#ifndef BSP_DB8379_H_
    #define BSP_DB8379_H_

#include "common_include.h"

typedef union {
uint16_t      LampData;
struct {
         unsigned int RELAY_F7          :  1 ; //D11
         unsigned int RELAY_F8          :  1 ; //D10
         unsigned int /*RELAY_IGN*/         :  1 ; //D9
         unsigned int RELAY_B_          :  1 ; //D8
         unsigned int RELAY_IGN           :  1 ; //D7
         unsigned int RELAY_B                  :  1 ; //D6
         unsigned int RELAY_F6          :  1 ; //D5
         unsigned int RELAY_F5          :  1 ; //D4
         unsigned int RELAY_F4          :  1 ; //D3
         unsigned int RELAY_F3          :  1 ; //D2
         unsigned int RELAY_F2          :  1 ; //D1
         unsigned int RELAY_F1          :  1 ; //D0  
         unsigned int                   :  4 ;
    }Lamps;
}LampStateStruct_L;
extern LampStateStruct_L LampState_L;

typedef union {
uint16_t      LampData;
struct {
         unsigned int FB_K3              :  1 ; //D11-> 14030_FB_K3 LED7 -> FB_K3
         unsigned int TripSW1_1         :  1 ; //D10 PADD_DN
         unsigned int TripSW1_2         :  1 ; //D9  SW1_MENU
         unsigned int TripSW1_3         :  1 ; //D8  SW1_UP
         unsigned int TripSW1_4         :  1 ; //D7  SW1_DOWN
         unsigned int TripSW1_5         :  1 ; //D6  SW1_OK
         unsigned int FB_K2              :  1 ; //D5 -> 14030_FB_K2 LED6 -> FB_K2
         unsigned int FB_K1              :  1 ; //D4 -> 14030_FB_K1 LED5 -> FB_K1
         unsigned int LED4              :  1 ; //D3
         unsigned int LED3              :  1 ; //D2
         unsigned int LED2              :  1 ; //D1
         unsigned int LED1              :  1 ; //D0   
         unsigned int                   :  4 ;
    }Lamps;
}LampStateStruct_M;
extern LampStateStruct_M LampState_M;




    #define  BD8379_CLK_HIGH                          Port_SetPortPinLevel(2,5,PortGpioHigh)
    #define  BD8379_CLK_LOW                           Port_SetPortPinLevel(2,5,PortGpioLow)
    #define  BD8379_LATCH_HIGH                        Port_SetPortPinLevel(2,8,PortGpioHigh)
    #define  BD8379_LATCH_LOW                         Port_SetPortPinLevel(2,8,PortGpioLow)
    #define  BD8379_OE_HIGH                           Port_SetPortPinLevel(2,4,PortGpioHigh)
    #define  BD8379_OE_LOW                            Port_SetPortPinLevel(2,4,PortGpioLow)
    #define  BD8379_RST_HIGH                          Port_SetPortPinLevel(2,7,PortGpioHigh)
    #define  BD8379_RST_LOW                           Port_SetPortPinLevel(2,7,PortGpioLow)
    #define  BD8379_SEROUT_HIGH                       Port_SetPortPinLevel(2,6,PortGpioHigh)
    #define  BD8379_SEROUT_LOW                        Port_SetPortPinLevel(2,6,PortGpioLow)

    #define  MC1413_BON                             LampState_L.Lamps.RELAY_B = 1 //Port_SetPortPinLevel(1, 20, PortGpioHigh) //30
    #define  MC1413_BOFF                            LampState_L.Lamps.RELAY_B = 0 //Port_SetPortPinLevel(1, 20, PortGpioLow) //30
    #define  MC1413_B_ON                            LampState_L.Lamps.RELAY_B_ = 1 //静�?30 B+~
    #define  MC1413_B_OFF                           LampState_L.Lamps.RELAY_B_ = 0 //静�?30 B+~
    #define  MC1413_IGNON                           LampState_L.Lamps.RELAY_IGN = 1//Port_SetPortPinLevel(1, 19, PortGpioHigh); //15 IGN
    #define  MC1413_IGNOFF                          LampState_L.Lamps.RELAY_IGN = 0//Port_SetPortPinLevel(1, 19, PortGpioLow); //15 IGN
//#define  High beamOFF                          LampState_L.Lamps.RELAY_IGN = 0  //远光灭
//#define  High beamON                          LampState_L.Lamps.RELAY_IGN = 1  //远光开

    extern      void        bsp_BD8379_Init(void);
    extern      void        bsp_BD8379_OFF(void);
    extern      void        bsp_BD8379_WriteData(uint16_t  dataL,uint16_t  dataM);
#endif /* BSP_DB8379_H_ */