
#ifndef _NM_INTERFACE_H_
#define _NM_INTERFACE_H_

    
    #define     NM_BUF_EMPTY                0
    #define     NM_BUF_FULL                 1

    #define     VoltUpLimit                 1810  //18.1V
    #define     VoltDownLimit               690   //6.9V

    typedef struct
    {
        uint16_t  AppTime;
        uint16_t  msgEvent;
        uint16_t  msgEventCnt;
        uint16_t  msgEventTime;
    }_AppMsgTime;


    #define MSG_0x1DF 0
    #define MSG_0x1D4 1
    #define MSG_0x1D5 2

    extern   volatile    uint16_t          NM_BatVolt;
    extern   volatile    uint8_t           NM_Volt_Abnormal;
    extern   volatile    _AppMsgTime       AppMsgTime[3];
    extern   volatile    uint8_t           AppMsgSendRequest;


    extern   void    NM_Time_2ms_Count(void);

    extern   void    NM_Send_PDU_Fun(void);         //Send PDU Message Interface Function
    extern   void    NM_Send_App_Fun(void);         //Send Application Message Interface Function
    
    extern   void    NM_CheckSleep_Fun(void);
    
    extern   void    NM_RemoteWakeup_Fun(void);
    extern   void    NM_LocalWakeup_Fun(void);
    
    extern   void    NM_tSleepRequTimeCount_Fun(void);
    extern   void    NM_Receive_isr_Fun(uint16_t id,uint8_t *pBuf);
    extern   void    NM_TranMsgErrorDetect(void);
    extern   void    NM_TranMsgSuccessDetect(void);
    extern   void    NM_CheckBatVolt(uint16_t adValue);
    extern   void    NM_SetIgnState(uint8_t IgnPosition);
    
#endif