/******************************************************************************
文 件 名：TFT_LCD.h
功能描述：TFT彩色液晶显示屏控制函数库头文件
作    者：张暄
版    本：V1.0
日    期：2017.4.8
******************************************************************************/

#ifndef _TFT_LCD_H_
#define _TFT_LCD_H_



/******************************************************************************
绘图请求FIFO深度设置

说明: 调用绘图函数后,绘图请求会首先存放于FIFO中,而后由后台绘图执行函数从FIFO中
      取出绘图请求并完成绘图工作.这种机制可以满足用户连续的绘图请求而不用担心绘
      图过程中的时延会影响整个系统工作.

      绘图请求FIFO的深度应根据程序中最大的突发性的连续绘图数量设置,并应预留出一
      定余量.过浅的FIFO设置将有可能导致突发性绘图中靠后的请求因FIFO已满而丢失,
      最终这些请求没有被响应;而过深的FIFO设置则会导致内存的浪费
******************************************************************************/
#define   TFT_LCD_REQ_FIFO_MAX_DEPTH        250

/******************************************************************************
绘图类型
******************************************************************************/
#define   TFT_LCD_TYPE_SET                  0x00
#define   TFT_LCD_TYPE_CLR                  0x01
#define   TFT_LCD_TYPE_INV                  0x02

/******************************************************************************
填充类型
******************************************************************************/
#define   TFT_LCD_FILL_NONE                 0x00
#define   TFT_LCD_FILL_FULL                 0x01

/******************************************************************************
绘图状态
******************************************************************************/
#define   TFT_LCD_STATE_IDLE                0x00
#define   TFT_LCD_STATE_INIT                0x01
#define   TFT_LCD_STATE_DRAW                0x02
#define   TFT_LCD_STATE_TOP                 0x03
#define   TFT_LCD_STATE_MID                 0x04
#define   TFT_LCD_STATE_BOT                 0x05
#define   TFT_LCD_STATE_LEFT                0x06
#define   TFT_LCD_STATE_RIGHT               0x07
#define   TFT_LCD_STATE_VERTEX              0x08

/******************************************************************************
绘图模式
******************************************************************************/
#define   TFT_LCD_MODE_IDLE                 0x00
#define   TFT_LCD_MODE_CLEAR                0x01
#define   TFT_LCD_MODE_DBMP                 0x02
#define   TFT_LCD_MODE_IBMP                 0x03
#define   TFT_LCD_MODE_DTBMP                0x04
#define   TFT_LCD_MODE_ITBMP                0x05
#define   TFT_LCD_MODE_PIXEL                0x06
#define   TFT_LCD_MODE_HLINE                0x07
#define   TFT_LCD_MODE_VLINE                0x08
#define   TFT_LCD_MODE_BBOX                 0x09
#define   TFT_LCD_MODE_DFBOX                0x0A
#define   TFT_LCD_MODE_IFBOX                0x0B
#define   TFT_LCD_MODE_NEAR                 0x0C

/******************************************************************************
屏幕分辨率
******************************************************************************/
#define   TFT_LCD_X_SIZE                    240
#define   TFT_LCD_Y_SIZE                    320

/******************************************************************************
绘图请求结构体
******************************************************************************/
typedef struct
{
    uint8_t   Mode;
    uint8_t   State;

    uint8_t   StartPage;
    uint8_t   StartCol;
    uint8_t   EndPage;
    uint8_t   EndCol;
    uint8_t   CurrentPage;
    uint8_t   CurrentCol;

    uint16_t  Width;
    uint16_t  Length;
    uint16_t  Offset;

    uint8_t   Type;
    uint8_t   BitShiftT;
    uint8_t   BitShiftB;
    uint8_t * pBmp ;
 } TFTLCDDrawingReqStruct;

/******************************************************************************
绘图请求FIFO结构体
******************************************************************************/
typedef struct
{
    TFTLCDDrawingReqStruct  Req[TFT_LCD_REQ_FIFO_MAX_DEPTH];
    uint8_t                 Iptr;
    uint8_t                 Optr;
    uint8_t                 Depth;
} TFTLCDDrawingFIFOStruct;



/******************************************************************************
显示更新控制结构
******************************************************************************/
typedef struct
{
  uint8_t   Brightness;
  uint8_t   Enable;
}TFTLCDUpdateCtrlStruct;



/******************************************************************************
绘图屏蔽位编码
******************************************************************************/
static const uint8_t TFTLCDBitMask[]  = {0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF};

/******************************************************************************
绘图位编码
******************************************************************************/
static const uint8_t TFTLCDBitTable[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};

/******************************************************************************
函数声明
******************************************************************************/
void TFT_LCD_Startup ( void );
void TFT_LCD_Shutdown ( void );
uint8_t TFT_LCD_Busy_Check ( void );
void TFT_LCD_Set_Brightness ( uint8_t Br );
void TFT_LCD_Display_Update_Service ( void );

void TFT_LCD_Cls ( void );

static uint8_t  TFT_LCD_Insert_Draw_Traffic_Bmp_Handler ( TFTLCDDrawingReqStruct *pReq );
void TFT_LCD_Draw_Traffic_Bmp ( uint16_t StartX, uint16_t StartY, uint8_t * pBmp );
static uint8_t TFT_LCD_Insert_Draw_Bmp_Handler ( TFTLCDDrawingReqStruct *pReq );

void TFT_LCD_Draw_Bmp ( uint16_t StartX, uint16_t StartY, uint8_t * pBmp );
void TFT_LCD_Draw_Transparent_Bmp ( uint16_t StartX, uint16_t StartY, uint8_t * pBmp, uint8_t Type );
void TFT_LCD_Draw_Pixel ( uint16_t PosX, uint16_t PosY, uint8_t Type );
void TFT_LCD_Draw_Horizontal_Line ( uint16_t StartX, uint16_t EndX, uint16_t PosY, uint8_t Type );
void TFT_LCD_Draw_Vertical_Line ( uint16_t PosX, uint16_t StartY, uint16_t EndY, uint8_t Type );
void TFT_LCD_Draw_Box ( uint16_t StartX, uint16_t StartY, uint16_t EndX, uint16_t EndY, uint8_t Fill, uint8_t Type );
void TFT_LCD_Draw_NEAR_Bmp ( uint16_t StartX, uint16_t StartY, uint8_t * pBmp );

static uint8_t TFT_LCD_Cls_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Direct_Draw_Bmp_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Insert_Draw_Bmp_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Direct_Draw_Transparent_Bmp_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Insert_Draw_Transparent_Bmp_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Draw_Pixel_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Draw_Horizontal_Line_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Draw_Vertical_Line_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Draw_Box_Border_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Direct_Draw_Full_Box_Handler ( TFTLCDDrawingReqStruct *pReq );
static uint8_t TFT_LCD_Insert_Draw_Full_Box_Handler ( TFTLCDDrawingReqStruct *pReq );

#endif
