
#include "stdlib.h"
#include "rh850_macros.h"

void RH850_Software_Reset(void)
{
}

void RH850_Hardware_Reset(void)
{
    protected_write(WPROTRPROTCMD0, WPROTRPROTS0, RESCTLSWRESA, 0x00000001UL);
    while ( 1U )
    {
        /*  Wait for MCU to be reset by WDT in case of reset failure */
    }
}

void RH850_Peripheral_IRQ_Enable(volatile uint16_t *pInt)
{
    uint16_t u16RegVal;

    if ( pInt != NULL )
    {
        u16RegVal = *pInt;
        if ( u16RegVal & 0x0080U )
        {
            u16RegVal |= 0x0040U;
            u16RegVal &= 0xEF7FU;

            *pInt = u16RegVal;
        }
    }
}

void RH850_Peripheral_IRQ_Disable(volatile uint16_t *pInt)
{
    uint16_t u16RegVal;

    if ( pInt != NULL )
    {
        u16RegVal = *pInt;
        if ( (u16RegVal & 0x0080U) == 0x0000U )
        {
            u16RegVal &= 0xEFFFU;
            u16RegVal |= 0x0080U;

            *pInt = u16RegVal;
        }
    }
}

void RH850_Peripheral_IRQ_Flag_Clear(volatile uint16_t *pInt)
{
    uint16_t u16RegVal;

    if ( pInt != NULL )
    {
        u16RegVal = *pInt;
        u16RegVal &= 0xEFFFU;
        *pInt = u16RegVal;
    }
}

void RH850_Enter_Idle_Mode(void)
{
}

void RH850_Enter_Stop_Mode(void)
{
    protected_write(WPROTRPROTCMD0, WPROTRPROTS0, STBC0PSC, 0x02U); /* Enter DeepSTOP */
    while ( 1U )
    {
    }
}
/*
返回值：
1：wakeup
other： KL30
*/
uint8_t RH850_Get_startup_mode(void)
{
    uint8_t  u8startmode   = 0U;
    uint32_t u32ResetValue = 0UL;

    u32ResetValue = RESCTLRESF;
    RESCTLRESFC   = 0x47FFUL;

    if ( u32ResetValue & 0X400UL )
    {
        u8startmode = 1U;
    }
    else if ( u32ResetValue & 0X200UL )
    {
        u8startmode = 0U;
    }
    else
    {
        u8startmode = 2U;
    }

    return u8startmode;
}
