
#ifndef TIMER_B_HEADER__
#define TIMER_B_HEADER__

#include "r_typedefs.h"
/*-----------------use for RH850_F1KM_S1 --------------------*/
/*-----------------PWM输出引脚和频率捕获输入引脚都需要放在timerB的奇数通道上--------------------*/

typedef enum
{
	TIMERB_HIGH = 0U,
	TIMERB_LOW,
} TIMERB_Polarity_en_t;

typedef enum
{
	TIMERB_FALL = 0U,
	TIMERB_RISING,
	TIMERB_RISING_FALL,
} TIMERB_Edge_en_t;

typedef enum
{
	TIMERB_CLOCK_0 = 0U,
	TIMERB_CLOCK_1,
	TIMERB_CLOCK_2,
	TIMERB_CLOCK_3,
} TIMERB_Clock_en_t;
typedef enum
{
	TIMERB_0_CH0 = 0U,
	TIMERB_0_CH1,
	TIMERB_0_CH2,
	TIMERB_0_CH3,
	TIMERB_0_CH4,
	TIMERB_0_CH5,
	TIMERB_0_CH6,
	TIMERB_0_CH7,
	TIMERB_0_CH8,
	TIMERB_0_CH9,
	TIMERB_0_CH10,
	TIMERB_0_CH11,
	TIMERB_0_CH12,
	TIMERB_0_CH13,
	TIMERB_0_CH14,
	TIMERB_0_CH15,

} TIMERB_Channel_en_t;

/*-------------------PWM相关-------------------------------------*/
extern void TimerB_PWM_Init(void);
extern uint8_t TimerB_PWM_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity);
extern uint32_t TimerB_PWM_Channel_Fre_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Fre, uint16_t u16Duty);
/*占空比精度千分之一*/
extern void TimerB_PWM_Channel_Duty_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Duty);
extern void TimerB_PWM_Channel_Start(TIMERB_Channel_en_t enTimerBChannel);
/*调用该函数后，仅重新调用开始函数功能即可正常使用*/
extern void TimerB_PWM_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel);
/*仅休眠时可调用，调用该函数后需要重新初始化相关通道才可以正常使用。*/
extern void TimerB_PWM_Channel_Sleep(TIMERB_Channel_en_t enTimerBChannel);

/*--------------------捕获相关--------------------------------------*/
extern void TimerB_Overflow_Isr(void);
extern void TimerB_Input_Isr(TIMERB_Channel_en_t enTimerBChannel);
extern void TimerB_Input_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel);
extern void TimerB_Input_Channel_Start(TIMERB_Channel_en_t enTimerBChannel);
extern void TimerB_Input_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Edge_en_t enTimerBEdge);
/*----------------------------------------------------------*/

#endif
