

#ifdef        GLOBALS_APP_TEST
    #define   EXTERN_APP_TEST
    
#else
    #define   EXTERN_APP_TEST     extern
#endif

#ifndef APP_TEDT_H_
#define APP_TEDT_H_

#define Motorola                0
#define Intel                   1

#define Offset_Minus            0
#define Offset_Plus             1

#define Value_Minus             0
#define Value_Plus              1

typedef struct{
    unsigned int val;
    unsigned char fval;
}s_CurValue;

typedef struct{
    CAN_message *canMsg;
    unsigned char StartByte;    //起始字节
    unsigned char StartBit;     //起始位
    unsigned char SignalLen;    //信号长度
    unsigned int  Offset;       //偏移量
    unsigned char fOffset;      //偏移量标志位
    unsigned int Factor_1;      //缩放因子1
    unsigned int Factor_2;      //缩放因子2
    s_CurValue *CurValue;       //当前值指针
    unsigned char fFormat;      //信号格式 Motorola or Intel

}s_CAN_List;

enum
{
    VELVEIC_ABS_F          = 0,//����
    VELVEIC_ABS_R,
    TH2OC,
    MIL_Lamp,
    ABS_warning_lamp,
    OIL_TALE_STOP,
    CENACC,
    ASR_indicator,
    AB_SET,
    Telephone_lcon,
    Device_connected,
    App_lcon_status,
    Lost_call_icon,
    Notincaton_lcon,
    CSTAMPLAT,
    GSM,
    Smartphone_battery,
    Music_ico,
    HHGLevel,
    Meter_field_begin,
    Meter_field_setdata_bit1,
    Meter_field_setdata_bit2,
    Meter_field_setdata_bit3,
    Meter_field_setdata_bit4,
    Meter_field_setdata_bit5,
    Meter_field_setdata_bit6,
    Meter_field_setdata_bit7,
    Meter_field_setdata_bit8,
    // Sync_clock_Minutes,
    // Sync_Request,
    // Sync_clock_Hours,


    CAN_List_Num        ,
#if 0
    ENUM_VSpeed          = 0,//����
    ENUM_RSpeed          ,//�??�??
    ENUM_WaterTemp       ,//   温度
    TCS_Warning_Lamp   ,//前轮胎压
    TCS_Work_Mode   ,//后轮胎压
    ISG_Ready,
    ISG_Power,
    ISG_Power_Enable,
    
    ABS_Warning_Lamp,
    ECU_Warning_Lamp,

    MBMS_TOTALSigCharg,     //充电指示灯    18202922
    MBMS_TOTALSigAcc,

    MMCU_PowerMode,             //125
    MMCU_TravelSpeedGear,
    MMCU_SeatDetectState,
    MMCU_ParkingGearState,

    BMCU_PTOSwicthState,
    BMCU_BladeSpeedGear,

    MBMS_Soc1,
    MBMS_Soc2,

    MBMS_StatSoc,

    BMCU_Moto1_Locked_RotorFault,

    CAN_List_Num        ,
#endif
};
                                                                                    
EXTERN_APP_TEST volatile s_CurValue CurValueStr[CAN_List_Num];

static const s_CAN_List CAN_List[] = 
{
    {&CanMsg_260,      1,  0,  16,   0,   Offset_Plus,   100,         1, &CurValueStr[VELVEIC_ABS_F           ], Motorola},
    {&CanMsg_260,      3,  0,  16,   0,   Offset_Plus,   100,         1, &CurValueStr[VELVEIC_ABS_R           ], Motorola},
    {&CanMsg_180,      2,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[TH2OC                   ], Motorola},
    {&CanMsg_100,      5,  2,  2,    0,   Offset_Plus,    1,          1, &CurValueStr[MIL_Lamp                ], Motorola},
    {&CanMsg_153,      0,  0,  2,    0,   Offset_Plus,    1,          1, &CurValueStr[ABS_warning_lamp        ], Motorola},
    {&CanMsg_100,      5,  0,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[OIL_TALE_STOP           ], Motorola},
    {&CanMsg_120,      4,  6,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[CENACC                  ], Motorola},
    {&CanMsg_200,      4,  6,  2,    0,   Offset_Plus,    1,          1, &CurValueStr[ASR_indicator           ], Motorola},
    {&CanMsg_200,      2,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[AB_SET                  ], Motorola},
    {&CanMsg_687,      1,  4,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[Telephone_lcon          ], Motorola},
    {&CanMsg_687,      1,  1,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[Device_connected        ], Motorola},
    {&CanMsg_687,      1,  2,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[App_lcon_status         ], Motorola},
    {&CanMsg_687,      1,  6,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[Lost_call_icon          ], Motorola},
    {&CanMsg_687,      1,  5,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[Notincaton_lcon         ], Motorola},
    {&CanMsg_100,      5,  7,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[CSTAMPLAT               ], Motorola},
    {&CanMsg_687,      0,  0,  3,    0,   Offset_Plus,    1,          1, &CurValueStr[GSM                     ], Motorola},
    {&CanMsg_687,      0,  3,  4,    0,   Offset_Plus,    1,          1, &CurValueStr[Smartphone_battery      ], Motorola},
    {&CanMsg_687,      1,  7,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[Music_ico               ], Motorola},
    {&CanMsg_687,      3,  1,  4,    0,   Offset_Plus,    1,          1, &CurValueStr[HHGLevel                ], Motorola},
    {&CanMsg_6A0,      0,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_begin       ], Motorola},
    {&CanMsg_6A2,      0,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_setdata_bit1], Motorola},
    {&CanMsg_6A2,      1,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_setdata_bit2], Motorola},
    {&CanMsg_6A2,      2,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_setdata_bit3], Motorola},
    {&CanMsg_6A2,      3,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_setdata_bit4], Motorola},
    {&CanMsg_6A2,      4,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_setdata_bit5], Motorola},
    {&CanMsg_6A2,      5,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_setdata_bit6], Motorola},
    {&CanMsg_6A2,      6,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_setdata_bit7], Motorola},
    {&CanMsg_6A2,      7,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Meter_field_setdata_bit8], Motorola},

    // {&CanMsg_600,      3,  1,  7,    0,   Offset_Plus,    1,          1, &CurValueStr[Sync_clock_Minutes ], Motorola},
    // {&CanMsg_600,      3,  0,  1,    0,   Offset_Plus,    1,          1, &CurValueStr[Sync_Request       ], Motorola},
    // {&CanMsg_600,      4,  0,  8,    0,   Offset_Plus,    1,          1, &CurValueStr[Sync_clock_Hours   ], Motorola},

    #if 0
    {&CanMsg_101, 2,  0,  8,    0,   Offset_Plus,    1,       1, &CurValueStr[ENUM_VSpeed         ], Motorola},
    {&CanMsg_101, 1,  0, 16,    0,   Offset_Plus,    100,    25, &CurValueStr[ENUM_RSpeed         ], Motorola},
    {&CanMsg_101, 5,  0, 16,  273,   Offset_Minus,    10,     1, &CurValueStr[ENUM_WaterTemp      ], Motorola},

    {&CanMsg_37B, 3,  2,  1,    0,   Offset_Plus,     1,    1, &CurValueStr[TCS_Warning_Lamp ], Motorola},
    {&CanMsg_37B, 3,  4,  4,    0,   Offset_Plus,     1,    1, &CurValueStr[TCS_Work_Mode  ], Motorola},

    {&CanMsg_111, 4,  1, 1,    0,   Offset_Plus,    1,    1, &CurValueStr[ISG_Ready         ], Motorola},
    {&CanMsg_111, 4,  2, 1,    0,   Offset_Plus,    1,    1, &CurValueStr[ISG_Power         ], Motorola},
    {&CanMsg_111, 4,  4, 2,      0,   Offset_Plus,    1,     1, &CurValueStr[ISG_Power_Enable      ], Motorola},

    {&CanMsg_12B, 4,  2, 2,      0,   Offset_Plus,    1,     1, &CurValueStr[ABS_Warning_Lamp      ], Motorola},

    {&CanMsg_402, 7,  7, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[ECU_Warning_Lamp      ], Motorola},

    {&CanMsg_18202922, 0,  0, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_TOTALSigCharg      ], Motorola},
    {&CanMsg_18202922, 0,  1, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_TOTALSigAcc      ], Motorola},


    {&CanMsg_125, 0,  2, 4,      0,   Offset_Plus,    1,     1, &CurValueStr[MMCU_PowerMode      ], Motorola},
    {&CanMsg_125, 1,  0, 2,      0,   Offset_Plus,    1,     1, &CurValueStr[MMCU_TravelSpeedGear      ], Motorola},
    {&CanMsg_125, 2,  1, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[MMCU_SeatDetectState      ], Motorola},
    {&CanMsg_125, 2,  7, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[MMCU_ParkingGearState      ], Motorola},

    {&CanMsg_157, 0,  3, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[BMCU_PTOSwicthState      ], Motorola},
    {&CanMsg_157, 0,  4, 3,      0,   Offset_Plus,    1,     1, &CurValueStr[BMCU_BladeSpeedGear      ], Motorola},

    {&CanMsg_SOC1, 4,  0, 8,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_Soc1      ], Motorola},
    {&CanMsg_SOC2, 4,  0, 8,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_Soc2      ], Motorola},

    {&CanMsg_SOC, 4,  0, 8,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_StatSoc      ], Motorola},

    {&CanMsg_38E, 1,  0, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[BMCU_Moto1_Locked_RotorFault      ], Motorola},
    #endif

};



extern unsigned int lost_flag;
extern unsigned int CAN_init_flag;
extern unsigned int water_value;
extern unsigned int count_flag_a;
extern unsigned int speed_value;
extern unsigned int Meterfieldstep;
EXTERN_APP_TEST             void                APP_Button_Proc(void);
EXTERN_APP_TEST             void                Message_Value_Calculate(s_CAN_List list);

void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value);  /*Do not span bytes*/



#endif /* API_CAN_H_ */
