#define GLOBALS_API_TPM
#include "../App_Headers/includes.h"


/*-------------------------------------------------------------------------
* Function Name  : Api_Timer0_Init
* Description    : ʱ0ʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_Timer0_Init(INT8U TPM_DIV)
{
    
    TIM0_TSCR1_TSWAI = Enable;   //timer 0 MCUȴģʽ²
    TIM0_TSCR1_TSWAI = WaitRun;
    TIM0_TSCR1_TSFRZ = Enable;   //timer 0 ڶģʽ½ֹ
    TIM0_TSCR1_TFFCA = Disable;  //־λ
    TIM0_TSCR1_PRNT  = Disable;  // 
    TIM0_TSCR2_PR    = TPM_DIV;  //Bus Clock / 4
    TIM0_TSCR2_TCRE  = Disable;
    TIM0_TTOV        = Disable;

    TIM0_TCTL1 = Disable;        //ֹȽϹ
    TIM0_TCTL2 = Disable;
    TIM0_TCTL3 = Disable;        //ֹȽϹ
    TIM0_TCTL4 = Disable; 
        
    TIM0_TFLG2_TOF   = Enable;
    TIM0_TSCR1_TEN   = Enable;   //ʹtimer 0 
    TIM0_TSCR2_TOI   = Enable;   //жʹ
    
}
/*-------------------------------------------------------------------------
* Function Name  : Api_Timer1_Init
* Description    : ʱ1ʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_Timer1_Init(INT8U TPM_DIV)
{

    TIM1_TSCR1_TSWAI = Enable;   //timer 0 MCUȴģʽ²
    TIM1_TSCR1_TSFRZ = Enable;   //timer 0 ڶģʽ½ֹ
    TIM1_TSCR1_TFFCA = Disable;  //־λ
    TIM1_TSCR1_PRNT  = Disable;  // 
    TIM1_TSCR2_PR    = TPM_DIV; //Bus Clock / 4
    TIM1_TSCR2_TCRE  = Disable;
    TIM1_TTOV        = Disable;

    TIM1_TCTL1 = Disable;        //ֹȽϹ
    TIM1_TCTL2 = Disable;
    TIM1_TCTL3 = Disable;        //ֹȽϹ
    TIM1_TCTL4 = Disable; 
    
    TIM1_TFLG2_TOF   = Enable;
    TIM1_TSCR1_TEN   = Enable;   //ʹtimer 0 
    TIM1_TSCR2_TOI   = Enable;   //жʹ
    

}

//-----------------------------------------------------------------------------
//    :    Api_Motor_Init
//    :    ʼ
//        :    
//                 *Motor    ->   ṹָ
//        :    
// ֵ     :    ״̬
//        :    
//-----------------------------------------------------------------------------
void  Api_Motor_Init(void)
{
    INT16U         *w;
    INT8U          Nub;

    MCCTL0_MCPRE        = 0;            //ʱΪߵ8Ƶ
    MCCTL0_MCSWAI       = Enable;          //ֹͣģʽֹͣ 
    MCCTL0_FAST         = Disable;         //11bitֱ
    MCCTL0_DITH         = Disable;         //PER-> P10-P0   0:P0
    MCCTL0_MCTOIF       = ClearFlag;       //жϱ־
    MCCTL1_RECIRC       = True;            //
    MCCTL1_MCTOIE       = Enable;          //ʹж
    MCPER               = 1454;       //PWM   жƵ 22000
    //
    MCCC0_MCOM          = clear;            //˫ȫHģʽ
    MCCC0_MCAM          = clear;         //
    MCCC0_CD            = clear;         //ֹʱ
    MCCC1_MCOM          = clear;            //ȫHģʽ
    MCCC1_MCAM          = clear;         //
    MCCC1_CD            = clear;         //ֹʱ
    //
    MCCC2_MCOM          = clear;            //˫ȫHģʽ
    MCCC2_MCAM          = clear;         //
    MCCC2_CD            = clear;         //ֹʱ
    MCCC3_MCOM          = clear;            //ȫHģʽ
    MCCC3_MCAM          = clear;         //
    MCCC3_CD            = clear;         //ֹʱ

    
    MCCC4_MCOM          = clear;         
    MCCC4_MCAM          = clear;         
    MCCC4_CD            = clear;         
    MCCC5_MCOM          = clear;         
    MCCC5_MCAM          = clear;       
    MCCC5_CD            = clear;       
    
    
    MCCC6_MCOM          = clear;            //˫ȫHģʽ
    MCCC6_MCAM          = clear;         //
    MCCC6_CD            = clear;         //ֹʱ
    MCCC7_MCOM          = clear;            //ȫHģʽ
    MCCC7_MCAM          = clear;         //
    MCCC7_CD            = clear;         //ֹʱ
    
    w = &MCDC0;                            //ʼMCOC 0-7
         
    for(Nub = 0;Nub < 8 ;Nub++)
    {
         *(w + Nub) = 0;         
    }
}
//-----------------------------------------------------------------------------
//    :    Api_Motor_isr
//    :    PWMж
//        :    
//        :    
// ֵ     :    
//        :    
//-----------------------------------------------------------------------------
interrupt void Api_Motor_isr(void)
{


    MCCTL0_MCTOIF       = ClearFlag;       //жϱ־
}
/*-------------------------------------------------------------------------
* Function Name  : Api_Timer0_isr
* Description    : ʱж
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_Timer0_isr(void)
{
    if((CANRFLG_RSTAT == 0x03)||(CANRFLG_TSTAT == 0x03))
    {
        if(BusOffTime == null) 
        {                       
            BusOffTime = TT_200ms;
            CANMISC_BOHOLD = ClearFlag;                                                 
        }  
        if(BusOffTime > null)
        {
             BusOffTime--;                 
        }         
    }    
    TIM0_TFLG2_TOF = ClearFlag;  //жϱ־λ
}
/*-------------------------------------------------------------------------
* Function Name  : API_Timer1_isr
* Description    : ʱж
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void API_Timer1_isr(void)
{
  
    TIM1_TFLG2_TOF = ClearFlag;  //жϱ־λ
}
