

#ifdef        GLOBALS_APP_TEST
    #define   EXTERN_APP_TEST
    
#else
    #define   EXTERN_APP_TEST     extern
#endif

#ifndef APP_TEDT_H_
#define APP_TEDT_H_

#define Motorola                0
#define Intel                   1

#define Offset_Minus            0
#define Offset_Plus             1

#define Value_Minus             0
#define Value_Plus              1

typedef struct{
    unsigned int val;
    unsigned char fval;
}s_CurValue;

typedef struct{
    CAN_message *canMsg;                
    unsigned char StartByte;                
    unsigned char StartBit;              
    unsigned char SignalLen;                
    unsigned int  Offset;               
    unsigned char fOffset;           
    unsigned int Factor_1;
    unsigned int Factor_2;
    s_CurValue *CurValue;                 
    unsigned char fFormat;                
}s_CAN_List;

enum
{
    ABS_VehicleSpeed  = 0,
    ABS_Warning_Lamp,
    BCM_PositionLightIndication,
    BCM_TurnLeftandRightIndication,
    BCM_TurnRightIndication,
    BCM_TurnLeftIndication,
    BCM_LowBeamIndication,
    BCM_HighBeamIndication,
    TCS_WarningLamp,
    TCS_WorkSt,
    TCS_Control,
    MCU_GearPosition,
    MCU_ReadyStatus,
    MCU_CruiseSwitchActive,
    MCU_LimpingMode,
    MCU_EnergyRecIntensitySet,
    MCU_OperationMode,
    MCU_MotorTemperature,
    MCU_AutoHoldSta,
    MCU_ControllerWorkingState,
    MCU_CruiseState,
    MCU_MotorSpeed,
    BCM_PowerOnStatus,
    BMS1_SOH,
    BMS1_PACKTotalSOC,
    BMS1_PACKTotalCurrent,
    BMS1_PACKInTotalVoltage,
    MCU_HighestFaultPrompt,
    ICU_RemainrvMile,
    ICU_Speed,
    BMS2_SOH,
    BMS2_PACKTotalSOC,
    BMS2_PACKTotalCurrent,
    BMS2_PACKInTotalVoltage,
    BMS1_HighestFaultPrompt,
    BMS2_HighestFaultPrompt,
    BMS_ChargerConnectSignal,
    BCM_RTCDate_Valid,
    BCM_RTCDate_Second,
    BCM_RTCDate_Minute,
    BCM_RTCDate_Hour,
    BCM_RTCDate_Day,
    BCM_RTCDate_Month,
    BCM_RTCDate_Year,
    BCM_MetricMilesSwitchSet,
    
    CAN_List_Num,

};                         
EXTERN_APP_TEST volatile s_CurValue CurValueStr[CAN_List_Num];

static const s_CAN_List CAN_List[] = 
{
     
    {&CanMsg_0xC2, 1,   2,  14,      0,   Offset_Plus,    128,     1, &CurValueStr[ ABS_VehicleSpeed ], Motorola},
    {&CanMsg_0xC2, 1,   0,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ ABS_Warning_Lamp ], Motorola},

    {&CanMsg_0xC3, 0,   5,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_PositionLightIndication], Motorola},
    {&CanMsg_0xC3, 0,   4,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_TurnLeftandRightIndication], Motorola},
    {&CanMsg_0xC3, 0,   3,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_TurnRightIndication], Motorola},
    {&CanMsg_0xC3, 0,   2,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_TurnLeftIndication], Motorola},
    {&CanMsg_0xC3, 0,   1,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_LowBeamIndication], Motorola},
    {&CanMsg_0xC3, 0,   0,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_HighBeamIndication], Motorola},

    {&CanMsg_0xC1, 5,   3,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ TCS_WarningLamp ], Motorola},
    {&CanMsg_0xC1, 5,   1,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ TCS_WorkSt ], Motorola},
    {&CanMsg_0xC1, 5,   0,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ TCS_Control ], Motorola},
    
    {&CanMsg_0x81, 0,   5,   3,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_GearPosition ], Motorola},
    {&CanMsg_0x81, 0,   0,   2,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_ReadyStatus ], Motorola},
    {&CanMsg_0x81, 1,   1,   2,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_CruiseSwitchActive ], Motorola},

    {&CanMsg_0x82, 0,   7,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_LimpingMode ], Motorola},
    {&CanMsg_0x82, 0,   2,   2,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_EnergyRecIntensitySet ], Motorola},
    {&CanMsg_0x82, 0,   0,   2,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_OperationMode ], Motorola},

    {&CanMsg_0xB2, 7,   0,   8,     40,   Offset_Minus,   1,       1, &CurValueStr[ MCU_MotorTemperature ], Motorola},
    {&CanMsg_0xB2, 1,   4,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_AutoHoldSta ], Motorola},
    {&CanMsg_0xB2, 1,   0,   2,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_ControllerWorkingState ], Motorola},

    {&CanMsg_0xB3, 6,   3,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_CruiseState ], Motorola},
    {&CanMsg_0xB3, 1,   0,  16,  10000,   Offset_Minus,   1,       1, &CurValueStr[ MCU_MotorSpeed ], Motorola},

    {&CanMsg_0x122, 0,  0,   3,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_PowerOnStatus ], Motorola},

    {&CanMsg_0x212, 7,  0,   8,      0,   Offset_Plus,    1,       1, &CurValueStr[ BMS1_SOH ], Motorola},
    {&CanMsg_0x212, 4,  0,   8,      0,   Offset_Plus,    1,       1, &CurValueStr[ BMS1_PACKTotalSOC ], Motorola},
    {&CanMsg_0x212, 3,  0,  16,   3000,   Offset_Minus,   10,      1, &CurValueStr[ BMS1_PACKTotalCurrent ], Motorola},
    {&CanMsg_0x212, 1,  0,  16,      0,   Offset_Plus,    10,      1, &CurValueStr[ BMS1_PACKInTotalVoltage ], Motorola},

    {&CanMsg_0x217, 7,  6,   2,      0,   Offset_Plus,    1,       1, &CurValueStr[ MCU_HighestFaultPrompt ], Motorola},

    {&CanMsg_0x218, 6,  0,  10,      0,   Offset_Plus,    1,       1, &CurValueStr[ ICU_RemainrvMile ], Motorola},
    {&CanMsg_0x218, 0,  0,   8,      0,   Offset_Plus,    1,       1, &CurValueStr[ ICU_Speed ], Motorola},
 
    {&CanMsg_0x221, 7,  0,   8,      0,   Offset_Plus,    1,       1, &CurValueStr[ BMS2_SOH ], Motorola},
    {&CanMsg_0x221, 4,  0,   8,      0,   Offset_Plus,    1,       1, &CurValueStr[ BMS2_PACKTotalSOC ], Motorola},
    {&CanMsg_0x221, 3,  0,  16,   3000,   Offset_Minus,   1,       10, &CurValueStr[ BMS2_PACKTotalCurrent ], Motorola},
    {&CanMsg_0x221, 1,  0,  16,      0,   Offset_Plus,    1,       10, &CurValueStr[ BMS2_PACKInTotalVoltage ], Motorola},

    {&CanMsg_0x310, 7,  6,   2,      0,   Offset_Plus,    1,       1, &CurValueStr[ BMS1_HighestFaultPrompt ], Motorola},

    {&CanMsg_0x312, 7,  6,   2,      0,   Offset_Plus,    1,       1, &CurValueStr[ BMS2_HighestFaultPrompt ], Motorola},

    {&CanMsg_0x321, 0,  3,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BMS_ChargerConnectSignal ], Motorola},

    {&CanMsg_0x353, 5,  6,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_RTCDate_Valid ], Motorola},
    {&CanMsg_0x353, 5,  0,   6,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_RTCDate_Second ], Motorola},
    {&CanMsg_0x353, 4,  0,   6,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_RTCDate_Minute ], Motorola},
    {&CanMsg_0x353, 3,  0,   5,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_RTCDate_Hour ], Motorola},
    {&CanMsg_0x353, 2,  0,   5,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_RTCDate_Day ], Motorola},
    {&CanMsg_0x353, 1,  0,   4,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_RTCDate_Month ], Motorola},
    {&CanMsg_0x353, 0,  0,   5,   2015,   Offset_Plus,    1,       1, &CurValueStr[ BCM_RTCDate_Year ], Motorola},
 
    {&CanMsg_0x21F, 2,  6,   1,      0,   Offset_Plus,    1,       1, &CurValueStr[ BCM_MetricMilesSwitchSet ], Motorola},

};

extern unsigned int switchon;
extern unsigned int miletime;
extern unsigned int lost_flag;
extern unsigned int mileflag;
extern unsigned int CAN_init_flag;
extern unsigned int water_value;
extern unsigned int count_flag_a;
extern unsigned int speed_value;
extern unsigned int canfinish;
extern unsigned int canover;
EXTERN_APP_TEST             void                APP_Button_Proc(void);
EXTERN_APP_TEST             void                Message_Value_Calculate(s_CAN_List list);

void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value);  /*Do not span bytes*/



#endif /* API_CAN_H_ */
