/*
 * APP_Data_Process.c
 *
 *  Created on: 2012-6-17
 *      Author: qitiancun
 */
#define GLOBALS_APP_PROCESS
#include "../App_Headers/includes.h"



/*-------------------------------------------------------------------------
* Function Name  : App_State_Init
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void App_State_Init(void)
{
    
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_Data
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void App_Load_Data(void)
{
    App_Read_EE_Memory(DFLASH_RADIO_ADDR- DFLASH_PROGRAM_OFFSET,(INT8U *)&Radio,8);
    check = App_CreateCheckSun((INT8U*)&Radio.VehRadio,Radio.bFlag,6);
    
    if((Radio.bFlag != 0x55)||(check != Radio.bCheckSun))
    { 
        Radio.RevRadio = 40; 
        Radio.VehRadio = 568;
        Radio.VehNum = 4;
    } 
}

/*-------------------------------------------------------------------------
* Function Name  : App_SCI_Proc
* Description    : ݴ
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
INT8U App_CreateCheckSun(INT8U *pData,INT8U checkbyte,INT8U len)
{
  	INT8U Check=0,i;
  	Check = 0xff ^ checkbyte;
  	for(i=0;i<len;i++)
  	{
  		Check = Check ^ pData[i];
  	}
  	return Check;
}
INT8U key_1[4];
INT8U key_2[4];
INT8U key_3[8];
INT8U key_4 = 0;
void App_Uds_Calc_Key(INT8U seed[4])
{
    INT8U Xor[4] = {0x56,0x45,0x73,0x54};
    INT8U Cal[4];
    
    Cal[0] = seed[0] ^ Xor[0];
    Cal[1] = seed[1] ^ Xor[1];
    Cal[2] = seed[2] ^ Xor[2];
    Cal[3] = seed[3] ^ Xor[3];
    
    key_1[0] = ((Cal[0] & 0x0f) << 4) | (Cal[1] & 0xf0);
    key_1[1] = ((Cal[1] & 0x0f) << 4) | ((Cal[2] & 0xf0)>>4);
    key_1[2] = (Cal[2] & 0xf0) | ((Cal[3] & 0xf0) >>4);
    key_1[3] = ((Cal[3] & 0x0f) << 4) | (Cal[0] & 0x0f);
}

void UDS_Receive_Main(unsigned char *buf)
{

    switch(EOLStep)
    {
       case 0:
        {
            if((buf[1] == 0x50) && (buf[2] == 0x03))
            {
                EOLStep = 2;
                CurValueStr[UDS0                  ].val = 0x02;//չģʽ
                CurValueStr[UDS1                  ].val = 0x27;
                CurValueStr[UDS2                  ].val = 0x01;
                CurValueStr[UDS3                  ].val = 0x55;
                CurValueStr[UDS4                  ].val = 0x55;
                CurValueStr[UDS5                  ].val = 0x55;
                CurValueStr[UDS6                  ].val = 0x55;
                CurValueStr[UDS7                  ].val = 0x55;
                
                EOLError = 0;
            }
            else
            {
                // EOLStep = 0;
                // EOLError = 0;
            }
        }
        break; 

        case 1:
        {

            EOLStep = 2;
            EOLError = 0;            
        }
        break;

        case 2://ܲԿ
        {
            if((buf[1] == 0x67) && (buf[2] == 0x01))
            {
                key_2[0] = buf[3];
                key_2[1] = buf[4];
                key_2[2] = buf[5];
                key_2[3] = buf[6];
                App_Uds_Calc_Key(key_2);
                CurValueStr[UDS0                  ].val = 0x06;//
                CurValueStr[UDS1                  ].val = 0x27;
                CurValueStr[UDS2                  ].val = 0x02;
                CurValueStr[UDS3                  ].val = key_1[0];
                CurValueStr[UDS4                  ].val = key_1[1];
                CurValueStr[UDS5                  ].val = key_1[2];
                CurValueStr[UDS6                  ].val = key_1[3];
                CurValueStr[UDS7                  ].val = 0x55; 
                EOLStep = 3;
                EOLError = 0;      
            }
            else
            {
                EOLError++;
            } 
        }
        break;

        case 3:
        {
            if((buf[1] == 0x67) && (buf[2] == 0x02))//ȡ
            {
                CurValueStr[UDS0                  ].val = 0x03;
                CurValueStr[UDS1                  ].val = 0x22;
                CurValueStr[UDS2                  ].val = 0xf0;
                CurValueStr[UDS3                  ].val = 0x10;
                CurValueStr[UDS4                  ].val = 0x55;
                CurValueStr[UDS5                  ].val = 0x55;
                CurValueStr[UDS6                  ].val = 0x55;
                CurValueStr[UDS7                  ].val = 0x55;
                EOLStep = 4;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;

        case 4:
        {
            if((buf[1] == 0x0b) && (buf[2] == 0x62) && (buf[3] == 0xf0))//ȡǰ3λ
            {
                key_3[0] = buf[5];
                key_3[1] = buf[6];
                key_3[2] = buf[7];
                
                CurValueStr[UDS0                  ].val = 0x30;//
                CurValueStr[UDS1                  ].val = 0x00;
                CurValueStr[UDS2                  ].val = 0x32;
                CurValueStr[UDS3                  ].val = 0xf1;
                CurValueStr[UDS4                  ].val = 0x40;
                CurValueStr[UDS5                  ].val = 0x55;
                CurValueStr[UDS6                  ].val = 0x55;
                CurValueStr[UDS7                  ].val = 0x55;
                EOLStep = 5;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;

        case 5://ȡ5λ
        {
            if((buf[0] == 0x21)&&(buf[1] == 0x84))
            {
                key_3[3] = buf[1];
                key_3[4] = buf[2];
                key_3[5] = buf[3];     
                key_3[6] = buf[4];  
                key_3[7] = buf[5];
                
                CurValueStr[UDS0                  ].val = 0x10;//дǰλ
                CurValueStr[UDS1                  ].val = 0x0b;
                CurValueStr[UDS2                  ].val = 0x2e;
                CurValueStr[UDS3                  ].val = 0xf0;
                CurValueStr[UDS4                  ].val = 0x10;
                CurValueStr[UDS5                  ].val = 0x28;
                CurValueStr[UDS6                  ].val = 0xc0;
                CurValueStr[UDS7                  ].val = 0x80;
                EOLStep = 6;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        case 6:
        {
            if((buf[0] == 0x30)&&(buf[1] == 0x0f))//
            {
                if(key_3[6]&0x04)//״Ϊ
                {
                CurValueStr[UDS0                  ].val = 0x21;
                CurValueStr[UDS1                  ].val = 0x84;
                CurValueStr[UDS2                  ].val = 0xcc;
                CurValueStr[UDS3                  ].val = 0xcc;
                CurValueStr[UDS4                  ].val = 0xc8;
                CurValueStr[UDS5                  ].val = 0xcc;
                CurValueStr[UDS6                  ].val = 0x55;
                CurValueStr[UDS7                  ].val = 0x55;
                MP5_Flag = 2;
                }    
                else
                {
                CurValueStr[UDS0                  ].val = 0x21;
                CurValueStr[UDS1                  ].val = 0x84;
                CurValueStr[UDS2                  ].val = 0xcc;
                CurValueStr[UDS3                  ].val = 0xcc;
                CurValueStr[UDS4                  ].val = 0xcc;
                CurValueStr[UDS5                  ].val = 0xcc;
                CurValueStr[UDS6                  ].val = 0x55;
                CurValueStr[UDS7                  ].val = 0x55;
                MP5_Flag = 1;
                }
                EOLStep = 7;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;
        case 7:
        {
            if((buf[0] == 0x03)&&(buf[1] == 0x7f))//ȴ
            {
                CurValueStr[UDS0                  ].val = 0x02;
                CurValueStr[UDS1                  ].val = 0x3e;
                CurValueStr[UDS2                  ].val = 0x00;
                CurValueStr[UDS3                  ].val = 0x55;
                CurValueStr[UDS4                  ].val = 0x55;
                CurValueStr[UDS5                  ].val = 0x55;
                CurValueStr[UDS6                  ].val = 0x55;
                CurValueStr[UDS7                  ].val = 0x55;
                EOLStep = 0;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;

        default:
        {
            EOLStep = 0;
            EOLError = 0;
        }
    }

    if(EOLError >= 5)
    {
        EOLStep = 0;
        EOLError = 0;
    }



}


void Service_10_03_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x02;
    CanMessageID18DA17F9.Msg[1] = 0x10;
    CanMessageID18DA17F9.Msg[2] = 0x03;
    */
}

void Service_11_01_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x02;
    CanMessageID18DA17F9.Msg[1] = 0x11;
    CanMessageID18DA17F9.Msg[2] = 0x01;
    */
}

void Service_22_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x03;
    CanMessageID18DA17F9.Msg[1] = 0x22;
    CanMessageID18DA17F9.Msg[2] = 0x02;
    CanMessageID18DA17F9.Msg[3] = 0x1F;
    */
}

void Service_27_01_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x02;
    CanMessageID18DA17F9.Msg[1] = 0x27;
    CanMessageID18DA17F9.Msg[2] = 0x01;
    */
}

void Service_27_02_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    App_Uds_Calc_Key(GetSeed);

    CanMessageID18DA17F9.Msg[0] = 0x06;
    CanMessageID18DA17F9.Msg[1] = 0x27;
    CanMessageID18DA17F9.Msg[2] = 0x02;
    CanMessageID18DA17F9.Msg[3] = (unsigned char)(CalcKey >> 24);
    CanMessageID18DA17F9.Msg[4] = (unsigned char)(CalcKey >> 16);
    CanMessageID18DA17F9.Msg[5] = (unsigned char)(CalcKey >> 8);
    CanMessageID18DA17F9.Msg[6] = (unsigned char)(CalcKey);
    */
}

void Service_2E_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x04;
    CanMessageID18DA17F9.Msg[1] = 0x2E;
    CanMessageID18DA17F9.Msg[2] = 0x02;
    CanMessageID18DA17F9.Msg[3] = 0x1F;
    CanMessageID18DA17F9.Msg[4] = EOLMode;
    */
}

void UDS_Service_Main(void)
{
    switch(EOLStep)
    {
        case 0:
        {
            Service_22_Proc();
        }
        break;

        case 1:
        {
            Service_10_03_Proc();
        }
        break;

        case 2:
        {
            Service_27_01_Proc();
        }
        break;

        case 3:
        {
            Service_27_02_Proc();
        }
        break;

        case 4:
        {
            Service_2E_Proc();
        }   
        break;

        case 5:
        {
            Service_11_01_Proc();
        }   
        break;

        default:
        {
            EOLStep = 0;
            EOLError = 0;
        }
    }
}