#ifndef WORK_FLASH_PRO_H
#define WORK_FLASH_PRO_H

#define WORKFLASH_MIRROR1_ADDRESS		0x0E000000u //WFlashMirror4
#define WORKFLASH_MIRROR4_ADDRESS		0x0E300000u //WFlashMirror4
#define WORKFLASH_MIRROR4_OFFECT        0x00300000u //WFlashMirror4

#define WORK_FLASH_SA1		1u
#define WORK_FLASH_SA2		2u
#define WORK_FLASH_SA3		3u
#define WORK_FLASH_SA4		4u
#define WORK_FLASH_SA5		5u
#define WORK_FLASH_SA6		6u
#define WORK_FLASH_SA7		7u
#define WORK_FLASH_SA8		8u
#define WORK_FLASH_SA9		9u
#define WORK_FLASH_SA10		10u
#define WORK_FLASH_SA11		11u
#define WORK_FLASH_SA12		12u
#define WORK_FLASH_SA13		13u
#define WORK_FLASH_SA14		14u
#define WORK_FLASH_SA15		15u
#define WORK_FLASH_SA16		16u
#define WORK_FLASH_SA17		17u
#define WORK_FLASH_SA18		18u
#define WORK_FLASH_SA19		19u
#define WORK_FLASH_SA20		20u
#define WORK_FLASH_SA21		21u
#define WORK_FLASH_SA22		22u
#define WORK_FLASH_SA23		23u
#define WORK_FLASH_SA24		24u
#define WORK_FLASH_SA25		25u

#define WORK_FLASH_SECTOR_SIZE	0x1000u

#define WK_ODO_PACK_LENGTH	8u
#define WK_ODO_PACK_TAIL 	0xEB

#define WK_SAF_PACK_LENGTH		64u
#define WK_USM_USER_PACK_LENGTH	64u
#define WK_EOL_UDS_PACK_LENGTH	64u

#define WFLASH_WRITE_OK		0u
#define WFLASH_WRITE_ERR	1u
#define WFLASH_WRITE_EN_ERR	2u

#define WFLASH_IDLE				0u
#define WFLASH_REQUEST_ERASE	1u
#define WFLASH_ERASING			2u
#define WFLASH_ERASE_COMPLETE	3u

#define WORK_FLASH_BLOCK_NONE	0u
#define WORK_FLASH_BLOCK_ODO	1u
#define WORK_FLASH_BLOCK_SAF	2u
#define WORK_FLASH_BLOCK_USM	3u
#define WORK_FLASH_BLOCK_EOL	4u

#pragma pack(1)

typedef struct
{//8bytes
    uint32_t ODO;
    uint8_t AliveCnts;
    uint8_t Tail;   //0xEB
    uint16_t CheckSum;
}WK_ODO_PACK;

typedef struct
{//8bytes
    WK_ODO_PACK OdoPack;
    uint8_t Sector;
    uint32_t Offect;
}WK_ODO_ADDRESS;

typedef struct 
{
    uint8_t Sector;
    uint32_t Offect;
}WK_ADDR_PACK;

typedef struct 
{
    uint8_t Sector;
    uint32_t ID;
}WK_READ_ADDR_PACK;
#pragma pack()


extern uint32_t ReadODORecord(void);
extern uint8_t StoreODOIntoWorkFlash(uint32_t Odo);

extern void ReadSAFRecord(uint8_t *pSAFPack, uint8_t Length);
extern void ReadUsmUserRecord(uint8_t *pUsmUserRecordPack, uint8_t Length);
extern void ReadEolUdsRecord(uint8_t *pWkEolUdsPack, uint8_t Length);
extern uint8_t StoreSAFIntoWorkFlash(uint8_t *pSAFPack, uint8_t Length);
extern uint8_t StoreUsmUserIntoWorkFlash(uint8_t *pUsmUserRecordPack, uint8_t Length);
extern uint8_t StoreEolUdsIntoWorkFlash(uint8_t *pWkEolUdsPack, uint8_t Length);

extern void WorkFlashReset(void);
extern void WorkFlashErasePro(void);

extern void ResetUsmUserStoreAddress(void);
extern void ResetEolUdsStoreAddress(void);
extern void ResetODOStoreAddress(void);
extern void ResetSAFStoreAddress(void);
extern void WK_SetVoltageState(uint16_t CurVoltage, uint8_t IsUnderPower);
extern uint8_t WorkFlashCheckIdleState(void);

extern uint16_t CRC16_cal(uint8_t* data, uint32_t length);
extern void CRC32_cal(uint32_t *crcCheck,uint8_t *buf, int len);
extern uint8_t WriteWorkFlash(uint32_t Addr, const uint32_t *buf, uint32_t length);
extern void WK_InitSAF(void);
extern void WK_InitUsmUser(void);
extern void WK_InitEolUds(void);
#endif