#include "common_include.h"

#define WAV_SOUNDINIT_LEN 240
static const uint8_t WAV_SOUNTINIT[WAV_SOUNDINIT_LEN] = {
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B, 
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
0x0D, 0x00, 0x1E, 0x08, 0xB7, 0x0F, 0x8C, 0x15, 0x27, 0x1B, 0x27, 0x1B,
};
static void I2SInit(void)//modefy@20190730 by zhoutie
{
    Port_SelectInputSource(&RIC.unRESIN1195, PortInputSourceI);
    
    
#if 0    
    stc_port_pin_config_t stc_port_pin_configECLK = { 
        .enOutputFunction      = PortOutputResourceGPIO,
        .enPullResistor        = PortPullResistorDown,
        .bInputEnable          = TRUE,
        .enGpioDirection       = PortGpioInput};
    
    Port_SetPinConfig(0, 3, &stc_port_pin_configECLK);
#endif    

    stc_port_pin_config_t stc_port_pin_config_out;
    
    stc_port_pin_config_out.enOutputFunction      = PortOutputResourceF,
    stc_port_pin_config_out.enOutputDrive         = PortOutputDriveD,
    stc_port_pin_config_out.enPullResistor        = PortPullResistorDown,
    stc_port_pin_config_out.enInputLevel          = PortInputLevelCmosA,
    stc_port_pin_config_out.bInputEnable          = FALSE,
    stc_port_pin_config_out.bNoiseFilterEnable    = TRUE,
    stc_port_pin_config_out.enGpioDirection       = PortGpioOutput,
    stc_port_pin_config_out.enGpioInitOutputLevel = PortGpioLow;
    
    Port_SetPinConfig(2, 5, &stc_port_pin_config_out);
    Port_SetPinConfig(2, 6, &stc_port_pin_config_out);
    Port_SetPinConfig(2, 7, &stc_port_pin_config_out);

    
    I2S0_SRST_SRST = 1;
    while (I2S0_SRST_SRST == 1);
    I2S0_CNTREG_ECKM = 0;// internal bus clock is divided and output
    I2S0_CNTREG_CKRT = 14;// divided by 16  (2^4)
    I2S0_CNTREG_OVHD = 0;// mon need not setting,when Stereo Mode Set this register 
    I2S0_CNTREG_MSKB = 1;// Serial Output Data in case of Invalid/Empty Frame Transmission
    I2S0_CNTREG_MSMD = 1;// 1-Master or 0-Salve
    I2S0_CNTREG_SBFN = 0;// Sub Frame Construction 1 or 2 Sub Frame  (0: 1 Sub Frame; 1: 2 Sub Frame)
    I2S0_CNTREG_RHLL = 1;// 0-word   1-two half word

    I2S0_CNTREG_BEXT = 0;// free bit is 0
    I2S0_CNTREG_FRUN = 1;// 0-burst or 1-Free-running  
    I2S0_CNTREG_MSLB = 0;// 0 MSB or 1 LSB
    I2S0_CNTREG_TXDIS = 0;// Transmitting function is 0-enable or 1-disable 
    I2S0_CNTREG_RXDIS = 1;// only transmite
    I2S0_CNTREG_SMPL = 0; // 0-center
    I2S0_CNTREG_CPOL = 1;// clock polarity 
    I2S0_CNTREG_FSPH = 1;
    I2S0_CNTREG_FSLN = 1;
    I2S0_CNTREG_FSPL = 1;
    
#if 1   
    I2S0_MCR0REG_S0WDL = 16 - 1;
    I2S0_MCR0REG_S0CHL = 16 - 1;
    I2S0_MCR0REG_S0CHN = 0;
    //I2S0_MCR0REG_S1WDL = 16 - 1;
    //I2S0_MCR0REG_S1CHL = 16 - 1;
    //I2S0_MCR0REG_S1CHN = 1;
#else   
    
    I2S0_MCR0REG_S0WDL = 0x1F;
    I2S0_MCR0REG_S0CHL = 0x1F;
    I2S0_MCR0REG_S0CHN = 0x1;
    //I2S0_MCR0REG_S1WDL = 0x1F;
    //I2S0_MCR0REG_S1CHL = 0x1F;
    //I2S0_MCR0REG_S1CHN = 0x1;    
#endif    
    
    I2S0_MCR1REG_S0CH0 = 1;
    //I2S0_MCR1REG_S0CH1 = 1;
    //I2S0_MCR2REG_S1CH0 = 1;
    //I2S0_MCR2REG_S1CH1 = 1;
    
    I2S0_INTCNT_TFTH = 5;// must set as same as FEST of SMIX 
    I2S0_INTCNT_TXFDM = 0;
    I2S0_INTCNT_TXFIM = 0;
    
    I2S0_OPRREG_TXENB = 1;
    I2S0_OPRREG_START = 1;
    
    I2S0_DMAACT_TDMACT = 1;
     
    I2S0_DEBUG    = 0x00000000;
}


/*****************************************************************************/
/* StartSMIXChannel                                                      */
/* StartSMIXChannel                                                      */
/*****************************************************************************/
static void StartSMIXChannel(uint8_t PMIS_CH)
{
    switch(PMIS_CH)
    {
        case SOUND_CH0:
            SMIX_MXICTRL_PMIS0FREQ = 1;    /*0:96kHz, 1:48kHz, 2:24kHz, 3:12kHz, 4:8kHz, 5:4kHz, 6:44.1kHz*/
            SMIX_MXCHMONO_PMIS0MONO = 3;       /* 0:stereo 1:monoral R 2:monoral L 3:monoral LR */
            SMIX_MXBUFFCLR_PMIS0BCLR = 0x1;             /* write 1: Buffer clear*/
            SMIX_MXFADECLR_PMIS0CLR = 0x1;              /* write 1: Initialize fade state*/
            SMIX_MXDRQCTRL_DMAENCH0 = 0x1;                /* DMA transfer to PMISx request setting*/
            SMIX_MXDRQCTRL_FESTCH0 = 5;
            SMIX_MXDRQCTRL_DMAENCH0 = 1;
            while(SMIX_MXBUFFCLR_PMIS0BCLR == 1 || SMIX_MXFADECLR_PMIS0CLR == 1);
            SMIX_MXCH_PMIS0 = 0x01;
            break;
        case SOUND_CH1:
            SMIX_MXICTRL_PMIS1FREQ = 1;
            SMIX_MXCHMONO_PMIS1MONO = 3;
            SMIX_MXBUFFCLR_PMIS1BCLR = 0x1;
            SMIX_MXFADECLR_PMIS1CLR = 0x1;
            SMIX_MXDRQCTRL_DMAENCH1 = 0x1;
            SMIX_MXDRQCTRL_FESTCH1 = 5;
            SMIX_MXDRQCTRL_DMAENCH1 = 1;
            while(SMIX_MXBUFFCLR_PMIS1BCLR == 1 || SMIX_MXFADECLR_PMIS1CLR == 1);
            SMIX_MXCH_PMIS1 = 0x01;
            break;
        case SOUND_CH2:
            SMIX_MXICTRL_PMIS2FREQ = 1;
            SMIX_MXCHMONO_PMIS2MONO = 3;
            SMIX_MXBUFFCLR_PMIS2BCLR = 0x1;
            SMIX_MXFADECLR_PMIS2CLR = 0x1;
            SMIX_MXDRQCTRL_DMAENCH2 = 0x1;
            SMIX_MXDRQCTRL_FESTCH2 = 5;
            SMIX_MXDRQCTRL_DMAENCH2 = 1;
            while(SMIX_MXBUFFCLR_PMIS2BCLR == 1 || SMIX_MXFADECLR_PMIS2CLR == 1);
            SMIX_MXCH_PMIS2 = 0x01;
            break;
        case SOUND_CH3:
            SMIX_MXICTRL_PMIS3FREQ = 1;
            SMIX_MXCHMONO_PMIS3MONO = 3;
            SMIX_MXBUFFCLR_PMIS3BCLR = 0x1;
            SMIX_MXFADECLR_PMIS3CLR = 0x1;
            SMIX_MXDRQCTRL_DMAENCH3 = 0x1;
            SMIX_MXDRQCTRL_FESTCH3 = 5;
            SMIX_MXDRQCTRL_DMAENCH3 = 1;
            while(SMIX_MXBUFFCLR_PMIS3BCLR == 1 || SMIX_MXFADECLR_PMIS3CLR == 1);
            SMIX_MXCH_PMIS3 = 0x01;
            break;
        case SOUND_CH4:
            SMIX_MXICTRL_PMIS4FREQ = 1;
            SMIX_MXCHMONO_PMIS4MONO = 3;
            SMIX_MXBUFFCLR_PMIS4BCLR = 0x1;
            SMIX_MXFADECLR_PMIS4CLR = 0x1;
            SMIX_MXDRQCTRL_DMAENCH4 = 0x1;
            SMIX_MXDRQCTRL_FESTCH4 = 5;
            SMIX_MXDRQCTRL_DMAENCH4 = 1;
            while(SMIX_MXBUFFCLR_PMIS4BCLR == 1 || SMIX_MXFADECLR_PMIS4CLR == 1);
            SMIX_MXCH_PMIS4 = 0x01;
            
            break;
        default:
            break;
    }
    
    return;
}

void Change_FadeIn(uint8_t PMIS_CH,uint8_t fadeInTime)
{
    uint8_t fadeInOn = 0;
    if (fadeInTime == 0) {
        fadeInOn = 0;
    } else {
        fadeInOn = 2;//fade in on
    }
    switch(PMIS_CH)
    {
        case SOUND_CH0:
            SMIX_MXCHFADE3_PMIS0FADEIN = fadeInTime;
            SMIX_MXFADECLR_PMIS0CLR = 1;
            SMIX_MXCHFADEEN_PMIS0FADEEN = fadeInOn;
            break;
        case SOUND_CH1:
            SMIX_MXCHFADE4_PMIS1FADEIN = fadeInTime;
            SMIX_MXFADECLR_PMIS1CLR = 1;
            SMIX_MXCHFADEEN_PMIS1FADEEN = fadeInOn;
            break;
        case SOUND_CH2:
            SMIX_MXCHFADE4_PMIS2FADEIN = fadeInTime;
            SMIX_MXFADECLR_PMIS2CLR = 1;
            SMIX_MXCHFADEEN_PMIS2FADEEN = fadeInOn;
            break;
        case SOUND_CH3:
            SMIX_MXCHFADE5_PMIS3FADEIN = fadeInTime;
            SMIX_MXFADECLR_PMIS3CLR = 1;
            SMIX_MXCHFADEEN_PMIS3FADEEN = fadeInOn;
            break;
        case SOUND_CH4:
            SMIX_MXCHFADE5_PMIS4FADEIN = fadeInTime;
            SMIX_MXFADECLR_PMIS4CLR = 1;
            SMIX_MXCHFADEEN_PMIS4FADEEN = fadeInOn;
            break;
        case SOUND_CHMIX:
            SMIX_MXMXDFADE_MXDFADEIN = fadeInTime;
            SMIX_MXFADECLR_MIXCLR = 1;
            SMIX_MXCHFADEEN_MXDFADEEN = fadeInOn;
            break;
        default:
            break;
    }

    return;
}

void Change_FadeOut(uint8_t PMIS_CH,uint8_t fadeOutTime)
{
    uint8_t fadeOutOn = 0; 
    if (fadeOutTime == 0) {
        fadeOutOn = 0;
    } else {
        fadeOutOn = 3;//fade out on
    }
    switch(PMIS_CH)
    {
        case SOUND_CH0:
            SMIX_MXCHFADE3_PMIS0FADEOUT = fadeOutTime;
            SMIX_MXFADECLR_PMIS0CLR = 1;
            SMIX_MXCHFADEEN_PMIS0FADEEN = fadeOutOn;
            break;
        case SOUND_CH1:
            SMIX_MXCHFADE4_PMIS1FADEOUT = fadeOutTime;
            SMIX_MXFADECLR_PMIS1CLR = 1;
            SMIX_MXCHFADEEN_PMIS1FADEEN = fadeOutOn;
            break;
        case SOUND_CH2:
            SMIX_MXCHFADE4_PMIS2FADEOUT = fadeOutTime;
            SMIX_MXFADECLR_PMIS2CLR = 1;
            SMIX_MXCHFADEEN_PMIS2FADEEN = fadeOutOn;
            break;
        case SOUND_CH3:
            SMIX_MXCHFADE5_PMIS3FADEOUT = fadeOutTime;
            SMIX_MXFADECLR_PMIS3CLR = 1;
            SMIX_MXCHFADEEN_PMIS3FADEEN = fadeOutOn;
            break;
        case SOUND_CH4:
            SMIX_MXCHFADE5_PMIS4FADEOUT = fadeOutTime;
            SMIX_MXFADECLR_PMIS4CLR = 1;
            SMIX_MXCHFADEEN_PMIS4FADEEN = fadeOutOn;
            break;
        case SOUND_CHMIX:
            SMIX_MXMXDFADE_MXDFADEOUT = fadeOutTime;
            SMIX_MXFADECLR_MIXCLR = 1;
            SMIX_MXCHFADEEN_MXDFADEEN = fadeOutOn;
            break;
        default:
            break;
    }

    return;
}

static void DMAChannel0Init(void)
{
     DMA0_A0_EB = 0;
        
     DMA0_A0_IS = 1;
     DMA0_A0_AL = 1;
     DMA0_A0_BL = 3;
     DMA0_A0_BC = 5;//dma_block_size;
     DMA0_A0_TO = 15;
     
     DMA0_B0_MS = 0;
     DMA0_B0_TW = 2;
     DMA0_B0_EI = 0;
     DMA0_B0_CI = 1;
     DMA0_B0_PN = 127;
     
     DMA0_D0_3_FS = 0;
     DMA0_D0_3_DES = 0;
     DMA0_D0_3_US = 0;
     DMA0_D0_3_FBS = 0;
     
     DMA0_D0_1_FD = 0;
     DMA0_D0_1_DED = 0;
     DMA0_D0_1_UD = 0;
     DMA0_D0_1_FBD = 1;
     DMA0_CMCHIC0 = 114;
}

static void DMAChannel1Init(void)
{
    DMA0_A1_EB = 0;
            
    DMA0_A1_IS = 1;
    DMA0_A1_AL = 1;
    DMA0_A1_BL = 3;
    DMA0_A1_BC = 5;//dma_block_size;
    DMA0_A1_TO = 15;
    
    DMA0_B1_MS = 0;
    DMA0_B1_TW = 2;
    DMA0_B1_EI = 0;
    DMA0_B1_CI = 1;
    DMA0_B1_PN = 127;
    
    DMA0_D1_3_FS = 0;
    DMA0_D1_3_DES = 0;
    DMA0_D1_3_US = 0;
    DMA0_D1_3_FBS = 0;
    
    DMA0_D1_1_FD = 0;
    DMA0_D1_1_DED = 0;
    DMA0_D1_1_UD = 0;
    DMA0_D1_1_FBD = 1;
    DMA0_CMCHIC1 = 115;
}

static void DMAChannel2Init(void)
{
    DMA0_A2_EB = 0;
        
    DMA0_A2_IS = 1;
    DMA0_A2_AL = 1;
    DMA0_A2_BL = 3;
    DMA0_A2_BC = 5;//dma_block_size;
    DMA0_A2_TO = 15;
    
    DMA0_B2_MS = 0;
    DMA0_B2_TW = 2;
    DMA0_B2_EI = 0;
    DMA0_B2_CI = 1;
    DMA0_B2_PN = 127;
    
    DMA0_D2_3_FS = 0;
    DMA0_D2_3_DES = 0;
    DMA0_D2_3_US = 0;
    DMA0_D2_3_FBS = 0;
    
    DMA0_D2_1_FD = 0;
    DMA0_D2_1_DED = 0;
    DMA0_D2_1_UD = 0;
    DMA0_D2_1_FBD = 1;
    DMA0_CMCHIC2 = 116;
}

static void DMAChannel3Init(void)
{
    DMA0_A3_EB = 0;
        
    DMA0_A3_IS = 1;
    DMA0_A3_AL = 1;
    DMA0_A3_BL = 3;
    DMA0_A3_BC = 5;//dma_block_size;
    DMA0_A3_TO = 15;
    
    DMA0_B3_MS = 0;
    DMA0_B3_TW = 2;
    DMA0_B3_EI = 0;
    DMA0_B3_CI = 1;
    DMA0_B3_PN = 127;
    
    DMA0_D3_3_FS = 0;
    DMA0_D3_3_DES = 0;
    DMA0_D3_3_US = 0;
    DMA0_D3_3_FBS = 0;
    
    DMA0_D3_1_FD = 0;
    DMA0_D3_1_DED = 0;
    DMA0_D3_1_UD = 0;
    DMA0_D3_1_FBD = 1;
    DMA0_CMCHIC3 = 117;
}

static void DMAChannel4Init(void)
{
    DMA0_A4_EB = 0;
        
    DMA0_A4_IS = 1;
    DMA0_A4_AL = 1;
    DMA0_A4_BL = 3;
    DMA0_A4_BC = 5;//dma_block_size;
    DMA0_A4_TO = 15;
    
    DMA0_B4_MS = 0;
    DMA0_B4_TW = 2;
    DMA0_B4_EI = 0;
    DMA0_B4_CI = 1;
    DMA0_B4_PN = 127;
    
    DMA0_D4_3_FS = 0;
    DMA0_D4_3_DES = 0;
    DMA0_D4_3_US = 0;
    DMA0_D4_3_FBS = 0;
    
    DMA0_D4_1_FD = 0;
    DMA0_D4_1_DED = 0;
    DMA0_D4_1_UD = 0;
    DMA0_D4_1_FBD = 1;
    DMA0_CMCHIC4 = 118;
}

static void AllSoundChannelDMAInit(void)
{
    DMA0_R_PR = 2;//ѭ
    DMA0_R_DE = 1;//DMA EN
    DMAChannel0Init();
    DMAChannel1Init();
    DMAChannel2Init();
    DMAChannel3Init();
    DMAChannel4Init();
}
/*****************************************************************************/
/* StartDMAChannel                                                      */
/* StartDMAChannel                                                      */
/*****************************************************************************/
static void StartDMAChannel(uint8_t PMIS_CH,uint32_t  Sound_Addr,uint32_t len)//DMA0~DMA4
{
    switch(PMIS_CH)
    {
        case SOUND_CH0:
            DMA0_A0_EB = 0;
            DMA0_C0_CE = 0;
            DMA0_A0_TC = (unsigned short) ((len / 24) - 1);
            DMA0_SA0 = Sound_Addr;
            DMA0_DA0 = (uint32_t) (&SMIX_MXPMIS0DADR0);
            DMA0_A0_EB = 1;
            DMA0_C0_CE = 1;
            break;
        case SOUND_CH1:
            DMA0_A1_EB = 0;
            DMA0_C1_CE = 0;
            DMA0_A1_TC = (unsigned short) ((len / 24) - 1);
            DMA0_SA1 = Sound_Addr;
            DMA0_DA1 = (uint32_t) (&SMIX_MXPMIS1DADR0);
            DMA0_A1_EB = 1;
            DMA0_C1_CE = 1;
            break;
        case SOUND_CH2:
            DMA0_A2_EB = 0;
            DMA0_C2_CE = 0;
            DMA0_A2_TC = (unsigned short) ((len / 24) - 1);
            DMA0_SA2 = Sound_Addr;
            DMA0_DA2 = (uint32_t) (&SMIX_MXPMIS2DADR0);
            DMA0_A2_EB = 1;
            DMA0_C2_CE = 1;
            break;
        case SOUND_CH3:
            DMA0_A3_EB = 0;
            DMA0_C3_CE = 0;
            DMA0_A3_TC = (unsigned short) ((len / 24) - 1);
            DMA0_SA3 = Sound_Addr;
            DMA0_DA3 = (uint32_t) (&SMIX_MXPMIS3DADR0);
            DMA0_A3_EB = 1;
            DMA0_C3_CE = 1;
            break;
        case SOUND_CH4:
            DMA0_A4_EB = 0;
            DMA0_C4_CE = 0;
            DMA0_A4_TC = (unsigned short) ((len / 24) - 1);
            DMA0_SA4 = Sound_Addr;
            DMA0_DA4 = (uint32_t) (&SMIX_MXPMIS4DADR0);
            DMA0_A4_EB = 1;
            DMA0_C4_CE = 1;
            break;
    }
}

static void SMIXInit(void)
{   
    SMIX_MXCH = 0x00000000;	
    SMIX_MXOCTRL = 0x00000503;// 1 DAC 2 PCM
    SMIX_MXBUFFCLR = 0x000007FF;
    SMIX_MXINTREN = 0x00000000;
    
    SMIX_MXFADECLR = 0x0000041F;
    SMIX_MXCHFADEEN = 0x00000000;
    return;
}
#if 0
static void PCMPWMInit(void)
{
    PCMPWM0_CONTROL = 0;
    //WPREG_PPC(PPC_PCFGR103, 87);    /* P1_03 (Pin77) AP0(AH0) */
    stc_port_pin_config_t stc_Sound_PCMAH_OUT_pin_config =
    {
        .enOutputFunction      = PortOutputResourceH,
        .enOutputDrive         = PortOutputDriveD,
        .enPullResistor        = PortPullResistorNone,
        .enInputLevel          = PortInputLevelCmosA,
        .bInputEnable          = FALSE,
        .bNoiseFilterEnable    = TRUE,
        .enGpioDirection       = PortGpioOutput,
        .enGpioInitOutputLevel = PortGpioLow,
    };
    Port_SetPinConfig( 1, 3, &stc_Sound_PCMAH_OUT_pin_config);
    Port_SetPinConfig( 1, 2, &stc_Sound_PCMAH_OUT_pin_config);
    //WPREG_PPC(PPC_PCFGR102, 87);    /* P1_02 (Pin76) AN0(AL0) */
    //WPREG_PPC(PPC_PCFGR101, 87);    /* P1_01 (Pin75) BP0(BH0) */
    //WPREG_PPC(PPC_PCFGR100, 87);    /* P1_00 (Pin74) BN0(BL0) */
    //PCMPWM0_CONTROL = 0x00050500;
    PCMPWM0_CONTROL_FEST = 5;
    PCMPWM0_CONTROL_MODE = 1;// 0 low pass 1 simplified h-bridge mode 2 full h-bridge mode
    PCMPWM0_CONTROL_DMAEN = 1;
    PCMPWM0_CONTROL_STEREO = 1;
    PCMPWM0_OCTRL_EN1 = 1;
    PCMPWM0_COUNTP_COUNTP = 2082;
    PCMPWM0_PCMOFFS_PCM_OFFS = 1041;
    //PCMPWM0_COUNTP_COUNTP = 4166;
    //PCMPWM0_PCMOFFS_PCM_OFFS = 2083;
    PCMPWM0_CLKSEL_CLK_SEL = 0x00000000;
    PCMPWM0_INTREN_DREQ = 0;
    PCMPWM0_INTREN_OVFL = 0;
    PCMPWM0_INTREN_UDRN = 0;
    PCMPWM0_INTREN_DMA_ERR = 0;
    PCMPWM0_CONTROL_EN = 1;
    return;
}
#endif
/****************************************************************************/
/* ChangeVolume                                                            */
/* To set the volume gain of the specified channel                          */
/****************************************************************************/
void SoundVolChange(uint8_t PMIS_CH, uint32_t volume)
{
    
    switch(PMIS_CH)
    {
        case SOUND_CH0:
            /* To set the volume GAIN of PMIS_CH0 */
            SMIX_MXCHVOL2_PMIS0VOL = volume;
            break;
        case SOUND_CH1:
            /* To set the volume GAIN of PMIS_CH1 */
            SMIX_MXCHVOL2_PMIS1VOL = volume;
            break;
        case SOUND_CH2:
            /* To set the volume GAIN of PMIS_CH2 */
            SMIX_MXCHVOL2_PMIS2VOL = volume;
            break;
        case SOUND_CH3:
            /* To set the volume GAIN of PMIS_CH3 */
            SMIX_MXCHVOL3_PMIS3VOL = volume;
            break;
        case SOUND_CH4:
            /* To set the volume GAIN of PMIS_CH4 */
            SMIX_MXCHVOL3_PMIS4VOL = volume;
            break;
        case SOUND_CHMIX:
            /* To set the volume GAIN of MIXER */
            SMIX_MXCHVOL3_MXDVOL = volume;
            break;
        default:
            break;
    }
}


void StopSoundCh(uint8_t PMIS_CH)
{
    switch(PMIS_CH) {
    case SOUND_CH0:
        DMA0_A0_EB = 0;                  
        DMA0_C0_CE = 0;
        SMIX_MXCH_PMIS0 = 0x0;
        SMIX_MXINTRCLR = 0xffff;
        SMIX_MXBUFFCLR_PMIS0BCLR = 0x1;         /* write 1: Buffer clear*/
        SMIX_MXFADECLR_PMIS0CLR = 0x1;          /* write 1: Initialize fade state*/
        SMIX_MXDRQCTRL_DMAENCH0 = 1;            /* DMA transfer to PMISx request setting*/
        
        break;
    case SOUND_CH1:
        DMA0_A1_EB = 0;                  
        DMA0_C1_CE = 0;
        SMIX_MXCH_PMIS1 = 0x0;
        SMIX_MXINTRCLR = 0xffff;
        SMIX_MXBUFFCLR_PMIS1BCLR = 0x1;         /* write 1: Buffer clear*/
        SMIX_MXFADECLR_PMIS1CLR = 0x1;          /* write 1: Initialize fade state*/
        SMIX_MXDRQCTRL_DMAENCH1 = 1;            /* DMA transfer to PMISx request setting*/
        
        break;
    case SOUND_CH2:
        DMA0_A2_EB = 0;                  
        DMA0_C2_CE = 0;
        SMIX_MXCH_PMIS2 = 0x0;
        SMIX_MXINTRCLR = 0xffff;
        SMIX_MXBUFFCLR_PMIS2BCLR = 0x1;         /* write 1: Buffer clear*/
        SMIX_MXFADECLR_PMIS2CLR = 0x1;          /* write 1: Initialize fade state*/
        SMIX_MXDRQCTRL_DMAENCH2 = 1;            /* DMA transfer to PMISx request setting*/
        
        break;
    case SOUND_CH3:
        DMA0_A3_EB = 0;                  
        DMA0_C3_CE = 0;
        SMIX_MXCH_PMIS3 = 0x0;
        SMIX_MXINTRCLR = 0xffff;
        SMIX_MXBUFFCLR_PMIS3BCLR = 0x1;         /* write 1: Buffer clear*/
        SMIX_MXFADECLR_PMIS3CLR = 0x1;          /* write 1: Initialize fade state*/
        SMIX_MXDRQCTRL_DMAENCH3 = 1;            /* DMA transfer to PMISx request setting*/
        
        break;
    case SOUND_CH4:
        DMA0_A4_EB = 0;                  
        DMA0_C4_CE = 0;
        SMIX_MXCH_PMIS4 = 0x0;
        SMIX_MXINTRCLR = 0xffff;
        SMIX_MXBUFFCLR_PMIS4BCLR = 0x1;         /* write 1: Buffer clear*/
        SMIX_MXFADECLR_PMIS4CLR = 0x1;          /* write 1: Initialize fade state*/
        SMIX_MXDRQCTRL_DMAENCH4 = 1;            /* DMA transfer to PMISx request setting*/
        
        break;   
    }
}

void KeepOnSoundCh(uint8_t PMIS_CH)
{
    switch(PMIS_CH) {
        case SOUND_CH0:
            SMIX_MXCH_PMIS0 = 0x1;
            break;
        case SOUND_CH1:
            SMIX_MXCH_PMIS1 = 0x1;
            break;
        case SOUND_CH2:
            SMIX_MXCH_PMIS2 = 0x1;
            break;
        case SOUND_CH3:
            SMIX_MXCH_PMIS3 = 0x1;
            break;
        case SOUND_CH4:
            SMIX_MXCH_PMIS4 = 0x1;
            break;  
    }
}

void BSP_SOUND_Init(void)
{  
    SMIXInit();
    AllSoundChannelDMAInit();	
    I2SInit();//modify@20190730 by zhoutie   

    SoundVolChange(SOUND_CHMIX, MAXVOL); 

    SoundVolChange(4, 0);
    StartDMASoundPlay(4, (unsigned long)(WAV_SOUNTINIT) + 0x04000000u, WAV_SOUNDINIT_LEN);
    DelayMs(25);//6ms
}

void StartDMASoundPlay(uint8_t PMIS_CH,uint32_t Sound_Addr,uint32_t len)
{
    if (Sound_Addr % 4 != 0) {
        return;//four byte 
    }
    
    //StopSoundCh(PMIS_CH);
    StartDMAChannel(PMIS_CH,Sound_Addr,len);
    StartSMIXChannel(PMIS_CH);
}
FN_IRQ_NOT_NESTED void intrirq_isr_irq199(void)
{   
    uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_199;
    if (DMA0_B0_DQ){
        DMA0_C0_CD = 1;
        //LastCHPhrase[0] = 0;

    }
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void intrirq_isr_irq200(void)
{   
    uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_200;
    if (DMA0_B1_DQ) {
        DMA0_C1_CD = 1; 
        //LastCHPhrase[1] = 0;

    }
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void intrirq_isr_irq201(void)
{   
    uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_201;
    if (DMA0_B2_DQ) {
        DMA0_C2_CD = 1;
        //LastCHPhrase[2] = 0;

    }
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void intrirq_isr_irq202(void)
{   
    uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_202;
    if (DMA0_B3_DQ) {
        DMA0_C3_CD = 1;
        //LastCHPhrase[3] = 0;

    }
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void intrirq_isr_irq203(void)
{   
    uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_203;
    if (DMA0_B4_DQ) {
        DMA0_C4_CD = 1;
        SMIX_MXCH_PMIS4 = 0x0;
        //CheckSoundSystemPlayComplete(SOUND_CH4);
    }
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void PCMPWM_ERROR(void)
{
    uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_159;
    if (PCMPWM0_INTRSTAT_OVFL) {
        PCMPWM0_INTRCLR_OVFL = 1;
        //SoundSystemInit();
    }
    if (PCMPWM0_INTRSTAT_UDRN) {
        PCMPWM0_INTRCLR_UDRN = 1;
        //SoundSystemInit();
    }
    if (PCMPWM0_INTRSTAT_DMA_ERR) {
        PCMPWM0_INTRCLR_DMA_ERR = 1;
        //SoundSystemInit();
    }
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}




