#include "UDS_TP.h"
#include "UDS_Service.h"
/*
typedef struct
{
    unsigned char ID;
    unsigned char Switch;
    unsigned int DID;
} s_ServiceSwitch;

s_UDS_ServiceBuffer Rx_Buffer;
s_UDS_ServiceBuffer Tx_Buffer;

unsigned char pRxTransfer;
unsigned char pTxTransfer;

unsigned char CF_SN = 0;

s_ServiceSwitch ServiceSwitch;

unsigned char Service27_Seed[8];
unsigned char Service27_Key[8];

void SetRxTransferStatus(e_TransferStatus sts, unsigned int UDS_Len)
{
    Rx_Buffer.TransferStatus = sts;
    if (sts == TransferStart)
    {
        Rx_Buffer.DataLen = UDS_Len - 1;
    }
    pRxTransfer = 0;
}

void SetTxTransferStatus(e_TransferStatus sts)
{
    Tx_Buffer.TransferStatus = sts;
    pTxTransfer = 0;
}

unsigned char GetRxTransferDataNumber(void)
{
    return pRxTransfer;
}

void TransferServiceRxInfo(unsigned char *Data, unsigned char len)
{
    unsigned char i;
    if (Rx_Buffer.TransferStatus == TransferEnd)
    {
        return;
    }

    if (pRxTransfer == 0)
    {
        Rx_Buffer.ServiceID = Data[0];
        for (i = 1; i < len; i++)
        {
            Rx_Buffer.Data[i - 1] = Data[i];
        }
        pRxTransfer += len - 1;
    }
    else
    {
        for (i = 0; i < len; i++)
        {
            Rx_Buffer.Data[pRxTransfer + i] = Data[i];
        }
        pRxTransfer += len;
    }
}

e_TxType TransferServiceTxInfo(s_UDS_Msg_Buffer *buffer)
{
    unsigned char len, i;
    e_TxType type;

    if (buffer->AnalysisStatus)
    {
        return Tx_NoAct;
    }

    if (Tx_Buffer.ServiceID == 0xFF)
    {
        return Tx_NoAct;
    }

    buffer->AnalysisStatus = 1;

    if (Tx_Buffer.TransferStatus == TransferEnd)
    {
        Tx_Buffer.TransferStatus = TransferStart;
        pTxTransfer = 0;
        len = Tx_Buffer.DataLen + 1;
        if (len < 8)
        {
            buffer->DataMsg.SF_Format.N_PCItype = N_PCITYPE_SF;
            buffer->DataMsg.SF_Format.SF_DL = len;
            buffer->DataMsg.SF_Format.Data1 = Tx_Buffer.ServiceID;
            for (i = 0; i < Tx_Buffer.DataLen; i++)
            {
                buffer->DataMsg.Data[i + 2] = Tx_Buffer.Data[i];
            }
            Tx_Buffer.TransferStatus = TransferEnd;
            pTxTransfer = 0;
            type = Tx_SF;
        }
        else
        {
            buffer->DataMsg.FF_Format.N_PCItype = N_PCITYPE_FF;
            buffer->DataMsg.FF_Format.FF_DL_L = len;
            buffer->DataMsg.FF_Format.FF_DL_H = len >> 8;
            buffer->DataMsg.FF_Format.Data2 = Tx_Buffer.ServiceID;
            for (i = 0; i < 5; i++)
            {
                buffer->DataMsg.Data[i + 3] = Tx_Buffer.Data[i];
            }
            pTxTransfer += 5;
            CF_SN = 1;
            type = Tx_FF;
        }
    }
    else
    {
        buffer->DataMsg.CF_Format.N_PCItype = N_PCITYPE_CF;
        buffer->DataMsg.CF_Format.SN = CF_SN;
        CF_SN++;
        if (CF_SN > 15)
        {
            CF_SN = 0;
        }
        if ((Tx_Buffer.DataLen - pTxTransfer) > 7)
        {
            for (i = 0; i < 7; i++)
            {
                buffer->DataMsg.Data[i + 1] = Tx_Buffer.Data[i + pTxTransfer];
            }
            type = Tx_CF;
            pTxTransfer += 7;
        }
        else
        {
            for (i = 0; i < (Tx_Buffer.DataLen - pTxTransfer); i++)
            {
                buffer->DataMsg.Data[i + 1] = Tx_Buffer.Data[i + pTxTransfer];
            }
            Tx_Buffer.TransferStatus = TransferEnd;
            pTxTransfer = 0;
            type = Tx_End;
        }
    }

    return type;
}

void ServiceID_DiagnosticSessionControlProc(unsigned char DID)
{
    Tx_Buffer.ServiceID = ServiceID_DiagnosticSessionControl;
    Tx_Buffer.DataLen = 1;
    Tx_Buffer.Data[0] = DID;
}

void ServiceID_ECUResetProc(unsigned char DID)
{
    Tx_Buffer.ServiceID = ServiceID_ECUReset;
    Tx_Buffer.DataLen = 1;
    Tx_Buffer.Data[0] = DID;
}

void ServiceID_SecurityAccessProc(unsigned char DID)
{
    if (DID % 2)
    {
        Tx_Buffer.ServiceID = ServiceID_SecurityAccess;
        Tx_Buffer.DataLen = 1;
        Tx_Buffer.Data[0] = DID;
    }
    else
    {
        Tx_Buffer.ServiceID = ServiceID_SecurityAccess;
        Tx_Buffer.DataLen = 9;
        Tx_Buffer.Data[0] = DID;
        Tx_Buffer.Data[1] = Service27_Key[0];
        Tx_Buffer.Data[2] = Service27_Key[1];
        Tx_Buffer.Data[3] = Service27_Key[2];
        Tx_Buffer.Data[4] = Service27_Key[3];
        Tx_Buffer.Data[5] = Service27_Key[4];
        Tx_Buffer.Data[6] = Service27_Key[5];
        Tx_Buffer.Data[7] = Service27_Key[6];
        Tx_Buffer.Data[8] = Service27_Key[7];
    }
}

void ServiceID_ReadDataByIdentifierProc(unsigned int DID)
{
    Tx_Buffer.ServiceID = ServiceID_ReadDataByIdentifier;
    Tx_Buffer.DataLen = 2;
    Tx_Buffer.Data[0] = DID >> 8;
    Tx_Buffer.Data[1] = DID;
}

void ServiceID_WriteDataByIdentifierProc(unsigned int DID)
{
    Tx_Buffer.ServiceID = ServiceID_WriteDataByIdentifier;
    Tx_Buffer.DataLen = 6;
    Tx_Buffer.Data[0] = DID >> 8;
    Tx_Buffer.Data[1] = DID;
    Tx_Buffer.Data[2] = 0xFF;
    Tx_Buffer.Data[3] = 0xFF;
    Tx_Buffer.Data[4] = 0x57;
    Tx_Buffer.Data[5] = 0x06;
}

void ServiceID_TesterPresentProc(void)
{
    Tx_Buffer.ServiceID = ServiceID_TesterPresent;
    Tx_Buffer.DataLen = 1;
    Tx_Buffer.Data[0] = 0x00;
}

void UDS_SendSerivceMain(void)
{
    if (ServiceSwitch.Switch)
    {
        ServiceSwitch.Switch = 0;
        switch (ServiceSwitch.ID)
        {
        case ServiceID_DiagnosticSessionControl:
        {
            ServiceID_DiagnosticSessionControlProc(ServiceSwitch.DID);
        }
        break;
        case ServiceID_ECUReset:
        {
            ServiceID_ECUResetProc(ServiceSwitch.DID);
        }
        break;
        case ServiceID_SecurityAccess:
        {
            ServiceID_SecurityAccessProc(ServiceSwitch.DID);
        }
        break;
        case ServiceID_ReadDataByIdentifier:
        {
            ServiceID_ReadDataByIdentifierProc(ServiceSwitch.DID);
        }
        break;
        case ServiceID_WriteDataByIdentifier:
        {
            ServiceID_WriteDataByIdentifierProc(ServiceSwitch.DID);
        }
        break;
        case ServiceID_TesterPresent:
        {
            ServiceID_TesterPresentProc();
        }
        break;

        default:;
        }

        EnableUDSSend();
    }
}

unsigned char UDS_Button = 0xFF;

void UDS_ServiceMain(void)
{
    if (UDS_Button != 0xFF)
    {
        ServiceSwitch.ID = UDS_Button;
        ServiceSwitch.Switch = 1;

        UDS_Button = 0xFF;
    }

    if (GetCtrlTime(UDS_3E_Service) >= 3000)
    {
        ServiceSwitch.ID = ServiceID_TesterPresent;
        ServiceSwitch.Switch = 1;
    }

    UDS_SendSerivceMain();

    AnalysisUDSMessage();

    if (CommunicateStatus == COMM_WaitServiceHandle)
    {
        CommunicateStatus = COMM_Free;
        switch (Rx_Buffer.ServiceID - 0x40)
        {
        case ServiceID_SecurityAccess:
        {
            if (Rx_Buffer.Data[0] == 0x01)
            {
                memcpy((void *)Service27_Seed, (void *)&Rx_Buffer.Data[1], 8);
                ASK_KeyGenerate(Service27_Seed, Service27_Key);
                //ServiceID_SecurityAccessProc(0x02);
                ClearCtrlTime(UDS_3E_Service);
                //CommunicateStatus = COMM_Send_Frame;
            }
        }
        break;

        case ServiceID_WriteDataByIdentifier:
        {
            EOL_Complete_Ctrl(1);
        }
        break;

        case 0x7F:
        {
            if ((Rx_Buffer.Data[0] == 0x2E) && (Rx_Buffer.Data[1] == 0x78))
            {
                ;
            }
            else
            {
                EOL_Complete_Ctrl(0);
                NextEOLStep();
            }
        }
        break;

        default:
        {
            ;
        }
        }

        if (GetWaitReqServiceID() == (Rx_Buffer.ServiceID - 0x40))
        {
            NextEOLStep();
        }
    }

    TP_SendServiceMsg();
}

void SetServiceProc(unsigned char ServiceID, unsigned int ServiceDID)
{
    ServiceSwitch.Switch = 1;
    ServiceSwitch.ID = ServiceID;
    ServiceSwitch.DID = ServiceDID;
}*/