/******************************************************************************
 * $Revision: 422 $
 * $Date:: 2017-04-07 15:58:41 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************/
/** \file main.h
 **
 ** Common project definitions
 **
 ** History:
 **   - 2015-09-01  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __MAIN_H__
#define __MAIN_H__

// File version 0xYYXX = vYY.XX
#define MAIN_H_VERSION          0x0001
#define PWMCH_REV_OUT           18 


/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "base_types.h"

typedef enum {
    TASK_WEAKUP,
    TASK_IOPUT,
    TASK_CAN,
    TASK_MAINCONTENTS,
    TASK_EVENT,
    TASK_FUNCTION_CONTROL,
    TASK_SCI,
}_RUNSTEP;
extern _RUNSTEP RunStep;




/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define')                           */
/*****************************************************************************/
#define QR_CODE_PARTNUM_OFFECT			14
#define QR_CODE_DATE_OFFECT				24
#define QR_CODE_CLUSTER_ID_OFFECT		36
#define QR_CODE_SERIAL_NUMBER_OFFECT	18

/*****************************************************************************/
/* Global type definitions ('typedef')                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source)           */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source)             */
/*****************************************************************************/
extern uint8_t VIN_NumberBuf[10]; 
extern uint8_t VIN_Count;

extern uint8_t Flag_SetTime;
extern uint8_t DateTimeDay;
extern uint8_t DateTimeMonth;
extern uint8_t DateTimeYear1;
extern uint8_t DateTimeYear;
extern uint32_t CheckStep;
extern uint8_t CheckResult[53];
extern uint8_t Flag_DisplayErr;
extern uint32_t DisplayErrTimer;
extern uint8_t Flag_CheckBarcode;
extern uint8_t BarcodeErr;
extern uint8_t SetTimeState;
extern uint8_t SetCheckStationBarcodeCnts;
extern uint8_t PartNum_AssemblyWorkshop[16];
extern uint32_t ClusterID;
extern uint32_t BarcodeDate;
extern uint8_t SerialNumber[4];
extern uint8_t Flag_BarcodeErr;
extern uint8_t SetClusterState;
extern uint8_t tmpPartNum_AssemblyWorkshop[16];
extern uint32_t tmpClusterID;
extern uint32_t tmpBarcodeDate;
extern uint8_t tmpSerialNumber[4];
extern uint32_t CluClusterID;
extern uint32_t CluBarcodeDate;
extern uint8_t CluSerialNumber[4];
extern uint8_t CluWriteCompleteFlag[8];
#endif /* __MAIN_H__ */
