

#ifdef        GLOBALS_APP_TEST
    #define   EXTERN_APP_TEST
    
#else
    #define   EXTERN_APP_TEST     extern
#endif

#ifndef APP_TEDT_H_
#define APP_TEDT_H_

#define Motorola                0
#define Intel                   1

#define Offset_Minus            0
#define Offset_Plus             1

#define Value_Minus             0
#define Value_Plus              1

typedef struct{
    unsigned int val;
    unsigned char fval;
}s_CurValue;

typedef struct{
    CAN_message *canMsg;
    unsigned char StartByte;    //起始字节
    unsigned char StartBit;     //起始位
    unsigned char SignalLen;    //信号长度
    unsigned int  Offset;       //偏移量
    unsigned char fOffset;      //偏移量标志位
    unsigned int Factor_1;      //缩放因子1
    unsigned int Factor_2;      //缩放因子2
    s_CurValue *CurValue;       //当前值指针
    unsigned char fFormat;      //信号格式 Motorola or Intel

}s_CAN_List;

enum
{
    ENUM_VSpeed          = 0,//����
    TCS_Warning_Lamp,
    ABS_Warning_Lamp,

    CAN_List_Num        ,
#if 0
    ENUM_VSpeed          = 0,//����
    ENUM_RSpeed          ,//�??�??
    ENUM_WaterTemp       ,//   温度
    TCS_Warning_Lamp   ,//前轮胎压
    TCS_Work_Mode   ,//后轮胎压
    ISG_Ready,
    ISG_Power,
    ISG_Power_Enable,
    
    ABS_Warning_Lamp,
    ECU_Warning_Lamp,

    MBMS_TOTALSigCharg,     //充电指示灯    18202922
    MBMS_TOTALSigAcc,

    MMCU_PowerMode,             //125
    MMCU_TravelSpeedGear,
    MMCU_SeatDetectState,
    MMCU_ParkingGearState,

    BMCU_PTOSwicthState,
    BMCU_BladeSpeedGear,

    MBMS_Soc1,
    MBMS_Soc2,

    MBMS_StatSoc,

    BMCU_Moto1_Locked_RotorFault,

    CAN_List_Num        ,
#endif
};
                                                                                    
EXTERN_APP_TEST volatile s_CurValue CurValueStr[CAN_List_Num];

static const s_CAN_List CAN_List[] = 
{
    {&CanMsg_0A31FFE8, 0,  0,  16,   0,   Offset_Plus,    1,         1, &CurValueStr[ENUM_VSpeed      ], Intel},
    {&CanMsg_0A30FFE8, 0,  3,  2,    0,   Offset_Plus,    1,         1, &CurValueStr[TCS_Warning_Lamp ], Intel},
    {&CanMsg_0A30FFE8, 0,  0,  2,    0,   Offset_Plus,    1,         1, &CurValueStr[ABS_Warning_Lamp ], Intel}

    #if 0
    {&CanMsg_101, 2,  0,  8,    0,   Offset_Plus,    1,       1, &CurValueStr[ENUM_VSpeed         ], Motorola},
    {&CanMsg_101, 1,  0, 16,    0,   Offset_Plus,    100,    25, &CurValueStr[ENUM_RSpeed         ], Motorola},
    {&CanMsg_101, 5,  0, 16,  273,   Offset_Minus,    10,     1, &CurValueStr[ENUM_WaterTemp      ], Motorola},

    {&CanMsg_37B, 3,  2,  1,    0,   Offset_Plus,     1,    1, &CurValueStr[TCS_Warning_Lamp ], Motorola},
    {&CanMsg_37B, 3,  4,  4,    0,   Offset_Plus,     1,    1, &CurValueStr[TCS_Work_Mode  ], Motorola},

    {&CanMsg_111, 4,  1, 1,    0,   Offset_Plus,    1,    1, &CurValueStr[ISG_Ready         ], Motorola},
    {&CanMsg_111, 4,  2, 1,    0,   Offset_Plus,    1,    1, &CurValueStr[ISG_Power         ], Motorola},
    {&CanMsg_111, 4,  4, 2,      0,   Offset_Plus,    1,     1, &CurValueStr[ISG_Power_Enable      ], Motorola},

    {&CanMsg_12B, 4,  2, 2,      0,   Offset_Plus,    1,     1, &CurValueStr[ABS_Warning_Lamp      ], Motorola},

    {&CanMsg_402, 7,  7, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[ECU_Warning_Lamp      ], Motorola},

    {&CanMsg_18202922, 0,  0, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_TOTALSigCharg      ], Motorola},
    {&CanMsg_18202922, 0,  1, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_TOTALSigAcc      ], Motorola},


    {&CanMsg_125, 0,  2, 4,      0,   Offset_Plus,    1,     1, &CurValueStr[MMCU_PowerMode      ], Motorola},
    {&CanMsg_125, 1,  0, 2,      0,   Offset_Plus,    1,     1, &CurValueStr[MMCU_TravelSpeedGear      ], Motorola},
    {&CanMsg_125, 2,  1, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[MMCU_SeatDetectState      ], Motorola},
    {&CanMsg_125, 2,  7, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[MMCU_ParkingGearState      ], Motorola},

    {&CanMsg_157, 0,  3, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[BMCU_PTOSwicthState      ], Motorola},
    {&CanMsg_157, 0,  4, 3,      0,   Offset_Plus,    1,     1, &CurValueStr[BMCU_BladeSpeedGear      ], Motorola},

    {&CanMsg_SOC1, 4,  0, 8,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_Soc1      ], Motorola},
    {&CanMsg_SOC2, 4,  0, 8,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_Soc2      ], Motorola},

    {&CanMsg_SOC, 4,  0, 8,      0,   Offset_Plus,    1,     1, &CurValueStr[MBMS_StatSoc      ], Motorola},

    {&CanMsg_38E, 1,  0, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[BMCU_Moto1_Locked_RotorFault      ], Motorola},
    #endif

};



extern unsigned int lost_flag;
extern unsigned int CAN_init_flag;
extern unsigned int water_value;
extern unsigned int count_flag_a;
extern unsigned int speed_value;
EXTERN_APP_TEST             void                APP_Button_Proc(void);
EXTERN_APP_TEST             void                Message_Value_Calculate(s_CAN_List list);

void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value);  /*Do not span bytes*/



#endif /* API_CAN_H_ */
