#ifndef __HSSPI_FLASH_H__
#define __HSSPI_FLASH_H__

#include "mcu_settings.h"
#include "abstract.h"

#define FLASH_OK                0
#define FLASH_ADDR_ALIGN_ERR    1
#define FLASH_ADDR_RANGE_ERR    2
#define FLASH_SIZE_ERR          3
#define FLASH_BUSY              4
#define FLASH_PROGRAM_ERR       5

#define ADDRESS_24BIT	0
#define ADDRESS_32BIT	1

extern uint8_t hsspi_SingleErase_4K(uint32_t Address);
extern uint8_t hsspi_SingleErase_32K(uint32_t Address, uint8_t AddrType);
extern uint8_t hsspi_SingleErase_64K(uint32_t Address);
extern uint8_t hsspi_SingleErase_CHIP(void);
extern uint8_t hsspi_QuadProgram(uint32_t address, uint8_t *data, uint32_t TxSize, uint8_t AddrType);
extern void hsspi_WriteEnable(void);
extern uint8_t hsspi_CheckBusy(void);
extern void Start_Write_dsspi(void);
extern void End_Write_dsspi(void);
extern uint32_t Write_dsspi(void);
extern void hsspi_CheckQuadBitSingle_GigaDevice(void); 
extern void hsspi_DisProtectBit(void);
extern uint8_t hsspi_QuadCheck(uint32_t Address, uint8_t *data, uint32_t TxSize, uint8_t AddrType);


#endif