#ifndef __PROJECT_CONFIG_H__
#define __PROJECT_CONFIG_H__
#pragma pack(1)

#define UI_CHINESE 0
#define UI_ENGLISH 1


#define FAST_CHECK       1

#define STATE_CHECKING     0
#define STATE_CHECKED      1
#define STATE_CONFIGURING  2
#define STATE_CONFIGED     3
#define STATE_CONFIGERROR  4


#define RESULT_MAN_REVIEW 0
#define RESULT_NORMAL     1
#define RESULT_ABNORMAL   2

#define CLUSTER_CHECK_TIME  1000   //�Ǳ�δ������ʾ���ʱ��Ĭ��1��

#if (PRO_CONFIG_EOL_APPLY)
typedef struct tagPos{
    unsigned short uiX;
    unsigned short uiY;
}ST_POS;
#define PER_PAGE_MAX_NUM 36
#define PER_ROW_NUM 3
#define PER_COL_NUM 12
#endif




#define FuncNameSize 16
typedef void (*fpFunc)(void);
typedef struct tagFunctionOut
{
    unsigned char uiIndex;
    unsigned char szFuncName[FuncNameSize+1];
    fpFunc pFunc;
} ST_FUNC_OUT;

#define POWER_NORMAL   0
#define POWER_ABNORMAL 1
#define POWER_CHECKING 2
#define POWER_CHECK_START 3
#define POWER_CHECK_END 4

#define SVC_CFG 0
#define MID_CFG 1
#define STD_CFG 2

#define BVM_YES 1
#define BVM_NO  0

#define SPORT_PLUS_YES 1
#define SPORT_PLUS_NO  0

#define DBC_YES 1
#define DBC_NO  0

#define HBA_WHITE_YES 1
#define HBA_WHITE_NO 0

#define FCA_RED_YES 1
#define FCA_RED_NO 0

#define RESERVE1 0
#define RESERVE2 1
#define RESERVE3 2

enum {
    CAR_TYPE_NONE = 0,
    CAR_TYPE_ICV,
    CAR_TYPE_EV,
    CAR_TYPE_HEV,
    CAR_TYPE_PHEV,
    CAR_TYPE_FCEV,
    CAR_TYPE_LPI,
    CAR_TYPE_CNG,
};
#define AUTO_CAN_0 0
#define AUTO_CAN_1 1
#define AUTO_CAN_SW_HW_0 0
#define AUTO_CAN_SW_HW_1 1
#define AUTO_CAN_SW1_0 0
#define AUTO_CAN_SW1_1 1
#define AUTO_CAN_SW2_0 0
#define AUTO_CAN_SW2_1 1
#define AUTO_CAN_Engine_0 0
#define AUTO_CAN_Engine_1 1
#define AUTO_CAN_PRNDS_0 0
#define AUTO_CAN_PRNDS_1 1
#define AUTO_CAN_GND_0 0
#define AUTO_CAN_GND_1 1
#define AUTO_CAN_Rheo_0 0
#define AUTO_CAN_Rheo_1 1
#define AUTO_CAN_Detent_0 0
#define AUTO_CAN_Detent_1 1
#define AUTO_CAN_DMS_0 0
#define AUTO_CAN_DMS_1 1
#define AUTO_CAN_Speed_ILL_0 0
#define AUTO_CAN_Speed_ILL_1 1
#define AUTO_CAN_OutPut  1

typedef struct tag20Lv{
	unsigned int value;
}ST_BACK_LIGHT_20Lv;

typedef struct tagBacklight{
	ST_BACK_LIGHT_20Lv stHigh[21];
	ST_BACK_LIGHT_20Lv stLow[21];
}ST_BACK_LIGHT;

typedef struct tagAutoConfig {
    unsigned char AUTO_STEP0_APPLY; //�Լ�:���ļ��
    unsigned char AUTO_STEP1_APPLY; //�Լ�:��Ӳ���汾�Ŷ�ȡ 
    unsigned char AUTO_STEP2_APPLY; //�Լ�:Trip SW1 Ӳ�߼��
    unsigned char AUTO_STEP3_APPLY; //�Լ�:Trip SW2 Ӳ�߼��
    unsigned char AUTO_STEP4_APPLY; //�Լ�:������״̬Ӳ�߼��
    unsigned char AUTO_STEP5_APPLY; //�Լ�:��λP R N D S Ӳ�߼��
    unsigned char AUTO_STEP6_APPLY; //�Լ�:GND Signal3 Ӳ��������
    unsigned char AUTO_STEP7_APPLY; //�Լ�:Rheo ���� Ӳ��������
    unsigned char AUTO_STEP8_APPLY; //�Լ�:Detent Ӳ��������
    unsigned char AUTO_STEP9_APPLY; //�Լ�:��ʻģʽӲ�߼��
    unsigned char AUTO_STEP10_APPLY; //�Լ�:���� Ƶ�� ILL Ӳ��������
    unsigned char AUTO_STEP11_APPLY; //�Լ�:�ⷢ
}ST_AUTO_CFG;

typedef struct tagVehicleConfig {
    unsigned char  szProName[14];    //��Ŀ���ƣ����̨������ʾ,һ����Ŀ������ʾ��ͬ������ʵ����ʾ����������ȼ��������ʾ
    unsigned char  ucProName;        //��Ŀ���ƣ���Ŀ��ֵ�����ڲ�ʹ�ã�ÿ����ĿΨһ���������ֲ�ͬ��Ŀ
    unsigned char  ucVehicleType;    //�Ǳ�ȼ������ 0 ICV 1 EV 2 HEV 3 PHEV 4 FCEV
    unsigned char  ucPartNumber[11]; //�Ǳ�Ʒ��(�����)
    ST_AUTO_CFG*   ucAUTO;           //�Ǳ��Լ�
    unsigned char  ucCluType;        //�Ǳ���ǰƷ������:���е��� 0 SVC_CFG  1 MID_CFG 2 MID_CFG
    unsigned char  ucBvmSupport;     //�Ǳ���ǰƷ���Ƿ�֧�ֵ���Ͷ��(BVM)0 Not Support 1 Support
    unsigned char  ucHaveSportPlus;  //�Ǳ���ʻģʽ��Sport+ģʽ
    unsigned char  ucRESERVE2;       //Ԥ�����壬��Ҫʱ��չʹ��
    unsigned char  ucReserve3;       //Ԥ�����壬��Ҫʱ��չʹ��
}ST_VEHICLE_CFG;
extern ST_AUTO_CFG g_AutoConfig;
extern unsigned char g_VehicleType;
extern unsigned char CheckPartNumber(unsigned char *pPartNum);
extern unsigned char GetVehicleType(unsigned char *pPartNum);
extern unsigned char *GetProjectName(unsigned char *pPartNum);
extern unsigned char IsSupportBVM(void);
extern unsigned char IsHaveSportPlus(void);
extern unsigned char IsHaveDBC(void);
extern unsigned char IsHaveFcaRed(void);
extern unsigned char IsHaveHBA_WHITE(void);
extern unsigned char IsHaveMph(void);
extern unsigned char GetCluType(void);
extern unsigned char JudgePartNum(void);

#define PRO_CONFIG_CHECK_APPLY  1 //���̨����       ��Ҫ����Ϊ1 ,��������Ϊ0
#define PRO_CONFIG_EOL_APPLY    0 //EOL���ó���      ��Ҫ����Ϊ1 ,��������Ϊ0
#define PRO_CONFIG_SCAN_APPLY   0 //��װɨ�����ó��� ��Ҫ����Ϊ1 ,��������Ϊ0
#define HARD_WARE_VERSION_2_1_7 1 //���̨Ӳ���汾2.1.7
#define HARD_WARE_VERSION_2_2_0 0 //���̨Ӳ���汾2.2.0
#define HARD_WARE_VERSION_2_3_0 0 //���̨Ӳ���汾2.3.0
#if (PRO_CONFIG_EOL_APPLY)
typedef struct tagPos{
    unsigned short uiX;
    unsigned short uiY;
}ST_POS;
#define PER_PAGE_MAX_NUM 36
#define PER_ROW_NUM 3
#define PER_COL_NUM 12
#endif

#define JLINK_DEBUG_MODE   1 //����Jlink���Է���

#define DEBUG_CONFIG1       0 //���԰汾����,��׷�ݹ���,����ֹ��ܼ��
#define DEBUG_CONFIG2       0 //���԰汾����,��׷�ݹ���,�������

#define RELEASE_CONFIG1    1 //�ͷŰ汾����,������,��׷�ݹ���,������
#define RELEASE_CONFIG2    0 //�ͷŰ汾����,������,��׷�ݹ���,�������

#define RELEASE_CONFIG3    0 //�ͷŰ汾����,������,��׷�ݹ���,������
#define RELEASE_CONFIG4    0 //�ͷŰ汾����,������,��׷�ݹ���,�������

#define FALSE_CONFIG       0 //(��ɨ��)�ͷŰ汾����


#if DEBUG_CONFIG1
#define NOBARCODE_CHECK      1 //ɨ���Ƿ��� 1  ������  0 ���� 
#define QR_CODE_TRACE_FLAG   0 //�׿Ƕ�ά��׷�ݹ��� 0 �رգ�1����
#define SEMI_AUTOMATIC_STAGE 0 //������⿪�� 0 �ఴ��  1������
#endif

#if DEBUG_CONFIG2
#define NOBARCODE_CHECK      1 //ɨ���Ƿ��� 1  ������  0 ���� 
#define QR_CODE_TRACE_FLAG   0 //�׿Ƕ�ά��׷�ݹ��� 0 �رգ�1����
#define SEMI_AUTOMATIC_STAGE 1 //������⿪�� 0 �ఴ��  1������
#endif

#if RELEASE_CONFIG1
#define NOBARCODE_CHECK      0 //ɨ���Ƿ��� 1  ������  0 ����  
#define QR_CODE_TRACE_FLAG   1 //�׿Ƕ�ά��׷�ݹ��� 0 �رգ�1����
#define SEMI_AUTOMATIC_STAGE 0 //������⿪�� 0 �ఴ��  1������
#endif

#if RELEASE_CONFIG2
#define NOBARCODE_CHECK      0 //ɨ���Ƿ��� 1  ������  0 ����  
#define QR_CODE_TRACE_FLAG   1 //�׿Ƕ�ά��׷�ݹ��� 0 �رգ�1����
#define SEMI_AUTOMATIC_STAGE 1 //������⿪�� 0 �ఴ��  1������
#endif

#if RELEASE_CONFIG3
#define NOBARCODE_CHECK      0 //ɨ���Ƿ��� 1  ������  0 ����  
#define QR_CODE_TRACE_FLAG   0 //�׿Ƕ�ά��׷�ݹ��� 0 �رգ�1����
#define SEMI_AUTOMATIC_STAGE 0 //������⿪�� 0 �ఴ��  1������
#endif

#if RELEASE_CONFIG4
#define NOBARCODE_CHECK      0 //ɨ���Ƿ��� 1  ������  0 ����  
#define QR_CODE_TRACE_FLAG   0 //�׿Ƕ�ά��׷�ݹ��� 0 �رգ�1����
#define SEMI_AUTOMATIC_STAGE 1 //������⿪�� 0 �ఴ��  1������
#endif

#if FALSE_CONFIG
#define NOBARCODE_CHECK    0 //ɨ���Ƿ��� 1  ������  0 ����
#define QR_CODE_TRACE_FLAG 0 //�׿Ƕ�ά��׷�ݹ��� 0 �رգ�1����
#endif

#define SupportPartNum(partnum)  (strcmp(CluPartNum,partnum) == 0)



//����CAN����>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//����ƽ̨��
#define PRO_QXI        1
#define PRO_QX23       0
#define PRO_LX2        0
#define PRO_SK3_PE     0
#define PRO_AX         0
#define PRO_KY         0
#define PRO_SP2        0
#define PRO_ONPE       0
#define PRO_TAM        0
#define PRO_BR2        0
#define PRO_KS         0
#define PRO_CN7        0
#define PRO_BL7M       0
#define PRO_BL7R       0
#define PRO_BN7R       0
#define PRO_PDEPE2     0
#define PRO_SU2IFL     0
#define PRO_JAPE2      0
#define PRO_AC3_PE     0
#define PRO_YB_PE      0
#define PRO_AI3        0
#define PRO_BN7I       0
#define PRO_SU2ID      0
#define PRO_SU2ID_FL   0
#define PRO_BC3        0
#define PRO_SU2BFL     0
//----------------------------------------------------
//����ƽ̨��
#define PRO_NUPE       0
#define PRO_KU         0
#define PRO_SQFL       0
#define PRO_CN7C       0
#define PRO_SP2C_PE    0
#define PRO_QYC        0
#define PRO_BDC_PE     0
#define PRO_DL3C       0
//����CAN����<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<


//����CAN����>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//����ƽ̨��
#define PRO_NQ5        0 
#define PRO_SG2        0
#define PRO_US4        0
#define PRO_GL3        0 
//----------------------------------------------------
//����ƽ̨��
#define PRO_NQ5C       0
#define PRO_NU2        0
#define PRO_NX4C       0
//����CAN����<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<


enum {
    PartNum_KS,
    PartNum_KS_23MY,
    PartNum_KY,
    PartNum_KY_23MY,
    PartNum_NQ5,
    PartNum_NQ5_24MY,
    PartNum_SG2,
    PartNum_SG2_24MY,
    PartNum_NQ5C,
    PartNum_NQ5C_Outlet,
    PartNum_SP2,
    PartNum_SP2I,
    PartNum_AX_PE,
    PartNum_AX
};

#if (PRO_QXI)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.03"
//#if (SEMI_AUTOMATIC_STAGE)
//#define RELEASE_DATE_TIME "2023/04/15  16:00:00"
//#else
#define RELEASE_DATE_TIME "2025/01/10  00:00:00"
//#endif

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 2000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_LX2)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 1
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.7"
#define RELEASE_DATE_TIME "2023/07/14  15:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x78 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_SK3_PE)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.4"
#define RELEASE_DATE_TIME "2023/07/13  15:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_NQ5)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 0
#define CAN_2P5 0
#define CAN_3RD 1

#define RELEASE_VERS      "V2.2.5"
#define RELEASE_DATE_TIME "2023/06/14  11:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S 250
#define BackLightValue_LV12_E 310

#define BackLightValue_LV18_S 680
#define BackLightValue_LV18_E 730
//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x29 //����������
#define SOC_MIDDLE   0x65 //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD8 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_SG2)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 0
#define CAN_2P5 0
#define CAN_3RD 1

#define RELEASE_VERS      "V2.1.8"
#define RELEASE_DATE_TIME "2023/07/14  10:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0xD //����������
#define SOC_MIDDLE   0x58 //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif

#if (PRO_TAM)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.5"
#define RELEASE_DATE_TIME "2023/09/11  16:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x78 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_AX)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.8"
#define RELEASE_DATE_TIME "2023/09/05  10:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_KY)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.8"
#define RELEASE_DATE_TIME "2023/09/26  17:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  11
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_US4)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 0
#define CAN_2P5 0
#define CAN_3RD 1

#define RELEASE_VERS      "V2.1.9"
#define RELEASE_DATE_TIME "2023/10/10  9:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x1 //����1��
#define SOC_MIDDLE   0x55 //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD8 //ˮ���е�
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_KS)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0
#define KS_LOCAL 1  //������1 ������0

#define RELEASE_VERS      "V2.2.3"
#define RELEASE_DATE_TIME "2023/10/28  17:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 240

#define FREQ_LV18_S 263
#define FREQ_LV18_E 468

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_BR2)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.1"
#define RELEASE_DATE_TIME "2023/07/17  11:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 102
#define FREQ_LV12_E 142

#define FREQ_LV18_S 234
#define FREQ_LV18_E 290

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������


#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif

#if (PRO_SP2)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.0.7"
#define RELEASE_DATE_TIME "2023/07/14  09:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12 
#define SPEED_MAX_SP2I  13 
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif

#if (PRO_ONPE)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 1
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.6"
#define RELEASE_DATE_TIME "2023/02/22  11:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_GL3)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 0
#define CAN_2P5 0
#define CAN_3RD 1

#define RELEASE_VERS      "V2.1.3"
#define RELEASE_DATE_TIME "2023/03/27  16:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 0 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 1 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x29 //����������
#define SOC_MIDDLE   0x65 //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif

#if (PRO_QX23)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.7"
#define RELEASE_DATE_TIME "2023/07/14  13:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_NUPE)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 1
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.1"
#define RELEASE_DATE_TIME "2022/12/28 15:00:00"

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x8A //ˮ��1��
#define TEMP_SEG6     0x9B //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_KU)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 1
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.2"
#define RELEASE_DATE_TIME "2023/12/02 17:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_NQ5C)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 1
#define CAN_2ND 1
#define CAN_3RD 0

#define RELEASE_VERS      "V2.0.6"
#define RELEASE_DATE_TIME "2024/01/18 14:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x86 //ˮ��1��
#define TEMP_SEG6     0xD9 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 16
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   2
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_BL7M)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.3"
#define RELEASE_DATE_TIME "2023/08/10 10:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x77 //ˮ��1��
#define TEMP_SEG6     0xD6 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 16
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif



#if (PRO_CN7C)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 1
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.4"
#define RELEASE_DATE_TIME "2023/10/12 10:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������
#define TEMP_EMPTY_SVC    0x00 //ˮ�¿յ�
#define TEMP_SEG1_SVC     0x86 //ˮ��1��
#define TEMP_SEG6_SVC     0xD9 //ˮ��6��
#define TEMP_FULL_SVC     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 16
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   2
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif

#if (PRO_SQFL)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 1
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.0.1"
#define RELEASE_DATE_TIME "2022/10/04  10:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x86 //ˮ��1��
#define TEMP_SEG6     0xD9 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12  //ʽ��ȡ��20����������̶�Ϊ0��Ĭ��12��
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 16000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_PDEPE2)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.2"
#define RELEASE_DATE_TIME "2023/02/11 12:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  11
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_BN7R)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_3RD 0

#define RELEASE_VERS      "V2.0.0"
#define RELEASE_DATE_TIME "2022/09/29  20:50:00"

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_BL7R)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.0.2"
#define RELEASE_DATE_TIME "2023/07/13  14:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_SU2IFL)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.5"
#define RELEASE_DATE_TIME "2023/09/25 12:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_SP2C_PE)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.5"
#define RELEASE_DATE_TIME "2023/06/16  15:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value


//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_JAPE2)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.6"
#define RELEASE_DATE_TIME "2023/07/22  11:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define CUNT_DOWN_TIME 120000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_NU2)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 0
#define CAN_2P5 0
#define CAN_3RD 1

#define RELEASE_VERS      "V2.1.8"
#define RELEASE_DATE_TIME "2023/10/16  16:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value
//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x86 //ˮ��1��
#define TEMP_SEG6     0xD9 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������
#define TEMP_EMPTY_STD    0x00 //ˮ�¿յ�
#define TEMP_SEG1_STD     0x76 //ˮ��1��
#define TEMP_SEG6_STD     0xD5 //ˮ��6��
#define TEMP_FULL_STD     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   2
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_AC3_PE)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.1.6"
#define RELEASE_DATE_TIME "2023/07/17  16:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x46 //����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  11
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 4000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_YB_PE)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 1
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.1"
#define RELEASE_DATE_TIME "2023/04/12  14:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S 250
#define BackLightValue_LV12_E 310

#define BackLightValue_LV18_S 680
#define BackLightValue_LV18_E 730

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x70 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_AI3)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.6"
#if (SEMI_AUTOMATIC_STAGE)
#define RELEASE_DATE_TIME "2023/04/15  16:00:00"
#else
#define RELEASE_DATE_TIME "2023/07/15  09:00:00"
#endif

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//CNG�ź�ֵ
#define CNG_EMPTY    0x00 //CNG�յ�
#define CNG_SEG1     0xc //CNG1��
#define CNG_SEG6     0x74 //CNG6��
#define CNG_FULL     0xFF //CNG����
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  11
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_CN7)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.1.0"
#define RELEASE_DATE_TIME "2023/05/07  14:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//�����ź�ֵ
#define SOC_EMPTY1    0x00 //�����յ�
#define SOC_WARNING1  0x1 //����������
#define SOC_MIDDLE1   0x55 //�����е�
#define SOC_FULL1     0xB7 //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_BN7I)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.4"
#define RELEASE_DATE_TIME "2023/11/14  14:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_SU2ID)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.0.1"
#define RELEASE_DATE_TIME "2023/07/17  15:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x7E //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_QYC)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.9"
#define RELEASE_DATE_TIME "2023/12/27  19:30:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x76 //ˮ�¿յ�
#define TEMP_SEG1     0x7E //ˮ��1��
#define TEMP_SEG6     0xD9 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������
#define TEMP_FULL_UP     0xE6 //ˮ������4.5

#define TEMP_EMPTY_SVC    0x00 //ˮ�¿յ�
#define TEMP_SEG1_SVC     0x86 //ˮ��1��
#define TEMP_SEG6_SVC     0xD9 //ˮ��6��
#define TEMP_FULL_SVC     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_NX4C)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 0
#define CAN_2P5 0
#define CAN_3RD 1

#define RELEASE_VERS      "V1.0.0"
#define RELEASE_DATE_TIME "2023/03/21  15:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//�����ź�ֵ
#define SOC_EMPTY    0x00 //�����յ�
#define SOC_WARNING  0x29//����������
#define SOC_MIDDLE   0x6E //�����е�
#define SOC_FULL     0xB7 //��������
#define SOC_EMPTY_SVC    0x00 //�����յ�
#define SOC_WARNING_SVC  0x46//����������
#define SOC_MIDDLE_SVC   0x6E //�����е�
#define SOC_FULL_SVC     0xBE //��������
//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x82 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define SPEED_MAX_HEV 11
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_BC3)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.0.4"
#define RELEASE_DATE_TIME "2023/07/14  15:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_BDC_PE)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 1
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V2.0.0"
#define RELEASE_DATE_TIME "2022/12/27 15:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������
#define TEMP_EMPTY_SVC    0x00 //ˮ�¿յ�
#define TEMP_SEG1_SVC     0x86 //ˮ��1��
#define TEMP_SEG6_SVC     0xD9 //ˮ��6��
#define TEMP_FULL_SVC     0xE1 //ˮ������

#define SPEED_MAX  12
#define DMS_MODE_INIT_VALUE  60

#define DEFAULT_BACKLIGHT_VALUE 16
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   2
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_SU2BFL)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.0"
#define RELEASE_DATE_TIME "2023/06/07  10:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S BackLight_Limit_Down[12]
#define BackLightValue_LV12_E BackLight_Limit_UP[12]

#define BackLightValue_LV18_S BackLight_Limit_Down[18]
#define BackLightValue_LV18_E BackLight_Limit_UP[18]

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x76 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_DL3C)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.4"
#define RELEASE_DATE_TIME "2023/09/27  10:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x78 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   2
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#if (PRO_SU2ID_FL)
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#define LOCAL 0
#define CAN_2ND 1
#define CAN_2P5 0
#define CAN_3RD 0

#define RELEASE_VERS      "V1.0.1"
#define RELEASE_DATE_TIME "2023/10/06  9:00:00"

#define PRO_CONFIG_CHECK_APPLY_TYPE1 1 //��׼���̨
#define PRO_CONFIG_CHECK_APPLY_TYPE2 0 //��ؼ���̨�������

#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   1
#define FUNCTION_KEY_SPEED_DOWN 1
#define FUNCTION_KEY_LED        1
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   1
#define FUNCTION_KEY_TFT_UP     1
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       1
#endif

#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
#define FUNCTION_KEY_AUTO       1
#define FUNCTION_KEY_EOL        1
#define FUNCTION_KEY_END        1
#define FUNCTION_KEY_SPEED_UP   0
#define FUNCTION_KEY_SPEED_DOWN 0
#define FUNCTION_KEY_LED        0
#define FUNCTION_KEY_IOL_UP     1
#define FUNCTION_KEY_IOL_DOWN   0
#define FUNCTION_KEY_TFT_UP     0
#define FUNCTION_KEY_TFT_DOWN   1
#define FUNCTION_KEY_ELSE       0
#endif

#define FREQ_LV12_S 121
#define FREQ_LV12_E 161

#define FREQ_LV18_S 263
#define FREQ_LV18_E 303

#define BackLightValue_LV12_S g_st20Level[g_BackLightNum].stHigh[12].value
#define BackLightValue_LV12_E g_st20Level[g_BackLightNum].stLow[12].value

#define BackLightValue_LV18_S g_st20Level[g_BackLightNum].stHigh[18].value
#define BackLightValue_LV18_E g_st20Level[g_BackLightNum].stLow[18].value

//ˮ���ź�ֵ
#define TEMP_EMPTY    0x00 //ˮ�¿յ�
#define TEMP_SEG1     0x78 //ˮ��1��
#define TEMP_SEG6     0xD5 //ˮ��6��
#define TEMP_FULL     0xE1 //ˮ������

#define SPEED_MAX  13
#define DMS_MODE_INIT_VALUE  60
#define DEFAULT_BACKLIGHT_VALUE 12
#define CLUSTER_START_TIME 8000
#define DMS_PREPARE_TIME 4000
#define BVM_STEP_NUM   0
#define PDWLV_STEP_NUM 1
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#endif
#pragma pack()
#endif//__PROJECT_CONFIG_H__
