#define  GLOBALS_API_SCI
#include "../App_Headers/includes.h"

/*-------------------------------------------------------------------------
* Function Name  : Api_SCI_Init
* Description    : SCIģʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_SCI_Init(void)
{
    SCICR1_LOOPS   = Disable;   //ģʽ
    SCICR1_SCISWAI = Enable;    //ֹȴģʽ
    SCICR1_M       = Disable;   //8 byte ģʽ
    SCICR1_WAKE    = Enable;    //Adrress Wake
    SCICR1_PE      = Disable;   //ֹУ
    SCISR1_RDRF    = Disable;

    SCIACR1_RXEDGIE = Disable;  //
    SCIACR1_BERRIE  = Disable;
    SCIACR1_BKDIE   = Disable;
    SCIACR2 = Disable;

    SCIBDH_TNP     = div4;
/*
When IREN = 0 then,
SCI baud rate = SCI bus clock / (16 x SBR[12:0])
When IREN = 1 then,
SCI baud rate = SCI bus clock / (32 x SBR[12:1])
*/
    SCIBDH_IREN    = Disable;   //ֹ
    SCIBD_SBR      = 20;//baud_38400;

    SCICR2_TIE  = Disable;
    SCICR2_TCIE = Disable;
    SCICR2_ILIE = Disable;
    SCICR2_RE  = Enable;    //ʹܽ
    SCICR2_TE  = Enable;    //ʹܷ
    SCICR2_RWU = Disable;
    SCICR2_SBK = Disable;   //ʹܷ
  
    SCICR2_RIE = Enable;    //ʹܽж
}
/*-------------------------------------------------------------------------
* Function Name  : Api_SCI_Trans_Bytes
* Description    : ڷ
* Input          : INT8U *str,INT16U len
* Output         : None
* Return         : None
* onther         : str:ַ   len:ݳ
--------------------------------------------------------------------------*/
void Api_SCI_Trans_Bytes(INT8U *str,INT8U len)
{
    INT8U i;    
    for(i=0;i<len;i++)
    {
       Api_SCI_Trans_Byte((*str));
       str++;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Api_SCI_Trans_Byte
* Description    : ڷ
* Input          : INT8U data
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void  Api_SCI_Trans_Byte(INT8U data)
{
    while(SCISR1_TDRE == null);
    SCIDRL = data;
    while(!SCISR1_TC);    
}
/*-------------------------------------------------------------------------
* Function Name  : Api_SCI_Rev_isr
* Description    : ڽж
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void Api_SCI_Rev_isr(void)
{    

    if(SCISR1_RDRF == one)
    {     
        SCIRV[rvcnt] = SCIDRL;
        rvcnt ++;    
        if((SCIRV[0]==0xEB)&&(SCIRV[1]==0x90))
        {                    
            if(SCIRV[rvcnt-1]==0xAA)
            {   
                if((SCIRV[rvcnt-2]==0x55)&&(rvcnt >=126))
                {
                    rvcnt   = null;
                    CarFlag.FlagBits.RS232RV_Full = Enable;
                }
            }       
        }
    }
    if(SCIRV[0] !=0xEB)
    {
        rvcnt = null;
    }
    if(rvcnt >= SCI_LEN) 
    {
        rvcnt = null;
    }
    SCISR1_RDRF = ClearFlag;
}