#define  GLOBALS_BSP_SYS
#include "../app_Headers/g_includes.h"

/*-------------------------------------------------------------------------
* Function Name  : bsp_Sys_Init
* Description    : ϵͳ��ʼ��
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void bsp_Sys_Init(void)
{
   DisableInterrupts;
   bsp_Clock_Init(); 
   bsp_GPIO_Init();
   bsp_CAN_Init();   
   bsp_Timer0_Init(TPM_DIV1);     
   bsp_SCI_Init();
   bsp_LCD_Init();
   Api_API_Init(1);   
   EnableInterrupts;
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_Clock_Init
* Description    : ϵͳʱ�ӳ�ʼ��
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void bsp_Clock_Init(void)
{
    INT32U    dwTime = null;
    MODE      = NormalChip;
    DIRECT    = InitDIRECT;           //��ʼ��ֱ��ҳ�Ĵ���
    IVBR      = InitIVBR;             //��ʼ���ж���������ַ
    CPMUOSC_OSCE   = Enable;                //ʹ���ⲿ����
    while(!CPMUFLG_UPOSC)                   //�ȴ����ȶ�
    {
        dwTime++;
        if(dwTime > 10000)
        {
            dwTime = null;
            break;
        }
    }
    ECLKCTL_NECLK  = Enable;               //��ֹECLK���
    CPMUPROT       = InitCPMUPROT;         //��ֹʱ�ӱ���   
    CPMUREFDIV     = InitCPMUREFDIV;       //���÷�Ƶϵ��
    CPMUSYNR       = InitCPMUSYNR;         //���ó�ϵ��
    CPMUPOSTDIV    = InitCPMUPOSTDIV;      //���÷�Ƶ����
    CPMUPLL        = InitCPMUPLL;          //PLLƵ�ʵ���
    CPMUCOP        = InitCPMUCOP;               //�������Ź�
    CPMUCLKS       = InitCPMUCLKS;         //��ֹͣģʽ�������� ѡ��PLLʱ��
    CPMUCLKS_PLLSEL = Enable;
                
    CPMUOSC_OSCE   = Enable;               //ʹ���ⲿ����
    while(!CPMUFLG_UPOSC)                  //�ȴ����ȶ�
    { 
       dwTime++;
       _FEED_COP();
       if(dwTime > 10000)
       {
           dwTime = null;
           break;
       }
    }
    CPMUCLKS_PSTP  = Enable;               //αֹͣģʽ
    CPMUCLKS_RTIOSCSEL = Enable;           //RTI STOP MODE �������� 
    CPMUCLKS_PRE   = Enable;               
    CPMUCLKS_COPOSCSEL = !Enable;           //COP STOP MODE ���� 
    CPMUCLKS_PCE   = !Enable; 
    
    CPMUPROT       = Enable;               //ʹ��ʱ�ӱ���
    CPMUHTCTL      = Disable;              //�¶ȱ�����ֹ
    //�ж�
    CPMUINT_OSCIE  = Disable;              //Osc
    CPMUINT_LOCKIE = Disable;              //Lock
    //RTI
    CPMURTI_RTDEC  = True;                 //ʮ����
    CPMURTI_RTR    = 0x57;                   //400*10^3 0X57 4M  0x5F 8M  800 *10^4
    
    CPMUINT_RTIE   = Enable;               //RTI  
    CPMULVCTL_LVIE = Disable;              //LV
    IRQCR          = Disable;              //IRQ  
    
    


}



 //===========================================
//
//===========================================
void GJ_CS10_JS_ECUOUT_N(void)
{
    INT16U m16;  

    m16=973/g_runStep;  //8hz   	
    //m16=469/g_runStep;  //16.6hz 
    //m16=78/g_runStep;  //100hz 
    //m16=156/g_runStep;  //50hz
    //m16=7812/g_runStep;  //1hz 
    
    CS_FR_BASIC= ((INT32U)695*8*10)/3600;
    
    //glz--20170428  ����PWM
     if(g_FRStep==0) 
      {
        CS_FR = 7812;
      }
      if(g_FRStep==1) 
      {
        CS_FR = 200;//156Hz
      }
      if(g_FRStep==2) 
      {
        CS_FR = 102;//312Hz
      }  
      if(g_FRStep==3) 
      {
        CS_FR = 68;//468Hz
      }  
      if(g_FRStep==4) 
      {
        CS_FR = 50;//624Hz
      }  
      if(g_FRStep==5) 
      {
        CS_FR = 50;//83Hz
      }  
      if(g_FRStep==6) 
      {
        CS_FR=44;//6000
      }  
      if(g_FRStep==7) 
      {
        ZS_FR=39;//7000
      }  
      if(g_FRStep==8) 
      {
        ZS_FR=39;//8000
      }    
      if(g_FRStep==9) 
      {
        // CS_FR=30; //160KM
        // ZS_FR=52;//9000
      }   
      if(g_FRStep==10) 
      {
        // CS_FR=30; //160KM
        // ZS_FR=45;//9000
      }  
          
    cli();     
    CS_OUT_N=CS_FR;
    ZS_OUT_N=ZS_FR; 
    sei();    
}         



#pragma    CODE_SEG    NON_BANKED    
interrupt void bsp_API_isr(void)
{    
    //    INT16U mTIME;
        CPMUAPICTL_APIF=1;	
        
                

        if(CS_OUT_N)                 
        {
            if(++CS_OUT_CC>=CS_OUT_N)                // 64US 
            {
                
                CS_OUT_CC=0;
                CS_PWM_OUT=!CS_PWM_OUT;	
                
            }
        }  
        
        //glz--20170428
        if(ZS_OUT_N)                 
        {
                if(++ZS_OUT_CC>=ZS_OUT_N)                // 64US 
                {
                ZS_OUT_CC=0;
                
                ZS_PWM_OUT=!ZS_PWM_OUT;	
                }
        } 
        
        
                //		���ٱ�
        CZBTIME0_6MSCCFF=!CZBTIME0_6MSCCFF;
        if(CZBTIME0_6MSCCFF)                                                       //��Ӧ����128us��
        {

                if(++iTIME1MS==8)		//1.024MS
                {
                        T1MS_F1_FF=1;			//1MS��־(����ˮ�ͱ��߶�)   
                        iTIME1MS=0;
                        iTIME2MS=!iTIME2MS;
                        if(iTIME2MS)
                        {
                                T2MS_F2_FF=1;       //2MS��־(���ڳ��ٱ��������峬�����)
                                T2MS_F9_FF=1;       //2MS��־(����ʱ���־) 
                        }  
         
                }	

  
        }
}


  #pragma CODE_SEG DEFAULT
//-------------------------------------------------------------------------------
void Api_API_Init(INT8U tog)
{   
    //���������ж�ʱ��
    CPMUAPICTL_APICLK=1;         //Bus Clock ��Ϊ ���������жϵ�ʱ��Դ   
   
    CPMUAPIR=255;   			//���������ж�����=2*(1023+1)*(1/32M)=64US      +++++++++  
   
    CPMUAPICTL_APIFE=1;			//ʹ�����������жϹ���,����ʼ��ʱzheg
    
    //-----------------------------	//306ҳ
    if(tog)  	CPMUAPICTL_APIE=1;           //�����������ж�
   
    else   	CPMUAPICTL_APIE=0;           //�����������ж�
}




