#define  GLOBALS_APP_TEST
#include "../App_Headers/includes.h"
#include "../Library/TimeCtrl.h"
#include "../App_Headers/ConfigSet.h"

#define STEP_MAX        9



void All_Lamp_TurnOn(void);

void APP_Test_Init(void){
    Key.StepAuto = null;
    Key.CAN_Step = null;
    Key.CAN_Step = null;

    // CAN_ListRT2[VSpeed].val = 22;
    //         CAN_ListRT2[VSpeed].fval = Value_Plus; 
    //CurValueStr[ENUM_BatteryCurrent].val = 0;
    // //CurValueStr[CoolTemp].val = 0;
    // CurValueStr[VehSpeed].val = 0;
    // //CurValueStr[AD_Blue].val = 0;

    // CurValueStr[VehSpeed].fval = Value_Plus;
    //CurValueStr[CoolTemp].fval = Value_Plus;
    //CurValueStr[VehSpeed].fval = Value_Plus;
    //CurValueStr[AD_Blue].fval = Value_Plus;

    //CanMessageID18F00029.Msg[1] = 0x7D;

    //LDW Open
    //CanMessageID18FE5BE8.Msg[0] |= 0x40;
    //FCW Open
   // CanMessageID0CF02FA0.Msg[0] |= 0x03;
    //AutoLwBm Open
  //  CanMessageID18FF0B21.Msg[5] |= 0x10;

    EOLMode = 1;
    EOLStep = 0;
    EOLError = 0;
}

void APP_Button_Proc(void){
    /*if(Key.PushTime_1 > T_3s){
        Key.StepAuto = 1;
    }
    if(Key.PushTime_2 > T_3s){
        Key.StepAuto = 2;
    }*/      
    
    if((Key.PushTime_2 > T_3s) && (Key.PushTime_1 > T_3s)){
        Key.StepAuto = 1;
        Key.StepAutodir = 0;
    }
    
    if(pSB1 == 1){
        if((Key.PushTime_1 > T_50ms) && (!Key.StepAuto)){
            Key.CAN_Step++;
            if(Key.CAN_Step > STEP_MAX){
                Key.CAN_Step = 0;
            }
        }
        Key.PushTime_1 = null;
    }
    
    if(pSB2 == 1){
        if((Key.PushTime_2 > T_50ms) && (!Key.StepAuto)){
            if(Key.CAN_Step > 0){
                Key.CAN_Step--;
            }else{
                Key.CAN_Step = STEP_MAX;
            }
            
        }
        Key.PushTime_2 = null;
    }
}
INT8U LASTSTEP = 0xff;
INT8U Vspeed_Arr[10] = {22,43,63,85,96,134,171,191,199,199};
INT16U Espeed_Arr[10] = {1000,2000,3000,4000,5000,7000,8000,10000,12000,12000};
INT16U Water_Arr[10] = {0,0,35,97,112,125,125,125,125,125};
INT16U TIME_Arr[10] = {18,20,22,0,2,4,6,10,15,16};
void APP_ICM_Proc(void)  /*zh321*/  /*CS08*/
{
   // UDS_Service_Main();
   if(Key.CAN_Step < 10)
   {
    CurValueStrRT2[VSpeed].val = Vspeed_Arr[Key.CAN_Step];
    CurValueStrRT2[VSpeed].fval = Value_Plus; 

    CurValueStrRT2[VSpeed_Status].val = 0;
    CurValueStrRT2[VSpeed_Status].fval = Value_Plus; 

    CurValueStrRT2[ESpeed].val = Espeed_Arr[Key.CAN_Step];
    CurValueStrRT2[ESpeed].fval = Value_Plus;

    CurValueStrRT2[ESpeed_Status].val = 0;
    CurValueStrRT2[ESpeed_Status].fval = Value_Plus;

    CurValueStrRT2[Water_Temp].val = Water_Arr[Key.CAN_Step];
    CurValueStrRT2[Water_Temp].fval = Value_Plus;

    if(Key.CAN_Step == 0)
    {
        CurValueStrRT2[Water_Temp_Status].val = 1;
        CurValueStrRT2[Water_Temp_Status].fval = Value_Plus;
    }
    else
    {
        CurValueStrRT2[Water_Temp_Status].val = 0;
        CurValueStrRT2[Water_Temp_Status].fval = Value_Plus;
    }
    

    CurValueStrRT2[Time_Hour].val = TIME_Arr[Key.CAN_Step];
    CurValueStrRT2[Time_Hour].fval = Value_Plus;

    CurValueStrRT2[Time_Min].val = 0;
    CurValueStrRT2[Time_Min].fval = Value_Plus;

    CurValueStrRT2[Time_Sec].val = 0;
    CurValueStrRT2[Time_Sec].fval = Value_Plus;
   }
    
    switch(Key.CAN_Step)
    {

        case 0:
        {
            // All_Lamp_TurnOn();

            // if(LASTSTEP!= 0)
            // {

            //     Set_Config_2E_Value(0x207, 0x03);
            //     Set_Config_2E_Value(0x208, 0x01);
            //     Set_Config_2E_Value(0x214, 0x02);
            // }
            // CurValueStr[ConsumedPower].val = 175;/*功率表*/
            // CurValueStr[ConsumedPower].fval = Value_Plus;

            //左后方盲区侦测指示灯 he 右后方盲区侦测指示灯
            CurValueStrRT2[LED_SW_Resp].val = 0;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 0;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 0;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 0;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 0;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 0;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;






        }break;
        case 1:
        {   
            CurValueStrRT2[LED_SW_Resp].val = 1;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 1;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 0;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 0;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 0;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 0;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 0;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;

        }break;

        case 2:
        {
           CurValueStrRT2[LED_SW_Resp].val = 0;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 0;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 0;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 0;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 0;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 0;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;
        }break;

        case 3:
        {
            CurValueStrRT2[LED_SW_Resp].val = 0;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 1;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 0;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 0;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 0;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 0;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;
        }break;

        case 4:
        {
            CurValueStrRT2[LED_SW_Resp].val = 0;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 0;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 1;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 0;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 0;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 0;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;
        }break;

        case 5:
        {
           CurValueStrRT2[LED_SW_Resp].val = 0;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 0;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 0;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 1;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 1;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 0;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;
        }break;

        case 6:
        {
            CurValueStrRT2[LED_SW_Resp].val = 0;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 0;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 0;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 0;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 0;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 1;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;
        }break;

        case 7:
        {
             CurValueStrRT2[LED_SW_Resp].val = 1;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 0;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 1;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 0;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 0;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 0;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 0;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 0;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;
        }break;

        case 8:
        {
            
        }break;

        case 9:
        {
            CurValueStrRT2[LED_SW_Resp].val = 1;
            CurValueStrRT2[LED_SW_Resp].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_L2].val = 1;
            CurValueStrRT2[LED_BSD_STATUS_L2].fval = Value_Plus;

            CurValueStrRT2[LED_BSD_STATUS_R].val = 1;
            CurValueStrRT2[LED_BSD_STATUS_R].fval = Value_Plus;

             //边撑指示灯
            CurValueStrRT2[LED_FootBrackeSwSts].val = 1;
            CurValueStrRT2[LED_FootBrackeSwSts].fval = Value_Plus;

            //发动机故障指示灯
            CurValueStrRT2[LED_EMS_MIL].val = 1;
            CurValueStrRT2[LED_EMS_MIL].fval = Value_Plus;

            //ABS故障指示灯
            CurValueStrRT2[LED_ABSWarningLamp].val = 1;
            CurValueStrRT2[LED_ABSWarningLamp].fval = Value_Plus;

            //TCS  NO
            CurValueStrRT2[LED_TCSON].val = 1;
            CurValueStrRT2[LED_TCSON].fval = Value_Plus;

             //TCS  OFF
            CurValueStrRT2[LED_TCSOFF].val = 1;
            CurValueStrRT2[LED_TCSOFF].fval = Value_Plus;
        }break;


        default:
        {
            //Key.CAN_Step = null;
        }break;

        
    }

    LASTSTEP = Key.CAN_Step;
}


void Message_ClearDatas(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char len, unsigned char Format){
    unsigned char pBit, pByte, i;

    pBit = StartBit;
    pByte = StartByte;

    switch(Format){
        case Motorola:{
            for(i = 0; i < len; i++){
                __RESET_WATCHDOG();
                Message->Msg[pByte] &= ~(1 << pBit);
                pBit++;
                if(pBit >= 8){
                    pBit = 0;
                    if(pByte > 0){
                        pByte--;
                    }else{
                        break;
                    }
                }
            }
        }break;

        case Intel:{
            for(i = 0; i < len; i++){
                __RESET_WATCHDOG();
                Message->Msg[pByte] &= ~(1 << pBit);
                pBit++;
                if(pBit >= 8){
                    pBit = 0;
                    if(pByte < 7){
                        pByte++;
                    }else{
                        break;
                    }
                }
            }
        }break;

        default:{
            ;
        }
    }
}

void Message_FillDatas(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char len, unsigned char Format, unsigned long MessageValue){
    unsigned char pBit, pByte, i;

    pBit = StartBit;
    pByte = StartByte;
    MessageValue = MessageValue << pBit;

    switch(Format){
        case Motorola:{
            for(i = 0; i < len; i++){
                __RESET_WATCHDOG();
                Message->Msg[pByte] |= MessageValue & (1 << pBit);
                pBit++;
                if(pBit >= 8){
                    pBit = 0;
                    if(pByte > 0){
                        pByte--;
                        MessageValue = MessageValue >> 8;
                    }else{
                        break;
                    }
                }
            }
        }break;

        case Intel:{
            for(i = 0; i < len; i++){
                __RESET_WATCHDOG();
                Message->Msg[pByte] |= MessageValue & (1 << pBit);
                pBit++;
                if(pBit >= 8){
                    pBit = 0;
                    if(pByte < 7){
                        pByte++;
                        MessageValue = MessageValue >> 8;
                    }else{
                        break;
                    }
                }
            }
        }break;

        default:{
            ;
        }
    }
}



void Message_Value_Calculate(s_CAN_List list)
{

    CAN_message *CanMessage;
    INT8U Start_Byte, Start_Bit, len, Offset_Flag, Format_Flag;
    INT16U Offset, Factor_1, Factor_2, CurValue, Value_Flag;

    INT32U temp;
    INT32U Message_Clear;
    INT8U  Byte_Count;
    INT8U  i;

    CanMessage = list.canMsg;
    Start_Byte = list.StartByte;
    Start_Bit = list.StartBit;
    len = list.SignalLen;
    Offset_Flag = list.fOffset;
    Format_Flag = list.fFormat;
    Offset = list.Offset;
    Factor_1 = list.Factor_1;
    Factor_2 = list.Factor_2;

    CurValue = list.CurValue->val;
    Value_Flag = list.CurValue->fval;



    temp = CurValue;

    //璁＄畻鍋忕Щ锟??
    if(Offset != 0){
        if(Offset_Flag  == Offset_Minus){
            if(Value_Flag == Value_Minus){
                if(temp > Offset){
                    temp = 0;               //閿欒��锛屾墍瑕佸疄鐜扮殑鍊煎皬浜庣墿鐞嗘渶灏忥拷?
                }else{
                    temp = Offset - temp;
                }
            }else if(Value_Flag == Value_Plus){
                temp += Offset;
            }else{;}
        }else if(Offset_Flag  == Offset_Plus){
            if(temp < Offset){
                temp = 0;               //閿欒��锛屾墍瑕佸疄鐜扮殑鍊煎皬浜庣墿鐞嗘渶灏忥拷?
            }else{
                temp -= Offset;
            }
        }
        
    }

    temp = temp * Factor_1 / Factor_2;
    //temp = temp << Start_Bit;

    Byte_Count = len / 8;
    if((len % 8) != 0){
        Byte_Count += 1;
    }

    //娓呰剰鏁版嵁
    Message_ClearDatas(CanMessage, Start_Byte, Start_Bit, len, Format_Flag);
    Message_FillDatas(CanMessage, Start_Byte, Start_Bit, len, Format_Flag, temp);
    
}




void FT_VehSpeedCalc(unsigned char spd){
    unsigned long wTemp;

    wTemp = spd;

    
}


/*zh:*/
/*------------------------------------------------------------------------------------------------
 * function name : Bits_Operation
 * parameter value range : StartByte(0~7)     StartBit(0~7)     Length(1~8)     Value(0~255)
 * notice : Do not span bytes.
 * author : zhouhang
 * date :2022.01.18
--------------------------------------------------------------------------------------------------*/        
void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value)  /*Do not span bytes*/
{
    unsigned char i;
    
    for (i = 0; i < Length; i++)
    {
        Message->Msg[StartByte] &= (~(1 << (i + StartBit)));
    }

    Message->Msg[StartByte] |= (Value << StartBit);
}

/*:zh*/


void All_Lamp_TurnOn(void)
{
    /*福田S1电动 点亮全部指示灯*/
    Bits_Operation(&CanMessageID18FF12EF, 4, 2, 1, 1);/*READY指示灯*/                /*start bit 34, length 1*/
    Bits_Operation(&CanMessageID18FF12EF, 4, 7, 1, 1);/*巡航指示灯*/                 /*start bit 39, length 1*/
    Bits_Operation(&CanMessageID18FF12EF, 5, 0, 1, 1);/*真空度报警灯*/               /*start bit 40, length 1*/
    Bits_Operation(&CanMessageID18F0010B, 5, 4, 2, 1);/*ABS指示灯*/                  /*start bit 44, length 2*/
    Bits_Operation(&CanMessageID18FF13EF, 5, 6, 1, 1);/*高压断开指示灯*/             /*start bit 46, length 1*/
    Bits_Operation(&CanMessageID18FF13EF, 5, 0, 1, 1);/*SOC低指示灯*/                /*start bit 40, length 1*/
    Bits_Operation(&CanMessageID18FF13EF, 6, 0, 2, 3);/*（绿）充电完成指示灯*/       /*start bit 48, length 2*/
    Bits_Operation(&CanMessageID18FF13EF, 6, 0, 2, 1);/*（黄）充电指示灯*/           /*start bit 48, length 2*/
    Bits_Operation(&CanMessageID18FF13EF, 6, 0, 2, 2);/*（红）充电指示灯*/           /*start bit 48, length 2*/
    Bits_Operation(&CanMessageID18FF12EF, 4, 5, 1, 1);/*互锁指示灯*/                 /*start bit 37, length 1*/
    Bits_Operation(&CanMessageID18FF13EF, 5, 7, 1, 1);/*绝缘报警指示灯*/             /*start bit 47, length 1*/
    Bits_Operation(&CanMessageID18FF12EF, 5, 1, 2, 1);/*驱动电机系统故障指示灯*/     /*start bit 41, length 2*/
    Bits_Operation(&CanMessageID18FF13EF, 6, 7, 1, 1);/*降功率显示指示灯*/           /*start bit 55, length 1*/
    Bits_Operation(&CanMessageID18FF12EF, 4, 3, 2, 1);/*系统故障指示灯*/             /*start bit 35, length 2*/
    Bits_Operation(&CanMessageID18FF13EF, 6, 2, 1, 1);/*充电插头接入指示灯*/         /*start bit 50, length 1*/
    Bits_Operation(&CanMessageID18FF12EF, 5, 3, 1, 1);/*电机系统过热指示灯*/         /*start bit 43, length 1*/
    Bits_Operation(&CanMessageID18FF13EF, 5, 2, 1, 1);/*动力电池故障指示灯*/         /*start bit 42, length 1*/
    Bits_Operation(&CanMessageID18FF12EF, 7, 3, 1, 1);/*动力电池热失控预警指示灯*/   /*start bit 59, length 1*/
    Bits_Operation(&CanMessageID18FF13EF, 5, 4, 1, 1);/*动力电池温度过高指示器*/     /*start bit 44, length 1*/
    Bits_Operation(&CanMessageID18FF13EF, 5, 5, 1, 1);/*低压蓄电池电压低指示灯*/     /*start bit 45, length 1*/
    Bits_Operation(&CanMessageID18FF25EF, 4, 4, 2, 1);/*PTO指示灯*/       /*start bit 36, length 2*/
    Bits_Operation(&CanMessageID142FFF95, 5, 0, 2, 1);/*EPS指示灯*/       /*start bit 40, length 2*/
    Bits_Operation(&CanMessageID18F0010B, 5, 6, 2, 1);/*ASR指示灯*/       /*start bit 46, length 2*/
    Bits_Operation(&CanMessageID18F0010B, 5, 2, 2, 1);/*ESC*/       /*start bit 42, length 2*/
    Bits_Operation(&CanMessageID18F0010B, 2, 6, 2, 1);/*ESCOFF*/       /*start bit 22, length 2*/
    Bits_Operation(&CanMessageID18FE5BE8, 6, 0, 4, 2);/*LDWS*/       /*start bit 48, length 4*/
    Bits_Operation(&CanMessageID0CF02FA0, 0, 0, 4, 2);/*AEBS、FCWS*/       /*start bit 0, length 4*/
    
    
}