

#ifdef        GLOBALS_APP_TEST
    #define   EXTERN_APP_TEST
    
#else
    #define   EXTERN_APP_TEST     extern
#endif

#ifndef APP_TEDT_H_
#define APP_TEDT_H_

#define Motorola                0
#define Intel                   1

#define Offset_Minus            0
#define Offset_Plus             1

#define Value_Minus             0
#define Value_Plus              1

typedef struct{
    unsigned int val;
    unsigned char fval;
}s_CurValue;

typedef struct{
    CAN_message *canMsg;
    unsigned char StartByte;
    unsigned char StartBit;
    unsigned char SignalLen;
    unsigned int  Offset;
    unsigned char fOffset;
    unsigned int Factor_1;/*Denominator of Resolution*/  /*精度的分母*/
    unsigned int Factor_2;/*Numerator of Resolution*/    /*精度的分子*/
    s_CurValue *CurValue; 
    unsigned char fFormat;
}s_CAN_List;

enum{
    VehSpeed = 0,/*车速表*/
    ConsumedPower ,/*功率表*/
    CellTemp,/*电池温度*/
    SOC,/*SOC*/
    BatteryVoltage,/*电压表*/
    BatteryCurrent,/*电流表*/
    ResidualPower,/*可用剩余功率*/
    RemainDriverRange,/*续航里程*/
    AvgCellVoltage,/*电池最高单体电压*/
    Gear,/*挡位显示*/

    //ENUM_VH,

    CAN_List_Num,
};

EXTERN_APP_TEST volatile s_CurValue CurValueStr[CAN_List_Num];

static const s_CAN_List CAN_List[] = 
{
    {&CanMessageID18FF12EF, 0, 0, 16, 0, Offset_Plus, 1280, 5, &CurValueStr[VehSpeed], Intel},
    {&CanMessageID18FF13EF, 7, 0, 8,  80, Offset_Minus,     1,    1, &CurValueStr[ConsumedPower],    Intel},/*功率表*/      /**/
    {&CanMessageID18FF37EF, 3, 0, 8,  40, Offset_Minus,     1,    1, &CurValueStr[CellTemp],         Intel},/*电池温度*/    /**/
    {&CanMessageID18FF13EF, 4, 0, 8,   0,  Offset_Plus,    10,    4, &CurValueStr[SOC],              Intel},/*SOC*/         /**/
    {&CanMessageID18FF13EF, 0, 0,16,   0,  Offset_Plus,    10,    1, &CurValueStr[BatteryVoltage],   Intel},/*电压表*/  /*动力电池总电压*/
    {&CanMessageID18FF13EF, 2, 0,16, 400, Offset_Minus,    10,    1, &CurValueStr[BatteryCurrent],   Intel},/*电流表*/  /*动力电池总电流*/
    {&CanMessageID18FF23EF, 2, 0,16,1000, Offset_Minus,     1,    1, &CurValueStr[ResidualPower],    Intel},/*可用剩余功率*/  /*可用剩余功率*/
    {&CanMessageID18FF12EF, 6, 0,10,   0,  Offset_Plus,     1,    1, &CurValueStr[RemainDriverRange],Intel},/*续航里程*/          /*剩余可行驶里程*/
    {&CanMessageID18FF37EF, 0, 0, 8,   0,  Offset_Plus,     1,    2, &CurValueStr[AvgCellVoltage],   Intel},/*电池最高单体电压*/  /*平均单体电压*/
    {&CanMessageID18FF12EF, 4, 0, 2,   0,  Offset_Plus,     1,    1, &CurValueStr[Gear],             Intel},/*挡位显示*/          /*档位状态*/

    

    //{&CanMessageID0CFF7D03, 3, 0, 16,     0,  Offset_Plus, 1000, 1000, &CurValueStr[ENUM_VH],             Intel},/*电池最高单体电压/VH*/  /*电池最高单体电压*/  /*为了表示4.888,将精度乘1000*/
    
};

enum{
    VSpeed = 0,/*车速表*/
    VSpeed_Status ,/*车速表有效值*/
    ESpeed ,/*转速表*/
    ESpeed_Status ,/*转速表有效值*/
    Water_Temp,/*水温表*/
    Water_Temp_Status,/*水温表有效值*/
    Time_Hour,/*时间*/
    Time_Min,/*时间*/
    Time_Sec,/*时间*/
    LED_SW_Resp,/*左后方盲区侦测指示灯*/
    LED_BSD_STATUS_L2,/*左后方盲区侦测指示灯*/
    LED_FootBrackeSwSts,/*边撑指示灯*/
    LED_EMS_MIL,/*发动机故障指示灯*/
    LED_ABSWarningLamp,/*ABS故障指示灯*/
    LED_TCSON,/*，TCS  NO*/
    LED_TCSOFF,/*，TCS  OFF*/
    LED_BSD_STATUS_R,/*右后方盲区侦测指示灯*/
    CAN_List_RT2_MAX,
};
EXTERN_APP_TEST volatile s_CurValue CurValueStrRT2[CAN_List_RT2_MAX];


static const s_CAN_List CAN_ListRT2[] = 
{
    {&CanMessageID12B, 1, 0, 16, 0,  Offset_Plus,      160, 9, &CurValueStrRT2[VSpeed], Motorola},
    {&CanMessageID12B, 4, 4, 1, 0,  Offset_Plus,      1, 1, &CurValueStrRT2[VSpeed_Status], Motorola},
    {&CanMessageID110, 3, 0, 16,  0, Offset_Minus,     4,    1, &CurValueStrRT2[ESpeed],    Motorola},
    {&CanMessageID110, 7, 0, 1,  0, Offset_Minus,     1,    1, &CurValueStrRT2[ESpeed_Status],    Motorola},
    {&CanMessageID110, 4, 0, 8,  48, Offset_Minus,     4,    3, &CurValueStrRT2[Water_Temp],         Motorola},
    {&CanMessageID110, 7, 1, 1,  0, Offset_Minus,     1,    1, &CurValueStrRT2[Water_Temp_Status],         Motorola},
    {&CanMessageID421, 3, 0, 8,   0,  Offset_Plus,    1,    1, &CurValueStrRT2[Time_Hour],              Motorola},
    {&CanMessageID421, 4, 0, 8,   0,  Offset_Plus,    1,    1, &CurValueStrRT2[Time_Min],              Motorola},
    {&CanMessageID421, 5, 0, 8,   0,  Offset_Plus,    1,    1, &CurValueStrRT2[Time_Sec],              Motorola},
    {&CanMessageID50A, 0, 1, 1,   0,  Offset_Plus,    1,    1, &CurValueStrRT2[LED_SW_Resp],   Motorola},
    {&CanMessageID50A, 1, 0, 2,   0,  Offset_Plus,    1,    1, &CurValueStrRT2[LED_BSD_STATUS_L2],   Motorola},
    {&CanMessageID200, 1, 7, 1, 0, Offset_Minus,    1,    1, &CurValueStrRT2[LED_FootBrackeSwSts],   Motorola},
    {&CanMessageID111, 0, 3, 1, 0, Offset_Minus,     1,    1, &CurValueStrRT2[LED_EMS_MIL],    Motorola},
    {&CanMessageID12B, 5, 0, 3,   0,  Offset_Plus,     1,    1, &CurValueStrRT2[LED_ABSWarningLamp],Motorola},
    {&CanMessageID51B, 3, 0, 3,   0,  Offset_Plus,     1,    1, &CurValueStrRT2[LED_TCSON],   Motorola},
    {&CanMessageID51B, 2, 2, 4,   0,  Offset_Plus,     1,    1, &CurValueStrRT2[LED_TCSOFF],             Motorola},
    {&CanMessageID50A, 2, 0, 2,   0,  Offset_Plus,     1,    1, &CurValueStrRT2[LED_BSD_STATUS_R],             Motorola},
    

    //{&CanMessageID0CFF7D03, 3, 0, 16,     0,  Offset_Plus, 1000, 1000, &CurValueStr[ENUM_VH],             Intel},/*电池最高单体电压/VH*/  /*电池最高单体电压*/  /*为了表示4.888,将精度乘1000*/
    
};

EXTERN_APP_TEST             void                APP_Button_Proc(void);
EXTERN_APP_TEST             void                Message_Value_Calculate(s_CAN_List list);

void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value);  /*Do not span bytes*/


void APP_ICM_Proc(void) ;




#endif /* API_CAN_H_ */
