#ifndef CAN_CH4_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH4_CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

extern st_CanMsgOp CAN_CH4_CanMsgOp;

extern st_CanMsgTxOp CAN_CH4_CanMsgTxOp;
extern uint8_t count;

typedef enum
{
    CAN_CH4_ID_250_Msg_Count,
    CAN_CH4_ID_450_Msg_Count,
    CAN_CH4_ID_451_Msg_Count,
    CAN_CH4_ID_750_Msg_Count,
    CAN_CH4_ID_TOTAL_MAX,
} CAN_CH4_CAN_MSG_ID_t;

typedef enum
{
    CAN_CH4_ID_200,
    CAN_CH4_ID_481,
    CAN_CH4_ID_020,
    CAN_CH4_ID_042,
    CAN_CH4_ID_480,
    CAN_CH4_ID_280,
    CAN_CH4_ID_202,
    CAN_CH4_ID_001,
    CAN_CH4_ID_021,
    CAN_CH4_ID_284,
    CAN_CH4_ID_786,
    CAN_CH4_ID_207,
    CAN_CH4_ID_SEND_TOTAL,
} CAN_CH4_CAN_MSG_SEND_ID_t;


extern const st_CANMsgAttribute CAN_CH4_CAN_MSG_CONST_ARRAY[CAN_CH4_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH4_CANSendAttr[CAN_CH4_ID_SEND_TOTAL] ;

//小计
extern uint8_t Get_CAN_CH4_ID_450_Trip(void);
//TCS模式设置
extern uint8_t Get_CAN_CH4_ID_250_TCS(void);
//总计
extern uint8_t Get_CAN_CH4_ID_450_Mileage(void);


#define  CAN_CH4_ID_250_Msg    0x250u
#define  CAN_CH4_ID_450_Msg    0x450u
#define  CAN_CH4_ID_451_Msg    0x451u
#define  CAN_CH4_ID_750_Msg    0x750u


extern uint8_t  Co_Can_ConvertSubID_CAN_CH4(uint32_t MsgID);
#endif
