#ifndef KEY_H__
#define KEY_H__

#include "TYW_stdint.h"

typedef enum
{
    KEY_5,
    KEY_6,
    KEY_7,
    KEY_8,
    KEY_9,
    KEY_10,

    KEY_NUM_MAX,
} Key_Num_en_t;

/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
typedef enum
{
    KEY_TYPE_CAN = 0U,
    KEY_TYPE_LINE,

} Key_Type_en_t;

typedef enum
{
    KEY_SET_OK = 0U,
    KEY_SET_ERROR,

    KEY_SET_MAX,
} Key_Set_en_t;

typedef enum
{
    KEY_CAN_NONE = 0U,
    KEY_CAN_SHORT_PRESS,
    KEY_CAN_LONG_PRESS,
    KEY_LINE_PRESS,
    KEY_LINE_LOOSEN,

    KEY_REAL_STATUS_MAX,
} Key_Real_Status_en_t;

typedef enum
{
    KEY_EVENT_NONE = 0U,
    KEY_EVENT_SHORT_PRESS,
    KEY_EVENT_LONG_PRESS,
    KEY_EVENT_SUPER_LONG_PRESS,

    KEY_EVENT_MAX,

} Key_Event_en_t;

typedef Key_Real_Status_en_t (*Key_Real_Status_Read)(void);
typedef void (*Key_Operation)(Key_Event_en_t enKeyEvent);

typedef struct
{
    Key_Type_en_t        enKeyType;
    Key_Real_Status_Read pfnKeyReadStatusCallBack;
    Key_Operation        pfnKeyOperationCallBack;

} Key_Attribute_st_t;

/*--------------------------------------------------------------------------------------------*/
extern const Key_Attribute_st_t stKeyAttribute [ KEY_NUM_MAX ];
extern Key_Real_Status_en_t     enKeyLeftRealStatus;
extern Key_Real_Status_en_t     enKeyRightRealStatus;

/*------------------------------------------------------------------------------------*/
extern uint8_t leftkey;
extern uint8_t leftkeytime;
extern uint8_t rightkey;
extern uint8_t rightkeytime;
extern uint8_t middlekey;
extern uint8_t middlekeytime;
extern void Key_Init(void);
extern void Key_Service(void); /*10ms*/

extern Key_Set_en_t Key_Parameter_Set_Short_Press_Time(uint16_t u16Time);
extern Key_Set_en_t Key_Parameter_Set_Long_Press_Time(uint16_t u16Time);
extern Key_Set_en_t Key_Parameter_Set_Super_Long_Press_Time(uint32_t u32Time);

#endif
