/*
 * RH850_OTA.c
 *
 *  Created on: 2022年7月21日
 */
#include <string.h>
#include "rh850_macros.h"
#include "Internal_FCL.h"
#include "Internal_EEPROM.h"
#include "RH850_OTA.h"
#include "../src.h"
#include "../BSP/BSP.h"
typedef void (*InitFunction)(void);
const uint32_t CRC32_Table[256];
_VerifyTCFlash VerifyTCFlash[26];
#define DIM( X ) 

DiagFlagUnion DiagFlag;


//擦除FLASH
uint8_t OTA_FLASH_Erase(uint32_t blockID)
{
    disable_interrupt();
    Internal_FCL_OPEN( );
    Internal_FCL_Init( );
    Internal_FCL_Unlock();
    Internal_FCL_Erase(blockID);
    Internal_FCL_CLOSE();
    enable_interrupt();
    return 0u;
}

void RTE_FCL_OP(void)
{
    disable_interrupt();
    Internal_FCL_OPEN( );
    Internal_FCL_Init( );
    Internal_FCL_Unlock();
    OptionByte_Handle();
    Internal_FCL_CLOSE();
    enable_interrupt();
}

//写FLASH
uint8_t white_flash_buffer[256];
uint8_t OTA_FLASH_Write(uint32_t address, uint8_t data[], uint32_t len)
{
    uint16_t i;
    for(i = 0; i<256; i++)
    {
        white_flash_buffer[i] = 0xFFu;
    }
    for(i = 0; i<len; i++)
    {
        white_flash_buffer[i] = data[i];
    }
    disable_interrupt();
    Internal_FCL_OPEN( );
    Internal_FCL_Init( );
    Internal_FCL_Write(address, white_flash_buffer, 1u);
    Internal_FCL_CLOSE();
    enable_interrupt();
    return 0u;
}

/*读指定地址*/
uint8_t OTA_FCL_Read8(uint32_t address)
{
    return *((uint32_t*)address);
}

uint32_t RTE_FLASH_Read32(uint32_t address)
{
    return Internal_FCL_Read32(address);
}

void CalculateAPPCRC32ForFF01 (void *pStart)
{
    uint8_t *pData;


    /* init the start value */

    pData = pStart;

    /* calculate CRC */
    DiagFlag.CalculateCRC  = CRC32_Table[(DiagFlag.CalculateCRC  ^ *pData) & 0xFF] ^ ((DiagFlag.CalculateCRC   >> 8) & 0x00ffffff);

}
uint32_t BootReadCrcBlockInfo(uint32_t address)
{
    uint32_t m32;
    uint8_t m8_1;
    uint8_t m8_2;
    uint8_t m8_3;
    uint8_t m8_4;

    m32 = RTE_FLASH_Read32(address);
    m8_1 = (uint8_t)((m32 & 0x000000ff));
    m8_2 = (uint8_t)((m32 & 0x0000ff00) >> 8);
    m8_3 = (uint8_t)((m32 & 0x00ff0000) >> 16);
    m8_4 = (uint8_t)((m32 & 0xff000000) >> 24);

    m32 = BuildUint32_t(m8_1, m8_2, m8_3, m8_4);


    return m32;
}
uint32_t BuildUint32_t(uint8_t NumH, uint8_t Num2, uint8_t Num1, uint8_t NumL)
{
    uint32_t m32;
    m32 = (((uint32_t)NumH << 24) & 0xff000000) | (((uint32_t)Num2 << 16) & 0x00ff0000) | (((uint32_t)Num1 << 8) & 0x0000ff00) | (((uint32_t)NumL ) & 0x000000ff) ;

    return m32;
}
void UDS_CheckProgDependence(void)
{
    uint8_t i=0;
    uint8_t m8_1;
    uint8_t m8_2;
    uint8_t m8_3;
    uint8_t m8_4;
    uint32_t m32;

    m32 = RTE_FLASH_Read32(FLASH_LOAD_APP_Addr+8);
    m8_1 = (uint8_t)((m32 & 0x000000ff));
    m8_2 = (uint8_t)((m32 & 0x0000ff00) >> 8);
    m8_3 = (uint8_t)((m32 & 0x00ff0000) >> 16);
    m8_4 = (uint8_t)((m32 & 0xff000000) >> 24);

    m32 = BuildUint32_t(m8_1, m8_2, m8_3, m8_4);


    VerifyTCFlash[i].StartAddress = USER_APP_ADDRESS;
    
    VerifyTCFlash[i].Endaddress=USER_APP_ADDRESS+m32;
    //uart1_printf("%08X,%08X",VerifyTCFlash[i].StartAddress,VerifyTCFlash[i].Endaddress);

    DiagFlag.CalculateCRC = 0xFFFFFFFF;
    while (VerifyTCFlash[i].StartAddress < VerifyTCFlash[i].Endaddress)
    {
        m32 = RTE_FLASH_Read32(VerifyTCFlash[i].StartAddress);
        m8_1 = (uint8_t)((m32 & 0x000000ff));
        CalculateAPPCRC32ForFF01(&m8_1);
        m8_2 = (uint8_t)((m32 & 0x0000ff00) >> 8);
        CalculateAPPCRC32ForFF01(&m8_2);
        m8_3 = (uint8_t)((m32 & 0x00ff0000) >> 16);
        CalculateAPPCRC32ForFF01(&m8_3);
        m8_4 = (uint8_t)((m32 & 0xff000000) >> 24);
        CalculateAPPCRC32ForFF01(&m8_4);
        VerifyTCFlash[i].StartAddress += 4;
    }
 
}
/*读指定地址 打印指定地址后多长的区域 调试用*/
//void OTA_FCL_Read_printf(uint32_t address ,uint32_t len)
//{
//    if((address+len-1)<=0xFFFFFU)
//    {
//        uint32_t i = 0;
//        for (i = address; i < (address+len); i++)
//        {
//        if ((i % 32) == 0)
//            {
//                uart1_printf("\r\n %08x    ",i);
//            }
//            uart1_printf("%02x ", OTA_FCL_Read8(i));
//        }
//        uart1_printf("\r\n");
//    }
//    else
//    {
//        uart1_printf("Address or len error!\r\n");
//    }
//}

//读OTA标志位
uint32_t OTA_EEL_Read(void)
{
    uint32_t temp;
    temp = ReadProgramVaildStatus();
    return temp;
}

//写OTA标志位
void OTA_EEL_Write(uint32_t Flag)
{  
    WriteProgramVaildStatus(Flag);
}
/**
  *读取信息
  */
uint8_t ReadDFlashData(uint8_t u8BlockNum, uint32_t u32Data[], uint16_t u16Len, InitFunction initFunction)
{
    uint8_t  enResult = 1;
    enResult = DFlash_ReadData(u8BlockNum, (uint8_t *)u32Data, u16Len);
    return enResult;
}

/**
  *写入信息
  */
uint8_t WriteDFlashData(uint8_t u8BlockNum, uint32_t u32Data[], uint16_t u16Len, uint8_t isWait)
{
    uint8_t  enResult = 1;
   
    enResult = DFlash_WriteData(u8BlockNum, (uint8_t *)u32Data, u16Len);
    return enResult;
}
void AllFlagInit(void)
{
    DiagFlag.Flag = 0x7AA7A55Au;
    DiagFlag.JumpToBootFlag = 0xFFFFFFFF;
    DiagFlag.CalculateCRC = 0x00000000u;
    DiagFlag.ReadCRC = 0x00000000u;
}
/**
 * 读出D—FLASH标志位
 */
uint32_t ReadProgramVaildStatus(void)
{
    (void)ReadDFlashData(INTERNAL_EE_BLOCK_02, (uint32_t *)&DiagFlag.JumpToBootFlag  , 16U  , AllFlagInit);
    return (DiagFlag.JumpToBootFlag);
}
/**
 * 写入D—FLASH标志位
 */
void WriteProgramVaildStatus(uint32_t status)
{
    DiagFlag.Flag = 0x7AA7A55Au;
    DiagFlag.JumpToBootFlag = status;
    WriteDFlashData(INTERNAL_EE_BLOCK_02, (uint32_t *)&DiagFlag.JumpToBootFlag,  16U, 1);
}

//执行命令相关设置
void OTA_BOOT_init(void)
{
    //OTA_EEL_Write(APP_INVAILD_FLAG);/*设置为应用无效，调试用，否则屏蔽*/
    uint32_t Appflag;
    Appflag = APP_INVAILD_FLAG;
    Appflag = OTA_EEL_Read();/*读取跳转标志*/

    if(Appflag == APP_VAILD_JUMP_FLAG)/*如果为应用有效标志，直接跳转*/
    {
        JumpToUserApplication();/*跳转*/
    }
    else if (Appflag == APP_INVAILD_FLAG)/*如果为应用无效标志，停留在boot准备升级*/
    {
        /*硬件初始化在函数外边执行，因此这里就不再处理*/
    }
    else /*如果标志既不是无效也不是有效，进行CRC校验*/
    {
        if(OTA_CRC() == 0)/*如果校验正确，跳转*/
        {
            JumpToUserApplication();/*跳转*/
        }
    }
    Appflag = OTA_EEL_Read();
    Update_buffer_init();
}



//擦除用户空间
void OTA_EraseAll_APP(void)
{
    uint32_t i;
    //  执行擦除Flash
    #if BSP_USER_DEBUG>=1
        uart1_printf("Begin Erase Flash Sector:\r\n");
    #endif
    for (i = USER_APP_Block; i < 38; i++ )
    {
        BSP_WDT_Clear();/*喂狗*/
        OTA_FLASH_Erase(i);
        #if BSP_USER_DEBUG>=1
            uart1_printf("    Erase Flash Block at %d\r\n", i);
        #endif
    }
    #if BSP_USER_DEBUG>=1
        uart1_printf("Erase User Flash Finish!!\r\n");
    #endif
}
//-----------------------------------------------------------------
//  应用程序复位
void OTA_SystemReset(void)
{
    RH850_Hardware_Reset();
}
//  跳转至用户程序
void JumpToUserApplication(void)
{
    uint32_t (* jr_app)(void); 
    disable_interrupt();
    jr_app= ( uint32_t (*)() )USER_APP_ADDRESS;
    jr_app();
}

/*写入FLASH缓冲区*/
static Update_buffer_st_t Update_buffer;

void Update_buffer_init(void)
{
    uint16_t clear;
    for (clear = 0; clear < 256U; clear++)
    {
        Update_buffer.data[clear] = 0xFFU;
    }
    Update_buffer.byte = 0;
    Update_buffer.Write_addr = FLASH_LOAD_APP_Addr;
    Update_buffer.end_addr = FLASH_LOAD_APP_Addr - 1U;
}

uint8_t OTA_Write(uint32_t address, uint8_t *data, uint8_t len)
{
    uint16_t i, clear, ret = 1;

    /*如果上次结束的地址和这次的起始地址不连续*/
    if (Update_buffer.end_addr < (address - 1))
    {
        for (; Update_buffer.end_addr < (address - 1); Update_buffer.end_addr++)
        {
            Update_buffer.data[Update_buffer.byte] = 0xFFU;
            Update_buffer.byte++;
            if (Update_buffer.byte == 256U)
            {
                Update_buffer.byte = 0;
                OTA_FLASH_Write(Update_buffer.Write_addr, Update_buffer.data, 256U);
                for (clear = 0; clear < 256U; clear++)
                {
                    Update_buffer.data[clear] = 0xFFU;
                }
                Update_buffer.Write_addr = Update_buffer.Write_addr + 256U;
            }
        }
    }

    if(Update_buffer.end_addr == (address - 1))
    {
        /*写入数据*/
        for (i = 0; i < len; i++)
        {
            Update_buffer.data[Update_buffer.byte] = data[i];
            Update_buffer.byte++;
            if (Update_buffer.byte == 256U) /*如果缓冲区的数据满了则写入FLASH并清空缓冲区、更新下次写入地址*/
            {
                Update_buffer.byte = 0;
                OTA_FLASH_Write(Update_buffer.Write_addr, Update_buffer.data, 256U);
                for (clear = 0; clear < 256U; clear++)
                {
                    Update_buffer.data[clear] = 0xFFU;
                }
                Update_buffer.Write_addr = Update_buffer.Write_addr + 256U;
            }
        }
        /*更新上次结束地址*/
        Update_buffer.end_addr = Update_buffer.end_addr + len;
    }
    else
    {
        ret = 0;
    }

    return ret;
}

void OTA_END_Write(void)
{
    OTA_FLASH_Write(Update_buffer.Write_addr, Update_buffer.data, 256U);
    Update_buffer_init();
}

uint8_t S19_Checksum(uint8_t *pdata, uint32_t len)
{
    uint32_t i,Checksum = 0;

    for (i = 0; i < len; i++)
    {
        Checksum += pdata[i];
    }
    Checksum = Checksum & 0x0FFU;
    Checksum = 0xFFU - Checksum;

    return (uint8_t)Checksum;
}

uint8_t OTA_CRC(void)
{
    uint8_t ret = 0;
    UDS_CheckProgDependence();
    DiagFlag.CalculateCRC = DiagFlag.CalculateCRC ^ 0xffffffff;
    DiagFlag.ReadCRC= BootReadCrcBlockInfo(FLASH_LOAD_APP_Addr);
    
    if (DiagFlag.CalculateCRC ==DiagFlag.ReadCRC)
    {
        OTA_EEL_Write(APP_VAILD_JUMP_FLAG);
        ret = 0;
    }
    else
    {
        OTA_EEL_Write(APP_INVAILD_FLAG);
        ret = 1;
    }
    return ret;
}

const uint32_t CRC32_Table[256] =
{
    0x00000000ul, 0x77073096ul, 0xEE0E612Cul, 0x990951BAul,
    0x076DC419ul, 0x706AF48Ful, 0xE963A535ul, 0x9E6495A3ul,
    0x0EDB8832ul, 0x79DCB8A4ul, 0xE0D5E91Eul, 0x97D2D988ul,
    0x09B64C2Bul, 0x7EB17CBDul, 0xE7B82D07ul, 0x90BF1D91ul,
    0x1DB71064ul, 0x6AB020F2ul, 0xF3B97148ul, 0x84BE41DEul,
    0x1ADAD47Dul, 0x6DDDE4EBul, 0xF4D4B551ul, 0x83D385C7ul,
    0x136C9856ul, 0x646BA8C0ul, 0xFD62F97Aul, 0x8A65C9ECul,
    0x14015C4Ful, 0x63066CD9ul, 0xFA0F3D63ul, 0x8D080DF5ul,
    0x3B6E20C8ul, 0x4C69105Eul, 0xD56041E4ul, 0xA2677172ul,
    0x3C03E4D1ul, 0x4B04D447ul, 0xD20D85FDul, 0xA50AB56Bul,
    0x35B5A8FAul, 0x42B2986Cul, 0xDBBBC9D6ul, 0xACBCF940ul,
    0x32D86CE3ul, 0x45DF5C75ul, 0xDCD60DCFul, 0xABD13D59ul,
    0x26D930ACul, 0x51DE003Aul, 0xC8D75180ul, 0xBFD06116ul,
    0x21B4F4B5ul, 0x56B3C423ul, 0xCFBA9599ul, 0xB8BDA50Ful,
    0x2802B89Eul, 0x5F058808ul, 0xC60CD9B2ul, 0xB10BE924ul,
    0x2F6F7C87ul, 0x58684C11ul, 0xC1611DABul, 0xB6662D3Dul,
    0x76DC4190ul, 0x01DB7106ul, 0x98D220BCul, 0xEFD5102Aul,
    0x71B18589ul, 0x06B6B51Ful, 0x9FBFE4A5ul, 0xE8B8D433ul,
    0x7807C9A2ul, 0x0F00F934ul, 0x9609A88Eul, 0xE10E9818ul,
    0x7F6A0DBBul, 0x086D3D2Dul, 0x91646C97ul, 0xE6635C01ul,
    0x6B6B51F4ul, 0x1C6C6162ul, 0x856530D8ul, 0xF262004Eul,
    0x6C0695EDul, 0x1B01A57Bul, 0x8208F4C1ul, 0xF50FC457ul,
    0x65B0D9C6ul, 0x12B7E950ul, 0x8BBEB8EAul, 0xFCB9887Cul,
    0x62DD1DDFul, 0x15DA2D49ul, 0x8CD37CF3ul, 0xFBD44C65ul,
    0x4DB26158ul, 0x3AB551CEul, 0xA3BC0074ul, 0xD4BB30E2ul,
    0x4ADFA541ul, 0x3DD895D7ul, 0xA4D1C46Dul, 0xD3D6F4FBul,
    0x4369E96Aul, 0x346ED9FCul, 0xAD678846ul, 0xDA60B8D0ul,
    0x44042D73ul, 0x33031DE5ul, 0xAA0A4C5Ful, 0xDD0D7CC9ul,
    0x5005713Cul, 0x270241AAul, 0xBE0B1010ul, 0xC90C2086ul,
    0x5768B525ul, 0x206F85B3ul, 0xB966D409ul, 0xCE61E49Ful,
    0x5EDEF90Eul, 0x29D9C998ul, 0xB0D09822ul, 0xC7D7A8B4ul,
    0x59B33D17ul, 0x2EB40D81ul, 0xB7BD5C3Bul, 0xC0BA6CADul,
    0xEDB88320ul, 0x9ABFB3B6ul, 0x03B6E20Cul, 0x74B1D29Aul,
    0xEAD54739ul, 0x9DD277AFul, 0x04DB2615ul, 0x73DC1683ul,
    0xE3630B12ul, 0x94643B84ul, 0x0D6D6A3Eul, 0x7A6A5AA8ul,
    0xE40ECF0Bul, 0x9309FF9Dul, 0x0A00AE27ul, 0x7D079EB1ul,
    0xF00F9344ul, 0x8708A3D2ul, 0x1E01F268ul, 0x6906C2FEul,
    0xF762575Dul, 0x806567CBul, 0x196C3671ul, 0x6E6B06E7ul,
    0xFED41B76ul, 0x89D32BE0ul, 0x10DA7A5Aul, 0x67DD4ACCul,
    0xF9B9DF6Ful, 0x8EBEEFF9ul, 0x17B7BE43ul, 0x60B08ED5ul,
    0xD6D6A3E8ul, 0xA1D1937Eul, 0x38D8C2C4ul, 0x4FDFF252ul,
    0xD1BB67F1ul, 0xA6BC5767ul, 0x3FB506DDul, 0x48B2364Bul,
    0xD80D2BDAul, 0xAF0A1B4Cul, 0x36034AF6ul, 0x41047A60ul,
    0xDF60EFC3ul, 0xA867DF55ul, 0x316E8EEFul, 0x4669BE79ul,
    0xCB61B38Cul, 0xBC66831Aul, 0x256FD2A0ul, 0x5268E236ul,
    0xCC0C7795ul, 0xBB0B4703ul, 0x220216B9ul, 0x5505262Ful,
    0xC5BA3BBEul, 0xB2BD0B28ul, 0x2BB45A92ul, 0x5CB36A04ul,
    0xC2D7FFA7ul, 0xB5D0CF31ul, 0x2CD99E8Bul, 0x5BDEAE1Dul,
    0x9B64C2B0ul, 0xEC63F226ul, 0x756AA39Cul, 0x026D930Aul,
    0x9C0906A9ul, 0xEB0E363Ful, 0x72076785ul, 0x05005713ul,
    0x95BF4A82ul, 0xE2B87A14ul, 0x7BB12BAEul, 0x0CB61B38ul,
    0x92D28E9Bul, 0xE5D5BE0Dul, 0x7CDCEFB7ul, 0x0BDBDF21ul,
    0x86D3D2D4ul, 0xF1D4E242ul, 0x68DDB3F8ul, 0x1FDA836Eul,
    0x81BE16CDul, 0xF6B9265Bul, 0x6FB077E1ul, 0x18B74777ul,
    0x88085AE6ul, 0xFF0F6A70ul, 0x66063BCAul, 0x11010B5Cul,
    0x8F659EFFul, 0xF862AE69ul, 0x616BFFD3ul, 0x166CCF45ul,
    0xA00AE278ul, 0xD70DD2EEul, 0x4E048354ul, 0x3903B3C2ul,
    0xA7672661ul, 0xD06016F7ul, 0x4969474Dul, 0x3E6E77DBul,
    0xAED16A4Aul, 0xD9D65ADCul, 0x40DF0B66ul, 0x37D83BF0ul,
    0xA9BCAE53ul, 0xDEBB9EC5ul, 0x47B2CF7Ful, 0x30B5FFE9ul,
    0xBDBDF21Cul, 0xCABAC28Aul, 0x53B39330ul, 0x24B4A3A6ul,
    0xBAD03605ul, 0xCDD70693ul, 0x54DE5729ul, 0x23D967BFul,
    0xB3667A2Eul, 0xC4614AB8ul, 0x5D681B02ul, 0x2A6F2B94ul,
    0xB40BBE37ul, 0xC30C8EA1ul, 0x5A05DF1Bul, 0x2D02EF8Dul
};

void OTA_test(void)
{
  
 
    OTA_CRC();

}