/*
 * RH850_OTA.h
 *
 *  Created on: 2022年7月21日
 */

#ifndef RH850_OTA_H_
#define RH850_OTA_H_

#define APP_INVAILD_FLAG                                        0xA77A5AA5u     //APP无效标志
#define APP_VAILD_JUMP_FLAG                                     0x58583636u     //APP跳转标志
typedef struct
{
    uint32_t Flag;
    uint32_t JumpToBootFlag;
    uint32_t CalculateCRC;
    uint32_t ReadCRC;
} DiagFlagUnion;

/*OTA写入缓冲区结构体*/
typedef struct
{
    uint8_t data[256];      /*写入flash的缓冲区*/
    uint16_t byte;          /*data记录到了第几个字节*/
    uint32_t Write_addr;    /*数据凑够256字节(1 unit)后应该写入的地址*/
    uint32_t end_addr;      /*上次传进来的数据最后一位的地址*/
} Update_buffer_st_t;

typedef struct
{
    uint8_t  IsValid;
    uint32_t StartAddress;
    uint32_t TotalSize; 
    uint32_t Endaddress;
    uint16_t CRCResult;
} _VerifyTCFlash;

//读OTA标志位
uint32_t OTA_EEL_Read(void);
//写OTA标志位
void OTA_EEL_Write(uint32_t Flag);
//BOOT需要调用的初始化
void OTA_BOOT_init(void);


//-----------------------------------------------------------------
// APP部分完全擦除命令
void OTA_EraseAll_APP(void);
//  应用程序复位
void OTA_SystemReset(void);

//  跳转至用户程序
void JumpToUserApplication(void);


/*初始化升级缓冲区*/
void Update_buffer_init(void);
/*写入数据到FLASH*/
uint8_t OTA_Write(uint32_t address, uint8_t *data, uint8_t len);
/*收到S7(写入结束)时调用*/
void OTA_END_Write(void);
/*计算S19校验和*/
uint8_t S19_Checksum(uint8_t *pdata, uint32_t len);
uint8_t OTA_CRC(void);
/*测试调用*/
void OTA_test(void);
extern void RTE_FCL_OP(void);
extern uint8_t DFlash_WriteData(uint32_t Adrr, uint8_t *Data,uint16_t len);
extern uint8_t DFlash_ReadData(uint32_t Adrr, uint8_t *Data,uint16_t len);
uint32_t ReadProgramVaildStatus(void);
void WriteProgramVaildStatus(uint32_t status);
void UDS_CheckProgDependence(void);
uint32_t BootReadCrcBlockInfo(uint32_t address);
uint32_t BuildUint32_t(uint8_t NumH, uint8_t Num2, uint8_t Num1, uint8_t NumL);
extern DiagFlagUnion DiagFlag;
#endif /* RH850_OTA_H_ */
