#include "common_include.h"
#include "app_tft.h"
#include "picture.h"
uint8_t CHECK_CluPartNum1[][10] = {
    {0x39,0x34,0x30,0x31,0x33,0x4F,0x36,0x30,0x30,0x30},
   

};
unsigned int g_RPM_Val;

#define CHECK_NAME_BASEX 0
#define CHECK_NAME_BASEY 13


#define TITLE_BASEX      9
#define TITLE_BASEY      9



//#define BARCODE_Y    106
//#define PARTNUM_Y    136

#define FUNC_X  0
#define FUNC_Y  62

#define FUNC_LIST_Y 106

#define BARCODE_Y    FUNC_LIST_Y + 96 +24
#define PARTNUM_Y    FUNC_LIST_Y + 96 +24 + 30

#define SMALL_PIC_H   17
#define SMALL_PIC_BASE 107
#define SW_VERSON_Y  SMALL_PIC_BASE
#define HW_VERSON_Y  SMALL_PIC_BASE

#define SW_HJStatic_X  10
#define SW_HJStatic_Y  107
#define SW_HJSW_X  SW_HJStatic_X
#define SW_HJHW_Y  SW_HJStatic_Y + 20

#define SMALL_PIC_LIST_COL1_X 10
#define SMALL_PIC_LIST_COL2_X 140

#define OTHER_CHECK_STARTX 105

#define SMALL_PIC_LIST_ROW01 SMALL_PIC_BASE
#define SMALL_PIC_LIST_ROW02 SMALL_PIC_BASE + 1*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW03 SMALL_PIC_BASE + 2*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW04 SMALL_PIC_BASE + 3*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW05 SMALL_PIC_BASE + 4*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW06 SMALL_PIC_BASE + 5*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW07 SMALL_PIC_BASE + 6*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW08 SMALL_PIC_BASE + 7*SMALL_PIC_H

#define SMALL_PIC_LIST_ROW09 SMALL_PIC_BASE + 8*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW10 SMALL_PIC_BASE + 9*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW11 SMALL_PIC_BASE + 10*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW12 SMALL_PIC_BASE + 11*SMALL_PIC_H
#define SMALL_PIC_LIST_ROW13 SMALL_PIC_BASE + 12*SMALL_PIC_H


#define CHECK_ITEM_BASE_Y 215
#define CHECK_STATE_OFFSET 48

#define CHECK_STATE_OFFSET1 110
#define CHECK_STATE_OFFSET2 85
#define X_STRAT_BASE 5

//��һ��
#define MSG_CHECK_X  X_STRAT_BASE
#define MSG_CHECK_Y  CHECK_ITEM_BASE_Y

#define SW1_CHECK_X  X_STRAT_BASE + 80
#define SW1_CHECK_Y  CHECK_ITEM_BASE_Y

#define SW2_CHECK_X  X_STRAT_BASE + 160
#define SW2_CHECK_Y  CHECK_ITEM_BASE_Y

//�ڶ���

#define ENG_CHECK_X  X_STRAT_BASE
#define ENG_CHECK_Y  CHECK_ITEM_BASE_Y + 25

#define GEAR_CHECK_X  X_STRAT_BASE + 80
#define GEAR_CHECK_Y  CHECK_ITEM_BASE_Y + 25

#define GND3_CHECK_X  X_STRAT_BASE + 160
#define GND3_CHECK_Y  CHECK_ITEM_BASE_Y + 25

//������
#define RHEO_CHECK_X  X_STRAT_BASE
#define RHEO_CHECK_Y  CHECK_ITEM_BASE_Y + 50

#define DETENT_CHECK_X  X_STRAT_BASE + 80
#define DETENT_CHECK_Y  CHECK_ITEM_BASE_Y + 50


#define CHECK_STATE_X 0
#define CHECK_STATE_Y 295

#define CHECK_VERSION_X 1
#define CHECK_VERSION_Y 295




const uint32_t IOLValue[6] = {PW2_05, PW2_06, PW2_08, PW2_60, PW2_52, PW2_51};//һ����˸ һ�� ���� ���� �Ÿ� ʮ����
//const uint32_t TEMPValue[6] = {PW2_52 ,PW2_06 ,PW2_07, PW2_08, PW2_50, PW2_51};//�յ� һ�� ���� ���� �Ÿ� ʮ����
const uint8_t GearValue[5]  = { 0, 4, 5, 6, 7,};
const uint32_t GearList[5]  = { PW2_10P, PW2_10S, PW2_10D, PW2_10N, PW2_10R,};//��λ  P S D N R

                             
const uint32_t StageList[] = 
{ 
    PW1_017, // 0 ��ѡ��
    PW1_13,  // 1 �Լ�
    PW1_10,  // 2 �Ʊ��̼��
    PW1_12,  // 3 ˮ�ͼ��
    PW1_14,  // 4 ����
    PW2_13,  // 5 ����
    PW1_05,  // 6 ����
    PW1_07,  // 7 TFT���

    PW1_10,  // 8 LCD��� ��ʾ2 �Ʊ��̼��
    PW1_10,  // 9 ����Ƶ��ռ�ձȼ�� 2 �Ʊ��̼��
};//������ʾ

const uint32_t NumberList[12] = {   //0 1 2 3 4 5 6 7 8 9 . _
    gImage_0, gImage_1, gImage_2, gImage_3, gImage_4, gImage_5, gImage_6, gImage_7, gImage_8, gImage_9, gImage_point, PW2_107};
const uint32_t NumberList_S[12] = {   //0 1 2 3 4 5 6 7 8 9 . _
    Num0, Num1, Num2, Num3, Num4, Num5, Num6, Num7, Num8, Num9, Image_JuHao, Image_XiaHuaXian};    
const uint32_t NumberList_EOL[16] = {   //0 1 2 3 4 5 6 7 8 9 A B C D E F
    Num0, Num1, Num2, Num3, Num4, Num5, Num6, Num7, Num8, Num9, CharA,  CharB,  CharC,  CharD,  CharE,  CharF};
const uint32_t AIISCList[44] = {  
    gImage_0, gImage_1, gImage_2, gImage_3, gImage_4, gImage_5, gImage_6, gImage_7, gImage_8, gImage_9,  // 0-9
    //10       11        12        13        14        15        16
    PW2_10X,   PW2_10X,  PW2_10X,  PW2_10X,  PW2_10X,  PW2_10X,  PW2_10X,                                // ��; < = > ? @ 
    //17       18        19        20        21        22        23        24        25        26
    PW2_10A,   PW2_10B,  PW2_10C,  PW2_10D,  PW2_10E,  PW2_10F,  PW2_10G,  PW2_10H,  PW2_10I,  PW2_10J,  // A-Z
    //27       28        29        30        31        32        33        34        35        36
    PW2_10K,   PW2_10L,  PW2_10M,  PW2_10N,  PW2_10O,  PW2_10P,  PW2_10Q,  PW2_10R,  PW2_10S,  PW2_10T,
    //37       38        39        40         41        42     
    PW2_10U,   PW2_10V,  PW2_10W,  PW2_10X_,  PW2_10Y,  PW2_10Z,  gImage_point,
};

const uint32_t AIISCList_S[45] = {  
    Num0, Num1, Num2, Num3, Num4, Num5, Num6, Num7, Num8, Num9,  // 0-9
    //10            11             12                13              14              15             16
    Image_MaoHao,   Image_FenHao,  Image_XiaoYuHao,  Image_DengHao,  Image_DaYuHao,  Image_WenHao,  Image_Copy,           // ��; < = > ? @ 
    //17     18      19      20      21      22      23      24      25      26
    CharA,   CharB,  CharC,  CharD,  CharE,  CharF,  CharG,  CharH,  CharI,  CharJ,  // A-Z
    //27     28      29      30      31      32      33      34      35      36
    CharK,   CharL,  CharM,  CharN,  CharO,  CharP,  CharQ,  CharR,  CharS,  CharT,
    //37     38      39      40      41      42      43
    CharU,   CharV,  CharW,  CharX,  CharY,  CharZ,  Image_XiaHuaXian,Image_JiaHao,
};
#if 1
CENTER_AREA_DISPLAY_ITEM DisplayItem;
uint8_t g_uiStaticIndex = 0;
uint8_t g_uiDyncIndex = 0;



//��̬ͼƬ��ʾ
void SetDisplayStaticItemW1(uint32_t uiPic, int16_t uiStartX, int16_t uiStartY,uint8_t uiDrawWindow)
{
    SET_DISPLAY_STATIC_ITEM(g_uiStaticIndex, uiPic,  uiStartX,   uiStartY, uiDrawWindow);
    SET_DISPLAY_STATIC_ITEM_WINDOW(g_uiStaticIndex, MIN_START_X, MAX_STOP_X, W1_START_Y, W1_STOP_Y);
    g_uiStaticIndex++;
}
void SetDisplayStaticItemW2(uint32_t uiPic, int16_t uiStartX, int16_t uiStartY,uint8_t uiDrawWindow)
{
    SET_DISPLAY_STATIC_ITEM(g_uiStaticIndex, uiPic,  uiStartX,   uiStartY, uiDrawWindow);
    SET_DISPLAY_STATIC_ITEM_WINDOW(g_uiStaticIndex, MIN_START_X, MAX_STOP_X, W2_START_Y, W2_STOP_Y);
    g_uiStaticIndex++;
}
void SetDisplayStaticItemW3(uint32_t uiPic, int16_t uiStartX, int16_t uiStartY,uint8_t uiDrawWindow)
{
    SET_DISPLAY_STATIC_ITEM(g_uiStaticIndex, uiPic,  uiStartX,   uiStartY, uiDrawWindow);
    SET_DISPLAY_STATIC_ITEM_WINDOW(g_uiStaticIndex, MIN_START_X, MAX_STOP_X, W3_START_Y, W3_STOP_Y);
    g_uiStaticIndex++;
}
//��̬ͼƬ��ʾ
void SetDisplayDynamicItemW1(uint32_t uiPic, int16_t uiStartX, int16_t uiStartY,uint8_t uiDrawWindow)
{
    SET_DISPLAY_DYNC_ITEM(g_uiDyncIndex, uiPic,  uiStartX,   uiStartY, uiDrawWindow);
    SET_DISPLAY_DYNC_ITEM_WINDOW(g_uiDyncIndex, MIN_START_X, MAX_STOP_X, W1_START_Y, W1_STOP_Y);
    g_uiDyncIndex++;
}
void SetDisplayDynamicItemW2(uint32_t uiPic, int16_t uiStartX, int16_t uiStartY,uint8_t uiDrawWindow)
{
    SET_DISPLAY_DYNC_ITEM(g_uiDyncIndex, uiPic,  uiStartX,   uiStartY, uiDrawWindow);
    SET_DISPLAY_DYNC_ITEM_WINDOW(g_uiDyncIndex, MIN_START_X, MAX_STOP_X, W2_START_Y, W2_STOP_Y);
    g_uiDyncIndex++;
}
void SetDisplayDynamicItemW3(uint32_t uiPic, int16_t uiStartX, int16_t uiStartY,uint8_t uiDrawWindow)
{
    SET_DISPLAY_DYNC_ITEM(g_uiDyncIndex, uiPic,  uiStartX,   uiStartY, uiDrawWindow);
    SET_DISPLAY_DYNC_ITEM_WINDOW(g_uiDyncIndex, MIN_START_X, MAX_STOP_X, W3_START_Y, W3_STOP_Y);
    g_uiDyncIndex++;
}

void DspOneLineStaticStr(const char *pStr,int16_t uiStartX, int16_t uiStartY)
{
    int iMaxLen = strlen(pStr) > 20 ?20:strlen(pStr);
    for(uint8_t i = 0; i < iMaxLen; i++){
      for(uint8_t j = 0; j < 0x7A-0x21; j++) {
        if(g_stCharList[j].uiAscVal >= 0x21 && g_stCharList[j].uiAscVal <= 0x7A) {
            if(g_stCharList[j].uiAscVal == pStr[i])
                if(W1_START_Y <= uiStartY && uiStartY <= W1_STOP_Y) {
                    SetDisplayStaticItemW1(g_stCharList[j].uiCharPic, uiStartX + (i * 12), uiStartY,DRAW_LUMIN_ICOM_WINDOW);
                }
                else if(W2_START_Y <= uiStartY && uiStartY <= W2_STOP_Y) {
                    SetDisplayStaticItemW2(g_stCharList[j].uiCharPic, uiStartX + (i * 12), uiStartY,DRAW_LUMIN_ICOM_WINDOW);
                }
                else if(W3_START_Y <= uiStartY && uiStartY <= W3_STOP_Y) {
                    SetDisplayStaticItemW3(g_stCharList[j].uiCharPic, uiStartX + (i * 12), uiStartY,DRAW_LUMIN_ICOM_WINDOW);
                }

        }
      }
    }
}

void DspOneLineDynamicStr(const char *pStr,int16_t uiStartX, int16_t uiStartY)
{
    int iMaxLen = strlen(pStr) > 20 ?20:strlen(pStr);
    for(uint8_t i = 0; i < iMaxLen; i++){
      for(uint8_t j = 0; j < 0x7A-0x21; j++) {
        if(g_stCharList[j].uiAscVal >= 0x21 && g_stCharList[j].uiAscVal <= 0x7A) {
            if(g_stCharList[j].uiAscVal == pStr[i])
                if(W1_START_Y <= uiStartY && uiStartY <= W1_STOP_Y) {
                    SetDisplayDynamicItemW1(g_stCharList[j].uiCharPic, uiStartX + (i * 12), uiStartY,DRAW_LUMIN_ICOM_WINDOW);
                }
                else if(W2_START_Y <= uiStartY && uiStartY <= W2_STOP_Y) {
                    SetDisplayDynamicItemW2(g_stCharList[j].uiCharPic, uiStartX + (i * 12), uiStartY,DRAW_LUMIN_ICOM_WINDOW);
                }
                else if(W3_START_Y <= uiStartY && uiStartY <= W3_STOP_Y) {
                    SetDisplayDynamicItemW3(g_stCharList[j].uiCharPic, uiStartX + (i * 12), uiStartY,DRAW_LUMIN_ICOM_WINDOW);
                }

        }
      }
    }
}



#endif





CENTER_AREA_DISPLAY_ITEM CenterAreaDisplayList[SAME_TIME_DISPLAY_NUM];
uint8_t LastDisplayType = 0;
uint8_t Flag_EventNeedSaveIsPlayed = 0;
int32_t FadeOutTemp = 0;    //��������˳�����ƽ��ʱ���м����
uint8_t Flag_FadeOutTemp_Init = 0;
uint32_t GearPopup_Count = 0;
uint8_t SystemCheckDisplayFinish = 0;
uint16_t PageIndicatorRemainTime = 0;
uint16_t PressOkClrRemainTime = 0;
uint8_t Flag_EventFadeOutStart = 0;
//EVENT_PARA *pCurEventMessageSave;
uint8_t Last_Flag_TFTOpen = 0;
uint32_t DTETCnts = 0;
uint8_t DTE500msLevel = 0;
uint8_t DTE500msEN = 0;
uint32_t OutTemperatureTCnts = 0;
uint8_t OutTemperature500msLevel = 0;
uint8_t OutTemperature500msEN = 0;
uint32_t GearTCnts = 0;
uint8_t Gear200msLevel = 0;
uint8_t Gear200msEN = 0;
uint32_t TFT_BilnkTimerDelta = 0;
uint32_t TFT_BilnkTimerCnts = 0;
uint32_t EventDoorCnts = 0;
uint8_t EventDoor600msOn400msOffLevel = 0;
uint8_t EventDoor600msOn400msOffEN = 0;
uint32_t EventPasCnts = 0;
uint8_t EventPas600msOn400msOffLevel = 0;
uint8_t EventPas600msOn400msOffEN = 0;
uint32_t EventServiceCnts = 0;
uint8_t EventService600msOn400msOffLevel = 0;
uint8_t EventService600msOn400msOffEN = 0;
uint32_t LKACnts = 0;
uint8_t LKA400msLevel = 0;
uint8_t LKA400msEN = 0;
uint32_t EventAnimationCnts = 0;
uint8_t EventAnimationEn = 0;
uint8_t EventAnimationLevel = 0;
uint8_t Flag_SysCheck_Displaying = 0;
uint8_t EventWelcomeAnimationEn = 0;
uint8_t EventWelcomeAnimationCnts = 0;
uint8_t EventWelcomeAnimationLevel = 0;
uint8_t DTEEn = 0;
uint32_t DTECnts = 0;
uint8_t DTELevel = 0;
uint32_t GearPopupTimer1msCnts_Old = 0;
uint16_t ADASUsmRemainTimer = 0;
uint8_t GearDisp = 0;
uint8_t GearCheckResult = 0;

uint8_t EngineState = 0;



extern volatile uint16_t  BackLight_Value;

const int32_t CartoonLogCoefficient[11][2] = {{0, 0}, {1, 2696}, {2, 4853}, {3, 6569}, {4, 7794}, {5, 8725}, {6, 9363}, {7, 9706}, {8, 9902}, {9, 9951}, {10, 10000}};
const int32_t CartoonExpCoefficient[11][2] = {{0, 0}, {1, 49}, {2, 98}, {3, 294}, {4, 637}, {5, 1275}, {6, 2206}, {7, 3431}, {8, 5147}, {9, 7304}, {10, 10000}};


int32_t CartoonLinearCalculate(int32_t InputRange, int32_t OutputRange, int32_t Input)
{//���ݶ�������ָ��5.1�½ڣ�����Pattern����ָ�ϱ�д
    //int32_t InputCoefficient = 0; //����ϵ��
    //int32_t OutputCoefficient = 0; //���ϵ��
    int32_t Output = 0;
    
    if(InputRange > 0 && Input > InputRange)
    {
        Input = InputRange;
    }
    else if(InputRange < 0 && Input < InputRange)
    {
        Input = InputRange;
    }
    
    //InputCoefficient = Input * 10000 / InputRange;
    
    //OutputCoefficient = InputCoefficient;
    
    Output = OutputRange * Input / InputRange;
    
    return Output;
}

int32_t CartoonLogCalculate(int32_t InputRange, int32_t OutputRange, int32_t Input)
{//���ݶ�������ָ��5.1�½ڣ�����Pattern����ָ�ϱ�д
    int32_t InputCoefficient = 0; //����ϵ��
    int32_t Output = 0;
    int32_t InputAlpha = 0;     //����Ĳ�ֵ���������Ǹ�����
    int32_t InputRangeTemp = 0;
    int32_t OutputHigh = 0;
    uint8_t i = 0;
    
    if(InputRange > 0 && Input > InputRange)
    {
        Input = InputRange;
    }
    else if(InputRange < 0 && Input < InputRange)
    {
        Input = InputRange;
    }
    
    InputCoefficient = Input * 10 / InputRange;
    
    for(i = 0; i < 11; i++)
    {
        if(CartoonLogCoefficient[i][0] == InputCoefficient)
        {
            break;
        }
    }
    if(i == 11)
    {
        Output = OutputRange;
        return Output;
    }
    InputAlpha = Input - InputRange * InputCoefficient / 10;
    InputRangeTemp = InputRange * (InputCoefficient + 1) / 10 - InputRange * InputCoefficient / 10;
    Output = OutputRange * CartoonLogCoefficient[i][1] / 10000;
    OutputHigh = OutputRange * CartoonLogCoefficient[i + 1][1] / 10000;
    OutputHigh = CartoonLinearCalculate(InputRangeTemp, OutputHigh - Output, InputAlpha);
    
    return Output + OutputHigh;
}

int32_t CartoonExpCalculate(int32_t InputRange, int32_t OutputRange, int32_t Input)
{//���ݶ�������ָ��5.1�½ڣ�����Pattern����ָ�ϱ�д
    int32_t InputCoefficient = 0; //����ϵ��
    int32_t Output = 0;
    int32_t InputAlpha = 0;     //����Ĳ�ֵ���������Ǹ�����
    int32_t InputRangeTemp = 0;
    int32_t OutputHigh = 0;
    uint8_t i = 0;
    
    if(InputRange > 0 && Input > InputRange)
    {
        Input = InputRange;
    }
    else if(InputRange < 0 && Input < InputRange)
    {
        Input = InputRange;
    }
    
    InputCoefficient = Input * 10 / InputRange;
    
    for(i = 0; i < 11; i++)
    {
        if(CartoonExpCoefficient[i][0] == InputCoefficient)
        {
            break;
        }
    }
    if(i == 11)
    {
        Output = OutputRange;
        return Output;
    }
    InputAlpha = Input - InputRange * InputCoefficient / 10;
    InputRangeTemp = InputRange * (InputCoefficient + 1) / 10 - InputRange * InputCoefficient / 10;
    Output = OutputRange * CartoonExpCoefficient[i][1] / 10000;
    OutputHigh = OutputRange * CartoonExpCoefficient[i + 1][1] / 10000;
    OutputHigh = CartoonLinearCalculate(InputRangeTemp, OutputHigh - Output, InputAlpha);
    
    return Output + OutputHigh;
}

void DisplayNum(const uint32_t *NumList, int32_t Num, uint8_t StartPos, uint8_t Interval, int16_t x, int16_t y, uint8_t DisplayType, CENTER_AREA_DISPLAY_ITEM *DisplayItem)
{
    uint8_t i = 0;
    int32_t tmp = Num;
    if (tmp < 0) {
        tmp = -tmp;
    }
    do {
        SET_DISPLAY_DYNC_ITEM_P(StartPos + i, NumList[tmp % 10], x - (i * Interval), y, DisplayType);
        i++;
        tmp /= 10;
    } while (tmp);
    if (Num < 0) {
        SET_DISPLAY_DYNC_ITEM_P(StartPos + i, NumList[10], x - (i * Interval), y, DisplayType);
    }
}

static uint8_t CheckAlreadyDisplayedAll(void)
{
    uint8_t i = 0;
    
    for (i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if(CenterAreaDisplayList[i].CurDisplayFlag == 1 && CenterAreaDisplayList[i].AliveDisplaytime == CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT)
        {
            return 1;
        }
    }    
    return 0;
}

uint8_t CheckAlreadyDisplayed(uint8_t DisplayType)
{
    uint8_t i = 0;
    
    for (i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if(CenterAreaDisplayList[i].DisplayType == DisplayType 
           && CenterAreaDisplayList[i].CurDisplayFlag == 1 
               && CenterAreaDisplayList[i].AliveDisplaytime == CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT)
        {
            return 1;
        }
    }    
    return 0;
}

static uint8_t CheckAlreadyFadeOut(void)
{
    uint8_t i = 0;
    
    for (i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if(CenterAreaDisplayList[i].CurDisplayFlag == 0 && CenterAreaDisplayList[i].AliveDisplaytime != 0)
        {
            return 0;
        }
    }    
    return 1;
}

uint8_t CheckCenterAreaSwitchEffect(void)
{
    for (uint8_t i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if(CenterAreaDisplayList[i].FadeInOffsetEffect != FALSE 
           || CenterAreaDisplayList[i].FadeOutOffsetEffect != FALSE 
               || CenterAreaDisplayList[i].FadeInAlphaEffect != FALSE 
                   || CenterAreaDisplayList[i].FadeOutAlphaEffect != FALSE)
        {
            return 0;
        }
    }
    return 1;
}

void SetCenterAreaSwitchEffect(uint8_t EffectValid, uint8_t OffsetEffect)
{
    for (uint8_t i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if(EffectValid == SWITCH_EFFECT_NONE)
        {
            CenterAreaDisplayList[i].FadeInOffsetEffect = FALSE;
            CenterAreaDisplayList[i].FadeOutOffsetEffect = FALSE;
            CenterAreaDisplayList[i].FadeInAlphaEffect = FALSE;
            CenterAreaDisplayList[i].FadeOutAlphaEffect = FALSE;
            CenterAreaDisplayList[i].FadeInRadiusEffect = FALSE;
            Flag_FadeOutTemp_Init = 0;
        }
        else
        {
            CenterAreaDisplayList[i].FadeInOffsetEffect = FALSE;
            CenterAreaDisplayList[i].FadeOutOffsetEffect = FALSE;
            CenterAreaDisplayList[i].FadeInAlphaEffect = FALSE;
            CenterAreaDisplayList[i].FadeOutAlphaEffect = FALSE;
            CenterAreaDisplayList[i].FadeInRadiusEffect = FALSE;
            if((EffectValid & SWITCH_EFFECT_IN_ALPHA) != 0)
            {
                CenterAreaDisplayList[i].FadeInAlphaEffect = TRUE;
            }
            if((EffectValid & SWITCH_EFFECT_OUT_ALPHA) != 0)
            {
                CenterAreaDisplayList[i].FadeOutAlphaEffect = TRUE;
            }
            if((EffectValid & SWITCH_EFFECT_IN_OFFSET) != 0)
            {
                CenterAreaDisplayList[i].FadeInOffsetEffect = TRUE;
            }
            if((EffectValid & SWITCH_EFFECT_OUT_OFFSET) != 0)
            {
                CenterAreaDisplayList[i].FadeOutOffsetEffect = TRUE;
            }
            if((EffectValid & SWITCH_EFFECT_RADIUS_OFFSET) != 0)
            {
                CenterAreaDisplayList[i].FadeInRadiusEffect = TRUE;
            }
            if(CenterAreaDisplayList[i].FadeOutOffsetEffect == FALSE)
            {
                Flag_FadeOutTemp_Init = 0;
            }
        }
        
        if (EffectValid != SWITCH_EFFECT_NONE) 
        {
            switch(OffsetEffect)
            {
                case SWITCH_EFFECT_OFFSET_FADE_IN_RIGHT_TO_LEFT:
                CenterAreaDisplayList[i].FadeInXStep = 1;
                CenterAreaDisplayList[i].FadeOutXStep = 1;
                CenterAreaDisplayList[i].FadeInYStep = 0;
                CenterAreaDisplayList[i].FadeOutYStep = 0;
                break;
                case SWITCH_EFFECT_OFFSET_FADE_IN_LEFT_TO_RIGHT:
                CenterAreaDisplayList[i].FadeInXStep = -1;
                CenterAreaDisplayList[i].FadeOutXStep = -1;
                CenterAreaDisplayList[i].FadeInYStep = 0;
                CenterAreaDisplayList[i].FadeOutYStep = 0;
                break;
                case SWITCH_EFFECT_OFFSET_FADE_IN_UP_TO_DOWN:
                CenterAreaDisplayList[i].FadeInXStep = 0;
                CenterAreaDisplayList[i].FadeOutXStep = 0;
                CenterAreaDisplayList[i].FadeInYStep = -1;
                CenterAreaDisplayList[i].FadeOutYStep = -1;
                break;
                case SWITCH_EFFECT_OFFSET_FADE_IN_DOWN_TO_UP:
                CenterAreaDisplayList[i].FadeInXStep = 0;
                CenterAreaDisplayList[i].FadeOutXStep = 0;
                CenterAreaDisplayList[i].FadeInYStep = 1;
                CenterAreaDisplayList[i].FadeOutYStep = 1;
                break;
                default:
                break;
            }
        }
    }
}

void SetCenterAreaDisplayList(CENTER_AREA_DISPLAY_ITEM *item, uint16_t DefaultStartTime)
{
    uint8_t i = 0;
    uint8_t j = 0;
    
    for (i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if (memcmp(&CenterAreaDisplayList[i].StaticPara, &item->StaticPara, sizeof (CenterAreaDisplayList[i].StaticPara)) == 0) 
        {
            memcpy(&CenterAreaDisplayList[i].DyncPara, &item->DyncPara, sizeof (CenterAreaDisplayList[i].DyncPara));
            break;
        }
    }
    if (i < SAME_TIME_DISPLAY_NUM) 
    {
        return;
    }
    
    for (i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if (CenterAreaDisplayList[i].StaticPara.DisplayPic[0] == 0) 
        {
            break;
        }
    }
    if (i == SAME_TIME_DISPLAY_NUM) 
    {
        return;
    }
    if (DefaultStartTime == CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT) 
    {
        for (j = 0; j < SAME_TIME_DISPLAY_NUM; j ++) 
        {
            CenterAreaDisplayList[j].AliveDisplaytime = 0;
            CenterAreaDisplayList[j].CurDisplayFlag = 0;
        }
    }
    for (j = 0; j < SAME_TIME_DISPLAY_NUM; j ++) 
    {//�����Ҫ��ʾ�Ľ��浭�붯��û�в�����ϣ��������óɵ��붯�����״̬�����뵭������״̬
        if(CenterAreaDisplayList[j].CurDisplayFlag == 1 && CenterAreaDisplayList[j].AliveDisplaytime < CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT)
            CenterAreaDisplayList[j].AliveDisplaytime = 400;
    }
    
    CenterAreaDisplayList[i].AliveDisplaytime = DefaultStartTime;
    memcpy(&CenterAreaDisplayList[i].StaticPara, &item->StaticPara, sizeof (CenterAreaDisplayList[i].StaticPara));
    memcpy(&CenterAreaDisplayList[i].DyncPara, &item->DyncPara, sizeof (CenterAreaDisplayList[i].DyncPara));
    for ( j = 0; j < SAME_TIME_DISPLAY_NUM; j ++) 
    {
        CenterAreaDisplayList[j].CurDisplayFlag = 0;
    }
    CenterAreaDisplayList[i].CurDisplayFlag = 1;
    CenterAreaDisplayList[i].DisplayType = item->DisplayType;
    LastDisplayType = CenterAreaDisplayList[i].DisplayType;
}

static void ExecCenterAreaPic(CENTER_AREA_DISPLAY_ITEM *pItem, uint8_t StaticOrDync)
{
    uint8_t j = 0;
    uint8_t Brightness = 0;
    int16_t TargetX = 0;
    int16_t TargetY = 0;
    uint16_t FadeInStartTime = 200;     //FadeInEndTime - FadeInStartTime = 200(only 200),FadeInEndTime <= CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT
    uint16_t FadeInEndTime = 400;
    uint16_t FadeOutStartTime = 400;    //FadeOutStartTime - FadeOutEndTime = 200(only 200),FadeOutEndTime >= 0
    uint16_t FadeOutEndTime = 200;
    uint8_t FadeInOffsetEffect = pItem->FadeInOffsetEffect;
    uint8_t FadeOutOffsetEffect = pItem->FadeOutOffsetEffect;
    uint8_t FadeInAlphaEffect = pItem->FadeInAlphaEffect;
    uint8_t FadeOutAlphaEffect = pItem->FadeOutAlphaEffect;
    uint8_t FadeInRadiusEffect = pItem->FadeInRadiusEffect;
    int16_t CenterWindowRadius = 119;
    int16_t WinTopYTemp = 0;
    
    CENTER_AREA_DISPLAY_PARA *pPara;
    if (StaticOrDync == CENTER_DISPLAY_PARA_STATIC) 
    {
        pPara = &pItem->StaticPara;
    } 
    else if (StaticOrDync == CENTER_DISPLAY_PARA_DYNC) 
    {
        pPara = &pItem->DyncPara;
        if ((pItem->CurDisplayFlag == 1) && (pItem->AliveDisplaytime == CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT)) 
        {
            FadeInOffsetEffect  = FALSE;
            FadeOutOffsetEffect = FALSE;
            FadeInAlphaEffect   = FALSE;
            FadeOutAlphaEffect  = FALSE;
        }
    }
    
    //���뵭��Ч������̬ͼ ��̬ͼȫ��ˢ�꣬�������������뵭��Ч��
    if((FadeOutAlphaEffect == TRUE || FadeInAlphaEffect == TRUE))
    {
        if (pItem->CurDisplayFlag == 1) 
        {
            if ((pItem->AliveDisplaytime >= FadeInStartTime) && (pItem->AliveDisplaytime < FadeInEndTime)) 
            { 
                if (FadeInAlphaEffect == TRUE) 
                {
                    Brightness = (uint8_t)CartoonLogCalculate(FadeInEndTime - FadeInStartTime - 10, 15, pItem->AliveDisplaytime - FadeInStartTime);
                    if(Brightness < 15)
                    {
                        Brightness += 1;
                    }
                } 
                else 
                {
                    Brightness = 15;
                }
            } 
            else if (pItem->AliveDisplaytime >= FadeInEndTime) 
            {
                Brightness = 15;
            } 
            else if (pItem->AliveDisplaytime < FadeInStartTime) 
            {
                Brightness = 0;
            }
        } 
        else 
        {
            if ((pItem->AliveDisplaytime > FadeOutEndTime) && (pItem->AliveDisplaytime <= FadeOutStartTime)) 
            {
                if (FadeOutAlphaEffect == TRUE) 
                {
                    Brightness = 15 - (uint8_t)CartoonLogCalculate(FadeOutStartTime - FadeOutEndTime - 10, 15, FadeOutStartTime - pItem->AliveDisplaytime);
                } 
                else 
                {
                    Brightness = 0;
                }
            } 
            else if (pItem->AliveDisplaytime > FadeOutStartTime) 
            {
                Brightness = 15;
            } 
            else if (pItem->AliveDisplaytime <= FadeOutEndTime) 
            {
                Brightness = 0;
            }
        }
    }
    for (j = 0; j < EACH_SURFACE_CONTAIN_PIC_NUM; j++) 
    {
        if (pPara->DisplayPic[j]) 
        {
            TargetX = pPara->DisplayPicOffsetX[j];
            TargetY = pPara->DisplayPicOffsetY[j];
            if (FadeInOffsetEffect == TRUE && FadeOutOffsetEffect == TRUE)
            {
                if (pItem->CurDisplayFlag == 1) 
                {
                    if ((pItem->AliveDisplaytime >= FadeInStartTime) && (pItem->AliveDisplaytime < FadeInEndTime)) 
                    {
                        if (FadeInOffsetEffect == TRUE) 
                        {
                            TargetX = (int16_t)(pPara->DisplayPicOffsetX[j]) + (30 - (int16_t)CartoonLogCalculate(FadeInEndTime - FadeInStartTime, 30, pItem->AliveDisplaytime - FadeInStartTime))* pItem->FadeInXStep;
                            TargetY = (int16_t)(pPara->DisplayPicOffsetY[j]) + (14 - (int16_t)CartoonLogCalculate(FadeInEndTime - FadeInStartTime, 14, pItem->AliveDisplaytime - FadeInStartTime))* pItem->FadeInYStep;   
                            g_DrawInfo.Luminance = Brightness;                        
                        } 
                        else 
                        {
                            TargetX = pPara->DisplayPicOffsetX[j];
                            TargetY = pPara->DisplayPicOffsetY[j];
                            g_DrawInfo.Luminance = 15;
                        }
                    } 
                    else if (pItem->AliveDisplaytime >= FadeInEndTime) 
                    {
                        TargetX = pPara->DisplayPicOffsetX[j];
                        TargetY = pPara->DisplayPicOffsetY[j];
                        g_DrawInfo.Luminance = 15;
                    } 
                    else if (pItem->AliveDisplaytime < FadeInStartTime) 
                    {
                        TargetX = 800;
                        TargetY = 480;
                        g_DrawInfo.Luminance = 0;
                    }
                } 
                else 
                {
                    if ((pItem->AliveDisplaytime > FadeOutEndTime) && (pItem->AliveDisplaytime <= FadeOutStartTime)) 
                    {
                        if (FadeOutOffsetEffect == TRUE) 
                        {
                            TargetX = (int16_t)(pPara->DisplayPicOffsetX[j]) - ((int16_t)CartoonLogCalculate(FadeOutStartTime - FadeOutEndTime, 30, FadeOutStartTime - pItem->AliveDisplaytime)) * pItem->FadeInXStep;
                            TargetY = (int16_t)(pPara->DisplayPicOffsetY[j]) - ((int16_t)CartoonLogCalculate(FadeOutStartTime - FadeOutEndTime, 14, FadeOutStartTime - pItem->AliveDisplaytime)) * pItem->FadeInYStep;
                            g_DrawInfo.Luminance = Brightness;
                        } 
                        else 
                        {
                            TargetX = pPara->DisplayPicOffsetX[j];
                            TargetY = pPara->DisplayPicOffsetY[j];
                            g_DrawInfo.Luminance = 15;
                        }
                    } 
                    else if (pItem->AliveDisplaytime > FadeOutStartTime) 
                    {
                        TargetX = pPara->DisplayPicOffsetX[j];
                        TargetY = pPara->DisplayPicOffsetY[j];
                        g_DrawInfo.Luminance = 15;
                    } 
                    else if (pItem->AliveDisplaytime <= FadeOutEndTime) 
                    {
                        TargetX = 800;
                        TargetY = 480;
                        g_DrawInfo.Luminance = 0;
                    }
                }
            } 
            else if(FadeOutOffsetEffect == TRUE)
            {
                if (pItem->CurDisplayFlag == 1 && Flag_FadeOutTemp_Init == 1) 
                {
                    TargetX = pPara->DisplayPicOffsetX[j];
                    TargetY = pPara->DisplayPicOffsetY[j];
                    g_DrawInfo.Luminance = 15;
                    if(pPara->DisplayWindow[j].WinTopY < FadeOutTemp + UP_BOTTOM_Y + 2)
                    {
                        WinTopYTemp = FadeOutTemp + UP_BOTTOM_Y + 2;
                        if(WinTopYTemp >= pPara->DisplayWindow[j].WinBottomY)
                        {
                            TargetX = 800;
                            TargetY = 480;
                            g_DrawInfo.Luminance = 0;
                        }
                    }
                } 
                else if(pItem->CurDisplayFlag == 0)
                {
                    if ((pItem->AliveDisplaytime > 0) && (pItem->AliveDisplaytime <= 400)) 
                    {
                        TargetX = pPara->DisplayPicOffsetX[j];
                        FadeOutTemp = (int32_t)pItem->AliveDisplaytime * (DOWN_TOP_Y - (UP_BOTTOM_Y + 2 + 1)) / 400;
                        Flag_FadeOutTemp_Init = 1;
                        if(FadeOutTemp < 100)
                        {
                            FadeOutTemp++;
                        }
                        TargetY = FadeOutTemp + pPara->DisplayPicOffsetY[j] + ((UP_BOTTOM_Y + 2 + 1) - DOWN_TOP_Y);
                        g_DrawInfo.Luminance = 15;
                    }
                    else
                    {
                        TargetX = 800;
                        TargetY = 480;
                        g_DrawInfo.Luminance = 0;
                    }
                }
                else if (pItem->CurDisplayFlag == 1 && Flag_FadeOutTemp_Init == 0)
                {
                    TargetX = 800;
                    TargetY = 480;
                    g_DrawInfo.Luminance = 0;
                }
            }
            else if(FadeInRadiusEffect == TRUE)
            {
                if(pItem->CurDisplayFlag == 1)
                {
                    TargetX = pPara->DisplayPicOffsetX[j];
                    TargetY = pPara->DisplayPicOffsetY[j];
                    if(pItem->AliveDisplaytime < CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT)
                    {
                        CenterWindowRadius = (int16_t)CartoonLogCalculate(400, 119, pItem->AliveDisplaytime);
                        g_DrawInfo.Luminance = (uint8_t)CartoonLogCalculate(400, 15, pItem->AliveDisplaytime);
                        if(g_DrawInfo.Luminance < 15)
                        {
                            g_DrawInfo.Luminance += 1;
                        }
                    }
                    else 
                    {
                        g_DrawInfo.Luminance = 15;
                        CenterWindowRadius = 119;
                    }
                }
                else
                {
                    TargetX = 800;
                    TargetY = 480;
                }
            }
            else 
            {
                if (pItem->CurDisplayFlag == 1) 
                {
                    TargetX = pPara->DisplayPicOffsetX[j];
                    TargetY = pPara->DisplayPicOffsetY[j];
                    g_DrawInfo.Luminance = 15;
                } 
                else 
                {
                    TargetX = 800;
                    TargetY = 480;
                    g_DrawInfo.Luminance = 0;
                }
            }
            if (pItem->DisplayType == CENTER_AREA_DISPLAY_TYPE_NORMAL || pItem->DisplayType == CENTER_AREA_DISPLAY_TYPE_ASSIST_LAK || pItem->DisplayType == CENTER_AREA_DISPLAY_TYPE_ASSIST_DAW) 
            {
                SET_DRAW_INFO(TargetX, TargetY, pPara->DisplayPic[j], 0, 0);
                if(WinTopYTemp == 0)
                {
                    GUI_DrawDispFunc(pPara->BrushType[j], pPara->DisplayWindow[j].WinLeftX, pPara->DisplayWindow[j].WinRightX, pPara->DisplayWindow[j].WinTopY, pPara->DisplayWindow[j].WinBottomY);
                }
                else
                { 
                    GUI_DrawDispFunc(pPara->BrushType[j], pPara->DisplayWindow[j].WinLeftX, pPara->DisplayWindow[j].WinRightX, WinTopYTemp, pPara->DisplayWindow[j].WinBottomY);
                }
            } 
            else if (pItem->DisplayType == CENTER_AREA_DISPLAY_TYPE_USM) 
            {
                SET_DRAW_INFO(TargetX, TargetY, pPara->DisplayPic[j], 0, 0);
                if(WinTopYTemp == 0)
                {
                    GUI_DrawDispFunc(pPara->BrushType[j], pPara->DisplayWindow[j].WinLeftX, pPara->DisplayWindow[j].WinRightX, pPara->DisplayWindow[j].WinTopY, pPara->DisplayWindow[j].WinBottomY);
                }
                else
                { 
                    GUI_DrawDispFunc(pPara->BrushType[j], pPara->DisplayWindow[j].WinLeftX, pPara->DisplayWindow[j].WinRightX, WinTopYTemp + 2, pPara->DisplayWindow[j].WinBottomY);
                }
            }
            else if(pItem->DisplayType == CENTER_AREA_DISPLAY_TYPE_EVENT)
            {
                /*if(pItem->CurDisplayFlag == 1)
                {
                if(pItem->AliveDisplaytime < CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT)
                {
                CenterWindowRadius = (int16_t)CartoonLogCalculate(400, 119, pItem->AliveDisplaytime);
                SET_DRAW_INFO(TargetX, TargetY, pPara->DisplayPic[j], 0, 0);
                g_DrawInfo.Luminance = (uint8_t)CartoonLogCalculate(400, 15, pItem->AliveDisplaytime);
                if(g_DrawInfo.Luminance < 15)
                {
                g_DrawInfo.Luminance += 1;
            }
                GUI_DrawDispFunc(pPara->BrushType[j], 119 - CenterWindowRadius, 120 + CenterWindowRadius, UP_BOTTOM_Y, DOWN_TOP_Y);
            }
                    else 
                {
                g_DrawInfo.Luminance = 15;
                SET_DRAW_INFO(TargetX, TargetY, pPara->DisplayPic[j], 0, 0);
                GUI_DrawDispFunc(pPara->BrushType[j], LEFT_X_START, RIGHT_X_END, UP_BOTTOM_Y, DOWN_BOTTOM_Y);
            }
            }
                else
                {
                SET_DRAW_INFO(TargetX, TargetY, pPara->DisplayPic[j], 0, 0);
                GUI_DrawDispFunc(pPara->BrushType[j], LEFT_X_START, RIGHT_X_END, UP_BOTTOM_Y + 1, DOWN_BOTTOM_Y);
            }*/
                SET_DRAW_INFO(TargetX, TargetY, pPara->DisplayPic[j], 0, 0);
                if(WinTopYTemp == 0)
                {
                    if(Flag_FadeOutTemp_Init == 0)
                    {
                        GUI_DrawDispFunc(pPara->BrushType[j], 119 - CenterWindowRadius, 120 + CenterWindowRadius, UP_BOTTOM_Y, DOWN_TOP_Y);
                    }
                    else
                    {
                        GUI_DrawDispFunc(pPara->BrushType[j], 119 - CenterWindowRadius, 120 + CenterWindowRadius, UP_BOTTOM_Y + 2, DOWN_TOP_Y);
                    }
                }
                else
                { 
                    GUI_DrawDispFunc(pPara->BrushType[j], pPara->DisplayWindow[j].WinLeftX, pPara->DisplayWindow[j].WinRightX, WinTopYTemp, pPara->DisplayWindow[j].WinBottomY);
                }
            }
        }
    } 
}

static void UpdateCenterAreaPicData(void)
{
    uint8_t i;
    
    for (uint8_t i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if (CenterAreaDisplayList[i].CurDisplayFlag == 1) 
        {
            if (CenterAreaDisplayList[i].AliveDisplaytime < CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT) 
            {
                if ((CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT - CenterAreaDisplayList[i].AliveDisplaytime) > TFT_BilnkTimerDelta) 
                {
                    CenterAreaDisplayList[i].AliveDisplaytime += TFT_BilnkTimerDelta;
                } 
                else 
                {
                    CenterAreaDisplayList[i].AliveDisplaytime = CENTER_AREA_DISPLAY_ALIVE_TIME_DEFAULT;
                }
            }
        } 
        else 
        {
            if (CenterAreaDisplayList[i].AliveDisplaytime > TFT_BilnkTimerDelta) 
            {
                CenterAreaDisplayList[i].AliveDisplaytime -= TFT_BilnkTimerDelta;
            }
            else 
            {
                CenterAreaDisplayList[i].AliveDisplaytime = 0;
            }
        }
    }
    /* xxhh add1
    if(GroupTabPara.GroupTabJumptime > TFT_BilnkTimerDelta)
    {
    GroupTabPara.GroupTabJumptime -= TFT_BilnkTimerDelta;
}
    else
    {
    GroupTabPara.GroupTabJumptime = 0;
}
    */
    for (i = 0; i < SAME_TIME_DISPLAY_NUM; i++) 
    {
        if ((CenterAreaDisplayList[i].CurDisplayFlag == 1) || (CenterAreaDisplayList[i].AliveDisplaytime)) 
        {
            ExecCenterAreaPic(&CenterAreaDisplayList[i], CENTER_DISPLAY_PARA_STATIC);
            ExecCenterAreaPic(&CenterAreaDisplayList[i], CENTER_DISPLAY_PARA_DYNC);
        } 
        else 
        {
            CenterAreaDisplayList[i].AliveDisplaytime = 0;
            CenterAreaDisplayList[i].DisplayType = 0;
            CenterAreaDisplayList[i].CurDisplayFlag = 0;
            memset(&CenterAreaDisplayList[i].StaticPara, 0, sizeof (CenterAreaDisplayList[i].StaticPara));
            memset(&CenterAreaDisplayList[i].DyncPara, 0, sizeof (CenterAreaDisplayList[i].DyncPara));
        }
    }
}





/*-------------------------------------------------------------------------
*	Function Name	: void GUI_DrawDispFunc
*	Description: ����ˢͼ����
*	Input:  func_num   ��ʾ����
*               LeftX      ��ͼ�����������
*               RightX     ��ͼ�����ұ�����
*               WinTopY    ��ͼ����Y��������
*               WinBottomY     ��ͼ����Y��������
*	Output	: None
*	Return	: None
*	onther	:
--------------------------------------------------------------------------*/
void GUI_DrawDispFunc(uint8_t func_num, uint16_t LeftX, uint16_t RightX, uint16_t WinTopY, uint16_t WinBottomY)
{
    switch(func_num)
    {
        case 0:
        Api_SetDrawWindow(&g_DrawInfo,LeftX,RightX,WinTopY,WinBottomY);
        Api_DrawIcon(&g_DrawInfo);
        break;
        case 1:
        Api_DrawMinAlphaIcon(&g_DrawInfo);
        break;
        case 2:
        Api_SetDrawWindow(&g_DrawInfo,LeftX,RightX,WinTopY,WinBottomY);
        Api_DrawWindowMinAlphaIcon(&g_DrawInfo);
        break;
        case 3:
        g_DrawInfo.Img_with = 222;
        g_DrawInfo.Img_high = 190;//180;
        Api_DrawConstMaxAlpha(&g_DrawInfo);
        break;
        case 4:
        Api_SetDrawWindow(&g_DrawInfo,LeftX,RightX,WinTopY,WinBottomY);
        Api_DrawMaxAlphaChannelIcon(&g_DrawInfo);
        break;
        case 5:
        Api_SetDrawWindow(&g_DrawInfo,LeftX,RightX,WinTopY,WinBottomY);
        Api_DrawAlphaChannelIcon(&g_DrawInfo);
        break;
        case 6:
        Api_DrawEdgeMinAlphaIcon(&g_DrawInfo);
        break;
        case 7:
        Api_SetDrawWindow(&g_DrawInfo,LeftX,RightX,WinTopY,WinBottomY);
        Api_DrawCenterSpreadIcon(&g_DrawInfo);
        break;
        case 8:
        Api_DrawMinAlphaLuminIcon(&g_DrawInfo);
        break;
        case 9:
        Api_DrawConstMaxAlpha(&g_DrawInfo);
        break;
        case 10:
        Api_SetDrawWindow(&g_DrawInfo,LeftX,RightX,WinTopY,WinBottomY);
        Api_DrawLuminIcon(&g_DrawInfo);
        break;
        case 11:
        Api_SetDrawWindow(&g_DrawInfo,LeftX,RightX,WinTopY,WinBottomY);
        Api_DrawWindowMinAlphaLuminIcon(&g_DrawInfo);
        break;
        default:
        break;
    }
}

unsigned int gui_num(uint8_t num)
{
    unsigned int return_num;
    switch(num)
    {
        case 0x30:
        return_num = 0;
        break;
        case 0x31:
        return_num = 1;
        break;
        case 0x32:
        return_num = 2;
        break;
        case 0x33:
        return_num = 3;
        break;
        case 0x34:
        return_num = 4;
        break;
        case 0x35:
        return_num = 5;
        break;
        case 0x36:
        return_num = 6;
        break;
        case 0x37:
        return_num = 7;
        break;
        case 0x38:
        return_num = 8;
        break;
        case 0x39:
        return_num = 9;
        break;
        case 0x40:
        return_num = 17;
        break;
        case 0x41:
        return_num = 18;
        break;
        case 0x2E:
        return_num = 43;
        break;
        default:
        break;
    }
    return return_num;
}


unsigned int Dispaly_N(unsigned int data)
{
    unsigned int return_buf;
    switch((data)){
        case 0:
        return_buf = 0;
        break;
        case 1:
        return_buf = 1000;
        break;
        case 2:
        return_buf = 2000;
        break;
        case 3:
        return_buf = 3000;
        break;
        case 4:
        return_buf = 4000;
        break;
        case 5:
        return_buf = 5000;
        break;
        case 6:
        return_buf = 6000;
        break;
        case 7:
        return_buf = 6000;
        break;
        case 8:
        return_buf = 6000;
        break;
        case 9:
        return_buf = 6000;
        break;
        case 10:
        case 11:
        case 12:
        return_buf = 6000;
        break;
        default:
        return_buf = 0;
        break;
        
    }
    return return_buf;
}


#define START_B 0x690
#define STOP 0x18EB
static const uint16_t BarCodeList[] = {
    0x6CC, 0x66C, 0x666, 0x498, 0x48C, 0x44C, 0x4C8, 0x4C4, 0x464, 0x648, 
    0x644, 0x624, 0x59C, 0x4DC, 0x4CE, 0x5CC, 0x4EC, 0x4E6, 0x672, 0x65C, 
    0x64E, 0x6E4, 0x674, 0x76E, 0x74C, 0x72C, 0x726, 0x764, 0x734, 0x732, 
    0x6D8, 0x6C6, 0x636, 0x518, 0x458, 0x446, 0x588, 0x468, 0x462, 0x688, 
    0x628, 0x622, 0x5B8, 0x58E, 0x46E, 0x5D8, 0x5C6, 0x476, 0x776, 0x68E, 
    0x62E, 0x6E8, 0x6E2, 0x6EE, 0x758, 0x746, 0x716, 0x768, 0x762, 0x71A, 
    0x77A, 0x642, 0x78A, 0x530, 0x5C, 0x4B0, 0x486, 0x42C, 0x426, 0x590, 
    0x584, 0x4D0, 0x4C2, 0x434, 0x432, 0x612, 0x650, 0x7BA, 0x614, 0x47A, 
    0x53C, 0x4BC, 0x49E, 0x5E4, 0x4F4, 0x4F2, 0x7A4, 0x794, 0x792, 0x6DE, 
    0x6F6, 0x7B6, 0x578, 0x51E, 0x45E, 0x5E8, 0x5E2, 0x7A8, 0x7A2, 0x5DE, 
    0x5EE, 0x75E, 0x7AE, 0x684, 0x690, 0x69C, 0x18EB
};

static const uint16_t BarCharList[] = {
    0, '!', '\"', '#', '$', '%', '&', '\'', '(', ')', 
    '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', 
    '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', 
    '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 
    'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 
    'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', 
    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 
    'f', 'g', 'h', 'i', 'j', 'k', 'I', 'm', 'n', 'o', 
    'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 
    'z', '{', '|', '}', '~', 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0
};

static void Encode(uint8_t *SrcBuf, uint8_t len, uint16_t *DestBuf)
{
    uint8_t num = 0;
    uint32_t CheckBit = 104;    //startb 104
    memset((void*)DestBuf, 0, len * 2);
    DestBuf[num++] = START_B;
    for (uint8_t i = 0; i < len; i++) {
        for (uint8_t n = 0; n < (sizeof (BarCharList) / sizeof (BarCharList[0])); n++) {
            if ((SrcBuf[i] != 0) && (SrcBuf[i] == BarCharList[n])) {
                CheckBit += n * num;
                DestBuf[num++] = BarCodeList[n];
                break;
            }
        }
    }
    DestBuf[num++] = BarCodeList[CheckBit % 103];
    DestBuf[num++] = STOP;
}

#define BAR_CODE_H 30
#define BAR_CODE_W 220
#define BAR_CODE_START_POS 10
#define BAR_CODE_TAIL_LEN 10
uint8_t BarCodePic[BAR_CODE_W * BAR_CODE_H + 4];
static void GenerateBarCodePic(uint16_t *DestBuf, uint8_t len)
{
    uint16_t TmpPos = 4;
    uint16_t Offset = 0;
    memset(BarCodePic, 0, sizeof (BarCodePic));
    *((uint16_t*)&BarCodePic[0]) = BAR_CODE_W;
    *((uint16_t*)&BarCodePic[2]) = BAR_CODE_H;
    
    if ((len * 11 + 2) <= (BAR_CODE_W - BAR_CODE_START_POS - BAR_CODE_TAIL_LEN)) {
        Offset = ((BAR_CODE_W - BAR_CODE_START_POS - BAR_CODE_TAIL_LEN) / 2) - ((len * 11 + 2) / 2);
        for (uint8_t i = 0; i < len; i++) {
            if (DestBuf[i] != 0) {
                if (DestBuf[i] == STOP) {
                    for (uint8_t n = 0; n < 13; n++) {
                        if (DestBuf[i] & (1 << (12 - n))) {
                            for (uint8_t j = 0; j < ((BAR_CODE_H / 2) - 2); j++) {
                                BarCodePic[BAR_CODE_START_POS + TmpPos + (j + 1) * BAR_CODE_W + Offset] = 0xff;
                            }
                        }
                        TmpPos++;
                    }
                } else {
                    for (uint8_t n = 0; n < 11; n++) {
                        if (DestBuf[i] & (1 << (10 - n))) {
                            for (uint8_t j = 0; j < ((BAR_CODE_H / 2) - 2); j++) {
                                BarCodePic[BAR_CODE_START_POS + TmpPos + (j + 1) * BAR_CODE_W + Offset] = 0xff;
                            }
                        }
                        TmpPos++;
                    }
                }
            }
        }
    }
}



uint32_t Time_1K;
uint16_t Diaplay_test;
uint16_t Charge_Value;
extern uint16_t DisplayVehicleSpeedOutput;//�����ⷢ
extern uint16_t DisPlayBatteryVoltageOutPut;//���ص�ѹ���
extern uint16_t DisPlayHandBrakeSystemStsOutput;//�ֶ��ƶ�״̬���
extern uint8_t DisPlayMessageCounterOutPut;//MessageCounter���
uint32_t DisPlayTotalOdometerOutPut;//����ܼ���� 
extern uint8_t DisPlayAirBagLampFailStsOutPut;//��ȫ����
extern uint8_t DisPlayICM_DriverSeatBeltSwitchOutPut;//��ʻ�లȫ��
extern uint8_t DisPlayBrakeFluidOutPut;//�ƶ�Һλ��


uint8_t Diaplay_Flag = 0;
uint8_t g_Stage,g_OldStage;
extern uint8_t LED_Flag,Speed_Tester, Freque_Flag;;
extern uint16_t DisplaySpeed , DisplaySpeed1 , DisplaySpeed2  ; 
extern volatile uint8_t Time_500ms_Flag;
_StaticCurrent   StaticCurrent; 
_StaticCurrent   ButtomCurrent; 
_StaticCurrent   LedCurrent;
_StaticCurrent   SpeedCurrent;
_StaticCurrent   Iol_TempCurrent;
_StaticCurrent   TFTCurrent;
_StaticCurrent   Back_lightCurrent;
_StaticCurrent   LuminosityCurrent;
_StaticCurrent   LCDCurrent;
_StaticCurrent   TftCurrent;
_StaticCurrent   ElseCurrent;
_StaticCurrent   EndCurrent;
_StaticCurrent   OKKeyCurrent;
_StaticCurrent   UPKeyCurrent;
_StaticCurrent   DOWNKeyCurrent;
_StaticCurrent   LONGOKKeyCurrent;

_StaticCurrent   PressKeyStruct;
_StaticCurrent   SpeedOutPutNum;
_StaticCurrent   VolOutPutNum;
_StaticCurrent   AirBagLampFail;
_StaticCurrent   MessageCounterNum;

_StaticCurrent   HandBreakOutPutNum;
_StaticCurrent   DriverSeatBeltOutPutNum;
_StaticCurrent   DriverLow_BrakeOutPutNum;


_StaticCurrent   HJ_OtherKeyCurrent;//OtherKey




_KeyStruct       KeyStruct;
_BuzzerCurrent   BuzzerAlarm;
_BuzzerCurrent   CheckCurrent;
uint16_t Freque_Count;

uint8_t TestSrcBuf[20] = "";
uint16_t TestDestBuf[128];

#define ErrorBlink_S(x,y) \
if(Time_Charge_1s % 2 == 0) {\
    SetDisplayDynamicItemW2(WRONG_S, x, y, DRAW_LUMIN_ICOM_WINDOW);\
}

#define ErrorBlink(x,y) \
if(Time_Charge_1s % 2 == 0) {\
    SetDisplayDynamicItemW2(PW2_03, x, y, DRAW_LUMIN_ICOM_WINDOW);\
}

void DisplayString(const char *pStr,int iPos,int iStartX,int iStartY)
{
    for(uint8_t i = 0; i < strlen(pStr); i++)
    {
        uint32_t tmp = AIISCList[0];
        if(pStr[i] >= 0x30 && pStr[i] <= 0x5A)
        {
            tmp = AIISCList[(pStr[i] - 0x30)];
        }
        if(1 == iPos)
            SetDisplayStaticItemW1(tmp, iStartX + (i * 18), iStartY + 4, DRAW_LUMIN_ICOM_WINDOW);
        else if(2 == iPos)
            SetDisplayStaticItemW2(tmp, iStartX + (i * 18), iStartY + 4, DRAW_LUMIN_ICOM_WINDOW);
        else if(3 == iPos)
            SetDisplayStaticItemW3(tmp, iStartX + (i * 18), iStartY + 4, DRAW_LUMIN_ICOM_WINDOW);
        else
            SetDisplayStaticItemW2(tmp, iStartX + (i * 18), iStartY + 4, DRAW_LUMIN_ICOM_WINDOW);
    }
}

void SetDisplayDMS(const char *pDmsName)
{
     DspOneLineDynamicStr(pDmsName,9,106);  
}

void SetDisplayBVM(const char *pDmsName)
{
    DspOneLineDynamicStr(pDmsName,9,106);   
}

void SetDisplayPDW3(void)
{
    if (g_UI_Language == UI_CHINESE) {
        SetDisplayDynamicItemW2(PDWLV3_CHECK,9, 106, DRAW_LUMIN_ICOM_WINDOW);     //�����״�ȼ�3
    }
    else if (g_UI_Language == UI_ENGLISH) {
        //SetDisplayDynamicItemW2(PDWLV3_CHECK_EN,9, 106, DRAW_LUMIN_ICOM_WINDOW);     //�����״�ȼ�3
        DspOneLineDynamicStr("Radar sound level3",9,106);   
    }
}

void SetCheckBenchVersion(void)
{
    DspOneLineStaticStr(CluPartNum,        CHECK_VERSION_X,        CHECK_VERSION_Y);
    DspOneLineStaticStr(RELEASE_VERS,      CHECK_VERSION_X + 147,  CHECK_VERSION_Y);
    DspOneLineStaticStr(RELEASE_DATE_TIME, CHECK_VERSION_X,        CHECK_VERSION_Y + 14);
}

void DspStepSerialNumber(uint16_t uiIdx)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    sprintf(uiDspInfo,"%4d",uiIdx);
    DspOneLineDynamicStr(uiDspInfo, 192,  63); 
}

uint8_t g_szCheckBenchName[14];
#if (SEMI_AUTOMATIC_STAGE)
void UpdatePerFunctionExecTimer(void)
{
      uint8_t uiDspInfo[17];
      uiDspInfo[0]=0;
      sprintf(uiDspInfo,"Wait:%dS", g_PerFuncExecSecond);
      DspOneLineDynamicStr(uiDspInfo, CHECK_NAME_BASEX,  CHECK_NAME_BASEY); 
}
#endif
void UpdateTitle(void)
{
#if (PRO_CONFIG_CHECK_APPLY)
#if (SEMI_AUTOMATIC_STAGE)
    if (g_PerFuncExecSecond == 0) {
        DspOneLineStaticStr(g_szCheckBenchName, 0, CHECK_NAME_BASEY);
        if (g_UI_Language == UI_ENGLISH) {
            SetDisplayStaticItemW1(TestBenchEn, 110, 0, DRAW_LUMIN_ICOM_WINDOW);//���̨       
        } else {
            SetDisplayStaticItemW1(TestBench, 155, 0, DRAW_LUMIN_ICOM_WINDOW);//���̨       
        }
    } else {
        UpdatePerFunctionExecTimer();
    }
#else
    DspOneLineStaticStr(g_szCheckBenchName, 0, CHECK_NAME_BASEY);

    if (g_UI_Language == UI_ENGLISH) {
        SetDisplayStaticItemW1(TestBenchEn, 110, 0, DRAW_LUMIN_ICOM_WINDOW);//���̨       
    } else {
        SetDisplayStaticItemW1(TestBench, 155, 0, DRAW_LUMIN_ICOM_WINDOW);//���̨       
    }
#endif    
#endif    
#if (PRO_CONFIG_EOL_APPLY)
    DspOneLineStaticStr("EOL", 200, 11);
#endif
}


void DisplayStep(uint32_t uiPic)
{
    if (g_UI_Language == UI_CHINESE) {

    }
    else if (g_UI_Language == UI_ENGLISH) {
        SetDisplayStaticItemW1(uiPic,  FUNC_X,  FUNC_Y, DRAW_LUMIN_ICOM_WINDOW);
    }
}


void General_Display(void)
{
    uint8_t uiStage = 0;
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    UpdateTitle();
    if(g_Stage == 0)
        SetCheckBenchVersion();//���̨�汾��
    SetDisplayStaticItemW1(P_Line,   0,  30, DRAW_LUMIN_ICOM_WINDOW);            // ����
    if(Diaplay_test >= 999) {
        Diaplay_test = 999;
    }
    sprintf(uiDspInfo,"%3d",Diaplay_test);
    DspOneLineStaticStr(uiDspInfo, 130,  42); 

    //switch(App_CalDataLen(Diaplay_test)) //�������
    //{
    //    case 3:
    //        SetDisplayDynamicItemW1(NumberList[Diaplay_test /100%10], 122,  35, DRAW_LUMIN_ICOM_WINDOW); //������� ��λ
    //    case 2:
    //        SetDisplayDynamicItemW1(NumberList[Diaplay_test /10%10],  137,  35, DRAW_LUMIN_ICOM_WINDOW); //������� ʮλ
    //    case 1:
    //        SetDisplayDynamicItemW1(NumberList[Diaplay_test % 10],    152,  35, DRAW_LUMIN_ICOM_WINDOW); //������� ��λ
    //} 
    if (g_UI_Language == UI_ENGLISH) {
        SetDisplayStaticItemW1(CumulativeCheckClusterEn,   0,  32, DRAW_LUMIN_ICOM_WINDOW);            //�ۼƼ��
        //SetDisplayStaticItemW1(State,   0,  80, DRAW_LUMIN_ICOM_WINDOW);            //״̬
    } else {
        SetDisplayStaticItemW1(CumulativeCheckCluster,   0,  32, DRAW_LUMIN_ICOM_WINDOW);   //�ۼƼ��
        if(g_Stage == STAGE_SetEOL)
        {
            DspOneLineStaticStr(Test_array, FUNC_X+30, 150);
        }
        else
        {
            DspOneLineStaticStr(Test_array, FUNC_X+30, FUNC_Y);         //sn
        }
        if(g_Stage == STAGE_OilDown && RxFinish == FINISH)
        {
            DspOneLineStaticStr(MultiplePack.Data, FUNC_X+30, 150);
        }
       
        //SetDisplayStaticItemW1(State,   0,  80, DRAW_LUMIN_ICOM_WINDOW);            //״̬
    }
    
    
    //DisplayStep(g_Stage);
    
    
    SetDisplayStaticItemW2(P_Line,   0, 103, DRAW_LUMIN_ICOM_WINDOW);            // ����
    SetDisplayStaticItemW2(P_Line,   0, 291, DRAW_LUMIN_ICOM_WINDOW);            // ����

}

void DisplayCSW_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    sprintf(uiDspInfo,"CSW:%d,%d,%d",CSW_Data[0],CSW_Data[1],CSW_Data[2]);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);
    
}

void CompilationDate_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    sprintf(uiDspInfo,"%x%x%x%x",g_CompileDateTime[0],g_CompileDateTime[1],g_CompileDateTime[2],g_CompileDateTime[3]);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);
    
}
void DisplayStaticCurrent_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    //��̬����
    sprintf(uiDspInfo,"SC:%4d.%dmA",StaticCurrentNum/10,StaticCurrentNum % 10);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine); 
    
    if(StaticCurrent.Finsh == 1){
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(StaticCurrent.Finsh == 2) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}


void DisPlayTempNum(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    switch(Iol_TempCurrent.count)
    {
        case 1:
        sprintf(uiDspInfo,"-40",DisPlayCurSpeeds);
        break;
        case 2:
        sprintf(uiDspInfo,"-32",DisPlayCurSpeeds);
        break;
        case 3:
        sprintf(uiDspInfo,"23",DisPlayCurSpeeds);
        break;
        case 4:
        sprintf(uiDspInfo,"14",DisPlayCurSpeeds);
        break;
        case 5:
        sprintf(uiDspInfo,"11",DisPlayCurSpeeds);
        break;
    }
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine); 
}

void DisPlayChargingPower(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    switch(Iol_TempCurrent.count)
    {
        case 1:
        sprintf(uiDspInfo,"11",DisPlayCurSpeeds);
        break;
        case 2:
        sprintf(uiDspInfo,"22",DisPlayCurSpeeds);
        break;
        case 3:
        sprintf(uiDspInfo,"33",DisPlayCurSpeeds);
        break;
        case 4:
        sprintf(uiDspInfo,"44",DisPlayCurSpeeds);
        break;
        case 5:
        sprintf(uiDspInfo,"0",DisPlayCurSpeeds);
        break;
    }
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine); 
}

void DisPlayChargingTime(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    switch(Iol_TempCurrent.count)
    {
        case 1:
        sprintf(uiDspInfo,"01:06 ",DisPlayCurSpeeds);
        break;
        case 2:
        sprintf(uiDspInfo,"10:00 ",DisPlayCurSpeeds);
        break;
        case 3:
        sprintf(uiDspInfo,"19:59 ",DisPlayCurSpeeds);
        break;
        case 4:
        sprintf(uiDspInfo,"19:59 ",DisPlayCurSpeeds);
        break;
        case 5:
        sprintf(uiDspInfo,"00:06 ",DisPlayCurSpeeds);
        break;
    }
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine); 
}

extern uint8_t CAN_0x430;
void HandBrakeSystemStsOutPut(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;

    //DisPlayHandBrakeSystemStsOutput = ICM_DisplayVehicleSpeed.msg.bits.ICM_HandBrakeSystemSts;
    sprintf(uiDspInfo,"HandBrake: %4d",DisPlayHandBrakeSystemStsOutput);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
    if(HandBreakOutPutNum.Finsh == 1){
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(HandBreakOutPutNum.Finsh == 2) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}


void MessageCounterOutPut(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    
    sprintf(uiDspInfo,"Counter: %4d",DisPlayMessageCounterOutPut);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
    if(MessageCounterNum.Finsh == 1){
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(MessageCounterNum.Finsh == 2) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}

void BatteryVoltageOutPut(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    
    sprintf(uiDspInfo,"BatVol: %4dV",DisPlayBatteryVoltageOutPut);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
    if(VolOutPutNum.Finsh == 1){
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(VolOutPutNum.Finsh == 2) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}

void TotalOdometerOutPut(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    DisPlayTotalOdometerOutPut = (ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L << 16) + (ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L2 << 8) + ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L3;
    sprintf(uiDspInfo,"ODO: %6dkm",DisPlayTotalOdometerOutPut);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
    if(CAN_0x430 == 1){
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(CAN_0x430== 0) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
    
}

void AirBagLampFailStsReservedOutPut(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    
    sprintf(uiDspInfo,"AirBagLp: %4d",DisPlayAirBagLampFailStsOutPut);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
    if(AirBagLampFail.Finsh == 1){
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(AirBagLampFail.Finsh == 2) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}

void DriverSeatBeltSwitchOutPut(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    // DisPlayICM_DriverSeatBeltSwitchOutPut = ICM_DisplayVehicleSpeed.msg.bits.ICM_DriverSeatBeltSwitch;
    sprintf(uiDspInfo,"SeatBelt: %4d",DisPlayICM_DriverSeatBeltSwitchOutPut);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
    if(DriverSeatBeltOutPutNum.Finsh == 1){
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(DriverSeatBeltOutPutNum.Finsh == 2) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}

void Low_Brake_FluidOutPut(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    //DisPlayBrakeFluidOutPut = ICM_DisplayVehicleSpeed.msg.bits.ICM_Low_Brake_Fluid;
    sprintf(uiDspInfo,"LowBrake: %4d",DisPlayBrakeFluidOutPut);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);   
    if(DriverLow_BrakeOutPutNum.Finsh == 1){
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(DriverLow_BrakeOutPutNum.Finsh == 2) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}

void DisplaySpeedInfoOutPut(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    //DisplayVehicleSpeedOutput = ((ICM_DisplayVehicleSpeed.msg.bits.ICM_DisplayVehicleSpeed_L << 8) + ICM_DisplayVehicleSpeed.msg.bits.ICM_DisplayVehicleSpeed_H)*0.0625;
    sprintf(uiDspInfo,"Speed: %4dkm/h",DisplayVehicleSpeedOutput);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
    if(SpeedOutPutNum.Finsh == 1){
    SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(CAN_0x430 == 2) {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}


void DisplaySpeedInfo_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    // ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x00;
    // ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xA0;
    // CanSendCan0Msg(0x2E9,  ESP_ABS_FailSts, 8,1);
    DisplayVehicleSpeedOutput = ((ICM_DisplayVehicleSpeed.msg.bits.ICM_DisplayVehicleSpeed_L << 8) + ICM_DisplayVehicleSpeed.msg.bits.ICM_DisplayVehicleSpeed_H)*0.0625;
    sprintf(uiDspInfo,"%4d  km/h",DisplayVehicleSpeedOutput);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
}
void DisplayPowerInfo_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    switch(LedCurrent.count)
    {
        case 23:
        sprintf(uiDspInfo,"-100 KW");
        break;
        case 24:
        sprintf(uiDspInfo,"-60 KW");
        break;
        case 25:
        sprintf(uiDspInfo,"-30 KW");
        break;
        case 26:
        sprintf(uiDspInfo,"-15 KW");
        break;
        case 27:
        sprintf(uiDspInfo,"0 KW");
        break;
        case 28:
        sprintf(uiDspInfo,"11 KW");
        break;
        case 29:
        sprintf(uiDspInfo,"22 KW");
        break;
        case 30:
        sprintf(uiDspInfo,"33 KW");
        break;
        case 31:
        sprintf(uiDspInfo,"44 KW");
        break;
        case 32:
        sprintf(uiDspInfo,"55 KW");
        break;
        case 33:
        sprintf(uiDspInfo,"66 KW");
        break;
        case 34:
        sprintf(uiDspInfo,"77 KW");
        break;
        case 35:
        sprintf(uiDspInfo,"88 KW");
        break;
        case 36:
        sprintf(uiDspInfo,"100 KW");
        break;
    }
    
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
}
void DisplayElectricityInfo_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    switch(LedCurrent.count)
    {
        case 23:
        sprintf(uiDspInfo,"05 %");
        break;
        case 24:
        sprintf(uiDspInfo,"11 %");
        break;
        case 25:
        sprintf(uiDspInfo,"22 %");
        break;
        case 26:
        sprintf(uiDspInfo,"33 %");
        break;
        case 27:
        sprintf(uiDspInfo,"44 %");
        break;
        case 28:
        sprintf(uiDspInfo,"55 %");
        break;
        case 29:
        sprintf(uiDspInfo,"66 %");
        break;
        case 30:
        sprintf(uiDspInfo,"77 %");
        break;
        case 31:
        sprintf(uiDspInfo,"88 %");
        break;
        case 32:
        sprintf(uiDspInfo,"99 %");
        break;
        case 33:
        sprintf(uiDspInfo,"100 %");
        break;
        case 34:
        sprintf(uiDspInfo,"100 %");
        break;
        case 35:
        sprintf(uiDspInfo,"100 %");
        break;
        case 36:
        sprintf(uiDspInfo,"100 %");
        break;
    }
    
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
}

void DisplayTachoInfo_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    //ת��
   // g_RPM_Val = DisPlayPowerNumBer  / 4;
    sprintf(uiDspInfo,"%4d  RPM",DisPlayCurMotorSpds);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine); 
}

void DisplayFrequency_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;

    Freque_Count = Frequeice.Value;

    sprintf(uiDspInfo,"%4d.%d",Freque_Count / 10,Freque_Count % 10);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
    if(Freque_Flag == 1) //�������Ƶ������
    {
        SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine, DRAW_LUMIN_ICOM_WINDOW);
    }
    else if(Freque_Flag == 2)
    {
        ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, uiDspLine);
    }
}

void DisplayILL_S(uint16_t uiStartX,uint16_t uiDspLine)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    //ILL�ȼ�
#if ((PRO_KS) || (PRO_BR2))
    sprintf(uiDspInfo,"%4d",CanFDDataStruct.CF_Clu_RheostatLevel);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
#else 
    sprintf(uiDspInfo,"%4d",HU_USM_E_04.CF_AVN_CluRheostatLvl);
    DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
#endif
}

void DisplayILL_DutyRatio_S(uint16_t uiStartX,uint16_t uiDspLine)
{

}

uint8_t g_uiStageNum1 = 1;
uint8_t g_uiStageNum2 = 2;
uint8_t g_uiStageNum3 = 3;
uint8_t g_uiStageNum4 = 4;
uint8_t g_uiStageNum5 = 5;

void DisplayBarCode(void)
{
    //if(strlen(TestSrcBuf) > 0) {
    //    Encode(TestSrcBuf, strlen(TestSrcBuf), TestDestBuf);
    //    GenerateBarCodePic(TestDestBuf, strlen(TestSrcBuf) + 3);
    //    SetDisplayStaticItemW2((Base_address + (uint32_t)BarCodePic), 120 - (BAR_CODE_W / 2), BARCODE_Y, DRAW_LUMIN_ICOM_WINDOW); //146
    //}
}

void DisplayPartNum(void)
{
    //Ʒ��>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
    //SetDisplayDynamicItemW2(PW2_10N, 10, PARTNUM_Y, DRAW_LUMIN_ICOM_WINDOW);//N      
    //SetDisplayDynamicItemW2(AIISCList[0]  , 27, PARTNUM_Y, DRAW_LUMIN_ICOM_WINDOW);//O       
    //SetDisplayDynamicItemW2(gImage_point  , 48, PARTNUM_Y+16, DRAW_LUMIN_ICOM_WINDOW);//.   
    //
    //for(uint8_t i = 0; i < 10; i++) {
    //    
    //    uint32_t tmp = AIISCList[0];
    //    
    //    if ((CluPartNum[i] >= 0x30) && (CluPartNum[i] <= 0x5A)) {
    //        tmp = AIISCList[(CluPartNum[i] - 0x30)];
    //    }
    //    
    //    SetDisplayDynamicItemW2(tmp  , 65 + (i*17), PARTNUM_Y, DRAW_LUMIN_ICOM_WINDOW);       
    //}
    //Ʒ��<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    //DspOneLineDynamicStr(CluPartNum, 9, PARTNUM_Y);
}

void DisplayPowerCheck(void)
{
    SetDisplayDynamicItemW2(PowerCheck,  9, 120, DRAW_LUMIN_ICOM_WINDOW);     //��Դ���
    if(PowerCheckFlag == POWER_ABNORMAL) {
      SetDisplayDynamicItemW2(Abnormal,  120, 121, DRAW_LUMIN_ICOM_WINDOW);     //�쳣
    }
    else if(PowerCheckFlag == POWER_CHECKING) {
      SetDisplayDynamicItemW2(NumberList[PowerCheckTimer/10%10], 9,  150, DRAW_LUMIN_ICOM_WINDOW);  // ʮλ
      SetDisplayDynamicItemW2(NumberList[PowerCheckTimer % 10]  , 24,  150, DRAW_LUMIN_ICOM_WINDOW);  //��λ
      
      if(PowerCheckTimer%2 == 0) {
          SetDisplayDynamicItemW2(DoNotPressKey,  120, 121, DRAW_LUMIN_ICOM_WINDOW);     //���𰴼�
      }
    }  
    else if(PowerCheckFlag == POWER_NORMAL || PowerCheckFlag == POWER_CHECK_END) {
      SetDisplayDynamicItemW2(Normal,  120, 118, DRAW_LUMIN_ICOM_WINDOW);     //����
    }  
}

void DspCheckState(uint8_t uiState) 
{
    if (g_UI_Language == UI_CHINESE) {
         switch(uiState) {
            case STATE_CHECKING:
               SetDisplayDynamicItemW1(StateChecking,     0,  78, DRAW_LUMIN_ICOM_WINDOW);//״̬:�����
               break;
            case STATE_CHECKED:
               SetDisplayDynamicItemW1(StateChecked,      0,  77, DRAW_LUMIN_ICOM_WINDOW);//״̬:������
               break;  
            case STATE_CONFIGURING:
               SetDisplayDynamicItemW1(stateConfiguring,  0,  77, DRAW_LUMIN_ICOM_WINDOW);//״̬:������ 
               break;
            case STATE_CONFIGED:
               SetDisplayDynamicItemW1(stateConfigOver,   3,  77, DRAW_LUMIN_ICOM_WINDOW);//״̬:�������
               break; 
           case STATE_CONFIGERROR:
               uint8_t uiDspInfo[16+1];
               uiDspInfo[0]=0;
               sprintf(uiDspInfo,"ERROR",0);
               DspOneLineDynamicStr(uiDspInfo, 9,  150);  
               break;
        }
    }
    else if (g_UI_Language == UI_ENGLISH) {
          switch(uiState) {
            case STATE_CHECKING:
               SetDisplayDynamicItemW1(StateChecking_EN,     0,  74, DRAW_LUMIN_ICOM_WINDOW);//״̬:�����
               break;
            case STATE_CHECKED:
               SetDisplayDynamicItemW1(StateChecked_EN,      0,  75, DRAW_LUMIN_ICOM_WINDOW);//״̬:������
               break;  
            case STATE_CONFIGURING:
               SetDisplayDynamicItemW1(stateConfiguring_EN,  0,  74, DRAW_LUMIN_ICOM_WINDOW);//״̬:������ 
               break;
            case STATE_CONFIGED:
               SetDisplayDynamicItemW1(stateConfigOver_EN,   0,  74, DRAW_LUMIN_ICOM_WINDOW);//״̬:�������
               break;
        }

    }
}

void DspCheckResult(uint8_t uiState)
{    uint8_t uiDspInfo[16+1];
     uiDspInfo[0]=0;
     if (g_UI_Language == UI_CHINESE) {
          switch(uiState) {
             case RESULT_MAN_REVIEW:
                SetDisplayStaticItemW3(CheckResultManualReview,  CHECK_STATE_X,  CHECK_STATE_Y, DRAW_LUMIN_ICOM_WINDOW);//�����:�˹����
                break;
             case RESULT_NORMAL:
                SetDisplayDynamicItemW3(CheckResultNormal, CHECK_STATE_X, CHECK_STATE_Y, DRAW_LUMIN_ICOM_WINDOW);//�����:����
                break;     
             case RESULT_ABNORMAL:
                SetDisplayDynamicItemW3(CheckResultAbnormal, CHECK_STATE_X, CHECK_STATE_Y, DRAW_LUMIN_ICOM_WINDOW);//�����:�쳣
                sprintf(uiDspInfo,"%2d",ErrorCode);
                DspOneLineDynamicStr(uiDspInfo, 220,  CHECK_STATE_Y + 7);  
                break;             
         }
     }
     else if (g_UI_Language == UI_ENGLISH) {
          switch(uiState) {
             case RESULT_MAN_REVIEW:
                SetDisplayStaticItemW3(CheckResultManualReview_EN,  CHECK_STATE_X,  CHECK_STATE_Y, DRAW_LUMIN_ICOM_WINDOW);//�����:�˹����
                break;
             case RESULT_NORMAL:
                SetDisplayDynamicItemW3(CheckResultNormal_EN, CHECK_STATE_X, CHECK_STATE_Y, DRAW_LUMIN_ICOM_WINDOW);//�����:����
                break;     
             case RESULT_ABNORMAL:
                SetDisplayDynamicItemW3(CheckResultAbnormal_EN, CHECK_STATE_X, CHECK_STATE_Y, DRAW_LUMIN_ICOM_WINDOW);//�����:�쳣
                sprintf(uiDspInfo,"%2d",ErrorCode);
                DspOneLineDynamicStr(uiDspInfo, 215,  CHECK_STATE_Y + 7); 
                break;             
         }

     }

}

uint8_t g_uiFunctionListDspFlag = 0;
void STEP0_Display(void)
{
    if(g_uiFunctionListDspFlag == 0) {
        g_uiFunctionListDspFlag = 1;
        if (UI_ENGLISH== g_UI_Language) {
             SetDisplayStaticItemW2(FunctionListEn,  0, FUNC_LIST_Y, DRAW_LUMIN_ICOM_WINDOW);
        }
        else {
            SetDisplayStaticItemW2(FunctionListCh,  0, FUNC_LIST_Y, DRAW_LUMIN_ICOM_WINDOW);
        }
    }
//#if (PRO_KS)
//    uint8_t uiDspInfo[16+1];
//    uiDspInfo[0]=0;
//    sprintf(uiDspInfo,"Build:%02X%02X/%02X/%02X",g_CompileDateTime[0],
//                                           g_CompileDateTime[1],
//                                           g_CompileDateTime[2],
//                                           g_CompileDateTime[3]);
//    DspOneLineStaticStr(uiDspInfo, 0,  90); 
//#endif    
}


void AUTO_Step0(void)
{
    //���ļ��
    SetDisplayStaticItemW2(Message,SMALL_PIC_LIST_COL1_X,SMALL_PIC_LIST_ROW02, DRAW_LUMIN_ICOM_WINDOW);

    if(ButtomCurrent.count >= 0) {
        if (AutoStep0Result == 1) {
           SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW02, DRAW_LUMIN_ICOM_WINDOW);           
        } else if (AutoStep0Result >= 2) { 
           if(AutoStep0Result == 2) {
               DspOneLineStaticStr("C Er",SMALL_PIC_LIST_COL1_X+60,SMALL_PIC_LIST_ROW02);
           }
           if(AutoStep0Result == 3) {
               DspOneLineStaticStr("M Er1",SMALL_PIC_LIST_COL1_X+60,SMALL_PIC_LIST_ROW02);
           }
           if(AutoStep0Result == 4) {
               DspOneLineStaticStr("M Er2",SMALL_PIC_LIST_COL1_X+60,SMALL_PIC_LIST_ROW02);
           }
           if(AutoStep0Result == 5) {
               DspOneLineStaticStr("C Er2",SMALL_PIC_LIST_COL1_X+60,SMALL_PIC_LIST_ROW02);
           }
           //SetDisplayDynamicItemW2(WRONG_S, SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW02, DRAW_LUMIN_ICOM_WINDOW);  
           ErrorBlink_S(SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW02);
        } 
    }
}


void AUTO_Step1(void)
{

    uint8_t uiDspInfo_NUM1[16+1];
    uiDspInfo_NUM1[0]=0;
  
    sprintf(uiDspInfo_NUM1,"NUM1:",SW_Data);
    DspOneLineDynamicStr(uiDspInfo_NUM1,SW_HJSW_X,  SW_HJHW_Y); 

    DspOneLineStaticStr(NUM1_Data,SW_HJSW_X + 70,SW_HJHW_Y);//�ڲ��汾��1
    
    if(NUM1Flag ==NUM1_UDSStateSuc){
        SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(NUM1Flag == NUM1_UDSStateFail) {
        ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y);
    }    

    uint8_t uiDspInfo_NUM2[16+1];
    uiDspInfo_NUM2[0]=0;
  
    sprintf(uiDspInfo_NUM2,"NUM2:",SW_Data);
    DspOneLineDynamicStr(uiDspInfo_NUM2,SW_HJSW_X,  SW_HJHW_Y + 20); 

    DspOneLineStaticStr(NUM2_Data,SW_HJSW_X + 70,SW_HJHW_Y + 20);//�ڲ��汾��2
    
    if(NUM2Flag ==NUM2_UDSStateSuc){
        SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y + 20, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(NUM2Flag == NUM2_UDSStateFail) {
        ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 20);
    }    

  uint8_t uiDspInfo_NUM3[16+1];
    uiDspInfo_NUM3[0]=0;
    
    sprintf(uiDspInfo_NUM3,"NUM3:",SW_Data);
    DspOneLineDynamicStr(uiDspInfo_NUM3,SW_HJSW_X,  SW_HJHW_Y + 40); 

    DspOneLineStaticStr(NUM3_Data,SW_HJSW_X + 70,SW_HJHW_Y + 40);//�ڲ��汾��3
    
    if(NUM3Flag ==NUM3_UDSStateSuc){
        SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y + 40, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(NUM3Flag == NUM3_UDSStateFail) {
        ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 40);
    }    

    uint8_t uiDspInfo_NUM4[16+1];
    uiDspInfo_NUM4[0]=0;

    uint8_t NUM4_H[20];
    uint8_t NUM4_L[20];
  
    sprintf(uiDspInfo_NUM4,"NUM4:",SW_Data);
    DspOneLineDynamicStr(uiDspInfo_NUM4,SW_HJSW_X,  SW_HJHW_Y + 60); 

    memcpy(NUM4_H, NUM4_Data, 11);
    memcpy(NUM4_L, NUM4_Data+11, 10);
    //DspOneLineStaticStr(NUM4_Data,SW_HJSW_X /*+ 70*/,SW_HJHW_Y + 60);//�ڲ��汾��4
    DspOneLineStaticStr(NUM4_H,SW_HJSW_X + 70,SW_HJHW_Y + 60);
    DspOneLineStaticStr(NUM4_L,SW_HJSW_X /*+ 70*/,SW_HJHW_Y + 80);
    if(NUM4Flag ==NUM4_UDSStateSuc){
        SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y + 60, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(NUM4Flag == NUM4_UDSStateFail) {
        ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 60);
    }    

    uint8_t uiDspInfo_NUM5[16+1];
    uiDspInfo_NUM2[0]=0;
  
    sprintf(uiDspInfo_NUM5,"NUM5:",SW_Data);
    //DspOneLineDynamicStr(uiDspInfo_NUM5,SW_HJSW_X,  SW_HJHW_Y + 80); 

    DspOneLineStaticStr(NUM5_Data,SW_HJSW_X + 70,SW_HJHW_Y + 80);//�ڲ��汾��5
    
    if(NUM5Flag ==NUM5_UDSStateSuc){
        SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y + 80, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(NUM5Flag == NUM5_UDSStateFail) {
        ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 80);
    }    

    uint8_t uiDspInfo_NUM6[16+1];
    uiDspInfo_NUM6[0]=0;
  
    sprintf(uiDspInfo_NUM6,"NUM6:",SW_Data);
    DspOneLineDynamicStr(uiDspInfo_NUM6,SW_HJSW_X,  SW_HJHW_Y + 100); 

    DspOneLineStaticStr(NUM6_Data,SW_HJSW_X + 70,SW_HJHW_Y + 100);//�ڲ��汾��6
    
    if(NUM6Flag ==NUM6_UDSStateSuc){
        SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y + 100, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(NUM6Flag == NUM6_UDSStateFail) {
        ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 100);
    }   

    uint8_t uiDspInfo_NUM7[16+1];
    uiDspInfo_NUM7[0]=0;
  
    sprintf(uiDspInfo_NUM7,"NUM7:",SW_Data);
    DspOneLineDynamicStr(uiDspInfo_NUM7,SW_HJSW_X,  SW_HJHW_Y + 120); 

    DspOneLineStaticStr(NUM7_Data,SW_HJSW_X + 70,SW_HJHW_Y + 120);//�ڲ��汾��7
    
    if(NUM7Flag ==NUM7_UDSStateSuc){
        SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y + 120, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(NUM7Flag == NUM7_UDSStateFail) {
        ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 120);
    }   

    uint8_t uiDspInfo_NUM8[16+1];
    uiDspInfo_NUM8[0]=0;
  
    sprintf(uiDspInfo_NUM8,"NUM8:",SW_Data);
    DspOneLineDynamicStr(uiDspInfo_NUM8,SW_HJSW_X,  SW_HJHW_Y + 140); 

    DspOneLineStaticStr(NUM8_Data,SW_HJSW_X + 70,SW_HJHW_Y + 140);//�ڲ��汾��7
    
    if(NUM8Flag ==NUM7_UDSStateSuc){
        SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y + 140, DRAW_LUMIN_ICOM_WINDOW);//����
    }else if(NUM8Flag == NUM7_UDSStateFail) {
        ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 140);
    }   
 //  uint8_t uiDspInfo_SW[16+1];
 //  uiDspInfo_SW[0]=0;
 //  
 //  //SW
 //  sprintf(uiDspInfo_SW,"SW:",SW_Data);
 //  DspOneLineDynamicStr(uiDspInfo_SW,SW_HJSW_X,  SW_HJHW_Y); 

 //  DspOneLineStaticStr(SW_Data,SW_HJSW_X + 40,SW_HJHW_Y);//�����汾�� 
 //  
 //  if(HJ_SWStateFlag == HJ_UDSStateSuc){
 //      SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y, DRAW_LUMIN_ICOM_WINDOW);//����
 //  }else if(HJ_SWStateFlag == HJ_UDSStateFail) {
 //      ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y);
 //  }    
       
     //Ӳ���汾�� 
  //  uint8_t uiDspInfo_HW[16+1];
  //  uiDspInfo_HW[0]=0;
  // //HW
  // sprintf(uiDspInfo_HW,"HW:",SW_Data);
  // DspOneLineDynamicStr(uiDspInfo_HW,SW_HJSW_X,  SW_HJHW_Y + 20); 
//
  // DspOneLineStaticStr(HW_Data,SW_HJSW_X + 40,SW_HJHW_Y + 20);//Ӳ���汾�� 
  // 
  // if(HJ_HWStateFlag == HW_UDSStateSuc){
  //     SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y+20, DRAW_LUMIN_ICOM_WINDOW );//����
  // }else if(HJ_HWStateFlag == HW_UDSStateFail) {
  //     ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 20);
  // }    
  //  uint8_t uiDspInfo_HJYB[16+1];
  //  uiDspInfo_HJYB[0]=0;
  //  
  // sprintf(uiDspInfo_HJYB,"HJYB:",SW_Data);
  // DspOneLineDynamicStr(uiDspInfo_HJYB,SW_HJSW_X,  SW_HJHW_Y + 40); 
//
  // DspOneLineStaticStr(HJYB_Data,SW_HJSW_X + 60,SW_HJHW_Y + 40);//����� 
  // 
  // if(HJ_HJYBStateFlag == HJYB_UDSStateSuc){
  //     SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y+40, DRAW_LUMIN_ICOM_WINDOW );//����
  // }else if(HJ_HJYBStateFlag == HJYB_UDSStateFail) {
  //     ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 40);
  // }   
  // //����
  //  uint8_t uiDspInfo_DAY[16+1];
  //  uiDspInfo_DAY[0]=0;
  // sprintf(uiDspInfo_DAY,"DATE:",SW_Data);
  // DspOneLineDynamicStr(uiDspInfo_DAY,SW_HJSW_X,  SW_HJHW_Y + 60); 
//
  // DspOneLineStaticStr(DAY_Data,SW_HJSW_X + 60,SW_HJHW_Y + 60);//����
  // 
  // if(HJ_DAYFlag == DAY_UDSStateSuc){
  //     SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, SW_HJHW_Y+60, DRAW_LUMIN_ICOM_WINDOW );//����
  // }else if( HJ_DAYFlag == DAY_UDSStateFail) {
  //     ErrorBlink_S(SW_HJSW_X + 200, SW_HJHW_Y + 60);
  // }  
  //   

}

void AUTO_Step2(void)
{
    //SW1���
   SetDisplayStaticItemW2(TripSW1,SMALL_PIC_LIST_COL1_X,SMALL_PIC_LIST_ROW03, DRAW_LUMIN_ICOM_WINDOW); 
   if(ButtomCurrent.count >= 2) {
       if(SW1_CHECK_RESULT == 1 && AutoStep2Result == 1) {
         SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW03, DRAW_LUMIN_ICOM_WINDOW);           
       }
       else if(AutoStep2Result == 2) {
         //SetDisplayDynamicItemW2(WRONG_S, SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW03, DRAW_LUMIN_ICOM_WINDOW);
         ErrorBlink_S(SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW03);
       }
   }
}

void AUTO_Step3(void)
{
    //SW2���
    SetDisplayStaticItemW2(TripSW2,SMALL_PIC_LIST_COL2_X,SMALL_PIC_LIST_ROW03, DRAW_LUMIN_ICOM_WINDOW);
    if(ButtomCurrent.count >= 3) {
        if(SW2_CHECK_RESULT == 1 && AutoStep3Result == 1) {
            SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW03, DRAW_LUMIN_ICOM_WINDOW);            
        }
        else if(AutoStep3Result == 2) {
            //SetDisplayDynamicItemW2(WRONG_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW03, DRAW_LUMIN_ICOM_WINDOW);
            ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW03);
        } 
    }
}

void AUTO_Step4(void)
{
    SetDisplayStaticItemW2(EngState,10,SMALL_PIC_LIST_ROW04, DRAW_LUMIN_ICOM_WINDOW);
    if(ButtomCurrent.count >= 4) {
        if(AutoStep4Result == 1) {
            SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW04, DRAW_LUMIN_ICOM_WINDOW);             
        } else  if(AutoStep4Result == 2) {
            //SetDisplayDynamicItemW2(WRONG_S, SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW04, DRAW_LUMIN_ICOM_WINDOW); 
            ErrorBlink_S(SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW04);
        }
    }
}

void AUTO_Step5(void)
{
    SetDisplayStaticItemW2(Gear,SMALL_PIC_LIST_COL2_X,SMALL_PIC_LIST_ROW02, DRAW_LUMIN_ICOM_WINDOW);
    if(ButtomCurrent.count >= 5) {
        if (AutoStep5Result == 1) {
            SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW02, DRAW_LUMIN_ICOM_WINDOW);       
        } else if (AutoStep5Result == 2) {
            //SetDisplayDynamicItemW2(WRONG_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW02, DRAW_LUMIN_ICOM_WINDOW);
            ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW02);
        } 
    }
}

void AUTO_Step6(void)
{
    //GND Signal3 Ӳ��������
#if (PRO_US4) 
    CompilationDate_S(SMALL_PIC_LIST_COL2_X,SMALL_PIC_LIST_ROW04);
#else
    SetDisplayStaticItemW2(GND_Signal3,SMALL_PIC_LIST_COL2_X,SMALL_PIC_LIST_ROW04, DRAW_LUMIN_ICOM_WINDOW);
   
    if(ButtomCurrent.count >= 6) {
        if(AutoStep6Result == 1) {
            SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW04, DRAW_LUMIN_ICOM_WINDOW);             
        } else  if(AutoStep6Result == 2){
            //SetDisplayDynamicItemW2(WRONG_S, SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW04, DRAW_LUMIN_ICOM_WINDOW);
            ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW04);
        }
    } 
#endif
}

void AUTO_Step7(void)
{
    //Rheo ���� Ӳ��������
    SetDisplayStaticItemW2(RheostatSW,SMALL_PIC_LIST_COL1_X,SMALL_PIC_LIST_ROW05, DRAW_LUMIN_ICOM_WINDOW);
    if(ButtomCurrent.count >= 7) {
        if(AutoStep7Result == 1) {
            SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW05, DRAW_LUMIN_ICOM_WINDOW);             
        } else  if(AutoStep7Result == 2){
            //SetDisplayDynamicItemW2(WRONG_S, SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW05, DRAW_LUMIN_ICOM_WINDOW);
            ErrorBlink_S(SMALL_PIC_LIST_COL1_X + CHECK_STATE_OFFSET1, SMALL_PIC_LIST_ROW05);
        }
    }
}


void AUTO_Step8(void)
{
    //Detent Ӳ��������
    SetDisplayStaticItemW2(Detent,SMALL_PIC_LIST_COL2_X,SMALL_PIC_LIST_ROW05, DRAW_LUMIN_ICOM_WINDOW);
    if(ButtomCurrent.count >= 8) {
        if(AutoStep8Result == 1) {
            SetDisplayDynamicItemW2(RIGHT_S,  SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW05, DRAW_LUMIN_ICOM_WINDOW);             
        } else  if(AutoStep8Result == 2){
            //SetDisplayDynamicItemW2(WRONG_S,  SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW05, DRAW_LUMIN_ICOM_WINDOW);
            ErrorBlink_S(SMALL_PIC_LIST_COL2_X + CHECK_STATE_OFFSET2, SMALL_PIC_LIST_ROW05);
        }
    }
}

void AUTO_Step9(void)
{
#if (PRO_AI3)
#else
    DspOneLineDynamicStr("DMS:",SMALL_PIC_LIST_COL1_X,SMALL_PIC_LIST_ROW06 + 3);
    if(ButtomCurrent.count >= 9){
//            if (GreaterThan(4500)){
            if (AutoStep10Result == 1){
                SetDisplayDynamicItemW2(RIGHT_S, SMALL_PIC_LIST_COL1_X + 50, SMALL_PIC_LIST_ROW06, DRAW_LUMIN_ICOM_WINDOW);
            } else {
                ErrorBlink_S(SMALL_PIC_LIST_COL1_X + 50, SMALL_PIC_LIST_ROW06);
              }
//            }
    }
#endif
}
void AUTO_Step10(void)
{
    if(ButtomCurrent.count >= 0)
    {
        DisplayStaticCurrent_S(SW_HJStatic_X,SW_HJStatic_Y);
    }
}
void AUTO_Step11(void)
{
        
    if(ButtomCurrent.count >= 0)
    {
        DisplaySpeedInfoOutPut(9,140);
        BatteryVoltageOutPut(9,160);
        HandBrakeSystemStsOutPut(9,180);
        TotalOdometerOutPut(9, 200);
        AirBagLampFailStsReservedOutPut(9,220);
        DriverSeatBeltSwitchOutPut(9,240);
        Low_Brake_FluidOutPut(9,260);
        MessageCounterOutPut(9,275);

    }
}
        
void AUTO_Display(void)
{   
    if(g_uiStaticCurrentCheckFlag == 0) {
        if (g_UI_Language == UI_CHINESE) {//Function01_CN
            SetDisplayStaticItemW1(HJ_photograph,  FUNC_X,  110, DRAW_LUMIN_ICOM_WINDOW);
        }
        else if (g_UI_Language == UI_ENGLISH) {
            DspOneLineStaticStr("01.Auto", FUNC_X, FUNC_Y);
        }
    }
    else {
        if (g_UI_Language == UI_CHINESE) {
            SetDisplayStaticItemW1(HJ_photograph,  FUNC_X,  110, DRAW_LUMIN_ICOM_WINDOW);
        }
        else if (g_UI_Language == UI_ENGLISH) {
            DspOneLineStaticStr("02.Auto(S)", FUNC_X, FUNC_Y);
        }
    }

    // if(g_AutoConfig.AUTO_STEP0_APPLY == 1) AUTO_Step0();
    // if(g_AutoConfig.AUTO_STEP1_APPLY == 1) AUTO_Step1();
    // if(g_AutoConfig.AUTO_STEP2_APPLY == 1) AUTO_Step2(); 
    // if(g_AutoConfig.AUTO_STEP3_APPLY == 1) AUTO_Step3(); 
    // if(g_AutoConfig.AUTO_STEP4_APPLY == 1) AUTO_Step4(); 
    // if(g_AutoConfig.AUTO_STEP5_APPLY == 1) AUTO_Step5(); 
    // if(g_AutoConfig.AUTO_STEP6_APPLY == 1) AUTO_Step6(); 
    // if(g_AutoConfig.AUTO_STEP7_APPLY == 1) AUTO_Step7(); 
    // if(g_AutoConfig.AUTO_STEP8_APPLY == 1) AUTO_Step8(); 
    // if(g_AutoConfig.AUTO_STEP9_APPLY == 1) AUTO_Step9();
    
    //if(g_AutoConfig.AUTO_STEP11_APPLY == 1) AUTO_Step11();
    AUTO_Step10();
    AUTO_Step1();


    // SetDisplayStaticItemW2(P_Line,   SMALL_PIC_LIST_COL1_X, SMALL_PIC_LIST_ROW01 + 14, DRAW_LUMIN_ICOM_WINDOW);// ����
    // SetDisplayStaticItemW2(P_Line,   SMALL_PIC_LIST_COL1_X, SMALL_PIC_LIST_ROW02 + 14, DRAW_LUMIN_ICOM_WINDOW);// ����
    // SetDisplayStaticItemW2(P_Line,   SMALL_PIC_LIST_COL1_X, SMALL_PIC_LIST_ROW03 + 14, DRAW_LUMIN_ICOM_WINDOW);// ����
    // SetDisplayStaticItemW2(P_Line,   SMALL_PIC_LIST_COL1_X, SMALL_PIC_LIST_ROW04 + 14, DRAW_LUMIN_ICOM_WINDOW);// ����
    // SetDisplayStaticItemW2(P_Line,   SMALL_PIC_LIST_COL1_X, SMALL_PIC_LIST_ROW05 + 14, DRAW_LUMIN_ICOM_WINDOW);// ����

    if(ErrorCode == 0){
        DspCheckState(STATE_CHECKING);
    }
    else if(ErrorCode == 99){
        DspCheckResult(RESULT_NORMAL);
        DspCheckState(STATE_CHECKED);
    }
    else {
        DspCheckResult(RESULT_ABNORMAL);
        DspCheckState(STATE_CHECKED);
    }
}

void LED_Display(void)
{
    if (g_UI_Language == UI_CHINESE) {
        SetDisplayStaticItemW1(Function05_CN,  FUNC_X,  FUNC_Y, DRAW_LUMIN_ICOM_WINDOW);
    }
    else if (g_UI_Language == UI_ENGLISH) {
        DspOneLineStaticStr("05.Lamp(Hard line)", FUNC_X, FUNC_Y);
    }
    if (LedCurrent.count > 0) {
//        SetDisplayDynamicItemW1(NumberList[LedCurrent.count/10%10], 210,  57, DRAW_LUMIN_ICOM_WINDOW);  //ʮλ
//        SetDisplayDynamicItemW1(NumberList[LedCurrent.count % 10] , 225,  57, DRAW_LUMIN_ICOM_WINDOW);  //��λ
        DspStepSerialNumber(LedCurrent.count);
    }
      
    if(LedCurrent.statu == FINISH)
        DspCheckState(STATE_CHECKED);
    else
        DspCheckState(STATE_CHECKING);
    if(LedCurrent.count == 1)    
      DspOneLineDynamicStr("Hard Line LED ON", 9, 110);
    else if(LedCurrent.count == 2)    
      DspOneLineDynamicStr("Hard Line LED OFF", 9, 110);
    else if(LedCurrent.count == 3)    
#if (PRO_NU2)
      DspOneLineDynamicStr("SINGLE LED ON", 9, 110);
    else if(LedCurrent.count == 4)
      DspOneLineDynamicStr("DOUBLE LED ON", 9, 110);
    else if(LedCurrent.count == 5)
      DspOneLineDynamicStr("All LED ON", 9, 110);
#else
      DspOneLineDynamicStr("All LED ON", 9, 110);
#if (SEMI_AUTOMATIC_STAGE)
    else if(LedCurrent.count == 4)
      DspOneLineDynamicStr("All LED OFF", 9, 110);
#endif    
#endif

}
void SPEED_Display(void)
{  
      uint8_t uiStartX = 60;
      //if(g_SpeedCheckDeriction == 0) {//����+
        
 /*   uint8_t uiDspInfo[16+1];
        uiDspInfo[0]=0;*/

        // sprintf(uiDspInfo,"SN: %4dV",DisPlayBatteryVoltageOutPut);
        // DspOneLineDynamicStr(uiDspInfo, uiStartX,  uiDspLine);  
        //  MultiplePack.Data
        // HandBrakeSystemStsOutPut(9,160);
        // TotalOdometerOutPut(9, 180);
        // AirBagLampFailStsReservedOutPut(9,200);
        // DriverSeatBeltSwitchOutPut(9,220);
        // Low_Brake_FluidOutPut(9,240);

        //   if (g_UI_Language == UI_CHINESE) {
        //       SetDisplayStaticItemW1(Function04_CN,  FUNC_X,  FUNC_Y - 3, DRAW_LUMIN_ICOM_WINDOW);
        //   }
        //   else if (g_UI_Language == UI_ENGLISH) {
        //       DspOneLineStaticStr("04.Speed", FUNC_X, FUNC_Y);
        //   }
        //   //�������
        //   DspStepSerialNumber(SpeedCurrent.count);
        //   if (g_UI_Language == UI_CHINESE) {
        //      SetDisplayStaticItemW2(SpeedTachoFreq_CN,  0,  106, DRAW_LUMIN_ICOM_WINDOW);//����ת��Ƶ��
        //      uiStartX = 60;
        //   }
        //   else if (g_UI_Language == UI_ENGLISH) {
        //      SetDisplayStaticItemW2(SpeedTachoFreq_EN,  0,  106, DRAW_LUMIN_ICOM_WINDOW);//����ת��Ƶ��  
        //      uiStartX = 120;
        //   }
        //   DisplaySpeedInfo_S(uiStartX,115);//��ʾ����  
        //   DisplayTachoInfo_S(uiStartX,150);//ת��
        //   DisplayFrequency_S(uiStartX,185);//����Ƶ��

        //   if(SpeedCurrent.statu == FINISH)
        //       DspCheckState(STATE_CHECKED);
        //   else
        //      DspCheckState(STATE_CHECKING);
     // } else if(g_SpeedCheckDeriction == 1) {//����-
        if(LedCurrent.count <= 22)
        {
            DisplayTachoInfo_S(9,140);//ת��
            DisplaySpeedInfo_S(9,155);//��ʾ����
        }
        else
        {
            DisplayPowerInfo_S(9,140);
            DisplayElectricityInfo_S(9,155);
        }
          if(LedCurrent.count == g_uiLedNum)
              DspCheckState(STATE_CHECKED);
          else
              DspCheckState(STATE_CHECKING);
          if (g_UI_Language == UI_CHINESE) {
             // SetDisplayStaticItemW1(Function06_CN,  FUNC_X,  FUNC_Y - 3, DRAW_LUMIN_ICOM_WINDOW);
          }
          else if (g_UI_Language == UI_ENGLISH) {
             DspOneLineStaticStr("06.Lamp(All)", FUNC_X, FUNC_Y);
          }          
          //�������
          DspStepSerialNumber(LedCurrent.count);
        //   if (g_uiLowLevelTrigerFlag == 1) {
        //         if (DMS_SPORT == 1) { // SPORT  
        //              DspOneLineDynamicStr("SPORT", 9, 110);
        //         }
        //         else  if (DMS_ECO == 1) { // ECO 
        //              DspOneLineDynamicStr("ECO", 9, 110);
        //         }
        //         else  if (DMS_NORMAL == 1) { // COMFORT
        //              DspOneLineDynamicStr("NORMAL", 9, 110);
        //         } 
        //         else  if (DMS_SMART== 1) { // SMART
        //              DspOneLineDynamicStr("SMART", 9, 110);
        //         }
        //   } else {
        //       DspOneLineDynamicStr(g_szLedName, 9, 110);  
        //   }          

        //   if(g_uiDmsLedCheckFlag == 0) {
        //       if (g_uiB_PlusResetWaitTimer > 0) {
        //           DspOneLineDynamicStr("Wait for restart", 9, 130);
        //           SetDisplayDynamicItemW2(NumberList[g_uiB_PlusResetWaitTimer/1000  /10%10],  9, 150, DRAW_LUMIN_ICOM_WINDOW);  //ʮλ
        //           SetDisplayDynamicItemW2(NumberList[g_uiB_PlusResetWaitTimer/1000    % 10],  24, 150, DRAW_LUMIN_ICOM_WINDOW);  //��λ
        //           SetDisplayDynamicItemW2(AIISCList[35],                                   39, 151, DRAW_LUMIN_ICOM_WINDOW);  //��λ
        //       }
        //   }
        //   if(g_uiSmartComfortWaitFlag == 1) {
        //       if (g_uiSmartComfortWaitTimer > 0) {
        //           DspOneLineDynamicStr("Wait for 4s", 9, 130);
        //           SetDisplayDynamicItemW2(NumberList[g_uiSmartComfortWaitTimer/1000  /10%10],  9, 150, DRAW_LUMIN_ICOM_WINDOW);  //ʮλ
        //           SetDisplayDynamicItemW2(NumberList[g_uiSmartComfortWaitTimer/1000    % 10],  24, 150, DRAW_LUMIN_ICOM_WINDOW);  //��λ
        //           SetDisplayDynamicItemW2(AIISCList[35],                                   39, 151, DRAW_LUMIN_ICOM_WINDOW);  //��λ
        //       }
        //   } 
      //}
}

void OIL_TEMP_Display(void)
{
    //�������
    DspStepSerialNumber(Iol_TempCurrent.count);
    if(Iol_TempCurrent.Flag == 1 && Iol_TempCurrent.count == 6)
        DspCheckState(STATE_CHECKED);
    else if(Iol_TempCurrent.Flag == 0 && Iol_TempCurrent.count == 1)
        DspCheckState(STATE_CHECKED);
    else
        DspCheckState(STATE_CHECKING);
    
    if(Iol_TempCurrent.count <= 5){
        if (g_UI_Language == UI_CHINESE) {
            SetDisplayDynamicItemW2(FuelWaterChargingTime_CN,  0, 108, DRAW_LUMIN_ICOM_WINDOW);  //���ʱ��  
            DisPlayChargingTime(120,120); 
            DisPlayChargingPower(120,145);
            DisPlayTempNum(120,170);     

        }
    }
    else if(Iol_TempCurrent.count == 6)
    {
        SetDisplayDynamicItemW2(gImage_MaxSpeedDisplay_CN,  0, 108, DRAW_LUMIN_ICOM_WINDOW);  // 
    }
}

void TFT_Display(void)
{
    if(g_TftCheckDeriction == 0) {
        //if (g_UI_Language == UI_CHINESE) {
          
        //}
        // else if (g_UI_Language == UI_ENGLISH) {
        //     DspOneLineStaticStr("08.Segment", FUNC_X, FUNC_Y);
        // }
        // DspStepSerialNumber(TFTCurrent.count);
        // if(TFTCurrent.statu == FINISH)
        //     DspCheckState(STATE_CHECKED);
        // else
        //     DspCheckState(STATE_CHECKING);
    }
    else if(g_TftCheckDeriction == 1) {
        if (g_UI_Language == UI_CHINESE) {
            SetDisplayStaticItemW1(Function09_CN,  FUNC_X,  FUNC_Y - 3, DRAW_LUMIN_ICOM_WINDOW);
        }
        else if (g_UI_Language == UI_ENGLISH) {
            DspOneLineStaticStr("09.Warning", FUNC_X, FUNC_Y);
        }
        if(TFTCurrent.count == g_uiTftNum)
            DspCheckState(STATE_CHECKED);
        else
            DspCheckState(STATE_CHECKING);
        DspStepSerialNumber(TFTCurrent.count);
        DspOneLineDynamicStr(g_szTftName, 9, 110);
    }
}

void LCD_Display(void)
{
    if (g_UI_Language == UI_CHINESE) {
        SetDisplayStaticItemW1(Function10_CN,  FUNC_X,  FUNC_Y, DRAW_LUMIN_ICOM_WINDOW);
        if(Back_lightCurrent.count ==1)
            SetDisplayStaticItemW2(PW2_MODE_Day    ,  8,  SMALL_PIC_LIST_ROW08, DRAW_LUMIN_ICOM_WINDOW);//����
        else if(Back_lightCurrent.count ==2)
            SetDisplayStaticItemW2(PW2_MODE_Dusk   ,  8,  SMALL_PIC_LIST_ROW08, DRAW_LUMIN_ICOM_WINDOW);//����
        else if(Back_lightCurrent.count ==3)
            SetDisplayStaticItemW2(PW2_MODE_Night  ,  8,  SMALL_PIC_LIST_ROW08, DRAW_LUMIN_ICOM_WINDOW);//ҹ��
        else
            SetDisplayStaticItemW2(PW2_MODE        ,  10,  SMALL_PIC_LIST_ROW08, DRAW_LUMIN_ICOM_WINDOW);//Ĭ��
    }
    else if (g_UI_Language == UI_ENGLISH) {
        DspOneLineStaticStr("10.Light", FUNC_X, FUNC_Y);
        if(Back_lightCurrent.count ==1)
            DspOneLineStaticStr("Light Mode:Day",     9, SMALL_PIC_LIST_ROW09);//����
        else if(Back_lightCurrent.count ==2)
            DspOneLineStaticStr("Light Mode:Sunset",  9, SMALL_PIC_LIST_ROW09);//����
        else if(Back_lightCurrent.count ==3)
            DspOneLineStaticStr("Light Mode:Night",   9, SMALL_PIC_LIST_ROW09);//ҹ��
        else
            DspOneLineStaticStr("Light Mode:Default", 9, SMALL_PIC_LIST_ROW09);//Ĭ��  
    }
#if (PRO_KS)
     if (1 <= CanFDDataStruct.CF_Clu_RheostatLevel && CanFDDataStruct.CF_Clu_RheostatLevel <= 20) {
        SetDisplayStaticItemW2(ILL,       SMALL_PIC_LIST_COL1_X,SMALL_PIC_LIST_ROW10, DRAW_LUMIN_ICOM_WINDOW);//ILL
        SetDisplayStaticItemW2(Duty_Ratio,SMALL_PIC_LIST_COL1_X,SMALL_PIC_LIST_ROW11, DRAW_LUMIN_ICOM_WINDOW);//ILLƵ��ռ�ձ�
        //ILL�ȼ�
        DisplayILL_S(OTHER_CHECK_STARTX,SMALL_PIC_LIST_ROW10);//ILL�ȼ�
        DisplayILL_DutyRatio_S(OTHER_CHECK_STARTX,SMALL_PIC_LIST_ROW11);//ILLƵ��ռ�ձ�
#else
     if (1 <= LuminosityCurrent.count && LuminosityCurrent.count <= 20) {
        SetDisplayStaticItemW2(ILL,       SMALL_PIC_LIST_COL1_X,SMALL_PIC_LIST_ROW10, DRAW_LUMIN_ICOM_WINDOW);//ILL
        SetDisplayStaticItemW2(Duty_Ratio,SMALL_PIC_LIST_COL1_X,SMALL_PIC_LIST_ROW11, DRAW_LUMIN_ICOM_WINDOW);//ILLƵ��ռ�ձ�
        //ILL�ȼ�
        DisplayILL_S(OTHER_CHECK_STARTX,SMALL_PIC_LIST_ROW10);//ILL�ȼ�
        DisplayILL_DutyRatio_S(OTHER_CHECK_STARTX,SMALL_PIC_LIST_ROW11);//ILLƵ��ռ�ձ�
#endif
    }
}
void StaticCurrentCheck_Display(void)
{
  //  DisplayStaticCurrent_S(OTHER_CHECK_STARTX,SMALL_PIC_LIST_ROW06);

}
void ELSE_Display(void)
{
     if (g_UI_Language == UI_CHINESE) {
         SetDisplayStaticItemW1(Function11_CN,  FUNC_X,  FUNC_Y - 3, DRAW_LUMIN_ICOM_WINDOW);
     }
     else if (g_UI_Language == UI_ENGLISH) {
         DspOneLineStaticStr("11.Other", FUNC_X, FUNC_Y);
     }     
     DspStepSerialNumber(ElseCurrent.count);
        if (ElseCurrent.count == 1){
            SetDisplayDMS("RestoreDefault");
            }
        if(2 <= ElseCurrent.count && ElseCurrent.count <= g_ElseDmsMaxCheckSteps) {
            if (DMS_SPORT == 1) { // SPORT  
                if(IsHaveSportPlus())
                    SetDisplayDMS("SPORT+");   
                else
                     SetDisplayDMS("SPORT");
            }
            else  if (DMS_ECO == 1) { // ECO 
                SetDisplayDMS("ECO");   
            }
            else  if (DMS_NORMAL == 1) { // COMFORT
#if ((PRO_SQFL) || (PRO_NQ5C) || (PRO_ONPE) ||(PRO_NU2) || (PRO_CN7C) || (PRO_NUPE) || (PRO_SP2C_PE) || (PRO_QYC) || (PRO_NX4C))
                SetDisplayDMS("COMFORT");
#else
                SetDisplayDMS("NORMAL");
#endif
            }
            else  if (DMS_SPORTPLUS == 1) { //CN7C��
                SetDisplayDMS("SPORT+");   
            }
            else if (DMS_Snow == 1){
                SetDisplayDMS("Snow");
            }
            else if (DMS_Mud == 1){
                SetDisplayDMS("Mud");
            }
            else if (DMS_Sand == 1){
                SetDisplayDMS("Sand");
            }
            else  if (DMS_SMART == 1){
                //SetDisplayDMS("SMART");
                if(g_uiSmartComfortWaitFlag == 1) {
                  if (g_uiSmartComfortWaitTimer > 0) {
                      DspOneLineDynamicStr("Wait for 4s", 9, 130);
                      SetDisplayDynamicItemW2(NumberList[g_uiSmartComfortWaitTimer/1000  /10%10],  9, 150, DRAW_LUMIN_ICOM_WINDOW);  //ʮλ
                      SetDisplayDynamicItemW2(NumberList[g_uiSmartComfortWaitTimer/1000    % 10],  24, 150, DRAW_LUMIN_ICOM_WINDOW);  //��λ
                      SetDisplayDynamicItemW2(AIISCList[35],                                   39, 151, DRAW_LUMIN_ICOM_WINDOW);  //��λ
                   }
                } 
#if (CAN_2ND)
                if (CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp == 0X2){
                    SetDisplayDMS("ECO Color");
                }
                else  if (CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp == 0X1){
                    SetDisplayDMS("COMFORT Color");
                }
                else  if (CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp == 0X4){
                    SetDisplayDMS("SPORT Color");
                }
                else  if (CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp == 0X0){
                    SetDisplayDMS("SMART Color");
                }
#endif
#if (CAN_3RD)
                if (TCU_01_10ms.TCU_DrvngModDis == 0x2){
                    SetDisplayDMS("ECO Color");
                }
                else  if (TCU_01_10ms.TCU_DrvngModDis == 0x1){
                    SetDisplayDMS("COMFORT Color");
                }
                else  if (TCU_01_10ms.TCU_DrvngModDis == 0x4){
                    SetDisplayDMS("SPORT Color");
                }
                else  if (TCU_01_10ms.TCU_DrvngModDis == 0x0){
                    SetDisplayDMS("SMART Color");
                }
#endif
            }
            DspCheckState(STATE_CHECKING);
        }
        else {
            if ((IsSupportBVM() == BVM_YES) && (ElseCurrent.count == g_ElseDmsMaxCheckSteps + 1)) {
                SetDisplayBVM("BVM Left");
            }
            if ((IsSupportBVM() == BVM_YES) && (ElseCurrent.count == g_ElseDmsMaxCheckSteps + 2)) {
                SetDisplayBVM("BVM Right");
            }

            if (ElseCurrent.count == g_ElseMaxCheckSteps) {
                SetDisplayPDW3();
                DspCheckState(STATE_CHECKED);
            } 
            else {
                DspCheckState(STATE_CHECKING);
            }
        }
//#endif
}

void END_Display(void)
{
    uint8_t uiDspInfo[16+1];
    uiDspInfo[0]=0;
    if (g_UI_Language == UI_CHINESE) {
        SetDisplayStaticItemW1(Function12_CN,  FUNC_X,  FUNC_Y, DRAW_LUMIN_ICOM_WINDOW);
    }
    else if (g_UI_Language == UI_ENGLISH) {
        DspOneLineStaticStr("12.END", FUNC_X, FUNC_Y);
    }
    DspStepSerialNumber(g_CostTimeSecond);
    if(g_CostTimeSecond <= CLUSTER_START_TIME/1000) {
        DspCheckState(STATE_CHECKING);
        DspCheckResult(RESULT_MAN_REVIEW);
        DspOneLineDynamicStr("Wait for restart", 9, 110);    
    }
    else {
        sprintf(uiDspInfo,"success", (ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L << 16) + (ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L2 << 8) + ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L3);
        DspOneLineDynamicStr(uiDspInfo, 9, 110); 
// #if (CAN_2ND)         
//         sprintf(uiDspInfo,"ODO:%-d",CanFDDataStruct.CF_Clu_Odometer1);
// #endif
// #if (CAN_3RD)         
//         sprintf(uiDspInfo,"ODO:%-d",CLU_02_100ms.CLU_OdoVal / 10);
// #endif
//         DspOneLineDynamicStr(uiDspInfo, 9, 110);    
//         if (g_UI_Language == UI_CHINESE) {
//              SetDisplayStaticItemW2(EndDoing,  0,  160, DRAW_LUMIN_ICOM_WINDOW);//���������ȴ�
//         }
//         else if (g_UI_Language == UI_ENGLISH) {
//              SetDisplayStaticItemW2(EndDoing_EN,  0,  160, DRAW_LUMIN_ICOM_WINDOW);//���������ȴ�
//         }
//         if((EndCurrent.Flag == END_FINISH) && (ClearedOdoFlag == 1)){
//             DspCheckState(STATE_CHECKED);
//             DspCheckResult(RESULT_NORMAL);
//         }
//         else if(EndCurrent.Flag == END_FAIL){
//             DspCheckState(STATE_CHECKED);
//             DspCheckResult(RESULT_ABNORMAL);
//         }
//         else {
//             DspCheckState(STATE_CHECKING);
//             DspCheckResult(RESULT_MAN_REVIEW);
//         }
    }
}

void EOL_Display(void)
{
    if (g_UI_Language == UI_CHINESE) {
        SetDisplayStaticItemW1(Function03_CN,  FUNC_X,  FUNC_Y, DRAW_LUMIN_ICOM_WINDOW);
    }
    else if (g_UI_Language == UI_ENGLISH) {
        DspOneLineStaticStr("03.EOL", FUNC_X, FUNC_Y);
    }
    if(EOL.Statu == 4)
        DspCheckState(STATE_CONFIGED);
    else if (EOL.Statu < 4)
        DspCheckState(STATE_CONFIGURING);
        else if(EOL.Statu == 5)
        DspCheckState(STATE_CONFIGERROR);
#if (PRO_NQ5)
    if (g_EolCfgFuelType == 0) {
        if (g_VehicleType == CAR_TYPE_LPI){
            DspOneLineStaticStr("LPI",9,108); 
        } else {
            DspOneLineStaticStr("GSL",9,108); 
        }
    } 
    else if (g_EolCfgFuelType == 1) {
        if (g_VehicleType == CAR_TYPE_LPI){
            DspOneLineStaticStr("LPI",9,108); 
        } else if((g_VehicleType == CAR_TYPE_HEV) || (g_VehicleType == CAR_TYPE_PHEV)){
            DspOneLineStaticStr("GSL",9,108); 
        } else {
            DspOneLineStaticStr("DSL",9,108);
        }
    }
    else if (g_EolCfgFuelType == 2) {
        DspOneLineStaticStr("LPI",9,108); 
    }
#else
    // if (g_EolCfgFuelType == 0) {
    //     DspOneLineStaticStr("GSL",9,108); 
    // } 
    // else if (g_EolCfgFuelType == 1) {
    //     DspOneLineStaticStr("DSL",9,108); 
    // }
    // else if (g_EolCfgFuelType == 2) {
    //     DspOneLineStaticStr("LPI",9,108); 
    // }
#endif
}
void Electricity(void)
{
    if(g_uiCuntDownFlag == 1) {
              if (TftTimer > 0) {
                  DspOneLineDynamicStr("Wait for 120s", 9, 55);
               //   SetDisplayDynamicItemW2(NumberList[TftTimer/1000  /100],  9, 150, DRAW_LUMIN_ICOM_WINDOW);  //ʮλ
               //   SetDisplayDynamicItemW2(NumberList[TftTimer/1000  /10%10],  24, 150, DRAW_LUMIN_ICOM_WINDOW);  //ʮλ
               //   SetDisplayDynamicItemW2(NumberList[TftTimer/1000    % 10],  39, 150, DRAW_LUMIN_ICOM_WINDOW);  //��λ
               //   SetDisplayDynamicItemW2([35],                                   54, 151, DRAW_LUMIN_ICOM_WINDOW);  //��λ
                  uint8_t uiDspInfo[17];
                  uiDspInfo[0]=0;
                  sprintf(uiDspInfo,"%d%d%d",(TftTimer / 1000 / 100 % 10),
                                              TftTimer/1000  /10%10 ,
                                              TftTimer/1000  %10);
                  DspOneLineDynamicStr(uiDspInfo, 9,  75); 
              }
          }
}

#define UPDATE_CENTER_INFO_BASE 80

void UpdateCenterInfo(uint8_t uiErrType)
{
    uint32_t tmp = 0;
    static uint32_t Timer1msCnts_Old = 0;
    int i = 0;

    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    g_uiStaticIndex = 0;
    g_uiDyncIndex = 0;
    
    if (Timer1msCnts >= Timer1msCnts_Old) {
        tmp = Timer1msCnts - Timer1msCnts_Old;
    } else {
        tmp = (0xffffffff - Timer1msCnts_Old) + Timer1msCnts;
    }
    Timer1msCnts_Old = Timer1msCnts;
    Time_1K += tmp;
    
    //General_Display();
    if (uiErrType == ST_NCK) {
        SetDisplayStaticItemW2(PC_CommError,  0, 160, DRAW_LUMIN_ICOM_WINDOW);
    }
    else if (uiErrType == ST_QUERY) {
        //SetDisplayStaticItemW2(QrCodeQuering,  0, 160, DRAW_LUMIN_ICOM_WINDOW);
        if (Timer1msCnts % 12 == 0)
            DspOneLineStaticStr("......",UPDATE_CENTER_INFO_BASE, 160);
        else if (Timer1msCnts % 10 == 0)
            DspOneLineStaticStr("....",UPDATE_CENTER_INFO_BASE, 160); 
        else if (Timer1msCnts % 8 == 0)
            DspOneLineStaticStr("...",UPDATE_CENTER_INFO_BASE, 160); 
        else if (Timer1msCnts % 6 == 0)
            DspOneLineStaticStr("..",UPDATE_CENTER_INFO_BASE, 160); 
        else if (Timer1msCnts % 4 == 0)
            DspOneLineStaticStr(".",UPDATE_CENTER_INFO_BASE, 160); 
    }
    else if (uiErrType == ST_FAIL) {
        SetDisplayStaticItemW2(QrCodeTraceFailed,  0, 160, DRAW_LUMIN_ICOM_WINDOW);
    }
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    
    UpdateCenterAreaPicData();
}
void HJ_OtherDisplay()
{
    //SetDisplayStaticItemW2(HJ_pilotlamp,  0, 110, DRAW_LUMIN_ICOM_WINDOW);

    uint8_t uiDspInfoVSpeed[16+1];
    uiDspInfoVSpeed[0]=0;
    
    //sprintf(uiDspInfoVSpeed,"%4d km/h",HJ_CurvSpeedNum);
    //DspOneLineDynamicStr(uiDspInfoVSpeed, 80,  120);  

  

    uint8_t uiDspInfoEspeed[16+1];
    uiDspInfoEspeed[0]=0;
    //sprintf(uiDspInfoEspeed,"%4d r/min",HJ_CureSpeedNum);
    //DspOneLineDynamicStr(uiDspInfoEspeed, 80,  205); 

    uint8_t uiDspInfoFuel[16+1];
    uiDspInfoFuel[0]=0;
    //sprintf(uiDspInfoFuel,"%4d /5",HJ_CurFuelNum);
    //DspOneLineDynamicStr(uiDspInfoFuel, 80,  150);  

    switch (HJ_CurFuelNum) {
        case 1: {
            if ((FuelResTest >= 1350) && (FuelResTest <= 1650)) {
                ;// SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, 150, DRAW_LUMIN_ICOM_WINDOW);//����
            }else if(NUM7Flag == NUM7_UDSStateFail) {
               ; //ErrorBlink_S(SW_HJSW_X + 200, 150);
            }
        }break;

        case 2: {
            if ((FuelResTest >= 648) && (FuelResTest <= 792)) {
                ;// SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, 150, DRAW_LUMIN_ICOM_WINDOW);//����
            }else if(NUM7Flag == NUM7_UDSStateFail) {
                ;//ErrorBlink_S(SW_HJSW_X + 200, 150);
            }
        }break;

        case 3: {
            if ((FuelResTest >= 180) && (FuelResTest <= 220)) {
                ;// SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, 150, DRAW_LUMIN_ICOM_WINDOW);//����
            }else if(NUM7Flag == NUM7_UDSStateFail) {
                ;//ErrorBlink_S(SW_HJSW_X + 200, 150);
            }
        }break;

        case 4: 
        case 5: {
            if ((FuelResTest >= 90) && (FuelResTest <= 110)) {
                 ;//SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, 150, DRAW_LUMIN_ICOM_WINDOW);//����
            }else if(NUM7Flag == NUM7_UDSStateFail) {
                ;//ErrorBlink_S(SW_HJSW_X + 200, 150);
            }
        }break;

        default: {
            
            if (FuelResTest >= 60000) {
                 ;//SetDisplayDynamicItemW2(RIGHT_S, SW_HJSW_X + 200, 150, DRAW_LUMIN_ICOM_WINDOW);//����
            }else if(NUM7Flag == NUM7_UDSStateFail) {
                ;//ErrorBlink_S(SW_HJSW_X + 200, 150);
            }
        }break;
    }
    
     uint8_t uiDspInfoSetting[16+1];
    uiDspInfoSetting[0]=0;
    sprintf(uiDspInfoSetting,"%4d /12",HJ_OtherKeyCurrent.count);
    DspOneLineDynamicStr(uiDspInfoSetting, 80,  265);  

    uint8_t uiDspInfoTime[16+1];
    uiDspInfoTime[0]=0;
   //switch(HJ_OtherKeyCurrent.count)
   //{
   //    case 1:
   //    sprintf(uiDspInfoTime,"00:00",HJ_CurFuelNum);
   //    break;
   //    case 2:
   //    sprintf(uiDspInfoTime,"11:11",HJ_CurFuelNum);
   //    break;
   //    case 3:
   //    sprintf(uiDspInfoTime,"22:22",HJ_CurFuelNum);
   //    break;
   //    case 4:
   //    sprintf(uiDspInfoTime,"23:59",HJ_CurFuelNum);
   //    break;
   //    default:
   //    sprintf(uiDspInfoTime,"00:00",HJ_CurFuelNum);
   //    break;
   //}
   //if(Othercount >= 3 ) {
   //    DspOneLineDynamicStr(uiDspInfoTime, 115, 175); 
   //} else {
   //    //SET_DISPLAY_STATIC_ITEM(0, HJSettingTime, 80, 146, DRAW_LUMIN_ICOM_WINDOW);  
   //    SetDisplayStaticItemW2(HJSettingTime,  105,  170, DRAW_LUMIN_ICOM_WINDOW);
   //}
     switch(HJ_OtherKeyCurrent.count)
    {
        case 1:
        //SetDisplayStaticItemW2(HJ_rightlight  ,  90, 225, DRAW_LUMIN_ICOM_WINDOW);

        //SetDisplayStaticItemW2(HJ_Lightout,  90, 225, DRAW_LUMIN_ICOM_WINDOW);

        break;
        case 2:
        //SetDisplayStaticItemW2(HJ_Left,  70, 225, DRAW_LUMIN_ICOM_WINDOW);
        //SetDisplayStaticItemW2(HJ_rightlight,  150, 225, DRAW_LUMIN_ICOM_WINDOW);
        
        //SetDisplayStaticItemW2(HJ_Lightout,  150, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;
        case 3:
        //SetDisplayStaticItemW2(HJ_Distancelight,  70, 225, DRAW_LUMIN_ICOM_WINDOW);
        //SetDisplayStaticItemW2(HJ_ABS ,  150, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;
        case 4:
        //SetDisplayStaticItemW2(HJ_DianPen ,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
        
        break;
        case 5:
        
        //SetDisplayStaticItemW2(HJ_JiYou ,  70, 225, DRAW_LUMIN_ICOM_WINDOW);
        //SetDisplayStaticItemW2(HJ_S ,  150, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;
        case 6:
        //SetDisplayStaticItemW2(HJ_NGear  ,  70, 225, DRAW_LUMIN_ICOM_WINDOW);
        //SetDisplayStaticItemW2(HJ_TCS  ,  100, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;

         case 7:
         //SetDisplayStaticItemW2(HJ_ZiDong  ,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
    //    SetDisplayStaticItemW2(HJ_rightlight,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;

         case 8:
        //SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
        //SetDisplayStaticItemW2( HJ_Engine,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;

         case 9:
        //SetDisplayStaticItemW2(HJ_E,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;

         case 10:
         //SetDisplayStaticItemW2(HJ_HEV,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
      //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;

         case 11:
        //SetDisplayStaticItemW2( HJ_Alllight,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;

     //   case 12:
     //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
     //  break;

     //   case 13:
     //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
     //  break;
     //   case 14:
     //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
     //  break;
     //   case 15:
     //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
     //  break;
     //   case 16:
     //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
     //  break;
     //   case 17:
     //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
     //  break;

     //   case 6:
     //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
     //  break;

     //   case 6:
     //  SetDisplayStaticItemW2(,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
     //  break;


        default:
        SetDisplayStaticItemW2( HJ_Alllight,  90, 225, DRAW_LUMIN_ICOM_WINDOW);
        break;
    }
    



}

void UpdateCenterTripC(void)
{
    uint32_t tmp = 0;
    static uint32_t Timer1msCnts_Old = 0;
    int i = 0;

    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    g_uiStaticIndex = 0;
    g_uiDyncIndex = 0;
    
    if (Timer1msCnts >= Timer1msCnts_Old) {
        tmp = Timer1msCnts - Timer1msCnts_Old;
    } else {
        tmp = (0xffffffff - Timer1msCnts_Old) + Timer1msCnts;
    }
    Timer1msCnts_Old = Timer1msCnts;
    Time_1K += tmp;
    
    General_Display();
    if( g_Stage == STAGE_Led_Telltale_Check || 
        g_Stage == STAGE_Speed || 
        g_Stage == STAGE_WaterAndFuel || 
        g_Stage == STAGE_TFTCheck  || 
        g_Stage == STAGE_Other ||
        g_Stage == STAGE_LCDCheck /*||
        g_Stage == STAGE_SetEOL*/)
    {
        DspCheckResult(RESULT_MAN_REVIEW);
    }
    switch(g_Stage)    //��̬ͼѡ����
    {
        case 0:
             STEP0_Display();
#if (PRO_JAPE2)
             Electricity();
#endif
             break;
        case STAGE_AutoCheck:    //�Լ�
             AUTO_Display();
             break; 
        case STAGE_Led_Telltale_Check:  //����ָʾ��
             //LED_Display();
             break;    
        case STAGE_Speed:        //����ת��Ƶ��ռ�ձ�  
             //SPEED_Display();
             break;       
        case STAGE_WaterAndFuel: //ˮ�ͼ��  
             //OIL_TEMP_Display();
             break;                                                      
        case STAGE_TFTCheck:     //TFT
             //TFT_Display();
             break;
        case STAGE_Other:       //���� ELse
            // ELSE_Display();
             HJ_OtherDisplay();
             break;
        case STAGE_ClearODO:   //END ����
             //END_Display();
             break;
        case STAGE_SetEOL:     //���� EOL����
             //EOL_Display();
             break; 
        case STAGE_LCDCheck:   //LCD
             //LCD_Display();
             break;  
        default:
            break;
    } 


    SetCenterAreaDisplayList(&DisplayItem, 400);
    
    UpdateCenterAreaPicData();
}

#if (PRO_CONFIG_EOL_APPLY)
extern ST_POS g_stArrowPos[PER_PAGE_MAX_NUM];
extern unsigned int VC_List[][2];
void Disp_Table_S(uint32_t x, uint32_t y, uint32_t data)
{
    //CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    uint32_t Data = 0x0;
    uint8_t i= 0;
    g_uiStaticIndex = 0;
    g_uiDyncIndex = 0;
    
    if(g_uiPosUpdateFlag == 0) {
        g_stArrowPos[g_uiIdx].uiX = x - 20;
        g_stArrowPos[g_uiIdx].uiY = y;
    }

    SetDisplayStaticItemW1(P_Line,   0,  28, DRAW_LUMIN_ICOM_WINDOW);            // ����
    SetDisplayStaticItemW1(PW1_04,   9,  36, DRAW_LUMIN_ICOM_WINDOW);            //״̬
    SetDisplayStaticItemW1(P_Line,   0,  60, DRAW_LUMIN_ICOM_WINDOW);            // ����

    
    for(i=0;i<4;i++)
    {
        Data = (data & (0xF000 >> (4*i))) >> (4 * (3-i));
        SetDisplayDynamicItemW2(NumberList_EOL[Data],  (x+i*13),   y, DRAW_LUMIN_ICOM_WINDOW);            
        //SetCenterAreaDisplayList(&DisplayItem, 400);
        //UpdateCenterAreaPicData();
    }
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}
uint32_t g_tmp = 0;
uint8_t Eol_receive[4] = {0x00};
void Move_Arrow_S(uint8_t data)
{
    uint32_t tmp = 0;
    //CENTER_AREA_DISPLAY_ITEM DisplayItem;
   // memset(&DisplayItem, 0, sizeof (DisplayItem));
    //DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    UpdateTitle();

    SetDisplayDynamicItemW2(MoveArrow,  g_stArrowPos[data].uiX, g_stArrowPos[data].uiY, DRAW_LUMIN_ICOM_WINDOW);            

    if(g_Stage == STAGE_SetEOL){
        SetDisplayDynamicItemW1(PW1_05,    80, 36, DRAW_LUMIN_ICOM_WINDOW);//����
        SetDisplayDynamicItemW1(PW1_06,   126, 36, DRAW_LUMIN_ICOM_WINDOW);//�� 
    }
    
    tmp = Eol_receive[0];
    tmp = tmp << 8 | Eol_receive[1];
    tmp = tmp << 8 | Eol_receive[2];
    tmp = tmp << 8 | Eol_receive[3];
    g_tmp = tmp;
    if (EOL.Statu == 5) {
        if(VC_List[data][1] == tmp){
            SetDisplayDynamicItemW1(PW1_05,  80, 36, DRAW_LUMIN_ICOM_WINDOW);//����
            SetDisplayDynamicItemW1(PW1_08, 126, 36, DRAW_LUMIN_ICOM_WINDOW);//�ɹ�   
            VC_List[data][0] = (VC_List[data][0] | 0x0000);
        } else {
            SetDisplayDynamicItemW1(PW1_05,  80, 36, DRAW_LUMIN_ICOM_WINDOW);//����
            SetDisplayDynamicItemW1(PW1_11, 126, 36, DRAW_LUMIN_ICOM_WINDOW);//ʧ��
        }
    }
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}


void UpdateCenterEol(void)
{
    uint8_t uiIdx = 0;
    uint16_t uiXOffset = 0;
    uint16_t uiYOffset = 0;
    if (TFTCurrent.count < g_uiTotleCount) {
        for(uint8_t uiRow = 0;uiRow < g_uiRowNum; uiRow++) {
            for(uint8_t uiCol = 0;uiCol < PER_ROW_NUM; uiCol++) {
                if(uiIdx < g_uiTotleCount) {
                    Disp_Table_S(28 + uiXOffset, 66 + uiYOffset, VC_List[uiIdx++][0]);
                    uiXOffset += 75;
                    if(g_uiPosUpdateFlag == 0 && g_uiIdx < g_uiTotleCount) {
                        g_uiIdx++;
                        if(g_uiPosUpdateFlag == 0 && g_uiIdx == g_uiTotleCount){
                            g_uiPosUpdateFlag = 1;
                        }
                    }
                } else {
                    break;
                }
            }
            uiXOffset = 0;
            uiYOffset += 20;
        }
    } else {

    }
    Move_Arrow_S(TFTCurrent.count);
}
#endif


/*-------------------------------------------------------------------------
* Function Name  : NumberDisplay
* Description    : ����4λ����
* Input          : ����-ͼ��-�Ƿ��е�-����
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void  NumberDisplay(uint16_t  data,uint8_t  n,uint8_t  point,uint16_t  x,uint16_t  x1,uint16_t  y,uint16_t  y1)
{
    uint8_t m = 0;
    
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    if(point == 1)  m = 4;
    //  SET_DISPLAY_STATIC_ITEM(0, gImage_P001, 100, 100, DRAW_LUMIN_ICOM_WINDOW);
    //  SET_DISPLAY_STATIC_ITEM_WINDOW(0, 100, 240, 100, 320);
    
    SET_DISPLAY_STATIC_ITEM(0, P_Line, 0, 45, DRAW_LUMIN_ICOM_WINDOW);
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
    
    
    SET_DISPLAY_DYNC_ITEM(n,   NumberList[data % 10],      x+65, y, DRAW_ICON);
    if(m == 4)
        SET_DISPLAY_DYNC_ITEM(n+4, gImage_point, x+60, y, DRAW_ICON);
    SET_DISPLAY_DYNC_ITEM(n+1, NumberList[data /10% 10],   x+50-m, y, DRAW_ICON);
    SET_DISPLAY_DYNC_ITEM(n+2, NumberList[data /100 % 10], x+35-m, y, DRAW_ICON);
    SET_DISPLAY_DYNC_ITEM(n+3, NumberList[data /1000 % 10],x+20-m, y, DRAW_ICON);
    
    SET_DISPLAY_DYNC_ITEM_WINDOW(n,   x, x1, y, y1);
    SET_DISPLAY_DYNC_ITEM_WINDOW(n+1, x, x1, y, y1);
    SET_DISPLAY_DYNC_ITEM_WINDOW(n+2, x, x1, y, y1);
    SET_DISPLAY_DYNC_ITEM_WINDOW(n+3, x, x1, y, y1);
    SET_DISPLAY_DYNC_ITEM_WINDOW(n+4, x, x1, y, y1);
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    
}
/*-------------------------------------------------------------------------
* Function Name  : OneTransverterSixteen
* Description    : ��ɫת16�Ȼ�
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void OneTransverterSixteen(uint8_t *buf)
{
    uint32_t   i,m,k,tmp;
    uint8_t   txt,j;
    
    memset((uint8_t*)&bufdat, 0, sizeof (bufdat));
    
    bufdat[0]=buf[0];
    bufdat[1]=buf[1];
    bufdat[2]=buf[2];
    bufdat[3]=buf[3];
    tmp = (int32_t)((buf[0]*buf[2])/8 + 4);
    m=3;
    for(i = 4;i<tmp;i++)
    {
        if(((m-3)%buf[0] == 0) &&(m != 3))
        {
            m = m+(buf[0]*3);
        }
        m++;
        k = m;
        txt = buf[i];
        for(j=0;j<8;j++)
        {
            if((j%2==0)&&(j != 0))
                k=k+buf[0];
            if(txt & 0x1 == 1)
            {
                bufdat[k] |= 0xf0;
            }
            if(j%2==0)
                bufdat[k] = bufdat[k] >> 4;
            txt = txt >> 1;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_CalDataLen
* Description    : �������ݳ���
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
uint8_t App_CalDataLen(uint32_t data)
{
    uint8_t len = 1;
    
    if(data /10 >0)
        len = 2;
    if(data /100>0)
        len = 3;
    if(data /1000 >0)
        len = 4;
    if(data /10000 >0)
        len = 5;
    if(data /100000 >0)
        len = 6;
    return len;
}

void UpdateClusterCheck(void)
{
    //CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    g_uiStaticIndex = 0;
    g_uiDyncIndex = 0;

    DspOneLineStaticStr(CluPartNum,58,130);
    SetDisplayStaticItemW2(PartNotSupport, 0, 160,DRAW_LUMIN_ICOM_WINDOW);

	SetCenterAreaDisplayList(&DisplayItem, 400);
	UpdateCenterAreaPicData();
}

void LcdError(void)
{
    //CENTER_AREA_DISPLAY_ITEM DisplayItem;
 //   memset(&DisplayItem, 0, sizeof (DisplayItem));
 //   DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
 //   g_uiStaticIndex = 0;
 //   g_uiDyncIndex = 0;
 //   DisplayString(CluPartNum,2,30,130);
 //   DisplayString("E1",2,30,160);

	//SetCenterAreaDisplayList(&DisplayItem, 400);
	//UpdateCenterAreaPicData();
}

void UpdateConnectCluster(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;

    if (UI_CHINESE == g_UI_Language) {
        SET_DISPLAY_STATIC_ITEM(0, ConnectClusterCh, 0, 103, DRAW_LUMIN_ICOM_WINDOW);     
    }
    else  if (UI_ENGLISH== g_UI_Language) {
        SET_DISPLAY_STATIC_ITEM(0, ConnectClusterEn, 0, 103, DRAW_LUMIN_ICOM_WINDOW);     
    }       
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320); 

    

    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateErrNum(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
	
	SET_DISPLAY_STATIC_ITEM( 2, NumberList[CheckStep /100%10], 122,  35, DRAW_LUMIN_ICOM_WINDOW); //������� ��λ
	SET_DISPLAY_STATIC_ITEM_WINDOW( 2, MIN_START_X, MAX_STOP_X, W1_START_Y, W1_STOP_Y);
	
	SET_DISPLAY_STATIC_ITEM( 1, NumberList[CheckStep /10%10],  137,  35, DRAW_LUMIN_ICOM_WINDOW); //������� ʮλ
	SET_DISPLAY_STATIC_ITEM_WINDOW( 1, MIN_START_X, MAX_STOP_X, W1_START_Y, W1_STOP_Y);

	SET_DISPLAY_STATIC_ITEM( 0, NumberList[CheckStep % 10],    152,  35, DRAW_LUMIN_ICOM_WINDOW); //������� ��λ
	SET_DISPLAY_STATIC_ITEM_WINDOW( 0, MIN_START_X, MAX_STOP_X, W1_START_Y, W1_STOP_Y);
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateBarcode(void)
{
    //CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    g_uiStaticIndex = 0;
    g_uiDyncIndex = 0;
	if(BarcodeErr == 0)
	{
	    if (g_UI_Language == UI_CHINESE)
            SetDisplayStaticItemW2(gImage_Barcode, 30, 146, DRAW_LUMIN_ICOM_WINDOW);  
        else
            DspOneLineStaticStr("Please scan QR code",  5, 146);
	}
	else
	{
	    if (g_UI_Language == UI_CHINESE)
    	    SetDisplayStaticItemW2(QrCodeUnmatched, 0, 146, DRAW_LUMIN_ICOM_WINDOW);  
        else
            DspOneLineStaticStr("QR code error",  40, 146);
	}
    //SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320); 

    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateGetClusterPartNum(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    SET_DISPLAY_STATIC_ITEM(0, gImage_GettingPartNum, 30, 146, DRAW_LUMIN_ICOM_WINDOW);            
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateClusterError(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    SET_DISPLAY_STATIC_ITEM(0, gImage_ClusterTypeError, 30, 146, DRAW_LUMIN_ICOM_WINDOW);            
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateSetQRcodeErr(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    SET_DISPLAY_STATIC_ITEM(0, gImage_TftSetQRcodeErr, 30, 146, DRAW_LUMIN_ICOM_WINDOW);            
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
	
	SET_DISPLAY_DYNC_ITEM( 0, NumberList[5 - SetCheckStationBarcodeCnts], 121, 187, DRAW_LUMIN_ICOM_WINDOW); //������� ��λ
    SET_DISPLAY_DYNC_ITEM_WINDOW(0, 0, 240, 0, 320);
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateSetQRcode(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    SET_DISPLAY_STATIC_ITEM(0, gImage_TftSetQRcode, 30, 146, DRAW_LUMIN_ICOM_WINDOW);            
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
	
	SET_DISPLAY_DYNC_ITEM( 0, NumberList[5 - SetCheckStationBarcodeCnts], 180, 184, DRAW_LUMIN_ICOM_WINDOW); //������� ��λ
    SET_DISPLAY_DYNC_ITEM_WINDOW(0, 0, 240, 0, 320);
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateConfigingClu(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    SET_DISPLAY_STATIC_ITEM(0, gImage_TftConfigingClu, 30, 146, DRAW_LUMIN_ICOM_WINDOW);            
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateConfigComplete(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    SET_DISPLAY_STATIC_ITEM(0, gImage_TftConfigComplete, 30, 146, DRAW_LUMIN_ICOM_WINDOW);            
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateConfigErr(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    SET_DISPLAY_STATIC_ITEM(0, gImage_TftConfigErr, 30, 146, DRAW_LUMIN_ICOM_WINDOW);            
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdatePleaseScan(void)
{
    CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    SET_DISPLAY_STATIC_ITEM(0, gImage_TftPleaseScan, 30, 146, DRAW_LUMIN_ICOM_WINDOW);
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}

void UpdateConfigFail(void)
{
	CENTER_AREA_DISPLAY_ITEM DisplayItem;
    memset(&DisplayItem, 0, sizeof (DisplayItem));
    DisplayItem.DisplayType = CENTER_AREA_DISPLAY_TYPE_NORMAL;
    
    SET_DISPLAY_STATIC_ITEM(0, gImage_TftConfigFail, 30, 146, DRAW_LUMIN_ICOM_WINDOW);            
    SET_DISPLAY_STATIC_ITEM_WINDOW(0, 0, 240, 0, 320);   
    
    SetCenterAreaDisplayList(&DisplayItem, 400);
    UpdateCenterAreaPicData();
}
