#include "common_include.h"
#include "bsp_button.h"
#include "bsp_speed_check.h"
#include "bsp_app_led_output.h"
#include "bsp_app_tft_output.h"

typedef union { 
  uint8_t Data[4];
  struct {
        uint16_t ECS           :1;
        uint16_t LKA_LDW       :1;
        uint16_t TPMS          :1;
        uint16_t ESC           :1;
        uint16_t MDPS          :1;
        uint16_t AHLS          :1;
        uint16_t EPB           :1;
        uint16_t _SCC          :1;
        
        uint16_t eCall         :1;
        uint16_t EVP           :1;
        uint16_t _AT           :1;
        uint16_t _4WD          :1;
        uint16_t AFL           :1;
        uint16_t PSB           :1;
        uint16_t AIR_BAG       :1;
        uint16_t ABS           :1;
        
        uint16_t Area          :4;
        uint16_t SpeedType     :2;
        uint16_t FuelType      :2;
        
        uint16_t AutoLight     :1;
        uint16_t FCA           :1;
        uint16_t ISG           :1;
        uint16_t CAR4          :1;
        uint16_t CAR3          :1;
        uint16_t CAR2          :1;
        uint16_t CAR1          :2;
    };
}EOL_UNOIN;
EOL_UNOIN EolData;
_Eol      EOL;

uint8_t VinNumSendBuf[17];
uint8_t VinNumReadBuf[17];
uint8_t PowerCheckFlag = POWER_CHECK_END;
uint8_t EOL_Flag = 0;
uint8_t ReceiveData[8] = {0}; 
uint8_t UdsKeyData[8] = {0}; 
uint8_t Key27Buffer[128] = {0};
uint8_t Key27Step = 0u;
uint8_t Write2EStep = 0;
uint8_t parking_big = 0;
uint8_t TelltaleFlag = 0;
uint8_t LanguageFlag = 0;
uint8_t g_EolCfgFuelType = 0;//GSL����
#if (PRO_CONFIG_EOL_APPLY) 
void SendEOLMessage(uint8_t statu)
{
    uint32_t EOL_data = 0;
    EOL_data = VC_List[statu][1];
#if (CAN_2ND)    
    //DATA1 Bit7 - Bit4
    if(EOL_data & 0x80000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x420, BUF_16, TX_ISR_EN, (uint8_t*)&Send_420.msg.data, 8);/* SCC     */ 
    } else {
        ;
    }
    if(EOL_data & 0x40000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x490, BUF_11, TX_ISR_EN, (uint8_t*)&Send_490.msg.data, 8);/* EPB     */ 
    } else {
        ;
    }

    //AHLS 
    
    if(EOL_data & 0x10000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x381, BUF_15, TX_ISR_EN, (uint8_t*)&Send_381.msg.data, 8);/* MDPS    */
    } else {
        ;
    }
    
    //DATA1  Bit3 - Bit0  
    if(EOL_data & 0x08000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x507, BUF_12, TX_ISR_EN, (uint8_t*)&Send_507.msg.data, 8);/* ESC     */ 
    } else {
        ;
    }
    if(EOL_data & 0x04000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x593, BUF_17, TX_ISR_EN, (uint8_t*)&Send_593.msg.data, 8);/*TPMS     */  
    } else {
        ;
    }
    if(EOL_data & 0x02000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x340, BUF_14, TX_ISR_EN, (uint8_t*)&Send_340.msg.data, 8);/* LKA     */ 
    } else {
        ;
    }
    if(EOL_data & 0x01000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x220, BUF_19, TX_ISR_EN, (uint8_t*)&Send_12A.msg.data, 8);/* ECS     */ 
    } else {
        ;
    }
    //DATA2 Bit7 - Bit4
    if(EOL_data & 0x00800000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x38A, BUF_9,  TX_ISR_EN, (uint8_t*)&Send_420.msg.data, 8);/* ABS     */  
    } else {
        ;
    }
    if(EOL_data & 0x00400000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x500, BUF_10, TX_ISR_EN, (uint8_t*)&Send_500.msg.data, 8);/* Air Bag */  
    } else {
        ;
    }
    //PSB
    //AFL
    //DATA2  Bit3 - Bit0  
//    if(EOL_data & 0x00080000){
//        CanFD_Send_StandMsg(CANFD0_Type, 0x1A5, BUF_18, TX_ISR_EN, (uint8_t*)&Send_1A5.msg.data, 8);/*4WD      */ 
//    } else {
//        ;
//    }
    if(EOL_data & 0x00040000){
        Send_586.msg.bits.Byte0Data = 0x00;
        Send_586.msg.bits.Byte1Data = 0x00;  
        Send_586.msg.bits.Byte2Data = 0x00;
        Send_586.msg.bits.Byte3Data = 0x00;
        Send_586.msg.bits.Byte4Data = 0x30; 
        CanFD_Send_StandMsg(CANFD0_Type, 0x368, BUF_30, TX_ISR_EN, (uint8_t*)&Send_586.msg.data, 8);/*AT       */ 
        
    } else {
        ;
    }
    if(EOL_data & 0x00020000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x586, BUF_19, TX_ISR_EN, (uint8_t*)&Send_586.msg.data, 8); /*EVP    */ 
    } else {
        ;
    }
    if(EOL_data & 0x00010000){
        CanFD_Send_StandMsg(CANFD1_Type, 0x141, BUF_20, TX_ISR_EN, (uint8_t*)&Send_340.msg.data, 8); /*ECALL    */ 
    } else {
        ;
    }
#endif
#if (CAN_3RD)  
    if(EOL_data & 0x80000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x1A0, BUF_16, TX_ISR_EN, (uint8_t*)&Send_1A0.msg.data, 8);/* SCC     */ 
    } else {
        ;
    }
    if(EOL_data & 0x40000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x1F0, BUF_11, TX_ISR_EN, (uint8_t*)&Send_1F0.msg.data, 8);/* EPB     */ 
    } else {
        ;
    }
    if(EOL_data & 0x10000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x0EA, BUF_15, TX_ISR_EN, (uint8_t*)&Send_0EA.msg.data, 8);/* MDPS    */
    } else {
        ;
    }
    
    if(EOL_data & 0x08000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x060, BUF_12, TX_ISR_EN, (uint8_t*)&Send_060.msg.data, 8);/* ESC     */ 
    } else {
        ;
    }
    if(EOL_data & 0x04000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x3A0, BUF_17, TX_ISR_EN, (uint8_t*)&Send_3A0.msg.data, 8);/*TPMS     */  
    } else {
        ;
    }
    if(EOL_data & 0x02000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x12A, BUF_14, TX_ISR_EN, (uint8_t*)&Send_12A.msg.data, 8);/* LKA     */ 
    } else {
        ;
    }
    if(EOL_data & 0x01000000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x220, BUF_19, TX_ISR_EN, (uint8_t*)&Send_220.msg.data, 8);/* ECS     */ 
    } else {
        ;
    }
    if(EOL_data & 0x00800000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x06F, BUF_9,  TX_ISR_EN, (uint8_t*)&Send_06F.msg.data, 8);/* ABS     */  
    } else {
        ;
    }
    if(EOL_data & 0x00400000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x20A, BUF_10, TX_ISR_EN, (uint8_t*)&Send_20A.msg.data, 8);/* Air Bag */  
    } else {
        ;
    }
    if(EOL_data & 0x00080000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x1A5, BUF_18, TX_ISR_EN, (uint8_t*)&Send_1A5.msg.data, 8);/*4WD      */ 
    } else {
        ;
    }
    if(EOL_data & 0x00040000){
        Send_3B3.msg.bits.Byte0Data = 0x00;
        Send_3B3.msg.bits.Byte1Data = 0x00;  
        Send_3B3.msg.bits.Byte2Data = 0x00;
        Send_3B3.msg.bits.Byte3Data = 0x00;
        Send_3B3.msg.bits.Byte4Data = 0x30; 
        CanFD_Send_StandMsg(CANFD0_Type, 0x040, BUF_30, TX_ISR_EN, (uint8_t*)&Send_3B3.msg.data, 8);/*AT       */ 
        
    } else {
        ;
    }
    if(EOL_data & 0x00020000){
        CanFD_Send_StandMsg(CANFD0_Type, 0x3B3, BUF_19, TX_ISR_EN, (uint8_t*)&Send_3B3.msg.data, 8); /*EVP    */ 
    } else {
        ;
    }
    if(EOL_data & 0x00010000){
        CanFD_Send_StandMsg(CANFD1_Type, 0x3BF, BUF_20, TX_ISR_EN, (uint8_t*)&Send_3BF.msg.data, 8); /*ECALL    */ 
    } else {
        ;
    }
#endif
}
#endif

void SendCan0Message_EOL(void)
{
    //if ((Timer10msCnts > SendCanMessage10msTimer) && ((Timer10msCnts - SendCanMessage10msTimer) >= 10)) 
    {
        // 50ms
        SendCanMessage10msTimer = Timer10msCnts;
        InitBuf();
#if ((PRO_QXI) || (PRO_QX23))    
        // CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        // CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        // CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        // CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        // CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        // CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        // CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        // CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        // CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        // CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        // CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); 
        
        // CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 

#elif (PRO_LX2)   
        CanSendCan0Msg(0x421,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */ 
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */ 
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */    
        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
         
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);    /* AT */ 
        CanSendCan0Msg(0x428,CAN_4WD11_.msg.data, 8,0); /* 4wd11 */  
#elif (PRO_ONPE)
        CanSendCan0Msg(0x421,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */ 
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */ 
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */    
        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */  
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);    /* AT */ 
        CanSendCan0Msg(0x428,CAN_4WD11_.msg.data, 8,0); /* 4wd11 */         
#elif (PRO_AX)
       CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
       CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
       CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
       CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
       CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
       CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
       CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
       CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
       CGW_PC6.msg.bits.TCU_TYPE = 0x1;
       CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); 
#elif (PRO_TAM)
       CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
       CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
       CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
       CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
       CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
       CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
       CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
       CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
       CGW_PC6.msg.bits.TCU_TYPE = 0x1;
       CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); 
#elif (PRO_SK3_PE)
       CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
       CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
       CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
       CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
       CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
       CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
       CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
       CGW_PC6.msg.bits.TCU_TYPE = 0x1;
       CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);
#elif (PRO_NQ5)
        TCU_01_10ms.TCU_Typ=0x2;
        CanSendCan0Msg(0x1A0,Send_1A0.msg.data, 32,0);/* SCC     */   
        CanSendCan0Msg(0x1F0,Send_1F0.msg.data, 16,0);/* EPB     */ 
        CanSendCan0Msg(0x0EA,Send_0EA.msg.data, 24,0);/* MDPS    */ 
        CanSendCan0Msg(0x060,Send_060.msg.data, 32,0);/* ESC     */ 
        CanSendCan0Msg(0x3A0,Send_3A0.msg.data, 16,0);/* TPMS     */
        CanSendCan0Msg(0x12A,Send_12A.msg.data, 16,0);/* LKA     */ 
        CanSendCan0Msg(0x220,Send_220.msg.data, 16,0);/* ECS     */
        CanSendCan0Msg(0x06F,Send_06F.msg.data, 32,0);/* ABS     */ 
        CanSendCan0Msg(0x20A,Send_20A.msg.data, 16,0);/* Air Bag */ 
        CanSendCan0Msg(0x1A5,Send_1A5.msg.data, 32,0);/* 4WD      */ 
        CanSendCan0Msg(0x040,TCU_01_10ms, 32,0);      /* AT      */ 
        
        CanSendCan1Msg(0x3BF,Send_3B3.msg.data, 8,0); /*ECALL    */ 
#elif (PRO_SP2)
        if (JudgePartNum() == PartNum_SP2){
            CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
            CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
            CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
            CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
            CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
            CanSendCan0Msg(0x38A,Send_38A.msg.data, 8,0);/* ABS */ 
            CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
            CanSendCan0Msg(0x428,Send_428.msg.data, 8,0);/* 4wd11 */
            CanSendCan0Msg(0x368,Send_586.msg.data, 8,0);/* AT */ 
            CGW_PC6.msg.bits.TCU_TYPE = 0x1;
            CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); 
            CanSendCan0Msg(0x367,Send_340.msg.data, 8,0); /* ISG    */ 
            CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     
        } else if (JudgePartNum() == PartNum_SP2I){
            CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
            CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
            CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
            CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
            CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
            CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
            CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
            CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
            CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
            CGW_PC6.msg.bits.TCU_TYPE = 0x1;
            CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
            CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
        }
#elif (PRO_QYC)
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif (PRO_KY)
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */ 
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */ 
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); /* AT */ 
        
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */        
#elif (PRO_SG2)
        TCU_01_10ms.TCU_Typ=0x2;
        CanSendCan0Msg(0x1A0,Send_1A0.msg.data, 32,0);/* SCC     */   
        CanSendCan0Msg(0x1F0,Send_1F0.msg.data, 16,0);/* EPB     */ 
        CanSendCan0Msg(0x0EA,Send_0EA.msg.data, 24,0);/* MDPS    */ 
        CanSendCan0Msg(0x060,Send_060.msg.data, 32,0);/* ESC     */ 
        CanSendCan0Msg(0x3A0,Send_3A0.msg.data, 16,0);/* TPMS    */
        CanSendCan0Msg(0x12A,Send_12A.msg.data, 16,0);/* LKA     */ 
        CanSendCan0Msg(0x220,Send_220.msg.data, 16,0);/* ECS     */
        CanSendCan0Msg(0x06F,Send_06F.msg.data, 32,0);/* ABS     */ 
        CanSendCan0Msg(0x20A,Send_20A.msg.data, 16,0);/* Air Bag */ 
        CanSendCan0Msg(0x1A5,Send_1A5.msg.data, 32,0);/* 4WD     */ 
        CanSendCan0Msg(0x040,TCU_01_10ms, 32,0);      /* AT      */ 
        CanSendCan1Msg(0x3BF,Send_3B3.msg.data, 8,0); /* ECALL   */ 
#elif (PRO_US4)
        TCU_01_10ms.TCU_Typ=0x2;
        CanSendCan0Msg(0x1A0,Send_1A0.msg.data, 32,0);/* SCC     */   
        CanSendCan0Msg(0x1F0,Send_1F0.msg.data, 16,0);/* EPB     */ 
        CanSendCan0Msg(0x0EA,Send_0EA.msg.data, 24,0);/* MDPS    */ 
        CanSendCan0Msg(0x060,Send_060.msg.data, 32,0);/* ESC     */ 
        CanSendCan0Msg(0x3A0,Send_3A0.msg.data, 16,0);/* TPMS    */
        CanSendCan0Msg(0x12A,Send_12A.msg.data, 16,0);/* LKA     */ 
        CanSendCan0Msg(0x06F,Send_06F.msg.data, 32,0);/* ABS     */ 
        CanSendCan0Msg(0x20A,Send_20A.msg.data, 16,0);/* Air Bag */ 
        CanSendCan0Msg(0x220,Send_220.msg.data, 16,0);/* ECS     */
        CanSendCan0Msg(0x1A5,Send_1A5.msg.data, 32,0);/* 4WD     */ 
        CanSendCan0Msg(0x040,TCU_01_10ms, 32,0);      /* AT      */ 
        CanSendCan1Msg(0x3BF,Send_3B3.msg.data, 8,0); /* ECALL   */  
#elif (PRO_BR2)
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */ 
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);    /* AT */ 
        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
#elif (PRO_KS)
//        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
//        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */  
//        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0); /* MDPS11  */ 
//
//        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
//        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
//        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     
//
//        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
//        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
//
//        CanSendCan0Msg(0x428,Send_428.msg.data, 8,0);/* 4wd11 */
//        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); /* AT */ 
//        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */   
                CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); 
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */
#elif (PRO_NUPE)
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */  
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0); /* MDPS11  */ 

        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     

        //CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 

        //CanSendCan0Msg(0x428,Send_428.msg.data, 8,0);/* 4wd11 */
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); /* AT */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */ 
        //CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */  
#elif (PRO_KU)
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */  
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0); /* MDPS11  */ 

        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     

        //CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 

        //CanSendCan0Msg(0x428,Send_428.msg.data, 8,0);/* 4wd11 */
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); /* AT */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */ 
        //CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */          
#elif (PRO_SQFL)
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */  
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0); /* MDPS11  */ 

        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     

        //CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 

        //CanSendCan0Msg(0x428,Send_428.msg.data, 8,0);/* 4wd11 */
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); /* AT */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */ 
        //CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */  
#elif (PRO_DL3C)
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */  
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0); /* MDPS11  */ 

        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     

        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
        CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 

        //CanSendCan0Msg(0x428,Send_428.msg.data, 8,0);/* 4wd11 */
      //  CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); /* AT */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */ 
        //CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */  
#elif (PRO_GL3)
        TCU_01_10ms.TCU_Typ=0x2;
        CanSendCan0Msg(0x1A0,Send_1A0.msg.data, 32,0);/* SCC     */   
        CanSendCan0Msg(0x1F0,Send_1F0.msg.data, 16,0);/* EPB     */ 
        CanSendCan0Msg(0x0EA,Send_0EA.msg.data, 24,0);/* MDPS    */ 
        CanSendCan0Msg(0x060,Send_060.msg.data, 32,0);/* ESC     */ 
        CanSendCan0Msg(0x3A0,Send_3A0.msg.data, 16,0);/* TPMS     */
        CanSendCan0Msg(0x12A,Send_12A.msg.data, 16,0);/* LKA     */ 
        CanSendCan0Msg(0x220,Send_220.msg.data, 16,0);/* ECS     */
        CanSendCan0Msg(0x06F,Send_06F.msg.data, 32,0);/* ABS     */ 
        CanSendCan0Msg(0x20A,Send_20A.msg.data, 16,0);/* Air Bag */ 
        CanSendCan0Msg(0x1A5,Send_1A5.msg.data, 32,0);/* 4WD      */ 
        CanSendCan0Msg(0x040,TCU_01_10ms, 32,0);      /* AT      */ 
        
        CanSendCan1Msg(0x3BF,Send_3B3.msg.data, 8,0); /*ECALL    */ 
#elif (PRO_NQ5C)
        TCU_01_10ms.TCU_Typ=0x2;
        CanSendCan0Msg(0x1A0,Send_1A0.msg.data, 32,0);/* SCC     */   
        CanSendCan0Msg(0x1F0,Send_1F0.msg.data, 16,0);/* EPB     */ 
        CanSendCan0Msg(0x0EA,Send_0EA.msg.data, 24,0);/* MDPS    */ 
        CanSendCan0Msg(0x060,Send_060.msg.data, 32,0);/* ESC     */ 
        CanSendCan0Msg(0x3A0,Send_3A0.msg.data, 16,0);/* TPMS    */
        CanSendCan0Msg(0x12A,Send_12A.msg.data, 16,0);/* LKA     */ 
        //CanSendCan0Msg(0x220,Send_220.msg.data, 16,0);/* ECS     */
        CanSendCan0Msg(0x06F,Send_06F.msg.data, 32,0);/* ABS     */ 
        CanSendCan0Msg(0x20A,Send_20A.msg.data, 16,0);/* Air Bag */ 
        CanSendCan0Msg(0x1A5,Send_1A5.msg.data, 32,0);/* 4WD     */ 
        CanSendCan0Msg(0x040,TCU_01_10ms, 32,0);      /* AT      */ 
        CRC001.Byte0Data = 0xFE;
        CanSendCan0Msg(0x001,CRC001.mdata, 1,0);/*EVP     */
#elif (PRO_NX4C)
        TCU_01_10ms.TCU_Typ=0x2;
        CanSendCan0Msg(0x1A0,Send_1A0.msg.data, 32,0);/* SCC     */   
        CanSendCan0Msg(0x1F0,Send_1F0.msg.data, 16,0);/* EPB     */ 
        CanSendCan0Msg(0x0EA,Send_0EA.msg.data, 24,0);/* MDPS    */ 
        CanSendCan0Msg(0x060,Send_060.msg.data, 32,0);/* ESC     */ 
        CanSendCan0Msg(0x3A0,Send_3A0.msg.data, 16,0);/* TPMS    */
        CanSendCan0Msg(0x12A,Send_12A.msg.data, 16,0);/* LKA     */ 
        //CanSendCan0Msg(0x220,Send_220.msg.data, 16,0);/* ECS     */
        CanSendCan0Msg(0x06F,Send_06F.msg.data, 32,0);/* ABS     */ 
        CanSendCan0Msg(0x20A,Send_20A.msg.data, 16,0);/* Air Bag */ 
        CanSendCan0Msg(0x1A5,Send_1A5.msg.data, 32,0);/* 4WD     */ 
        CanSendCan0Msg(0x040,TCU_01_10ms, 32,0);      /* AT      */ 
        CRC001.Byte0Data = 0xFE;
        CanSendCan0Msg(0x001,CRC001.mdata, 1,0);/*EVP     */
#elif (PRO_PDEPE2)
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); 
        
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif (PRO_BN7R)
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); 
        
        //CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif (PRO_SU2IFL)
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif (PRO_SU2BFL)
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif (PRO_SU2ID_FL)
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif ((PRO_SP2C_PE))
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif ((PRO_JAPE2))
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL  */ 
#elif ((PRO_BC3))
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL  */ 
#elif (PRO_CN7C)
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif ((PRO_NU2))
         TCU_01_10ms.TCU_Typ=0x2;
        CanSendCan0Msg(0x1A0,Send_1A0.msg.data, 32,0);/* SCC     */   
        CanSendCan0Msg(0x1F0,Send_1F0.msg.data, 16,0);/* EPB     */ 
        CanSendCan0Msg(0x0EA,Send_0EA.msg.data, 24,0);/* MDPS    */ 
        CanSendCan0Msg(0x060,Send_060.msg.data, 32,0);/* ESC     */ 
        CanSendCan0Msg(0x3A0,Send_3A0.msg.data, 16,0);/* TPMS    */
        CanSendCan0Msg(0x12A,Send_12A.msg.data, 16,0);/* LKA     */ 
        //CanSendCan0Msg(0x220,Send_220.msg.data, 16,0);/* ECS     */
        CanSendCan0Msg(0x06F,Send_06F.msg.data, 32,0);/* ABS     */ 
        CanSendCan0Msg(0x20A,Send_20A.msg.data, 16,0);/* Air Bag */ 
        CanSendCan0Msg(0x1A5,Send_1A5.msg.data, 32,0);/* 4WD     */ 
        CanSendCan0Msg(0x040,TCU_01_10ms, 32,0);      /* AT      */ 
        CRC001.Byte0Data = 0xFE;
        CanSendCan0Msg(0x001,CRC001.mdata, 1,0);/*EVP     */
#elif (PRO_YB_PE)
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif (PRO_AC3_PE)
       CGW_PC6.msg.bits.TCU_TYPE = 0x1; 
       CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     
       CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
       CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
       CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */ 
       CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);    /* AT */ 
       CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
       CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */ 
#elif (PRO_AI3)
       CGW_PC6.msg.bits.TCU_TYPE = 0x1;   
       CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
       CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
       CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */ 
       CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);    /* AT */ 
       CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
       CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ 
#elif (PRO_BL7M)
       CGW_PC6.msg.bits.TCU_TYPE = 0x1;
       CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */  
       CanSendCan0Msg(0x381,Send_381.msg.data, 8,0); /* MDPS11  */ 
      
       CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
       CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
       CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     
      
       CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
       CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
      
       CanSendCan0Msg(0x428,Send_428.msg.data, 8,0);/* 4wd11 */
       CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); /* AT */ 
       CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */ 
#elif (PRO_BL7R)
       CGW_PC6.msg.bits.TCU_TYPE = 0x1;
       CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */  
       CanSendCan0Msg(0x381,Send_381.msg.data, 8,0); /* MDPS11  */ 
      
       CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */
       CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
       CanSendCan0Msg(0x340,Send_340.msg.data, 8,0); /* LKA     */     
      
       CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */  
       CanSendCan0Msg(0x500,ACU14.msg.data, 8,0);   /* Air Bag */ 
      
       CanSendCan0Msg(0x428,Send_428.msg.data, 8,0);/* 4wd11 */
       CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0); /* AT */ 
       CanSendCan1Msg(0x141,Send_340.msg.data, 8,0);/* ECALL    */ 
#elif (PRO_CN7)  
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif (PRO_BN7I)
       CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */ 
#elif (PRO_SU2ID)  
        CanSendCan0Msg(0x420,Send_420.msg.data, 8,0);/* SCC     */  
        CanSendCan0Msg(0x490,Send_490.msg.data, 8,0);/* EPB11   */     
        CanSendCan0Msg(0x381,Send_381.msg.data, 8,0);/* MDPS11  */  
        CanSendCan0Msg(0x507,Send_507.msg.data, 8,0);/* ESC     */    
        CanSendCan0Msg(0x593,Send_593.msg.data, 8,0);/* TPMS    */ 
        CanSendCan0Msg(0x340,Send_340.msg.data, 8,0);/* LKA     */     
        CanSendCan0Msg(0x500,Send_500.msg.data, 8,0);/* Air Bag */ 
        CanSendCan0Msg(0x586,Send_586.msg.data, 8,0);/* EVP */
        CanSendCan0Msg(0x38A,ABS11.msg.data, 8,0);   /* ABS */ //23
        CGW_PC6.msg.bits.TCU_TYPE = 0x1;
        CanSendCan0Msg(0x368,CGW_PC6.msg.data, 8,0);         
        CanSendCan1Msg(0x141,Send_340.msg.data, 8,0); /* ECALL    */
#endif
    }
}

#if (PRO_CONFIG_EOL_APPLY) 
void SetEOL0(uint8_t statu)
{
    uint32_t EOL_data = 0;
    uint32_t data = 0;
    uint8_t EOL_BIT_H = 0;
    uint8_t EOL_BIT_L = 0;
    uint8_t EOL_BIT = 0;
    uint8_t i=0;
    Send_7C6_Data.msg.bits.Byte0Data = 0x07;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2E;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x00;
    Send_7C6_Data.msg.bits.Byte3Data = 0x60;
    EOL_data = VC_List[statu][1];
    
    for(i = 0;i<4;i++)
    {
        data = ((EOL_data & (0xFF << (i * 8))) >> (i * 8));
        Send_7C6_Data.msg.data[7-i] = data;
    }
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);
#if (CAN_2ND)    
    Delay(20);//20ms  
#endif
#if (CAN_3RD)    
    Delay(1000);//1000ms  
#endif
}
#endif
void SetHH12()
{
    Send_7C6_Data.msg.bits.Byte0Data = 0x10;
    Send_7C6_Data.msg.bits.Byte1Data = 0x14;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x2E;
    Send_7C6_Data.msg.bits.Byte3Data = 0xF1;
    Send_7C6_Data.msg.bits.Byte4Data = 0x90;
    Send_7C6_Data.msg.bits.Byte5Data = VinNumSendBuf[0];
    Send_7C6_Data.msg.bits.Byte6Data = VinNumSendBuf[1];
    Send_7C6_Data.msg.bits.Byte7Data = VinNumSendBuf[2];
    CanFD_Send_StandMsg(CANFD0_Type, 0x747, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);

}
void SetEOL(uint8_t statu)
{
    uint32_t EOL_data = 0;
    uint32_t data = 0;
    uint8_t EOL_BIT_H = 0;
    uint8_t EOL_BIT_L = 0;
    uint8_t EOL_BIT = 0;
    uint8_t i=0;
    Send_7C6_Data.msg.bits.Byte0Data = 0x07;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2E;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x00;
    Send_7C6_Data.msg.bits.Byte3Data = 0x60;
    

    EolData.SpeedType = 0;// 00 KPH  01 KMPH  02 MKPH
#if ((PRO_SQFL) || (PRO_NU2) || (PRO_NUPE))
    EolData.Data[0] = 0xDE;
    EolData.Data[1] = 0xEC;
    EolData.Data[2] = 0x07;
    EolData.Data[3] = 0xFF;
    EolData.Area = 7;        //�й�����
#elif (PRO_NQ5C)
    if (JudgePartNum() == PartNum_NQ5C){
        EolData.Data[0] = 0xDE;
        EolData.Data[1] = 0xEC;
        EolData.Data[2] = 0x07;
        EolData.Data[3] = 0xFF;
        EolData.Area = 7;        //�й�����
    } else if (JudgePartNum() == PartNum_NQ5C_Outlet){
        EolData.Data[0] = 0xDE;
        EolData.Data[1] = 0xEC;
        EolData.Data[2] = 0x02;
        EolData.Data[3] = 0xFF;
        EolData.Area = 2;        //�й�����
    }
#elif ((PRO_CN7C) || (PRO_QYC))
    EolData.Data[0] = 0xDF;
    EolData.Data[1] = 0x45;
    EolData.Data[2] = 0x02;
    EolData.Data[3] = 0xFF;
    EolData.Area = 7;     
#elif (PRO_US4)
    if (g_VehicleType == CAR_TYPE_HEV){
        EolData.Data[0] = 0xff;
        EolData.Data[1] = 0xff;
        EolData.Data[2] = 0xff;
        EolData.Data[3] = 0xdf;  
    }else {
        EolData.Data[0] = 0xff;
        EolData.Data[1] = 0xff;
        EolData.Data[2] = 0xff;
        EolData.Data[3] = 0xff;
    }
#elif (PRO_NQ5)
    EolData.Data[0] = 0xff;
    EolData.Data[1] = 0xff;
    EolData.Data[2] = 0xCf;
    EolData.Data[3] = 0xf7;
#elif (PRO_JAPE2)
    if(g_EolCfgFuelType == 0){
        EolData.Data[0] = 0xf7;
        EolData.Data[1] = 0x7B;
        EolData.Data[2] = 0xff;
        EolData.Data[3] = 0x7f;
    }else{
        EolData.Data[0] = 0xff;
        EolData.Data[1] = 0xff;
        EolData.Data[2] = 0xff;
        EolData.Data[3] = 0xff;
    }
#else 
    EolData.Data[0] = 0xff;
    EolData.Data[1] = 0xff;
    EolData.Data[2] = 0xff;
    EolData.Data[3] = 0xff;
  
    EolData.Area = 0;    //DOM��������
#endif
    if(g_EolCfgFuelType == 0) {
#if ((PRO_JAPE2) || (PRO_KY) || (PRO_QX23) || (PRO_SK3_PE) || (PRO_GL3) || (PRO_SG2) || (PRO_AX) || (PRO_BL7M) || (PRO_CN7) || (PRO_ONPE) || (PRO_BN7I) || (PRO_BR2) || (PRO_LX2) || (PRO_TAM) || (PRO_QXI) || (PRO_SP2) || (PRO_SU2BFL) || (PRO_US4) || (PRO_SU2ID_FL))
        EolData.FuelType = 0;//GSL����
        EolData.Area = 0;//DOM ��������
        LanguageFlag = 0;
#elif (PRO_NQ5)
       if (g_VehicleType == CAR_TYPE_LPI){
            EolData.FuelType = 2;//GSL����
            EolData.Area = 0;//DOM ��������
            LanguageFlag = 0;
        } else {
            EolData.FuelType = 0;//GSL����
            EolData.Area = 0;//DOM ��������
            LanguageFlag = 0;
        }
#elif (PRO_KS)
    if (JudgePartNum() == PartNum_KS){
        EolData.FuelType = 0;//GSL����
        EolData.Area = 7;//�й�����
        LanguageFlag = 4;
    } else if (JudgePartNum() == PartNum_KS_23MY){
        EolData.FuelType = 0;//GSL����
        EolData.Area = 0;//DOM ��������
        LanguageFlag = 0;
    }
#else
        EolData.FuelType = 0;//GSL����
        EolData.Area = 7;//�й�����
         LanguageFlag = 4;
#endif
    } 
    else if(g_EolCfgFuelType == 1) {
#if ((PRO_SU2IFL) || (PRO_US4) || (PRO_JAPE2) || (PRO_SP2C_PE) || (PRO_KY) || (PRO_QX23) || (PRO_SK3_PE) || (PRO_GL3) || (PRO_SG2) || (PRO_BL7M) || (PRO_CN7) || (PRO_BN7I) || (PRO_BR2) || (PRO_LX2) || (PRO_QXI) || (PRO_QYC) || (PRO_SP2) || (PRO_SU2BFL) || (PRO_SU2ID) || (PRO_SU2ID_FL))        
        EolData.FuelType = 1;//DSL����
        EolData.Area = 2;//MID �ж�����
        LanguageFlag = 2;
#elif (PRO_NQ5)
       if (g_VehicleType == CAR_TYPE_LPI){
            EolData.FuelType = 2;//GSL����
            EolData.Area = 2;//DOM ��������
            LanguageFlag = 2;
        } else if ((g_VehicleType == CAR_TYPE_HEV) || (g_VehicleType == CAR_TYPE_PHEV)){
            EolData.FuelType = 0;//GSL����
            EolData.Area = 2;//DOM ��������
            LanguageFlag = 2;
        }else {
            EolData.FuelType = 1;
            EolData.Area = 2;//DOM ��������
            LanguageFlag = 2;
        }
#elif (PRO_NQ5C)
    if (JudgePartNum() == PartNum_NQ5C){
        EolData.FuelType = 1;//DSL����
        HU_MON_PE_01.HU_Type = 0x69;
        HU_CLU_PE_05.HU_LanguageInfo = 0x4;
    } else if (JudgePartNum() == PartNum_NQ5C_Outlet){
        EolData.FuelType = 1;//DSL����
        EolData.Area = 2;
        HU_MON_PE_01.HU_Type = 0x69;
        HU_CLU_PE_05.HU_LanguageInfo = 0x2;
    }

#elif (PRO_ONPE)
        EolData.FuelType = 1;//DSL����
        EolData.Area = 2;//MID �ж�����
        HU_MON_PE_01.HU_Type = 0x40;
        HU_CLU_PE_05.HU_LanguageInfo = 0x2;
#elif (PRO_KS)
    if (JudgePartNum() == PartNum_KS){
        EolData.FuelType = 1;//DSL����
        EolData.Area = 7;//�й�����
        LanguageFlag = 4;
    } else if (JudgePartNum() == PartNum_KS_23MY){
        EolData.FuelType = 1;//DSL����
        EolData.Area = 2;//MID �ж�����
        LanguageFlag = 2;
    }
#elif (PRO_CN7C)
        EolData.FuelType = 1;//DSL����
        EolData.Area = 7;//�й�����
        LanguageFlag = 4;
#else
        EolData.FuelType = 1;//DSL����
        EolData.Area = 0;//DOM ��������
#endif        
    }
#if ((PRO_US4) || (PRO_GL3))    
    else if(g_EolCfgFuelType == 2) {
        EolData.FuelType = 2; //LPIȼ��
        EolData.Area = 0;     //DOM ��������
    }
#elif (PRO_CN7)
    if (g_VehicleType == CAR_TYPE_ICV){
        if(g_EolCfgFuelType == 2) {
        EolData.FuelType = 2; //LPIȼ��
        EolData.Area = 0;     //DOM ��������
        }
    }
#endif    
    Send_7C6_Data.msg.data[4] = EolData.Data[0];
    Send_7C6_Data.msg.data[5] = EolData.Data[1];
    Send_7C6_Data.msg.data[6] = EolData.Data[2];
    Send_7C6_Data.msg.data[7] = EolData.Data[3];

    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);
#if (CAN_2ND)    
    Delay(20);//20ms  
#endif
#if (CAN_3RD)    
    Delay(1000);//1000ms  
#endif
 
}

void SetEOL2(uint8_t statu)
{
    uint32_t EOL_data = 0;
    uint32_t data = 0;
    uint8_t EOL_BIT_H = 0;
    uint8_t EOL_BIT_L = 0;
    uint8_t EOL_BIT = 0;
    uint8_t i=0;
    Send_7C6_Data.msg.bits.Byte0Data = 0x05;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2E;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x00;
    Send_7C6_Data.msg.bits.Byte3Data = 0x60;
    
    EolData.Data[0] = 0xff;
    EolData.Data[1] = 0xff;
    EolData.Data[2] = 0xff;
    EolData.Data[3] = 0xff;
  
   
    EolData.SpeedType = 0;
    if(g_EolCfgFuelType == 0) {
        EolData.FuelType = 0;//GSL����
        EolData.Area = 7;//�й�����
    } 
    else if(g_EolCfgFuelType == 1) {
        EolData.FuelType = 1;//DSL����
        EolData.Area = 0;//DOM ��������
    }    
    Send_7C6_Data.msg.data[4] = EolData.Data[0];
    Send_7C6_Data.msg.data[5] = EolData.Data[1];
    Send_7C6_Data.msg.data[6] = EolData.Data[2];
    Send_7C6_Data.msg.data[7] = EolData.Data[3];

    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 6);
#if (CAN_2ND)    
    Delay(20);//20ms  
#endif
#if (CAN_3RD)    
    Delay(1000);//1000ms  
#endif
}


void SetEOL3(uint8_t statu)
{
    uint32_t EOL_data = 0;
    uint32_t data = 0;
    uint8_t EOL_BIT_H = 0;
    uint8_t EOL_BIT_L = 0;
    uint8_t EOL_BIT = 0;
    uint8_t i=0;
    Send_7C6_Data.msg.bits.Byte0Data = 0x05;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2E;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x00;
    Send_7C6_Data.msg.bits.Byte3Data = 0x60;
    
    EolData.Data[0] = 0xff;
    EolData.Data[1] = 0xff;
    EolData.Data[2] = 0xff;
    EolData.Data[3] = 0xff;
    
    Send_7C6_Data.msg.data[4] = EolData.Data[0];
    Send_7C6_Data.msg.data[5] = EolData.Data[1];
    Send_7C6_Data.msg.data[6] = EolData.Data[2];
    Send_7C6_Data.msg.data[7] = EolData.Data[3];
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);
#if (CAN_2ND)    
    Delay(20);//20ms  
#endif
#if (CAN_3RD)    
    Delay(1000);//1000ms  
#endif
}

void SetEOL4(uint8_t statu)   //EOL����ȫ0
{
    uint32_t EOL_data = 0;
    uint32_t data = 0;
    uint8_t EOL_BIT_H = 0;
    uint8_t EOL_BIT_L = 0;
    uint8_t EOL_BIT = 0;
    uint8_t i=0;
    Send_7C6_Data.msg.bits.Byte0Data = 0x05;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2E;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x00;
    Send_7C6_Data.msg.bits.Byte3Data = 0x60;
    
    EolData.Data[0] = 0x00;
    EolData.Data[1] = 0x00;
    EolData.Data[2] = 0x00;
    EolData.Data[3] = 0x00;
    
    Send_7C6_Data.msg.data[4] = EolData.Data[0];
    Send_7C6_Data.msg.data[5] = EolData.Data[1];
    Send_7C6_Data.msg.data[6] = EolData.Data[2];
    Send_7C6_Data.msg.data[7] = EolData.Data[3];
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);
#if (CAN_2ND)    
    Delay(20);//20ms  
#endif
#if (CAN_3RD)    
    Delay(1000);//1000ms  
#endif
}

void SetEOL5(uint8_t statu)   //EOL����ȫ0
{
    uint32_t EOL_data = 0;
    uint32_t data = 0;
    uint8_t EOL_BIT_H = 0;
    uint8_t EOL_BIT_L = 0;
    uint8_t EOL_BIT = 0;
    uint8_t i=0;
    Send_7C6_Data.msg.bits.Byte0Data = 0x05;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2E;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x00;
    Send_7C6_Data.msg.bits.Byte3Data = 0x60;
    
    EolData.Data[0] = 0xDF;
    EolData.Data[1] = 0x41;

    
    Send_7C6_Data.msg.data[4] = EolData.Data[0];
    Send_7C6_Data.msg.data[5] = EolData.Data[1];

    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_21, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);
#if (CAN_2ND)    
    Delay(20);//20ms  
#endif
#if (CAN_3RD)    
    Delay(1000);//1000ms  
#endif
}
void EOL_UDS_10(void)
{
    Send_7C6_Data.msg.bits.Byte0Data = 0x02;
    Send_7C6_Data.msg.bits.Byte1Data = 0x10;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x03;
    CanFD_Send_StandMsg(CANFD0_Type, 0x747, BUF_5, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);
}

void EOL_UDS_27(uint8_t uiByte2Data)
{
    Send_7C6_Data.msg.bits.Byte0Data = 0x02;  
    Send_7C6_Data.msg.bits.Byte1Data = 0x27;                
    Send_7C6_Data.msg.bits.Byte2Data = uiByte2Data;  

    CanFD_Send_StandMsg(CANFD0_Type, 0x747, BUF_7, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);
}

static uint16_t calcKey(uint16_t seed)	
{	
    #define TOPBIT 0x8000	
    #define POLYNOM_1 0x8408	
    #define POLYNOM_2 0x8025	
    #define BITMASK 0x0080	
    #define INITIAL_REMINDER 0xFFFE	
    #define MSG_LEN 2 /* seed length in bytes */	
    uint8_t bSeed[2];	
    uint16_t remainder;	
    uint8_t n;	
    uint8_t i;	
    bSeed[0] = (uint8_t)(seed >> 8); /* MSB */	
    bSeed[1] = (uint8_t)seed; /* LSB */	
    remainder = INITIAL_REMINDER;	
    for (n = 0; n < MSG_LEN; n++)	
    {	
        /* Bring the next byte into the remainder. */	
        remainder ^= ((bSeed[n]) << 8);	
        /* Perform modulo-2 division, a bit at a time. */	
        for (i = 0; i < 8; i++)	
        {	
            /* Try to divide the current data bit. */	
            if (remainder & TOPBIT)	
                {	
                    if(remainder & BITMASK)	
                    {	
                        remainder = (remainder << 1) ^ POLYNOM_1;	
                    }	
                    else	
                    {	
                        remainder = (remainder << 1) ^ POLYNOM_2;	
                    }	
                }	
                else	
                {	
                    remainder = (remainder << 1);	
                }	
        }	
    }	
    /* The final remainder is the key */	
    return remainder;	
}	
uint16_t test123;
void EOL_UDS_Key27Step_1_1(uint8_t uiByte2Data)
{
    //�����㷨     
    test123 = calcKey((Key27Buffer[3] << 8) + Key27Buffer[4]);
    memcpy(&ReceiveData[0], &Key27Buffer[4], 4);
    memcpy(&ReceiveData[4], &Key27Buffer[9], 4);
    UdsKeyData[0] = test123 >> 8;
    UdsKeyData[1] = test123 & 0xFF;
    Send_7C6_Data.msg.bits.Byte0Data = 0x04;
    Send_7C6_Data.msg.bits.Byte1Data = 0x27;  
    Send_7C6_Data.msg.bits.Byte2Data = uiByte2Data;           
    Send_7C6_Data.msg.bits.Byte3Data = UdsKeyData[0]; 
    Send_7C6_Data.msg.bits.Byte4Data = UdsKeyData[1];  
    CanFD_Send_StandMsg(CANFD0_Type, 0x747, BUF_8, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8); 
}

void EOL_UDS_Key27Step_1_2(uint8_t uiByte2Data)
{
    //�����㷨 
    uint32_t recvseed = 0;
    uint32_t Key = 0;
    recvseed = Receive_7CE_Data.data[3];
    recvseed <<= 8;
    recvseed |= Receive_7CE_Data.data[4];
    recvseed <<= 8;
    recvseed |= Receive_7CE_Data.data[5];
    recvseed <<= 8;
    recvseed |= Receive_7CE_Data.data[6];
    //�����㷨 
    recvseed = ~recvseed;
    Key = recvseed;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Key++;
    Delay(200);//200ms
    Send_7C6_Data.msg.bits.Byte0Data = 0x06;
    Send_7C6_Data.msg.bits.Byte1Data = 0x27;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x02;
    Send_7C6_Data.msg.bits.Byte3Data = (Key >> 24) & 0xff;
    Send_7C6_Data.msg.bits.Byte4Data = (Key >> 16) & 0xff;  
    Send_7C6_Data.msg.bits.Byte5Data = (Key >> 8) & 0xff;  
    Send_7C6_Data.msg.bits.Byte6Data = (Key >> 0) & 0xff; 
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_1, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 7);   
}

void EOL_UDS_Key27Step_2_1(void)
{
    Send_7C6_Data.msg.bits.Byte0Data = 0x21;
 
    Send_7C6_Data.msg.bits.Byte1Data = VinNumSendBuf[3];
    Send_7C6_Data.msg.bits.Byte2Data = VinNumSendBuf[4];
    Send_7C6_Data.msg.bits.Byte3Data = VinNumSendBuf[5];  
    Send_7C6_Data.msg.bits.Byte4Data = VinNumSendBuf[6];
    Send_7C6_Data.msg.bits.Byte5Data = VinNumSendBuf[7]; 
    Send_7C6_Data.msg.bits.Byte6Data = VinNumSendBuf[8];
    Send_7C6_Data.msg.bits.Byte7Data = VinNumSendBuf[9]; 
    CanFD_Send_StandMsg(CANFD0_Type, 0x747, BUF_8, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);  
}

void EOL_UDS_Key27Step_2_2(void)
{
    Send_7C6_Data.msg.bits.Byte0Data = 0x22;
    Send_7C6_Data.msg.bits.Byte1Data = VinNumSendBuf[10];  
    Send_7C6_Data.msg.bits.Byte2Data = VinNumSendBuf[11];
    Send_7C6_Data.msg.bits.Byte3Data = VinNumSendBuf[12];
    Send_7C6_Data.msg.bits.Byte4Data = VinNumSendBuf[13];  
    Send_7C6_Data.msg.bits.Byte5Data = VinNumSendBuf[14];
    Send_7C6_Data.msg.bits.Byte6Data = VinNumSendBuf[15]; 
    Send_7C6_Data.msg.bits.Byte7Data = VinNumSendBuf[16];
    CanFD_Send_StandMsg(CANFD0_Type, 0x747, BUF_8, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);  
}

void EOL_UDS_Key22Step_2_1(void)
{
    Send_7C6_Data.msg.bits.Byte0Data = 0x03;
    Send_7C6_Data.msg.bits.Byte1Data = 0x22;  
    Send_7C6_Data.msg.bits.Byte2Data = 0xF1; 
    Send_7C6_Data.msg.bits.Byte3Data = 0x90;
    Send_7C6_Data.msg.bits.Byte4Data = 0x00;
    Send_7C6_Data.msg.bits.Byte5Data = 0x00;
    Send_7C6_Data.msg.bits.Byte6Data = 0x00;
    Send_7C6_Data.msg.bits.Byte7Data = 0x00;
    CanFD_Send_StandMsg(CANFD0_Type, 0x747, BUF_8, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);  
}

void EOL_UDS_Key22Step_2_2(void)
{
    Send_7C6_Data.msg.bits.Byte0Data = 0x30;
    Send_7C6_Data.msg.bits.Byte1Data = 0x00;  
    Send_7C6_Data.msg.bits.Byte2Data = 0x00; 
    Send_7C6_Data.msg.bits.Byte3Data = 0x90;
    Send_7C6_Data.msg.bits.Byte4Data = 0x00;
    Send_7C6_Data.msg.bits.Byte5Data = 0x00;
    Send_7C6_Data.msg.bits.Byte6Data = 0x00;
    Send_7C6_Data.msg.bits.Byte7Data = 0x00;
    CanFD_Send_StandMsg(CANFD0_Type, 0x747, BUF_8, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 8);  
}



void EOL_Step0(void)
{
    EOL.Statu = 1;  
    Can_Clear((uint8_t*)&Receive_7CE_Data.data,sizeof(Receive_7CE_Data));
    memset(ReceiveData, 0, sizeof(ReceiveData));
    memset(UdsKeyData, 0, sizeof(UdsKeyData));
    memset(Key27Buffer, 0, sizeof(Key27Buffer));
}

void EOL_Step1(void)
{
    if(parking_big == 1) {
        SetEOL(0);  
        LanguageFlag = 1;
        TelltaleFlag = 1;
    } else {
        SendCan0Message_EOL();
        SetEOL(1); 
        LanguageFlag = 2;
        TelltaleFlag = 2;
    }
    EOL.Statu = 2 ;
}
uint8_t test15 = 0;
void APP_EOL(void) 
{
    Default_flag=1;
    uint32_t recvseed = 0;
    uint32_t Key = 0;
    uint8_t tmp = 0;
    g_uiBackDoorFlag = 1;
    memcpy(VinNumSendBuf , Test_array , sizeof(VinNumSendBuf) );//ɨ��ǹ��浽����������   
    uint8_t uiEolStepCnt = 4;
    if((EOL.Statu != uiEolStepCnt) && (EOL.Statu != 5))
    {
        CANSendEnable = OFF; //�ر��������ķ���
        //EOL_Flag = 1;
        
        if(EOL.Statu == 0) 
        {
            switch (Key27Step) {
                case 0:
                    RxFinish = UNFINISH;
                    EOL_UDS_10();// 02 10 03
                    Delay(50);//50ms
#if ((PRO_QXI) || (PRO_BR2) || (PRO_NUPE) || (PRO_KU) || (PRO_CN7C) || (PRO_SQFL) || (PRO_DL3C))                
                    EOL_UDS_27(0x03);// 02 27 01 
#endif                    
                    Key27Step = 1;
                    break;
                case 1:  
#if ((PRO_QXI) || (PRO_BR2) || (PRO_CN7C))        
                    if (RxFinish == FINISH) {
                        //�����㷨 
                        EOL_UDS_Key27Step_1_1(0x04);  
                        Key27Step = 2; 
                    }
#endif                           
                    break;
                case 2:
                    Delay(5);
                    if (test15 == 0) {
                        if (Receive_7CE_Data.data[1] == 0x67) {
                            SetHH12();
                            test15 = 1;
                        }
                    }
                    if (Receive_7CE_Data.data[0] == 0x30) {
                        Delay(5);//5ms 
                        EOL_UDS_Key27Step_2_1();
                        Delay(5);
                        EOL_UDS_Key27Step_2_2();
                        Key27Step = 3;

                    }
                    break;
                case 3:
                    if((Receive_7CE_Data.data[1] == 0x6E) && (Receive_7CE_Data.data[2] == 0xF1) && (Receive_7CE_Data.data[3] == 0x90) && (RxFinish == FINISH))//�жϷ���
                    { 
                        EOL_UDS_Key22Step_2_1();
                        VinNumReadBuf[0] = Receive_7CE_Data.data[5];
                        VinNumReadBuf[1] = Receive_7CE_Data.data[6];
                        VinNumReadBuf[2] = Receive_7CE_Data.data[7];
                        RxFinish = UNFINISH;
                        Key27Step = 4;
                    }
                    break;
                case 4:
                    if (RxFinish == FINISH){
                        for(uint8_t i = 0;i < 17;i++)
                        {
                            if(MultiplePack.Data[i] != Test_array[i])
                            {
                                EOL.Statu = 5;//����ʧ��
                                return;
                            }
                        }
                        EOL.Statu = 4 ;
                        // Can_Clear((uint8_t*)&Receive_7CE_Data,sizeof(Receive_7CE_Data));
                    }
                    break;    
            }
        }
        
    }
    else{
        CANSendEnable = ON;  //�����������ķ���
        EOL_Flag = 0;
    }
}

