#ifndef __ADC_RLT_DRIVER_H__
#define __ADC_RLT_DRIVER_H__

#include "adc12b.h"

typedef enum en_adc12b_instance_index
{
    Adc12bInstanceIndexAdc0,
    Adc12bInstanceIndexMax
} en_adc12b_instance_index_t;


/** ADC instance data type */
typedef struct stc_adc12b_instance_data
{
    volatile stc_adc12b0_t* pstcInstance;       /*!< pointer to registers of an instance */
    stc_adc12b_intern_data_t stcInternData;     /*!< module internal data of instance */
    uint8_t u8UnitIndex;                        /*!< unit index */
} stc_adc12b_instance_data_t;

extern uint16_t u16ConversionData;
extern volatile uint16_t AdcValList[64];

extern void InitADC(void);
extern void InitADCch(uint8_t ch);

extern stc_adc12b_intern_data_t* Adc12bGetInternDataPtr(volatile stc_adc12b0_t* pstcAdc);
extern FN_IRQ_NOT_NESTED void Adc_Isr_Adc12b_EndOfConversion(void);
extern FN_IRQ_NOT_NESTED void Adc_Isr_Adc12b_GroupInt(void);
extern FN_IRQ_NOT_NESTED void Adc_Isr_Adc12b_PulseDetection(void);
extern FN_IRQ_NOT_NESTED void Adc_Isr_Adc12b_RangeCompare(void);

#endif /* __ADC_RLT_DRIVER_H__ */