/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L01                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_LCDB_H
#define __S6J3360_LCDB_H

#include "s6j3360io_basetypes.h"

/* LCDB base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define LCDB	stcLCDB
#else /* __IO_DEFINE */
#define LCDB	(*((volatile stc_lcdb_t*)0xB8040000))
#endif /* __IO_DEFINE */

#define LCDB_LockUnlockLcd	(LCDB.unLockUnlockLcd.u32Register)
#define LCDB_LockUnlockLcd_LockUnlockLcd	(LCDB.unLockUnlockLcd.stcField.u32LockUnlockLcd)
typedef struct stc_lcdb_lockunlocklcd_field{
    uint_io32_t		u32LockUnlockLcd:32;
}stc_lcdb_lockunlocklcd_field_t;

typedef union un_lcdb_lockunlocklcd{
    uint_io32_t		u32Register;
    stc_lcdb_lockunlocklcd_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockunlocklcd_t;

#define LCDB_LockStatusLcd	(LCDB.unLockStatusLcd.u32Register)
#define LCDB_LockStatusLcd_LockStatusLcd	(LCDB.unLockStatusLcd.stcField.u1LockStatusLcd)
#define LCDB_LockStatusLcd_PrivilegeStatusLcd	(LCDB.unLockStatusLcd.stcField.u1PrivilegeStatusLcd)
#define LCDB_LockStatusLcd_FreezeStatusLcd	(LCDB.unLockStatusLcd.stcField.u1FreezeStatusLcd)
typedef struct stc_lcdb_lockstatuslcd_field{
    uint_io32_t		u1LockStatusLcd:1;
    uint_io32_t		:3;
    uint_io32_t		u1PrivilegeStatusLcd:1;
    uint_io32_t		:3;
    uint_io32_t		u1FreezeStatusLcd:1;
    uint_io32_t		:23;
}stc_lcdb_lockstatuslcd_field_t;

typedef union un_lcdb_lockstatuslcd{
    uint_io32_t		u32Register;
    stc_lcdb_lockstatuslcd_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockstatuslcd_t;

#define LCDB_IPIdentifier	(LCDB.unIPIdentifier.u32Register)
#define LCDB_IPIdentifier_DesignDeliveryID	(LCDB.unIPIdentifier.stcField.u4DesignDeliveryID)
#define LCDB_IPIdentifier_DesignMaturityLevel	(LCDB.unIPIdentifier.stcField.u4DesignMaturityLevel)
#define LCDB_IPIdentifier_IPEvolution	(LCDB.unIPIdentifier.stcField.u4IPEvolution)
#define LCDB_IPIdentifier_IPFeatureSet	(LCDB.unIPIdentifier.stcField.u4IPFeatureSet)
typedef struct stc_lcdb_ipidentifier_field{
    uint_io32_t		:4;
    uint_io32_t		u4DesignDeliveryID:4;
    uint_io32_t		u4DesignMaturityLevel:4;
    uint_io32_t		u4IPEvolution:4;
    uint_io32_t		u4IPFeatureSet:4;
    uint_io32_t		:12;
}stc_lcdb_ipidentifier_field_t;

typedef union un_lcdb_ipidentifier{
    uint_io32_t		u32Register;
    stc_lcdb_ipidentifier_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_ipidentifier_t;

#define LCDB_InterfaceConfig	(LCDB.unInterfaceConfig.u32Register)
#define LCDB_InterfaceConfig_InterfaceType	(LCDB.unInterfaceConfig.stcField.u2InterfaceType)
#define LCDB_InterfaceConfig_InterfaceWidth	(LCDB.unInterfaceConfig.stcField.u2InterfaceWidth)
#define LCDB_InterfaceConfig_CsPolarity	(LCDB.unInterfaceConfig.stcField.u1CsPolarity)
#define LCDB_InterfaceConfig_WrPolarity	(LCDB.unInterfaceConfig.stcField.u1WrPolarity)
#define LCDB_InterfaceConfig_RdPolarity	(LCDB.unInterfaceConfig.stcField.u1RdPolarity)
#define LCDB_InterfaceConfig_RsPolarity	(LCDB.unInterfaceConfig.stcField.u1RsPolarity)
#define LCDB_InterfaceConfig_DataPolarity	(LCDB.unInterfaceConfig.stcField.u1DataPolarity)
#define LCDB_InterfaceConfig_TePolarity	(LCDB.unInterfaceConfig.stcField.u1TePolarity)
typedef struct stc_lcdb_interfaceconfig_field{
    uint_io32_t		u2InterfaceType:2;
    uint_io32_t		:6;
    uint_io32_t		u2InterfaceWidth:2;
    uint_io32_t		:6;
    uint_io32_t		u1CsPolarity:1;
    uint_io32_t		u1WrPolarity:1;
    uint_io32_t		u1RdPolarity:1;
    uint_io32_t		u1RsPolarity:1;
    uint_io32_t		u1DataPolarity:1;
    uint_io32_t		u1TePolarity:1;
    uint_io32_t		:10;
}stc_lcdb_interfaceconfig_field_t;

typedef union un_lcdb_interfaceconfig{
    uint_io32_t		u32Register;
    stc_lcdb_interfaceconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_interfaceconfig_t;

#define LCDB_WriteTimingConfig	(LCDB.unWriteTimingConfig.u32Register)
#define LCDB_WriteTimingConfig_WriteSetupCycles	(LCDB.unWriteTimingConfig.stcField.u8WriteSetupCycles)
#define LCDB_WriteTimingConfig_WriteActiveCycles	(LCDB.unWriteTimingConfig.stcField.u8WriteActiveCycles)
#define LCDB_WriteTimingConfig_WriteHoldCycles	(LCDB.unWriteTimingConfig.stcField.u8WriteHoldCycles)
typedef struct stc_lcdb_writetimingconfig_field{
    uint_io32_t		u8WriteSetupCycles:8;
    uint_io32_t		u8WriteActiveCycles:8;
    uint_io32_t		u8WriteHoldCycles:8;
    uint_io32_t		:8;
}stc_lcdb_writetimingconfig_field_t;

typedef union un_lcdb_writetimingconfig{
    uint_io32_t		u32Register;
    stc_lcdb_writetimingconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_writetimingconfig_t;

#define LCDB_ReadTimingConfig	(LCDB.unReadTimingConfig.u32Register)
#define LCDB_ReadTimingConfig_ReadSetupCycles	(LCDB.unReadTimingConfig.stcField.u8ReadSetupCycles)
#define LCDB_ReadTimingConfig_ReadActiveCycles	(LCDB.unReadTimingConfig.stcField.u8ReadActiveCycles)
#define LCDB_ReadTimingConfig_ReadHoldCycles	(LCDB.unReadTimingConfig.stcField.u8ReadHoldCycles)
typedef struct stc_lcdb_readtimingconfig_field{
    uint_io32_t		u8ReadSetupCycles:8;
    uint_io32_t		u8ReadActiveCycles:8;
    uint_io32_t		u8ReadHoldCycles:8;
    uint_io32_t		:8;
}stc_lcdb_readtimingconfig_field_t;

typedef union un_lcdb_readtimingconfig{
    uint_io32_t		u32Register;
    stc_lcdb_readtimingconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_readtimingconfig_t;

#define LCDB_CommandTransferMapping0	(LCDB.unCommandTransferMapping0.u32Register)
#define LCDB_CommandTransferMapping0_CommandTransfer0Bits	(LCDB.unCommandTransferMapping0.stcField.u5CommandTransfer0Bits)
#define LCDB_CommandTransferMapping0_CommandTransfer0SrcLsb	(LCDB.unCommandTransferMapping0.stcField.u5CommandTransfer0SrcLsb)
#define LCDB_CommandTransferMapping0_CommandTransfer0DstLsb	(LCDB.unCommandTransferMapping0.stcField.u5CommandTransfer0DstLsb)
#define LCDB_CommandTransferMapping0_CommandTransfer0Next	(LCDB.unCommandTransferMapping0.stcField.u1CommandTransfer0Next)
typedef struct stc_lcdb_commandtransfermapping0_field{
    uint_io32_t		u5CommandTransfer0Bits:5;
    uint_io32_t		u5CommandTransfer0SrcLsb:5;
    uint_io32_t		u5CommandTransfer0DstLsb:5;
    uint_io32_t		u1CommandTransfer0Next:1;
    uint_io32_t		:16;
}stc_lcdb_commandtransfermapping0_field_t;

typedef union un_lcdb_commandtransfermapping0{
    uint_io32_t		u32Register;
    stc_lcdb_commandtransfermapping0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_commandtransfermapping0_t;

#define LCDB_CommandTransferMapping1	(LCDB.unCommandTransferMapping1.u32Register)
#define LCDB_CommandTransferMapping1_CommandTransfer1Bits	(LCDB.unCommandTransferMapping1.stcField.u5CommandTransfer1Bits)
#define LCDB_CommandTransferMapping1_CommandTransfer1SrcLsb	(LCDB.unCommandTransferMapping1.stcField.u5CommandTransfer1SrcLsb)
#define LCDB_CommandTransferMapping1_CommandTransfer1DstLsb	(LCDB.unCommandTransferMapping1.stcField.u5CommandTransfer1DstLsb)
#define LCDB_CommandTransferMapping1_CommandTransfer1Next	(LCDB.unCommandTransferMapping1.stcField.u1CommandTransfer1Next)
typedef struct stc_lcdb_commandtransfermapping1_field{
    uint_io32_t		u5CommandTransfer1Bits:5;
    uint_io32_t		u5CommandTransfer1SrcLsb:5;
    uint_io32_t		u5CommandTransfer1DstLsb:5;
    uint_io32_t		u1CommandTransfer1Next:1;
    uint_io32_t		:16;
}stc_lcdb_commandtransfermapping1_field_t;

typedef union un_lcdb_commandtransfermapping1{
    uint_io32_t		u32Register;
    stc_lcdb_commandtransfermapping1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_commandtransfermapping1_t;

#define LCDB_CommandTransferMapping2	(LCDB.unCommandTransferMapping2.u32Register)
#define LCDB_CommandTransferMapping2_CommandTransfer2Bits	(LCDB.unCommandTransferMapping2.stcField.u5CommandTransfer2Bits)
#define LCDB_CommandTransferMapping2_CommandTransfer2SrcLsb	(LCDB.unCommandTransferMapping2.stcField.u5CommandTransfer2SrcLsb)
#define LCDB_CommandTransferMapping2_CommandTransfer2DstLsb	(LCDB.unCommandTransferMapping2.stcField.u5CommandTransfer2DstLsb)
typedef struct stc_lcdb_commandtransfermapping2_field{
    uint_io32_t		u5CommandTransfer2Bits:5;
    uint_io32_t		u5CommandTransfer2SrcLsb:5;
    uint_io32_t		u5CommandTransfer2DstLsb:5;
    uint_io32_t		:17;
}stc_lcdb_commandtransfermapping2_field_t;

typedef union un_lcdb_commandtransfermapping2{
    uint_io32_t		u32Register;
    stc_lcdb_commandtransfermapping2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_commandtransfermapping2_t;

#define LCDB_DataTransferMapping0	(LCDB.unDataTransferMapping0.u32Register)
#define LCDB_DataTransferMapping0_DataTransfer0Bits	(LCDB.unDataTransferMapping0.stcField.u5DataTransfer0Bits)
#define LCDB_DataTransferMapping0_DataTransfer0SrcLsb	(LCDB.unDataTransferMapping0.stcField.u5DataTransfer0SrcLsb)
#define LCDB_DataTransferMapping0_DataTransfer0DstLsb	(LCDB.unDataTransferMapping0.stcField.u5DataTransfer0DstLsb)
#define LCDB_DataTransferMapping0_DataTransfer0Next	(LCDB.unDataTransferMapping0.stcField.u1DataTransfer0Next)
typedef struct stc_lcdb_datatransfermapping0_field{
    uint_io32_t		u5DataTransfer0Bits:5;
    uint_io32_t		u5DataTransfer0SrcLsb:5;
    uint_io32_t		u5DataTransfer0DstLsb:5;
    uint_io32_t		u1DataTransfer0Next:1;
    uint_io32_t		:16;
}stc_lcdb_datatransfermapping0_field_t;

typedef union un_lcdb_datatransfermapping0{
    uint_io32_t		u32Register;
    stc_lcdb_datatransfermapping0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_datatransfermapping0_t;

#define LCDB_DataTransferMapping1	(LCDB.unDataTransferMapping1.u32Register)
#define LCDB_DataTransferMapping1_DataTransfer1Bits	(LCDB.unDataTransferMapping1.stcField.u5DataTransfer1Bits)
#define LCDB_DataTransferMapping1_DataTransfer1SrcLsb	(LCDB.unDataTransferMapping1.stcField.u5DataTransfer1SrcLsb)
#define LCDB_DataTransferMapping1_DataTransfer1DstLsb	(LCDB.unDataTransferMapping1.stcField.u5DataTransfer1DstLsb)
#define LCDB_DataTransferMapping1_DataTransfer1Next	(LCDB.unDataTransferMapping1.stcField.u1DataTransfer1Next)
typedef struct stc_lcdb_datatransfermapping1_field{
    uint_io32_t		u5DataTransfer1Bits:5;
    uint_io32_t		u5DataTransfer1SrcLsb:5;
    uint_io32_t		u5DataTransfer1DstLsb:5;
    uint_io32_t		u1DataTransfer1Next:1;
    uint_io32_t		:16;
}stc_lcdb_datatransfermapping1_field_t;

typedef union un_lcdb_datatransfermapping1{
    uint_io32_t		u32Register;
    stc_lcdb_datatransfermapping1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_datatransfermapping1_t;

#define LCDB_DataTransferMapping2	(LCDB.unDataTransferMapping2.u32Register)
#define LCDB_DataTransferMapping2_DataTransfer2Bits	(LCDB.unDataTransferMapping2.stcField.u5DataTransfer2Bits)
#define LCDB_DataTransferMapping2_DataTransfer2SrcLsb	(LCDB.unDataTransferMapping2.stcField.u5DataTransfer2SrcLsb)
#define LCDB_DataTransferMapping2_DataTransfer2DstLsb	(LCDB.unDataTransferMapping2.stcField.u5DataTransfer2DstLsb)
typedef struct stc_lcdb_datatransfermapping2_field{
    uint_io32_t		u5DataTransfer2Bits:5;
    uint_io32_t		u5DataTransfer2SrcLsb:5;
    uint_io32_t		u5DataTransfer2DstLsb:5;
    uint_io32_t		:17;
}stc_lcdb_datatransfermapping2_field_t;

typedef union un_lcdb_datatransfermapping2{
    uint_io32_t		u32Register;
    stc_lcdb_datatransfermapping2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_datatransfermapping2_t;

#define LCDB_ColorComponentBits	(LCDB.unColorComponentBits.u32Register)
#define LCDB_ColorComponentBits_ComponentBitsBlue	(LCDB.unColorComponentBits.stcField.u4ComponentBitsBlue)
#define LCDB_ColorComponentBits_ComponentBitsGreen	(LCDB.unColorComponentBits.stcField.u4ComponentBitsGreen)
#define LCDB_ColorComponentBits_ComponentBitsRed	(LCDB.unColorComponentBits.stcField.u4ComponentBitsRed)
typedef struct stc_lcdb_colorcomponentbits_field{
    uint_io32_t		:8;
    uint_io32_t		u4ComponentBitsBlue:4;
    uint_io32_t		:4;
    uint_io32_t		u4ComponentBitsGreen:4;
    uint_io32_t		:4;
    uint_io32_t		u4ComponentBitsRed:4;
    uint_io32_t		:4;
}stc_lcdb_colorcomponentbits_field_t;

typedef union un_lcdb_colorcomponentbits{
    uint_io32_t		u32Register;
    stc_lcdb_colorcomponentbits_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_colorcomponentbits_t;

#define LCDB_ColorComponentShift	(LCDB.unColorComponentShift.u32Register)
#define LCDB_ColorComponentShift_ComponentShiftBlue	(LCDB.unColorComponentShift.stcField.u5ComponentShiftBlue)
#define LCDB_ColorComponentShift_ComponentShiftGreen	(LCDB.unColorComponentShift.stcField.u5ComponentShiftGreen)
#define LCDB_ColorComponentShift_ComponentShiftRed	(LCDB.unColorComponentShift.stcField.u5ComponentShiftRed)
typedef struct stc_lcdb_colorcomponentshift_field{
    uint_io32_t		:8;
    uint_io32_t		u5ComponentShiftBlue:5;
    uint_io32_t		:3;
    uint_io32_t		u5ComponentShiftGreen:5;
    uint_io32_t		:3;
    uint_io32_t		u5ComponentShiftRed:5;
    uint_io32_t		:3;
}stc_lcdb_colorcomponentshift_field_t;

typedef union un_lcdb_colorcomponentshift{
    uint_io32_t		u32Register;
    stc_lcdb_colorcomponentshift_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_colorcomponentshift_t;

#define LCDB_DestinationAttributes	(LCDB.unDestinationAttributes.u32Register)
#define LCDB_DestinationAttributes_BitsPerTransfer	(LCDB.unDestinationAttributes.stcField.u5BitsPerTransfer)
#define LCDB_DestinationAttributes_BitsPerPixel	(LCDB.unDestinationAttributes.stcField.u5BitsPerPixel)
typedef struct stc_lcdb_destinationattributes_field{
    uint_io32_t		u5BitsPerTransfer:5;
    uint_io32_t		:3;
    uint_io32_t		u5BitsPerPixel:5;
    uint_io32_t		:19;
}stc_lcdb_destinationattributes_field_t;

typedef union un_lcdb_destinationattributes{
    uint_io32_t		u32Register;
    stc_lcdb_destinationattributes_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_destinationattributes_t;

#define LCDB_LockUnlockControl	(LCDB.unLockUnlockControl.u32Register)
#define LCDB_LockUnlockControl_LockUnlockControl	(LCDB.unLockUnlockControl.stcField.u32LockUnlockControl)
typedef struct stc_lcdb_lockunlockcontrol_field{
    uint_io32_t		u32LockUnlockControl:32;
}stc_lcdb_lockunlockcontrol_field_t;

typedef union un_lcdb_lockunlockcontrol{
    uint_io32_t		u32Register;
    stc_lcdb_lockunlockcontrol_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockunlockcontrol_t;

#define LCDB_LockStatusControl	(LCDB.unLockStatusControl.u32Register)
#define LCDB_LockStatusControl_LockStatusControl	(LCDB.unLockStatusControl.stcField.u1LockStatusControl)
#define LCDB_LockStatusControl_PrivilegeStatusControl	(LCDB.unLockStatusControl.stcField.u1PrivilegeStatusControl)
#define LCDB_LockStatusControl_FreezeStatusControl	(LCDB.unLockStatusControl.stcField.u1FreezeStatusControl)
typedef struct stc_lcdb_lockstatuscontrol_field{
    uint_io32_t		u1LockStatusControl:1;
    uint_io32_t		:4;
    uint_io32_t		u1PrivilegeStatusControl:1;
    uint_io32_t		:3;
    uint_io32_t		u1FreezeStatusControl:1;
    uint_io32_t		:22;
}stc_lcdb_lockstatuscontrol_field_t;

typedef union un_lcdb_lockstatuscontrol{
    uint_io32_t		u32Register;
    stc_lcdb_lockstatuscontrol_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockstatuscontrol_t;

#define LCDB_InterruptEnable	(LCDB.unInterruptEnable.u32Register)
#define LCDB_InterruptEnable_SequencerErrorInterruptEnable	(LCDB.unInterruptEnable.stcField.u1SequencerErrorInterruptEnable)
#define LCDB_InterruptEnable_SequencerSyncInterruptEnable	(LCDB.unInterruptEnable.stcField.u1SequencerSyncInterruptEnable)
#define LCDB_InterruptEnable_InstrFifoInterruptEnable	(LCDB.unInterruptEnable.stcField.u1InstrFifoInterruptEnable)
#define LCDB_InterruptEnable_RxFifoInterruptEnable	(LCDB.unInterruptEnable.stcField.u1RxFifoInterruptEnable)
#define LCDB_InterruptEnable_TearingEffectInterruptEnable	(LCDB.unInterruptEnable.stcField.u1TearingEffectInterruptEnable)
#define LCDB_InterruptEnable_ReadChannelDoneInterruptEnable	(LCDB.unInterruptEnable.stcField.u1ReadChannelDoneInterruptEnable)
#define LCDB_InterruptEnable_WriteChannelDoneInterruptEnable	(LCDB.unInterruptEnable.stcField.u1WriteChannelDoneInterruptEnable)
typedef struct stc_lcdb_interruptenable_field{
    uint_io32_t		u1SequencerErrorInterruptEnable:1;
    uint_io32_t		u1SequencerSyncInterruptEnable:1;
    uint_io32_t		u1InstrFifoInterruptEnable:1;
    uint_io32_t		u1RxFifoInterruptEnable:1;
    uint_io32_t		u1TearingEffectInterruptEnable:1;
    uint_io32_t		u1ReadChannelDoneInterruptEnable:1;
    uint_io32_t		u1WriteChannelDoneInterruptEnable:1;
    uint_io32_t		:25;
}stc_lcdb_interruptenable_field_t;

typedef union un_lcdb_interruptenable{
    uint_io32_t		u32Register;
    stc_lcdb_interruptenable_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_interruptenable_t;

#define LCDB_InterruptPreset	(LCDB.unInterruptPreset.u32Register)
#define LCDB_InterruptPreset_SequencerErrorInterruptPreset	(LCDB.unInterruptPreset.stcField.u1SequencerErrorInterruptPreset)
#define LCDB_InterruptPreset_SequencerSyncInterruptPreset	(LCDB.unInterruptPreset.stcField.u1SequencerSyncInterruptPreset)
#define LCDB_InterruptPreset_InstrFifoInterruptPreset	(LCDB.unInterruptPreset.stcField.u1InstrFifoInterruptPreset)
#define LCDB_InterruptPreset_RxFifoInterruptPreset	(LCDB.unInterruptPreset.stcField.u1RxFifoInterruptPreset)
#define LCDB_InterruptPreset_TearingEffectInterruptPreset	(LCDB.unInterruptPreset.stcField.u1TearingEffectInterruptPreset)
#define LCDB_InterruptPreset_ReadChannelDoneInterruptPreset	(LCDB.unInterruptPreset.stcField.u1ReadChannelDoneInterruptPreset)
#define LCDB_InterruptPreset_WriteChannelDoneInterruptPreset	(LCDB.unInterruptPreset.stcField.u1WriteChannelDoneInterruptPreset)
typedef struct stc_lcdb_interruptpreset_field{
    uint_io32_t		u1SequencerErrorInterruptPreset:1;
    uint_io32_t		u1SequencerSyncInterruptPreset:1;
    uint_io32_t		u1InstrFifoInterruptPreset:1;
    uint_io32_t		u1RxFifoInterruptPreset:1;
    uint_io32_t		u1TearingEffectInterruptPreset:1;
    uint_io32_t		u1ReadChannelDoneInterruptPreset:1;
    uint_io32_t		u1WriteChannelDoneInterruptPreset:1;
    uint_io32_t		:25;
}stc_lcdb_interruptpreset_field_t;

typedef union un_lcdb_interruptpreset{
    uint_io32_t		u32Register;
    stc_lcdb_interruptpreset_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_interruptpreset_t;

#define LCDB_InterruptClear	(LCDB.unInterruptClear.u32Register)
#define LCDB_InterruptClear_SequencerErrorInterruptClear	(LCDB.unInterruptClear.stcField.u1SequencerErrorInterruptClear)
#define LCDB_InterruptClear_SequencerSyncInterruptClear	(LCDB.unInterruptClear.stcField.u1SequencerSyncInterruptClear)
#define LCDB_InterruptClear_InstrFifoInterruptClear	(LCDB.unInterruptClear.stcField.u1InstrFifoInterruptClear)
#define LCDB_InterruptClear_RxFifoInterruptClear	(LCDB.unInterruptClear.stcField.u1RxFifoInterruptClear)
#define LCDB_InterruptClear_TearingEffectInterruptClear	(LCDB.unInterruptClear.stcField.u1TearingEffectInterruptClear)
#define LCDB_InterruptClear_ReadChannelDoneInterruptClear	(LCDB.unInterruptClear.stcField.u1ReadChannelDoneInterruptClear)
#define LCDB_InterruptClear_WriteChannelDoneInterruptClear	(LCDB.unInterruptClear.stcField.u1WriteChannelDoneInterruptClear)
typedef struct stc_lcdb_interruptclear_field{
    uint_io32_t		u1SequencerErrorInterruptClear:1;
    uint_io32_t		u1SequencerSyncInterruptClear:1;
    uint_io32_t		u1InstrFifoInterruptClear:1;
    uint_io32_t		u1RxFifoInterruptClear:1;
    uint_io32_t		u1TearingEffectInterruptClear:1;
    uint_io32_t		u1ReadChannelDoneInterruptClear:1;
    uint_io32_t		u1WriteChannelDoneInterruptClear:1;
    uint_io32_t		:25;
}stc_lcdb_interruptclear_field_t;

typedef union un_lcdb_interruptclear{
    uint_io32_t		u32Register;
    stc_lcdb_interruptclear_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_interruptclear_t;

#define LCDB_InterruptStatus	(LCDB.unInterruptStatus.u32Register)
#define LCDB_InterruptStatus_SequencerErrorInterruptStatus	(LCDB.unInterruptStatus.stcField.u1SequencerErrorInterruptStatus)
#define LCDB_InterruptStatus_SequencerSyncInterruptStatus	(LCDB.unInterruptStatus.stcField.u1SequencerSyncInterruptStatus)
#define LCDB_InterruptStatus_InstrFifoInterruptStatus	(LCDB.unInterruptStatus.stcField.u1InstrFifoInterruptStatus)
#define LCDB_InterruptStatus_RxFifoInterruptStatus	(LCDB.unInterruptStatus.stcField.u1RxFifoInterruptStatus)
#define LCDB_InterruptStatus_TearingEffectInterruptStatus	(LCDB.unInterruptStatus.stcField.u1TearingEffectInterruptStatus)
#define LCDB_InterruptStatus_ReadChannelDoneInterruptStatus	(LCDB.unInterruptStatus.stcField.u1ReadChannelDoneInterruptStatus)
#define LCDB_InterruptStatus_WriteChannelDoneInterruptStatus	(LCDB.unInterruptStatus.stcField.u1WriteChannelDoneInterruptStatus)
typedef struct stc_lcdb_interruptstatus_field{
    uint_io32_t		u1SequencerErrorInterruptStatus:1;
    uint_io32_t		u1SequencerSyncInterruptStatus:1;
    uint_io32_t		u1InstrFifoInterruptStatus:1;
    uint_io32_t		u1RxFifoInterruptStatus:1;
    uint_io32_t		u1TearingEffectInterruptStatus:1;
    uint_io32_t		u1ReadChannelDoneInterruptStatus:1;
    uint_io32_t		u1WriteChannelDoneInterruptStatus:1;
    uint_io32_t		:25;
}stc_lcdb_interruptstatus_field_t;

typedef union un_lcdb_interruptstatus{
    uint_io32_t		u32Register;
    stc_lcdb_interruptstatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_interruptstatus_t;

#define LCDB_SequencerConfig	(LCDB.unSequencerConfig.u32Register)
#define LCDB_SequencerConfig_InstructionTimeout	(LCDB.unSequencerConfig.stcField.u31InstructionTimeout)
#define LCDB_SequencerConfig_InstructionTimeoutEnable	(LCDB.unSequencerConfig.stcField.u1InstructionTimeoutEnable)
typedef struct stc_lcdb_sequencerconfig_field{
    uint_io32_t		u31InstructionTimeout:31;
    uint_io32_t		u1InstructionTimeoutEnable:1;
}stc_lcdb_sequencerconfig_field_t;

typedef union un_lcdb_sequencerconfig{
    uint_io32_t		u32Register;
    stc_lcdb_sequencerconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_sequencerconfig_t;

#define LCDB_InstructionFifoConfig	(LCDB.unInstructionFifoConfig.u32Register)
#define LCDB_InstructionFifoConfig_InstrThresholdLow	(LCDB.unInstructionFifoConfig.stcField.u6InstrThresholdLow)
#define LCDB_InstructionFifoConfig_InstrThresholdHigh	(LCDB.unInstructionFifoConfig.stcField.u6InstrThresholdHigh)
#define LCDB_InstructionFifoConfig_InstrThresholdTrigger	(LCDB.unInstructionFifoConfig.stcField.u2InstrThresholdTrigger)
typedef struct stc_lcdb_instructionfifoconfig_field{
    uint_io32_t		u6InstrThresholdLow:6;
    uint_io32_t		:2;
    uint_io32_t		u6InstrThresholdHigh:6;
    uint_io32_t		:2;
    uint_io32_t		u2InstrThresholdTrigger:2;
    uint_io32_t		:14;
}stc_lcdb_instructionfifoconfig_field_t;

typedef union un_lcdb_instructionfifoconfig{
    uint_io32_t		u32Register;
    stc_lcdb_instructionfifoconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_instructionfifoconfig_t;

#define LCDB_ReadChannelConfig	(LCDB.unReadChannelConfig.u32Register)
#define LCDB_ReadChannelConfig_ReadChannelWords	(LCDB.unReadChannelConfig.stcField.u24ReadChannelWords)
#define LCDB_ReadChannelConfig_ReadChannelMaxBurstLength	(LCDB.unReadChannelConfig.stcField.u5ReadChannelMaxBurstLength)
#define LCDB_ReadChannelConfig_ReadChannelEnable	(LCDB.unReadChannelConfig.stcField.u1ReadChannelEnable)
typedef struct stc_lcdb_readchannelconfig_field{
    uint_io32_t		u24ReadChannelWords:24;
    uint_io32_t		u5ReadChannelMaxBurstLength:5;
    uint_io32_t		:2;
    uint_io32_t		u1ReadChannelEnable:1;
}stc_lcdb_readchannelconfig_field_t;

typedef union un_lcdb_readchannelconfig{
    uint_io32_t		u32Register;
    stc_lcdb_readchannelconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_readchannelconfig_t;

#define LCDB_ReadChannelBuffer	(LCDB.unReadChannelBuffer.u32Register)
#define LCDB_ReadChannelBuffer_ReadChannelBaseAddress	(LCDB.unReadChannelBuffer.stcField.u32ReadChannelBaseAddress)
typedef struct stc_lcdb_readchannelbuffer_field{
    uint_io32_t		u32ReadChannelBaseAddress:32;
}stc_lcdb_readchannelbuffer_field_t;

typedef union un_lcdb_readchannelbuffer{
    uint_io32_t		u32Register;
    stc_lcdb_readchannelbuffer_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_readchannelbuffer_t;

#define LCDB_ReadChannelControl	(LCDB.unReadChannelControl.u32Register)
#define LCDB_ReadChannelControl_ReadChannelTrigger	(LCDB.unReadChannelControl.stcField.u1ReadChannelTrigger)
typedef struct stc_lcdb_readchannelcontrol_field{
    uint_io32_t		u1ReadChannelTrigger:1;
    uint_io32_t		:31;
}stc_lcdb_readchannelcontrol_field_t;

typedef union un_lcdb_readchannelcontrol{
    uint_io32_t		u32Register;
    stc_lcdb_readchannelcontrol_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_readchannelcontrol_t;

#define LCDB_WriteChannelConfig	(LCDB.unWriteChannelConfig.u32Register)
#define LCDB_WriteChannelConfig_WriteChannelPacking	(LCDB.unWriteChannelConfig.stcField.u3WriteChannelPacking)
#define LCDB_WriteChannelConfig_WriteChannelMaxBurstLength	(LCDB.unWriteChannelConfig.stcField.u5WriteChannelMaxBurstLength)
#define LCDB_WriteChannelConfig_WriteChannelEnable	(LCDB.unWriteChannelConfig.stcField.u1WriteChannelEnable)
typedef struct stc_lcdb_writechannelconfig_field{
    uint_io32_t		u3WriteChannelPacking:3;
    uint_io32_t		:21;
    uint_io32_t		u5WriteChannelMaxBurstLength:5;
    uint_io32_t		:2;
    uint_io32_t		u1WriteChannelEnable:1;
}stc_lcdb_writechannelconfig_field_t;

typedef union un_lcdb_writechannelconfig{
    uint_io32_t		u32Register;
    stc_lcdb_writechannelconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_writechannelconfig_t;

#define LCDB_WriteChannelBuffer	(LCDB.unWriteChannelBuffer.u32Register)
#define LCDB_WriteChannelBuffer_WriteChannelBaseAddress	(LCDB.unWriteChannelBuffer.stcField.u32WriteChannelBaseAddress)
typedef struct stc_lcdb_writechannelbuffer_field{
    uint_io32_t		u32WriteChannelBaseAddress:32;
}stc_lcdb_writechannelbuffer_field_t;

typedef union un_lcdb_writechannelbuffer{
    uint_io32_t		u32Register;
    stc_lcdb_writechannelbuffer_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_writechannelbuffer_t;

#define LCDB_SoftwareReset	(LCDB.unSoftwareReset.u32Register)
#define LCDB_SoftwareReset_SoftwareReset	(LCDB.unSoftwareReset.stcField.u1SoftwareReset)
typedef struct stc_lcdb_softwarereset_field{
    uint_io32_t		:31;
    uint_io32_t		u1SoftwareReset:1;
}stc_lcdb_softwarereset_field_t;

typedef union un_lcdb_softwarereset{
    uint_io32_t		u32Register;
    stc_lcdb_softwarereset_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_softwarereset_t;

#define LCDB_SequencerSync	(LCDB.unSequencerSync.u32Register)
#define LCDB_SequencerSync_SequencerAck	(LCDB.unSequencerSync.stcField.u1SequencerAck)
typedef struct stc_lcdb_sequencersync_field{
    uint_io32_t		:31;
    uint_io32_t		u1SequencerAck:1;
}stc_lcdb_sequencersync_field_t;

typedef union un_lcdb_sequencersync{
    uint_io32_t		u32Register;
    stc_lcdb_sequencersync_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_sequencersync_t;

#define LCDB_SequencerStatus	(LCDB.unSequencerStatus.u32Register)
#define LCDB_SequencerStatus_OperationState	(LCDB.unSequencerStatus.stcField.u2OperationState)
#define LCDB_SequencerStatus_WaitAck	(LCDB.unSequencerStatus.stcField.u1WaitAck)
#define LCDB_SequencerStatus_ErrorCode	(LCDB.unSequencerStatus.stcField.u4ErrorCode)
#define LCDB_SequencerStatus_InstructionCounter	(LCDB.unSequencerStatus.stcField.u6InstructionCounter)
#define LCDB_SequencerStatus_InstructionRegister	(LCDB.unSequencerStatus.stcField.u8InstructionRegister)
#define LCDB_SequencerStatus_IrisInterfaceStatus	(LCDB.unSequencerStatus.stcField.u2IrisInterfaceStatus)
#define LCDB_SequencerStatus_LcdInterfaceState	(LCDB.unSequencerStatus.stcField.u1LcdInterfaceState)
typedef struct stc_lcdb_sequencerstatus_field{
    uint_io32_t		u2OperationState:2;
    uint_io32_t		u1WaitAck:1;
    uint_io32_t		:1;
    uint_io32_t		u4ErrorCode:4;
    uint_io32_t		u6InstructionCounter:6;
    uint_io32_t		:2;
    uint_io32_t		u8InstructionRegister:8;
    uint_io32_t		u2IrisInterfaceStatus:2;
    uint_io32_t		:2;
    uint_io32_t		u1LcdInterfaceState:1;
    uint_io32_t		:3;
}stc_lcdb_sequencerstatus_field_t;

typedef union un_lcdb_sequencerstatus{
    uint_io32_t		u32Register;
    stc_lcdb_sequencerstatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_sequencerstatus_t;

#define LCDB_SequencerTransferStatus	(LCDB.unSequencerTransferStatus.u32Register)
#define LCDB_SequencerTransferStatus_TransferRemaining	(LCDB.unSequencerTransferStatus.stcField.u28TransferRemaining)
typedef struct stc_lcdb_sequencertransferstatus_field{
    uint_io32_t		u28TransferRemaining:28;
    uint_io32_t		:4;
}stc_lcdb_sequencertransferstatus_field_t;

typedef union un_lcdb_sequencertransferstatus{
    uint_io32_t		u32Register;
    stc_lcdb_sequencertransferstatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_sequencertransferstatus_t;

#define LCDB_InstrFifoStatus	(LCDB.unInstrFifoStatus.u32Register)
#define LCDB_InstrFifoStatus_InstrSpace	(LCDB.unInstrFifoStatus.stcField.u6InstrSpace)
#define LCDB_InstrFifoStatus_InstrEmpty	(LCDB.unInstrFifoStatus.stcField.u1InstrEmpty)
#define LCDB_InstrFifoStatus_InstrFull	(LCDB.unInstrFifoStatus.stcField.u1InstrFull)
typedef struct stc_lcdb_instrfifostatus_field{
    uint_io32_t		u6InstrSpace:6;
    uint_io32_t		:2;
    uint_io32_t		u1InstrEmpty:1;
    uint_io32_t		:3;
    uint_io32_t		u1InstrFull:1;
    uint_io32_t		:19;
}stc_lcdb_instrfifostatus_field_t;

typedef union un_lcdb_instrfifostatus{
    uint_io32_t		u32Register;
    stc_lcdb_instrfifostatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_instrfifostatus_t;

#define LCDB_ReadChannelStatus	(LCDB.unReadChannelStatus.u32Register)
#define LCDB_ReadChannelStatus_ReadChannelBusy	(LCDB.unReadChannelStatus.stcField.u1ReadChannelBusy)
#define LCDB_ReadChannelStatus_ReadChannelWordsRemaining	(LCDB.unReadChannelStatus.stcField.u24ReadChannelWordsRemaining)
typedef struct stc_lcdb_readchannelstatus_field{
    uint_io32_t		u1ReadChannelBusy:1;
    uint_io32_t		:7;
    uint_io32_t		u24ReadChannelWordsRemaining:24;
}stc_lcdb_readchannelstatus_field_t;

typedef union un_lcdb_readchannelstatus{
    uint_io32_t		u32Register;
    stc_lcdb_readchannelstatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_readchannelstatus_t;

#define LCDB_WriteChannelStatus	(LCDB.unWriteChannelStatus.u32Register)
#define LCDB_WriteChannelStatus_WriteChannelBusy	(LCDB.unWriteChannelStatus.stcField.u1WriteChannelBusy)
typedef struct stc_lcdb_writechannelstatus_field{
    uint_io32_t		u1WriteChannelBusy:1;
    uint_io32_t		:31;
}stc_lcdb_writechannelstatus_field_t;

typedef union un_lcdb_writechannelstatus{
    uint_io32_t		u32Register;
    stc_lcdb_writechannelstatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_writechannelstatus_t;

#define LCDB_LockUnlockFifo	(LCDB.unLockUnlockFifo.u32Register)
#define LCDB_LockUnlockFifo_LockUnlockFifo	(LCDB.unLockUnlockFifo.stcField.u32LockUnlockFifo)
typedef struct stc_lcdb_lockunlockfifo_field{
    uint_io32_t		u32LockUnlockFifo:32;
}stc_lcdb_lockunlockfifo_field_t;

typedef union un_lcdb_lockunlockfifo{
    uint_io32_t		u32Register;
    stc_lcdb_lockunlockfifo_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockunlockfifo_t;

#define LCDB_LockStatusFifo	(LCDB.unLockStatusFifo.u32Register)
#define LCDB_LockStatusFifo_LockStatusFifo	(LCDB.unLockStatusFifo.stcField.u1LockStatusFifo)
#define LCDB_LockStatusFifo_PrivilegeStatusFifo	(LCDB.unLockStatusFifo.stcField.u1PrivilegeStatusFifo)
#define LCDB_LockStatusFifo_FreezeStatusFifo	(LCDB.unLockStatusFifo.stcField.u1FreezeStatusFifo)
typedef struct stc_lcdb_lockstatusfifo_field{
    uint_io32_t		u1LockStatusFifo:1;
    uint_io32_t		:3;
    uint_io32_t		u1PrivilegeStatusFifo:1;
    uint_io32_t		:3;
    uint_io32_t		u1FreezeStatusFifo:1;
    uint_io32_t		:23;
}stc_lcdb_lockstatusfifo_field_t;

typedef union un_lcdb_lockstatusfifo{
    uint_io32_t		u32Register;
    stc_lcdb_lockstatusfifo_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockstatusfifo_t;

#define LCDB_ReceptionFifoConfig	(LCDB.unReceptionFifoConfig.u32Register)
#define LCDB_ReceptionFifoConfig_RxThresholdLow	(LCDB.unReceptionFifoConfig.stcField.u5RxThresholdLow)
#define LCDB_ReceptionFifoConfig_RxThresholdHigh	(LCDB.unReceptionFifoConfig.stcField.u5RxThresholdHigh)
#define LCDB_ReceptionFifoConfig_RxThresholdTrigger	(LCDB.unReceptionFifoConfig.stcField.u2RxThresholdTrigger)
typedef struct stc_lcdb_receptionfifoconfig_field{
    uint_io32_t		u5RxThresholdLow:5;
    uint_io32_t		:3;
    uint_io32_t		u5RxThresholdHigh:5;
    uint_io32_t		:3;
    uint_io32_t		u2RxThresholdTrigger:2;
    uint_io32_t		:14;
}stc_lcdb_receptionfifoconfig_field_t;

typedef union un_lcdb_receptionfifoconfig{
    uint_io32_t		u32Register;
    stc_lcdb_receptionfifoconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_receptionfifoconfig_t;

#define LCDB_RxFifoControl	(LCDB.unRxFifoControl.u32Register)
#define LCDB_RxFifoControl_RxClear	(LCDB.unRxFifoControl.stcField.u1RxClear)
typedef struct stc_lcdb_rxfifocontrol_field{
    uint_io32_t		u1RxClear:1;
    uint_io32_t		:31;
}stc_lcdb_rxfifocontrol_field_t;

typedef union un_lcdb_rxfifocontrol{
    uint_io32_t		u32Register;
    stc_lcdb_rxfifocontrol_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_rxfifocontrol_t;

#define LCDB_RxFifoStatus	(LCDB.unRxFifoStatus.u32Register)
#define LCDB_RxFifoStatus_RxLevel	(LCDB.unRxFifoStatus.stcField.u5RxLevel)
#define LCDB_RxFifoStatus_RxEmpty	(LCDB.unRxFifoStatus.stcField.u1RxEmpty)
#define LCDB_RxFifoStatus_RxFull	(LCDB.unRxFifoStatus.stcField.u1RxFull)
typedef struct stc_lcdb_rxfifostatus_field{
    uint_io32_t		:16;
    uint_io32_t		u5RxLevel:5;
    uint_io32_t		:3;
    uint_io32_t		u1RxEmpty:1;
    uint_io32_t		:3;
    uint_io32_t		u1RxFull:1;
    uint_io32_t		:3;
}stc_lcdb_rxfifostatus_field_t;

typedef union un_lcdb_rxfifostatus{
    uint_io32_t		u32Register;
    stc_lcdb_rxfifostatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_rxfifostatus_t;

#define LCDB_InstructionFifo0	(LCDB.unInstructionFifo0.u32Register)
#define LCDB_InstructionFifo0_Instruction	(LCDB.unInstructionFifo0.stcField.u32Instruction)
#define LCDB_InstructionFifo1	(LCDB.unInstructionFifo1.u32Register)
#define LCDB_InstructionFifo1_Instruction	(LCDB.unInstructionFifo1.stcField.u32Instruction)
#define LCDB_InstructionFifo2	(LCDB.unInstructionFifo2.u32Register)
#define LCDB_InstructionFifo2_Instruction	(LCDB.unInstructionFifo2.stcField.u32Instruction)
#define LCDB_InstructionFifo3	(LCDB.unInstructionFifo3.u32Register)
#define LCDB_InstructionFifo3_Instruction	(LCDB.unInstructionFifo3.stcField.u32Instruction)
#define LCDB_InstructionFifo4	(LCDB.unInstructionFifo4.u32Register)
#define LCDB_InstructionFifo4_Instruction	(LCDB.unInstructionFifo4.stcField.u32Instruction)
#define LCDB_InstructionFifo5	(LCDB.unInstructionFifo5.u32Register)
#define LCDB_InstructionFifo5_Instruction	(LCDB.unInstructionFifo5.stcField.u32Instruction)
#define LCDB_InstructionFifo6	(LCDB.unInstructionFifo6.u32Register)
#define LCDB_InstructionFifo6_Instruction	(LCDB.unInstructionFifo6.stcField.u32Instruction)
#define LCDB_InstructionFifo7	(LCDB.unInstructionFifo7.u32Register)
#define LCDB_InstructionFifo7_Instruction	(LCDB.unInstructionFifo7.stcField.u32Instruction)
#define LCDB_InstructionFifo8	(LCDB.unInstructionFifo8.u32Register)
#define LCDB_InstructionFifo8_Instruction	(LCDB.unInstructionFifo8.stcField.u32Instruction)
#define LCDB_InstructionFifo9	(LCDB.unInstructionFifo9.u32Register)
#define LCDB_InstructionFifo9_Instruction	(LCDB.unInstructionFifo9.stcField.u32Instruction)
#define LCDB_InstructionFifo10	(LCDB.unInstructionFifo10.u32Register)
#define LCDB_InstructionFifo10_Instruction	(LCDB.unInstructionFifo10.stcField.u32Instruction)
#define LCDB_InstructionFifo11	(LCDB.unInstructionFifo11.u32Register)
#define LCDB_InstructionFifo11_Instruction	(LCDB.unInstructionFifo11.stcField.u32Instruction)
#define LCDB_InstructionFifo12	(LCDB.unInstructionFifo12.u32Register)
#define LCDB_InstructionFifo12_Instruction	(LCDB.unInstructionFifo12.stcField.u32Instruction)
#define LCDB_InstructionFifo13	(LCDB.unInstructionFifo13.u32Register)
#define LCDB_InstructionFifo13_Instruction	(LCDB.unInstructionFifo13.stcField.u32Instruction)
#define LCDB_InstructionFifo14	(LCDB.unInstructionFifo14.u32Register)
#define LCDB_InstructionFifo14_Instruction	(LCDB.unInstructionFifo14.stcField.u32Instruction)
#define LCDB_InstructionFifo15	(LCDB.unInstructionFifo15.u32Register)
#define LCDB_InstructionFifo15_Instruction	(LCDB.unInstructionFifo15.stcField.u32Instruction)
#define LCDB_InstructionFifo16	(LCDB.unInstructionFifo16.u32Register)
#define LCDB_InstructionFifo16_Instruction	(LCDB.unInstructionFifo16.stcField.u32Instruction)
#define LCDB_InstructionFifo17	(LCDB.unInstructionFifo17.u32Register)
#define LCDB_InstructionFifo17_Instruction	(LCDB.unInstructionFifo17.stcField.u32Instruction)
#define LCDB_InstructionFifo18	(LCDB.unInstructionFifo18.u32Register)
#define LCDB_InstructionFifo18_Instruction	(LCDB.unInstructionFifo18.stcField.u32Instruction)
#define LCDB_InstructionFifo19	(LCDB.unInstructionFifo19.u32Register)
#define LCDB_InstructionFifo19_Instruction	(LCDB.unInstructionFifo19.stcField.u32Instruction)
#define LCDB_InstructionFifo20	(LCDB.unInstructionFifo20.u32Register)
#define LCDB_InstructionFifo20_Instruction	(LCDB.unInstructionFifo20.stcField.u32Instruction)
#define LCDB_InstructionFifo21	(LCDB.unInstructionFifo21.u32Register)
#define LCDB_InstructionFifo21_Instruction	(LCDB.unInstructionFifo21.stcField.u32Instruction)
#define LCDB_InstructionFifo22	(LCDB.unInstructionFifo22.u32Register)
#define LCDB_InstructionFifo22_Instruction	(LCDB.unInstructionFifo22.stcField.u32Instruction)
#define LCDB_InstructionFifo23	(LCDB.unInstructionFifo23.u32Register)
#define LCDB_InstructionFifo23_Instruction	(LCDB.unInstructionFifo23.stcField.u32Instruction)
#define LCDB_InstructionFifo24	(LCDB.unInstructionFifo24.u32Register)
#define LCDB_InstructionFifo24_Instruction	(LCDB.unInstructionFifo24.stcField.u32Instruction)
#define LCDB_InstructionFifo25	(LCDB.unInstructionFifo25.u32Register)
#define LCDB_InstructionFifo25_Instruction	(LCDB.unInstructionFifo25.stcField.u32Instruction)
#define LCDB_InstructionFifo26	(LCDB.unInstructionFifo26.u32Register)
#define LCDB_InstructionFifo26_Instruction	(LCDB.unInstructionFifo26.stcField.u32Instruction)
#define LCDB_InstructionFifo27	(LCDB.unInstructionFifo27.u32Register)
#define LCDB_InstructionFifo27_Instruction	(LCDB.unInstructionFifo27.stcField.u32Instruction)
#define LCDB_InstructionFifo28	(LCDB.unInstructionFifo28.u32Register)
#define LCDB_InstructionFifo28_Instruction	(LCDB.unInstructionFifo28.stcField.u32Instruction)
#define LCDB_InstructionFifo29	(LCDB.unInstructionFifo29.u32Register)
#define LCDB_InstructionFifo29_Instruction	(LCDB.unInstructionFifo29.stcField.u32Instruction)
#define LCDB_InstructionFifo30	(LCDB.unInstructionFifo30.u32Register)
#define LCDB_InstructionFifo30_Instruction	(LCDB.unInstructionFifo30.stcField.u32Instruction)
#define LCDB_InstructionFifo31	(LCDB.unInstructionFifo31.u32Register)
#define LCDB_InstructionFifo31_Instruction	(LCDB.unInstructionFifo31.stcField.u32Instruction)
typedef struct stc_lcdb_instructionfifo0_field{
    uint_io32_t		u32Instruction:32;
}stc_lcdb_instructionfifo0_field_t;

typedef union un_lcdb_instructionfifo0{
    uint_io32_t		u32Register;
    stc_lcdb_instructionfifo0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_instructionfifo0_t;

#define LCDB_RxFifo0	(LCDB.unRxFifo0.u32Register)
#define LCDB_RxFifo0_RxEntry	(LCDB.unRxFifo0.stcField.u18RxEntry)
#define LCDB_RxFifo1	(LCDB.unRxFifo1.u32Register)
#define LCDB_RxFifo1_RxEntry	(LCDB.unRxFifo1.stcField.u18RxEntry)
#define LCDB_RxFifo2	(LCDB.unRxFifo2.u32Register)
#define LCDB_RxFifo2_RxEntry	(LCDB.unRxFifo2.stcField.u18RxEntry)
#define LCDB_RxFifo3	(LCDB.unRxFifo3.u32Register)
#define LCDB_RxFifo3_RxEntry	(LCDB.unRxFifo3.stcField.u18RxEntry)
#define LCDB_RxFifo4	(LCDB.unRxFifo4.u32Register)
#define LCDB_RxFifo4_RxEntry	(LCDB.unRxFifo4.stcField.u18RxEntry)
#define LCDB_RxFifo5	(LCDB.unRxFifo5.u32Register)
#define LCDB_RxFifo5_RxEntry	(LCDB.unRxFifo5.stcField.u18RxEntry)
#define LCDB_RxFifo6	(LCDB.unRxFifo6.u32Register)
#define LCDB_RxFifo6_RxEntry	(LCDB.unRxFifo6.stcField.u18RxEntry)
#define LCDB_RxFifo7	(LCDB.unRxFifo7.u32Register)
#define LCDB_RxFifo7_RxEntry	(LCDB.unRxFifo7.stcField.u18RxEntry)
#define LCDB_RxFifo8	(LCDB.unRxFifo8.u32Register)
#define LCDB_RxFifo8_RxEntry	(LCDB.unRxFifo8.stcField.u18RxEntry)
#define LCDB_RxFifo9	(LCDB.unRxFifo9.u32Register)
#define LCDB_RxFifo9_RxEntry	(LCDB.unRxFifo9.stcField.u18RxEntry)
#define LCDB_RxFifo10	(LCDB.unRxFifo10.u32Register)
#define LCDB_RxFifo10_RxEntry	(LCDB.unRxFifo10.stcField.u18RxEntry)
#define LCDB_RxFifo11	(LCDB.unRxFifo11.u32Register)
#define LCDB_RxFifo11_RxEntry	(LCDB.unRxFifo11.stcField.u18RxEntry)
#define LCDB_RxFifo12	(LCDB.unRxFifo12.u32Register)
#define LCDB_RxFifo12_RxEntry	(LCDB.unRxFifo12.stcField.u18RxEntry)
#define LCDB_RxFifo13	(LCDB.unRxFifo13.u32Register)
#define LCDB_RxFifo13_RxEntry	(LCDB.unRxFifo13.stcField.u18RxEntry)
#define LCDB_RxFifo14	(LCDB.unRxFifo14.u32Register)
#define LCDB_RxFifo14_RxEntry	(LCDB.unRxFifo14.stcField.u18RxEntry)
#define LCDB_RxFifo15	(LCDB.unRxFifo15.u32Register)
#define LCDB_RxFifo15_RxEntry	(LCDB.unRxFifo15.stcField.u18RxEntry)
typedef struct stc_lcdb_rxfifo0_field{
    uint_io32_t		u18RxEntry:18;
    uint_io32_t		:14;
}stc_lcdb_rxfifo0_field_t;

typedef union un_lcdb_rxfifo0{
    uint_io32_t		u32Register;
    stc_lcdb_rxfifo0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_rxfifo0_t;

#define LCDB_ColorLookupTable0	(LCDB.unColorLookupTable0.u32Register)
#define LCDB_ColorLookupTable0_ClutEntry	(LCDB.unColorLookupTable0.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable1	(LCDB.unColorLookupTable1.u32Register)
#define LCDB_ColorLookupTable1_ClutEntry	(LCDB.unColorLookupTable1.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable2	(LCDB.unColorLookupTable2.u32Register)
#define LCDB_ColorLookupTable2_ClutEntry	(LCDB.unColorLookupTable2.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable3	(LCDB.unColorLookupTable3.u32Register)
#define LCDB_ColorLookupTable3_ClutEntry	(LCDB.unColorLookupTable3.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable4	(LCDB.unColorLookupTable4.u32Register)
#define LCDB_ColorLookupTable4_ClutEntry	(LCDB.unColorLookupTable4.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable5	(LCDB.unColorLookupTable5.u32Register)
#define LCDB_ColorLookupTable5_ClutEntry	(LCDB.unColorLookupTable5.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable6	(LCDB.unColorLookupTable6.u32Register)
#define LCDB_ColorLookupTable6_ClutEntry	(LCDB.unColorLookupTable6.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable7	(LCDB.unColorLookupTable7.u32Register)
#define LCDB_ColorLookupTable7_ClutEntry	(LCDB.unColorLookupTable7.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable8	(LCDB.unColorLookupTable8.u32Register)
#define LCDB_ColorLookupTable8_ClutEntry	(LCDB.unColorLookupTable8.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable9	(LCDB.unColorLookupTable9.u32Register)
#define LCDB_ColorLookupTable9_ClutEntry	(LCDB.unColorLookupTable9.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable10	(LCDB.unColorLookupTable10.u32Register)
#define LCDB_ColorLookupTable10_ClutEntry	(LCDB.unColorLookupTable10.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable11	(LCDB.unColorLookupTable11.u32Register)
#define LCDB_ColorLookupTable11_ClutEntry	(LCDB.unColorLookupTable11.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable12	(LCDB.unColorLookupTable12.u32Register)
#define LCDB_ColorLookupTable12_ClutEntry	(LCDB.unColorLookupTable12.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable13	(LCDB.unColorLookupTable13.u32Register)
#define LCDB_ColorLookupTable13_ClutEntry	(LCDB.unColorLookupTable13.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable14	(LCDB.unColorLookupTable14.u32Register)
#define LCDB_ColorLookupTable14_ClutEntry	(LCDB.unColorLookupTable14.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable15	(LCDB.unColorLookupTable15.u32Register)
#define LCDB_ColorLookupTable15_ClutEntry	(LCDB.unColorLookupTable15.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable16	(LCDB.unColorLookupTable16.u32Register)
#define LCDB_ColorLookupTable16_ClutEntry	(LCDB.unColorLookupTable16.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable17	(LCDB.unColorLookupTable17.u32Register)
#define LCDB_ColorLookupTable17_ClutEntry	(LCDB.unColorLookupTable17.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable18	(LCDB.unColorLookupTable18.u32Register)
#define LCDB_ColorLookupTable18_ClutEntry	(LCDB.unColorLookupTable18.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable19	(LCDB.unColorLookupTable19.u32Register)
#define LCDB_ColorLookupTable19_ClutEntry	(LCDB.unColorLookupTable19.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable20	(LCDB.unColorLookupTable20.u32Register)
#define LCDB_ColorLookupTable20_ClutEntry	(LCDB.unColorLookupTable20.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable21	(LCDB.unColorLookupTable21.u32Register)
#define LCDB_ColorLookupTable21_ClutEntry	(LCDB.unColorLookupTable21.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable22	(LCDB.unColorLookupTable22.u32Register)
#define LCDB_ColorLookupTable22_ClutEntry	(LCDB.unColorLookupTable22.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable23	(LCDB.unColorLookupTable23.u32Register)
#define LCDB_ColorLookupTable23_ClutEntry	(LCDB.unColorLookupTable23.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable24	(LCDB.unColorLookupTable24.u32Register)
#define LCDB_ColorLookupTable24_ClutEntry	(LCDB.unColorLookupTable24.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable25	(LCDB.unColorLookupTable25.u32Register)
#define LCDB_ColorLookupTable25_ClutEntry	(LCDB.unColorLookupTable25.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable26	(LCDB.unColorLookupTable26.u32Register)
#define LCDB_ColorLookupTable26_ClutEntry	(LCDB.unColorLookupTable26.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable27	(LCDB.unColorLookupTable27.u32Register)
#define LCDB_ColorLookupTable27_ClutEntry	(LCDB.unColorLookupTable27.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable28	(LCDB.unColorLookupTable28.u32Register)
#define LCDB_ColorLookupTable28_ClutEntry	(LCDB.unColorLookupTable28.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable29	(LCDB.unColorLookupTable29.u32Register)
#define LCDB_ColorLookupTable29_ClutEntry	(LCDB.unColorLookupTable29.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable30	(LCDB.unColorLookupTable30.u32Register)
#define LCDB_ColorLookupTable30_ClutEntry	(LCDB.unColorLookupTable30.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable31	(LCDB.unColorLookupTable31.u32Register)
#define LCDB_ColorLookupTable31_ClutEntry	(LCDB.unColorLookupTable31.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable32	(LCDB.unColorLookupTable32.u32Register)
#define LCDB_ColorLookupTable32_ClutEntry	(LCDB.unColorLookupTable32.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable33	(LCDB.unColorLookupTable33.u32Register)
#define LCDB_ColorLookupTable33_ClutEntry	(LCDB.unColorLookupTable33.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable34	(LCDB.unColorLookupTable34.u32Register)
#define LCDB_ColorLookupTable34_ClutEntry	(LCDB.unColorLookupTable34.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable35	(LCDB.unColorLookupTable35.u32Register)
#define LCDB_ColorLookupTable35_ClutEntry	(LCDB.unColorLookupTable35.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable36	(LCDB.unColorLookupTable36.u32Register)
#define LCDB_ColorLookupTable36_ClutEntry	(LCDB.unColorLookupTable36.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable37	(LCDB.unColorLookupTable37.u32Register)
#define LCDB_ColorLookupTable37_ClutEntry	(LCDB.unColorLookupTable37.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable38	(LCDB.unColorLookupTable38.u32Register)
#define LCDB_ColorLookupTable38_ClutEntry	(LCDB.unColorLookupTable38.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable39	(LCDB.unColorLookupTable39.u32Register)
#define LCDB_ColorLookupTable39_ClutEntry	(LCDB.unColorLookupTable39.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable40	(LCDB.unColorLookupTable40.u32Register)
#define LCDB_ColorLookupTable40_ClutEntry	(LCDB.unColorLookupTable40.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable41	(LCDB.unColorLookupTable41.u32Register)
#define LCDB_ColorLookupTable41_ClutEntry	(LCDB.unColorLookupTable41.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable42	(LCDB.unColorLookupTable42.u32Register)
#define LCDB_ColorLookupTable42_ClutEntry	(LCDB.unColorLookupTable42.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable43	(LCDB.unColorLookupTable43.u32Register)
#define LCDB_ColorLookupTable43_ClutEntry	(LCDB.unColorLookupTable43.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable44	(LCDB.unColorLookupTable44.u32Register)
#define LCDB_ColorLookupTable44_ClutEntry	(LCDB.unColorLookupTable44.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable45	(LCDB.unColorLookupTable45.u32Register)
#define LCDB_ColorLookupTable45_ClutEntry	(LCDB.unColorLookupTable45.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable46	(LCDB.unColorLookupTable46.u32Register)
#define LCDB_ColorLookupTable46_ClutEntry	(LCDB.unColorLookupTable46.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable47	(LCDB.unColorLookupTable47.u32Register)
#define LCDB_ColorLookupTable47_ClutEntry	(LCDB.unColorLookupTable47.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable48	(LCDB.unColorLookupTable48.u32Register)
#define LCDB_ColorLookupTable48_ClutEntry	(LCDB.unColorLookupTable48.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable49	(LCDB.unColorLookupTable49.u32Register)
#define LCDB_ColorLookupTable49_ClutEntry	(LCDB.unColorLookupTable49.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable50	(LCDB.unColorLookupTable50.u32Register)
#define LCDB_ColorLookupTable50_ClutEntry	(LCDB.unColorLookupTable50.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable51	(LCDB.unColorLookupTable51.u32Register)
#define LCDB_ColorLookupTable51_ClutEntry	(LCDB.unColorLookupTable51.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable52	(LCDB.unColorLookupTable52.u32Register)
#define LCDB_ColorLookupTable52_ClutEntry	(LCDB.unColorLookupTable52.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable53	(LCDB.unColorLookupTable53.u32Register)
#define LCDB_ColorLookupTable53_ClutEntry	(LCDB.unColorLookupTable53.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable54	(LCDB.unColorLookupTable54.u32Register)
#define LCDB_ColorLookupTable54_ClutEntry	(LCDB.unColorLookupTable54.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable55	(LCDB.unColorLookupTable55.u32Register)
#define LCDB_ColorLookupTable55_ClutEntry	(LCDB.unColorLookupTable55.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable56	(LCDB.unColorLookupTable56.u32Register)
#define LCDB_ColorLookupTable56_ClutEntry	(LCDB.unColorLookupTable56.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable57	(LCDB.unColorLookupTable57.u32Register)
#define LCDB_ColorLookupTable57_ClutEntry	(LCDB.unColorLookupTable57.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable58	(LCDB.unColorLookupTable58.u32Register)
#define LCDB_ColorLookupTable58_ClutEntry	(LCDB.unColorLookupTable58.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable59	(LCDB.unColorLookupTable59.u32Register)
#define LCDB_ColorLookupTable59_ClutEntry	(LCDB.unColorLookupTable59.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable60	(LCDB.unColorLookupTable60.u32Register)
#define LCDB_ColorLookupTable60_ClutEntry	(LCDB.unColorLookupTable60.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable61	(LCDB.unColorLookupTable61.u32Register)
#define LCDB_ColorLookupTable61_ClutEntry	(LCDB.unColorLookupTable61.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable62	(LCDB.unColorLookupTable62.u32Register)
#define LCDB_ColorLookupTable62_ClutEntry	(LCDB.unColorLookupTable62.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable63	(LCDB.unColorLookupTable63.u32Register)
#define LCDB_ColorLookupTable63_ClutEntry	(LCDB.unColorLookupTable63.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable64	(LCDB.unColorLookupTable64.u32Register)
#define LCDB_ColorLookupTable64_ClutEntry	(LCDB.unColorLookupTable64.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable65	(LCDB.unColorLookupTable65.u32Register)
#define LCDB_ColorLookupTable65_ClutEntry	(LCDB.unColorLookupTable65.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable66	(LCDB.unColorLookupTable66.u32Register)
#define LCDB_ColorLookupTable66_ClutEntry	(LCDB.unColorLookupTable66.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable67	(LCDB.unColorLookupTable67.u32Register)
#define LCDB_ColorLookupTable67_ClutEntry	(LCDB.unColorLookupTable67.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable68	(LCDB.unColorLookupTable68.u32Register)
#define LCDB_ColorLookupTable68_ClutEntry	(LCDB.unColorLookupTable68.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable69	(LCDB.unColorLookupTable69.u32Register)
#define LCDB_ColorLookupTable69_ClutEntry	(LCDB.unColorLookupTable69.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable70	(LCDB.unColorLookupTable70.u32Register)
#define LCDB_ColorLookupTable70_ClutEntry	(LCDB.unColorLookupTable70.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable71	(LCDB.unColorLookupTable71.u32Register)
#define LCDB_ColorLookupTable71_ClutEntry	(LCDB.unColorLookupTable71.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable72	(LCDB.unColorLookupTable72.u32Register)
#define LCDB_ColorLookupTable72_ClutEntry	(LCDB.unColorLookupTable72.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable73	(LCDB.unColorLookupTable73.u32Register)
#define LCDB_ColorLookupTable73_ClutEntry	(LCDB.unColorLookupTable73.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable74	(LCDB.unColorLookupTable74.u32Register)
#define LCDB_ColorLookupTable74_ClutEntry	(LCDB.unColorLookupTable74.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable75	(LCDB.unColorLookupTable75.u32Register)
#define LCDB_ColorLookupTable75_ClutEntry	(LCDB.unColorLookupTable75.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable76	(LCDB.unColorLookupTable76.u32Register)
#define LCDB_ColorLookupTable76_ClutEntry	(LCDB.unColorLookupTable76.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable77	(LCDB.unColorLookupTable77.u32Register)
#define LCDB_ColorLookupTable77_ClutEntry	(LCDB.unColorLookupTable77.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable78	(LCDB.unColorLookupTable78.u32Register)
#define LCDB_ColorLookupTable78_ClutEntry	(LCDB.unColorLookupTable78.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable79	(LCDB.unColorLookupTable79.u32Register)
#define LCDB_ColorLookupTable79_ClutEntry	(LCDB.unColorLookupTable79.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable80	(LCDB.unColorLookupTable80.u32Register)
#define LCDB_ColorLookupTable80_ClutEntry	(LCDB.unColorLookupTable80.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable81	(LCDB.unColorLookupTable81.u32Register)
#define LCDB_ColorLookupTable81_ClutEntry	(LCDB.unColorLookupTable81.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable82	(LCDB.unColorLookupTable82.u32Register)
#define LCDB_ColorLookupTable82_ClutEntry	(LCDB.unColorLookupTable82.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable83	(LCDB.unColorLookupTable83.u32Register)
#define LCDB_ColorLookupTable83_ClutEntry	(LCDB.unColorLookupTable83.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable84	(LCDB.unColorLookupTable84.u32Register)
#define LCDB_ColorLookupTable84_ClutEntry	(LCDB.unColorLookupTable84.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable85	(LCDB.unColorLookupTable85.u32Register)
#define LCDB_ColorLookupTable85_ClutEntry	(LCDB.unColorLookupTable85.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable86	(LCDB.unColorLookupTable86.u32Register)
#define LCDB_ColorLookupTable86_ClutEntry	(LCDB.unColorLookupTable86.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable87	(LCDB.unColorLookupTable87.u32Register)
#define LCDB_ColorLookupTable87_ClutEntry	(LCDB.unColorLookupTable87.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable88	(LCDB.unColorLookupTable88.u32Register)
#define LCDB_ColorLookupTable88_ClutEntry	(LCDB.unColorLookupTable88.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable89	(LCDB.unColorLookupTable89.u32Register)
#define LCDB_ColorLookupTable89_ClutEntry	(LCDB.unColorLookupTable89.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable90	(LCDB.unColorLookupTable90.u32Register)
#define LCDB_ColorLookupTable90_ClutEntry	(LCDB.unColorLookupTable90.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable91	(LCDB.unColorLookupTable91.u32Register)
#define LCDB_ColorLookupTable91_ClutEntry	(LCDB.unColorLookupTable91.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable92	(LCDB.unColorLookupTable92.u32Register)
#define LCDB_ColorLookupTable92_ClutEntry	(LCDB.unColorLookupTable92.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable93	(LCDB.unColorLookupTable93.u32Register)
#define LCDB_ColorLookupTable93_ClutEntry	(LCDB.unColorLookupTable93.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable94	(LCDB.unColorLookupTable94.u32Register)
#define LCDB_ColorLookupTable94_ClutEntry	(LCDB.unColorLookupTable94.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable95	(LCDB.unColorLookupTable95.u32Register)
#define LCDB_ColorLookupTable95_ClutEntry	(LCDB.unColorLookupTable95.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable96	(LCDB.unColorLookupTable96.u32Register)
#define LCDB_ColorLookupTable96_ClutEntry	(LCDB.unColorLookupTable96.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable97	(LCDB.unColorLookupTable97.u32Register)
#define LCDB_ColorLookupTable97_ClutEntry	(LCDB.unColorLookupTable97.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable98	(LCDB.unColorLookupTable98.u32Register)
#define LCDB_ColorLookupTable98_ClutEntry	(LCDB.unColorLookupTable98.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable99	(LCDB.unColorLookupTable99.u32Register)
#define LCDB_ColorLookupTable99_ClutEntry	(LCDB.unColorLookupTable99.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable100	(LCDB.unColorLookupTable100.u32Register)
#define LCDB_ColorLookupTable100_ClutEntry	(LCDB.unColorLookupTable100.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable101	(LCDB.unColorLookupTable101.u32Register)
#define LCDB_ColorLookupTable101_ClutEntry	(LCDB.unColorLookupTable101.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable102	(LCDB.unColorLookupTable102.u32Register)
#define LCDB_ColorLookupTable102_ClutEntry	(LCDB.unColorLookupTable102.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable103	(LCDB.unColorLookupTable103.u32Register)
#define LCDB_ColorLookupTable103_ClutEntry	(LCDB.unColorLookupTable103.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable104	(LCDB.unColorLookupTable104.u32Register)
#define LCDB_ColorLookupTable104_ClutEntry	(LCDB.unColorLookupTable104.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable105	(LCDB.unColorLookupTable105.u32Register)
#define LCDB_ColorLookupTable105_ClutEntry	(LCDB.unColorLookupTable105.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable106	(LCDB.unColorLookupTable106.u32Register)
#define LCDB_ColorLookupTable106_ClutEntry	(LCDB.unColorLookupTable106.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable107	(LCDB.unColorLookupTable107.u32Register)
#define LCDB_ColorLookupTable107_ClutEntry	(LCDB.unColorLookupTable107.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable108	(LCDB.unColorLookupTable108.u32Register)
#define LCDB_ColorLookupTable108_ClutEntry	(LCDB.unColorLookupTable108.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable109	(LCDB.unColorLookupTable109.u32Register)
#define LCDB_ColorLookupTable109_ClutEntry	(LCDB.unColorLookupTable109.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable110	(LCDB.unColorLookupTable110.u32Register)
#define LCDB_ColorLookupTable110_ClutEntry	(LCDB.unColorLookupTable110.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable111	(LCDB.unColorLookupTable111.u32Register)
#define LCDB_ColorLookupTable111_ClutEntry	(LCDB.unColorLookupTable111.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable112	(LCDB.unColorLookupTable112.u32Register)
#define LCDB_ColorLookupTable112_ClutEntry	(LCDB.unColorLookupTable112.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable113	(LCDB.unColorLookupTable113.u32Register)
#define LCDB_ColorLookupTable113_ClutEntry	(LCDB.unColorLookupTable113.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable114	(LCDB.unColorLookupTable114.u32Register)
#define LCDB_ColorLookupTable114_ClutEntry	(LCDB.unColorLookupTable114.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable115	(LCDB.unColorLookupTable115.u32Register)
#define LCDB_ColorLookupTable115_ClutEntry	(LCDB.unColorLookupTable115.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable116	(LCDB.unColorLookupTable116.u32Register)
#define LCDB_ColorLookupTable116_ClutEntry	(LCDB.unColorLookupTable116.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable117	(LCDB.unColorLookupTable117.u32Register)
#define LCDB_ColorLookupTable117_ClutEntry	(LCDB.unColorLookupTable117.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable118	(LCDB.unColorLookupTable118.u32Register)
#define LCDB_ColorLookupTable118_ClutEntry	(LCDB.unColorLookupTable118.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable119	(LCDB.unColorLookupTable119.u32Register)
#define LCDB_ColorLookupTable119_ClutEntry	(LCDB.unColorLookupTable119.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable120	(LCDB.unColorLookupTable120.u32Register)
#define LCDB_ColorLookupTable120_ClutEntry	(LCDB.unColorLookupTable120.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable121	(LCDB.unColorLookupTable121.u32Register)
#define LCDB_ColorLookupTable121_ClutEntry	(LCDB.unColorLookupTable121.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable122	(LCDB.unColorLookupTable122.u32Register)
#define LCDB_ColorLookupTable122_ClutEntry	(LCDB.unColorLookupTable122.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable123	(LCDB.unColorLookupTable123.u32Register)
#define LCDB_ColorLookupTable123_ClutEntry	(LCDB.unColorLookupTable123.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable124	(LCDB.unColorLookupTable124.u32Register)
#define LCDB_ColorLookupTable124_ClutEntry	(LCDB.unColorLookupTable124.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable125	(LCDB.unColorLookupTable125.u32Register)
#define LCDB_ColorLookupTable125_ClutEntry	(LCDB.unColorLookupTable125.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable126	(LCDB.unColorLookupTable126.u32Register)
#define LCDB_ColorLookupTable126_ClutEntry	(LCDB.unColorLookupTable126.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable127	(LCDB.unColorLookupTable127.u32Register)
#define LCDB_ColorLookupTable127_ClutEntry	(LCDB.unColorLookupTable127.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable128	(LCDB.unColorLookupTable128.u32Register)
#define LCDB_ColorLookupTable128_ClutEntry	(LCDB.unColorLookupTable128.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable129	(LCDB.unColorLookupTable129.u32Register)
#define LCDB_ColorLookupTable129_ClutEntry	(LCDB.unColorLookupTable129.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable130	(LCDB.unColorLookupTable130.u32Register)
#define LCDB_ColorLookupTable130_ClutEntry	(LCDB.unColorLookupTable130.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable131	(LCDB.unColorLookupTable131.u32Register)
#define LCDB_ColorLookupTable131_ClutEntry	(LCDB.unColorLookupTable131.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable132	(LCDB.unColorLookupTable132.u32Register)
#define LCDB_ColorLookupTable132_ClutEntry	(LCDB.unColorLookupTable132.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable133	(LCDB.unColorLookupTable133.u32Register)
#define LCDB_ColorLookupTable133_ClutEntry	(LCDB.unColorLookupTable133.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable134	(LCDB.unColorLookupTable134.u32Register)
#define LCDB_ColorLookupTable134_ClutEntry	(LCDB.unColorLookupTable134.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable135	(LCDB.unColorLookupTable135.u32Register)
#define LCDB_ColorLookupTable135_ClutEntry	(LCDB.unColorLookupTable135.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable136	(LCDB.unColorLookupTable136.u32Register)
#define LCDB_ColorLookupTable136_ClutEntry	(LCDB.unColorLookupTable136.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable137	(LCDB.unColorLookupTable137.u32Register)
#define LCDB_ColorLookupTable137_ClutEntry	(LCDB.unColorLookupTable137.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable138	(LCDB.unColorLookupTable138.u32Register)
#define LCDB_ColorLookupTable138_ClutEntry	(LCDB.unColorLookupTable138.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable139	(LCDB.unColorLookupTable139.u32Register)
#define LCDB_ColorLookupTable139_ClutEntry	(LCDB.unColorLookupTable139.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable140	(LCDB.unColorLookupTable140.u32Register)
#define LCDB_ColorLookupTable140_ClutEntry	(LCDB.unColorLookupTable140.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable141	(LCDB.unColorLookupTable141.u32Register)
#define LCDB_ColorLookupTable141_ClutEntry	(LCDB.unColorLookupTable141.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable142	(LCDB.unColorLookupTable142.u32Register)
#define LCDB_ColorLookupTable142_ClutEntry	(LCDB.unColorLookupTable142.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable143	(LCDB.unColorLookupTable143.u32Register)
#define LCDB_ColorLookupTable143_ClutEntry	(LCDB.unColorLookupTable143.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable144	(LCDB.unColorLookupTable144.u32Register)
#define LCDB_ColorLookupTable144_ClutEntry	(LCDB.unColorLookupTable144.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable145	(LCDB.unColorLookupTable145.u32Register)
#define LCDB_ColorLookupTable145_ClutEntry	(LCDB.unColorLookupTable145.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable146	(LCDB.unColorLookupTable146.u32Register)
#define LCDB_ColorLookupTable146_ClutEntry	(LCDB.unColorLookupTable146.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable147	(LCDB.unColorLookupTable147.u32Register)
#define LCDB_ColorLookupTable147_ClutEntry	(LCDB.unColorLookupTable147.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable148	(LCDB.unColorLookupTable148.u32Register)
#define LCDB_ColorLookupTable148_ClutEntry	(LCDB.unColorLookupTable148.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable149	(LCDB.unColorLookupTable149.u32Register)
#define LCDB_ColorLookupTable149_ClutEntry	(LCDB.unColorLookupTable149.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable150	(LCDB.unColorLookupTable150.u32Register)
#define LCDB_ColorLookupTable150_ClutEntry	(LCDB.unColorLookupTable150.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable151	(LCDB.unColorLookupTable151.u32Register)
#define LCDB_ColorLookupTable151_ClutEntry	(LCDB.unColorLookupTable151.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable152	(LCDB.unColorLookupTable152.u32Register)
#define LCDB_ColorLookupTable152_ClutEntry	(LCDB.unColorLookupTable152.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable153	(LCDB.unColorLookupTable153.u32Register)
#define LCDB_ColorLookupTable153_ClutEntry	(LCDB.unColorLookupTable153.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable154	(LCDB.unColorLookupTable154.u32Register)
#define LCDB_ColorLookupTable154_ClutEntry	(LCDB.unColorLookupTable154.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable155	(LCDB.unColorLookupTable155.u32Register)
#define LCDB_ColorLookupTable155_ClutEntry	(LCDB.unColorLookupTable155.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable156	(LCDB.unColorLookupTable156.u32Register)
#define LCDB_ColorLookupTable156_ClutEntry	(LCDB.unColorLookupTable156.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable157	(LCDB.unColorLookupTable157.u32Register)
#define LCDB_ColorLookupTable157_ClutEntry	(LCDB.unColorLookupTable157.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable158	(LCDB.unColorLookupTable158.u32Register)
#define LCDB_ColorLookupTable158_ClutEntry	(LCDB.unColorLookupTable158.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable159	(LCDB.unColorLookupTable159.u32Register)
#define LCDB_ColorLookupTable159_ClutEntry	(LCDB.unColorLookupTable159.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable160	(LCDB.unColorLookupTable160.u32Register)
#define LCDB_ColorLookupTable160_ClutEntry	(LCDB.unColorLookupTable160.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable161	(LCDB.unColorLookupTable161.u32Register)
#define LCDB_ColorLookupTable161_ClutEntry	(LCDB.unColorLookupTable161.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable162	(LCDB.unColorLookupTable162.u32Register)
#define LCDB_ColorLookupTable162_ClutEntry	(LCDB.unColorLookupTable162.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable163	(LCDB.unColorLookupTable163.u32Register)
#define LCDB_ColorLookupTable163_ClutEntry	(LCDB.unColorLookupTable163.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable164	(LCDB.unColorLookupTable164.u32Register)
#define LCDB_ColorLookupTable164_ClutEntry	(LCDB.unColorLookupTable164.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable165	(LCDB.unColorLookupTable165.u32Register)
#define LCDB_ColorLookupTable165_ClutEntry	(LCDB.unColorLookupTable165.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable166	(LCDB.unColorLookupTable166.u32Register)
#define LCDB_ColorLookupTable166_ClutEntry	(LCDB.unColorLookupTable166.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable167	(LCDB.unColorLookupTable167.u32Register)
#define LCDB_ColorLookupTable167_ClutEntry	(LCDB.unColorLookupTable167.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable168	(LCDB.unColorLookupTable168.u32Register)
#define LCDB_ColorLookupTable168_ClutEntry	(LCDB.unColorLookupTable168.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable169	(LCDB.unColorLookupTable169.u32Register)
#define LCDB_ColorLookupTable169_ClutEntry	(LCDB.unColorLookupTable169.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable170	(LCDB.unColorLookupTable170.u32Register)
#define LCDB_ColorLookupTable170_ClutEntry	(LCDB.unColorLookupTable170.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable171	(LCDB.unColorLookupTable171.u32Register)
#define LCDB_ColorLookupTable171_ClutEntry	(LCDB.unColorLookupTable171.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable172	(LCDB.unColorLookupTable172.u32Register)
#define LCDB_ColorLookupTable172_ClutEntry	(LCDB.unColorLookupTable172.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable173	(LCDB.unColorLookupTable173.u32Register)
#define LCDB_ColorLookupTable173_ClutEntry	(LCDB.unColorLookupTable173.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable174	(LCDB.unColorLookupTable174.u32Register)
#define LCDB_ColorLookupTable174_ClutEntry	(LCDB.unColorLookupTable174.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable175	(LCDB.unColorLookupTable175.u32Register)
#define LCDB_ColorLookupTable175_ClutEntry	(LCDB.unColorLookupTable175.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable176	(LCDB.unColorLookupTable176.u32Register)
#define LCDB_ColorLookupTable176_ClutEntry	(LCDB.unColorLookupTable176.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable177	(LCDB.unColorLookupTable177.u32Register)
#define LCDB_ColorLookupTable177_ClutEntry	(LCDB.unColorLookupTable177.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable178	(LCDB.unColorLookupTable178.u32Register)
#define LCDB_ColorLookupTable178_ClutEntry	(LCDB.unColorLookupTable178.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable179	(LCDB.unColorLookupTable179.u32Register)
#define LCDB_ColorLookupTable179_ClutEntry	(LCDB.unColorLookupTable179.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable180	(LCDB.unColorLookupTable180.u32Register)
#define LCDB_ColorLookupTable180_ClutEntry	(LCDB.unColorLookupTable180.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable181	(LCDB.unColorLookupTable181.u32Register)
#define LCDB_ColorLookupTable181_ClutEntry	(LCDB.unColorLookupTable181.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable182	(LCDB.unColorLookupTable182.u32Register)
#define LCDB_ColorLookupTable182_ClutEntry	(LCDB.unColorLookupTable182.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable183	(LCDB.unColorLookupTable183.u32Register)
#define LCDB_ColorLookupTable183_ClutEntry	(LCDB.unColorLookupTable183.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable184	(LCDB.unColorLookupTable184.u32Register)
#define LCDB_ColorLookupTable184_ClutEntry	(LCDB.unColorLookupTable184.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable185	(LCDB.unColorLookupTable185.u32Register)
#define LCDB_ColorLookupTable185_ClutEntry	(LCDB.unColorLookupTable185.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable186	(LCDB.unColorLookupTable186.u32Register)
#define LCDB_ColorLookupTable186_ClutEntry	(LCDB.unColorLookupTable186.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable187	(LCDB.unColorLookupTable187.u32Register)
#define LCDB_ColorLookupTable187_ClutEntry	(LCDB.unColorLookupTable187.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable188	(LCDB.unColorLookupTable188.u32Register)
#define LCDB_ColorLookupTable188_ClutEntry	(LCDB.unColorLookupTable188.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable189	(LCDB.unColorLookupTable189.u32Register)
#define LCDB_ColorLookupTable189_ClutEntry	(LCDB.unColorLookupTable189.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable190	(LCDB.unColorLookupTable190.u32Register)
#define LCDB_ColorLookupTable190_ClutEntry	(LCDB.unColorLookupTable190.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable191	(LCDB.unColorLookupTable191.u32Register)
#define LCDB_ColorLookupTable191_ClutEntry	(LCDB.unColorLookupTable191.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable192	(LCDB.unColorLookupTable192.u32Register)
#define LCDB_ColorLookupTable192_ClutEntry	(LCDB.unColorLookupTable192.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable193	(LCDB.unColorLookupTable193.u32Register)
#define LCDB_ColorLookupTable193_ClutEntry	(LCDB.unColorLookupTable193.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable194	(LCDB.unColorLookupTable194.u32Register)
#define LCDB_ColorLookupTable194_ClutEntry	(LCDB.unColorLookupTable194.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable195	(LCDB.unColorLookupTable195.u32Register)
#define LCDB_ColorLookupTable195_ClutEntry	(LCDB.unColorLookupTable195.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable196	(LCDB.unColorLookupTable196.u32Register)
#define LCDB_ColorLookupTable196_ClutEntry	(LCDB.unColorLookupTable196.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable197	(LCDB.unColorLookupTable197.u32Register)
#define LCDB_ColorLookupTable197_ClutEntry	(LCDB.unColorLookupTable197.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable198	(LCDB.unColorLookupTable198.u32Register)
#define LCDB_ColorLookupTable198_ClutEntry	(LCDB.unColorLookupTable198.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable199	(LCDB.unColorLookupTable199.u32Register)
#define LCDB_ColorLookupTable199_ClutEntry	(LCDB.unColorLookupTable199.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable200	(LCDB.unColorLookupTable200.u32Register)
#define LCDB_ColorLookupTable200_ClutEntry	(LCDB.unColorLookupTable200.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable201	(LCDB.unColorLookupTable201.u32Register)
#define LCDB_ColorLookupTable201_ClutEntry	(LCDB.unColorLookupTable201.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable202	(LCDB.unColorLookupTable202.u32Register)
#define LCDB_ColorLookupTable202_ClutEntry	(LCDB.unColorLookupTable202.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable203	(LCDB.unColorLookupTable203.u32Register)
#define LCDB_ColorLookupTable203_ClutEntry	(LCDB.unColorLookupTable203.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable204	(LCDB.unColorLookupTable204.u32Register)
#define LCDB_ColorLookupTable204_ClutEntry	(LCDB.unColorLookupTable204.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable205	(LCDB.unColorLookupTable205.u32Register)
#define LCDB_ColorLookupTable205_ClutEntry	(LCDB.unColorLookupTable205.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable206	(LCDB.unColorLookupTable206.u32Register)
#define LCDB_ColorLookupTable206_ClutEntry	(LCDB.unColorLookupTable206.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable207	(LCDB.unColorLookupTable207.u32Register)
#define LCDB_ColorLookupTable207_ClutEntry	(LCDB.unColorLookupTable207.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable208	(LCDB.unColorLookupTable208.u32Register)
#define LCDB_ColorLookupTable208_ClutEntry	(LCDB.unColorLookupTable208.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable209	(LCDB.unColorLookupTable209.u32Register)
#define LCDB_ColorLookupTable209_ClutEntry	(LCDB.unColorLookupTable209.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable210	(LCDB.unColorLookupTable210.u32Register)
#define LCDB_ColorLookupTable210_ClutEntry	(LCDB.unColorLookupTable210.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable211	(LCDB.unColorLookupTable211.u32Register)
#define LCDB_ColorLookupTable211_ClutEntry	(LCDB.unColorLookupTable211.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable212	(LCDB.unColorLookupTable212.u32Register)
#define LCDB_ColorLookupTable212_ClutEntry	(LCDB.unColorLookupTable212.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable213	(LCDB.unColorLookupTable213.u32Register)
#define LCDB_ColorLookupTable213_ClutEntry	(LCDB.unColorLookupTable213.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable214	(LCDB.unColorLookupTable214.u32Register)
#define LCDB_ColorLookupTable214_ClutEntry	(LCDB.unColorLookupTable214.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable215	(LCDB.unColorLookupTable215.u32Register)
#define LCDB_ColorLookupTable215_ClutEntry	(LCDB.unColorLookupTable215.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable216	(LCDB.unColorLookupTable216.u32Register)
#define LCDB_ColorLookupTable216_ClutEntry	(LCDB.unColorLookupTable216.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable217	(LCDB.unColorLookupTable217.u32Register)
#define LCDB_ColorLookupTable217_ClutEntry	(LCDB.unColorLookupTable217.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable218	(LCDB.unColorLookupTable218.u32Register)
#define LCDB_ColorLookupTable218_ClutEntry	(LCDB.unColorLookupTable218.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable219	(LCDB.unColorLookupTable219.u32Register)
#define LCDB_ColorLookupTable219_ClutEntry	(LCDB.unColorLookupTable219.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable220	(LCDB.unColorLookupTable220.u32Register)
#define LCDB_ColorLookupTable220_ClutEntry	(LCDB.unColorLookupTable220.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable221	(LCDB.unColorLookupTable221.u32Register)
#define LCDB_ColorLookupTable221_ClutEntry	(LCDB.unColorLookupTable221.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable222	(LCDB.unColorLookupTable222.u32Register)
#define LCDB_ColorLookupTable222_ClutEntry	(LCDB.unColorLookupTable222.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable223	(LCDB.unColorLookupTable223.u32Register)
#define LCDB_ColorLookupTable223_ClutEntry	(LCDB.unColorLookupTable223.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable224	(LCDB.unColorLookupTable224.u32Register)
#define LCDB_ColorLookupTable224_ClutEntry	(LCDB.unColorLookupTable224.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable225	(LCDB.unColorLookupTable225.u32Register)
#define LCDB_ColorLookupTable225_ClutEntry	(LCDB.unColorLookupTable225.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable226	(LCDB.unColorLookupTable226.u32Register)
#define LCDB_ColorLookupTable226_ClutEntry	(LCDB.unColorLookupTable226.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable227	(LCDB.unColorLookupTable227.u32Register)
#define LCDB_ColorLookupTable227_ClutEntry	(LCDB.unColorLookupTable227.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable228	(LCDB.unColorLookupTable228.u32Register)
#define LCDB_ColorLookupTable228_ClutEntry	(LCDB.unColorLookupTable228.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable229	(LCDB.unColorLookupTable229.u32Register)
#define LCDB_ColorLookupTable229_ClutEntry	(LCDB.unColorLookupTable229.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable230	(LCDB.unColorLookupTable230.u32Register)
#define LCDB_ColorLookupTable230_ClutEntry	(LCDB.unColorLookupTable230.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable231	(LCDB.unColorLookupTable231.u32Register)
#define LCDB_ColorLookupTable231_ClutEntry	(LCDB.unColorLookupTable231.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable232	(LCDB.unColorLookupTable232.u32Register)
#define LCDB_ColorLookupTable232_ClutEntry	(LCDB.unColorLookupTable232.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable233	(LCDB.unColorLookupTable233.u32Register)
#define LCDB_ColorLookupTable233_ClutEntry	(LCDB.unColorLookupTable233.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable234	(LCDB.unColorLookupTable234.u32Register)
#define LCDB_ColorLookupTable234_ClutEntry	(LCDB.unColorLookupTable234.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable235	(LCDB.unColorLookupTable235.u32Register)
#define LCDB_ColorLookupTable235_ClutEntry	(LCDB.unColorLookupTable235.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable236	(LCDB.unColorLookupTable236.u32Register)
#define LCDB_ColorLookupTable236_ClutEntry	(LCDB.unColorLookupTable236.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable237	(LCDB.unColorLookupTable237.u32Register)
#define LCDB_ColorLookupTable237_ClutEntry	(LCDB.unColorLookupTable237.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable238	(LCDB.unColorLookupTable238.u32Register)
#define LCDB_ColorLookupTable238_ClutEntry	(LCDB.unColorLookupTable238.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable239	(LCDB.unColorLookupTable239.u32Register)
#define LCDB_ColorLookupTable239_ClutEntry	(LCDB.unColorLookupTable239.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable240	(LCDB.unColorLookupTable240.u32Register)
#define LCDB_ColorLookupTable240_ClutEntry	(LCDB.unColorLookupTable240.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable241	(LCDB.unColorLookupTable241.u32Register)
#define LCDB_ColorLookupTable241_ClutEntry	(LCDB.unColorLookupTable241.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable242	(LCDB.unColorLookupTable242.u32Register)
#define LCDB_ColorLookupTable242_ClutEntry	(LCDB.unColorLookupTable242.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable243	(LCDB.unColorLookupTable243.u32Register)
#define LCDB_ColorLookupTable243_ClutEntry	(LCDB.unColorLookupTable243.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable244	(LCDB.unColorLookupTable244.u32Register)
#define LCDB_ColorLookupTable244_ClutEntry	(LCDB.unColorLookupTable244.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable245	(LCDB.unColorLookupTable245.u32Register)
#define LCDB_ColorLookupTable245_ClutEntry	(LCDB.unColorLookupTable245.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable246	(LCDB.unColorLookupTable246.u32Register)
#define LCDB_ColorLookupTable246_ClutEntry	(LCDB.unColorLookupTable246.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable247	(LCDB.unColorLookupTable247.u32Register)
#define LCDB_ColorLookupTable247_ClutEntry	(LCDB.unColorLookupTable247.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable248	(LCDB.unColorLookupTable248.u32Register)
#define LCDB_ColorLookupTable248_ClutEntry	(LCDB.unColorLookupTable248.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable249	(LCDB.unColorLookupTable249.u32Register)
#define LCDB_ColorLookupTable249_ClutEntry	(LCDB.unColorLookupTable249.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable250	(LCDB.unColorLookupTable250.u32Register)
#define LCDB_ColorLookupTable250_ClutEntry	(LCDB.unColorLookupTable250.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable251	(LCDB.unColorLookupTable251.u32Register)
#define LCDB_ColorLookupTable251_ClutEntry	(LCDB.unColorLookupTable251.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable252	(LCDB.unColorLookupTable252.u32Register)
#define LCDB_ColorLookupTable252_ClutEntry	(LCDB.unColorLookupTable252.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable253	(LCDB.unColorLookupTable253.u32Register)
#define LCDB_ColorLookupTable253_ClutEntry	(LCDB.unColorLookupTable253.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable254	(LCDB.unColorLookupTable254.u32Register)
#define LCDB_ColorLookupTable254_ClutEntry	(LCDB.unColorLookupTable254.stcField.u18ClutEntry)
#define LCDB_ColorLookupTable255	(LCDB.unColorLookupTable255.u32Register)
#define LCDB_ColorLookupTable255_ClutEntry	(LCDB.unColorLookupTable255.stcField.u18ClutEntry)
typedef struct stc_lcdb_colorlookuptable0_field{
    uint_io32_t		u18ClutEntry:18;
    uint_io32_t		:14;
}stc_lcdb_colorlookuptable0_field_t;

typedef union un_lcdb_colorlookuptable0{
    uint_io32_t		u32Register;
    stc_lcdb_colorlookuptable0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_colorlookuptable0_t;

typedef struct stc_lcdb{
    un_lcdb_lockunlocklcd_t	unLockUnlockLcd;	/* 0x00000000 */
    un_lcdb_lockstatuslcd_t	unLockStatusLcd;	/* 0x00000004 */
    un_lcdb_ipidentifier_t	unIPIdentifier;	/* 0x00000008 */
    un_lcdb_interfaceconfig_t	unInterfaceConfig;	/* 0x0000000C */
    un_lcdb_writetimingconfig_t	unWriteTimingConfig;	/* 0x00000010 */
    un_lcdb_readtimingconfig_t	unReadTimingConfig;	/* 0x00000014 */
    un_lcdb_commandtransfermapping0_t	unCommandTransferMapping0;	/* 0x00000018 */
    un_lcdb_commandtransfermapping1_t	unCommandTransferMapping1;	/* 0x0000001C */
    un_lcdb_commandtransfermapping2_t	unCommandTransferMapping2;	/* 0x00000020 */
    un_lcdb_datatransfermapping0_t	unDataTransferMapping0;	/* 0x00000024 */
    un_lcdb_datatransfermapping1_t	unDataTransferMapping1;	/* 0x00000028 */
    un_lcdb_datatransfermapping2_t	unDataTransferMapping2;	/* 0x0000002C */
    un_lcdb_colorcomponentbits_t	unColorComponentBits;	/* 0x00000030 */
    un_lcdb_colorcomponentshift_t	unColorComponentShift;	/* 0x00000034 */
    un_lcdb_destinationattributes_t	unDestinationAttributes;	/* 0x00000038 */
    uint_io8_t	au8Reserved0[68];	/* 0x0000003C */
    un_lcdb_lockunlockcontrol_t	unLockUnlockControl;	/* 0x00000080 */
    un_lcdb_lockstatuscontrol_t	unLockStatusControl;	/* 0x00000084 */
    un_lcdb_interruptenable_t	unInterruptEnable;	/* 0x00000088 */
    un_lcdb_interruptpreset_t	unInterruptPreset;	/* 0x0000008C */
    un_lcdb_interruptclear_t	unInterruptClear;	/* 0x00000090 */
    un_lcdb_interruptstatus_t	unInterruptStatus;	/* 0x00000094 */
    un_lcdb_sequencerconfig_t	unSequencerConfig;	/* 0x00000098 */
    un_lcdb_instructionfifoconfig_t	unInstructionFifoConfig;	/* 0x0000009C */
    un_lcdb_readchannelconfig_t	unReadChannelConfig;	/* 0x000000A0 */
    un_lcdb_readchannelbuffer_t	unReadChannelBuffer;	/* 0x000000A4 */
    un_lcdb_readchannelcontrol_t	unReadChannelControl;	/* 0x000000A8 */
    un_lcdb_writechannelconfig_t	unWriteChannelConfig;	/* 0x000000AC */
    un_lcdb_writechannelbuffer_t	unWriteChannelBuffer;	/* 0x000000B0 */
    un_lcdb_softwarereset_t	unSoftwareReset;	/* 0x000000B4 */
    un_lcdb_sequencersync_t	unSequencerSync;	/* 0x000000B8 */
    un_lcdb_sequencerstatus_t	unSequencerStatus;	/* 0x000000BC */
    un_lcdb_sequencertransferstatus_t	unSequencerTransferStatus;	/* 0x000000C0 */
    un_lcdb_instrfifostatus_t	unInstrFifoStatus;	/* 0x000000C4 */
    un_lcdb_readchannelstatus_t	unReadChannelStatus;	/* 0x000000C8 */
    un_lcdb_writechannelstatus_t	unWriteChannelStatus;	/* 0x000000CC */
    uint_io8_t	au8Reserved1[48];	/* 0x000000D0 */
    un_lcdb_lockunlockfifo_t	unLockUnlockFifo;	/* 0x00000100 */
    un_lcdb_lockstatusfifo_t	unLockStatusFifo;	/* 0x00000104 */
    un_lcdb_receptionfifoconfig_t	unReceptionFifoConfig;	/* 0x00000108 */
    un_lcdb_rxfifocontrol_t	unRxFifoControl;	/* 0x0000010C */
    un_lcdb_rxfifostatus_t	unRxFifoStatus;	/* 0x00000110 */
    uint_io8_t	au8Reserved2[236];	/* 0x00000114 */
    un_lcdb_instructionfifo0_t	unInstructionFifo0;	/* 0x00000200 */
    un_lcdb_instructionfifo0_t	unInstructionFifo1;	/* 0x00000204 */
    un_lcdb_instructionfifo0_t	unInstructionFifo2;	/* 0x00000208 */
    un_lcdb_instructionfifo0_t	unInstructionFifo3;	/* 0x0000020C */
    un_lcdb_instructionfifo0_t	unInstructionFifo4;	/* 0x00000210 */
    un_lcdb_instructionfifo0_t	unInstructionFifo5;	/* 0x00000214 */
    un_lcdb_instructionfifo0_t	unInstructionFifo6;	/* 0x00000218 */
    un_lcdb_instructionfifo0_t	unInstructionFifo7;	/* 0x0000021C */
    un_lcdb_instructionfifo0_t	unInstructionFifo8;	/* 0x00000220 */
    un_lcdb_instructionfifo0_t	unInstructionFifo9;	/* 0x00000224 */
    un_lcdb_instructionfifo0_t	unInstructionFifo10;	/* 0x00000228 */
    un_lcdb_instructionfifo0_t	unInstructionFifo11;	/* 0x0000022C */
    un_lcdb_instructionfifo0_t	unInstructionFifo12;	/* 0x00000230 */
    un_lcdb_instructionfifo0_t	unInstructionFifo13;	/* 0x00000234 */
    un_lcdb_instructionfifo0_t	unInstructionFifo14;	/* 0x00000238 */
    un_lcdb_instructionfifo0_t	unInstructionFifo15;	/* 0x0000023C */
    un_lcdb_instructionfifo0_t	unInstructionFifo16;	/* 0x00000240 */
    un_lcdb_instructionfifo0_t	unInstructionFifo17;	/* 0x00000244 */
    un_lcdb_instructionfifo0_t	unInstructionFifo18;	/* 0x00000248 */
    un_lcdb_instructionfifo0_t	unInstructionFifo19;	/* 0x0000024C */
    un_lcdb_instructionfifo0_t	unInstructionFifo20;	/* 0x00000250 */
    un_lcdb_instructionfifo0_t	unInstructionFifo21;	/* 0x00000254 */
    un_lcdb_instructionfifo0_t	unInstructionFifo22;	/* 0x00000258 */
    un_lcdb_instructionfifo0_t	unInstructionFifo23;	/* 0x0000025C */
    un_lcdb_instructionfifo0_t	unInstructionFifo24;	/* 0x00000260 */
    un_lcdb_instructionfifo0_t	unInstructionFifo25;	/* 0x00000264 */
    un_lcdb_instructionfifo0_t	unInstructionFifo26;	/* 0x00000268 */
    un_lcdb_instructionfifo0_t	unInstructionFifo27;	/* 0x0000026C */
    un_lcdb_instructionfifo0_t	unInstructionFifo28;	/* 0x00000270 */
    un_lcdb_instructionfifo0_t	unInstructionFifo29;	/* 0x00000274 */
    un_lcdb_instructionfifo0_t	unInstructionFifo30;	/* 0x00000278 */
    un_lcdb_instructionfifo0_t	unInstructionFifo31;	/* 0x0000027C */
    uint_io8_t	au8Reserved3[128];	/* 0x00000280 */
    un_lcdb_rxfifo0_t	unRxFifo0;	/* 0x00000300 */
    un_lcdb_rxfifo0_t	unRxFifo1;	/* 0x00000304 */
    un_lcdb_rxfifo0_t	unRxFifo2;	/* 0x00000308 */
    un_lcdb_rxfifo0_t	unRxFifo3;	/* 0x0000030C */
    un_lcdb_rxfifo0_t	unRxFifo4;	/* 0x00000310 */
    un_lcdb_rxfifo0_t	unRxFifo5;	/* 0x00000314 */
    un_lcdb_rxfifo0_t	unRxFifo6;	/* 0x00000318 */
    un_lcdb_rxfifo0_t	unRxFifo7;	/* 0x0000031C */
    un_lcdb_rxfifo0_t	unRxFifo8;	/* 0x00000320 */
    un_lcdb_rxfifo0_t	unRxFifo9;	/* 0x00000324 */
    un_lcdb_rxfifo0_t	unRxFifo10;	/* 0x00000328 */
    un_lcdb_rxfifo0_t	unRxFifo11;	/* 0x0000032C */
    un_lcdb_rxfifo0_t	unRxFifo12;	/* 0x00000330 */
    un_lcdb_rxfifo0_t	unRxFifo13;	/* 0x00000334 */
    un_lcdb_rxfifo0_t	unRxFifo14;	/* 0x00000338 */
    un_lcdb_rxfifo0_t	unRxFifo15;	/* 0x0000033C */
    uint_io8_t	au8Reserved4[192];	/* 0x00000340 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable0;	/* 0x00000400 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable1;	/* 0x00000404 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable2;	/* 0x00000408 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable3;	/* 0x0000040C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable4;	/* 0x00000410 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable5;	/* 0x00000414 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable6;	/* 0x00000418 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable7;	/* 0x0000041C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable8;	/* 0x00000420 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable9;	/* 0x00000424 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable10;	/* 0x00000428 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable11;	/* 0x0000042C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable12;	/* 0x00000430 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable13;	/* 0x00000434 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable14;	/* 0x00000438 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable15;	/* 0x0000043C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable16;	/* 0x00000440 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable17;	/* 0x00000444 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable18;	/* 0x00000448 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable19;	/* 0x0000044C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable20;	/* 0x00000450 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable21;	/* 0x00000454 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable22;	/* 0x00000458 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable23;	/* 0x0000045C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable24;	/* 0x00000460 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable25;	/* 0x00000464 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable26;	/* 0x00000468 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable27;	/* 0x0000046C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable28;	/* 0x00000470 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable29;	/* 0x00000474 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable30;	/* 0x00000478 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable31;	/* 0x0000047C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable32;	/* 0x00000480 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable33;	/* 0x00000484 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable34;	/* 0x00000488 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable35;	/* 0x0000048C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable36;	/* 0x00000490 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable37;	/* 0x00000494 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable38;	/* 0x00000498 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable39;	/* 0x0000049C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable40;	/* 0x000004A0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable41;	/* 0x000004A4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable42;	/* 0x000004A8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable43;	/* 0x000004AC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable44;	/* 0x000004B0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable45;	/* 0x000004B4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable46;	/* 0x000004B8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable47;	/* 0x000004BC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable48;	/* 0x000004C0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable49;	/* 0x000004C4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable50;	/* 0x000004C8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable51;	/* 0x000004CC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable52;	/* 0x000004D0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable53;	/* 0x000004D4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable54;	/* 0x000004D8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable55;	/* 0x000004DC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable56;	/* 0x000004E0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable57;	/* 0x000004E4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable58;	/* 0x000004E8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable59;	/* 0x000004EC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable60;	/* 0x000004F0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable61;	/* 0x000004F4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable62;	/* 0x000004F8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable63;	/* 0x000004FC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable64;	/* 0x00000500 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable65;	/* 0x00000504 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable66;	/* 0x00000508 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable67;	/* 0x0000050C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable68;	/* 0x00000510 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable69;	/* 0x00000514 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable70;	/* 0x00000518 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable71;	/* 0x0000051C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable72;	/* 0x00000520 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable73;	/* 0x00000524 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable74;	/* 0x00000528 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable75;	/* 0x0000052C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable76;	/* 0x00000530 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable77;	/* 0x00000534 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable78;	/* 0x00000538 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable79;	/* 0x0000053C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable80;	/* 0x00000540 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable81;	/* 0x00000544 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable82;	/* 0x00000548 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable83;	/* 0x0000054C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable84;	/* 0x00000550 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable85;	/* 0x00000554 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable86;	/* 0x00000558 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable87;	/* 0x0000055C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable88;	/* 0x00000560 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable89;	/* 0x00000564 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable90;	/* 0x00000568 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable91;	/* 0x0000056C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable92;	/* 0x00000570 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable93;	/* 0x00000574 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable94;	/* 0x00000578 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable95;	/* 0x0000057C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable96;	/* 0x00000580 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable97;	/* 0x00000584 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable98;	/* 0x00000588 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable99;	/* 0x0000058C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable100;	/* 0x00000590 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable101;	/* 0x00000594 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable102;	/* 0x00000598 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable103;	/* 0x0000059C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable104;	/* 0x000005A0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable105;	/* 0x000005A4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable106;	/* 0x000005A8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable107;	/* 0x000005AC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable108;	/* 0x000005B0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable109;	/* 0x000005B4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable110;	/* 0x000005B8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable111;	/* 0x000005BC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable112;	/* 0x000005C0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable113;	/* 0x000005C4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable114;	/* 0x000005C8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable115;	/* 0x000005CC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable116;	/* 0x000005D0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable117;	/* 0x000005D4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable118;	/* 0x000005D8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable119;	/* 0x000005DC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable120;	/* 0x000005E0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable121;	/* 0x000005E4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable122;	/* 0x000005E8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable123;	/* 0x000005EC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable124;	/* 0x000005F0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable125;	/* 0x000005F4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable126;	/* 0x000005F8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable127;	/* 0x000005FC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable128;	/* 0x00000600 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable129;	/* 0x00000604 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable130;	/* 0x00000608 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable131;	/* 0x0000060C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable132;	/* 0x00000610 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable133;	/* 0x00000614 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable134;	/* 0x00000618 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable135;	/* 0x0000061C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable136;	/* 0x00000620 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable137;	/* 0x00000624 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable138;	/* 0x00000628 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable139;	/* 0x0000062C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable140;	/* 0x00000630 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable141;	/* 0x00000634 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable142;	/* 0x00000638 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable143;	/* 0x0000063C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable144;	/* 0x00000640 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable145;	/* 0x00000644 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable146;	/* 0x00000648 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable147;	/* 0x0000064C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable148;	/* 0x00000650 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable149;	/* 0x00000654 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable150;	/* 0x00000658 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable151;	/* 0x0000065C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable152;	/* 0x00000660 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable153;	/* 0x00000664 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable154;	/* 0x00000668 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable155;	/* 0x0000066C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable156;	/* 0x00000670 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable157;	/* 0x00000674 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable158;	/* 0x00000678 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable159;	/* 0x0000067C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable160;	/* 0x00000680 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable161;	/* 0x00000684 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable162;	/* 0x00000688 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable163;	/* 0x0000068C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable164;	/* 0x00000690 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable165;	/* 0x00000694 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable166;	/* 0x00000698 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable167;	/* 0x0000069C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable168;	/* 0x000006A0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable169;	/* 0x000006A4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable170;	/* 0x000006A8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable171;	/* 0x000006AC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable172;	/* 0x000006B0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable173;	/* 0x000006B4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable174;	/* 0x000006B8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable175;	/* 0x000006BC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable176;	/* 0x000006C0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable177;	/* 0x000006C4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable178;	/* 0x000006C8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable179;	/* 0x000006CC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable180;	/* 0x000006D0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable181;	/* 0x000006D4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable182;	/* 0x000006D8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable183;	/* 0x000006DC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable184;	/* 0x000006E0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable185;	/* 0x000006E4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable186;	/* 0x000006E8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable187;	/* 0x000006EC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable188;	/* 0x000006F0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable189;	/* 0x000006F4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable190;	/* 0x000006F8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable191;	/* 0x000006FC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable192;	/* 0x00000700 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable193;	/* 0x00000704 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable194;	/* 0x00000708 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable195;	/* 0x0000070C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable196;	/* 0x00000710 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable197;	/* 0x00000714 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable198;	/* 0x00000718 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable199;	/* 0x0000071C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable200;	/* 0x00000720 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable201;	/* 0x00000724 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable202;	/* 0x00000728 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable203;	/* 0x0000072C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable204;	/* 0x00000730 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable205;	/* 0x00000734 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable206;	/* 0x00000738 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable207;	/* 0x0000073C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable208;	/* 0x00000740 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable209;	/* 0x00000744 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable210;	/* 0x00000748 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable211;	/* 0x0000074C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable212;	/* 0x00000750 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable213;	/* 0x00000754 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable214;	/* 0x00000758 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable215;	/* 0x0000075C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable216;	/* 0x00000760 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable217;	/* 0x00000764 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable218;	/* 0x00000768 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable219;	/* 0x0000076C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable220;	/* 0x00000770 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable221;	/* 0x00000774 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable222;	/* 0x00000778 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable223;	/* 0x0000077C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable224;	/* 0x00000780 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable225;	/* 0x00000784 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable226;	/* 0x00000788 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable227;	/* 0x0000078C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable228;	/* 0x00000790 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable229;	/* 0x00000794 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable230;	/* 0x00000798 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable231;	/* 0x0000079C */
    un_lcdb_colorlookuptable0_t	unColorLookupTable232;	/* 0x000007A0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable233;	/* 0x000007A4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable234;	/* 0x000007A8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable235;	/* 0x000007AC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable236;	/* 0x000007B0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable237;	/* 0x000007B4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable238;	/* 0x000007B8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable239;	/* 0x000007BC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable240;	/* 0x000007C0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable241;	/* 0x000007C4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable242;	/* 0x000007C8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable243;	/* 0x000007CC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable244;	/* 0x000007D0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable245;	/* 0x000007D4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable246;	/* 0x000007D8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable247;	/* 0x000007DC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable248;	/* 0x000007E0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable249;	/* 0x000007E4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable250;	/* 0x000007E8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable251;	/* 0x000007EC */
    un_lcdb_colorlookuptable0_t	unColorLookupTable252;	/* 0x000007F0 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable253;	/* 0x000007F4 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable254;	/* 0x000007F8 */
    un_lcdb_colorlookuptable0_t	unColorLookupTable255;	/* 0x000007FC */
}stc_lcdb_t;


#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_lcdb_t	stcLCDB;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 2048(0x800) bytes */


#endif /* __S6J3360_LCDB_H */
