#ifndef API_IOCONFIG_H_
    #define API_IOCONFIG_H_

typedef enum {
    PRO_DN8C,
    PRO_DU2,
}PRO_SELECT;
extern PRO_SELECT ProSelect;
#define         PWMCH_SPEED_OUT         18
#define TEST_PRO_ODO 0
#define TEST_PRO_BACK_LIGHT 0
#define TEST_PRO_SOUND_VOLUM 0
#define TEST_PRO_LVDS 0

//按键 start
extern en_port_gpio_level_t BUTTON_S30_IN;
#define GET_BUTTON_S30_LEVEL  Port_GetPortPinLevel(0, 24, &BUTTON_S30_IN)

extern en_port_gpio_level_t BUTTON_S15_IN;
#define GET_BUTTON_S15_LEVEL    Port_GetPortPinLevel(1, 26, &BUTTON_S15_IN)

//extern en_port_gpio_level_t BUTTON_Luminosity_IN;
//#define GET_Luminosity_LEVEL    Port_GetPortPinLevel(2, 9, &BUTTON_Luminosity_IN)

//extern en_port_gpio_level_t BUTTON_Back_light_IN;
//#define GET_BUTTON_Back_light_LEVEL    Port_GetPortPinLevel(2, 11, &BUTTON_Back_light_IN)

extern en_port_gpio_level_t BUTTON_Luminosity_IN;
#define GET_Luminosity_LEVEL    Port_GetPortPinLevel(1, 4, &BUTTON_Luminosity_IN)

extern en_port_gpio_level_t BUTTON_Back_light_IN;
#define GET_BUTTON_Back_light_LEVEL    Port_GetPortPinLevel(2, 11, &BUTTON_Back_light_IN)

extern en_port_gpio_level_t BUTTON_AUTO_IN; 
#define GET_BUTTON_AUTO_LEVEL  Port_GetPortPinLevel(1, 27, &BUTTON_AUTO_IN)

extern en_port_gpio_level_t BUTTON_EOL_IN;
#define GET_BUTTON_EOL_LEVEL  Port_GetPortPinLevel(0, 5, &BUTTON_EOL_IN)

extern en_port_gpio_level_t BUTTON_SPEED_UP_IN;
#define GET_BUTTON_SPEED_UP_LEVEL    Port_GetPortPinLevel(1, 29, &BUTTON_SPEED_UP_IN)

extern en_port_gpio_level_t BUTTON_SPEED_DOWN_IN;
#define GET_BUTTON_SPEED_DOWN_LEVEL  Port_GetPortPinLevel(1, 30, &BUTTON_SPEED_DOWN_IN)

extern en_port_gpio_level_t BUTTON_LED_IN;
#define GET_BUTTON_LED_LEVEL  Port_GetPortPinLevel(1, 28, &BUTTON_LED_IN)

extern en_port_gpio_level_t BUTTON_IOL_UP_IN;
#define GET_BUTTON_IOL_UP_LEVEL  Port_GetPortPinLevel(1, 31, &BUTTON_IOL_UP_IN)

extern en_port_gpio_level_t BUTTON_IOL_DOWN_IN;
#define GET_BUTTON_IOL_DOWN_LEVEL  Port_GetPortPinLevel(0, 9, &BUTTON_IOL_DOWN_IN)

extern en_port_gpio_level_t BUTTON_TFT_UP_IN;
#define GET_BUTTON_TFT_UP_LEVEL  Port_GetPortPinLevel(0, 1, &BUTTON_TFT_UP_IN)

extern en_port_gpio_level_t BUTTON_TFT_DOWN_IN;
#define GET_BUTTON_TFT_DOWN_LEVEL  Port_GetPortPinLevel(0, 2, &BUTTON_TFT_DOWN_IN)

extern en_port_gpio_level_t BUTTON_ELSE_IN;
#define GET_BUTTON_ELSE_LEVEL  Port_GetPortPinLevel(0, 3, &BUTTON_ELSE_IN)

extern en_port_gpio_level_t BUTTON_END_IN;
#define GET_BUTTON_END_LEVEL  Port_GetPortPinLevel(0, 4, &BUTTON_END_IN)
//按键 end

//档位 start

extern en_port_gpio_level_t BUTTON_S_IN;
#define GET_BUTTON_S_LEVEL  Port_GetPortPinLevel(1, 23, &BUTTON_S_IN)

extern en_port_gpio_level_t BUTTON_D_IN;
#define GET_BUTTON_D_LEVEL  Port_GetPortPinLevel(1, 22, &BUTTON_D_IN)

extern en_port_gpio_level_t BUTTON_N_IN;
#define GET_BUTTON_N_LEVEL  Port_GetPortPinLevel(1, 21, &BUTTON_N_IN)

extern en_port_gpio_level_t BUTTON_R_IN;
#define GET_BUTTON_R_LEVEL  Port_GetPortPinLevel(1, 20, &BUTTON_R_IN)

extern en_port_gpio_level_t BUTTON_P_IN;
#define GET_BUTTON_P_LEVEL  Port_GetPortPinLevel(1, 19, &BUTTON_P_IN)

extern en_port_gpio_level_t BUTTON_DETENT_IN;
#define GET_BUTTON_DETENT_LEVEL  Port_GetPortPinLevel(1, 6, &BUTTON_DETENT_IN)

//档位 end

extern en_port_gpio_level_t BUTTON_SEATBELT_IN;
#define GET_BUTTON_SEATBELT_LEVEL  Port_GetPortPinLevel(1, 13, &BUTTON_SEATBELT_IN) // 副驾驶安全带信息

extern en_port_gpio_level_t BUTTON_ALTL_IN;
#define GET_BUTTON_ALTL_LEVEL  Port_GetPortPinLevel(1, 11, &BUTTON_ALTL_IN) //电池

// extern en_port_gpio_level_t BUTTON_BackLigth_IN;
// #define GET_BUTTON_BackLight_LEVEL  Port_GetPortPinLevel(1, 15, &BUTTON_BackLigth_IN) //ILL

extern en_port_gpio_level_t BUTTON_GND_Signal3_IN;
#define GET_BUTTON_GND_Signal3_LEVEL Port_GetPortPinLevel(0, 17, &BUTTON_GND_Signal3_IN)

// extern en_port_gpio_level_t BUTTON_EngRun_IN;
// #define GET_BUTTON_EngRun_LEVEL Port_GetPortPinLevel(1, 10, &BUTTON_EngRun_IN)

//extern en_port_gpio_level_t BUTTON_HOODOPEN_IN;
//#define GET_BUTTON_HOODOPEN_LEVEL  Port_GetPortPinLevel(2, 19, &BUTTON_HOODOPEN_IN)



//#define F_LCD_RESET(Level)     Port_SetPortPinLevel(1, 29, (Level))
//#define F_LCD_STBYB(Level)     Port_SetPortPinLevel(0, 4, (Level))
#define P_61194_EN(Level)      Port_SetPortPinLevel(2, 13, (Level))
#define P_3V3MCU_EN(Level)     Port_SetPortPinLevel(1, 4, (Level))
#define P_APOWER_OUT(Level)    Port_SetPortPinLevel(1, 19, (Level))
#define P_78324_EN(Level)      Port_SetPortPinLevel(0, 30, (Level))
#define F_Sound_EN(Level)      Port_SetPortPinLevel(0, 31, (Level))
//#define NEW_F_Sound_EN(Level)  Port_SetPortPinLevel(1, 24, (Level))
//#define P_VCC4V2_EN(Level)     Port_SetPortPinLevel(0, 1, (Level))
//#define P_BD12_EN(Level)       Port_SetPortPinLevel(0, 5, (Level))
//#define P_949ALL_EN(Level)     Port_SetPortPinLevel(0, 0, (Level))
#define P_1531_EN(Level)       Port_SetPortPinLevel(2, 03, (Level))
//#define P_TPA6211_EN(Level)    Port_SetPortPinLevel(1, 24, (Level))

#define FUEL_IN_EN(Level)      Port_SetPortPinLevel( 2, 12, (Level));

#define R_OUT(Level)     Port_SetPortPinLevel(2, 14, (Level))
#define N_OUT(Level)     Port_SetPortPinLevel(2, 27, (Level))
#if (CAN_2ND)
#define CAN0_STB(Level) Port_SetPortPinLevel(0, 29, (Level))
#define CAN1_STB(Level) Port_SetPortPinLevel(1, 22, PortGpioHigh)
#endif
#if (CAN_3RD)
#define CAN0_STB(Level) Port_SetPortPinLevel(0, 29, PortGpioLow)
#define CAN1_STB(Level) Port_SetPortPinLevel(1, 2, PortGpioLow)
#endif
#define CAN1_EN(Level) Port_SetPortPinLevel(1, 21, PortGpioHigh)

extern en_port_gpio_level_t Can1Rx_IN;
#define GET_CAN1_RX_IN_LEVEL  Port_GetPortPinLevel(0, 27, &Can1Rx_IN)

#define  LINE_LampLowON                          Port_SetPortPinLevel(2,5,PortGpioHigh)
#define  LINE_LampLowOFF                         Port_SetPortPinLevel(2,5,PortGpioLow)

#define  LINE_LampHighON                          Port_SetPortPinLevel(2,0,PortGpioHigh)
#define  LINE_LampHighOFF                         Port_SetPortPinLevel(2,0,PortGpioLow)

#define  LINE_weizhiON                          Port_SetPortPinLevel(1,25,PortGpioHigh)
#define  LINE_weizhiOFF                         Port_SetPortPinLevel(1,25,PortGpioLow)

#define  LINE_TurnLeftON                          Port_SetPortPinLevel(2,27,PortGpioLow)
#define  LINE_TurnLeftOFF                         Port_SetPortPinLevel(2,27,PortGpioHigh)

#define  LINE_TurnRightON                          Port_SetPortPinLevel(2,29,PortGpioLow)
#define  LINE_TurnRightOFF                         Port_SetPortPinLevel(2,29,PortGpioHigh)

#define  LINE_ABSON                          Port_SetPortPinLevel(1,24,PortGpioHigh)
#define  LINE_ABSOFF                         Port_SetPortPinLevel(1,24,PortGpioLow)

#define  LINE_BLEON                          Port_SetPortPinLevel(1,24,PortGpioHigh)
#define  LINE_BLEOFF                         Port_SetPortPinLevel(1,24,PortGpioLow)
extern void Api_GPIO_Init(void);
extern void Line_Temp(void);

#endif /* API_IOCONFIG_H_ */
//
