

#ifdef GLOBALS_APP_TEST
#define EXTERN_APP_TEST

#else
#define EXTERN_APP_TEST extern
#endif

#ifndef APP_TEDT_H_
#define APP_TEDT_H_

#define Motorola 0
#define Intel 1

#define Offset_Minus 0
#define Offset_Plus 1

#define Value_Minus 0
#define Value_Plus 1

typedef struct
{
    int val;
    unsigned char fval;
} s_CurValue;

typedef struct
{
    CAN_message *canMsg;
    unsigned char StartByte;
    unsigned char StartBit;
    unsigned char SignalLen;
    unsigned int Offset;
    unsigned char fOffset;
    unsigned int Factor_1; /*Denominator of Resolution*/ /*���ȵķ�ĸ*/
    unsigned int Factor_2; /*Numerator of Resolution*/   /*���ȵķ���*/
    s_CurValue *CurValue;
    unsigned char fFormat;
} s_CAN_List;

enum
{
    ENUM_VSpeed = 0, // ����
    ECM_FaultIndicator,
    ECM_StautsInvalid,
    ECM_MotorOver,
    ECM_ReadyIndicator,
    ECM_ChargeStatus,
    ECM_CruiseStatus,
    ECM_GearPositionStatus,
    PFC_Relag,                    
    LLC_UnderOutput,              
    LLC_OverOutput,               
    LLC_OutPut,                   
    PFC_LLC_Interal_Communication,
    LLC_Temp,                     
    Battery_status,
    Battery_Current,
    Battery_SOC,    
    CAN_List_Num,
};

EXTERN_APP_TEST volatile s_CurValue CurValueStr[CAN_List_Num];

static const s_CAN_List CAN_List[] =
{
    {&CanMsg_101, 2, 0, 16,0,Offset_Plus, 1, 1, &CurValueStr[ENUM_VSpeed                    ], Motorola},
    {&CanMsg_067, 2, 0, 16, 0,Offset_Plus, 1, 1, &CurValueStr[ECM_FaultIndicator            ], Motorola},
    {&CanMsg_067, 3, 0, 2, 0, Offset_Plus, 1, 1, &CurValueStr[ECM_StautsInvalid             ], Motorola},
    {&CanMsg_067, 3, 2, 2, 0, Offset_Plus, 1, 1, &CurValueStr[ECM_MotorOver                 ], Motorola},
    {&CanMsg_067, 3, 4, 1, 0, Offset_Plus, 1, 1, &CurValueStr[ECM_ReadyIndicator            ], Motorola},
    {&CanMsg_067, 3, 6, 1, 0, Offset_Plus, 1, 1, &CurValueStr[ECM_ChargeStatus              ], Motorola},
    {&CanMsg_067, 4, 2, 1, 0, Offset_Plus, 1, 1, &CurValueStr[ECM_CruiseStatus              ], Motorola},
    {&CanMsg_067, 5, 0, 3, 0, Offset_Plus, 1, 1, &CurValueStr[ECM_GearPositionStatus        ], Motorola},
    {&CanMsg_600, 0, 0, 1, 0, Offset_Plus, 1, 1, &CurValueStr[PFC_Relag                     ], Motorola},
    {&CanMsg_600, 0, 1, 1, 0, Offset_Plus, 1, 1, &CurValueStr[LLC_UnderOutput               ], Motorola},
    {&CanMsg_600, 0, 2, 1, 0, Offset_Plus, 1, 1, &CurValueStr[LLC_OverOutput                ], Motorola},
    {&CanMsg_600, 0, 3, 1, 0, Offset_Plus, 1, 1, &CurValueStr[LLC_OutPut                    ], Motorola},
    {&CanMsg_600, 0, 4, 1, 0, Offset_Plus, 1, 1, &CurValueStr[PFC_LLC_Interal_Communication ], Motorola},
    {&CanMsg_600, 0, 5, 1, 0, Offset_Plus, 1, 1, &CurValueStr[LLC_Temp                      ], Motorola},
    {&CanMsg_610, 0, 0, 8, 0, Offset_Plus, 1, 1, &CurValueStr[Battery_status                ], Motorola},
    {&CanMsg_610,2,0, 16,255,Offset_Minus, 10, 1, &CurValueStr[Battery_Current               ], Motorola},
    {&CanMsg_611, 0, 0, 8, 0, Offset_Plus, 1, 1, &CurValueStr[Battery_SOC                   ], Motorola},
};
extern unsigned int Key_Dodging_flag;
extern unsigned int lost_flag;
extern unsigned int CAN_init_flag; 
extern unsigned int water_value;
extern unsigned int count_flag_a;
extern unsigned int speed_value;
EXTERN_APP_TEST void APP_Button_Proc(void);
EXTERN_APP_TEST void Message_Value_Calculate(s_CAN_List list);

void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value); /*Do not span bytes*/

#endif /* API_CAN_H_ */
