#include "r_typedefs.h"
#include "dr7f701684.dvf.h"
#include "GPIO.h"

/*-----------------use for RH850_F1KM_S1 --------------------*/

#define GPIO_STB_PROTECTED_WRITE(preg, pstatus, reg, value) \
    do                                                      \
    {                                                       \
        (preg) = 0xA5U;                                     \
        (reg) = (value);                                    \
        (reg) = ~(value);                                   \
        (reg) = (value);                                    \
    } while ((pstatus) == 1U)

#define GPIO_PORTN_BASE_ADDRESS 0xFFC10000UL

typedef enum
{
    GPIO_REG_PMC = 0U,
    GPIO_REG_PIPC,
    GPIO_REG_PM,
    GPIO_REG_PIBC,
    GPIO_REG_PFC,
    GPIO_REG_PFCE,
    GPIO_REG_PFCAE,
    GPIO_REG_PBDC,
    GPIO_REG_P,
    GPIO_REG_PU,
    GPIO_REG_PD,
    GPIO_REG_PDSC,
    GPIO_REG_PODC,
    GPIO_REG_PIS,
    GPIO_REG_PPCMD,
    GPIO_REG_PPROTS,

} GPIO_Register_en_t;

const uint16_t g_u16GPIOConfigArray[56U][2U] =
{
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0020u, 0x0000u},
    {0x0620u, 0x0600u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0630u, 0x0600u},
    {0x4220u, 0x2207u},
    {0x79CFu, 0x79FFu},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0008u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0003u},
    {0x0000u, 0x0008u},
    {0x0000u, 0x0008u},
    {0x1FFFu, 0x1FF7u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x007Fu, 0x007Fu},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x8800u, 0x0000u},
    {0x8800u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0004u, 0x0200u},
    {0x8800u, 0x0000u},
    {0x8020u, 0x0000u},
    {0x77FFu, 0xFFFFu},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0005u, 0x0000u},
    {0x0005u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0000u},
    {0x0000u, 0x0080u},
    {0x0005u, 0x0000u},
    {0x0001u, 0x0005u},
    {0x00FAu, 0x00FFu},
    {0x8080u, 0x1000u},
    {0x000Fu, 0x673Fu},
    {0xFFFFu, 0xFFFFu},
};
static void GPIO_PIN_Init(GPIO_Config_Mode_en_t enGPIOConfigMode)
{

    PORTPIBC0 = 0X0UL;
    PORTPIBC8 = 0X0UL;
    PORTPIBC9 = 0X0UL;
    PORTPIBC10 = 0X0UL;
    PORTPIBC11 = 0X0UL;
    PORTAPIBC0 = 0X0UL;

    PORTPBDC0 = 0X0UL;
    PORTPBDC8 = 0X0UL;
    PORTPBDC9 = 0X0UL;
    PORTPBDC10 = 0X0UL;
    PORTPBDC11 = 0X0UL;
    PORTAPBDC0 = 0X0UL;

    PORTPM0 = 0XFFFFUL;
    PORTPM8 = 0XFFFFUL;
    PORTPM9 = 0XFFFFUL;
    PORTPM10 = 0XFFFFUL;
    PORTPM11 = 0XFFFFUL;
    PORTAPM0 = 0XFFFFUL;

    PORTPMC0 = 0X0UL;
    PORTPMC8 = 0X0UL;
    PORTPMC9 = 0X0UL;
    PORTPMC10 = 0X0UL;
    PORTPMC11 = 0X0UL;

    PORTPIPC0 = 0X0UL;
    PORTPIPC10 = 0X0UL;
    PORTPIPC11 = 0X0UL;

    PORTPODC0 = 0X0UL;
    PORTPODC8 = 0X0UL;
    PORTPODC9 = 0X0UL;
    PORTPODC10 = 0X0UL;
    PORTPODC11 = 0X0UL;

    /******************************/

    PORTPU0 = g_u16GPIOConfigArray[0U][enGPIOConfigMode];
    PORTPD0 = g_u16GPIOConfigArray[1U][enGPIOConfigMode];
    PORTPIS0 = g_u16GPIOConfigArray[2U][enGPIOConfigMode];
    PORTPFC0 = g_u16GPIOConfigArray[3U][enGPIOConfigMode];
    PORTPFCE0 = g_u16GPIOConfigArray[4U][enGPIOConfigMode];
    PORTPFCAE0 = g_u16GPIOConfigArray[5U][enGPIOConfigMode];
    PORTPIPC0 = g_u16GPIOConfigArray[6U][enGPIOConfigMode];
    PORTP0 = g_u16GPIOConfigArray[7U][enGPIOConfigMode];
    PORTPMC0 = g_u16GPIOConfigArray[8U][enGPIOConfigMode];
    PORTPM0 = g_u16GPIOConfigArray[9U][enGPIOConfigMode];
    PORTPIBC0 = g_u16GPIOConfigArray[10U][enGPIOConfigMode];

    PORTPU8 = g_u16GPIOConfigArray[11U][enGPIOConfigMode];
    PORTPD8 = g_u16GPIOConfigArray[12U][enGPIOConfigMode];
    PORTPIS8 = g_u16GPIOConfigArray[13U][enGPIOConfigMode];
    PORTPFC8 = g_u16GPIOConfigArray[14U][enGPIOConfigMode];
    PORTPFCE8 = g_u16GPIOConfigArray[15U][enGPIOConfigMode];
    PORTPFCAE8 = g_u16GPIOConfigArray[16U][enGPIOConfigMode];
    PORTP8 = g_u16GPIOConfigArray[17U][enGPIOConfigMode];
    PORTPMC8 = g_u16GPIOConfigArray[18U][enGPIOConfigMode];
    PORTPM8 = g_u16GPIOConfigArray[19U][enGPIOConfigMode];
    PORTPIBC8 = g_u16GPIOConfigArray[20U][enGPIOConfigMode];

    PORTPU9 = g_u16GPIOConfigArray[21U][enGPIOConfigMode];
    PORTPD9 = g_u16GPIOConfigArray[22U][enGPIOConfigMode];
    PORTPIS9 = g_u16GPIOConfigArray[23U][enGPIOConfigMode];
    PORTPFC9 = g_u16GPIOConfigArray[24U][enGPIOConfigMode];
    PORTPFCE9 = g_u16GPIOConfigArray[25U][enGPIOConfigMode];
    PORTPFCAE9 = g_u16GPIOConfigArray[26U][enGPIOConfigMode];
    PORTP9 = g_u16GPIOConfigArray[27U][enGPIOConfigMode];
    PORTPMC9 = g_u16GPIOConfigArray[28U][enGPIOConfigMode];
    PORTPM9 = g_u16GPIOConfigArray[29U][enGPIOConfigMode];
    PORTPIBC9 = g_u16GPIOConfigArray[30U][enGPIOConfigMode];

    PORTPU10 = g_u16GPIOConfigArray[31U][enGPIOConfigMode];
    PORTPD10 = g_u16GPIOConfigArray[32U][enGPIOConfigMode];
    PORTPIS10 = g_u16GPIOConfigArray[33U][enGPIOConfigMode];
    PORTPFC10 = g_u16GPIOConfigArray[34U][enGPIOConfigMode];
    PORTPFCE10 = g_u16GPIOConfigArray[35U][enGPIOConfigMode];
    PORTPFCAE10 = g_u16GPIOConfigArray[36U][enGPIOConfigMode];
    PORTPIPC10 = g_u16GPIOConfigArray[37U][enGPIOConfigMode];
    PORTP10 = g_u16GPIOConfigArray[38U][enGPIOConfigMode];
    PORTPMC10 = g_u16GPIOConfigArray[39U][enGPIOConfigMode];
    PORTPM10 = g_u16GPIOConfigArray[40U][enGPIOConfigMode];
    PORTPIBC10 = g_u16GPIOConfigArray[41U][enGPIOConfigMode];

    PORTPU11 = g_u16GPIOConfigArray[42U][enGPIOConfigMode];
    PORTPD11 = g_u16GPIOConfigArray[43U][enGPIOConfigMode];
    PORTPIS11 = g_u16GPIOConfigArray[44U][enGPIOConfigMode];
    PORTPFC11 = g_u16GPIOConfigArray[45U][enGPIOConfigMode];
    PORTPFCE11 = g_u16GPIOConfigArray[46U][enGPIOConfigMode];
    PORTPFCAE11 = g_u16GPIOConfigArray[47U][enGPIOConfigMode];
    PORTPIPC11 = g_u16GPIOConfigArray[48U][enGPIOConfigMode];
    PORTP11 = g_u16GPIOConfigArray[49U][enGPIOConfigMode];
    PORTPMC11 = g_u16GPIOConfigArray[50U][enGPIOConfigMode];
    PORTPM11 = g_u16GPIOConfigArray[51U][enGPIOConfigMode];
    PORTPIBC11 = g_u16GPIOConfigArray[52U][enGPIOConfigMode];

    PORTAP0 = g_u16GPIOConfigArray[53U][enGPIOConfigMode];
    PORTAPM0 = g_u16GPIOConfigArray[54U][enGPIOConfigMode];
    PORTAPIBC0 = g_u16GPIOConfigArray[55U][enGPIOConfigMode];
}

void GPIO_Init(GPIO_Config_Mode_en_t enGPIOConfigMode)
{
    if (enGPIOConfigMode == GPIO_WAKEUP_MODE)
    {
        GPIO_PIN_Init(GPIO_WAKEUP_MODE);
        /*port buffer  exit hold state*/
        GPIO_STB_PROTECTED_WRITE(WPROTRPROTCMD0, WPROTRPROTS0, STBC_IOHOLDIOHOLD, 0x00U);
    }
    else
    {
        GPIO_PIN_Init(GPIO_SLEEP_MODE);
    }
}
static uint32_t GPIO_Get_Wake_Bit(GPIO_Wakeup_PIN_en_t enGPIOWakeupPIN)
{
    uint32_t u32GPIOWakeBit = 0UL;
    switch (enGPIOWakeupPIN)
    {
    case GPIO_WAKEUP_PIN_P0_1:
    {
        u32GPIOWakeBit = 0x20UL;
        break;
    }
    case GPIO_WAKEUP_PIN_P0_2:
    {
        u32GPIOWakeBit = 0x40UL;
        break;
    }
    case GPIO_WAKEUP_PIN_P0_3:
    {
        u32GPIOWakeBit = 0x1000UL;
        break;
    }
    case GPIO_WAKEUP_PIN_P0_4:
    {
        u32GPIOWakeBit = 0x2000UL;
        break;
    }
    /*case GPIO_WAKEUP_PIN_P0_5: */
    case GPIO_WAKEUP_PIN_P0_6:
    {
        u32GPIOWakeBit = 0x80UL;
        break;
    }
    /*case GPIO_WAKEUP_PIN_P0_7: */
    case GPIO_WAKEUP_PIN_P0_10:
    {
        u32GPIOWakeBit = 0x200UL;
        break;
    }
    case GPIO_WAKEUP_PIN_P0_9:
    {
        u32GPIOWakeBit = 0x400UL;
        break;
    }
    case GPIO_WAKEUP_PIN_P0_13:
    {
        u32GPIOWakeBit = 0x800UL;
        break;
    }
    case GPIO_WAKEUP_PIN_P8_2:
    {
        u32GPIOWakeBit = 0x100000UL;
        break;
    }
    case GPIO_WAKEUP_PIN_P8_3:
    {
        u32GPIOWakeBit = 0x200000UL;
        break;
    }
    case GPIO_WAKEUP_PIN_P8_4:
    {
        u32GPIOWakeBit = 0x400000UL;
        break;
    }
    default:
        break;
    }
    return (~u32GPIOWakeBit);
}

void GPIO_Wakeup_PIN_Set(GPIO_Wakeup_PIN_en_t enGPIOWakeupPIN, GPIO_Wakeup_Trigger_Mode_en_t enGPIOTrigger)
{
    uint32_t u32GPIORegisterAddress = 0xFFC34020U + 0X4U * enGPIOWakeupPIN;
    uint32_t u32GPIORegisterValue = GPIO_Get_Wake_Bit(enGPIOWakeupPIN);

    /*trigger type*/
    *(uint8_t *)u32GPIORegisterAddress = enGPIOTrigger;

    /*trigger PIN*/
    STBC_WUF0WUFMSK0 &= u32GPIORegisterValue;
}

static uint32_t GPIO_Register_Address_Cal(GPIO_Port_en_t enGPIOPort, GPIO_Register_en_t enGPIORegister)
{
    uint32_t u32GPIOAddress = 0UL;
    uint32_t u32GPIOAddressBase = GPIO_PORTN_BASE_ADDRESS + enGPIOPort * 4UL;

    switch (enGPIORegister)
    {
    case GPIO_REG_PMC:
    {
        u32GPIOAddress = 0X400UL;
        break;
    }
    case GPIO_REG_PIPC:
    {
        u32GPIOAddress = 0X4200UL;
        break;
    }
    case GPIO_REG_PM:
    {
        u32GPIOAddress = 0x300UL;
        break;
    }
    case GPIO_REG_PIBC:
    {
        u32GPIOAddress = 0x4000UL;
        break;
    }
    case GPIO_REG_PFC:
    {
        u32GPIOAddress = 0X500UL;
        break;
    }
    case GPIO_REG_PFCE:
    {
        u32GPIOAddress = 0X600UL;
        break;
    }
    case GPIO_REG_PFCAE:
    {
        u32GPIOAddress = 0XA00UL;
        break;
    }
    case GPIO_REG_PBDC:
    {
        u32GPIOAddress = 0X4100UL;
        break;
    }
    case GPIO_REG_P:
    {
        u32GPIOAddress = 0X000UL;
        break;
    }
    case GPIO_REG_PU:
    {
        u32GPIOAddress = 0X4300UL;
        break;
    }
    case GPIO_REG_PD:
    {
        u32GPIOAddress = 0X4400UL;
        break;
    }
    case GPIO_REG_PDSC:
    {
        u32GPIOAddress = 0X4600UL;
        break;
    }
    case GPIO_REG_PODC:
    {
        u32GPIOAddress = 0X4500UL;
        break;
    }
    case GPIO_REG_PIS:
    {
        u32GPIOAddress = 0X4700UL;
        break;
    }
    case GPIO_REG_PPCMD:
    {
        u32GPIOAddress = 0X4C00UL;
        break;
    }
    case GPIO_REG_PPROTS:
    {
        u32GPIOAddress = 0X4B00UL;
        break;
    }
    default:
        break;
    }

    u32GPIOAddress += u32GPIOAddressBase;
    return u32GPIOAddress;
}

void GPIO_Config(GPIO_Config_st_t *pstGPIOConfig)
{

    uint32_t u32GPIORegisterAddress = 0UL;
    uint16_t u16GPIORegisterValue = 0U;
    uint32_t u32GPIORegisterAddress2 = 0UL;
    uint16_t u16GPIORegisterValue2 = 0U;
    uint32_t u32GPIORegisterAddress3 = 0UL;
    uint16_t u16GPIORegisterValue3 = 0U;

    uint16_t u16GPIOBitOr = (1U << pstGPIOConfig->enGPIOPIN);
    uint16_t u16GPIOBitAnd = ~u16GPIOBitOr;

    /**********************Port initialization*******************/
    /*******PDSCn**Lower drive strength********/
    /*******PODCn**Push-pull********/
    /*******PBDCn**Bidirectional mode disabled********/
    /*******PDn**PUn**********/
    if (pstGPIOConfig->enGPIOPort != GPIO_PORT_GROUP_AP0)
    {
        u32GPIORegisterAddress = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PU);
        u16GPIORegisterValue = (*((uint16_t *)(u32GPIORegisterAddress)));
        u32GPIORegisterAddress2 = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PD);
        u16GPIORegisterValue2 = (*((uint16_t *)(u32GPIORegisterAddress2)));

        if (pstGPIOConfig->enGPIOPull == GPIO_PULL_UP)
        {
            u16GPIORegisterValue2 &= u16GPIOBitAnd;
            u16GPIORegisterValue |= u16GPIOBitOr;
        }
        else if (pstGPIOConfig->enGPIOPull == GPIO_PULL_DOWN)
        {
            u16GPIORegisterValue &= u16GPIOBitAnd;
            u16GPIORegisterValue2 |= u16GPIOBitOr;
        }
        else /*GPIO_PULL_NONE*/
        {
            u16GPIORegisterValue &= u16GPIOBitAnd;
            u16GPIORegisterValue2 &= u16GPIOBitAnd;
        }
        (*((uint16_t *)(u32GPIORegisterAddress))) = u16GPIORegisterValue;
        (*((uint16_t *)(u32GPIORegisterAddress2))) = u16GPIORegisterValue2;
    }
    /********PISn*********/
    if (pstGPIOConfig->enGPIOPort != GPIO_PORT_GROUP_AP0)
    {
        u32GPIORegisterAddress = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PIS);
        u16GPIORegisterValue = (*((uint16_t *)(u32GPIORegisterAddress)));

        if (pstGPIOConfig->enGPIOCharacter == GPIO_Char_Schmitt1)
        {
            u16GPIORegisterValue &= u16GPIOBitAnd;
        }
        else if (pstGPIOConfig->enGPIOCharacter == GPIO_Char_Schmitt4)
        {
            u16GPIORegisterValue |= u16GPIOBitOr;
        }
        (*((uint16_t *)(u32GPIORegisterAddress))) = u16GPIORegisterValue;
    }
    /******PFCn**PFCEn**PFCAEn*******/
    if (pstGPIOConfig->enGPIOPort != GPIO_PORT_GROUP_AP0)
    {
        u32GPIORegisterAddress = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PFC);
        u16GPIORegisterValue = (*((uint16_t *)(u32GPIORegisterAddress)));
        u32GPIORegisterAddress2 = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PFCE);
        u16GPIORegisterValue2 = (*((uint16_t *)(u32GPIORegisterAddress2)));
        u32GPIORegisterAddress3 = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PFCAE);
        u16GPIORegisterValue3 = (*((uint16_t *)(u32GPIORegisterAddress3)));

        switch (pstGPIOConfig->enGPIOAltFun)
        {
        default:
        case GPIO_ALTER_FUN_1:
        {
            u16GPIORegisterValue &= u16GPIOBitAnd;
            u16GPIORegisterValue2 &= u16GPIOBitAnd;
            u16GPIORegisterValue3 &= u16GPIOBitAnd;
            break;
        }
        case GPIO_ALTER_FUN_2:
        {
            u16GPIORegisterValue |= u16GPIOBitOr;
            u16GPIORegisterValue2 &= u16GPIOBitAnd;
            u16GPIORegisterValue3 &= u16GPIOBitAnd;
            break;
        }
        case GPIO_ALTER_FUN_3:
        {
            u16GPIORegisterValue &= u16GPIOBitAnd;
            u16GPIORegisterValue2 |= u16GPIOBitOr;
            u16GPIORegisterValue3 &= u16GPIOBitAnd;
            break;
        }
        case GPIO_ALTER_FUN_4:
        {
            u16GPIORegisterValue |= u16GPIOBitOr;
            u16GPIORegisterValue2 |= u16GPIOBitOr;
            u16GPIORegisterValue3 &= u16GPIOBitAnd;
            break;
        }
        case GPIO_ALTER_FUN_5:
        {
            u16GPIORegisterValue &= u16GPIOBitAnd;
            u16GPIORegisterValue2 &= u16GPIOBitAnd;
            u16GPIORegisterValue3 |= u16GPIOBitOr;
            break;
        }
        case GPIO_ALTER_FUN_6:
        {
            u16GPIORegisterValue |= u16GPIOBitOr;
            u16GPIORegisterValue2 &= u16GPIOBitAnd;
            u16GPIORegisterValue3 |= u16GPIOBitOr;
            break;
        }
        case GPIO_ALTER_FUN_7:
        {
            u16GPIORegisterValue &= u16GPIOBitAnd;
            u16GPIORegisterValue2 |= u16GPIOBitOr;
            u16GPIORegisterValue3 |= u16GPIOBitOr;
            break;
        }
        }

        (*((uint16_t *)(u32GPIORegisterAddress))) = u16GPIORegisterValue;
        (*((uint16_t *)(u32GPIORegisterAddress2))) = u16GPIORegisterValue2;
        (*((uint16_t *)(u32GPIORegisterAddress3))) = u16GPIORegisterValue3;
    }
    /*******Pn**********/
    u32GPIORegisterAddress = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_P);
    u16GPIORegisterValue = (*((uint16_t *)(u32GPIORegisterAddress)));

    if (pstGPIOConfig->enGPIOOutputValue == GPIO_Level_High)
    {
        u16GPIORegisterValue |= u16GPIOBitOr;
    }
    else
    {
        u16GPIORegisterValue &= u16GPIOBitAnd;
    }

    (*((uint16_t *)(u32GPIORegisterAddress))) = u16GPIORegisterValue;
    /*****PMCn**PIPCn***PIBCn*******/
    u32GPIORegisterAddress = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PMC);
    u16GPIORegisterValue = (*((uint16_t *)(u32GPIORegisterAddress)));
    u32GPIORegisterAddress2 = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PIPC);
    u16GPIORegisterValue2 = (*((uint16_t *)(u32GPIORegisterAddress2)));
    u32GPIORegisterAddress3 = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PIBC);
    u16GPIORegisterValue3 = (*((uint16_t *)(u32GPIORegisterAddress3)));

    if (pstGPIOConfig->enGPIOMode == GPIO_MODE_ALTER_DIRECT)
    {
        u16GPIORegisterValue |= u16GPIOBitOr;
        u16GPIORegisterValue2 |= u16GPIOBitOr;
        u16GPIORegisterValue3 &= u16GPIOBitAnd;
    }
    else if (pstGPIOConfig->enGPIOMode == GPIO_MODE_ALTER_SOFTWARE)
    {
        u16GPIORegisterValue |= u16GPIOBitOr;
        u16GPIORegisterValue2 &= u16GPIOBitAnd;
        u16GPIORegisterValue3 &= u16GPIOBitAnd;
    }
    else /*if (pstGPIOConfig->enGPIOMode==GPIO_MODE_PORT)*/
    {
        u16GPIORegisterValue &= u16GPIOBitAnd;
        u16GPIORegisterValue2 &= u16GPIOBitAnd;
        u16GPIORegisterValue3 |= u16GPIOBitOr;
    }
    if (pstGPIOConfig->enGPIOPort != GPIO_PORT_GROUP_AP0)
    {
        (*((uint16_t *)(u32GPIORegisterAddress))) = u16GPIORegisterValue;
    }
    if ((pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_0) ||
        (pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_10) ||
        (pstGPIOConfig->enGPIOPort == GPIO_PORT_GROUP_11))
    {
        (*((uint16_t *)(u32GPIORegisterAddress2))) = u16GPIORegisterValue2;
    }
    (*((uint16_t *)(u32GPIORegisterAddress3))) = u16GPIORegisterValue3;
    /***************PMn*****************/
    u32GPIORegisterAddress = GPIO_Register_Address_Cal(pstGPIOConfig->enGPIOPort, GPIO_REG_PM);
    u16GPIORegisterValue = (*((uint16_t *)(u32GPIORegisterAddress)));
    if (pstGPIOConfig->enGPIODir == GPIO_DIR_IN)
    {
        u16GPIORegisterValue |= u16GPIOBitOr;
    }
    else
    {
        u16GPIORegisterValue &= u16GPIOBitAnd;
    }
    (*((uint16_t *)(u32GPIORegisterAddress))) = u16GPIORegisterValue;
}
void GPIO_SET_KEPP(void) 
{
    GPIO_STB_PROTECTED_WRITE(WPROTRPROTCMD0, WPROTRPROTS0, STBC_IOHOLDIOHOLD, 0x00U);
}

