#include <string.h>
#include <stdio.h>
#include "../GPIO/GPIO.h"
#include "BSP.h"
#include "rh850_macros.h"
#include "RTE_PWM.h"
#include "..\TimeStamp\TimeStamp.h"
#include "..\UART\UART.h"
#include "..\src.h"
#include "Analog_Signals.h"
#include "..\RIIC\RIIC.h"
#include "RTE_WDT.h"

STimeStampInfo Init_948_time; // 防止拉高中断后下次中断被拉低的时间过短导致主机识别不到
uint32_t current_bl_pwm;      //  当前背光的亮度值

////---------------------------------------------------------------------------
//  清看门狗
void BSP_WDT_Clear(void)
{
    WDT_Clear(); // 清看门狗
}

////---------------------------------------------------------------------------
//  96752 1V电源使能
void BSP_GPIO_96751_1V_EN(int in)
{
    //  使能
    if (in != 0U)
    {
        //  根据电路图，此时需要设置高电平
        GPIO_OUT_PORT09_PIN02 = 1U;
    }
    //  关闭
    else
    {
        //  根据电路图，此时需要设置低电平
        GPIO_OUT_PORT09_PIN02 = 0U;
    }
}

////---------------------------------------------------------------------------
//  96752 1V电源使能
void BSP_GPIO_96751_1V8_EN(int in)
{
    //  使能
    if (in != 0U)
    {
        //  根据电路图，此时需要设置高电平
        GPIO_OUT_PORT09_PIN06 = 1U;
    }
    //  关闭
    else
    {
        //  根据电路图，此时需要设置低电平
        GPIO_OUT_PORT09_PIN06 = 0U;
    }
}

////---------------------------------------------------------------------------
//  屏幕、06752电源使能
void BSP_GPIO_TFT_EN(int in)
{
    //  使能
    if (in != 0U)
    {
        //  根据电路图，此时需要设置高电平
        GPIO_OUT_PORT11_PIN00 = 1U;
    }
    //  关闭
    else
    {
        //  根据电路图，此时需要设置低电平
        GPIO_OUT_PORT11_PIN00 = 0U;
    }
}

////---------------------------------------------------------------------------
//  96751 PDB
void BSP_GPIO_96751_PDB_EN(int in)
{
    //  使能
    if (in != 0U)
    {
        //  根据电路图，此时需要设置高电平
        GPIO_OUT_PORT11_PIN01 = 1U;
    }
    //  关闭
    else
    {
        //  根据电路图，此时需要设置低电平
        GPIO_OUT_PORT11_PIN01 = 0U;
    }
}

//---------------------------------------------------------------------------
// 948_lock检测
int BSP_GPIO_Get_948_lock(void)
{
    int state = 0;
    state = (GPIO_IN_PORT10_PIN10) ? 1 : 0;
    // uart1_printf("[info]state =%d\r\n",state);
    return state;
}

//---------------------------------------------------------------------------
//  1ms定时器中断服务函数
static uint8_t time_count = 1;
void BSP_FTM0_IRQHandler(void)
{
    if (time_count < 20)
    {
        time_count++;
    }
    else
    {
        time_count = 1;
        /*调用时间戳*/
        TimeStamp_TimeCntCallback();
    }
    /*清除定时器中断标志*/
    peripheral_IRQ_flag_clear(INTOSTM0);
}

//---------------------------------------------------------------------------
//  延时指定的ms数
void BSP_Delay_ms(unsigned int in)
{
    //  定义时间戳变量
    STimeStampInfo tmp_time;

    //  复位时间戳对象
    TimeStamp_Reset(&tmp_time);

    //  等待到达时间
    while (TimeStamp_GetCntTime(&tmp_time) < in)
    {
        //  更新时间
        TimeStamp_Update(&tmp_time);
        BSP_WDT_Clear();
    }
}

//---------------------------------------------------------------------------
//  初始化PWM    频率10KHz
void BSP_PWM_Init(void)
{
    PWN_Init();
    // PWM_Channel_Init(9, 0, 0, 0, 0);    //按键背光PWM
    // PWM_Channel_Set_Freq(9, 1200);     //按键背光PWM频率
    // PWM_Channel_Set_Duty(9, 0);         //初始占空比为0

    PWM_Channel_Init(7 ,0, 0, 0, 0); // bl PWM
    PWM_Channel_Set_Freq(7, 1000);   // bl PWM Hz
    PWM_Channel_Set_Duty(7, 500);    // 初始占空比为0
}

//---------------------------------------------------------------------------
//  发送一个字符串
void BSP_SendString(char *pstr)
{
    while ((*pstr) != '\0')
    {
        UART_Ch0_Send_Multiple_Byte((uint8_t *)pstr, 1); /*串口打印函数*/
        while (UART_Ch0_Get_TX_Busy_Flag())
            ; /*等待发送完按成*/
        pstr++;
    }
}

//---------------------------------------------------------------------------
//  串口0的打印
void uart1_printf(char *str, ...)
{
    va_list arg_ptr;
    char s[100];

    va_start(arg_ptr, str);

    memset(s, 0x00, sizeof(s));

    vsprintf(s, str, arg_ptr);
    va_end(arg_ptr);

    //  这里的printf就可以换成自己的字符串打印函数了
    BSP_SendString(s);
}

//---------------------------------------------------------------------------
//  初始化串口
void BSP_InitUSART(void)
{
    /*DEBUG串口初始化结构体*/
    UART_Channel_Config_st_t debug_uart_config;

    /*DEBUG串口初始化*/
    debug_uart_config.u32UARTChEn = 1;     /*通道使能*/
    debug_uart_config.u32UARTbps = 115200; /*通道实际波特率*/
    debug_uart_config.pfnUARTConfirmCallBack = 0;
    debug_uart_config.pfnUARTReadMsgCallBack = 0;
    UART_Init(UART_RLIN30, &debug_uart_config);
}

//---------------------------------------------------------------------------
// //  设置背光亮度 精度千分之一
// void BSP_SetBL_Brightness_PWM(uint32_t in)
// {
//     //  设置屏幕背光亮度   精度千分之一
//     PWM_Channel_Set_Duty(11, in); // 设置屏幕背光占空比
//     //  设置触摸按键背光亮度   精度千分之一
//     // PWM_Channel_Set_Duty(9, in);    //设置触摸按键背光占空比
// }

//---------------------------------------------------------------------------
//  等待I2C1发送结束
void I2C1_Send_End(void)
{
    while (RIIC1_Slave_Send_Flag() != 2)
        ;
    if (RIIC1_Slave_Send_Count() == 2) /*如果上次发送完成，发送了两个字节*/
    {
        RIIC1_Slave_Send_Flag_Reset(); /*清除发送完成标志并等待本次发送完成*/
        while (RIIC1_Slave_Send_Flag() != 2)
            ;
    }
    /*清除发送完成标志*/
    RIIC1_Slave_Send_Flag_Reset();
}

//---------------------------------------------------------------------------
//  I2C0初始化
void BSP_I2C0_INIT(void)
{
    /*I2C初始化结构体*/
    RIIC_Init_st_t i2c_config;
    uint32_t I2C_rate = 0;
    i2c_config.u32RIICBaud = 400000;   /**波特率200k**/
    i2c_config.u32RIICSlaveTxLen = 0;  /*从机模式时，设定的发送长度*/
    i2c_config.pu8RIICSlaveTxData = 0; /*从机模式，发送状态时的指针*/
    i2c_config.u32RIICSlaveRxLen = 0;  /*从机模式时，设定的接收长度*/
    i2c_config.pu8RIICSlaveRxData = 0; /*从机模式，接收状态时的指针*/
    i2c_config.u32RIICSlaveAddr = 0;   /*从机地址*/
    I2C_rate = RIIC0_Init(&i2c_config);
#if BSP_USER_DEBUG >= 2
    uart1_printf(" [info] I2C0 init rate = %d \r\n", I2C_rate);
#endif
}
uint8_t gpio_get_key1(void)
{
    return ((GPIO_IN_PORT09_PIN05) ? 1 : 0);
}

uint8_t gpio_get_key2(void)
{
    return ((GPIO_IN_PORT09_PIN04) ? 1 : 0);
}

uint8_t gpio_get_key3(void)
{
    return ((GPIO_IN_PORT09_PIN01) ? 1 : 0);
}

uint8_t gpio_get_key4(void)
{
    return ((GPIO_IN_PORT09_PIN00) ? 1 : 0);
}
uint8_t gpio_get_key5(void)
{
    return ((GPIO_IN_PORT09_PIN03) ? 1 : 0);
}
uint8_t gpio_get_key6(void)
{
    return ((GPIO_IN_PORT10_PIN02) ? 1 : 0);
}
uint8_t gpio_get_96751_lock(void)
{
    return ((GPIO_IN_PORT10_PIN00) ? 1 : 0);
}

void touch_IRQ_Enable(void)
{
    /*触摸屏回读中断*/
    peripheral_IRQ_enable(INTP2);

    FCLA0CTL2_INTPL = GPIO_WAKEUP_FALLING_EDGE;
}

//---------------------------------------------------------------------------
//  触摸屏外部中断
static volatile uint8_t TOUCH_IRQHandler_flag = 0;
void BSP_TOUCH_IRQHandler(void)
{
    TOUCH_IRQHandler_flag = 1;
    peripheral_IRQ_flag_clear(INTP2);
}

//---------------------------------------------------------------------------
//  返回触摸中断标志
uint8_t GET_TOUCH_IRQHandler_flag(void)
{
    // return TOUCH_IRQHandler_flag;
    return ((GPIO_IN_PORT00_PIN05) ? 1 : 0);
}

//---------------------------------------------------------------------------
//  清除触摸中断标志
void Clear_TOUCH_IRQHandler_flag(void)
{
    TOUCH_IRQHandler_flag = 0;
}

void AIM951_i2c_send(uint8_t addr, uint8_t data)
{
    unsigned char tmp_buf[2];
    /*CONFIG Blance*/
    tmp_buf[0] = addr;
    tmp_buf[1] = data;
    RIIC0_Master_SendMultiByte_Interrupt(BU948_I2C_DEVICE_ID, tmp_buf, 2);
    RIIC0_WaitForBusy_Block();
    BSP_WDT_Clear();
}
void AIM951_i2c_sendreceive(uint8_t sendreceive_addr,uint8_t *receive_data)
{
     unsigned char sendreceive_addr_buf[1];
    sendreceive_addr_buf[0] =sendreceive_addr;   
    RIIC0_Master_SendRecvMultiByte_Interrupt(BU956_I2C_DEVICE_ID, sendreceive_addr_buf, 1, receive_data,1);
    RIIC0_WaitForBusy_Block();
    BSP_WDT_Clear();
}

void switch_951_init(uint8_t work_mode)
{
    if (work_mode == 0)
    {
        AIM951_i2c_send(0xFF, 0x00);
        AIM951_i2c_send(0x08, 0xAC);
        AIM951_i2c_send(0x68, 0x02);
        AIM951_i2c_send(0x04, 0x70);
        AIM951_i2c_send(0xFF, 0x05);
        AIM951_i2c_send(0x1B, 0x00);
        AIM951_i2c_send(0x1F, 0x08);
        AIM951_i2c_send(0xFF, 0x08);
        AIM951_i2c_send(0x88, 0x1F);
        AIM951_i2c_send(0xFF, 0x04);
        AIM951_i2c_send(0x03, 0x50);
        AIM951_i2c_send(0xFF, 0x03);
        AIM951_i2c_send(0x03, 0x50);
        // 1112
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x44, 0x0A);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x50, 0xC0);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x51, 0x30);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x3B, 0x4C);
        BSP_Delay_ms(10);

        // 951 iic mapping
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0E, 0x34);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x16, 0x34);
        BSP_Delay_ms(10);

        // INTB init
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x93, 0x10);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x5C, 0x21);
        BSP_Delay_ms(10);
        // 951 init end
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x04, 0x50);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x3B, 0xCC);

        BSP_Delay_ms(10);
        // 951 patternGen 1920*720P60 1222 mode
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x5F, 0x60);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x84, 0x14);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x8C, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x47, 0x4F);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0xFF, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x07, 0x10);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x08, 0xF8);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x09, 0x82);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0A, 0x80);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0B, 0xD0);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0C, 0x72);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0D, 0x28);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0E, 0x0A);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0F, 0x28);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x10, 0x0A);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x11, 0x03);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x02, 0x44);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x00, 0x05);

        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x31, 0x33);
        BSP_Delay_ms(10);

        GPIO_OUT_PORT08_PIN12 = 1U;
        GPIO_OUT_PORT08_PIN09 = 1U;
    }
    if (work_mode == 1)
    {

        AIM951_i2c_send(0xFF, 0x00);
        AIM951_i2c_send(0x08, 0xAC);
        AIM951_i2c_send(0x68, 0x02);
        AIM951_i2c_send(0x04, 0x70);
        AIM951_i2c_send(0xFF, 0x05);
        AIM951_i2c_send(0x1B, 0x00);
        AIM951_i2c_send(0x1F, 0x08);
        AIM951_i2c_send(0xFF, 0x08);
        AIM951_i2c_send(0x88, 0x1F);
        AIM951_i2c_send(0xFF, 0x04);
        AIM951_i2c_send(0x03, 0x50);
        AIM951_i2c_send(0xFF, 0x03);
        AIM951_i2c_send(0x03, 0x50);
        // 1222
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x44, 0x0B);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x50, 0xC0);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x51, 0xF0);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x3B, 0x4C);
        BSP_Delay_ms(10);

        // 951 iic mapping
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0E, 0x34);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x16, 0x34);
        BSP_Delay_ms(10);

        // intb enable
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x93, 0x10);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x5c, 0x21);
        BSP_Delay_ms(10);

        // 951 init end
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x04, 0x50);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x3B, 0xCC);
        BSP_Delay_ms(10);
        // 951 patternGen 1920*1080P60 1222 mode 纯色
        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x5F, 0x60);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x84, 0x0D);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x8C, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x47, 0x4F);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0xFF, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x07, 0xF8);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x08, 0x5A);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x09, 0x74);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0A, 0x80);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0B, 0x38);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0C, 0x74);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0D, 0x28);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0E, 0x05);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x0F, 0x28);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x10, 0x05);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x11, 0x03);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x02, 0x44);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x00, 0x05);
        BSP_Delay_ms(10);

        AIM951_i2c_send(0xFF, 0x00);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x31, 0x33);
        BSP_Delay_ms(10);

        GPIO_OUT_PORT08_PIN12 = 1U;
        GPIO_OUT_PORT08_PIN09 = 1U;
    }
}

// void switch_951_3G_6G(uint8_t work_mode)
// {
//     AIM951_i2c_send(0xFF, 0x00);
//     AIM951_i2c_send(0x08, 0xAC);
//     AIM951_i2c_send(0x68, 0x02);
//     AIM951_i2c_send(0x04, 0x70);
//     AIM951_i2c_send(0xFF, 0x05);
//     AIM951_i2c_send(0x1B, 0x00);
//     AIM951_i2c_send(0x1F, 0x08);
//     AIM951_i2c_send(0xFF, 0x08);
//     AIM951_i2c_send(0x88, 0x1F);
//     AIM951_i2c_send(0xFF, 0x04);
//     AIM951_i2c_send(0x03, 0x50);
//     AIM951_i2c_send(0xFF, 0x03);
//     AIM951_i2c_send(0x03, 0x50);
//     // 1222
//     if (work_mode == 1)
//     {
//         AIM951_i2c_send(0xFF, 0x00);
//         BSP_Delay_ms(10);
//         AIM951_i2c_send(0x44, 0x0B);
//         BSP_Delay_ms(10);
//         AIM951_i2c_send(0x50, 0xC0);
//         BSP_Delay_ms(10);
//         AIM951_i2c_send(0x51, 0xF0);
//         BSP_Delay_ms(10);
//         AIM951_i2c_send(0x3B, 0x4C);
//         BSP_Delay_ms(10);
//     }
//     //1112
//     else if (work_mode == 2)
//     {
//         AIM951_i2c_send(0xFF, 0x00);
//         BSP_Delay_ms(10);
//         AIM951_i2c_send(0x44, 0x0B);
//         BSP_Delay_ms(10);
//         AIM951_i2c_send(0x50, 0xC0);
//         BSP_Delay_ms(10);
//         AIM951_i2c_send(0x51, 0x30);
//         BSP_Delay_ms(10);
//         AIM951_i2c_send(0x3B, 0x4C);
//         BSP_Delay_ms(10);
//     }

//     AIM951_i2c_send(0xFF, 0x00);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x04, 0x50);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x3B, 0xCC);
//     BSP_Delay_ms(10);

//     // 951 patternGen 1920*720P60 1222 mode 彩条
//     // AIM951_i2c_send(0xFF, 0x00);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x5F, 0x60);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x84, 0x15);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x8C, 0x01);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x47, 0x4F);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0xFF, 0x01);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x07, 0x00);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x08, 0xD9);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x09, 0x82);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x0A, 0x80);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x0B, 0xD0);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x0C, 0x72);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x0D, 0x28);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x0E, 0x02);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x0F, 0x28);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x10, 0x02);
//     // BSP_Delay_ms(10);
//     // AIM951_i2c_send(0x11, 0x03);
//     // BSP_Delay_ms(10);
//     // // AIM951_i2c_send(0x02, 0x44);
//     // // BSP_Delay_ms(10);
//     // // AIM951_i2c_send(0x00, 0x05);
//     // // BSP_Delay_ms(10);

//     // 951 patternGen 1920*1080P60 1222 mode 纯色
//     AIM951_i2c_send(0xFF, 0x00);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x5F, 0x60);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x84, 0x0D);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x8C, 0x01);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x47, 0x4F);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0xFF, 0x01);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x07, 0x20);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x08, 0x5C);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x09, 0x84);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x0A, 0x80);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x0B, 0x38);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x0C, 0x74);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x0D, 0x28);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x0E, 0x02);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x0F, 0x50);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x10, 0x0A);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x11, 0x03);
//     BSP_Delay_ms(10);

//     AIM951_i2c_send(0x02, 0x07);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x00, 0x43);
//     BSP_Delay_ms(10);

//     AIM951_i2c_send(0xFF, 0x00);
//     BSP_Delay_ms(10);
//     AIM951_i2c_send(0x31, 0x33);
//     BSP_Delay_ms(10);

//     GPIO_OUT_PORT08_PIN12 = 1U;
//     GPIO_OUT_PORT08_PIN09 = 1U;
// }

uint8_t auto_color_flag = 1;
uint8_t color_flag = 0;

uint8_t get_auto_color_flag(void)
{
    return auto_color_flag;
}

uint8_t get_color_flag(void)
{
    return color_flag;
}

void switch_951_Color(uint8_t in)
{
    switch (in)
    {
    case 0:
        AIM951_i2c_send(0xFF, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x02, 0x04);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x00, 0x13);
        BSP_Delay_ms(10);
        break;

    case 1:
        AIM951_i2c_send(0xFF, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x02, 0x04);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x00, 0x23);
        BSP_Delay_ms(10);
        break;

    case 2:
        AIM951_i2c_send(0xFF, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x02, 0x04);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x00, 0x33);
        BSP_Delay_ms(10);
        break;

    case 3:
        AIM951_i2c_send(0xFF, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x02, 0x04);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x00, 0x43);
        BSP_Delay_ms(10);
        break;

    case 4:
        AIM951_i2c_send(0xFF, 0x01);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x02, 0x04);
        BSP_Delay_ms(10);
        AIM951_i2c_send(0x00, 0x53);
        BSP_Delay_ms(10);
        break;

    default:
        break;
    }
}

void init_951(void)
{
    switch_951_init(0);
}
