/*
 * src.h
 *
 *  Created on: 2019年8月22日
 *      Author: LSM
 */

#ifndef SRC_H_
#define SRC_H_

#include "r_typedefs.h"

extern uint8_t HW_I2C_Buff_Glob[256];   //	全局i2c接收缓冲区指针
extern uint8_t HW_I2C_Buff_Tx[16];     //	全局i2c发送缓冲区指针

#define BOOT_VER_STR     			   "0.02"					//  初版
#define USER_APP_ADDRESS               0x00040000U              //  APP首地址
#define USER_APP_Block                 12U                      //  APP所在的首个Block  
#define FLASH_LOAD_APP_Addr            0x3FF00u                //  App校验信息存储地址
#define WAIT_LOCK_TIMEOUT              10000 					//  等待948lock信号的超时时间 单位ms
#define TIME_OUT_CONFIG_948			   600						//  重配948超时时间

#define I2C_FAILED_MAX                 12                       //  连续检测15s如果i2c电平未拉高则判定i2c锁死
#define TIME_I2C_HARDWARE_RESET_TIME   1000						//  i2c检测计时间隔

//  是否开启调试功能
#define BSP_USER_DEBUG                 0					    //  0:重要错误打印 1：流程，警告，错误信息打印  2：调试打印

//  i2c从设备地址设置
#define ADDR_SLAVE_IIC                 0x34						//  MCU作为从设备时候的地址

#define I2C_DEVICE_96752_ID            0x90                     //  96752芯片的I2C的器件地址
#define BU948_I2C_DEVICE_ID            0x18                     //  948芯片的I2C的器件地址
#define BU956_I2C_DEVICE_ID            0x58                     //  9456芯片的I2C的器件地址
#endif /* SRC_H_ */
