
//  程序版本 REV 0.1

//---------------------------------------------------------------------------
//  包含头文件
#include "TimeStamp.h"

//---------------------------------------------------------------------------
//   定义时间戳相关
static volatile unsigned int TimeStampCnt = 0;            //  时间戳计数器

//---------------------------------------------------------------------------
//  时间累计调用函数,用户在1ms中断中调用该函数
void TimeStamp_TimeCntCallback(void)
{
	//  当超过最大值
	if(TimeStampCnt >= MAX_TIMESTAMP_VAL)
	{
		TimeStampCnt = 0;
	}
	//  没有超过最大值
	else
	{
		TimeStampCnt++;
	}
}

//---------------------------------------------------------------------------
//  开始一个时间戳对象
void TimeStamp_Reset(STimeStampInfo* pinfo)
{
	//  检查输入
	if(pinfo == 0) return;
	
	//  初始化
	pinfo->last_timesptamp = TimeStampCnt;       //  获取当前时间戳的值
	pinfo->time_cnt = 0;                         //  清空统计的时间
}

//---------------------------------------------------------------------------
//  统计时间戳对象
void TimeStamp_Update(STimeStampInfo* pinfo)
{
	//  定义相关变量
	unsigned int now_time;           //  当前时间戳的值
	unsigned int diff_time;          //  两次时间差值
	
	//  检查输入
	if(pinfo == 0) return;
	
	//  获取当前时间戳的值
	now_time = TimeStampCnt;
	
	//  计算两个时间戳的相差累计
	//  如果新值大于旧值
	if(now_time > (pinfo->last_timesptamp))
	{
		diff_time = now_time - pinfo->last_timesptamp;
	}
	//  如果新值小于旧值
	else if(now_time < (pinfo->last_timesptamp))
	{
		diff_time = (MAX_TIMESTAMP_VAL - pinfo->last_timesptamp + 1) + now_time;
	}
	//  如果相等
	else
	{
		//  没有超过最小时间单位
		diff_time = 0;
	}

	//  更新到对象中
	if(pinfo->time_cnt < 0xFFFFFFF0)
	{
		pinfo->time_cnt += diff_time;
	}
	pinfo->last_timesptamp = now_time;
}

//---------------------------------------------------------------------------
//  获得指定时间戳对象的累计时间
unsigned int TimeStamp_GetCntTime(STimeStampInfo* pinfo)
{
	//  检查输入
	if(pinfo == 0) return 0;
	
	//  返回累计时间
	return pinfo->time_cnt;
}

