/**************************************************************************//**
  * \file     Sys_Tick.c
  * \brief    System tick timer driver file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     19-Jul-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "stdlib.h"
#include "r_device.h"
#include "rh850_macros.h"
#include "Clock.h"
#include "Sys_Tick.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
#define   SYS_TICK_CLK_SRC                  (CLOCK_CPU_FREQ_HZ / 2UL)
#define   SYS_TICK_RELOAD_VAL               (SYS_TICK_INT_INTERVAL * SYS_TICK_CLK_SRC / 1000000UL)

/* Private variables ---------------------------------------------------------*/
Sys_Tick_Int_Call_Back_ptr_t   g_pfnSysTickIntCallBackFunc = NULL;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**************************************************************************//**
  * \brief      Start tick timer
  * \retval     None
******************************************************************************/
void Sys_Tick_Timer_Start(void)
{
    if (OSTM0TE != 0x00U)             /* Disable OSTM before configuration */
    {
        OSTM0TT = 0x01U;
        while (OSTM0TE != 0x00U)
        {
            
        }
    }
    
    OSTM0CTL = 0x01U;                 /* Enable OSTM interrupt */
    OSTM0EMU = 0x00U;                 /* Counter is stopped when Debugger takes control */
    OSTM0CMP = SYS_TICK_RELOAD_VAL;
    
    peripheral_IRQ_enable(INTOSTM0);
    
    OSTM0TS  = 0x01U;                 /* Start OSTM */
}

/**************************************************************************//**
  * \brief      GPIO initialization for sleep mode
  * \retval     None
******************************************************************************/
void Sys_Tick_Timer_Stop(void)
{
    peripheral_IRQ_disable(INTOSTM0);    /* Disable interrupt */
    OSTM0TT = 0x01U;                 /* Stop OSTM */
}

void Sys_Tick_Timer_Call_Back_Reg(Sys_Tick_Int_Call_Back_ptr_t pfnCallBack)
{
    g_pfnSysTickIntCallBackFunc = pfnCallBack;
}

/**************************************************************************//**
  * \brief      Tick timer interrupt service routines
  * \retval     None
******************************************************************************/
void Sys_Tick_Timer_ISR(void)
{
    if (g_pfnSysTickIntCallBackFunc != NULL)
    {
        g_pfnSysTickIntCallBackFunc();
    }
    
    peripheral_IRQ_flag_clear(INTOSTM0);
}
