/************************************************************************
 * \file     Init.c
 * \brief    Initializations during work state switching
 * \details
 * \author   Zhang Xuan
 * \version  V1.0.0
 * \date     18-Jan-2019
 * \par      History:
 *           V1.0.0 Initial release
 * \par      Copyright:
 *           (c) Heilongjiang TYW Electronics co., LTD
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "r_device.h"
#include "rh850_macros.h"
#include "init.h"
#include "clock.h"
#include "TimerB.h"
#include "..\UART\UART.h"
#include "..\touch_screen\BSP\BSP.h"
#include "..\touch_screen\RH850_OTA\RH850_OTA.h"
#include "..\touch_screen\fx12_test\fx12_test.h"

#include "../GPIO/GPIO.h"
#include "../GPIO/TFT_LCD.h"
#include "RTE_PWM.h"
#include "..\RIIC\RIIC.h"
#include "Sys_Tick.h"
#include "WDT.h"


/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/************************************************************************
 * \brief      Initializations during work state switching
 * \attention
 * \retval     None
 ************************************************************************/
void Sys_Startup_Pre_Init(void)
{
    Clock_Run_Mode_Init( );
}
/************************************************************************
 * \brief      Initializations during system power up
 * \attention
 * \retval     None
 ***********************************************************************/
void Sys_Startup_Init(void)
{
    /*I2C初始化结构体*/ 
    RIIC_Init_st_t i2c_config;
    uint32_t I2C_rate = 0;

    /*写配置字*/ 
    RTE_FCL_OP();
    /*检查升级状态并跳转*/
    //OTA_BOOT_init();

    /*系统中断开启*/
    enable_interrupt();

    /*GPIO初始化  GPIO配置需要使用诊断工具生成GPIO文件*/
    GPIO_Init(GPIO_WAKEUP_MODE);
    touch_IRQ_Enable();
    //touch_IRQ_pin_Enable();

    //看门狗初始化
    WDT_Init();
    
    /*50um定时器*/
    Sys_Tick_Timer_Start();

    /*DEBUG串口初始化*/
    BSP_InitUSART(); 

    BSP_I2C0_INIT();
    /*初始ADC*/
    //BSP_InitADC();

    BSP_GPIO_96751_1V_EN(1);
    BSP_Delay_ms(10);
    BSP_GPIO_96751_1V8_EN(1);
    BSP_Delay_ms(10);
    BSP_GPIO_TFT_EN(1);
    BSP_Delay_ms(20);
    BSP_GPIO_96751_PDB_EN(1);
    BSP_Delay_ms(50);

    //tft初始化
    TFT_LCD_Startup( );
    Display_Init();
    /*PWM初始化*/
    BSP_PWM_Init();

   // init_96751();
    init_951();
    /*上电时序*/
    //PowerON_Sequential();

    /*指令数据初始化*/
    ///COM_948_SLAVE_INIT();
    //测试
    //BSP_GPIO_BL_EN(1);

/*    uint32_t                *pRam;
    uint8_t                  u8StartupMode;
    UART_Channel_Config_st_t loc_config;
    uint32_t                 i;
    u8StartupMode = system_startup_mode( );
    if ( u8StartupMode == 1u )
    {
        u8StartupMode = 0x55u;
    }
    else
    {
        u8StartupMode = 0u;

        pRam = ( unsigned int * )0xFEBF8000ul;
        for ( i = 0; i < 0x2000; i++ )
        {
            pRam [ i ] = 0;
        }
    }

    WDT_Init( );
    GenDelay_Init(WDT__Clear);
    RTE_ADC_Init( );
    Sys_Tick_Timer_Call_Back_Reg(Sys_Process_ISR);
    RTE_GPIO_Init( );
    GPIO_SET_KEPP( );
    PWN_Init( );
    enable_interrupt( );
    Sys_Tick_Timer_Start( );
    RTE_GPIO_Squence( );*/
}




/************************************************************************
 * \brief      Initializations during work state switch to system sleep
 * \attention
 * \retval     None
 ************************************************************************
void Sys_Sleep_Init(void)
{
    Sys_Tick_Timer_Stop( );
    TimerB_PWM_Channel_Sleep(5);
    Analog_Signal_Conv_Stop( );
    RSCAN0_Sleep_Init( );
    RTE_GPIO_Sleep_Init( );
    RTE_GPIO_SET_WakeUp( );
    disable_interrupt( );
    GPIO_Wakeup_PIN_Set(GPIO_WAKEUP_PIN_P0_9, GPIO_WAKEUP_FALLING_EDGE);
    GPIO_Wakeup_PIN_Set(GPIO_WAKEUP_PIN_P8_3, GPIO_WAKEUP_RISING_EDGE);
    Clock_Sleep_Mode_Init( );
    system_stop( );
}*/

/************************************************************************
 * \brief      Initializations during work state switch to system run
 * \attention
 * \retval     None
 ***********************************************************************
void System_Wakeup_Init(void)
{
}*/
