/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_BTSEL_H
#define __S6J3360_BTSEL_H

#include "s6j3360io_basetypes.h"

/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT	stcBT
#else /* __IO_DEFINE */
#define BT	(*((volatile stc_bt_t*)0xB4808030))
#endif /* __IO_DEFINE */

/* BTSEL01 */
#define BT_BTSEL01	(BT.unBTSEL01.u32Register)  /*@rg@*/
#define BT_BTSEL01_BTSEL01	(BT.unBTSEL01.stcField.u4BTSEL01)  /*@bf@*/

typedef struct stc_bt_btsel01_field{
    uint_io32_t		u4BTSEL01:4;
    uint_io32_t		:28;
}stc_bt_btsel01_field_t;

typedef union un_bt_btsel01{
    uint_io32_t		u32Register;
    stc_bt_btsel01_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_btsel01_t;

/* BTSSSR0 */
#define BT_BTSSSR0	(BT.unBTSSSR0.u32Register)  /*@rg@*/
#define BT_BTSSSR0_SSSR	(BT.unBTSSSR0.stcField.u12SSSR)  /*@bf@*/

typedef struct stc_bt_btsssr0_field{
    uint_io32_t		u12SSSR:12;
    uint_io32_t		:20;
}stc_bt_btsssr0_field_t;

typedef union un_bt_btsssr0{
    uint_io32_t		u32Register;
    stc_bt_btsssr0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_btsssr0_t;

/* BTTRR0 */
#define BT_BTTRR0	(BT.unBTTRR0.u32Register)  /*@rg@*/
#define BT_BTTRR0_TRR0	(BT.unBTTRR0.stcField.u1TRR0)  /*@bf@*/
#define BT_BTTRR0_TRR1	(BT.unBTTRR0.stcField.u1TRR1)  /*@bf@*/
#define BT_BTTRR0_TRR2	(BT.unBTTRR0.stcField.u1TRR2)  /*@bf@*/
#define BT_BTTRR0_TRR3	(BT.unBTTRR0.stcField.u1TRR3)  /*@bf@*/
#define BT_BTTRR0_TRR4	(BT.unBTTRR0.stcField.u1TRR4)  /*@bf@*/
#define BT_BTTRR0_TRR5	(BT.unBTTRR0.stcField.u1TRR5)  /*@bf@*/
#define BT_BTTRR0_TRR6	(BT.unBTTRR0.stcField.u1TRR6)  /*@bf@*/
#define BT_BTTRR0_TRR7	(BT.unBTTRR0.stcField.u1TRR7)  /*@bf@*/
#define BT_BTTRR0_TRR8	(BT.unBTTRR0.stcField.u1TRR8)  /*@bf@*/
#define BT_BTTRR0_TRR9	(BT.unBTTRR0.stcField.u1TRR9)  /*@bf@*/
#define BT_BTTRR0_TRR10	(BT.unBTTRR0.stcField.u1TRR10)  /*@bf@*/
#define BT_BTTRR0_TRR11	(BT.unBTTRR0.stcField.u1TRR11)  /*@bf@*/

typedef struct stc_bt_bttrr0_field{
    uint_io32_t		u1TRR0:1;
    uint_io32_t		u1TRR1:1;
    uint_io32_t		u1TRR2:1;
    uint_io32_t		u1TRR3:1;
    uint_io32_t		u1TRR4:1;
    uint_io32_t		u1TRR5:1;
    uint_io32_t		u1TRR6:1;
    uint_io32_t		u1TRR7:1;
    uint_io32_t		u1TRR8:1;
    uint_io32_t		u1TRR9:1;
    uint_io32_t		u1TRR10:1;
    uint_io32_t		u1TRR11:1;
    uint_io32_t		:20;
}stc_bt_bttrr0_field_t;

typedef union un_bt_bttrr0{
    uint_io32_t		u32Register;
    stc_bt_bttrr0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_bttrr0_t;


typedef struct stc_bt{
    un_bt_btsel01_t	unBTSEL01;	/* 0x00000000 */
    un_bt_btsssr0_t	unBTSSSR0;	/* 0x00000004 */
    un_bt_bttrr0_t	unBTTRR0;	/* 0x00000008 */
    uint_io8_t	au8Reserved0[964];	/* 0x0000000C */
}stc_bt_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_t	stcBT;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_1	stcBT_1
#else /* __IO_DEFINE */
#define BT_1	(*((volatile stc_bt_1_t*)0xB4808830))
#endif /* __IO_DEFINE */

/* BTSEL23 */
#define BT_BTSEL23	(BT_1.unBTSEL23.u32Register)  /*@rg@*/
#define BT_BTSEL23_BTSEL23	(BT_1.unBTSEL23.stcField.u4BTSEL23)  /*@bf@*/

typedef struct stc_bt_1_btsel23_field{
    uint_io32_t		u4BTSEL23:4;
    uint_io32_t		:28;
}stc_bt_1_btsel23_field_t;

typedef union un_bt_1_btsel23{
    uint_io32_t		u32Register;
    stc_bt_1_btsel23_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_1_btsel23_t;


typedef struct stc_bt_1{
    un_bt_1_btsel23_t	unBTSEL23;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_1_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_1_t	stcBT_1;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_2	stcBT_2
#else /* __IO_DEFINE */
#define BT_2	(*((volatile stc_bt_2_t*)0xB4809030))
#endif /* __IO_DEFINE */

/* BTSEL45 */
#define BT_BTSEL45	(BT_2.unBTSEL45.u32Register)  /*@rg@*/
#define BT_BTSEL45_BTSEL45	(BT_2.unBTSEL45.stcField.u4BTSEL45)  /*@bf@*/

typedef struct stc_bt_2_btsel45_field{
    uint_io32_t		u4BTSEL45:4;
    uint_io32_t		:28;
}stc_bt_2_btsel45_field_t;

typedef union un_bt_2_btsel45{
    uint_io32_t		u32Register;
    stc_bt_2_btsel45_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_2_btsel45_t;


typedef struct stc_bt_2{
    un_bt_2_btsel45_t	unBTSEL45;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_2_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_2_t	stcBT_2;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_3	stcBT_3
#else /* __IO_DEFINE */
#define BT_3	(*((volatile stc_bt_3_t*)0xB4809830))
#endif /* __IO_DEFINE */

/* BTSEL67 */
#define BT_BTSEL67	(BT_3.unBTSEL67.u32Register)  /*@rg@*/
#define BT_BTSEL67_BTSEL67	(BT_3.unBTSEL67.stcField.u4BTSEL67)  /*@bf@*/

typedef struct stc_bt_3_btsel67_field{
    uint_io32_t		u4BTSEL67:4;
    uint_io32_t		:28;
}stc_bt_3_btsel67_field_t;

typedef union un_bt_3_btsel67{
    uint_io32_t		u32Register;
    stc_bt_3_btsel67_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_3_btsel67_t;


typedef struct stc_bt_3{
    un_bt_3_btsel67_t	unBTSEL67;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_3_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_3_t	stcBT_3;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_4	stcBT_4
#else /* __IO_DEFINE */
#define BT_4	(*((volatile stc_bt_4_t*)0xB480A030))
#endif /* __IO_DEFINE */

/* BTSEL89 */
#define BT_BTSEL89	(BT_4.unBTSEL89.u32Register)  /*@rg@*/
#define BT_BTSEL89_BTSEL89	(BT_4.unBTSEL89.stcField.u4BTSEL89)  /*@bf@*/

typedef struct stc_bt_4_btsel89_field{
    uint_io32_t		u4BTSEL89:4;
    uint_io32_t		:28;
}stc_bt_4_btsel89_field_t;

typedef union un_bt_4_btsel89{
    uint_io32_t		u32Register;
    stc_bt_4_btsel89_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_4_btsel89_t;


typedef struct stc_bt_4{
    un_bt_4_btsel89_t	unBTSEL89;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_4_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_4_t	stcBT_4;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_5	stcBT_5
#else /* __IO_DEFINE */
#define BT_5	(*((volatile stc_bt_5_t*)0xB480A830))
#endif /* __IO_DEFINE */

/* BTSEL1011 */
#define BT_BTSEL1011	(BT_5.unBTSEL1011.u32Register)  /*@rg@*/
#define BT_BTSEL1011_BTSEL1011	(BT_5.unBTSEL1011.stcField.u4BTSEL1011)  /*@bf@*/

typedef struct stc_bt_5_btsel1011_field{
    uint_io32_t		u4BTSEL1011:4;
    uint_io32_t		:28;
}stc_bt_5_btsel1011_field_t;

typedef union un_bt_5_btsel1011{
    uint_io32_t		u32Register;
    stc_bt_5_btsel1011_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_5_btsel1011_t;


typedef struct stc_bt_5{
    un_bt_5_btsel1011_t	unBTSEL1011;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_5_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_5_t	stcBT_5;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_6	stcBT_6
#else /* __IO_DEFINE */
#define BT_6	(*((volatile stc_bt_6_t*)0xB4888030))
#endif /* __IO_DEFINE */

/* BTSEL1213 */
#define BT_BTSEL1213	(BT_6.unBTSEL1213.u32Register)  /*@rg@*/
#define BT_BTSEL1213_BTSEL1213	(BT_6.unBTSEL1213.stcField.u4BTSEL1213)  /*@bf@*/

typedef struct stc_bt_6_btsel1213_field{
    uint_io32_t		u4BTSEL1213:4;
    uint_io32_t		:28;
}stc_bt_6_btsel1213_field_t;

typedef union un_bt_6_btsel1213{
    uint_io32_t		u32Register;
    stc_bt_6_btsel1213_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_6_btsel1213_t;

/* BTSSSR12 */
#define BT_BTSSSR12	(BT_6.unBTSSSR12.u32Register)  /*@rg@*/
#define BT_BTSSSR12_SSSR	(BT_6.unBTSSSR12.stcField.u12SSSR)  /*@bf@*/

typedef struct stc_bt_6_btsssr12_field{
    uint_io32_t		u12SSSR:12;
    uint_io32_t		:20;
}stc_bt_6_btsssr12_field_t;

typedef union un_bt_6_btsssr12{
    uint_io32_t		u32Register;
    stc_bt_6_btsssr12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_6_btsssr12_t;

/* BTTRR12 */
#define BT_BTTRR12	(BT_6.unBTTRR12.u32Register)  /*@rg@*/
#define BT_BTTRR12_TRR0	(BT_6.unBTTRR12.stcField.u1TRR0)  /*@bf@*/
#define BT_BTTRR12_TRR1	(BT_6.unBTTRR12.stcField.u1TRR1)  /*@bf@*/
#define BT_BTTRR12_TRR2	(BT_6.unBTTRR12.stcField.u1TRR2)  /*@bf@*/
#define BT_BTTRR12_TRR3	(BT_6.unBTTRR12.stcField.u1TRR3)  /*@bf@*/
#define BT_BTTRR12_TRR4	(BT_6.unBTTRR12.stcField.u1TRR4)  /*@bf@*/
#define BT_BTTRR12_TRR5	(BT_6.unBTTRR12.stcField.u1TRR5)  /*@bf@*/
#define BT_BTTRR12_TRR6	(BT_6.unBTTRR12.stcField.u1TRR6)  /*@bf@*/
#define BT_BTTRR12_TRR7	(BT_6.unBTTRR12.stcField.u1TRR7)  /*@bf@*/
#define BT_BTTRR12_TRR8	(BT_6.unBTTRR12.stcField.u1TRR8)  /*@bf@*/
#define BT_BTTRR12_TRR9	(BT_6.unBTTRR12.stcField.u1TRR9)  /*@bf@*/
#define BT_BTTRR12_TRR10	(BT_6.unBTTRR12.stcField.u1TRR10)  /*@bf@*/
#define BT_BTTRR12_TRR11	(BT_6.unBTTRR12.stcField.u1TRR11)  /*@bf@*/

typedef struct stc_bt_6_bttrr12_field{
    uint_io32_t		u1TRR0:1;
    uint_io32_t		u1TRR1:1;
    uint_io32_t		u1TRR2:1;
    uint_io32_t		u1TRR3:1;
    uint_io32_t		u1TRR4:1;
    uint_io32_t		u1TRR5:1;
    uint_io32_t		u1TRR6:1;
    uint_io32_t		u1TRR7:1;
    uint_io32_t		u1TRR8:1;
    uint_io32_t		u1TRR9:1;
    uint_io32_t		u1TRR10:1;
    uint_io32_t		u1TRR11:1;
    uint_io32_t		:20;
}stc_bt_6_bttrr12_field_t;

typedef union un_bt_6_bttrr12{
    uint_io32_t		u32Register;
    stc_bt_6_bttrr12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_6_bttrr12_t;


typedef struct stc_bt_6{
    un_bt_6_btsel1213_t	unBTSEL1213;	/* 0x00000000 */
    un_bt_6_btsssr12_t	unBTSSSR12;	/* 0x00000004 */
    un_bt_6_bttrr12_t	unBTTRR12;	/* 0x00000008 */
    uint_io8_t	au8Reserved0[964];	/* 0x0000000C */
}stc_bt_6_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_6_t	stcBT_6;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_7	stcBT_7
#else /* __IO_DEFINE */
#define BT_7	(*((volatile stc_bt_7_t*)0xB4888830))
#endif /* __IO_DEFINE */

/* BTSEL1415 */
#define BT_BTSEL1415	(BT_7.unBTSEL1415.u32Register)  /*@rg@*/
#define BT_BTSEL1415_BTSEL1415	(BT_7.unBTSEL1415.stcField.u4BTSEL1415)  /*@bf@*/

typedef struct stc_bt_7_btsel1415_field{
    uint_io32_t		u4BTSEL1415:4;
    uint_io32_t		:28;
}stc_bt_7_btsel1415_field_t;

typedef union un_bt_7_btsel1415{
    uint_io32_t		u32Register;
    stc_bt_7_btsel1415_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_7_btsel1415_t;


typedef struct stc_bt_7{
    un_bt_7_btsel1415_t	unBTSEL1415;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_7_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_7_t	stcBT_7;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_8	stcBT_8
#else /* __IO_DEFINE */
#define BT_8	(*((volatile stc_bt_8_t*)0xB4889030))
#endif /* __IO_DEFINE */

/* BTSEL1617 */
#define BT_BTSEL1617	(BT_8.unBTSEL1617.u32Register)  /*@rg@*/
#define BT_BTSEL1617_BTSEL1617	(BT_8.unBTSEL1617.stcField.u4BTSEL1617)  /*@bf@*/

typedef struct stc_bt_8_btsel1617_field{
    uint_io32_t		u4BTSEL1617:4;
    uint_io32_t		:28;
}stc_bt_8_btsel1617_field_t;

typedef union un_bt_8_btsel1617{
    uint_io32_t		u32Register;
    stc_bt_8_btsel1617_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_8_btsel1617_t;


typedef struct stc_bt_8{
    un_bt_8_btsel1617_t	unBTSEL1617;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_8_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_8_t	stcBT_8;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_9	stcBT_9
#else /* __IO_DEFINE */
#define BT_9	(*((volatile stc_bt_9_t*)0xB4889830))
#endif /* __IO_DEFINE */

/* BTSEL1819 */
#define BT_BTSEL1819	(BT_9.unBTSEL1819.u32Register)  /*@rg@*/
#define BT_BTSEL1819_BTSEL1819	(BT_9.unBTSEL1819.stcField.u4BTSEL1819)  /*@bf@*/

typedef struct stc_bt_9_btsel1819_field{
    uint_io32_t		u4BTSEL1819:4;
    uint_io32_t		:28;
}stc_bt_9_btsel1819_field_t;

typedef union un_bt_9_btsel1819{
    uint_io32_t		u32Register;
    stc_bt_9_btsel1819_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_9_btsel1819_t;


typedef struct stc_bt_9{
    un_bt_9_btsel1819_t	unBTSEL1819;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_9_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_9_t	stcBT_9;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_10	stcBT_10
#else /* __IO_DEFINE */
#define BT_10	(*((volatile stc_bt_10_t*)0xB488A030))
#endif /* __IO_DEFINE */

/* BTSEL2021 */
#define BT_BTSEL2021	(BT_10.unBTSEL2021.u32Register)  /*@rg@*/
#define BT_BTSEL2021_BTSEL2021	(BT_10.unBTSEL2021.stcField.u4BTSEL2021)  /*@bf@*/

typedef struct stc_bt_10_btsel2021_field{
    uint_io32_t		u4BTSEL2021:4;
    uint_io32_t		:28;
}stc_bt_10_btsel2021_field_t;

typedef union un_bt_10_btsel2021{
    uint_io32_t		u32Register;
    stc_bt_10_btsel2021_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_10_btsel2021_t;


typedef struct stc_bt_10{
    un_bt_10_btsel2021_t	unBTSEL2021;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_10_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_10_t	stcBT_10;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_11	stcBT_11
#else /* __IO_DEFINE */
#define BT_11	(*((volatile stc_bt_11_t*)0xB488A830))
#endif /* __IO_DEFINE */

/* BTSEL2223 */
#define BT_BTSEL2223	(BT_11.unBTSEL2223.u32Register)  /*@rg@*/
#define BT_BTSEL2223_BTSEL2223	(BT_11.unBTSEL2223.stcField.u4BTSEL2223)  /*@bf@*/

typedef struct stc_bt_11_btsel2223_field{
    uint_io32_t		u4BTSEL2223:4;
    uint_io32_t		:28;
}stc_bt_11_btsel2223_field_t;

typedef union un_bt_11_btsel2223{
    uint_io32_t		u32Register;
    stc_bt_11_btsel2223_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_11_btsel2223_t;


typedef struct stc_bt_11{
    un_bt_11_btsel2223_t	unBTSEL2223;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_11_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_11_t	stcBT_11;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_12	stcBT_12
#else /* __IO_DEFINE */
#define BT_12	(*((volatile stc_bt_12_t*)0xB4846030))
#endif /* __IO_DEFINE */

/* BTSEL2425 */
#define BT_BTSEL2425	(BT_12.unBTSEL2425.u32Register)  /*@rg@*/
#define BT_BTSEL2425_BTSEL2425	(BT_12.unBTSEL2425.stcField.u4BTSEL2425)  /*@bf@*/

typedef struct stc_bt_12_btsel2425_field{
    uint_io32_t		u4BTSEL2425:4;
    uint_io32_t		:28;
}stc_bt_12_btsel2425_field_t;

typedef union un_bt_12_btsel2425{
    uint_io32_t		u32Register;
    stc_bt_12_btsel2425_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_12_btsel2425_t;

/* BTSSSR24 */
#define BT_BTSSSR24	(BT_12.unBTSSSR24.u32Register)  /*@rg@*/
#define BT_BTSSSR24_SSSR	(BT_12.unBTSSSR24.stcField.u12SSSR)  /*@bf@*/

typedef struct stc_bt_12_btsssr24_field{
    uint_io32_t		u12SSSR:12;
    uint_io32_t		:20;
}stc_bt_12_btsssr24_field_t;

typedef union un_bt_12_btsssr24{
    uint_io32_t		u32Register;
    stc_bt_12_btsssr24_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_12_btsssr24_t;

/* BTTRR24 */
#define BT_BTTRR24	(BT_12.unBTTRR24.u32Register)  /*@rg@*/
#define BT_BTTRR24_TRR0	(BT_12.unBTTRR24.stcField.u1TRR0)  /*@bf@*/
#define BT_BTTRR24_TRR1	(BT_12.unBTTRR24.stcField.u1TRR1)  /*@bf@*/
#define BT_BTTRR24_TRR2	(BT_12.unBTTRR24.stcField.u1TRR2)  /*@bf@*/
#define BT_BTTRR24_TRR3	(BT_12.unBTTRR24.stcField.u1TRR3)  /*@bf@*/
#define BT_BTTRR24_TRR4	(BT_12.unBTTRR24.stcField.u1TRR4)  /*@bf@*/
#define BT_BTTRR24_TRR5	(BT_12.unBTTRR24.stcField.u1TRR5)  /*@bf@*/
#define BT_BTTRR24_TRR6	(BT_12.unBTTRR24.stcField.u1TRR6)  /*@bf@*/
#define BT_BTTRR24_TRR7	(BT_12.unBTTRR24.stcField.u1TRR7)  /*@bf@*/
#define BT_BTTRR24_TRR8	(BT_12.unBTTRR24.stcField.u1TRR8)  /*@bf@*/
#define BT_BTTRR24_TRR9	(BT_12.unBTTRR24.stcField.u1TRR9)  /*@bf@*/
#define BT_BTTRR24_TRR10	(BT_12.unBTTRR24.stcField.u1TRR10)  /*@bf@*/
#define BT_BTTRR24_TRR11	(BT_12.unBTTRR24.stcField.u1TRR11)  /*@bf@*/

typedef struct stc_bt_12_bttrr24_field{
    uint_io32_t		u1TRR0:1;
    uint_io32_t		u1TRR1:1;
    uint_io32_t		u1TRR2:1;
    uint_io32_t		u1TRR3:1;
    uint_io32_t		u1TRR4:1;
    uint_io32_t		u1TRR5:1;
    uint_io32_t		u1TRR6:1;
    uint_io32_t		u1TRR7:1;
    uint_io32_t		u1TRR8:1;
    uint_io32_t		u1TRR9:1;
    uint_io32_t		u1TRR10:1;
    uint_io32_t		u1TRR11:1;
    uint_io32_t		:20;
}stc_bt_12_bttrr24_field_t;

typedef union un_bt_12_bttrr24{
    uint_io32_t		u32Register;
    stc_bt_12_bttrr24_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_12_bttrr24_t;


typedef struct stc_bt_12{
    un_bt_12_btsel2425_t	unBTSEL2425;	/* 0x00000000 */
    un_bt_12_btsssr24_t	unBTSSSR24;	/* 0x00000004 */
    un_bt_12_bttrr24_t	unBTTRR24;	/* 0x00000008 */
    uint_io8_t	au8Reserved0[964];	/* 0x0000000C */
}stc_bt_12_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_12_t	stcBT_12;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_13	stcBT_13
#else /* __IO_DEFINE */
#define BT_13	(*((volatile stc_bt_13_t*)0xB4846830))
#endif /* __IO_DEFINE */

/* BTSEL2627 */
#define BT_BTSEL2627	(BT_13.unBTSEL2627.u32Register)  /*@rg@*/
#define BT_BTSEL2627_BTSEL2627	(BT_13.unBTSEL2627.stcField.u4BTSEL2627)  /*@bf@*/

typedef struct stc_bt_13_btsel2627_field{
    uint_io32_t		u4BTSEL2627:4;
    uint_io32_t		:28;
}stc_bt_13_btsel2627_field_t;

typedef union un_bt_13_btsel2627{
    uint_io32_t		u32Register;
    stc_bt_13_btsel2627_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_13_btsel2627_t;


typedef struct stc_bt_13{
    un_bt_13_btsel2627_t	unBTSEL2627;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_13_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_13_t	stcBT_13;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_14	stcBT_14
#else /* __IO_DEFINE */
#define BT_14	(*((volatile stc_bt_14_t*)0xB4847030))
#endif /* __IO_DEFINE */

/* BTSEL2829 */
#define BT_BTSEL2829	(BT_14.unBTSEL2829.u32Register)  /*@rg@*/
#define BT_BTSEL2829_BTSEL2829	(BT_14.unBTSEL2829.stcField.u4BTSEL2829)  /*@bf@*/

typedef struct stc_bt_14_btsel2829_field{
    uint_io32_t		u4BTSEL2829:4;
    uint_io32_t		:28;
}stc_bt_14_btsel2829_field_t;

typedef union un_bt_14_btsel2829{
    uint_io32_t		u32Register;
    stc_bt_14_btsel2829_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_14_btsel2829_t;


typedef struct stc_bt_14{
    un_bt_14_btsel2829_t	unBTSEL2829;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_14_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_14_t	stcBT_14;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


/* BT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT_15	stcBT_15
#else /* __IO_DEFINE */
#define BT_15	(*((volatile stc_bt_15_t*)0xB4847830))
#endif /* __IO_DEFINE */

/* BTSEL3031 */
#define BT_BTSEL3031	(BT_15.unBTSEL3031.u32Register)  /*@rg@*/
#define BT_BTSEL3031_BTSEL3031	(BT_15.unBTSEL3031.stcField.u4BTSEL3031)  /*@bf@*/

typedef struct stc_bt_15_btsel3031_field{
    uint_io32_t		u4BTSEL3031:4;
    uint_io32_t		:28;
}stc_bt_15_btsel3031_field_t;

typedef union un_bt_15_btsel3031{
    uint_io32_t		u32Register;
    stc_bt_15_btsel3031_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_bt_15_btsel3031_t;


typedef struct stc_bt_15{
    un_bt_15_btsel3031_t	unBTSEL3031;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[972];	/* 0x00000004 */
}stc_bt_15_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_bt_15_t	stcBT_15;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 976(0x3d0) bytes */


#endif /* __S6J3360_BTSEL_H */
