/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_MFS_LIN_H
#define __S6J3360_MFS_LIN_H

#include "s6j3360io_basetypes.h"

/* CPG_MFS[00-11]_LIN base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CPG_MFS00_LIN	stcCPG_MFS_LIN[0]
#define CPG_MFS01_LIN	stcCPG_MFS_LIN[1]
#define CPG_MFS02_LIN	stcCPG_MFS_LIN[2]
#define CPG_MFS03_LIN	stcCPG_MFS_LIN[3]
#define CPG_MFS04_LIN	stcCPG_MFS_LIN[4]
#define CPG_MFS05_LIN	stcCPG_MFS_LIN[5]
#define CPG_MFS06_LIN	stcCPG_MFS_LIN[6]
#define CPG_MFS07_LIN	stcCPG_MFS_LIN[7]
#define CPG_MFS08_LIN	stcCPG_MFS_LIN[8]
#define CPG_MFS09_LIN	stcCPG_MFS_LIN[9]
#define CPG_MFS10_LIN	stcCPG_MFS_LIN[10]
#define CPG_MFS11_LIN	stcCPG_MFS_LIN[11]
#else /* __IO_DEFINE */
#define CPG_MFS00_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4800000))
#define CPG_MFS01_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4800400))
#define CPG_MFS02_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4800800))
#define CPG_MFS03_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4800C00))
#define CPG_MFS04_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4801000))
#define CPG_MFS05_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4801400))
#define CPG_MFS06_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4801800))
#define CPG_MFS07_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4801C00))
#define CPG_MFS08_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4880000))
#define CPG_MFS09_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4880400))
#define CPG_MFS10_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4880800))
#define CPG_MFS11_LIN	(*((volatile stc_cpg_mfsn_lin_t*)0xB4880C00))
#endif /* __IO_DEFINE */

/* SMR */
#define CPG_MFS00_LIN_SMR	(CPG_MFS00_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SMR_SOE	(CPG_MFS00_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS00_LIN_SMR_SBL	(CPG_MFS00_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS00_LIN_SMR_WUCR	(CPG_MFS00_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS00_LIN_SMR_MD	(CPG_MFS00_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS01_LIN_SMR	(CPG_MFS01_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SMR_SOE	(CPG_MFS01_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS01_LIN_SMR_SBL	(CPG_MFS01_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS01_LIN_SMR_WUCR	(CPG_MFS01_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS01_LIN_SMR_MD	(CPG_MFS01_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS02_LIN_SMR	(CPG_MFS02_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SMR_SOE	(CPG_MFS02_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS02_LIN_SMR_SBL	(CPG_MFS02_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS02_LIN_SMR_WUCR	(CPG_MFS02_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS02_LIN_SMR_MD	(CPG_MFS02_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS03_LIN_SMR	(CPG_MFS03_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SMR_SOE	(CPG_MFS03_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS03_LIN_SMR_SBL	(CPG_MFS03_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS03_LIN_SMR_WUCR	(CPG_MFS03_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS03_LIN_SMR_MD	(CPG_MFS03_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS04_LIN_SMR	(CPG_MFS04_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SMR_SOE	(CPG_MFS04_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS04_LIN_SMR_SBL	(CPG_MFS04_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS04_LIN_SMR_WUCR	(CPG_MFS04_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS04_LIN_SMR_MD	(CPG_MFS04_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS05_LIN_SMR	(CPG_MFS05_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SMR_SOE	(CPG_MFS05_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS05_LIN_SMR_SBL	(CPG_MFS05_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS05_LIN_SMR_WUCR	(CPG_MFS05_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS05_LIN_SMR_MD	(CPG_MFS05_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS06_LIN_SMR	(CPG_MFS06_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SMR_SOE	(CPG_MFS06_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS06_LIN_SMR_SBL	(CPG_MFS06_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS06_LIN_SMR_WUCR	(CPG_MFS06_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS06_LIN_SMR_MD	(CPG_MFS06_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS07_LIN_SMR	(CPG_MFS07_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SMR_SOE	(CPG_MFS07_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS07_LIN_SMR_SBL	(CPG_MFS07_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS07_LIN_SMR_WUCR	(CPG_MFS07_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS07_LIN_SMR_MD	(CPG_MFS07_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS08_LIN_SMR	(CPG_MFS08_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SMR_SOE	(CPG_MFS08_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS08_LIN_SMR_SBL	(CPG_MFS08_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS08_LIN_SMR_WUCR	(CPG_MFS08_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS08_LIN_SMR_MD	(CPG_MFS08_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS09_LIN_SMR	(CPG_MFS09_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SMR_SOE	(CPG_MFS09_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS09_LIN_SMR_SBL	(CPG_MFS09_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS09_LIN_SMR_WUCR	(CPG_MFS09_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS09_LIN_SMR_MD	(CPG_MFS09_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS10_LIN_SMR	(CPG_MFS10_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SMR_SOE	(CPG_MFS10_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS10_LIN_SMR_SBL	(CPG_MFS10_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS10_LIN_SMR_WUCR	(CPG_MFS10_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS10_LIN_SMR_MD	(CPG_MFS10_LIN.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS11_LIN_SMR	(CPG_MFS11_LIN.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SMR_SOE	(CPG_MFS11_LIN.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS11_LIN_SMR_SBL	(CPG_MFS11_LIN.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS11_LIN_SMR_WUCR	(CPG_MFS11_LIN.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS11_LIN_SMR_MD	(CPG_MFS11_LIN.unSMR.stcField.u3MD)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_smr_field{
    uint_io8_t		u1SOE:1;
    uint_io8_t		:2;
    uint_io8_t		u1SBL:1;
    uint_io8_t		u1WUCR:1;
    uint_io8_t		u3MD:3;
}stc_cpg_mfsn_lin_smr_field_t;

typedef union un_cpg_mfsn_lin_smr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_smr_field_t		stcField;
}un_cpg_mfsn_lin_smr_t;

/* SCR */
#define CPG_MFS00_LIN_SCR	(CPG_MFS00_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SCR_TXE	(CPG_MFS00_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS00_LIN_SCR_RXE	(CPG_MFS00_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS00_LIN_SCR_TBIE	(CPG_MFS00_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS00_LIN_SCR_TIE	(CPG_MFS00_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS00_LIN_SCR_RIE	(CPG_MFS00_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS00_LIN_SCR_LBR	(CPG_MFS00_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS00_LIN_SCR_MS	(CPG_MFS00_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS00_LIN_SCR_UPCL	(CPG_MFS00_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS01_LIN_SCR	(CPG_MFS01_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SCR_TXE	(CPG_MFS01_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS01_LIN_SCR_RXE	(CPG_MFS01_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS01_LIN_SCR_TBIE	(CPG_MFS01_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS01_LIN_SCR_TIE	(CPG_MFS01_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS01_LIN_SCR_RIE	(CPG_MFS01_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS01_LIN_SCR_LBR	(CPG_MFS01_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS01_LIN_SCR_MS	(CPG_MFS01_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS01_LIN_SCR_UPCL	(CPG_MFS01_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS02_LIN_SCR	(CPG_MFS02_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SCR_TXE	(CPG_MFS02_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS02_LIN_SCR_RXE	(CPG_MFS02_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS02_LIN_SCR_TBIE	(CPG_MFS02_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS02_LIN_SCR_TIE	(CPG_MFS02_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS02_LIN_SCR_RIE	(CPG_MFS02_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS02_LIN_SCR_LBR	(CPG_MFS02_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS02_LIN_SCR_MS	(CPG_MFS02_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS02_LIN_SCR_UPCL	(CPG_MFS02_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS03_LIN_SCR	(CPG_MFS03_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SCR_TXE	(CPG_MFS03_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS03_LIN_SCR_RXE	(CPG_MFS03_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS03_LIN_SCR_TBIE	(CPG_MFS03_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS03_LIN_SCR_TIE	(CPG_MFS03_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS03_LIN_SCR_RIE	(CPG_MFS03_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS03_LIN_SCR_LBR	(CPG_MFS03_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS03_LIN_SCR_MS	(CPG_MFS03_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS03_LIN_SCR_UPCL	(CPG_MFS03_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS04_LIN_SCR	(CPG_MFS04_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SCR_TXE	(CPG_MFS04_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS04_LIN_SCR_RXE	(CPG_MFS04_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS04_LIN_SCR_TBIE	(CPG_MFS04_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS04_LIN_SCR_TIE	(CPG_MFS04_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS04_LIN_SCR_RIE	(CPG_MFS04_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS04_LIN_SCR_LBR	(CPG_MFS04_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS04_LIN_SCR_MS	(CPG_MFS04_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS04_LIN_SCR_UPCL	(CPG_MFS04_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS05_LIN_SCR	(CPG_MFS05_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SCR_TXE	(CPG_MFS05_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS05_LIN_SCR_RXE	(CPG_MFS05_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS05_LIN_SCR_TBIE	(CPG_MFS05_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS05_LIN_SCR_TIE	(CPG_MFS05_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS05_LIN_SCR_RIE	(CPG_MFS05_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS05_LIN_SCR_LBR	(CPG_MFS05_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS05_LIN_SCR_MS	(CPG_MFS05_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS05_LIN_SCR_UPCL	(CPG_MFS05_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS06_LIN_SCR	(CPG_MFS06_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SCR_TXE	(CPG_MFS06_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS06_LIN_SCR_RXE	(CPG_MFS06_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS06_LIN_SCR_TBIE	(CPG_MFS06_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS06_LIN_SCR_TIE	(CPG_MFS06_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS06_LIN_SCR_RIE	(CPG_MFS06_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS06_LIN_SCR_LBR	(CPG_MFS06_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS06_LIN_SCR_MS	(CPG_MFS06_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS06_LIN_SCR_UPCL	(CPG_MFS06_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS07_LIN_SCR	(CPG_MFS07_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SCR_TXE	(CPG_MFS07_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS07_LIN_SCR_RXE	(CPG_MFS07_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS07_LIN_SCR_TBIE	(CPG_MFS07_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS07_LIN_SCR_TIE	(CPG_MFS07_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS07_LIN_SCR_RIE	(CPG_MFS07_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS07_LIN_SCR_LBR	(CPG_MFS07_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS07_LIN_SCR_MS	(CPG_MFS07_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS07_LIN_SCR_UPCL	(CPG_MFS07_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS08_LIN_SCR	(CPG_MFS08_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SCR_TXE	(CPG_MFS08_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS08_LIN_SCR_RXE	(CPG_MFS08_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS08_LIN_SCR_TBIE	(CPG_MFS08_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS08_LIN_SCR_TIE	(CPG_MFS08_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS08_LIN_SCR_RIE	(CPG_MFS08_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS08_LIN_SCR_LBR	(CPG_MFS08_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS08_LIN_SCR_MS	(CPG_MFS08_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS08_LIN_SCR_UPCL	(CPG_MFS08_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS09_LIN_SCR	(CPG_MFS09_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SCR_TXE	(CPG_MFS09_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS09_LIN_SCR_RXE	(CPG_MFS09_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS09_LIN_SCR_TBIE	(CPG_MFS09_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS09_LIN_SCR_TIE	(CPG_MFS09_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS09_LIN_SCR_RIE	(CPG_MFS09_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS09_LIN_SCR_LBR	(CPG_MFS09_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS09_LIN_SCR_MS	(CPG_MFS09_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS09_LIN_SCR_UPCL	(CPG_MFS09_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS10_LIN_SCR	(CPG_MFS10_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SCR_TXE	(CPG_MFS10_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS10_LIN_SCR_RXE	(CPG_MFS10_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS10_LIN_SCR_TBIE	(CPG_MFS10_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS10_LIN_SCR_TIE	(CPG_MFS10_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS10_LIN_SCR_RIE	(CPG_MFS10_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS10_LIN_SCR_LBR	(CPG_MFS10_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS10_LIN_SCR_MS	(CPG_MFS10_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS10_LIN_SCR_UPCL	(CPG_MFS10_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS11_LIN_SCR	(CPG_MFS11_LIN.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SCR_TXE	(CPG_MFS11_LIN.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS11_LIN_SCR_RXE	(CPG_MFS11_LIN.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS11_LIN_SCR_TBIE	(CPG_MFS11_LIN.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS11_LIN_SCR_TIE	(CPG_MFS11_LIN.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS11_LIN_SCR_RIE	(CPG_MFS11_LIN.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS11_LIN_SCR_LBR	(CPG_MFS11_LIN.unSCR.stcField.u1LBR)  /*@bf@*/
#define CPG_MFS11_LIN_SCR_MS	(CPG_MFS11_LIN.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS11_LIN_SCR_UPCL	(CPG_MFS11_LIN.unSCR.stcField.u1UPCL)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_scr_field{
    uint_io8_t		u1TXE:1;
    uint_io8_t		u1RXE:1;
    uint_io8_t		u1TBIE:1;
    uint_io8_t		u1TIE:1;
    uint_io8_t		u1RIE:1;
    uint_io8_t		u1LBR:1;
    uint_io8_t		u1MS:1;
    uint_io8_t		u1UPCL:1;
}stc_cpg_mfsn_lin_scr_field_t;

typedef union un_cpg_mfsn_lin_scr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_scr_field_t		stcField;
}un_cpg_mfsn_lin_scr_t;

/* ESCR */
#define CPG_MFS00_LIN_ESCR	(CPG_MFS00_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_ESCR_DEL	(CPG_MFS00_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS00_LIN_ESCR_LBL1_0	(CPG_MFS00_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS00_LIN_ESCR_LBIE	(CPG_MFS00_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS00_LIN_ESCR_LBL2	(CPG_MFS00_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS00_LIN_ESCR_ESBL	(CPG_MFS00_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS01_LIN_ESCR	(CPG_MFS01_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_ESCR_DEL	(CPG_MFS01_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS01_LIN_ESCR_LBL1_0	(CPG_MFS01_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS01_LIN_ESCR_LBIE	(CPG_MFS01_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS01_LIN_ESCR_LBL2	(CPG_MFS01_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS01_LIN_ESCR_ESBL	(CPG_MFS01_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS02_LIN_ESCR	(CPG_MFS02_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_ESCR_DEL	(CPG_MFS02_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS02_LIN_ESCR_LBL1_0	(CPG_MFS02_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS02_LIN_ESCR_LBIE	(CPG_MFS02_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS02_LIN_ESCR_LBL2	(CPG_MFS02_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS02_LIN_ESCR_ESBL	(CPG_MFS02_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS03_LIN_ESCR	(CPG_MFS03_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_ESCR_DEL	(CPG_MFS03_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS03_LIN_ESCR_LBL1_0	(CPG_MFS03_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS03_LIN_ESCR_LBIE	(CPG_MFS03_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS03_LIN_ESCR_LBL2	(CPG_MFS03_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS03_LIN_ESCR_ESBL	(CPG_MFS03_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS04_LIN_ESCR	(CPG_MFS04_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_ESCR_DEL	(CPG_MFS04_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS04_LIN_ESCR_LBL1_0	(CPG_MFS04_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS04_LIN_ESCR_LBIE	(CPG_MFS04_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS04_LIN_ESCR_LBL2	(CPG_MFS04_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS04_LIN_ESCR_ESBL	(CPG_MFS04_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS05_LIN_ESCR	(CPG_MFS05_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_ESCR_DEL	(CPG_MFS05_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS05_LIN_ESCR_LBL1_0	(CPG_MFS05_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS05_LIN_ESCR_LBIE	(CPG_MFS05_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS05_LIN_ESCR_LBL2	(CPG_MFS05_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS05_LIN_ESCR_ESBL	(CPG_MFS05_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS06_LIN_ESCR	(CPG_MFS06_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_ESCR_DEL	(CPG_MFS06_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS06_LIN_ESCR_LBL1_0	(CPG_MFS06_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS06_LIN_ESCR_LBIE	(CPG_MFS06_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS06_LIN_ESCR_LBL2	(CPG_MFS06_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS06_LIN_ESCR_ESBL	(CPG_MFS06_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS07_LIN_ESCR	(CPG_MFS07_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_ESCR_DEL	(CPG_MFS07_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS07_LIN_ESCR_LBL1_0	(CPG_MFS07_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS07_LIN_ESCR_LBIE	(CPG_MFS07_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS07_LIN_ESCR_LBL2	(CPG_MFS07_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS07_LIN_ESCR_ESBL	(CPG_MFS07_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS08_LIN_ESCR	(CPG_MFS08_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_ESCR_DEL	(CPG_MFS08_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS08_LIN_ESCR_LBL1_0	(CPG_MFS08_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS08_LIN_ESCR_LBIE	(CPG_MFS08_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS08_LIN_ESCR_LBL2	(CPG_MFS08_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS08_LIN_ESCR_ESBL	(CPG_MFS08_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS09_LIN_ESCR	(CPG_MFS09_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_ESCR_DEL	(CPG_MFS09_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS09_LIN_ESCR_LBL1_0	(CPG_MFS09_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS09_LIN_ESCR_LBIE	(CPG_MFS09_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS09_LIN_ESCR_LBL2	(CPG_MFS09_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS09_LIN_ESCR_ESBL	(CPG_MFS09_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS10_LIN_ESCR	(CPG_MFS10_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_ESCR_DEL	(CPG_MFS10_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS10_LIN_ESCR_LBL1_0	(CPG_MFS10_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS10_LIN_ESCR_LBIE	(CPG_MFS10_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS10_LIN_ESCR_LBL2	(CPG_MFS10_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS10_LIN_ESCR_ESBL	(CPG_MFS10_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

#define CPG_MFS11_LIN_ESCR	(CPG_MFS11_LIN.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_ESCR_DEL	(CPG_MFS11_LIN.unESCR.stcField.u2DEL)  /*@bf@*/
#define CPG_MFS11_LIN_ESCR_LBL1_0	(CPG_MFS11_LIN.unESCR.stcField.u2LBL1_0)  /*@bf@*/
#define CPG_MFS11_LIN_ESCR_LBIE	(CPG_MFS11_LIN.unESCR.stcField.u1LBIE)  /*@bf@*/
#define CPG_MFS11_LIN_ESCR_LBL2	(CPG_MFS11_LIN.unESCR.stcField.u1LBL2)  /*@bf@*/
#define CPG_MFS11_LIN_ESCR_ESBL	(CPG_MFS11_LIN.unESCR.stcField.u1ESBL)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_escr_field{
    uint_io8_t		u2DEL:2;
    uint_io8_t		u2LBL1_0:2;
    uint_io8_t		u1LBIE:1;
    uint_io8_t		u1LBL2:1;
    uint_io8_t		u1ESBL:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_escr_field_t;

typedef union un_cpg_mfsn_lin_escr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_escr_field_t		stcField;
}un_cpg_mfsn_lin_escr_t;

/* SSR */
#define CPG_MFS00_LIN_SSR	(CPG_MFS00_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SSR_TBI	(CPG_MFS00_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS00_LIN_SSR_TDRE	(CPG_MFS00_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS00_LIN_SSR_RDRF	(CPG_MFS00_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS00_LIN_SSR_ORE	(CPG_MFS00_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS00_LIN_SSR_FRE	(CPG_MFS00_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS00_LIN_SSR_LBD	(CPG_MFS00_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS00_LIN_SSR_REC	(CPG_MFS00_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS01_LIN_SSR	(CPG_MFS01_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SSR_TBI	(CPG_MFS01_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS01_LIN_SSR_TDRE	(CPG_MFS01_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS01_LIN_SSR_RDRF	(CPG_MFS01_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS01_LIN_SSR_ORE	(CPG_MFS01_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS01_LIN_SSR_FRE	(CPG_MFS01_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS01_LIN_SSR_LBD	(CPG_MFS01_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS01_LIN_SSR_REC	(CPG_MFS01_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS02_LIN_SSR	(CPG_MFS02_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SSR_TBI	(CPG_MFS02_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS02_LIN_SSR_TDRE	(CPG_MFS02_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS02_LIN_SSR_RDRF	(CPG_MFS02_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS02_LIN_SSR_ORE	(CPG_MFS02_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS02_LIN_SSR_FRE	(CPG_MFS02_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS02_LIN_SSR_LBD	(CPG_MFS02_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS02_LIN_SSR_REC	(CPG_MFS02_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS03_LIN_SSR	(CPG_MFS03_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SSR_TBI	(CPG_MFS03_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS03_LIN_SSR_TDRE	(CPG_MFS03_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS03_LIN_SSR_RDRF	(CPG_MFS03_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS03_LIN_SSR_ORE	(CPG_MFS03_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS03_LIN_SSR_FRE	(CPG_MFS03_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS03_LIN_SSR_LBD	(CPG_MFS03_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS03_LIN_SSR_REC	(CPG_MFS03_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS04_LIN_SSR	(CPG_MFS04_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SSR_TBI	(CPG_MFS04_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS04_LIN_SSR_TDRE	(CPG_MFS04_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS04_LIN_SSR_RDRF	(CPG_MFS04_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS04_LIN_SSR_ORE	(CPG_MFS04_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS04_LIN_SSR_FRE	(CPG_MFS04_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS04_LIN_SSR_LBD	(CPG_MFS04_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS04_LIN_SSR_REC	(CPG_MFS04_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS05_LIN_SSR	(CPG_MFS05_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SSR_TBI	(CPG_MFS05_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS05_LIN_SSR_TDRE	(CPG_MFS05_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS05_LIN_SSR_RDRF	(CPG_MFS05_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS05_LIN_SSR_ORE	(CPG_MFS05_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS05_LIN_SSR_FRE	(CPG_MFS05_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS05_LIN_SSR_LBD	(CPG_MFS05_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS05_LIN_SSR_REC	(CPG_MFS05_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS06_LIN_SSR	(CPG_MFS06_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SSR_TBI	(CPG_MFS06_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS06_LIN_SSR_TDRE	(CPG_MFS06_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS06_LIN_SSR_RDRF	(CPG_MFS06_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS06_LIN_SSR_ORE	(CPG_MFS06_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS06_LIN_SSR_FRE	(CPG_MFS06_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS06_LIN_SSR_LBD	(CPG_MFS06_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS06_LIN_SSR_REC	(CPG_MFS06_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS07_LIN_SSR	(CPG_MFS07_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SSR_TBI	(CPG_MFS07_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS07_LIN_SSR_TDRE	(CPG_MFS07_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS07_LIN_SSR_RDRF	(CPG_MFS07_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS07_LIN_SSR_ORE	(CPG_MFS07_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS07_LIN_SSR_FRE	(CPG_MFS07_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS07_LIN_SSR_LBD	(CPG_MFS07_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS07_LIN_SSR_REC	(CPG_MFS07_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS08_LIN_SSR	(CPG_MFS08_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SSR_TBI	(CPG_MFS08_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS08_LIN_SSR_TDRE	(CPG_MFS08_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS08_LIN_SSR_RDRF	(CPG_MFS08_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS08_LIN_SSR_ORE	(CPG_MFS08_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS08_LIN_SSR_FRE	(CPG_MFS08_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS08_LIN_SSR_LBD	(CPG_MFS08_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS08_LIN_SSR_REC	(CPG_MFS08_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS09_LIN_SSR	(CPG_MFS09_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SSR_TBI	(CPG_MFS09_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS09_LIN_SSR_TDRE	(CPG_MFS09_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS09_LIN_SSR_RDRF	(CPG_MFS09_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS09_LIN_SSR_ORE	(CPG_MFS09_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS09_LIN_SSR_FRE	(CPG_MFS09_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS09_LIN_SSR_LBD	(CPG_MFS09_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS09_LIN_SSR_REC	(CPG_MFS09_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS10_LIN_SSR	(CPG_MFS10_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SSR_TBI	(CPG_MFS10_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS10_LIN_SSR_TDRE	(CPG_MFS10_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS10_LIN_SSR_RDRF	(CPG_MFS10_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS10_LIN_SSR_ORE	(CPG_MFS10_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS10_LIN_SSR_FRE	(CPG_MFS10_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS10_LIN_SSR_LBD	(CPG_MFS10_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS10_LIN_SSR_REC	(CPG_MFS10_LIN.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS11_LIN_SSR	(CPG_MFS11_LIN.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SSR_TBI	(CPG_MFS11_LIN.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS11_LIN_SSR_TDRE	(CPG_MFS11_LIN.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS11_LIN_SSR_RDRF	(CPG_MFS11_LIN.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS11_LIN_SSR_ORE	(CPG_MFS11_LIN.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS11_LIN_SSR_FRE	(CPG_MFS11_LIN.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS11_LIN_SSR_LBD	(CPG_MFS11_LIN.unSSR.stcField.u1LBD)  /*@bf@*/
#define CPG_MFS11_LIN_SSR_REC	(CPG_MFS11_LIN.unSSR.stcField.u1REC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_ssr_field{
    uint_io8_t		u1TBI:1;
    uint_io8_t		u1TDRE:1;
    uint_io8_t		u1RDRF:1;
    uint_io8_t		u1ORE:1;
    uint_io8_t		u1FRE:1;
    uint_io8_t		u1LBD:1;
    uint_io8_t		:1;
    uint_io8_t		u1REC:1;
}stc_cpg_mfsn_lin_ssr_field_t;

typedef union un_cpg_mfsn_lin_ssr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_ssr_field_t		stcField;
}un_cpg_mfsn_lin_ssr_t;

/* RDR */
#define CPG_MFS00_LIN_RDR	(CPG_MFS00_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_TDR	(CPG_MFS00_LIN_RDR)  /*@rg2@*/
#define CPG_MFS00_LIN_RDR_D	CPG_MFS00_LIN_RDR  /*@bfrg@*/
#define CPG_MFS00_LIN_TDR_D	CPG_MFS00_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS01_LIN_RDR	(CPG_MFS01_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_TDR	(CPG_MFS01_LIN_RDR)  /*@rg2@*/
#define CPG_MFS01_LIN_RDR_D	CPG_MFS01_LIN_RDR  /*@bfrg@*/
#define CPG_MFS01_LIN_TDR_D	CPG_MFS01_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS02_LIN_RDR	(CPG_MFS02_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_TDR	(CPG_MFS02_LIN_RDR)  /*@rg2@*/
#define CPG_MFS02_LIN_RDR_D	CPG_MFS02_LIN_RDR  /*@bfrg@*/
#define CPG_MFS02_LIN_TDR_D	CPG_MFS02_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS03_LIN_RDR	(CPG_MFS03_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_TDR	(CPG_MFS03_LIN_RDR)  /*@rg2@*/
#define CPG_MFS03_LIN_RDR_D	CPG_MFS03_LIN_RDR  /*@bfrg@*/
#define CPG_MFS03_LIN_TDR_D	CPG_MFS03_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS04_LIN_RDR	(CPG_MFS04_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_TDR	(CPG_MFS04_LIN_RDR)  /*@rg2@*/
#define CPG_MFS04_LIN_RDR_D	CPG_MFS04_LIN_RDR  /*@bfrg@*/
#define CPG_MFS04_LIN_TDR_D	CPG_MFS04_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS05_LIN_RDR	(CPG_MFS05_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_TDR	(CPG_MFS05_LIN_RDR)  /*@rg2@*/
#define CPG_MFS05_LIN_RDR_D	CPG_MFS05_LIN_RDR  /*@bfrg@*/
#define CPG_MFS05_LIN_TDR_D	CPG_MFS05_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS06_LIN_RDR	(CPG_MFS06_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_TDR	(CPG_MFS06_LIN_RDR)  /*@rg2@*/
#define CPG_MFS06_LIN_RDR_D	CPG_MFS06_LIN_RDR  /*@bfrg@*/
#define CPG_MFS06_LIN_TDR_D	CPG_MFS06_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS07_LIN_RDR	(CPG_MFS07_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_TDR	(CPG_MFS07_LIN_RDR)  /*@rg2@*/
#define CPG_MFS07_LIN_RDR_D	CPG_MFS07_LIN_RDR  /*@bfrg@*/
#define CPG_MFS07_LIN_TDR_D	CPG_MFS07_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS08_LIN_RDR	(CPG_MFS08_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_TDR	(CPG_MFS08_LIN_RDR)  /*@rg2@*/
#define CPG_MFS08_LIN_RDR_D	CPG_MFS08_LIN_RDR  /*@bfrg@*/
#define CPG_MFS08_LIN_TDR_D	CPG_MFS08_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS09_LIN_RDR	(CPG_MFS09_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_TDR	(CPG_MFS09_LIN_RDR)  /*@rg2@*/
#define CPG_MFS09_LIN_RDR_D	CPG_MFS09_LIN_RDR  /*@bfrg@*/
#define CPG_MFS09_LIN_TDR_D	CPG_MFS09_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS10_LIN_RDR	(CPG_MFS10_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_TDR	(CPG_MFS10_LIN_RDR)  /*@rg2@*/
#define CPG_MFS10_LIN_RDR_D	CPG_MFS10_LIN_RDR  /*@bfrg@*/
#define CPG_MFS10_LIN_TDR_D	CPG_MFS10_LIN_RDR_D  /*@bf2@*/

#define CPG_MFS11_LIN_RDR	(CPG_MFS11_LIN.unRDR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_TDR	(CPG_MFS11_LIN_RDR)  /*@rg2@*/
#define CPG_MFS11_LIN_RDR_D	CPG_MFS11_LIN_RDR  /*@bfrg@*/
#define CPG_MFS11_LIN_TDR_D	CPG_MFS11_LIN_RDR_D  /*@bf2@*/

typedef union un_cpg_mfsn_lin_rdr{
    uint_io8_t		u8Register;
}un_cpg_mfsn_lin_rdr_t;

/* SACSR */
#define CPG_MFS00_LIN_SACSR	(CPG_MFS00_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_SACSR_TMRE	(CPG_MFS00_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_TDIV	(CPG_MFS00_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_TRGE	(CPG_MFS00_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_TINTE	(CPG_MFS00_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_TINT	(CPG_MFS00_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_TRG	(CPG_MFS00_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_AUTE	(CPG_MFS00_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_SFDE	(CPG_MFS00_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_SFD	(CPG_MFS00_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_BST	(CPG_MFS00_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS00_LIN_SACSR_STST	(CPG_MFS00_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS01_LIN_SACSR	(CPG_MFS01_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_SACSR_TMRE	(CPG_MFS01_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_TDIV	(CPG_MFS01_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_TRGE	(CPG_MFS01_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_TINTE	(CPG_MFS01_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_TINT	(CPG_MFS01_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_TRG	(CPG_MFS01_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_AUTE	(CPG_MFS01_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_SFDE	(CPG_MFS01_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_SFD	(CPG_MFS01_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_BST	(CPG_MFS01_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS01_LIN_SACSR_STST	(CPG_MFS01_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS02_LIN_SACSR	(CPG_MFS02_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_SACSR_TMRE	(CPG_MFS02_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_TDIV	(CPG_MFS02_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_TRGE	(CPG_MFS02_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_TINTE	(CPG_MFS02_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_TINT	(CPG_MFS02_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_TRG	(CPG_MFS02_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_AUTE	(CPG_MFS02_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_SFDE	(CPG_MFS02_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_SFD	(CPG_MFS02_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_BST	(CPG_MFS02_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS02_LIN_SACSR_STST	(CPG_MFS02_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS03_LIN_SACSR	(CPG_MFS03_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_SACSR_TMRE	(CPG_MFS03_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_TDIV	(CPG_MFS03_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_TRGE	(CPG_MFS03_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_TINTE	(CPG_MFS03_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_TINT	(CPG_MFS03_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_TRG	(CPG_MFS03_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_AUTE	(CPG_MFS03_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_SFDE	(CPG_MFS03_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_SFD	(CPG_MFS03_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_BST	(CPG_MFS03_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS03_LIN_SACSR_STST	(CPG_MFS03_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS04_LIN_SACSR	(CPG_MFS04_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_SACSR_TMRE	(CPG_MFS04_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_TDIV	(CPG_MFS04_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_TRGE	(CPG_MFS04_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_TINTE	(CPG_MFS04_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_TINT	(CPG_MFS04_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_TRG	(CPG_MFS04_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_AUTE	(CPG_MFS04_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_SFDE	(CPG_MFS04_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_SFD	(CPG_MFS04_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_BST	(CPG_MFS04_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS04_LIN_SACSR_STST	(CPG_MFS04_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS05_LIN_SACSR	(CPG_MFS05_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_SACSR_TMRE	(CPG_MFS05_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_TDIV	(CPG_MFS05_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_TRGE	(CPG_MFS05_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_TINTE	(CPG_MFS05_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_TINT	(CPG_MFS05_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_TRG	(CPG_MFS05_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_AUTE	(CPG_MFS05_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_SFDE	(CPG_MFS05_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_SFD	(CPG_MFS05_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_BST	(CPG_MFS05_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS05_LIN_SACSR_STST	(CPG_MFS05_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS06_LIN_SACSR	(CPG_MFS06_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_SACSR_TMRE	(CPG_MFS06_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_TDIV	(CPG_MFS06_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_TRGE	(CPG_MFS06_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_TINTE	(CPG_MFS06_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_TINT	(CPG_MFS06_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_TRG	(CPG_MFS06_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_AUTE	(CPG_MFS06_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_SFDE	(CPG_MFS06_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_SFD	(CPG_MFS06_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_BST	(CPG_MFS06_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS06_LIN_SACSR_STST	(CPG_MFS06_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS07_LIN_SACSR	(CPG_MFS07_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_SACSR_TMRE	(CPG_MFS07_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_TDIV	(CPG_MFS07_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_TRGE	(CPG_MFS07_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_TINTE	(CPG_MFS07_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_TINT	(CPG_MFS07_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_TRG	(CPG_MFS07_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_AUTE	(CPG_MFS07_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_SFDE	(CPG_MFS07_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_SFD	(CPG_MFS07_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_BST	(CPG_MFS07_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS07_LIN_SACSR_STST	(CPG_MFS07_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS08_LIN_SACSR	(CPG_MFS08_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_SACSR_TMRE	(CPG_MFS08_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_TDIV	(CPG_MFS08_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_TRGE	(CPG_MFS08_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_TINTE	(CPG_MFS08_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_TINT	(CPG_MFS08_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_TRG	(CPG_MFS08_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_AUTE	(CPG_MFS08_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_SFDE	(CPG_MFS08_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_SFD	(CPG_MFS08_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_BST	(CPG_MFS08_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS08_LIN_SACSR_STST	(CPG_MFS08_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS09_LIN_SACSR	(CPG_MFS09_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_SACSR_TMRE	(CPG_MFS09_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_TDIV	(CPG_MFS09_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_TRGE	(CPG_MFS09_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_TINTE	(CPG_MFS09_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_TINT	(CPG_MFS09_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_TRG	(CPG_MFS09_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_AUTE	(CPG_MFS09_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_SFDE	(CPG_MFS09_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_SFD	(CPG_MFS09_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_BST	(CPG_MFS09_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS09_LIN_SACSR_STST	(CPG_MFS09_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS10_LIN_SACSR	(CPG_MFS10_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_SACSR_TMRE	(CPG_MFS10_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_TDIV	(CPG_MFS10_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_TRGE	(CPG_MFS10_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_TINTE	(CPG_MFS10_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_TINT	(CPG_MFS10_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_TRG	(CPG_MFS10_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_AUTE	(CPG_MFS10_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_SFDE	(CPG_MFS10_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_SFD	(CPG_MFS10_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_BST	(CPG_MFS10_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS10_LIN_SACSR_STST	(CPG_MFS10_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS11_LIN_SACSR	(CPG_MFS11_LIN.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_SACSR_TMRE	(CPG_MFS11_LIN.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_TDIV	(CPG_MFS11_LIN.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_TRGE	(CPG_MFS11_LIN.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_TINTE	(CPG_MFS11_LIN.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_TINT	(CPG_MFS11_LIN.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_TRG	(CPG_MFS11_LIN.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_AUTE	(CPG_MFS11_LIN.unSACSR.stcField.u1AUTE)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_SFDE	(CPG_MFS11_LIN.unSACSR.stcField.u1SFDE)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_SFD	(CPG_MFS11_LIN.unSACSR.stcField.u1SFD)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_BST	(CPG_MFS11_LIN.unSACSR.stcField.u1BST)  /*@bf@*/
#define CPG_MFS11_LIN_SACSR_STST	(CPG_MFS11_LIN.unSACSR.stcField.u1STST)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_sacsr_field{
    uint_io16_t		u1TMRE:1;
    uint_io16_t		u4TDIV:4;
    uint_io16_t		u1TRGE:1;
    uint_io16_t		:1;
    uint_io16_t		u1TINTE:1;
    uint_io16_t		u1TINT:1;
    uint_io16_t		u2TRG:2;
    uint_io16_t		u1AUTE:1;
    uint_io16_t		u1SFDE:1;
    uint_io16_t		u1SFD:1;
    uint_io16_t		u1BST:1;
    uint_io16_t		u1STST:1;
}stc_cpg_mfsn_lin_sacsr_field_t;

typedef union un_cpg_mfsn_lin_sacsr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_lin_sacsr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_sacsr_t;

/* STMR */
#define CPG_MFS00_LIN_STMR	(CPG_MFS00_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_STMR_TM	CPG_MFS00_LIN_STMR  /*@bfrg@*/

#define CPG_MFS01_LIN_STMR	(CPG_MFS01_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_STMR_TM	CPG_MFS01_LIN_STMR  /*@bfrg@*/

#define CPG_MFS02_LIN_STMR	(CPG_MFS02_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_STMR_TM	CPG_MFS02_LIN_STMR  /*@bfrg@*/

#define CPG_MFS03_LIN_STMR	(CPG_MFS03_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_STMR_TM	CPG_MFS03_LIN_STMR  /*@bfrg@*/

#define CPG_MFS04_LIN_STMR	(CPG_MFS04_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_STMR_TM	CPG_MFS04_LIN_STMR  /*@bfrg@*/

#define CPG_MFS05_LIN_STMR	(CPG_MFS05_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_STMR_TM	CPG_MFS05_LIN_STMR  /*@bfrg@*/

#define CPG_MFS06_LIN_STMR	(CPG_MFS06_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_STMR_TM	CPG_MFS06_LIN_STMR  /*@bfrg@*/

#define CPG_MFS07_LIN_STMR	(CPG_MFS07_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_STMR_TM	CPG_MFS07_LIN_STMR  /*@bfrg@*/

#define CPG_MFS08_LIN_STMR	(CPG_MFS08_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_STMR_TM	CPG_MFS08_LIN_STMR  /*@bfrg@*/

#define CPG_MFS09_LIN_STMR	(CPG_MFS09_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_STMR_TM	CPG_MFS09_LIN_STMR  /*@bfrg@*/

#define CPG_MFS10_LIN_STMR	(CPG_MFS10_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_STMR_TM	CPG_MFS10_LIN_STMR  /*@bfrg@*/

#define CPG_MFS11_LIN_STMR	(CPG_MFS11_LIN.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_STMR_TM	CPG_MFS11_LIN_STMR  /*@bfrg@*/

typedef union un_cpg_mfsn_lin_stmr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_stmr_t;

/* STMCR */
#define CPG_MFS00_LIN_STMCR	(CPG_MFS00_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_STMCR_TC	CPG_MFS00_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS01_LIN_STMCR	(CPG_MFS01_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_STMCR_TC	CPG_MFS01_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS02_LIN_STMCR	(CPG_MFS02_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_STMCR_TC	CPG_MFS02_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS03_LIN_STMCR	(CPG_MFS03_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_STMCR_TC	CPG_MFS03_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS04_LIN_STMCR	(CPG_MFS04_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_STMCR_TC	CPG_MFS04_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS05_LIN_STMCR	(CPG_MFS05_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_STMCR_TC	CPG_MFS05_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS06_LIN_STMCR	(CPG_MFS06_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_STMCR_TC	CPG_MFS06_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS07_LIN_STMCR	(CPG_MFS07_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_STMCR_TC	CPG_MFS07_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS08_LIN_STMCR	(CPG_MFS08_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_STMCR_TC	CPG_MFS08_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS09_LIN_STMCR	(CPG_MFS09_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_STMCR_TC	CPG_MFS09_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS10_LIN_STMCR	(CPG_MFS10_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_STMCR_TC	CPG_MFS10_LIN_STMCR  /*@bfrg@*/

#define CPG_MFS11_LIN_STMCR	(CPG_MFS11_LIN.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_STMCR_TC	CPG_MFS11_LIN_STMCR  /*@bfrg@*/

typedef union un_cpg_mfsn_lin_stmcr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_stmcr_t;

/* SFUR */
#define CPG_MFS00_LIN_SFUR	(CPG_MFS00_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_SFUR_TU	(CPG_MFS00_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS01_LIN_SFUR	(CPG_MFS01_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_SFUR_TU	(CPG_MFS01_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS02_LIN_SFUR	(CPG_MFS02_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_SFUR_TU	(CPG_MFS02_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS03_LIN_SFUR	(CPG_MFS03_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_SFUR_TU	(CPG_MFS03_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS04_LIN_SFUR	(CPG_MFS04_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_SFUR_TU	(CPG_MFS04_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS05_LIN_SFUR	(CPG_MFS05_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_SFUR_TU	(CPG_MFS05_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS06_LIN_SFUR	(CPG_MFS06_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_SFUR_TU	(CPG_MFS06_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS07_LIN_SFUR	(CPG_MFS07_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_SFUR_TU	(CPG_MFS07_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS08_LIN_SFUR	(CPG_MFS08_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_SFUR_TU	(CPG_MFS08_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS09_LIN_SFUR	(CPG_MFS09_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_SFUR_TU	(CPG_MFS09_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS10_LIN_SFUR	(CPG_MFS10_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_SFUR_TU	(CPG_MFS10_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

#define CPG_MFS11_LIN_SFUR	(CPG_MFS11_LIN.unSFUR.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_SFUR_TU	(CPG_MFS11_LIN.unSFUR.stcField.u15TU)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_sfur_field{
    uint_io16_t		u15TU:15;
    uint_io16_t		:1;
}stc_cpg_mfsn_lin_sfur_field_t;

typedef union un_cpg_mfsn_lin_sfur{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_lin_sfur_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_sfur_t;

/* SFLR */
#define CPG_MFS00_LIN_SFLR	(CPG_MFS00_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_SFLR_TL	(CPG_MFS00_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS01_LIN_SFLR	(CPG_MFS01_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_SFLR_TL	(CPG_MFS01_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS02_LIN_SFLR	(CPG_MFS02_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_SFLR_TL	(CPG_MFS02_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS03_LIN_SFLR	(CPG_MFS03_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_SFLR_TL	(CPG_MFS03_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS04_LIN_SFLR	(CPG_MFS04_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_SFLR_TL	(CPG_MFS04_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS05_LIN_SFLR	(CPG_MFS05_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_SFLR_TL	(CPG_MFS05_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS06_LIN_SFLR	(CPG_MFS06_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_SFLR_TL	(CPG_MFS06_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS07_LIN_SFLR	(CPG_MFS07_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_SFLR_TL	(CPG_MFS07_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS08_LIN_SFLR	(CPG_MFS08_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_SFLR_TL	(CPG_MFS08_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS09_LIN_SFLR	(CPG_MFS09_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_SFLR_TL	(CPG_MFS09_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS10_LIN_SFLR	(CPG_MFS10_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_SFLR_TL	(CPG_MFS10_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

#define CPG_MFS11_LIN_SFLR	(CPG_MFS11_LIN.unSFLR.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_SFLR_TL	(CPG_MFS11_LIN.unSFLR.stcField.u15TL)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_sflr_field{
    uint_io16_t		u15TL:15;
    uint_io16_t		:1;
}stc_cpg_mfsn_lin_sflr_field_t;

typedef union un_cpg_mfsn_lin_sflr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_lin_sflr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_sflr_t;

/* LAMCR */
#define CPG_MFS00_LIN_LAMCR	(CPG_MFS00_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMCR_LAMEN	(CPG_MFS00_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCR_LIDEN	(CPG_MFS00_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCR_LCSTYP	(CPG_MFS00_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCR_LTDRCL	(CPG_MFS00_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCR_LDL	(CPG_MFS00_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS01_LIN_LAMCR	(CPG_MFS01_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMCR_LAMEN	(CPG_MFS01_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCR_LIDEN	(CPG_MFS01_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCR_LCSTYP	(CPG_MFS01_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCR_LTDRCL	(CPG_MFS01_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCR_LDL	(CPG_MFS01_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS02_LIN_LAMCR	(CPG_MFS02_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMCR_LAMEN	(CPG_MFS02_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCR_LIDEN	(CPG_MFS02_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCR_LCSTYP	(CPG_MFS02_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCR_LTDRCL	(CPG_MFS02_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCR_LDL	(CPG_MFS02_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS03_LIN_LAMCR	(CPG_MFS03_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMCR_LAMEN	(CPG_MFS03_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCR_LIDEN	(CPG_MFS03_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCR_LCSTYP	(CPG_MFS03_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCR_LTDRCL	(CPG_MFS03_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCR_LDL	(CPG_MFS03_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS04_LIN_LAMCR	(CPG_MFS04_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMCR_LAMEN	(CPG_MFS04_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCR_LIDEN	(CPG_MFS04_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCR_LCSTYP	(CPG_MFS04_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCR_LTDRCL	(CPG_MFS04_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCR_LDL	(CPG_MFS04_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS05_LIN_LAMCR	(CPG_MFS05_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMCR_LAMEN	(CPG_MFS05_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCR_LIDEN	(CPG_MFS05_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCR_LCSTYP	(CPG_MFS05_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCR_LTDRCL	(CPG_MFS05_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCR_LDL	(CPG_MFS05_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS06_LIN_LAMCR	(CPG_MFS06_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMCR_LAMEN	(CPG_MFS06_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCR_LIDEN	(CPG_MFS06_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCR_LCSTYP	(CPG_MFS06_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCR_LTDRCL	(CPG_MFS06_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCR_LDL	(CPG_MFS06_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS07_LIN_LAMCR	(CPG_MFS07_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMCR_LAMEN	(CPG_MFS07_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCR_LIDEN	(CPG_MFS07_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCR_LCSTYP	(CPG_MFS07_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCR_LTDRCL	(CPG_MFS07_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCR_LDL	(CPG_MFS07_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS08_LIN_LAMCR	(CPG_MFS08_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMCR_LAMEN	(CPG_MFS08_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCR_LIDEN	(CPG_MFS08_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCR_LCSTYP	(CPG_MFS08_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCR_LTDRCL	(CPG_MFS08_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCR_LDL	(CPG_MFS08_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS09_LIN_LAMCR	(CPG_MFS09_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMCR_LAMEN	(CPG_MFS09_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCR_LIDEN	(CPG_MFS09_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCR_LCSTYP	(CPG_MFS09_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCR_LTDRCL	(CPG_MFS09_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCR_LDL	(CPG_MFS09_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS10_LIN_LAMCR	(CPG_MFS10_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMCR_LAMEN	(CPG_MFS10_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCR_LIDEN	(CPG_MFS10_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCR_LCSTYP	(CPG_MFS10_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCR_LTDRCL	(CPG_MFS10_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCR_LDL	(CPG_MFS10_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

#define CPG_MFS11_LIN_LAMCR	(CPG_MFS11_LIN.unLAMCR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMCR_LAMEN	(CPG_MFS11_LIN.unLAMCR.stcField.u1LAMEN)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCR_LIDEN	(CPG_MFS11_LIN.unLAMCR.stcField.u1LIDEN)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCR_LCSTYP	(CPG_MFS11_LIN.unLAMCR.stcField.u1LCSTYP)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCR_LTDRCL	(CPG_MFS11_LIN.unLAMCR.stcField.u1LTDRCL)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCR_LDL	(CPG_MFS11_LIN.unLAMCR.stcField.u4LDL)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamcr_field{
    uint_io8_t		u1LAMEN:1;
    uint_io8_t		u1LIDEN:1;
    uint_io8_t		u1LCSTYP:1;
    uint_io8_t		u1LTDRCL:1;
    uint_io8_t		u4LDL:4;
}stc_cpg_mfsn_lin_lamcr_field_t;

typedef union un_cpg_mfsn_lin_lamcr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamcr_field_t		stcField;
}un_cpg_mfsn_lin_lamcr_t;

/* LAMSR */
#define CPG_MFS00_LIN_LAMSR	(CPG_MFS00_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMSR_LAHC	(CPG_MFS00_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMSR_LCSC	(CPG_MFS00_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMSR_TBI	(CPG_MFS00_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS00_LIN_LAMSR_TDRE	(CPG_MFS00_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS00_LIN_LAMSR_RDRF	(CPG_MFS00_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS00_LIN_LAMSR_SER	(CPG_MFS00_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS00_LIN_LAMSR_LER	(CPG_MFS00_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS01_LIN_LAMSR	(CPG_MFS01_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMSR_LAHC	(CPG_MFS01_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMSR_LCSC	(CPG_MFS01_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMSR_TBI	(CPG_MFS01_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS01_LIN_LAMSR_TDRE	(CPG_MFS01_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS01_LIN_LAMSR_RDRF	(CPG_MFS01_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS01_LIN_LAMSR_SER	(CPG_MFS01_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS01_LIN_LAMSR_LER	(CPG_MFS01_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS02_LIN_LAMSR	(CPG_MFS02_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMSR_LAHC	(CPG_MFS02_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMSR_LCSC	(CPG_MFS02_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMSR_TBI	(CPG_MFS02_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS02_LIN_LAMSR_TDRE	(CPG_MFS02_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS02_LIN_LAMSR_RDRF	(CPG_MFS02_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS02_LIN_LAMSR_SER	(CPG_MFS02_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS02_LIN_LAMSR_LER	(CPG_MFS02_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS03_LIN_LAMSR	(CPG_MFS03_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMSR_LAHC	(CPG_MFS03_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMSR_LCSC	(CPG_MFS03_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMSR_TBI	(CPG_MFS03_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS03_LIN_LAMSR_TDRE	(CPG_MFS03_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS03_LIN_LAMSR_RDRF	(CPG_MFS03_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS03_LIN_LAMSR_SER	(CPG_MFS03_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS03_LIN_LAMSR_LER	(CPG_MFS03_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS04_LIN_LAMSR	(CPG_MFS04_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMSR_LAHC	(CPG_MFS04_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMSR_LCSC	(CPG_MFS04_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMSR_TBI	(CPG_MFS04_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS04_LIN_LAMSR_TDRE	(CPG_MFS04_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS04_LIN_LAMSR_RDRF	(CPG_MFS04_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS04_LIN_LAMSR_SER	(CPG_MFS04_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS04_LIN_LAMSR_LER	(CPG_MFS04_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS05_LIN_LAMSR	(CPG_MFS05_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMSR_LAHC	(CPG_MFS05_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMSR_LCSC	(CPG_MFS05_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMSR_TBI	(CPG_MFS05_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS05_LIN_LAMSR_TDRE	(CPG_MFS05_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS05_LIN_LAMSR_RDRF	(CPG_MFS05_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS05_LIN_LAMSR_SER	(CPG_MFS05_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS05_LIN_LAMSR_LER	(CPG_MFS05_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS06_LIN_LAMSR	(CPG_MFS06_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMSR_LAHC	(CPG_MFS06_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMSR_LCSC	(CPG_MFS06_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMSR_TBI	(CPG_MFS06_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS06_LIN_LAMSR_TDRE	(CPG_MFS06_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS06_LIN_LAMSR_RDRF	(CPG_MFS06_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS06_LIN_LAMSR_SER	(CPG_MFS06_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS06_LIN_LAMSR_LER	(CPG_MFS06_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS07_LIN_LAMSR	(CPG_MFS07_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMSR_LAHC	(CPG_MFS07_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMSR_LCSC	(CPG_MFS07_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMSR_TBI	(CPG_MFS07_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS07_LIN_LAMSR_TDRE	(CPG_MFS07_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS07_LIN_LAMSR_RDRF	(CPG_MFS07_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS07_LIN_LAMSR_SER	(CPG_MFS07_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS07_LIN_LAMSR_LER	(CPG_MFS07_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS08_LIN_LAMSR	(CPG_MFS08_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMSR_LAHC	(CPG_MFS08_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMSR_LCSC	(CPG_MFS08_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMSR_TBI	(CPG_MFS08_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS08_LIN_LAMSR_TDRE	(CPG_MFS08_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS08_LIN_LAMSR_RDRF	(CPG_MFS08_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS08_LIN_LAMSR_SER	(CPG_MFS08_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS08_LIN_LAMSR_LER	(CPG_MFS08_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS09_LIN_LAMSR	(CPG_MFS09_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMSR_LAHC	(CPG_MFS09_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMSR_LCSC	(CPG_MFS09_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMSR_TBI	(CPG_MFS09_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS09_LIN_LAMSR_TDRE	(CPG_MFS09_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS09_LIN_LAMSR_RDRF	(CPG_MFS09_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS09_LIN_LAMSR_SER	(CPG_MFS09_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS09_LIN_LAMSR_LER	(CPG_MFS09_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS10_LIN_LAMSR	(CPG_MFS10_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMSR_LAHC	(CPG_MFS10_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMSR_LCSC	(CPG_MFS10_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMSR_TBI	(CPG_MFS10_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS10_LIN_LAMSR_TDRE	(CPG_MFS10_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS10_LIN_LAMSR_RDRF	(CPG_MFS10_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS10_LIN_LAMSR_SER	(CPG_MFS10_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS10_LIN_LAMSR_LER	(CPG_MFS10_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

#define CPG_MFS11_LIN_LAMSR	(CPG_MFS11_LIN.unLAMSR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMSR_LAHC	(CPG_MFS11_LIN.unLAMSR.stcField.u1LAHC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMSR_LCSC	(CPG_MFS11_LIN.unLAMSR.stcField.u1LCSC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMSR_TBI	(CPG_MFS11_LIN.unLAMSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS11_LIN_LAMSR_TDRE	(CPG_MFS11_LIN.unLAMSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS11_LIN_LAMSR_RDRF	(CPG_MFS11_LIN.unLAMSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS11_LIN_LAMSR_SER	(CPG_MFS11_LIN.unLAMSR.stcField.u1SER)  /*@bf@*/
#define CPG_MFS11_LIN_LAMSR_LER	(CPG_MFS11_LIN.unLAMSR.stcField.u1LER)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamsr_field{
    uint_io8_t		u1LAHC:1;
    uint_io8_t		:1;
    uint_io8_t		u1LCSC:1;
    uint_io8_t		u1TBI:1;
    uint_io8_t		u1TDRE:1;
    uint_io8_t		u1RDRF:1;
    uint_io8_t		u1SER:1;
    uint_io8_t		u1LER:1;
}stc_cpg_mfsn_lin_lamsr_field_t;

typedef union un_cpg_mfsn_lin_lamsr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamsr_field_t		stcField;
}un_cpg_mfsn_lin_lamsr_t;

/* LAMRID */
#define CPG_MFS00_LIN_LAMRID	(CPG_MFS00_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMTID	(CPG_MFS00_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS00_LIN_LAMRID_LID	(CPG_MFS00_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS00_LIN_LAMRID_P	(CPG_MFS00_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS00_LIN_LAMTID_LID	CPG_MFS00_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS01_LIN_LAMRID	(CPG_MFS01_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMTID	(CPG_MFS01_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS01_LIN_LAMRID_LID	(CPG_MFS01_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS01_LIN_LAMRID_P	(CPG_MFS01_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS01_LIN_LAMTID_LID	CPG_MFS01_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS02_LIN_LAMRID	(CPG_MFS02_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMTID	(CPG_MFS02_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS02_LIN_LAMRID_LID	(CPG_MFS02_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS02_LIN_LAMRID_P	(CPG_MFS02_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS02_LIN_LAMTID_LID	CPG_MFS02_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS03_LIN_LAMRID	(CPG_MFS03_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMTID	(CPG_MFS03_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS03_LIN_LAMRID_LID	(CPG_MFS03_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS03_LIN_LAMRID_P	(CPG_MFS03_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS03_LIN_LAMTID_LID	CPG_MFS03_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS04_LIN_LAMRID	(CPG_MFS04_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMTID	(CPG_MFS04_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS04_LIN_LAMRID_LID	(CPG_MFS04_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS04_LIN_LAMRID_P	(CPG_MFS04_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS04_LIN_LAMTID_LID	CPG_MFS04_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS05_LIN_LAMRID	(CPG_MFS05_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMTID	(CPG_MFS05_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS05_LIN_LAMRID_LID	(CPG_MFS05_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS05_LIN_LAMRID_P	(CPG_MFS05_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS05_LIN_LAMTID_LID	CPG_MFS05_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS06_LIN_LAMRID	(CPG_MFS06_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMTID	(CPG_MFS06_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS06_LIN_LAMRID_LID	(CPG_MFS06_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS06_LIN_LAMRID_P	(CPG_MFS06_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS06_LIN_LAMTID_LID	CPG_MFS06_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS07_LIN_LAMRID	(CPG_MFS07_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMTID	(CPG_MFS07_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS07_LIN_LAMRID_LID	(CPG_MFS07_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS07_LIN_LAMRID_P	(CPG_MFS07_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS07_LIN_LAMTID_LID	CPG_MFS07_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS08_LIN_LAMRID	(CPG_MFS08_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMTID	(CPG_MFS08_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS08_LIN_LAMRID_LID	(CPG_MFS08_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS08_LIN_LAMRID_P	(CPG_MFS08_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS08_LIN_LAMTID_LID	CPG_MFS08_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS09_LIN_LAMRID	(CPG_MFS09_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMTID	(CPG_MFS09_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS09_LIN_LAMRID_LID	(CPG_MFS09_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS09_LIN_LAMRID_P	(CPG_MFS09_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS09_LIN_LAMTID_LID	CPG_MFS09_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS10_LIN_LAMRID	(CPG_MFS10_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMTID	(CPG_MFS10_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS10_LIN_LAMRID_LID	(CPG_MFS10_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS10_LIN_LAMRID_P	(CPG_MFS10_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS10_LIN_LAMTID_LID	CPG_MFS10_LIN_LAMRID_LID  /*@bf2@*/

#define CPG_MFS11_LIN_LAMRID	(CPG_MFS11_LIN.unLAMRID.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMTID	(CPG_MFS11_LIN_LAMRID)  /*@rg2@*/
#define CPG_MFS11_LIN_LAMRID_LID	(CPG_MFS11_LIN.unLAMRID.stcField.u6LID)  /*@bf@*/
#define CPG_MFS11_LIN_LAMRID_P	(CPG_MFS11_LIN.unLAMRID.stcField.u2P)  /*@bf@*/
#define CPG_MFS11_LIN_LAMTID_LID	CPG_MFS11_LIN_LAMRID_LID  /*@bf2@*/

typedef struct stc_cpg_mfsn_lin_lamrid_field{
    uint_io8_t		u6LID:6;
    uint_io8_t		u2P:2;
}stc_cpg_mfsn_lin_lamrid_field_t;

typedef union un_cpg_mfsn_lin_lamrid{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamrid_field_t		stcField;
}un_cpg_mfsn_lin_lamrid_t;

/* LAMIER */
#define CPG_MFS00_LIN_LAMIER	(CPG_MFS00_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMIER_LAHCIE	(CPG_MFS00_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIER_LCSCIE	(CPG_MFS00_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIER_LBSERIE	(CPG_MFS00_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIER_LSFERIE	(CPG_MFS00_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIER_LPTERIE	(CPG_MFS00_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIER_LCSERIE	(CPG_MFS00_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS01_LIN_LAMIER	(CPG_MFS01_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMIER_LAHCIE	(CPG_MFS01_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIER_LCSCIE	(CPG_MFS01_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIER_LBSERIE	(CPG_MFS01_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIER_LSFERIE	(CPG_MFS01_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIER_LPTERIE	(CPG_MFS01_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIER_LCSERIE	(CPG_MFS01_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS02_LIN_LAMIER	(CPG_MFS02_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMIER_LAHCIE	(CPG_MFS02_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIER_LCSCIE	(CPG_MFS02_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIER_LBSERIE	(CPG_MFS02_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIER_LSFERIE	(CPG_MFS02_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIER_LPTERIE	(CPG_MFS02_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIER_LCSERIE	(CPG_MFS02_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS03_LIN_LAMIER	(CPG_MFS03_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMIER_LAHCIE	(CPG_MFS03_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIER_LCSCIE	(CPG_MFS03_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIER_LBSERIE	(CPG_MFS03_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIER_LSFERIE	(CPG_MFS03_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIER_LPTERIE	(CPG_MFS03_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIER_LCSERIE	(CPG_MFS03_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS04_LIN_LAMIER	(CPG_MFS04_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMIER_LAHCIE	(CPG_MFS04_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIER_LCSCIE	(CPG_MFS04_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIER_LBSERIE	(CPG_MFS04_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIER_LSFERIE	(CPG_MFS04_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIER_LPTERIE	(CPG_MFS04_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIER_LCSERIE	(CPG_MFS04_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS05_LIN_LAMIER	(CPG_MFS05_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMIER_LAHCIE	(CPG_MFS05_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIER_LCSCIE	(CPG_MFS05_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIER_LBSERIE	(CPG_MFS05_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIER_LSFERIE	(CPG_MFS05_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIER_LPTERIE	(CPG_MFS05_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIER_LCSERIE	(CPG_MFS05_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS06_LIN_LAMIER	(CPG_MFS06_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMIER_LAHCIE	(CPG_MFS06_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIER_LCSCIE	(CPG_MFS06_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIER_LBSERIE	(CPG_MFS06_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIER_LSFERIE	(CPG_MFS06_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIER_LPTERIE	(CPG_MFS06_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIER_LCSERIE	(CPG_MFS06_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS07_LIN_LAMIER	(CPG_MFS07_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMIER_LAHCIE	(CPG_MFS07_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIER_LCSCIE	(CPG_MFS07_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIER_LBSERIE	(CPG_MFS07_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIER_LSFERIE	(CPG_MFS07_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIER_LPTERIE	(CPG_MFS07_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIER_LCSERIE	(CPG_MFS07_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS08_LIN_LAMIER	(CPG_MFS08_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMIER_LAHCIE	(CPG_MFS08_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIER_LCSCIE	(CPG_MFS08_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIER_LBSERIE	(CPG_MFS08_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIER_LSFERIE	(CPG_MFS08_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIER_LPTERIE	(CPG_MFS08_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIER_LCSERIE	(CPG_MFS08_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS09_LIN_LAMIER	(CPG_MFS09_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMIER_LAHCIE	(CPG_MFS09_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIER_LCSCIE	(CPG_MFS09_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIER_LBSERIE	(CPG_MFS09_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIER_LSFERIE	(CPG_MFS09_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIER_LPTERIE	(CPG_MFS09_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIER_LCSERIE	(CPG_MFS09_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS10_LIN_LAMIER	(CPG_MFS10_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMIER_LAHCIE	(CPG_MFS10_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIER_LCSCIE	(CPG_MFS10_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIER_LBSERIE	(CPG_MFS10_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIER_LSFERIE	(CPG_MFS10_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIER_LPTERIE	(CPG_MFS10_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIER_LCSERIE	(CPG_MFS10_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

#define CPG_MFS11_LIN_LAMIER	(CPG_MFS11_LIN.unLAMIER.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMIER_LAHCIE	(CPG_MFS11_LIN.unLAMIER.stcField.u1LAHCIE)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIER_LCSCIE	(CPG_MFS11_LIN.unLAMIER.stcField.u1LCSCIE)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIER_LBSERIE	(CPG_MFS11_LIN.unLAMIER.stcField.u1LBSERIE)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIER_LSFERIE	(CPG_MFS11_LIN.unLAMIER.stcField.u1LSFERIE)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIER_LPTERIE	(CPG_MFS11_LIN.unLAMIER.stcField.u1LPTERIE)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIER_LCSERIE	(CPG_MFS11_LIN.unLAMIER.stcField.u1LCSERIE)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamier_field{
    uint_io8_t		u1LAHCIE:1;
    uint_io8_t		:1;
    uint_io8_t		u1LCSCIE:1;
    uint_io8_t		u1LBSERIE:1;
    uint_io8_t		u1LSFERIE:1;
    uint_io8_t		u1LPTERIE:1;
    uint_io8_t		u1LCSERIE:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_lamier_field_t;

typedef union un_cpg_mfsn_lin_lamier{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamier_field_t		stcField;
}un_cpg_mfsn_lin_lamier_t;

/* LAMERT */
#define CPG_MFS00_LIN_LAMERT	(CPG_MFS00_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMERT_FRET	(CPG_MFS00_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS00_LIN_LAMERT_LBSERT	(CPG_MFS00_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS00_LIN_LAMERT_LSFERT	(CPG_MFS00_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS00_LIN_LAMERT_LPTERT	(CPG_MFS00_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS00_LIN_LAMERT_LCSERT	(CPG_MFS00_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS00_LIN_LAMERT_KEY	(CPG_MFS00_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS01_LIN_LAMERT	(CPG_MFS01_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMERT_FRET	(CPG_MFS01_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS01_LIN_LAMERT_LBSERT	(CPG_MFS01_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS01_LIN_LAMERT_LSFERT	(CPG_MFS01_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS01_LIN_LAMERT_LPTERT	(CPG_MFS01_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS01_LIN_LAMERT_LCSERT	(CPG_MFS01_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS01_LIN_LAMERT_KEY	(CPG_MFS01_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS02_LIN_LAMERT	(CPG_MFS02_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMERT_FRET	(CPG_MFS02_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS02_LIN_LAMERT_LBSERT	(CPG_MFS02_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS02_LIN_LAMERT_LSFERT	(CPG_MFS02_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS02_LIN_LAMERT_LPTERT	(CPG_MFS02_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS02_LIN_LAMERT_LCSERT	(CPG_MFS02_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS02_LIN_LAMERT_KEY	(CPG_MFS02_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS03_LIN_LAMERT	(CPG_MFS03_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMERT_FRET	(CPG_MFS03_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS03_LIN_LAMERT_LBSERT	(CPG_MFS03_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS03_LIN_LAMERT_LSFERT	(CPG_MFS03_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS03_LIN_LAMERT_LPTERT	(CPG_MFS03_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS03_LIN_LAMERT_LCSERT	(CPG_MFS03_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS03_LIN_LAMERT_KEY	(CPG_MFS03_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS04_LIN_LAMERT	(CPG_MFS04_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMERT_FRET	(CPG_MFS04_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS04_LIN_LAMERT_LBSERT	(CPG_MFS04_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS04_LIN_LAMERT_LSFERT	(CPG_MFS04_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS04_LIN_LAMERT_LPTERT	(CPG_MFS04_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS04_LIN_LAMERT_LCSERT	(CPG_MFS04_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS04_LIN_LAMERT_KEY	(CPG_MFS04_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS05_LIN_LAMERT	(CPG_MFS05_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMERT_FRET	(CPG_MFS05_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS05_LIN_LAMERT_LBSERT	(CPG_MFS05_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS05_LIN_LAMERT_LSFERT	(CPG_MFS05_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS05_LIN_LAMERT_LPTERT	(CPG_MFS05_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS05_LIN_LAMERT_LCSERT	(CPG_MFS05_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS05_LIN_LAMERT_KEY	(CPG_MFS05_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS06_LIN_LAMERT	(CPG_MFS06_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMERT_FRET	(CPG_MFS06_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS06_LIN_LAMERT_LBSERT	(CPG_MFS06_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS06_LIN_LAMERT_LSFERT	(CPG_MFS06_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS06_LIN_LAMERT_LPTERT	(CPG_MFS06_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS06_LIN_LAMERT_LCSERT	(CPG_MFS06_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS06_LIN_LAMERT_KEY	(CPG_MFS06_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS07_LIN_LAMERT	(CPG_MFS07_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMERT_FRET	(CPG_MFS07_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS07_LIN_LAMERT_LBSERT	(CPG_MFS07_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS07_LIN_LAMERT_LSFERT	(CPG_MFS07_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS07_LIN_LAMERT_LPTERT	(CPG_MFS07_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS07_LIN_LAMERT_LCSERT	(CPG_MFS07_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS07_LIN_LAMERT_KEY	(CPG_MFS07_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS08_LIN_LAMERT	(CPG_MFS08_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMERT_FRET	(CPG_MFS08_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS08_LIN_LAMERT_LBSERT	(CPG_MFS08_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS08_LIN_LAMERT_LSFERT	(CPG_MFS08_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS08_LIN_LAMERT_LPTERT	(CPG_MFS08_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS08_LIN_LAMERT_LCSERT	(CPG_MFS08_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS08_LIN_LAMERT_KEY	(CPG_MFS08_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS09_LIN_LAMERT	(CPG_MFS09_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMERT_FRET	(CPG_MFS09_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS09_LIN_LAMERT_LBSERT	(CPG_MFS09_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS09_LIN_LAMERT_LSFERT	(CPG_MFS09_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS09_LIN_LAMERT_LPTERT	(CPG_MFS09_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS09_LIN_LAMERT_LCSERT	(CPG_MFS09_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS09_LIN_LAMERT_KEY	(CPG_MFS09_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS10_LIN_LAMERT	(CPG_MFS10_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMERT_FRET	(CPG_MFS10_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS10_LIN_LAMERT_LBSERT	(CPG_MFS10_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS10_LIN_LAMERT_LSFERT	(CPG_MFS10_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS10_LIN_LAMERT_LPTERT	(CPG_MFS10_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS10_LIN_LAMERT_LCSERT	(CPG_MFS10_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS10_LIN_LAMERT_KEY	(CPG_MFS10_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

#define CPG_MFS11_LIN_LAMERT	(CPG_MFS11_LIN.unLAMERT.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMERT_FRET	(CPG_MFS11_LIN.unLAMERT.stcField.u1FRET)  /*@bf@*/
#define CPG_MFS11_LIN_LAMERT_LBSERT	(CPG_MFS11_LIN.unLAMERT.stcField.u1LBSERT)  /*@bf@*/
#define CPG_MFS11_LIN_LAMERT_LSFERT	(CPG_MFS11_LIN.unLAMERT.stcField.u1LSFERT)  /*@bf@*/
#define CPG_MFS11_LIN_LAMERT_LPTERT	(CPG_MFS11_LIN.unLAMERT.stcField.u1LPTERT)  /*@bf@*/
#define CPG_MFS11_LIN_LAMERT_LCSERT	(CPG_MFS11_LIN.unLAMERT.stcField.u1LCSERT)  /*@bf@*/
#define CPG_MFS11_LIN_LAMERT_KEY	(CPG_MFS11_LIN.unLAMERT.stcField.u2KEY)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamert_field{
    uint_io8_t		u1FRET:1;
    uint_io8_t		u1LBSERT:1;
    uint_io8_t		u1LSFERT:1;
    uint_io8_t		u1LPTERT:1;
    uint_io8_t		u1LCSERT:1;
    uint_io8_t		:1;
    uint_io8_t		u2KEY:2;
}stc_cpg_mfsn_lin_lamert_field_t;

typedef union un_cpg_mfsn_lin_lamert{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamert_field_t		stcField;
}un_cpg_mfsn_lin_lamert_t;

/* LAMESR */
#define CPG_MFS00_LIN_LAMESR	(CPG_MFS00_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMESR_LBSER	(CPG_MFS00_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS00_LIN_LAMESR_LSFER	(CPG_MFS00_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS00_LIN_LAMESR_LPTER	(CPG_MFS00_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS00_LIN_LAMESR_LCSER	(CPG_MFS00_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS01_LIN_LAMESR	(CPG_MFS01_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMESR_LBSER	(CPG_MFS01_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS01_LIN_LAMESR_LSFER	(CPG_MFS01_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS01_LIN_LAMESR_LPTER	(CPG_MFS01_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS01_LIN_LAMESR_LCSER	(CPG_MFS01_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS02_LIN_LAMESR	(CPG_MFS02_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMESR_LBSER	(CPG_MFS02_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS02_LIN_LAMESR_LSFER	(CPG_MFS02_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS02_LIN_LAMESR_LPTER	(CPG_MFS02_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS02_LIN_LAMESR_LCSER	(CPG_MFS02_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS03_LIN_LAMESR	(CPG_MFS03_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMESR_LBSER	(CPG_MFS03_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS03_LIN_LAMESR_LSFER	(CPG_MFS03_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS03_LIN_LAMESR_LPTER	(CPG_MFS03_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS03_LIN_LAMESR_LCSER	(CPG_MFS03_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS04_LIN_LAMESR	(CPG_MFS04_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMESR_LBSER	(CPG_MFS04_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS04_LIN_LAMESR_LSFER	(CPG_MFS04_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS04_LIN_LAMESR_LPTER	(CPG_MFS04_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS04_LIN_LAMESR_LCSER	(CPG_MFS04_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS05_LIN_LAMESR	(CPG_MFS05_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMESR_LBSER	(CPG_MFS05_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS05_LIN_LAMESR_LSFER	(CPG_MFS05_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS05_LIN_LAMESR_LPTER	(CPG_MFS05_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS05_LIN_LAMESR_LCSER	(CPG_MFS05_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS06_LIN_LAMESR	(CPG_MFS06_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMESR_LBSER	(CPG_MFS06_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS06_LIN_LAMESR_LSFER	(CPG_MFS06_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS06_LIN_LAMESR_LPTER	(CPG_MFS06_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS06_LIN_LAMESR_LCSER	(CPG_MFS06_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS07_LIN_LAMESR	(CPG_MFS07_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMESR_LBSER	(CPG_MFS07_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS07_LIN_LAMESR_LSFER	(CPG_MFS07_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS07_LIN_LAMESR_LPTER	(CPG_MFS07_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS07_LIN_LAMESR_LCSER	(CPG_MFS07_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS08_LIN_LAMESR	(CPG_MFS08_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMESR_LBSER	(CPG_MFS08_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS08_LIN_LAMESR_LSFER	(CPG_MFS08_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS08_LIN_LAMESR_LPTER	(CPG_MFS08_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS08_LIN_LAMESR_LCSER	(CPG_MFS08_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS09_LIN_LAMESR	(CPG_MFS09_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMESR_LBSER	(CPG_MFS09_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS09_LIN_LAMESR_LSFER	(CPG_MFS09_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS09_LIN_LAMESR_LPTER	(CPG_MFS09_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS09_LIN_LAMESR_LCSER	(CPG_MFS09_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS10_LIN_LAMESR	(CPG_MFS10_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMESR_LBSER	(CPG_MFS10_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS10_LIN_LAMESR_LSFER	(CPG_MFS10_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS10_LIN_LAMESR_LPTER	(CPG_MFS10_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS10_LIN_LAMESR_LCSER	(CPG_MFS10_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

#define CPG_MFS11_LIN_LAMESR	(CPG_MFS11_LIN.unLAMESR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMESR_LBSER	(CPG_MFS11_LIN.unLAMESR.stcField.u1LBSER)  /*@bf@*/
#define CPG_MFS11_LIN_LAMESR_LSFER	(CPG_MFS11_LIN.unLAMESR.stcField.u1LSFER)  /*@bf@*/
#define CPG_MFS11_LIN_LAMESR_LPTER	(CPG_MFS11_LIN.unLAMESR.stcField.u1LPTER)  /*@bf@*/
#define CPG_MFS11_LIN_LAMESR_LCSER	(CPG_MFS11_LIN.unLAMESR.stcField.u1LCSER)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamesr_field{
    uint_io8_t		:3;
    uint_io8_t		u1LBSER:1;
    uint_io8_t		u1LSFER:1;
    uint_io8_t		u1LPTER:1;
    uint_io8_t		u1LCSER:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_lamesr_field_t;

typedef union un_cpg_mfsn_lin_lamesr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamesr_field_t		stcField;
}un_cpg_mfsn_lin_lamesr_t;

/* BGR */
#define CPG_MFS00_LIN_BGR	(CPG_MFS00_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_BGR_BGR	(CPG_MFS00_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS00_LIN_BGR_EXT	(CPG_MFS00_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS01_LIN_BGR	(CPG_MFS01_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_BGR_BGR	(CPG_MFS01_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS01_LIN_BGR_EXT	(CPG_MFS01_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS02_LIN_BGR	(CPG_MFS02_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_BGR_BGR	(CPG_MFS02_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS02_LIN_BGR_EXT	(CPG_MFS02_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS03_LIN_BGR	(CPG_MFS03_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_BGR_BGR	(CPG_MFS03_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS03_LIN_BGR_EXT	(CPG_MFS03_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS04_LIN_BGR	(CPG_MFS04_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_BGR_BGR	(CPG_MFS04_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS04_LIN_BGR_EXT	(CPG_MFS04_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS05_LIN_BGR	(CPG_MFS05_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_BGR_BGR	(CPG_MFS05_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS05_LIN_BGR_EXT	(CPG_MFS05_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS06_LIN_BGR	(CPG_MFS06_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_BGR_BGR	(CPG_MFS06_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS06_LIN_BGR_EXT	(CPG_MFS06_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS07_LIN_BGR	(CPG_MFS07_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_BGR_BGR	(CPG_MFS07_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS07_LIN_BGR_EXT	(CPG_MFS07_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS08_LIN_BGR	(CPG_MFS08_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_BGR_BGR	(CPG_MFS08_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS08_LIN_BGR_EXT	(CPG_MFS08_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS09_LIN_BGR	(CPG_MFS09_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_BGR_BGR	(CPG_MFS09_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS09_LIN_BGR_EXT	(CPG_MFS09_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS10_LIN_BGR	(CPG_MFS10_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_BGR_BGR	(CPG_MFS10_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS10_LIN_BGR_EXT	(CPG_MFS10_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS11_LIN_BGR	(CPG_MFS11_LIN.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_BGR_BGR	(CPG_MFS11_LIN.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS11_LIN_BGR_EXT	(CPG_MFS11_LIN.unBGR.stcField.u1EXT)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_bgr_field{
    uint_io16_t		u15BGR:15;
    uint_io16_t		u1EXT:1;
}stc_cpg_mfsn_lin_bgr_field_t;

typedef union un_cpg_mfsn_lin_bgr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_lin_bgr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_bgr_t;

/* FCR0 */
#define CPG_MFS00_LIN_FCR0	(CPG_MFS00_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_FCR0_FE1	(CPG_MFS00_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0_FE2	(CPG_MFS00_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0_FCL1	(CPG_MFS00_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0_FCL2	(CPG_MFS00_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0_FSET	(CPG_MFS00_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0_FLD	(CPG_MFS00_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0_FLST	(CPG_MFS00_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS01_LIN_FCR0	(CPG_MFS01_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_FCR0_FE1	(CPG_MFS01_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0_FE2	(CPG_MFS01_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0_FCL1	(CPG_MFS01_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0_FCL2	(CPG_MFS01_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0_FSET	(CPG_MFS01_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0_FLD	(CPG_MFS01_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0_FLST	(CPG_MFS01_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS02_LIN_FCR0	(CPG_MFS02_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_FCR0_FE1	(CPG_MFS02_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0_FE2	(CPG_MFS02_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0_FCL1	(CPG_MFS02_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0_FCL2	(CPG_MFS02_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0_FSET	(CPG_MFS02_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0_FLD	(CPG_MFS02_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0_FLST	(CPG_MFS02_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS03_LIN_FCR0	(CPG_MFS03_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_FCR0_FE1	(CPG_MFS03_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0_FE2	(CPG_MFS03_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0_FCL1	(CPG_MFS03_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0_FCL2	(CPG_MFS03_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0_FSET	(CPG_MFS03_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0_FLD	(CPG_MFS03_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0_FLST	(CPG_MFS03_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS04_LIN_FCR0	(CPG_MFS04_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_FCR0_FE1	(CPG_MFS04_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0_FE2	(CPG_MFS04_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0_FCL1	(CPG_MFS04_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0_FCL2	(CPG_MFS04_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0_FSET	(CPG_MFS04_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0_FLD	(CPG_MFS04_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0_FLST	(CPG_MFS04_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS05_LIN_FCR0	(CPG_MFS05_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_FCR0_FE1	(CPG_MFS05_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0_FE2	(CPG_MFS05_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0_FCL1	(CPG_MFS05_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0_FCL2	(CPG_MFS05_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0_FSET	(CPG_MFS05_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0_FLD	(CPG_MFS05_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0_FLST	(CPG_MFS05_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS06_LIN_FCR0	(CPG_MFS06_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_FCR0_FE1	(CPG_MFS06_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0_FE2	(CPG_MFS06_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0_FCL1	(CPG_MFS06_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0_FCL2	(CPG_MFS06_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0_FSET	(CPG_MFS06_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0_FLD	(CPG_MFS06_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0_FLST	(CPG_MFS06_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS07_LIN_FCR0	(CPG_MFS07_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_FCR0_FE1	(CPG_MFS07_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0_FE2	(CPG_MFS07_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0_FCL1	(CPG_MFS07_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0_FCL2	(CPG_MFS07_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0_FSET	(CPG_MFS07_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0_FLD	(CPG_MFS07_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0_FLST	(CPG_MFS07_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS08_LIN_FCR0	(CPG_MFS08_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_FCR0_FE1	(CPG_MFS08_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0_FE2	(CPG_MFS08_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0_FCL1	(CPG_MFS08_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0_FCL2	(CPG_MFS08_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0_FSET	(CPG_MFS08_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0_FLD	(CPG_MFS08_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0_FLST	(CPG_MFS08_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS09_LIN_FCR0	(CPG_MFS09_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_FCR0_FE1	(CPG_MFS09_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0_FE2	(CPG_MFS09_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0_FCL1	(CPG_MFS09_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0_FCL2	(CPG_MFS09_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0_FSET	(CPG_MFS09_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0_FLD	(CPG_MFS09_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0_FLST	(CPG_MFS09_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS10_LIN_FCR0	(CPG_MFS10_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_FCR0_FE1	(CPG_MFS10_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0_FE2	(CPG_MFS10_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0_FCL1	(CPG_MFS10_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0_FCL2	(CPG_MFS10_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0_FSET	(CPG_MFS10_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0_FLD	(CPG_MFS10_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0_FLST	(CPG_MFS10_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS11_LIN_FCR0	(CPG_MFS11_LIN.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_FCR0_FE1	(CPG_MFS11_LIN.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0_FE2	(CPG_MFS11_LIN.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0_FCL1	(CPG_MFS11_LIN.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0_FCL2	(CPG_MFS11_LIN.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0_FSET	(CPG_MFS11_LIN.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0_FLD	(CPG_MFS11_LIN.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0_FLST	(CPG_MFS11_LIN.unFCR0.stcField.u1FLST)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_fcr0_field{
    uint_io8_t		u1FE1:1;
    uint_io8_t		u1FE2:1;
    uint_io8_t		u1FCL1:1;
    uint_io8_t		u1FCL2:1;
    uint_io8_t		u1FSET:1;
    uint_io8_t		u1FLD:1;
    uint_io8_t		u1FLST:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_fcr0_field_t;

typedef union un_cpg_mfsn_lin_fcr0{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_fcr0_field_t		stcField;
}un_cpg_mfsn_lin_fcr0_t;

/* FCR1 */
#define CPG_MFS00_LIN_FCR1	(CPG_MFS00_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_FCR1_FSEL	(CPG_MFS00_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1_FTIE	(CPG_MFS00_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1_FDRQ	(CPG_MFS00_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1_FRIIE	(CPG_MFS00_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1_FLSTE	(CPG_MFS00_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS01_LIN_FCR1	(CPG_MFS01_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_FCR1_FSEL	(CPG_MFS01_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1_FTIE	(CPG_MFS01_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1_FDRQ	(CPG_MFS01_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1_FRIIE	(CPG_MFS01_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1_FLSTE	(CPG_MFS01_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS02_LIN_FCR1	(CPG_MFS02_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_FCR1_FSEL	(CPG_MFS02_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1_FTIE	(CPG_MFS02_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1_FDRQ	(CPG_MFS02_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1_FRIIE	(CPG_MFS02_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1_FLSTE	(CPG_MFS02_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS03_LIN_FCR1	(CPG_MFS03_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_FCR1_FSEL	(CPG_MFS03_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1_FTIE	(CPG_MFS03_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1_FDRQ	(CPG_MFS03_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1_FRIIE	(CPG_MFS03_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1_FLSTE	(CPG_MFS03_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS04_LIN_FCR1	(CPG_MFS04_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_FCR1_FSEL	(CPG_MFS04_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1_FTIE	(CPG_MFS04_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1_FDRQ	(CPG_MFS04_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1_FRIIE	(CPG_MFS04_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1_FLSTE	(CPG_MFS04_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS05_LIN_FCR1	(CPG_MFS05_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_FCR1_FSEL	(CPG_MFS05_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1_FTIE	(CPG_MFS05_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1_FDRQ	(CPG_MFS05_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1_FRIIE	(CPG_MFS05_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1_FLSTE	(CPG_MFS05_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS06_LIN_FCR1	(CPG_MFS06_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_FCR1_FSEL	(CPG_MFS06_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1_FTIE	(CPG_MFS06_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1_FDRQ	(CPG_MFS06_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1_FRIIE	(CPG_MFS06_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1_FLSTE	(CPG_MFS06_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS07_LIN_FCR1	(CPG_MFS07_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_FCR1_FSEL	(CPG_MFS07_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1_FTIE	(CPG_MFS07_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1_FDRQ	(CPG_MFS07_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1_FRIIE	(CPG_MFS07_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1_FLSTE	(CPG_MFS07_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS08_LIN_FCR1	(CPG_MFS08_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_FCR1_FSEL	(CPG_MFS08_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1_FTIE	(CPG_MFS08_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1_FDRQ	(CPG_MFS08_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1_FRIIE	(CPG_MFS08_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1_FLSTE	(CPG_MFS08_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS09_LIN_FCR1	(CPG_MFS09_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_FCR1_FSEL	(CPG_MFS09_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1_FTIE	(CPG_MFS09_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1_FDRQ	(CPG_MFS09_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1_FRIIE	(CPG_MFS09_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1_FLSTE	(CPG_MFS09_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS10_LIN_FCR1	(CPG_MFS10_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_FCR1_FSEL	(CPG_MFS10_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1_FTIE	(CPG_MFS10_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1_FDRQ	(CPG_MFS10_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1_FRIIE	(CPG_MFS10_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1_FLSTE	(CPG_MFS10_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS11_LIN_FCR1	(CPG_MFS11_LIN.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_FCR1_FSEL	(CPG_MFS11_LIN.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1_FTIE	(CPG_MFS11_LIN.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1_FDRQ	(CPG_MFS11_LIN.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1_FRIIE	(CPG_MFS11_LIN.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1_FLSTE	(CPG_MFS11_LIN.unFCR1.stcField.u1FLSTE)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_fcr1_field{
    uint_io8_t		u1FSEL:1;
    uint_io8_t		u1FTIE:1;
    uint_io8_t		u1FDRQ:1;
    uint_io8_t		u1FRIIE:1;
    uint_io8_t		u1FLSTE:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_lin_fcr1_field_t;

typedef union un_cpg_mfsn_lin_fcr1{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_fcr1_field_t		stcField;
}un_cpg_mfsn_lin_fcr1_t;

/* FBYTE */
#define CPG_MFS00_LIN_FBYTE	(CPG_MFS00_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_FBYTE_FBYTE1	(CPG_MFS00_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS00_LIN_FBYTE_FBYTE2	(CPG_MFS00_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS01_LIN_FBYTE	(CPG_MFS01_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_FBYTE_FBYTE1	(CPG_MFS01_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS01_LIN_FBYTE_FBYTE2	(CPG_MFS01_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS02_LIN_FBYTE	(CPG_MFS02_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_FBYTE_FBYTE1	(CPG_MFS02_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS02_LIN_FBYTE_FBYTE2	(CPG_MFS02_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS03_LIN_FBYTE	(CPG_MFS03_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_FBYTE_FBYTE1	(CPG_MFS03_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS03_LIN_FBYTE_FBYTE2	(CPG_MFS03_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS04_LIN_FBYTE	(CPG_MFS04_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_FBYTE_FBYTE1	(CPG_MFS04_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS04_LIN_FBYTE_FBYTE2	(CPG_MFS04_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS05_LIN_FBYTE	(CPG_MFS05_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_FBYTE_FBYTE1	(CPG_MFS05_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS05_LIN_FBYTE_FBYTE2	(CPG_MFS05_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS06_LIN_FBYTE	(CPG_MFS06_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_FBYTE_FBYTE1	(CPG_MFS06_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS06_LIN_FBYTE_FBYTE2	(CPG_MFS06_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS07_LIN_FBYTE	(CPG_MFS07_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_FBYTE_FBYTE1	(CPG_MFS07_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS07_LIN_FBYTE_FBYTE2	(CPG_MFS07_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS08_LIN_FBYTE	(CPG_MFS08_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_FBYTE_FBYTE1	(CPG_MFS08_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS08_LIN_FBYTE_FBYTE2	(CPG_MFS08_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS09_LIN_FBYTE	(CPG_MFS09_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_FBYTE_FBYTE1	(CPG_MFS09_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS09_LIN_FBYTE_FBYTE2	(CPG_MFS09_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS10_LIN_FBYTE	(CPG_MFS10_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_FBYTE_FBYTE1	(CPG_MFS10_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS10_LIN_FBYTE_FBYTE2	(CPG_MFS10_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS11_LIN_FBYTE	(CPG_MFS11_LIN.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_FBYTE_FBYTE1	(CPG_MFS11_LIN.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS11_LIN_FBYTE_FBYTE2	(CPG_MFS11_LIN.unFBYTE.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_mfsn_lin_fbyte_field{
    uint_io16_t		u8FBYTE1:8;
    uint_io16_t		u8FBYTE2:8;
}stc_cpg_mfsn_lin_fbyte_field_t;

typedef union un_cpg_mfsn_lin_fbyte{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_lin_fbyte_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_fbyte_t;

/* FTICR */
#define CPG_MFS00_LIN_FTICR	(CPG_MFS00_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_FTICR_FTICR1	(CPG_MFS00_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS00_LIN_FTICR_FTICR2	(CPG_MFS00_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS01_LIN_FTICR	(CPG_MFS01_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_FTICR_FTICR1	(CPG_MFS01_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS01_LIN_FTICR_FTICR2	(CPG_MFS01_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS02_LIN_FTICR	(CPG_MFS02_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_FTICR_FTICR1	(CPG_MFS02_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS02_LIN_FTICR_FTICR2	(CPG_MFS02_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS03_LIN_FTICR	(CPG_MFS03_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_FTICR_FTICR1	(CPG_MFS03_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS03_LIN_FTICR_FTICR2	(CPG_MFS03_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS04_LIN_FTICR	(CPG_MFS04_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_FTICR_FTICR1	(CPG_MFS04_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS04_LIN_FTICR_FTICR2	(CPG_MFS04_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS05_LIN_FTICR	(CPG_MFS05_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_FTICR_FTICR1	(CPG_MFS05_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS05_LIN_FTICR_FTICR2	(CPG_MFS05_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS06_LIN_FTICR	(CPG_MFS06_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_FTICR_FTICR1	(CPG_MFS06_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS06_LIN_FTICR_FTICR2	(CPG_MFS06_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS07_LIN_FTICR	(CPG_MFS07_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_FTICR_FTICR1	(CPG_MFS07_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS07_LIN_FTICR_FTICR2	(CPG_MFS07_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS08_LIN_FTICR	(CPG_MFS08_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_FTICR_FTICR1	(CPG_MFS08_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS08_LIN_FTICR_FTICR2	(CPG_MFS08_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS09_LIN_FTICR	(CPG_MFS09_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_FTICR_FTICR1	(CPG_MFS09_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS09_LIN_FTICR_FTICR2	(CPG_MFS09_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS10_LIN_FTICR	(CPG_MFS10_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_FTICR_FTICR1	(CPG_MFS10_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS10_LIN_FTICR_FTICR2	(CPG_MFS10_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS11_LIN_FTICR	(CPG_MFS11_LIN.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_FTICR_FTICR1	(CPG_MFS11_LIN.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS11_LIN_FTICR_FTICR2	(CPG_MFS11_LIN.unFTICR.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_mfsn_lin_fticr_field{
    uint_io16_t		u8FTICR1:8;
    uint_io16_t		u8FTICR2:8;
}stc_cpg_mfsn_lin_fticr_field_t;

typedef union un_cpg_mfsn_lin_fticr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_lin_fticr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_fticr_t;

/* ECR */
#define CPG_MFS00_LIN_ECR	(CPG_MFS00_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_ECR_TXBLKEN	(CPG_MFS00_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS00_LIN_ECR_RXBLKEN	(CPG_MFS00_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS00_LIN_ECR_TEIE	(CPG_MFS00_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS00_LIN_ECR_REIE	(CPG_MFS00_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS00_LIN_ECR_EISEL	(CPG_MFS00_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS01_LIN_ECR	(CPG_MFS01_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_ECR_TXBLKEN	(CPG_MFS01_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS01_LIN_ECR_RXBLKEN	(CPG_MFS01_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS01_LIN_ECR_TEIE	(CPG_MFS01_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS01_LIN_ECR_REIE	(CPG_MFS01_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS01_LIN_ECR_EISEL	(CPG_MFS01_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS02_LIN_ECR	(CPG_MFS02_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_ECR_TXBLKEN	(CPG_MFS02_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS02_LIN_ECR_RXBLKEN	(CPG_MFS02_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS02_LIN_ECR_TEIE	(CPG_MFS02_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS02_LIN_ECR_REIE	(CPG_MFS02_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS02_LIN_ECR_EISEL	(CPG_MFS02_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS03_LIN_ECR	(CPG_MFS03_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_ECR_TXBLKEN	(CPG_MFS03_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS03_LIN_ECR_RXBLKEN	(CPG_MFS03_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS03_LIN_ECR_TEIE	(CPG_MFS03_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS03_LIN_ECR_REIE	(CPG_MFS03_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS03_LIN_ECR_EISEL	(CPG_MFS03_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS04_LIN_ECR	(CPG_MFS04_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_ECR_TXBLKEN	(CPG_MFS04_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS04_LIN_ECR_RXBLKEN	(CPG_MFS04_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS04_LIN_ECR_TEIE	(CPG_MFS04_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS04_LIN_ECR_REIE	(CPG_MFS04_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS04_LIN_ECR_EISEL	(CPG_MFS04_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS05_LIN_ECR	(CPG_MFS05_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_ECR_TXBLKEN	(CPG_MFS05_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS05_LIN_ECR_RXBLKEN	(CPG_MFS05_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS05_LIN_ECR_TEIE	(CPG_MFS05_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS05_LIN_ECR_REIE	(CPG_MFS05_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS05_LIN_ECR_EISEL	(CPG_MFS05_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS06_LIN_ECR	(CPG_MFS06_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_ECR_TXBLKEN	(CPG_MFS06_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS06_LIN_ECR_RXBLKEN	(CPG_MFS06_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS06_LIN_ECR_TEIE	(CPG_MFS06_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS06_LIN_ECR_REIE	(CPG_MFS06_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS06_LIN_ECR_EISEL	(CPG_MFS06_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS07_LIN_ECR	(CPG_MFS07_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_ECR_TXBLKEN	(CPG_MFS07_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS07_LIN_ECR_RXBLKEN	(CPG_MFS07_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS07_LIN_ECR_TEIE	(CPG_MFS07_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS07_LIN_ECR_REIE	(CPG_MFS07_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS07_LIN_ECR_EISEL	(CPG_MFS07_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS08_LIN_ECR	(CPG_MFS08_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_ECR_TXBLKEN	(CPG_MFS08_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS08_LIN_ECR_RXBLKEN	(CPG_MFS08_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS08_LIN_ECR_TEIE	(CPG_MFS08_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS08_LIN_ECR_REIE	(CPG_MFS08_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS08_LIN_ECR_EISEL	(CPG_MFS08_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS09_LIN_ECR	(CPG_MFS09_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_ECR_TXBLKEN	(CPG_MFS09_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS09_LIN_ECR_RXBLKEN	(CPG_MFS09_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS09_LIN_ECR_TEIE	(CPG_MFS09_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS09_LIN_ECR_REIE	(CPG_MFS09_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS09_LIN_ECR_EISEL	(CPG_MFS09_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS10_LIN_ECR	(CPG_MFS10_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_ECR_TXBLKEN	(CPG_MFS10_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS10_LIN_ECR_RXBLKEN	(CPG_MFS10_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS10_LIN_ECR_TEIE	(CPG_MFS10_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS10_LIN_ECR_REIE	(CPG_MFS10_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS10_LIN_ECR_EISEL	(CPG_MFS10_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS11_LIN_ECR	(CPG_MFS11_LIN.unECR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_ECR_TXBLKEN	(CPG_MFS11_LIN.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS11_LIN_ECR_RXBLKEN	(CPG_MFS11_LIN.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS11_LIN_ECR_TEIE	(CPG_MFS11_LIN.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS11_LIN_ECR_REIE	(CPG_MFS11_LIN.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS11_LIN_ECR_EISEL	(CPG_MFS11_LIN.unECR.stcField.u1EISEL)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_ecr_field{
    uint_io8_t		u1TXBLKEN:1;
    uint_io8_t		u1RXBLKEN:1;
    uint_io8_t		u1TEIE:1;
    uint_io8_t		u1REIE:1;
    uint_io8_t		u1EISEL:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_lin_ecr_field_t;

typedef union un_cpg_mfsn_lin_ecr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_ecr_field_t		stcField;
}un_cpg_mfsn_lin_ecr_t;

/* ESR */
#define CPG_MFS00_LIN_ESR	(CPG_MFS00_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_ESR_TBERR	(CPG_MFS00_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS00_LIN_ESR_RBERR	(CPG_MFS00_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS00_LIN_ESR_TXOVR	(CPG_MFS00_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS00_LIN_ESR_RXUDR	(CPG_MFS00_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS01_LIN_ESR	(CPG_MFS01_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_ESR_TBERR	(CPG_MFS01_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS01_LIN_ESR_RBERR	(CPG_MFS01_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS01_LIN_ESR_TXOVR	(CPG_MFS01_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS01_LIN_ESR_RXUDR	(CPG_MFS01_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS02_LIN_ESR	(CPG_MFS02_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_ESR_TBERR	(CPG_MFS02_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS02_LIN_ESR_RBERR	(CPG_MFS02_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS02_LIN_ESR_TXOVR	(CPG_MFS02_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS02_LIN_ESR_RXUDR	(CPG_MFS02_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS03_LIN_ESR	(CPG_MFS03_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_ESR_TBERR	(CPG_MFS03_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS03_LIN_ESR_RBERR	(CPG_MFS03_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS03_LIN_ESR_TXOVR	(CPG_MFS03_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS03_LIN_ESR_RXUDR	(CPG_MFS03_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS04_LIN_ESR	(CPG_MFS04_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_ESR_TBERR	(CPG_MFS04_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS04_LIN_ESR_RBERR	(CPG_MFS04_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS04_LIN_ESR_TXOVR	(CPG_MFS04_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS04_LIN_ESR_RXUDR	(CPG_MFS04_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS05_LIN_ESR	(CPG_MFS05_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_ESR_TBERR	(CPG_MFS05_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS05_LIN_ESR_RBERR	(CPG_MFS05_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS05_LIN_ESR_TXOVR	(CPG_MFS05_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS05_LIN_ESR_RXUDR	(CPG_MFS05_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS06_LIN_ESR	(CPG_MFS06_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_ESR_TBERR	(CPG_MFS06_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS06_LIN_ESR_RBERR	(CPG_MFS06_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS06_LIN_ESR_TXOVR	(CPG_MFS06_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS06_LIN_ESR_RXUDR	(CPG_MFS06_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS07_LIN_ESR	(CPG_MFS07_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_ESR_TBERR	(CPG_MFS07_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS07_LIN_ESR_RBERR	(CPG_MFS07_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS07_LIN_ESR_TXOVR	(CPG_MFS07_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS07_LIN_ESR_RXUDR	(CPG_MFS07_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS08_LIN_ESR	(CPG_MFS08_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_ESR_TBERR	(CPG_MFS08_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS08_LIN_ESR_RBERR	(CPG_MFS08_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS08_LIN_ESR_TXOVR	(CPG_MFS08_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS08_LIN_ESR_RXUDR	(CPG_MFS08_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS09_LIN_ESR	(CPG_MFS09_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_ESR_TBERR	(CPG_MFS09_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS09_LIN_ESR_RBERR	(CPG_MFS09_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS09_LIN_ESR_TXOVR	(CPG_MFS09_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS09_LIN_ESR_RXUDR	(CPG_MFS09_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS10_LIN_ESR	(CPG_MFS10_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_ESR_TBERR	(CPG_MFS10_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS10_LIN_ESR_RBERR	(CPG_MFS10_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS10_LIN_ESR_TXOVR	(CPG_MFS10_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS10_LIN_ESR_RXUDR	(CPG_MFS10_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS11_LIN_ESR	(CPG_MFS11_LIN.unESR.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_ESR_TBERR	(CPG_MFS11_LIN.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS11_LIN_ESR_RBERR	(CPG_MFS11_LIN.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS11_LIN_ESR_TXOVR	(CPG_MFS11_LIN.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS11_LIN_ESR_RXUDR	(CPG_MFS11_LIN.unESR.stcField.u1RXUDR)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_esr_field{
    uint_io8_t		u1TBERR:1;
    uint_io8_t		u1RBERR:1;
    uint_io8_t		u1TXOVR:1;
    uint_io8_t		u1RXUDR:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_lin_esr_field_t;

typedef union un_cpg_mfsn_lin_esr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_esr_field_t		stcField;
}un_cpg_mfsn_lin_esr_t;

/* TBSIZE */
#define CPG_MFS00_LIN_TBSIZE	(CPG_MFS00_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_TBSIZE_TBSIZE	CPG_MFS00_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS01_LIN_TBSIZE	(CPG_MFS01_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_TBSIZE_TBSIZE	CPG_MFS01_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS02_LIN_TBSIZE	(CPG_MFS02_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_TBSIZE_TBSIZE	CPG_MFS02_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS03_LIN_TBSIZE	(CPG_MFS03_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_TBSIZE_TBSIZE	CPG_MFS03_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS04_LIN_TBSIZE	(CPG_MFS04_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_TBSIZE_TBSIZE	CPG_MFS04_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS05_LIN_TBSIZE	(CPG_MFS05_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_TBSIZE_TBSIZE	CPG_MFS05_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS06_LIN_TBSIZE	(CPG_MFS06_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_TBSIZE_TBSIZE	CPG_MFS06_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS07_LIN_TBSIZE	(CPG_MFS07_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_TBSIZE_TBSIZE	CPG_MFS07_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS08_LIN_TBSIZE	(CPG_MFS08_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_TBSIZE_TBSIZE	CPG_MFS08_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS09_LIN_TBSIZE	(CPG_MFS09_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_TBSIZE_TBSIZE	CPG_MFS09_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS10_LIN_TBSIZE	(CPG_MFS10_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_TBSIZE_TBSIZE	CPG_MFS10_LIN_TBSIZE  /*@bfrg@*/

#define CPG_MFS11_LIN_TBSIZE	(CPG_MFS11_LIN.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_TBSIZE_TBSIZE	CPG_MFS11_LIN_TBSIZE  /*@bfrg@*/

typedef union un_cpg_mfsn_lin_tbsize{
    uint_io8_t		u8Register;
}un_cpg_mfsn_lin_tbsize_t;

/* SMRC */
#define CPG_MFS00_LIN_SMRC	(CPG_MFS00_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SMRC_SOEC	(CPG_MFS00_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS00_LIN_SMRC_SBLC	(CPG_MFS00_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS00_LIN_SMRC_WUCRC	(CPG_MFS00_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS01_LIN_SMRC	(CPG_MFS01_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SMRC_SOEC	(CPG_MFS01_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS01_LIN_SMRC_SBLC	(CPG_MFS01_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS01_LIN_SMRC_WUCRC	(CPG_MFS01_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS02_LIN_SMRC	(CPG_MFS02_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SMRC_SOEC	(CPG_MFS02_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS02_LIN_SMRC_SBLC	(CPG_MFS02_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS02_LIN_SMRC_WUCRC	(CPG_MFS02_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS03_LIN_SMRC	(CPG_MFS03_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SMRC_SOEC	(CPG_MFS03_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS03_LIN_SMRC_SBLC	(CPG_MFS03_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS03_LIN_SMRC_WUCRC	(CPG_MFS03_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS04_LIN_SMRC	(CPG_MFS04_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SMRC_SOEC	(CPG_MFS04_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS04_LIN_SMRC_SBLC	(CPG_MFS04_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS04_LIN_SMRC_WUCRC	(CPG_MFS04_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS05_LIN_SMRC	(CPG_MFS05_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SMRC_SOEC	(CPG_MFS05_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS05_LIN_SMRC_SBLC	(CPG_MFS05_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS05_LIN_SMRC_WUCRC	(CPG_MFS05_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS06_LIN_SMRC	(CPG_MFS06_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SMRC_SOEC	(CPG_MFS06_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS06_LIN_SMRC_SBLC	(CPG_MFS06_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS06_LIN_SMRC_WUCRC	(CPG_MFS06_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS07_LIN_SMRC	(CPG_MFS07_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SMRC_SOEC	(CPG_MFS07_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS07_LIN_SMRC_SBLC	(CPG_MFS07_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS07_LIN_SMRC_WUCRC	(CPG_MFS07_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS08_LIN_SMRC	(CPG_MFS08_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SMRC_SOEC	(CPG_MFS08_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS08_LIN_SMRC_SBLC	(CPG_MFS08_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS08_LIN_SMRC_WUCRC	(CPG_MFS08_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS09_LIN_SMRC	(CPG_MFS09_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SMRC_SOEC	(CPG_MFS09_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS09_LIN_SMRC_SBLC	(CPG_MFS09_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS09_LIN_SMRC_WUCRC	(CPG_MFS09_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS10_LIN_SMRC	(CPG_MFS10_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SMRC_SOEC	(CPG_MFS10_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS10_LIN_SMRC_SBLC	(CPG_MFS10_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS10_LIN_SMRC_WUCRC	(CPG_MFS10_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

#define CPG_MFS11_LIN_SMRC	(CPG_MFS11_LIN.unSMRC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SMRC_SOEC	(CPG_MFS11_LIN.unSMRC.stcField.u1SOEC)  /*@bf@*/
#define CPG_MFS11_LIN_SMRC_SBLC	(CPG_MFS11_LIN.unSMRC.stcField.u1SBLC)  /*@bf@*/
#define CPG_MFS11_LIN_SMRC_WUCRC	(CPG_MFS11_LIN.unSMRC.stcField.u1WUCRC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_smrc_field{
    uint_io8_t		u1SOEC:1;
    uint_io8_t		:2;
    uint_io8_t		u1SBLC:1;
    uint_io8_t		u1WUCRC:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_lin_smrc_field_t;

typedef union un_cpg_mfsn_lin_smrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_smrc_field_t		stcField;
}un_cpg_mfsn_lin_smrc_t;

/* SCRC */
#define CPG_MFS00_LIN_SCRC	(CPG_MFS00_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SCRC_TXEC	(CPG_MFS00_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS00_LIN_SCRC_RXEC	(CPG_MFS00_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS00_LIN_SCRC_TBIEC	(CPG_MFS00_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS00_LIN_SCRC_TIEC	(CPG_MFS00_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS00_LIN_SCRC_RIEC	(CPG_MFS00_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS00_LIN_SCRC_MSC	(CPG_MFS00_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS01_LIN_SCRC	(CPG_MFS01_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SCRC_TXEC	(CPG_MFS01_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS01_LIN_SCRC_RXEC	(CPG_MFS01_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS01_LIN_SCRC_TBIEC	(CPG_MFS01_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS01_LIN_SCRC_TIEC	(CPG_MFS01_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS01_LIN_SCRC_RIEC	(CPG_MFS01_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS01_LIN_SCRC_MSC	(CPG_MFS01_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS02_LIN_SCRC	(CPG_MFS02_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SCRC_TXEC	(CPG_MFS02_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS02_LIN_SCRC_RXEC	(CPG_MFS02_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS02_LIN_SCRC_TBIEC	(CPG_MFS02_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS02_LIN_SCRC_TIEC	(CPG_MFS02_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS02_LIN_SCRC_RIEC	(CPG_MFS02_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS02_LIN_SCRC_MSC	(CPG_MFS02_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS03_LIN_SCRC	(CPG_MFS03_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SCRC_TXEC	(CPG_MFS03_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS03_LIN_SCRC_RXEC	(CPG_MFS03_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS03_LIN_SCRC_TBIEC	(CPG_MFS03_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS03_LIN_SCRC_TIEC	(CPG_MFS03_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS03_LIN_SCRC_RIEC	(CPG_MFS03_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS03_LIN_SCRC_MSC	(CPG_MFS03_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS04_LIN_SCRC	(CPG_MFS04_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SCRC_TXEC	(CPG_MFS04_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS04_LIN_SCRC_RXEC	(CPG_MFS04_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS04_LIN_SCRC_TBIEC	(CPG_MFS04_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS04_LIN_SCRC_TIEC	(CPG_MFS04_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS04_LIN_SCRC_RIEC	(CPG_MFS04_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS04_LIN_SCRC_MSC	(CPG_MFS04_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS05_LIN_SCRC	(CPG_MFS05_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SCRC_TXEC	(CPG_MFS05_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS05_LIN_SCRC_RXEC	(CPG_MFS05_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS05_LIN_SCRC_TBIEC	(CPG_MFS05_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS05_LIN_SCRC_TIEC	(CPG_MFS05_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS05_LIN_SCRC_RIEC	(CPG_MFS05_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS05_LIN_SCRC_MSC	(CPG_MFS05_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS06_LIN_SCRC	(CPG_MFS06_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SCRC_TXEC	(CPG_MFS06_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS06_LIN_SCRC_RXEC	(CPG_MFS06_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS06_LIN_SCRC_TBIEC	(CPG_MFS06_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS06_LIN_SCRC_TIEC	(CPG_MFS06_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS06_LIN_SCRC_RIEC	(CPG_MFS06_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS06_LIN_SCRC_MSC	(CPG_MFS06_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS07_LIN_SCRC	(CPG_MFS07_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SCRC_TXEC	(CPG_MFS07_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS07_LIN_SCRC_RXEC	(CPG_MFS07_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS07_LIN_SCRC_TBIEC	(CPG_MFS07_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS07_LIN_SCRC_TIEC	(CPG_MFS07_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS07_LIN_SCRC_RIEC	(CPG_MFS07_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS07_LIN_SCRC_MSC	(CPG_MFS07_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS08_LIN_SCRC	(CPG_MFS08_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SCRC_TXEC	(CPG_MFS08_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS08_LIN_SCRC_RXEC	(CPG_MFS08_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS08_LIN_SCRC_TBIEC	(CPG_MFS08_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS08_LIN_SCRC_TIEC	(CPG_MFS08_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS08_LIN_SCRC_RIEC	(CPG_MFS08_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS08_LIN_SCRC_MSC	(CPG_MFS08_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS09_LIN_SCRC	(CPG_MFS09_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SCRC_TXEC	(CPG_MFS09_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS09_LIN_SCRC_RXEC	(CPG_MFS09_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS09_LIN_SCRC_TBIEC	(CPG_MFS09_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS09_LIN_SCRC_TIEC	(CPG_MFS09_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS09_LIN_SCRC_RIEC	(CPG_MFS09_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS09_LIN_SCRC_MSC	(CPG_MFS09_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS10_LIN_SCRC	(CPG_MFS10_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SCRC_TXEC	(CPG_MFS10_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS10_LIN_SCRC_RXEC	(CPG_MFS10_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS10_LIN_SCRC_TBIEC	(CPG_MFS10_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS10_LIN_SCRC_TIEC	(CPG_MFS10_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS10_LIN_SCRC_RIEC	(CPG_MFS10_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS10_LIN_SCRC_MSC	(CPG_MFS10_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

#define CPG_MFS11_LIN_SCRC	(CPG_MFS11_LIN.unSCRC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SCRC_TXEC	(CPG_MFS11_LIN.unSCRC.stcField.u1TXEC)  /*@bf@*/
#define CPG_MFS11_LIN_SCRC_RXEC	(CPG_MFS11_LIN.unSCRC.stcField.u1RXEC)  /*@bf@*/
#define CPG_MFS11_LIN_SCRC_TBIEC	(CPG_MFS11_LIN.unSCRC.stcField.u1TBIEC)  /*@bf@*/
#define CPG_MFS11_LIN_SCRC_TIEC	(CPG_MFS11_LIN.unSCRC.stcField.u1TIEC)  /*@bf@*/
#define CPG_MFS11_LIN_SCRC_RIEC	(CPG_MFS11_LIN.unSCRC.stcField.u1RIEC)  /*@bf@*/
#define CPG_MFS11_LIN_SCRC_MSC	(CPG_MFS11_LIN.unSCRC.stcField.u1MSC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_scrc_field{
    uint_io8_t		u1TXEC:1;
    uint_io8_t		u1RXEC:1;
    uint_io8_t		u1TBIEC:1;
    uint_io8_t		u1TIEC:1;
    uint_io8_t		u1RIEC:1;
    uint_io8_t		:1;
    uint_io8_t		u1MSC:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_scrc_field_t;

typedef union un_cpg_mfsn_lin_scrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_scrc_field_t		stcField;
}un_cpg_mfsn_lin_scrc_t;

/* ESCRC */
#define CPG_MFS00_LIN_ESCRC	(CPG_MFS00_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_ESCRC_LBIEC	(CPG_MFS00_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS00_LIN_ESCRC_ESBLC	(CPG_MFS00_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS01_LIN_ESCRC	(CPG_MFS01_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_ESCRC_LBIEC	(CPG_MFS01_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS01_LIN_ESCRC_ESBLC	(CPG_MFS01_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS02_LIN_ESCRC	(CPG_MFS02_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_ESCRC_LBIEC	(CPG_MFS02_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS02_LIN_ESCRC_ESBLC	(CPG_MFS02_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS03_LIN_ESCRC	(CPG_MFS03_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_ESCRC_LBIEC	(CPG_MFS03_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS03_LIN_ESCRC_ESBLC	(CPG_MFS03_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS04_LIN_ESCRC	(CPG_MFS04_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_ESCRC_LBIEC	(CPG_MFS04_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS04_LIN_ESCRC_ESBLC	(CPG_MFS04_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS05_LIN_ESCRC	(CPG_MFS05_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_ESCRC_LBIEC	(CPG_MFS05_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS05_LIN_ESCRC_ESBLC	(CPG_MFS05_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS06_LIN_ESCRC	(CPG_MFS06_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_ESCRC_LBIEC	(CPG_MFS06_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS06_LIN_ESCRC_ESBLC	(CPG_MFS06_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS07_LIN_ESCRC	(CPG_MFS07_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_ESCRC_LBIEC	(CPG_MFS07_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS07_LIN_ESCRC_ESBLC	(CPG_MFS07_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS08_LIN_ESCRC	(CPG_MFS08_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_ESCRC_LBIEC	(CPG_MFS08_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS08_LIN_ESCRC_ESBLC	(CPG_MFS08_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS09_LIN_ESCRC	(CPG_MFS09_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_ESCRC_LBIEC	(CPG_MFS09_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS09_LIN_ESCRC_ESBLC	(CPG_MFS09_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS10_LIN_ESCRC	(CPG_MFS10_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_ESCRC_LBIEC	(CPG_MFS10_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS10_LIN_ESCRC_ESBLC	(CPG_MFS10_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

#define CPG_MFS11_LIN_ESCRC	(CPG_MFS11_LIN.unESCRC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_ESCRC_LBIEC	(CPG_MFS11_LIN.unESCRC.stcField.u1LBIEC)  /*@bf@*/
#define CPG_MFS11_LIN_ESCRC_ESBLC	(CPG_MFS11_LIN.unESCRC.stcField.u1ESBLC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_escrc_field{
    uint_io8_t		:4;
    uint_io8_t		u1LBIEC:1;
    uint_io8_t		:1;
    uint_io8_t		u1ESBLC:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_escrc_field_t;

typedef union un_cpg_mfsn_lin_escrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_escrc_field_t		stcField;
}un_cpg_mfsn_lin_escrc_t;

/* SSRC */
#define CPG_MFS00_LIN_SSRC	(CPG_MFS00_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SSRC_LBDC	(CPG_MFS00_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS01_LIN_SSRC	(CPG_MFS01_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SSRC_LBDC	(CPG_MFS01_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS02_LIN_SSRC	(CPG_MFS02_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SSRC_LBDC	(CPG_MFS02_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS03_LIN_SSRC	(CPG_MFS03_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SSRC_LBDC	(CPG_MFS03_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS04_LIN_SSRC	(CPG_MFS04_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SSRC_LBDC	(CPG_MFS04_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS05_LIN_SSRC	(CPG_MFS05_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SSRC_LBDC	(CPG_MFS05_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS06_LIN_SSRC	(CPG_MFS06_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SSRC_LBDC	(CPG_MFS06_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS07_LIN_SSRC	(CPG_MFS07_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SSRC_LBDC	(CPG_MFS07_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS08_LIN_SSRC	(CPG_MFS08_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SSRC_LBDC	(CPG_MFS08_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS09_LIN_SSRC	(CPG_MFS09_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SSRC_LBDC	(CPG_MFS09_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS10_LIN_SSRC	(CPG_MFS10_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SSRC_LBDC	(CPG_MFS10_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

#define CPG_MFS11_LIN_SSRC	(CPG_MFS11_LIN.unSSRC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SSRC_LBDC	(CPG_MFS11_LIN.unSSRC.stcField.u1LBDC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_ssrc_field{
    uint_io8_t		:5;
    uint_io8_t		u1LBDC:1;
    uint_io8_t		:2;
}stc_cpg_mfsn_lin_ssrc_field_t;

typedef union un_cpg_mfsn_lin_ssrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_ssrc_field_t		stcField;
}un_cpg_mfsn_lin_ssrc_t;

/* SACSRC */
#define CPG_MFS00_LIN_SACSRC	(CPG_MFS00_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_SACSRC_TMREC	(CPG_MFS00_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRC_TRGEC	(CPG_MFS00_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRC_TINTEC	(CPG_MFS00_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRC_TINTC	(CPG_MFS00_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRC_AUTEC	(CPG_MFS00_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRC_SFDEC	(CPG_MFS00_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRC_SFDC	(CPG_MFS00_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRC_STSTC	(CPG_MFS00_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS01_LIN_SACSRC	(CPG_MFS01_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_SACSRC_TMREC	(CPG_MFS01_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRC_TRGEC	(CPG_MFS01_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRC_TINTEC	(CPG_MFS01_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRC_TINTC	(CPG_MFS01_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRC_AUTEC	(CPG_MFS01_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRC_SFDEC	(CPG_MFS01_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRC_SFDC	(CPG_MFS01_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRC_STSTC	(CPG_MFS01_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS02_LIN_SACSRC	(CPG_MFS02_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_SACSRC_TMREC	(CPG_MFS02_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRC_TRGEC	(CPG_MFS02_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRC_TINTEC	(CPG_MFS02_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRC_TINTC	(CPG_MFS02_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRC_AUTEC	(CPG_MFS02_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRC_SFDEC	(CPG_MFS02_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRC_SFDC	(CPG_MFS02_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRC_STSTC	(CPG_MFS02_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS03_LIN_SACSRC	(CPG_MFS03_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_SACSRC_TMREC	(CPG_MFS03_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRC_TRGEC	(CPG_MFS03_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRC_TINTEC	(CPG_MFS03_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRC_TINTC	(CPG_MFS03_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRC_AUTEC	(CPG_MFS03_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRC_SFDEC	(CPG_MFS03_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRC_SFDC	(CPG_MFS03_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRC_STSTC	(CPG_MFS03_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS04_LIN_SACSRC	(CPG_MFS04_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_SACSRC_TMREC	(CPG_MFS04_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRC_TRGEC	(CPG_MFS04_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRC_TINTEC	(CPG_MFS04_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRC_TINTC	(CPG_MFS04_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRC_AUTEC	(CPG_MFS04_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRC_SFDEC	(CPG_MFS04_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRC_SFDC	(CPG_MFS04_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRC_STSTC	(CPG_MFS04_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS05_LIN_SACSRC	(CPG_MFS05_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_SACSRC_TMREC	(CPG_MFS05_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRC_TRGEC	(CPG_MFS05_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRC_TINTEC	(CPG_MFS05_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRC_TINTC	(CPG_MFS05_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRC_AUTEC	(CPG_MFS05_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRC_SFDEC	(CPG_MFS05_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRC_SFDC	(CPG_MFS05_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRC_STSTC	(CPG_MFS05_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS06_LIN_SACSRC	(CPG_MFS06_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_SACSRC_TMREC	(CPG_MFS06_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRC_TRGEC	(CPG_MFS06_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRC_TINTEC	(CPG_MFS06_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRC_TINTC	(CPG_MFS06_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRC_AUTEC	(CPG_MFS06_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRC_SFDEC	(CPG_MFS06_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRC_SFDC	(CPG_MFS06_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRC_STSTC	(CPG_MFS06_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS07_LIN_SACSRC	(CPG_MFS07_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_SACSRC_TMREC	(CPG_MFS07_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRC_TRGEC	(CPG_MFS07_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRC_TINTEC	(CPG_MFS07_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRC_TINTC	(CPG_MFS07_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRC_AUTEC	(CPG_MFS07_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRC_SFDEC	(CPG_MFS07_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRC_SFDC	(CPG_MFS07_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRC_STSTC	(CPG_MFS07_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS08_LIN_SACSRC	(CPG_MFS08_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_SACSRC_TMREC	(CPG_MFS08_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRC_TRGEC	(CPG_MFS08_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRC_TINTEC	(CPG_MFS08_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRC_TINTC	(CPG_MFS08_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRC_AUTEC	(CPG_MFS08_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRC_SFDEC	(CPG_MFS08_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRC_SFDC	(CPG_MFS08_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRC_STSTC	(CPG_MFS08_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS09_LIN_SACSRC	(CPG_MFS09_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_SACSRC_TMREC	(CPG_MFS09_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRC_TRGEC	(CPG_MFS09_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRC_TINTEC	(CPG_MFS09_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRC_TINTC	(CPG_MFS09_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRC_AUTEC	(CPG_MFS09_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRC_SFDEC	(CPG_MFS09_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRC_SFDC	(CPG_MFS09_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRC_STSTC	(CPG_MFS09_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS10_LIN_SACSRC	(CPG_MFS10_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_SACSRC_TMREC	(CPG_MFS10_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRC_TRGEC	(CPG_MFS10_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRC_TINTEC	(CPG_MFS10_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRC_TINTC	(CPG_MFS10_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRC_AUTEC	(CPG_MFS10_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRC_SFDEC	(CPG_MFS10_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRC_SFDC	(CPG_MFS10_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRC_STSTC	(CPG_MFS10_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS11_LIN_SACSRC	(CPG_MFS11_LIN.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_SACSRC_TMREC	(CPG_MFS11_LIN.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRC_TRGEC	(CPG_MFS11_LIN.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRC_TINTEC	(CPG_MFS11_LIN.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRC_TINTC	(CPG_MFS11_LIN.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRC_AUTEC	(CPG_MFS11_LIN.unSACSRC.stcField.u1AUTEC)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRC_SFDEC	(CPG_MFS11_LIN.unSACSRC.stcField.u1SFDEC)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRC_SFDC	(CPG_MFS11_LIN.unSACSRC.stcField.u1SFDC)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRC_STSTC	(CPG_MFS11_LIN.unSACSRC.stcField.u1STSTC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_sacsrc_field{
    uint_io16_t		u1TMREC:1;
    uint_io16_t		:4;
    uint_io16_t		u1TRGEC:1;
    uint_io16_t		:1;
    uint_io16_t		u1TINTEC:1;
    uint_io16_t		u1TINTC:1;
    uint_io16_t		:2;
    uint_io16_t		u1AUTEC:1;
    uint_io16_t		u1SFDEC:1;
    uint_io16_t		u1SFDC:1;
    uint_io16_t		:1;
    uint_io16_t		u1STSTC:1;
}stc_cpg_mfsn_lin_sacsrc_field_t;

typedef union un_cpg_mfsn_lin_sacsrc{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_lin_sacsrc_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_sacsrc_t;

/* LAMCRC */
#define CPG_MFS00_LIN_LAMCRC	(CPG_MFS00_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMCRC_LAMENC	(CPG_MFS00_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCRC_LIDENC	(CPG_MFS00_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCRC_LCSTYPC	(CPG_MFS00_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS01_LIN_LAMCRC	(CPG_MFS01_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMCRC_LAMENC	(CPG_MFS01_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCRC_LIDENC	(CPG_MFS01_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCRC_LCSTYPC	(CPG_MFS01_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS02_LIN_LAMCRC	(CPG_MFS02_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMCRC_LAMENC	(CPG_MFS02_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCRC_LIDENC	(CPG_MFS02_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCRC_LCSTYPC	(CPG_MFS02_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS03_LIN_LAMCRC	(CPG_MFS03_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMCRC_LAMENC	(CPG_MFS03_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCRC_LIDENC	(CPG_MFS03_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCRC_LCSTYPC	(CPG_MFS03_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS04_LIN_LAMCRC	(CPG_MFS04_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMCRC_LAMENC	(CPG_MFS04_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCRC_LIDENC	(CPG_MFS04_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCRC_LCSTYPC	(CPG_MFS04_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS05_LIN_LAMCRC	(CPG_MFS05_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMCRC_LAMENC	(CPG_MFS05_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCRC_LIDENC	(CPG_MFS05_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCRC_LCSTYPC	(CPG_MFS05_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS06_LIN_LAMCRC	(CPG_MFS06_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMCRC_LAMENC	(CPG_MFS06_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCRC_LIDENC	(CPG_MFS06_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCRC_LCSTYPC	(CPG_MFS06_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS07_LIN_LAMCRC	(CPG_MFS07_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMCRC_LAMENC	(CPG_MFS07_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCRC_LIDENC	(CPG_MFS07_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCRC_LCSTYPC	(CPG_MFS07_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS08_LIN_LAMCRC	(CPG_MFS08_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMCRC_LAMENC	(CPG_MFS08_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCRC_LIDENC	(CPG_MFS08_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCRC_LCSTYPC	(CPG_MFS08_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS09_LIN_LAMCRC	(CPG_MFS09_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMCRC_LAMENC	(CPG_MFS09_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCRC_LIDENC	(CPG_MFS09_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCRC_LCSTYPC	(CPG_MFS09_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS10_LIN_LAMCRC	(CPG_MFS10_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMCRC_LAMENC	(CPG_MFS10_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCRC_LIDENC	(CPG_MFS10_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCRC_LCSTYPC	(CPG_MFS10_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

#define CPG_MFS11_LIN_LAMCRC	(CPG_MFS11_LIN.unLAMCRC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMCRC_LAMENC	(CPG_MFS11_LIN.unLAMCRC.stcField.u1LAMENC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCRC_LIDENC	(CPG_MFS11_LIN.unLAMCRC.stcField.u1LIDENC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCRC_LCSTYPC	(CPG_MFS11_LIN.unLAMCRC.stcField.u1LCSTYPC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamcrc_field{
    uint_io8_t		u1LAMENC:1;
    uint_io8_t		u1LIDENC:1;
    uint_io8_t		u1LCSTYPC:1;
    uint_io8_t		:5;
}stc_cpg_mfsn_lin_lamcrc_field_t;

typedef union un_cpg_mfsn_lin_lamcrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamcrc_field_t		stcField;
}un_cpg_mfsn_lin_lamcrc_t;

/* LAMSRC */
#define CPG_MFS00_LIN_LAMSRC	(CPG_MFS00_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMSRC_LAHCC	(CPG_MFS00_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMSRC_LCSCC	(CPG_MFS00_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS01_LIN_LAMSRC	(CPG_MFS01_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMSRC_LAHCC	(CPG_MFS01_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMSRC_LCSCC	(CPG_MFS01_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS02_LIN_LAMSRC	(CPG_MFS02_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMSRC_LAHCC	(CPG_MFS02_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMSRC_LCSCC	(CPG_MFS02_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS03_LIN_LAMSRC	(CPG_MFS03_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMSRC_LAHCC	(CPG_MFS03_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMSRC_LCSCC	(CPG_MFS03_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS04_LIN_LAMSRC	(CPG_MFS04_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMSRC_LAHCC	(CPG_MFS04_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMSRC_LCSCC	(CPG_MFS04_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS05_LIN_LAMSRC	(CPG_MFS05_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMSRC_LAHCC	(CPG_MFS05_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMSRC_LCSCC	(CPG_MFS05_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS06_LIN_LAMSRC	(CPG_MFS06_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMSRC_LAHCC	(CPG_MFS06_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMSRC_LCSCC	(CPG_MFS06_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS07_LIN_LAMSRC	(CPG_MFS07_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMSRC_LAHCC	(CPG_MFS07_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMSRC_LCSCC	(CPG_MFS07_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS08_LIN_LAMSRC	(CPG_MFS08_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMSRC_LAHCC	(CPG_MFS08_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMSRC_LCSCC	(CPG_MFS08_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS09_LIN_LAMSRC	(CPG_MFS09_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMSRC_LAHCC	(CPG_MFS09_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMSRC_LCSCC	(CPG_MFS09_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS10_LIN_LAMSRC	(CPG_MFS10_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMSRC_LAHCC	(CPG_MFS10_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMSRC_LCSCC	(CPG_MFS10_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

#define CPG_MFS11_LIN_LAMSRC	(CPG_MFS11_LIN.unLAMSRC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMSRC_LAHCC	(CPG_MFS11_LIN.unLAMSRC.stcField.u1LAHCC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMSRC_LCSCC	(CPG_MFS11_LIN.unLAMSRC.stcField.u1LCSCC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamsrc_field{
    uint_io8_t		u1LAHCC:1;
    uint_io8_t		:1;
    uint_io8_t		u1LCSCC:1;
    uint_io8_t		:5;
}stc_cpg_mfsn_lin_lamsrc_field_t;

typedef union un_cpg_mfsn_lin_lamsrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamsrc_field_t		stcField;
}un_cpg_mfsn_lin_lamsrc_t;

/* LAMIERC */
#define CPG_MFS00_LIN_LAMIERC	(CPG_MFS00_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMIERC_LAHCIEC	(CPG_MFS00_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERC_LCSCIEC	(CPG_MFS00_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERC_LBSERIEC	(CPG_MFS00_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERC_LSFERIEC	(CPG_MFS00_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERC_LPTERIEC	(CPG_MFS00_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERC_LCSERIEC	(CPG_MFS00_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS01_LIN_LAMIERC	(CPG_MFS01_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMIERC_LAHCIEC	(CPG_MFS01_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERC_LCSCIEC	(CPG_MFS01_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERC_LBSERIEC	(CPG_MFS01_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERC_LSFERIEC	(CPG_MFS01_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERC_LPTERIEC	(CPG_MFS01_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERC_LCSERIEC	(CPG_MFS01_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS02_LIN_LAMIERC	(CPG_MFS02_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMIERC_LAHCIEC	(CPG_MFS02_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERC_LCSCIEC	(CPG_MFS02_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERC_LBSERIEC	(CPG_MFS02_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERC_LSFERIEC	(CPG_MFS02_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERC_LPTERIEC	(CPG_MFS02_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERC_LCSERIEC	(CPG_MFS02_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS03_LIN_LAMIERC	(CPG_MFS03_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMIERC_LAHCIEC	(CPG_MFS03_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERC_LCSCIEC	(CPG_MFS03_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERC_LBSERIEC	(CPG_MFS03_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERC_LSFERIEC	(CPG_MFS03_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERC_LPTERIEC	(CPG_MFS03_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERC_LCSERIEC	(CPG_MFS03_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS04_LIN_LAMIERC	(CPG_MFS04_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMIERC_LAHCIEC	(CPG_MFS04_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERC_LCSCIEC	(CPG_MFS04_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERC_LBSERIEC	(CPG_MFS04_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERC_LSFERIEC	(CPG_MFS04_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERC_LPTERIEC	(CPG_MFS04_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERC_LCSERIEC	(CPG_MFS04_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS05_LIN_LAMIERC	(CPG_MFS05_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMIERC_LAHCIEC	(CPG_MFS05_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERC_LCSCIEC	(CPG_MFS05_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERC_LBSERIEC	(CPG_MFS05_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERC_LSFERIEC	(CPG_MFS05_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERC_LPTERIEC	(CPG_MFS05_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERC_LCSERIEC	(CPG_MFS05_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS06_LIN_LAMIERC	(CPG_MFS06_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMIERC_LAHCIEC	(CPG_MFS06_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERC_LCSCIEC	(CPG_MFS06_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERC_LBSERIEC	(CPG_MFS06_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERC_LSFERIEC	(CPG_MFS06_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERC_LPTERIEC	(CPG_MFS06_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERC_LCSERIEC	(CPG_MFS06_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS07_LIN_LAMIERC	(CPG_MFS07_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMIERC_LAHCIEC	(CPG_MFS07_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERC_LCSCIEC	(CPG_MFS07_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERC_LBSERIEC	(CPG_MFS07_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERC_LSFERIEC	(CPG_MFS07_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERC_LPTERIEC	(CPG_MFS07_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERC_LCSERIEC	(CPG_MFS07_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS08_LIN_LAMIERC	(CPG_MFS08_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMIERC_LAHCIEC	(CPG_MFS08_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERC_LCSCIEC	(CPG_MFS08_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERC_LBSERIEC	(CPG_MFS08_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERC_LSFERIEC	(CPG_MFS08_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERC_LPTERIEC	(CPG_MFS08_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERC_LCSERIEC	(CPG_MFS08_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS09_LIN_LAMIERC	(CPG_MFS09_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMIERC_LAHCIEC	(CPG_MFS09_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERC_LCSCIEC	(CPG_MFS09_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERC_LBSERIEC	(CPG_MFS09_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERC_LSFERIEC	(CPG_MFS09_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERC_LPTERIEC	(CPG_MFS09_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERC_LCSERIEC	(CPG_MFS09_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS10_LIN_LAMIERC	(CPG_MFS10_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMIERC_LAHCIEC	(CPG_MFS10_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERC_LCSCIEC	(CPG_MFS10_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERC_LBSERIEC	(CPG_MFS10_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERC_LSFERIEC	(CPG_MFS10_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERC_LPTERIEC	(CPG_MFS10_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERC_LCSERIEC	(CPG_MFS10_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

#define CPG_MFS11_LIN_LAMIERC	(CPG_MFS11_LIN.unLAMIERC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMIERC_LAHCIEC	(CPG_MFS11_LIN.unLAMIERC.stcField.u1LAHCIEC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERC_LCSCIEC	(CPG_MFS11_LIN.unLAMIERC.stcField.u1LCSCIEC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERC_LBSERIEC	(CPG_MFS11_LIN.unLAMIERC.stcField.u1LBSERIEC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERC_LSFERIEC	(CPG_MFS11_LIN.unLAMIERC.stcField.u1LSFERIEC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERC_LPTERIEC	(CPG_MFS11_LIN.unLAMIERC.stcField.u1LPTERIEC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERC_LCSERIEC	(CPG_MFS11_LIN.unLAMIERC.stcField.u1LCSERIEC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamierc_field{
    uint_io8_t		u1LAHCIEC:1;
    uint_io8_t		:1;
    uint_io8_t		u1LCSCIEC:1;
    uint_io8_t		u1LBSERIEC:1;
    uint_io8_t		u1LSFERIEC:1;
    uint_io8_t		u1LPTERIEC:1;
    uint_io8_t		u1LCSERIEC:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_lamierc_field_t;

typedef union un_cpg_mfsn_lin_lamierc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamierc_field_t		stcField;
}un_cpg_mfsn_lin_lamierc_t;

/* LAMESRC */
#define CPG_MFS00_LIN_LAMESRC	(CPG_MFS00_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMESRC_LBSERC	(CPG_MFS00_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMESRC_LSFERC	(CPG_MFS00_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMESRC_LPTERC	(CPG_MFS00_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS00_LIN_LAMESRC_LCSERC	(CPG_MFS00_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS01_LIN_LAMESRC	(CPG_MFS01_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMESRC_LBSERC	(CPG_MFS01_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMESRC_LSFERC	(CPG_MFS01_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMESRC_LPTERC	(CPG_MFS01_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS01_LIN_LAMESRC_LCSERC	(CPG_MFS01_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS02_LIN_LAMESRC	(CPG_MFS02_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMESRC_LBSERC	(CPG_MFS02_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMESRC_LSFERC	(CPG_MFS02_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMESRC_LPTERC	(CPG_MFS02_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS02_LIN_LAMESRC_LCSERC	(CPG_MFS02_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS03_LIN_LAMESRC	(CPG_MFS03_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMESRC_LBSERC	(CPG_MFS03_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMESRC_LSFERC	(CPG_MFS03_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMESRC_LPTERC	(CPG_MFS03_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS03_LIN_LAMESRC_LCSERC	(CPG_MFS03_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS04_LIN_LAMESRC	(CPG_MFS04_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMESRC_LBSERC	(CPG_MFS04_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMESRC_LSFERC	(CPG_MFS04_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMESRC_LPTERC	(CPG_MFS04_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS04_LIN_LAMESRC_LCSERC	(CPG_MFS04_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS05_LIN_LAMESRC	(CPG_MFS05_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMESRC_LBSERC	(CPG_MFS05_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMESRC_LSFERC	(CPG_MFS05_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMESRC_LPTERC	(CPG_MFS05_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS05_LIN_LAMESRC_LCSERC	(CPG_MFS05_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS06_LIN_LAMESRC	(CPG_MFS06_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMESRC_LBSERC	(CPG_MFS06_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMESRC_LSFERC	(CPG_MFS06_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMESRC_LPTERC	(CPG_MFS06_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS06_LIN_LAMESRC_LCSERC	(CPG_MFS06_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS07_LIN_LAMESRC	(CPG_MFS07_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMESRC_LBSERC	(CPG_MFS07_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMESRC_LSFERC	(CPG_MFS07_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMESRC_LPTERC	(CPG_MFS07_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS07_LIN_LAMESRC_LCSERC	(CPG_MFS07_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS08_LIN_LAMESRC	(CPG_MFS08_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMESRC_LBSERC	(CPG_MFS08_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMESRC_LSFERC	(CPG_MFS08_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMESRC_LPTERC	(CPG_MFS08_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS08_LIN_LAMESRC_LCSERC	(CPG_MFS08_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS09_LIN_LAMESRC	(CPG_MFS09_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMESRC_LBSERC	(CPG_MFS09_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMESRC_LSFERC	(CPG_MFS09_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMESRC_LPTERC	(CPG_MFS09_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS09_LIN_LAMESRC_LCSERC	(CPG_MFS09_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS10_LIN_LAMESRC	(CPG_MFS10_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMESRC_LBSERC	(CPG_MFS10_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMESRC_LSFERC	(CPG_MFS10_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMESRC_LPTERC	(CPG_MFS10_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS10_LIN_LAMESRC_LCSERC	(CPG_MFS10_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

#define CPG_MFS11_LIN_LAMESRC	(CPG_MFS11_LIN.unLAMESRC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMESRC_LBSERC	(CPG_MFS11_LIN.unLAMESRC.stcField.u1LBSERC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMESRC_LSFERC	(CPG_MFS11_LIN.unLAMESRC.stcField.u1LSFERC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMESRC_LPTERC	(CPG_MFS11_LIN.unLAMESRC.stcField.u1LPTERC)  /*@bf@*/
#define CPG_MFS11_LIN_LAMESRC_LCSERC	(CPG_MFS11_LIN.unLAMESRC.stcField.u1LCSERC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamesrc_field{
    uint_io8_t		:3;
    uint_io8_t		u1LBSERC:1;
    uint_io8_t		u1LSFERC:1;
    uint_io8_t		u1LPTERC:1;
    uint_io8_t		u1LCSERC:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_lamesrc_field_t;

typedef union un_cpg_mfsn_lin_lamesrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamesrc_field_t		stcField;
}un_cpg_mfsn_lin_lamesrc_t;

/* FCR0C */
#define CPG_MFS00_LIN_FCR0C	(CPG_MFS00_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_FCR0C_FE1C	(CPG_MFS00_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0C_FE2C	(CPG_MFS00_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS01_LIN_FCR0C	(CPG_MFS01_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_FCR0C_FE1C	(CPG_MFS01_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0C_FE2C	(CPG_MFS01_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS02_LIN_FCR0C	(CPG_MFS02_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_FCR0C_FE1C	(CPG_MFS02_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0C_FE2C	(CPG_MFS02_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS03_LIN_FCR0C	(CPG_MFS03_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_FCR0C_FE1C	(CPG_MFS03_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0C_FE2C	(CPG_MFS03_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS04_LIN_FCR0C	(CPG_MFS04_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_FCR0C_FE1C	(CPG_MFS04_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0C_FE2C	(CPG_MFS04_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS05_LIN_FCR0C	(CPG_MFS05_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_FCR0C_FE1C	(CPG_MFS05_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0C_FE2C	(CPG_MFS05_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS06_LIN_FCR0C	(CPG_MFS06_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_FCR0C_FE1C	(CPG_MFS06_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0C_FE2C	(CPG_MFS06_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS07_LIN_FCR0C	(CPG_MFS07_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_FCR0C_FE1C	(CPG_MFS07_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0C_FE2C	(CPG_MFS07_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS08_LIN_FCR0C	(CPG_MFS08_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_FCR0C_FE1C	(CPG_MFS08_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0C_FE2C	(CPG_MFS08_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS09_LIN_FCR0C	(CPG_MFS09_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_FCR0C_FE1C	(CPG_MFS09_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0C_FE2C	(CPG_MFS09_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS10_LIN_FCR0C	(CPG_MFS10_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_FCR0C_FE1C	(CPG_MFS10_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0C_FE2C	(CPG_MFS10_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS11_LIN_FCR0C	(CPG_MFS11_LIN.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_FCR0C_FE1C	(CPG_MFS11_LIN.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0C_FE2C	(CPG_MFS11_LIN.unFCR0C.stcField.u1FE2C)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_fcr0c_field{
    uint_io8_t		u1FE1C:1;
    uint_io8_t		u1FE2C:1;
    uint_io8_t		:6;
}stc_cpg_mfsn_lin_fcr0c_field_t;

typedef union un_cpg_mfsn_lin_fcr0c{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_fcr0c_field_t		stcField;
}un_cpg_mfsn_lin_fcr0c_t;

/* FCR1C */
#define CPG_MFS00_LIN_FCR1C	(CPG_MFS00_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_FCR1C_FSELC	(CPG_MFS00_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1C_FTIEC	(CPG_MFS00_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1C_FDRQC	(CPG_MFS00_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1C_FRIIEC	(CPG_MFS00_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1C_FLSTEC	(CPG_MFS00_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS01_LIN_FCR1C	(CPG_MFS01_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_FCR1C_FSELC	(CPG_MFS01_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1C_FTIEC	(CPG_MFS01_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1C_FDRQC	(CPG_MFS01_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1C_FRIIEC	(CPG_MFS01_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1C_FLSTEC	(CPG_MFS01_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS02_LIN_FCR1C	(CPG_MFS02_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_FCR1C_FSELC	(CPG_MFS02_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1C_FTIEC	(CPG_MFS02_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1C_FDRQC	(CPG_MFS02_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1C_FRIIEC	(CPG_MFS02_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1C_FLSTEC	(CPG_MFS02_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS03_LIN_FCR1C	(CPG_MFS03_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_FCR1C_FSELC	(CPG_MFS03_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1C_FTIEC	(CPG_MFS03_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1C_FDRQC	(CPG_MFS03_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1C_FRIIEC	(CPG_MFS03_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1C_FLSTEC	(CPG_MFS03_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS04_LIN_FCR1C	(CPG_MFS04_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_FCR1C_FSELC	(CPG_MFS04_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1C_FTIEC	(CPG_MFS04_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1C_FDRQC	(CPG_MFS04_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1C_FRIIEC	(CPG_MFS04_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1C_FLSTEC	(CPG_MFS04_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS05_LIN_FCR1C	(CPG_MFS05_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_FCR1C_FSELC	(CPG_MFS05_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1C_FTIEC	(CPG_MFS05_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1C_FDRQC	(CPG_MFS05_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1C_FRIIEC	(CPG_MFS05_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1C_FLSTEC	(CPG_MFS05_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS06_LIN_FCR1C	(CPG_MFS06_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_FCR1C_FSELC	(CPG_MFS06_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1C_FTIEC	(CPG_MFS06_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1C_FDRQC	(CPG_MFS06_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1C_FRIIEC	(CPG_MFS06_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1C_FLSTEC	(CPG_MFS06_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS07_LIN_FCR1C	(CPG_MFS07_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_FCR1C_FSELC	(CPG_MFS07_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1C_FTIEC	(CPG_MFS07_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1C_FDRQC	(CPG_MFS07_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1C_FRIIEC	(CPG_MFS07_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1C_FLSTEC	(CPG_MFS07_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS08_LIN_FCR1C	(CPG_MFS08_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_FCR1C_FSELC	(CPG_MFS08_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1C_FTIEC	(CPG_MFS08_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1C_FDRQC	(CPG_MFS08_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1C_FRIIEC	(CPG_MFS08_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1C_FLSTEC	(CPG_MFS08_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS09_LIN_FCR1C	(CPG_MFS09_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_FCR1C_FSELC	(CPG_MFS09_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1C_FTIEC	(CPG_MFS09_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1C_FDRQC	(CPG_MFS09_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1C_FRIIEC	(CPG_MFS09_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1C_FLSTEC	(CPG_MFS09_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS10_LIN_FCR1C	(CPG_MFS10_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_FCR1C_FSELC	(CPG_MFS10_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1C_FTIEC	(CPG_MFS10_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1C_FDRQC	(CPG_MFS10_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1C_FRIIEC	(CPG_MFS10_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1C_FLSTEC	(CPG_MFS10_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS11_LIN_FCR1C	(CPG_MFS11_LIN.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_FCR1C_FSELC	(CPG_MFS11_LIN.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1C_FTIEC	(CPG_MFS11_LIN.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1C_FDRQC	(CPG_MFS11_LIN.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1C_FRIIEC	(CPG_MFS11_LIN.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1C_FLSTEC	(CPG_MFS11_LIN.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_fcr1c_field{
    uint_io8_t		u1FSELC:1;
    uint_io8_t		u1FTIEC:1;
    uint_io8_t		u1FDRQC:1;
    uint_io8_t		u1FRIIEC:1;
    uint_io8_t		u1FLSTEC:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_lin_fcr1c_field_t;

typedef union un_cpg_mfsn_lin_fcr1c{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_fcr1c_field_t		stcField;
}un_cpg_mfsn_lin_fcr1c_t;

/* ESRC */
#define CPG_MFS00_LIN_ESRC	(CPG_MFS00_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_ESRC_TBERRC	(CPG_MFS00_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS00_LIN_ESRC_RBERRC	(CPG_MFS00_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS00_LIN_ESRC_TXOVRC	(CPG_MFS00_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS00_LIN_ESRC_RXUDRC	(CPG_MFS00_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS01_LIN_ESRC	(CPG_MFS01_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_ESRC_TBERRC	(CPG_MFS01_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS01_LIN_ESRC_RBERRC	(CPG_MFS01_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS01_LIN_ESRC_TXOVRC	(CPG_MFS01_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS01_LIN_ESRC_RXUDRC	(CPG_MFS01_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS02_LIN_ESRC	(CPG_MFS02_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_ESRC_TBERRC	(CPG_MFS02_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS02_LIN_ESRC_RBERRC	(CPG_MFS02_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS02_LIN_ESRC_TXOVRC	(CPG_MFS02_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS02_LIN_ESRC_RXUDRC	(CPG_MFS02_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS03_LIN_ESRC	(CPG_MFS03_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_ESRC_TBERRC	(CPG_MFS03_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS03_LIN_ESRC_RBERRC	(CPG_MFS03_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS03_LIN_ESRC_TXOVRC	(CPG_MFS03_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS03_LIN_ESRC_RXUDRC	(CPG_MFS03_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS04_LIN_ESRC	(CPG_MFS04_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_ESRC_TBERRC	(CPG_MFS04_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS04_LIN_ESRC_RBERRC	(CPG_MFS04_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS04_LIN_ESRC_TXOVRC	(CPG_MFS04_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS04_LIN_ESRC_RXUDRC	(CPG_MFS04_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS05_LIN_ESRC	(CPG_MFS05_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_ESRC_TBERRC	(CPG_MFS05_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS05_LIN_ESRC_RBERRC	(CPG_MFS05_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS05_LIN_ESRC_TXOVRC	(CPG_MFS05_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS05_LIN_ESRC_RXUDRC	(CPG_MFS05_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS06_LIN_ESRC	(CPG_MFS06_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_ESRC_TBERRC	(CPG_MFS06_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS06_LIN_ESRC_RBERRC	(CPG_MFS06_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS06_LIN_ESRC_TXOVRC	(CPG_MFS06_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS06_LIN_ESRC_RXUDRC	(CPG_MFS06_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS07_LIN_ESRC	(CPG_MFS07_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_ESRC_TBERRC	(CPG_MFS07_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS07_LIN_ESRC_RBERRC	(CPG_MFS07_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS07_LIN_ESRC_TXOVRC	(CPG_MFS07_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS07_LIN_ESRC_RXUDRC	(CPG_MFS07_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS08_LIN_ESRC	(CPG_MFS08_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_ESRC_TBERRC	(CPG_MFS08_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS08_LIN_ESRC_RBERRC	(CPG_MFS08_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS08_LIN_ESRC_TXOVRC	(CPG_MFS08_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS08_LIN_ESRC_RXUDRC	(CPG_MFS08_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS09_LIN_ESRC	(CPG_MFS09_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_ESRC_TBERRC	(CPG_MFS09_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS09_LIN_ESRC_RBERRC	(CPG_MFS09_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS09_LIN_ESRC_TXOVRC	(CPG_MFS09_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS09_LIN_ESRC_RXUDRC	(CPG_MFS09_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS10_LIN_ESRC	(CPG_MFS10_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_ESRC_TBERRC	(CPG_MFS10_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS10_LIN_ESRC_RBERRC	(CPG_MFS10_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS10_LIN_ESRC_TXOVRC	(CPG_MFS10_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS10_LIN_ESRC_RXUDRC	(CPG_MFS10_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS11_LIN_ESRC	(CPG_MFS11_LIN.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_ESRC_TBERRC	(CPG_MFS11_LIN.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS11_LIN_ESRC_RBERRC	(CPG_MFS11_LIN.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS11_LIN_ESRC_TXOVRC	(CPG_MFS11_LIN.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS11_LIN_ESRC_RXUDRC	(CPG_MFS11_LIN.unESRC.stcField.u1RXUDRC)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_esrc_field{
    uint_io8_t		u1TBERRC:1;
    uint_io8_t		u1RBERRC:1;
    uint_io8_t		u1TXOVRC:1;
    uint_io8_t		u1RXUDRC:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_lin_esrc_field_t;

typedef union un_cpg_mfsn_lin_esrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_esrc_field_t		stcField;
}un_cpg_mfsn_lin_esrc_t;

/* SMRS */
#define CPG_MFS00_LIN_SMRS	(CPG_MFS00_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SMRS_SOES	(CPG_MFS00_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS00_LIN_SMRS_SBLS	(CPG_MFS00_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS00_LIN_SMRS_WUCRS	(CPG_MFS00_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS01_LIN_SMRS	(CPG_MFS01_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SMRS_SOES	(CPG_MFS01_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS01_LIN_SMRS_SBLS	(CPG_MFS01_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS01_LIN_SMRS_WUCRS	(CPG_MFS01_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS02_LIN_SMRS	(CPG_MFS02_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SMRS_SOES	(CPG_MFS02_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS02_LIN_SMRS_SBLS	(CPG_MFS02_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS02_LIN_SMRS_WUCRS	(CPG_MFS02_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS03_LIN_SMRS	(CPG_MFS03_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SMRS_SOES	(CPG_MFS03_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS03_LIN_SMRS_SBLS	(CPG_MFS03_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS03_LIN_SMRS_WUCRS	(CPG_MFS03_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS04_LIN_SMRS	(CPG_MFS04_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SMRS_SOES	(CPG_MFS04_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS04_LIN_SMRS_SBLS	(CPG_MFS04_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS04_LIN_SMRS_WUCRS	(CPG_MFS04_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS05_LIN_SMRS	(CPG_MFS05_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SMRS_SOES	(CPG_MFS05_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS05_LIN_SMRS_SBLS	(CPG_MFS05_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS05_LIN_SMRS_WUCRS	(CPG_MFS05_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS06_LIN_SMRS	(CPG_MFS06_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SMRS_SOES	(CPG_MFS06_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS06_LIN_SMRS_SBLS	(CPG_MFS06_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS06_LIN_SMRS_WUCRS	(CPG_MFS06_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS07_LIN_SMRS	(CPG_MFS07_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SMRS_SOES	(CPG_MFS07_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS07_LIN_SMRS_SBLS	(CPG_MFS07_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS07_LIN_SMRS_WUCRS	(CPG_MFS07_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS08_LIN_SMRS	(CPG_MFS08_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SMRS_SOES	(CPG_MFS08_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS08_LIN_SMRS_SBLS	(CPG_MFS08_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS08_LIN_SMRS_WUCRS	(CPG_MFS08_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS09_LIN_SMRS	(CPG_MFS09_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SMRS_SOES	(CPG_MFS09_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS09_LIN_SMRS_SBLS	(CPG_MFS09_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS09_LIN_SMRS_WUCRS	(CPG_MFS09_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS10_LIN_SMRS	(CPG_MFS10_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SMRS_SOES	(CPG_MFS10_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS10_LIN_SMRS_SBLS	(CPG_MFS10_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS10_LIN_SMRS_WUCRS	(CPG_MFS10_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

#define CPG_MFS11_LIN_SMRS	(CPG_MFS11_LIN.unSMRS.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SMRS_SOES	(CPG_MFS11_LIN.unSMRS.stcField.u1SOES)  /*@bf@*/
#define CPG_MFS11_LIN_SMRS_SBLS	(CPG_MFS11_LIN.unSMRS.stcField.u1SBLS)  /*@bf@*/
#define CPG_MFS11_LIN_SMRS_WUCRS	(CPG_MFS11_LIN.unSMRS.stcField.u1WUCRS)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_smrs_field{
    uint_io8_t		u1SOES:1;
    uint_io8_t		:2;
    uint_io8_t		u1SBLS:1;
    uint_io8_t		u1WUCRS:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_lin_smrs_field_t;

typedef union un_cpg_mfsn_lin_smrs{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_smrs_field_t		stcField;
}un_cpg_mfsn_lin_smrs_t;

/* SCRS */
#define CPG_MFS00_LIN_SCRS	(CPG_MFS00_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SCRS_TXES	(CPG_MFS00_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS00_LIN_SCRS_RXES	(CPG_MFS00_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS00_LIN_SCRS_TBIES	(CPG_MFS00_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS00_LIN_SCRS_TIES	(CPG_MFS00_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS00_LIN_SCRS_RIES	(CPG_MFS00_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS00_LIN_SCRS_LBRS	(CPG_MFS00_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS00_LIN_SCRS_MSS	(CPG_MFS00_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS00_LIN_SCRS_UPCLS	(CPG_MFS00_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS01_LIN_SCRS	(CPG_MFS01_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SCRS_TXES	(CPG_MFS01_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS01_LIN_SCRS_RXES	(CPG_MFS01_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS01_LIN_SCRS_TBIES	(CPG_MFS01_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS01_LIN_SCRS_TIES	(CPG_MFS01_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS01_LIN_SCRS_RIES	(CPG_MFS01_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS01_LIN_SCRS_LBRS	(CPG_MFS01_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS01_LIN_SCRS_MSS	(CPG_MFS01_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS01_LIN_SCRS_UPCLS	(CPG_MFS01_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS02_LIN_SCRS	(CPG_MFS02_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SCRS_TXES	(CPG_MFS02_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS02_LIN_SCRS_RXES	(CPG_MFS02_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS02_LIN_SCRS_TBIES	(CPG_MFS02_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS02_LIN_SCRS_TIES	(CPG_MFS02_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS02_LIN_SCRS_RIES	(CPG_MFS02_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS02_LIN_SCRS_LBRS	(CPG_MFS02_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS02_LIN_SCRS_MSS	(CPG_MFS02_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS02_LIN_SCRS_UPCLS	(CPG_MFS02_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS03_LIN_SCRS	(CPG_MFS03_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SCRS_TXES	(CPG_MFS03_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS03_LIN_SCRS_RXES	(CPG_MFS03_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS03_LIN_SCRS_TBIES	(CPG_MFS03_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS03_LIN_SCRS_TIES	(CPG_MFS03_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS03_LIN_SCRS_RIES	(CPG_MFS03_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS03_LIN_SCRS_LBRS	(CPG_MFS03_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS03_LIN_SCRS_MSS	(CPG_MFS03_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS03_LIN_SCRS_UPCLS	(CPG_MFS03_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS04_LIN_SCRS	(CPG_MFS04_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SCRS_TXES	(CPG_MFS04_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS04_LIN_SCRS_RXES	(CPG_MFS04_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS04_LIN_SCRS_TBIES	(CPG_MFS04_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS04_LIN_SCRS_TIES	(CPG_MFS04_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS04_LIN_SCRS_RIES	(CPG_MFS04_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS04_LIN_SCRS_LBRS	(CPG_MFS04_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS04_LIN_SCRS_MSS	(CPG_MFS04_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS04_LIN_SCRS_UPCLS	(CPG_MFS04_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS05_LIN_SCRS	(CPG_MFS05_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SCRS_TXES	(CPG_MFS05_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS05_LIN_SCRS_RXES	(CPG_MFS05_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS05_LIN_SCRS_TBIES	(CPG_MFS05_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS05_LIN_SCRS_TIES	(CPG_MFS05_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS05_LIN_SCRS_RIES	(CPG_MFS05_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS05_LIN_SCRS_LBRS	(CPG_MFS05_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS05_LIN_SCRS_MSS	(CPG_MFS05_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS05_LIN_SCRS_UPCLS	(CPG_MFS05_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS06_LIN_SCRS	(CPG_MFS06_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SCRS_TXES	(CPG_MFS06_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS06_LIN_SCRS_RXES	(CPG_MFS06_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS06_LIN_SCRS_TBIES	(CPG_MFS06_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS06_LIN_SCRS_TIES	(CPG_MFS06_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS06_LIN_SCRS_RIES	(CPG_MFS06_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS06_LIN_SCRS_LBRS	(CPG_MFS06_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS06_LIN_SCRS_MSS	(CPG_MFS06_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS06_LIN_SCRS_UPCLS	(CPG_MFS06_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS07_LIN_SCRS	(CPG_MFS07_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SCRS_TXES	(CPG_MFS07_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS07_LIN_SCRS_RXES	(CPG_MFS07_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS07_LIN_SCRS_TBIES	(CPG_MFS07_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS07_LIN_SCRS_TIES	(CPG_MFS07_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS07_LIN_SCRS_RIES	(CPG_MFS07_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS07_LIN_SCRS_LBRS	(CPG_MFS07_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS07_LIN_SCRS_MSS	(CPG_MFS07_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS07_LIN_SCRS_UPCLS	(CPG_MFS07_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS08_LIN_SCRS	(CPG_MFS08_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SCRS_TXES	(CPG_MFS08_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS08_LIN_SCRS_RXES	(CPG_MFS08_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS08_LIN_SCRS_TBIES	(CPG_MFS08_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS08_LIN_SCRS_TIES	(CPG_MFS08_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS08_LIN_SCRS_RIES	(CPG_MFS08_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS08_LIN_SCRS_LBRS	(CPG_MFS08_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS08_LIN_SCRS_MSS	(CPG_MFS08_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS08_LIN_SCRS_UPCLS	(CPG_MFS08_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS09_LIN_SCRS	(CPG_MFS09_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SCRS_TXES	(CPG_MFS09_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS09_LIN_SCRS_RXES	(CPG_MFS09_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS09_LIN_SCRS_TBIES	(CPG_MFS09_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS09_LIN_SCRS_TIES	(CPG_MFS09_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS09_LIN_SCRS_RIES	(CPG_MFS09_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS09_LIN_SCRS_LBRS	(CPG_MFS09_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS09_LIN_SCRS_MSS	(CPG_MFS09_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS09_LIN_SCRS_UPCLS	(CPG_MFS09_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS10_LIN_SCRS	(CPG_MFS10_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SCRS_TXES	(CPG_MFS10_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS10_LIN_SCRS_RXES	(CPG_MFS10_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS10_LIN_SCRS_TBIES	(CPG_MFS10_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS10_LIN_SCRS_TIES	(CPG_MFS10_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS10_LIN_SCRS_RIES	(CPG_MFS10_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS10_LIN_SCRS_LBRS	(CPG_MFS10_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS10_LIN_SCRS_MSS	(CPG_MFS10_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS10_LIN_SCRS_UPCLS	(CPG_MFS10_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

#define CPG_MFS11_LIN_SCRS	(CPG_MFS11_LIN.unSCRS.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SCRS_TXES	(CPG_MFS11_LIN.unSCRS.stcField.u1TXES)  /*@bf@*/
#define CPG_MFS11_LIN_SCRS_RXES	(CPG_MFS11_LIN.unSCRS.stcField.u1RXES)  /*@bf@*/
#define CPG_MFS11_LIN_SCRS_TBIES	(CPG_MFS11_LIN.unSCRS.stcField.u1TBIES)  /*@bf@*/
#define CPG_MFS11_LIN_SCRS_TIES	(CPG_MFS11_LIN.unSCRS.stcField.u1TIES)  /*@bf@*/
#define CPG_MFS11_LIN_SCRS_RIES	(CPG_MFS11_LIN.unSCRS.stcField.u1RIES)  /*@bf@*/
#define CPG_MFS11_LIN_SCRS_LBRS	(CPG_MFS11_LIN.unSCRS.stcField.u1LBRS)  /*@bf@*/
#define CPG_MFS11_LIN_SCRS_MSS	(CPG_MFS11_LIN.unSCRS.stcField.u1MSS)  /*@bf@*/
#define CPG_MFS11_LIN_SCRS_UPCLS	(CPG_MFS11_LIN.unSCRS.stcField.u1UPCLS)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_scrs_field{
    uint_io8_t		u1TXES:1;
    uint_io8_t		u1RXES:1;
    uint_io8_t		u1TBIES:1;
    uint_io8_t		u1TIES:1;
    uint_io8_t		u1RIES:1;
    uint_io8_t		u1LBRS:1;
    uint_io8_t		u1MSS:1;
    uint_io8_t		u1UPCLS:1;
}stc_cpg_mfsn_lin_scrs_field_t;

typedef union un_cpg_mfsn_lin_scrs{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_scrs_field_t		stcField;
}un_cpg_mfsn_lin_scrs_t;

/* ESCRS */
#define CPG_MFS00_LIN_ESCRS	(CPG_MFS00_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_ESCRS_LBIES	(CPG_MFS00_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS00_LIN_ESCRS_ESBLS	(CPG_MFS00_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS01_LIN_ESCRS	(CPG_MFS01_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_ESCRS_LBIES	(CPG_MFS01_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS01_LIN_ESCRS_ESBLS	(CPG_MFS01_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS02_LIN_ESCRS	(CPG_MFS02_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_ESCRS_LBIES	(CPG_MFS02_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS02_LIN_ESCRS_ESBLS	(CPG_MFS02_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS03_LIN_ESCRS	(CPG_MFS03_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_ESCRS_LBIES	(CPG_MFS03_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS03_LIN_ESCRS_ESBLS	(CPG_MFS03_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS04_LIN_ESCRS	(CPG_MFS04_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_ESCRS_LBIES	(CPG_MFS04_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS04_LIN_ESCRS_ESBLS	(CPG_MFS04_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS05_LIN_ESCRS	(CPG_MFS05_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_ESCRS_LBIES	(CPG_MFS05_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS05_LIN_ESCRS_ESBLS	(CPG_MFS05_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS06_LIN_ESCRS	(CPG_MFS06_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_ESCRS_LBIES	(CPG_MFS06_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS06_LIN_ESCRS_ESBLS	(CPG_MFS06_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS07_LIN_ESCRS	(CPG_MFS07_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_ESCRS_LBIES	(CPG_MFS07_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS07_LIN_ESCRS_ESBLS	(CPG_MFS07_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS08_LIN_ESCRS	(CPG_MFS08_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_ESCRS_LBIES	(CPG_MFS08_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS08_LIN_ESCRS_ESBLS	(CPG_MFS08_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS09_LIN_ESCRS	(CPG_MFS09_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_ESCRS_LBIES	(CPG_MFS09_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS09_LIN_ESCRS_ESBLS	(CPG_MFS09_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS10_LIN_ESCRS	(CPG_MFS10_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_ESCRS_LBIES	(CPG_MFS10_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS10_LIN_ESCRS_ESBLS	(CPG_MFS10_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

#define CPG_MFS11_LIN_ESCRS	(CPG_MFS11_LIN.unESCRS.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_ESCRS_LBIES	(CPG_MFS11_LIN.unESCRS.stcField.u1LBIES)  /*@bf@*/
#define CPG_MFS11_LIN_ESCRS_ESBLS	(CPG_MFS11_LIN.unESCRS.stcField.u1ESBLS)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_escrs_field{
    uint_io8_t		:4;
    uint_io8_t		u1LBIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1ESBLS:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_escrs_field_t;

typedef union un_cpg_mfsn_lin_escrs{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_escrs_field_t		stcField;
}un_cpg_mfsn_lin_escrs_t;

/* SSRS */
#define CPG_MFS00_LIN_SSRS	(CPG_MFS00_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_SSRS_RECS	(CPG_MFS00_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS01_LIN_SSRS	(CPG_MFS01_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_SSRS_RECS	(CPG_MFS01_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS02_LIN_SSRS	(CPG_MFS02_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_SSRS_RECS	(CPG_MFS02_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS03_LIN_SSRS	(CPG_MFS03_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_SSRS_RECS	(CPG_MFS03_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS04_LIN_SSRS	(CPG_MFS04_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_SSRS_RECS	(CPG_MFS04_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS05_LIN_SSRS	(CPG_MFS05_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_SSRS_RECS	(CPG_MFS05_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS06_LIN_SSRS	(CPG_MFS06_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_SSRS_RECS	(CPG_MFS06_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS07_LIN_SSRS	(CPG_MFS07_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_SSRS_RECS	(CPG_MFS07_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS08_LIN_SSRS	(CPG_MFS08_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_SSRS_RECS	(CPG_MFS08_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS09_LIN_SSRS	(CPG_MFS09_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_SSRS_RECS	(CPG_MFS09_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS10_LIN_SSRS	(CPG_MFS10_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_SSRS_RECS	(CPG_MFS10_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

#define CPG_MFS11_LIN_SSRS	(CPG_MFS11_LIN.unSSRS.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_SSRS_RECS	(CPG_MFS11_LIN.unSSRS.stcField.u1RECS)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_ssrs_field{
    uint_io8_t		:7;
    uint_io8_t		u1RECS:1;
}stc_cpg_mfsn_lin_ssrs_field_t;

typedef union un_cpg_mfsn_lin_ssrs{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_ssrs_field_t		stcField;
}un_cpg_mfsn_lin_ssrs_t;

/* SACSRS */
#define CPG_MFS00_LIN_SACSRS	(CPG_MFS00_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS00_LIN_SACSRS_TMRES	(CPG_MFS00_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRS_TRGES	(CPG_MFS00_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRS_TINTES	(CPG_MFS00_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRS_AUTES	(CPG_MFS00_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRS_SFDES	(CPG_MFS00_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS00_LIN_SACSRS_STSTS	(CPG_MFS00_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS01_LIN_SACSRS	(CPG_MFS01_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS01_LIN_SACSRS_TMRES	(CPG_MFS01_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRS_TRGES	(CPG_MFS01_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRS_TINTES	(CPG_MFS01_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRS_AUTES	(CPG_MFS01_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRS_SFDES	(CPG_MFS01_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS01_LIN_SACSRS_STSTS	(CPG_MFS01_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS02_LIN_SACSRS	(CPG_MFS02_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS02_LIN_SACSRS_TMRES	(CPG_MFS02_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRS_TRGES	(CPG_MFS02_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRS_TINTES	(CPG_MFS02_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRS_AUTES	(CPG_MFS02_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRS_SFDES	(CPG_MFS02_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS02_LIN_SACSRS_STSTS	(CPG_MFS02_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS03_LIN_SACSRS	(CPG_MFS03_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS03_LIN_SACSRS_TMRES	(CPG_MFS03_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRS_TRGES	(CPG_MFS03_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRS_TINTES	(CPG_MFS03_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRS_AUTES	(CPG_MFS03_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRS_SFDES	(CPG_MFS03_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS03_LIN_SACSRS_STSTS	(CPG_MFS03_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS04_LIN_SACSRS	(CPG_MFS04_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS04_LIN_SACSRS_TMRES	(CPG_MFS04_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRS_TRGES	(CPG_MFS04_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRS_TINTES	(CPG_MFS04_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRS_AUTES	(CPG_MFS04_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRS_SFDES	(CPG_MFS04_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS04_LIN_SACSRS_STSTS	(CPG_MFS04_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS05_LIN_SACSRS	(CPG_MFS05_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS05_LIN_SACSRS_TMRES	(CPG_MFS05_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRS_TRGES	(CPG_MFS05_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRS_TINTES	(CPG_MFS05_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRS_AUTES	(CPG_MFS05_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRS_SFDES	(CPG_MFS05_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS05_LIN_SACSRS_STSTS	(CPG_MFS05_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS06_LIN_SACSRS	(CPG_MFS06_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS06_LIN_SACSRS_TMRES	(CPG_MFS06_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRS_TRGES	(CPG_MFS06_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRS_TINTES	(CPG_MFS06_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRS_AUTES	(CPG_MFS06_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRS_SFDES	(CPG_MFS06_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS06_LIN_SACSRS_STSTS	(CPG_MFS06_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS07_LIN_SACSRS	(CPG_MFS07_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS07_LIN_SACSRS_TMRES	(CPG_MFS07_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRS_TRGES	(CPG_MFS07_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRS_TINTES	(CPG_MFS07_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRS_AUTES	(CPG_MFS07_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRS_SFDES	(CPG_MFS07_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS07_LIN_SACSRS_STSTS	(CPG_MFS07_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS08_LIN_SACSRS	(CPG_MFS08_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS08_LIN_SACSRS_TMRES	(CPG_MFS08_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRS_TRGES	(CPG_MFS08_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRS_TINTES	(CPG_MFS08_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRS_AUTES	(CPG_MFS08_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRS_SFDES	(CPG_MFS08_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS08_LIN_SACSRS_STSTS	(CPG_MFS08_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS09_LIN_SACSRS	(CPG_MFS09_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS09_LIN_SACSRS_TMRES	(CPG_MFS09_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRS_TRGES	(CPG_MFS09_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRS_TINTES	(CPG_MFS09_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRS_AUTES	(CPG_MFS09_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRS_SFDES	(CPG_MFS09_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS09_LIN_SACSRS_STSTS	(CPG_MFS09_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS10_LIN_SACSRS	(CPG_MFS10_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS10_LIN_SACSRS_TMRES	(CPG_MFS10_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRS_TRGES	(CPG_MFS10_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRS_TINTES	(CPG_MFS10_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRS_AUTES	(CPG_MFS10_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRS_SFDES	(CPG_MFS10_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS10_LIN_SACSRS_STSTS	(CPG_MFS10_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS11_LIN_SACSRS	(CPG_MFS11_LIN.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS11_LIN_SACSRS_TMRES	(CPG_MFS11_LIN.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRS_TRGES	(CPG_MFS11_LIN.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRS_TINTES	(CPG_MFS11_LIN.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRS_AUTES	(CPG_MFS11_LIN.unSACSRS.stcField.u1AUTES)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRS_SFDES	(CPG_MFS11_LIN.unSACSRS.stcField.u1SFDES)  /*@bf@*/
#define CPG_MFS11_LIN_SACSRS_STSTS	(CPG_MFS11_LIN.unSACSRS.stcField.u1STSTS)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_sacsrs_field{
    uint_io16_t		u1TMRES:1;
    uint_io16_t		:4;
    uint_io16_t		u1TRGES:1;
    uint_io16_t		:1;
    uint_io16_t		u1TINTES:1;
    uint_io16_t		:3;
    uint_io16_t		u1AUTES:1;
    uint_io16_t		u1SFDES:1;
    uint_io16_t		:2;
    uint_io16_t		u1STSTS:1;
}stc_cpg_mfsn_lin_sacsrs_field_t;

typedef union un_cpg_mfsn_lin_sacsrs{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_lin_sacsrs_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_lin_sacsrs_t;

/* LAMCRS */
#define CPG_MFS00_LIN_LAMCRS	(CPG_MFS00_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMCRS_LAMENS	(CPG_MFS00_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCRS_LIDENS	(CPG_MFS00_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCRS_LCSTYPS	(CPG_MFS00_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS00_LIN_LAMCRS_LTDRCLS	(CPG_MFS00_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS01_LIN_LAMCRS	(CPG_MFS01_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMCRS_LAMENS	(CPG_MFS01_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCRS_LIDENS	(CPG_MFS01_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCRS_LCSTYPS	(CPG_MFS01_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS01_LIN_LAMCRS_LTDRCLS	(CPG_MFS01_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS02_LIN_LAMCRS	(CPG_MFS02_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMCRS_LAMENS	(CPG_MFS02_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCRS_LIDENS	(CPG_MFS02_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCRS_LCSTYPS	(CPG_MFS02_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS02_LIN_LAMCRS_LTDRCLS	(CPG_MFS02_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS03_LIN_LAMCRS	(CPG_MFS03_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMCRS_LAMENS	(CPG_MFS03_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCRS_LIDENS	(CPG_MFS03_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCRS_LCSTYPS	(CPG_MFS03_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS03_LIN_LAMCRS_LTDRCLS	(CPG_MFS03_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS04_LIN_LAMCRS	(CPG_MFS04_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMCRS_LAMENS	(CPG_MFS04_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCRS_LIDENS	(CPG_MFS04_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCRS_LCSTYPS	(CPG_MFS04_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS04_LIN_LAMCRS_LTDRCLS	(CPG_MFS04_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS05_LIN_LAMCRS	(CPG_MFS05_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMCRS_LAMENS	(CPG_MFS05_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCRS_LIDENS	(CPG_MFS05_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCRS_LCSTYPS	(CPG_MFS05_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS05_LIN_LAMCRS_LTDRCLS	(CPG_MFS05_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS06_LIN_LAMCRS	(CPG_MFS06_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMCRS_LAMENS	(CPG_MFS06_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCRS_LIDENS	(CPG_MFS06_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCRS_LCSTYPS	(CPG_MFS06_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS06_LIN_LAMCRS_LTDRCLS	(CPG_MFS06_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS07_LIN_LAMCRS	(CPG_MFS07_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMCRS_LAMENS	(CPG_MFS07_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCRS_LIDENS	(CPG_MFS07_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCRS_LCSTYPS	(CPG_MFS07_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS07_LIN_LAMCRS_LTDRCLS	(CPG_MFS07_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS08_LIN_LAMCRS	(CPG_MFS08_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMCRS_LAMENS	(CPG_MFS08_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCRS_LIDENS	(CPG_MFS08_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCRS_LCSTYPS	(CPG_MFS08_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS08_LIN_LAMCRS_LTDRCLS	(CPG_MFS08_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS09_LIN_LAMCRS	(CPG_MFS09_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMCRS_LAMENS	(CPG_MFS09_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCRS_LIDENS	(CPG_MFS09_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCRS_LCSTYPS	(CPG_MFS09_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS09_LIN_LAMCRS_LTDRCLS	(CPG_MFS09_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS10_LIN_LAMCRS	(CPG_MFS10_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMCRS_LAMENS	(CPG_MFS10_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCRS_LIDENS	(CPG_MFS10_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCRS_LCSTYPS	(CPG_MFS10_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS10_LIN_LAMCRS_LTDRCLS	(CPG_MFS10_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

#define CPG_MFS11_LIN_LAMCRS	(CPG_MFS11_LIN.unLAMCRS.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMCRS_LAMENS	(CPG_MFS11_LIN.unLAMCRS.stcField.u1LAMENS)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCRS_LIDENS	(CPG_MFS11_LIN.unLAMCRS.stcField.u1LIDENS)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCRS_LCSTYPS	(CPG_MFS11_LIN.unLAMCRS.stcField.u1LCSTYPS)  /*@bf@*/
#define CPG_MFS11_LIN_LAMCRS_LTDRCLS	(CPG_MFS11_LIN.unLAMCRS.stcField.u1LTDRCLS)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamcrs_field{
    uint_io8_t		u1LAMENS:1;
    uint_io8_t		u1LIDENS:1;
    uint_io8_t		u1LCSTYPS:1;
    uint_io8_t		u1LTDRCLS:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_lin_lamcrs_field_t;

typedef union un_cpg_mfsn_lin_lamcrs{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamcrs_field_t		stcField;
}un_cpg_mfsn_lin_lamcrs_t;

/* LAMIERS */
#define CPG_MFS00_LIN_LAMIERS	(CPG_MFS00_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_LAMIERS_LAHCIES	(CPG_MFS00_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERS_LCSCIES	(CPG_MFS00_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERS_LBSERIES	(CPG_MFS00_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERS_LSFERIES	(CPG_MFS00_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERS_LPTERIES	(CPG_MFS00_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS00_LIN_LAMIERS_LCSERIES	(CPG_MFS00_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS01_LIN_LAMIERS	(CPG_MFS01_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_LAMIERS_LAHCIES	(CPG_MFS01_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERS_LCSCIES	(CPG_MFS01_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERS_LBSERIES	(CPG_MFS01_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERS_LSFERIES	(CPG_MFS01_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERS_LPTERIES	(CPG_MFS01_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS01_LIN_LAMIERS_LCSERIES	(CPG_MFS01_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS02_LIN_LAMIERS	(CPG_MFS02_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_LAMIERS_LAHCIES	(CPG_MFS02_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERS_LCSCIES	(CPG_MFS02_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERS_LBSERIES	(CPG_MFS02_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERS_LSFERIES	(CPG_MFS02_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERS_LPTERIES	(CPG_MFS02_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS02_LIN_LAMIERS_LCSERIES	(CPG_MFS02_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS03_LIN_LAMIERS	(CPG_MFS03_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_LAMIERS_LAHCIES	(CPG_MFS03_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERS_LCSCIES	(CPG_MFS03_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERS_LBSERIES	(CPG_MFS03_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERS_LSFERIES	(CPG_MFS03_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERS_LPTERIES	(CPG_MFS03_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS03_LIN_LAMIERS_LCSERIES	(CPG_MFS03_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS04_LIN_LAMIERS	(CPG_MFS04_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_LAMIERS_LAHCIES	(CPG_MFS04_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERS_LCSCIES	(CPG_MFS04_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERS_LBSERIES	(CPG_MFS04_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERS_LSFERIES	(CPG_MFS04_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERS_LPTERIES	(CPG_MFS04_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS04_LIN_LAMIERS_LCSERIES	(CPG_MFS04_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS05_LIN_LAMIERS	(CPG_MFS05_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_LAMIERS_LAHCIES	(CPG_MFS05_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERS_LCSCIES	(CPG_MFS05_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERS_LBSERIES	(CPG_MFS05_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERS_LSFERIES	(CPG_MFS05_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERS_LPTERIES	(CPG_MFS05_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS05_LIN_LAMIERS_LCSERIES	(CPG_MFS05_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS06_LIN_LAMIERS	(CPG_MFS06_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_LAMIERS_LAHCIES	(CPG_MFS06_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERS_LCSCIES	(CPG_MFS06_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERS_LBSERIES	(CPG_MFS06_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERS_LSFERIES	(CPG_MFS06_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERS_LPTERIES	(CPG_MFS06_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS06_LIN_LAMIERS_LCSERIES	(CPG_MFS06_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS07_LIN_LAMIERS	(CPG_MFS07_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_LAMIERS_LAHCIES	(CPG_MFS07_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERS_LCSCIES	(CPG_MFS07_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERS_LBSERIES	(CPG_MFS07_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERS_LSFERIES	(CPG_MFS07_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERS_LPTERIES	(CPG_MFS07_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS07_LIN_LAMIERS_LCSERIES	(CPG_MFS07_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS08_LIN_LAMIERS	(CPG_MFS08_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_LAMIERS_LAHCIES	(CPG_MFS08_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERS_LCSCIES	(CPG_MFS08_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERS_LBSERIES	(CPG_MFS08_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERS_LSFERIES	(CPG_MFS08_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERS_LPTERIES	(CPG_MFS08_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS08_LIN_LAMIERS_LCSERIES	(CPG_MFS08_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS09_LIN_LAMIERS	(CPG_MFS09_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_LAMIERS_LAHCIES	(CPG_MFS09_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERS_LCSCIES	(CPG_MFS09_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERS_LBSERIES	(CPG_MFS09_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERS_LSFERIES	(CPG_MFS09_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERS_LPTERIES	(CPG_MFS09_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS09_LIN_LAMIERS_LCSERIES	(CPG_MFS09_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS10_LIN_LAMIERS	(CPG_MFS10_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_LAMIERS_LAHCIES	(CPG_MFS10_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERS_LCSCIES	(CPG_MFS10_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERS_LBSERIES	(CPG_MFS10_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERS_LSFERIES	(CPG_MFS10_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERS_LPTERIES	(CPG_MFS10_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS10_LIN_LAMIERS_LCSERIES	(CPG_MFS10_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

#define CPG_MFS11_LIN_LAMIERS	(CPG_MFS11_LIN.unLAMIERS.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_LAMIERS_LAHCIES	(CPG_MFS11_LIN.unLAMIERS.stcField.u1LAHCIES)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERS_LCSCIES	(CPG_MFS11_LIN.unLAMIERS.stcField.u1LCSCIES)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERS_LBSERIES	(CPG_MFS11_LIN.unLAMIERS.stcField.u1LBSERIES)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERS_LSFERIES	(CPG_MFS11_LIN.unLAMIERS.stcField.u1LSFERIES)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERS_LPTERIES	(CPG_MFS11_LIN.unLAMIERS.stcField.u1LPTERIES)  /*@bf@*/
#define CPG_MFS11_LIN_LAMIERS_LCSERIES	(CPG_MFS11_LIN.unLAMIERS.stcField.u1LCSERIES)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_lamiers_field{
    uint_io8_t		u1LAHCIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1LCSCIES:1;
    uint_io8_t		u1LBSERIES:1;
    uint_io8_t		u1LSFERIES:1;
    uint_io8_t		u1LPTERIES:1;
    uint_io8_t		u1LCSERIES:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_lin_lamiers_field_t;

typedef union un_cpg_mfsn_lin_lamiers{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_lamiers_field_t		stcField;
}un_cpg_mfsn_lin_lamiers_t;

/* FCR0S */
#define CPG_MFS00_LIN_FCR0S	(CPG_MFS00_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_FCR0S_FE1S	(CPG_MFS00_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0S_FE2S	(CPG_MFS00_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0S_FCL1S	(CPG_MFS00_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0S_FCL2S	(CPG_MFS00_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0S_FSETS	(CPG_MFS00_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS00_LIN_FCR0S_FLDS	(CPG_MFS00_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS01_LIN_FCR0S	(CPG_MFS01_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_FCR0S_FE1S	(CPG_MFS01_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0S_FE2S	(CPG_MFS01_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0S_FCL1S	(CPG_MFS01_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0S_FCL2S	(CPG_MFS01_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0S_FSETS	(CPG_MFS01_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS01_LIN_FCR0S_FLDS	(CPG_MFS01_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS02_LIN_FCR0S	(CPG_MFS02_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_FCR0S_FE1S	(CPG_MFS02_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0S_FE2S	(CPG_MFS02_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0S_FCL1S	(CPG_MFS02_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0S_FCL2S	(CPG_MFS02_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0S_FSETS	(CPG_MFS02_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS02_LIN_FCR0S_FLDS	(CPG_MFS02_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS03_LIN_FCR0S	(CPG_MFS03_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_FCR0S_FE1S	(CPG_MFS03_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0S_FE2S	(CPG_MFS03_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0S_FCL1S	(CPG_MFS03_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0S_FCL2S	(CPG_MFS03_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0S_FSETS	(CPG_MFS03_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS03_LIN_FCR0S_FLDS	(CPG_MFS03_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS04_LIN_FCR0S	(CPG_MFS04_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_FCR0S_FE1S	(CPG_MFS04_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0S_FE2S	(CPG_MFS04_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0S_FCL1S	(CPG_MFS04_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0S_FCL2S	(CPG_MFS04_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0S_FSETS	(CPG_MFS04_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS04_LIN_FCR0S_FLDS	(CPG_MFS04_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS05_LIN_FCR0S	(CPG_MFS05_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_FCR0S_FE1S	(CPG_MFS05_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0S_FE2S	(CPG_MFS05_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0S_FCL1S	(CPG_MFS05_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0S_FCL2S	(CPG_MFS05_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0S_FSETS	(CPG_MFS05_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS05_LIN_FCR0S_FLDS	(CPG_MFS05_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS06_LIN_FCR0S	(CPG_MFS06_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_FCR0S_FE1S	(CPG_MFS06_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0S_FE2S	(CPG_MFS06_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0S_FCL1S	(CPG_MFS06_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0S_FCL2S	(CPG_MFS06_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0S_FSETS	(CPG_MFS06_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS06_LIN_FCR0S_FLDS	(CPG_MFS06_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS07_LIN_FCR0S	(CPG_MFS07_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_FCR0S_FE1S	(CPG_MFS07_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0S_FE2S	(CPG_MFS07_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0S_FCL1S	(CPG_MFS07_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0S_FCL2S	(CPG_MFS07_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0S_FSETS	(CPG_MFS07_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS07_LIN_FCR0S_FLDS	(CPG_MFS07_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS08_LIN_FCR0S	(CPG_MFS08_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_FCR0S_FE1S	(CPG_MFS08_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0S_FE2S	(CPG_MFS08_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0S_FCL1S	(CPG_MFS08_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0S_FCL2S	(CPG_MFS08_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0S_FSETS	(CPG_MFS08_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS08_LIN_FCR0S_FLDS	(CPG_MFS08_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS09_LIN_FCR0S	(CPG_MFS09_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_FCR0S_FE1S	(CPG_MFS09_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0S_FE2S	(CPG_MFS09_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0S_FCL1S	(CPG_MFS09_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0S_FCL2S	(CPG_MFS09_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0S_FSETS	(CPG_MFS09_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS09_LIN_FCR0S_FLDS	(CPG_MFS09_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS10_LIN_FCR0S	(CPG_MFS10_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_FCR0S_FE1S	(CPG_MFS10_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0S_FE2S	(CPG_MFS10_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0S_FCL1S	(CPG_MFS10_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0S_FCL2S	(CPG_MFS10_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0S_FSETS	(CPG_MFS10_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS10_LIN_FCR0S_FLDS	(CPG_MFS10_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS11_LIN_FCR0S	(CPG_MFS11_LIN.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_FCR0S_FE1S	(CPG_MFS11_LIN.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0S_FE2S	(CPG_MFS11_LIN.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0S_FCL1S	(CPG_MFS11_LIN.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0S_FCL2S	(CPG_MFS11_LIN.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0S_FSETS	(CPG_MFS11_LIN.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS11_LIN_FCR0S_FLDS	(CPG_MFS11_LIN.unFCR0S.stcField.u1FLDS)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_fcr0s_field{
    uint_io8_t		u1FE1S:1;
    uint_io8_t		u1FE2S:1;
    uint_io8_t		u1FCL1S:1;
    uint_io8_t		u1FCL2S:1;
    uint_io8_t		u1FSETS:1;
    uint_io8_t		u1FLDS:1;
    uint_io8_t		:2;
}stc_cpg_mfsn_lin_fcr0s_field_t;

typedef union un_cpg_mfsn_lin_fcr0s{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_fcr0s_field_t		stcField;
}un_cpg_mfsn_lin_fcr0s_t;

/* FCR1S */
#define CPG_MFS00_LIN_FCR1S	(CPG_MFS00_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS00_LIN_FCR1S_FSELS	(CPG_MFS00_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1S_FTIES	(CPG_MFS00_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1S_FRIIES	(CPG_MFS00_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS00_LIN_FCR1S_FLSTES	(CPG_MFS00_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS01_LIN_FCR1S	(CPG_MFS01_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS01_LIN_FCR1S_FSELS	(CPG_MFS01_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1S_FTIES	(CPG_MFS01_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1S_FRIIES	(CPG_MFS01_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS01_LIN_FCR1S_FLSTES	(CPG_MFS01_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS02_LIN_FCR1S	(CPG_MFS02_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS02_LIN_FCR1S_FSELS	(CPG_MFS02_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1S_FTIES	(CPG_MFS02_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1S_FRIIES	(CPG_MFS02_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS02_LIN_FCR1S_FLSTES	(CPG_MFS02_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS03_LIN_FCR1S	(CPG_MFS03_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS03_LIN_FCR1S_FSELS	(CPG_MFS03_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1S_FTIES	(CPG_MFS03_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1S_FRIIES	(CPG_MFS03_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS03_LIN_FCR1S_FLSTES	(CPG_MFS03_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS04_LIN_FCR1S	(CPG_MFS04_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS04_LIN_FCR1S_FSELS	(CPG_MFS04_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1S_FTIES	(CPG_MFS04_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1S_FRIIES	(CPG_MFS04_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS04_LIN_FCR1S_FLSTES	(CPG_MFS04_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS05_LIN_FCR1S	(CPG_MFS05_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS05_LIN_FCR1S_FSELS	(CPG_MFS05_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1S_FTIES	(CPG_MFS05_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1S_FRIIES	(CPG_MFS05_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS05_LIN_FCR1S_FLSTES	(CPG_MFS05_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS06_LIN_FCR1S	(CPG_MFS06_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS06_LIN_FCR1S_FSELS	(CPG_MFS06_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1S_FTIES	(CPG_MFS06_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1S_FRIIES	(CPG_MFS06_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS06_LIN_FCR1S_FLSTES	(CPG_MFS06_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS07_LIN_FCR1S	(CPG_MFS07_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS07_LIN_FCR1S_FSELS	(CPG_MFS07_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1S_FTIES	(CPG_MFS07_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1S_FRIIES	(CPG_MFS07_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS07_LIN_FCR1S_FLSTES	(CPG_MFS07_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS08_LIN_FCR1S	(CPG_MFS08_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS08_LIN_FCR1S_FSELS	(CPG_MFS08_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1S_FTIES	(CPG_MFS08_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1S_FRIIES	(CPG_MFS08_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS08_LIN_FCR1S_FLSTES	(CPG_MFS08_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS09_LIN_FCR1S	(CPG_MFS09_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS09_LIN_FCR1S_FSELS	(CPG_MFS09_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1S_FTIES	(CPG_MFS09_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1S_FRIIES	(CPG_MFS09_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS09_LIN_FCR1S_FLSTES	(CPG_MFS09_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS10_LIN_FCR1S	(CPG_MFS10_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS10_LIN_FCR1S_FSELS	(CPG_MFS10_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1S_FTIES	(CPG_MFS10_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1S_FRIIES	(CPG_MFS10_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS10_LIN_FCR1S_FLSTES	(CPG_MFS10_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS11_LIN_FCR1S	(CPG_MFS11_LIN.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS11_LIN_FCR1S_FSELS	(CPG_MFS11_LIN.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1S_FTIES	(CPG_MFS11_LIN.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1S_FRIIES	(CPG_MFS11_LIN.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS11_LIN_FCR1S_FLSTES	(CPG_MFS11_LIN.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

typedef struct stc_cpg_mfsn_lin_fcr1s_field{
    uint_io8_t		u1FSELS:1;
    uint_io8_t		u1FTIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1FRIIES:1;
    uint_io8_t		u1FLSTES:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_lin_fcr1s_field_t;

typedef union un_cpg_mfsn_lin_fcr1s{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_lin_fcr1s_field_t		stcField;
}un_cpg_mfsn_lin_fcr1s_t;


typedef struct stc_cpg_mfsn_lin{
    un_cpg_mfsn_lin_smr_t	unSMR;	/* 0x00000000 */
    un_cpg_mfsn_lin_scr_t	unSCR;	/* 0x00000001 */
    un_cpg_mfsn_lin_escr_t	unESCR;	/* 0x00000002 */
    un_cpg_mfsn_lin_ssr_t	unSSR;	/* 0x00000003 */
    un_cpg_mfsn_lin_rdr_t	unRDR;	/* 0x00000004 */
    uint_io8_t	au8Reserved0[3];	/* 0x00000005 */
    un_cpg_mfsn_lin_sacsr_t	unSACSR;	/* 0x00000008 */
    un_cpg_mfsn_lin_stmr_t	unSTMR;	/* 0x0000000A */
    un_cpg_mfsn_lin_stmcr_t	unSTMCR;	/* 0x0000000C */
    un_cpg_mfsn_lin_sfur_t	unSFUR;	/* 0x0000000E */
    un_cpg_mfsn_lin_sflr_t	unSFLR;	/* 0x00000010 */
    un_cpg_mfsn_lin_lamcr_t	unLAMCR;	/* 0x00000012 */
    un_cpg_mfsn_lin_lamsr_t	unLAMSR;	/* 0x00000013 */
    uint_io8_t	au8Reserved1[4];	/* 0x00000014 */
    un_cpg_mfsn_lin_lamrid_t	unLAMRID;	/* 0x00000018 */
    un_cpg_mfsn_lin_lamier_t	unLAMIER;	/* 0x00000019 */
    un_cpg_mfsn_lin_lamert_t	unLAMERT;	/* 0x0000001A */
    un_cpg_mfsn_lin_lamesr_t	unLAMESR;	/* 0x0000001B */
    un_cpg_mfsn_lin_bgr_t	unBGR;	/* 0x0000001C */
    uint_io8_t	au8Reserved2[2];	/* 0x0000001E */
    un_cpg_mfsn_lin_fcr0_t	unFCR0;	/* 0x00000020 */
    un_cpg_mfsn_lin_fcr1_t	unFCR1;	/* 0x00000021 */
    un_cpg_mfsn_lin_fbyte_t	unFBYTE;	/* 0x00000022 */
    un_cpg_mfsn_lin_fticr_t	unFTICR;	/* 0x00000024 */
    un_cpg_mfsn_lin_ecr_t	unECR;	/* 0x00000026 */
    un_cpg_mfsn_lin_esr_t	unESR;	/* 0x00000027 */
    un_cpg_mfsn_lin_tbsize_t	unTBSIZE;	/* 0x00000028 */
    uint_io8_t	au8Reserved3[3];	/* 0x00000029 */
    un_cpg_mfsn_lin_smrc_t	unSMRC;	/* 0x0000002C */
    un_cpg_mfsn_lin_scrc_t	unSCRC;	/* 0x0000002D */
    un_cpg_mfsn_lin_escrc_t	unESCRC;	/* 0x0000002E */
    un_cpg_mfsn_lin_ssrc_t	unSSRC;	/* 0x0000002F */
    un_cpg_mfsn_lin_sacsrc_t	unSACSRC;	/* 0x00000030 */
    uint_io8_t	au8Reserved4[4];	/* 0x00000032 */
    un_cpg_mfsn_lin_lamcrc_t	unLAMCRC;	/* 0x00000036 */
    un_cpg_mfsn_lin_lamsrc_t	unLAMSRC;	/* 0x00000037 */
    uint_io8_t	au8Reserved5[1];	/* 0x00000038 */
    un_cpg_mfsn_lin_lamierc_t	unLAMIERC;	/* 0x00000039 */
    uint_io8_t	au8Reserved6[1];	/* 0x0000003A */
    un_cpg_mfsn_lin_lamesrc_t	unLAMESRC;	/* 0x0000003B */
    un_cpg_mfsn_lin_fcr0c_t	unFCR0C;	/* 0x0000003C */
    un_cpg_mfsn_lin_fcr1c_t	unFCR1C;	/* 0x0000003D */
    uint_io8_t	au8Reserved7[5];	/* 0x0000003E */
    un_cpg_mfsn_lin_esrc_t	unESRC;	/* 0x00000043 */
    un_cpg_mfsn_lin_smrs_t	unSMRS;	/* 0x00000044 */
    un_cpg_mfsn_lin_scrs_t	unSCRS;	/* 0x00000045 */
    un_cpg_mfsn_lin_escrs_t	unESCRS;	/* 0x00000046 */
    un_cpg_mfsn_lin_ssrs_t	unSSRS;	/* 0x00000047 */
    un_cpg_mfsn_lin_sacsrs_t	unSACSRS;	/* 0x00000048 */
    uint_io8_t	au8Reserved8[4];	/* 0x0000004A */
    un_cpg_mfsn_lin_lamcrs_t	unLAMCRS;	/* 0x0000004E */
    uint_io8_t	au8Reserved9[2];	/* 0x0000004F */
    un_cpg_mfsn_lin_lamiers_t	unLAMIERS;	/* 0x00000051 */
    uint_io8_t	au8Reserved10[2];	/* 0x00000052 */
    un_cpg_mfsn_lin_fcr0s_t	unFCR0S;	/* 0x00000054 */
    un_cpg_mfsn_lin_fcr1s_t	unFCR1S;	/* 0x00000055 */
    uint_io8_t	au8Reserved11[938];	/* 0x00000056 */
}stc_cpg_mfsn_lin_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_cpg_mfsn_lin_t	stcCPG_MFS_LIN[12];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_MFS_LIN_H */
