#include "RTE_CAN.h"
#include "CAN_Lib.h"
#include "CAN_APP.h"
#include "CAN_Communication_Matrix.h"
#include "Analog_Signals.h"
#include "RSCAN.h"
#include "Check_Ctrl.h"
#include "Display_Info.h"
#include "RTE_GPIO.h"
#include "GenDelay.h"
extern uint8_t cycleflag;
const uint8_t crc8_table[256] = {
    0x00, 0x1D, 0x3A, 0x27, 0x74, 0x69, 0x4E, 0x53, 0xE8, 0xF5, 0xD2, 0xCF, 0x9C, 0x81, 0xA6, 0xBB,
    0xCD, 0xD0, 0xF7, 0xEA, 0xB9, 0xA4, 0x83, 0x9E, 0x25, 0x38, 0x1F, 0x02, 0x51, 0x4C, 0x6B, 0x76,
    0x87, 0x9A, 0xBD, 0xA0, 0xF3, 0xEE, 0xC9, 0xD4, 0x6F, 0x72, 0x55, 0x48, 0x1B, 0x06, 0x21, 0x3C,
    0x4A, 0x57, 0x70, 0x6D, 0x3E, 0x23, 0x04, 0x19, 0xA2, 0xBF, 0x98, 0x85, 0xD6, 0xCB, 0xEC, 0xF1,
    0x13, 0x0E, 0x29, 0x34, 0x67, 0x7A, 0x5D, 0x40, 0xFB, 0xE6, 0xC1, 0xDC, 0x8F, 0x92, 0xB5, 0xA8,
    0xDE, 0xC3, 0xE4, 0xF9, 0xAA, 0xB7, 0x90, 0x8D, 0x36, 0x2B, 0x0C, 0x11, 0x42, 0x5F, 0x78, 0x65,
    0x94, 0x89, 0xAE, 0xB3, 0xE0, 0xFD, 0xDA, 0xC7, 0x7C, 0x61, 0x46, 0x5B, 0x08, 0x15, 0x32, 0x2F,
    0x59, 0x44, 0x63, 0x7E, 0x2D, 0x30, 0x17, 0x0A, 0xB1, 0xAC, 0x8B, 0x96, 0xC5, 0xD8, 0xFF, 0xE2,
    0x26, 0x3B, 0x1C, 0x01, 0x52, 0x4F, 0x68, 0x75, 0xCE, 0xD3, 0xF4, 0xE9, 0xBA, 0xA7, 0x80, 0x9D,
    0xEB, 0xF6, 0xD1, 0xCC, 0x9F, 0x82, 0xA5, 0xB8, 0x03, 0x1E, 0x39, 0x24, 0x77, 0x6A, 0x4D, 0x50,
    0xA1, 0xBC, 0x9B, 0x86, 0xD5, 0xC8, 0xEF, 0xF2, 0x49, 0x54, 0x73, 0x6E, 0x3D, 0x20, 0x07, 0x1A,
    0x6C, 0x71, 0x56, 0x4B, 0x18, 0x05, 0x22, 0x3F, 0x84, 0x99, 0xBE, 0xA3, 0xF0, 0xED, 0xCA, 0xD7,
    0x35, 0x28, 0x0F, 0x12, 0x41, 0x5C, 0x7B, 0x66, 0xDD, 0xC0, 0xE7, 0xFA, 0xA9, 0xB4, 0x93, 0x8E,
    0xF8, 0xE5, 0xC2, 0xDF, 0x8C, 0x91, 0xB6, 0xAB, 0x10, 0x0D, 0x2A, 0x37, 0x64, 0x79, 0x5E, 0x43,
    0xB2, 0xAF, 0x88, 0x95, 0xC6, 0xDB, 0xFC, 0xE1, 0x5A, 0x47, 0x60, 0x7D, 0x2E, 0x33, 0x14, 0x09,
    0x7F, 0x62, 0x45, 0x58, 0x0B, 0x16, 0x31, 0x2C, 0x97, 0x8A, 0xAD, 0xB0, 0xE3, 0xFE, 0xD9, 0xC4
};
uint8_t CRC8_CheckSum(uint8_t data[], uint8_t len)    
{
    uint8_t crc = 0xFFu;  // 初始值为0xFF

    for (uint8_t i = 0; i < len; i++) {
        crc = crc8_table[crc ^ data[i]];  // 逐字节查表
    }
    
    return crc ^ 0xFFu;  // 最终异或0xFF
}
uint8_t CrcCheckSum(uint8_t *data, uint8_t len)
{
    uint8_t crc        = 0xff;
    uint8_t CRC_POLY   = 0x2f;
    uint8_t crcxor     = 0xff;
    uint8_t bit_index  = 0;
    uint8_t byte_index = 0;

    for ( byte_index = 0; byte_index < len; ++byte_index )
    {
        crc ^= data [ byte_index ];
        for ( bit_index = 0; bit_index < 8; ++bit_index )
        {
            if ( (crc & 0x80) != 0 )
                crc = (crc << 1) ^ CRC_POLY;
            else
                crc = (crc << 1);
        }
    }

    crc = crc ^ crcxor;

    return crc;
}

void Can_Write_Fun_APP(void)
{
}

void Can_Abort_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
}

void CAN_QuickTimer_Init(void)
{
}

void NODE_26D_SET_Confirm(void)
{
}

void Can_BusOff_Fun(void)
{
}

void Can_BusOffRecover(void)
{
}

void Can_Set_Buff_260(uint8_t CopyData [])
{

}

void Can_Set_Buff_280(uint8_t CopyData [])
{

}

void Can_Set_Buff_380(uint8_t CopyData [])
{

}

void Can_Set_Buff_385(uint8_t CopyData [])
{

}

void Can_Set_Buff_52E(uint8_t CopyData [])
{

}

void Can_Set_Buff_69B(uint8_t CopyData [])
{

}

void Can_Set_Buff_28A(uint8_t CopyData [])
{

}

void Can_Set_Buff_2E1(uint8_t CopyData [])
{

}
void Can_Set_Buff_228(uint8_t CopyData [])
{

}

void Can_Set_Buff_211(uint8_t CopyData [])
{

}
void Can_Set_Buff_341(uint8_t CopyData [])
{

}
void Can_Set_Buff_128(uint8_t CopyData [])
{

}
void Can_Set_Buff_24A(uint8_t CopyData [])
{

}
void Can_Set_Buff_35A(uint8_t CopyData [])
{

}

void Can_Set_Buff_135(uint8_t CopyData [])
{

}
void Can_Set_Buff_153(uint8_t CopyData [])
{

}
void Can_Set_Buff_131(uint8_t CopyData [])
{

}
void Can_Set_Buff_139(uint8_t CopyData [])
{

}
void Can_Set_Buff_431(uint8_t CopyData [])
{

}
void Can_Set_Buff_5e0(uint8_t CopyData [])
{

}
void Can_Set_Buff_236(uint8_t CopyData [])
{

}

void Can_Set_Buff_168(uint8_t CopyData [])
{

}
void Can_Set_Buff_0F6(uint8_t CopyData [])
{

}
void Can_Set_Buff_0E1(uint8_t CopyData [])
{

}
void Can_Set_Buff_036(uint8_t CopyData [])
{

}

void Can_Set_Buff_0B6(uint8_t CopyData [])
{

}

void Can_Set_Buff_320(uint8_t CopyData [])
{

}

void Can_Set_Buff_152(uint8_t CopyData [])
{

}

void Can_Set_Buff_1A1(uint8_t CopyData [])
{

}

void Can_Set_Buff_75F(uint8_t CopyData [])
{
}

void Can_Set_Buff_389(uint8_t CopyData [])
{

}
void init_CAN_Frame(CAN_Frame_st_t* msg, uint32_t can_id, uint8_t can_len, uint8_t can_frame_ide, const uint8_t* data)
{
    for (uint32_t i = 0; i < can_len; i++) {
        msg->unCANData.u8CANData[i] = 0;
    }

    msg->u32CANID = can_id;
    msg->u8CANLEN = can_len;
    // msg->u8CANFrameIDE = can_frame_ide;
    msg->u8CANFrameIDE = 0;
    for (uint32_t i = 0; i < can_len; i++) {
        msg->unCANData.u8CANData[i] = data[i];
    }
}

void can_mid(CAN_Frame_st_t Msg)
{
    CAN_Frame_st_t m_msg;

    init_CAN_Frame(&m_msg, Msg.u32CANID, Msg.u8CANLEN, Msg.u8CANFrameIDE, Msg.unCANData.u8CANData);

    RSCAN0_CH4_Set_FIFO0_Data(&m_msg);
}
uint8_t rolaconter = 0;
void can_submit(void)
{
    //车速112
    CAN_Frame_st_t m_msg1;// 车速 母线电流
    uint8_t data1[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C20FFD2


    //功率103
    CAN_Frame_st_t m_msg2;// 氛围灯 报警器报警状态 整车状态 自动大灯功能设置
    uint8_t data2[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C10FFD3
    //电量104
    CAN_Frame_st_t m_msg3;// 氛围灯 整车操作状态反馈
    uint8_t data3[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C22FFD2


    //定速巡航/翘头辅助116
    CAN_Frame_st_t m_msg4;
    uint8_t data4[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFD0


    //动力系统/挡位/READY/TURBO/降功率 113
    CAN_Frame_st_t m_msg5;// 总电池电压
    uint8_t data5[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C10FFD1

    //ABS OFF / ABS 12F
    CAN_Frame_st_t m_msg6;
    uint8_t data6[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFD2
    //充电指示灯331
    CAN_Frame_st_t m_msg7;
    uint8_t data7[8] = {0, 0, 0, 0, 0, 0, 0, 0};

    //故障指示灯 012/104/105
    CAN_Frame_st_t m_msg8;
    uint8_t data8[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    //侧支架/自动驻车 115
     CAN_Frame_st_t m_msg9;
    uint8_t data9[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    //油门曲线 117
      CAN_Frame_st_t m_msg10;
    uint8_t data10[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    //左手拨杆  317
     CAN_Frame_st_t m_msg11;
    uint8_t data11[8] = {0, 0, 0, 0, 0, 0, 0, 0};

    switch (MENU_CHECK_STEP)
    {
        case 0:
            data1[3]=0;
            init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
            data2[7]=0;
            init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
            data4[1]=0;
            init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
          data5[5]=0;
            init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
            data3[1]=0;
            init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
            data9[3]=0;
            init_CAN_Frame(&m_msg9,0x115,8,1,data9);
             data6[0]=0;
            init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
             data7[2]=0;
            init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
            data8[0]=0;
            init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8);
             data10[7]=0;
            init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
            data11[7]=0;
            init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
        case  1://步骤1
                 data1[0]=0xFF;
            data1[1]=0xFF;
            data1[2]=0x34;
            init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1); 
            data4[0]=0x01;
            data4[1]=0xC7;
            init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
            data3[0]=0xE8;
            data3[1]=0x03;
            init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
              data6[0]=0x00;
            init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
            data2[6]=0x06;
            init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
            data5[5]=0x01;
            data5[6]=0x0A;
            init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
            data7[7]=0;
            init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
            data8[7]=0;
            init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8); 
            data9[7]=0;
            init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9); 
            data10[7]=0;
            init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
            data11[7]=0;
            init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
            break;
        case  2:
                  data1[0]=0xFF;
            data1[1]=0xFF;
            data1[2]=0x34;
            init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
                data2[6]=0xF5;
                data2[7]=0xFF;
            init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
                 data3[0]=0xD0;
            data3[1]=0x07;
            init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
        data4[0]=0x01;
            data4[1]=0xC7;
            init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
            data5[5]=0x04;
            data5[6]=0x14;
            init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
       
            data6[1]=0x20;
            init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
          
            data7[7]=0;
            init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
            data8[7]=0;
            init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8); 
            data9[7]=0;
            init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9); 
            data10[7]=0;
            init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
            data11[7]=0;
            init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
            break;
        case  3:
                  data1[0]=0xFF;
            data1[1]=0xFF;
            data1[2]=0x34;
            init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
                data2[7]=0;
            init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
                 data3[0]=0x88;
            data3[1]=0x13;
            init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
        data4[0]=0x01;
            data4[1]=0xC7;
            init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
           data5[5]=0x09;
           data5[6]=0x32;
            init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
       
            data6[0]=0x00;
            data6[1]=0x00;
            init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
             data7[7]=0;
            init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
            data8[7]=0;
            init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8); 
            data9[7]=0;
            init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9); 
            data10[7]=0;
            init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
            data11[7]=0;
            init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 

            break;
        // case 4:
        //       data1[0]=0xC8;
        //     data1[1]=0x32;
        //     data1[2]=0x28;
        //     data1[3]=0x28;
        //     init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
        //              data2[8]=0;
        //     init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
        //        data3[0]=0xA0;
        //     data3[1]=0x0F;
        //     init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
        // data4[0]=0x01;
        //     data4[1]=0xC7;
        //     init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
        //    data5[5]=0x09;
        //     init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
        //      data6[0]=0x20;
        //     init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
        //     data7[2]=0xCD;
        //     data7[3]=0x0C;
        //     init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
        // data8[8]=0;
        //     init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8); 
        //     data9[8]=0;
        //     init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9); 
        //     data10[8]=0;
        //     init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
        //     data11[8]=0;
        //     init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
        //     break;
        // case 5:
        //       data1[0]=0xC8;
        //     data1[1]=0x32;
        //     data1[2]=0x28;
        //     data1[3]=0x28;
        //     init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
        //            data2[8]=0;
        //     init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
        //            data3[0]=0x88;
        //     data3[1]=0x13;
        //     init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
        // data4[0]=0x01;
        //     data4[1]=0xC7;
        //     init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
        //     data5[5]=0x05;
        //     data5[3]=0x01;
        //     init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
        //      data6[0]=0;
        //     init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
        //     data7[2]=0;
        //     init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
        // data8[8]=0;
        //     init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8); 
        //     data9[8]=0;
        //     init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9); 
        //     data10[8]=0;
        //     init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
        //     data11[8]=0;
        //     init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
       
        //     break;
        // case 6:
        //       data1[0]=0xC8;
        //     data1[1]=0x32;
        //     data1[2]=0x28;
        //     data1[3]=0x28;
        //     init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
        //          data2[8]=0;
        //     init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
        //                data3[0]=0x70;
        //     data3[1]=0x17;
        //     init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
        // data4[0]=0x01;
        //     data4[1]=0xC7;
        //     init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
        //     data5[5]=0x04;
        //     init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
        //    data6[0]=0;
        //     init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
        //      data7[2]=0;
        //     init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
        //     data8[0]=0x01;
        //     init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8);
        //       data9[1]=0x10;
        //     init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9);
        //      data10[8]=0;
        //     init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
        //     data11[8]=0;
        //     init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
        //     break;
        // case 7:
        //       data1[0]=0xC8;
        //     data1[1]=0x32;
        //     data1[2]=0x28;
        //     data1[3]=0x28;
        //     init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
        //          data2[8]=0;
        //     init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
        //         data3[0]=0x58;
        //     data3[1]=0x1B;
        //     init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
        // data4[0]=0x01;
        //     data4[1]=0xC7;
        //     init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
        //      data5[5]=0x02;
        //      data5[7]=0x01;
        //     init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
        //      data6[0]=0;
        //     init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
        //      data7[2]=0;
        //     init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
        //     data8[0]=0;
        //     init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8);
        //       data9[1]=0;
        //     init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9);
        //      data10[8]=0;
        //     init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
        //     data11[8]=0;
        //     init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
          
        //     break;
        // case 8:
        //       data1[0]=0xC8;
        //     data1[1]=0x32;
        //     data1[2]=0x28;
        //     data1[3]=0x28;
        //     init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
        //            data2[8]=0;
        //     init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
        //          data3[0]=0x40;
        //     data3[1]=0x1F;
        //     init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
        // data4[0]=0x01;
        //     data4[1]=0xC7;
        //     data4[2]=0x01;
        //     data4[3]=0x0D;
        //     init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
        //     data5[5]=0x06;
        //     init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
        //    data6[0]=0;
        //     init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
        //      data7[2]=0;
        //     init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
        //     data8[0]=0;
        //     init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8);
        //       data9[1]=0;
        //     init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9);
        //      data10[8]=0;
        //     init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
        //     data11[8]=0;
        //     init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
           

        //     break;
        // case 9:
        //       data1[0]=0xC8;
        //     data1[1]=0x32;
        //     data1[2]=0x28;
        //     data1[3]=0x28;
        //     init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
        //              data2[8]=0;
        //     init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
        // data4[0]=0x01;
        //     data4[1]=0xC7;
        //     init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
        //   data5[5]=0x02;
        //     init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
        //       data3[0]=0x28;
        //     data3[1]=0x23;
        //     init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
        //     data9[3]=0x04;
        //     init_CAN_Frame(&m_msg9,0x115,8,1,data9);
        //      data6[0]=0;
        //     init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
        //      data7[2]=0;
        //     init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
        //     data8[0]=0;
        //     init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8);
        //      data10[8]=0;
        //     init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
        //     data11[8]=0;
        //     init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
        //     break;
        case 4:
              data1[0]=0xFF;
            data1[1]=0xFF;
            data1[2]=0x34;
            init_CAN_Frame(&m_msg1, 0x112, 8, 1, data1);
             data2[6]=0xE8;
             data2[7]=0xFF;
            init_CAN_Frame(&m_msg2, 0x103, 8, 1, data2); 
        data4[0]=0x01;
        data4[1]=0xC7;
        data4[2]=0x01;
        data4[3]=0x1F;
            init_CAN_Frame(&m_msg4, 0x116, 8, 1, data4); 
            data5[3]=0x01;
            data5[5]=0x02;
            data5[6]=0x64;
            data5[7]=0x01;
           data5[1]=0x10;
            init_CAN_Frame(&m_msg5, 0x113, 8, 1, data5); 
              data3[0]=0x10;
            data3[1]=0x27;
            init_CAN_Frame(&m_msg3, 0x104, 8, 1, data3); 
             data6[0]=0x20;
            data6[1]=0x20;
            init_CAN_Frame(&m_msg6, 0x12F, 8, 1, data6); 
            data7[0]=0xCD;
            data7[1]=0x0C;
             data7[2]=0xCD;
            data7[3]=0x0C;
            init_CAN_Frame(&m_msg7, 0x331, 8, 1, data7); 
             data8[0]=0x01;
            init_CAN_Frame(&m_msg8, 0x012, 8, 1, data8);
              data9[1]=0x10;
              data9[2]=0x01;
              data9[3]=0x04;
            init_CAN_Frame(&m_msg9, 0x115, 8, 1, data9);
                  data10[2]=0x10;
            init_CAN_Frame(&m_msg10, 0x117, 8, 1, data10); 
            data11[3]=0x01;
            init_CAN_Frame(&m_msg11, 0x317, 8, 1, data11); 
            break;
        default:
            break;
    }
    if(MENU_CHECK_STEP != 0 && MENU_CHECK_STEP<=4)
    {
        can_mid(m_msg1);
        can_mid(m_msg2);
        can_mid(m_msg3);
        can_mid(m_msg4);
        can_mid(m_msg5);
        can_mid(m_msg6);
        can_mid(m_msg7);
        can_mid(m_msg8);
        can_mid(m_msg9);
        can_mid(m_msg10);
        can_mid(m_msg11);
    }
    if(rolaconter<4)
    {
        rolaconter++;
    }
    else
    {
        rolaconter = 0;
    }
    
}
uint8_t u8get714msg[8];
uint8_t u8getSWmsg[8];
uint8_t u8getPnmsg[8];
uint8_t SWtestresult = 0;
uint8_t HWtestresult = 0;
uint8_t PNtestresult = 0;
uint8_t ruanjianbanbenhao[8];
uint8_t ruanjianbanbenhao2[8];
uint8_t yingjianbanbenhao[8];
uint8_t lingjianhao[21];
uint8_t zhenduanstep = 0;
void Get_SW_msg(void);
void Get_HW_msg(void);
void Get_PN_msg(void);
extern uint8_t getmsgfinish;
extern uint32_t send0x714time;

void send_0x714_fuc()
{

        CAN_Frame_st_t m_msg7;
    uint8_t data7[8] = {0, 0, 0, 0, 0, 0, 0, 0};

    if(MENU_CHECK_STEP != 0)
    {
        SWtestresult = 0;
        HWtestresult = 0;
        PNtestresult = 0;
    }
    switch (zhenduanstep)
    {
        case 0:
            data7[0] = 0x03;
            data7[1] = 0x22;
            data7[2] = 0xF1;
            data7[3] = 0x89;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7d2, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            break;
        case 1:
            data7[0] = 0x30;
            data7[1] = 0x00;
            data7[2] = 0x00;
            data7[3] = 0xAA;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7d2, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            Get_SW_msg();
            break;
        case 2:
            Get_SW_msg();
            zhenduanstep++;
        break;
        case 3:
            data7[0] = 0x03;
            data7[1] = 0x22;
            data7[2] = 0xF1;
            data7[3] = 0x93;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7d2, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            break;
        case 4:
            data7[0] = 0x30;
            data7[1] = 0x00;
            data7[2] = 0x00;
            data7[3] = 0xAA;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7d2, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            break;
        case 5:
            Get_HW_msg();
            zhenduanstep++;
            break;
        case 6:
            data7[0] = 0x03;
            data7[1] = 0x22;
            data7[2] = 0xF1;
            data7[3] = 0x87;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7d2, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            break;
        case 7:
            Get_PN_msg();
            data7[0] = 0x30;
            data7[1] = 0x00;
            data7[2] = 0x00;
            data7[3] = 0xAA;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7d2, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            Get_PN_msg();
            break;
        case 8:
            Get_PN_msg();
            zhenduanstep++;
            break;
        default:
        zhenduanstep = 0;
        cycleflag = 0;
        getmsgfinish = 1;
        send0x714time = 0;
        break;
    }

}

void Get_ID_0x794_Msg(void)
{

}
uint8_t Can_Flag=0;
uint8_t dnajcx[9];
uint8_t dnajcx2[9];
void Get_SW_msg(void)
{
    if(MENU_CHECK_STEP==0){
 
      u8get714msg[0] = Get_CAN_CH0_ID_72d_byte0_Sig();
    u8get714msg[1] = Get_CAN_CH0_ID_72d_byte1_Sig();
    u8get714msg[2] = Get_CAN_CH0_ID_72d_byte2_Sig();
    u8get714msg[3] = Get_CAN_CH0_ID_72d_byte3_Sig();
    u8get714msg[4] = Get_CAN_CH0_ID_72d_byte4_Sig();
    u8get714msg[5] = Get_CAN_CH0_ID_72d_byte5_Sig();
    u8get714msg[6] = Get_CAN_CH0_ID_72d_byte6_Sig();
    u8get714msg[7] = Get_CAN_CH0_ID_72d_byte7_Sig();
      if((u8get714msg[0] == 0x10) && (u8get714msg[4] == 0x89))
    {
        dnajcx2[0] = u8get714msg[5];
        dnajcx2[1] = u8get714msg[6];
        dnajcx2[2] = u8get714msg[7];
    }
    else if((u8get714msg[0] == 0x21) && (u8get714msg[3] == 0x2E))
    {
        dnajcx2[3] = u8get714msg[1];
        dnajcx2[4] = u8get714msg[2];
        dnajcx2[5] = u8get714msg[3];
        dnajcx2[6] = u8get714msg[4];
        dnajcx2[7] = u8get714msg[5];
        dnajcx2[8] = 0XFF;
        General_Number_Disp(dnajcx2, 105, 25);  
    }
    }
}

void Get_HW_msg(void)
{
    // if(HWtestresult == 1)
    // {
    //     return ;
    // }
    // u8get714msg[0] = Get_CAN_CH0_ID_72d_byte0_Sig();
    // u8get714msg[1] = Get_CAN_CH0_ID_72d_byte1_Sig();
    // u8get714msg[2] = Get_CAN_CH0_ID_72d_byte2_Sig();
    // u8get714msg[3] = Get_CAN_CH0_ID_72d_byte3_Sig();
    // u8get714msg[4] = Get_CAN_CH0_ID_72d_byte4_Sig();
    // u8get714msg[5] = Get_CAN_CH0_ID_72d_byte5_Sig();
    // u8get714msg[6] = Get_CAN_CH0_ID_72d_byte6_Sig();
    // u8get714msg[7] = Get_CAN_CH0_ID_72d_byte7_Sig();
    // if(u8get714msg[0] == 0x21 && zhenduanstep == 5)
    // {
    
    //     memcpy(yingjianbanbenhao,&u8get714msg[1],7);
    //     yingjianbanbenhao[8] = 0xFF;
    //     HWtestresult = 1;
    //     for(uint8_t i=15;i<20;i++)
    //     {
    //         yingjianbanbenhao[i]=yingjianbanbenhao[i-15];
    //     }
    //     for(uint8_t j=12;j<20;j++)
    //     {
    //     yingjianbanbenhao[j-12]=yingjianbanbenhao[j];

    //     }
    //     General_Number_Disp(yingjianbanbenhao, 105, 50);  
    //     zhenduanstep++;
    // }
     if(MENU_CHECK_STEP==0){
        u8getSWmsg[0] = Get_CAN_CH0_ID_72d_byte0_Sig();
        u8getSWmsg[1] = Get_CAN_CH0_ID_72d_byte1_Sig();
        u8getSWmsg[2] = Get_CAN_CH0_ID_72d_byte2_Sig();
        u8getSWmsg[3] = Get_CAN_CH0_ID_72d_byte3_Sig();
        u8getSWmsg[4] = Get_CAN_CH0_ID_72d_byte4_Sig();
        u8getSWmsg[5] = Get_CAN_CH0_ID_72d_byte5_Sig();
        u8getSWmsg[6] = Get_CAN_CH0_ID_72d_byte6_Sig();
        u8getSWmsg[7] = Get_CAN_CH0_ID_72d_byte7_Sig();
    // }
    if((u8getSWmsg[0] == 0x10) && (u8getSWmsg[4] == 0x93))
    {
        dnajcx[0] = u8getSWmsg[5];
        dnajcx[1] = u8getSWmsg[6];
        dnajcx[2] = u8getSWmsg[7];
    }
    else if((u8getSWmsg[0] == 0x21) && (u8getSWmsg[2] == 0x2D))
    {
        dnajcx[3] = u8getSWmsg[1];
        dnajcx[4] = u8getSWmsg[2];
        dnajcx[5] = u8getSWmsg[3];
        dnajcx[6] = u8getSWmsg[4];
        dnajcx[7] = u8getSWmsg[5];
        dnajcx[8] = 0XFF;
        General_Number_Disp(dnajcx, 105, 50);  
    }
     }
}
uint8_t PNresult = 0;
 uint8_t PNFlag=0;
void Get_PN_msg(void)
{
   if(MENU_CHECK_STEP==0)
   {
    
    {
    u8getPnmsg[0] = Get_CAN_CH0_ID_72d_byte0_Sig();
    u8getPnmsg[1] = Get_CAN_CH0_ID_72d_byte1_Sig();
    u8getPnmsg[2] = Get_CAN_CH0_ID_72d_byte2_Sig();
    u8getPnmsg[3] = Get_CAN_CH0_ID_72d_byte3_Sig();
    u8getPnmsg[4] = Get_CAN_CH0_ID_72d_byte4_Sig();
    u8getPnmsg[5] = Get_CAN_CH0_ID_72d_byte5_Sig();
    u8getPnmsg[6] = Get_CAN_CH0_ID_72d_byte6_Sig();
    u8getPnmsg[7] = Get_CAN_CH0_ID_72d_byte7_Sig();
    if((u8getPnmsg[0] == 0x10) && (u8getPnmsg[4] == 0x87) && (PNresult == 0))
    {
        lingjianhao[0] = u8getPnmsg[5];
        lingjianhao[1] = u8getPnmsg[6];
        lingjianhao[2] = u8getPnmsg[7];
        PNresult = 1;
    }
    else if((u8getPnmsg[0] == 0x21)  && (PNresult == 1))
    {
       lingjianhao[3] = u8getPnmsg[1];
       lingjianhao[4] = u8getPnmsg[2];
       lingjianhao[5] = u8getPnmsg[3];
       lingjianhao[6] = u8getPnmsg[4];
       lingjianhao[7] = u8getPnmsg[5];
       lingjianhao[8] = u8getPnmsg[6];
       lingjianhao[9] = 0xFF;
       if(PNFlag==0)
       {   
        //   Gen_TimeDelay (500 *1000,50U);
        General_Number_Disp(lingjianhao, 5,95);  
        PNresult=0;
        PNFlag=1;
       }
    }
    }
   }

}
uint32_t GenerateKey(uint8_t *Seed)
{
    const uint8_t Xor[4] = {0x34, 0x66, 0x2E, 0x8D};
    uint8_t key_array[4], Cal[4];
    uint32_t key_value;

    for (size_t i = 0; i < 4; i++)
    {
        Cal[i] = Seed[i] ^ Xor[i];
    }

    key_array[0] = ((Cal[2] & 0xF0) << 4) | (Cal[3] & 0xF0);
    key_array[1] = ((Cal[3] & 0x2F) << 2) | (Cal[1] & 0x03);
    key_array[2] = ((Cal[1] & 0xFC) >> 2) | (Cal[0] & 0xC0);
    key_array[3] = ((Cal[0] & 0x0F) << 4) | (Cal[2] & 0x0F);

    key_value = ((uint32_t)key_array[0] << 24U);
    key_value = key_value | ((uint32_t)key_array[1] << 16U);
    key_value = key_value | ((uint32_t)key_array[2] << 8U);
    key_value = key_value | (uint32_t)key_array[3];

    return (key_value);
}

uint8_t chaengUDSstep = 0;
uint8_t getseedresult = 0;
uint8_t seednum[4] = {0};
uint8_t seedresult[4] = {0};
void get_seed_msg(void);
uint32_t UDS_time = 0;
extern uint32_t fakedelay;
uint8_t resettime = 0;
uint8_t resetflag = 0;
extern uint32_t fakedelay;
uint32_t resetpowtime = 0;
uint32_t FUresetpowtime = 0;
uint8_t fuelreset1 = 0;
uint8_t fuelreset2 = 0;
uint8_t fuelreset3 = 0;
uint8_t fuelreset4 = 0;
void resetpowerfuel(void)
{
    if(FUresetpowtime < 100)
    {
        FUresetpowtime++;
        // POWER_CTRL_KL30   = 0u;  //B+
        // POWER_CTRL_KL15   = 0u;  //KL15
    }
    else
    {
        // POWER_CTRL_KL30   = 1u;  //B+
        // POWER_CTRL_KL15   = 1u;  //KL15
        FUresetpowtime = 0;
        if(fuelreset1 == 1)
        {
            fuelreset1 = 2;
        }
        else if(fuelreset2 == 1)
        {
            fuelreset2 = 2;
        }
        else if(fuelreset3 == 1)
        {
            fuelreset3 = 2;
        }
        else if(fuelreset4 == 1)
        {
            fuelreset4 = 2;
        }
        else
        {
            ;
        }

    }
}
void resetpower(void)
{

    if(resetpowtime < 100)
    {
        resetpowtime++;
        // POWER_CTRL_KL30   = 0u;  //B+
        // POWER_CTRL_KL15   = 0u;  //KL15
    }
    else
    {
        // POWER_CTRL_KL30   = 1u;  //B+
        // POWER_CTRL_KL15   = 1u;  //KL15
        
        chaengUDSstep = 0;
        resettime = 1;
    }
    // resetflag = 1;
}
void resetchangeUDSfuc(void)
{
    if((MENU_CHECK_STEP == 0 || MENU_CHECK_STEP == 4) && resettime == 0)
    {
        
        
        fakedelay = 0;
        UDS_time = 0;
        getseedresult = 0;
        fakedelay = 0;
        if(MENU_CHECK_STEP == 4)
        {
            resetpower();
        }
        else
        {
            resettime = 1;
            chaengUDSstep = 0;
        }
        
    }
    if(MENU_CHECK_STEP != 0 && MENU_CHECK_STEP != 4)
    {
        resettime = 0;
    }
}
uint8_t vspeedpeizhi = 0;
uint8_t trackmode = 0;
void change_UDS_DID(void)
{
    if(MENU_CHECK_STEP != 0)
    {
        vspeedpeizhi = 0x4;
        trackmode = 1;
    }
    else
    {
        vspeedpeizhi = 0x3;
        trackmode = 0;
    }
    CAN_Frame_st_t m_msg;
    uint8_t data[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    // switch (chaengUDSstep)
    // {
    //     case 0:
    //     // resetflag = 1;
    //         data[0] = 0x02;
    //         data[1] = 0x10;
    //         data[2] = 0x03;
    //         data[3] = 0xAA;
    //         data[4] = 0xAA;
    //         data[5] = 0xAA;
    //         data[6] = 0xAA;
    //         data[7] = 0xAA;
    //         init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
    //         can_mid(m_msg);
    //         // POWER_CTRL_KL30   = 1u;  //B+
    //         // POWER_CTRL_KL15   = 1u;  //KL15
    //         chaengUDSstep++;
    //         break;
    //     case 1:
    //         data[0] = 0x02;
    //         data[1] = 0x27;
    //         data[2] = 0x01;
    //         data[3] = 0xAA;
    //         data[4] = 0xAA;
    //         data[5] = 0xAA;
    //         data[6] = 0xAA;
    //         data[7] = 0xAA;
    //         init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
    //         can_mid(m_msg);
    //         chaengUDSstep++;
    //         break;
    //     case 2:
    //         get_seed_msg();
    //         if(getseedresult == 1)
    //         {
    //             chaengUDSstep++;
    //         }
            
    //         break;
    //     case 3:
    //         data[0] = 0x06;
    //         data[1] = 0x27;
    //         data[2] = 0x02;
    //         data[3] = seedresult[0];
    //         data[4] = seedresult[1];
    //         data[5] = seedresult[2];
    //         data[6] = seedresult[3];
    //         data[7] = 0xAA;
    //         init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
    //         can_mid(m_msg);
    //         chaengUDSstep++;
    //         break;
    //     case 4:
    //         data[0] = 0x10;
    //         data[1] = 0x13;
    //         data[2] = 0x2E;
    //         data[3] = 0xF0;
    //         data[4] = 0x10;
    //         data[5] = 0x02;
    //         data[6] = 0xBF;
    //         data[7] = 0xFD;
    //         init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
    //         can_mid(m_msg);
    //         chaengUDSstep++;
    //         break;
    //     case 5:
    //         data[0] = 0x21;
    //         data[1] = 0xE7;
    //         data[2] = vspeedpeizhi;//车速配置四:0x03 车速配置五：0x04
    //         data[3] = 0x03;
    //         data[4] = 0x98;
    //         data[5] = 0x20;
    //         data[6] = 0x00;
    //         data[7] = 0x00;
    //         init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
    //         can_mid(m_msg);
    //         chaengUDSstep++;
    //         break;
    //     case 6:
    //         data[0] = 0x22;
    //         data[1] = 0x00;
    //         data[2] = 0x00;
    //         data[3] = 0x00;
    //         data[4] = 0x00;
    //         data[5] = 0x00;
    //         data[6] = 0x00;
    //         data[7] = 0xAA;
    //         init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
    //         can_mid(m_msg);
    //         chaengUDSstep++;
    //         break;
    //     case 7:
    //     {//履带模式开关
    //         data[0] = 0x04;
    //         data[1] = 0x2E;
    //         data[2] = 0x03;
    //         data[3] = 0x0A;
    //         data[4] = trackmode;//1:开 0：关
    //         data[5] = 0xAA;
    //         data[6] = 0xAA;
    //         data[7] = 0xAA;
    //         init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
    //         can_mid(m_msg);
    //         chaengUDSstep++;
    //         break;
    //     }   

    //     case 8:
    //             POWER_CTRL_KL30   = 0u;  //B+
    //             POWER_CTRL_KL15   = 0u;  //KL15
    //             if(UDS_time < 100)
    //             {
    //                 UDS_time++;
    //             }
    //             else
    //             {
    //                 chaengUDSstep++;
    //             }
    //             break;
    //     case 9:
    //             // POWER_CTRL_KL30   = 1u;  //B+
    //             // POWER_CTRL_KL15   = 1u;  //KL15
    //             if(UDS_time < 50)
    //             {
    //                 UDS_time++;
    //             }
    //             else
    //             {
    //                 chaengUDSstep++;
    //             }
    //             break;
    //     default:
    //     cycleflag = 1;
    //     resetflag = 0;
    //     break;
    // }
}
uint32_t testseed;
void get_seed_msg(void)
{
    if(getseedresult == 1)
    {
        return ;
    }
    u8get714msg[0] = Get_CAN_CH0_ID_794_byte0_Sig();
    u8get714msg[1] = Get_CAN_CH0_ID_794_byte1_Sig();
    u8get714msg[2] = Get_CAN_CH0_ID_794_byte2_Sig();
    u8get714msg[3] = Get_CAN_CH0_ID_794_byte3_Sig();
    u8get714msg[4] = Get_CAN_CH0_ID_794_byte4_Sig();
    u8get714msg[5] = Get_CAN_CH0_ID_794_byte5_Sig();
    u8get714msg[6] = Get_CAN_CH0_ID_794_byte6_Sig();
    u8get714msg[7] = Get_CAN_CH0_ID_794_byte7_Sig();
    if(u8get714msg[1] == 0x67 && u8get714msg[2] == 0x01)
    {
        memcpy(seednum,&u8get714msg[3],4);
        testseed = GenerateKey(seednum);
        seedresult[0] = (uint8_t)(testseed >> 24);
        seedresult[1] = (uint8_t)(testseed >> 16);
        seedresult[2] = (uint8_t)(testseed >> 8);
        seedresult[3] = (uint8_t)testseed ;
        getseedresult = 1;
        
    }
    // getseedresult = 1;
}
uint8_t opentrackstep = 0;
void Opentracksta(void)
{
    CAN_Frame_st_t m_msg;
    uint8_t data[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    switch (opentrackstep)
    {
        case 0:
            data[0] = 0x02;
            data[1] = 0x10;
            data[2] = 0x03;
            data[3] = 0xAA;
            data[4] = 0xAA;
            data[5] = 0xAA;
            data[6] = 0xAA;
            data[7] = 0xAA;
            init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
            can_mid(m_msg);
            chaengUDSstep++;
            break;
        case 1:
            data[0] = 0x02;
            data[1] = 0x27;
            data[2] = 0x01;
            data[3] = 0xAA;
            data[4] = 0xAA;
            data[5] = 0xAA;
            data[6] = 0xAA;
            data[7] = 0xAA;
            init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
            can_mid(m_msg);
            chaengUDSstep++;
            break;
        case 2:
            get_seed_msg();
            if(getseedresult == 1)
            {
                chaengUDSstep++;
            }
            
            break;
        case 3:
            data[0] = 0x06;
            data[1] = 0x27;
            data[2] = 0x02;
            data[3] = seedresult[0];
            data[4] = seedresult[1];
            data[5] = seedresult[2];
            data[6] = seedresult[3];
            data[7] = 0xAA;
            init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
            can_mid(m_msg);
            chaengUDSstep++;
            break;
        case 4:
        {
            data[0] = 0x04;
            data[1] = 0x2E;
            data[2] = 0x03;
            data[3] = 0x0A;
            data[4] = 0x01;
            data[5] = 0xAA;
            data[6] = 0xAA;
            data[7] = 0xAA;
            init_CAN_Frame(&m_msg, 0x7d2, 8, 1, data); 
            can_mid(m_msg);
            chaengUDSstep++;
            break;
        }   

        default:
        break;
    }
}