#ifndef _BENCH_TP_COMMON_H_
#define _BENCH_TP_COMMON_H_

#include "stdint.h"

typedef uint32_t PduIdType;
enum {
    BenchTpPduId0,
    BenchTpPduIdMax,
};

extern void BenchTpInit(uint32_t id);
extern void BenchTpTaskMain(uint16_t TimerDelta);
extern void BenchTpRxFrame(uint32_t Id, PduIdType RxPduId, uint8_t *CAN_BufAddr, uint8_t dlc);
extern void BenchTpSendMessageToCan(uint32_t ID, uint8_t *data, uint8_t len);

extern void BenchTpDataProc(uint8_t *data, uint32_t len);
extern void BenchTpTxData(PduIdType TxPduId, uint8_t *data, uint32_t Length);

#endif
