

#include "LCD_C035QAN02.h"

volatile LCDPanelUpdtCtrlStruct          LCDPanelUpdtCtrl;
uint32_t* LCDPanelGraphicRAM = (uint32_t*)VRAM_BUF[ 0 ];


void LCD_Panel_Start_Up(void)
{
    uint8_t   Para[4];
    
    LCDPanelGraphicRAM = (uint32_t*)VRAM_BUF[ 0 ];
    
    LCDPanelUpdtCtrl.Request    = 0;
    LCDPanelUpdtCtrl.Cmd       = 1;
    
    LCDPanelUpdtCtrl.StartPage = 0;
    LCDPanelUpdtCtrl.Len       = 0;
    LCDPanelUpdtCtrl.pData     = (uint32_t*)LCDPanelGraphicRAM;
    
    //Reset Panel
    LCD_BUS_Panel_Reset_Ctrl(0);
    bsp_IIC_DelayUs(2000);
    LCD_BUS_Panel_Reset_Ctrl(1);
    bsp_IIC_DelayUs(2000);
    
    //Panel Init
    Para[0] = 0xa5;
    LCD_BUS_Write_Cmd(0x5e, Para, 1);     //SWreset
    
    Para[0] = 0x0e;
    Para[1] = 0x00;
    Para[2] = 0x00;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x49, Para, 4);     //VCMDAT
    
    Para[0] = 0x8f;
    Para[1] = 0x44;
    Para[2] = 0x02;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x61, Para, 4);     //PWRCTL
    
    bsp_IIC_DelayUs(20);
    
    Para[0] = 0x20;
    Para[1] = 0x71;
    Para[2] = 0xa5;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x5a, Para, 4);     //CPSET ԭҪ ϵʱ
    
    Para[0] = 0x3d;
    Para[1] = 0x0b;
    Para[2] = 0x0b;
    Para[3] = 0xA5;
    LCD_BUS_Write_Cmd(0x71, Para, 4);     //Electronic Volume Set 1
    
    Para[0] = 0x19;
    Para[1] = 0x19;
    Para[2] = 0xa5;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x72, Para, 4);     //Electronic Volume Set 2
    
    Para[0] = 0x01;
    Para[1] = 0x3F;
    Para[2] = 0x00;
    Para[3] = 0xEF;
    LCD_BUS_Write_Cmd(0x91, Para, 4);     //DISAR
    
    Para[0] = 0x32;
    Para[1] = 0x02;
    Para[2] = 0x00;
    Para[3] = 0x01;
    LCD_BUS_Write_Cmd(0x92, Para, 4);     //DISAR
    
    Para[0] = 0x02;
    Para[1] = 0xa5;
    Para[2] = 0xa5;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x21, Para, 4);     //MADCTL
    
    Para[0] = 0x00;
    Para[1] = 0xa5;
    Para[2] = 0xa5;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x24, Para, 4);     //STFRAME
    
    Para[0] = 0x03;
    Para[1] = 0xa5;
    Para[2] = 0xa5;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x25, Para, 4);     //BPPSEL
    
    Para[0] = 0x00;
    Para[1] = 0x00;
    Para[2] = 0x00;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x26, Para, 4);     //MDCTL
    
    Para[0] = 0x00;
    Para[1] = 0xa5;
    Para[2] = 0xa5;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0xA2, Para, 4);     //GATSET
    
    Para[0] = 0x00;
    Para[1] = 0xa5;
    Para[2] = 0xa5;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x69, Para, 4);     //ACSET
    
    Para[0] = 0x00;
    Para[1] = 0x1A;
    Para[2] = 0x1B;
    Para[3] = 0x1D;
    LCD_BUS_Write_Cmd(0x81, Para, 4);     // Set Gamma Positive1
    
    Para[0] = 0x1D;
    Para[1] = 0x1E;
    Para[2] = 0x1F;
    Para[3] = 0x20;
    LCD_BUS_Write_Cmd(0x82, Para, 4);     // Set Gamma Positive2
    
    Para[0] = 0x21;
    Para[1] = 0x23;
    Para[2] = 0x24;
    Para[3] = 0x26;
    LCD_BUS_Write_Cmd(0x83, Para, 4);     // Set Gamma Positive3
    
    Para[0] = 0x28;
    Para[1] = 0x2A;
    Para[2] = 0x2F;
    Para[3] = 0x3F;
    LCD_BUS_Write_Cmd(0x84, Para, 4);     // Set Gamma Positive4
    
    Para[0] = 0x00;
    Para[1] = 0x1B;
    Para[2] = 0x1C;
    Para[3] = 0x1D;
    LCD_BUS_Write_Cmd(0x89, Para, 4);     // Set Gamma Negative1
    
    Para[0] = 0x1E;
    Para[1] = 0x1F;
    Para[2] = 0x20;
    Para[3] = 0x21;
    LCD_BUS_Write_Cmd(0x8A, Para, 4);     // Set Gamma Negative2
    
    Para[0] = 0x22;
    Para[1] = 0x23;
    Para[2] = 0x25;
    Para[3] = 0x26;
    LCD_BUS_Write_Cmd(0x8B, Para, 4);     // Set Gamma Negative3
    
    Para[0] = 0x28;
    Para[1] = 0x2B;
    Para[2] = 0x2F;
    Para[3] = 0x3F;
    LCD_BUS_Write_Cmd(0x8C, Para, 4);     // Set Gamma Negative4
    
    Para[0] = 0xa5;
    LCD_BUS_Write_Cmd(0x16, Para, 1);
    
    bsp_IIC_DelayUs(500);
    
    Para[0] = 0xa5;
    LCD_BUS_Write_Cmd(0x13, Para, 1);
    
    bsp_IIC_DelayUs(500);
    
    Para[0] = 0xa5;
    LCD_BUS_Write_Cmd(0x12, Para, 1);
    
}

/*-------------------------------------------------------------------------
* Function Name  : LCD_ClearFullScreen
* Description    : ʾ
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void LCD_ClearFullScreen(uint8_t FullPixel)
{
    uint16_t  i;
    uint16_t  j;
    uint16_t  count = 0;
    uint8_t   Para[4];
    
    Para[0] = 0;
    Para[1] = 159;
    Para[2] = 0x00;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x22, Para, 4);
    
    Para[0] = 0;
    Para[1] = 0;
    Para[2] = (uint8_t)(239 >> 8);
    Para[3] = (uint8_t)239;
    LCD_BUS_Write_Cmd(0x23, Para, 4);
    
    Para[0] = 0xa5;
    LCD_BUS_Write_Cmd(0x3A, Para, 1);
    
    LCD_BUS_Write_Bus_Fifo(LCD_BUS_CMD_WR_PIXEL | 0x00200000 | (38400 - 1));
        
    for (i = 0; i < LCD_PANEL_WIDTH * LCD_PANEL_HEIGHT / 256; i++)
    {
        count = 0;
        while (LCD_BUS_Get_Status())
        {
            count ++;
            if(count > 38400)
            {
                break;
            }
        }
        
        for (j = 0; j < 32; j++)
        {
            LCD_BUS_Write_Bus_Fifo(0x00000000);
        }
    }
}

void LCD_Panel_Shut_Down(void)
{
    LCDPanelUpdtCtrl.Request = 0;
    LCD_ClearFullScreen(0xFF);
    
    LCD_BUS_Write_Cmd(LCD_CMD_DISPOFF, NULL, 0);

    bsp_IIC_DelayUs(1);

    LCD_BUS_Write_Cmd(LCD_CMD_SLPIN, NULL, 0);
    
    bsp_IIC_DelayUs(150);
    
    Eic_Disable((stc_eic00_t *) &EIC00, 23);  //Disable  VSYNC
}


void LCD_Panel_Update_Req(uint16_t starPage,uint16_t endPage)
{
    uint16_t    wTemp = 0;
    uint8_t   Para[4];
    
    if(LcdBusState)
    {
        return;
    }
    
    if((LCDPanelGraphicRAM != (uint32_t*)VRAM_BUF[ 0 ]) && (LCDPanelGraphicRAM != (uint32_t*)VRAM_BUF[ 1 ]))
    {
        LCDPanelGraphicRAM = (uint32_t*)VRAM_BUF[ 0 ];
    }
    
    Para[0] = starPage;
    Para[1] = endPage-1;
    Para[2] = 0x00;
    Para[3] = 0xa5;
    LCD_BUS_Write_Cmd(0x22, Para, 4);
    
    Para[0] = 0;
    Para[1] = 0;
    Para[2] = (uint8_t)(239 >> 8);
    Para[3] = (uint8_t)239;
    LCD_BUS_Write_Cmd(0x23, Para, 4);
    
    Para[0] = 0xa5;
    LCD_BUS_Write_Cmd(0x3A, Para, 1);
    
    wTemp = (endPage - starPage) * 240;
    
    LCD_BUS_Write_Bus_Fifo(LCD_BUS_CMD_WR_PIXEL | 0x00200000 | (wTemp  - 1));
        
    LCDPanelUpdtCtrl.pData     = (uint32_t*)((uint8_t*)LCDPanelGraphicRAM + starPage * 240);

    LCDPanelUpdtCtrl.Len       = wTemp >> 2;

    LCDPanelUpdtCtrl.Request = 1;
}


uint8_t LCD_Panel_Get_Update_Enable(void)
{
    return !LCDPanelUpdtCtrl.Request;
}

void LCD_Panel_Update_ISR(uint8_t step)
{
    if (LCDPanelUpdtCtrl.Request)
    {
        if (!LCD_BUS_Get_Status())      //Transfer data when bus is idle
        {
            if (LCDPanelUpdtCtrl.Len > 32)
            {
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 0 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 1 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 2 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 3 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 4 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 5 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 6 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 7 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 8 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 9 ];
                
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 10 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 11 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 12 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 13 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 14 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 15 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 16 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 17 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 18 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 19 ];
                
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 20 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 21 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 22 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 23 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 24 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 25 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 26 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 27 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 28 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 29 ];
                
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 30 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 31 ];
                
                LCDPanelUpdtCtrl.pData += 32;
                LCDPanelUpdtCtrl.Len  -= 32;
            }
            else
            {
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 0 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 1 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 2 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 3 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 4 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 5 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 6 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 7 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 8 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 9 ];
                
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 10 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 11 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 12 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 13 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 14 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 15 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 16 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 17 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 18 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 19 ];
                
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 20 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 21 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 22 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 23 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 24 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 25 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 26 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 27 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 28 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 29 ];
                
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 30 ];
                LCDB_InstructionFifo0 = LCDPanelUpdtCtrl.pData[ 31 ];
                
                LCDPanelUpdtCtrl.Len = 0;
                LCDPanelUpdtCtrl.Request = 0;
                LCDB_InstructionFifo0 = LCD_BUS_CMD_END;
                
                if(UpScreenStep == 9)
                {
                    UpScreenStep = 10;
                    UP_VSYNC = 0;                  //qitiancun 2018-6-21
                    g_DrawInfo.VramCalOverFlag[ memoryVramSel ] = 0;
                }
            }
        }
    }
}
