#include "CAN_Communication_Matrix.h"
#include "CAN_APP.h"
/* 2021/08/08 16:54:40 */
/*
can1    0-  31
can2    32- 63
can4    64  95
*/


//Tx：
const st_CAN_SendAttribute st_CANSendAttr [ ID_SEND_TOTAL ] = {
    {0x2E1ul, 50ul * 1000ul, 0ul, 0u, 0, 64u, 8u, 0, Can_Set_Buff_2E1, ( void * )0},

};



//Rx:
const st_CANMsgAttribute CAN_MSG_CONST_ARRAY [ CAN_CH0_ID_TOTAL_MAX ] = 
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10FF4117ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEAE17ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10FF1017ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEC1EEul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xCFE6CEEul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEFC17ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x0C82FFD4ul,//物料编码 1 - 5
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },

    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x0C81FFD4ul,//物料编码 5 - 10
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },

    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x0C80FFD4ul,//物料编码 10 - 15
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },

    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x0C70FFD4ul,//esp32主次软件版本号
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },

    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x0C87FFD4ul,//国民 esp32 固件版本号
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },

};






uint32_t Get_ID_ODO(void)
{
    
    uint32_t ret = 0;    
    ret          = Get_CAN_CH0_ID_18FEC1EE_Sig_Total_Vehicle_Distance();
    ret          = ret / 200 ;
    

    return ret;
    
}
uint32_t Get_ID_FUEL(void)
{
    uint32_t ret = 0;
    ret          = Get_CAN_CH0_ID_18FEFC17_Sig_Fuel_level();    
    ret          = ret * 2 / 5;  
    return ret;
}
uint32_t Get_ID_VSpeed(void)
{
    uint32_t ret = 0;
    ret          = Get_CAN_CH0_ID_0CFE6CEE_Sig_Tachograph_vehicle_speed();    
    ret          = ret  / 256;  
    return ret;
}

uint8_t Get_ID_HandBrakeSts(void)
{
    uint8_t ret = 0; 
    ret         = Get_CAN_CH0_ID_10FF4117_Sig_IC_HandBrakeSts();
    return ret;
}




uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_IC_HCSPS_LampFailSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF4117_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_BackUPSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF4117_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_Seatbeltsts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF4117_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF4117_Sig_IC_HandBrakeSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF4117_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEAE17_Sig_Service_Brake_Circuit_2_Air_Pressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send18FEAE17_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEAE17_Sig_Service_Brake_Circuit_1_Air_Pressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send18FEAE17_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_HeatedMirrorSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF1017_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_RearFogLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF1017_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_FrontFogLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF1017_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_LowBeamSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF1017_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_HighBeamSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF1017_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_LHParkTailLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF1017_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1017_Sig_RHParkTailLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send10FF1017_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint32_t Get_CAN_CH0_ID_18FEC1EE_Sig_Total_Vehicle_Distance(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0_ID_Send18FEC1EE_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0_ID_Send18FEC1EE_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0_ID_Send18FEC1EE_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint32_t)((uint32_t)CAN_MSG_Read(CAN_CH0_ID_Send18FEC1EE_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0CFE6CEE_Sig_Tachograph_vehicle_speed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0_ID_Send0CFE6CEE_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0_ID_Send0CFE6CEE_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEFC17_Sig_Fuel_level(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0_ID_Send18FEFC17_Msg_Count, 0u) >> 0u) & 0xFFu));
}












uint8_t Co_Can_ConvertSubID(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_Send10FF4117_Msg:
        u8Result = CAN_CH0_ID_Send10FF4117_Msg_Count;
        break;
    case CAN_CH0_ID_Send18FEAE17_Msg:
        u8Result = CAN_CH0_ID_Send18FEAE17_Msg_Count;
        break;
    case CAN_CH0_ID_Send10FF1017_Msg:
        u8Result = CAN_CH0_ID_Send10FF1017_Msg_Count;
        break;
    case CAN_CH0_ID_Send18FEC1EE_Msg:
        u8Result = CAN_CH0_ID_Send18FEC1EE_Msg_Count;
        break;
    case CAN_CH0_ID_Send0CFE6CEE_Msg:
        u8Result = CAN_CH0_ID_Send0CFE6CEE_Msg_Count;
        break;
    case CAN_CH0_ID_Send18FEFC17_Msg:
        u8Result = CAN_CH0_ID_Send18FEFC17_Msg_Count;
        break;
        
    case CAN_CH0_ID_WLCODE1_5_Msg:
        u8Result = CAN_CH0_ID_WLCODE1_5_Msg_Count;
        break;
    case CAN_CH0_ID_WLCODE6_10_Msg:
        u8Result = CAN_CH0_ID_WLCODE6_10_Msg_Count;
        break;
    case CAN_CH0_ID_WLCODE10_15Msg:
        u8Result = CAN_CH0_ID_WLCODE10_15Msg_Count;
        break;

    case CAN_CH0_ID_esp32_soft_Msg:
        u8Result = CAN_CH0_ID_esp32_soft_Msg_Count;
        break;
    case CAN_CH0_ID_gm_esp_ee_Msg:
        u8Result = CAN_CH0_ID_gm_esp_ee_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}
