#include "RTE_CAN.h"
#include "CAN_Lib.h"
#include "CAN_APP.h"
#include "CAN_Communication_Matrix.h"
#include "Analog_Signals.h"
#include "RSCAN.h"
#include "Check_Ctrl.h"
#include "Display_Info.h"
#include "RTE_GPIO.h"

#define CAN_ID_1 0x521
#define CAN_ID_2 0x522

CAN_Frame_st_t m_msg1;
CAN_Frame_st_t m_msg2;
CAN_Frame_st_t m_msg3;
CAN_Frame_st_t m_msg4;
CAN_Frame_st_t m_msg5;
CAN_Frame_st_t m_msg6;

uint8_t data1[8] = {0, 0, 0, 0, 0, 0, 0, 0};
uint8_t data2[8] = {0, 0, 0, 0, 0, 0, 0, 0};
uint8_t data3[8] = {0, 0, 0, 0, 0, 0, 0, 0};
uint8_t data4[8] = {0, 0, 0, 0, 0, 0, 0, 0};
uint8_t data5[8] = {0, 0, 0, 0, 0, 0, 0, 0};
uint8_t data6[8] = {0, 0, 0, 0, 0, 0, 0, 0};

typedef enum {
    CAN_REG_FAIL = 0,  // 未注册/注册失败
    CAN_REG_OK         // 已注册成功
} CAN_Register_Result_e;

static CAN_Register_Result_e g_canRegStatus = CAN_REG_FAIL;  // 注册状态全局变量

void init_CAN_Frame(CAN_Frame_st_t* msg, uint32_t can_id, uint8_t can_len, uint8_t can_frame_ide, const uint8_t* data)
{
    for (uint32_t i = 0; i < can_len; i++) {
        msg->unCANData.u8CANData[i] = 0;
    }

    msg->u32CANID = can_id;
    msg->u8CANLEN = can_len;
    msg->u8CANFrameIDE = can_frame_ide;
    for (uint32_t i = 0; i < can_len; i++)
    {
        msg->unCANData.u8CANData[i] = data[i];
    }
}

void can_mid(CAN_Frame_st_t Msg)
{
    CAN_Frame_st_t m_msg;

    init_CAN_Frame(&m_msg, Msg.u32CANID, Msg.u8CANLEN, Msg.u8CANFrameIDE, Msg.unCANData.u8CANData);

    RSCAN0_CH4_Set_FIFO0_Data(&m_msg);
}

CAN_Register_Result_e checkIfRegistered(void)
{
    return g_canRegStatus;
}

void CAN_Service(void)
{
    init_CAN_Frame(&m_msg1, CAN_ID_1, 8, 0, data1);
    init_CAN_Frame(&m_msg2, CAN_ID_2, 8, 0, data2);
    // init_CAN_Frame(&m_msg3, CAN_ID_1, 8, 0, data3);
    // init_CAN_Frame(&m_msg4, CAN_ID_1, 8, 0, data4);
    // init_CAN_Frame(&m_msg5, CAN_ID_1, 8, 0, data5);
    // init_CAN_Frame(&m_msg6, CAN_ID_1, 8, 0, data6);
    can_mid(m_msg1);
    can_mid(m_msg2);
}

void can_submit(void)
{
    switch (MENU_CHECK_STEP)
    {
        case  1:
            data1[1] = 0x00;        //水温

            data2[4] = 0x00;
            data2[5] = 0x00;
            break;
        case  2:
            data1[1] = 0x5A;

            data2[4] = 0xE8;
            data2[5] = 0x03;
            break;
        case  3:
            data1[1] = 0xAA;

            data2[4] = 0xE8;
            data2[5] = 0x03;
            break;
        case 4:
            data1[1] = 0xAA;

            data2[4] = 0xE8;
            data2[5] = 0x03;
            break;
        case 5:
            data1[1] = 0x00;

            data2[4] = 0x00;
            data2[5] = 0x00;
            break;
        case 6:
            data1[1] = 0x00;

            data2[4] = 0x00;
            data2[5] = 0x00;
            break;
        case 7:
            data1[1] = 0x00;

            data2[4] = 0x00;
            data2[5] = 0x00;
            break;
        case 8:
            data1[1] = 0x00;

            data2[4] = 0x00;
            data2[5] = 0x00;
            break;
        case 9:
            data1[1] = 0x00;

            data2[4] = 0x00;
            data2[5] = 0x00;
            break;
        case 10:
            data1[1] = 0x00;

            data2[4] = 0x00;
            data2[5] = 0x00;
            break;
        default:
            break;
    }
}
void UID_ADD(void)
{
    for(uint8_t i = 13; i > 1; i--)
    {
        if(UIDNumber2[i] < 9)
        {
            UIDNumber2[i] += 1;
            return;
        }
        else
        {
            UIDNumber2[i] = 0;
        }
    }
}
uint8_t u8get714msg[8];
uint8_t u8getSWmsg[8];
uint8_t u8getUIDmsg[8];
uint8_t SWtestresult = 0;
uint8_t HWtestresult = 0;
uint8_t PNtestresult = 0;
uint8_t ruanjianbanbenhao[8];
uint8_t yingjianbanbenhao[8];
uint8_t ruanjianbanbenhaoin[5];
uint8_t lingjianhao[21];
uint8_t UIDcode1[33];
uint8_t UIDcode2[33];
uint8_t zhenduanstep = 0;
void Get_SW_msg(void);
void Get_HW_msg(void);
void Get_PN_msg(void);
extern uint32_t send0x714time;
uint8_t begin714 = 0;
uint8_t UIDdelay;
uint8_t SWINtestresult;
void Send_UDS_fuc()
{

        CAN_Frame_st_t m_msg7;
    uint8_t data7[8] = {0, 0, 0, 0, 0, 0, 0, 0};

    if(MENU_CHECK_STEP != 0)
    {
        PNtestresult = 0;
    }
    switch (zhenduanstep)
    {
        case 0:
            if(UIDdelay < 10)
            {
                UIDdelay++;
            }
            else
            {
                data7[0] = 0x03;
                data7[1] = 0x22;
                data7[2] = 0xF1;
                data7[3] = 0x89;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x7A1, 8, 1, data7); 
                can_mid(m_msg7);
                zhenduanstep++;
            }
            
            break;
        case 1:
            data7[0] = 0x30;
            data7[1] = 0x00;
            data7[2] = 0x00;
            data7[3] = 0xAA;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7A1, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            SWtestresult = 1;
            Get_SW_msg();
            break;
        case 2:
            Get_SW_msg();
            zhenduanstep++;
        break;
        case 3:
            data7[0] = 0x03;
            data7[1] = 0x22;
            data7[2] = 0xF1;
            data7[3] = 0x93;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7A1, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            break;
        case 4:
            data7[0] = 0x30;
            data7[1] = 0x00;
            data7[2] = 0x00;
            data7[3] = 0xAA;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7A1, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            break;
        case 5:
            Get_HW_msg();
            zhenduanstep++;
            break;
        case 6:
            data7[0] = 0x03;
            data7[1] = 0x22;
            data7[2] = 0xF1;
            data7[3] = 0x8A;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7A1, 8, 1, data7); 
            can_mid(m_msg7);
            HWtestresult = 1;
            Get_HW_msg();
            zhenduanstep++;
            break;
        case 7:
            Get_PN_msg();
            data7[0] = 0x30;
            data7[1] = 0x00;
            data7[2] = 0x00;
            data7[3] = 0xAA;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7A1, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            Get_PN_msg();
            break;
        case 8:
            Get_PN_msg();
            data7[0] = 0x03;
            data7[1] = 0x22;
            data7[2] = 0x20;
            data7[3] = 0x24;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7A1, 8, 1, data7); 
            can_mid(m_msg7);
            SWINtestresult = 1;
            zhenduanstep++;
            break;
        case 9:
            Get_SWIN_msg();
            data7[0] = 0x30;
            data7[1] = 0x00;
            data7[2] = 0x00;
            data7[3] = 0xAA;
            data7[4] = 0xAA;
            data7[5] = 0xAA;
            data7[6] = 0xAA;
            data7[7] = 0xAA;
            init_CAN_Frame(&m_msg7, 0x7A1, 8, 1, data7); 
            can_mid(m_msg7);
            zhenduanstep++;
            Get_SWIN_msg();
            break;
        case 10:
            Get_SWIN_msg();
            zhenduanstep++;
            break;
        default:
        begin714 = 1;
        break;
    }
}
uint8_t readstep = 0;
void UIDRead(void)
{
    CAN_Frame_st_t m_msg9;
    uint8_t data9[8] = {0, 0, 0, 0, 0, 0, 0, 0};

    switch(readstep)
    {
        case 0:     //读取UID
        data9[0] = 0x03;
        data9[1] = 0x22;
        data9[2] = 0x50;
        data9[3] = 0x01;
        data9[4] = 0xAA;
        data9[5] = 0xAA;
        data9[6] = 0xAA;
        data9[7] = 0xAA;
        init_CAN_Frame(&m_msg9, 0x7A1, 8, 1, data9); 
        can_mid(m_msg9);
        readstep++;
        break;

        case 1:
        data9[0] = 0x30;
        data9[1] = 0x00;
        data9[2] = 0x00;
        data9[3] = 0xAA;
        data9[4] = 0xAA;
        data9[5] = 0xAA;
        data9[6] = 0xAA;
        data9[7] = 0xAA;
        init_CAN_Frame(&m_msg9, 0x7A1, 8, 1, data9); 
        can_mid(m_msg9);
        readstep++;
        break;

        default:
        readstep = 0;
        break;
    }
}
uint8_t UIDNumber[19] = {84,89,87,0,0,0,0,0,0,0,0,0,0,1,2,0,2,5,0xFF};
uint8_t UIDNumber2[15] = {0,5,2,2,0,0,0,0,0,0,0,0,0,0,0xFF};
uint8_t change = 13;
uint8_t writeflag = 0;
uint8_t UIDStep;
uint8_t seedresult[4] = {0};
void get_seed_msg(void);
uint8_t getseedresult = 0;
uint8_t waittime = 0;
void UIDWrite(void)
{
    CAN_Frame_st_t m_msg8;
    uint8_t data8[8] = {0, 0, 0, 0, 0, 0, 0, 0};

    if(UIDStep == 2)
    {
        waittime++;
        if(waittime > 3)
        {
            waittime = 0;
            UIDStep = 0;
        }
    }

    switch (UIDStep)
    {
        case 0:
            data8[0] = 0x02;
            data8[1] = 0x10;
            data8[2] = 0x03;
            data8[3] = 0xAA;
            data8[4] = 0xAA;
            data8[5] = 0xAA;
            data8[6] = 0xAA;
            data8[7] = 0xAA;
            init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
            can_mid(m_msg8);
            UIDStep++;
            break;
        case 1:
            data8[0] = 0x02;
            data8[1] = 0x27;
            data8[2] = 0x01;
            data8[3] = 0xAA;
            data8[4] = 0xAA;
            data8[5] = 0xAA;
            data8[6] = 0xAA;
            data8[7] = 0xAA;
            init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
            can_mid(m_msg8);
            UIDStep++;
            break;
        case 2:
            get_seed_msg();
            if(getseedresult == 1)
            {
                UIDStep++;
                getseedresult = 0;
            }
            break;
        case 3:
            waittime = 0;
            data8[0] = 0x06;
            data8[1] = 0x27;
            data8[2] = 0x02;
            data8[3] = seedresult[0];
            data8[4] = seedresult[1];
            data8[5] = seedresult[2];
            data8[6] = seedresult[3];
            data8[7] = 0xAA;
            init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
            can_mid(m_msg8);
            UIDStep++;
            break;
        case 4:
            data8[0] = 0x10;
            data8[1] = 0x23;
            data8[2] = 0x2E;
            data8[3] = 0x50;
            data8[4] = 0x01;
            data8[5] = 0x54;
            data8[6] = 0x59;
            data8[7] = 0x57;
            init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
            can_mid(m_msg8);
            UIDStep++;
            break;
        case 5:
            u8getUIDmsg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
            u8getUIDmsg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
            u8getUIDmsg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
            u8getUIDmsg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
            u8getUIDmsg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
            u8getUIDmsg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
            u8getUIDmsg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
            u8getUIDmsg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();
            if((u8getUIDmsg[0] == 0x30) && (u8getUIDmsg[2] == 0x14))
            {
                data8[0] = 0x21;
                data8[1] = 0x30;
                data8[2] = 0x30;
                data8[3] = 0x30;
                data8[4] = 0x30;
                data8[5] = 0x30;
                data8[6] = 0x30;
                data8[7] = 0x30;
                init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
                can_mid(m_msg8);
            }
            else
            {
                UIDStep = 0;
                writeflag = 0;
            }
            UIDStep++;
            break;
        case 6:
            data8[0] = 0x22;
            data8[1] = 0x30;
            data8[2] = 0x30;
            data8[3] = 0x30;
            data8[4] = 0x31;
            data8[5] = 0x32;
            data8[6] = 0x30;
            data8[7] = 0x32;
            init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
            can_mid(m_msg8);
            UIDStep++;
            break;
        case 7:
            data8[0] = 0x23;
            data8[1] = 0x35;
            data8[2] = 0x30 + UIDNumber2[0];
            data8[3] = 0x30 + UIDNumber2[1];
            data8[4] = 0x30 + UIDNumber2[2];
            data8[5] = 0x30 + UIDNumber2[3];
            data8[6] = 0x30 + UIDNumber2[4];
            data8[7] = 0x30 + UIDNumber2[5];
            init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
            can_mid(m_msg8);
            UIDStep++;
            break;
        case 8:
            data8[0] = 0x24;
            data8[1] = 0x30 + UIDNumber2[6];
            data8[2] = 0x30 + UIDNumber2[7];
            data8[3] = 0x30 + UIDNumber2[8];
            data8[4] = 0x30 + UIDNumber2[9];
            data8[5] = 0x30 + UIDNumber2[10];
            data8[6] = 0x30 + UIDNumber2[11];
            data8[7] = 0x30 + UIDNumber2[12];
            init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
            can_mid(m_msg8);
            UIDStep++;
            break;
        case 9:
            data8[0] = 0x25;
            data8[1] = 0x30 + UIDNumber2[13];
            data8[2] = 0xAA;
            data8[3] = 0xAA;
            data8[4] = 0xAA;
            data8[5] = 0xAA;
            data8[6] = 0xAA;
            data8[7] = 0xAA;
            init_CAN_Frame(&m_msg8, 0x7A1, 8, 1, data8); 
            can_mid(m_msg8);
            UID_ADD();
            UIDStep++;
            break;
        default:
            writeflag = 0;
            UIDStep = 0;
            writebeing = 1;
            UIDresult = 0;
            break;
    }
}
void Get_ID_0x794_Msg(void)
{

}

void Get_SW_msg(void)
{
    u8getSWmsg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
    u8getSWmsg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
    u8getSWmsg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
    u8getSWmsg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
    u8getSWmsg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
    u8getSWmsg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
    u8getSWmsg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
    u8getSWmsg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();

    if(u8getSWmsg[0] == 0x21)
    {
        ruanjianbanbenhao[0] = u8getSWmsg[1] / 10;
        ruanjianbanbenhao[1] = u8getSWmsg[1] % 10;
        ruanjianbanbenhao[2] = u8getSWmsg[2];
        ruanjianbanbenhao[3] =  u8getSWmsg[3] / 10;
        ruanjianbanbenhao[4] =  u8getSWmsg[3] % 10;
        ruanjianbanbenhao[5] = 0xFF;
        SWtestresult = 0;
        General_Number_Disp(ruanjianbanbenhao, 135, 50);  
    }
}

void Get_SWIN_msg(void)
{
    u8getSWmsg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
    u8getSWmsg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
    u8getSWmsg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
    u8getSWmsg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
    u8getSWmsg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
    u8getSWmsg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
    u8getSWmsg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
    u8getSWmsg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();

    if((u8getSWmsg[0] == 0x10) && (zhenduanstep == 9))
    {
        ruanjianbanbenhaoin[0] = u8getSWmsg[7];

    }
    else if(u8getSWmsg[0] == 0x21)
    {
        ruanjianbanbenhaoin[1] = u8getSWmsg[1];
        ruanjianbanbenhaoin[2] = u8getSWmsg[2];
        ruanjianbanbenhaoin[3] = u8getSWmsg[3];
        ruanjianbanbenhaoin[4] = 0xFF;
        General_Number_Disp(ruanjianbanbenhaoin, 135, 75);  
        SWINtestresult = 0;
    }
}

void Get_HW_msg(void)
{
    u8get714msg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
    u8get714msg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
    u8get714msg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
    u8get714msg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
    u8get714msg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
    u8get714msg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
    u8get714msg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
    u8get714msg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();
    if(u8get714msg[0] == 0x21)
    {
        memcpy(yingjianbanbenhao,&u8get714msg[1],7);
        yingjianbanbenhao[7] = 0xFF;
        HWtestresult = 0;
        General_Number_Disp(yingjianbanbenhao, 100, 100);  
    }
    
}
uint8_t PNresult = 0;
void Get_PN_msg(void)
{
    u8get714msg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
    u8get714msg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
    u8get714msg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
    u8get714msg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
    u8get714msg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
    u8get714msg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
    u8get714msg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
    u8get714msg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();
    if(u8get714msg[0] == 0x10 && u8get714msg[4] == 0x8A && PNresult == 0)
    {
        memset(lingjianhao,0xFF,sizeof(lingjianhao));
        // memcpy(&lingjianhao[0],&u8get714msg[5],3);
        lingjianhao[0] = u8get714msg[5];
        lingjianhao[1] = u8get714msg[6];
        lingjianhao[2] = u8get714msg[7];
        PNresult = 1;
    }
    else if(u8get714msg[0] == 0x21 && PNresult == 1)
    {
    //    memcpy(&lingjianhao[3],&u8get714msg[1],7);
       lingjianhao[3] = u8get714msg[1];
       lingjianhao[4] = u8get714msg[2];
       lingjianhao[5] = u8get714msg[3];
       lingjianhao[6] = u8get714msg[4];
       lingjianhao[7] = u8get714msg[5];
       lingjianhao[8] = u8get714msg[6];
       lingjianhao[9] = u8get714msg[7];
       PNresult = 2;
    }
    else if(u8get714msg[0] == 0x22 && PNresult == 2)
    {
        // memcpy(&lingjianhao[10],&u8get714msg[1],7);
        lingjianhao[10] = u8get714msg[1];
        lingjianhao[11] = u8get714msg[2];
        lingjianhao[12] = u8get714msg[3];
        lingjianhao[13] = u8get714msg[4];
        lingjianhao[14] = u8get714msg[5];
        lingjianhao[15] = u8get714msg[6];
        lingjianhao[16] = u8get714msg[7];
        // lingjianhao[16] = u8get714msg[7];
        PNtestresult = 1;
    }
}
uint8_t canlost;
uint8_t resettime = 0;
void uidreset(void)
{
    if(resettime > 50)
    {
        UIDresult = 0;
        resettime = 0;
        Display_TFT_Clear_UID2();
        canlost = 1;
    }
}
uint8_t writebeing = 1;
uint8_t UIDresult = 0;
uint8_t UIDcode1last[33];
void Get_UID_msg(void)
{
    u8get714msg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
    u8get714msg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
    u8get714msg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
    u8get714msg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
    u8get714msg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
    u8get714msg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
    u8get714msg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
    u8get714msg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();
    if((u8get714msg[0] == 0x10) && (u8get714msg[4] == 0x01) && (UIDresult == 0))
    {
        // memset(UIDcode1,0xFF,sizeof(UIDcode1));
        // memcpy(UIDcode1,&u8get714msg[1],32);
        UIDcode1[0] = u8get714msg[5];
        UIDcode1[1] = u8get714msg[6];
        UIDcode1[2] = u8get714msg[7];
        UIDresult = 1;
    }
    if((u8get714msg[0] == 0x21) && (UIDresult == 1))
    {
       UIDcode1[3] = u8get714msg[1];
       UIDcode1[4] = u8get714msg[2];
       UIDcode1[5] = u8get714msg[3];
       UIDcode1[6] = u8get714msg[4];
       UIDcode1[7] = u8get714msg[5];
       UIDcode1[8] = u8get714msg[6];
       UIDcode1[9] = u8get714msg[7];
       UIDresult = 2;
    }
    else if((u8get714msg[0] == 0x22) && (UIDresult == 2))
    {
        UIDcode1[10] = u8get714msg[1];
        UIDcode1[11] = u8get714msg[2];
        UIDcode1[12] = u8get714msg[3];
        UIDcode1[13] = u8get714msg[4];
        UIDcode1[14] = u8get714msg[5];
        UIDcode1[15] = u8get714msg[6];
        UIDcode1[16] = u8get714msg[7];
        UIDresult = 3;
    }
    else if((u8get714msg[0] == 0x23) && (UIDresult == 3))
    {
        UIDcode1[17] = u8get714msg[1];
        UIDcode1[18] = u8get714msg[2];
        UIDcode1[19] = u8get714msg[3];
        UIDcode1[20] = u8get714msg[4];
        UIDcode1[21] = u8get714msg[5];
        UIDcode1[22] = u8get714msg[6];
        UIDcode1[23] = u8get714msg[7];
        UIDresult = 4;
    }
    else if((u8get714msg[0] == 0x24) && (UIDresult == 4))
    {
        UIDcode1[24] = u8get714msg[1];
        UIDcode1[25] = u8get714msg[2];
        UIDcode1[26] = u8get714msg[3];
        UIDcode1[27] = u8get714msg[4];
        UIDcode1[28] = u8get714msg[5];
        UIDcode1[29] = u8get714msg[6];
        UIDcode1[30] = u8get714msg[7];
        UIDresult = 5;
    }
    else if((u8get714msg[0] == 0x25) && (UIDresult == 5))
    {
        UIDcode1[31] = u8get714msg[1];
        UIDcode1[32] = 0xFF;
        UIDresult = 0;
        resettime = 0;

        if(canlost == 0)
        {
            for(int i = 0;i<33;i++)
            {
                if(UIDcode1last[i] != UIDcode1[i])
                {
                    General_Number_Disp(UIDcode1, 95, 225);
                    shouuid();
                }
            }
        }
        else
        {
            General_Number_Disp(UIDcode1, 95, 225);
            shouuid();
            canlost = 0;
        }

        for(int i = 0;i<33;i++)
        {
           UIDcode1last[i] = UIDcode1[i];
        }
    }
}


uint32_t ValidSeedKey;
uint32_t GenerateKey(uint8_t *Seed)
{
    // const uint8_t Xor[4] = {0xAC, 0x89, 0x18, 0xF2};
    // uint8_t key_array[4], Cal[4];
    // uint32_t key_value;

    // for (size_t i = 0; i < 4; i++)
    // {
    //     Cal[i] = Seed[i] ^ Xor[i];
    // }

    // key_array[0] = ((Cal[2] & 0xF0) << 4) | (Cal[3] & 0xF0);
    // key_array[1] = ((Cal[3] & 0x2F) << 2) | (Cal[1] & 0x03);
    // key_array[2] = ((Cal[1] & 0xFC) >> 2) | (Cal[0] & 0xC0);
    // key_array[3] = ((Cal[0] & 0x0F) << 4) | (Cal[2] & 0x0F);

    // key_value = ((uint32_t)key_array[0] << 24U);
    // key_value = key_value | ((uint32_t)key_array[1] << 16U);
    // key_value = key_value | ((uint32_t)key_array[2] << 8U);
    // key_value = key_value | (uint32_t)key_array[3];

    // return (key_value);


    unsigned char i = 0u;
	unsigned char T1[4u] = { 0u };
	unsigned char T2[4u] = { 0u };
	unsigned char Xor[4u] = { 0u };
    unsigned char arr[4u] = { 0u };
	unsigned char KeyConst[4u] = { 0u };
	unsigned char KeyConst_L1[4u] = { 0xACu, 0x89u, 0x18u, 0xF2u };
    unsigned char iSeedArray[4u] = { 0u };
    for (i = 0u; i < 4u; i++)
	{
        iSeedArray[i] = Seed[i];
    }

	Xor[0u] = iSeedArray[2u];
	Xor[1u] = iSeedArray[3u];
	Xor[2u] = iSeedArray[0u];
	Xor[3u] = iSeedArray[1u];

	for (i = 0u; i < 4u; i++)
	{
		KeyConst[i] = KeyConst_L1[i];
	}

	for (i = 0u; i < 4u; i++)
	{
		T1[i] = iSeedArray[i] ^ KeyConst[i];
		T2[i] = Xor[i] ^ KeyConst[i];
		arr[i] = (T1[i] + T2[i]) & 0xFFu;
	}
    ValidSeedKey = ((uint32_t)arr[0u] <<24u) + ((uint32_t)arr[1u] << 16u) + ((uint32_t)arr[2u] << 8u) + ((uint32_t)arr[3u] );
    return ValidSeedKey;
}

// void CalculateKey(void)
// {
//     unsigned char i = 0u;
//     unsigned char T1[4u] = { 0u };
//     unsigned char T2[4u] = { 0u };
//     unsigned char Xor[4u] = { 0u };
//     unsigned char arr[4u] = { 0u };
//     unsigned char KeyConst[4u] = { 0u };
//     unsigned char KeyConst_L1[4u] = { 0xACu, 0x89u, 0x18u, 0xF2u };
//     unsigned char iSeedArray[4u] = { 0u };
//     for (i = 0u; i < 4u; i++)
//     {
//         iSeedArray[i] = Seed[i];
//     }

//     Xor[0u] = iSeedArray[2u];
//     Xor[1u] = iSeedArray[3u];
//     Xor[2u] = iSeedArray[0u];
//     Xor[3u] = iSeedArray[1u];

//     for (i = 0u; i < 4u; i++)
//     {
//         KeyConst[i] = KeyConst_L1[i];
//     }

//     for (i = 0u; i < 4u; i++)
//     {
//         T1[i] = iSeedArray[i] ^ KeyConst[i];
//         T2[i] = Xor[i] ^ KeyConst[i];
//         arr[i] = (T1[i] + T2[i]) & 0xFFu;
//     }
//     ValidSeedKey = ((uint32_t)arr[0u] <<24u) + ((uint32_t)arr[1u] << 16u) + ((uint32_t)arr[2u] << 8u) + ((uint32_t)arr[3u] );
//    
// }
uint8_t seednum[4] = {0};
uint8_t fuelreset1 = 0;
uint8_t fuelreset2 = 0;
uint8_t fuelreset3 = 0;
uint8_t fuelreset4 = 0;
uint32_t testseed;
void get_seed_msg(void)
{
    if(getseedresult == 1)
    {
        return ;
    }
    u8get714msg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
    u8get714msg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
    u8get714msg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
    u8get714msg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
    u8get714msg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
    u8get714msg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
    u8get714msg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
    u8get714msg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();
    if(u8get714msg[1] == 0x67 && u8get714msg[2] == 0x01)
    {
        memcpy(seednum,&u8get714msg[3],4);
        testseed = GenerateKey(seednum);
        seedresult[0] = (uint8_t)(testseed >> 24);
        seedresult[1] = (uint8_t)(testseed >> 16);
        seedresult[2] = (uint8_t)(testseed >> 8);
        seedresult[3] = (uint8_t)testseed ;
        getseedresult = 1;
        
    }
    // getseedresult = 1;
}