#include "common_include.h"
#include "api_can.h"



uint32_t SendCanMessage20msTimer;
uint32_t SendCanMessage100msTimer;
uint32_t SendCanMessage10msTimer;
uint32_t SendCanMessage50msTimer;
uint32_t SendCanMessage200msTimer;
uint32_t SendCanMessage500msTimer;
uint32_t SendCanMessage1000msTimer;
uint32_t SendCanMessage3000msTimer;
//extern uint8_t BDC_PE_ALL;
void Can_Clear(uint8_t *data)
{
    uint8_t i;
    for(i = 0;i < 8;i++)
    {
        data[i] = 0;
    }
}

uint8_t CAN_0x1DF = 0;
uint8_t CAN_0x1D4 = 0;
uint8_t CAN_0x1D5 = 0;

void CheckRecvCan1Frame(stc_canfd_msg_t *stc_msg)
{
    RECV_CAN_FRAME data;
    //recv
    data.ID = stc_msg->stcIdentifier.u32Identifier;
    data.DataLen = stc_msg->stcData.u8DataLengthCode > 8 ? 8 : stc_msg->stcData.u8DataLengthCode;
    memcpy((void*)data.Data, (void*)stc_msg->stcData.au32Data, data.DataLen);
    RecvCanFrame(&data);
    //recv end
    
	if(data.ID == 0x1DF)
	{
		CanFrameAnlysisFunc_0x1DF(data.Data);
		CAN_0x1DF = 1;
	}
    
    if (data.ID == 0x1D4) {
        CanFrameAnlysisFunc_0x1D4(data.Data);
		CAN_0x1D4 = 1;
	}
	if(data.ID == 0x1D5)
	{
		CAN_0x1D5 = 1;
	}
        
}
/*
static void Can1_Init(void)
{
    StartNM();
    ResetAllCanFrameTime();
}
*/
void SetCan1Mode(uint8_t n)
{
    if (n) {
        Port_SetPortPinLevel(1, 2, 1);   //stb
    } else {
        Port_SetPortPinLevel(1, 2, 0); //stb
    }
    if (n) {
        Port_SetPortPinLevel(1, 5, 1); //stb PortGpioHigh
    } else {
        Port_SetPortPinLevel(1, 5, 0); //stbPortGpioHigh
    }
}

void SetCan0Mode(uint8_t n)
{
  if (n) {
    Port_SetPortPinLevel(0, 29, PortGpioLow);
  } else {
    Port_SetPortPinLevel(0, 29, PortGpioHigh);
  }
}

void CANInit(void)
{
    InitCanRecvModule();
    memset(&CanFDDataStruct, 0, sizeof (CanFDDataStruct));
    memset(&MMCanDataStruct, 0, sizeof (MMCanDataStruct));
    bsp_CAN0_Init();
    bsp_CAN1_Init();
    SetCan0Mode(1);   
    SetCan1Mode(1);
}
extern volatile uint8_t  Auto_HW_flag;
//uint32_t SendCanMessage100msTimer;
uint8_t UDSSend;
uint8_t UDSSend_check;
void SendCan0Message(void)
{ 
    
    if ((Timer10msCnts > SendCanMessage10msTimer) && ((Timer10msCnts - SendCanMessage10msTimer) >= 10)) 
    {        
        //10ms 
        SendCanMessage10msTimer = Timer10msCnts; 
        //Stage_Manage();
        
        if(g_Stage == STAGE_PreWarning){
          //  LKA11.msg.bits.CF_HBA_Opt_USM = 0x01;
        }
        //if(g_Stage == STAGE_TelltaleAndSpeed)
        {
            APP_LED_OUTPUT();
            APP_SPEED_OUTPUT();
        }
        if(g_Stage == STAGE_Other)
        {
            switch(ElseCurrent.count)
            {
            case 0:
                TCU11.msg.bits.G_SEL_DISP = 0x0;
                break;
            case 1:
                TCU11.msg.bits.G_SEL_DISP = 0x4;
                break;
            case 2:
                TCU11.msg.bits.G_SEL_DISP = 0x5;
                break;
            case 3:
                TCU11.msg.bits.G_SEL_DISP = 0x6;
                break;
            case 4:
                TCU11.msg.bits.G_SEL_DISP = 0x7;
                break;
            default:
                break;
            }
        }
        if(g_Stage == STAGE_ClearODO)
        {
          //WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1B80;//
          WHL_SPD11.msg.bits.WHL_SPD_FL = 0x20A0;//260
          WHL_SPD11.msg.bits.WHL_SPD_RL = 0x20A0;//260
          
          //EMS11.msg.bits.N =0x7D00;//8000  
          CGW_PC4.msg.bits.N =0x7D00;//8000 閿燂拷???
          
          //TCU11.msg.bits.G_SEL_DISP = 0x4;
          CGW_PC5.msg.bits.G_SEL_DISP = 0x0;
         
        }
        
        if(g_Stage == STAGE_WaterAndFuil)
        {
          if(BDC_PE_ALL == 2)
          {switch(Iol_TempCurrent.count)
          {
          case 1:
            EMS12.msg.bits.TEMP_ENG = 140 ;   //62.25        SEG4 ???
            break;
          case 2:
            EMS12.msg.bits.TEMP_ENG = 212 ;   //70.5           SEG7  ???
            break;
          case 3:
            EMS12.msg.bits.TEMP_ENG = 220 ;   //116.25     SEG12  ????
            break;
          case 4:
            EMS12.msg.bits.TEMP_ENG = 0xE1 ;   //120.75       SEG15  ????
            break;
          default:
            break;
          }
          }
          if(BDC_PE_ALL == 1)
          {
            switch(Iol_TempCurrent.count)
          {
           case 1:
            EMS12.msg.bits.TEMP_ENG = 0x8E ;   //62.25        SEG4 ???
            break;
          case 2:
            EMS12.msg.bits.TEMP_ENG = 0xD5 ;   //70.5           SEG7  ???
            break;
          case 3:
            EMS12.msg.bits.TEMP_ENG = 0xDB ;   //116.25     SEG12  ????
            break;
          case 4:
            EMS12.msg.bits.TEMP_ENG = 0xE1 ;   //120.75       SEG15  ????
            break;
          default:
            break;
          }
          }
          
        }
        if(Iol_TempCurrent.count != 0)
          {
            switch(Iol_TempCurrent.count)
          {

           case 1:
            
            ECU_Engine_Data_M2.msg.bits.ECU_Temperature_Water = 0x90;   //69        SEG1 ???
            //_OIL2_out(PortGpioLow);
            //_OIL1_out(PortGpioHigh);
            
            break;
          case 2:
            ECU_Engine_Data_M2.msg.bits.ECU_Temperature_Water = 0xb7 ;   //87           SEG2  ???
            //_OIL3_out(PortGpioLow);
            //_OIL1_out(PortGpioLow);
            //_OIL2_out(PortGpioHigh);
            break;
          case 3:
            ECU_Engine_Data_M2.msg.bits.ECU_Temperature_Water = 0xc7 ;   //99     SEG3  ????
            //_OIL4_out(PortGpioLow);
            //_OIL2_out(PortGpioLow);
            //_OIL3_out(PortGpioHigh);
            break;
          case 4:
            ECU_Engine_Data_M2.msg.bits.ECU_Temperature_Water = 0xd4 ;   //109       SEG4  ????
            //_OIL3_out(PortGpioLow);
            //_OIL4_out(PortGpioHigh);
          case 5:
            ECU_Engine_Data_M2.msg.bits.ECU_Temperature_Water = 0xd8 ;   //114       SEG5  ????
            break;
           case 6:
            ECU_Engine_Data_M2.msg.bits.ECU_Temperature_Water = 0xe4 ;   //123       SEG6  ????
            break;
          default:
            break;
          }
          }
        
      //  CanFD_Send_StandMsg(CANFD0_Type, 0x10, BUF_1, TX_ISR_EN, (uint8_t*)&ACU13.msg.data, 8);
      //  Can_Clear((uint8_t*)&ACU13.msg.data);
      //  CanFD_Send_StandMsg(CANFD0_Type, 0x113, BUF_2, TX_ISR_EN, (uint8_t*)&TCU13.msg.data, 8);
      //  Can_Clear((uint8_t*)&TCU13.msg.data);
        
        
//        CanFD_Send_StandMsg(CANFD0_Type, 0x356, BUF_3, TX_ISR_EN, (uint8_t*)&CGW_PC8.msg.data, 8);
//        Can_Clear((uint8_t*)&CGW_PC8.msg.data);
        
       // CanFD_Send_StandMsg(CANFD0_Type, 0x111, BUF_3, TX_ISR_EN, (uint8_t*)&TCU11.msg.data, 8);
       // Can_Clear((uint8_t*)&TCU11.msg.data);
       // CanFD_Send_StandMsg(CANFD0_Type, 0x125, BUF_45, TX_ISR_EN, (uint8_t*)&TCS_125.msg.data, 8);
       // Can_Clear((uint8_t*)&TCS_125.msg.data);
       // CanFD_Send_StandMsg(CANFD0_Type, 0x402, BUF_46, TX_ISR_EN, (uint8_t*)&ECU_402.msg.data, 8);
       // Can_Clear((uint8_t*)&ECU_402.msg.data);
       // CanFD_Send_StandMsg(CANFD0_Type, 0x101, BUF_47, TX_ISR_EN, (uint8_t*)&ECU_101.msg.data, 8);
       // Can_Clear((uint8_t*)&ECU_101.msg.data);
       // CanFD_Send_StandMsg(CANFD0_Type, 0x401, BUF_48, TX_ISR_EN, (uint8_t*)&ECU_401.msg.data, 8);
       // Can_Clear((uint8_t*)&ECU_401.msg.data);
       // CanFD_Send_StandMsg(CANFD0_Type, 0x341, BUF_49, TX_ISR_EN, (uint8_t*)&QS_341.msg.data, 8);
       // Can_Clear((uint8_t*)&QS_341.msg.data);
       // CanFD_Send_StandMsg(CANFD0_Type, 0x55E, BUF_4, TX_ISR_EN, (uint8_t*)&TBOX.msg.data, 8);
       // Can_Clear((uint8_t*)&TBOX.msg.data);
        
        
        CanFD_Send_StandMsg(CANFD0_Type, 0x18200A21, BUF_4, TX_ISR_EN, (uint8_t*)&SOC2.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);
        CanFD_Send_StandMsg(CANFD0_Type, 0x18200A20, BUF_4, TX_ISR_EN, (uint8_t*)&SOC1.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);
        CanFD_Send_StandMsg(CANFD0_Type, 0x125, BUF_4, TX_ISR_EN, (uint8_t*)&CAN125.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);
        CanFD_Send_StandMsg(CANFD0_Type, 0x157, BUF_4, TX_ISR_EN, (uint8_t*)&CAN157.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);
        CanFD_Send_StandMsg(CANFD0_Type, 0x38E, BUF_4, TX_ISR_EN, (uint8_t*)&CAN38E.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);
        CanFD_Send_StandMsg(CANFD0_Type, 0x339, BUF_4, TX_ISR_EN, (uint8_t*)&CAN339.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);
        CanFD_Send_StandMsg(CANFD0_Type, 0x18202922, BUF_4, TX_ISR_EN, (uint8_t*)&CAN18202922.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);
        CanFD_Send_StandMsg(CANFD0_Type, 0x18203220, BUF_4, TX_ISR_EN, (uint8_t*)&CAN18203220.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);
        CanFD_Send_StandMsg(CANFD0_Type, 0x18203020, BUF_4, TX_ISR_EN, (uint8_t*)&CAN18203020.msg.data, 8);
        Can_Clear((uint8_t*)&TBOX.msg.data);



//        CanFD_Send_StandMsg(CANFD0_Type, 0x2b0, BUF_5, TX_ISR_EN, (uint8_t*)&SAS11.msg.data, 8);
//        Can_Clear((uint8_t*)&SAS11.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x340, BUF_6, TX_ISR_EN, (uint8_t*)&LKA11.msg.data, 8);
//        Can_Clear((uint8_t*)&LKA11.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x153, BUF_7, TX_ISR_EN, (uint8_t*)&TCS11.msg.data, 8);
//        Can_Clear((uint8_t*)&TCS11.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x220, BUF_8, TX_ISR_EN, (uint8_t*)&ESP12.msg.data, 8);
//        Can_Clear((uint8_t*)&ESP12.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x1bf, BUF_9, TX_ISR_EN, (uint8_t*)&EMS_H11.msg.data, 8);
//        Can_Clear((uint8_t*)&EMS_H11.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x18f, BUF_10, TX_ISR_EN, (uint8_t*)&EMS_H12.msg.data, 8);
//        Can_Clear((uint8_t*)&EMS_H12.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x200, BUF_11, TX_ISR_EN, (uint8_t*)&EMS20.msg.data, 8);
//        Can_Clear((uint8_t*)&EMS20.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x329, BUF_12, TX_ISR_EN, (uint8_t*)&EMS12.msg.data, 8);
//        Can_Clear((uint8_t*)&EMS12.msg.data);
        
//        CanFD_Send_StandMsg(CANFD0_Type, 0x553, BUF_29, TX_ISR_EN, (uint8_t*)&CGW2.msg.data,  8);
//        Can_Clear((uint8_t*)&CGW2.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x541, BUF_28, TX_ISR_EN, (uint8_t*)&CGW1.msg.data,  8);
//        Can_Clear((uint8_t*)&CGW1.msg.data); 
//        CGW2.msg.bits.CF_Gway_SJBDeliveryMode = 0x1;
       
//        CanFD_Send_StandMsg(CANFD0_Type, 0x4C9, BUF_27, TX_ISR_EN, (uint8_t*)&CGW_PC12.msg.data, 8);
//        Can_Clear((uint8_t*)&CGW_PC12.msg.data);
        
        /* YC 閿燂拷?閿熸枻鎷�
        CanFD_Send_StandMsg(CANFD0_Type, 0x316, BUF_11, TX_ISR_EN, (uint8_t*)&EMS11.msg.data, 8);
        Can_Clear((uint8_t*)&EMS11.msg.data);
        */
//        CanFD_Send_StandMsg(CANFD0_Type, 0x366, BUF_24, TX_ISR_EN, (uint8_t*)&CGW_PC4.msg.data, 8);
//        Can_Clear((uint8_t*)&CGW_PC4.msg.data); 
        if(LedCurrent.count == 20|| LedCurrent.count == 34)
        {
            ACU14.msg.bits.CF_SWL_Ind = 0x0;                    //Airbag閿熸枻鎷峰叏閿熸枻鎷烽敓鎻鎷�
        }
        else
        {
            ACU14.msg.bits.CF_SWL_Ind = 0x1;
        }
        if(LedCurrent.count != 11|| LedCurrent.count != 12|| LedCurrent.count != 13|| LedCurrent.count != 34)
        {
            CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x3;              //ISG鐔勯敓鏂ゆ嫹
        }   
    }
    
    if ((Timer10msCnts > SendCanMessage20msTimer) && ((Timer10msCnts - SendCanMessage20msTimer) >= 20)) 
    {
        //20ms
        SendCanMessage20msTimer = Timer10msCnts; 
//        CanFD_Send_StandMsg(CANFD0_Type, 0x470, BUF_21, TX_ISR_EN, (uint8_t*)&P_STS.msg.data, 8);
//        Can_Clear((uint8_t*)&P_STS.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x381, BUF_14, TX_ISR_EN, (uint8_t*)&MDPS11.msg.data, 8);
//        Can_Clear((uint8_t*)&MDPS11.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x38d, BUF_15, TX_ISR_EN, (uint8_t*)&FCA11.msg.data, 8);
//        Can_Clear((uint8_t*)&FCA11.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x492, BUF_16, TX_ISR_EN, (uint8_t*)&EMS19.msg.data, 8);
//        Can_Clear((uint8_t*)&EMS19.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x386, BUF_17, TX_ISR_EN, (uint8_t*)&WHL_SPD11.msg.data, 8);
        //Can_Clear((uint8_t*)&WHL_SPD11.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x38a, BUF_18, TX_ISR_EN, (uint8_t*)&ABS11.msg.data, 8);
//        Can_Clear((uint8_t*)&ABS11.msg.data);
        
//        CanFD_Send_StandMsg(CANFD0_Type, 0x420, BUF_19, TX_ISR_EN, (uint8_t*)&SCC11.msg.data, 8);
//        Can_Clear((uint8_t*)&SCC11.msg.data);    
//        CanFD_Send_StandMsg(CANFD0_Type, 0x421, BUF_20, TX_ISR_EN, (uint8_t*)&SCC12.msg.data, 8);
//        Can_Clear((uint8_t*)&SCC12.msg.data);   
//        CanFD_Send_StandMsg(CANFD0_Type, 0x389, BUF_21, TX_ISR_EN, (uint8_t*)&SCC14.msg.data, 8);
//        Can_Clear((uint8_t*)&SCC14.msg.data); 
//        CanFD_Send_StandMsg(CANFD0_Type, 0x507, BUF_34, TX_ISR_EN, (uint8_t*)&TCS15.msg.data, 8);
//        Can_Clear((uint8_t*)&TCS15.msg.data);
        
        //anFD_Send_StandMsg(CANFD0_Type, 0x12B, BUF_35, TX_ISR_EN, (uint8_t*)&ECU_12B.msg.data, 8);
        //an_Clear((uint8_t*)&ECU_12B.msg.data);
        //    
      
        //CanFD_Send_StandMsg(CANFD0_Type, 0x240, BUF_38, TX_ISR_EN, (uint8_t*)&ECU_Engine_Data_M2.msg.data, 8);
        //Can_Clear((uint8_t*)&ECU_Engine_Data_M2.msg.data);
        //ECU_Engine_Data_M2.msg.bits.ECU_Temperature_Water = 0x99;
        
//        ECU_Engine_Data_M2.msg.bits.Byte0Data=0xb;
//        ECU_Engine_Data_M2.msg.bits.Byte1Data=0x16;
//        ECU_Engine_Data_M2.msg.bits.Byte2Data=0x21;
//        ECU_Engine_Data_M2.msg.bits.Byte3Data=0x2c;
//        ECU_Engine_Data_M2.msg.bits.Byte4Data=0x37;
//        ECU_Engine_Data_M2.msg.bits.Byte5Data=0x42;
//        ECU_Engine_Data_M2.msg.bits.Byte6Data=0x4d;
//        ECU_Engine_Data_M2.msg.bits.Byte7Data=0x58;
        
        if(LedCurrent.count == 29)
        {
            //CanFD_Send_StandMsg(CANFD0_Type, 0x453, BUF_23, TX_ISR_EN, (uint8_t*)&CGW_PC1.msg.data, 8);
            //Can_Clear((uint8_t*)&CGW_PC1.msg.data); 
        }
//        CanFD_Send_StandMsg(CANFD0_Type, 0x568, BUF_26, TX_ISR_EN, (uint8_t*)&CGW_PC2.msg.data,  8);
//        Can_Clear((uint8_t*)&CGW_PC2.msg.data);
        
    }
    if ((Timer10msCnts > SendCanMessage50msTimer) && ((Timer10msCnts - SendCanMessage50msTimer) >= 50)) 
    {
      // 50ms
        SendCanMessage50msTimer = Timer10msCnts;
      /*DN8C*/  
                
                
//                CanFD_Send_StandMsg(CANFD0_Type, 0x424, BUF_20, TX_ISR_EN, (uint8_t*)&HU_BLE_PE_00, 8);
//        Can_Clear((uint8_t*)&HU_BLE_PE_00);
//         CanFD_Send_StandMsg(CANFD0_Type, 0x58B, BUF_22, TX_ISR_EN, (uint8_t*)&BCW11.msg.data, 8);
//         Can_Clear((uint8_t*)&BCW11.msg.data); 
//         BCW11.msg.bits.CF_BCW_Stat=0x1;//鍙栭敓鏂ゆ嫹鐩查敓濮愭姤閿熸枻鎷�
//         CanFD_Send_StandMsg(CANFD0_Type, 0x48A, BUF_2, TX_ISR_EN, (uint8_t*)&BCA11, 8);
//         Can_Clear((uint8_t*)&BCA11); 
//         CanFD_Send_StandMsg(CANFD0_Type, 0x490, BUF_23, TX_ISR_EN, (uint8_t*)&EPB11.msg.data, 8);
//         Can_Clear((uint8_t*)&EPB11.msg.data); 
//         CanFD_Send_StandMsg(CANFD0_Type, 0x485, BUF_24, TX_ISR_EN, (uint8_t*)&HDA11.msg.data, 8);
//         Can_Clear((uint8_t*)&HDA11.msg.data); 
//         CanFD_Send_StandMsg(CANFD0_Type, 0x436, BUF_25, TX_ISR_EN, (uint8_t*)&PAS11.msg.data, 8);
//         Can_Clear((uint8_t*)&PAS11.msg.data); 
//         CanFD_Send_StandMsg(CANFD0_Type, 0x53e, BUF_33, TX_ISR_EN, (uint8_t*)&LKA12.msg.data, 8);
//         Can_Clear((uint8_t*)&LKA12.msg.data);
//         CanFD_Send_StandMsg(CANFD0_Type, 0x593, BUF_21, TX_ISR_EN, (uint8_t*)&TPMS11.msg.data, 8);
//        Can_Clear((uint8_t*)&TPMS11.msg.data);
         
    }
    if ((Timer10msCnts > SendCanMessage100msTimer) && ((Timer10msCnts - SendCanMessage100msTimer) >= 98)) 
    {
        SendCanMessage100msTimer = Timer10msCnts;
        

//        CanFD_Send_StandMsg(CANFD0_Type, 0x586, BUF_27, TX_ISR_EN, (uint8_t*)&EVP11.m_aucData,  8);
//        Can_Clear((uint8_t*)&EVP11.m_aucData);
        /*DN8C*/

//        CanFD_Send_StandMsg(CANFD0_Type, 0x001, BUF_18, TX_ISR_EN, (uint8_t*)&Send_500.msg.data,  8);//test mode 閿熸枻鎷疯壊
//        Can_Clear((uint8_t*)&Send_500.msg.data); 
        

        //CanFD_Send_StandMsg(CANFD0_Type, 0x470, BUF_30, TX_ISR_EN, (uint8_t*)&CGW2.msg.data,  8);
        if(LedCurrent.count == 1){
        //CanFD_Send_StandMsg(CANFD0_Type, 0x453, BUF_37, TX_ISR_EN, (uint8_t*)&CGW_PC1.msg.data,  8);
        //Can_Clear((uint8_t*)&CGW_PC1);
        }
        else{}
//        CanFD_Send_StandMsg(CANFD0_Type, 0x240, BUF_20, TX_ISR_EN, (uint8_t*)&CGW_PC11.m_aucData,  8);
//        Can_Clear((uint8_t*)&CGW_PC11);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x502, BUF_32, TX_ISR_EN, (uint8_t*)&TCU14.msg.data, 8);
//        Can_Clear((uint8_t*)&TCU14.msg.data);
        //        CanFD_Send_StandMsg(CANFD0_Type, 0x507, BUF_34, TX_ISR_EN, (uint8_t*)&TCS15.msg.data, 8);
        //        Can_Clear((uint8_t*)&TCS15.msg.data);
//        CanFD_Send_StandMsg(CANFD0_Type, 0x545, BUF_35, TX_ISR_EN, (uint8_t*)&EMS14.msg.data, 8);
//        Can_Clear((uint8_t*)&EMS14.msg.data);
        //CanFD_Send_StandMsg(CANFD0_Type, 0x500, BUF_36, TX_ISR_EN, (uint8_t*)&ACU14.msg.data, 8);
        //Can_Clear((uint8_t*)&ACU14.msg.data);
//
//
        //
        //CanFD_Send_StandMsg(CANFD1_Type, 0x069, BUF_4, TX_ISR_EN, (uint8_t*)&HU_USM_E_05.m_aucData,  8);
        //CanFD_Send_StandMsg(CANFD1_Type, 0x068, BUF_1, TX_ISR_EN, (uint8_t*)&HU_USM_E_04.m_aucData,  8);
        //CanFD_Send_StandMsg(CANFD1_Type, 0x065, BUF_2, TX_ISR_EN, (uint8_t*)&HU_USM_E_01.m_aucData,  8);
        //CanFD_Send_StandMsg(CANFD1_Type, 0x122, BUF_3, TX_ISR_EN, (uint8_t*)&HU_CLU_PE_06.m_aucData,  8);
        
    }
    if ((Timer10msCnts > SendCanMessage200msTimer) && ((Timer10msCnts - SendCanMessage200msTimer) >= 190)) 
    {
       // 200ms
       SendCanMessage200msTimer = Timer10msCnts;
       
       /*DN8C*/

       
//       CanFD_Send_StandMsg(CANFD0_Type, 0x50E, BUF_15, TX_ISR_EN, (uint8_t*)&CGW6, 8);
//       Can_Clear((uint8_t*)&CGW6);
       
//       CanFD_Send_StandMsg(CANFD0_Type, 0x572, BUF_1, TX_ISR_EN, (uint8_t*)&CGW_PC3, 8);
//       Can_Clear((uint8_t*)&CGW_PC3);
       
       //CanFD_Send_StandMsg(CANFD1_Type, 0x115, BUF_22, TX_ISR_EN, (uint8_t*)&HU_CLU_PE_02, 8);
       Can_Clear((uint8_t*)&HU_CLU_PE_02);
       

       
//       CanFD_Send_StandMsg(CANFD0_Type, 0x07f, BUF_3, TX_ISR_EN, (uint8_t*)&CGW5.msg.data, 8);
//       Can_Clear((uint8_t*)&CGW5.msg.data); 
       //CanFD_Send_StandMsg(CANFD1_Type, 0x197, BUF_4, TX_ISR_EN, (uint8_t*)&HU_CLU_PE_05, 8);
       Can_Clear((uint8_t*)&HU_CLU_PE_05);
       
      
       
//       CanFD_Send_StandMsg(CANFD1_Type, 0x113, BUF_5, TX_ISR_EN, (uint8_t*)&SMKmsg20.msg.data, 8);
//       Can_Clear((uint8_t*)&SMKmsg20.msg.data);
       //CanFD_Send_StandMsg(CANFD1_Type, 0x112, BUF_6, TX_ISR_EN, (uint8_t*)&SMKmsg19.msg.data, 8);
       Can_Clear((uint8_t*)&SMKmsg19.msg.data);
//       CanFD_Send_StandMsg(CANFD1_Type, 0x111, BUF_7, TX_ISR_EN, (uint8_t*)&ISG_111.msg.data, 8);
//       Can_Clear((uint8_t*)&ISG_111.msg.data);
       //CanFD_Send_StandMsg(CANFD1_Type, 0x110, BUF_8, TX_ISR_EN, (uint8_t*)&SMKmsg17.msg.data, 8);
       Can_Clear((uint8_t*)&SMKmsg17.msg.data);
//       CanFD_Send_StandMsg(CANFD1_Type, 0x10,  BUF_9, TX_ISR_EN, (uint8_t*)&SMKmsg01.msg.data, 8);
//       Can_Clear((uint8_t*)&SMKmsg01.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x107, BUF_10, TX_ISR_EN, (uint8_t*)&BCMmsg24.msg.data, 8);
      //  Can_Clear((uint8_t*)&BCMmsg24.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x105, BUF_11, TX_ISR_EN, (uint8_t*)&BCMmsg22.msg.data, 8);
      //  Can_Clear((uint8_t*)&BCMmsg22.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x19B, BUF_12, TX_ISR_EN, (uint8_t*)&WPCmsg03.msg.data, 8);
      //  Can_Clear((uint8_t*)&WPCmsg03.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x104, BUF_13, TX_ISR_EN, (uint8_t*)&BCMmsg21.msg.data, 8);
      //  Can_Clear((uint8_t*)&BCMmsg21.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x103, BUF_14, TX_ISR_EN, (uint8_t*)&BCMmsg20.msg.data, 8);
      //  Can_Clear((uint8_t*)&BCMmsg20.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x102, BUF_15, TX_ISR_EN, (uint8_t*)&BCMmsg19.msg.data, 8);
      //  Can_Clear((uint8_t*)&BCMmsg19.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x101, BUF_16, TX_ISR_EN, (uint8_t*)&BCMmsg18.msg.data, 8);
      //  Can_Clear((uint8_t*)&BCMmsg18.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x100, BUF_17, TX_ISR_EN, (uint8_t*)&BCMmsg17.msg.data, 8);
      //  Can_Clear((uint8_t*)&BCMmsg17.msg.data);
      //  //CanFD_Send_StandMsg(CANFD1_Type, 0x0, BUF_23, TX_ISR_EN, (uint8_t*)&BCMmsg01.msg.data, 8);
      //  //Can_Clear((uint8_t*)&BCMmsg01.msg.data);
      //  CanFD_Send_StandMsg(CANFD1_Type, 0x720, BUF_18, TX_ISR_EN, (uint8_t*)&BCMGst.msg.data, 8);
      //  Can_Clear((uint8_t*)&BCMGst.msg.data);
//       CanFD_Send_StandMsg(CANFD0_Type, 0x483, BUF_19, TX_ISR_EN, (uint8_t*)&FCA12.msg.data, 8);
//       Can_Clear((uint8_t*)&FCA12.msg.data);
       
//       CanFD_Send_StandMsg(CANFD0_Type, 0x4CB, BUF_21, TX_ISR_EN, (uint8_t*)&CGW7.msg.data, 8);
//       Can_Clear((uint8_t*)&CGW7.msg.data);

       
    }
    if ((Timer10msCnts > SendCanMessage500msTimer) && ((Timer10msCnts - SendCanMessage500msTimer) >= 500)) 
    {
      // 500ms
      SendCanMessage500msTimer = Timer10msCnts;
      
    }
    if ((Timer10msCnts > SendCanMessage1000msTimer) && ((Timer10msCnts - SendCanMessage1000msTimer) >= 1000)) 
    {
      // 1000ms
      SendCanMessage1000msTimer = Timer10msCnts;
      /*DN8C*/
     
      
      //CanFD_Send_StandMsg(CANFD1_Type, 0x100, BUF_22, TX_ISR_EN, (uint8_t*)&HU_MON_PE_01.m_aucData, 8);
      Can_Clear((uint8_t*)&HU_MON_PE_01);
      //CanFD_Send_StandMsg(CANFD1_Type, 0x509, BUF_25, TX_ISR_EN, (uint8_t*)&HU_CLU_P_03.m_aucData, 8);
      Can_Clear((uint8_t*)&HU_CLU_P_03);

      
//      CanFD_Send_StandMsg(CANFD0_Type, 0x43, BUF_23, TX_ISR_EN, (uint8_t*)&DATC13.msg.data, 8);
//      Can_Clear((uint8_t*)&DATC13.msg.data);
//      CanFD_Send_StandMsg(CANFD0_Type, 0x44, BUF_24, TX_ISR_EN, (uint8_t*)&DATC11.msg.data, 8);
//      Can_Clear((uint8_t*)&DATC11.msg.data);
     // CanFD_Send_StandMsg(CANFD1_Type, 0x197, BUF_25, TX_ISR_EN, (uint8_t*)&HU_CLU_PE_05.m_aucData[0], 8);
	  
    }
//    if(UDSSend == ON)
//    {
//        UDSSend = FINISH;
//        CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_26, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
//    }
    

}
void SendCan0Message_7DF(void)
{
//    if ((Timer10msCnts > SendCanMessage3000msTimer) && ((Timer10msCnts - SendCanMessage3000msTimer) >= 3000)) 
//    {
//      // 1000ms
//      SendCanMessage3000msTimer = Timer10msCnts;
//      Send_7DF_Data.msg.bits.Byte0Data = 0x02;
//      Send_7DF_Data.msg.bits.Byte1Data = 0x3E;   
//      Send_7DF_Data.msg.bits.Byte1Data = 0x80; 
//      CanFD_Send_StandMsg(CANFD0_Type, 0x7DF, BUF_27, TX_ISR_EN, (uint8_t*)&Send_7DF_Data.msg.data, 3);
//    }
}
void SendCan0Message_7DF_ectype(void)
{
//    if ((Timer10msCnts > SendCanMessage10msTimer) && ((Timer10msCnts - SendCanMessage10msTimer) >= 10)) 
//    {
//        // 10ms
//        SendCanMessage10msTimer = Timer10msCnts; 
//        Send_7DF_ectype_Data.msg.bits.Byte0Data = 0xfd;
//        CanFD_Send_StandMsg(CANFD0_Type, 0x7DF, BUF_20, TX_ISR_EN, (uint8_t*)&Send_7DF_ectype_Data.msg.data, 1);
//    }
}

void SendCan0Message_7DF_color(void)
{
//    if ((Timer10msCnts > SendCanMessage10msTimer) && ((Timer10msCnts - SendCanMessage10msTimer) >= 10)) 
//    {
//        // 10ms
//        SendCanMessage10msTimer = Timer10msCnts; 
//        Send_7DF_ectype_Data.msg.bits.Byte0Data = 0xfb;
//        CanFD_Send_StandMsg(CANFD0_Type, 0x7DF, BUF_20, TX_ISR_EN, (uint8_t*)&Send_7DF_ectype_Data.msg.data, 1);
//    }
}

