/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_BT_PWC_H
#define __S6J3360_BT_PWC_H

#include "s6j3360io_basetypes.h"

/* BT[00-31]_PWC base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define BT00_PWC	stcBT_PWC[0]
#define BT01_PWC	stcBT_PWC[1]
#define BT02_PWC	stcBT_PWC[2]
#define BT03_PWC	stcBT_PWC[3]
#define BT04_PWC	stcBT_PWC[4]
#define BT05_PWC	stcBT_PWC[5]
#define BT06_PWC	stcBT_PWC[6]
#define BT07_PWC	stcBT_PWC[7]
#define BT08_PWC	stcBT_PWC[8]
#define BT09_PWC	stcBT_PWC[9]
#define BT10_PWC	stcBT_PWC[10]
#define BT11_PWC	stcBT_PWC[11]
#define BT12_PWC	stcBT_PWC[12]
#define BT13_PWC	stcBT_PWC[13]
#define BT14_PWC	stcBT_PWC[14]
#define BT15_PWC	stcBT_PWC[15]
#define BT16_PWC	stcBT_PWC[16]
#define BT17_PWC	stcBT_PWC[17]
#define BT18_PWC	stcBT_PWC[18]
#define BT19_PWC	stcBT_PWC[19]
#define BT20_PWC	stcBT_PWC[20]
#define BT21_PWC	stcBT_PWC[21]
#define BT22_PWC	stcBT_PWC[22]
#define BT23_PWC	stcBT_PWC[23]
#define BT24_PWC	stcBT_PWC[24]
#define BT25_PWC	stcBT_PWC[25]
#define BT26_PWC	stcBT_PWC[26]
#define BT27_PWC	stcBT_PWC[27]
#define BT28_PWC	stcBT_PWC[28]
#define BT29_PWC	stcBT_PWC[29]
#define BT30_PWC	stcBT_PWC[30]
#define BT31_PWC	stcBT_PWC[31]
#else /* __IO_DEFINE */
#define BT00_PWC	(*((volatile stc_btn_pwc_t*)0xB4808000))
#define BT01_PWC	(*((volatile stc_btn_pwc_t*)0xB4808400))
#define BT02_PWC	(*((volatile stc_btn_pwc_t*)0xB4808800))
#define BT03_PWC	(*((volatile stc_btn_pwc_t*)0xB4808C00))
#define BT04_PWC	(*((volatile stc_btn_pwc_t*)0xB4809000))
#define BT05_PWC	(*((volatile stc_btn_pwc_t*)0xB4809400))
#define BT06_PWC	(*((volatile stc_btn_pwc_t*)0xB4809800))
#define BT07_PWC	(*((volatile stc_btn_pwc_t*)0xB4809C00))
#define BT08_PWC	(*((volatile stc_btn_pwc_t*)0xB480A000))
#define BT09_PWC	(*((volatile stc_btn_pwc_t*)0xB480A400))
#define BT10_PWC	(*((volatile stc_btn_pwc_t*)0xB480A800))
#define BT11_PWC	(*((volatile stc_btn_pwc_t*)0xB480AC00))
#define BT12_PWC	(*((volatile stc_btn_pwc_t*)0xB4888000))
#define BT13_PWC	(*((volatile stc_btn_pwc_t*)0xB4888400))
#define BT14_PWC	(*((volatile stc_btn_pwc_t*)0xB4888800))
#define BT15_PWC	(*((volatile stc_btn_pwc_t*)0xB4888C00))
#define BT16_PWC	(*((volatile stc_btn_pwc_t*)0xB4889000))
#define BT17_PWC	(*((volatile stc_btn_pwc_t*)0xB4889400))
#define BT18_PWC	(*((volatile stc_btn_pwc_t*)0xB4889800))
#define BT19_PWC	(*((volatile stc_btn_pwc_t*)0xB4889C00))
#define BT20_PWC	(*((volatile stc_btn_pwc_t*)0xB488A000))
#define BT21_PWC	(*((volatile stc_btn_pwc_t*)0xB488A400))
#define BT22_PWC	(*((volatile stc_btn_pwc_t*)0xB488A800))
#define BT23_PWC	(*((volatile stc_btn_pwc_t*)0xB488AC00))
#define BT24_PWC	(*((volatile stc_btn_pwc_t*)0xB4846000))
#define BT25_PWC	(*((volatile stc_btn_pwc_t*)0xB4846400))
#define BT26_PWC	(*((volatile stc_btn_pwc_t*)0xB4846800))
#define BT27_PWC	(*((volatile stc_btn_pwc_t*)0xB4846C00))
#define BT28_PWC	(*((volatile stc_btn_pwc_t*)0xB4847000))
#define BT29_PWC	(*((volatile stc_btn_pwc_t*)0xB4847400))
#define BT30_PWC	(*((volatile stc_btn_pwc_t*)0xB4847800))
#define BT31_PWC	(*((volatile stc_btn_pwc_t*)0xB4847C00))
#endif /* __IO_DEFINE */

/* DTBF */
#define BT00_PWC_DTBF	(BT00_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT00_PWC_DTBF_DTBF	BT00_PWC_DTBF  /*@bfrg@*/

#define BT01_PWC_DTBF	(BT01_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT01_PWC_DTBF_DTBF	BT01_PWC_DTBF  /*@bfrg@*/

#define BT02_PWC_DTBF	(BT02_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT02_PWC_DTBF_DTBF	BT02_PWC_DTBF  /*@bfrg@*/

#define BT03_PWC_DTBF	(BT03_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT03_PWC_DTBF_DTBF	BT03_PWC_DTBF  /*@bfrg@*/

#define BT04_PWC_DTBF	(BT04_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT04_PWC_DTBF_DTBF	BT04_PWC_DTBF  /*@bfrg@*/

#define BT05_PWC_DTBF	(BT05_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT05_PWC_DTBF_DTBF	BT05_PWC_DTBF  /*@bfrg@*/

#define BT06_PWC_DTBF	(BT06_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT06_PWC_DTBF_DTBF	BT06_PWC_DTBF  /*@bfrg@*/

#define BT07_PWC_DTBF	(BT07_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT07_PWC_DTBF_DTBF	BT07_PWC_DTBF  /*@bfrg@*/

#define BT08_PWC_DTBF	(BT08_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT08_PWC_DTBF_DTBF	BT08_PWC_DTBF  /*@bfrg@*/

#define BT09_PWC_DTBF	(BT09_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT09_PWC_DTBF_DTBF	BT09_PWC_DTBF  /*@bfrg@*/

#define BT10_PWC_DTBF	(BT10_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT10_PWC_DTBF_DTBF	BT10_PWC_DTBF  /*@bfrg@*/

#define BT11_PWC_DTBF	(BT11_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT11_PWC_DTBF_DTBF	BT11_PWC_DTBF  /*@bfrg@*/

#define BT12_PWC_DTBF	(BT12_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT12_PWC_DTBF_DTBF	BT12_PWC_DTBF  /*@bfrg@*/

#define BT13_PWC_DTBF	(BT13_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT13_PWC_DTBF_DTBF	BT13_PWC_DTBF  /*@bfrg@*/

#define BT14_PWC_DTBF	(BT14_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT14_PWC_DTBF_DTBF	BT14_PWC_DTBF  /*@bfrg@*/

#define BT15_PWC_DTBF	(BT15_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT15_PWC_DTBF_DTBF	BT15_PWC_DTBF  /*@bfrg@*/

#define BT16_PWC_DTBF	(BT16_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT16_PWC_DTBF_DTBF	BT16_PWC_DTBF  /*@bfrg@*/

#define BT17_PWC_DTBF	(BT17_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT17_PWC_DTBF_DTBF	BT17_PWC_DTBF  /*@bfrg@*/

#define BT18_PWC_DTBF	(BT18_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT18_PWC_DTBF_DTBF	BT18_PWC_DTBF  /*@bfrg@*/

#define BT19_PWC_DTBF	(BT19_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT19_PWC_DTBF_DTBF	BT19_PWC_DTBF  /*@bfrg@*/

#define BT20_PWC_DTBF	(BT20_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT20_PWC_DTBF_DTBF	BT20_PWC_DTBF  /*@bfrg@*/

#define BT21_PWC_DTBF	(BT21_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT21_PWC_DTBF_DTBF	BT21_PWC_DTBF  /*@bfrg@*/

#define BT22_PWC_DTBF	(BT22_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT22_PWC_DTBF_DTBF	BT22_PWC_DTBF  /*@bfrg@*/

#define BT23_PWC_DTBF	(BT23_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT23_PWC_DTBF_DTBF	BT23_PWC_DTBF  /*@bfrg@*/

#define BT24_PWC_DTBF	(BT24_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT24_PWC_DTBF_DTBF	BT24_PWC_DTBF  /*@bfrg@*/

#define BT25_PWC_DTBF	(BT25_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT25_PWC_DTBF_DTBF	BT25_PWC_DTBF  /*@bfrg@*/

#define BT26_PWC_DTBF	(BT26_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT26_PWC_DTBF_DTBF	BT26_PWC_DTBF  /*@bfrg@*/

#define BT27_PWC_DTBF	(BT27_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT27_PWC_DTBF_DTBF	BT27_PWC_DTBF  /*@bfrg@*/

#define BT28_PWC_DTBF	(BT28_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT28_PWC_DTBF_DTBF	BT28_PWC_DTBF  /*@bfrg@*/

#define BT29_PWC_DTBF	(BT29_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT29_PWC_DTBF_DTBF	BT29_PWC_DTBF  /*@bfrg@*/

#define BT30_PWC_DTBF	(BT30_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT30_PWC_DTBF_DTBF	BT30_PWC_DTBF  /*@bfrg@*/

#define BT31_PWC_DTBF	(BT31_PWC.unDTBF.u16Register)  /*@rg@*/
#define BT31_PWC_DTBF_DTBF	BT31_PWC_DTBF  /*@bfrg@*/

typedef union un_btn_pwc_dtbf{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_btn_pwc_dtbf_t;

/* TMCR */
#define BT00_PWC_TMCR	(BT00_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT00_PWC_TMCR_CTEN	(BT00_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT00_PWC_TMCR_MDSE	(BT00_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT00_PWC_TMCR_FMD	(BT00_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT00_PWC_TMCR_T32	(BT00_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT00_PWC_TMCR_EGS	(BT00_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT00_PWC_TMCR_CKS2_0	(BT00_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT01_PWC_TMCR	(BT01_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT01_PWC_TMCR_CTEN	(BT01_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT01_PWC_TMCR_MDSE	(BT01_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT01_PWC_TMCR_FMD	(BT01_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT01_PWC_TMCR_T32	(BT01_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT01_PWC_TMCR_EGS	(BT01_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT01_PWC_TMCR_CKS2_0	(BT01_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT02_PWC_TMCR	(BT02_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT02_PWC_TMCR_CTEN	(BT02_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT02_PWC_TMCR_MDSE	(BT02_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT02_PWC_TMCR_FMD	(BT02_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT02_PWC_TMCR_T32	(BT02_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT02_PWC_TMCR_EGS	(BT02_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT02_PWC_TMCR_CKS2_0	(BT02_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT03_PWC_TMCR	(BT03_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT03_PWC_TMCR_CTEN	(BT03_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT03_PWC_TMCR_MDSE	(BT03_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT03_PWC_TMCR_FMD	(BT03_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT03_PWC_TMCR_T32	(BT03_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT03_PWC_TMCR_EGS	(BT03_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT03_PWC_TMCR_CKS2_0	(BT03_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT04_PWC_TMCR	(BT04_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT04_PWC_TMCR_CTEN	(BT04_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT04_PWC_TMCR_MDSE	(BT04_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT04_PWC_TMCR_FMD	(BT04_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT04_PWC_TMCR_T32	(BT04_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT04_PWC_TMCR_EGS	(BT04_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT04_PWC_TMCR_CKS2_0	(BT04_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT05_PWC_TMCR	(BT05_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT05_PWC_TMCR_CTEN	(BT05_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT05_PWC_TMCR_MDSE	(BT05_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT05_PWC_TMCR_FMD	(BT05_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT05_PWC_TMCR_T32	(BT05_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT05_PWC_TMCR_EGS	(BT05_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT05_PWC_TMCR_CKS2_0	(BT05_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT06_PWC_TMCR	(BT06_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT06_PWC_TMCR_CTEN	(BT06_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT06_PWC_TMCR_MDSE	(BT06_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT06_PWC_TMCR_FMD	(BT06_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT06_PWC_TMCR_T32	(BT06_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT06_PWC_TMCR_EGS	(BT06_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT06_PWC_TMCR_CKS2_0	(BT06_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT07_PWC_TMCR	(BT07_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT07_PWC_TMCR_CTEN	(BT07_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT07_PWC_TMCR_MDSE	(BT07_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT07_PWC_TMCR_FMD	(BT07_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT07_PWC_TMCR_T32	(BT07_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT07_PWC_TMCR_EGS	(BT07_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT07_PWC_TMCR_CKS2_0	(BT07_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT08_PWC_TMCR	(BT08_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT08_PWC_TMCR_CTEN	(BT08_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT08_PWC_TMCR_MDSE	(BT08_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT08_PWC_TMCR_FMD	(BT08_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT08_PWC_TMCR_T32	(BT08_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT08_PWC_TMCR_EGS	(BT08_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT08_PWC_TMCR_CKS2_0	(BT08_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT09_PWC_TMCR	(BT09_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT09_PWC_TMCR_CTEN	(BT09_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT09_PWC_TMCR_MDSE	(BT09_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT09_PWC_TMCR_FMD	(BT09_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT09_PWC_TMCR_T32	(BT09_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT09_PWC_TMCR_EGS	(BT09_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT09_PWC_TMCR_CKS2_0	(BT09_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT10_PWC_TMCR	(BT10_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT10_PWC_TMCR_CTEN	(BT10_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT10_PWC_TMCR_MDSE	(BT10_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT10_PWC_TMCR_FMD	(BT10_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT10_PWC_TMCR_T32	(BT10_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT10_PWC_TMCR_EGS	(BT10_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT10_PWC_TMCR_CKS2_0	(BT10_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT11_PWC_TMCR	(BT11_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT11_PWC_TMCR_CTEN	(BT11_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT11_PWC_TMCR_MDSE	(BT11_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT11_PWC_TMCR_FMD	(BT11_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT11_PWC_TMCR_T32	(BT11_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT11_PWC_TMCR_EGS	(BT11_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT11_PWC_TMCR_CKS2_0	(BT11_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT12_PWC_TMCR	(BT12_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT12_PWC_TMCR_CTEN	(BT12_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT12_PWC_TMCR_MDSE	(BT12_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT12_PWC_TMCR_FMD	(BT12_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT12_PWC_TMCR_T32	(BT12_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT12_PWC_TMCR_EGS	(BT12_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT12_PWC_TMCR_CKS2_0	(BT12_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT13_PWC_TMCR	(BT13_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT13_PWC_TMCR_CTEN	(BT13_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT13_PWC_TMCR_MDSE	(BT13_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT13_PWC_TMCR_FMD	(BT13_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT13_PWC_TMCR_T32	(BT13_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT13_PWC_TMCR_EGS	(BT13_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT13_PWC_TMCR_CKS2_0	(BT13_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT14_PWC_TMCR	(BT14_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT14_PWC_TMCR_CTEN	(BT14_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT14_PWC_TMCR_MDSE	(BT14_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT14_PWC_TMCR_FMD	(BT14_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT14_PWC_TMCR_T32	(BT14_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT14_PWC_TMCR_EGS	(BT14_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT14_PWC_TMCR_CKS2_0	(BT14_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT15_PWC_TMCR	(BT15_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT15_PWC_TMCR_CTEN	(BT15_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT15_PWC_TMCR_MDSE	(BT15_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT15_PWC_TMCR_FMD	(BT15_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT15_PWC_TMCR_T32	(BT15_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT15_PWC_TMCR_EGS	(BT15_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT15_PWC_TMCR_CKS2_0	(BT15_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT16_PWC_TMCR	(BT16_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT16_PWC_TMCR_CTEN	(BT16_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT16_PWC_TMCR_MDSE	(BT16_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT16_PWC_TMCR_FMD	(BT16_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT16_PWC_TMCR_T32	(BT16_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT16_PWC_TMCR_EGS	(BT16_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT16_PWC_TMCR_CKS2_0	(BT16_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT17_PWC_TMCR	(BT17_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT17_PWC_TMCR_CTEN	(BT17_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT17_PWC_TMCR_MDSE	(BT17_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT17_PWC_TMCR_FMD	(BT17_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT17_PWC_TMCR_T32	(BT17_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT17_PWC_TMCR_EGS	(BT17_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT17_PWC_TMCR_CKS2_0	(BT17_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT18_PWC_TMCR	(BT18_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT18_PWC_TMCR_CTEN	(BT18_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT18_PWC_TMCR_MDSE	(BT18_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT18_PWC_TMCR_FMD	(BT18_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT18_PWC_TMCR_T32	(BT18_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT18_PWC_TMCR_EGS	(BT18_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT18_PWC_TMCR_CKS2_0	(BT18_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT19_PWC_TMCR	(BT19_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT19_PWC_TMCR_CTEN	(BT19_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT19_PWC_TMCR_MDSE	(BT19_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT19_PWC_TMCR_FMD	(BT19_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT19_PWC_TMCR_T32	(BT19_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT19_PWC_TMCR_EGS	(BT19_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT19_PWC_TMCR_CKS2_0	(BT19_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT20_PWC_TMCR	(BT20_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT20_PWC_TMCR_CTEN	(BT20_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT20_PWC_TMCR_MDSE	(BT20_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT20_PWC_TMCR_FMD	(BT20_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT20_PWC_TMCR_T32	(BT20_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT20_PWC_TMCR_EGS	(BT20_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT20_PWC_TMCR_CKS2_0	(BT20_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT21_PWC_TMCR	(BT21_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT21_PWC_TMCR_CTEN	(BT21_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT21_PWC_TMCR_MDSE	(BT21_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT21_PWC_TMCR_FMD	(BT21_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT21_PWC_TMCR_T32	(BT21_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT21_PWC_TMCR_EGS	(BT21_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT21_PWC_TMCR_CKS2_0	(BT21_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT22_PWC_TMCR	(BT22_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT22_PWC_TMCR_CTEN	(BT22_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT22_PWC_TMCR_MDSE	(BT22_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT22_PWC_TMCR_FMD	(BT22_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT22_PWC_TMCR_T32	(BT22_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT22_PWC_TMCR_EGS	(BT22_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT22_PWC_TMCR_CKS2_0	(BT22_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT23_PWC_TMCR	(BT23_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT23_PWC_TMCR_CTEN	(BT23_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT23_PWC_TMCR_MDSE	(BT23_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT23_PWC_TMCR_FMD	(BT23_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT23_PWC_TMCR_T32	(BT23_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT23_PWC_TMCR_EGS	(BT23_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT23_PWC_TMCR_CKS2_0	(BT23_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT24_PWC_TMCR	(BT24_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT24_PWC_TMCR_CTEN	(BT24_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT24_PWC_TMCR_MDSE	(BT24_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT24_PWC_TMCR_FMD	(BT24_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT24_PWC_TMCR_T32	(BT24_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT24_PWC_TMCR_EGS	(BT24_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT24_PWC_TMCR_CKS2_0	(BT24_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT25_PWC_TMCR	(BT25_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT25_PWC_TMCR_CTEN	(BT25_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT25_PWC_TMCR_MDSE	(BT25_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT25_PWC_TMCR_FMD	(BT25_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT25_PWC_TMCR_T32	(BT25_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT25_PWC_TMCR_EGS	(BT25_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT25_PWC_TMCR_CKS2_0	(BT25_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT26_PWC_TMCR	(BT26_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT26_PWC_TMCR_CTEN	(BT26_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT26_PWC_TMCR_MDSE	(BT26_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT26_PWC_TMCR_FMD	(BT26_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT26_PWC_TMCR_T32	(BT26_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT26_PWC_TMCR_EGS	(BT26_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT26_PWC_TMCR_CKS2_0	(BT26_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT27_PWC_TMCR	(BT27_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT27_PWC_TMCR_CTEN	(BT27_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT27_PWC_TMCR_MDSE	(BT27_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT27_PWC_TMCR_FMD	(BT27_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT27_PWC_TMCR_T32	(BT27_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT27_PWC_TMCR_EGS	(BT27_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT27_PWC_TMCR_CKS2_0	(BT27_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT28_PWC_TMCR	(BT28_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT28_PWC_TMCR_CTEN	(BT28_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT28_PWC_TMCR_MDSE	(BT28_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT28_PWC_TMCR_FMD	(BT28_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT28_PWC_TMCR_T32	(BT28_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT28_PWC_TMCR_EGS	(BT28_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT28_PWC_TMCR_CKS2_0	(BT28_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT29_PWC_TMCR	(BT29_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT29_PWC_TMCR_CTEN	(BT29_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT29_PWC_TMCR_MDSE	(BT29_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT29_PWC_TMCR_FMD	(BT29_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT29_PWC_TMCR_T32	(BT29_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT29_PWC_TMCR_EGS	(BT29_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT29_PWC_TMCR_CKS2_0	(BT29_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT30_PWC_TMCR	(BT30_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT30_PWC_TMCR_CTEN	(BT30_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT30_PWC_TMCR_MDSE	(BT30_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT30_PWC_TMCR_FMD	(BT30_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT30_PWC_TMCR_T32	(BT30_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT30_PWC_TMCR_EGS	(BT30_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT30_PWC_TMCR_CKS2_0	(BT30_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

#define BT31_PWC_TMCR	(BT31_PWC.unTMCR.u16Register)  /*@rg@*/
#define BT31_PWC_TMCR_CTEN	(BT31_PWC.unTMCR.stcField.u1CTEN)  /*@bf@*/
#define BT31_PWC_TMCR_MDSE	(BT31_PWC.unTMCR.stcField.u1MDSE)  /*@bf@*/
#define BT31_PWC_TMCR_FMD	(BT31_PWC.unTMCR.stcField.u3FMD)  /*@bf@*/
#define BT31_PWC_TMCR_T32	(BT31_PWC.unTMCR.stcField.u1T32)  /*@bf@*/
#define BT31_PWC_TMCR_EGS	(BT31_PWC.unTMCR.stcField.u3EGS)  /*@bf@*/
#define BT31_PWC_TMCR_CKS2_0	(BT31_PWC.unTMCR.stcField.u3CKS2_0)  /*@bf@*/

typedef struct stc_btn_pwc_tmcr_field{
    uint_io16_t		:1;
    uint_io16_t		u1CTEN:1;
    uint_io16_t		u1MDSE:1;
    uint_io16_t		:1;
    uint_io16_t		u3FMD:3;
    uint_io16_t		u1T32:1;
    uint_io16_t		u3EGS:3;
    uint_io16_t		:1;
    uint_io16_t		u3CKS2_0:3;
    uint_io16_t		:1;
}stc_btn_pwc_tmcr_field_t;

typedef union un_btn_pwc_tmcr{
    uint_io16_t		u16Register;
    stc_btn_pwc_tmcr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_btn_pwc_tmcr_t;

/* STC */
#define BT00_PWC_STC	(BT00_PWC.unSTC.u8Register)  /*@rg@*/
#define BT00_PWC_STC_OVIR	(BT00_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT00_PWC_STC_EDIR	(BT00_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT00_PWC_STC_OVIE	(BT00_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT00_PWC_STC_EDIE	(BT00_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT00_PWC_STC_ERR	(BT00_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT01_PWC_STC	(BT01_PWC.unSTC.u8Register)  /*@rg@*/
#define BT01_PWC_STC_OVIR	(BT01_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT01_PWC_STC_EDIR	(BT01_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT01_PWC_STC_OVIE	(BT01_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT01_PWC_STC_EDIE	(BT01_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT01_PWC_STC_ERR	(BT01_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT02_PWC_STC	(BT02_PWC.unSTC.u8Register)  /*@rg@*/
#define BT02_PWC_STC_OVIR	(BT02_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT02_PWC_STC_EDIR	(BT02_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT02_PWC_STC_OVIE	(BT02_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT02_PWC_STC_EDIE	(BT02_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT02_PWC_STC_ERR	(BT02_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT03_PWC_STC	(BT03_PWC.unSTC.u8Register)  /*@rg@*/
#define BT03_PWC_STC_OVIR	(BT03_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT03_PWC_STC_EDIR	(BT03_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT03_PWC_STC_OVIE	(BT03_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT03_PWC_STC_EDIE	(BT03_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT03_PWC_STC_ERR	(BT03_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT04_PWC_STC	(BT04_PWC.unSTC.u8Register)  /*@rg@*/
#define BT04_PWC_STC_OVIR	(BT04_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT04_PWC_STC_EDIR	(BT04_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT04_PWC_STC_OVIE	(BT04_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT04_PWC_STC_EDIE	(BT04_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT04_PWC_STC_ERR	(BT04_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT05_PWC_STC	(BT05_PWC.unSTC.u8Register)  /*@rg@*/
#define BT05_PWC_STC_OVIR	(BT05_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT05_PWC_STC_EDIR	(BT05_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT05_PWC_STC_OVIE	(BT05_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT05_PWC_STC_EDIE	(BT05_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT05_PWC_STC_ERR	(BT05_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT06_PWC_STC	(BT06_PWC.unSTC.u8Register)  /*@rg@*/
#define BT06_PWC_STC_OVIR	(BT06_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT06_PWC_STC_EDIR	(BT06_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT06_PWC_STC_OVIE	(BT06_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT06_PWC_STC_EDIE	(BT06_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT06_PWC_STC_ERR	(BT06_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT07_PWC_STC	(BT07_PWC.unSTC.u8Register)  /*@rg@*/
#define BT07_PWC_STC_OVIR	(BT07_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT07_PWC_STC_EDIR	(BT07_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT07_PWC_STC_OVIE	(BT07_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT07_PWC_STC_EDIE	(BT07_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT07_PWC_STC_ERR	(BT07_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT08_PWC_STC	(BT08_PWC.unSTC.u8Register)  /*@rg@*/
#define BT08_PWC_STC_OVIR	(BT08_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT08_PWC_STC_EDIR	(BT08_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT08_PWC_STC_OVIE	(BT08_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT08_PWC_STC_EDIE	(BT08_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT08_PWC_STC_ERR	(BT08_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT09_PWC_STC	(BT09_PWC.unSTC.u8Register)  /*@rg@*/
#define BT09_PWC_STC_OVIR	(BT09_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT09_PWC_STC_EDIR	(BT09_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT09_PWC_STC_OVIE	(BT09_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT09_PWC_STC_EDIE	(BT09_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT09_PWC_STC_ERR	(BT09_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT10_PWC_STC	(BT10_PWC.unSTC.u8Register)  /*@rg@*/
#define BT10_PWC_STC_OVIR	(BT10_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT10_PWC_STC_EDIR	(BT10_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT10_PWC_STC_OVIE	(BT10_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT10_PWC_STC_EDIE	(BT10_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT10_PWC_STC_ERR	(BT10_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT11_PWC_STC	(BT11_PWC.unSTC.u8Register)  /*@rg@*/
#define BT11_PWC_STC_OVIR	(BT11_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT11_PWC_STC_EDIR	(BT11_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT11_PWC_STC_OVIE	(BT11_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT11_PWC_STC_EDIE	(BT11_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT11_PWC_STC_ERR	(BT11_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT12_PWC_STC	(BT12_PWC.unSTC.u8Register)  /*@rg@*/
#define BT12_PWC_STC_OVIR	(BT12_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT12_PWC_STC_EDIR	(BT12_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT12_PWC_STC_OVIE	(BT12_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT12_PWC_STC_EDIE	(BT12_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT12_PWC_STC_ERR	(BT12_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT13_PWC_STC	(BT13_PWC.unSTC.u8Register)  /*@rg@*/
#define BT13_PWC_STC_OVIR	(BT13_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT13_PWC_STC_EDIR	(BT13_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT13_PWC_STC_OVIE	(BT13_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT13_PWC_STC_EDIE	(BT13_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT13_PWC_STC_ERR	(BT13_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT14_PWC_STC	(BT14_PWC.unSTC.u8Register)  /*@rg@*/
#define BT14_PWC_STC_OVIR	(BT14_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT14_PWC_STC_EDIR	(BT14_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT14_PWC_STC_OVIE	(BT14_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT14_PWC_STC_EDIE	(BT14_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT14_PWC_STC_ERR	(BT14_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT15_PWC_STC	(BT15_PWC.unSTC.u8Register)  /*@rg@*/
#define BT15_PWC_STC_OVIR	(BT15_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT15_PWC_STC_EDIR	(BT15_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT15_PWC_STC_OVIE	(BT15_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT15_PWC_STC_EDIE	(BT15_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT15_PWC_STC_ERR	(BT15_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT16_PWC_STC	(BT16_PWC.unSTC.u8Register)  /*@rg@*/
#define BT16_PWC_STC_OVIR	(BT16_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT16_PWC_STC_EDIR	(BT16_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT16_PWC_STC_OVIE	(BT16_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT16_PWC_STC_EDIE	(BT16_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT16_PWC_STC_ERR	(BT16_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT17_PWC_STC	(BT17_PWC.unSTC.u8Register)  /*@rg@*/
#define BT17_PWC_STC_OVIR	(BT17_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT17_PWC_STC_EDIR	(BT17_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT17_PWC_STC_OVIE	(BT17_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT17_PWC_STC_EDIE	(BT17_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT17_PWC_STC_ERR	(BT17_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT18_PWC_STC	(BT18_PWC.unSTC.u8Register)  /*@rg@*/
#define BT18_PWC_STC_OVIR	(BT18_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT18_PWC_STC_EDIR	(BT18_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT18_PWC_STC_OVIE	(BT18_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT18_PWC_STC_EDIE	(BT18_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT18_PWC_STC_ERR	(BT18_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT19_PWC_STC	(BT19_PWC.unSTC.u8Register)  /*@rg@*/
#define BT19_PWC_STC_OVIR	(BT19_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT19_PWC_STC_EDIR	(BT19_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT19_PWC_STC_OVIE	(BT19_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT19_PWC_STC_EDIE	(BT19_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT19_PWC_STC_ERR	(BT19_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT20_PWC_STC	(BT20_PWC.unSTC.u8Register)  /*@rg@*/
#define BT20_PWC_STC_OVIR	(BT20_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT20_PWC_STC_EDIR	(BT20_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT20_PWC_STC_OVIE	(BT20_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT20_PWC_STC_EDIE	(BT20_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT20_PWC_STC_ERR	(BT20_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT21_PWC_STC	(BT21_PWC.unSTC.u8Register)  /*@rg@*/
#define BT21_PWC_STC_OVIR	(BT21_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT21_PWC_STC_EDIR	(BT21_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT21_PWC_STC_OVIE	(BT21_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT21_PWC_STC_EDIE	(BT21_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT21_PWC_STC_ERR	(BT21_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT22_PWC_STC	(BT22_PWC.unSTC.u8Register)  /*@rg@*/
#define BT22_PWC_STC_OVIR	(BT22_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT22_PWC_STC_EDIR	(BT22_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT22_PWC_STC_OVIE	(BT22_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT22_PWC_STC_EDIE	(BT22_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT22_PWC_STC_ERR	(BT22_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT23_PWC_STC	(BT23_PWC.unSTC.u8Register)  /*@rg@*/
#define BT23_PWC_STC_OVIR	(BT23_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT23_PWC_STC_EDIR	(BT23_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT23_PWC_STC_OVIE	(BT23_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT23_PWC_STC_EDIE	(BT23_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT23_PWC_STC_ERR	(BT23_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT24_PWC_STC	(BT24_PWC.unSTC.u8Register)  /*@rg@*/
#define BT24_PWC_STC_OVIR	(BT24_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT24_PWC_STC_EDIR	(BT24_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT24_PWC_STC_OVIE	(BT24_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT24_PWC_STC_EDIE	(BT24_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT24_PWC_STC_ERR	(BT24_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT25_PWC_STC	(BT25_PWC.unSTC.u8Register)  /*@rg@*/
#define BT25_PWC_STC_OVIR	(BT25_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT25_PWC_STC_EDIR	(BT25_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT25_PWC_STC_OVIE	(BT25_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT25_PWC_STC_EDIE	(BT25_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT25_PWC_STC_ERR	(BT25_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT26_PWC_STC	(BT26_PWC.unSTC.u8Register)  /*@rg@*/
#define BT26_PWC_STC_OVIR	(BT26_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT26_PWC_STC_EDIR	(BT26_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT26_PWC_STC_OVIE	(BT26_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT26_PWC_STC_EDIE	(BT26_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT26_PWC_STC_ERR	(BT26_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT27_PWC_STC	(BT27_PWC.unSTC.u8Register)  /*@rg@*/
#define BT27_PWC_STC_OVIR	(BT27_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT27_PWC_STC_EDIR	(BT27_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT27_PWC_STC_OVIE	(BT27_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT27_PWC_STC_EDIE	(BT27_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT27_PWC_STC_ERR	(BT27_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT28_PWC_STC	(BT28_PWC.unSTC.u8Register)  /*@rg@*/
#define BT28_PWC_STC_OVIR	(BT28_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT28_PWC_STC_EDIR	(BT28_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT28_PWC_STC_OVIE	(BT28_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT28_PWC_STC_EDIE	(BT28_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT28_PWC_STC_ERR	(BT28_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT29_PWC_STC	(BT29_PWC.unSTC.u8Register)  /*@rg@*/
#define BT29_PWC_STC_OVIR	(BT29_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT29_PWC_STC_EDIR	(BT29_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT29_PWC_STC_OVIE	(BT29_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT29_PWC_STC_EDIE	(BT29_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT29_PWC_STC_ERR	(BT29_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT30_PWC_STC	(BT30_PWC.unSTC.u8Register)  /*@rg@*/
#define BT30_PWC_STC_OVIR	(BT30_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT30_PWC_STC_EDIR	(BT30_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT30_PWC_STC_OVIE	(BT30_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT30_PWC_STC_EDIE	(BT30_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT30_PWC_STC_ERR	(BT30_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

#define BT31_PWC_STC	(BT31_PWC.unSTC.u8Register)  /*@rg@*/
#define BT31_PWC_STC_OVIR	(BT31_PWC.unSTC.stcField.u1OVIR)  /*@bf@*/
#define BT31_PWC_STC_EDIR	(BT31_PWC.unSTC.stcField.u1EDIR)  /*@bf@*/
#define BT31_PWC_STC_OVIE	(BT31_PWC.unSTC.stcField.u1OVIE)  /*@bf@*/
#define BT31_PWC_STC_EDIE	(BT31_PWC.unSTC.stcField.u1EDIE)  /*@bf@*/
#define BT31_PWC_STC_ERR	(BT31_PWC.unSTC.stcField.u1ERR)  /*@bf@*/

typedef struct stc_btn_pwc_stc_field{
    uint_io8_t		u1OVIR:1;
    uint_io8_t		:1;
    uint_io8_t		u1EDIR:1;
    uint_io8_t		:1;
    uint_io8_t		u1OVIE:1;
    uint_io8_t		:1;
    uint_io8_t		u1EDIE:1;
    uint_io8_t		u1ERR:1;
}stc_btn_pwc_stc_field_t;

typedef union un_btn_pwc_stc{
    uint_io8_t		u8Register;
    stc_btn_pwc_stc_field_t		stcField;
}un_btn_pwc_stc_t;

/* TMCR2 */
#define BT00_PWC_TMCR2	(BT00_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT00_PWC_TMCR2_CKS3	(BT00_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT01_PWC_TMCR2	(BT01_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT01_PWC_TMCR2_CKS3	(BT01_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT02_PWC_TMCR2	(BT02_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT02_PWC_TMCR2_CKS3	(BT02_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT03_PWC_TMCR2	(BT03_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT03_PWC_TMCR2_CKS3	(BT03_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT04_PWC_TMCR2	(BT04_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT04_PWC_TMCR2_CKS3	(BT04_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT05_PWC_TMCR2	(BT05_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT05_PWC_TMCR2_CKS3	(BT05_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT06_PWC_TMCR2	(BT06_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT06_PWC_TMCR2_CKS3	(BT06_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT07_PWC_TMCR2	(BT07_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT07_PWC_TMCR2_CKS3	(BT07_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT08_PWC_TMCR2	(BT08_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT08_PWC_TMCR2_CKS3	(BT08_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT09_PWC_TMCR2	(BT09_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT09_PWC_TMCR2_CKS3	(BT09_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT10_PWC_TMCR2	(BT10_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT10_PWC_TMCR2_CKS3	(BT10_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT11_PWC_TMCR2	(BT11_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT11_PWC_TMCR2_CKS3	(BT11_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT12_PWC_TMCR2	(BT12_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT12_PWC_TMCR2_CKS3	(BT12_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT13_PWC_TMCR2	(BT13_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT13_PWC_TMCR2_CKS3	(BT13_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT14_PWC_TMCR2	(BT14_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT14_PWC_TMCR2_CKS3	(BT14_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT15_PWC_TMCR2	(BT15_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT15_PWC_TMCR2_CKS3	(BT15_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT16_PWC_TMCR2	(BT16_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT16_PWC_TMCR2_CKS3	(BT16_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT17_PWC_TMCR2	(BT17_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT17_PWC_TMCR2_CKS3	(BT17_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT18_PWC_TMCR2	(BT18_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT18_PWC_TMCR2_CKS3	(BT18_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT19_PWC_TMCR2	(BT19_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT19_PWC_TMCR2_CKS3	(BT19_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT20_PWC_TMCR2	(BT20_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT20_PWC_TMCR2_CKS3	(BT20_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT21_PWC_TMCR2	(BT21_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT21_PWC_TMCR2_CKS3	(BT21_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT22_PWC_TMCR2	(BT22_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT22_PWC_TMCR2_CKS3	(BT22_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT23_PWC_TMCR2	(BT23_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT23_PWC_TMCR2_CKS3	(BT23_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT24_PWC_TMCR2	(BT24_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT24_PWC_TMCR2_CKS3	(BT24_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT25_PWC_TMCR2	(BT25_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT25_PWC_TMCR2_CKS3	(BT25_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT26_PWC_TMCR2	(BT26_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT26_PWC_TMCR2_CKS3	(BT26_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT27_PWC_TMCR2	(BT27_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT27_PWC_TMCR2_CKS3	(BT27_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT28_PWC_TMCR2	(BT28_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT28_PWC_TMCR2_CKS3	(BT28_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT29_PWC_TMCR2	(BT29_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT29_PWC_TMCR2_CKS3	(BT29_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT30_PWC_TMCR2	(BT30_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT30_PWC_TMCR2_CKS3	(BT30_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

#define BT31_PWC_TMCR2	(BT31_PWC.unTMCR2.u8Register)  /*@rg@*/
#define BT31_PWC_TMCR2_CKS3	(BT31_PWC.unTMCR2.stcField.u1CKS3)  /*@bf@*/

typedef struct stc_btn_pwc_tmcr2_field{
    uint_io8_t		u1CKS3:1;
    uint_io8_t		:7;
}stc_btn_pwc_tmcr2_field_t;

typedef union un_btn_pwc_tmcr2{
    uint_io8_t		u8Register;
    stc_btn_pwc_tmcr2_field_t		stcField;
}un_btn_pwc_tmcr2_t;

/* STCC */
#define BT00_PWC_STCC	(BT00_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT00_PWC_STCC_OVIRC	(BT00_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT00_PWC_STCC_OVIEC	(BT00_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT00_PWC_STCC_EDIEC	(BT00_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT01_PWC_STCC	(BT01_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT01_PWC_STCC_OVIRC	(BT01_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT01_PWC_STCC_OVIEC	(BT01_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT01_PWC_STCC_EDIEC	(BT01_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT02_PWC_STCC	(BT02_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT02_PWC_STCC_OVIRC	(BT02_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT02_PWC_STCC_OVIEC	(BT02_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT02_PWC_STCC_EDIEC	(BT02_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT03_PWC_STCC	(BT03_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT03_PWC_STCC_OVIRC	(BT03_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT03_PWC_STCC_OVIEC	(BT03_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT03_PWC_STCC_EDIEC	(BT03_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT04_PWC_STCC	(BT04_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT04_PWC_STCC_OVIRC	(BT04_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT04_PWC_STCC_OVIEC	(BT04_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT04_PWC_STCC_EDIEC	(BT04_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT05_PWC_STCC	(BT05_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT05_PWC_STCC_OVIRC	(BT05_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT05_PWC_STCC_OVIEC	(BT05_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT05_PWC_STCC_EDIEC	(BT05_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT06_PWC_STCC	(BT06_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT06_PWC_STCC_OVIRC	(BT06_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT06_PWC_STCC_OVIEC	(BT06_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT06_PWC_STCC_EDIEC	(BT06_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT07_PWC_STCC	(BT07_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT07_PWC_STCC_OVIRC	(BT07_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT07_PWC_STCC_OVIEC	(BT07_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT07_PWC_STCC_EDIEC	(BT07_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT08_PWC_STCC	(BT08_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT08_PWC_STCC_OVIRC	(BT08_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT08_PWC_STCC_OVIEC	(BT08_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT08_PWC_STCC_EDIEC	(BT08_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT09_PWC_STCC	(BT09_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT09_PWC_STCC_OVIRC	(BT09_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT09_PWC_STCC_OVIEC	(BT09_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT09_PWC_STCC_EDIEC	(BT09_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT10_PWC_STCC	(BT10_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT10_PWC_STCC_OVIRC	(BT10_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT10_PWC_STCC_OVIEC	(BT10_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT10_PWC_STCC_EDIEC	(BT10_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT11_PWC_STCC	(BT11_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT11_PWC_STCC_OVIRC	(BT11_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT11_PWC_STCC_OVIEC	(BT11_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT11_PWC_STCC_EDIEC	(BT11_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT12_PWC_STCC	(BT12_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT12_PWC_STCC_OVIRC	(BT12_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT12_PWC_STCC_OVIEC	(BT12_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT12_PWC_STCC_EDIEC	(BT12_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT13_PWC_STCC	(BT13_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT13_PWC_STCC_OVIRC	(BT13_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT13_PWC_STCC_OVIEC	(BT13_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT13_PWC_STCC_EDIEC	(BT13_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT14_PWC_STCC	(BT14_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT14_PWC_STCC_OVIRC	(BT14_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT14_PWC_STCC_OVIEC	(BT14_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT14_PWC_STCC_EDIEC	(BT14_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT15_PWC_STCC	(BT15_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT15_PWC_STCC_OVIRC	(BT15_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT15_PWC_STCC_OVIEC	(BT15_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT15_PWC_STCC_EDIEC	(BT15_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT16_PWC_STCC	(BT16_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT16_PWC_STCC_OVIRC	(BT16_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT16_PWC_STCC_OVIEC	(BT16_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT16_PWC_STCC_EDIEC	(BT16_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT17_PWC_STCC	(BT17_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT17_PWC_STCC_OVIRC	(BT17_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT17_PWC_STCC_OVIEC	(BT17_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT17_PWC_STCC_EDIEC	(BT17_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT18_PWC_STCC	(BT18_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT18_PWC_STCC_OVIRC	(BT18_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT18_PWC_STCC_OVIEC	(BT18_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT18_PWC_STCC_EDIEC	(BT18_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT19_PWC_STCC	(BT19_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT19_PWC_STCC_OVIRC	(BT19_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT19_PWC_STCC_OVIEC	(BT19_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT19_PWC_STCC_EDIEC	(BT19_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT20_PWC_STCC	(BT20_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT20_PWC_STCC_OVIRC	(BT20_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT20_PWC_STCC_OVIEC	(BT20_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT20_PWC_STCC_EDIEC	(BT20_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT21_PWC_STCC	(BT21_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT21_PWC_STCC_OVIRC	(BT21_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT21_PWC_STCC_OVIEC	(BT21_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT21_PWC_STCC_EDIEC	(BT21_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT22_PWC_STCC	(BT22_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT22_PWC_STCC_OVIRC	(BT22_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT22_PWC_STCC_OVIEC	(BT22_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT22_PWC_STCC_EDIEC	(BT22_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT23_PWC_STCC	(BT23_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT23_PWC_STCC_OVIRC	(BT23_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT23_PWC_STCC_OVIEC	(BT23_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT23_PWC_STCC_EDIEC	(BT23_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT24_PWC_STCC	(BT24_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT24_PWC_STCC_OVIRC	(BT24_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT24_PWC_STCC_OVIEC	(BT24_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT24_PWC_STCC_EDIEC	(BT24_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT25_PWC_STCC	(BT25_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT25_PWC_STCC_OVIRC	(BT25_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT25_PWC_STCC_OVIEC	(BT25_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT25_PWC_STCC_EDIEC	(BT25_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT26_PWC_STCC	(BT26_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT26_PWC_STCC_OVIRC	(BT26_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT26_PWC_STCC_OVIEC	(BT26_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT26_PWC_STCC_EDIEC	(BT26_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT27_PWC_STCC	(BT27_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT27_PWC_STCC_OVIRC	(BT27_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT27_PWC_STCC_OVIEC	(BT27_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT27_PWC_STCC_EDIEC	(BT27_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT28_PWC_STCC	(BT28_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT28_PWC_STCC_OVIRC	(BT28_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT28_PWC_STCC_OVIEC	(BT28_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT28_PWC_STCC_EDIEC	(BT28_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT29_PWC_STCC	(BT29_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT29_PWC_STCC_OVIRC	(BT29_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT29_PWC_STCC_OVIEC	(BT29_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT29_PWC_STCC_EDIEC	(BT29_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT30_PWC_STCC	(BT30_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT30_PWC_STCC_OVIRC	(BT30_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT30_PWC_STCC_OVIEC	(BT30_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT30_PWC_STCC_EDIEC	(BT30_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

#define BT31_PWC_STCC	(BT31_PWC.unSTCC.u8Register)  /*@rg@*/
#define BT31_PWC_STCC_OVIRC	(BT31_PWC.unSTCC.stcField.u1OVIRC)  /*@bf@*/
#define BT31_PWC_STCC_OVIEC	(BT31_PWC.unSTCC.stcField.u1OVIEC)  /*@bf@*/
#define BT31_PWC_STCC_EDIEC	(BT31_PWC.unSTCC.stcField.u1EDIEC)  /*@bf@*/

typedef struct stc_btn_pwc_stcc_field{
    uint_io8_t		u1OVIRC:1;
    uint_io8_t		:3;
    uint_io8_t		u1OVIEC:1;
    uint_io8_t		:1;
    uint_io8_t		u1EDIEC:1;
    uint_io8_t		:1;
}stc_btn_pwc_stcc_field_t;

typedef union un_btn_pwc_stcc{
    uint_io8_t		u8Register;
    stc_btn_pwc_stcc_field_t		stcField;
}un_btn_pwc_stcc_t;

/* STCS */
#define BT00_PWC_STCS	(BT00_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT00_PWC_STCS_OVIES	(BT00_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT00_PWC_STCS_EDIES	(BT00_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT01_PWC_STCS	(BT01_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT01_PWC_STCS_OVIES	(BT01_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT01_PWC_STCS_EDIES	(BT01_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT02_PWC_STCS	(BT02_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT02_PWC_STCS_OVIES	(BT02_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT02_PWC_STCS_EDIES	(BT02_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT03_PWC_STCS	(BT03_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT03_PWC_STCS_OVIES	(BT03_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT03_PWC_STCS_EDIES	(BT03_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT04_PWC_STCS	(BT04_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT04_PWC_STCS_OVIES	(BT04_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT04_PWC_STCS_EDIES	(BT04_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT05_PWC_STCS	(BT05_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT05_PWC_STCS_OVIES	(BT05_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT05_PWC_STCS_EDIES	(BT05_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT06_PWC_STCS	(BT06_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT06_PWC_STCS_OVIES	(BT06_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT06_PWC_STCS_EDIES	(BT06_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT07_PWC_STCS	(BT07_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT07_PWC_STCS_OVIES	(BT07_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT07_PWC_STCS_EDIES	(BT07_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT08_PWC_STCS	(BT08_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT08_PWC_STCS_OVIES	(BT08_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT08_PWC_STCS_EDIES	(BT08_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT09_PWC_STCS	(BT09_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT09_PWC_STCS_OVIES	(BT09_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT09_PWC_STCS_EDIES	(BT09_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT10_PWC_STCS	(BT10_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT10_PWC_STCS_OVIES	(BT10_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT10_PWC_STCS_EDIES	(BT10_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT11_PWC_STCS	(BT11_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT11_PWC_STCS_OVIES	(BT11_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT11_PWC_STCS_EDIES	(BT11_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT12_PWC_STCS	(BT12_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT12_PWC_STCS_OVIES	(BT12_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT12_PWC_STCS_EDIES	(BT12_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT13_PWC_STCS	(BT13_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT13_PWC_STCS_OVIES	(BT13_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT13_PWC_STCS_EDIES	(BT13_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT14_PWC_STCS	(BT14_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT14_PWC_STCS_OVIES	(BT14_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT14_PWC_STCS_EDIES	(BT14_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT15_PWC_STCS	(BT15_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT15_PWC_STCS_OVIES	(BT15_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT15_PWC_STCS_EDIES	(BT15_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT16_PWC_STCS	(BT16_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT16_PWC_STCS_OVIES	(BT16_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT16_PWC_STCS_EDIES	(BT16_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT17_PWC_STCS	(BT17_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT17_PWC_STCS_OVIES	(BT17_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT17_PWC_STCS_EDIES	(BT17_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT18_PWC_STCS	(BT18_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT18_PWC_STCS_OVIES	(BT18_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT18_PWC_STCS_EDIES	(BT18_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT19_PWC_STCS	(BT19_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT19_PWC_STCS_OVIES	(BT19_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT19_PWC_STCS_EDIES	(BT19_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT20_PWC_STCS	(BT20_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT20_PWC_STCS_OVIES	(BT20_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT20_PWC_STCS_EDIES	(BT20_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT21_PWC_STCS	(BT21_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT21_PWC_STCS_OVIES	(BT21_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT21_PWC_STCS_EDIES	(BT21_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT22_PWC_STCS	(BT22_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT22_PWC_STCS_OVIES	(BT22_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT22_PWC_STCS_EDIES	(BT22_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT23_PWC_STCS	(BT23_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT23_PWC_STCS_OVIES	(BT23_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT23_PWC_STCS_EDIES	(BT23_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT24_PWC_STCS	(BT24_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT24_PWC_STCS_OVIES	(BT24_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT24_PWC_STCS_EDIES	(BT24_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT25_PWC_STCS	(BT25_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT25_PWC_STCS_OVIES	(BT25_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT25_PWC_STCS_EDIES	(BT25_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT26_PWC_STCS	(BT26_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT26_PWC_STCS_OVIES	(BT26_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT26_PWC_STCS_EDIES	(BT26_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT27_PWC_STCS	(BT27_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT27_PWC_STCS_OVIES	(BT27_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT27_PWC_STCS_EDIES	(BT27_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT28_PWC_STCS	(BT28_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT28_PWC_STCS_OVIES	(BT28_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT28_PWC_STCS_EDIES	(BT28_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT29_PWC_STCS	(BT29_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT29_PWC_STCS_OVIES	(BT29_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT29_PWC_STCS_EDIES	(BT29_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT30_PWC_STCS	(BT30_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT30_PWC_STCS_OVIES	(BT30_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT30_PWC_STCS_EDIES	(BT30_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

#define BT31_PWC_STCS	(BT31_PWC.unSTCS.u8Register)  /*@rg@*/
#define BT31_PWC_STCS_OVIES	(BT31_PWC.unSTCS.stcField.u1OVIES)  /*@bf@*/
#define BT31_PWC_STCS_EDIES	(BT31_PWC.unSTCS.stcField.u1EDIES)  /*@bf@*/

typedef struct stc_btn_pwc_stcs_field{
    uint_io8_t		:4;
    uint_io8_t		u1OVIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1EDIES:1;
    uint_io8_t		:1;
}stc_btn_pwc_stcs_field_t;

typedef union un_btn_pwc_stcs{
    uint_io8_t		u8Register;
    stc_btn_pwc_stcs_field_t		stcField;
}un_btn_pwc_stcs_t;

/* BT_DEBUG */
#define BT00_PWC_BT_DEBUG	(BT00_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT00_PWC_BT_DEBUG_DBGEN	(BT00_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT01_PWC_BT_DEBUG	(BT01_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT01_PWC_BT_DEBUG_DBGEN	(BT01_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT02_PWC_BT_DEBUG	(BT02_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT02_PWC_BT_DEBUG_DBGEN	(BT02_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT03_PWC_BT_DEBUG	(BT03_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT03_PWC_BT_DEBUG_DBGEN	(BT03_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT04_PWC_BT_DEBUG	(BT04_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT04_PWC_BT_DEBUG_DBGEN	(BT04_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT05_PWC_BT_DEBUG	(BT05_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT05_PWC_BT_DEBUG_DBGEN	(BT05_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT06_PWC_BT_DEBUG	(BT06_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT06_PWC_BT_DEBUG_DBGEN	(BT06_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT07_PWC_BT_DEBUG	(BT07_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT07_PWC_BT_DEBUG_DBGEN	(BT07_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT08_PWC_BT_DEBUG	(BT08_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT08_PWC_BT_DEBUG_DBGEN	(BT08_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT09_PWC_BT_DEBUG	(BT09_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT09_PWC_BT_DEBUG_DBGEN	(BT09_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT10_PWC_BT_DEBUG	(BT10_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT10_PWC_BT_DEBUG_DBGEN	(BT10_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT11_PWC_BT_DEBUG	(BT11_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT11_PWC_BT_DEBUG_DBGEN	(BT11_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT12_PWC_BT_DEBUG	(BT12_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT12_PWC_BT_DEBUG_DBGEN	(BT12_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT13_PWC_BT_DEBUG	(BT13_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT13_PWC_BT_DEBUG_DBGEN	(BT13_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT14_PWC_BT_DEBUG	(BT14_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT14_PWC_BT_DEBUG_DBGEN	(BT14_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT15_PWC_BT_DEBUG	(BT15_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT15_PWC_BT_DEBUG_DBGEN	(BT15_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT16_PWC_BT_DEBUG	(BT16_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT16_PWC_BT_DEBUG_DBGEN	(BT16_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT17_PWC_BT_DEBUG	(BT17_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT17_PWC_BT_DEBUG_DBGEN	(BT17_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT18_PWC_BT_DEBUG	(BT18_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT18_PWC_BT_DEBUG_DBGEN	(BT18_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT19_PWC_BT_DEBUG	(BT19_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT19_PWC_BT_DEBUG_DBGEN	(BT19_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT20_PWC_BT_DEBUG	(BT20_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT20_PWC_BT_DEBUG_DBGEN	(BT20_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT21_PWC_BT_DEBUG	(BT21_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT21_PWC_BT_DEBUG_DBGEN	(BT21_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT22_PWC_BT_DEBUG	(BT22_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT22_PWC_BT_DEBUG_DBGEN	(BT22_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT23_PWC_BT_DEBUG	(BT23_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT23_PWC_BT_DEBUG_DBGEN	(BT23_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT24_PWC_BT_DEBUG	(BT24_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT24_PWC_BT_DEBUG_DBGEN	(BT24_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT25_PWC_BT_DEBUG	(BT25_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT25_PWC_BT_DEBUG_DBGEN	(BT25_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT26_PWC_BT_DEBUG	(BT26_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT26_PWC_BT_DEBUG_DBGEN	(BT26_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT27_PWC_BT_DEBUG	(BT27_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT27_PWC_BT_DEBUG_DBGEN	(BT27_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT28_PWC_BT_DEBUG	(BT28_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT28_PWC_BT_DEBUG_DBGEN	(BT28_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT29_PWC_BT_DEBUG	(BT29_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT29_PWC_BT_DEBUG_DBGEN	(BT29_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT30_PWC_BT_DEBUG	(BT30_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT30_PWC_BT_DEBUG_DBGEN	(BT30_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

#define BT31_PWC_BT_DEBUG	(BT31_PWC.unBT_DEBUG.u16Register)  /*@rg@*/
#define BT31_PWC_BT_DEBUG_DBGEN	(BT31_PWC.unBT_DEBUG.stcField.u1DBGEN)  /*@bf@*/

typedef struct stc_btn_pwc_bt_debug_field{
    uint_io16_t		u1DBGEN:1;
    uint_io16_t		:15;
}stc_btn_pwc_bt_debug_field_t;

typedef union un_btn_pwc_bt_debug{
    uint_io16_t		u16Register;
    stc_btn_pwc_bt_debug_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_btn_pwc_bt_debug_t;


typedef struct stc_btn_pwc{
    uint_io8_t	au8Reserved0[4];	/* 0x00000000 */
    un_btn_pwc_dtbf_t	unDTBF;	/* 0x00000004 */
    uint_io8_t	au8Reserved1[6];	/* 0x00000006 */
    un_btn_pwc_tmcr_t	unTMCR;	/* 0x0000000C */
    uint_io8_t	au8Reserved2[2];	/* 0x0000000E */
    un_btn_pwc_stc_t	unSTC;	/* 0x00000010 */
    un_btn_pwc_tmcr2_t	unTMCR2;	/* 0x00000011 */
    uint_io8_t	au8Reserved3[2];	/* 0x00000012 */
    un_btn_pwc_stcc_t	unSTCC;	/* 0x00000014 */
    uint_io8_t	au8Reserved4[3];	/* 0x00000015 */
    un_btn_pwc_stcs_t	unSTCS;	/* 0x00000018 */
    uint_io8_t	au8Reserved5[11];	/* 0x00000019 */
    un_btn_pwc_bt_debug_t	unBT_DEBUG;	/* 0x00000024 */
    uint_io8_t	au8Reserved6[10];	/* 0x00000026 */
}stc_btn_pwc_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_btn_pwc_t	stcBT_PWC[32];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 48(0x30) bytes */


#endif /* __S6J3360_BT_PWC_H */
