/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_MFS_UART_H
#define __S6J3360_MFS_UART_H

#include "s6j3360io_basetypes.h"

/* CPG_MFS[00-11]_UART base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CPG_MFS00_UART	stcCPG_MFS_UART[0]
#define CPG_MFS01_UART	stcCPG_MFS_UART[1]
#define CPG_MFS02_UART	stcCPG_MFS_UART[2]
#define CPG_MFS03_UART	stcCPG_MFS_UART[3]
#define CPG_MFS04_UART	stcCPG_MFS_UART[4]
#define CPG_MFS05_UART	stcCPG_MFS_UART[5]
#define CPG_MFS06_UART	stcCPG_MFS_UART[6]
#define CPG_MFS07_UART	stcCPG_MFS_UART[7]
#define CPG_MFS08_UART	stcCPG_MFS_UART[8]
#define CPG_MFS09_UART	stcCPG_MFS_UART[9]
#define CPG_MFS10_UART	stcCPG_MFS_UART[10]
#define CPG_MFS11_UART	stcCPG_MFS_UART[11]
#else /* __IO_DEFINE */
#define CPG_MFS00_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4800000))
#define CPG_MFS01_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4800400))
#define CPG_MFS02_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4800800))
#define CPG_MFS03_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4800C00))
#define CPG_MFS04_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4801000))
#define CPG_MFS05_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4801400))
#define CPG_MFS06_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4801800))
#define CPG_MFS07_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4801C00))
#define CPG_MFS08_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4880000))
#define CPG_MFS09_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4880400))
#define CPG_MFS10_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4880800))
#define CPG_MFS11_UART	(*((volatile stc_cpg_mfsn_uart_t*)0xB4880C00))
#endif /* __IO_DEFINE */

/* SMR */
#define CPG_MFS00_UART_SMR	(CPG_MFS00_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_SMR_SOE	(CPG_MFS00_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS00_UART_SMR_BDS	(CPG_MFS00_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS00_UART_SMR_SBL	(CPG_MFS00_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS00_UART_SMR_WUCR	(CPG_MFS00_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS00_UART_SMR_MD	(CPG_MFS00_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS01_UART_SMR	(CPG_MFS01_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_SMR_SOE	(CPG_MFS01_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS01_UART_SMR_BDS	(CPG_MFS01_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS01_UART_SMR_SBL	(CPG_MFS01_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS01_UART_SMR_WUCR	(CPG_MFS01_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS01_UART_SMR_MD	(CPG_MFS01_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS02_UART_SMR	(CPG_MFS02_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_SMR_SOE	(CPG_MFS02_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS02_UART_SMR_BDS	(CPG_MFS02_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS02_UART_SMR_SBL	(CPG_MFS02_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS02_UART_SMR_WUCR	(CPG_MFS02_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS02_UART_SMR_MD	(CPG_MFS02_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS03_UART_SMR	(CPG_MFS03_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_SMR_SOE	(CPG_MFS03_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS03_UART_SMR_BDS	(CPG_MFS03_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS03_UART_SMR_SBL	(CPG_MFS03_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS03_UART_SMR_WUCR	(CPG_MFS03_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS03_UART_SMR_MD	(CPG_MFS03_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS04_UART_SMR	(CPG_MFS04_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_SMR_SOE	(CPG_MFS04_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS04_UART_SMR_BDS	(CPG_MFS04_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS04_UART_SMR_SBL	(CPG_MFS04_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS04_UART_SMR_WUCR	(CPG_MFS04_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS04_UART_SMR_MD	(CPG_MFS04_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS05_UART_SMR	(CPG_MFS05_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_SMR_SOE	(CPG_MFS05_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS05_UART_SMR_BDS	(CPG_MFS05_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS05_UART_SMR_SBL	(CPG_MFS05_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS05_UART_SMR_WUCR	(CPG_MFS05_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS05_UART_SMR_MD	(CPG_MFS05_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS06_UART_SMR	(CPG_MFS06_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_SMR_SOE	(CPG_MFS06_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS06_UART_SMR_BDS	(CPG_MFS06_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS06_UART_SMR_SBL	(CPG_MFS06_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS06_UART_SMR_WUCR	(CPG_MFS06_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS06_UART_SMR_MD	(CPG_MFS06_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS07_UART_SMR	(CPG_MFS07_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_SMR_SOE	(CPG_MFS07_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS07_UART_SMR_BDS	(CPG_MFS07_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS07_UART_SMR_SBL	(CPG_MFS07_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS07_UART_SMR_WUCR	(CPG_MFS07_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS07_UART_SMR_MD	(CPG_MFS07_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS08_UART_SMR	(CPG_MFS08_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_SMR_SOE	(CPG_MFS08_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS08_UART_SMR_BDS	(CPG_MFS08_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS08_UART_SMR_SBL	(CPG_MFS08_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS08_UART_SMR_WUCR	(CPG_MFS08_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS08_UART_SMR_MD	(CPG_MFS08_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS09_UART_SMR	(CPG_MFS09_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_SMR_SOE	(CPG_MFS09_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS09_UART_SMR_BDS	(CPG_MFS09_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS09_UART_SMR_SBL	(CPG_MFS09_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS09_UART_SMR_WUCR	(CPG_MFS09_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS09_UART_SMR_MD	(CPG_MFS09_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS10_UART_SMR	(CPG_MFS10_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_SMR_SOE	(CPG_MFS10_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS10_UART_SMR_BDS	(CPG_MFS10_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS10_UART_SMR_SBL	(CPG_MFS10_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS10_UART_SMR_WUCR	(CPG_MFS10_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS10_UART_SMR_MD	(CPG_MFS10_UART.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS11_UART_SMR	(CPG_MFS11_UART.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_SMR_SOE	(CPG_MFS11_UART.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS11_UART_SMR_BDS	(CPG_MFS11_UART.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS11_UART_SMR_SBL	(CPG_MFS11_UART.unSMR.stcField.u1SBL)  /*@bf@*/
#define CPG_MFS11_UART_SMR_WUCR	(CPG_MFS11_UART.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS11_UART_SMR_MD	(CPG_MFS11_UART.unSMR.stcField.u3MD)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_smr_field{
    uint_io8_t		u1SOE:1;
    uint_io8_t		:1;
    uint_io8_t		u1BDS:1;
    uint_io8_t		u1SBL:1;
    uint_io8_t		u1WUCR:1;
    uint_io8_t		u3MD:3;
}stc_cpg_mfsn_uart_smr_field_t;

typedef union un_cpg_mfsn_uart_smr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_smr_field_t		stcField;
}un_cpg_mfsn_uart_smr_t;

/* SCR */
#define CPG_MFS00_UART_SCR	(CPG_MFS00_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_SCR_TXE	(CPG_MFS00_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS00_UART_SCR_RXE	(CPG_MFS00_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS00_UART_SCR_TBIE	(CPG_MFS00_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS00_UART_SCR_TIE	(CPG_MFS00_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS00_UART_SCR_RIE	(CPG_MFS00_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS00_UART_SCR_UPCL	(CPG_MFS00_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS01_UART_SCR	(CPG_MFS01_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_SCR_TXE	(CPG_MFS01_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS01_UART_SCR_RXE	(CPG_MFS01_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS01_UART_SCR_TBIE	(CPG_MFS01_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS01_UART_SCR_TIE	(CPG_MFS01_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS01_UART_SCR_RIE	(CPG_MFS01_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS01_UART_SCR_UPCL	(CPG_MFS01_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS02_UART_SCR	(CPG_MFS02_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_SCR_TXE	(CPG_MFS02_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS02_UART_SCR_RXE	(CPG_MFS02_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS02_UART_SCR_TBIE	(CPG_MFS02_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS02_UART_SCR_TIE	(CPG_MFS02_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS02_UART_SCR_RIE	(CPG_MFS02_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS02_UART_SCR_UPCL	(CPG_MFS02_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS03_UART_SCR	(CPG_MFS03_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_SCR_TXE	(CPG_MFS03_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS03_UART_SCR_RXE	(CPG_MFS03_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS03_UART_SCR_TBIE	(CPG_MFS03_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS03_UART_SCR_TIE	(CPG_MFS03_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS03_UART_SCR_RIE	(CPG_MFS03_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS03_UART_SCR_UPCL	(CPG_MFS03_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS04_UART_SCR	(CPG_MFS04_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_SCR_TXE	(CPG_MFS04_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS04_UART_SCR_RXE	(CPG_MFS04_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS04_UART_SCR_TBIE	(CPG_MFS04_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS04_UART_SCR_TIE	(CPG_MFS04_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS04_UART_SCR_RIE	(CPG_MFS04_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS04_UART_SCR_UPCL	(CPG_MFS04_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS05_UART_SCR	(CPG_MFS05_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_SCR_TXE	(CPG_MFS05_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS05_UART_SCR_RXE	(CPG_MFS05_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS05_UART_SCR_TBIE	(CPG_MFS05_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS05_UART_SCR_TIE	(CPG_MFS05_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS05_UART_SCR_RIE	(CPG_MFS05_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS05_UART_SCR_UPCL	(CPG_MFS05_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS06_UART_SCR	(CPG_MFS06_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_SCR_TXE	(CPG_MFS06_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS06_UART_SCR_RXE	(CPG_MFS06_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS06_UART_SCR_TBIE	(CPG_MFS06_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS06_UART_SCR_TIE	(CPG_MFS06_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS06_UART_SCR_RIE	(CPG_MFS06_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS06_UART_SCR_UPCL	(CPG_MFS06_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS07_UART_SCR	(CPG_MFS07_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_SCR_TXE	(CPG_MFS07_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS07_UART_SCR_RXE	(CPG_MFS07_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS07_UART_SCR_TBIE	(CPG_MFS07_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS07_UART_SCR_TIE	(CPG_MFS07_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS07_UART_SCR_RIE	(CPG_MFS07_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS07_UART_SCR_UPCL	(CPG_MFS07_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS08_UART_SCR	(CPG_MFS08_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_SCR_TXE	(CPG_MFS08_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS08_UART_SCR_RXE	(CPG_MFS08_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS08_UART_SCR_TBIE	(CPG_MFS08_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS08_UART_SCR_TIE	(CPG_MFS08_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS08_UART_SCR_RIE	(CPG_MFS08_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS08_UART_SCR_UPCL	(CPG_MFS08_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS09_UART_SCR	(CPG_MFS09_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_SCR_TXE	(CPG_MFS09_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS09_UART_SCR_RXE	(CPG_MFS09_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS09_UART_SCR_TBIE	(CPG_MFS09_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS09_UART_SCR_TIE	(CPG_MFS09_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS09_UART_SCR_RIE	(CPG_MFS09_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS09_UART_SCR_UPCL	(CPG_MFS09_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS10_UART_SCR	(CPG_MFS10_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_SCR_TXE	(CPG_MFS10_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS10_UART_SCR_RXE	(CPG_MFS10_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS10_UART_SCR_TBIE	(CPG_MFS10_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS10_UART_SCR_TIE	(CPG_MFS10_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS10_UART_SCR_RIE	(CPG_MFS10_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS10_UART_SCR_UPCL	(CPG_MFS10_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS11_UART_SCR	(CPG_MFS11_UART.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_SCR_TXE	(CPG_MFS11_UART.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS11_UART_SCR_RXE	(CPG_MFS11_UART.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS11_UART_SCR_TBIE	(CPG_MFS11_UART.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS11_UART_SCR_TIE	(CPG_MFS11_UART.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS11_UART_SCR_RIE	(CPG_MFS11_UART.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS11_UART_SCR_UPCL	(CPG_MFS11_UART.unSCR.stcField.u1UPCL)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_scr_field{
    uint_io8_t		u1TXE:1;
    uint_io8_t		u1RXE:1;
    uint_io8_t		u1TBIE:1;
    uint_io8_t		u1TIE:1;
    uint_io8_t		u1RIE:1;
    uint_io8_t		:2;
    uint_io8_t		u1UPCL:1;
}stc_cpg_mfsn_uart_scr_field_t;

typedef union un_cpg_mfsn_uart_scr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_scr_field_t		stcField;
}un_cpg_mfsn_uart_scr_t;

/* ESCR */
#define CPG_MFS00_UART_ESCR	(CPG_MFS00_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_ESCR_L	(CPG_MFS00_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS00_UART_ESCR_P	(CPG_MFS00_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS00_UART_ESCR_PEN	(CPG_MFS00_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS00_UART_ESCR_INV	(CPG_MFS00_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS00_UART_ESCR_ESBL	(CPG_MFS00_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS00_UART_ESCR_FLWEN	(CPG_MFS00_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS01_UART_ESCR	(CPG_MFS01_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_ESCR_L	(CPG_MFS01_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS01_UART_ESCR_P	(CPG_MFS01_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS01_UART_ESCR_PEN	(CPG_MFS01_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS01_UART_ESCR_INV	(CPG_MFS01_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS01_UART_ESCR_ESBL	(CPG_MFS01_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS01_UART_ESCR_FLWEN	(CPG_MFS01_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS02_UART_ESCR	(CPG_MFS02_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_ESCR_L	(CPG_MFS02_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS02_UART_ESCR_P	(CPG_MFS02_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS02_UART_ESCR_PEN	(CPG_MFS02_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS02_UART_ESCR_INV	(CPG_MFS02_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS02_UART_ESCR_ESBL	(CPG_MFS02_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS02_UART_ESCR_FLWEN	(CPG_MFS02_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS03_UART_ESCR	(CPG_MFS03_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_ESCR_L	(CPG_MFS03_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS03_UART_ESCR_P	(CPG_MFS03_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS03_UART_ESCR_PEN	(CPG_MFS03_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS03_UART_ESCR_INV	(CPG_MFS03_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS03_UART_ESCR_ESBL	(CPG_MFS03_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS03_UART_ESCR_FLWEN	(CPG_MFS03_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS04_UART_ESCR	(CPG_MFS04_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_ESCR_L	(CPG_MFS04_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS04_UART_ESCR_P	(CPG_MFS04_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS04_UART_ESCR_PEN	(CPG_MFS04_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS04_UART_ESCR_INV	(CPG_MFS04_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS04_UART_ESCR_ESBL	(CPG_MFS04_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS04_UART_ESCR_FLWEN	(CPG_MFS04_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS05_UART_ESCR	(CPG_MFS05_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_ESCR_L	(CPG_MFS05_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS05_UART_ESCR_P	(CPG_MFS05_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS05_UART_ESCR_PEN	(CPG_MFS05_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS05_UART_ESCR_INV	(CPG_MFS05_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS05_UART_ESCR_ESBL	(CPG_MFS05_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS05_UART_ESCR_FLWEN	(CPG_MFS05_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS06_UART_ESCR	(CPG_MFS06_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_ESCR_L	(CPG_MFS06_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS06_UART_ESCR_P	(CPG_MFS06_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS06_UART_ESCR_PEN	(CPG_MFS06_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS06_UART_ESCR_INV	(CPG_MFS06_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS06_UART_ESCR_ESBL	(CPG_MFS06_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS06_UART_ESCR_FLWEN	(CPG_MFS06_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS07_UART_ESCR	(CPG_MFS07_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_ESCR_L	(CPG_MFS07_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS07_UART_ESCR_P	(CPG_MFS07_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS07_UART_ESCR_PEN	(CPG_MFS07_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS07_UART_ESCR_INV	(CPG_MFS07_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS07_UART_ESCR_ESBL	(CPG_MFS07_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS07_UART_ESCR_FLWEN	(CPG_MFS07_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS08_UART_ESCR	(CPG_MFS08_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_ESCR_L	(CPG_MFS08_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS08_UART_ESCR_P	(CPG_MFS08_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS08_UART_ESCR_PEN	(CPG_MFS08_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS08_UART_ESCR_INV	(CPG_MFS08_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS08_UART_ESCR_ESBL	(CPG_MFS08_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS08_UART_ESCR_FLWEN	(CPG_MFS08_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS09_UART_ESCR	(CPG_MFS09_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_ESCR_L	(CPG_MFS09_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS09_UART_ESCR_P	(CPG_MFS09_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS09_UART_ESCR_PEN	(CPG_MFS09_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS09_UART_ESCR_INV	(CPG_MFS09_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS09_UART_ESCR_ESBL	(CPG_MFS09_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS09_UART_ESCR_FLWEN	(CPG_MFS09_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS10_UART_ESCR	(CPG_MFS10_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_ESCR_L	(CPG_MFS10_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS10_UART_ESCR_P	(CPG_MFS10_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS10_UART_ESCR_PEN	(CPG_MFS10_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS10_UART_ESCR_INV	(CPG_MFS10_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS10_UART_ESCR_ESBL	(CPG_MFS10_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS10_UART_ESCR_FLWEN	(CPG_MFS10_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

#define CPG_MFS11_UART_ESCR	(CPG_MFS11_UART.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_ESCR_L	(CPG_MFS11_UART.unESCR.stcField.u3L)  /*@bf@*/
#define CPG_MFS11_UART_ESCR_P	(CPG_MFS11_UART.unESCR.stcField.u1P)  /*@bf@*/
#define CPG_MFS11_UART_ESCR_PEN	(CPG_MFS11_UART.unESCR.stcField.u1PEN)  /*@bf@*/
#define CPG_MFS11_UART_ESCR_INV	(CPG_MFS11_UART.unESCR.stcField.u1INV)  /*@bf@*/
#define CPG_MFS11_UART_ESCR_ESBL	(CPG_MFS11_UART.unESCR.stcField.u1ESBL)  /*@bf@*/
#define CPG_MFS11_UART_ESCR_FLWEN	(CPG_MFS11_UART.unESCR.stcField.u1FLWEN)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_escr_field{
    uint_io8_t		u3L:3;
    uint_io8_t		u1P:1;
    uint_io8_t		u1PEN:1;
    uint_io8_t		u1INV:1;
    uint_io8_t		u1ESBL:1;
    uint_io8_t		u1FLWEN:1;
}stc_cpg_mfsn_uart_escr_field_t;

typedef union un_cpg_mfsn_uart_escr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_escr_field_t		stcField;
}un_cpg_mfsn_uart_escr_t;

/* SSR */
#define CPG_MFS00_UART_SSR	(CPG_MFS00_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_SSR_TBI	(CPG_MFS00_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS00_UART_SSR_TDRE	(CPG_MFS00_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS00_UART_SSR_RDRF	(CPG_MFS00_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS00_UART_SSR_ORE	(CPG_MFS00_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS00_UART_SSR_FRE	(CPG_MFS00_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS00_UART_SSR_PE	(CPG_MFS00_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS00_UART_SSR_REC	(CPG_MFS00_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS01_UART_SSR	(CPG_MFS01_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_SSR_TBI	(CPG_MFS01_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS01_UART_SSR_TDRE	(CPG_MFS01_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS01_UART_SSR_RDRF	(CPG_MFS01_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS01_UART_SSR_ORE	(CPG_MFS01_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS01_UART_SSR_FRE	(CPG_MFS01_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS01_UART_SSR_PE	(CPG_MFS01_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS01_UART_SSR_REC	(CPG_MFS01_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS02_UART_SSR	(CPG_MFS02_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_SSR_TBI	(CPG_MFS02_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS02_UART_SSR_TDRE	(CPG_MFS02_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS02_UART_SSR_RDRF	(CPG_MFS02_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS02_UART_SSR_ORE	(CPG_MFS02_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS02_UART_SSR_FRE	(CPG_MFS02_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS02_UART_SSR_PE	(CPG_MFS02_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS02_UART_SSR_REC	(CPG_MFS02_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS03_UART_SSR	(CPG_MFS03_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_SSR_TBI	(CPG_MFS03_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS03_UART_SSR_TDRE	(CPG_MFS03_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS03_UART_SSR_RDRF	(CPG_MFS03_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS03_UART_SSR_ORE	(CPG_MFS03_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS03_UART_SSR_FRE	(CPG_MFS03_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS03_UART_SSR_PE	(CPG_MFS03_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS03_UART_SSR_REC	(CPG_MFS03_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS04_UART_SSR	(CPG_MFS04_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_SSR_TBI	(CPG_MFS04_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS04_UART_SSR_TDRE	(CPG_MFS04_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS04_UART_SSR_RDRF	(CPG_MFS04_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS04_UART_SSR_ORE	(CPG_MFS04_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS04_UART_SSR_FRE	(CPG_MFS04_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS04_UART_SSR_PE	(CPG_MFS04_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS04_UART_SSR_REC	(CPG_MFS04_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS05_UART_SSR	(CPG_MFS05_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_SSR_TBI	(CPG_MFS05_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS05_UART_SSR_TDRE	(CPG_MFS05_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS05_UART_SSR_RDRF	(CPG_MFS05_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS05_UART_SSR_ORE	(CPG_MFS05_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS05_UART_SSR_FRE	(CPG_MFS05_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS05_UART_SSR_PE	(CPG_MFS05_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS05_UART_SSR_REC	(CPG_MFS05_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS06_UART_SSR	(CPG_MFS06_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_SSR_TBI	(CPG_MFS06_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS06_UART_SSR_TDRE	(CPG_MFS06_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS06_UART_SSR_RDRF	(CPG_MFS06_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS06_UART_SSR_ORE	(CPG_MFS06_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS06_UART_SSR_FRE	(CPG_MFS06_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS06_UART_SSR_PE	(CPG_MFS06_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS06_UART_SSR_REC	(CPG_MFS06_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS07_UART_SSR	(CPG_MFS07_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_SSR_TBI	(CPG_MFS07_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS07_UART_SSR_TDRE	(CPG_MFS07_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS07_UART_SSR_RDRF	(CPG_MFS07_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS07_UART_SSR_ORE	(CPG_MFS07_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS07_UART_SSR_FRE	(CPG_MFS07_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS07_UART_SSR_PE	(CPG_MFS07_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS07_UART_SSR_REC	(CPG_MFS07_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS08_UART_SSR	(CPG_MFS08_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_SSR_TBI	(CPG_MFS08_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS08_UART_SSR_TDRE	(CPG_MFS08_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS08_UART_SSR_RDRF	(CPG_MFS08_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS08_UART_SSR_ORE	(CPG_MFS08_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS08_UART_SSR_FRE	(CPG_MFS08_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS08_UART_SSR_PE	(CPG_MFS08_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS08_UART_SSR_REC	(CPG_MFS08_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS09_UART_SSR	(CPG_MFS09_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_SSR_TBI	(CPG_MFS09_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS09_UART_SSR_TDRE	(CPG_MFS09_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS09_UART_SSR_RDRF	(CPG_MFS09_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS09_UART_SSR_ORE	(CPG_MFS09_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS09_UART_SSR_FRE	(CPG_MFS09_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS09_UART_SSR_PE	(CPG_MFS09_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS09_UART_SSR_REC	(CPG_MFS09_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS10_UART_SSR	(CPG_MFS10_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_SSR_TBI	(CPG_MFS10_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS10_UART_SSR_TDRE	(CPG_MFS10_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS10_UART_SSR_RDRF	(CPG_MFS10_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS10_UART_SSR_ORE	(CPG_MFS10_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS10_UART_SSR_FRE	(CPG_MFS10_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS10_UART_SSR_PE	(CPG_MFS10_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS10_UART_SSR_REC	(CPG_MFS10_UART.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS11_UART_SSR	(CPG_MFS11_UART.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_SSR_TBI	(CPG_MFS11_UART.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS11_UART_SSR_TDRE	(CPG_MFS11_UART.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS11_UART_SSR_RDRF	(CPG_MFS11_UART.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS11_UART_SSR_ORE	(CPG_MFS11_UART.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS11_UART_SSR_FRE	(CPG_MFS11_UART.unSSR.stcField.u1FRE)  /*@bf@*/
#define CPG_MFS11_UART_SSR_PE	(CPG_MFS11_UART.unSSR.stcField.u1PE)  /*@bf@*/
#define CPG_MFS11_UART_SSR_REC	(CPG_MFS11_UART.unSSR.stcField.u1REC)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_ssr_field{
    uint_io8_t		u1TBI:1;
    uint_io8_t		u1TDRE:1;
    uint_io8_t		u1RDRF:1;
    uint_io8_t		u1ORE:1;
    uint_io8_t		u1FRE:1;
    uint_io8_t		u1PE:1;
    uint_io8_t		:1;
    uint_io8_t		u1REC:1;
}stc_cpg_mfsn_uart_ssr_field_t;

typedef union un_cpg_mfsn_uart_ssr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_ssr_field_t		stcField;
}un_cpg_mfsn_uart_ssr_t;

/* RDR */
#define CPG_MFS00_UART_RDR	(CPG_MFS00_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_TDR	(CPG_MFS00_UART_RDR)  /*@rg2@*/
#define CPG_MFS00_UART_RDR_0	(CPG_MFS00_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS00_UART_TDR_0	(CPG_MFS00_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS00_UART_RDR_D	(CPG_MFS00_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS00_UART_TDR_D	CPG_MFS00_UART_RDR_D  /*@bf2@*/

#define CPG_MFS01_UART_RDR	(CPG_MFS01_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_TDR	(CPG_MFS01_UART_RDR)  /*@rg2@*/
#define CPG_MFS01_UART_RDR_0	(CPG_MFS01_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS01_UART_TDR_0	(CPG_MFS01_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS01_UART_RDR_D	(CPG_MFS01_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS01_UART_TDR_D	CPG_MFS01_UART_RDR_D  /*@bf2@*/

#define CPG_MFS02_UART_RDR	(CPG_MFS02_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_TDR	(CPG_MFS02_UART_RDR)  /*@rg2@*/
#define CPG_MFS02_UART_RDR_0	(CPG_MFS02_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS02_UART_TDR_0	(CPG_MFS02_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS02_UART_RDR_D	(CPG_MFS02_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS02_UART_TDR_D	CPG_MFS02_UART_RDR_D  /*@bf2@*/

#define CPG_MFS03_UART_RDR	(CPG_MFS03_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_TDR	(CPG_MFS03_UART_RDR)  /*@rg2@*/
#define CPG_MFS03_UART_RDR_0	(CPG_MFS03_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS03_UART_TDR_0	(CPG_MFS03_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS03_UART_RDR_D	(CPG_MFS03_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS03_UART_TDR_D	CPG_MFS03_UART_RDR_D  /*@bf2@*/

#define CPG_MFS04_UART_RDR	(CPG_MFS04_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_TDR	(CPG_MFS04_UART_RDR)  /*@rg2@*/
#define CPG_MFS04_UART_RDR_0	(CPG_MFS04_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS04_UART_TDR_0	(CPG_MFS04_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS04_UART_RDR_D	(CPG_MFS04_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS04_UART_TDR_D	CPG_MFS04_UART_RDR_D  /*@bf2@*/

#define CPG_MFS05_UART_RDR	(CPG_MFS05_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_TDR	(CPG_MFS05_UART_RDR)  /*@rg2@*/
#define CPG_MFS05_UART_RDR_0	(CPG_MFS05_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS05_UART_TDR_0	(CPG_MFS05_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS05_UART_RDR_D	(CPG_MFS05_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS05_UART_TDR_D	CPG_MFS05_UART_RDR_D  /*@bf2@*/

#define CPG_MFS06_UART_RDR	(CPG_MFS06_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_TDR	(CPG_MFS06_UART_RDR)  /*@rg2@*/
#define CPG_MFS06_UART_RDR_0	(CPG_MFS06_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS06_UART_TDR_0	(CPG_MFS06_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS06_UART_RDR_D	(CPG_MFS06_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS06_UART_TDR_D	CPG_MFS06_UART_RDR_D  /*@bf2@*/

#define CPG_MFS07_UART_RDR	(CPG_MFS07_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_TDR	(CPG_MFS07_UART_RDR)  /*@rg2@*/
#define CPG_MFS07_UART_RDR_0	(CPG_MFS07_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS07_UART_TDR_0	(CPG_MFS07_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS07_UART_RDR_D	(CPG_MFS07_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS07_UART_TDR_D	CPG_MFS07_UART_RDR_D  /*@bf2@*/

#define CPG_MFS08_UART_RDR	(CPG_MFS08_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_TDR	(CPG_MFS08_UART_RDR)  /*@rg2@*/
#define CPG_MFS08_UART_RDR_0	(CPG_MFS08_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS08_UART_TDR_0	(CPG_MFS08_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS08_UART_RDR_D	(CPG_MFS08_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS08_UART_TDR_D	CPG_MFS08_UART_RDR_D  /*@bf2@*/

#define CPG_MFS09_UART_RDR	(CPG_MFS09_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_TDR	(CPG_MFS09_UART_RDR)  /*@rg2@*/
#define CPG_MFS09_UART_RDR_0	(CPG_MFS09_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS09_UART_TDR_0	(CPG_MFS09_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS09_UART_RDR_D	(CPG_MFS09_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS09_UART_TDR_D	CPG_MFS09_UART_RDR_D  /*@bf2@*/

#define CPG_MFS10_UART_RDR	(CPG_MFS10_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_TDR	(CPG_MFS10_UART_RDR)  /*@rg2@*/
#define CPG_MFS10_UART_RDR_0	(CPG_MFS10_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS10_UART_TDR_0	(CPG_MFS10_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS10_UART_RDR_D	(CPG_MFS10_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS10_UART_TDR_D	CPG_MFS10_UART_RDR_D  /*@bf2@*/

#define CPG_MFS11_UART_RDR	(CPG_MFS11_UART.unRDR.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_TDR	(CPG_MFS11_UART_RDR)  /*@rg2@*/
#define CPG_MFS11_UART_RDR_0	(CPG_MFS11_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS11_UART_TDR_0	(CPG_MFS11_UART.unRDR.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS11_UART_RDR_D	(CPG_MFS11_UART.unRDR.stcField.u9D)  /*@bf@*/
#define CPG_MFS11_UART_TDR_D	CPG_MFS11_UART_RDR_D  /*@bf2@*/

typedef struct stc_cpg_mfsn_uart_rdr_field{
    uint_io16_t		u9D:9;
    uint_io16_t		:7;
}stc_cpg_mfsn_uart_rdr_field_t;

typedef union un_cpg_mfsn_uart_rdr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_uart_rdr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_rdr_t;

/* SACSR */
#define CPG_MFS00_UART_SACSR	(CPG_MFS00_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_SACSR_TMRE	(CPG_MFS00_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS00_UART_SACSR_TDIV	(CPG_MFS00_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS00_UART_SACSR_TRGE	(CPG_MFS00_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS00_UART_SACSR_TSYNE	(CPG_MFS00_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS00_UART_SACSR_TINTE	(CPG_MFS00_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS00_UART_SACSR_TINT	(CPG_MFS00_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS00_UART_SACSR_TRG	(CPG_MFS00_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS00_UART_SACSR_STST	(CPG_MFS00_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS01_UART_SACSR	(CPG_MFS01_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_SACSR_TMRE	(CPG_MFS01_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS01_UART_SACSR_TDIV	(CPG_MFS01_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS01_UART_SACSR_TRGE	(CPG_MFS01_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS01_UART_SACSR_TSYNE	(CPG_MFS01_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS01_UART_SACSR_TINTE	(CPG_MFS01_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS01_UART_SACSR_TINT	(CPG_MFS01_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS01_UART_SACSR_TRG	(CPG_MFS01_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS01_UART_SACSR_STST	(CPG_MFS01_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS02_UART_SACSR	(CPG_MFS02_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_SACSR_TMRE	(CPG_MFS02_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS02_UART_SACSR_TDIV	(CPG_MFS02_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS02_UART_SACSR_TRGE	(CPG_MFS02_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS02_UART_SACSR_TSYNE	(CPG_MFS02_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS02_UART_SACSR_TINTE	(CPG_MFS02_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS02_UART_SACSR_TINT	(CPG_MFS02_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS02_UART_SACSR_TRG	(CPG_MFS02_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS02_UART_SACSR_STST	(CPG_MFS02_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS03_UART_SACSR	(CPG_MFS03_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_SACSR_TMRE	(CPG_MFS03_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS03_UART_SACSR_TDIV	(CPG_MFS03_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS03_UART_SACSR_TRGE	(CPG_MFS03_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS03_UART_SACSR_TSYNE	(CPG_MFS03_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS03_UART_SACSR_TINTE	(CPG_MFS03_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS03_UART_SACSR_TINT	(CPG_MFS03_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS03_UART_SACSR_TRG	(CPG_MFS03_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS03_UART_SACSR_STST	(CPG_MFS03_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS04_UART_SACSR	(CPG_MFS04_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_SACSR_TMRE	(CPG_MFS04_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS04_UART_SACSR_TDIV	(CPG_MFS04_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS04_UART_SACSR_TRGE	(CPG_MFS04_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS04_UART_SACSR_TSYNE	(CPG_MFS04_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS04_UART_SACSR_TINTE	(CPG_MFS04_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS04_UART_SACSR_TINT	(CPG_MFS04_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS04_UART_SACSR_TRG	(CPG_MFS04_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS04_UART_SACSR_STST	(CPG_MFS04_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS05_UART_SACSR	(CPG_MFS05_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_SACSR_TMRE	(CPG_MFS05_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS05_UART_SACSR_TDIV	(CPG_MFS05_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS05_UART_SACSR_TRGE	(CPG_MFS05_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS05_UART_SACSR_TSYNE	(CPG_MFS05_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS05_UART_SACSR_TINTE	(CPG_MFS05_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS05_UART_SACSR_TINT	(CPG_MFS05_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS05_UART_SACSR_TRG	(CPG_MFS05_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS05_UART_SACSR_STST	(CPG_MFS05_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS06_UART_SACSR	(CPG_MFS06_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_SACSR_TMRE	(CPG_MFS06_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS06_UART_SACSR_TDIV	(CPG_MFS06_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS06_UART_SACSR_TRGE	(CPG_MFS06_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS06_UART_SACSR_TSYNE	(CPG_MFS06_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS06_UART_SACSR_TINTE	(CPG_MFS06_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS06_UART_SACSR_TINT	(CPG_MFS06_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS06_UART_SACSR_TRG	(CPG_MFS06_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS06_UART_SACSR_STST	(CPG_MFS06_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS07_UART_SACSR	(CPG_MFS07_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_SACSR_TMRE	(CPG_MFS07_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS07_UART_SACSR_TDIV	(CPG_MFS07_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS07_UART_SACSR_TRGE	(CPG_MFS07_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS07_UART_SACSR_TSYNE	(CPG_MFS07_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS07_UART_SACSR_TINTE	(CPG_MFS07_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS07_UART_SACSR_TINT	(CPG_MFS07_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS07_UART_SACSR_TRG	(CPG_MFS07_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS07_UART_SACSR_STST	(CPG_MFS07_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS08_UART_SACSR	(CPG_MFS08_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_SACSR_TMRE	(CPG_MFS08_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS08_UART_SACSR_TDIV	(CPG_MFS08_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS08_UART_SACSR_TRGE	(CPG_MFS08_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS08_UART_SACSR_TSYNE	(CPG_MFS08_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS08_UART_SACSR_TINTE	(CPG_MFS08_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS08_UART_SACSR_TINT	(CPG_MFS08_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS08_UART_SACSR_TRG	(CPG_MFS08_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS08_UART_SACSR_STST	(CPG_MFS08_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS09_UART_SACSR	(CPG_MFS09_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_SACSR_TMRE	(CPG_MFS09_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS09_UART_SACSR_TDIV	(CPG_MFS09_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS09_UART_SACSR_TRGE	(CPG_MFS09_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS09_UART_SACSR_TSYNE	(CPG_MFS09_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS09_UART_SACSR_TINTE	(CPG_MFS09_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS09_UART_SACSR_TINT	(CPG_MFS09_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS09_UART_SACSR_TRG	(CPG_MFS09_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS09_UART_SACSR_STST	(CPG_MFS09_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS10_UART_SACSR	(CPG_MFS10_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_SACSR_TMRE	(CPG_MFS10_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS10_UART_SACSR_TDIV	(CPG_MFS10_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS10_UART_SACSR_TRGE	(CPG_MFS10_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS10_UART_SACSR_TSYNE	(CPG_MFS10_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS10_UART_SACSR_TINTE	(CPG_MFS10_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS10_UART_SACSR_TINT	(CPG_MFS10_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS10_UART_SACSR_TRG	(CPG_MFS10_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS10_UART_SACSR_STST	(CPG_MFS10_UART.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS11_UART_SACSR	(CPG_MFS11_UART.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_SACSR_TMRE	(CPG_MFS11_UART.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS11_UART_SACSR_TDIV	(CPG_MFS11_UART.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS11_UART_SACSR_TRGE	(CPG_MFS11_UART.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS11_UART_SACSR_TSYNE	(CPG_MFS11_UART.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS11_UART_SACSR_TINTE	(CPG_MFS11_UART.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS11_UART_SACSR_TINT	(CPG_MFS11_UART.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS11_UART_SACSR_TRG	(CPG_MFS11_UART.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS11_UART_SACSR_STST	(CPG_MFS11_UART.unSACSR.stcField.u1STST)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_sacsr_field{
    uint_io16_t		u1TMRE:1;
    uint_io16_t		u4TDIV:4;
    uint_io16_t		u1TRGE:1;
    uint_io16_t		u1TSYNE:1;
    uint_io16_t		u1TINTE:1;
    uint_io16_t		u1TINT:1;
    uint_io16_t		u2TRG:2;
    uint_io16_t		:4;
    uint_io16_t		u1STST:1;
}stc_cpg_mfsn_uart_sacsr_field_t;

typedef union un_cpg_mfsn_uart_sacsr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_uart_sacsr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_sacsr_t;

/* STMR */
#define CPG_MFS00_UART_STMR	(CPG_MFS00_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_STMR_TM	CPG_MFS00_UART_STMR  /*@bfrg@*/

#define CPG_MFS01_UART_STMR	(CPG_MFS01_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_STMR_TM	CPG_MFS01_UART_STMR  /*@bfrg@*/

#define CPG_MFS02_UART_STMR	(CPG_MFS02_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_STMR_TM	CPG_MFS02_UART_STMR  /*@bfrg@*/

#define CPG_MFS03_UART_STMR	(CPG_MFS03_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_STMR_TM	CPG_MFS03_UART_STMR  /*@bfrg@*/

#define CPG_MFS04_UART_STMR	(CPG_MFS04_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_STMR_TM	CPG_MFS04_UART_STMR  /*@bfrg@*/

#define CPG_MFS05_UART_STMR	(CPG_MFS05_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_STMR_TM	CPG_MFS05_UART_STMR  /*@bfrg@*/

#define CPG_MFS06_UART_STMR	(CPG_MFS06_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_STMR_TM	CPG_MFS06_UART_STMR  /*@bfrg@*/

#define CPG_MFS07_UART_STMR	(CPG_MFS07_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_STMR_TM	CPG_MFS07_UART_STMR  /*@bfrg@*/

#define CPG_MFS08_UART_STMR	(CPG_MFS08_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_STMR_TM	CPG_MFS08_UART_STMR  /*@bfrg@*/

#define CPG_MFS09_UART_STMR	(CPG_MFS09_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_STMR_TM	CPG_MFS09_UART_STMR  /*@bfrg@*/

#define CPG_MFS10_UART_STMR	(CPG_MFS10_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_STMR_TM	CPG_MFS10_UART_STMR  /*@bfrg@*/

#define CPG_MFS11_UART_STMR	(CPG_MFS11_UART.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_STMR_TM	CPG_MFS11_UART_STMR  /*@bfrg@*/

typedef union un_cpg_mfsn_uart_stmr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_stmr_t;

/* STMCR */
#define CPG_MFS00_UART_STMCR	(CPG_MFS00_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_STMCR_TC	CPG_MFS00_UART_STMCR  /*@bfrg@*/

#define CPG_MFS01_UART_STMCR	(CPG_MFS01_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_STMCR_TC	CPG_MFS01_UART_STMCR  /*@bfrg@*/

#define CPG_MFS02_UART_STMCR	(CPG_MFS02_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_STMCR_TC	CPG_MFS02_UART_STMCR  /*@bfrg@*/

#define CPG_MFS03_UART_STMCR	(CPG_MFS03_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_STMCR_TC	CPG_MFS03_UART_STMCR  /*@bfrg@*/

#define CPG_MFS04_UART_STMCR	(CPG_MFS04_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_STMCR_TC	CPG_MFS04_UART_STMCR  /*@bfrg@*/

#define CPG_MFS05_UART_STMCR	(CPG_MFS05_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_STMCR_TC	CPG_MFS05_UART_STMCR  /*@bfrg@*/

#define CPG_MFS06_UART_STMCR	(CPG_MFS06_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_STMCR_TC	CPG_MFS06_UART_STMCR  /*@bfrg@*/

#define CPG_MFS07_UART_STMCR	(CPG_MFS07_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_STMCR_TC	CPG_MFS07_UART_STMCR  /*@bfrg@*/

#define CPG_MFS08_UART_STMCR	(CPG_MFS08_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_STMCR_TC	CPG_MFS08_UART_STMCR  /*@bfrg@*/

#define CPG_MFS09_UART_STMCR	(CPG_MFS09_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_STMCR_TC	CPG_MFS09_UART_STMCR  /*@bfrg@*/

#define CPG_MFS10_UART_STMCR	(CPG_MFS10_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_STMCR_TC	CPG_MFS10_UART_STMCR  /*@bfrg@*/

#define CPG_MFS11_UART_STMCR	(CPG_MFS11_UART.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_STMCR_TC	CPG_MFS11_UART_STMCR  /*@bfrg@*/

typedef union un_cpg_mfsn_uart_stmcr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_stmcr_t;

/* TBYTE0 */
#define CPG_MFS00_UART_TBYTE0	(CPG_MFS00_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_TBYTE0_TBYTE0	CPG_MFS00_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS01_UART_TBYTE0	(CPG_MFS01_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_TBYTE0_TBYTE0	CPG_MFS01_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS02_UART_TBYTE0	(CPG_MFS02_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_TBYTE0_TBYTE0	CPG_MFS02_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS03_UART_TBYTE0	(CPG_MFS03_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_TBYTE0_TBYTE0	CPG_MFS03_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS04_UART_TBYTE0	(CPG_MFS04_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_TBYTE0_TBYTE0	CPG_MFS04_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS05_UART_TBYTE0	(CPG_MFS05_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_TBYTE0_TBYTE0	CPG_MFS05_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS06_UART_TBYTE0	(CPG_MFS06_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_TBYTE0_TBYTE0	CPG_MFS06_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS07_UART_TBYTE0	(CPG_MFS07_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_TBYTE0_TBYTE0	CPG_MFS07_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS08_UART_TBYTE0	(CPG_MFS08_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_TBYTE0_TBYTE0	CPG_MFS08_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS09_UART_TBYTE0	(CPG_MFS09_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_TBYTE0_TBYTE0	CPG_MFS09_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS10_UART_TBYTE0	(CPG_MFS10_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_TBYTE0_TBYTE0	CPG_MFS10_UART_TBYTE0  /*@bfrg@*/

#define CPG_MFS11_UART_TBYTE0	(CPG_MFS11_UART.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_TBYTE0_TBYTE0	CPG_MFS11_UART_TBYTE0  /*@bfrg@*/

typedef union un_cpg_mfsn_uart_tbyte0{
    uint_io8_t		u8Register;
}un_cpg_mfsn_uart_tbyte0_t;

/* BGR */
#define CPG_MFS00_UART_BGR	(CPG_MFS00_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_BGR_BGR	(CPG_MFS00_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS00_UART_BGR_EXT	(CPG_MFS00_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS01_UART_BGR	(CPG_MFS01_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_BGR_BGR	(CPG_MFS01_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS01_UART_BGR_EXT	(CPG_MFS01_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS02_UART_BGR	(CPG_MFS02_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_BGR_BGR	(CPG_MFS02_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS02_UART_BGR_EXT	(CPG_MFS02_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS03_UART_BGR	(CPG_MFS03_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_BGR_BGR	(CPG_MFS03_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS03_UART_BGR_EXT	(CPG_MFS03_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS04_UART_BGR	(CPG_MFS04_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_BGR_BGR	(CPG_MFS04_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS04_UART_BGR_EXT	(CPG_MFS04_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS05_UART_BGR	(CPG_MFS05_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_BGR_BGR	(CPG_MFS05_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS05_UART_BGR_EXT	(CPG_MFS05_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS06_UART_BGR	(CPG_MFS06_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_BGR_BGR	(CPG_MFS06_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS06_UART_BGR_EXT	(CPG_MFS06_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS07_UART_BGR	(CPG_MFS07_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_BGR_BGR	(CPG_MFS07_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS07_UART_BGR_EXT	(CPG_MFS07_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS08_UART_BGR	(CPG_MFS08_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_BGR_BGR	(CPG_MFS08_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS08_UART_BGR_EXT	(CPG_MFS08_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS09_UART_BGR	(CPG_MFS09_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_BGR_BGR	(CPG_MFS09_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS09_UART_BGR_EXT	(CPG_MFS09_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS10_UART_BGR	(CPG_MFS10_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_BGR_BGR	(CPG_MFS10_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS10_UART_BGR_EXT	(CPG_MFS10_UART.unBGR.stcField.u1EXT)  /*@bf@*/

#define CPG_MFS11_UART_BGR	(CPG_MFS11_UART.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_BGR_BGR	(CPG_MFS11_UART.unBGR.stcField.u15BGR)  /*@bf@*/
#define CPG_MFS11_UART_BGR_EXT	(CPG_MFS11_UART.unBGR.stcField.u1EXT)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_bgr_field{
    uint_io16_t		u15BGR:15;
    uint_io16_t		u1EXT:1;
}stc_cpg_mfsn_uart_bgr_field_t;

typedef union un_cpg_mfsn_uart_bgr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_uart_bgr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_bgr_t;

/* FCR0 */
#define CPG_MFS00_UART_FCR0	(CPG_MFS00_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_FCR0_FE1	(CPG_MFS00_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS00_UART_FCR0_FE2	(CPG_MFS00_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS00_UART_FCR0_FCL1	(CPG_MFS00_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS00_UART_FCR0_FCL2	(CPG_MFS00_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS00_UART_FCR0_FSET	(CPG_MFS00_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS00_UART_FCR0_FLD	(CPG_MFS00_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS00_UART_FCR0_FLST	(CPG_MFS00_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS01_UART_FCR0	(CPG_MFS01_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_FCR0_FE1	(CPG_MFS01_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS01_UART_FCR0_FE2	(CPG_MFS01_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS01_UART_FCR0_FCL1	(CPG_MFS01_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS01_UART_FCR0_FCL2	(CPG_MFS01_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS01_UART_FCR0_FSET	(CPG_MFS01_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS01_UART_FCR0_FLD	(CPG_MFS01_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS01_UART_FCR0_FLST	(CPG_MFS01_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS02_UART_FCR0	(CPG_MFS02_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_FCR0_FE1	(CPG_MFS02_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS02_UART_FCR0_FE2	(CPG_MFS02_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS02_UART_FCR0_FCL1	(CPG_MFS02_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS02_UART_FCR0_FCL2	(CPG_MFS02_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS02_UART_FCR0_FSET	(CPG_MFS02_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS02_UART_FCR0_FLD	(CPG_MFS02_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS02_UART_FCR0_FLST	(CPG_MFS02_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS03_UART_FCR0	(CPG_MFS03_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_FCR0_FE1	(CPG_MFS03_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS03_UART_FCR0_FE2	(CPG_MFS03_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS03_UART_FCR0_FCL1	(CPG_MFS03_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS03_UART_FCR0_FCL2	(CPG_MFS03_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS03_UART_FCR0_FSET	(CPG_MFS03_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS03_UART_FCR0_FLD	(CPG_MFS03_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS03_UART_FCR0_FLST	(CPG_MFS03_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS04_UART_FCR0	(CPG_MFS04_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_FCR0_FE1	(CPG_MFS04_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS04_UART_FCR0_FE2	(CPG_MFS04_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS04_UART_FCR0_FCL1	(CPG_MFS04_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS04_UART_FCR0_FCL2	(CPG_MFS04_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS04_UART_FCR0_FSET	(CPG_MFS04_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS04_UART_FCR0_FLD	(CPG_MFS04_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS04_UART_FCR0_FLST	(CPG_MFS04_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS05_UART_FCR0	(CPG_MFS05_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_FCR0_FE1	(CPG_MFS05_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS05_UART_FCR0_FE2	(CPG_MFS05_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS05_UART_FCR0_FCL1	(CPG_MFS05_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS05_UART_FCR0_FCL2	(CPG_MFS05_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS05_UART_FCR0_FSET	(CPG_MFS05_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS05_UART_FCR0_FLD	(CPG_MFS05_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS05_UART_FCR0_FLST	(CPG_MFS05_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS06_UART_FCR0	(CPG_MFS06_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_FCR0_FE1	(CPG_MFS06_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS06_UART_FCR0_FE2	(CPG_MFS06_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS06_UART_FCR0_FCL1	(CPG_MFS06_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS06_UART_FCR0_FCL2	(CPG_MFS06_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS06_UART_FCR0_FSET	(CPG_MFS06_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS06_UART_FCR0_FLD	(CPG_MFS06_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS06_UART_FCR0_FLST	(CPG_MFS06_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS07_UART_FCR0	(CPG_MFS07_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_FCR0_FE1	(CPG_MFS07_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS07_UART_FCR0_FE2	(CPG_MFS07_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS07_UART_FCR0_FCL1	(CPG_MFS07_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS07_UART_FCR0_FCL2	(CPG_MFS07_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS07_UART_FCR0_FSET	(CPG_MFS07_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS07_UART_FCR0_FLD	(CPG_MFS07_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS07_UART_FCR0_FLST	(CPG_MFS07_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS08_UART_FCR0	(CPG_MFS08_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_FCR0_FE1	(CPG_MFS08_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS08_UART_FCR0_FE2	(CPG_MFS08_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS08_UART_FCR0_FCL1	(CPG_MFS08_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS08_UART_FCR0_FCL2	(CPG_MFS08_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS08_UART_FCR0_FSET	(CPG_MFS08_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS08_UART_FCR0_FLD	(CPG_MFS08_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS08_UART_FCR0_FLST	(CPG_MFS08_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS09_UART_FCR0	(CPG_MFS09_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_FCR0_FE1	(CPG_MFS09_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS09_UART_FCR0_FE2	(CPG_MFS09_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS09_UART_FCR0_FCL1	(CPG_MFS09_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS09_UART_FCR0_FCL2	(CPG_MFS09_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS09_UART_FCR0_FSET	(CPG_MFS09_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS09_UART_FCR0_FLD	(CPG_MFS09_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS09_UART_FCR0_FLST	(CPG_MFS09_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS10_UART_FCR0	(CPG_MFS10_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_FCR0_FE1	(CPG_MFS10_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS10_UART_FCR0_FE2	(CPG_MFS10_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS10_UART_FCR0_FCL1	(CPG_MFS10_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS10_UART_FCR0_FCL2	(CPG_MFS10_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS10_UART_FCR0_FSET	(CPG_MFS10_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS10_UART_FCR0_FLD	(CPG_MFS10_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS10_UART_FCR0_FLST	(CPG_MFS10_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS11_UART_FCR0	(CPG_MFS11_UART.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_FCR0_FE1	(CPG_MFS11_UART.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS11_UART_FCR0_FE2	(CPG_MFS11_UART.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS11_UART_FCR0_FCL1	(CPG_MFS11_UART.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS11_UART_FCR0_FCL2	(CPG_MFS11_UART.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS11_UART_FCR0_FSET	(CPG_MFS11_UART.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS11_UART_FCR0_FLD	(CPG_MFS11_UART.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS11_UART_FCR0_FLST	(CPG_MFS11_UART.unFCR0.stcField.u1FLST)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_fcr0_field{
    uint_io8_t		u1FE1:1;
    uint_io8_t		u1FE2:1;
    uint_io8_t		u1FCL1:1;
    uint_io8_t		u1FCL2:1;
    uint_io8_t		u1FSET:1;
    uint_io8_t		u1FLD:1;
    uint_io8_t		u1FLST:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_uart_fcr0_field_t;

typedef union un_cpg_mfsn_uart_fcr0{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_fcr0_field_t		stcField;
}un_cpg_mfsn_uart_fcr0_t;

/* FCR1 */
#define CPG_MFS00_UART_FCR1	(CPG_MFS00_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_FCR1_FSEL	(CPG_MFS00_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS00_UART_FCR1_FTIE	(CPG_MFS00_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS00_UART_FCR1_FDRQ	(CPG_MFS00_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS00_UART_FCR1_FRIIE	(CPG_MFS00_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS00_UART_FCR1_FLSTE	(CPG_MFS00_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS01_UART_FCR1	(CPG_MFS01_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_FCR1_FSEL	(CPG_MFS01_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS01_UART_FCR1_FTIE	(CPG_MFS01_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS01_UART_FCR1_FDRQ	(CPG_MFS01_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS01_UART_FCR1_FRIIE	(CPG_MFS01_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS01_UART_FCR1_FLSTE	(CPG_MFS01_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS02_UART_FCR1	(CPG_MFS02_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_FCR1_FSEL	(CPG_MFS02_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS02_UART_FCR1_FTIE	(CPG_MFS02_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS02_UART_FCR1_FDRQ	(CPG_MFS02_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS02_UART_FCR1_FRIIE	(CPG_MFS02_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS02_UART_FCR1_FLSTE	(CPG_MFS02_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS03_UART_FCR1	(CPG_MFS03_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_FCR1_FSEL	(CPG_MFS03_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS03_UART_FCR1_FTIE	(CPG_MFS03_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS03_UART_FCR1_FDRQ	(CPG_MFS03_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS03_UART_FCR1_FRIIE	(CPG_MFS03_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS03_UART_FCR1_FLSTE	(CPG_MFS03_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS04_UART_FCR1	(CPG_MFS04_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_FCR1_FSEL	(CPG_MFS04_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS04_UART_FCR1_FTIE	(CPG_MFS04_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS04_UART_FCR1_FDRQ	(CPG_MFS04_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS04_UART_FCR1_FRIIE	(CPG_MFS04_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS04_UART_FCR1_FLSTE	(CPG_MFS04_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS05_UART_FCR1	(CPG_MFS05_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_FCR1_FSEL	(CPG_MFS05_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS05_UART_FCR1_FTIE	(CPG_MFS05_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS05_UART_FCR1_FDRQ	(CPG_MFS05_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS05_UART_FCR1_FRIIE	(CPG_MFS05_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS05_UART_FCR1_FLSTE	(CPG_MFS05_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS06_UART_FCR1	(CPG_MFS06_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_FCR1_FSEL	(CPG_MFS06_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS06_UART_FCR1_FTIE	(CPG_MFS06_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS06_UART_FCR1_FDRQ	(CPG_MFS06_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS06_UART_FCR1_FRIIE	(CPG_MFS06_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS06_UART_FCR1_FLSTE	(CPG_MFS06_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS07_UART_FCR1	(CPG_MFS07_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_FCR1_FSEL	(CPG_MFS07_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS07_UART_FCR1_FTIE	(CPG_MFS07_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS07_UART_FCR1_FDRQ	(CPG_MFS07_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS07_UART_FCR1_FRIIE	(CPG_MFS07_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS07_UART_FCR1_FLSTE	(CPG_MFS07_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS08_UART_FCR1	(CPG_MFS08_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_FCR1_FSEL	(CPG_MFS08_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS08_UART_FCR1_FTIE	(CPG_MFS08_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS08_UART_FCR1_FDRQ	(CPG_MFS08_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS08_UART_FCR1_FRIIE	(CPG_MFS08_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS08_UART_FCR1_FLSTE	(CPG_MFS08_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS09_UART_FCR1	(CPG_MFS09_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_FCR1_FSEL	(CPG_MFS09_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS09_UART_FCR1_FTIE	(CPG_MFS09_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS09_UART_FCR1_FDRQ	(CPG_MFS09_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS09_UART_FCR1_FRIIE	(CPG_MFS09_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS09_UART_FCR1_FLSTE	(CPG_MFS09_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS10_UART_FCR1	(CPG_MFS10_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_FCR1_FSEL	(CPG_MFS10_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS10_UART_FCR1_FTIE	(CPG_MFS10_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS10_UART_FCR1_FDRQ	(CPG_MFS10_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS10_UART_FCR1_FRIIE	(CPG_MFS10_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS10_UART_FCR1_FLSTE	(CPG_MFS10_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS11_UART_FCR1	(CPG_MFS11_UART.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_FCR1_FSEL	(CPG_MFS11_UART.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS11_UART_FCR1_FTIE	(CPG_MFS11_UART.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS11_UART_FCR1_FDRQ	(CPG_MFS11_UART.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS11_UART_FCR1_FRIIE	(CPG_MFS11_UART.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS11_UART_FCR1_FLSTE	(CPG_MFS11_UART.unFCR1.stcField.u1FLSTE)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_fcr1_field{
    uint_io8_t		u1FSEL:1;
    uint_io8_t		u1FTIE:1;
    uint_io8_t		u1FDRQ:1;
    uint_io8_t		u1FRIIE:1;
    uint_io8_t		u1FLSTE:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_uart_fcr1_field_t;

typedef union un_cpg_mfsn_uart_fcr1{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_fcr1_field_t		stcField;
}un_cpg_mfsn_uart_fcr1_t;

/* FBYTE */
#define CPG_MFS00_UART_FBYTE	(CPG_MFS00_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_FBYTE_FBYTE1	(CPG_MFS00_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS00_UART_FBYTE_FBYTE2	(CPG_MFS00_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS01_UART_FBYTE	(CPG_MFS01_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_FBYTE_FBYTE1	(CPG_MFS01_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS01_UART_FBYTE_FBYTE2	(CPG_MFS01_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS02_UART_FBYTE	(CPG_MFS02_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_FBYTE_FBYTE1	(CPG_MFS02_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS02_UART_FBYTE_FBYTE2	(CPG_MFS02_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS03_UART_FBYTE	(CPG_MFS03_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_FBYTE_FBYTE1	(CPG_MFS03_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS03_UART_FBYTE_FBYTE2	(CPG_MFS03_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS04_UART_FBYTE	(CPG_MFS04_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_FBYTE_FBYTE1	(CPG_MFS04_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS04_UART_FBYTE_FBYTE2	(CPG_MFS04_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS05_UART_FBYTE	(CPG_MFS05_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_FBYTE_FBYTE1	(CPG_MFS05_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS05_UART_FBYTE_FBYTE2	(CPG_MFS05_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS06_UART_FBYTE	(CPG_MFS06_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_FBYTE_FBYTE1	(CPG_MFS06_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS06_UART_FBYTE_FBYTE2	(CPG_MFS06_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS07_UART_FBYTE	(CPG_MFS07_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_FBYTE_FBYTE1	(CPG_MFS07_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS07_UART_FBYTE_FBYTE2	(CPG_MFS07_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS08_UART_FBYTE	(CPG_MFS08_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_FBYTE_FBYTE1	(CPG_MFS08_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS08_UART_FBYTE_FBYTE2	(CPG_MFS08_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS09_UART_FBYTE	(CPG_MFS09_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_FBYTE_FBYTE1	(CPG_MFS09_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS09_UART_FBYTE_FBYTE2	(CPG_MFS09_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS10_UART_FBYTE	(CPG_MFS10_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_FBYTE_FBYTE1	(CPG_MFS10_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS10_UART_FBYTE_FBYTE2	(CPG_MFS10_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS11_UART_FBYTE	(CPG_MFS11_UART.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_FBYTE_FBYTE1	(CPG_MFS11_UART.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS11_UART_FBYTE_FBYTE2	(CPG_MFS11_UART.unFBYTE.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_mfsn_uart_fbyte_field{
    uint_io16_t		u8FBYTE1:8;
    uint_io16_t		u8FBYTE2:8;
}stc_cpg_mfsn_uart_fbyte_field_t;

typedef union un_cpg_mfsn_uart_fbyte{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_uart_fbyte_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_fbyte_t;

/* FTICR */
#define CPG_MFS00_UART_FTICR	(CPG_MFS00_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_FTICR_FTICR1	(CPG_MFS00_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS00_UART_FTICR_FTICR2	(CPG_MFS00_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS01_UART_FTICR	(CPG_MFS01_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_FTICR_FTICR1	(CPG_MFS01_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS01_UART_FTICR_FTICR2	(CPG_MFS01_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS02_UART_FTICR	(CPG_MFS02_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_FTICR_FTICR1	(CPG_MFS02_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS02_UART_FTICR_FTICR2	(CPG_MFS02_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS03_UART_FTICR	(CPG_MFS03_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_FTICR_FTICR1	(CPG_MFS03_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS03_UART_FTICR_FTICR2	(CPG_MFS03_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS04_UART_FTICR	(CPG_MFS04_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_FTICR_FTICR1	(CPG_MFS04_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS04_UART_FTICR_FTICR2	(CPG_MFS04_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS05_UART_FTICR	(CPG_MFS05_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_FTICR_FTICR1	(CPG_MFS05_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS05_UART_FTICR_FTICR2	(CPG_MFS05_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS06_UART_FTICR	(CPG_MFS06_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_FTICR_FTICR1	(CPG_MFS06_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS06_UART_FTICR_FTICR2	(CPG_MFS06_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS07_UART_FTICR	(CPG_MFS07_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_FTICR_FTICR1	(CPG_MFS07_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS07_UART_FTICR_FTICR2	(CPG_MFS07_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS08_UART_FTICR	(CPG_MFS08_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_FTICR_FTICR1	(CPG_MFS08_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS08_UART_FTICR_FTICR2	(CPG_MFS08_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS09_UART_FTICR	(CPG_MFS09_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_FTICR_FTICR1	(CPG_MFS09_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS09_UART_FTICR_FTICR2	(CPG_MFS09_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS10_UART_FTICR	(CPG_MFS10_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_FTICR_FTICR1	(CPG_MFS10_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS10_UART_FTICR_FTICR2	(CPG_MFS10_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS11_UART_FTICR	(CPG_MFS11_UART.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_FTICR_FTICR1	(CPG_MFS11_UART.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS11_UART_FTICR_FTICR2	(CPG_MFS11_UART.unFTICR.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_mfsn_uart_fticr_field{
    uint_io16_t		u8FTICR1:8;
    uint_io16_t		u8FTICR2:8;
}stc_cpg_mfsn_uart_fticr_field_t;

typedef union un_cpg_mfsn_uart_fticr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_uart_fticr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_fticr_t;

/* ECR */
#define CPG_MFS00_UART_ECR	(CPG_MFS00_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_ECR_TXBLKEN	(CPG_MFS00_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS00_UART_ECR_RXBLKEN	(CPG_MFS00_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS00_UART_ECR_TEIE	(CPG_MFS00_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS00_UART_ECR_REIE	(CPG_MFS00_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS00_UART_ECR_EISEL	(CPG_MFS00_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS01_UART_ECR	(CPG_MFS01_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_ECR_TXBLKEN	(CPG_MFS01_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS01_UART_ECR_RXBLKEN	(CPG_MFS01_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS01_UART_ECR_TEIE	(CPG_MFS01_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS01_UART_ECR_REIE	(CPG_MFS01_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS01_UART_ECR_EISEL	(CPG_MFS01_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS02_UART_ECR	(CPG_MFS02_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_ECR_TXBLKEN	(CPG_MFS02_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS02_UART_ECR_RXBLKEN	(CPG_MFS02_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS02_UART_ECR_TEIE	(CPG_MFS02_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS02_UART_ECR_REIE	(CPG_MFS02_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS02_UART_ECR_EISEL	(CPG_MFS02_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS03_UART_ECR	(CPG_MFS03_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_ECR_TXBLKEN	(CPG_MFS03_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS03_UART_ECR_RXBLKEN	(CPG_MFS03_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS03_UART_ECR_TEIE	(CPG_MFS03_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS03_UART_ECR_REIE	(CPG_MFS03_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS03_UART_ECR_EISEL	(CPG_MFS03_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS04_UART_ECR	(CPG_MFS04_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_ECR_TXBLKEN	(CPG_MFS04_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS04_UART_ECR_RXBLKEN	(CPG_MFS04_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS04_UART_ECR_TEIE	(CPG_MFS04_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS04_UART_ECR_REIE	(CPG_MFS04_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS04_UART_ECR_EISEL	(CPG_MFS04_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS05_UART_ECR	(CPG_MFS05_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_ECR_TXBLKEN	(CPG_MFS05_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS05_UART_ECR_RXBLKEN	(CPG_MFS05_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS05_UART_ECR_TEIE	(CPG_MFS05_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS05_UART_ECR_REIE	(CPG_MFS05_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS05_UART_ECR_EISEL	(CPG_MFS05_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS06_UART_ECR	(CPG_MFS06_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_ECR_TXBLKEN	(CPG_MFS06_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS06_UART_ECR_RXBLKEN	(CPG_MFS06_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS06_UART_ECR_TEIE	(CPG_MFS06_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS06_UART_ECR_REIE	(CPG_MFS06_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS06_UART_ECR_EISEL	(CPG_MFS06_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS07_UART_ECR	(CPG_MFS07_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_ECR_TXBLKEN	(CPG_MFS07_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS07_UART_ECR_RXBLKEN	(CPG_MFS07_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS07_UART_ECR_TEIE	(CPG_MFS07_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS07_UART_ECR_REIE	(CPG_MFS07_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS07_UART_ECR_EISEL	(CPG_MFS07_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS08_UART_ECR	(CPG_MFS08_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_ECR_TXBLKEN	(CPG_MFS08_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS08_UART_ECR_RXBLKEN	(CPG_MFS08_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS08_UART_ECR_TEIE	(CPG_MFS08_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS08_UART_ECR_REIE	(CPG_MFS08_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS08_UART_ECR_EISEL	(CPG_MFS08_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS09_UART_ECR	(CPG_MFS09_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_ECR_TXBLKEN	(CPG_MFS09_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS09_UART_ECR_RXBLKEN	(CPG_MFS09_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS09_UART_ECR_TEIE	(CPG_MFS09_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS09_UART_ECR_REIE	(CPG_MFS09_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS09_UART_ECR_EISEL	(CPG_MFS09_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS10_UART_ECR	(CPG_MFS10_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_ECR_TXBLKEN	(CPG_MFS10_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS10_UART_ECR_RXBLKEN	(CPG_MFS10_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS10_UART_ECR_TEIE	(CPG_MFS10_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS10_UART_ECR_REIE	(CPG_MFS10_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS10_UART_ECR_EISEL	(CPG_MFS10_UART.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS11_UART_ECR	(CPG_MFS11_UART.unECR.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_ECR_TXBLKEN	(CPG_MFS11_UART.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS11_UART_ECR_RXBLKEN	(CPG_MFS11_UART.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS11_UART_ECR_TEIE	(CPG_MFS11_UART.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS11_UART_ECR_REIE	(CPG_MFS11_UART.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS11_UART_ECR_EISEL	(CPG_MFS11_UART.unECR.stcField.u1EISEL)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_ecr_field{
    uint_io8_t		u1TXBLKEN:1;
    uint_io8_t		u1RXBLKEN:1;
    uint_io8_t		u1TEIE:1;
    uint_io8_t		u1REIE:1;
    uint_io8_t		u1EISEL:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_uart_ecr_field_t;

typedef union un_cpg_mfsn_uart_ecr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_ecr_field_t		stcField;
}un_cpg_mfsn_uart_ecr_t;

/* ESR */
#define CPG_MFS00_UART_ESR	(CPG_MFS00_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_ESR_TBERR	(CPG_MFS00_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS00_UART_ESR_RBERR	(CPG_MFS00_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS00_UART_ESR_TXOVR	(CPG_MFS00_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS00_UART_ESR_RXUDR	(CPG_MFS00_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS01_UART_ESR	(CPG_MFS01_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_ESR_TBERR	(CPG_MFS01_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS01_UART_ESR_RBERR	(CPG_MFS01_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS01_UART_ESR_TXOVR	(CPG_MFS01_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS01_UART_ESR_RXUDR	(CPG_MFS01_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS02_UART_ESR	(CPG_MFS02_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_ESR_TBERR	(CPG_MFS02_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS02_UART_ESR_RBERR	(CPG_MFS02_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS02_UART_ESR_TXOVR	(CPG_MFS02_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS02_UART_ESR_RXUDR	(CPG_MFS02_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS03_UART_ESR	(CPG_MFS03_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_ESR_TBERR	(CPG_MFS03_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS03_UART_ESR_RBERR	(CPG_MFS03_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS03_UART_ESR_TXOVR	(CPG_MFS03_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS03_UART_ESR_RXUDR	(CPG_MFS03_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS04_UART_ESR	(CPG_MFS04_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_ESR_TBERR	(CPG_MFS04_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS04_UART_ESR_RBERR	(CPG_MFS04_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS04_UART_ESR_TXOVR	(CPG_MFS04_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS04_UART_ESR_RXUDR	(CPG_MFS04_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS05_UART_ESR	(CPG_MFS05_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_ESR_TBERR	(CPG_MFS05_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS05_UART_ESR_RBERR	(CPG_MFS05_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS05_UART_ESR_TXOVR	(CPG_MFS05_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS05_UART_ESR_RXUDR	(CPG_MFS05_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS06_UART_ESR	(CPG_MFS06_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_ESR_TBERR	(CPG_MFS06_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS06_UART_ESR_RBERR	(CPG_MFS06_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS06_UART_ESR_TXOVR	(CPG_MFS06_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS06_UART_ESR_RXUDR	(CPG_MFS06_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS07_UART_ESR	(CPG_MFS07_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_ESR_TBERR	(CPG_MFS07_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS07_UART_ESR_RBERR	(CPG_MFS07_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS07_UART_ESR_TXOVR	(CPG_MFS07_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS07_UART_ESR_RXUDR	(CPG_MFS07_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS08_UART_ESR	(CPG_MFS08_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_ESR_TBERR	(CPG_MFS08_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS08_UART_ESR_RBERR	(CPG_MFS08_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS08_UART_ESR_TXOVR	(CPG_MFS08_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS08_UART_ESR_RXUDR	(CPG_MFS08_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS09_UART_ESR	(CPG_MFS09_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_ESR_TBERR	(CPG_MFS09_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS09_UART_ESR_RBERR	(CPG_MFS09_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS09_UART_ESR_TXOVR	(CPG_MFS09_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS09_UART_ESR_RXUDR	(CPG_MFS09_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS10_UART_ESR	(CPG_MFS10_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_ESR_TBERR	(CPG_MFS10_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS10_UART_ESR_RBERR	(CPG_MFS10_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS10_UART_ESR_TXOVR	(CPG_MFS10_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS10_UART_ESR_RXUDR	(CPG_MFS10_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS11_UART_ESR	(CPG_MFS11_UART.unESR.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_ESR_TBERR	(CPG_MFS11_UART.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS11_UART_ESR_RBERR	(CPG_MFS11_UART.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS11_UART_ESR_TXOVR	(CPG_MFS11_UART.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS11_UART_ESR_RXUDR	(CPG_MFS11_UART.unESR.stcField.u1RXUDR)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_esr_field{
    uint_io8_t		u1TBERR:1;
    uint_io8_t		u1RBERR:1;
    uint_io8_t		u1TXOVR:1;
    uint_io8_t		u1RXUDR:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_uart_esr_field_t;

typedef union un_cpg_mfsn_uart_esr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_esr_field_t		stcField;
}un_cpg_mfsn_uart_esr_t;

/* TBSIZE */
#define CPG_MFS00_UART_TBSIZE	(CPG_MFS00_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_TBSIZE_TBSIZE	CPG_MFS00_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS01_UART_TBSIZE	(CPG_MFS01_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_TBSIZE_TBSIZE	CPG_MFS01_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS02_UART_TBSIZE	(CPG_MFS02_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_TBSIZE_TBSIZE	CPG_MFS02_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS03_UART_TBSIZE	(CPG_MFS03_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_TBSIZE_TBSIZE	CPG_MFS03_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS04_UART_TBSIZE	(CPG_MFS04_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_TBSIZE_TBSIZE	CPG_MFS04_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS05_UART_TBSIZE	(CPG_MFS05_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_TBSIZE_TBSIZE	CPG_MFS05_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS06_UART_TBSIZE	(CPG_MFS06_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_TBSIZE_TBSIZE	CPG_MFS06_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS07_UART_TBSIZE	(CPG_MFS07_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_TBSIZE_TBSIZE	CPG_MFS07_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS08_UART_TBSIZE	(CPG_MFS08_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_TBSIZE_TBSIZE	CPG_MFS08_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS09_UART_TBSIZE	(CPG_MFS09_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_TBSIZE_TBSIZE	CPG_MFS09_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS10_UART_TBSIZE	(CPG_MFS10_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_TBSIZE_TBSIZE	CPG_MFS10_UART_TBSIZE  /*@bfrg@*/

#define CPG_MFS11_UART_TBSIZE	(CPG_MFS11_UART.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_TBSIZE_TBSIZE	CPG_MFS11_UART_TBSIZE  /*@bfrg@*/

typedef union un_cpg_mfsn_uart_tbsize{
    uint_io8_t		u8Register;
}un_cpg_mfsn_uart_tbsize_t;

/* SACSRC */
#define CPG_MFS00_UART_SACSRC	(CPG_MFS00_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_SACSRC_TMREC	(CPG_MFS00_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS00_UART_SACSRC_TRGEC	(CPG_MFS00_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS00_UART_SACSRC_TSYNEC	(CPG_MFS00_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS00_UART_SACSRC_TINTEC	(CPG_MFS00_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS00_UART_SACSRC_TINTC	(CPG_MFS00_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS00_UART_SACSRC_STSTC	(CPG_MFS00_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS01_UART_SACSRC	(CPG_MFS01_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_SACSRC_TMREC	(CPG_MFS01_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS01_UART_SACSRC_TRGEC	(CPG_MFS01_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS01_UART_SACSRC_TSYNEC	(CPG_MFS01_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS01_UART_SACSRC_TINTEC	(CPG_MFS01_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS01_UART_SACSRC_TINTC	(CPG_MFS01_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS01_UART_SACSRC_STSTC	(CPG_MFS01_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS02_UART_SACSRC	(CPG_MFS02_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_SACSRC_TMREC	(CPG_MFS02_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS02_UART_SACSRC_TRGEC	(CPG_MFS02_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS02_UART_SACSRC_TSYNEC	(CPG_MFS02_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS02_UART_SACSRC_TINTEC	(CPG_MFS02_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS02_UART_SACSRC_TINTC	(CPG_MFS02_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS02_UART_SACSRC_STSTC	(CPG_MFS02_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS03_UART_SACSRC	(CPG_MFS03_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_SACSRC_TMREC	(CPG_MFS03_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS03_UART_SACSRC_TRGEC	(CPG_MFS03_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS03_UART_SACSRC_TSYNEC	(CPG_MFS03_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS03_UART_SACSRC_TINTEC	(CPG_MFS03_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS03_UART_SACSRC_TINTC	(CPG_MFS03_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS03_UART_SACSRC_STSTC	(CPG_MFS03_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS04_UART_SACSRC	(CPG_MFS04_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_SACSRC_TMREC	(CPG_MFS04_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS04_UART_SACSRC_TRGEC	(CPG_MFS04_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS04_UART_SACSRC_TSYNEC	(CPG_MFS04_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS04_UART_SACSRC_TINTEC	(CPG_MFS04_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS04_UART_SACSRC_TINTC	(CPG_MFS04_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS04_UART_SACSRC_STSTC	(CPG_MFS04_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS05_UART_SACSRC	(CPG_MFS05_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_SACSRC_TMREC	(CPG_MFS05_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS05_UART_SACSRC_TRGEC	(CPG_MFS05_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS05_UART_SACSRC_TSYNEC	(CPG_MFS05_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS05_UART_SACSRC_TINTEC	(CPG_MFS05_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS05_UART_SACSRC_TINTC	(CPG_MFS05_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS05_UART_SACSRC_STSTC	(CPG_MFS05_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS06_UART_SACSRC	(CPG_MFS06_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_SACSRC_TMREC	(CPG_MFS06_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS06_UART_SACSRC_TRGEC	(CPG_MFS06_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS06_UART_SACSRC_TSYNEC	(CPG_MFS06_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS06_UART_SACSRC_TINTEC	(CPG_MFS06_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS06_UART_SACSRC_TINTC	(CPG_MFS06_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS06_UART_SACSRC_STSTC	(CPG_MFS06_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS07_UART_SACSRC	(CPG_MFS07_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_SACSRC_TMREC	(CPG_MFS07_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS07_UART_SACSRC_TRGEC	(CPG_MFS07_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS07_UART_SACSRC_TSYNEC	(CPG_MFS07_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS07_UART_SACSRC_TINTEC	(CPG_MFS07_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS07_UART_SACSRC_TINTC	(CPG_MFS07_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS07_UART_SACSRC_STSTC	(CPG_MFS07_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS08_UART_SACSRC	(CPG_MFS08_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_SACSRC_TMREC	(CPG_MFS08_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS08_UART_SACSRC_TRGEC	(CPG_MFS08_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS08_UART_SACSRC_TSYNEC	(CPG_MFS08_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS08_UART_SACSRC_TINTEC	(CPG_MFS08_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS08_UART_SACSRC_TINTC	(CPG_MFS08_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS08_UART_SACSRC_STSTC	(CPG_MFS08_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS09_UART_SACSRC	(CPG_MFS09_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_SACSRC_TMREC	(CPG_MFS09_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS09_UART_SACSRC_TRGEC	(CPG_MFS09_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS09_UART_SACSRC_TSYNEC	(CPG_MFS09_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS09_UART_SACSRC_TINTEC	(CPG_MFS09_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS09_UART_SACSRC_TINTC	(CPG_MFS09_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS09_UART_SACSRC_STSTC	(CPG_MFS09_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS10_UART_SACSRC	(CPG_MFS10_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_SACSRC_TMREC	(CPG_MFS10_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS10_UART_SACSRC_TRGEC	(CPG_MFS10_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS10_UART_SACSRC_TSYNEC	(CPG_MFS10_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS10_UART_SACSRC_TINTEC	(CPG_MFS10_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS10_UART_SACSRC_TINTC	(CPG_MFS10_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS10_UART_SACSRC_STSTC	(CPG_MFS10_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS11_UART_SACSRC	(CPG_MFS11_UART.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_SACSRC_TMREC	(CPG_MFS11_UART.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS11_UART_SACSRC_TRGEC	(CPG_MFS11_UART.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS11_UART_SACSRC_TSYNEC	(CPG_MFS11_UART.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS11_UART_SACSRC_TINTEC	(CPG_MFS11_UART.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS11_UART_SACSRC_TINTC	(CPG_MFS11_UART.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS11_UART_SACSRC_STSTC	(CPG_MFS11_UART.unSACSRC.stcField.u1STSTC)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_sacsrc_field{
    uint_io16_t		u1TMREC:1;
    uint_io16_t		:4;
    uint_io16_t		u1TRGEC:1;
    uint_io16_t		u1TSYNEC:1;
    uint_io16_t		u1TINTEC:1;
    uint_io16_t		u1TINTC:1;
    uint_io16_t		:6;
    uint_io16_t		u1STSTC:1;
}stc_cpg_mfsn_uart_sacsrc_field_t;

typedef union un_cpg_mfsn_uart_sacsrc{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_uart_sacsrc_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_sacsrc_t;

/* FCR0C */
#define CPG_MFS00_UART_FCR0C	(CPG_MFS00_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_FCR0C_FE1C	(CPG_MFS00_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS00_UART_FCR0C_FE2C	(CPG_MFS00_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS01_UART_FCR0C	(CPG_MFS01_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_FCR0C_FE1C	(CPG_MFS01_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS01_UART_FCR0C_FE2C	(CPG_MFS01_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS02_UART_FCR0C	(CPG_MFS02_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_FCR0C_FE1C	(CPG_MFS02_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS02_UART_FCR0C_FE2C	(CPG_MFS02_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS03_UART_FCR0C	(CPG_MFS03_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_FCR0C_FE1C	(CPG_MFS03_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS03_UART_FCR0C_FE2C	(CPG_MFS03_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS04_UART_FCR0C	(CPG_MFS04_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_FCR0C_FE1C	(CPG_MFS04_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS04_UART_FCR0C_FE2C	(CPG_MFS04_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS05_UART_FCR0C	(CPG_MFS05_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_FCR0C_FE1C	(CPG_MFS05_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS05_UART_FCR0C_FE2C	(CPG_MFS05_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS06_UART_FCR0C	(CPG_MFS06_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_FCR0C_FE1C	(CPG_MFS06_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS06_UART_FCR0C_FE2C	(CPG_MFS06_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS07_UART_FCR0C	(CPG_MFS07_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_FCR0C_FE1C	(CPG_MFS07_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS07_UART_FCR0C_FE2C	(CPG_MFS07_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS08_UART_FCR0C	(CPG_MFS08_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_FCR0C_FE1C	(CPG_MFS08_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS08_UART_FCR0C_FE2C	(CPG_MFS08_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS09_UART_FCR0C	(CPG_MFS09_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_FCR0C_FE1C	(CPG_MFS09_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS09_UART_FCR0C_FE2C	(CPG_MFS09_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS10_UART_FCR0C	(CPG_MFS10_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_FCR0C_FE1C	(CPG_MFS10_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS10_UART_FCR0C_FE2C	(CPG_MFS10_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS11_UART_FCR0C	(CPG_MFS11_UART.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_FCR0C_FE1C	(CPG_MFS11_UART.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS11_UART_FCR0C_FE2C	(CPG_MFS11_UART.unFCR0C.stcField.u1FE2C)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_fcr0c_field{
    uint_io8_t		u1FE1C:1;
    uint_io8_t		u1FE2C:1;
    uint_io8_t		:6;
}stc_cpg_mfsn_uart_fcr0c_field_t;

typedef union un_cpg_mfsn_uart_fcr0c{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_fcr0c_field_t		stcField;
}un_cpg_mfsn_uart_fcr0c_t;

/* FCR1C */
#define CPG_MFS00_UART_FCR1C	(CPG_MFS00_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_FCR1C_FSELC	(CPG_MFS00_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS00_UART_FCR1C_FTIEC	(CPG_MFS00_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS00_UART_FCR1C_FDRQC	(CPG_MFS00_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS00_UART_FCR1C_FRIIEC	(CPG_MFS00_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS00_UART_FCR1C_FLSTEC	(CPG_MFS00_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS01_UART_FCR1C	(CPG_MFS01_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_FCR1C_FSELC	(CPG_MFS01_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS01_UART_FCR1C_FTIEC	(CPG_MFS01_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS01_UART_FCR1C_FDRQC	(CPG_MFS01_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS01_UART_FCR1C_FRIIEC	(CPG_MFS01_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS01_UART_FCR1C_FLSTEC	(CPG_MFS01_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS02_UART_FCR1C	(CPG_MFS02_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_FCR1C_FSELC	(CPG_MFS02_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS02_UART_FCR1C_FTIEC	(CPG_MFS02_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS02_UART_FCR1C_FDRQC	(CPG_MFS02_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS02_UART_FCR1C_FRIIEC	(CPG_MFS02_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS02_UART_FCR1C_FLSTEC	(CPG_MFS02_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS03_UART_FCR1C	(CPG_MFS03_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_FCR1C_FSELC	(CPG_MFS03_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS03_UART_FCR1C_FTIEC	(CPG_MFS03_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS03_UART_FCR1C_FDRQC	(CPG_MFS03_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS03_UART_FCR1C_FRIIEC	(CPG_MFS03_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS03_UART_FCR1C_FLSTEC	(CPG_MFS03_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS04_UART_FCR1C	(CPG_MFS04_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_FCR1C_FSELC	(CPG_MFS04_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS04_UART_FCR1C_FTIEC	(CPG_MFS04_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS04_UART_FCR1C_FDRQC	(CPG_MFS04_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS04_UART_FCR1C_FRIIEC	(CPG_MFS04_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS04_UART_FCR1C_FLSTEC	(CPG_MFS04_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS05_UART_FCR1C	(CPG_MFS05_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_FCR1C_FSELC	(CPG_MFS05_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS05_UART_FCR1C_FTIEC	(CPG_MFS05_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS05_UART_FCR1C_FDRQC	(CPG_MFS05_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS05_UART_FCR1C_FRIIEC	(CPG_MFS05_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS05_UART_FCR1C_FLSTEC	(CPG_MFS05_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS06_UART_FCR1C	(CPG_MFS06_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_FCR1C_FSELC	(CPG_MFS06_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS06_UART_FCR1C_FTIEC	(CPG_MFS06_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS06_UART_FCR1C_FDRQC	(CPG_MFS06_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS06_UART_FCR1C_FRIIEC	(CPG_MFS06_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS06_UART_FCR1C_FLSTEC	(CPG_MFS06_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS07_UART_FCR1C	(CPG_MFS07_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_FCR1C_FSELC	(CPG_MFS07_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS07_UART_FCR1C_FTIEC	(CPG_MFS07_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS07_UART_FCR1C_FDRQC	(CPG_MFS07_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS07_UART_FCR1C_FRIIEC	(CPG_MFS07_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS07_UART_FCR1C_FLSTEC	(CPG_MFS07_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS08_UART_FCR1C	(CPG_MFS08_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_FCR1C_FSELC	(CPG_MFS08_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS08_UART_FCR1C_FTIEC	(CPG_MFS08_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS08_UART_FCR1C_FDRQC	(CPG_MFS08_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS08_UART_FCR1C_FRIIEC	(CPG_MFS08_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS08_UART_FCR1C_FLSTEC	(CPG_MFS08_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS09_UART_FCR1C	(CPG_MFS09_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_FCR1C_FSELC	(CPG_MFS09_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS09_UART_FCR1C_FTIEC	(CPG_MFS09_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS09_UART_FCR1C_FDRQC	(CPG_MFS09_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS09_UART_FCR1C_FRIIEC	(CPG_MFS09_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS09_UART_FCR1C_FLSTEC	(CPG_MFS09_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS10_UART_FCR1C	(CPG_MFS10_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_FCR1C_FSELC	(CPG_MFS10_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS10_UART_FCR1C_FTIEC	(CPG_MFS10_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS10_UART_FCR1C_FDRQC	(CPG_MFS10_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS10_UART_FCR1C_FRIIEC	(CPG_MFS10_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS10_UART_FCR1C_FLSTEC	(CPG_MFS10_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS11_UART_FCR1C	(CPG_MFS11_UART.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_FCR1C_FSELC	(CPG_MFS11_UART.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS11_UART_FCR1C_FTIEC	(CPG_MFS11_UART.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS11_UART_FCR1C_FDRQC	(CPG_MFS11_UART.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS11_UART_FCR1C_FRIIEC	(CPG_MFS11_UART.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS11_UART_FCR1C_FLSTEC	(CPG_MFS11_UART.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_fcr1c_field{
    uint_io8_t		u1FSELC:1;
    uint_io8_t		u1FTIEC:1;
    uint_io8_t		u1FDRQC:1;
    uint_io8_t		u1FRIIEC:1;
    uint_io8_t		u1FLSTEC:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_uart_fcr1c_field_t;

typedef union un_cpg_mfsn_uart_fcr1c{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_fcr1c_field_t		stcField;
}un_cpg_mfsn_uart_fcr1c_t;

/* ESRC */
#define CPG_MFS00_UART_ESRC	(CPG_MFS00_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_ESRC_TBERRC	(CPG_MFS00_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS00_UART_ESRC_RBERRC	(CPG_MFS00_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS00_UART_ESRC_TXOVRC	(CPG_MFS00_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS00_UART_ESRC_RXUDRC	(CPG_MFS00_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS01_UART_ESRC	(CPG_MFS01_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_ESRC_TBERRC	(CPG_MFS01_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS01_UART_ESRC_RBERRC	(CPG_MFS01_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS01_UART_ESRC_TXOVRC	(CPG_MFS01_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS01_UART_ESRC_RXUDRC	(CPG_MFS01_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS02_UART_ESRC	(CPG_MFS02_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_ESRC_TBERRC	(CPG_MFS02_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS02_UART_ESRC_RBERRC	(CPG_MFS02_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS02_UART_ESRC_TXOVRC	(CPG_MFS02_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS02_UART_ESRC_RXUDRC	(CPG_MFS02_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS03_UART_ESRC	(CPG_MFS03_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_ESRC_TBERRC	(CPG_MFS03_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS03_UART_ESRC_RBERRC	(CPG_MFS03_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS03_UART_ESRC_TXOVRC	(CPG_MFS03_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS03_UART_ESRC_RXUDRC	(CPG_MFS03_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS04_UART_ESRC	(CPG_MFS04_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_ESRC_TBERRC	(CPG_MFS04_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS04_UART_ESRC_RBERRC	(CPG_MFS04_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS04_UART_ESRC_TXOVRC	(CPG_MFS04_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS04_UART_ESRC_RXUDRC	(CPG_MFS04_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS05_UART_ESRC	(CPG_MFS05_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_ESRC_TBERRC	(CPG_MFS05_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS05_UART_ESRC_RBERRC	(CPG_MFS05_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS05_UART_ESRC_TXOVRC	(CPG_MFS05_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS05_UART_ESRC_RXUDRC	(CPG_MFS05_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS06_UART_ESRC	(CPG_MFS06_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_ESRC_TBERRC	(CPG_MFS06_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS06_UART_ESRC_RBERRC	(CPG_MFS06_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS06_UART_ESRC_TXOVRC	(CPG_MFS06_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS06_UART_ESRC_RXUDRC	(CPG_MFS06_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS07_UART_ESRC	(CPG_MFS07_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_ESRC_TBERRC	(CPG_MFS07_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS07_UART_ESRC_RBERRC	(CPG_MFS07_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS07_UART_ESRC_TXOVRC	(CPG_MFS07_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS07_UART_ESRC_RXUDRC	(CPG_MFS07_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS08_UART_ESRC	(CPG_MFS08_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_ESRC_TBERRC	(CPG_MFS08_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS08_UART_ESRC_RBERRC	(CPG_MFS08_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS08_UART_ESRC_TXOVRC	(CPG_MFS08_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS08_UART_ESRC_RXUDRC	(CPG_MFS08_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS09_UART_ESRC	(CPG_MFS09_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_ESRC_TBERRC	(CPG_MFS09_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS09_UART_ESRC_RBERRC	(CPG_MFS09_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS09_UART_ESRC_TXOVRC	(CPG_MFS09_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS09_UART_ESRC_RXUDRC	(CPG_MFS09_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS10_UART_ESRC	(CPG_MFS10_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_ESRC_TBERRC	(CPG_MFS10_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS10_UART_ESRC_RBERRC	(CPG_MFS10_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS10_UART_ESRC_TXOVRC	(CPG_MFS10_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS10_UART_ESRC_RXUDRC	(CPG_MFS10_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS11_UART_ESRC	(CPG_MFS11_UART.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_ESRC_TBERRC	(CPG_MFS11_UART.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS11_UART_ESRC_RBERRC	(CPG_MFS11_UART.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS11_UART_ESRC_TXOVRC	(CPG_MFS11_UART.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS11_UART_ESRC_RXUDRC	(CPG_MFS11_UART.unESRC.stcField.u1RXUDRC)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_esrc_field{
    uint_io8_t		u1TBERRC:1;
    uint_io8_t		u1RBERRC:1;
    uint_io8_t		u1TXOVRC:1;
    uint_io8_t		u1RXUDRC:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_uart_esrc_field_t;

typedef union un_cpg_mfsn_uart_esrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_esrc_field_t		stcField;
}un_cpg_mfsn_uart_esrc_t;

/* SACSRS */
#define CPG_MFS00_UART_SACSRS	(CPG_MFS00_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS00_UART_SACSRS_TMRES	(CPG_MFS00_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS00_UART_SACSRS_TRGES	(CPG_MFS00_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS00_UART_SACSRS_TSYNES	(CPG_MFS00_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS00_UART_SACSRS_TINTES	(CPG_MFS00_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS00_UART_SACSRS_STSTS	(CPG_MFS00_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS01_UART_SACSRS	(CPG_MFS01_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS01_UART_SACSRS_TMRES	(CPG_MFS01_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS01_UART_SACSRS_TRGES	(CPG_MFS01_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS01_UART_SACSRS_TSYNES	(CPG_MFS01_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS01_UART_SACSRS_TINTES	(CPG_MFS01_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS01_UART_SACSRS_STSTS	(CPG_MFS01_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS02_UART_SACSRS	(CPG_MFS02_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS02_UART_SACSRS_TMRES	(CPG_MFS02_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS02_UART_SACSRS_TRGES	(CPG_MFS02_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS02_UART_SACSRS_TSYNES	(CPG_MFS02_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS02_UART_SACSRS_TINTES	(CPG_MFS02_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS02_UART_SACSRS_STSTS	(CPG_MFS02_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS03_UART_SACSRS	(CPG_MFS03_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS03_UART_SACSRS_TMRES	(CPG_MFS03_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS03_UART_SACSRS_TRGES	(CPG_MFS03_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS03_UART_SACSRS_TSYNES	(CPG_MFS03_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS03_UART_SACSRS_TINTES	(CPG_MFS03_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS03_UART_SACSRS_STSTS	(CPG_MFS03_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS04_UART_SACSRS	(CPG_MFS04_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS04_UART_SACSRS_TMRES	(CPG_MFS04_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS04_UART_SACSRS_TRGES	(CPG_MFS04_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS04_UART_SACSRS_TSYNES	(CPG_MFS04_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS04_UART_SACSRS_TINTES	(CPG_MFS04_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS04_UART_SACSRS_STSTS	(CPG_MFS04_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS05_UART_SACSRS	(CPG_MFS05_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS05_UART_SACSRS_TMRES	(CPG_MFS05_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS05_UART_SACSRS_TRGES	(CPG_MFS05_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS05_UART_SACSRS_TSYNES	(CPG_MFS05_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS05_UART_SACSRS_TINTES	(CPG_MFS05_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS05_UART_SACSRS_STSTS	(CPG_MFS05_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS06_UART_SACSRS	(CPG_MFS06_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS06_UART_SACSRS_TMRES	(CPG_MFS06_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS06_UART_SACSRS_TRGES	(CPG_MFS06_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS06_UART_SACSRS_TSYNES	(CPG_MFS06_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS06_UART_SACSRS_TINTES	(CPG_MFS06_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS06_UART_SACSRS_STSTS	(CPG_MFS06_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS07_UART_SACSRS	(CPG_MFS07_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS07_UART_SACSRS_TMRES	(CPG_MFS07_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS07_UART_SACSRS_TRGES	(CPG_MFS07_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS07_UART_SACSRS_TSYNES	(CPG_MFS07_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS07_UART_SACSRS_TINTES	(CPG_MFS07_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS07_UART_SACSRS_STSTS	(CPG_MFS07_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS08_UART_SACSRS	(CPG_MFS08_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS08_UART_SACSRS_TMRES	(CPG_MFS08_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS08_UART_SACSRS_TRGES	(CPG_MFS08_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS08_UART_SACSRS_TSYNES	(CPG_MFS08_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS08_UART_SACSRS_TINTES	(CPG_MFS08_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS08_UART_SACSRS_STSTS	(CPG_MFS08_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS09_UART_SACSRS	(CPG_MFS09_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS09_UART_SACSRS_TMRES	(CPG_MFS09_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS09_UART_SACSRS_TRGES	(CPG_MFS09_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS09_UART_SACSRS_TSYNES	(CPG_MFS09_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS09_UART_SACSRS_TINTES	(CPG_MFS09_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS09_UART_SACSRS_STSTS	(CPG_MFS09_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS10_UART_SACSRS	(CPG_MFS10_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS10_UART_SACSRS_TMRES	(CPG_MFS10_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS10_UART_SACSRS_TRGES	(CPG_MFS10_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS10_UART_SACSRS_TSYNES	(CPG_MFS10_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS10_UART_SACSRS_TINTES	(CPG_MFS10_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS10_UART_SACSRS_STSTS	(CPG_MFS10_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS11_UART_SACSRS	(CPG_MFS11_UART.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS11_UART_SACSRS_TMRES	(CPG_MFS11_UART.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS11_UART_SACSRS_TRGES	(CPG_MFS11_UART.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS11_UART_SACSRS_TSYNES	(CPG_MFS11_UART.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS11_UART_SACSRS_TINTES	(CPG_MFS11_UART.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS11_UART_SACSRS_STSTS	(CPG_MFS11_UART.unSACSRS.stcField.u1STSTS)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_sacsrs_field{
    uint_io16_t		u1TMRES:1;
    uint_io16_t		:4;
    uint_io16_t		u1TRGES:1;
    uint_io16_t		u1TSYNES:1;
    uint_io16_t		u1TINTES:1;
    uint_io16_t		:7;
    uint_io16_t		u1STSTS:1;
}stc_cpg_mfsn_uart_sacsrs_field_t;

typedef union un_cpg_mfsn_uart_sacsrs{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_uart_sacsrs_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_uart_sacsrs_t;

/* FCR0S */
#define CPG_MFS00_UART_FCR0S	(CPG_MFS00_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_FCR0S_FE1S	(CPG_MFS00_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS00_UART_FCR0S_FE2S	(CPG_MFS00_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS00_UART_FCR0S_FCL1S	(CPG_MFS00_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS00_UART_FCR0S_FCL2S	(CPG_MFS00_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS00_UART_FCR0S_FSETS	(CPG_MFS00_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS00_UART_FCR0S_FLDS	(CPG_MFS00_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS01_UART_FCR0S	(CPG_MFS01_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_FCR0S_FE1S	(CPG_MFS01_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS01_UART_FCR0S_FE2S	(CPG_MFS01_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS01_UART_FCR0S_FCL1S	(CPG_MFS01_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS01_UART_FCR0S_FCL2S	(CPG_MFS01_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS01_UART_FCR0S_FSETS	(CPG_MFS01_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS01_UART_FCR0S_FLDS	(CPG_MFS01_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS02_UART_FCR0S	(CPG_MFS02_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_FCR0S_FE1S	(CPG_MFS02_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS02_UART_FCR0S_FE2S	(CPG_MFS02_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS02_UART_FCR0S_FCL1S	(CPG_MFS02_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS02_UART_FCR0S_FCL2S	(CPG_MFS02_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS02_UART_FCR0S_FSETS	(CPG_MFS02_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS02_UART_FCR0S_FLDS	(CPG_MFS02_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS03_UART_FCR0S	(CPG_MFS03_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_FCR0S_FE1S	(CPG_MFS03_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS03_UART_FCR0S_FE2S	(CPG_MFS03_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS03_UART_FCR0S_FCL1S	(CPG_MFS03_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS03_UART_FCR0S_FCL2S	(CPG_MFS03_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS03_UART_FCR0S_FSETS	(CPG_MFS03_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS03_UART_FCR0S_FLDS	(CPG_MFS03_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS04_UART_FCR0S	(CPG_MFS04_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_FCR0S_FE1S	(CPG_MFS04_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS04_UART_FCR0S_FE2S	(CPG_MFS04_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS04_UART_FCR0S_FCL1S	(CPG_MFS04_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS04_UART_FCR0S_FCL2S	(CPG_MFS04_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS04_UART_FCR0S_FSETS	(CPG_MFS04_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS04_UART_FCR0S_FLDS	(CPG_MFS04_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS05_UART_FCR0S	(CPG_MFS05_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_FCR0S_FE1S	(CPG_MFS05_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS05_UART_FCR0S_FE2S	(CPG_MFS05_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS05_UART_FCR0S_FCL1S	(CPG_MFS05_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS05_UART_FCR0S_FCL2S	(CPG_MFS05_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS05_UART_FCR0S_FSETS	(CPG_MFS05_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS05_UART_FCR0S_FLDS	(CPG_MFS05_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS06_UART_FCR0S	(CPG_MFS06_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_FCR0S_FE1S	(CPG_MFS06_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS06_UART_FCR0S_FE2S	(CPG_MFS06_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS06_UART_FCR0S_FCL1S	(CPG_MFS06_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS06_UART_FCR0S_FCL2S	(CPG_MFS06_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS06_UART_FCR0S_FSETS	(CPG_MFS06_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS06_UART_FCR0S_FLDS	(CPG_MFS06_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS07_UART_FCR0S	(CPG_MFS07_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_FCR0S_FE1S	(CPG_MFS07_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS07_UART_FCR0S_FE2S	(CPG_MFS07_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS07_UART_FCR0S_FCL1S	(CPG_MFS07_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS07_UART_FCR0S_FCL2S	(CPG_MFS07_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS07_UART_FCR0S_FSETS	(CPG_MFS07_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS07_UART_FCR0S_FLDS	(CPG_MFS07_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS08_UART_FCR0S	(CPG_MFS08_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_FCR0S_FE1S	(CPG_MFS08_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS08_UART_FCR0S_FE2S	(CPG_MFS08_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS08_UART_FCR0S_FCL1S	(CPG_MFS08_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS08_UART_FCR0S_FCL2S	(CPG_MFS08_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS08_UART_FCR0S_FSETS	(CPG_MFS08_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS08_UART_FCR0S_FLDS	(CPG_MFS08_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS09_UART_FCR0S	(CPG_MFS09_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_FCR0S_FE1S	(CPG_MFS09_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS09_UART_FCR0S_FE2S	(CPG_MFS09_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS09_UART_FCR0S_FCL1S	(CPG_MFS09_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS09_UART_FCR0S_FCL2S	(CPG_MFS09_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS09_UART_FCR0S_FSETS	(CPG_MFS09_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS09_UART_FCR0S_FLDS	(CPG_MFS09_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS10_UART_FCR0S	(CPG_MFS10_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_FCR0S_FE1S	(CPG_MFS10_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS10_UART_FCR0S_FE2S	(CPG_MFS10_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS10_UART_FCR0S_FCL1S	(CPG_MFS10_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS10_UART_FCR0S_FCL2S	(CPG_MFS10_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS10_UART_FCR0S_FSETS	(CPG_MFS10_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS10_UART_FCR0S_FLDS	(CPG_MFS10_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS11_UART_FCR0S	(CPG_MFS11_UART.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_FCR0S_FE1S	(CPG_MFS11_UART.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS11_UART_FCR0S_FE2S	(CPG_MFS11_UART.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS11_UART_FCR0S_FCL1S	(CPG_MFS11_UART.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS11_UART_FCR0S_FCL2S	(CPG_MFS11_UART.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS11_UART_FCR0S_FSETS	(CPG_MFS11_UART.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS11_UART_FCR0S_FLDS	(CPG_MFS11_UART.unFCR0S.stcField.u1FLDS)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_fcr0s_field{
    uint_io8_t		u1FE1S:1;
    uint_io8_t		u1FE2S:1;
    uint_io8_t		u1FCL1S:1;
    uint_io8_t		u1FCL2S:1;
    uint_io8_t		u1FSETS:1;
    uint_io8_t		u1FLDS:1;
    uint_io8_t		:2;
}stc_cpg_mfsn_uart_fcr0s_field_t;

typedef union un_cpg_mfsn_uart_fcr0s{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_fcr0s_field_t		stcField;
}un_cpg_mfsn_uart_fcr0s_t;

/* FCR1S */
#define CPG_MFS00_UART_FCR1S	(CPG_MFS00_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS00_UART_FCR1S_FSELS	(CPG_MFS00_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS00_UART_FCR1S_FTIES	(CPG_MFS00_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS00_UART_FCR1S_FRIIES	(CPG_MFS00_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS00_UART_FCR1S_FLSTES	(CPG_MFS00_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS01_UART_FCR1S	(CPG_MFS01_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS01_UART_FCR1S_FSELS	(CPG_MFS01_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS01_UART_FCR1S_FTIES	(CPG_MFS01_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS01_UART_FCR1S_FRIIES	(CPG_MFS01_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS01_UART_FCR1S_FLSTES	(CPG_MFS01_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS02_UART_FCR1S	(CPG_MFS02_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS02_UART_FCR1S_FSELS	(CPG_MFS02_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS02_UART_FCR1S_FTIES	(CPG_MFS02_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS02_UART_FCR1S_FRIIES	(CPG_MFS02_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS02_UART_FCR1S_FLSTES	(CPG_MFS02_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS03_UART_FCR1S	(CPG_MFS03_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS03_UART_FCR1S_FSELS	(CPG_MFS03_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS03_UART_FCR1S_FTIES	(CPG_MFS03_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS03_UART_FCR1S_FRIIES	(CPG_MFS03_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS03_UART_FCR1S_FLSTES	(CPG_MFS03_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS04_UART_FCR1S	(CPG_MFS04_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS04_UART_FCR1S_FSELS	(CPG_MFS04_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS04_UART_FCR1S_FTIES	(CPG_MFS04_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS04_UART_FCR1S_FRIIES	(CPG_MFS04_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS04_UART_FCR1S_FLSTES	(CPG_MFS04_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS05_UART_FCR1S	(CPG_MFS05_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS05_UART_FCR1S_FSELS	(CPG_MFS05_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS05_UART_FCR1S_FTIES	(CPG_MFS05_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS05_UART_FCR1S_FRIIES	(CPG_MFS05_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS05_UART_FCR1S_FLSTES	(CPG_MFS05_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS06_UART_FCR1S	(CPG_MFS06_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS06_UART_FCR1S_FSELS	(CPG_MFS06_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS06_UART_FCR1S_FTIES	(CPG_MFS06_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS06_UART_FCR1S_FRIIES	(CPG_MFS06_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS06_UART_FCR1S_FLSTES	(CPG_MFS06_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS07_UART_FCR1S	(CPG_MFS07_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS07_UART_FCR1S_FSELS	(CPG_MFS07_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS07_UART_FCR1S_FTIES	(CPG_MFS07_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS07_UART_FCR1S_FRIIES	(CPG_MFS07_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS07_UART_FCR1S_FLSTES	(CPG_MFS07_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS08_UART_FCR1S	(CPG_MFS08_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS08_UART_FCR1S_FSELS	(CPG_MFS08_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS08_UART_FCR1S_FTIES	(CPG_MFS08_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS08_UART_FCR1S_FRIIES	(CPG_MFS08_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS08_UART_FCR1S_FLSTES	(CPG_MFS08_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS09_UART_FCR1S	(CPG_MFS09_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS09_UART_FCR1S_FSELS	(CPG_MFS09_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS09_UART_FCR1S_FTIES	(CPG_MFS09_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS09_UART_FCR1S_FRIIES	(CPG_MFS09_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS09_UART_FCR1S_FLSTES	(CPG_MFS09_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS10_UART_FCR1S	(CPG_MFS10_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS10_UART_FCR1S_FSELS	(CPG_MFS10_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS10_UART_FCR1S_FTIES	(CPG_MFS10_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS10_UART_FCR1S_FRIIES	(CPG_MFS10_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS10_UART_FCR1S_FLSTES	(CPG_MFS10_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS11_UART_FCR1S	(CPG_MFS11_UART.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS11_UART_FCR1S_FSELS	(CPG_MFS11_UART.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS11_UART_FCR1S_FTIES	(CPG_MFS11_UART.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS11_UART_FCR1S_FRIIES	(CPG_MFS11_UART.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS11_UART_FCR1S_FLSTES	(CPG_MFS11_UART.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

typedef struct stc_cpg_mfsn_uart_fcr1s_field{
    uint_io8_t		u1FSELS:1;
    uint_io8_t		u1FTIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1FRIIES:1;
    uint_io8_t		u1FLSTES:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_uart_fcr1s_field_t;

typedef union un_cpg_mfsn_uart_fcr1s{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_uart_fcr1s_field_t		stcField;
}un_cpg_mfsn_uart_fcr1s_t;


typedef struct stc_cpg_mfsn_uart{
    un_cpg_mfsn_uart_smr_t	unSMR;	/* 0x00000000 */
    un_cpg_mfsn_uart_scr_t	unSCR;	/* 0x00000001 */
    un_cpg_mfsn_uart_escr_t	unESCR;	/* 0x00000002 */
    un_cpg_mfsn_uart_ssr_t	unSSR;	/* 0x00000003 */
    un_cpg_mfsn_uart_rdr_t	unRDR;	/* 0x00000004 */
    uint_io8_t	au8Reserved0[2];	/* 0x00000006 */
    un_cpg_mfsn_uart_sacsr_t	unSACSR;	/* 0x00000008 */
    un_cpg_mfsn_uart_stmr_t	unSTMR;	/* 0x0000000A */
    un_cpg_mfsn_uart_stmcr_t	unSTMCR;	/* 0x0000000C */
    uint_io8_t	au8Reserved1[10];	/* 0x0000000E */
    un_cpg_mfsn_uart_tbyte0_t	unTBYTE0;	/* 0x00000018 */
    uint_io8_t	au8Reserved2[3];	/* 0x00000019 */
    un_cpg_mfsn_uart_bgr_t	unBGR;	/* 0x0000001C */
    uint_io8_t	au8Reserved3[2];	/* 0x0000001E */
    un_cpg_mfsn_uart_fcr0_t	unFCR0;	/* 0x00000020 */
    un_cpg_mfsn_uart_fcr1_t	unFCR1;	/* 0x00000021 */
    un_cpg_mfsn_uart_fbyte_t	unFBYTE;	/* 0x00000022 */
    un_cpg_mfsn_uart_fticr_t	unFTICR;	/* 0x00000024 */
    un_cpg_mfsn_uart_ecr_t	unECR;	/* 0x00000026 */
    un_cpg_mfsn_uart_esr_t	unESR;	/* 0x00000027 */
    un_cpg_mfsn_uart_tbsize_t	unTBSIZE;	/* 0x00000028 */
    uint_io8_t	au8Reserved4[7];	/* 0x00000029 */
    un_cpg_mfsn_uart_sacsrc_t	unSACSRC;	/* 0x00000030 */
    uint_io8_t	au8Reserved5[10];	/* 0x00000032 */
    un_cpg_mfsn_uart_fcr0c_t	unFCR0C;	/* 0x0000003C */
    un_cpg_mfsn_uart_fcr1c_t	unFCR1C;	/* 0x0000003D */
    uint_io8_t	au8Reserved6[5];	/* 0x0000003E */
    un_cpg_mfsn_uart_esrc_t	unESRC;	/* 0x00000043 */
    uint_io8_t	au8Reserved7[4];	/* 0x00000044 */
    un_cpg_mfsn_uart_sacsrs_t	unSACSRS;	/* 0x00000048 */
    uint_io8_t	au8Reserved8[10];	/* 0x0000004A */
    un_cpg_mfsn_uart_fcr0s_t	unFCR0S;	/* 0x00000054 */
    un_cpg_mfsn_uart_fcr1s_t	unFCR1S;	/* 0x00000055 */
    uint_io8_t	au8Reserved9[938];	/* 0x00000056 */
}stc_cpg_mfsn_uart_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_cpg_mfsn_uart_t	stcCPG_MFS_UART[12];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_MFS_UART_H */
