/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_IRC_H
#define __S6J3360_IRC_H

#include "s6j3360io_basetypes.h"

/* IRC0 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define IRC0	stcIRC0
#else /* __IO_DEFINE */
#define IRC0	(*((volatile stc_irc0_t*)0xB0400000))
#endif /* __IO_DEFINE */

/* NMIVAS */
#define IRC0_NMIVAS	(IRC0.unNMIVAS.u32Register)  /*@rg@*/
#define IRC0_NMIVAS_NMIVAS	IRC0_NMIVAS  /*@bfrg@*/

typedef union un_irc0_nmivas{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmivas_t;

/* NMIST */
#define IRC0_NMIST	(IRC0.unNMIST.u32Register)  /*@rg@*/
#define IRC0_NMIST_NMISN	(IRC0.unNMIST.stcField.u6NMISN)  /*@bf@*/
#define IRC0_NMIST_NMIPS	(IRC0.unNMIST.stcField.u4NMIPS)  /*@bf@*/

typedef struct stc_irc0_nmist_field{
    uint_io32_t		u6NMISN:6;
    uint_io32_t		:2;
    uint_io32_t		u4NMIPS:4;
    uint_io32_t		:20;
}stc_irc0_nmist_field_t;

typedef union un_irc0_nmist{
    uint_io32_t		u32Register;
    stc_irc0_nmist_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmist_t;

/* IRQVAS */
#define IRC0_IRQVAS	(IRC0.unIRQVAS.u32Register)  /*@rg@*/
#define IRC0_IRQVAS_IRQVAS	IRC0_IRQVAS  /*@bfrg@*/

typedef union un_irc0_irqvas{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqvas_t;

/* IRQST */
#define IRC0_IRQST	(IRC0.unIRQST.u32Register)  /*@rg@*/
#define IRC0_IRQST_IRQSN	(IRC0.unIRQST.stcField.u10IRQSN)  /*@bf@*/
#define IRC0_IRQST_IRQPS	(IRC0.unIRQST.stcField.u5IRQPS)  /*@bf@*/
#define IRC0_IRQST_nIRQ	(IRC0.unIRQST.stcField.u1nIRQ)  /*@bf@*/
#define IRC0_IRQST_NIRQ	IRC0_IRQST_nIRQ  /*@bf2@*/

typedef struct stc_irc0_irqst_field{
    uint_io32_t		u10IRQSN:10;
    uint_io32_t		:6;
    uint_io32_t		u5IRQPS:5;
    uint_io32_t		:3;
    uint_io32_t		u1nIRQ:1;
    uint_io32_t		:7;
}stc_irc0_irqst_field_t;

typedef union un_irc0_irqst{
    uint_io32_t		u32Register;
    stc_irc0_irqst_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqst_t;

/* NMIVA[0-31] */
#define IRC0_NMIVA0	(IRC0.unNMIVA0.u32Register)  /*@rg@*/
#define IRC0_NMIVA0_NMIVA	IRC0_NMIVA0  /*@bfrg@*/

#define IRC0_NMIVA1	(IRC0.unNMIVA1.u32Register)  /*@rg@*/
#define IRC0_NMIVA1_NMIVA	IRC0_NMIVA1  /*@bfrg@*/

#define IRC0_NMIVA2	(IRC0.unNMIVA2.u32Register)  /*@rg@*/
#define IRC0_NMIVA2_NMIVA	IRC0_NMIVA2  /*@bfrg@*/

#define IRC0_NMIVA3	(IRC0.unNMIVA3.u32Register)  /*@rg@*/
#define IRC0_NMIVA3_NMIVA	IRC0_NMIVA3  /*@bfrg@*/

#define IRC0_NMIVA4	(IRC0.unNMIVA4.u32Register)  /*@rg@*/
#define IRC0_NMIVA4_NMIVA	IRC0_NMIVA4  /*@bfrg@*/

#define IRC0_NMIVA5	(IRC0.unNMIVA5.u32Register)  /*@rg@*/
#define IRC0_NMIVA5_NMIVA	IRC0_NMIVA5  /*@bfrg@*/

#define IRC0_NMIVA6	(IRC0.unNMIVA6.u32Register)  /*@rg@*/
#define IRC0_NMIVA6_NMIVA	IRC0_NMIVA6  /*@bfrg@*/

#define IRC0_NMIVA7	(IRC0.unNMIVA7.u32Register)  /*@rg@*/
#define IRC0_NMIVA7_NMIVA	IRC0_NMIVA7  /*@bfrg@*/

#define IRC0_NMIVA8	(IRC0.unNMIVA8.u32Register)  /*@rg@*/
#define IRC0_NMIVA8_NMIVA	IRC0_NMIVA8  /*@bfrg@*/

#define IRC0_NMIVA9	(IRC0.unNMIVA9.u32Register)  /*@rg@*/
#define IRC0_NMIVA9_NMIVA	IRC0_NMIVA9  /*@bfrg@*/

#define IRC0_NMIVA10	(IRC0.unNMIVA10.u32Register)  /*@rg@*/
#define IRC0_NMIVA10_NMIVA	IRC0_NMIVA10  /*@bfrg@*/

#define IRC0_NMIVA11	(IRC0.unNMIVA11.u32Register)  /*@rg@*/
#define IRC0_NMIVA11_NMIVA	IRC0_NMIVA11  /*@bfrg@*/

#define IRC0_NMIVA12	(IRC0.unNMIVA12.u32Register)  /*@rg@*/
#define IRC0_NMIVA12_NMIVA	IRC0_NMIVA12  /*@bfrg@*/

#define IRC0_NMIVA13	(IRC0.unNMIVA13.u32Register)  /*@rg@*/
#define IRC0_NMIVA13_NMIVA	IRC0_NMIVA13  /*@bfrg@*/

#define IRC0_NMIVA14	(IRC0.unNMIVA14.u32Register)  /*@rg@*/
#define IRC0_NMIVA14_NMIVA	IRC0_NMIVA14  /*@bfrg@*/

#define IRC0_NMIVA15	(IRC0.unNMIVA15.u32Register)  /*@rg@*/
#define IRC0_NMIVA15_NMIVA	IRC0_NMIVA15  /*@bfrg@*/

#define IRC0_NMIVA16	(IRC0.unNMIVA16.u32Register)  /*@rg@*/
#define IRC0_NMIVA16_NMIVA	IRC0_NMIVA16  /*@bfrg@*/

#define IRC0_NMIVA17	(IRC0.unNMIVA17.u32Register)  /*@rg@*/
#define IRC0_NMIVA17_NMIVA	IRC0_NMIVA17  /*@bfrg@*/

#define IRC0_NMIVA18	(IRC0.unNMIVA18.u32Register)  /*@rg@*/
#define IRC0_NMIVA18_NMIVA	IRC0_NMIVA18  /*@bfrg@*/

#define IRC0_NMIVA19	(IRC0.unNMIVA19.u32Register)  /*@rg@*/
#define IRC0_NMIVA19_NMIVA	IRC0_NMIVA19  /*@bfrg@*/

#define IRC0_NMIVA20	(IRC0.unNMIVA20.u32Register)  /*@rg@*/
#define IRC0_NMIVA20_NMIVA	IRC0_NMIVA20  /*@bfrg@*/

#define IRC0_NMIVA21	(IRC0.unNMIVA21.u32Register)  /*@rg@*/
#define IRC0_NMIVA21_NMIVA	IRC0_NMIVA21  /*@bfrg@*/

#define IRC0_NMIVA22	(IRC0.unNMIVA22.u32Register)  /*@rg@*/
#define IRC0_NMIVA22_NMIVA	IRC0_NMIVA22  /*@bfrg@*/

#define IRC0_NMIVA23	(IRC0.unNMIVA23.u32Register)  /*@rg@*/
#define IRC0_NMIVA23_NMIVA	IRC0_NMIVA23  /*@bfrg@*/

#define IRC0_NMIVA24	(IRC0.unNMIVA24.u32Register)  /*@rg@*/
#define IRC0_NMIVA24_NMIVA	IRC0_NMIVA24  /*@bfrg@*/

#define IRC0_NMIVA25	(IRC0.unNMIVA25.u32Register)  /*@rg@*/
#define IRC0_NMIVA25_NMIVA	IRC0_NMIVA25  /*@bfrg@*/

#define IRC0_NMIVA26	(IRC0.unNMIVA26.u32Register)  /*@rg@*/
#define IRC0_NMIVA26_NMIVA	IRC0_NMIVA26  /*@bfrg@*/

#define IRC0_NMIVA27	(IRC0.unNMIVA27.u32Register)  /*@rg@*/
#define IRC0_NMIVA27_NMIVA	IRC0_NMIVA27  /*@bfrg@*/

#define IRC0_NMIVA28	(IRC0.unNMIVA28.u32Register)  /*@rg@*/
#define IRC0_NMIVA28_NMIVA	IRC0_NMIVA28  /*@bfrg@*/

#define IRC0_NMIVA29	(IRC0.unNMIVA29.u32Register)  /*@rg@*/
#define IRC0_NMIVA29_NMIVA	IRC0_NMIVA29  /*@bfrg@*/

#define IRC0_NMIVA30	(IRC0.unNMIVA30.u32Register)  /*@rg@*/
#define IRC0_NMIVA30_NMIVA	IRC0_NMIVA30  /*@bfrg@*/

#define IRC0_NMIVA31	(IRC0.unNMIVA31.u32Register)  /*@rg@*/
#define IRC0_NMIVA31_NMIVA	IRC0_NMIVA31  /*@bfrg@*/

typedef union un_irc0_nmivan{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmivan_t;

/* IRQVA[0-511] */
#define IRC0_IRQVA0	(IRC0.unIRQVA0.u32Register)  /*@rg@*/
#define IRC0_IRQVA0_IRQVA	IRC0_IRQVA0  /*@bfrg@*/

#define IRC0_IRQVA1	(IRC0.unIRQVA1.u32Register)  /*@rg@*/
#define IRC0_IRQVA1_IRQVA	IRC0_IRQVA1  /*@bfrg@*/

#define IRC0_IRQVA2	(IRC0.unIRQVA2.u32Register)  /*@rg@*/
#define IRC0_IRQVA2_IRQVA	IRC0_IRQVA2  /*@bfrg@*/

#define IRC0_IRQVA3	(IRC0.unIRQVA3.u32Register)  /*@rg@*/
#define IRC0_IRQVA3_IRQVA	IRC0_IRQVA3  /*@bfrg@*/

#define IRC0_IRQVA4	(IRC0.unIRQVA4.u32Register)  /*@rg@*/
#define IRC0_IRQVA4_IRQVA	IRC0_IRQVA4  /*@bfrg@*/

#define IRC0_IRQVA5	(IRC0.unIRQVA5.u32Register)  /*@rg@*/
#define IRC0_IRQVA5_IRQVA	IRC0_IRQVA5  /*@bfrg@*/

#define IRC0_IRQVA6	(IRC0.unIRQVA6.u32Register)  /*@rg@*/
#define IRC0_IRQVA6_IRQVA	IRC0_IRQVA6  /*@bfrg@*/

#define IRC0_IRQVA7	(IRC0.unIRQVA7.u32Register)  /*@rg@*/
#define IRC0_IRQVA7_IRQVA	IRC0_IRQVA7  /*@bfrg@*/

#define IRC0_IRQVA8	(IRC0.unIRQVA8.u32Register)  /*@rg@*/
#define IRC0_IRQVA8_IRQVA	IRC0_IRQVA8  /*@bfrg@*/

#define IRC0_IRQVA9	(IRC0.unIRQVA9.u32Register)  /*@rg@*/
#define IRC0_IRQVA9_IRQVA	IRC0_IRQVA9  /*@bfrg@*/

#define IRC0_IRQVA10	(IRC0.unIRQVA10.u32Register)  /*@rg@*/
#define IRC0_IRQVA10_IRQVA	IRC0_IRQVA10  /*@bfrg@*/

#define IRC0_IRQVA11	(IRC0.unIRQVA11.u32Register)  /*@rg@*/
#define IRC0_IRQVA11_IRQVA	IRC0_IRQVA11  /*@bfrg@*/

#define IRC0_IRQVA12	(IRC0.unIRQVA12.u32Register)  /*@rg@*/
#define IRC0_IRQVA12_IRQVA	IRC0_IRQVA12  /*@bfrg@*/

#define IRC0_IRQVA13	(IRC0.unIRQVA13.u32Register)  /*@rg@*/
#define IRC0_IRQVA13_IRQVA	IRC0_IRQVA13  /*@bfrg@*/

#define IRC0_IRQVA14	(IRC0.unIRQVA14.u32Register)  /*@rg@*/
#define IRC0_IRQVA14_IRQVA	IRC0_IRQVA14  /*@bfrg@*/

#define IRC0_IRQVA15	(IRC0.unIRQVA15.u32Register)  /*@rg@*/
#define IRC0_IRQVA15_IRQVA	IRC0_IRQVA15  /*@bfrg@*/

#define IRC0_IRQVA16	(IRC0.unIRQVA16.u32Register)  /*@rg@*/
#define IRC0_IRQVA16_IRQVA	IRC0_IRQVA16  /*@bfrg@*/

#define IRC0_IRQVA17	(IRC0.unIRQVA17.u32Register)  /*@rg@*/
#define IRC0_IRQVA17_IRQVA	IRC0_IRQVA17  /*@bfrg@*/

#define IRC0_IRQVA18	(IRC0.unIRQVA18.u32Register)  /*@rg@*/
#define IRC0_IRQVA18_IRQVA	IRC0_IRQVA18  /*@bfrg@*/

#define IRC0_IRQVA19	(IRC0.unIRQVA19.u32Register)  /*@rg@*/
#define IRC0_IRQVA19_IRQVA	IRC0_IRQVA19  /*@bfrg@*/

#define IRC0_IRQVA20	(IRC0.unIRQVA20.u32Register)  /*@rg@*/
#define IRC0_IRQVA20_IRQVA	IRC0_IRQVA20  /*@bfrg@*/

#define IRC0_IRQVA21	(IRC0.unIRQVA21.u32Register)  /*@rg@*/
#define IRC0_IRQVA21_IRQVA	IRC0_IRQVA21  /*@bfrg@*/

#define IRC0_IRQVA22	(IRC0.unIRQVA22.u32Register)  /*@rg@*/
#define IRC0_IRQVA22_IRQVA	IRC0_IRQVA22  /*@bfrg@*/

#define IRC0_IRQVA23	(IRC0.unIRQVA23.u32Register)  /*@rg@*/
#define IRC0_IRQVA23_IRQVA	IRC0_IRQVA23  /*@bfrg@*/

#define IRC0_IRQVA24	(IRC0.unIRQVA24.u32Register)  /*@rg@*/
#define IRC0_IRQVA24_IRQVA	IRC0_IRQVA24  /*@bfrg@*/

#define IRC0_IRQVA25	(IRC0.unIRQVA25.u32Register)  /*@rg@*/
#define IRC0_IRQVA25_IRQVA	IRC0_IRQVA25  /*@bfrg@*/

#define IRC0_IRQVA26	(IRC0.unIRQVA26.u32Register)  /*@rg@*/
#define IRC0_IRQVA26_IRQVA	IRC0_IRQVA26  /*@bfrg@*/

#define IRC0_IRQVA27	(IRC0.unIRQVA27.u32Register)  /*@rg@*/
#define IRC0_IRQVA27_IRQVA	IRC0_IRQVA27  /*@bfrg@*/

#define IRC0_IRQVA28	(IRC0.unIRQVA28.u32Register)  /*@rg@*/
#define IRC0_IRQVA28_IRQVA	IRC0_IRQVA28  /*@bfrg@*/

#define IRC0_IRQVA29	(IRC0.unIRQVA29.u32Register)  /*@rg@*/
#define IRC0_IRQVA29_IRQVA	IRC0_IRQVA29  /*@bfrg@*/

#define IRC0_IRQVA30	(IRC0.unIRQVA30.u32Register)  /*@rg@*/
#define IRC0_IRQVA30_IRQVA	IRC0_IRQVA30  /*@bfrg@*/

#define IRC0_IRQVA31	(IRC0.unIRQVA31.u32Register)  /*@rg@*/
#define IRC0_IRQVA31_IRQVA	IRC0_IRQVA31  /*@bfrg@*/

#define IRC0_IRQVA32	(IRC0.unIRQVA32.u32Register)  /*@rg@*/
#define IRC0_IRQVA32_IRQVA	IRC0_IRQVA32  /*@bfrg@*/

#define IRC0_IRQVA33	(IRC0.unIRQVA33.u32Register)  /*@rg@*/
#define IRC0_IRQVA33_IRQVA	IRC0_IRQVA33  /*@bfrg@*/

#define IRC0_IRQVA34	(IRC0.unIRQVA34.u32Register)  /*@rg@*/
#define IRC0_IRQVA34_IRQVA	IRC0_IRQVA34  /*@bfrg@*/

#define IRC0_IRQVA35	(IRC0.unIRQVA35.u32Register)  /*@rg@*/
#define IRC0_IRQVA35_IRQVA	IRC0_IRQVA35  /*@bfrg@*/

#define IRC0_IRQVA36	(IRC0.unIRQVA36.u32Register)  /*@rg@*/
#define IRC0_IRQVA36_IRQVA	IRC0_IRQVA36  /*@bfrg@*/

#define IRC0_IRQVA37	(IRC0.unIRQVA37.u32Register)  /*@rg@*/
#define IRC0_IRQVA37_IRQVA	IRC0_IRQVA37  /*@bfrg@*/

#define IRC0_IRQVA38	(IRC0.unIRQVA38.u32Register)  /*@rg@*/
#define IRC0_IRQVA38_IRQVA	IRC0_IRQVA38  /*@bfrg@*/

#define IRC0_IRQVA39	(IRC0.unIRQVA39.u32Register)  /*@rg@*/
#define IRC0_IRQVA39_IRQVA	IRC0_IRQVA39  /*@bfrg@*/

#define IRC0_IRQVA40	(IRC0.unIRQVA40.u32Register)  /*@rg@*/
#define IRC0_IRQVA40_IRQVA	IRC0_IRQVA40  /*@bfrg@*/

#define IRC0_IRQVA41	(IRC0.unIRQVA41.u32Register)  /*@rg@*/
#define IRC0_IRQVA41_IRQVA	IRC0_IRQVA41  /*@bfrg@*/

#define IRC0_IRQVA42	(IRC0.unIRQVA42.u32Register)  /*@rg@*/
#define IRC0_IRQVA42_IRQVA	IRC0_IRQVA42  /*@bfrg@*/

#define IRC0_IRQVA43	(IRC0.unIRQVA43.u32Register)  /*@rg@*/
#define IRC0_IRQVA43_IRQVA	IRC0_IRQVA43  /*@bfrg@*/

#define IRC0_IRQVA44	(IRC0.unIRQVA44.u32Register)  /*@rg@*/
#define IRC0_IRQVA44_IRQVA	IRC0_IRQVA44  /*@bfrg@*/

#define IRC0_IRQVA45	(IRC0.unIRQVA45.u32Register)  /*@rg@*/
#define IRC0_IRQVA45_IRQVA	IRC0_IRQVA45  /*@bfrg@*/

#define IRC0_IRQVA46	(IRC0.unIRQVA46.u32Register)  /*@rg@*/
#define IRC0_IRQVA46_IRQVA	IRC0_IRQVA46  /*@bfrg@*/

#define IRC0_IRQVA47	(IRC0.unIRQVA47.u32Register)  /*@rg@*/
#define IRC0_IRQVA47_IRQVA	IRC0_IRQVA47  /*@bfrg@*/

#define IRC0_IRQVA48	(IRC0.unIRQVA48.u32Register)  /*@rg@*/
#define IRC0_IRQVA48_IRQVA	IRC0_IRQVA48  /*@bfrg@*/

#define IRC0_IRQVA49	(IRC0.unIRQVA49.u32Register)  /*@rg@*/
#define IRC0_IRQVA49_IRQVA	IRC0_IRQVA49  /*@bfrg@*/

#define IRC0_IRQVA50	(IRC0.unIRQVA50.u32Register)  /*@rg@*/
#define IRC0_IRQVA50_IRQVA	IRC0_IRQVA50  /*@bfrg@*/

#define IRC0_IRQVA51	(IRC0.unIRQVA51.u32Register)  /*@rg@*/
#define IRC0_IRQVA51_IRQVA	IRC0_IRQVA51  /*@bfrg@*/

#define IRC0_IRQVA52	(IRC0.unIRQVA52.u32Register)  /*@rg@*/
#define IRC0_IRQVA52_IRQVA	IRC0_IRQVA52  /*@bfrg@*/

#define IRC0_IRQVA53	(IRC0.unIRQVA53.u32Register)  /*@rg@*/
#define IRC0_IRQVA53_IRQVA	IRC0_IRQVA53  /*@bfrg@*/

#define IRC0_IRQVA54	(IRC0.unIRQVA54.u32Register)  /*@rg@*/
#define IRC0_IRQVA54_IRQVA	IRC0_IRQVA54  /*@bfrg@*/

#define IRC0_IRQVA55	(IRC0.unIRQVA55.u32Register)  /*@rg@*/
#define IRC0_IRQVA55_IRQVA	IRC0_IRQVA55  /*@bfrg@*/

#define IRC0_IRQVA56	(IRC0.unIRQVA56.u32Register)  /*@rg@*/
#define IRC0_IRQVA56_IRQVA	IRC0_IRQVA56  /*@bfrg@*/

#define IRC0_IRQVA57	(IRC0.unIRQVA57.u32Register)  /*@rg@*/
#define IRC0_IRQVA57_IRQVA	IRC0_IRQVA57  /*@bfrg@*/

#define IRC0_IRQVA58	(IRC0.unIRQVA58.u32Register)  /*@rg@*/
#define IRC0_IRQVA58_IRQVA	IRC0_IRQVA58  /*@bfrg@*/

#define IRC0_IRQVA59	(IRC0.unIRQVA59.u32Register)  /*@rg@*/
#define IRC0_IRQVA59_IRQVA	IRC0_IRQVA59  /*@bfrg@*/

#define IRC0_IRQVA60	(IRC0.unIRQVA60.u32Register)  /*@rg@*/
#define IRC0_IRQVA60_IRQVA	IRC0_IRQVA60  /*@bfrg@*/

#define IRC0_IRQVA61	(IRC0.unIRQVA61.u32Register)  /*@rg@*/
#define IRC0_IRQVA61_IRQVA	IRC0_IRQVA61  /*@bfrg@*/

#define IRC0_IRQVA62	(IRC0.unIRQVA62.u32Register)  /*@rg@*/
#define IRC0_IRQVA62_IRQVA	IRC0_IRQVA62  /*@bfrg@*/

#define IRC0_IRQVA63	(IRC0.unIRQVA63.u32Register)  /*@rg@*/
#define IRC0_IRQVA63_IRQVA	IRC0_IRQVA63  /*@bfrg@*/

#define IRC0_IRQVA64	(IRC0.unIRQVA64.u32Register)  /*@rg@*/
#define IRC0_IRQVA64_IRQVA	IRC0_IRQVA64  /*@bfrg@*/

#define IRC0_IRQVA65	(IRC0.unIRQVA65.u32Register)  /*@rg@*/
#define IRC0_IRQVA65_IRQVA	IRC0_IRQVA65  /*@bfrg@*/

#define IRC0_IRQVA66	(IRC0.unIRQVA66.u32Register)  /*@rg@*/
#define IRC0_IRQVA66_IRQVA	IRC0_IRQVA66  /*@bfrg@*/

#define IRC0_IRQVA67	(IRC0.unIRQVA67.u32Register)  /*@rg@*/
#define IRC0_IRQVA67_IRQVA	IRC0_IRQVA67  /*@bfrg@*/

#define IRC0_IRQVA68	(IRC0.unIRQVA68.u32Register)  /*@rg@*/
#define IRC0_IRQVA68_IRQVA	IRC0_IRQVA68  /*@bfrg@*/

#define IRC0_IRQVA69	(IRC0.unIRQVA69.u32Register)  /*@rg@*/
#define IRC0_IRQVA69_IRQVA	IRC0_IRQVA69  /*@bfrg@*/

#define IRC0_IRQVA70	(IRC0.unIRQVA70.u32Register)  /*@rg@*/
#define IRC0_IRQVA70_IRQVA	IRC0_IRQVA70  /*@bfrg@*/

#define IRC0_IRQVA71	(IRC0.unIRQVA71.u32Register)  /*@rg@*/
#define IRC0_IRQVA71_IRQVA	IRC0_IRQVA71  /*@bfrg@*/

#define IRC0_IRQVA72	(IRC0.unIRQVA72.u32Register)  /*@rg@*/
#define IRC0_IRQVA72_IRQVA	IRC0_IRQVA72  /*@bfrg@*/

#define IRC0_IRQVA73	(IRC0.unIRQVA73.u32Register)  /*@rg@*/
#define IRC0_IRQVA73_IRQVA	IRC0_IRQVA73  /*@bfrg@*/

#define IRC0_IRQVA74	(IRC0.unIRQVA74.u32Register)  /*@rg@*/
#define IRC0_IRQVA74_IRQVA	IRC0_IRQVA74  /*@bfrg@*/

#define IRC0_IRQVA75	(IRC0.unIRQVA75.u32Register)  /*@rg@*/
#define IRC0_IRQVA75_IRQVA	IRC0_IRQVA75  /*@bfrg@*/

#define IRC0_IRQVA76	(IRC0.unIRQVA76.u32Register)  /*@rg@*/
#define IRC0_IRQVA76_IRQVA	IRC0_IRQVA76  /*@bfrg@*/

#define IRC0_IRQVA77	(IRC0.unIRQVA77.u32Register)  /*@rg@*/
#define IRC0_IRQVA77_IRQVA	IRC0_IRQVA77  /*@bfrg@*/

#define IRC0_IRQVA78	(IRC0.unIRQVA78.u32Register)  /*@rg@*/
#define IRC0_IRQVA78_IRQVA	IRC0_IRQVA78  /*@bfrg@*/

#define IRC0_IRQVA79	(IRC0.unIRQVA79.u32Register)  /*@rg@*/
#define IRC0_IRQVA79_IRQVA	IRC0_IRQVA79  /*@bfrg@*/

#define IRC0_IRQVA80	(IRC0.unIRQVA80.u32Register)  /*@rg@*/
#define IRC0_IRQVA80_IRQVA	IRC0_IRQVA80  /*@bfrg@*/

#define IRC0_IRQVA81	(IRC0.unIRQVA81.u32Register)  /*@rg@*/
#define IRC0_IRQVA81_IRQVA	IRC0_IRQVA81  /*@bfrg@*/

#define IRC0_IRQVA82	(IRC0.unIRQVA82.u32Register)  /*@rg@*/
#define IRC0_IRQVA82_IRQVA	IRC0_IRQVA82  /*@bfrg@*/

#define IRC0_IRQVA83	(IRC0.unIRQVA83.u32Register)  /*@rg@*/
#define IRC0_IRQVA83_IRQVA	IRC0_IRQVA83  /*@bfrg@*/

#define IRC0_IRQVA84	(IRC0.unIRQVA84.u32Register)  /*@rg@*/
#define IRC0_IRQVA84_IRQVA	IRC0_IRQVA84  /*@bfrg@*/

#define IRC0_IRQVA85	(IRC0.unIRQVA85.u32Register)  /*@rg@*/
#define IRC0_IRQVA85_IRQVA	IRC0_IRQVA85  /*@bfrg@*/

#define IRC0_IRQVA86	(IRC0.unIRQVA86.u32Register)  /*@rg@*/
#define IRC0_IRQVA86_IRQVA	IRC0_IRQVA86  /*@bfrg@*/

#define IRC0_IRQVA87	(IRC0.unIRQVA87.u32Register)  /*@rg@*/
#define IRC0_IRQVA87_IRQVA	IRC0_IRQVA87  /*@bfrg@*/

#define IRC0_IRQVA88	(IRC0.unIRQVA88.u32Register)  /*@rg@*/
#define IRC0_IRQVA88_IRQVA	IRC0_IRQVA88  /*@bfrg@*/

#define IRC0_IRQVA89	(IRC0.unIRQVA89.u32Register)  /*@rg@*/
#define IRC0_IRQVA89_IRQVA	IRC0_IRQVA89  /*@bfrg@*/

#define IRC0_IRQVA90	(IRC0.unIRQVA90.u32Register)  /*@rg@*/
#define IRC0_IRQVA90_IRQVA	IRC0_IRQVA90  /*@bfrg@*/

#define IRC0_IRQVA91	(IRC0.unIRQVA91.u32Register)  /*@rg@*/
#define IRC0_IRQVA91_IRQVA	IRC0_IRQVA91  /*@bfrg@*/

#define IRC0_IRQVA92	(IRC0.unIRQVA92.u32Register)  /*@rg@*/
#define IRC0_IRQVA92_IRQVA	IRC0_IRQVA92  /*@bfrg@*/

#define IRC0_IRQVA93	(IRC0.unIRQVA93.u32Register)  /*@rg@*/
#define IRC0_IRQVA93_IRQVA	IRC0_IRQVA93  /*@bfrg@*/

#define IRC0_IRQVA94	(IRC0.unIRQVA94.u32Register)  /*@rg@*/
#define IRC0_IRQVA94_IRQVA	IRC0_IRQVA94  /*@bfrg@*/

#define IRC0_IRQVA95	(IRC0.unIRQVA95.u32Register)  /*@rg@*/
#define IRC0_IRQVA95_IRQVA	IRC0_IRQVA95  /*@bfrg@*/

#define IRC0_IRQVA96	(IRC0.unIRQVA96.u32Register)  /*@rg@*/
#define IRC0_IRQVA96_IRQVA	IRC0_IRQVA96  /*@bfrg@*/

#define IRC0_IRQVA97	(IRC0.unIRQVA97.u32Register)  /*@rg@*/
#define IRC0_IRQVA97_IRQVA	IRC0_IRQVA97  /*@bfrg@*/

#define IRC0_IRQVA98	(IRC0.unIRQVA98.u32Register)  /*@rg@*/
#define IRC0_IRQVA98_IRQVA	IRC0_IRQVA98  /*@bfrg@*/

#define IRC0_IRQVA99	(IRC0.unIRQVA99.u32Register)  /*@rg@*/
#define IRC0_IRQVA99_IRQVA	IRC0_IRQVA99  /*@bfrg@*/

#define IRC0_IRQVA100	(IRC0.unIRQVA100.u32Register)  /*@rg@*/
#define IRC0_IRQVA100_IRQVA	IRC0_IRQVA100  /*@bfrg@*/

#define IRC0_IRQVA101	(IRC0.unIRQVA101.u32Register)  /*@rg@*/
#define IRC0_IRQVA101_IRQVA	IRC0_IRQVA101  /*@bfrg@*/

#define IRC0_IRQVA102	(IRC0.unIRQVA102.u32Register)  /*@rg@*/
#define IRC0_IRQVA102_IRQVA	IRC0_IRQVA102  /*@bfrg@*/

#define IRC0_IRQVA103	(IRC0.unIRQVA103.u32Register)  /*@rg@*/
#define IRC0_IRQVA103_IRQVA	IRC0_IRQVA103  /*@bfrg@*/

#define IRC0_IRQVA104	(IRC0.unIRQVA104.u32Register)  /*@rg@*/
#define IRC0_IRQVA104_IRQVA	IRC0_IRQVA104  /*@bfrg@*/

#define IRC0_IRQVA105	(IRC0.unIRQVA105.u32Register)  /*@rg@*/
#define IRC0_IRQVA105_IRQVA	IRC0_IRQVA105  /*@bfrg@*/

#define IRC0_IRQVA106	(IRC0.unIRQVA106.u32Register)  /*@rg@*/
#define IRC0_IRQVA106_IRQVA	IRC0_IRQVA106  /*@bfrg@*/

#define IRC0_IRQVA107	(IRC0.unIRQVA107.u32Register)  /*@rg@*/
#define IRC0_IRQVA107_IRQVA	IRC0_IRQVA107  /*@bfrg@*/

#define IRC0_IRQVA108	(IRC0.unIRQVA108.u32Register)  /*@rg@*/
#define IRC0_IRQVA108_IRQVA	IRC0_IRQVA108  /*@bfrg@*/

#define IRC0_IRQVA109	(IRC0.unIRQVA109.u32Register)  /*@rg@*/
#define IRC0_IRQVA109_IRQVA	IRC0_IRQVA109  /*@bfrg@*/

#define IRC0_IRQVA110	(IRC0.unIRQVA110.u32Register)  /*@rg@*/
#define IRC0_IRQVA110_IRQVA	IRC0_IRQVA110  /*@bfrg@*/

#define IRC0_IRQVA111	(IRC0.unIRQVA111.u32Register)  /*@rg@*/
#define IRC0_IRQVA111_IRQVA	IRC0_IRQVA111  /*@bfrg@*/

#define IRC0_IRQVA112	(IRC0.unIRQVA112.u32Register)  /*@rg@*/
#define IRC0_IRQVA112_IRQVA	IRC0_IRQVA112  /*@bfrg@*/

#define IRC0_IRQVA113	(IRC0.unIRQVA113.u32Register)  /*@rg@*/
#define IRC0_IRQVA113_IRQVA	IRC0_IRQVA113  /*@bfrg@*/

#define IRC0_IRQVA114	(IRC0.unIRQVA114.u32Register)  /*@rg@*/
#define IRC0_IRQVA114_IRQVA	IRC0_IRQVA114  /*@bfrg@*/

#define IRC0_IRQVA115	(IRC0.unIRQVA115.u32Register)  /*@rg@*/
#define IRC0_IRQVA115_IRQVA	IRC0_IRQVA115  /*@bfrg@*/

#define IRC0_IRQVA116	(IRC0.unIRQVA116.u32Register)  /*@rg@*/
#define IRC0_IRQVA116_IRQVA	IRC0_IRQVA116  /*@bfrg@*/

#define IRC0_IRQVA117	(IRC0.unIRQVA117.u32Register)  /*@rg@*/
#define IRC0_IRQVA117_IRQVA	IRC0_IRQVA117  /*@bfrg@*/

#define IRC0_IRQVA118	(IRC0.unIRQVA118.u32Register)  /*@rg@*/
#define IRC0_IRQVA118_IRQVA	IRC0_IRQVA118  /*@bfrg@*/

#define IRC0_IRQVA119	(IRC0.unIRQVA119.u32Register)  /*@rg@*/
#define IRC0_IRQVA119_IRQVA	IRC0_IRQVA119  /*@bfrg@*/

#define IRC0_IRQVA120	(IRC0.unIRQVA120.u32Register)  /*@rg@*/
#define IRC0_IRQVA120_IRQVA	IRC0_IRQVA120  /*@bfrg@*/

#define IRC0_IRQVA121	(IRC0.unIRQVA121.u32Register)  /*@rg@*/
#define IRC0_IRQVA121_IRQVA	IRC0_IRQVA121  /*@bfrg@*/

#define IRC0_IRQVA122	(IRC0.unIRQVA122.u32Register)  /*@rg@*/
#define IRC0_IRQVA122_IRQVA	IRC0_IRQVA122  /*@bfrg@*/

#define IRC0_IRQVA123	(IRC0.unIRQVA123.u32Register)  /*@rg@*/
#define IRC0_IRQVA123_IRQVA	IRC0_IRQVA123  /*@bfrg@*/

#define IRC0_IRQVA124	(IRC0.unIRQVA124.u32Register)  /*@rg@*/
#define IRC0_IRQVA124_IRQVA	IRC0_IRQVA124  /*@bfrg@*/

#define IRC0_IRQVA125	(IRC0.unIRQVA125.u32Register)  /*@rg@*/
#define IRC0_IRQVA125_IRQVA	IRC0_IRQVA125  /*@bfrg@*/

#define IRC0_IRQVA126	(IRC0.unIRQVA126.u32Register)  /*@rg@*/
#define IRC0_IRQVA126_IRQVA	IRC0_IRQVA126  /*@bfrg@*/

#define IRC0_IRQVA127	(IRC0.unIRQVA127.u32Register)  /*@rg@*/
#define IRC0_IRQVA127_IRQVA	IRC0_IRQVA127  /*@bfrg@*/

#define IRC0_IRQVA128	(IRC0.unIRQVA128.u32Register)  /*@rg@*/
#define IRC0_IRQVA128_IRQVA	IRC0_IRQVA128  /*@bfrg@*/

#define IRC0_IRQVA129	(IRC0.unIRQVA129.u32Register)  /*@rg@*/
#define IRC0_IRQVA129_IRQVA	IRC0_IRQVA129  /*@bfrg@*/

#define IRC0_IRQVA130	(IRC0.unIRQVA130.u32Register)  /*@rg@*/
#define IRC0_IRQVA130_IRQVA	IRC0_IRQVA130  /*@bfrg@*/

#define IRC0_IRQVA131	(IRC0.unIRQVA131.u32Register)  /*@rg@*/
#define IRC0_IRQVA131_IRQVA	IRC0_IRQVA131  /*@bfrg@*/

#define IRC0_IRQVA132	(IRC0.unIRQVA132.u32Register)  /*@rg@*/
#define IRC0_IRQVA132_IRQVA	IRC0_IRQVA132  /*@bfrg@*/

#define IRC0_IRQVA133	(IRC0.unIRQVA133.u32Register)  /*@rg@*/
#define IRC0_IRQVA133_IRQVA	IRC0_IRQVA133  /*@bfrg@*/

#define IRC0_IRQVA134	(IRC0.unIRQVA134.u32Register)  /*@rg@*/
#define IRC0_IRQVA134_IRQVA	IRC0_IRQVA134  /*@bfrg@*/

#define IRC0_IRQVA135	(IRC0.unIRQVA135.u32Register)  /*@rg@*/
#define IRC0_IRQVA135_IRQVA	IRC0_IRQVA135  /*@bfrg@*/

#define IRC0_IRQVA136	(IRC0.unIRQVA136.u32Register)  /*@rg@*/
#define IRC0_IRQVA136_IRQVA	IRC0_IRQVA136  /*@bfrg@*/

#define IRC0_IRQVA137	(IRC0.unIRQVA137.u32Register)  /*@rg@*/
#define IRC0_IRQVA137_IRQVA	IRC0_IRQVA137  /*@bfrg@*/

#define IRC0_IRQVA138	(IRC0.unIRQVA138.u32Register)  /*@rg@*/
#define IRC0_IRQVA138_IRQVA	IRC0_IRQVA138  /*@bfrg@*/

#define IRC0_IRQVA139	(IRC0.unIRQVA139.u32Register)  /*@rg@*/
#define IRC0_IRQVA139_IRQVA	IRC0_IRQVA139  /*@bfrg@*/

#define IRC0_IRQVA140	(IRC0.unIRQVA140.u32Register)  /*@rg@*/
#define IRC0_IRQVA140_IRQVA	IRC0_IRQVA140  /*@bfrg@*/

#define IRC0_IRQVA141	(IRC0.unIRQVA141.u32Register)  /*@rg@*/
#define IRC0_IRQVA141_IRQVA	IRC0_IRQVA141  /*@bfrg@*/

#define IRC0_IRQVA142	(IRC0.unIRQVA142.u32Register)  /*@rg@*/
#define IRC0_IRQVA142_IRQVA	IRC0_IRQVA142  /*@bfrg@*/

#define IRC0_IRQVA143	(IRC0.unIRQVA143.u32Register)  /*@rg@*/
#define IRC0_IRQVA143_IRQVA	IRC0_IRQVA143  /*@bfrg@*/

#define IRC0_IRQVA144	(IRC0.unIRQVA144.u32Register)  /*@rg@*/
#define IRC0_IRQVA144_IRQVA	IRC0_IRQVA144  /*@bfrg@*/

#define IRC0_IRQVA145	(IRC0.unIRQVA145.u32Register)  /*@rg@*/
#define IRC0_IRQVA145_IRQVA	IRC0_IRQVA145  /*@bfrg@*/

#define IRC0_IRQVA146	(IRC0.unIRQVA146.u32Register)  /*@rg@*/
#define IRC0_IRQVA146_IRQVA	IRC0_IRQVA146  /*@bfrg@*/

#define IRC0_IRQVA147	(IRC0.unIRQVA147.u32Register)  /*@rg@*/
#define IRC0_IRQVA147_IRQVA	IRC0_IRQVA147  /*@bfrg@*/

#define IRC0_IRQVA148	(IRC0.unIRQVA148.u32Register)  /*@rg@*/
#define IRC0_IRQVA148_IRQVA	IRC0_IRQVA148  /*@bfrg@*/

#define IRC0_IRQVA149	(IRC0.unIRQVA149.u32Register)  /*@rg@*/
#define IRC0_IRQVA149_IRQVA	IRC0_IRQVA149  /*@bfrg@*/

#define IRC0_IRQVA150	(IRC0.unIRQVA150.u32Register)  /*@rg@*/
#define IRC0_IRQVA150_IRQVA	IRC0_IRQVA150  /*@bfrg@*/

#define IRC0_IRQVA151	(IRC0.unIRQVA151.u32Register)  /*@rg@*/
#define IRC0_IRQVA151_IRQVA	IRC0_IRQVA151  /*@bfrg@*/

#define IRC0_IRQVA152	(IRC0.unIRQVA152.u32Register)  /*@rg@*/
#define IRC0_IRQVA152_IRQVA	IRC0_IRQVA152  /*@bfrg@*/

#define IRC0_IRQVA153	(IRC0.unIRQVA153.u32Register)  /*@rg@*/
#define IRC0_IRQVA153_IRQVA	IRC0_IRQVA153  /*@bfrg@*/

#define IRC0_IRQVA154	(IRC0.unIRQVA154.u32Register)  /*@rg@*/
#define IRC0_IRQVA154_IRQVA	IRC0_IRQVA154  /*@bfrg@*/

#define IRC0_IRQVA155	(IRC0.unIRQVA155.u32Register)  /*@rg@*/
#define IRC0_IRQVA155_IRQVA	IRC0_IRQVA155  /*@bfrg@*/

#define IRC0_IRQVA156	(IRC0.unIRQVA156.u32Register)  /*@rg@*/
#define IRC0_IRQVA156_IRQVA	IRC0_IRQVA156  /*@bfrg@*/

#define IRC0_IRQVA157	(IRC0.unIRQVA157.u32Register)  /*@rg@*/
#define IRC0_IRQVA157_IRQVA	IRC0_IRQVA157  /*@bfrg@*/

#define IRC0_IRQVA158	(IRC0.unIRQVA158.u32Register)  /*@rg@*/
#define IRC0_IRQVA158_IRQVA	IRC0_IRQVA158  /*@bfrg@*/

#define IRC0_IRQVA159	(IRC0.unIRQVA159.u32Register)  /*@rg@*/
#define IRC0_IRQVA159_IRQVA	IRC0_IRQVA159  /*@bfrg@*/

#define IRC0_IRQVA160	(IRC0.unIRQVA160.u32Register)  /*@rg@*/
#define IRC0_IRQVA160_IRQVA	IRC0_IRQVA160  /*@bfrg@*/

#define IRC0_IRQVA161	(IRC0.unIRQVA161.u32Register)  /*@rg@*/
#define IRC0_IRQVA161_IRQVA	IRC0_IRQVA161  /*@bfrg@*/

#define IRC0_IRQVA162	(IRC0.unIRQVA162.u32Register)  /*@rg@*/
#define IRC0_IRQVA162_IRQVA	IRC0_IRQVA162  /*@bfrg@*/

#define IRC0_IRQVA163	(IRC0.unIRQVA163.u32Register)  /*@rg@*/
#define IRC0_IRQVA163_IRQVA	IRC0_IRQVA163  /*@bfrg@*/

#define IRC0_IRQVA164	(IRC0.unIRQVA164.u32Register)  /*@rg@*/
#define IRC0_IRQVA164_IRQVA	IRC0_IRQVA164  /*@bfrg@*/

#define IRC0_IRQVA165	(IRC0.unIRQVA165.u32Register)  /*@rg@*/
#define IRC0_IRQVA165_IRQVA	IRC0_IRQVA165  /*@bfrg@*/

#define IRC0_IRQVA166	(IRC0.unIRQVA166.u32Register)  /*@rg@*/
#define IRC0_IRQVA166_IRQVA	IRC0_IRQVA166  /*@bfrg@*/

#define IRC0_IRQVA167	(IRC0.unIRQVA167.u32Register)  /*@rg@*/
#define IRC0_IRQVA167_IRQVA	IRC0_IRQVA167  /*@bfrg@*/

#define IRC0_IRQVA168	(IRC0.unIRQVA168.u32Register)  /*@rg@*/
#define IRC0_IRQVA168_IRQVA	IRC0_IRQVA168  /*@bfrg@*/

#define IRC0_IRQVA169	(IRC0.unIRQVA169.u32Register)  /*@rg@*/
#define IRC0_IRQVA169_IRQVA	IRC0_IRQVA169  /*@bfrg@*/

#define IRC0_IRQVA170	(IRC0.unIRQVA170.u32Register)  /*@rg@*/
#define IRC0_IRQVA170_IRQVA	IRC0_IRQVA170  /*@bfrg@*/

#define IRC0_IRQVA171	(IRC0.unIRQVA171.u32Register)  /*@rg@*/
#define IRC0_IRQVA171_IRQVA	IRC0_IRQVA171  /*@bfrg@*/

#define IRC0_IRQVA172	(IRC0.unIRQVA172.u32Register)  /*@rg@*/
#define IRC0_IRQVA172_IRQVA	IRC0_IRQVA172  /*@bfrg@*/

#define IRC0_IRQVA173	(IRC0.unIRQVA173.u32Register)  /*@rg@*/
#define IRC0_IRQVA173_IRQVA	IRC0_IRQVA173  /*@bfrg@*/

#define IRC0_IRQVA174	(IRC0.unIRQVA174.u32Register)  /*@rg@*/
#define IRC0_IRQVA174_IRQVA	IRC0_IRQVA174  /*@bfrg@*/

#define IRC0_IRQVA175	(IRC0.unIRQVA175.u32Register)  /*@rg@*/
#define IRC0_IRQVA175_IRQVA	IRC0_IRQVA175  /*@bfrg@*/

#define IRC0_IRQVA176	(IRC0.unIRQVA176.u32Register)  /*@rg@*/
#define IRC0_IRQVA176_IRQVA	IRC0_IRQVA176  /*@bfrg@*/

#define IRC0_IRQVA177	(IRC0.unIRQVA177.u32Register)  /*@rg@*/
#define IRC0_IRQVA177_IRQVA	IRC0_IRQVA177  /*@bfrg@*/

#define IRC0_IRQVA178	(IRC0.unIRQVA178.u32Register)  /*@rg@*/
#define IRC0_IRQVA178_IRQVA	IRC0_IRQVA178  /*@bfrg@*/

#define IRC0_IRQVA179	(IRC0.unIRQVA179.u32Register)  /*@rg@*/
#define IRC0_IRQVA179_IRQVA	IRC0_IRQVA179  /*@bfrg@*/

#define IRC0_IRQVA180	(IRC0.unIRQVA180.u32Register)  /*@rg@*/
#define IRC0_IRQVA180_IRQVA	IRC0_IRQVA180  /*@bfrg@*/

#define IRC0_IRQVA181	(IRC0.unIRQVA181.u32Register)  /*@rg@*/
#define IRC0_IRQVA181_IRQVA	IRC0_IRQVA181  /*@bfrg@*/

#define IRC0_IRQVA182	(IRC0.unIRQVA182.u32Register)  /*@rg@*/
#define IRC0_IRQVA182_IRQVA	IRC0_IRQVA182  /*@bfrg@*/

#define IRC0_IRQVA183	(IRC0.unIRQVA183.u32Register)  /*@rg@*/
#define IRC0_IRQVA183_IRQVA	IRC0_IRQVA183  /*@bfrg@*/

#define IRC0_IRQVA184	(IRC0.unIRQVA184.u32Register)  /*@rg@*/
#define IRC0_IRQVA184_IRQVA	IRC0_IRQVA184  /*@bfrg@*/

#define IRC0_IRQVA185	(IRC0.unIRQVA185.u32Register)  /*@rg@*/
#define IRC0_IRQVA185_IRQVA	IRC0_IRQVA185  /*@bfrg@*/

#define IRC0_IRQVA186	(IRC0.unIRQVA186.u32Register)  /*@rg@*/
#define IRC0_IRQVA186_IRQVA	IRC0_IRQVA186  /*@bfrg@*/

#define IRC0_IRQVA187	(IRC0.unIRQVA187.u32Register)  /*@rg@*/
#define IRC0_IRQVA187_IRQVA	IRC0_IRQVA187  /*@bfrg@*/

#define IRC0_IRQVA188	(IRC0.unIRQVA188.u32Register)  /*@rg@*/
#define IRC0_IRQVA188_IRQVA	IRC0_IRQVA188  /*@bfrg@*/

#define IRC0_IRQVA189	(IRC0.unIRQVA189.u32Register)  /*@rg@*/
#define IRC0_IRQVA189_IRQVA	IRC0_IRQVA189  /*@bfrg@*/

#define IRC0_IRQVA190	(IRC0.unIRQVA190.u32Register)  /*@rg@*/
#define IRC0_IRQVA190_IRQVA	IRC0_IRQVA190  /*@bfrg@*/

#define IRC0_IRQVA191	(IRC0.unIRQVA191.u32Register)  /*@rg@*/
#define IRC0_IRQVA191_IRQVA	IRC0_IRQVA191  /*@bfrg@*/

#define IRC0_IRQVA192	(IRC0.unIRQVA192.u32Register)  /*@rg@*/
#define IRC0_IRQVA192_IRQVA	IRC0_IRQVA192  /*@bfrg@*/

#define IRC0_IRQVA193	(IRC0.unIRQVA193.u32Register)  /*@rg@*/
#define IRC0_IRQVA193_IRQVA	IRC0_IRQVA193  /*@bfrg@*/

#define IRC0_IRQVA194	(IRC0.unIRQVA194.u32Register)  /*@rg@*/
#define IRC0_IRQVA194_IRQVA	IRC0_IRQVA194  /*@bfrg@*/

#define IRC0_IRQVA195	(IRC0.unIRQVA195.u32Register)  /*@rg@*/
#define IRC0_IRQVA195_IRQVA	IRC0_IRQVA195  /*@bfrg@*/

#define IRC0_IRQVA196	(IRC0.unIRQVA196.u32Register)  /*@rg@*/
#define IRC0_IRQVA196_IRQVA	IRC0_IRQVA196  /*@bfrg@*/

#define IRC0_IRQVA197	(IRC0.unIRQVA197.u32Register)  /*@rg@*/
#define IRC0_IRQVA197_IRQVA	IRC0_IRQVA197  /*@bfrg@*/

#define IRC0_IRQVA198	(IRC0.unIRQVA198.u32Register)  /*@rg@*/
#define IRC0_IRQVA198_IRQVA	IRC0_IRQVA198  /*@bfrg@*/

#define IRC0_IRQVA199	(IRC0.unIRQVA199.u32Register)  /*@rg@*/
#define IRC0_IRQVA199_IRQVA	IRC0_IRQVA199  /*@bfrg@*/

#define IRC0_IRQVA200	(IRC0.unIRQVA200.u32Register)  /*@rg@*/
#define IRC0_IRQVA200_IRQVA	IRC0_IRQVA200  /*@bfrg@*/

#define IRC0_IRQVA201	(IRC0.unIRQVA201.u32Register)  /*@rg@*/
#define IRC0_IRQVA201_IRQVA	IRC0_IRQVA201  /*@bfrg@*/

#define IRC0_IRQVA202	(IRC0.unIRQVA202.u32Register)  /*@rg@*/
#define IRC0_IRQVA202_IRQVA	IRC0_IRQVA202  /*@bfrg@*/

#define IRC0_IRQVA203	(IRC0.unIRQVA203.u32Register)  /*@rg@*/
#define IRC0_IRQVA203_IRQVA	IRC0_IRQVA203  /*@bfrg@*/

#define IRC0_IRQVA204	(IRC0.unIRQVA204.u32Register)  /*@rg@*/
#define IRC0_IRQVA204_IRQVA	IRC0_IRQVA204  /*@bfrg@*/

#define IRC0_IRQVA205	(IRC0.unIRQVA205.u32Register)  /*@rg@*/
#define IRC0_IRQVA205_IRQVA	IRC0_IRQVA205  /*@bfrg@*/

#define IRC0_IRQVA206	(IRC0.unIRQVA206.u32Register)  /*@rg@*/
#define IRC0_IRQVA206_IRQVA	IRC0_IRQVA206  /*@bfrg@*/

#define IRC0_IRQVA207	(IRC0.unIRQVA207.u32Register)  /*@rg@*/
#define IRC0_IRQVA207_IRQVA	IRC0_IRQVA207  /*@bfrg@*/

#define IRC0_IRQVA208	(IRC0.unIRQVA208.u32Register)  /*@rg@*/
#define IRC0_IRQVA208_IRQVA	IRC0_IRQVA208  /*@bfrg@*/

#define IRC0_IRQVA209	(IRC0.unIRQVA209.u32Register)  /*@rg@*/
#define IRC0_IRQVA209_IRQVA	IRC0_IRQVA209  /*@bfrg@*/

#define IRC0_IRQVA210	(IRC0.unIRQVA210.u32Register)  /*@rg@*/
#define IRC0_IRQVA210_IRQVA	IRC0_IRQVA210  /*@bfrg@*/

#define IRC0_IRQVA211	(IRC0.unIRQVA211.u32Register)  /*@rg@*/
#define IRC0_IRQVA211_IRQVA	IRC0_IRQVA211  /*@bfrg@*/

#define IRC0_IRQVA212	(IRC0.unIRQVA212.u32Register)  /*@rg@*/
#define IRC0_IRQVA212_IRQVA	IRC0_IRQVA212  /*@bfrg@*/

#define IRC0_IRQVA213	(IRC0.unIRQVA213.u32Register)  /*@rg@*/
#define IRC0_IRQVA213_IRQVA	IRC0_IRQVA213  /*@bfrg@*/

#define IRC0_IRQVA214	(IRC0.unIRQVA214.u32Register)  /*@rg@*/
#define IRC0_IRQVA214_IRQVA	IRC0_IRQVA214  /*@bfrg@*/

#define IRC0_IRQVA215	(IRC0.unIRQVA215.u32Register)  /*@rg@*/
#define IRC0_IRQVA215_IRQVA	IRC0_IRQVA215  /*@bfrg@*/

#define IRC0_IRQVA216	(IRC0.unIRQVA216.u32Register)  /*@rg@*/
#define IRC0_IRQVA216_IRQVA	IRC0_IRQVA216  /*@bfrg@*/

#define IRC0_IRQVA217	(IRC0.unIRQVA217.u32Register)  /*@rg@*/
#define IRC0_IRQVA217_IRQVA	IRC0_IRQVA217  /*@bfrg@*/

#define IRC0_IRQVA218	(IRC0.unIRQVA218.u32Register)  /*@rg@*/
#define IRC0_IRQVA218_IRQVA	IRC0_IRQVA218  /*@bfrg@*/

#define IRC0_IRQVA219	(IRC0.unIRQVA219.u32Register)  /*@rg@*/
#define IRC0_IRQVA219_IRQVA	IRC0_IRQVA219  /*@bfrg@*/

#define IRC0_IRQVA220	(IRC0.unIRQVA220.u32Register)  /*@rg@*/
#define IRC0_IRQVA220_IRQVA	IRC0_IRQVA220  /*@bfrg@*/

#define IRC0_IRQVA221	(IRC0.unIRQVA221.u32Register)  /*@rg@*/
#define IRC0_IRQVA221_IRQVA	IRC0_IRQVA221  /*@bfrg@*/

#define IRC0_IRQVA222	(IRC0.unIRQVA222.u32Register)  /*@rg@*/
#define IRC0_IRQVA222_IRQVA	IRC0_IRQVA222  /*@bfrg@*/

#define IRC0_IRQVA223	(IRC0.unIRQVA223.u32Register)  /*@rg@*/
#define IRC0_IRQVA223_IRQVA	IRC0_IRQVA223  /*@bfrg@*/

#define IRC0_IRQVA224	(IRC0.unIRQVA224.u32Register)  /*@rg@*/
#define IRC0_IRQVA224_IRQVA	IRC0_IRQVA224  /*@bfrg@*/

#define IRC0_IRQVA225	(IRC0.unIRQVA225.u32Register)  /*@rg@*/
#define IRC0_IRQVA225_IRQVA	IRC0_IRQVA225  /*@bfrg@*/

#define IRC0_IRQVA226	(IRC0.unIRQVA226.u32Register)  /*@rg@*/
#define IRC0_IRQVA226_IRQVA	IRC0_IRQVA226  /*@bfrg@*/

#define IRC0_IRQVA227	(IRC0.unIRQVA227.u32Register)  /*@rg@*/
#define IRC0_IRQVA227_IRQVA	IRC0_IRQVA227  /*@bfrg@*/

#define IRC0_IRQVA228	(IRC0.unIRQVA228.u32Register)  /*@rg@*/
#define IRC0_IRQVA228_IRQVA	IRC0_IRQVA228  /*@bfrg@*/

#define IRC0_IRQVA229	(IRC0.unIRQVA229.u32Register)  /*@rg@*/
#define IRC0_IRQVA229_IRQVA	IRC0_IRQVA229  /*@bfrg@*/

#define IRC0_IRQVA230	(IRC0.unIRQVA230.u32Register)  /*@rg@*/
#define IRC0_IRQVA230_IRQVA	IRC0_IRQVA230  /*@bfrg@*/

#define IRC0_IRQVA231	(IRC0.unIRQVA231.u32Register)  /*@rg@*/
#define IRC0_IRQVA231_IRQVA	IRC0_IRQVA231  /*@bfrg@*/

#define IRC0_IRQVA232	(IRC0.unIRQVA232.u32Register)  /*@rg@*/
#define IRC0_IRQVA232_IRQVA	IRC0_IRQVA232  /*@bfrg@*/

#define IRC0_IRQVA233	(IRC0.unIRQVA233.u32Register)  /*@rg@*/
#define IRC0_IRQVA233_IRQVA	IRC0_IRQVA233  /*@bfrg@*/

#define IRC0_IRQVA234	(IRC0.unIRQVA234.u32Register)  /*@rg@*/
#define IRC0_IRQVA234_IRQVA	IRC0_IRQVA234  /*@bfrg@*/

#define IRC0_IRQVA235	(IRC0.unIRQVA235.u32Register)  /*@rg@*/
#define IRC0_IRQVA235_IRQVA	IRC0_IRQVA235  /*@bfrg@*/

#define IRC0_IRQVA236	(IRC0.unIRQVA236.u32Register)  /*@rg@*/
#define IRC0_IRQVA236_IRQVA	IRC0_IRQVA236  /*@bfrg@*/

#define IRC0_IRQVA237	(IRC0.unIRQVA237.u32Register)  /*@rg@*/
#define IRC0_IRQVA237_IRQVA	IRC0_IRQVA237  /*@bfrg@*/

#define IRC0_IRQVA238	(IRC0.unIRQVA238.u32Register)  /*@rg@*/
#define IRC0_IRQVA238_IRQVA	IRC0_IRQVA238  /*@bfrg@*/

#define IRC0_IRQVA239	(IRC0.unIRQVA239.u32Register)  /*@rg@*/
#define IRC0_IRQVA239_IRQVA	IRC0_IRQVA239  /*@bfrg@*/

#define IRC0_IRQVA240	(IRC0.unIRQVA240.u32Register)  /*@rg@*/
#define IRC0_IRQVA240_IRQVA	IRC0_IRQVA240  /*@bfrg@*/

#define IRC0_IRQVA241	(IRC0.unIRQVA241.u32Register)  /*@rg@*/
#define IRC0_IRQVA241_IRQVA	IRC0_IRQVA241  /*@bfrg@*/

#define IRC0_IRQVA242	(IRC0.unIRQVA242.u32Register)  /*@rg@*/
#define IRC0_IRQVA242_IRQVA	IRC0_IRQVA242  /*@bfrg@*/

#define IRC0_IRQVA243	(IRC0.unIRQVA243.u32Register)  /*@rg@*/
#define IRC0_IRQVA243_IRQVA	IRC0_IRQVA243  /*@bfrg@*/

#define IRC0_IRQVA244	(IRC0.unIRQVA244.u32Register)  /*@rg@*/
#define IRC0_IRQVA244_IRQVA	IRC0_IRQVA244  /*@bfrg@*/

#define IRC0_IRQVA245	(IRC0.unIRQVA245.u32Register)  /*@rg@*/
#define IRC0_IRQVA245_IRQVA	IRC0_IRQVA245  /*@bfrg@*/

#define IRC0_IRQVA246	(IRC0.unIRQVA246.u32Register)  /*@rg@*/
#define IRC0_IRQVA246_IRQVA	IRC0_IRQVA246  /*@bfrg@*/

#define IRC0_IRQVA247	(IRC0.unIRQVA247.u32Register)  /*@rg@*/
#define IRC0_IRQVA247_IRQVA	IRC0_IRQVA247  /*@bfrg@*/

#define IRC0_IRQVA248	(IRC0.unIRQVA248.u32Register)  /*@rg@*/
#define IRC0_IRQVA248_IRQVA	IRC0_IRQVA248  /*@bfrg@*/

#define IRC0_IRQVA249	(IRC0.unIRQVA249.u32Register)  /*@rg@*/
#define IRC0_IRQVA249_IRQVA	IRC0_IRQVA249  /*@bfrg@*/

#define IRC0_IRQVA250	(IRC0.unIRQVA250.u32Register)  /*@rg@*/
#define IRC0_IRQVA250_IRQVA	IRC0_IRQVA250  /*@bfrg@*/

#define IRC0_IRQVA251	(IRC0.unIRQVA251.u32Register)  /*@rg@*/
#define IRC0_IRQVA251_IRQVA	IRC0_IRQVA251  /*@bfrg@*/

#define IRC0_IRQVA252	(IRC0.unIRQVA252.u32Register)  /*@rg@*/
#define IRC0_IRQVA252_IRQVA	IRC0_IRQVA252  /*@bfrg@*/

#define IRC0_IRQVA253	(IRC0.unIRQVA253.u32Register)  /*@rg@*/
#define IRC0_IRQVA253_IRQVA	IRC0_IRQVA253  /*@bfrg@*/

#define IRC0_IRQVA254	(IRC0.unIRQVA254.u32Register)  /*@rg@*/
#define IRC0_IRQVA254_IRQVA	IRC0_IRQVA254  /*@bfrg@*/

#define IRC0_IRQVA255	(IRC0.unIRQVA255.u32Register)  /*@rg@*/
#define IRC0_IRQVA255_IRQVA	IRC0_IRQVA255  /*@bfrg@*/

#define IRC0_IRQVA256	(IRC0.unIRQVA256.u32Register)  /*@rg@*/
#define IRC0_IRQVA256_IRQVA	IRC0_IRQVA256  /*@bfrg@*/

#define IRC0_IRQVA257	(IRC0.unIRQVA257.u32Register)  /*@rg@*/
#define IRC0_IRQVA257_IRQVA	IRC0_IRQVA257  /*@bfrg@*/

#define IRC0_IRQVA258	(IRC0.unIRQVA258.u32Register)  /*@rg@*/
#define IRC0_IRQVA258_IRQVA	IRC0_IRQVA258  /*@bfrg@*/

#define IRC0_IRQVA259	(IRC0.unIRQVA259.u32Register)  /*@rg@*/
#define IRC0_IRQVA259_IRQVA	IRC0_IRQVA259  /*@bfrg@*/

#define IRC0_IRQVA260	(IRC0.unIRQVA260.u32Register)  /*@rg@*/
#define IRC0_IRQVA260_IRQVA	IRC0_IRQVA260  /*@bfrg@*/

#define IRC0_IRQVA261	(IRC0.unIRQVA261.u32Register)  /*@rg@*/
#define IRC0_IRQVA261_IRQVA	IRC0_IRQVA261  /*@bfrg@*/

#define IRC0_IRQVA262	(IRC0.unIRQVA262.u32Register)  /*@rg@*/
#define IRC0_IRQVA262_IRQVA	IRC0_IRQVA262  /*@bfrg@*/

#define IRC0_IRQVA263	(IRC0.unIRQVA263.u32Register)  /*@rg@*/
#define IRC0_IRQVA263_IRQVA	IRC0_IRQVA263  /*@bfrg@*/

#define IRC0_IRQVA264	(IRC0.unIRQVA264.u32Register)  /*@rg@*/
#define IRC0_IRQVA264_IRQVA	IRC0_IRQVA264  /*@bfrg@*/

#define IRC0_IRQVA265	(IRC0.unIRQVA265.u32Register)  /*@rg@*/
#define IRC0_IRQVA265_IRQVA	IRC0_IRQVA265  /*@bfrg@*/

#define IRC0_IRQVA266	(IRC0.unIRQVA266.u32Register)  /*@rg@*/
#define IRC0_IRQVA266_IRQVA	IRC0_IRQVA266  /*@bfrg@*/

#define IRC0_IRQVA267	(IRC0.unIRQVA267.u32Register)  /*@rg@*/
#define IRC0_IRQVA267_IRQVA	IRC0_IRQVA267  /*@bfrg@*/

#define IRC0_IRQVA268	(IRC0.unIRQVA268.u32Register)  /*@rg@*/
#define IRC0_IRQVA268_IRQVA	IRC0_IRQVA268  /*@bfrg@*/

#define IRC0_IRQVA269	(IRC0.unIRQVA269.u32Register)  /*@rg@*/
#define IRC0_IRQVA269_IRQVA	IRC0_IRQVA269  /*@bfrg@*/

#define IRC0_IRQVA270	(IRC0.unIRQVA270.u32Register)  /*@rg@*/
#define IRC0_IRQVA270_IRQVA	IRC0_IRQVA270  /*@bfrg@*/

#define IRC0_IRQVA271	(IRC0.unIRQVA271.u32Register)  /*@rg@*/
#define IRC0_IRQVA271_IRQVA	IRC0_IRQVA271  /*@bfrg@*/

#define IRC0_IRQVA272	(IRC0.unIRQVA272.u32Register)  /*@rg@*/
#define IRC0_IRQVA272_IRQVA	IRC0_IRQVA272  /*@bfrg@*/

#define IRC0_IRQVA273	(IRC0.unIRQVA273.u32Register)  /*@rg@*/
#define IRC0_IRQVA273_IRQVA	IRC0_IRQVA273  /*@bfrg@*/

#define IRC0_IRQVA274	(IRC0.unIRQVA274.u32Register)  /*@rg@*/
#define IRC0_IRQVA274_IRQVA	IRC0_IRQVA274  /*@bfrg@*/

#define IRC0_IRQVA275	(IRC0.unIRQVA275.u32Register)  /*@rg@*/
#define IRC0_IRQVA275_IRQVA	IRC0_IRQVA275  /*@bfrg@*/

#define IRC0_IRQVA276	(IRC0.unIRQVA276.u32Register)  /*@rg@*/
#define IRC0_IRQVA276_IRQVA	IRC0_IRQVA276  /*@bfrg@*/

#define IRC0_IRQVA277	(IRC0.unIRQVA277.u32Register)  /*@rg@*/
#define IRC0_IRQVA277_IRQVA	IRC0_IRQVA277  /*@bfrg@*/

#define IRC0_IRQVA278	(IRC0.unIRQVA278.u32Register)  /*@rg@*/
#define IRC0_IRQVA278_IRQVA	IRC0_IRQVA278  /*@bfrg@*/

#define IRC0_IRQVA279	(IRC0.unIRQVA279.u32Register)  /*@rg@*/
#define IRC0_IRQVA279_IRQVA	IRC0_IRQVA279  /*@bfrg@*/

#define IRC0_IRQVA280	(IRC0.unIRQVA280.u32Register)  /*@rg@*/
#define IRC0_IRQVA280_IRQVA	IRC0_IRQVA280  /*@bfrg@*/

#define IRC0_IRQVA281	(IRC0.unIRQVA281.u32Register)  /*@rg@*/
#define IRC0_IRQVA281_IRQVA	IRC0_IRQVA281  /*@bfrg@*/

#define IRC0_IRQVA282	(IRC0.unIRQVA282.u32Register)  /*@rg@*/
#define IRC0_IRQVA282_IRQVA	IRC0_IRQVA282  /*@bfrg@*/

#define IRC0_IRQVA283	(IRC0.unIRQVA283.u32Register)  /*@rg@*/
#define IRC0_IRQVA283_IRQVA	IRC0_IRQVA283  /*@bfrg@*/

#define IRC0_IRQVA284	(IRC0.unIRQVA284.u32Register)  /*@rg@*/
#define IRC0_IRQVA284_IRQVA	IRC0_IRQVA284  /*@bfrg@*/

#define IRC0_IRQVA285	(IRC0.unIRQVA285.u32Register)  /*@rg@*/
#define IRC0_IRQVA285_IRQVA	IRC0_IRQVA285  /*@bfrg@*/

#define IRC0_IRQVA286	(IRC0.unIRQVA286.u32Register)  /*@rg@*/
#define IRC0_IRQVA286_IRQVA	IRC0_IRQVA286  /*@bfrg@*/

#define IRC0_IRQVA287	(IRC0.unIRQVA287.u32Register)  /*@rg@*/
#define IRC0_IRQVA287_IRQVA	IRC0_IRQVA287  /*@bfrg@*/

#define IRC0_IRQVA288	(IRC0.unIRQVA288.u32Register)  /*@rg@*/
#define IRC0_IRQVA288_IRQVA	IRC0_IRQVA288  /*@bfrg@*/

#define IRC0_IRQVA289	(IRC0.unIRQVA289.u32Register)  /*@rg@*/
#define IRC0_IRQVA289_IRQVA	IRC0_IRQVA289  /*@bfrg@*/

#define IRC0_IRQVA290	(IRC0.unIRQVA290.u32Register)  /*@rg@*/
#define IRC0_IRQVA290_IRQVA	IRC0_IRQVA290  /*@bfrg@*/

#define IRC0_IRQVA291	(IRC0.unIRQVA291.u32Register)  /*@rg@*/
#define IRC0_IRQVA291_IRQVA	IRC0_IRQVA291  /*@bfrg@*/

#define IRC0_IRQVA292	(IRC0.unIRQVA292.u32Register)  /*@rg@*/
#define IRC0_IRQVA292_IRQVA	IRC0_IRQVA292  /*@bfrg@*/

#define IRC0_IRQVA293	(IRC0.unIRQVA293.u32Register)  /*@rg@*/
#define IRC0_IRQVA293_IRQVA	IRC0_IRQVA293  /*@bfrg@*/

#define IRC0_IRQVA294	(IRC0.unIRQVA294.u32Register)  /*@rg@*/
#define IRC0_IRQVA294_IRQVA	IRC0_IRQVA294  /*@bfrg@*/

#define IRC0_IRQVA295	(IRC0.unIRQVA295.u32Register)  /*@rg@*/
#define IRC0_IRQVA295_IRQVA	IRC0_IRQVA295  /*@bfrg@*/

#define IRC0_IRQVA296	(IRC0.unIRQVA296.u32Register)  /*@rg@*/
#define IRC0_IRQVA296_IRQVA	IRC0_IRQVA296  /*@bfrg@*/

#define IRC0_IRQVA297	(IRC0.unIRQVA297.u32Register)  /*@rg@*/
#define IRC0_IRQVA297_IRQVA	IRC0_IRQVA297  /*@bfrg@*/

#define IRC0_IRQVA298	(IRC0.unIRQVA298.u32Register)  /*@rg@*/
#define IRC0_IRQVA298_IRQVA	IRC0_IRQVA298  /*@bfrg@*/

#define IRC0_IRQVA299	(IRC0.unIRQVA299.u32Register)  /*@rg@*/
#define IRC0_IRQVA299_IRQVA	IRC0_IRQVA299  /*@bfrg@*/

#define IRC0_IRQVA300	(IRC0.unIRQVA300.u32Register)  /*@rg@*/
#define IRC0_IRQVA300_IRQVA	IRC0_IRQVA300  /*@bfrg@*/

#define IRC0_IRQVA301	(IRC0.unIRQVA301.u32Register)  /*@rg@*/
#define IRC0_IRQVA301_IRQVA	IRC0_IRQVA301  /*@bfrg@*/

#define IRC0_IRQVA302	(IRC0.unIRQVA302.u32Register)  /*@rg@*/
#define IRC0_IRQVA302_IRQVA	IRC0_IRQVA302  /*@bfrg@*/

#define IRC0_IRQVA303	(IRC0.unIRQVA303.u32Register)  /*@rg@*/
#define IRC0_IRQVA303_IRQVA	IRC0_IRQVA303  /*@bfrg@*/

#define IRC0_IRQVA304	(IRC0.unIRQVA304.u32Register)  /*@rg@*/
#define IRC0_IRQVA304_IRQVA	IRC0_IRQVA304  /*@bfrg@*/

#define IRC0_IRQVA305	(IRC0.unIRQVA305.u32Register)  /*@rg@*/
#define IRC0_IRQVA305_IRQVA	IRC0_IRQVA305  /*@bfrg@*/

#define IRC0_IRQVA306	(IRC0.unIRQVA306.u32Register)  /*@rg@*/
#define IRC0_IRQVA306_IRQVA	IRC0_IRQVA306  /*@bfrg@*/

#define IRC0_IRQVA307	(IRC0.unIRQVA307.u32Register)  /*@rg@*/
#define IRC0_IRQVA307_IRQVA	IRC0_IRQVA307  /*@bfrg@*/

#define IRC0_IRQVA308	(IRC0.unIRQVA308.u32Register)  /*@rg@*/
#define IRC0_IRQVA308_IRQVA	IRC0_IRQVA308  /*@bfrg@*/

#define IRC0_IRQVA309	(IRC0.unIRQVA309.u32Register)  /*@rg@*/
#define IRC0_IRQVA309_IRQVA	IRC0_IRQVA309  /*@bfrg@*/

#define IRC0_IRQVA310	(IRC0.unIRQVA310.u32Register)  /*@rg@*/
#define IRC0_IRQVA310_IRQVA	IRC0_IRQVA310  /*@bfrg@*/

#define IRC0_IRQVA311	(IRC0.unIRQVA311.u32Register)  /*@rg@*/
#define IRC0_IRQVA311_IRQVA	IRC0_IRQVA311  /*@bfrg@*/

#define IRC0_IRQVA312	(IRC0.unIRQVA312.u32Register)  /*@rg@*/
#define IRC0_IRQVA312_IRQVA	IRC0_IRQVA312  /*@bfrg@*/

#define IRC0_IRQVA313	(IRC0.unIRQVA313.u32Register)  /*@rg@*/
#define IRC0_IRQVA313_IRQVA	IRC0_IRQVA313  /*@bfrg@*/

#define IRC0_IRQVA314	(IRC0.unIRQVA314.u32Register)  /*@rg@*/
#define IRC0_IRQVA314_IRQVA	IRC0_IRQVA314  /*@bfrg@*/

#define IRC0_IRQVA315	(IRC0.unIRQVA315.u32Register)  /*@rg@*/
#define IRC0_IRQVA315_IRQVA	IRC0_IRQVA315  /*@bfrg@*/

#define IRC0_IRQVA316	(IRC0.unIRQVA316.u32Register)  /*@rg@*/
#define IRC0_IRQVA316_IRQVA	IRC0_IRQVA316  /*@bfrg@*/

#define IRC0_IRQVA317	(IRC0.unIRQVA317.u32Register)  /*@rg@*/
#define IRC0_IRQVA317_IRQVA	IRC0_IRQVA317  /*@bfrg@*/

#define IRC0_IRQVA318	(IRC0.unIRQVA318.u32Register)  /*@rg@*/
#define IRC0_IRQVA318_IRQVA	IRC0_IRQVA318  /*@bfrg@*/

#define IRC0_IRQVA319	(IRC0.unIRQVA319.u32Register)  /*@rg@*/
#define IRC0_IRQVA319_IRQVA	IRC0_IRQVA319  /*@bfrg@*/

#define IRC0_IRQVA320	(IRC0.unIRQVA320.u32Register)  /*@rg@*/
#define IRC0_IRQVA320_IRQVA	IRC0_IRQVA320  /*@bfrg@*/

#define IRC0_IRQVA321	(IRC0.unIRQVA321.u32Register)  /*@rg@*/
#define IRC0_IRQVA321_IRQVA	IRC0_IRQVA321  /*@bfrg@*/

#define IRC0_IRQVA322	(IRC0.unIRQVA322.u32Register)  /*@rg@*/
#define IRC0_IRQVA322_IRQVA	IRC0_IRQVA322  /*@bfrg@*/

#define IRC0_IRQVA323	(IRC0.unIRQVA323.u32Register)  /*@rg@*/
#define IRC0_IRQVA323_IRQVA	IRC0_IRQVA323  /*@bfrg@*/

#define IRC0_IRQVA324	(IRC0.unIRQVA324.u32Register)  /*@rg@*/
#define IRC0_IRQVA324_IRQVA	IRC0_IRQVA324  /*@bfrg@*/

#define IRC0_IRQVA325	(IRC0.unIRQVA325.u32Register)  /*@rg@*/
#define IRC0_IRQVA325_IRQVA	IRC0_IRQVA325  /*@bfrg@*/

#define IRC0_IRQVA326	(IRC0.unIRQVA326.u32Register)  /*@rg@*/
#define IRC0_IRQVA326_IRQVA	IRC0_IRQVA326  /*@bfrg@*/

#define IRC0_IRQVA327	(IRC0.unIRQVA327.u32Register)  /*@rg@*/
#define IRC0_IRQVA327_IRQVA	IRC0_IRQVA327  /*@bfrg@*/

#define IRC0_IRQVA328	(IRC0.unIRQVA328.u32Register)  /*@rg@*/
#define IRC0_IRQVA328_IRQVA	IRC0_IRQVA328  /*@bfrg@*/

#define IRC0_IRQVA329	(IRC0.unIRQVA329.u32Register)  /*@rg@*/
#define IRC0_IRQVA329_IRQVA	IRC0_IRQVA329  /*@bfrg@*/

#define IRC0_IRQVA330	(IRC0.unIRQVA330.u32Register)  /*@rg@*/
#define IRC0_IRQVA330_IRQVA	IRC0_IRQVA330  /*@bfrg@*/

#define IRC0_IRQVA331	(IRC0.unIRQVA331.u32Register)  /*@rg@*/
#define IRC0_IRQVA331_IRQVA	IRC0_IRQVA331  /*@bfrg@*/

#define IRC0_IRQVA332	(IRC0.unIRQVA332.u32Register)  /*@rg@*/
#define IRC0_IRQVA332_IRQVA	IRC0_IRQVA332  /*@bfrg@*/

#define IRC0_IRQVA333	(IRC0.unIRQVA333.u32Register)  /*@rg@*/
#define IRC0_IRQVA333_IRQVA	IRC0_IRQVA333  /*@bfrg@*/

#define IRC0_IRQVA334	(IRC0.unIRQVA334.u32Register)  /*@rg@*/
#define IRC0_IRQVA334_IRQVA	IRC0_IRQVA334  /*@bfrg@*/

#define IRC0_IRQVA335	(IRC0.unIRQVA335.u32Register)  /*@rg@*/
#define IRC0_IRQVA335_IRQVA	IRC0_IRQVA335  /*@bfrg@*/

#define IRC0_IRQVA336	(IRC0.unIRQVA336.u32Register)  /*@rg@*/
#define IRC0_IRQVA336_IRQVA	IRC0_IRQVA336  /*@bfrg@*/

#define IRC0_IRQVA337	(IRC0.unIRQVA337.u32Register)  /*@rg@*/
#define IRC0_IRQVA337_IRQVA	IRC0_IRQVA337  /*@bfrg@*/

#define IRC0_IRQVA338	(IRC0.unIRQVA338.u32Register)  /*@rg@*/
#define IRC0_IRQVA338_IRQVA	IRC0_IRQVA338  /*@bfrg@*/

#define IRC0_IRQVA339	(IRC0.unIRQVA339.u32Register)  /*@rg@*/
#define IRC0_IRQVA339_IRQVA	IRC0_IRQVA339  /*@bfrg@*/

#define IRC0_IRQVA340	(IRC0.unIRQVA340.u32Register)  /*@rg@*/
#define IRC0_IRQVA340_IRQVA	IRC0_IRQVA340  /*@bfrg@*/

#define IRC0_IRQVA341	(IRC0.unIRQVA341.u32Register)  /*@rg@*/
#define IRC0_IRQVA341_IRQVA	IRC0_IRQVA341  /*@bfrg@*/

#define IRC0_IRQVA342	(IRC0.unIRQVA342.u32Register)  /*@rg@*/
#define IRC0_IRQVA342_IRQVA	IRC0_IRQVA342  /*@bfrg@*/

#define IRC0_IRQVA343	(IRC0.unIRQVA343.u32Register)  /*@rg@*/
#define IRC0_IRQVA343_IRQVA	IRC0_IRQVA343  /*@bfrg@*/

#define IRC0_IRQVA344	(IRC0.unIRQVA344.u32Register)  /*@rg@*/
#define IRC0_IRQVA344_IRQVA	IRC0_IRQVA344  /*@bfrg@*/

#define IRC0_IRQVA345	(IRC0.unIRQVA345.u32Register)  /*@rg@*/
#define IRC0_IRQVA345_IRQVA	IRC0_IRQVA345  /*@bfrg@*/

#define IRC0_IRQVA346	(IRC0.unIRQVA346.u32Register)  /*@rg@*/
#define IRC0_IRQVA346_IRQVA	IRC0_IRQVA346  /*@bfrg@*/

#define IRC0_IRQVA347	(IRC0.unIRQVA347.u32Register)  /*@rg@*/
#define IRC0_IRQVA347_IRQVA	IRC0_IRQVA347  /*@bfrg@*/

#define IRC0_IRQVA348	(IRC0.unIRQVA348.u32Register)  /*@rg@*/
#define IRC0_IRQVA348_IRQVA	IRC0_IRQVA348  /*@bfrg@*/

#define IRC0_IRQVA349	(IRC0.unIRQVA349.u32Register)  /*@rg@*/
#define IRC0_IRQVA349_IRQVA	IRC0_IRQVA349  /*@bfrg@*/

#define IRC0_IRQVA350	(IRC0.unIRQVA350.u32Register)  /*@rg@*/
#define IRC0_IRQVA350_IRQVA	IRC0_IRQVA350  /*@bfrg@*/

#define IRC0_IRQVA351	(IRC0.unIRQVA351.u32Register)  /*@rg@*/
#define IRC0_IRQVA351_IRQVA	IRC0_IRQVA351  /*@bfrg@*/

#define IRC0_IRQVA352	(IRC0.unIRQVA352.u32Register)  /*@rg@*/
#define IRC0_IRQVA352_IRQVA	IRC0_IRQVA352  /*@bfrg@*/

#define IRC0_IRQVA353	(IRC0.unIRQVA353.u32Register)  /*@rg@*/
#define IRC0_IRQVA353_IRQVA	IRC0_IRQVA353  /*@bfrg@*/

#define IRC0_IRQVA354	(IRC0.unIRQVA354.u32Register)  /*@rg@*/
#define IRC0_IRQVA354_IRQVA	IRC0_IRQVA354  /*@bfrg@*/

#define IRC0_IRQVA355	(IRC0.unIRQVA355.u32Register)  /*@rg@*/
#define IRC0_IRQVA355_IRQVA	IRC0_IRQVA355  /*@bfrg@*/

#define IRC0_IRQVA356	(IRC0.unIRQVA356.u32Register)  /*@rg@*/
#define IRC0_IRQVA356_IRQVA	IRC0_IRQVA356  /*@bfrg@*/

#define IRC0_IRQVA357	(IRC0.unIRQVA357.u32Register)  /*@rg@*/
#define IRC0_IRQVA357_IRQVA	IRC0_IRQVA357  /*@bfrg@*/

#define IRC0_IRQVA358	(IRC0.unIRQVA358.u32Register)  /*@rg@*/
#define IRC0_IRQVA358_IRQVA	IRC0_IRQVA358  /*@bfrg@*/

#define IRC0_IRQVA359	(IRC0.unIRQVA359.u32Register)  /*@rg@*/
#define IRC0_IRQVA359_IRQVA	IRC0_IRQVA359  /*@bfrg@*/

#define IRC0_IRQVA360	(IRC0.unIRQVA360.u32Register)  /*@rg@*/
#define IRC0_IRQVA360_IRQVA	IRC0_IRQVA360  /*@bfrg@*/

#define IRC0_IRQVA361	(IRC0.unIRQVA361.u32Register)  /*@rg@*/
#define IRC0_IRQVA361_IRQVA	IRC0_IRQVA361  /*@bfrg@*/

#define IRC0_IRQVA362	(IRC0.unIRQVA362.u32Register)  /*@rg@*/
#define IRC0_IRQVA362_IRQVA	IRC0_IRQVA362  /*@bfrg@*/

#define IRC0_IRQVA363	(IRC0.unIRQVA363.u32Register)  /*@rg@*/
#define IRC0_IRQVA363_IRQVA	IRC0_IRQVA363  /*@bfrg@*/

#define IRC0_IRQVA364	(IRC0.unIRQVA364.u32Register)  /*@rg@*/
#define IRC0_IRQVA364_IRQVA	IRC0_IRQVA364  /*@bfrg@*/

#define IRC0_IRQVA365	(IRC0.unIRQVA365.u32Register)  /*@rg@*/
#define IRC0_IRQVA365_IRQVA	IRC0_IRQVA365  /*@bfrg@*/

#define IRC0_IRQVA366	(IRC0.unIRQVA366.u32Register)  /*@rg@*/
#define IRC0_IRQVA366_IRQVA	IRC0_IRQVA366  /*@bfrg@*/

#define IRC0_IRQVA367	(IRC0.unIRQVA367.u32Register)  /*@rg@*/
#define IRC0_IRQVA367_IRQVA	IRC0_IRQVA367  /*@bfrg@*/

#define IRC0_IRQVA368	(IRC0.unIRQVA368.u32Register)  /*@rg@*/
#define IRC0_IRQVA368_IRQVA	IRC0_IRQVA368  /*@bfrg@*/

#define IRC0_IRQVA369	(IRC0.unIRQVA369.u32Register)  /*@rg@*/
#define IRC0_IRQVA369_IRQVA	IRC0_IRQVA369  /*@bfrg@*/

#define IRC0_IRQVA370	(IRC0.unIRQVA370.u32Register)  /*@rg@*/
#define IRC0_IRQVA370_IRQVA	IRC0_IRQVA370  /*@bfrg@*/

#define IRC0_IRQVA371	(IRC0.unIRQVA371.u32Register)  /*@rg@*/
#define IRC0_IRQVA371_IRQVA	IRC0_IRQVA371  /*@bfrg@*/

#define IRC0_IRQVA372	(IRC0.unIRQVA372.u32Register)  /*@rg@*/
#define IRC0_IRQVA372_IRQVA	IRC0_IRQVA372  /*@bfrg@*/

#define IRC0_IRQVA373	(IRC0.unIRQVA373.u32Register)  /*@rg@*/
#define IRC0_IRQVA373_IRQVA	IRC0_IRQVA373  /*@bfrg@*/

#define IRC0_IRQVA374	(IRC0.unIRQVA374.u32Register)  /*@rg@*/
#define IRC0_IRQVA374_IRQVA	IRC0_IRQVA374  /*@bfrg@*/

#define IRC0_IRQVA375	(IRC0.unIRQVA375.u32Register)  /*@rg@*/
#define IRC0_IRQVA375_IRQVA	IRC0_IRQVA375  /*@bfrg@*/

#define IRC0_IRQVA376	(IRC0.unIRQVA376.u32Register)  /*@rg@*/
#define IRC0_IRQVA376_IRQVA	IRC0_IRQVA376  /*@bfrg@*/

#define IRC0_IRQVA377	(IRC0.unIRQVA377.u32Register)  /*@rg@*/
#define IRC0_IRQVA377_IRQVA	IRC0_IRQVA377  /*@bfrg@*/

#define IRC0_IRQVA378	(IRC0.unIRQVA378.u32Register)  /*@rg@*/
#define IRC0_IRQVA378_IRQVA	IRC0_IRQVA378  /*@bfrg@*/

#define IRC0_IRQVA379	(IRC0.unIRQVA379.u32Register)  /*@rg@*/
#define IRC0_IRQVA379_IRQVA	IRC0_IRQVA379  /*@bfrg@*/

#define IRC0_IRQVA380	(IRC0.unIRQVA380.u32Register)  /*@rg@*/
#define IRC0_IRQVA380_IRQVA	IRC0_IRQVA380  /*@bfrg@*/

#define IRC0_IRQVA381	(IRC0.unIRQVA381.u32Register)  /*@rg@*/
#define IRC0_IRQVA381_IRQVA	IRC0_IRQVA381  /*@bfrg@*/

#define IRC0_IRQVA382	(IRC0.unIRQVA382.u32Register)  /*@rg@*/
#define IRC0_IRQVA382_IRQVA	IRC0_IRQVA382  /*@bfrg@*/

#define IRC0_IRQVA383	(IRC0.unIRQVA383.u32Register)  /*@rg@*/
#define IRC0_IRQVA383_IRQVA	IRC0_IRQVA383  /*@bfrg@*/

#define IRC0_IRQVA384	(IRC0.unIRQVA384.u32Register)  /*@rg@*/
#define IRC0_IRQVA384_IRQVA	IRC0_IRQVA384  /*@bfrg@*/

#define IRC0_IRQVA385	(IRC0.unIRQVA385.u32Register)  /*@rg@*/
#define IRC0_IRQVA385_IRQVA	IRC0_IRQVA385  /*@bfrg@*/

#define IRC0_IRQVA386	(IRC0.unIRQVA386.u32Register)  /*@rg@*/
#define IRC0_IRQVA386_IRQVA	IRC0_IRQVA386  /*@bfrg@*/

#define IRC0_IRQVA387	(IRC0.unIRQVA387.u32Register)  /*@rg@*/
#define IRC0_IRQVA387_IRQVA	IRC0_IRQVA387  /*@bfrg@*/

#define IRC0_IRQVA388	(IRC0.unIRQVA388.u32Register)  /*@rg@*/
#define IRC0_IRQVA388_IRQVA	IRC0_IRQVA388  /*@bfrg@*/

#define IRC0_IRQVA389	(IRC0.unIRQVA389.u32Register)  /*@rg@*/
#define IRC0_IRQVA389_IRQVA	IRC0_IRQVA389  /*@bfrg@*/

#define IRC0_IRQVA390	(IRC0.unIRQVA390.u32Register)  /*@rg@*/
#define IRC0_IRQVA390_IRQVA	IRC0_IRQVA390  /*@bfrg@*/

#define IRC0_IRQVA391	(IRC0.unIRQVA391.u32Register)  /*@rg@*/
#define IRC0_IRQVA391_IRQVA	IRC0_IRQVA391  /*@bfrg@*/

#define IRC0_IRQVA392	(IRC0.unIRQVA392.u32Register)  /*@rg@*/
#define IRC0_IRQVA392_IRQVA	IRC0_IRQVA392  /*@bfrg@*/

#define IRC0_IRQVA393	(IRC0.unIRQVA393.u32Register)  /*@rg@*/
#define IRC0_IRQVA393_IRQVA	IRC0_IRQVA393  /*@bfrg@*/

#define IRC0_IRQVA394	(IRC0.unIRQVA394.u32Register)  /*@rg@*/
#define IRC0_IRQVA394_IRQVA	IRC0_IRQVA394  /*@bfrg@*/

#define IRC0_IRQVA395	(IRC0.unIRQVA395.u32Register)  /*@rg@*/
#define IRC0_IRQVA395_IRQVA	IRC0_IRQVA395  /*@bfrg@*/

#define IRC0_IRQVA396	(IRC0.unIRQVA396.u32Register)  /*@rg@*/
#define IRC0_IRQVA396_IRQVA	IRC0_IRQVA396  /*@bfrg@*/

#define IRC0_IRQVA397	(IRC0.unIRQVA397.u32Register)  /*@rg@*/
#define IRC0_IRQVA397_IRQVA	IRC0_IRQVA397  /*@bfrg@*/

#define IRC0_IRQVA398	(IRC0.unIRQVA398.u32Register)  /*@rg@*/
#define IRC0_IRQVA398_IRQVA	IRC0_IRQVA398  /*@bfrg@*/

#define IRC0_IRQVA399	(IRC0.unIRQVA399.u32Register)  /*@rg@*/
#define IRC0_IRQVA399_IRQVA	IRC0_IRQVA399  /*@bfrg@*/

#define IRC0_IRQVA400	(IRC0.unIRQVA400.u32Register)  /*@rg@*/
#define IRC0_IRQVA400_IRQVA	IRC0_IRQVA400  /*@bfrg@*/

#define IRC0_IRQVA401	(IRC0.unIRQVA401.u32Register)  /*@rg@*/
#define IRC0_IRQVA401_IRQVA	IRC0_IRQVA401  /*@bfrg@*/

#define IRC0_IRQVA402	(IRC0.unIRQVA402.u32Register)  /*@rg@*/
#define IRC0_IRQVA402_IRQVA	IRC0_IRQVA402  /*@bfrg@*/

#define IRC0_IRQVA403	(IRC0.unIRQVA403.u32Register)  /*@rg@*/
#define IRC0_IRQVA403_IRQVA	IRC0_IRQVA403  /*@bfrg@*/

#define IRC0_IRQVA404	(IRC0.unIRQVA404.u32Register)  /*@rg@*/
#define IRC0_IRQVA404_IRQVA	IRC0_IRQVA404  /*@bfrg@*/

#define IRC0_IRQVA405	(IRC0.unIRQVA405.u32Register)  /*@rg@*/
#define IRC0_IRQVA405_IRQVA	IRC0_IRQVA405  /*@bfrg@*/

#define IRC0_IRQVA406	(IRC0.unIRQVA406.u32Register)  /*@rg@*/
#define IRC0_IRQVA406_IRQVA	IRC0_IRQVA406  /*@bfrg@*/

#define IRC0_IRQVA407	(IRC0.unIRQVA407.u32Register)  /*@rg@*/
#define IRC0_IRQVA407_IRQVA	IRC0_IRQVA407  /*@bfrg@*/

#define IRC0_IRQVA408	(IRC0.unIRQVA408.u32Register)  /*@rg@*/
#define IRC0_IRQVA408_IRQVA	IRC0_IRQVA408  /*@bfrg@*/

#define IRC0_IRQVA409	(IRC0.unIRQVA409.u32Register)  /*@rg@*/
#define IRC0_IRQVA409_IRQVA	IRC0_IRQVA409  /*@bfrg@*/

#define IRC0_IRQVA410	(IRC0.unIRQVA410.u32Register)  /*@rg@*/
#define IRC0_IRQVA410_IRQVA	IRC0_IRQVA410  /*@bfrg@*/

#define IRC0_IRQVA411	(IRC0.unIRQVA411.u32Register)  /*@rg@*/
#define IRC0_IRQVA411_IRQVA	IRC0_IRQVA411  /*@bfrg@*/

#define IRC0_IRQVA412	(IRC0.unIRQVA412.u32Register)  /*@rg@*/
#define IRC0_IRQVA412_IRQVA	IRC0_IRQVA412  /*@bfrg@*/

#define IRC0_IRQVA413	(IRC0.unIRQVA413.u32Register)  /*@rg@*/
#define IRC0_IRQVA413_IRQVA	IRC0_IRQVA413  /*@bfrg@*/

#define IRC0_IRQVA414	(IRC0.unIRQVA414.u32Register)  /*@rg@*/
#define IRC0_IRQVA414_IRQVA	IRC0_IRQVA414  /*@bfrg@*/

#define IRC0_IRQVA415	(IRC0.unIRQVA415.u32Register)  /*@rg@*/
#define IRC0_IRQVA415_IRQVA	IRC0_IRQVA415  /*@bfrg@*/

#define IRC0_IRQVA416	(IRC0.unIRQVA416.u32Register)  /*@rg@*/
#define IRC0_IRQVA416_IRQVA	IRC0_IRQVA416  /*@bfrg@*/

#define IRC0_IRQVA417	(IRC0.unIRQVA417.u32Register)  /*@rg@*/
#define IRC0_IRQVA417_IRQVA	IRC0_IRQVA417  /*@bfrg@*/

#define IRC0_IRQVA418	(IRC0.unIRQVA418.u32Register)  /*@rg@*/
#define IRC0_IRQVA418_IRQVA	IRC0_IRQVA418  /*@bfrg@*/

#define IRC0_IRQVA419	(IRC0.unIRQVA419.u32Register)  /*@rg@*/
#define IRC0_IRQVA419_IRQVA	IRC0_IRQVA419  /*@bfrg@*/

#define IRC0_IRQVA420	(IRC0.unIRQVA420.u32Register)  /*@rg@*/
#define IRC0_IRQVA420_IRQVA	IRC0_IRQVA420  /*@bfrg@*/

#define IRC0_IRQVA421	(IRC0.unIRQVA421.u32Register)  /*@rg@*/
#define IRC0_IRQVA421_IRQVA	IRC0_IRQVA421  /*@bfrg@*/

#define IRC0_IRQVA422	(IRC0.unIRQVA422.u32Register)  /*@rg@*/
#define IRC0_IRQVA422_IRQVA	IRC0_IRQVA422  /*@bfrg@*/

#define IRC0_IRQVA423	(IRC0.unIRQVA423.u32Register)  /*@rg@*/
#define IRC0_IRQVA423_IRQVA	IRC0_IRQVA423  /*@bfrg@*/

#define IRC0_IRQVA424	(IRC0.unIRQVA424.u32Register)  /*@rg@*/
#define IRC0_IRQVA424_IRQVA	IRC0_IRQVA424  /*@bfrg@*/

#define IRC0_IRQVA425	(IRC0.unIRQVA425.u32Register)  /*@rg@*/
#define IRC0_IRQVA425_IRQVA	IRC0_IRQVA425  /*@bfrg@*/

#define IRC0_IRQVA426	(IRC0.unIRQVA426.u32Register)  /*@rg@*/
#define IRC0_IRQVA426_IRQVA	IRC0_IRQVA426  /*@bfrg@*/

#define IRC0_IRQVA427	(IRC0.unIRQVA427.u32Register)  /*@rg@*/
#define IRC0_IRQVA427_IRQVA	IRC0_IRQVA427  /*@bfrg@*/

#define IRC0_IRQVA428	(IRC0.unIRQVA428.u32Register)  /*@rg@*/
#define IRC0_IRQVA428_IRQVA	IRC0_IRQVA428  /*@bfrg@*/

#define IRC0_IRQVA429	(IRC0.unIRQVA429.u32Register)  /*@rg@*/
#define IRC0_IRQVA429_IRQVA	IRC0_IRQVA429  /*@bfrg@*/

#define IRC0_IRQVA430	(IRC0.unIRQVA430.u32Register)  /*@rg@*/
#define IRC0_IRQVA430_IRQVA	IRC0_IRQVA430  /*@bfrg@*/

#define IRC0_IRQVA431	(IRC0.unIRQVA431.u32Register)  /*@rg@*/
#define IRC0_IRQVA431_IRQVA	IRC0_IRQVA431  /*@bfrg@*/

#define IRC0_IRQVA432	(IRC0.unIRQVA432.u32Register)  /*@rg@*/
#define IRC0_IRQVA432_IRQVA	IRC0_IRQVA432  /*@bfrg@*/

#define IRC0_IRQVA433	(IRC0.unIRQVA433.u32Register)  /*@rg@*/
#define IRC0_IRQVA433_IRQVA	IRC0_IRQVA433  /*@bfrg@*/

#define IRC0_IRQVA434	(IRC0.unIRQVA434.u32Register)  /*@rg@*/
#define IRC0_IRQVA434_IRQVA	IRC0_IRQVA434  /*@bfrg@*/

#define IRC0_IRQVA435	(IRC0.unIRQVA435.u32Register)  /*@rg@*/
#define IRC0_IRQVA435_IRQVA	IRC0_IRQVA435  /*@bfrg@*/

#define IRC0_IRQVA436	(IRC0.unIRQVA436.u32Register)  /*@rg@*/
#define IRC0_IRQVA436_IRQVA	IRC0_IRQVA436  /*@bfrg@*/

#define IRC0_IRQVA437	(IRC0.unIRQVA437.u32Register)  /*@rg@*/
#define IRC0_IRQVA437_IRQVA	IRC0_IRQVA437  /*@bfrg@*/

#define IRC0_IRQVA438	(IRC0.unIRQVA438.u32Register)  /*@rg@*/
#define IRC0_IRQVA438_IRQVA	IRC0_IRQVA438  /*@bfrg@*/

#define IRC0_IRQVA439	(IRC0.unIRQVA439.u32Register)  /*@rg@*/
#define IRC0_IRQVA439_IRQVA	IRC0_IRQVA439  /*@bfrg@*/

#define IRC0_IRQVA440	(IRC0.unIRQVA440.u32Register)  /*@rg@*/
#define IRC0_IRQVA440_IRQVA	IRC0_IRQVA440  /*@bfrg@*/

#define IRC0_IRQVA441	(IRC0.unIRQVA441.u32Register)  /*@rg@*/
#define IRC0_IRQVA441_IRQVA	IRC0_IRQVA441  /*@bfrg@*/

#define IRC0_IRQVA442	(IRC0.unIRQVA442.u32Register)  /*@rg@*/
#define IRC0_IRQVA442_IRQVA	IRC0_IRQVA442  /*@bfrg@*/

#define IRC0_IRQVA443	(IRC0.unIRQVA443.u32Register)  /*@rg@*/
#define IRC0_IRQVA443_IRQVA	IRC0_IRQVA443  /*@bfrg@*/

#define IRC0_IRQVA444	(IRC0.unIRQVA444.u32Register)  /*@rg@*/
#define IRC0_IRQVA444_IRQVA	IRC0_IRQVA444  /*@bfrg@*/

#define IRC0_IRQVA445	(IRC0.unIRQVA445.u32Register)  /*@rg@*/
#define IRC0_IRQVA445_IRQVA	IRC0_IRQVA445  /*@bfrg@*/

#define IRC0_IRQVA446	(IRC0.unIRQVA446.u32Register)  /*@rg@*/
#define IRC0_IRQVA446_IRQVA	IRC0_IRQVA446  /*@bfrg@*/

#define IRC0_IRQVA447	(IRC0.unIRQVA447.u32Register)  /*@rg@*/
#define IRC0_IRQVA447_IRQVA	IRC0_IRQVA447  /*@bfrg@*/

#define IRC0_IRQVA448	(IRC0.unIRQVA448.u32Register)  /*@rg@*/
#define IRC0_IRQVA448_IRQVA	IRC0_IRQVA448  /*@bfrg@*/

#define IRC0_IRQVA449	(IRC0.unIRQVA449.u32Register)  /*@rg@*/
#define IRC0_IRQVA449_IRQVA	IRC0_IRQVA449  /*@bfrg@*/

#define IRC0_IRQVA450	(IRC0.unIRQVA450.u32Register)  /*@rg@*/
#define IRC0_IRQVA450_IRQVA	IRC0_IRQVA450  /*@bfrg@*/

#define IRC0_IRQVA451	(IRC0.unIRQVA451.u32Register)  /*@rg@*/
#define IRC0_IRQVA451_IRQVA	IRC0_IRQVA451  /*@bfrg@*/

#define IRC0_IRQVA452	(IRC0.unIRQVA452.u32Register)  /*@rg@*/
#define IRC0_IRQVA452_IRQVA	IRC0_IRQVA452  /*@bfrg@*/

#define IRC0_IRQVA453	(IRC0.unIRQVA453.u32Register)  /*@rg@*/
#define IRC0_IRQVA453_IRQVA	IRC0_IRQVA453  /*@bfrg@*/

#define IRC0_IRQVA454	(IRC0.unIRQVA454.u32Register)  /*@rg@*/
#define IRC0_IRQVA454_IRQVA	IRC0_IRQVA454  /*@bfrg@*/

#define IRC0_IRQVA455	(IRC0.unIRQVA455.u32Register)  /*@rg@*/
#define IRC0_IRQVA455_IRQVA	IRC0_IRQVA455  /*@bfrg@*/

#define IRC0_IRQVA456	(IRC0.unIRQVA456.u32Register)  /*@rg@*/
#define IRC0_IRQVA456_IRQVA	IRC0_IRQVA456  /*@bfrg@*/

#define IRC0_IRQVA457	(IRC0.unIRQVA457.u32Register)  /*@rg@*/
#define IRC0_IRQVA457_IRQVA	IRC0_IRQVA457  /*@bfrg@*/

#define IRC0_IRQVA458	(IRC0.unIRQVA458.u32Register)  /*@rg@*/
#define IRC0_IRQVA458_IRQVA	IRC0_IRQVA458  /*@bfrg@*/

#define IRC0_IRQVA459	(IRC0.unIRQVA459.u32Register)  /*@rg@*/
#define IRC0_IRQVA459_IRQVA	IRC0_IRQVA459  /*@bfrg@*/

#define IRC0_IRQVA460	(IRC0.unIRQVA460.u32Register)  /*@rg@*/
#define IRC0_IRQVA460_IRQVA	IRC0_IRQVA460  /*@bfrg@*/

#define IRC0_IRQVA461	(IRC0.unIRQVA461.u32Register)  /*@rg@*/
#define IRC0_IRQVA461_IRQVA	IRC0_IRQVA461  /*@bfrg@*/

#define IRC0_IRQVA462	(IRC0.unIRQVA462.u32Register)  /*@rg@*/
#define IRC0_IRQVA462_IRQVA	IRC0_IRQVA462  /*@bfrg@*/

#define IRC0_IRQVA463	(IRC0.unIRQVA463.u32Register)  /*@rg@*/
#define IRC0_IRQVA463_IRQVA	IRC0_IRQVA463  /*@bfrg@*/

#define IRC0_IRQVA464	(IRC0.unIRQVA464.u32Register)  /*@rg@*/
#define IRC0_IRQVA464_IRQVA	IRC0_IRQVA464  /*@bfrg@*/

#define IRC0_IRQVA465	(IRC0.unIRQVA465.u32Register)  /*@rg@*/
#define IRC0_IRQVA465_IRQVA	IRC0_IRQVA465  /*@bfrg@*/

#define IRC0_IRQVA466	(IRC0.unIRQVA466.u32Register)  /*@rg@*/
#define IRC0_IRQVA466_IRQVA	IRC0_IRQVA466  /*@bfrg@*/

#define IRC0_IRQVA467	(IRC0.unIRQVA467.u32Register)  /*@rg@*/
#define IRC0_IRQVA467_IRQVA	IRC0_IRQVA467  /*@bfrg@*/

#define IRC0_IRQVA468	(IRC0.unIRQVA468.u32Register)  /*@rg@*/
#define IRC0_IRQVA468_IRQVA	IRC0_IRQVA468  /*@bfrg@*/

#define IRC0_IRQVA469	(IRC0.unIRQVA469.u32Register)  /*@rg@*/
#define IRC0_IRQVA469_IRQVA	IRC0_IRQVA469  /*@bfrg@*/

#define IRC0_IRQVA470	(IRC0.unIRQVA470.u32Register)  /*@rg@*/
#define IRC0_IRQVA470_IRQVA	IRC0_IRQVA470  /*@bfrg@*/

#define IRC0_IRQVA471	(IRC0.unIRQVA471.u32Register)  /*@rg@*/
#define IRC0_IRQVA471_IRQVA	IRC0_IRQVA471  /*@bfrg@*/

#define IRC0_IRQVA472	(IRC0.unIRQVA472.u32Register)  /*@rg@*/
#define IRC0_IRQVA472_IRQVA	IRC0_IRQVA472  /*@bfrg@*/

#define IRC0_IRQVA473	(IRC0.unIRQVA473.u32Register)  /*@rg@*/
#define IRC0_IRQVA473_IRQVA	IRC0_IRQVA473  /*@bfrg@*/

#define IRC0_IRQVA474	(IRC0.unIRQVA474.u32Register)  /*@rg@*/
#define IRC0_IRQVA474_IRQVA	IRC0_IRQVA474  /*@bfrg@*/

#define IRC0_IRQVA475	(IRC0.unIRQVA475.u32Register)  /*@rg@*/
#define IRC0_IRQVA475_IRQVA	IRC0_IRQVA475  /*@bfrg@*/

#define IRC0_IRQVA476	(IRC0.unIRQVA476.u32Register)  /*@rg@*/
#define IRC0_IRQVA476_IRQVA	IRC0_IRQVA476  /*@bfrg@*/

#define IRC0_IRQVA477	(IRC0.unIRQVA477.u32Register)  /*@rg@*/
#define IRC0_IRQVA477_IRQVA	IRC0_IRQVA477  /*@bfrg@*/

#define IRC0_IRQVA478	(IRC0.unIRQVA478.u32Register)  /*@rg@*/
#define IRC0_IRQVA478_IRQVA	IRC0_IRQVA478  /*@bfrg@*/

#define IRC0_IRQVA479	(IRC0.unIRQVA479.u32Register)  /*@rg@*/
#define IRC0_IRQVA479_IRQVA	IRC0_IRQVA479  /*@bfrg@*/

#define IRC0_IRQVA480	(IRC0.unIRQVA480.u32Register)  /*@rg@*/
#define IRC0_IRQVA480_IRQVA	IRC0_IRQVA480  /*@bfrg@*/

#define IRC0_IRQVA481	(IRC0.unIRQVA481.u32Register)  /*@rg@*/
#define IRC0_IRQVA481_IRQVA	IRC0_IRQVA481  /*@bfrg@*/

#define IRC0_IRQVA482	(IRC0.unIRQVA482.u32Register)  /*@rg@*/
#define IRC0_IRQVA482_IRQVA	IRC0_IRQVA482  /*@bfrg@*/

#define IRC0_IRQVA483	(IRC0.unIRQVA483.u32Register)  /*@rg@*/
#define IRC0_IRQVA483_IRQVA	IRC0_IRQVA483  /*@bfrg@*/

#define IRC0_IRQVA484	(IRC0.unIRQVA484.u32Register)  /*@rg@*/
#define IRC0_IRQVA484_IRQVA	IRC0_IRQVA484  /*@bfrg@*/

#define IRC0_IRQVA485	(IRC0.unIRQVA485.u32Register)  /*@rg@*/
#define IRC0_IRQVA485_IRQVA	IRC0_IRQVA485  /*@bfrg@*/

#define IRC0_IRQVA486	(IRC0.unIRQVA486.u32Register)  /*@rg@*/
#define IRC0_IRQVA486_IRQVA	IRC0_IRQVA486  /*@bfrg@*/

#define IRC0_IRQVA487	(IRC0.unIRQVA487.u32Register)  /*@rg@*/
#define IRC0_IRQVA487_IRQVA	IRC0_IRQVA487  /*@bfrg@*/

#define IRC0_IRQVA488	(IRC0.unIRQVA488.u32Register)  /*@rg@*/
#define IRC0_IRQVA488_IRQVA	IRC0_IRQVA488  /*@bfrg@*/

#define IRC0_IRQVA489	(IRC0.unIRQVA489.u32Register)  /*@rg@*/
#define IRC0_IRQVA489_IRQVA	IRC0_IRQVA489  /*@bfrg@*/

#define IRC0_IRQVA490	(IRC0.unIRQVA490.u32Register)  /*@rg@*/
#define IRC0_IRQVA490_IRQVA	IRC0_IRQVA490  /*@bfrg@*/

#define IRC0_IRQVA491	(IRC0.unIRQVA491.u32Register)  /*@rg@*/
#define IRC0_IRQVA491_IRQVA	IRC0_IRQVA491  /*@bfrg@*/

#define IRC0_IRQVA492	(IRC0.unIRQVA492.u32Register)  /*@rg@*/
#define IRC0_IRQVA492_IRQVA	IRC0_IRQVA492  /*@bfrg@*/

#define IRC0_IRQVA493	(IRC0.unIRQVA493.u32Register)  /*@rg@*/
#define IRC0_IRQVA493_IRQVA	IRC0_IRQVA493  /*@bfrg@*/

#define IRC0_IRQVA494	(IRC0.unIRQVA494.u32Register)  /*@rg@*/
#define IRC0_IRQVA494_IRQVA	IRC0_IRQVA494  /*@bfrg@*/

#define IRC0_IRQVA495	(IRC0.unIRQVA495.u32Register)  /*@rg@*/
#define IRC0_IRQVA495_IRQVA	IRC0_IRQVA495  /*@bfrg@*/

#define IRC0_IRQVA496	(IRC0.unIRQVA496.u32Register)  /*@rg@*/
#define IRC0_IRQVA496_IRQVA	IRC0_IRQVA496  /*@bfrg@*/

#define IRC0_IRQVA497	(IRC0.unIRQVA497.u32Register)  /*@rg@*/
#define IRC0_IRQVA497_IRQVA	IRC0_IRQVA497  /*@bfrg@*/

#define IRC0_IRQVA498	(IRC0.unIRQVA498.u32Register)  /*@rg@*/
#define IRC0_IRQVA498_IRQVA	IRC0_IRQVA498  /*@bfrg@*/

#define IRC0_IRQVA499	(IRC0.unIRQVA499.u32Register)  /*@rg@*/
#define IRC0_IRQVA499_IRQVA	IRC0_IRQVA499  /*@bfrg@*/

#define IRC0_IRQVA500	(IRC0.unIRQVA500.u32Register)  /*@rg@*/
#define IRC0_IRQVA500_IRQVA	IRC0_IRQVA500  /*@bfrg@*/

#define IRC0_IRQVA501	(IRC0.unIRQVA501.u32Register)  /*@rg@*/
#define IRC0_IRQVA501_IRQVA	IRC0_IRQVA501  /*@bfrg@*/

#define IRC0_IRQVA502	(IRC0.unIRQVA502.u32Register)  /*@rg@*/
#define IRC0_IRQVA502_IRQVA	IRC0_IRQVA502  /*@bfrg@*/

#define IRC0_IRQVA503	(IRC0.unIRQVA503.u32Register)  /*@rg@*/
#define IRC0_IRQVA503_IRQVA	IRC0_IRQVA503  /*@bfrg@*/

#define IRC0_IRQVA504	(IRC0.unIRQVA504.u32Register)  /*@rg@*/
#define IRC0_IRQVA504_IRQVA	IRC0_IRQVA504  /*@bfrg@*/

#define IRC0_IRQVA505	(IRC0.unIRQVA505.u32Register)  /*@rg@*/
#define IRC0_IRQVA505_IRQVA	IRC0_IRQVA505  /*@bfrg@*/

#define IRC0_IRQVA506	(IRC0.unIRQVA506.u32Register)  /*@rg@*/
#define IRC0_IRQVA506_IRQVA	IRC0_IRQVA506  /*@bfrg@*/

#define IRC0_IRQVA507	(IRC0.unIRQVA507.u32Register)  /*@rg@*/
#define IRC0_IRQVA507_IRQVA	IRC0_IRQVA507  /*@bfrg@*/

#define IRC0_IRQVA508	(IRC0.unIRQVA508.u32Register)  /*@rg@*/
#define IRC0_IRQVA508_IRQVA	IRC0_IRQVA508  /*@bfrg@*/

#define IRC0_IRQVA509	(IRC0.unIRQVA509.u32Register)  /*@rg@*/
#define IRC0_IRQVA509_IRQVA	IRC0_IRQVA509  /*@bfrg@*/

#define IRC0_IRQVA510	(IRC0.unIRQVA510.u32Register)  /*@rg@*/
#define IRC0_IRQVA510_IRQVA	IRC0_IRQVA510  /*@bfrg@*/

#define IRC0_IRQVA511	(IRC0.unIRQVA511.u32Register)  /*@rg@*/
#define IRC0_IRQVA511_IRQVA	IRC0_IRQVA511  /*@bfrg@*/

typedef union un_irc0_irqvan{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqvan_t;

/* NMIPL0 */
#define IRC0_NMIPL0	(IRC0.unNMIPL0.u32Register)  /*@rg@*/
#define IRC0_NMIPL0_NMIPL0	(IRC0.unNMIPL0.stcField.u4NMIPL0)  /*@bf@*/
#define IRC0_NMIPL0_NMIPL1	(IRC0.unNMIPL0.stcField.u4NMIPL1)  /*@bf@*/
#define IRC0_NMIPL0_NMIPL2	(IRC0.unNMIPL0.stcField.u4NMIPL2)  /*@bf@*/
#define IRC0_NMIPL0_NMIPL3	(IRC0.unNMIPL0.stcField.u4NMIPL3)  /*@bf@*/

typedef struct stc_irc0_nmipl0_field{
    uint_io32_t		u4NMIPL0:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL1:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL2:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL3:4;
    uint_io32_t		:4;
}stc_irc0_nmipl0_field_t;

typedef union un_irc0_nmipl0{
    uint_io32_t		u32Register;
    stc_irc0_nmipl0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmipl0_t;

/* NMIPL1 */
#define IRC0_NMIPL1	(IRC0.unNMIPL1.u32Register)  /*@rg@*/
#define IRC0_NMIPL1_NMIPL4	(IRC0.unNMIPL1.stcField.u4NMIPL4)  /*@bf@*/
#define IRC0_NMIPL1_NMIPL5	(IRC0.unNMIPL1.stcField.u4NMIPL5)  /*@bf@*/
#define IRC0_NMIPL1_NMIPL6	(IRC0.unNMIPL1.stcField.u4NMIPL6)  /*@bf@*/
#define IRC0_NMIPL1_NMIPL7	(IRC0.unNMIPL1.stcField.u4NMIPL7)  /*@bf@*/

typedef struct stc_irc0_nmipl1_field{
    uint_io32_t		u4NMIPL4:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL5:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL6:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL7:4;
    uint_io32_t		:4;
}stc_irc0_nmipl1_field_t;

typedef union un_irc0_nmipl1{
    uint_io32_t		u32Register;
    stc_irc0_nmipl1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmipl1_t;

/* NMIPL2 */
#define IRC0_NMIPL2	(IRC0.unNMIPL2.u32Register)  /*@rg@*/
#define IRC0_NMIPL2_NMIPL8	(IRC0.unNMIPL2.stcField.u4NMIPL8)  /*@bf@*/
#define IRC0_NMIPL2_NMIPL9	(IRC0.unNMIPL2.stcField.u4NMIPL9)  /*@bf@*/
#define IRC0_NMIPL2_NMIPL10	(IRC0.unNMIPL2.stcField.u4NMIPL10)  /*@bf@*/
#define IRC0_NMIPL2_NMIPL11	(IRC0.unNMIPL2.stcField.u4NMIPL11)  /*@bf@*/

typedef struct stc_irc0_nmipl2_field{
    uint_io32_t		u4NMIPL8:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL9:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL10:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL11:4;
    uint_io32_t		:4;
}stc_irc0_nmipl2_field_t;

typedef union un_irc0_nmipl2{
    uint_io32_t		u32Register;
    stc_irc0_nmipl2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmipl2_t;

/* NMIPL3 */
#define IRC0_NMIPL3	(IRC0.unNMIPL3.u32Register)  /*@rg@*/
#define IRC0_NMIPL3_NMIPL12	(IRC0.unNMIPL3.stcField.u4NMIPL12)  /*@bf@*/
#define IRC0_NMIPL3_NMIPL13	(IRC0.unNMIPL3.stcField.u4NMIPL13)  /*@bf@*/
#define IRC0_NMIPL3_NMIPL14	(IRC0.unNMIPL3.stcField.u4NMIPL14)  /*@bf@*/
#define IRC0_NMIPL3_NMIPL15	(IRC0.unNMIPL3.stcField.u4NMIPL15)  /*@bf@*/

typedef struct stc_irc0_nmipl3_field{
    uint_io32_t		u4NMIPL12:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL13:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL14:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL15:4;
    uint_io32_t		:4;
}stc_irc0_nmipl3_field_t;

typedef union un_irc0_nmipl3{
    uint_io32_t		u32Register;
    stc_irc0_nmipl3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmipl3_t;

/* NMIPL4 */
#define IRC0_NMIPL4	(IRC0.unNMIPL4.u32Register)  /*@rg@*/
#define IRC0_NMIPL4_NMIPL16	(IRC0.unNMIPL4.stcField.u4NMIPL16)  /*@bf@*/
#define IRC0_NMIPL4_NMIPL17	(IRC0.unNMIPL4.stcField.u4NMIPL17)  /*@bf@*/
#define IRC0_NMIPL4_NMIPL18	(IRC0.unNMIPL4.stcField.u4NMIPL18)  /*@bf@*/
#define IRC0_NMIPL4_NMIPL19	(IRC0.unNMIPL4.stcField.u4NMIPL19)  /*@bf@*/

typedef struct stc_irc0_nmipl4_field{
    uint_io32_t		u4NMIPL16:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL17:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL18:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL19:4;
    uint_io32_t		:4;
}stc_irc0_nmipl4_field_t;

typedef union un_irc0_nmipl4{
    uint_io32_t		u32Register;
    stc_irc0_nmipl4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmipl4_t;

/* NMIPL5 */
#define IRC0_NMIPL5	(IRC0.unNMIPL5.u32Register)  /*@rg@*/
#define IRC0_NMIPL5_NMIPL20	(IRC0.unNMIPL5.stcField.u4NMIPL20)  /*@bf@*/
#define IRC0_NMIPL5_NMIPL21	(IRC0.unNMIPL5.stcField.u4NMIPL21)  /*@bf@*/
#define IRC0_NMIPL5_NMIPL22	(IRC0.unNMIPL5.stcField.u4NMIPL22)  /*@bf@*/
#define IRC0_NMIPL5_NMIPL23	(IRC0.unNMIPL5.stcField.u4NMIPL23)  /*@bf@*/

typedef struct stc_irc0_nmipl5_field{
    uint_io32_t		u4NMIPL20:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL21:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL22:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL23:4;
    uint_io32_t		:4;
}stc_irc0_nmipl5_field_t;

typedef union un_irc0_nmipl5{
    uint_io32_t		u32Register;
    stc_irc0_nmipl5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmipl5_t;

/* NMIPL6 */
#define IRC0_NMIPL6	(IRC0.unNMIPL6.u32Register)  /*@rg@*/
#define IRC0_NMIPL6_NMIPL24	(IRC0.unNMIPL6.stcField.u4NMIPL24)  /*@bf@*/
#define IRC0_NMIPL6_NMIPL25	(IRC0.unNMIPL6.stcField.u4NMIPL25)  /*@bf@*/
#define IRC0_NMIPL6_NMIPL26	(IRC0.unNMIPL6.stcField.u4NMIPL26)  /*@bf@*/
#define IRC0_NMIPL6_NMIPL27	(IRC0.unNMIPL6.stcField.u4NMIPL27)  /*@bf@*/

typedef struct stc_irc0_nmipl6_field{
    uint_io32_t		u4NMIPL24:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL25:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL26:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL27:4;
    uint_io32_t		:4;
}stc_irc0_nmipl6_field_t;

typedef union un_irc0_nmipl6{
    uint_io32_t		u32Register;
    stc_irc0_nmipl6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmipl6_t;

/* NMIPL7 */
#define IRC0_NMIPL7	(IRC0.unNMIPL7.u32Register)  /*@rg@*/
#define IRC0_NMIPL7_NMIPL28	(IRC0.unNMIPL7.stcField.u4NMIPL28)  /*@bf@*/
#define IRC0_NMIPL7_NMIPL29	(IRC0.unNMIPL7.stcField.u4NMIPL29)  /*@bf@*/
#define IRC0_NMIPL7_NMIPL30	(IRC0.unNMIPL7.stcField.u4NMIPL30)  /*@bf@*/
#define IRC0_NMIPL7_NMIPL31	(IRC0.unNMIPL7.stcField.u4NMIPL31)  /*@bf@*/

typedef struct stc_irc0_nmipl7_field{
    uint_io32_t		u4NMIPL28:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL29:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL30:4;
    uint_io32_t		:4;
    uint_io32_t		u4NMIPL31:4;
    uint_io32_t		:4;
}stc_irc0_nmipl7_field_t;

typedef union un_irc0_nmipl7{
    uint_io32_t		u32Register;
    stc_irc0_nmipl7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmipl7_t;

/* IRQPL0 */
#define IRC0_IRQPL0	(IRC0.unIRQPL0.u32Register)  /*@rg@*/
#define IRC0_IRQPL0_IRQPL0	(IRC0.unIRQPL0.stcField.u5IRQPL0)  /*@bf@*/
#define IRC0_IRQPL0_IRQPL1	(IRC0.unIRQPL0.stcField.u5IRQPL1)  /*@bf@*/
#define IRC0_IRQPL0_IRQPL2	(IRC0.unIRQPL0.stcField.u5IRQPL2)  /*@bf@*/
#define IRC0_IRQPL0_IRQPL3	(IRC0.unIRQPL0.stcField.u5IRQPL3)  /*@bf@*/

typedef struct stc_irc0_irqpl0_field{
    uint_io32_t		u5IRQPL0:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL1:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL2:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL3:5;
    uint_io32_t		:3;
}stc_irc0_irqpl0_field_t;

typedef union un_irc0_irqpl0{
    uint_io32_t		u32Register;
    stc_irc0_irqpl0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl0_t;

/* IRQPL1 */
#define IRC0_IRQPL1	(IRC0.unIRQPL1.u32Register)  /*@rg@*/
#define IRC0_IRQPL1_IRQPL4	(IRC0.unIRQPL1.stcField.u5IRQPL4)  /*@bf@*/
#define IRC0_IRQPL1_IRQPL5	(IRC0.unIRQPL1.stcField.u5IRQPL5)  /*@bf@*/
#define IRC0_IRQPL1_IRQPL6	(IRC0.unIRQPL1.stcField.u5IRQPL6)  /*@bf@*/
#define IRC0_IRQPL1_IRQPL7	(IRC0.unIRQPL1.stcField.u5IRQPL7)  /*@bf@*/

typedef struct stc_irc0_irqpl1_field{
    uint_io32_t		u5IRQPL4:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL5:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL6:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL7:5;
    uint_io32_t		:3;
}stc_irc0_irqpl1_field_t;

typedef union un_irc0_irqpl1{
    uint_io32_t		u32Register;
    stc_irc0_irqpl1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl1_t;

/* IRQPL2 */
#define IRC0_IRQPL2	(IRC0.unIRQPL2.u32Register)  /*@rg@*/
#define IRC0_IRQPL2_IRQPL8	(IRC0.unIRQPL2.stcField.u5IRQPL8)  /*@bf@*/
#define IRC0_IRQPL2_IRQPL9	(IRC0.unIRQPL2.stcField.u5IRQPL9)  /*@bf@*/
#define IRC0_IRQPL2_IRQPL10	(IRC0.unIRQPL2.stcField.u5IRQPL10)  /*@bf@*/
#define IRC0_IRQPL2_IRQPL11	(IRC0.unIRQPL2.stcField.u5IRQPL11)  /*@bf@*/

typedef struct stc_irc0_irqpl2_field{
    uint_io32_t		u5IRQPL8:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL9:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL10:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL11:5;
    uint_io32_t		:3;
}stc_irc0_irqpl2_field_t;

typedef union un_irc0_irqpl2{
    uint_io32_t		u32Register;
    stc_irc0_irqpl2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl2_t;

/* IRQPL3 */
#define IRC0_IRQPL3	(IRC0.unIRQPL3.u32Register)  /*@rg@*/
#define IRC0_IRQPL3_IRQPL12	(IRC0.unIRQPL3.stcField.u5IRQPL12)  /*@bf@*/
#define IRC0_IRQPL3_IRQPL13	(IRC0.unIRQPL3.stcField.u5IRQPL13)  /*@bf@*/
#define IRC0_IRQPL3_IRQPL14	(IRC0.unIRQPL3.stcField.u5IRQPL14)  /*@bf@*/
#define IRC0_IRQPL3_IRQPL15	(IRC0.unIRQPL3.stcField.u5IRQPL15)  /*@bf@*/

typedef struct stc_irc0_irqpl3_field{
    uint_io32_t		u5IRQPL12:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL13:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL14:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL15:5;
    uint_io32_t		:3;
}stc_irc0_irqpl3_field_t;

typedef union un_irc0_irqpl3{
    uint_io32_t		u32Register;
    stc_irc0_irqpl3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl3_t;

/* IRQPL4 */
#define IRC0_IRQPL4	(IRC0.unIRQPL4.u32Register)  /*@rg@*/
#define IRC0_IRQPL4_IRQPL16	(IRC0.unIRQPL4.stcField.u5IRQPL16)  /*@bf@*/
#define IRC0_IRQPL4_IRQPL17	(IRC0.unIRQPL4.stcField.u5IRQPL17)  /*@bf@*/
#define IRC0_IRQPL4_IRQPL18	(IRC0.unIRQPL4.stcField.u5IRQPL18)  /*@bf@*/
#define IRC0_IRQPL4_IRQPL19	(IRC0.unIRQPL4.stcField.u5IRQPL19)  /*@bf@*/

typedef struct stc_irc0_irqpl4_field{
    uint_io32_t		u5IRQPL16:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL17:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL18:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL19:5;
    uint_io32_t		:3;
}stc_irc0_irqpl4_field_t;

typedef union un_irc0_irqpl4{
    uint_io32_t		u32Register;
    stc_irc0_irqpl4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl4_t;

/* IRQPL5 */
#define IRC0_IRQPL5	(IRC0.unIRQPL5.u32Register)  /*@rg@*/
#define IRC0_IRQPL5_IRQPL20	(IRC0.unIRQPL5.stcField.u5IRQPL20)  /*@bf@*/
#define IRC0_IRQPL5_IRQPL21	(IRC0.unIRQPL5.stcField.u5IRQPL21)  /*@bf@*/
#define IRC0_IRQPL5_IRQPL22	(IRC0.unIRQPL5.stcField.u5IRQPL22)  /*@bf@*/
#define IRC0_IRQPL5_IRQPL23	(IRC0.unIRQPL5.stcField.u5IRQPL23)  /*@bf@*/

typedef struct stc_irc0_irqpl5_field{
    uint_io32_t		u5IRQPL20:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL21:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL22:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL23:5;
    uint_io32_t		:3;
}stc_irc0_irqpl5_field_t;

typedef union un_irc0_irqpl5{
    uint_io32_t		u32Register;
    stc_irc0_irqpl5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl5_t;

/* IRQPL6 */
#define IRC0_IRQPL6	(IRC0.unIRQPL6.u32Register)  /*@rg@*/
#define IRC0_IRQPL6_IRQPL24	(IRC0.unIRQPL6.stcField.u5IRQPL24)  /*@bf@*/
#define IRC0_IRQPL6_IRQPL25	(IRC0.unIRQPL6.stcField.u5IRQPL25)  /*@bf@*/
#define IRC0_IRQPL6_IRQPL26	(IRC0.unIRQPL6.stcField.u5IRQPL26)  /*@bf@*/
#define IRC0_IRQPL6_IRQPL27	(IRC0.unIRQPL6.stcField.u5IRQPL27)  /*@bf@*/

typedef struct stc_irc0_irqpl6_field{
    uint_io32_t		u5IRQPL24:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL25:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL26:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL27:5;
    uint_io32_t		:3;
}stc_irc0_irqpl6_field_t;

typedef union un_irc0_irqpl6{
    uint_io32_t		u32Register;
    stc_irc0_irqpl6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl6_t;

/* IRQPL7 */
#define IRC0_IRQPL7	(IRC0.unIRQPL7.u32Register)  /*@rg@*/
#define IRC0_IRQPL7_IRQPL28	(IRC0.unIRQPL7.stcField.u5IRQPL28)  /*@bf@*/
#define IRC0_IRQPL7_IRQPL29	(IRC0.unIRQPL7.stcField.u5IRQPL29)  /*@bf@*/
#define IRC0_IRQPL7_IRQPL30	(IRC0.unIRQPL7.stcField.u5IRQPL30)  /*@bf@*/
#define IRC0_IRQPL7_IRQPL31	(IRC0.unIRQPL7.stcField.u5IRQPL31)  /*@bf@*/

typedef struct stc_irc0_irqpl7_field{
    uint_io32_t		u5IRQPL28:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL29:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL30:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL31:5;
    uint_io32_t		:3;
}stc_irc0_irqpl7_field_t;

typedef union un_irc0_irqpl7{
    uint_io32_t		u32Register;
    stc_irc0_irqpl7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl7_t;

/* IRQPL8 */
#define IRC0_IRQPL8	(IRC0.unIRQPL8.u32Register)  /*@rg@*/
#define IRC0_IRQPL8_IRQPL32	(IRC0.unIRQPL8.stcField.u5IRQPL32)  /*@bf@*/
#define IRC0_IRQPL8_IRQPL33	(IRC0.unIRQPL8.stcField.u5IRQPL33)  /*@bf@*/
#define IRC0_IRQPL8_IRQPL34	(IRC0.unIRQPL8.stcField.u5IRQPL34)  /*@bf@*/
#define IRC0_IRQPL8_IRQPL35	(IRC0.unIRQPL8.stcField.u5IRQPL35)  /*@bf@*/

typedef struct stc_irc0_irqpl8_field{
    uint_io32_t		u5IRQPL32:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL33:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL34:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL35:5;
    uint_io32_t		:3;
}stc_irc0_irqpl8_field_t;

typedef union un_irc0_irqpl8{
    uint_io32_t		u32Register;
    stc_irc0_irqpl8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl8_t;

/* IRQPL9 */
#define IRC0_IRQPL9	(IRC0.unIRQPL9.u32Register)  /*@rg@*/
#define IRC0_IRQPL9_IRQPL36	(IRC0.unIRQPL9.stcField.u5IRQPL36)  /*@bf@*/
#define IRC0_IRQPL9_IRQPL37	(IRC0.unIRQPL9.stcField.u5IRQPL37)  /*@bf@*/
#define IRC0_IRQPL9_IRQPL38	(IRC0.unIRQPL9.stcField.u5IRQPL38)  /*@bf@*/
#define IRC0_IRQPL9_IRQPL39	(IRC0.unIRQPL9.stcField.u5IRQPL39)  /*@bf@*/

typedef struct stc_irc0_irqpl9_field{
    uint_io32_t		u5IRQPL36:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL37:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL38:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL39:5;
    uint_io32_t		:3;
}stc_irc0_irqpl9_field_t;

typedef union un_irc0_irqpl9{
    uint_io32_t		u32Register;
    stc_irc0_irqpl9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl9_t;

/* IRQPL10 */
#define IRC0_IRQPL10	(IRC0.unIRQPL10.u32Register)  /*@rg@*/
#define IRC0_IRQPL10_IRQPL40	(IRC0.unIRQPL10.stcField.u5IRQPL40)  /*@bf@*/
#define IRC0_IRQPL10_IRQPL41	(IRC0.unIRQPL10.stcField.u5IRQPL41)  /*@bf@*/
#define IRC0_IRQPL10_IRQPL42	(IRC0.unIRQPL10.stcField.u5IRQPL42)  /*@bf@*/
#define IRC0_IRQPL10_IRQPL43	(IRC0.unIRQPL10.stcField.u5IRQPL43)  /*@bf@*/

typedef struct stc_irc0_irqpl10_field{
    uint_io32_t		u5IRQPL40:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL41:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL42:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL43:5;
    uint_io32_t		:3;
}stc_irc0_irqpl10_field_t;

typedef union un_irc0_irqpl10{
    uint_io32_t		u32Register;
    stc_irc0_irqpl10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl10_t;

/* IRQPL11 */
#define IRC0_IRQPL11	(IRC0.unIRQPL11.u32Register)  /*@rg@*/
#define IRC0_IRQPL11_IRQPL44	(IRC0.unIRQPL11.stcField.u5IRQPL44)  /*@bf@*/
#define IRC0_IRQPL11_IRQPL45	(IRC0.unIRQPL11.stcField.u5IRQPL45)  /*@bf@*/
#define IRC0_IRQPL11_IRQPL46	(IRC0.unIRQPL11.stcField.u5IRQPL46)  /*@bf@*/
#define IRC0_IRQPL11_IRQPL47	(IRC0.unIRQPL11.stcField.u5IRQPL47)  /*@bf@*/

typedef struct stc_irc0_irqpl11_field{
    uint_io32_t		u5IRQPL44:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL45:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL46:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL47:5;
    uint_io32_t		:3;
}stc_irc0_irqpl11_field_t;

typedef union un_irc0_irqpl11{
    uint_io32_t		u32Register;
    stc_irc0_irqpl11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl11_t;

/* IRQPL12 */
#define IRC0_IRQPL12	(IRC0.unIRQPL12.u32Register)  /*@rg@*/
#define IRC0_IRQPL12_IRQPL48	(IRC0.unIRQPL12.stcField.u5IRQPL48)  /*@bf@*/
#define IRC0_IRQPL12_IRQPL49	(IRC0.unIRQPL12.stcField.u5IRQPL49)  /*@bf@*/
#define IRC0_IRQPL12_IRQPL50	(IRC0.unIRQPL12.stcField.u5IRQPL50)  /*@bf@*/
#define IRC0_IRQPL12_IRQPL51	(IRC0.unIRQPL12.stcField.u5IRQPL51)  /*@bf@*/

typedef struct stc_irc0_irqpl12_field{
    uint_io32_t		u5IRQPL48:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL49:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL50:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL51:5;
    uint_io32_t		:3;
}stc_irc0_irqpl12_field_t;

typedef union un_irc0_irqpl12{
    uint_io32_t		u32Register;
    stc_irc0_irqpl12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl12_t;

/* IRQPL13 */
#define IRC0_IRQPL13	(IRC0.unIRQPL13.u32Register)  /*@rg@*/
#define IRC0_IRQPL13_IRQPL52	(IRC0.unIRQPL13.stcField.u5IRQPL52)  /*@bf@*/
#define IRC0_IRQPL13_IRQPL53	(IRC0.unIRQPL13.stcField.u5IRQPL53)  /*@bf@*/
#define IRC0_IRQPL13_IRQPL54	(IRC0.unIRQPL13.stcField.u5IRQPL54)  /*@bf@*/
#define IRC0_IRQPL13_IRQPL55	(IRC0.unIRQPL13.stcField.u5IRQPL55)  /*@bf@*/

typedef struct stc_irc0_irqpl13_field{
    uint_io32_t		u5IRQPL52:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL53:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL54:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL55:5;
    uint_io32_t		:3;
}stc_irc0_irqpl13_field_t;

typedef union un_irc0_irqpl13{
    uint_io32_t		u32Register;
    stc_irc0_irqpl13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl13_t;

/* IRQPL14 */
#define IRC0_IRQPL14	(IRC0.unIRQPL14.u32Register)  /*@rg@*/
#define IRC0_IRQPL14_IRQPL56	(IRC0.unIRQPL14.stcField.u5IRQPL56)  /*@bf@*/
#define IRC0_IRQPL14_IRQPL57	(IRC0.unIRQPL14.stcField.u5IRQPL57)  /*@bf@*/
#define IRC0_IRQPL14_IRQPL58	(IRC0.unIRQPL14.stcField.u5IRQPL58)  /*@bf@*/
#define IRC0_IRQPL14_IRQPL59	(IRC0.unIRQPL14.stcField.u5IRQPL59)  /*@bf@*/

typedef struct stc_irc0_irqpl14_field{
    uint_io32_t		u5IRQPL56:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL57:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL58:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL59:5;
    uint_io32_t		:3;
}stc_irc0_irqpl14_field_t;

typedef union un_irc0_irqpl14{
    uint_io32_t		u32Register;
    stc_irc0_irqpl14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl14_t;

/* IRQPL15 */
#define IRC0_IRQPL15	(IRC0.unIRQPL15.u32Register)  /*@rg@*/
#define IRC0_IRQPL15_IRQPL60	(IRC0.unIRQPL15.stcField.u5IRQPL60)  /*@bf@*/
#define IRC0_IRQPL15_IRQPL61	(IRC0.unIRQPL15.stcField.u5IRQPL61)  /*@bf@*/
#define IRC0_IRQPL15_IRQPL62	(IRC0.unIRQPL15.stcField.u5IRQPL62)  /*@bf@*/
#define IRC0_IRQPL15_IRQPL63	(IRC0.unIRQPL15.stcField.u5IRQPL63)  /*@bf@*/

typedef struct stc_irc0_irqpl15_field{
    uint_io32_t		u5IRQPL60:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL61:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL62:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL63:5;
    uint_io32_t		:3;
}stc_irc0_irqpl15_field_t;

typedef union un_irc0_irqpl15{
    uint_io32_t		u32Register;
    stc_irc0_irqpl15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl15_t;

/* IRQPL16 */
#define IRC0_IRQPL16	(IRC0.unIRQPL16.u32Register)  /*@rg@*/
#define IRC0_IRQPL16_IRQPL64	(IRC0.unIRQPL16.stcField.u5IRQPL64)  /*@bf@*/
#define IRC0_IRQPL16_IRQPL65	(IRC0.unIRQPL16.stcField.u5IRQPL65)  /*@bf@*/
#define IRC0_IRQPL16_IRQPL66	(IRC0.unIRQPL16.stcField.u5IRQPL66)  /*@bf@*/
#define IRC0_IRQPL16_IRQPL67	(IRC0.unIRQPL16.stcField.u5IRQPL67)  /*@bf@*/

typedef struct stc_irc0_irqpl16_field{
    uint_io32_t		u5IRQPL64:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL65:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL66:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL67:5;
    uint_io32_t		:3;
}stc_irc0_irqpl16_field_t;

typedef union un_irc0_irqpl16{
    uint_io32_t		u32Register;
    stc_irc0_irqpl16_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl16_t;

/* IRQPL17 */
#define IRC0_IRQPL17	(IRC0.unIRQPL17.u32Register)  /*@rg@*/
#define IRC0_IRQPL17_IRQPL68	(IRC0.unIRQPL17.stcField.u5IRQPL68)  /*@bf@*/
#define IRC0_IRQPL17_IRQPL69	(IRC0.unIRQPL17.stcField.u5IRQPL69)  /*@bf@*/
#define IRC0_IRQPL17_IRQPL70	(IRC0.unIRQPL17.stcField.u5IRQPL70)  /*@bf@*/
#define IRC0_IRQPL17_IRQPL71	(IRC0.unIRQPL17.stcField.u5IRQPL71)  /*@bf@*/

typedef struct stc_irc0_irqpl17_field{
    uint_io32_t		u5IRQPL68:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL69:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL70:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL71:5;
    uint_io32_t		:3;
}stc_irc0_irqpl17_field_t;

typedef union un_irc0_irqpl17{
    uint_io32_t		u32Register;
    stc_irc0_irqpl17_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl17_t;

/* IRQPL18 */
#define IRC0_IRQPL18	(IRC0.unIRQPL18.u32Register)  /*@rg@*/
#define IRC0_IRQPL18_IRQPL72	(IRC0.unIRQPL18.stcField.u5IRQPL72)  /*@bf@*/
#define IRC0_IRQPL18_IRQPL73	(IRC0.unIRQPL18.stcField.u5IRQPL73)  /*@bf@*/
#define IRC0_IRQPL18_IRQPL74	(IRC0.unIRQPL18.stcField.u5IRQPL74)  /*@bf@*/
#define IRC0_IRQPL18_IRQPL75	(IRC0.unIRQPL18.stcField.u5IRQPL75)  /*@bf@*/

typedef struct stc_irc0_irqpl18_field{
    uint_io32_t		u5IRQPL72:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL73:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL74:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL75:5;
    uint_io32_t		:3;
}stc_irc0_irqpl18_field_t;

typedef union un_irc0_irqpl18{
    uint_io32_t		u32Register;
    stc_irc0_irqpl18_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl18_t;

/* IRQPL19 */
#define IRC0_IRQPL19	(IRC0.unIRQPL19.u32Register)  /*@rg@*/
#define IRC0_IRQPL19_IRQPL76	(IRC0.unIRQPL19.stcField.u5IRQPL76)  /*@bf@*/
#define IRC0_IRQPL19_IRQPL77	(IRC0.unIRQPL19.stcField.u5IRQPL77)  /*@bf@*/
#define IRC0_IRQPL19_IRQPL78	(IRC0.unIRQPL19.stcField.u5IRQPL78)  /*@bf@*/
#define IRC0_IRQPL19_IRQPL79	(IRC0.unIRQPL19.stcField.u5IRQPL79)  /*@bf@*/

typedef struct stc_irc0_irqpl19_field{
    uint_io32_t		u5IRQPL76:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL77:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL78:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL79:5;
    uint_io32_t		:3;
}stc_irc0_irqpl19_field_t;

typedef union un_irc0_irqpl19{
    uint_io32_t		u32Register;
    stc_irc0_irqpl19_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl19_t;

/* IRQPL20 */
#define IRC0_IRQPL20	(IRC0.unIRQPL20.u32Register)  /*@rg@*/
#define IRC0_IRQPL20_IRQPL80	(IRC0.unIRQPL20.stcField.u5IRQPL80)  /*@bf@*/
#define IRC0_IRQPL20_IRQPL81	(IRC0.unIRQPL20.stcField.u5IRQPL81)  /*@bf@*/
#define IRC0_IRQPL20_IRQPL82	(IRC0.unIRQPL20.stcField.u5IRQPL82)  /*@bf@*/
#define IRC0_IRQPL20_IRQPL83	(IRC0.unIRQPL20.stcField.u5IRQPL83)  /*@bf@*/

typedef struct stc_irc0_irqpl20_field{
    uint_io32_t		u5IRQPL80:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL81:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL82:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL83:5;
    uint_io32_t		:3;
}stc_irc0_irqpl20_field_t;

typedef union un_irc0_irqpl20{
    uint_io32_t		u32Register;
    stc_irc0_irqpl20_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl20_t;

/* IRQPL21 */
#define IRC0_IRQPL21	(IRC0.unIRQPL21.u32Register)  /*@rg@*/
#define IRC0_IRQPL21_IRQPL84	(IRC0.unIRQPL21.stcField.u5IRQPL84)  /*@bf@*/
#define IRC0_IRQPL21_IRQPL85	(IRC0.unIRQPL21.stcField.u5IRQPL85)  /*@bf@*/
#define IRC0_IRQPL21_IRQPL86	(IRC0.unIRQPL21.stcField.u5IRQPL86)  /*@bf@*/
#define IRC0_IRQPL21_IRQPL87	(IRC0.unIRQPL21.stcField.u5IRQPL87)  /*@bf@*/

typedef struct stc_irc0_irqpl21_field{
    uint_io32_t		u5IRQPL84:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL85:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL86:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL87:5;
    uint_io32_t		:3;
}stc_irc0_irqpl21_field_t;

typedef union un_irc0_irqpl21{
    uint_io32_t		u32Register;
    stc_irc0_irqpl21_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl21_t;

/* IRQPL22 */
#define IRC0_IRQPL22	(IRC0.unIRQPL22.u32Register)  /*@rg@*/
#define IRC0_IRQPL22_IRQPL88	(IRC0.unIRQPL22.stcField.u5IRQPL88)  /*@bf@*/
#define IRC0_IRQPL22_IRQPL89	(IRC0.unIRQPL22.stcField.u5IRQPL89)  /*@bf@*/
#define IRC0_IRQPL22_IRQPL90	(IRC0.unIRQPL22.stcField.u5IRQPL90)  /*@bf@*/
#define IRC0_IRQPL22_IRQPL91	(IRC0.unIRQPL22.stcField.u5IRQPL91)  /*@bf@*/

typedef struct stc_irc0_irqpl22_field{
    uint_io32_t		u5IRQPL88:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL89:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL90:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL91:5;
    uint_io32_t		:3;
}stc_irc0_irqpl22_field_t;

typedef union un_irc0_irqpl22{
    uint_io32_t		u32Register;
    stc_irc0_irqpl22_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl22_t;

/* IRQPL23 */
#define IRC0_IRQPL23	(IRC0.unIRQPL23.u32Register)  /*@rg@*/
#define IRC0_IRQPL23_IRQPL92	(IRC0.unIRQPL23.stcField.u5IRQPL92)  /*@bf@*/
#define IRC0_IRQPL23_IRQPL93	(IRC0.unIRQPL23.stcField.u5IRQPL93)  /*@bf@*/
#define IRC0_IRQPL23_IRQPL94	(IRC0.unIRQPL23.stcField.u5IRQPL94)  /*@bf@*/
#define IRC0_IRQPL23_IRQPL95	(IRC0.unIRQPL23.stcField.u5IRQPL95)  /*@bf@*/

typedef struct stc_irc0_irqpl23_field{
    uint_io32_t		u5IRQPL92:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL93:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL94:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL95:5;
    uint_io32_t		:3;
}stc_irc0_irqpl23_field_t;

typedef union un_irc0_irqpl23{
    uint_io32_t		u32Register;
    stc_irc0_irqpl23_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl23_t;

/* IRQPL24 */
#define IRC0_IRQPL24	(IRC0.unIRQPL24.u32Register)  /*@rg@*/
#define IRC0_IRQPL24_IRQPL96	(IRC0.unIRQPL24.stcField.u5IRQPL96)  /*@bf@*/
#define IRC0_IRQPL24_IRQPL97	(IRC0.unIRQPL24.stcField.u5IRQPL97)  /*@bf@*/
#define IRC0_IRQPL24_IRQPL98	(IRC0.unIRQPL24.stcField.u5IRQPL98)  /*@bf@*/
#define IRC0_IRQPL24_IRQPL99	(IRC0.unIRQPL24.stcField.u5IRQPL99)  /*@bf@*/

typedef struct stc_irc0_irqpl24_field{
    uint_io32_t		u5IRQPL96:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL97:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL98:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL99:5;
    uint_io32_t		:3;
}stc_irc0_irqpl24_field_t;

typedef union un_irc0_irqpl24{
    uint_io32_t		u32Register;
    stc_irc0_irqpl24_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl24_t;

/* IRQPL25 */
#define IRC0_IRQPL25	(IRC0.unIRQPL25.u32Register)  /*@rg@*/
#define IRC0_IRQPL25_IRQPL100	(IRC0.unIRQPL25.stcField.u5IRQPL100)  /*@bf@*/
#define IRC0_IRQPL25_IRQPL101	(IRC0.unIRQPL25.stcField.u5IRQPL101)  /*@bf@*/
#define IRC0_IRQPL25_IRQPL102	(IRC0.unIRQPL25.stcField.u5IRQPL102)  /*@bf@*/
#define IRC0_IRQPL25_IRQPL103	(IRC0.unIRQPL25.stcField.u5IRQPL103)  /*@bf@*/

typedef struct stc_irc0_irqpl25_field{
    uint_io32_t		u5IRQPL100:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL101:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL102:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL103:5;
    uint_io32_t		:3;
}stc_irc0_irqpl25_field_t;

typedef union un_irc0_irqpl25{
    uint_io32_t		u32Register;
    stc_irc0_irqpl25_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl25_t;

/* IRQPL26 */
#define IRC0_IRQPL26	(IRC0.unIRQPL26.u32Register)  /*@rg@*/
#define IRC0_IRQPL26_IRQPL104	(IRC0.unIRQPL26.stcField.u5IRQPL104)  /*@bf@*/
#define IRC0_IRQPL26_IRQPL105	(IRC0.unIRQPL26.stcField.u5IRQPL105)  /*@bf@*/
#define IRC0_IRQPL26_IRQPL106	(IRC0.unIRQPL26.stcField.u5IRQPL106)  /*@bf@*/
#define IRC0_IRQPL26_IRQPL107	(IRC0.unIRQPL26.stcField.u5IRQPL107)  /*@bf@*/

typedef struct stc_irc0_irqpl26_field{
    uint_io32_t		u5IRQPL104:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL105:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL106:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL107:5;
    uint_io32_t		:3;
}stc_irc0_irqpl26_field_t;

typedef union un_irc0_irqpl26{
    uint_io32_t		u32Register;
    stc_irc0_irqpl26_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl26_t;

/* IRQPL27 */
#define IRC0_IRQPL27	(IRC0.unIRQPL27.u32Register)  /*@rg@*/
#define IRC0_IRQPL27_IRQPL108	(IRC0.unIRQPL27.stcField.u5IRQPL108)  /*@bf@*/
#define IRC0_IRQPL27_IRQPL109	(IRC0.unIRQPL27.stcField.u5IRQPL109)  /*@bf@*/
#define IRC0_IRQPL27_IRQPL110	(IRC0.unIRQPL27.stcField.u5IRQPL110)  /*@bf@*/
#define IRC0_IRQPL27_IRQPL111	(IRC0.unIRQPL27.stcField.u5IRQPL111)  /*@bf@*/

typedef struct stc_irc0_irqpl27_field{
    uint_io32_t		u5IRQPL108:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL109:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL110:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL111:5;
    uint_io32_t		:3;
}stc_irc0_irqpl27_field_t;

typedef union un_irc0_irqpl27{
    uint_io32_t		u32Register;
    stc_irc0_irqpl27_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl27_t;

/* IRQPL28 */
#define IRC0_IRQPL28	(IRC0.unIRQPL28.u32Register)  /*@rg@*/
#define IRC0_IRQPL28_IRQPL112	(IRC0.unIRQPL28.stcField.u5IRQPL112)  /*@bf@*/
#define IRC0_IRQPL28_IRQPL113	(IRC0.unIRQPL28.stcField.u5IRQPL113)  /*@bf@*/
#define IRC0_IRQPL28_IRQPL114	(IRC0.unIRQPL28.stcField.u5IRQPL114)  /*@bf@*/
#define IRC0_IRQPL28_IRQPL115	(IRC0.unIRQPL28.stcField.u5IRQPL115)  /*@bf@*/

typedef struct stc_irc0_irqpl28_field{
    uint_io32_t		u5IRQPL112:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL113:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL114:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL115:5;
    uint_io32_t		:3;
}stc_irc0_irqpl28_field_t;

typedef union un_irc0_irqpl28{
    uint_io32_t		u32Register;
    stc_irc0_irqpl28_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl28_t;

/* IRQPL29 */
#define IRC0_IRQPL29	(IRC0.unIRQPL29.u32Register)  /*@rg@*/
#define IRC0_IRQPL29_IRQPL116	(IRC0.unIRQPL29.stcField.u5IRQPL116)  /*@bf@*/
#define IRC0_IRQPL29_IRQPL117	(IRC0.unIRQPL29.stcField.u5IRQPL117)  /*@bf@*/
#define IRC0_IRQPL29_IRQPL118	(IRC0.unIRQPL29.stcField.u5IRQPL118)  /*@bf@*/
#define IRC0_IRQPL29_IRQPL119	(IRC0.unIRQPL29.stcField.u5IRQPL119)  /*@bf@*/

typedef struct stc_irc0_irqpl29_field{
    uint_io32_t		u5IRQPL116:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL117:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL118:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL119:5;
    uint_io32_t		:3;
}stc_irc0_irqpl29_field_t;

typedef union un_irc0_irqpl29{
    uint_io32_t		u32Register;
    stc_irc0_irqpl29_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl29_t;

/* IRQPL30 */
#define IRC0_IRQPL30	(IRC0.unIRQPL30.u32Register)  /*@rg@*/
#define IRC0_IRQPL30_IRQPL120	(IRC0.unIRQPL30.stcField.u5IRQPL120)  /*@bf@*/
#define IRC0_IRQPL30_IRQPL121	(IRC0.unIRQPL30.stcField.u5IRQPL121)  /*@bf@*/
#define IRC0_IRQPL30_IRQPL122	(IRC0.unIRQPL30.stcField.u5IRQPL122)  /*@bf@*/
#define IRC0_IRQPL30_IRQPL123	(IRC0.unIRQPL30.stcField.u5IRQPL123)  /*@bf@*/

typedef struct stc_irc0_irqpl30_field{
    uint_io32_t		u5IRQPL120:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL121:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL122:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL123:5;
    uint_io32_t		:3;
}stc_irc0_irqpl30_field_t;

typedef union un_irc0_irqpl30{
    uint_io32_t		u32Register;
    stc_irc0_irqpl30_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl30_t;

/* IRQPL31 */
#define IRC0_IRQPL31	(IRC0.unIRQPL31.u32Register)  /*@rg@*/
#define IRC0_IRQPL31_IRQPL124	(IRC0.unIRQPL31.stcField.u5IRQPL124)  /*@bf@*/
#define IRC0_IRQPL31_IRQPL125	(IRC0.unIRQPL31.stcField.u5IRQPL125)  /*@bf@*/
#define IRC0_IRQPL31_IRQPL126	(IRC0.unIRQPL31.stcField.u5IRQPL126)  /*@bf@*/
#define IRC0_IRQPL31_IRQPL127	(IRC0.unIRQPL31.stcField.u5IRQPL127)  /*@bf@*/

typedef struct stc_irc0_irqpl31_field{
    uint_io32_t		u5IRQPL124:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL125:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL126:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL127:5;
    uint_io32_t		:3;
}stc_irc0_irqpl31_field_t;

typedef union un_irc0_irqpl31{
    uint_io32_t		u32Register;
    stc_irc0_irqpl31_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl31_t;

/* IRQPL32 */
#define IRC0_IRQPL32	(IRC0.unIRQPL32.u32Register)  /*@rg@*/
#define IRC0_IRQPL32_IRQPL128	(IRC0.unIRQPL32.stcField.u5IRQPL128)  /*@bf@*/
#define IRC0_IRQPL32_IRQPL129	(IRC0.unIRQPL32.stcField.u5IRQPL129)  /*@bf@*/
#define IRC0_IRQPL32_IRQPL130	(IRC0.unIRQPL32.stcField.u5IRQPL130)  /*@bf@*/
#define IRC0_IRQPL32_IRQPL131	(IRC0.unIRQPL32.stcField.u5IRQPL131)  /*@bf@*/

typedef struct stc_irc0_irqpl32_field{
    uint_io32_t		u5IRQPL128:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL129:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL130:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL131:5;
    uint_io32_t		:3;
}stc_irc0_irqpl32_field_t;

typedef union un_irc0_irqpl32{
    uint_io32_t		u32Register;
    stc_irc0_irqpl32_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl32_t;

/* IRQPL33 */
#define IRC0_IRQPL33	(IRC0.unIRQPL33.u32Register)  /*@rg@*/
#define IRC0_IRQPL33_IRQPL132	(IRC0.unIRQPL33.stcField.u5IRQPL132)  /*@bf@*/
#define IRC0_IRQPL33_IRQPL133	(IRC0.unIRQPL33.stcField.u5IRQPL133)  /*@bf@*/
#define IRC0_IRQPL33_IRQPL134	(IRC0.unIRQPL33.stcField.u5IRQPL134)  /*@bf@*/
#define IRC0_IRQPL33_IRQPL135	(IRC0.unIRQPL33.stcField.u5IRQPL135)  /*@bf@*/

typedef struct stc_irc0_irqpl33_field{
    uint_io32_t		u5IRQPL132:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL133:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL134:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL135:5;
    uint_io32_t		:3;
}stc_irc0_irqpl33_field_t;

typedef union un_irc0_irqpl33{
    uint_io32_t		u32Register;
    stc_irc0_irqpl33_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl33_t;

/* IRQPL34 */
#define IRC0_IRQPL34	(IRC0.unIRQPL34.u32Register)  /*@rg@*/
#define IRC0_IRQPL34_IRQPL136	(IRC0.unIRQPL34.stcField.u5IRQPL136)  /*@bf@*/
#define IRC0_IRQPL34_IRQPL137	(IRC0.unIRQPL34.stcField.u5IRQPL137)  /*@bf@*/
#define IRC0_IRQPL34_IRQPL138	(IRC0.unIRQPL34.stcField.u5IRQPL138)  /*@bf@*/
#define IRC0_IRQPL34_IRQPL139	(IRC0.unIRQPL34.stcField.u5IRQPL139)  /*@bf@*/

typedef struct stc_irc0_irqpl34_field{
    uint_io32_t		u5IRQPL136:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL137:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL138:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL139:5;
    uint_io32_t		:3;
}stc_irc0_irqpl34_field_t;

typedef union un_irc0_irqpl34{
    uint_io32_t		u32Register;
    stc_irc0_irqpl34_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl34_t;

/* IRQPL35 */
#define IRC0_IRQPL35	(IRC0.unIRQPL35.u32Register)  /*@rg@*/
#define IRC0_IRQPL35_IRQPL140	(IRC0.unIRQPL35.stcField.u5IRQPL140)  /*@bf@*/
#define IRC0_IRQPL35_IRQPL141	(IRC0.unIRQPL35.stcField.u5IRQPL141)  /*@bf@*/
#define IRC0_IRQPL35_IRQPL142	(IRC0.unIRQPL35.stcField.u5IRQPL142)  /*@bf@*/
#define IRC0_IRQPL35_IRQPL143	(IRC0.unIRQPL35.stcField.u5IRQPL143)  /*@bf@*/

typedef struct stc_irc0_irqpl35_field{
    uint_io32_t		u5IRQPL140:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL141:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL142:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL143:5;
    uint_io32_t		:3;
}stc_irc0_irqpl35_field_t;

typedef union un_irc0_irqpl35{
    uint_io32_t		u32Register;
    stc_irc0_irqpl35_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl35_t;

/* IRQPL36 */
#define IRC0_IRQPL36	(IRC0.unIRQPL36.u32Register)  /*@rg@*/
#define IRC0_IRQPL36_IRQPL144	(IRC0.unIRQPL36.stcField.u5IRQPL144)  /*@bf@*/
#define IRC0_IRQPL36_IRQPL145	(IRC0.unIRQPL36.stcField.u5IRQPL145)  /*@bf@*/
#define IRC0_IRQPL36_IRQPL146	(IRC0.unIRQPL36.stcField.u5IRQPL146)  /*@bf@*/
#define IRC0_IRQPL36_IRQPL147	(IRC0.unIRQPL36.stcField.u5IRQPL147)  /*@bf@*/

typedef struct stc_irc0_irqpl36_field{
    uint_io32_t		u5IRQPL144:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL145:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL146:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL147:5;
    uint_io32_t		:3;
}stc_irc0_irqpl36_field_t;

typedef union un_irc0_irqpl36{
    uint_io32_t		u32Register;
    stc_irc0_irqpl36_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl36_t;

/* IRQPL37 */
#define IRC0_IRQPL37	(IRC0.unIRQPL37.u32Register)  /*@rg@*/
#define IRC0_IRQPL37_IRQPL148	(IRC0.unIRQPL37.stcField.u5IRQPL148)  /*@bf@*/
#define IRC0_IRQPL37_IRQPL149	(IRC0.unIRQPL37.stcField.u5IRQPL149)  /*@bf@*/
#define IRC0_IRQPL37_IRQPL150	(IRC0.unIRQPL37.stcField.u5IRQPL150)  /*@bf@*/
#define IRC0_IRQPL37_IRQPL151	(IRC0.unIRQPL37.stcField.u5IRQPL151)  /*@bf@*/

typedef struct stc_irc0_irqpl37_field{
    uint_io32_t		u5IRQPL148:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL149:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL150:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL151:5;
    uint_io32_t		:3;
}stc_irc0_irqpl37_field_t;

typedef union un_irc0_irqpl37{
    uint_io32_t		u32Register;
    stc_irc0_irqpl37_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl37_t;

/* IRQPL38 */
#define IRC0_IRQPL38	(IRC0.unIRQPL38.u32Register)  /*@rg@*/
#define IRC0_IRQPL38_IRQPL152	(IRC0.unIRQPL38.stcField.u5IRQPL152)  /*@bf@*/
#define IRC0_IRQPL38_IRQPL153	(IRC0.unIRQPL38.stcField.u5IRQPL153)  /*@bf@*/
#define IRC0_IRQPL38_IRQPL154	(IRC0.unIRQPL38.stcField.u5IRQPL154)  /*@bf@*/
#define IRC0_IRQPL38_IRQPL155	(IRC0.unIRQPL38.stcField.u5IRQPL155)  /*@bf@*/

typedef struct stc_irc0_irqpl38_field{
    uint_io32_t		u5IRQPL152:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL153:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL154:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL155:5;
    uint_io32_t		:3;
}stc_irc0_irqpl38_field_t;

typedef union un_irc0_irqpl38{
    uint_io32_t		u32Register;
    stc_irc0_irqpl38_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl38_t;

/* IRQPL39 */
#define IRC0_IRQPL39	(IRC0.unIRQPL39.u32Register)  /*@rg@*/
#define IRC0_IRQPL39_IRQPL156	(IRC0.unIRQPL39.stcField.u5IRQPL156)  /*@bf@*/
#define IRC0_IRQPL39_IRQPL157	(IRC0.unIRQPL39.stcField.u5IRQPL157)  /*@bf@*/
#define IRC0_IRQPL39_IRQPL158	(IRC0.unIRQPL39.stcField.u5IRQPL158)  /*@bf@*/
#define IRC0_IRQPL39_IRQPL159	(IRC0.unIRQPL39.stcField.u5IRQPL159)  /*@bf@*/

typedef struct stc_irc0_irqpl39_field{
    uint_io32_t		u5IRQPL156:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL157:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL158:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL159:5;
    uint_io32_t		:3;
}stc_irc0_irqpl39_field_t;

typedef union un_irc0_irqpl39{
    uint_io32_t		u32Register;
    stc_irc0_irqpl39_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl39_t;

/* IRQPL40 */
#define IRC0_IRQPL40	(IRC0.unIRQPL40.u32Register)  /*@rg@*/
#define IRC0_IRQPL40_IRQPL160	(IRC0.unIRQPL40.stcField.u5IRQPL160)  /*@bf@*/
#define IRC0_IRQPL40_IRQPL161	(IRC0.unIRQPL40.stcField.u5IRQPL161)  /*@bf@*/
#define IRC0_IRQPL40_IRQPL162	(IRC0.unIRQPL40.stcField.u5IRQPL162)  /*@bf@*/
#define IRC0_IRQPL40_IRQPL163	(IRC0.unIRQPL40.stcField.u5IRQPL163)  /*@bf@*/

typedef struct stc_irc0_irqpl40_field{
    uint_io32_t		u5IRQPL160:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL161:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL162:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL163:5;
    uint_io32_t		:3;
}stc_irc0_irqpl40_field_t;

typedef union un_irc0_irqpl40{
    uint_io32_t		u32Register;
    stc_irc0_irqpl40_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl40_t;

/* IRQPL41 */
#define IRC0_IRQPL41	(IRC0.unIRQPL41.u32Register)  /*@rg@*/
#define IRC0_IRQPL41_IRQPL164	(IRC0.unIRQPL41.stcField.u5IRQPL164)  /*@bf@*/
#define IRC0_IRQPL41_IRQPL165	(IRC0.unIRQPL41.stcField.u5IRQPL165)  /*@bf@*/
#define IRC0_IRQPL41_IRQPL166	(IRC0.unIRQPL41.stcField.u5IRQPL166)  /*@bf@*/
#define IRC0_IRQPL41_IRQPL167	(IRC0.unIRQPL41.stcField.u5IRQPL167)  /*@bf@*/

typedef struct stc_irc0_irqpl41_field{
    uint_io32_t		u5IRQPL164:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL165:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL166:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL167:5;
    uint_io32_t		:3;
}stc_irc0_irqpl41_field_t;

typedef union un_irc0_irqpl41{
    uint_io32_t		u32Register;
    stc_irc0_irqpl41_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl41_t;

/* IRQPL42 */
#define IRC0_IRQPL42	(IRC0.unIRQPL42.u32Register)  /*@rg@*/
#define IRC0_IRQPL42_IRQPL168	(IRC0.unIRQPL42.stcField.u5IRQPL168)  /*@bf@*/
#define IRC0_IRQPL42_IRQPL169	(IRC0.unIRQPL42.stcField.u5IRQPL169)  /*@bf@*/
#define IRC0_IRQPL42_IRQPL170	(IRC0.unIRQPL42.stcField.u5IRQPL170)  /*@bf@*/
#define IRC0_IRQPL42_IRQPL171	(IRC0.unIRQPL42.stcField.u5IRQPL171)  /*@bf@*/

typedef struct stc_irc0_irqpl42_field{
    uint_io32_t		u5IRQPL168:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL169:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL170:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL171:5;
    uint_io32_t		:3;
}stc_irc0_irqpl42_field_t;

typedef union un_irc0_irqpl42{
    uint_io32_t		u32Register;
    stc_irc0_irqpl42_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl42_t;

/* IRQPL43 */
#define IRC0_IRQPL43	(IRC0.unIRQPL43.u32Register)  /*@rg@*/
#define IRC0_IRQPL43_IRQPL172	(IRC0.unIRQPL43.stcField.u5IRQPL172)  /*@bf@*/
#define IRC0_IRQPL43_IRQPL173	(IRC0.unIRQPL43.stcField.u5IRQPL173)  /*@bf@*/
#define IRC0_IRQPL43_IRQPL174	(IRC0.unIRQPL43.stcField.u5IRQPL174)  /*@bf@*/
#define IRC0_IRQPL43_IRQPL175	(IRC0.unIRQPL43.stcField.u5IRQPL175)  /*@bf@*/

typedef struct stc_irc0_irqpl43_field{
    uint_io32_t		u5IRQPL172:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL173:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL174:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL175:5;
    uint_io32_t		:3;
}stc_irc0_irqpl43_field_t;

typedef union un_irc0_irqpl43{
    uint_io32_t		u32Register;
    stc_irc0_irqpl43_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl43_t;

/* IRQPL44 */
#define IRC0_IRQPL44	(IRC0.unIRQPL44.u32Register)  /*@rg@*/
#define IRC0_IRQPL44_IRQPL176	(IRC0.unIRQPL44.stcField.u5IRQPL176)  /*@bf@*/
#define IRC0_IRQPL44_IRQPL177	(IRC0.unIRQPL44.stcField.u5IRQPL177)  /*@bf@*/
#define IRC0_IRQPL44_IRQPL178	(IRC0.unIRQPL44.stcField.u5IRQPL178)  /*@bf@*/
#define IRC0_IRQPL44_IRQPL179	(IRC0.unIRQPL44.stcField.u5IRQPL179)  /*@bf@*/

typedef struct stc_irc0_irqpl44_field{
    uint_io32_t		u5IRQPL176:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL177:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL178:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL179:5;
    uint_io32_t		:3;
}stc_irc0_irqpl44_field_t;

typedef union un_irc0_irqpl44{
    uint_io32_t		u32Register;
    stc_irc0_irqpl44_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl44_t;

/* IRQPL45 */
#define IRC0_IRQPL45	(IRC0.unIRQPL45.u32Register)  /*@rg@*/
#define IRC0_IRQPL45_IRQPL180	(IRC0.unIRQPL45.stcField.u5IRQPL180)  /*@bf@*/
#define IRC0_IRQPL45_IRQPL181	(IRC0.unIRQPL45.stcField.u5IRQPL181)  /*@bf@*/
#define IRC0_IRQPL45_IRQPL182	(IRC0.unIRQPL45.stcField.u5IRQPL182)  /*@bf@*/
#define IRC0_IRQPL45_IRQPL183	(IRC0.unIRQPL45.stcField.u5IRQPL183)  /*@bf@*/

typedef struct stc_irc0_irqpl45_field{
    uint_io32_t		u5IRQPL180:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL181:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL182:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL183:5;
    uint_io32_t		:3;
}stc_irc0_irqpl45_field_t;

typedef union un_irc0_irqpl45{
    uint_io32_t		u32Register;
    stc_irc0_irqpl45_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl45_t;

/* IRQPL46 */
#define IRC0_IRQPL46	(IRC0.unIRQPL46.u32Register)  /*@rg@*/
#define IRC0_IRQPL46_IRQPL184	(IRC0.unIRQPL46.stcField.u5IRQPL184)  /*@bf@*/
#define IRC0_IRQPL46_IRQPL185	(IRC0.unIRQPL46.stcField.u5IRQPL185)  /*@bf@*/
#define IRC0_IRQPL46_IRQPL186	(IRC0.unIRQPL46.stcField.u5IRQPL186)  /*@bf@*/
#define IRC0_IRQPL46_IRQPL187	(IRC0.unIRQPL46.stcField.u5IRQPL187)  /*@bf@*/

typedef struct stc_irc0_irqpl46_field{
    uint_io32_t		u5IRQPL184:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL185:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL186:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL187:5;
    uint_io32_t		:3;
}stc_irc0_irqpl46_field_t;

typedef union un_irc0_irqpl46{
    uint_io32_t		u32Register;
    stc_irc0_irqpl46_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl46_t;

/* IRQPL47 */
#define IRC0_IRQPL47	(IRC0.unIRQPL47.u32Register)  /*@rg@*/
#define IRC0_IRQPL47_IRQPL188	(IRC0.unIRQPL47.stcField.u5IRQPL188)  /*@bf@*/
#define IRC0_IRQPL47_IRQPL189	(IRC0.unIRQPL47.stcField.u5IRQPL189)  /*@bf@*/
#define IRC0_IRQPL47_IRQPL190	(IRC0.unIRQPL47.stcField.u5IRQPL190)  /*@bf@*/
#define IRC0_IRQPL47_IRQPL191	(IRC0.unIRQPL47.stcField.u5IRQPL191)  /*@bf@*/

typedef struct stc_irc0_irqpl47_field{
    uint_io32_t		u5IRQPL188:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL189:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL190:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL191:5;
    uint_io32_t		:3;
}stc_irc0_irqpl47_field_t;

typedef union un_irc0_irqpl47{
    uint_io32_t		u32Register;
    stc_irc0_irqpl47_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl47_t;

/* IRQPL48 */
#define IRC0_IRQPL48	(IRC0.unIRQPL48.u32Register)  /*@rg@*/
#define IRC0_IRQPL48_IRQPL192	(IRC0.unIRQPL48.stcField.u5IRQPL192)  /*@bf@*/
#define IRC0_IRQPL48_IRQPL193	(IRC0.unIRQPL48.stcField.u5IRQPL193)  /*@bf@*/
#define IRC0_IRQPL48_IRQPL194	(IRC0.unIRQPL48.stcField.u5IRQPL194)  /*@bf@*/
#define IRC0_IRQPL48_IRQPL195	(IRC0.unIRQPL48.stcField.u5IRQPL195)  /*@bf@*/

typedef struct stc_irc0_irqpl48_field{
    uint_io32_t		u5IRQPL192:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL193:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL194:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL195:5;
    uint_io32_t		:3;
}stc_irc0_irqpl48_field_t;

typedef union un_irc0_irqpl48{
    uint_io32_t		u32Register;
    stc_irc0_irqpl48_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl48_t;

/* IRQPL49 */
#define IRC0_IRQPL49	(IRC0.unIRQPL49.u32Register)  /*@rg@*/
#define IRC0_IRQPL49_IRQPL196	(IRC0.unIRQPL49.stcField.u5IRQPL196)  /*@bf@*/
#define IRC0_IRQPL49_IRQPL197	(IRC0.unIRQPL49.stcField.u5IRQPL197)  /*@bf@*/
#define IRC0_IRQPL49_IRQPL198	(IRC0.unIRQPL49.stcField.u5IRQPL198)  /*@bf@*/
#define IRC0_IRQPL49_IRQPL199	(IRC0.unIRQPL49.stcField.u5IRQPL199)  /*@bf@*/

typedef struct stc_irc0_irqpl49_field{
    uint_io32_t		u5IRQPL196:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL197:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL198:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL199:5;
    uint_io32_t		:3;
}stc_irc0_irqpl49_field_t;

typedef union un_irc0_irqpl49{
    uint_io32_t		u32Register;
    stc_irc0_irqpl49_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl49_t;

/* IRQPL50 */
#define IRC0_IRQPL50	(IRC0.unIRQPL50.u32Register)  /*@rg@*/
#define IRC0_IRQPL50_IRQPL200	(IRC0.unIRQPL50.stcField.u5IRQPL200)  /*@bf@*/
#define IRC0_IRQPL50_IRQPL201	(IRC0.unIRQPL50.stcField.u5IRQPL201)  /*@bf@*/
#define IRC0_IRQPL50_IRQPL202	(IRC0.unIRQPL50.stcField.u5IRQPL202)  /*@bf@*/
#define IRC0_IRQPL50_IRQPL203	(IRC0.unIRQPL50.stcField.u5IRQPL203)  /*@bf@*/

typedef struct stc_irc0_irqpl50_field{
    uint_io32_t		u5IRQPL200:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL201:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL202:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL203:5;
    uint_io32_t		:3;
}stc_irc0_irqpl50_field_t;

typedef union un_irc0_irqpl50{
    uint_io32_t		u32Register;
    stc_irc0_irqpl50_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl50_t;

/* IRQPL51 */
#define IRC0_IRQPL51	(IRC0.unIRQPL51.u32Register)  /*@rg@*/
#define IRC0_IRQPL51_IRQPL204	(IRC0.unIRQPL51.stcField.u5IRQPL204)  /*@bf@*/
#define IRC0_IRQPL51_IRQPL205	(IRC0.unIRQPL51.stcField.u5IRQPL205)  /*@bf@*/
#define IRC0_IRQPL51_IRQPL206	(IRC0.unIRQPL51.stcField.u5IRQPL206)  /*@bf@*/
#define IRC0_IRQPL51_IRQPL207	(IRC0.unIRQPL51.stcField.u5IRQPL207)  /*@bf@*/

typedef struct stc_irc0_irqpl51_field{
    uint_io32_t		u5IRQPL204:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL205:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL206:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL207:5;
    uint_io32_t		:3;
}stc_irc0_irqpl51_field_t;

typedef union un_irc0_irqpl51{
    uint_io32_t		u32Register;
    stc_irc0_irqpl51_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl51_t;

/* IRQPL52 */
#define IRC0_IRQPL52	(IRC0.unIRQPL52.u32Register)  /*@rg@*/
#define IRC0_IRQPL52_IRQPL208	(IRC0.unIRQPL52.stcField.u5IRQPL208)  /*@bf@*/
#define IRC0_IRQPL52_IRQPL209	(IRC0.unIRQPL52.stcField.u5IRQPL209)  /*@bf@*/
#define IRC0_IRQPL52_IRQPL210	(IRC0.unIRQPL52.stcField.u5IRQPL210)  /*@bf@*/
#define IRC0_IRQPL52_IRQPL211	(IRC0.unIRQPL52.stcField.u5IRQPL211)  /*@bf@*/

typedef struct stc_irc0_irqpl52_field{
    uint_io32_t		u5IRQPL208:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL209:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL210:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL211:5;
    uint_io32_t		:3;
}stc_irc0_irqpl52_field_t;

typedef union un_irc0_irqpl52{
    uint_io32_t		u32Register;
    stc_irc0_irqpl52_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl52_t;

/* IRQPL53 */
#define IRC0_IRQPL53	(IRC0.unIRQPL53.u32Register)  /*@rg@*/
#define IRC0_IRQPL53_IRQPL212	(IRC0.unIRQPL53.stcField.u5IRQPL212)  /*@bf@*/
#define IRC0_IRQPL53_IRQPL213	(IRC0.unIRQPL53.stcField.u5IRQPL213)  /*@bf@*/
#define IRC0_IRQPL53_IRQPL214	(IRC0.unIRQPL53.stcField.u5IRQPL214)  /*@bf@*/
#define IRC0_IRQPL53_IRQPL215	(IRC0.unIRQPL53.stcField.u5IRQPL215)  /*@bf@*/

typedef struct stc_irc0_irqpl53_field{
    uint_io32_t		u5IRQPL212:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL213:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL214:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL215:5;
    uint_io32_t		:3;
}stc_irc0_irqpl53_field_t;

typedef union un_irc0_irqpl53{
    uint_io32_t		u32Register;
    stc_irc0_irqpl53_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl53_t;

/* IRQPL54 */
#define IRC0_IRQPL54	(IRC0.unIRQPL54.u32Register)  /*@rg@*/
#define IRC0_IRQPL54_IRQPL216	(IRC0.unIRQPL54.stcField.u5IRQPL216)  /*@bf@*/
#define IRC0_IRQPL54_IRQPL217	(IRC0.unIRQPL54.stcField.u5IRQPL217)  /*@bf@*/
#define IRC0_IRQPL54_IRQPL218	(IRC0.unIRQPL54.stcField.u5IRQPL218)  /*@bf@*/
#define IRC0_IRQPL54_IRQPL219	(IRC0.unIRQPL54.stcField.u5IRQPL219)  /*@bf@*/

typedef struct stc_irc0_irqpl54_field{
    uint_io32_t		u5IRQPL216:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL217:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL218:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL219:5;
    uint_io32_t		:3;
}stc_irc0_irqpl54_field_t;

typedef union un_irc0_irqpl54{
    uint_io32_t		u32Register;
    stc_irc0_irqpl54_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl54_t;

/* IRQPL55 */
#define IRC0_IRQPL55	(IRC0.unIRQPL55.u32Register)  /*@rg@*/
#define IRC0_IRQPL55_IRQPL220	(IRC0.unIRQPL55.stcField.u5IRQPL220)  /*@bf@*/
#define IRC0_IRQPL55_IRQPL221	(IRC0.unIRQPL55.stcField.u5IRQPL221)  /*@bf@*/
#define IRC0_IRQPL55_IRQPL222	(IRC0.unIRQPL55.stcField.u5IRQPL222)  /*@bf@*/
#define IRC0_IRQPL55_IRQPL223	(IRC0.unIRQPL55.stcField.u5IRQPL223)  /*@bf@*/

typedef struct stc_irc0_irqpl55_field{
    uint_io32_t		u5IRQPL220:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL221:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL222:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL223:5;
    uint_io32_t		:3;
}stc_irc0_irqpl55_field_t;

typedef union un_irc0_irqpl55{
    uint_io32_t		u32Register;
    stc_irc0_irqpl55_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl55_t;

/* IRQPL56 */
#define IRC0_IRQPL56	(IRC0.unIRQPL56.u32Register)  /*@rg@*/
#define IRC0_IRQPL56_IRQPL224	(IRC0.unIRQPL56.stcField.u5IRQPL224)  /*@bf@*/
#define IRC0_IRQPL56_IRQPL225	(IRC0.unIRQPL56.stcField.u5IRQPL225)  /*@bf@*/
#define IRC0_IRQPL56_IRQPL226	(IRC0.unIRQPL56.stcField.u5IRQPL226)  /*@bf@*/
#define IRC0_IRQPL56_IRQPL227	(IRC0.unIRQPL56.stcField.u5IRQPL227)  /*@bf@*/

typedef struct stc_irc0_irqpl56_field{
    uint_io32_t		u5IRQPL224:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL225:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL226:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL227:5;
    uint_io32_t		:3;
}stc_irc0_irqpl56_field_t;

typedef union un_irc0_irqpl56{
    uint_io32_t		u32Register;
    stc_irc0_irqpl56_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl56_t;

/* IRQPL57 */
#define IRC0_IRQPL57	(IRC0.unIRQPL57.u32Register)  /*@rg@*/
#define IRC0_IRQPL57_IRQPL228	(IRC0.unIRQPL57.stcField.u5IRQPL228)  /*@bf@*/
#define IRC0_IRQPL57_IRQPL229	(IRC0.unIRQPL57.stcField.u5IRQPL229)  /*@bf@*/
#define IRC0_IRQPL57_IRQPL230	(IRC0.unIRQPL57.stcField.u5IRQPL230)  /*@bf@*/
#define IRC0_IRQPL57_IRQPL231	(IRC0.unIRQPL57.stcField.u5IRQPL231)  /*@bf@*/

typedef struct stc_irc0_irqpl57_field{
    uint_io32_t		u5IRQPL228:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL229:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL230:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL231:5;
    uint_io32_t		:3;
}stc_irc0_irqpl57_field_t;

typedef union un_irc0_irqpl57{
    uint_io32_t		u32Register;
    stc_irc0_irqpl57_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl57_t;

/* IRQPL58 */
#define IRC0_IRQPL58	(IRC0.unIRQPL58.u32Register)  /*@rg@*/
#define IRC0_IRQPL58_IRQPL232	(IRC0.unIRQPL58.stcField.u5IRQPL232)  /*@bf@*/
#define IRC0_IRQPL58_IRQPL233	(IRC0.unIRQPL58.stcField.u5IRQPL233)  /*@bf@*/
#define IRC0_IRQPL58_IRQPL234	(IRC0.unIRQPL58.stcField.u5IRQPL234)  /*@bf@*/
#define IRC0_IRQPL58_IRQPL235	(IRC0.unIRQPL58.stcField.u5IRQPL235)  /*@bf@*/

typedef struct stc_irc0_irqpl58_field{
    uint_io32_t		u5IRQPL232:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL233:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL234:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL235:5;
    uint_io32_t		:3;
}stc_irc0_irqpl58_field_t;

typedef union un_irc0_irqpl58{
    uint_io32_t		u32Register;
    stc_irc0_irqpl58_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl58_t;

/* IRQPL59 */
#define IRC0_IRQPL59	(IRC0.unIRQPL59.u32Register)  /*@rg@*/
#define IRC0_IRQPL59_IRQPL236	(IRC0.unIRQPL59.stcField.u5IRQPL236)  /*@bf@*/
#define IRC0_IRQPL59_IRQPL237	(IRC0.unIRQPL59.stcField.u5IRQPL237)  /*@bf@*/
#define IRC0_IRQPL59_IRQPL238	(IRC0.unIRQPL59.stcField.u5IRQPL238)  /*@bf@*/
#define IRC0_IRQPL59_IRQPL239	(IRC0.unIRQPL59.stcField.u5IRQPL239)  /*@bf@*/

typedef struct stc_irc0_irqpl59_field{
    uint_io32_t		u5IRQPL236:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL237:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL238:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL239:5;
    uint_io32_t		:3;
}stc_irc0_irqpl59_field_t;

typedef union un_irc0_irqpl59{
    uint_io32_t		u32Register;
    stc_irc0_irqpl59_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl59_t;

/* IRQPL60 */
#define IRC0_IRQPL60	(IRC0.unIRQPL60.u32Register)  /*@rg@*/
#define IRC0_IRQPL60_IRQPL240	(IRC0.unIRQPL60.stcField.u5IRQPL240)  /*@bf@*/
#define IRC0_IRQPL60_IRQPL241	(IRC0.unIRQPL60.stcField.u5IRQPL241)  /*@bf@*/
#define IRC0_IRQPL60_IRQPL242	(IRC0.unIRQPL60.stcField.u5IRQPL242)  /*@bf@*/
#define IRC0_IRQPL60_IRQPL243	(IRC0.unIRQPL60.stcField.u5IRQPL243)  /*@bf@*/

typedef struct stc_irc0_irqpl60_field{
    uint_io32_t		u5IRQPL240:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL241:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL242:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL243:5;
    uint_io32_t		:3;
}stc_irc0_irqpl60_field_t;

typedef union un_irc0_irqpl60{
    uint_io32_t		u32Register;
    stc_irc0_irqpl60_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl60_t;

/* IRQPL61 */
#define IRC0_IRQPL61	(IRC0.unIRQPL61.u32Register)  /*@rg@*/
#define IRC0_IRQPL61_IRQPL244	(IRC0.unIRQPL61.stcField.u5IRQPL244)  /*@bf@*/
#define IRC0_IRQPL61_IRQPL245	(IRC0.unIRQPL61.stcField.u5IRQPL245)  /*@bf@*/
#define IRC0_IRQPL61_IRQPL246	(IRC0.unIRQPL61.stcField.u5IRQPL246)  /*@bf@*/
#define IRC0_IRQPL61_IRQPL247	(IRC0.unIRQPL61.stcField.u5IRQPL247)  /*@bf@*/

typedef struct stc_irc0_irqpl61_field{
    uint_io32_t		u5IRQPL244:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL245:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL246:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL247:5;
    uint_io32_t		:3;
}stc_irc0_irqpl61_field_t;

typedef union un_irc0_irqpl61{
    uint_io32_t		u32Register;
    stc_irc0_irqpl61_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl61_t;

/* IRQPL62 */
#define IRC0_IRQPL62	(IRC0.unIRQPL62.u32Register)  /*@rg@*/
#define IRC0_IRQPL62_IRQPL248	(IRC0.unIRQPL62.stcField.u5IRQPL248)  /*@bf@*/
#define IRC0_IRQPL62_IRQPL249	(IRC0.unIRQPL62.stcField.u5IRQPL249)  /*@bf@*/
#define IRC0_IRQPL62_IRQPL250	(IRC0.unIRQPL62.stcField.u5IRQPL250)  /*@bf@*/
#define IRC0_IRQPL62_IRQPL251	(IRC0.unIRQPL62.stcField.u5IRQPL251)  /*@bf@*/

typedef struct stc_irc0_irqpl62_field{
    uint_io32_t		u5IRQPL248:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL249:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL250:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL251:5;
    uint_io32_t		:3;
}stc_irc0_irqpl62_field_t;

typedef union un_irc0_irqpl62{
    uint_io32_t		u32Register;
    stc_irc0_irqpl62_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl62_t;

/* IRQPL63 */
#define IRC0_IRQPL63	(IRC0.unIRQPL63.u32Register)  /*@rg@*/
#define IRC0_IRQPL63_IRQPL252	(IRC0.unIRQPL63.stcField.u5IRQPL252)  /*@bf@*/
#define IRC0_IRQPL63_IRQPL253	(IRC0.unIRQPL63.stcField.u5IRQPL253)  /*@bf@*/
#define IRC0_IRQPL63_IRQPL254	(IRC0.unIRQPL63.stcField.u5IRQPL254)  /*@bf@*/
#define IRC0_IRQPL63_IRQPL255	(IRC0.unIRQPL63.stcField.u5IRQPL255)  /*@bf@*/

typedef struct stc_irc0_irqpl63_field{
    uint_io32_t		u5IRQPL252:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL253:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL254:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL255:5;
    uint_io32_t		:3;
}stc_irc0_irqpl63_field_t;

typedef union un_irc0_irqpl63{
    uint_io32_t		u32Register;
    stc_irc0_irqpl63_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl63_t;

/* IRQPL64 */
#define IRC0_IRQPL64	(IRC0.unIRQPL64.u32Register)  /*@rg@*/
#define IRC0_IRQPL64_IRQPL256	(IRC0.unIRQPL64.stcField.u5IRQPL256)  /*@bf@*/
#define IRC0_IRQPL64_IRQPL257	(IRC0.unIRQPL64.stcField.u5IRQPL257)  /*@bf@*/
#define IRC0_IRQPL64_IRQPL258	(IRC0.unIRQPL64.stcField.u5IRQPL258)  /*@bf@*/
#define IRC0_IRQPL64_IRQPL259	(IRC0.unIRQPL64.stcField.u5IRQPL259)  /*@bf@*/

typedef struct stc_irc0_irqpl64_field{
    uint_io32_t		u5IRQPL256:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL257:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL258:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL259:5;
    uint_io32_t		:3;
}stc_irc0_irqpl64_field_t;

typedef union un_irc0_irqpl64{
    uint_io32_t		u32Register;
    stc_irc0_irqpl64_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl64_t;

/* IRQPL65 */
#define IRC0_IRQPL65	(IRC0.unIRQPL65.u32Register)  /*@rg@*/
#define IRC0_IRQPL65_IRQPL260	(IRC0.unIRQPL65.stcField.u5IRQPL260)  /*@bf@*/
#define IRC0_IRQPL65_IRQPL261	(IRC0.unIRQPL65.stcField.u5IRQPL261)  /*@bf@*/
#define IRC0_IRQPL65_IRQPL262	(IRC0.unIRQPL65.stcField.u5IRQPL262)  /*@bf@*/
#define IRC0_IRQPL65_IRQPL263	(IRC0.unIRQPL65.stcField.u5IRQPL263)  /*@bf@*/

typedef struct stc_irc0_irqpl65_field{
    uint_io32_t		u5IRQPL260:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL261:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL262:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL263:5;
    uint_io32_t		:3;
}stc_irc0_irqpl65_field_t;

typedef union un_irc0_irqpl65{
    uint_io32_t		u32Register;
    stc_irc0_irqpl65_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl65_t;

/* IRQPL66 */
#define IRC0_IRQPL66	(IRC0.unIRQPL66.u32Register)  /*@rg@*/
#define IRC0_IRQPL66_IRQPL264	(IRC0.unIRQPL66.stcField.u5IRQPL264)  /*@bf@*/
#define IRC0_IRQPL66_IRQPL265	(IRC0.unIRQPL66.stcField.u5IRQPL265)  /*@bf@*/
#define IRC0_IRQPL66_IRQPL266	(IRC0.unIRQPL66.stcField.u5IRQPL266)  /*@bf@*/
#define IRC0_IRQPL66_IRQPL267	(IRC0.unIRQPL66.stcField.u5IRQPL267)  /*@bf@*/

typedef struct stc_irc0_irqpl66_field{
    uint_io32_t		u5IRQPL264:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL265:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL266:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL267:5;
    uint_io32_t		:3;
}stc_irc0_irqpl66_field_t;

typedef union un_irc0_irqpl66{
    uint_io32_t		u32Register;
    stc_irc0_irqpl66_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl66_t;

/* IRQPL67 */
#define IRC0_IRQPL67	(IRC0.unIRQPL67.u32Register)  /*@rg@*/
#define IRC0_IRQPL67_IRQPL268	(IRC0.unIRQPL67.stcField.u5IRQPL268)  /*@bf@*/
#define IRC0_IRQPL67_IRQPL269	(IRC0.unIRQPL67.stcField.u5IRQPL269)  /*@bf@*/
#define IRC0_IRQPL67_IRQPL270	(IRC0.unIRQPL67.stcField.u5IRQPL270)  /*@bf@*/
#define IRC0_IRQPL67_IRQPL271	(IRC0.unIRQPL67.stcField.u5IRQPL271)  /*@bf@*/

typedef struct stc_irc0_irqpl67_field{
    uint_io32_t		u5IRQPL268:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL269:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL270:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL271:5;
    uint_io32_t		:3;
}stc_irc0_irqpl67_field_t;

typedef union un_irc0_irqpl67{
    uint_io32_t		u32Register;
    stc_irc0_irqpl67_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl67_t;

/* IRQPL68 */
#define IRC0_IRQPL68	(IRC0.unIRQPL68.u32Register)  /*@rg@*/
#define IRC0_IRQPL68_IRQPL272	(IRC0.unIRQPL68.stcField.u5IRQPL272)  /*@bf@*/
#define IRC0_IRQPL68_IRQPL273	(IRC0.unIRQPL68.stcField.u5IRQPL273)  /*@bf@*/
#define IRC0_IRQPL68_IRQPL274	(IRC0.unIRQPL68.stcField.u5IRQPL274)  /*@bf@*/
#define IRC0_IRQPL68_IRQPL275	(IRC0.unIRQPL68.stcField.u5IRQPL275)  /*@bf@*/

typedef struct stc_irc0_irqpl68_field{
    uint_io32_t		u5IRQPL272:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL273:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL274:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL275:5;
    uint_io32_t		:3;
}stc_irc0_irqpl68_field_t;

typedef union un_irc0_irqpl68{
    uint_io32_t		u32Register;
    stc_irc0_irqpl68_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl68_t;

/* IRQPL69 */
#define IRC0_IRQPL69	(IRC0.unIRQPL69.u32Register)  /*@rg@*/
#define IRC0_IRQPL69_IRQPL276	(IRC0.unIRQPL69.stcField.u5IRQPL276)  /*@bf@*/
#define IRC0_IRQPL69_IRQPL277	(IRC0.unIRQPL69.stcField.u5IRQPL277)  /*@bf@*/
#define IRC0_IRQPL69_IRQPL278	(IRC0.unIRQPL69.stcField.u5IRQPL278)  /*@bf@*/
#define IRC0_IRQPL69_IRQPL279	(IRC0.unIRQPL69.stcField.u5IRQPL279)  /*@bf@*/

typedef struct stc_irc0_irqpl69_field{
    uint_io32_t		u5IRQPL276:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL277:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL278:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL279:5;
    uint_io32_t		:3;
}stc_irc0_irqpl69_field_t;

typedef union un_irc0_irqpl69{
    uint_io32_t		u32Register;
    stc_irc0_irqpl69_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl69_t;

/* IRQPL70 */
#define IRC0_IRQPL70	(IRC0.unIRQPL70.u32Register)  /*@rg@*/
#define IRC0_IRQPL70_IRQPL280	(IRC0.unIRQPL70.stcField.u5IRQPL280)  /*@bf@*/
#define IRC0_IRQPL70_IRQPL281	(IRC0.unIRQPL70.stcField.u5IRQPL281)  /*@bf@*/
#define IRC0_IRQPL70_IRQPL282	(IRC0.unIRQPL70.stcField.u5IRQPL282)  /*@bf@*/
#define IRC0_IRQPL70_IRQPL283	(IRC0.unIRQPL70.stcField.u5IRQPL283)  /*@bf@*/

typedef struct stc_irc0_irqpl70_field{
    uint_io32_t		u5IRQPL280:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL281:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL282:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL283:5;
    uint_io32_t		:3;
}stc_irc0_irqpl70_field_t;

typedef union un_irc0_irqpl70{
    uint_io32_t		u32Register;
    stc_irc0_irqpl70_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl70_t;

/* IRQPL71 */
#define IRC0_IRQPL71	(IRC0.unIRQPL71.u32Register)  /*@rg@*/
#define IRC0_IRQPL71_IRQPL284	(IRC0.unIRQPL71.stcField.u5IRQPL284)  /*@bf@*/
#define IRC0_IRQPL71_IRQPL285	(IRC0.unIRQPL71.stcField.u5IRQPL285)  /*@bf@*/
#define IRC0_IRQPL71_IRQPL286	(IRC0.unIRQPL71.stcField.u5IRQPL286)  /*@bf@*/
#define IRC0_IRQPL71_IRQPL287	(IRC0.unIRQPL71.stcField.u5IRQPL287)  /*@bf@*/

typedef struct stc_irc0_irqpl71_field{
    uint_io32_t		u5IRQPL284:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL285:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL286:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL287:5;
    uint_io32_t		:3;
}stc_irc0_irqpl71_field_t;

typedef union un_irc0_irqpl71{
    uint_io32_t		u32Register;
    stc_irc0_irqpl71_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl71_t;

/* IRQPL72 */
#define IRC0_IRQPL72	(IRC0.unIRQPL72.u32Register)  /*@rg@*/
#define IRC0_IRQPL72_IRQPL288	(IRC0.unIRQPL72.stcField.u5IRQPL288)  /*@bf@*/
#define IRC0_IRQPL72_IRQPL289	(IRC0.unIRQPL72.stcField.u5IRQPL289)  /*@bf@*/
#define IRC0_IRQPL72_IRQPL290	(IRC0.unIRQPL72.stcField.u5IRQPL290)  /*@bf@*/
#define IRC0_IRQPL72_IRQPL291	(IRC0.unIRQPL72.stcField.u5IRQPL291)  /*@bf@*/

typedef struct stc_irc0_irqpl72_field{
    uint_io32_t		u5IRQPL288:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL289:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL290:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL291:5;
    uint_io32_t		:3;
}stc_irc0_irqpl72_field_t;

typedef union un_irc0_irqpl72{
    uint_io32_t		u32Register;
    stc_irc0_irqpl72_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl72_t;

/* IRQPL73 */
#define IRC0_IRQPL73	(IRC0.unIRQPL73.u32Register)  /*@rg@*/
#define IRC0_IRQPL73_IRQPL292	(IRC0.unIRQPL73.stcField.u5IRQPL292)  /*@bf@*/
#define IRC0_IRQPL73_IRQPL293	(IRC0.unIRQPL73.stcField.u5IRQPL293)  /*@bf@*/
#define IRC0_IRQPL73_IRQPL294	(IRC0.unIRQPL73.stcField.u5IRQPL294)  /*@bf@*/
#define IRC0_IRQPL73_IRQPL295	(IRC0.unIRQPL73.stcField.u5IRQPL295)  /*@bf@*/

typedef struct stc_irc0_irqpl73_field{
    uint_io32_t		u5IRQPL292:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL293:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL294:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL295:5;
    uint_io32_t		:3;
}stc_irc0_irqpl73_field_t;

typedef union un_irc0_irqpl73{
    uint_io32_t		u32Register;
    stc_irc0_irqpl73_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl73_t;

/* IRQPL74 */
#define IRC0_IRQPL74	(IRC0.unIRQPL74.u32Register)  /*@rg@*/
#define IRC0_IRQPL74_IRQPL296	(IRC0.unIRQPL74.stcField.u5IRQPL296)  /*@bf@*/
#define IRC0_IRQPL74_IRQPL297	(IRC0.unIRQPL74.stcField.u5IRQPL297)  /*@bf@*/
#define IRC0_IRQPL74_IRQPL298	(IRC0.unIRQPL74.stcField.u5IRQPL298)  /*@bf@*/
#define IRC0_IRQPL74_IRQPL299	(IRC0.unIRQPL74.stcField.u5IRQPL299)  /*@bf@*/

typedef struct stc_irc0_irqpl74_field{
    uint_io32_t		u5IRQPL296:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL297:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL298:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL299:5;
    uint_io32_t		:3;
}stc_irc0_irqpl74_field_t;

typedef union un_irc0_irqpl74{
    uint_io32_t		u32Register;
    stc_irc0_irqpl74_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl74_t;

/* IRQPL75 */
#define IRC0_IRQPL75	(IRC0.unIRQPL75.u32Register)  /*@rg@*/
#define IRC0_IRQPL75_IRQPL300	(IRC0.unIRQPL75.stcField.u5IRQPL300)  /*@bf@*/
#define IRC0_IRQPL75_IRQPL301	(IRC0.unIRQPL75.stcField.u5IRQPL301)  /*@bf@*/
#define IRC0_IRQPL75_IRQPL302	(IRC0.unIRQPL75.stcField.u5IRQPL302)  /*@bf@*/
#define IRC0_IRQPL75_IRQPL303	(IRC0.unIRQPL75.stcField.u5IRQPL303)  /*@bf@*/

typedef struct stc_irc0_irqpl75_field{
    uint_io32_t		u5IRQPL300:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL301:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL302:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL303:5;
    uint_io32_t		:3;
}stc_irc0_irqpl75_field_t;

typedef union un_irc0_irqpl75{
    uint_io32_t		u32Register;
    stc_irc0_irqpl75_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl75_t;

/* IRQPL76 */
#define IRC0_IRQPL76	(IRC0.unIRQPL76.u32Register)  /*@rg@*/
#define IRC0_IRQPL76_IRQPL304	(IRC0.unIRQPL76.stcField.u5IRQPL304)  /*@bf@*/
#define IRC0_IRQPL76_IRQPL305	(IRC0.unIRQPL76.stcField.u5IRQPL305)  /*@bf@*/
#define IRC0_IRQPL76_IRQPL306	(IRC0.unIRQPL76.stcField.u5IRQPL306)  /*@bf@*/
#define IRC0_IRQPL76_IRQPL307	(IRC0.unIRQPL76.stcField.u5IRQPL307)  /*@bf@*/

typedef struct stc_irc0_irqpl76_field{
    uint_io32_t		u5IRQPL304:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL305:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL306:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL307:5;
    uint_io32_t		:3;
}stc_irc0_irqpl76_field_t;

typedef union un_irc0_irqpl76{
    uint_io32_t		u32Register;
    stc_irc0_irqpl76_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl76_t;

/* IRQPL77 */
#define IRC0_IRQPL77	(IRC0.unIRQPL77.u32Register)  /*@rg@*/
#define IRC0_IRQPL77_IRQPL308	(IRC0.unIRQPL77.stcField.u5IRQPL308)  /*@bf@*/
#define IRC0_IRQPL77_IRQPL309	(IRC0.unIRQPL77.stcField.u5IRQPL309)  /*@bf@*/
#define IRC0_IRQPL77_IRQPL310	(IRC0.unIRQPL77.stcField.u5IRQPL310)  /*@bf@*/
#define IRC0_IRQPL77_IRQPL311	(IRC0.unIRQPL77.stcField.u5IRQPL311)  /*@bf@*/

typedef struct stc_irc0_irqpl77_field{
    uint_io32_t		u5IRQPL308:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL309:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL310:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL311:5;
    uint_io32_t		:3;
}stc_irc0_irqpl77_field_t;

typedef union un_irc0_irqpl77{
    uint_io32_t		u32Register;
    stc_irc0_irqpl77_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl77_t;

/* IRQPL78 */
#define IRC0_IRQPL78	(IRC0.unIRQPL78.u32Register)  /*@rg@*/
#define IRC0_IRQPL78_IRQPL312	(IRC0.unIRQPL78.stcField.u5IRQPL312)  /*@bf@*/
#define IRC0_IRQPL78_IRQPL313	(IRC0.unIRQPL78.stcField.u5IRQPL313)  /*@bf@*/
#define IRC0_IRQPL78_IRQPL314	(IRC0.unIRQPL78.stcField.u5IRQPL314)  /*@bf@*/
#define IRC0_IRQPL78_IRQPL315	(IRC0.unIRQPL78.stcField.u5IRQPL315)  /*@bf@*/

typedef struct stc_irc0_irqpl78_field{
    uint_io32_t		u5IRQPL312:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL313:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL314:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL315:5;
    uint_io32_t		:3;
}stc_irc0_irqpl78_field_t;

typedef union un_irc0_irqpl78{
    uint_io32_t		u32Register;
    stc_irc0_irqpl78_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl78_t;

/* IRQPL79 */
#define IRC0_IRQPL79	(IRC0.unIRQPL79.u32Register)  /*@rg@*/
#define IRC0_IRQPL79_IRQPL316	(IRC0.unIRQPL79.stcField.u5IRQPL316)  /*@bf@*/
#define IRC0_IRQPL79_IRQPL317	(IRC0.unIRQPL79.stcField.u5IRQPL317)  /*@bf@*/
#define IRC0_IRQPL79_IRQPL318	(IRC0.unIRQPL79.stcField.u5IRQPL318)  /*@bf@*/
#define IRC0_IRQPL79_IRQPL319	(IRC0.unIRQPL79.stcField.u5IRQPL319)  /*@bf@*/

typedef struct stc_irc0_irqpl79_field{
    uint_io32_t		u5IRQPL316:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL317:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL318:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL319:5;
    uint_io32_t		:3;
}stc_irc0_irqpl79_field_t;

typedef union un_irc0_irqpl79{
    uint_io32_t		u32Register;
    stc_irc0_irqpl79_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl79_t;

/* IRQPL80 */
#define IRC0_IRQPL80	(IRC0.unIRQPL80.u32Register)  /*@rg@*/
#define IRC0_IRQPL80_IRQPL320	(IRC0.unIRQPL80.stcField.u5IRQPL320)  /*@bf@*/
#define IRC0_IRQPL80_IRQPL321	(IRC0.unIRQPL80.stcField.u5IRQPL321)  /*@bf@*/
#define IRC0_IRQPL80_IRQPL322	(IRC0.unIRQPL80.stcField.u5IRQPL322)  /*@bf@*/
#define IRC0_IRQPL80_IRQPL323	(IRC0.unIRQPL80.stcField.u5IRQPL323)  /*@bf@*/

typedef struct stc_irc0_irqpl80_field{
    uint_io32_t		u5IRQPL320:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL321:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL322:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL323:5;
    uint_io32_t		:3;
}stc_irc0_irqpl80_field_t;

typedef union un_irc0_irqpl80{
    uint_io32_t		u32Register;
    stc_irc0_irqpl80_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl80_t;

/* IRQPL81 */
#define IRC0_IRQPL81	(IRC0.unIRQPL81.u32Register)  /*@rg@*/
#define IRC0_IRQPL81_IRQPL324	(IRC0.unIRQPL81.stcField.u5IRQPL324)  /*@bf@*/
#define IRC0_IRQPL81_IRQPL325	(IRC0.unIRQPL81.stcField.u5IRQPL325)  /*@bf@*/
#define IRC0_IRQPL81_IRQPL326	(IRC0.unIRQPL81.stcField.u5IRQPL326)  /*@bf@*/
#define IRC0_IRQPL81_IRQPL327	(IRC0.unIRQPL81.stcField.u5IRQPL327)  /*@bf@*/

typedef struct stc_irc0_irqpl81_field{
    uint_io32_t		u5IRQPL324:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL325:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL326:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL327:5;
    uint_io32_t		:3;
}stc_irc0_irqpl81_field_t;

typedef union un_irc0_irqpl81{
    uint_io32_t		u32Register;
    stc_irc0_irqpl81_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl81_t;

/* IRQPL82 */
#define IRC0_IRQPL82	(IRC0.unIRQPL82.u32Register)  /*@rg@*/
#define IRC0_IRQPL82_IRQPL328	(IRC0.unIRQPL82.stcField.u5IRQPL328)  /*@bf@*/
#define IRC0_IRQPL82_IRQPL329	(IRC0.unIRQPL82.stcField.u5IRQPL329)  /*@bf@*/
#define IRC0_IRQPL82_IRQPL330	(IRC0.unIRQPL82.stcField.u5IRQPL330)  /*@bf@*/
#define IRC0_IRQPL82_IRQPL331	(IRC0.unIRQPL82.stcField.u5IRQPL331)  /*@bf@*/

typedef struct stc_irc0_irqpl82_field{
    uint_io32_t		u5IRQPL328:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL329:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL330:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL331:5;
    uint_io32_t		:3;
}stc_irc0_irqpl82_field_t;

typedef union un_irc0_irqpl82{
    uint_io32_t		u32Register;
    stc_irc0_irqpl82_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl82_t;

/* IRQPL83 */
#define IRC0_IRQPL83	(IRC0.unIRQPL83.u32Register)  /*@rg@*/
#define IRC0_IRQPL83_IRQPL332	(IRC0.unIRQPL83.stcField.u5IRQPL332)  /*@bf@*/
#define IRC0_IRQPL83_IRQPL333	(IRC0.unIRQPL83.stcField.u5IRQPL333)  /*@bf@*/
#define IRC0_IRQPL83_IRQPL334	(IRC0.unIRQPL83.stcField.u5IRQPL334)  /*@bf@*/
#define IRC0_IRQPL83_IRQPL335	(IRC0.unIRQPL83.stcField.u5IRQPL335)  /*@bf@*/

typedef struct stc_irc0_irqpl83_field{
    uint_io32_t		u5IRQPL332:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL333:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL334:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL335:5;
    uint_io32_t		:3;
}stc_irc0_irqpl83_field_t;

typedef union un_irc0_irqpl83{
    uint_io32_t		u32Register;
    stc_irc0_irqpl83_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl83_t;

/* IRQPL84 */
#define IRC0_IRQPL84	(IRC0.unIRQPL84.u32Register)  /*@rg@*/
#define IRC0_IRQPL84_IRQPL336	(IRC0.unIRQPL84.stcField.u5IRQPL336)  /*@bf@*/
#define IRC0_IRQPL84_IRQPL337	(IRC0.unIRQPL84.stcField.u5IRQPL337)  /*@bf@*/
#define IRC0_IRQPL84_IRQPL338	(IRC0.unIRQPL84.stcField.u5IRQPL338)  /*@bf@*/
#define IRC0_IRQPL84_IRQPL339	(IRC0.unIRQPL84.stcField.u5IRQPL339)  /*@bf@*/

typedef struct stc_irc0_irqpl84_field{
    uint_io32_t		u5IRQPL336:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL337:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL338:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL339:5;
    uint_io32_t		:3;
}stc_irc0_irqpl84_field_t;

typedef union un_irc0_irqpl84{
    uint_io32_t		u32Register;
    stc_irc0_irqpl84_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl84_t;

/* IRQPL85 */
#define IRC0_IRQPL85	(IRC0.unIRQPL85.u32Register)  /*@rg@*/
#define IRC0_IRQPL85_IRQPL340	(IRC0.unIRQPL85.stcField.u5IRQPL340)  /*@bf@*/
#define IRC0_IRQPL85_IRQPL341	(IRC0.unIRQPL85.stcField.u5IRQPL341)  /*@bf@*/
#define IRC0_IRQPL85_IRQPL342	(IRC0.unIRQPL85.stcField.u5IRQPL342)  /*@bf@*/
#define IRC0_IRQPL85_IRQPL343	(IRC0.unIRQPL85.stcField.u5IRQPL343)  /*@bf@*/

typedef struct stc_irc0_irqpl85_field{
    uint_io32_t		u5IRQPL340:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL341:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL342:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL343:5;
    uint_io32_t		:3;
}stc_irc0_irqpl85_field_t;

typedef union un_irc0_irqpl85{
    uint_io32_t		u32Register;
    stc_irc0_irqpl85_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl85_t;

/* IRQPL86 */
#define IRC0_IRQPL86	(IRC0.unIRQPL86.u32Register)  /*@rg@*/
#define IRC0_IRQPL86_IRQPL344	(IRC0.unIRQPL86.stcField.u5IRQPL344)  /*@bf@*/
#define IRC0_IRQPL86_IRQPL345	(IRC0.unIRQPL86.stcField.u5IRQPL345)  /*@bf@*/
#define IRC0_IRQPL86_IRQPL346	(IRC0.unIRQPL86.stcField.u5IRQPL346)  /*@bf@*/
#define IRC0_IRQPL86_IRQPL347	(IRC0.unIRQPL86.stcField.u5IRQPL347)  /*@bf@*/

typedef struct stc_irc0_irqpl86_field{
    uint_io32_t		u5IRQPL344:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL345:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL346:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL347:5;
    uint_io32_t		:3;
}stc_irc0_irqpl86_field_t;

typedef union un_irc0_irqpl86{
    uint_io32_t		u32Register;
    stc_irc0_irqpl86_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl86_t;

/* IRQPL87 */
#define IRC0_IRQPL87	(IRC0.unIRQPL87.u32Register)  /*@rg@*/
#define IRC0_IRQPL87_IRQPL348	(IRC0.unIRQPL87.stcField.u5IRQPL348)  /*@bf@*/
#define IRC0_IRQPL87_IRQPL349	(IRC0.unIRQPL87.stcField.u5IRQPL349)  /*@bf@*/
#define IRC0_IRQPL87_IRQPL350	(IRC0.unIRQPL87.stcField.u5IRQPL350)  /*@bf@*/
#define IRC0_IRQPL87_IRQPL351	(IRC0.unIRQPL87.stcField.u5IRQPL351)  /*@bf@*/

typedef struct stc_irc0_irqpl87_field{
    uint_io32_t		u5IRQPL348:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL349:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL350:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL351:5;
    uint_io32_t		:3;
}stc_irc0_irqpl87_field_t;

typedef union un_irc0_irqpl87{
    uint_io32_t		u32Register;
    stc_irc0_irqpl87_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl87_t;

/* IRQPL88 */
#define IRC0_IRQPL88	(IRC0.unIRQPL88.u32Register)  /*@rg@*/
#define IRC0_IRQPL88_IRQPL352	(IRC0.unIRQPL88.stcField.u5IRQPL352)  /*@bf@*/
#define IRC0_IRQPL88_IRQPL353	(IRC0.unIRQPL88.stcField.u5IRQPL353)  /*@bf@*/
#define IRC0_IRQPL88_IRQPL354	(IRC0.unIRQPL88.stcField.u5IRQPL354)  /*@bf@*/
#define IRC0_IRQPL88_IRQPL355	(IRC0.unIRQPL88.stcField.u5IRQPL355)  /*@bf@*/

typedef struct stc_irc0_irqpl88_field{
    uint_io32_t		u5IRQPL352:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL353:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL354:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL355:5;
    uint_io32_t		:3;
}stc_irc0_irqpl88_field_t;

typedef union un_irc0_irqpl88{
    uint_io32_t		u32Register;
    stc_irc0_irqpl88_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl88_t;

/* IRQPL89 */
#define IRC0_IRQPL89	(IRC0.unIRQPL89.u32Register)  /*@rg@*/
#define IRC0_IRQPL89_IRQPL356	(IRC0.unIRQPL89.stcField.u5IRQPL356)  /*@bf@*/
#define IRC0_IRQPL89_IRQPL357	(IRC0.unIRQPL89.stcField.u5IRQPL357)  /*@bf@*/
#define IRC0_IRQPL89_IRQPL358	(IRC0.unIRQPL89.stcField.u5IRQPL358)  /*@bf@*/
#define IRC0_IRQPL89_IRQPL359	(IRC0.unIRQPL89.stcField.u5IRQPL359)  /*@bf@*/

typedef struct stc_irc0_irqpl89_field{
    uint_io32_t		u5IRQPL356:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL357:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL358:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL359:5;
    uint_io32_t		:3;
}stc_irc0_irqpl89_field_t;

typedef union un_irc0_irqpl89{
    uint_io32_t		u32Register;
    stc_irc0_irqpl89_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl89_t;

/* IRQPL90 */
#define IRC0_IRQPL90	(IRC0.unIRQPL90.u32Register)  /*@rg@*/
#define IRC0_IRQPL90_IRQPL360	(IRC0.unIRQPL90.stcField.u5IRQPL360)  /*@bf@*/
#define IRC0_IRQPL90_IRQPL361	(IRC0.unIRQPL90.stcField.u5IRQPL361)  /*@bf@*/
#define IRC0_IRQPL90_IRQPL362	(IRC0.unIRQPL90.stcField.u5IRQPL362)  /*@bf@*/
#define IRC0_IRQPL90_IRQPL363	(IRC0.unIRQPL90.stcField.u5IRQPL363)  /*@bf@*/

typedef struct stc_irc0_irqpl90_field{
    uint_io32_t		u5IRQPL360:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL361:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL362:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL363:5;
    uint_io32_t		:3;
}stc_irc0_irqpl90_field_t;

typedef union un_irc0_irqpl90{
    uint_io32_t		u32Register;
    stc_irc0_irqpl90_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl90_t;

/* IRQPL91 */
#define IRC0_IRQPL91	(IRC0.unIRQPL91.u32Register)  /*@rg@*/
#define IRC0_IRQPL91_IRQPL364	(IRC0.unIRQPL91.stcField.u5IRQPL364)  /*@bf@*/
#define IRC0_IRQPL91_IRQPL365	(IRC0.unIRQPL91.stcField.u5IRQPL365)  /*@bf@*/
#define IRC0_IRQPL91_IRQPL366	(IRC0.unIRQPL91.stcField.u5IRQPL366)  /*@bf@*/
#define IRC0_IRQPL91_IRQPL367	(IRC0.unIRQPL91.stcField.u5IRQPL367)  /*@bf@*/

typedef struct stc_irc0_irqpl91_field{
    uint_io32_t		u5IRQPL364:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL365:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL366:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL367:5;
    uint_io32_t		:3;
}stc_irc0_irqpl91_field_t;

typedef union un_irc0_irqpl91{
    uint_io32_t		u32Register;
    stc_irc0_irqpl91_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl91_t;

/* IRQPL92 */
#define IRC0_IRQPL92	(IRC0.unIRQPL92.u32Register)  /*@rg@*/
#define IRC0_IRQPL92_IRQPL368	(IRC0.unIRQPL92.stcField.u5IRQPL368)  /*@bf@*/
#define IRC0_IRQPL92_IRQPL369	(IRC0.unIRQPL92.stcField.u5IRQPL369)  /*@bf@*/
#define IRC0_IRQPL92_IRQPL370	(IRC0.unIRQPL92.stcField.u5IRQPL370)  /*@bf@*/
#define IRC0_IRQPL92_IRQPL371	(IRC0.unIRQPL92.stcField.u5IRQPL371)  /*@bf@*/

typedef struct stc_irc0_irqpl92_field{
    uint_io32_t		u5IRQPL368:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL369:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL370:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL371:5;
    uint_io32_t		:3;
}stc_irc0_irqpl92_field_t;

typedef union un_irc0_irqpl92{
    uint_io32_t		u32Register;
    stc_irc0_irqpl92_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl92_t;

/* IRQPL93 */
#define IRC0_IRQPL93	(IRC0.unIRQPL93.u32Register)  /*@rg@*/
#define IRC0_IRQPL93_IRQPL372	(IRC0.unIRQPL93.stcField.u5IRQPL372)  /*@bf@*/
#define IRC0_IRQPL93_IRQPL373	(IRC0.unIRQPL93.stcField.u5IRQPL373)  /*@bf@*/
#define IRC0_IRQPL93_IRQPL374	(IRC0.unIRQPL93.stcField.u5IRQPL374)  /*@bf@*/
#define IRC0_IRQPL93_IRQPL375	(IRC0.unIRQPL93.stcField.u5IRQPL375)  /*@bf@*/

typedef struct stc_irc0_irqpl93_field{
    uint_io32_t		u5IRQPL372:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL373:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL374:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL375:5;
    uint_io32_t		:3;
}stc_irc0_irqpl93_field_t;

typedef union un_irc0_irqpl93{
    uint_io32_t		u32Register;
    stc_irc0_irqpl93_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl93_t;

/* IRQPL94 */
#define IRC0_IRQPL94	(IRC0.unIRQPL94.u32Register)  /*@rg@*/
#define IRC0_IRQPL94_IRQPL376	(IRC0.unIRQPL94.stcField.u5IRQPL376)  /*@bf@*/
#define IRC0_IRQPL94_IRQPL377	(IRC0.unIRQPL94.stcField.u5IRQPL377)  /*@bf@*/
#define IRC0_IRQPL94_IRQPL378	(IRC0.unIRQPL94.stcField.u5IRQPL378)  /*@bf@*/
#define IRC0_IRQPL94_IRQPL379	(IRC0.unIRQPL94.stcField.u5IRQPL379)  /*@bf@*/

typedef struct stc_irc0_irqpl94_field{
    uint_io32_t		u5IRQPL376:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL377:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL378:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL379:5;
    uint_io32_t		:3;
}stc_irc0_irqpl94_field_t;

typedef union un_irc0_irqpl94{
    uint_io32_t		u32Register;
    stc_irc0_irqpl94_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl94_t;

/* IRQPL95 */
#define IRC0_IRQPL95	(IRC0.unIRQPL95.u32Register)  /*@rg@*/
#define IRC0_IRQPL95_IRQPL380	(IRC0.unIRQPL95.stcField.u5IRQPL380)  /*@bf@*/
#define IRC0_IRQPL95_IRQPL381	(IRC0.unIRQPL95.stcField.u5IRQPL381)  /*@bf@*/
#define IRC0_IRQPL95_IRQPL382	(IRC0.unIRQPL95.stcField.u5IRQPL382)  /*@bf@*/
#define IRC0_IRQPL95_IRQPL383	(IRC0.unIRQPL95.stcField.u5IRQPL383)  /*@bf@*/

typedef struct stc_irc0_irqpl95_field{
    uint_io32_t		u5IRQPL380:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL381:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL382:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL383:5;
    uint_io32_t		:3;
}stc_irc0_irqpl95_field_t;

typedef union un_irc0_irqpl95{
    uint_io32_t		u32Register;
    stc_irc0_irqpl95_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl95_t;

/* IRQPL96 */
#define IRC0_IRQPL96	(IRC0.unIRQPL96.u32Register)  /*@rg@*/
#define IRC0_IRQPL96_IRQPL384	(IRC0.unIRQPL96.stcField.u5IRQPL384)  /*@bf@*/
#define IRC0_IRQPL96_IRQPL385	(IRC0.unIRQPL96.stcField.u5IRQPL385)  /*@bf@*/
#define IRC0_IRQPL96_IRQPL386	(IRC0.unIRQPL96.stcField.u5IRQPL386)  /*@bf@*/
#define IRC0_IRQPL96_IRQPL387	(IRC0.unIRQPL96.stcField.u5IRQPL387)  /*@bf@*/

typedef struct stc_irc0_irqpl96_field{
    uint_io32_t		u5IRQPL384:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL385:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL386:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL387:5;
    uint_io32_t		:3;
}stc_irc0_irqpl96_field_t;

typedef union un_irc0_irqpl96{
    uint_io32_t		u32Register;
    stc_irc0_irqpl96_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl96_t;

/* IRQPL97 */
#define IRC0_IRQPL97	(IRC0.unIRQPL97.u32Register)  /*@rg@*/
#define IRC0_IRQPL97_IRQPL388	(IRC0.unIRQPL97.stcField.u5IRQPL388)  /*@bf@*/
#define IRC0_IRQPL97_IRQPL389	(IRC0.unIRQPL97.stcField.u5IRQPL389)  /*@bf@*/
#define IRC0_IRQPL97_IRQPL390	(IRC0.unIRQPL97.stcField.u5IRQPL390)  /*@bf@*/
#define IRC0_IRQPL97_IRQPL391	(IRC0.unIRQPL97.stcField.u5IRQPL391)  /*@bf@*/

typedef struct stc_irc0_irqpl97_field{
    uint_io32_t		u5IRQPL388:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL389:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL390:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL391:5;
    uint_io32_t		:3;
}stc_irc0_irqpl97_field_t;

typedef union un_irc0_irqpl97{
    uint_io32_t		u32Register;
    stc_irc0_irqpl97_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl97_t;

/* IRQPL98 */
#define IRC0_IRQPL98	(IRC0.unIRQPL98.u32Register)  /*@rg@*/
#define IRC0_IRQPL98_IRQPL392	(IRC0.unIRQPL98.stcField.u5IRQPL392)  /*@bf@*/
#define IRC0_IRQPL98_IRQPL393	(IRC0.unIRQPL98.stcField.u5IRQPL393)  /*@bf@*/
#define IRC0_IRQPL98_IRQPL394	(IRC0.unIRQPL98.stcField.u5IRQPL394)  /*@bf@*/
#define IRC0_IRQPL98_IRQPL395	(IRC0.unIRQPL98.stcField.u5IRQPL395)  /*@bf@*/

typedef struct stc_irc0_irqpl98_field{
    uint_io32_t		u5IRQPL392:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL393:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL394:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL395:5;
    uint_io32_t		:3;
}stc_irc0_irqpl98_field_t;

typedef union un_irc0_irqpl98{
    uint_io32_t		u32Register;
    stc_irc0_irqpl98_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl98_t;

/* IRQPL99 */
#define IRC0_IRQPL99	(IRC0.unIRQPL99.u32Register)  /*@rg@*/
#define IRC0_IRQPL99_IRQPL396	(IRC0.unIRQPL99.stcField.u5IRQPL396)  /*@bf@*/
#define IRC0_IRQPL99_IRQPL397	(IRC0.unIRQPL99.stcField.u5IRQPL397)  /*@bf@*/
#define IRC0_IRQPL99_IRQPL398	(IRC0.unIRQPL99.stcField.u5IRQPL398)  /*@bf@*/
#define IRC0_IRQPL99_IRQPL399	(IRC0.unIRQPL99.stcField.u5IRQPL399)  /*@bf@*/

typedef struct stc_irc0_irqpl99_field{
    uint_io32_t		u5IRQPL396:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL397:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL398:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL399:5;
    uint_io32_t		:3;
}stc_irc0_irqpl99_field_t;

typedef union un_irc0_irqpl99{
    uint_io32_t		u32Register;
    stc_irc0_irqpl99_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl99_t;

/* IRQPL100 */
#define IRC0_IRQPL100	(IRC0.unIRQPL100.u32Register)  /*@rg@*/
#define IRC0_IRQPL100_IRQPL400	(IRC0.unIRQPL100.stcField.u5IRQPL400)  /*@bf@*/
#define IRC0_IRQPL100_IRQPL401	(IRC0.unIRQPL100.stcField.u5IRQPL401)  /*@bf@*/
#define IRC0_IRQPL100_IRQPL402	(IRC0.unIRQPL100.stcField.u5IRQPL402)  /*@bf@*/
#define IRC0_IRQPL100_IRQPL403	(IRC0.unIRQPL100.stcField.u5IRQPL403)  /*@bf@*/

typedef struct stc_irc0_irqpl100_field{
    uint_io32_t		u5IRQPL400:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL401:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL402:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL403:5;
    uint_io32_t		:3;
}stc_irc0_irqpl100_field_t;

typedef union un_irc0_irqpl100{
    uint_io32_t		u32Register;
    stc_irc0_irqpl100_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl100_t;

/* IRQPL101 */
#define IRC0_IRQPL101	(IRC0.unIRQPL101.u32Register)  /*@rg@*/
#define IRC0_IRQPL101_IRQPL404	(IRC0.unIRQPL101.stcField.u5IRQPL404)  /*@bf@*/
#define IRC0_IRQPL101_IRQPL405	(IRC0.unIRQPL101.stcField.u5IRQPL405)  /*@bf@*/
#define IRC0_IRQPL101_IRQPL406	(IRC0.unIRQPL101.stcField.u5IRQPL406)  /*@bf@*/
#define IRC0_IRQPL101_IRQPL407	(IRC0.unIRQPL101.stcField.u5IRQPL407)  /*@bf@*/

typedef struct stc_irc0_irqpl101_field{
    uint_io32_t		u5IRQPL404:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL405:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL406:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL407:5;
    uint_io32_t		:3;
}stc_irc0_irqpl101_field_t;

typedef union un_irc0_irqpl101{
    uint_io32_t		u32Register;
    stc_irc0_irqpl101_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl101_t;

/* IRQPL102 */
#define IRC0_IRQPL102	(IRC0.unIRQPL102.u32Register)  /*@rg@*/
#define IRC0_IRQPL102_IRQPL408	(IRC0.unIRQPL102.stcField.u5IRQPL408)  /*@bf@*/
#define IRC0_IRQPL102_IRQPL409	(IRC0.unIRQPL102.stcField.u5IRQPL409)  /*@bf@*/
#define IRC0_IRQPL102_IRQPL410	(IRC0.unIRQPL102.stcField.u5IRQPL410)  /*@bf@*/
#define IRC0_IRQPL102_IRQPL411	(IRC0.unIRQPL102.stcField.u5IRQPL411)  /*@bf@*/

typedef struct stc_irc0_irqpl102_field{
    uint_io32_t		u5IRQPL408:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL409:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL410:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL411:5;
    uint_io32_t		:3;
}stc_irc0_irqpl102_field_t;

typedef union un_irc0_irqpl102{
    uint_io32_t		u32Register;
    stc_irc0_irqpl102_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl102_t;

/* IRQPL103 */
#define IRC0_IRQPL103	(IRC0.unIRQPL103.u32Register)  /*@rg@*/
#define IRC0_IRQPL103_IRQPL412	(IRC0.unIRQPL103.stcField.u5IRQPL412)  /*@bf@*/
#define IRC0_IRQPL103_IRQPL413	(IRC0.unIRQPL103.stcField.u5IRQPL413)  /*@bf@*/
#define IRC0_IRQPL103_IRQPL414	(IRC0.unIRQPL103.stcField.u5IRQPL414)  /*@bf@*/
#define IRC0_IRQPL103_IRQPL415	(IRC0.unIRQPL103.stcField.u5IRQPL415)  /*@bf@*/

typedef struct stc_irc0_irqpl103_field{
    uint_io32_t		u5IRQPL412:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL413:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL414:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL415:5;
    uint_io32_t		:3;
}stc_irc0_irqpl103_field_t;

typedef union un_irc0_irqpl103{
    uint_io32_t		u32Register;
    stc_irc0_irqpl103_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl103_t;

/* IRQPL104 */
#define IRC0_IRQPL104	(IRC0.unIRQPL104.u32Register)  /*@rg@*/
#define IRC0_IRQPL104_IRQPL416	(IRC0.unIRQPL104.stcField.u5IRQPL416)  /*@bf@*/
#define IRC0_IRQPL104_IRQPL417	(IRC0.unIRQPL104.stcField.u5IRQPL417)  /*@bf@*/
#define IRC0_IRQPL104_IRQPL418	(IRC0.unIRQPL104.stcField.u5IRQPL418)  /*@bf@*/
#define IRC0_IRQPL104_IRQPL419	(IRC0.unIRQPL104.stcField.u5IRQPL419)  /*@bf@*/

typedef struct stc_irc0_irqpl104_field{
    uint_io32_t		u5IRQPL416:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL417:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL418:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL419:5;
    uint_io32_t		:3;
}stc_irc0_irqpl104_field_t;

typedef union un_irc0_irqpl104{
    uint_io32_t		u32Register;
    stc_irc0_irqpl104_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl104_t;

/* IRQPL105 */
#define IRC0_IRQPL105	(IRC0.unIRQPL105.u32Register)  /*@rg@*/
#define IRC0_IRQPL105_IRQPL420	(IRC0.unIRQPL105.stcField.u5IRQPL420)  /*@bf@*/
#define IRC0_IRQPL105_IRQPL421	(IRC0.unIRQPL105.stcField.u5IRQPL421)  /*@bf@*/
#define IRC0_IRQPL105_IRQPL422	(IRC0.unIRQPL105.stcField.u5IRQPL422)  /*@bf@*/
#define IRC0_IRQPL105_IRQPL423	(IRC0.unIRQPL105.stcField.u5IRQPL423)  /*@bf@*/

typedef struct stc_irc0_irqpl105_field{
    uint_io32_t		u5IRQPL420:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL421:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL422:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL423:5;
    uint_io32_t		:3;
}stc_irc0_irqpl105_field_t;

typedef union un_irc0_irqpl105{
    uint_io32_t		u32Register;
    stc_irc0_irqpl105_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl105_t;

/* IRQPL106 */
#define IRC0_IRQPL106	(IRC0.unIRQPL106.u32Register)  /*@rg@*/
#define IRC0_IRQPL106_IRQPL424	(IRC0.unIRQPL106.stcField.u5IRQPL424)  /*@bf@*/
#define IRC0_IRQPL106_IRQPL425	(IRC0.unIRQPL106.stcField.u5IRQPL425)  /*@bf@*/
#define IRC0_IRQPL106_IRQPL426	(IRC0.unIRQPL106.stcField.u5IRQPL426)  /*@bf@*/
#define IRC0_IRQPL106_IRQPL427	(IRC0.unIRQPL106.stcField.u5IRQPL427)  /*@bf@*/

typedef struct stc_irc0_irqpl106_field{
    uint_io32_t		u5IRQPL424:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL425:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL426:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL427:5;
    uint_io32_t		:3;
}stc_irc0_irqpl106_field_t;

typedef union un_irc0_irqpl106{
    uint_io32_t		u32Register;
    stc_irc0_irqpl106_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl106_t;

/* IRQPL107 */
#define IRC0_IRQPL107	(IRC0.unIRQPL107.u32Register)  /*@rg@*/
#define IRC0_IRQPL107_IRQPL428	(IRC0.unIRQPL107.stcField.u5IRQPL428)  /*@bf@*/
#define IRC0_IRQPL107_IRQPL429	(IRC0.unIRQPL107.stcField.u5IRQPL429)  /*@bf@*/
#define IRC0_IRQPL107_IRQPL430	(IRC0.unIRQPL107.stcField.u5IRQPL430)  /*@bf@*/
#define IRC0_IRQPL107_IRQPL431	(IRC0.unIRQPL107.stcField.u5IRQPL431)  /*@bf@*/

typedef struct stc_irc0_irqpl107_field{
    uint_io32_t		u5IRQPL428:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL429:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL430:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL431:5;
    uint_io32_t		:3;
}stc_irc0_irqpl107_field_t;

typedef union un_irc0_irqpl107{
    uint_io32_t		u32Register;
    stc_irc0_irqpl107_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl107_t;

/* IRQPL108 */
#define IRC0_IRQPL108	(IRC0.unIRQPL108.u32Register)  /*@rg@*/
#define IRC0_IRQPL108_IRQPL432	(IRC0.unIRQPL108.stcField.u5IRQPL432)  /*@bf@*/
#define IRC0_IRQPL108_IRQPL433	(IRC0.unIRQPL108.stcField.u5IRQPL433)  /*@bf@*/
#define IRC0_IRQPL108_IRQPL434	(IRC0.unIRQPL108.stcField.u5IRQPL434)  /*@bf@*/
#define IRC0_IRQPL108_IRQPL435	(IRC0.unIRQPL108.stcField.u5IRQPL435)  /*@bf@*/

typedef struct stc_irc0_irqpl108_field{
    uint_io32_t		u5IRQPL432:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL433:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL434:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL435:5;
    uint_io32_t		:3;
}stc_irc0_irqpl108_field_t;

typedef union un_irc0_irqpl108{
    uint_io32_t		u32Register;
    stc_irc0_irqpl108_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl108_t;

/* IRQPL109 */
#define IRC0_IRQPL109	(IRC0.unIRQPL109.u32Register)  /*@rg@*/
#define IRC0_IRQPL109_IRQPL436	(IRC0.unIRQPL109.stcField.u5IRQPL436)  /*@bf@*/
#define IRC0_IRQPL109_IRQPL437	(IRC0.unIRQPL109.stcField.u5IRQPL437)  /*@bf@*/
#define IRC0_IRQPL109_IRQPL438	(IRC0.unIRQPL109.stcField.u5IRQPL438)  /*@bf@*/
#define IRC0_IRQPL109_IRQPL439	(IRC0.unIRQPL109.stcField.u5IRQPL439)  /*@bf@*/

typedef struct stc_irc0_irqpl109_field{
    uint_io32_t		u5IRQPL436:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL437:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL438:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL439:5;
    uint_io32_t		:3;
}stc_irc0_irqpl109_field_t;

typedef union un_irc0_irqpl109{
    uint_io32_t		u32Register;
    stc_irc0_irqpl109_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl109_t;

/* IRQPL110 */
#define IRC0_IRQPL110	(IRC0.unIRQPL110.u32Register)  /*@rg@*/
#define IRC0_IRQPL110_IRQPL440	(IRC0.unIRQPL110.stcField.u5IRQPL440)  /*@bf@*/
#define IRC0_IRQPL110_IRQPL441	(IRC0.unIRQPL110.stcField.u5IRQPL441)  /*@bf@*/
#define IRC0_IRQPL110_IRQPL442	(IRC0.unIRQPL110.stcField.u5IRQPL442)  /*@bf@*/
#define IRC0_IRQPL110_IRQPL443	(IRC0.unIRQPL110.stcField.u5IRQPL443)  /*@bf@*/

typedef struct stc_irc0_irqpl110_field{
    uint_io32_t		u5IRQPL440:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL441:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL442:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL443:5;
    uint_io32_t		:3;
}stc_irc0_irqpl110_field_t;

typedef union un_irc0_irqpl110{
    uint_io32_t		u32Register;
    stc_irc0_irqpl110_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl110_t;

/* IRQPL111 */
#define IRC0_IRQPL111	(IRC0.unIRQPL111.u32Register)  /*@rg@*/
#define IRC0_IRQPL111_IRQPL444	(IRC0.unIRQPL111.stcField.u5IRQPL444)  /*@bf@*/
#define IRC0_IRQPL111_IRQPL445	(IRC0.unIRQPL111.stcField.u5IRQPL445)  /*@bf@*/
#define IRC0_IRQPL111_IRQPL446	(IRC0.unIRQPL111.stcField.u5IRQPL446)  /*@bf@*/
#define IRC0_IRQPL111_IRQPL447	(IRC0.unIRQPL111.stcField.u5IRQPL447)  /*@bf@*/

typedef struct stc_irc0_irqpl111_field{
    uint_io32_t		u5IRQPL444:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL445:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL446:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL447:5;
    uint_io32_t		:3;
}stc_irc0_irqpl111_field_t;

typedef union un_irc0_irqpl111{
    uint_io32_t		u32Register;
    stc_irc0_irqpl111_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl111_t;

/* IRQPL112 */
#define IRC0_IRQPL112	(IRC0.unIRQPL112.u32Register)  /*@rg@*/
#define IRC0_IRQPL112_IRQPL448	(IRC0.unIRQPL112.stcField.u5IRQPL448)  /*@bf@*/
#define IRC0_IRQPL112_IRQPL449	(IRC0.unIRQPL112.stcField.u5IRQPL449)  /*@bf@*/
#define IRC0_IRQPL112_IRQPL450	(IRC0.unIRQPL112.stcField.u5IRQPL450)  /*@bf@*/
#define IRC0_IRQPL112_IRQPL451	(IRC0.unIRQPL112.stcField.u5IRQPL451)  /*@bf@*/

typedef struct stc_irc0_irqpl112_field{
    uint_io32_t		u5IRQPL448:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL449:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL450:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL451:5;
    uint_io32_t		:3;
}stc_irc0_irqpl112_field_t;

typedef union un_irc0_irqpl112{
    uint_io32_t		u32Register;
    stc_irc0_irqpl112_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl112_t;

/* IRQPL113 */
#define IRC0_IRQPL113	(IRC0.unIRQPL113.u32Register)  /*@rg@*/
#define IRC0_IRQPL113_IRQPL452	(IRC0.unIRQPL113.stcField.u5IRQPL452)  /*@bf@*/
#define IRC0_IRQPL113_IRQPL453	(IRC0.unIRQPL113.stcField.u5IRQPL453)  /*@bf@*/
#define IRC0_IRQPL113_IRQPL454	(IRC0.unIRQPL113.stcField.u5IRQPL454)  /*@bf@*/
#define IRC0_IRQPL113_IRQPL455	(IRC0.unIRQPL113.stcField.u5IRQPL455)  /*@bf@*/

typedef struct stc_irc0_irqpl113_field{
    uint_io32_t		u5IRQPL452:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL453:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL454:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL455:5;
    uint_io32_t		:3;
}stc_irc0_irqpl113_field_t;

typedef union un_irc0_irqpl113{
    uint_io32_t		u32Register;
    stc_irc0_irqpl113_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl113_t;

/* IRQPL114 */
#define IRC0_IRQPL114	(IRC0.unIRQPL114.u32Register)  /*@rg@*/
#define IRC0_IRQPL114_IRQPL456	(IRC0.unIRQPL114.stcField.u5IRQPL456)  /*@bf@*/
#define IRC0_IRQPL114_IRQPL457	(IRC0.unIRQPL114.stcField.u5IRQPL457)  /*@bf@*/
#define IRC0_IRQPL114_IRQPL458	(IRC0.unIRQPL114.stcField.u5IRQPL458)  /*@bf@*/
#define IRC0_IRQPL114_IRQPL459	(IRC0.unIRQPL114.stcField.u5IRQPL459)  /*@bf@*/

typedef struct stc_irc0_irqpl114_field{
    uint_io32_t		u5IRQPL456:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL457:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL458:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL459:5;
    uint_io32_t		:3;
}stc_irc0_irqpl114_field_t;

typedef union un_irc0_irqpl114{
    uint_io32_t		u32Register;
    stc_irc0_irqpl114_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl114_t;

/* IRQPL115 */
#define IRC0_IRQPL115	(IRC0.unIRQPL115.u32Register)  /*@rg@*/
#define IRC0_IRQPL115_IRQPL460	(IRC0.unIRQPL115.stcField.u5IRQPL460)  /*@bf@*/
#define IRC0_IRQPL115_IRQPL461	(IRC0.unIRQPL115.stcField.u5IRQPL461)  /*@bf@*/
#define IRC0_IRQPL115_IRQPL462	(IRC0.unIRQPL115.stcField.u5IRQPL462)  /*@bf@*/
#define IRC0_IRQPL115_IRQPL463	(IRC0.unIRQPL115.stcField.u5IRQPL463)  /*@bf@*/

typedef struct stc_irc0_irqpl115_field{
    uint_io32_t		u5IRQPL460:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL461:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL462:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL463:5;
    uint_io32_t		:3;
}stc_irc0_irqpl115_field_t;

typedef union un_irc0_irqpl115{
    uint_io32_t		u32Register;
    stc_irc0_irqpl115_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl115_t;

/* IRQPL116 */
#define IRC0_IRQPL116	(IRC0.unIRQPL116.u32Register)  /*@rg@*/
#define IRC0_IRQPL116_IRQPL464	(IRC0.unIRQPL116.stcField.u5IRQPL464)  /*@bf@*/
#define IRC0_IRQPL116_IRQPL465	(IRC0.unIRQPL116.stcField.u5IRQPL465)  /*@bf@*/
#define IRC0_IRQPL116_IRQPL466	(IRC0.unIRQPL116.stcField.u5IRQPL466)  /*@bf@*/
#define IRC0_IRQPL116_IRQPL467	(IRC0.unIRQPL116.stcField.u5IRQPL467)  /*@bf@*/

typedef struct stc_irc0_irqpl116_field{
    uint_io32_t		u5IRQPL464:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL465:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL466:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL467:5;
    uint_io32_t		:3;
}stc_irc0_irqpl116_field_t;

typedef union un_irc0_irqpl116{
    uint_io32_t		u32Register;
    stc_irc0_irqpl116_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl116_t;

/* IRQPL117 */
#define IRC0_IRQPL117	(IRC0.unIRQPL117.u32Register)  /*@rg@*/
#define IRC0_IRQPL117_IRQPL468	(IRC0.unIRQPL117.stcField.u5IRQPL468)  /*@bf@*/
#define IRC0_IRQPL117_IRQPL469	(IRC0.unIRQPL117.stcField.u5IRQPL469)  /*@bf@*/
#define IRC0_IRQPL117_IRQPL470	(IRC0.unIRQPL117.stcField.u5IRQPL470)  /*@bf@*/
#define IRC0_IRQPL117_IRQPL471	(IRC0.unIRQPL117.stcField.u5IRQPL471)  /*@bf@*/

typedef struct stc_irc0_irqpl117_field{
    uint_io32_t		u5IRQPL468:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL469:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL470:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL471:5;
    uint_io32_t		:3;
}stc_irc0_irqpl117_field_t;

typedef union un_irc0_irqpl117{
    uint_io32_t		u32Register;
    stc_irc0_irqpl117_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl117_t;

/* IRQPL118 */
#define IRC0_IRQPL118	(IRC0.unIRQPL118.u32Register)  /*@rg@*/
#define IRC0_IRQPL118_IRQPL472	(IRC0.unIRQPL118.stcField.u5IRQPL472)  /*@bf@*/
#define IRC0_IRQPL118_IRQPL473	(IRC0.unIRQPL118.stcField.u5IRQPL473)  /*@bf@*/
#define IRC0_IRQPL118_IRQPL474	(IRC0.unIRQPL118.stcField.u5IRQPL474)  /*@bf@*/
#define IRC0_IRQPL118_IRQPL475	(IRC0.unIRQPL118.stcField.u5IRQPL475)  /*@bf@*/

typedef struct stc_irc0_irqpl118_field{
    uint_io32_t		u5IRQPL472:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL473:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL474:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL475:5;
    uint_io32_t		:3;
}stc_irc0_irqpl118_field_t;

typedef union un_irc0_irqpl118{
    uint_io32_t		u32Register;
    stc_irc0_irqpl118_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl118_t;

/* IRQPL119 */
#define IRC0_IRQPL119	(IRC0.unIRQPL119.u32Register)  /*@rg@*/
#define IRC0_IRQPL119_IRQPL476	(IRC0.unIRQPL119.stcField.u5IRQPL476)  /*@bf@*/
#define IRC0_IRQPL119_IRQPL477	(IRC0.unIRQPL119.stcField.u5IRQPL477)  /*@bf@*/
#define IRC0_IRQPL119_IRQPL478	(IRC0.unIRQPL119.stcField.u5IRQPL478)  /*@bf@*/
#define IRC0_IRQPL119_IRQPL479	(IRC0.unIRQPL119.stcField.u5IRQPL479)  /*@bf@*/

typedef struct stc_irc0_irqpl119_field{
    uint_io32_t		u5IRQPL476:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL477:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL478:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL479:5;
    uint_io32_t		:3;
}stc_irc0_irqpl119_field_t;

typedef union un_irc0_irqpl119{
    uint_io32_t		u32Register;
    stc_irc0_irqpl119_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl119_t;

/* IRQPL120 */
#define IRC0_IRQPL120	(IRC0.unIRQPL120.u32Register)  /*@rg@*/
#define IRC0_IRQPL120_IRQPL480	(IRC0.unIRQPL120.stcField.u5IRQPL480)  /*@bf@*/
#define IRC0_IRQPL120_IRQPL481	(IRC0.unIRQPL120.stcField.u5IRQPL481)  /*@bf@*/
#define IRC0_IRQPL120_IRQPL482	(IRC0.unIRQPL120.stcField.u5IRQPL482)  /*@bf@*/
#define IRC0_IRQPL120_IRQPL483	(IRC0.unIRQPL120.stcField.u5IRQPL483)  /*@bf@*/

typedef struct stc_irc0_irqpl120_field{
    uint_io32_t		u5IRQPL480:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL481:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL482:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL483:5;
    uint_io32_t		:3;
}stc_irc0_irqpl120_field_t;

typedef union un_irc0_irqpl120{
    uint_io32_t		u32Register;
    stc_irc0_irqpl120_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl120_t;

/* IRQPL121 */
#define IRC0_IRQPL121	(IRC0.unIRQPL121.u32Register)  /*@rg@*/
#define IRC0_IRQPL121_IRQPL484	(IRC0.unIRQPL121.stcField.u5IRQPL484)  /*@bf@*/
#define IRC0_IRQPL121_IRQPL485	(IRC0.unIRQPL121.stcField.u5IRQPL485)  /*@bf@*/
#define IRC0_IRQPL121_IRQPL486	(IRC0.unIRQPL121.stcField.u5IRQPL486)  /*@bf@*/
#define IRC0_IRQPL121_IRQPL487	(IRC0.unIRQPL121.stcField.u5IRQPL487)  /*@bf@*/

typedef struct stc_irc0_irqpl121_field{
    uint_io32_t		u5IRQPL484:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL485:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL486:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL487:5;
    uint_io32_t		:3;
}stc_irc0_irqpl121_field_t;

typedef union un_irc0_irqpl121{
    uint_io32_t		u32Register;
    stc_irc0_irqpl121_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl121_t;

/* IRQPL122 */
#define IRC0_IRQPL122	(IRC0.unIRQPL122.u32Register)  /*@rg@*/
#define IRC0_IRQPL122_IRQPL488	(IRC0.unIRQPL122.stcField.u5IRQPL488)  /*@bf@*/
#define IRC0_IRQPL122_IRQPL489	(IRC0.unIRQPL122.stcField.u5IRQPL489)  /*@bf@*/
#define IRC0_IRQPL122_IRQPL490	(IRC0.unIRQPL122.stcField.u5IRQPL490)  /*@bf@*/
#define IRC0_IRQPL122_IRQPL491	(IRC0.unIRQPL122.stcField.u5IRQPL491)  /*@bf@*/

typedef struct stc_irc0_irqpl122_field{
    uint_io32_t		u5IRQPL488:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL489:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL490:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL491:5;
    uint_io32_t		:3;
}stc_irc0_irqpl122_field_t;

typedef union un_irc0_irqpl122{
    uint_io32_t		u32Register;
    stc_irc0_irqpl122_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl122_t;

/* IRQPL123 */
#define IRC0_IRQPL123	(IRC0.unIRQPL123.u32Register)  /*@rg@*/
#define IRC0_IRQPL123_IRQPL492	(IRC0.unIRQPL123.stcField.u5IRQPL492)  /*@bf@*/
#define IRC0_IRQPL123_IRQPL493	(IRC0.unIRQPL123.stcField.u5IRQPL493)  /*@bf@*/
#define IRC0_IRQPL123_IRQPL494	(IRC0.unIRQPL123.stcField.u5IRQPL494)  /*@bf@*/
#define IRC0_IRQPL123_IRQPL495	(IRC0.unIRQPL123.stcField.u5IRQPL495)  /*@bf@*/

typedef struct stc_irc0_irqpl123_field{
    uint_io32_t		u5IRQPL492:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL493:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL494:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL495:5;
    uint_io32_t		:3;
}stc_irc0_irqpl123_field_t;

typedef union un_irc0_irqpl123{
    uint_io32_t		u32Register;
    stc_irc0_irqpl123_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl123_t;

/* IRQPL124 */
#define IRC0_IRQPL124	(IRC0.unIRQPL124.u32Register)  /*@rg@*/
#define IRC0_IRQPL124_IRQPL496	(IRC0.unIRQPL124.stcField.u5IRQPL496)  /*@bf@*/
#define IRC0_IRQPL124_IRQPL497	(IRC0.unIRQPL124.stcField.u5IRQPL497)  /*@bf@*/
#define IRC0_IRQPL124_IRQPL498	(IRC0.unIRQPL124.stcField.u5IRQPL498)  /*@bf@*/
#define IRC0_IRQPL124_IRQPL499	(IRC0.unIRQPL124.stcField.u5IRQPL499)  /*@bf@*/

typedef struct stc_irc0_irqpl124_field{
    uint_io32_t		u5IRQPL496:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL497:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL498:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL499:5;
    uint_io32_t		:3;
}stc_irc0_irqpl124_field_t;

typedef union un_irc0_irqpl124{
    uint_io32_t		u32Register;
    stc_irc0_irqpl124_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl124_t;

/* IRQPL125 */
#define IRC0_IRQPL125	(IRC0.unIRQPL125.u32Register)  /*@rg@*/
#define IRC0_IRQPL125_IRQPL500	(IRC0.unIRQPL125.stcField.u5IRQPL500)  /*@bf@*/
#define IRC0_IRQPL125_IRQPL501	(IRC0.unIRQPL125.stcField.u5IRQPL501)  /*@bf@*/
#define IRC0_IRQPL125_IRQPL502	(IRC0.unIRQPL125.stcField.u5IRQPL502)  /*@bf@*/
#define IRC0_IRQPL125_IRQPL503	(IRC0.unIRQPL125.stcField.u5IRQPL503)  /*@bf@*/

typedef struct stc_irc0_irqpl125_field{
    uint_io32_t		u5IRQPL500:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL501:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL502:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL503:5;
    uint_io32_t		:3;
}stc_irc0_irqpl125_field_t;

typedef union un_irc0_irqpl125{
    uint_io32_t		u32Register;
    stc_irc0_irqpl125_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl125_t;

/* IRQPL126 */
#define IRC0_IRQPL126	(IRC0.unIRQPL126.u32Register)  /*@rg@*/
#define IRC0_IRQPL126_IRQPL504	(IRC0.unIRQPL126.stcField.u5IRQPL504)  /*@bf@*/
#define IRC0_IRQPL126_IRQPL505	(IRC0.unIRQPL126.stcField.u5IRQPL505)  /*@bf@*/
#define IRC0_IRQPL126_IRQPL506	(IRC0.unIRQPL126.stcField.u5IRQPL506)  /*@bf@*/
#define IRC0_IRQPL126_IRQPL507	(IRC0.unIRQPL126.stcField.u5IRQPL507)  /*@bf@*/

typedef struct stc_irc0_irqpl126_field{
    uint_io32_t		u5IRQPL504:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL505:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL506:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL507:5;
    uint_io32_t		:3;
}stc_irc0_irqpl126_field_t;

typedef union un_irc0_irqpl126{
    uint_io32_t		u32Register;
    stc_irc0_irqpl126_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl126_t;

/* IRQPL127 */
#define IRC0_IRQPL127	(IRC0.unIRQPL127.u32Register)  /*@rg@*/
#define IRC0_IRQPL127_IRQPL508	(IRC0.unIRQPL127.stcField.u5IRQPL508)  /*@bf@*/
#define IRC0_IRQPL127_IRQPL509	(IRC0.unIRQPL127.stcField.u5IRQPL509)  /*@bf@*/
#define IRC0_IRQPL127_IRQPL510	(IRC0.unIRQPL127.stcField.u5IRQPL510)  /*@bf@*/
#define IRC0_IRQPL127_IRQPL511	(IRC0.unIRQPL127.stcField.u5IRQPL511)  /*@bf@*/

typedef struct stc_irc0_irqpl127_field{
    uint_io32_t		u5IRQPL508:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL509:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL510:5;
    uint_io32_t		:3;
    uint_io32_t		u5IRQPL511:5;
    uint_io32_t		:3;
}stc_irc0_irqpl127_field_t;

typedef union un_irc0_irqpl127{
    uint_io32_t		u32Register;
    stc_irc0_irqpl127_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqpl127_t;

/* NMIS */
#define IRC0_NMIS	(IRC0.unNMIS.u32Register)  /*@rg@*/
#define IRC0_NMIS_NMIS0	(IRC0.unNMIS.stcField.u1NMIS0)  /*@bf@*/
#define IRC0_NMIS_NMIS1	(IRC0.unNMIS.stcField.u1NMIS1)  /*@bf@*/
#define IRC0_NMIS_NMIS2	(IRC0.unNMIS.stcField.u1NMIS2)  /*@bf@*/
#define IRC0_NMIS_NMIS3	(IRC0.unNMIS.stcField.u1NMIS3)  /*@bf@*/
#define IRC0_NMIS_NMIS4	(IRC0.unNMIS.stcField.u1NMIS4)  /*@bf@*/
#define IRC0_NMIS_NMIS5	(IRC0.unNMIS.stcField.u1NMIS5)  /*@bf@*/
#define IRC0_NMIS_NMIS6	(IRC0.unNMIS.stcField.u1NMIS6)  /*@bf@*/
#define IRC0_NMIS_NMIS7	(IRC0.unNMIS.stcField.u1NMIS7)  /*@bf@*/
#define IRC0_NMIS_NMIS8	(IRC0.unNMIS.stcField.u1NMIS8)  /*@bf@*/
#define IRC0_NMIS_NMIS9	(IRC0.unNMIS.stcField.u1NMIS9)  /*@bf@*/
#define IRC0_NMIS_NMIS10	(IRC0.unNMIS.stcField.u1NMIS10)  /*@bf@*/
#define IRC0_NMIS_NMIS11	(IRC0.unNMIS.stcField.u1NMIS11)  /*@bf@*/
#define IRC0_NMIS_NMIS12	(IRC0.unNMIS.stcField.u1NMIS12)  /*@bf@*/
#define IRC0_NMIS_NMIS13	(IRC0.unNMIS.stcField.u1NMIS13)  /*@bf@*/
#define IRC0_NMIS_NMIS14	(IRC0.unNMIS.stcField.u1NMIS14)  /*@bf@*/
#define IRC0_NMIS_NMIS15	(IRC0.unNMIS.stcField.u1NMIS15)  /*@bf@*/
#define IRC0_NMIS_NMIS16	(IRC0.unNMIS.stcField.u1NMIS16)  /*@bf@*/
#define IRC0_NMIS_NMIS17	(IRC0.unNMIS.stcField.u1NMIS17)  /*@bf@*/
#define IRC0_NMIS_NMIS18	(IRC0.unNMIS.stcField.u1NMIS18)  /*@bf@*/
#define IRC0_NMIS_NMIS19	(IRC0.unNMIS.stcField.u1NMIS19)  /*@bf@*/
#define IRC0_NMIS_NMIS20	(IRC0.unNMIS.stcField.u1NMIS20)  /*@bf@*/
#define IRC0_NMIS_NMIS21	(IRC0.unNMIS.stcField.u1NMIS21)  /*@bf@*/
#define IRC0_NMIS_NMIS22	(IRC0.unNMIS.stcField.u1NMIS22)  /*@bf@*/
#define IRC0_NMIS_NMIS23	(IRC0.unNMIS.stcField.u1NMIS23)  /*@bf@*/
#define IRC0_NMIS_NMIS24	(IRC0.unNMIS.stcField.u1NMIS24)  /*@bf@*/
#define IRC0_NMIS_NMIS25	(IRC0.unNMIS.stcField.u1NMIS25)  /*@bf@*/
#define IRC0_NMIS_NMIS26	(IRC0.unNMIS.stcField.u1NMIS26)  /*@bf@*/
#define IRC0_NMIS_NMIS27	(IRC0.unNMIS.stcField.u1NMIS27)  /*@bf@*/
#define IRC0_NMIS_NMIS28	(IRC0.unNMIS.stcField.u1NMIS28)  /*@bf@*/
#define IRC0_NMIS_NMIS29	(IRC0.unNMIS.stcField.u1NMIS29)  /*@bf@*/
#define IRC0_NMIS_NMIS30	(IRC0.unNMIS.stcField.u1NMIS30)  /*@bf@*/
#define IRC0_NMIS_NMIS31	(IRC0.unNMIS.stcField.u1NMIS31)  /*@bf@*/

typedef struct stc_irc0_nmis_field{
    uint_io32_t		u1NMIS0:1;
    uint_io32_t		u1NMIS1:1;
    uint_io32_t		u1NMIS2:1;
    uint_io32_t		u1NMIS3:1;
    uint_io32_t		u1NMIS4:1;
    uint_io32_t		u1NMIS5:1;
    uint_io32_t		u1NMIS6:1;
    uint_io32_t		u1NMIS7:1;
    uint_io32_t		u1NMIS8:1;
    uint_io32_t		u1NMIS9:1;
    uint_io32_t		u1NMIS10:1;
    uint_io32_t		u1NMIS11:1;
    uint_io32_t		u1NMIS12:1;
    uint_io32_t		u1NMIS13:1;
    uint_io32_t		u1NMIS14:1;
    uint_io32_t		u1NMIS15:1;
    uint_io32_t		u1NMIS16:1;
    uint_io32_t		u1NMIS17:1;
    uint_io32_t		u1NMIS18:1;
    uint_io32_t		u1NMIS19:1;
    uint_io32_t		u1NMIS20:1;
    uint_io32_t		u1NMIS21:1;
    uint_io32_t		u1NMIS22:1;
    uint_io32_t		u1NMIS23:1;
    uint_io32_t		u1NMIS24:1;
    uint_io32_t		u1NMIS25:1;
    uint_io32_t		u1NMIS26:1;
    uint_io32_t		u1NMIS27:1;
    uint_io32_t		u1NMIS28:1;
    uint_io32_t		u1NMIS29:1;
    uint_io32_t		u1NMIS30:1;
    uint_io32_t		u1NMIS31:1;
}stc_irc0_nmis_field_t;

typedef union un_irc0_nmis{
    uint_io32_t		u32Register;
    stc_irc0_nmis_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmis_t;

/* NMIR */
#define IRC0_NMIR	(IRC0.unNMIR.u32Register)  /*@rg@*/
#define IRC0_NMIR_NMIR0	(IRC0.unNMIR.stcField.u1NMIR0)  /*@bf@*/
#define IRC0_NMIR_NMIR1	(IRC0.unNMIR.stcField.u1NMIR1)  /*@bf@*/
#define IRC0_NMIR_NMIR2	(IRC0.unNMIR.stcField.u1NMIR2)  /*@bf@*/
#define IRC0_NMIR_NMIR3	(IRC0.unNMIR.stcField.u1NMIR3)  /*@bf@*/
#define IRC0_NMIR_NMIR4	(IRC0.unNMIR.stcField.u1NMIR4)  /*@bf@*/
#define IRC0_NMIR_NMIR5	(IRC0.unNMIR.stcField.u1NMIR5)  /*@bf@*/
#define IRC0_NMIR_NMIR6	(IRC0.unNMIR.stcField.u1NMIR6)  /*@bf@*/
#define IRC0_NMIR_NMIR7	(IRC0.unNMIR.stcField.u1NMIR7)  /*@bf@*/
#define IRC0_NMIR_NMIR8	(IRC0.unNMIR.stcField.u1NMIR8)  /*@bf@*/
#define IRC0_NMIR_NMIR9	(IRC0.unNMIR.stcField.u1NMIR9)  /*@bf@*/
#define IRC0_NMIR_NMIR10	(IRC0.unNMIR.stcField.u1NMIR10)  /*@bf@*/
#define IRC0_NMIR_NMIR11	(IRC0.unNMIR.stcField.u1NMIR11)  /*@bf@*/
#define IRC0_NMIR_NMIR12	(IRC0.unNMIR.stcField.u1NMIR12)  /*@bf@*/
#define IRC0_NMIR_NMIR13	(IRC0.unNMIR.stcField.u1NMIR13)  /*@bf@*/
#define IRC0_NMIR_NMIR14	(IRC0.unNMIR.stcField.u1NMIR14)  /*@bf@*/
#define IRC0_NMIR_NMIR15	(IRC0.unNMIR.stcField.u1NMIR15)  /*@bf@*/
#define IRC0_NMIR_NMIR16	(IRC0.unNMIR.stcField.u1NMIR16)  /*@bf@*/
#define IRC0_NMIR_NMIR17	(IRC0.unNMIR.stcField.u1NMIR17)  /*@bf@*/
#define IRC0_NMIR_NMIR18	(IRC0.unNMIR.stcField.u1NMIR18)  /*@bf@*/
#define IRC0_NMIR_NMIR19	(IRC0.unNMIR.stcField.u1NMIR19)  /*@bf@*/
#define IRC0_NMIR_NMIR20	(IRC0.unNMIR.stcField.u1NMIR20)  /*@bf@*/
#define IRC0_NMIR_NMIR21	(IRC0.unNMIR.stcField.u1NMIR21)  /*@bf@*/
#define IRC0_NMIR_NMIR22	(IRC0.unNMIR.stcField.u1NMIR22)  /*@bf@*/
#define IRC0_NMIR_NMIR23	(IRC0.unNMIR.stcField.u1NMIR23)  /*@bf@*/
#define IRC0_NMIR_NMIR24	(IRC0.unNMIR.stcField.u1NMIR24)  /*@bf@*/
#define IRC0_NMIR_NMIR25	(IRC0.unNMIR.stcField.u1NMIR25)  /*@bf@*/
#define IRC0_NMIR_NMIR26	(IRC0.unNMIR.stcField.u1NMIR26)  /*@bf@*/
#define IRC0_NMIR_NMIR27	(IRC0.unNMIR.stcField.u1NMIR27)  /*@bf@*/
#define IRC0_NMIR_NMIR28	(IRC0.unNMIR.stcField.u1NMIR28)  /*@bf@*/
#define IRC0_NMIR_NMIR29	(IRC0.unNMIR.stcField.u1NMIR29)  /*@bf@*/
#define IRC0_NMIR_NMIR30	(IRC0.unNMIR.stcField.u1NMIR30)  /*@bf@*/
#define IRC0_NMIR_NMIR31	(IRC0.unNMIR.stcField.u1NMIR31)  /*@bf@*/

typedef struct stc_irc0_nmir_field{
    uint_io32_t		u1NMIR0:1;
    uint_io32_t		u1NMIR1:1;
    uint_io32_t		u1NMIR2:1;
    uint_io32_t		u1NMIR3:1;
    uint_io32_t		u1NMIR4:1;
    uint_io32_t		u1NMIR5:1;
    uint_io32_t		u1NMIR6:1;
    uint_io32_t		u1NMIR7:1;
    uint_io32_t		u1NMIR8:1;
    uint_io32_t		u1NMIR9:1;
    uint_io32_t		u1NMIR10:1;
    uint_io32_t		u1NMIR11:1;
    uint_io32_t		u1NMIR12:1;
    uint_io32_t		u1NMIR13:1;
    uint_io32_t		u1NMIR14:1;
    uint_io32_t		u1NMIR15:1;
    uint_io32_t		u1NMIR16:1;
    uint_io32_t		u1NMIR17:1;
    uint_io32_t		u1NMIR18:1;
    uint_io32_t		u1NMIR19:1;
    uint_io32_t		u1NMIR20:1;
    uint_io32_t		u1NMIR21:1;
    uint_io32_t		u1NMIR22:1;
    uint_io32_t		u1NMIR23:1;
    uint_io32_t		u1NMIR24:1;
    uint_io32_t		u1NMIR25:1;
    uint_io32_t		u1NMIR26:1;
    uint_io32_t		u1NMIR27:1;
    uint_io32_t		u1NMIR28:1;
    uint_io32_t		u1NMIR29:1;
    uint_io32_t		u1NMIR30:1;
    uint_io32_t		u1NMIR31:1;
}stc_irc0_nmir_field_t;

typedef union un_irc0_nmir{
    uint_io32_t		u32Register;
    stc_irc0_nmir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmir_t;

/* NMISIS */
#define IRC0_NMISIS	(IRC0.unNMISIS.u32Register)  /*@rg@*/
#define IRC0_NMISIS_NMISIS0	(IRC0.unNMISIS.stcField.u1NMISIS0)  /*@bf@*/
#define IRC0_NMISIS_NMISIS1	(IRC0.unNMISIS.stcField.u1NMISIS1)  /*@bf@*/
#define IRC0_NMISIS_NMISIS2	(IRC0.unNMISIS.stcField.u1NMISIS2)  /*@bf@*/
#define IRC0_NMISIS_NMISIS3	(IRC0.unNMISIS.stcField.u1NMISIS3)  /*@bf@*/
#define IRC0_NMISIS_NMISIS4	(IRC0.unNMISIS.stcField.u1NMISIS4)  /*@bf@*/
#define IRC0_NMISIS_NMISIS5	(IRC0.unNMISIS.stcField.u1NMISIS5)  /*@bf@*/
#define IRC0_NMISIS_NMISIS6	(IRC0.unNMISIS.stcField.u1NMISIS6)  /*@bf@*/
#define IRC0_NMISIS_NMISIS7	(IRC0.unNMISIS.stcField.u1NMISIS7)  /*@bf@*/
#define IRC0_NMISIS_NMISIS8	(IRC0.unNMISIS.stcField.u1NMISIS8)  /*@bf@*/
#define IRC0_NMISIS_NMISIS9	(IRC0.unNMISIS.stcField.u1NMISIS9)  /*@bf@*/
#define IRC0_NMISIS_NMISIS10	(IRC0.unNMISIS.stcField.u1NMISIS10)  /*@bf@*/
#define IRC0_NMISIS_NMISIS11	(IRC0.unNMISIS.stcField.u1NMISIS11)  /*@bf@*/
#define IRC0_NMISIS_NMISIS12	(IRC0.unNMISIS.stcField.u1NMISIS12)  /*@bf@*/
#define IRC0_NMISIS_NMISIS13	(IRC0.unNMISIS.stcField.u1NMISIS13)  /*@bf@*/
#define IRC0_NMISIS_NMISIS14	(IRC0.unNMISIS.stcField.u1NMISIS14)  /*@bf@*/
#define IRC0_NMISIS_NMISIS15	(IRC0.unNMISIS.stcField.u1NMISIS15)  /*@bf@*/
#define IRC0_NMISIS_NMISIS16	(IRC0.unNMISIS.stcField.u1NMISIS16)  /*@bf@*/
#define IRC0_NMISIS_NMISIS17	(IRC0.unNMISIS.stcField.u1NMISIS17)  /*@bf@*/
#define IRC0_NMISIS_NMISIS18	(IRC0.unNMISIS.stcField.u1NMISIS18)  /*@bf@*/
#define IRC0_NMISIS_NMISIS19	(IRC0.unNMISIS.stcField.u1NMISIS19)  /*@bf@*/
#define IRC0_NMISIS_NMISIS20	(IRC0.unNMISIS.stcField.u1NMISIS20)  /*@bf@*/
#define IRC0_NMISIS_NMISIS21	(IRC0.unNMISIS.stcField.u1NMISIS21)  /*@bf@*/
#define IRC0_NMISIS_NMISIS22	(IRC0.unNMISIS.stcField.u1NMISIS22)  /*@bf@*/
#define IRC0_NMISIS_NMISIS23	(IRC0.unNMISIS.stcField.u1NMISIS23)  /*@bf@*/
#define IRC0_NMISIS_NMISIS24	(IRC0.unNMISIS.stcField.u1NMISIS24)  /*@bf@*/
#define IRC0_NMISIS_NMISIS25	(IRC0.unNMISIS.stcField.u1NMISIS25)  /*@bf@*/
#define IRC0_NMISIS_NMISIS26	(IRC0.unNMISIS.stcField.u1NMISIS26)  /*@bf@*/
#define IRC0_NMISIS_NMISIS27	(IRC0.unNMISIS.stcField.u1NMISIS27)  /*@bf@*/
#define IRC0_NMISIS_NMISIS28	(IRC0.unNMISIS.stcField.u1NMISIS28)  /*@bf@*/
#define IRC0_NMISIS_NMISIS29	(IRC0.unNMISIS.stcField.u1NMISIS29)  /*@bf@*/
#define IRC0_NMISIS_NMISIS30	(IRC0.unNMISIS.stcField.u1NMISIS30)  /*@bf@*/
#define IRC0_NMISIS_NMISIS31	(IRC0.unNMISIS.stcField.u1NMISIS31)  /*@bf@*/

typedef struct stc_irc0_nmisis_field{
    uint_io32_t		u1NMISIS0:1;
    uint_io32_t		u1NMISIS1:1;
    uint_io32_t		u1NMISIS2:1;
    uint_io32_t		u1NMISIS3:1;
    uint_io32_t		u1NMISIS4:1;
    uint_io32_t		u1NMISIS5:1;
    uint_io32_t		u1NMISIS6:1;
    uint_io32_t		u1NMISIS7:1;
    uint_io32_t		u1NMISIS8:1;
    uint_io32_t		u1NMISIS9:1;
    uint_io32_t		u1NMISIS10:1;
    uint_io32_t		u1NMISIS11:1;
    uint_io32_t		u1NMISIS12:1;
    uint_io32_t		u1NMISIS13:1;
    uint_io32_t		u1NMISIS14:1;
    uint_io32_t		u1NMISIS15:1;
    uint_io32_t		u1NMISIS16:1;
    uint_io32_t		u1NMISIS17:1;
    uint_io32_t		u1NMISIS18:1;
    uint_io32_t		u1NMISIS19:1;
    uint_io32_t		u1NMISIS20:1;
    uint_io32_t		u1NMISIS21:1;
    uint_io32_t		u1NMISIS22:1;
    uint_io32_t		u1NMISIS23:1;
    uint_io32_t		u1NMISIS24:1;
    uint_io32_t		u1NMISIS25:1;
    uint_io32_t		u1NMISIS26:1;
    uint_io32_t		u1NMISIS27:1;
    uint_io32_t		u1NMISIS28:1;
    uint_io32_t		u1NMISIS29:1;
    uint_io32_t		u1NMISIS30:1;
    uint_io32_t		u1NMISIS31:1;
}stc_irc0_nmisis_field_t;

typedef union un_irc0_nmisis{
    uint_io32_t		u32Register;
    stc_irc0_nmisis_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmisis_t;

/* IRQS0 */
#define IRC0_IRQS0	(IRC0.unIRQS0.u32Register)  /*@rg@*/
#define IRC0_IRQS0_IRQS0	(IRC0.unIRQS0.stcField.u1IRQS0)  /*@bf@*/
#define IRC0_IRQS0_IRQS1	(IRC0.unIRQS0.stcField.u1IRQS1)  /*@bf@*/
#define IRC0_IRQS0_IRQS2	(IRC0.unIRQS0.stcField.u1IRQS2)  /*@bf@*/
#define IRC0_IRQS0_IRQS3	(IRC0.unIRQS0.stcField.u1IRQS3)  /*@bf@*/
#define IRC0_IRQS0_IRQS4	(IRC0.unIRQS0.stcField.u1IRQS4)  /*@bf@*/
#define IRC0_IRQS0_IRQS5	(IRC0.unIRQS0.stcField.u1IRQS5)  /*@bf@*/
#define IRC0_IRQS0_IRQS6	(IRC0.unIRQS0.stcField.u1IRQS6)  /*@bf@*/
#define IRC0_IRQS0_IRQS7	(IRC0.unIRQS0.stcField.u1IRQS7)  /*@bf@*/
#define IRC0_IRQS0_IRQS8	(IRC0.unIRQS0.stcField.u1IRQS8)  /*@bf@*/
#define IRC0_IRQS0_IRQS9	(IRC0.unIRQS0.stcField.u1IRQS9)  /*@bf@*/
#define IRC0_IRQS0_IRQS10	(IRC0.unIRQS0.stcField.u1IRQS10)  /*@bf@*/
#define IRC0_IRQS0_IRQS11	(IRC0.unIRQS0.stcField.u1IRQS11)  /*@bf@*/
#define IRC0_IRQS0_IRQS12	(IRC0.unIRQS0.stcField.u1IRQS12)  /*@bf@*/
#define IRC0_IRQS0_IRQS13	(IRC0.unIRQS0.stcField.u1IRQS13)  /*@bf@*/
#define IRC0_IRQS0_IRQS14	(IRC0.unIRQS0.stcField.u1IRQS14)  /*@bf@*/
#define IRC0_IRQS0_IRQS15	(IRC0.unIRQS0.stcField.u1IRQS15)  /*@bf@*/
#define IRC0_IRQS0_IRQS16	(IRC0.unIRQS0.stcField.u1IRQS16)  /*@bf@*/
#define IRC0_IRQS0_IRQS17	(IRC0.unIRQS0.stcField.u1IRQS17)  /*@bf@*/
#define IRC0_IRQS0_IRQS18	(IRC0.unIRQS0.stcField.u1IRQS18)  /*@bf@*/
#define IRC0_IRQS0_IRQS19	(IRC0.unIRQS0.stcField.u1IRQS19)  /*@bf@*/
#define IRC0_IRQS0_IRQS20	(IRC0.unIRQS0.stcField.u1IRQS20)  /*@bf@*/
#define IRC0_IRQS0_IRQS21	(IRC0.unIRQS0.stcField.u1IRQS21)  /*@bf@*/
#define IRC0_IRQS0_IRQS22	(IRC0.unIRQS0.stcField.u1IRQS22)  /*@bf@*/
#define IRC0_IRQS0_IRQS23	(IRC0.unIRQS0.stcField.u1IRQS23)  /*@bf@*/
#define IRC0_IRQS0_IRQS24	(IRC0.unIRQS0.stcField.u1IRQS24)  /*@bf@*/
#define IRC0_IRQS0_IRQS25	(IRC0.unIRQS0.stcField.u1IRQS25)  /*@bf@*/
#define IRC0_IRQS0_IRQS26	(IRC0.unIRQS0.stcField.u1IRQS26)  /*@bf@*/
#define IRC0_IRQS0_IRQS27	(IRC0.unIRQS0.stcField.u1IRQS27)  /*@bf@*/
#define IRC0_IRQS0_IRQS28	(IRC0.unIRQS0.stcField.u1IRQS28)  /*@bf@*/
#define IRC0_IRQS0_IRQS29	(IRC0.unIRQS0.stcField.u1IRQS29)  /*@bf@*/
#define IRC0_IRQS0_IRQS30	(IRC0.unIRQS0.stcField.u1IRQS30)  /*@bf@*/
#define IRC0_IRQS0_IRQS31	(IRC0.unIRQS0.stcField.u1IRQS31)  /*@bf@*/

typedef struct stc_irc0_irqs0_field{
    uint_io32_t		u1IRQS0:1;
    uint_io32_t		u1IRQS1:1;
    uint_io32_t		u1IRQS2:1;
    uint_io32_t		u1IRQS3:1;
    uint_io32_t		u1IRQS4:1;
    uint_io32_t		u1IRQS5:1;
    uint_io32_t		u1IRQS6:1;
    uint_io32_t		u1IRQS7:1;
    uint_io32_t		u1IRQS8:1;
    uint_io32_t		u1IRQS9:1;
    uint_io32_t		u1IRQS10:1;
    uint_io32_t		u1IRQS11:1;
    uint_io32_t		u1IRQS12:1;
    uint_io32_t		u1IRQS13:1;
    uint_io32_t		u1IRQS14:1;
    uint_io32_t		u1IRQS15:1;
    uint_io32_t		u1IRQS16:1;
    uint_io32_t		u1IRQS17:1;
    uint_io32_t		u1IRQS18:1;
    uint_io32_t		u1IRQS19:1;
    uint_io32_t		u1IRQS20:1;
    uint_io32_t		u1IRQS21:1;
    uint_io32_t		u1IRQS22:1;
    uint_io32_t		u1IRQS23:1;
    uint_io32_t		u1IRQS24:1;
    uint_io32_t		u1IRQS25:1;
    uint_io32_t		u1IRQS26:1;
    uint_io32_t		u1IRQS27:1;
    uint_io32_t		u1IRQS28:1;
    uint_io32_t		u1IRQS29:1;
    uint_io32_t		u1IRQS30:1;
    uint_io32_t		u1IRQS31:1;
}stc_irc0_irqs0_field_t;

typedef union un_irc0_irqs0{
    uint_io32_t		u32Register;
    stc_irc0_irqs0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs0_t;

/* IRQS1 */
#define IRC0_IRQS1	(IRC0.unIRQS1.u32Register)  /*@rg@*/
#define IRC0_IRQS1_IRQS32	(IRC0.unIRQS1.stcField.u1IRQS32)  /*@bf@*/
#define IRC0_IRQS1_IRQS33	(IRC0.unIRQS1.stcField.u1IRQS33)  /*@bf@*/
#define IRC0_IRQS1_IRQS34	(IRC0.unIRQS1.stcField.u1IRQS34)  /*@bf@*/
#define IRC0_IRQS1_IRQS35	(IRC0.unIRQS1.stcField.u1IRQS35)  /*@bf@*/
#define IRC0_IRQS1_IRQS36	(IRC0.unIRQS1.stcField.u1IRQS36)  /*@bf@*/
#define IRC0_IRQS1_IRQS37	(IRC0.unIRQS1.stcField.u1IRQS37)  /*@bf@*/
#define IRC0_IRQS1_IRQS38	(IRC0.unIRQS1.stcField.u1IRQS38)  /*@bf@*/
#define IRC0_IRQS1_IRQS39	(IRC0.unIRQS1.stcField.u1IRQS39)  /*@bf@*/
#define IRC0_IRQS1_IRQS40	(IRC0.unIRQS1.stcField.u1IRQS40)  /*@bf@*/
#define IRC0_IRQS1_IRQS41	(IRC0.unIRQS1.stcField.u1IRQS41)  /*@bf@*/
#define IRC0_IRQS1_IRQS42	(IRC0.unIRQS1.stcField.u1IRQS42)  /*@bf@*/
#define IRC0_IRQS1_IRQS43	(IRC0.unIRQS1.stcField.u1IRQS43)  /*@bf@*/
#define IRC0_IRQS1_IRQS44	(IRC0.unIRQS1.stcField.u1IRQS44)  /*@bf@*/
#define IRC0_IRQS1_IRQS45	(IRC0.unIRQS1.stcField.u1IRQS45)  /*@bf@*/
#define IRC0_IRQS1_IRQS46	(IRC0.unIRQS1.stcField.u1IRQS46)  /*@bf@*/
#define IRC0_IRQS1_IRQS47	(IRC0.unIRQS1.stcField.u1IRQS47)  /*@bf@*/
#define IRC0_IRQS1_IRQS48	(IRC0.unIRQS1.stcField.u1IRQS48)  /*@bf@*/
#define IRC0_IRQS1_IRQS49	(IRC0.unIRQS1.stcField.u1IRQS49)  /*@bf@*/
#define IRC0_IRQS1_IRQS50	(IRC0.unIRQS1.stcField.u1IRQS50)  /*@bf@*/
#define IRC0_IRQS1_IRQS51	(IRC0.unIRQS1.stcField.u1IRQS51)  /*@bf@*/
#define IRC0_IRQS1_IRQS52	(IRC0.unIRQS1.stcField.u1IRQS52)  /*@bf@*/
#define IRC0_IRQS1_IRQS53	(IRC0.unIRQS1.stcField.u1IRQS53)  /*@bf@*/
#define IRC0_IRQS1_IRQS54	(IRC0.unIRQS1.stcField.u1IRQS54)  /*@bf@*/
#define IRC0_IRQS1_IRQS55	(IRC0.unIRQS1.stcField.u1IRQS55)  /*@bf@*/
#define IRC0_IRQS1_IRQS56	(IRC0.unIRQS1.stcField.u1IRQS56)  /*@bf@*/
#define IRC0_IRQS1_IRQS57	(IRC0.unIRQS1.stcField.u1IRQS57)  /*@bf@*/
#define IRC0_IRQS1_IRQS58	(IRC0.unIRQS1.stcField.u1IRQS58)  /*@bf@*/
#define IRC0_IRQS1_IRQS59	(IRC0.unIRQS1.stcField.u1IRQS59)  /*@bf@*/
#define IRC0_IRQS1_IRQS60	(IRC0.unIRQS1.stcField.u1IRQS60)  /*@bf@*/
#define IRC0_IRQS1_IRQS61	(IRC0.unIRQS1.stcField.u1IRQS61)  /*@bf@*/
#define IRC0_IRQS1_IRQS62	(IRC0.unIRQS1.stcField.u1IRQS62)  /*@bf@*/
#define IRC0_IRQS1_IRQS63	(IRC0.unIRQS1.stcField.u1IRQS63)  /*@bf@*/

typedef struct stc_irc0_irqs1_field{
    uint_io32_t		u1IRQS32:1;
    uint_io32_t		u1IRQS33:1;
    uint_io32_t		u1IRQS34:1;
    uint_io32_t		u1IRQS35:1;
    uint_io32_t		u1IRQS36:1;
    uint_io32_t		u1IRQS37:1;
    uint_io32_t		u1IRQS38:1;
    uint_io32_t		u1IRQS39:1;
    uint_io32_t		u1IRQS40:1;
    uint_io32_t		u1IRQS41:1;
    uint_io32_t		u1IRQS42:1;
    uint_io32_t		u1IRQS43:1;
    uint_io32_t		u1IRQS44:1;
    uint_io32_t		u1IRQS45:1;
    uint_io32_t		u1IRQS46:1;
    uint_io32_t		u1IRQS47:1;
    uint_io32_t		u1IRQS48:1;
    uint_io32_t		u1IRQS49:1;
    uint_io32_t		u1IRQS50:1;
    uint_io32_t		u1IRQS51:1;
    uint_io32_t		u1IRQS52:1;
    uint_io32_t		u1IRQS53:1;
    uint_io32_t		u1IRQS54:1;
    uint_io32_t		u1IRQS55:1;
    uint_io32_t		u1IRQS56:1;
    uint_io32_t		u1IRQS57:1;
    uint_io32_t		u1IRQS58:1;
    uint_io32_t		u1IRQS59:1;
    uint_io32_t		u1IRQS60:1;
    uint_io32_t		u1IRQS61:1;
    uint_io32_t		u1IRQS62:1;
    uint_io32_t		u1IRQS63:1;
}stc_irc0_irqs1_field_t;

typedef union un_irc0_irqs1{
    uint_io32_t		u32Register;
    stc_irc0_irqs1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs1_t;

/* IRQS2 */
#define IRC0_IRQS2	(IRC0.unIRQS2.u32Register)  /*@rg@*/
#define IRC0_IRQS2_IRQS64	(IRC0.unIRQS2.stcField.u1IRQS64)  /*@bf@*/
#define IRC0_IRQS2_IRQS65	(IRC0.unIRQS2.stcField.u1IRQS65)  /*@bf@*/
#define IRC0_IRQS2_IRQS66	(IRC0.unIRQS2.stcField.u1IRQS66)  /*@bf@*/
#define IRC0_IRQS2_IRQS67	(IRC0.unIRQS2.stcField.u1IRQS67)  /*@bf@*/
#define IRC0_IRQS2_IRQS68	(IRC0.unIRQS2.stcField.u1IRQS68)  /*@bf@*/
#define IRC0_IRQS2_IRQS69	(IRC0.unIRQS2.stcField.u1IRQS69)  /*@bf@*/
#define IRC0_IRQS2_IRQS70	(IRC0.unIRQS2.stcField.u1IRQS70)  /*@bf@*/
#define IRC0_IRQS2_IRQS71	(IRC0.unIRQS2.stcField.u1IRQS71)  /*@bf@*/
#define IRC0_IRQS2_IRQS72	(IRC0.unIRQS2.stcField.u1IRQS72)  /*@bf@*/
#define IRC0_IRQS2_IRQS73	(IRC0.unIRQS2.stcField.u1IRQS73)  /*@bf@*/
#define IRC0_IRQS2_IRQS74	(IRC0.unIRQS2.stcField.u1IRQS74)  /*@bf@*/
#define IRC0_IRQS2_IRQS75	(IRC0.unIRQS2.stcField.u1IRQS75)  /*@bf@*/
#define IRC0_IRQS2_IRQS76	(IRC0.unIRQS2.stcField.u1IRQS76)  /*@bf@*/
#define IRC0_IRQS2_IRQS77	(IRC0.unIRQS2.stcField.u1IRQS77)  /*@bf@*/
#define IRC0_IRQS2_IRQS78	(IRC0.unIRQS2.stcField.u1IRQS78)  /*@bf@*/
#define IRC0_IRQS2_IRQS79	(IRC0.unIRQS2.stcField.u1IRQS79)  /*@bf@*/
#define IRC0_IRQS2_IRQS80	(IRC0.unIRQS2.stcField.u1IRQS80)  /*@bf@*/
#define IRC0_IRQS2_IRQS81	(IRC0.unIRQS2.stcField.u1IRQS81)  /*@bf@*/
#define IRC0_IRQS2_IRQS82	(IRC0.unIRQS2.stcField.u1IRQS82)  /*@bf@*/
#define IRC0_IRQS2_IRQS83	(IRC0.unIRQS2.stcField.u1IRQS83)  /*@bf@*/
#define IRC0_IRQS2_IRQS84	(IRC0.unIRQS2.stcField.u1IRQS84)  /*@bf@*/
#define IRC0_IRQS2_IRQS85	(IRC0.unIRQS2.stcField.u1IRQS85)  /*@bf@*/
#define IRC0_IRQS2_IRQS86	(IRC0.unIRQS2.stcField.u1IRQS86)  /*@bf@*/
#define IRC0_IRQS2_IRQS87	(IRC0.unIRQS2.stcField.u1IRQS87)  /*@bf@*/
#define IRC0_IRQS2_IRQS88	(IRC0.unIRQS2.stcField.u1IRQS88)  /*@bf@*/
#define IRC0_IRQS2_IRQS89	(IRC0.unIRQS2.stcField.u1IRQS89)  /*@bf@*/
#define IRC0_IRQS2_IRQS90	(IRC0.unIRQS2.stcField.u1IRQS90)  /*@bf@*/
#define IRC0_IRQS2_IRQS91	(IRC0.unIRQS2.stcField.u1IRQS91)  /*@bf@*/
#define IRC0_IRQS2_IRQS92	(IRC0.unIRQS2.stcField.u1IRQS92)  /*@bf@*/
#define IRC0_IRQS2_IRQS93	(IRC0.unIRQS2.stcField.u1IRQS93)  /*@bf@*/
#define IRC0_IRQS2_IRQS94	(IRC0.unIRQS2.stcField.u1IRQS94)  /*@bf@*/
#define IRC0_IRQS2_IRQS95	(IRC0.unIRQS2.stcField.u1IRQS95)  /*@bf@*/

typedef struct stc_irc0_irqs2_field{
    uint_io32_t		u1IRQS64:1;
    uint_io32_t		u1IRQS65:1;
    uint_io32_t		u1IRQS66:1;
    uint_io32_t		u1IRQS67:1;
    uint_io32_t		u1IRQS68:1;
    uint_io32_t		u1IRQS69:1;
    uint_io32_t		u1IRQS70:1;
    uint_io32_t		u1IRQS71:1;
    uint_io32_t		u1IRQS72:1;
    uint_io32_t		u1IRQS73:1;
    uint_io32_t		u1IRQS74:1;
    uint_io32_t		u1IRQS75:1;
    uint_io32_t		u1IRQS76:1;
    uint_io32_t		u1IRQS77:1;
    uint_io32_t		u1IRQS78:1;
    uint_io32_t		u1IRQS79:1;
    uint_io32_t		u1IRQS80:1;
    uint_io32_t		u1IRQS81:1;
    uint_io32_t		u1IRQS82:1;
    uint_io32_t		u1IRQS83:1;
    uint_io32_t		u1IRQS84:1;
    uint_io32_t		u1IRQS85:1;
    uint_io32_t		u1IRQS86:1;
    uint_io32_t		u1IRQS87:1;
    uint_io32_t		u1IRQS88:1;
    uint_io32_t		u1IRQS89:1;
    uint_io32_t		u1IRQS90:1;
    uint_io32_t		u1IRQS91:1;
    uint_io32_t		u1IRQS92:1;
    uint_io32_t		u1IRQS93:1;
    uint_io32_t		u1IRQS94:1;
    uint_io32_t		u1IRQS95:1;
}stc_irc0_irqs2_field_t;

typedef union un_irc0_irqs2{
    uint_io32_t		u32Register;
    stc_irc0_irqs2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs2_t;

/* IRQS3 */
#define IRC0_IRQS3	(IRC0.unIRQS3.u32Register)  /*@rg@*/
#define IRC0_IRQS3_IRQS96	(IRC0.unIRQS3.stcField.u1IRQS96)  /*@bf@*/
#define IRC0_IRQS3_IRQS97	(IRC0.unIRQS3.stcField.u1IRQS97)  /*@bf@*/
#define IRC0_IRQS3_IRQS98	(IRC0.unIRQS3.stcField.u1IRQS98)  /*@bf@*/
#define IRC0_IRQS3_IRQS99	(IRC0.unIRQS3.stcField.u1IRQS99)  /*@bf@*/
#define IRC0_IRQS3_IRQS100	(IRC0.unIRQS3.stcField.u1IRQS100)  /*@bf@*/
#define IRC0_IRQS3_IRQS101	(IRC0.unIRQS3.stcField.u1IRQS101)  /*@bf@*/
#define IRC0_IRQS3_IRQS102	(IRC0.unIRQS3.stcField.u1IRQS102)  /*@bf@*/
#define IRC0_IRQS3_IRQS103	(IRC0.unIRQS3.stcField.u1IRQS103)  /*@bf@*/
#define IRC0_IRQS3_IRQS104	(IRC0.unIRQS3.stcField.u1IRQS104)  /*@bf@*/
#define IRC0_IRQS3_IRQS105	(IRC0.unIRQS3.stcField.u1IRQS105)  /*@bf@*/
#define IRC0_IRQS3_IRQS106	(IRC0.unIRQS3.stcField.u1IRQS106)  /*@bf@*/
#define IRC0_IRQS3_IRQS107	(IRC0.unIRQS3.stcField.u1IRQS107)  /*@bf@*/
#define IRC0_IRQS3_IRQS108	(IRC0.unIRQS3.stcField.u1IRQS108)  /*@bf@*/
#define IRC0_IRQS3_IRQS109	(IRC0.unIRQS3.stcField.u1IRQS109)  /*@bf@*/
#define IRC0_IRQS3_IRQS110	(IRC0.unIRQS3.stcField.u1IRQS110)  /*@bf@*/
#define IRC0_IRQS3_IRQS111	(IRC0.unIRQS3.stcField.u1IRQS111)  /*@bf@*/
#define IRC0_IRQS3_IRQS112	(IRC0.unIRQS3.stcField.u1IRQS112)  /*@bf@*/
#define IRC0_IRQS3_IRQS113	(IRC0.unIRQS3.stcField.u1IRQS113)  /*@bf@*/
#define IRC0_IRQS3_IRQS114	(IRC0.unIRQS3.stcField.u1IRQS114)  /*@bf@*/
#define IRC0_IRQS3_IRQS115	(IRC0.unIRQS3.stcField.u1IRQS115)  /*@bf@*/
#define IRC0_IRQS3_IRQS116	(IRC0.unIRQS3.stcField.u1IRQS116)  /*@bf@*/
#define IRC0_IRQS3_IRQS117	(IRC0.unIRQS3.stcField.u1IRQS117)  /*@bf@*/
#define IRC0_IRQS3_IRQS118	(IRC0.unIRQS3.stcField.u1IRQS118)  /*@bf@*/
#define IRC0_IRQS3_IRQS119	(IRC0.unIRQS3.stcField.u1IRQS119)  /*@bf@*/
#define IRC0_IRQS3_IRQS120	(IRC0.unIRQS3.stcField.u1IRQS120)  /*@bf@*/
#define IRC0_IRQS3_IRQS121	(IRC0.unIRQS3.stcField.u1IRQS121)  /*@bf@*/
#define IRC0_IRQS3_IRQS122	(IRC0.unIRQS3.stcField.u1IRQS122)  /*@bf@*/
#define IRC0_IRQS3_IRQS123	(IRC0.unIRQS3.stcField.u1IRQS123)  /*@bf@*/
#define IRC0_IRQS3_IRQS124	(IRC0.unIRQS3.stcField.u1IRQS124)  /*@bf@*/
#define IRC0_IRQS3_IRQS125	(IRC0.unIRQS3.stcField.u1IRQS125)  /*@bf@*/
#define IRC0_IRQS3_IRQS126	(IRC0.unIRQS3.stcField.u1IRQS126)  /*@bf@*/
#define IRC0_IRQS3_IRQS127	(IRC0.unIRQS3.stcField.u1IRQS127)  /*@bf@*/

typedef struct stc_irc0_irqs3_field{
    uint_io32_t		u1IRQS96:1;
    uint_io32_t		u1IRQS97:1;
    uint_io32_t		u1IRQS98:1;
    uint_io32_t		u1IRQS99:1;
    uint_io32_t		u1IRQS100:1;
    uint_io32_t		u1IRQS101:1;
    uint_io32_t		u1IRQS102:1;
    uint_io32_t		u1IRQS103:1;
    uint_io32_t		u1IRQS104:1;
    uint_io32_t		u1IRQS105:1;
    uint_io32_t		u1IRQS106:1;
    uint_io32_t		u1IRQS107:1;
    uint_io32_t		u1IRQS108:1;
    uint_io32_t		u1IRQS109:1;
    uint_io32_t		u1IRQS110:1;
    uint_io32_t		u1IRQS111:1;
    uint_io32_t		u1IRQS112:1;
    uint_io32_t		u1IRQS113:1;
    uint_io32_t		u1IRQS114:1;
    uint_io32_t		u1IRQS115:1;
    uint_io32_t		u1IRQS116:1;
    uint_io32_t		u1IRQS117:1;
    uint_io32_t		u1IRQS118:1;
    uint_io32_t		u1IRQS119:1;
    uint_io32_t		u1IRQS120:1;
    uint_io32_t		u1IRQS121:1;
    uint_io32_t		u1IRQS122:1;
    uint_io32_t		u1IRQS123:1;
    uint_io32_t		u1IRQS124:1;
    uint_io32_t		u1IRQS125:1;
    uint_io32_t		u1IRQS126:1;
    uint_io32_t		u1IRQS127:1;
}stc_irc0_irqs3_field_t;

typedef union un_irc0_irqs3{
    uint_io32_t		u32Register;
    stc_irc0_irqs3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs3_t;

/* IRQS4 */
#define IRC0_IRQS4	(IRC0.unIRQS4.u32Register)  /*@rg@*/
#define IRC0_IRQS4_IRQS128	(IRC0.unIRQS4.stcField.u1IRQS128)  /*@bf@*/
#define IRC0_IRQS4_IRQS129	(IRC0.unIRQS4.stcField.u1IRQS129)  /*@bf@*/
#define IRC0_IRQS4_IRQS130	(IRC0.unIRQS4.stcField.u1IRQS130)  /*@bf@*/
#define IRC0_IRQS4_IRQS131	(IRC0.unIRQS4.stcField.u1IRQS131)  /*@bf@*/
#define IRC0_IRQS4_IRQS132	(IRC0.unIRQS4.stcField.u1IRQS132)  /*@bf@*/
#define IRC0_IRQS4_IRQS133	(IRC0.unIRQS4.stcField.u1IRQS133)  /*@bf@*/
#define IRC0_IRQS4_IRQS134	(IRC0.unIRQS4.stcField.u1IRQS134)  /*@bf@*/
#define IRC0_IRQS4_IRQS135	(IRC0.unIRQS4.stcField.u1IRQS135)  /*@bf@*/
#define IRC0_IRQS4_IRQS136	(IRC0.unIRQS4.stcField.u1IRQS136)  /*@bf@*/
#define IRC0_IRQS4_IRQS137	(IRC0.unIRQS4.stcField.u1IRQS137)  /*@bf@*/
#define IRC0_IRQS4_IRQS138	(IRC0.unIRQS4.stcField.u1IRQS138)  /*@bf@*/
#define IRC0_IRQS4_IRQS139	(IRC0.unIRQS4.stcField.u1IRQS139)  /*@bf@*/
#define IRC0_IRQS4_IRQS140	(IRC0.unIRQS4.stcField.u1IRQS140)  /*@bf@*/
#define IRC0_IRQS4_IRQS141	(IRC0.unIRQS4.stcField.u1IRQS141)  /*@bf@*/
#define IRC0_IRQS4_IRQS142	(IRC0.unIRQS4.stcField.u1IRQS142)  /*@bf@*/
#define IRC0_IRQS4_IRQS143	(IRC0.unIRQS4.stcField.u1IRQS143)  /*@bf@*/
#define IRC0_IRQS4_IRQS144	(IRC0.unIRQS4.stcField.u1IRQS144)  /*@bf@*/
#define IRC0_IRQS4_IRQS145	(IRC0.unIRQS4.stcField.u1IRQS145)  /*@bf@*/
#define IRC0_IRQS4_IRQS146	(IRC0.unIRQS4.stcField.u1IRQS146)  /*@bf@*/
#define IRC0_IRQS4_IRQS147	(IRC0.unIRQS4.stcField.u1IRQS147)  /*@bf@*/
#define IRC0_IRQS4_IRQS148	(IRC0.unIRQS4.stcField.u1IRQS148)  /*@bf@*/
#define IRC0_IRQS4_IRQS149	(IRC0.unIRQS4.stcField.u1IRQS149)  /*@bf@*/
#define IRC0_IRQS4_IRQS150	(IRC0.unIRQS4.stcField.u1IRQS150)  /*@bf@*/
#define IRC0_IRQS4_IRQS151	(IRC0.unIRQS4.stcField.u1IRQS151)  /*@bf@*/
#define IRC0_IRQS4_IRQS152	(IRC0.unIRQS4.stcField.u1IRQS152)  /*@bf@*/
#define IRC0_IRQS4_IRQS153	(IRC0.unIRQS4.stcField.u1IRQS153)  /*@bf@*/
#define IRC0_IRQS4_IRQS154	(IRC0.unIRQS4.stcField.u1IRQS154)  /*@bf@*/
#define IRC0_IRQS4_IRQS155	(IRC0.unIRQS4.stcField.u1IRQS155)  /*@bf@*/
#define IRC0_IRQS4_IRQS156	(IRC0.unIRQS4.stcField.u1IRQS156)  /*@bf@*/
#define IRC0_IRQS4_IRQS157	(IRC0.unIRQS4.stcField.u1IRQS157)  /*@bf@*/
#define IRC0_IRQS4_IRQS158	(IRC0.unIRQS4.stcField.u1IRQS158)  /*@bf@*/
#define IRC0_IRQS4_IRQS159	(IRC0.unIRQS4.stcField.u1IRQS159)  /*@bf@*/

typedef struct stc_irc0_irqs4_field{
    uint_io32_t		u1IRQS128:1;
    uint_io32_t		u1IRQS129:1;
    uint_io32_t		u1IRQS130:1;
    uint_io32_t		u1IRQS131:1;
    uint_io32_t		u1IRQS132:1;
    uint_io32_t		u1IRQS133:1;
    uint_io32_t		u1IRQS134:1;
    uint_io32_t		u1IRQS135:1;
    uint_io32_t		u1IRQS136:1;
    uint_io32_t		u1IRQS137:1;
    uint_io32_t		u1IRQS138:1;
    uint_io32_t		u1IRQS139:1;
    uint_io32_t		u1IRQS140:1;
    uint_io32_t		u1IRQS141:1;
    uint_io32_t		u1IRQS142:1;
    uint_io32_t		u1IRQS143:1;
    uint_io32_t		u1IRQS144:1;
    uint_io32_t		u1IRQS145:1;
    uint_io32_t		u1IRQS146:1;
    uint_io32_t		u1IRQS147:1;
    uint_io32_t		u1IRQS148:1;
    uint_io32_t		u1IRQS149:1;
    uint_io32_t		u1IRQS150:1;
    uint_io32_t		u1IRQS151:1;
    uint_io32_t		u1IRQS152:1;
    uint_io32_t		u1IRQS153:1;
    uint_io32_t		u1IRQS154:1;
    uint_io32_t		u1IRQS155:1;
    uint_io32_t		u1IRQS156:1;
    uint_io32_t		u1IRQS157:1;
    uint_io32_t		u1IRQS158:1;
    uint_io32_t		u1IRQS159:1;
}stc_irc0_irqs4_field_t;

typedef union un_irc0_irqs4{
    uint_io32_t		u32Register;
    stc_irc0_irqs4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs4_t;

/* IRQS5 */
#define IRC0_IRQS5	(IRC0.unIRQS5.u32Register)  /*@rg@*/
#define IRC0_IRQS5_IRQS160	(IRC0.unIRQS5.stcField.u1IRQS160)  /*@bf@*/
#define IRC0_IRQS5_IRQS161	(IRC0.unIRQS5.stcField.u1IRQS161)  /*@bf@*/
#define IRC0_IRQS5_IRQS162	(IRC0.unIRQS5.stcField.u1IRQS162)  /*@bf@*/
#define IRC0_IRQS5_IRQS163	(IRC0.unIRQS5.stcField.u1IRQS163)  /*@bf@*/
#define IRC0_IRQS5_IRQS164	(IRC0.unIRQS5.stcField.u1IRQS164)  /*@bf@*/
#define IRC0_IRQS5_IRQS165	(IRC0.unIRQS5.stcField.u1IRQS165)  /*@bf@*/
#define IRC0_IRQS5_IRQS166	(IRC0.unIRQS5.stcField.u1IRQS166)  /*@bf@*/
#define IRC0_IRQS5_IRQS167	(IRC0.unIRQS5.stcField.u1IRQS167)  /*@bf@*/
#define IRC0_IRQS5_IRQS168	(IRC0.unIRQS5.stcField.u1IRQS168)  /*@bf@*/
#define IRC0_IRQS5_IRQS169	(IRC0.unIRQS5.stcField.u1IRQS169)  /*@bf@*/
#define IRC0_IRQS5_IRQS170	(IRC0.unIRQS5.stcField.u1IRQS170)  /*@bf@*/
#define IRC0_IRQS5_IRQS171	(IRC0.unIRQS5.stcField.u1IRQS171)  /*@bf@*/
#define IRC0_IRQS5_IRQS172	(IRC0.unIRQS5.stcField.u1IRQS172)  /*@bf@*/
#define IRC0_IRQS5_IRQS173	(IRC0.unIRQS5.stcField.u1IRQS173)  /*@bf@*/
#define IRC0_IRQS5_IRQS174	(IRC0.unIRQS5.stcField.u1IRQS174)  /*@bf@*/
#define IRC0_IRQS5_IRQS175	(IRC0.unIRQS5.stcField.u1IRQS175)  /*@bf@*/
#define IRC0_IRQS5_IRQS176	(IRC0.unIRQS5.stcField.u1IRQS176)  /*@bf@*/
#define IRC0_IRQS5_IRQS177	(IRC0.unIRQS5.stcField.u1IRQS177)  /*@bf@*/
#define IRC0_IRQS5_IRQS178	(IRC0.unIRQS5.stcField.u1IRQS178)  /*@bf@*/
#define IRC0_IRQS5_IRQS179	(IRC0.unIRQS5.stcField.u1IRQS179)  /*@bf@*/
#define IRC0_IRQS5_IRQS180	(IRC0.unIRQS5.stcField.u1IRQS180)  /*@bf@*/
#define IRC0_IRQS5_IRQS181	(IRC0.unIRQS5.stcField.u1IRQS181)  /*@bf@*/
#define IRC0_IRQS5_IRQS182	(IRC0.unIRQS5.stcField.u1IRQS182)  /*@bf@*/
#define IRC0_IRQS5_IRQS183	(IRC0.unIRQS5.stcField.u1IRQS183)  /*@bf@*/
#define IRC0_IRQS5_IRQS184	(IRC0.unIRQS5.stcField.u1IRQS184)  /*@bf@*/
#define IRC0_IRQS5_IRQS185	(IRC0.unIRQS5.stcField.u1IRQS185)  /*@bf@*/
#define IRC0_IRQS5_IRQS186	(IRC0.unIRQS5.stcField.u1IRQS186)  /*@bf@*/
#define IRC0_IRQS5_IRQS187	(IRC0.unIRQS5.stcField.u1IRQS187)  /*@bf@*/
#define IRC0_IRQS5_IRQS188	(IRC0.unIRQS5.stcField.u1IRQS188)  /*@bf@*/
#define IRC0_IRQS5_IRQS189	(IRC0.unIRQS5.stcField.u1IRQS189)  /*@bf@*/
#define IRC0_IRQS5_IRQS190	(IRC0.unIRQS5.stcField.u1IRQS190)  /*@bf@*/
#define IRC0_IRQS5_IRQS191	(IRC0.unIRQS5.stcField.u1IRQS191)  /*@bf@*/

typedef struct stc_irc0_irqs5_field{
    uint_io32_t		u1IRQS160:1;
    uint_io32_t		u1IRQS161:1;
    uint_io32_t		u1IRQS162:1;
    uint_io32_t		u1IRQS163:1;
    uint_io32_t		u1IRQS164:1;
    uint_io32_t		u1IRQS165:1;
    uint_io32_t		u1IRQS166:1;
    uint_io32_t		u1IRQS167:1;
    uint_io32_t		u1IRQS168:1;
    uint_io32_t		u1IRQS169:1;
    uint_io32_t		u1IRQS170:1;
    uint_io32_t		u1IRQS171:1;
    uint_io32_t		u1IRQS172:1;
    uint_io32_t		u1IRQS173:1;
    uint_io32_t		u1IRQS174:1;
    uint_io32_t		u1IRQS175:1;
    uint_io32_t		u1IRQS176:1;
    uint_io32_t		u1IRQS177:1;
    uint_io32_t		u1IRQS178:1;
    uint_io32_t		u1IRQS179:1;
    uint_io32_t		u1IRQS180:1;
    uint_io32_t		u1IRQS181:1;
    uint_io32_t		u1IRQS182:1;
    uint_io32_t		u1IRQS183:1;
    uint_io32_t		u1IRQS184:1;
    uint_io32_t		u1IRQS185:1;
    uint_io32_t		u1IRQS186:1;
    uint_io32_t		u1IRQS187:1;
    uint_io32_t		u1IRQS188:1;
    uint_io32_t		u1IRQS189:1;
    uint_io32_t		u1IRQS190:1;
    uint_io32_t		u1IRQS191:1;
}stc_irc0_irqs5_field_t;

typedef union un_irc0_irqs5{
    uint_io32_t		u32Register;
    stc_irc0_irqs5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs5_t;

/* IRQS6 */
#define IRC0_IRQS6	(IRC0.unIRQS6.u32Register)  /*@rg@*/
#define IRC0_IRQS6_IRQS192	(IRC0.unIRQS6.stcField.u1IRQS192)  /*@bf@*/
#define IRC0_IRQS6_IRQS193	(IRC0.unIRQS6.stcField.u1IRQS193)  /*@bf@*/
#define IRC0_IRQS6_IRQS194	(IRC0.unIRQS6.stcField.u1IRQS194)  /*@bf@*/
#define IRC0_IRQS6_IRQS195	(IRC0.unIRQS6.stcField.u1IRQS195)  /*@bf@*/
#define IRC0_IRQS6_IRQS196	(IRC0.unIRQS6.stcField.u1IRQS196)  /*@bf@*/
#define IRC0_IRQS6_IRQS197	(IRC0.unIRQS6.stcField.u1IRQS197)  /*@bf@*/
#define IRC0_IRQS6_IRQS198	(IRC0.unIRQS6.stcField.u1IRQS198)  /*@bf@*/
#define IRC0_IRQS6_IRQS199	(IRC0.unIRQS6.stcField.u1IRQS199)  /*@bf@*/
#define IRC0_IRQS6_IRQS200	(IRC0.unIRQS6.stcField.u1IRQS200)  /*@bf@*/
#define IRC0_IRQS6_IRQS201	(IRC0.unIRQS6.stcField.u1IRQS201)  /*@bf@*/
#define IRC0_IRQS6_IRQS202	(IRC0.unIRQS6.stcField.u1IRQS202)  /*@bf@*/
#define IRC0_IRQS6_IRQS203	(IRC0.unIRQS6.stcField.u1IRQS203)  /*@bf@*/
#define IRC0_IRQS6_IRQS204	(IRC0.unIRQS6.stcField.u1IRQS204)  /*@bf@*/
#define IRC0_IRQS6_IRQS205	(IRC0.unIRQS6.stcField.u1IRQS205)  /*@bf@*/
#define IRC0_IRQS6_IRQS206	(IRC0.unIRQS6.stcField.u1IRQS206)  /*@bf@*/
#define IRC0_IRQS6_IRQS207	(IRC0.unIRQS6.stcField.u1IRQS207)  /*@bf@*/
#define IRC0_IRQS6_IRQS208	(IRC0.unIRQS6.stcField.u1IRQS208)  /*@bf@*/
#define IRC0_IRQS6_IRQS209	(IRC0.unIRQS6.stcField.u1IRQS209)  /*@bf@*/
#define IRC0_IRQS6_IRQS210	(IRC0.unIRQS6.stcField.u1IRQS210)  /*@bf@*/
#define IRC0_IRQS6_IRQS211	(IRC0.unIRQS6.stcField.u1IRQS211)  /*@bf@*/
#define IRC0_IRQS6_IRQS212	(IRC0.unIRQS6.stcField.u1IRQS212)  /*@bf@*/
#define IRC0_IRQS6_IRQS213	(IRC0.unIRQS6.stcField.u1IRQS213)  /*@bf@*/
#define IRC0_IRQS6_IRQS214	(IRC0.unIRQS6.stcField.u1IRQS214)  /*@bf@*/
#define IRC0_IRQS6_IRQS215	(IRC0.unIRQS6.stcField.u1IRQS215)  /*@bf@*/
#define IRC0_IRQS6_IRQS216	(IRC0.unIRQS6.stcField.u1IRQS216)  /*@bf@*/
#define IRC0_IRQS6_IRQS217	(IRC0.unIRQS6.stcField.u1IRQS217)  /*@bf@*/
#define IRC0_IRQS6_IRQS218	(IRC0.unIRQS6.stcField.u1IRQS218)  /*@bf@*/
#define IRC0_IRQS6_IRQS219	(IRC0.unIRQS6.stcField.u1IRQS219)  /*@bf@*/
#define IRC0_IRQS6_IRQS220	(IRC0.unIRQS6.stcField.u1IRQS220)  /*@bf@*/
#define IRC0_IRQS6_IRQS221	(IRC0.unIRQS6.stcField.u1IRQS221)  /*@bf@*/
#define IRC0_IRQS6_IRQS222	(IRC0.unIRQS6.stcField.u1IRQS222)  /*@bf@*/
#define IRC0_IRQS6_IRQS223	(IRC0.unIRQS6.stcField.u1IRQS223)  /*@bf@*/

typedef struct stc_irc0_irqs6_field{
    uint_io32_t		u1IRQS192:1;
    uint_io32_t		u1IRQS193:1;
    uint_io32_t		u1IRQS194:1;
    uint_io32_t		u1IRQS195:1;
    uint_io32_t		u1IRQS196:1;
    uint_io32_t		u1IRQS197:1;
    uint_io32_t		u1IRQS198:1;
    uint_io32_t		u1IRQS199:1;
    uint_io32_t		u1IRQS200:1;
    uint_io32_t		u1IRQS201:1;
    uint_io32_t		u1IRQS202:1;
    uint_io32_t		u1IRQS203:1;
    uint_io32_t		u1IRQS204:1;
    uint_io32_t		u1IRQS205:1;
    uint_io32_t		u1IRQS206:1;
    uint_io32_t		u1IRQS207:1;
    uint_io32_t		u1IRQS208:1;
    uint_io32_t		u1IRQS209:1;
    uint_io32_t		u1IRQS210:1;
    uint_io32_t		u1IRQS211:1;
    uint_io32_t		u1IRQS212:1;
    uint_io32_t		u1IRQS213:1;
    uint_io32_t		u1IRQS214:1;
    uint_io32_t		u1IRQS215:1;
    uint_io32_t		u1IRQS216:1;
    uint_io32_t		u1IRQS217:1;
    uint_io32_t		u1IRQS218:1;
    uint_io32_t		u1IRQS219:1;
    uint_io32_t		u1IRQS220:1;
    uint_io32_t		u1IRQS221:1;
    uint_io32_t		u1IRQS222:1;
    uint_io32_t		u1IRQS223:1;
}stc_irc0_irqs6_field_t;

typedef union un_irc0_irqs6{
    uint_io32_t		u32Register;
    stc_irc0_irqs6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs6_t;

/* IRQS7 */
#define IRC0_IRQS7	(IRC0.unIRQS7.u32Register)  /*@rg@*/
#define IRC0_IRQS7_IRQS224	(IRC0.unIRQS7.stcField.u1IRQS224)  /*@bf@*/
#define IRC0_IRQS7_IRQS225	(IRC0.unIRQS7.stcField.u1IRQS225)  /*@bf@*/
#define IRC0_IRQS7_IRQS226	(IRC0.unIRQS7.stcField.u1IRQS226)  /*@bf@*/
#define IRC0_IRQS7_IRQS227	(IRC0.unIRQS7.stcField.u1IRQS227)  /*@bf@*/
#define IRC0_IRQS7_IRQS228	(IRC0.unIRQS7.stcField.u1IRQS228)  /*@bf@*/
#define IRC0_IRQS7_IRQS229	(IRC0.unIRQS7.stcField.u1IRQS229)  /*@bf@*/
#define IRC0_IRQS7_IRQS230	(IRC0.unIRQS7.stcField.u1IRQS230)  /*@bf@*/
#define IRC0_IRQS7_IRQS231	(IRC0.unIRQS7.stcField.u1IRQS231)  /*@bf@*/
#define IRC0_IRQS7_IRQS232	(IRC0.unIRQS7.stcField.u1IRQS232)  /*@bf@*/
#define IRC0_IRQS7_IRQS233	(IRC0.unIRQS7.stcField.u1IRQS233)  /*@bf@*/
#define IRC0_IRQS7_IRQS234	(IRC0.unIRQS7.stcField.u1IRQS234)  /*@bf@*/
#define IRC0_IRQS7_IRQS235	(IRC0.unIRQS7.stcField.u1IRQS235)  /*@bf@*/
#define IRC0_IRQS7_IRQS236	(IRC0.unIRQS7.stcField.u1IRQS236)  /*@bf@*/
#define IRC0_IRQS7_IRQS237	(IRC0.unIRQS7.stcField.u1IRQS237)  /*@bf@*/
#define IRC0_IRQS7_IRQS238	(IRC0.unIRQS7.stcField.u1IRQS238)  /*@bf@*/
#define IRC0_IRQS7_IRQS239	(IRC0.unIRQS7.stcField.u1IRQS239)  /*@bf@*/
#define IRC0_IRQS7_IRQS240	(IRC0.unIRQS7.stcField.u1IRQS240)  /*@bf@*/
#define IRC0_IRQS7_IRQS241	(IRC0.unIRQS7.stcField.u1IRQS241)  /*@bf@*/
#define IRC0_IRQS7_IRQS242	(IRC0.unIRQS7.stcField.u1IRQS242)  /*@bf@*/
#define IRC0_IRQS7_IRQS243	(IRC0.unIRQS7.stcField.u1IRQS243)  /*@bf@*/
#define IRC0_IRQS7_IRQS244	(IRC0.unIRQS7.stcField.u1IRQS244)  /*@bf@*/
#define IRC0_IRQS7_IRQS245	(IRC0.unIRQS7.stcField.u1IRQS245)  /*@bf@*/
#define IRC0_IRQS7_IRQS246	(IRC0.unIRQS7.stcField.u1IRQS246)  /*@bf@*/
#define IRC0_IRQS7_IRQS247	(IRC0.unIRQS7.stcField.u1IRQS247)  /*@bf@*/
#define IRC0_IRQS7_IRQS248	(IRC0.unIRQS7.stcField.u1IRQS248)  /*@bf@*/
#define IRC0_IRQS7_IRQS249	(IRC0.unIRQS7.stcField.u1IRQS249)  /*@bf@*/
#define IRC0_IRQS7_IRQS250	(IRC0.unIRQS7.stcField.u1IRQS250)  /*@bf@*/
#define IRC0_IRQS7_IRQS251	(IRC0.unIRQS7.stcField.u1IRQS251)  /*@bf@*/
#define IRC0_IRQS7_IRQS252	(IRC0.unIRQS7.stcField.u1IRQS252)  /*@bf@*/
#define IRC0_IRQS7_IRQS253	(IRC0.unIRQS7.stcField.u1IRQS253)  /*@bf@*/
#define IRC0_IRQS7_IRQS254	(IRC0.unIRQS7.stcField.u1IRQS254)  /*@bf@*/
#define IRC0_IRQS7_IRQS255	(IRC0.unIRQS7.stcField.u1IRQS255)  /*@bf@*/

typedef struct stc_irc0_irqs7_field{
    uint_io32_t		u1IRQS224:1;
    uint_io32_t		u1IRQS225:1;
    uint_io32_t		u1IRQS226:1;
    uint_io32_t		u1IRQS227:1;
    uint_io32_t		u1IRQS228:1;
    uint_io32_t		u1IRQS229:1;
    uint_io32_t		u1IRQS230:1;
    uint_io32_t		u1IRQS231:1;
    uint_io32_t		u1IRQS232:1;
    uint_io32_t		u1IRQS233:1;
    uint_io32_t		u1IRQS234:1;
    uint_io32_t		u1IRQS235:1;
    uint_io32_t		u1IRQS236:1;
    uint_io32_t		u1IRQS237:1;
    uint_io32_t		u1IRQS238:1;
    uint_io32_t		u1IRQS239:1;
    uint_io32_t		u1IRQS240:1;
    uint_io32_t		u1IRQS241:1;
    uint_io32_t		u1IRQS242:1;
    uint_io32_t		u1IRQS243:1;
    uint_io32_t		u1IRQS244:1;
    uint_io32_t		u1IRQS245:1;
    uint_io32_t		u1IRQS246:1;
    uint_io32_t		u1IRQS247:1;
    uint_io32_t		u1IRQS248:1;
    uint_io32_t		u1IRQS249:1;
    uint_io32_t		u1IRQS250:1;
    uint_io32_t		u1IRQS251:1;
    uint_io32_t		u1IRQS252:1;
    uint_io32_t		u1IRQS253:1;
    uint_io32_t		u1IRQS254:1;
    uint_io32_t		u1IRQS255:1;
}stc_irc0_irqs7_field_t;

typedef union un_irc0_irqs7{
    uint_io32_t		u32Register;
    stc_irc0_irqs7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs7_t;

/* IRQS8 */
#define IRC0_IRQS8	(IRC0.unIRQS8.u32Register)  /*@rg@*/
#define IRC0_IRQS8_IRQS256	(IRC0.unIRQS8.stcField.u1IRQS256)  /*@bf@*/
#define IRC0_IRQS8_IRQS257	(IRC0.unIRQS8.stcField.u1IRQS257)  /*@bf@*/
#define IRC0_IRQS8_IRQS258	(IRC0.unIRQS8.stcField.u1IRQS258)  /*@bf@*/
#define IRC0_IRQS8_IRQS259	(IRC0.unIRQS8.stcField.u1IRQS259)  /*@bf@*/
#define IRC0_IRQS8_IRQS260	(IRC0.unIRQS8.stcField.u1IRQS260)  /*@bf@*/
#define IRC0_IRQS8_IRQS261	(IRC0.unIRQS8.stcField.u1IRQS261)  /*@bf@*/
#define IRC0_IRQS8_IRQS262	(IRC0.unIRQS8.stcField.u1IRQS262)  /*@bf@*/
#define IRC0_IRQS8_IRQS263	(IRC0.unIRQS8.stcField.u1IRQS263)  /*@bf@*/
#define IRC0_IRQS8_IRQS264	(IRC0.unIRQS8.stcField.u1IRQS264)  /*@bf@*/
#define IRC0_IRQS8_IRQS265	(IRC0.unIRQS8.stcField.u1IRQS265)  /*@bf@*/
#define IRC0_IRQS8_IRQS266	(IRC0.unIRQS8.stcField.u1IRQS266)  /*@bf@*/
#define IRC0_IRQS8_IRQS267	(IRC0.unIRQS8.stcField.u1IRQS267)  /*@bf@*/
#define IRC0_IRQS8_IRQS268	(IRC0.unIRQS8.stcField.u1IRQS268)  /*@bf@*/
#define IRC0_IRQS8_IRQS269	(IRC0.unIRQS8.stcField.u1IRQS269)  /*@bf@*/
#define IRC0_IRQS8_IRQS270	(IRC0.unIRQS8.stcField.u1IRQS270)  /*@bf@*/
#define IRC0_IRQS8_IRQS271	(IRC0.unIRQS8.stcField.u1IRQS271)  /*@bf@*/
#define IRC0_IRQS8_IRQS272	(IRC0.unIRQS8.stcField.u1IRQS272)  /*@bf@*/
#define IRC0_IRQS8_IRQS273	(IRC0.unIRQS8.stcField.u1IRQS273)  /*@bf@*/
#define IRC0_IRQS8_IRQS274	(IRC0.unIRQS8.stcField.u1IRQS274)  /*@bf@*/
#define IRC0_IRQS8_IRQS275	(IRC0.unIRQS8.stcField.u1IRQS275)  /*@bf@*/
#define IRC0_IRQS8_IRQS276	(IRC0.unIRQS8.stcField.u1IRQS276)  /*@bf@*/
#define IRC0_IRQS8_IRQS277	(IRC0.unIRQS8.stcField.u1IRQS277)  /*@bf@*/
#define IRC0_IRQS8_IRQS278	(IRC0.unIRQS8.stcField.u1IRQS278)  /*@bf@*/
#define IRC0_IRQS8_IRQS279	(IRC0.unIRQS8.stcField.u1IRQS279)  /*@bf@*/
#define IRC0_IRQS8_IRQS280	(IRC0.unIRQS8.stcField.u1IRQS280)  /*@bf@*/
#define IRC0_IRQS8_IRQS281	(IRC0.unIRQS8.stcField.u1IRQS281)  /*@bf@*/
#define IRC0_IRQS8_IRQS282	(IRC0.unIRQS8.stcField.u1IRQS282)  /*@bf@*/
#define IRC0_IRQS8_IRQS283	(IRC0.unIRQS8.stcField.u1IRQS283)  /*@bf@*/
#define IRC0_IRQS8_IRQS284	(IRC0.unIRQS8.stcField.u1IRQS284)  /*@bf@*/
#define IRC0_IRQS8_IRQS285	(IRC0.unIRQS8.stcField.u1IRQS285)  /*@bf@*/
#define IRC0_IRQS8_IRQS286	(IRC0.unIRQS8.stcField.u1IRQS286)  /*@bf@*/
#define IRC0_IRQS8_IRQS287	(IRC0.unIRQS8.stcField.u1IRQS287)  /*@bf@*/

typedef struct stc_irc0_irqs8_field{
    uint_io32_t		u1IRQS256:1;
    uint_io32_t		u1IRQS257:1;
    uint_io32_t		u1IRQS258:1;
    uint_io32_t		u1IRQS259:1;
    uint_io32_t		u1IRQS260:1;
    uint_io32_t		u1IRQS261:1;
    uint_io32_t		u1IRQS262:1;
    uint_io32_t		u1IRQS263:1;
    uint_io32_t		u1IRQS264:1;
    uint_io32_t		u1IRQS265:1;
    uint_io32_t		u1IRQS266:1;
    uint_io32_t		u1IRQS267:1;
    uint_io32_t		u1IRQS268:1;
    uint_io32_t		u1IRQS269:1;
    uint_io32_t		u1IRQS270:1;
    uint_io32_t		u1IRQS271:1;
    uint_io32_t		u1IRQS272:1;
    uint_io32_t		u1IRQS273:1;
    uint_io32_t		u1IRQS274:1;
    uint_io32_t		u1IRQS275:1;
    uint_io32_t		u1IRQS276:1;
    uint_io32_t		u1IRQS277:1;
    uint_io32_t		u1IRQS278:1;
    uint_io32_t		u1IRQS279:1;
    uint_io32_t		u1IRQS280:1;
    uint_io32_t		u1IRQS281:1;
    uint_io32_t		u1IRQS282:1;
    uint_io32_t		u1IRQS283:1;
    uint_io32_t		u1IRQS284:1;
    uint_io32_t		u1IRQS285:1;
    uint_io32_t		u1IRQS286:1;
    uint_io32_t		u1IRQS287:1;
}stc_irc0_irqs8_field_t;

typedef union un_irc0_irqs8{
    uint_io32_t		u32Register;
    stc_irc0_irqs8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs8_t;

/* IRQS9 */
#define IRC0_IRQS9	(IRC0.unIRQS9.u32Register)  /*@rg@*/
#define IRC0_IRQS9_IRQS288	(IRC0.unIRQS9.stcField.u1IRQS288)  /*@bf@*/
#define IRC0_IRQS9_IRQS289	(IRC0.unIRQS9.stcField.u1IRQS289)  /*@bf@*/
#define IRC0_IRQS9_IRQS290	(IRC0.unIRQS9.stcField.u1IRQS290)  /*@bf@*/
#define IRC0_IRQS9_IRQS291	(IRC0.unIRQS9.stcField.u1IRQS291)  /*@bf@*/
#define IRC0_IRQS9_IRQS292	(IRC0.unIRQS9.stcField.u1IRQS292)  /*@bf@*/
#define IRC0_IRQS9_IRQS293	(IRC0.unIRQS9.stcField.u1IRQS293)  /*@bf@*/
#define IRC0_IRQS9_IRQS294	(IRC0.unIRQS9.stcField.u1IRQS294)  /*@bf@*/
#define IRC0_IRQS9_IRQS295	(IRC0.unIRQS9.stcField.u1IRQS295)  /*@bf@*/
#define IRC0_IRQS9_IRQS296	(IRC0.unIRQS9.stcField.u1IRQS296)  /*@bf@*/
#define IRC0_IRQS9_IRQS297	(IRC0.unIRQS9.stcField.u1IRQS297)  /*@bf@*/
#define IRC0_IRQS9_IRQS298	(IRC0.unIRQS9.stcField.u1IRQS298)  /*@bf@*/
#define IRC0_IRQS9_IRQS299	(IRC0.unIRQS9.stcField.u1IRQS299)  /*@bf@*/
#define IRC0_IRQS9_IRQS300	(IRC0.unIRQS9.stcField.u1IRQS300)  /*@bf@*/
#define IRC0_IRQS9_IRQS301	(IRC0.unIRQS9.stcField.u1IRQS301)  /*@bf@*/
#define IRC0_IRQS9_IRQS302	(IRC0.unIRQS9.stcField.u1IRQS302)  /*@bf@*/
#define IRC0_IRQS9_IRQS303	(IRC0.unIRQS9.stcField.u1IRQS303)  /*@bf@*/
#define IRC0_IRQS9_IRQS304	(IRC0.unIRQS9.stcField.u1IRQS304)  /*@bf@*/
#define IRC0_IRQS9_IRQS305	(IRC0.unIRQS9.stcField.u1IRQS305)  /*@bf@*/
#define IRC0_IRQS9_IRQS306	(IRC0.unIRQS9.stcField.u1IRQS306)  /*@bf@*/
#define IRC0_IRQS9_IRQS307	(IRC0.unIRQS9.stcField.u1IRQS307)  /*@bf@*/
#define IRC0_IRQS9_IRQS308	(IRC0.unIRQS9.stcField.u1IRQS308)  /*@bf@*/
#define IRC0_IRQS9_IRQS309	(IRC0.unIRQS9.stcField.u1IRQS309)  /*@bf@*/
#define IRC0_IRQS9_IRQS310	(IRC0.unIRQS9.stcField.u1IRQS310)  /*@bf@*/
#define IRC0_IRQS9_IRQS311	(IRC0.unIRQS9.stcField.u1IRQS311)  /*@bf@*/
#define IRC0_IRQS9_IRQS312	(IRC0.unIRQS9.stcField.u1IRQS312)  /*@bf@*/
#define IRC0_IRQS9_IRQS313	(IRC0.unIRQS9.stcField.u1IRQS313)  /*@bf@*/
#define IRC0_IRQS9_IRQS314	(IRC0.unIRQS9.stcField.u1IRQS314)  /*@bf@*/
#define IRC0_IRQS9_IRQS315	(IRC0.unIRQS9.stcField.u1IRQS315)  /*@bf@*/
#define IRC0_IRQS9_IRQS316	(IRC0.unIRQS9.stcField.u1IRQS316)  /*@bf@*/
#define IRC0_IRQS9_IRQS317	(IRC0.unIRQS9.stcField.u1IRQS317)  /*@bf@*/
#define IRC0_IRQS9_IRQS318	(IRC0.unIRQS9.stcField.u1IRQS318)  /*@bf@*/
#define IRC0_IRQS9_IRQS319	(IRC0.unIRQS9.stcField.u1IRQS319)  /*@bf@*/

typedef struct stc_irc0_irqs9_field{
    uint_io32_t		u1IRQS288:1;
    uint_io32_t		u1IRQS289:1;
    uint_io32_t		u1IRQS290:1;
    uint_io32_t		u1IRQS291:1;
    uint_io32_t		u1IRQS292:1;
    uint_io32_t		u1IRQS293:1;
    uint_io32_t		u1IRQS294:1;
    uint_io32_t		u1IRQS295:1;
    uint_io32_t		u1IRQS296:1;
    uint_io32_t		u1IRQS297:1;
    uint_io32_t		u1IRQS298:1;
    uint_io32_t		u1IRQS299:1;
    uint_io32_t		u1IRQS300:1;
    uint_io32_t		u1IRQS301:1;
    uint_io32_t		u1IRQS302:1;
    uint_io32_t		u1IRQS303:1;
    uint_io32_t		u1IRQS304:1;
    uint_io32_t		u1IRQS305:1;
    uint_io32_t		u1IRQS306:1;
    uint_io32_t		u1IRQS307:1;
    uint_io32_t		u1IRQS308:1;
    uint_io32_t		u1IRQS309:1;
    uint_io32_t		u1IRQS310:1;
    uint_io32_t		u1IRQS311:1;
    uint_io32_t		u1IRQS312:1;
    uint_io32_t		u1IRQS313:1;
    uint_io32_t		u1IRQS314:1;
    uint_io32_t		u1IRQS315:1;
    uint_io32_t		u1IRQS316:1;
    uint_io32_t		u1IRQS317:1;
    uint_io32_t		u1IRQS318:1;
    uint_io32_t		u1IRQS319:1;
}stc_irc0_irqs9_field_t;

typedef union un_irc0_irqs9{
    uint_io32_t		u32Register;
    stc_irc0_irqs9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs9_t;

/* IRQS10 */
#define IRC0_IRQS10	(IRC0.unIRQS10.u32Register)  /*@rg@*/
#define IRC0_IRQS10_IRQS320	(IRC0.unIRQS10.stcField.u1IRQS320)  /*@bf@*/
#define IRC0_IRQS10_IRQS321	(IRC0.unIRQS10.stcField.u1IRQS321)  /*@bf@*/
#define IRC0_IRQS10_IRQS322	(IRC0.unIRQS10.stcField.u1IRQS322)  /*@bf@*/
#define IRC0_IRQS10_IRQS323	(IRC0.unIRQS10.stcField.u1IRQS323)  /*@bf@*/
#define IRC0_IRQS10_IRQS324	(IRC0.unIRQS10.stcField.u1IRQS324)  /*@bf@*/
#define IRC0_IRQS10_IRQS325	(IRC0.unIRQS10.stcField.u1IRQS325)  /*@bf@*/
#define IRC0_IRQS10_IRQS326	(IRC0.unIRQS10.stcField.u1IRQS326)  /*@bf@*/
#define IRC0_IRQS10_IRQS327	(IRC0.unIRQS10.stcField.u1IRQS327)  /*@bf@*/
#define IRC0_IRQS10_IRQS328	(IRC0.unIRQS10.stcField.u1IRQS328)  /*@bf@*/
#define IRC0_IRQS10_IRQS329	(IRC0.unIRQS10.stcField.u1IRQS329)  /*@bf@*/
#define IRC0_IRQS10_IRQS330	(IRC0.unIRQS10.stcField.u1IRQS330)  /*@bf@*/
#define IRC0_IRQS10_IRQS331	(IRC0.unIRQS10.stcField.u1IRQS331)  /*@bf@*/
#define IRC0_IRQS10_IRQS332	(IRC0.unIRQS10.stcField.u1IRQS332)  /*@bf@*/
#define IRC0_IRQS10_IRQS333	(IRC0.unIRQS10.stcField.u1IRQS333)  /*@bf@*/
#define IRC0_IRQS10_IRQS334	(IRC0.unIRQS10.stcField.u1IRQS334)  /*@bf@*/
#define IRC0_IRQS10_IRQS335	(IRC0.unIRQS10.stcField.u1IRQS335)  /*@bf@*/
#define IRC0_IRQS10_IRQS336	(IRC0.unIRQS10.stcField.u1IRQS336)  /*@bf@*/
#define IRC0_IRQS10_IRQS337	(IRC0.unIRQS10.stcField.u1IRQS337)  /*@bf@*/
#define IRC0_IRQS10_IRQS338	(IRC0.unIRQS10.stcField.u1IRQS338)  /*@bf@*/
#define IRC0_IRQS10_IRQS339	(IRC0.unIRQS10.stcField.u1IRQS339)  /*@bf@*/
#define IRC0_IRQS10_IRQS340	(IRC0.unIRQS10.stcField.u1IRQS340)  /*@bf@*/
#define IRC0_IRQS10_IRQS341	(IRC0.unIRQS10.stcField.u1IRQS341)  /*@bf@*/
#define IRC0_IRQS10_IRQS342	(IRC0.unIRQS10.stcField.u1IRQS342)  /*@bf@*/
#define IRC0_IRQS10_IRQS343	(IRC0.unIRQS10.stcField.u1IRQS343)  /*@bf@*/
#define IRC0_IRQS10_IRQS344	(IRC0.unIRQS10.stcField.u1IRQS344)  /*@bf@*/
#define IRC0_IRQS10_IRQS345	(IRC0.unIRQS10.stcField.u1IRQS345)  /*@bf@*/
#define IRC0_IRQS10_IRQS346	(IRC0.unIRQS10.stcField.u1IRQS346)  /*@bf@*/
#define IRC0_IRQS10_IRQS347	(IRC0.unIRQS10.stcField.u1IRQS347)  /*@bf@*/
#define IRC0_IRQS10_IRQS348	(IRC0.unIRQS10.stcField.u1IRQS348)  /*@bf@*/
#define IRC0_IRQS10_IRQS349	(IRC0.unIRQS10.stcField.u1IRQS349)  /*@bf@*/
#define IRC0_IRQS10_IRQS350	(IRC0.unIRQS10.stcField.u1IRQS350)  /*@bf@*/
#define IRC0_IRQS10_IRQS351	(IRC0.unIRQS10.stcField.u1IRQS351)  /*@bf@*/

typedef struct stc_irc0_irqs10_field{
    uint_io32_t		u1IRQS320:1;
    uint_io32_t		u1IRQS321:1;
    uint_io32_t		u1IRQS322:1;
    uint_io32_t		u1IRQS323:1;
    uint_io32_t		u1IRQS324:1;
    uint_io32_t		u1IRQS325:1;
    uint_io32_t		u1IRQS326:1;
    uint_io32_t		u1IRQS327:1;
    uint_io32_t		u1IRQS328:1;
    uint_io32_t		u1IRQS329:1;
    uint_io32_t		u1IRQS330:1;
    uint_io32_t		u1IRQS331:1;
    uint_io32_t		u1IRQS332:1;
    uint_io32_t		u1IRQS333:1;
    uint_io32_t		u1IRQS334:1;
    uint_io32_t		u1IRQS335:1;
    uint_io32_t		u1IRQS336:1;
    uint_io32_t		u1IRQS337:1;
    uint_io32_t		u1IRQS338:1;
    uint_io32_t		u1IRQS339:1;
    uint_io32_t		u1IRQS340:1;
    uint_io32_t		u1IRQS341:1;
    uint_io32_t		u1IRQS342:1;
    uint_io32_t		u1IRQS343:1;
    uint_io32_t		u1IRQS344:1;
    uint_io32_t		u1IRQS345:1;
    uint_io32_t		u1IRQS346:1;
    uint_io32_t		u1IRQS347:1;
    uint_io32_t		u1IRQS348:1;
    uint_io32_t		u1IRQS349:1;
    uint_io32_t		u1IRQS350:1;
    uint_io32_t		u1IRQS351:1;
}stc_irc0_irqs10_field_t;

typedef union un_irc0_irqs10{
    uint_io32_t		u32Register;
    stc_irc0_irqs10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs10_t;

/* IRQS11 */
#define IRC0_IRQS11	(IRC0.unIRQS11.u32Register)  /*@rg@*/
#define IRC0_IRQS11_IRQS352	(IRC0.unIRQS11.stcField.u1IRQS352)  /*@bf@*/
#define IRC0_IRQS11_IRQS353	(IRC0.unIRQS11.stcField.u1IRQS353)  /*@bf@*/
#define IRC0_IRQS11_IRQS354	(IRC0.unIRQS11.stcField.u1IRQS354)  /*@bf@*/
#define IRC0_IRQS11_IRQS355	(IRC0.unIRQS11.stcField.u1IRQS355)  /*@bf@*/
#define IRC0_IRQS11_IRQS356	(IRC0.unIRQS11.stcField.u1IRQS356)  /*@bf@*/
#define IRC0_IRQS11_IRQS357	(IRC0.unIRQS11.stcField.u1IRQS357)  /*@bf@*/
#define IRC0_IRQS11_IRQS358	(IRC0.unIRQS11.stcField.u1IRQS358)  /*@bf@*/
#define IRC0_IRQS11_IRQS359	(IRC0.unIRQS11.stcField.u1IRQS359)  /*@bf@*/
#define IRC0_IRQS11_IRQS360	(IRC0.unIRQS11.stcField.u1IRQS360)  /*@bf@*/
#define IRC0_IRQS11_IRQS361	(IRC0.unIRQS11.stcField.u1IRQS361)  /*@bf@*/
#define IRC0_IRQS11_IRQS362	(IRC0.unIRQS11.stcField.u1IRQS362)  /*@bf@*/
#define IRC0_IRQS11_IRQS363	(IRC0.unIRQS11.stcField.u1IRQS363)  /*@bf@*/
#define IRC0_IRQS11_IRQS364	(IRC0.unIRQS11.stcField.u1IRQS364)  /*@bf@*/
#define IRC0_IRQS11_IRQS365	(IRC0.unIRQS11.stcField.u1IRQS365)  /*@bf@*/
#define IRC0_IRQS11_IRQS366	(IRC0.unIRQS11.stcField.u1IRQS366)  /*@bf@*/
#define IRC0_IRQS11_IRQS367	(IRC0.unIRQS11.stcField.u1IRQS367)  /*@bf@*/
#define IRC0_IRQS11_IRQS368	(IRC0.unIRQS11.stcField.u1IRQS368)  /*@bf@*/
#define IRC0_IRQS11_IRQS369	(IRC0.unIRQS11.stcField.u1IRQS369)  /*@bf@*/
#define IRC0_IRQS11_IRQS370	(IRC0.unIRQS11.stcField.u1IRQS370)  /*@bf@*/
#define IRC0_IRQS11_IRQS371	(IRC0.unIRQS11.stcField.u1IRQS371)  /*@bf@*/
#define IRC0_IRQS11_IRQS372	(IRC0.unIRQS11.stcField.u1IRQS372)  /*@bf@*/
#define IRC0_IRQS11_IRQS373	(IRC0.unIRQS11.stcField.u1IRQS373)  /*@bf@*/
#define IRC0_IRQS11_IRQS374	(IRC0.unIRQS11.stcField.u1IRQS374)  /*@bf@*/
#define IRC0_IRQS11_IRQS375	(IRC0.unIRQS11.stcField.u1IRQS375)  /*@bf@*/
#define IRC0_IRQS11_IRQS376	(IRC0.unIRQS11.stcField.u1IRQS376)  /*@bf@*/
#define IRC0_IRQS11_IRQS377	(IRC0.unIRQS11.stcField.u1IRQS377)  /*@bf@*/
#define IRC0_IRQS11_IRQS378	(IRC0.unIRQS11.stcField.u1IRQS378)  /*@bf@*/
#define IRC0_IRQS11_IRQS379	(IRC0.unIRQS11.stcField.u1IRQS379)  /*@bf@*/
#define IRC0_IRQS11_IRQS380	(IRC0.unIRQS11.stcField.u1IRQS380)  /*@bf@*/
#define IRC0_IRQS11_IRQS381	(IRC0.unIRQS11.stcField.u1IRQS381)  /*@bf@*/
#define IRC0_IRQS11_IRQS382	(IRC0.unIRQS11.stcField.u1IRQS382)  /*@bf@*/
#define IRC0_IRQS11_IRQS383	(IRC0.unIRQS11.stcField.u1IRQS383)  /*@bf@*/

typedef struct stc_irc0_irqs11_field{
    uint_io32_t		u1IRQS352:1;
    uint_io32_t		u1IRQS353:1;
    uint_io32_t		u1IRQS354:1;
    uint_io32_t		u1IRQS355:1;
    uint_io32_t		u1IRQS356:1;
    uint_io32_t		u1IRQS357:1;
    uint_io32_t		u1IRQS358:1;
    uint_io32_t		u1IRQS359:1;
    uint_io32_t		u1IRQS360:1;
    uint_io32_t		u1IRQS361:1;
    uint_io32_t		u1IRQS362:1;
    uint_io32_t		u1IRQS363:1;
    uint_io32_t		u1IRQS364:1;
    uint_io32_t		u1IRQS365:1;
    uint_io32_t		u1IRQS366:1;
    uint_io32_t		u1IRQS367:1;
    uint_io32_t		u1IRQS368:1;
    uint_io32_t		u1IRQS369:1;
    uint_io32_t		u1IRQS370:1;
    uint_io32_t		u1IRQS371:1;
    uint_io32_t		u1IRQS372:1;
    uint_io32_t		u1IRQS373:1;
    uint_io32_t		u1IRQS374:1;
    uint_io32_t		u1IRQS375:1;
    uint_io32_t		u1IRQS376:1;
    uint_io32_t		u1IRQS377:1;
    uint_io32_t		u1IRQS378:1;
    uint_io32_t		u1IRQS379:1;
    uint_io32_t		u1IRQS380:1;
    uint_io32_t		u1IRQS381:1;
    uint_io32_t		u1IRQS382:1;
    uint_io32_t		u1IRQS383:1;
}stc_irc0_irqs11_field_t;

typedef union un_irc0_irqs11{
    uint_io32_t		u32Register;
    stc_irc0_irqs11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs11_t;

/* IRQS12 */
#define IRC0_IRQS12	(IRC0.unIRQS12.u32Register)  /*@rg@*/
#define IRC0_IRQS12_IRQS384	(IRC0.unIRQS12.stcField.u1IRQS384)  /*@bf@*/
#define IRC0_IRQS12_IRQS385	(IRC0.unIRQS12.stcField.u1IRQS385)  /*@bf@*/
#define IRC0_IRQS12_IRQS386	(IRC0.unIRQS12.stcField.u1IRQS386)  /*@bf@*/
#define IRC0_IRQS12_IRQS387	(IRC0.unIRQS12.stcField.u1IRQS387)  /*@bf@*/
#define IRC0_IRQS12_IRQS388	(IRC0.unIRQS12.stcField.u1IRQS388)  /*@bf@*/
#define IRC0_IRQS12_IRQS389	(IRC0.unIRQS12.stcField.u1IRQS389)  /*@bf@*/
#define IRC0_IRQS12_IRQS390	(IRC0.unIRQS12.stcField.u1IRQS390)  /*@bf@*/
#define IRC0_IRQS12_IRQS391	(IRC0.unIRQS12.stcField.u1IRQS391)  /*@bf@*/
#define IRC0_IRQS12_IRQS392	(IRC0.unIRQS12.stcField.u1IRQS392)  /*@bf@*/
#define IRC0_IRQS12_IRQS393	(IRC0.unIRQS12.stcField.u1IRQS393)  /*@bf@*/
#define IRC0_IRQS12_IRQS394	(IRC0.unIRQS12.stcField.u1IRQS394)  /*@bf@*/
#define IRC0_IRQS12_IRQS395	(IRC0.unIRQS12.stcField.u1IRQS395)  /*@bf@*/
#define IRC0_IRQS12_IRQS396	(IRC0.unIRQS12.stcField.u1IRQS396)  /*@bf@*/
#define IRC0_IRQS12_IRQS397	(IRC0.unIRQS12.stcField.u1IRQS397)  /*@bf@*/
#define IRC0_IRQS12_IRQS398	(IRC0.unIRQS12.stcField.u1IRQS398)  /*@bf@*/
#define IRC0_IRQS12_IRQS399	(IRC0.unIRQS12.stcField.u1IRQS399)  /*@bf@*/
#define IRC0_IRQS12_IRQS400	(IRC0.unIRQS12.stcField.u1IRQS400)  /*@bf@*/
#define IRC0_IRQS12_IRQS401	(IRC0.unIRQS12.stcField.u1IRQS401)  /*@bf@*/
#define IRC0_IRQS12_IRQS402	(IRC0.unIRQS12.stcField.u1IRQS402)  /*@bf@*/
#define IRC0_IRQS12_IRQS403	(IRC0.unIRQS12.stcField.u1IRQS403)  /*@bf@*/
#define IRC0_IRQS12_IRQS404	(IRC0.unIRQS12.stcField.u1IRQS404)  /*@bf@*/
#define IRC0_IRQS12_IRQS405	(IRC0.unIRQS12.stcField.u1IRQS405)  /*@bf@*/
#define IRC0_IRQS12_IRQS406	(IRC0.unIRQS12.stcField.u1IRQS406)  /*@bf@*/
#define IRC0_IRQS12_IRQS407	(IRC0.unIRQS12.stcField.u1IRQS407)  /*@bf@*/
#define IRC0_IRQS12_IRQS408	(IRC0.unIRQS12.stcField.u1IRQS408)  /*@bf@*/
#define IRC0_IRQS12_IRQS409	(IRC0.unIRQS12.stcField.u1IRQS409)  /*@bf@*/
#define IRC0_IRQS12_IRQS410	(IRC0.unIRQS12.stcField.u1IRQS410)  /*@bf@*/
#define IRC0_IRQS12_IRQS411	(IRC0.unIRQS12.stcField.u1IRQS411)  /*@bf@*/
#define IRC0_IRQS12_IRQS412	(IRC0.unIRQS12.stcField.u1IRQS412)  /*@bf@*/
#define IRC0_IRQS12_IRQS413	(IRC0.unIRQS12.stcField.u1IRQS413)  /*@bf@*/
#define IRC0_IRQS12_IRQS414	(IRC0.unIRQS12.stcField.u1IRQS414)  /*@bf@*/
#define IRC0_IRQS12_IRQS415	(IRC0.unIRQS12.stcField.u1IRQS415)  /*@bf@*/

typedef struct stc_irc0_irqs12_field{
    uint_io32_t		u1IRQS384:1;
    uint_io32_t		u1IRQS385:1;
    uint_io32_t		u1IRQS386:1;
    uint_io32_t		u1IRQS387:1;
    uint_io32_t		u1IRQS388:1;
    uint_io32_t		u1IRQS389:1;
    uint_io32_t		u1IRQS390:1;
    uint_io32_t		u1IRQS391:1;
    uint_io32_t		u1IRQS392:1;
    uint_io32_t		u1IRQS393:1;
    uint_io32_t		u1IRQS394:1;
    uint_io32_t		u1IRQS395:1;
    uint_io32_t		u1IRQS396:1;
    uint_io32_t		u1IRQS397:1;
    uint_io32_t		u1IRQS398:1;
    uint_io32_t		u1IRQS399:1;
    uint_io32_t		u1IRQS400:1;
    uint_io32_t		u1IRQS401:1;
    uint_io32_t		u1IRQS402:1;
    uint_io32_t		u1IRQS403:1;
    uint_io32_t		u1IRQS404:1;
    uint_io32_t		u1IRQS405:1;
    uint_io32_t		u1IRQS406:1;
    uint_io32_t		u1IRQS407:1;
    uint_io32_t		u1IRQS408:1;
    uint_io32_t		u1IRQS409:1;
    uint_io32_t		u1IRQS410:1;
    uint_io32_t		u1IRQS411:1;
    uint_io32_t		u1IRQS412:1;
    uint_io32_t		u1IRQS413:1;
    uint_io32_t		u1IRQS414:1;
    uint_io32_t		u1IRQS415:1;
}stc_irc0_irqs12_field_t;

typedef union un_irc0_irqs12{
    uint_io32_t		u32Register;
    stc_irc0_irqs12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs12_t;

/* IRQS13 */
#define IRC0_IRQS13	(IRC0.unIRQS13.u32Register)  /*@rg@*/
#define IRC0_IRQS13_IRQS416	(IRC0.unIRQS13.stcField.u1IRQS416)  /*@bf@*/
#define IRC0_IRQS13_IRQS417	(IRC0.unIRQS13.stcField.u1IRQS417)  /*@bf@*/
#define IRC0_IRQS13_IRQS418	(IRC0.unIRQS13.stcField.u1IRQS418)  /*@bf@*/
#define IRC0_IRQS13_IRQS419	(IRC0.unIRQS13.stcField.u1IRQS419)  /*@bf@*/
#define IRC0_IRQS13_IRQS420	(IRC0.unIRQS13.stcField.u1IRQS420)  /*@bf@*/
#define IRC0_IRQS13_IRQS421	(IRC0.unIRQS13.stcField.u1IRQS421)  /*@bf@*/
#define IRC0_IRQS13_IRQS422	(IRC0.unIRQS13.stcField.u1IRQS422)  /*@bf@*/
#define IRC0_IRQS13_IRQS423	(IRC0.unIRQS13.stcField.u1IRQS423)  /*@bf@*/
#define IRC0_IRQS13_IRQS424	(IRC0.unIRQS13.stcField.u1IRQS424)  /*@bf@*/
#define IRC0_IRQS13_IRQS425	(IRC0.unIRQS13.stcField.u1IRQS425)  /*@bf@*/
#define IRC0_IRQS13_IRQS426	(IRC0.unIRQS13.stcField.u1IRQS426)  /*@bf@*/
#define IRC0_IRQS13_IRQS427	(IRC0.unIRQS13.stcField.u1IRQS427)  /*@bf@*/
#define IRC0_IRQS13_IRQS428	(IRC0.unIRQS13.stcField.u1IRQS428)  /*@bf@*/
#define IRC0_IRQS13_IRQS429	(IRC0.unIRQS13.stcField.u1IRQS429)  /*@bf@*/
#define IRC0_IRQS13_IRQS430	(IRC0.unIRQS13.stcField.u1IRQS430)  /*@bf@*/
#define IRC0_IRQS13_IRQS431	(IRC0.unIRQS13.stcField.u1IRQS431)  /*@bf@*/
#define IRC0_IRQS13_IRQS432	(IRC0.unIRQS13.stcField.u1IRQS432)  /*@bf@*/
#define IRC0_IRQS13_IRQS433	(IRC0.unIRQS13.stcField.u1IRQS433)  /*@bf@*/
#define IRC0_IRQS13_IRQS434	(IRC0.unIRQS13.stcField.u1IRQS434)  /*@bf@*/
#define IRC0_IRQS13_IRQS435	(IRC0.unIRQS13.stcField.u1IRQS435)  /*@bf@*/
#define IRC0_IRQS13_IRQS436	(IRC0.unIRQS13.stcField.u1IRQS436)  /*@bf@*/
#define IRC0_IRQS13_IRQS437	(IRC0.unIRQS13.stcField.u1IRQS437)  /*@bf@*/
#define IRC0_IRQS13_IRQS438	(IRC0.unIRQS13.stcField.u1IRQS438)  /*@bf@*/
#define IRC0_IRQS13_IRQS439	(IRC0.unIRQS13.stcField.u1IRQS439)  /*@bf@*/
#define IRC0_IRQS13_IRQS440	(IRC0.unIRQS13.stcField.u1IRQS440)  /*@bf@*/
#define IRC0_IRQS13_IRQS441	(IRC0.unIRQS13.stcField.u1IRQS441)  /*@bf@*/
#define IRC0_IRQS13_IRQS442	(IRC0.unIRQS13.stcField.u1IRQS442)  /*@bf@*/
#define IRC0_IRQS13_IRQS443	(IRC0.unIRQS13.stcField.u1IRQS443)  /*@bf@*/
#define IRC0_IRQS13_IRQS444	(IRC0.unIRQS13.stcField.u1IRQS444)  /*@bf@*/
#define IRC0_IRQS13_IRQS445	(IRC0.unIRQS13.stcField.u1IRQS445)  /*@bf@*/
#define IRC0_IRQS13_IRQS446	(IRC0.unIRQS13.stcField.u1IRQS446)  /*@bf@*/
#define IRC0_IRQS13_IRQS447	(IRC0.unIRQS13.stcField.u1IRQS447)  /*@bf@*/

typedef struct stc_irc0_irqs13_field{
    uint_io32_t		u1IRQS416:1;
    uint_io32_t		u1IRQS417:1;
    uint_io32_t		u1IRQS418:1;
    uint_io32_t		u1IRQS419:1;
    uint_io32_t		u1IRQS420:1;
    uint_io32_t		u1IRQS421:1;
    uint_io32_t		u1IRQS422:1;
    uint_io32_t		u1IRQS423:1;
    uint_io32_t		u1IRQS424:1;
    uint_io32_t		u1IRQS425:1;
    uint_io32_t		u1IRQS426:1;
    uint_io32_t		u1IRQS427:1;
    uint_io32_t		u1IRQS428:1;
    uint_io32_t		u1IRQS429:1;
    uint_io32_t		u1IRQS430:1;
    uint_io32_t		u1IRQS431:1;
    uint_io32_t		u1IRQS432:1;
    uint_io32_t		u1IRQS433:1;
    uint_io32_t		u1IRQS434:1;
    uint_io32_t		u1IRQS435:1;
    uint_io32_t		u1IRQS436:1;
    uint_io32_t		u1IRQS437:1;
    uint_io32_t		u1IRQS438:1;
    uint_io32_t		u1IRQS439:1;
    uint_io32_t		u1IRQS440:1;
    uint_io32_t		u1IRQS441:1;
    uint_io32_t		u1IRQS442:1;
    uint_io32_t		u1IRQS443:1;
    uint_io32_t		u1IRQS444:1;
    uint_io32_t		u1IRQS445:1;
    uint_io32_t		u1IRQS446:1;
    uint_io32_t		u1IRQS447:1;
}stc_irc0_irqs13_field_t;

typedef union un_irc0_irqs13{
    uint_io32_t		u32Register;
    stc_irc0_irqs13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs13_t;

/* IRQS14 */
#define IRC0_IRQS14	(IRC0.unIRQS14.u32Register)  /*@rg@*/
#define IRC0_IRQS14_IRQS448	(IRC0.unIRQS14.stcField.u1IRQS448)  /*@bf@*/
#define IRC0_IRQS14_IRQS449	(IRC0.unIRQS14.stcField.u1IRQS449)  /*@bf@*/
#define IRC0_IRQS14_IRQS450	(IRC0.unIRQS14.stcField.u1IRQS450)  /*@bf@*/
#define IRC0_IRQS14_IRQS451	(IRC0.unIRQS14.stcField.u1IRQS451)  /*@bf@*/
#define IRC0_IRQS14_IRQS452	(IRC0.unIRQS14.stcField.u1IRQS452)  /*@bf@*/
#define IRC0_IRQS14_IRQS453	(IRC0.unIRQS14.stcField.u1IRQS453)  /*@bf@*/
#define IRC0_IRQS14_IRQS454	(IRC0.unIRQS14.stcField.u1IRQS454)  /*@bf@*/
#define IRC0_IRQS14_IRQS455	(IRC0.unIRQS14.stcField.u1IRQS455)  /*@bf@*/
#define IRC0_IRQS14_IRQS456	(IRC0.unIRQS14.stcField.u1IRQS456)  /*@bf@*/
#define IRC0_IRQS14_IRQS457	(IRC0.unIRQS14.stcField.u1IRQS457)  /*@bf@*/
#define IRC0_IRQS14_IRQS458	(IRC0.unIRQS14.stcField.u1IRQS458)  /*@bf@*/
#define IRC0_IRQS14_IRQS459	(IRC0.unIRQS14.stcField.u1IRQS459)  /*@bf@*/
#define IRC0_IRQS14_IRQS460	(IRC0.unIRQS14.stcField.u1IRQS460)  /*@bf@*/
#define IRC0_IRQS14_IRQS461	(IRC0.unIRQS14.stcField.u1IRQS461)  /*@bf@*/
#define IRC0_IRQS14_IRQS462	(IRC0.unIRQS14.stcField.u1IRQS462)  /*@bf@*/
#define IRC0_IRQS14_IRQS463	(IRC0.unIRQS14.stcField.u1IRQS463)  /*@bf@*/
#define IRC0_IRQS14_IRQS464	(IRC0.unIRQS14.stcField.u1IRQS464)  /*@bf@*/
#define IRC0_IRQS14_IRQS465	(IRC0.unIRQS14.stcField.u1IRQS465)  /*@bf@*/
#define IRC0_IRQS14_IRQS466	(IRC0.unIRQS14.stcField.u1IRQS466)  /*@bf@*/
#define IRC0_IRQS14_IRQS467	(IRC0.unIRQS14.stcField.u1IRQS467)  /*@bf@*/
#define IRC0_IRQS14_IRQS468	(IRC0.unIRQS14.stcField.u1IRQS468)  /*@bf@*/
#define IRC0_IRQS14_IRQS469	(IRC0.unIRQS14.stcField.u1IRQS469)  /*@bf@*/
#define IRC0_IRQS14_IRQS470	(IRC0.unIRQS14.stcField.u1IRQS470)  /*@bf@*/
#define IRC0_IRQS14_IRQS471	(IRC0.unIRQS14.stcField.u1IRQS471)  /*@bf@*/
#define IRC0_IRQS14_IRQS472	(IRC0.unIRQS14.stcField.u1IRQS472)  /*@bf@*/
#define IRC0_IRQS14_IRQS473	(IRC0.unIRQS14.stcField.u1IRQS473)  /*@bf@*/
#define IRC0_IRQS14_IRQS474	(IRC0.unIRQS14.stcField.u1IRQS474)  /*@bf@*/
#define IRC0_IRQS14_IRQS475	(IRC0.unIRQS14.stcField.u1IRQS475)  /*@bf@*/
#define IRC0_IRQS14_IRQS476	(IRC0.unIRQS14.stcField.u1IRQS476)  /*@bf@*/
#define IRC0_IRQS14_IRQS477	(IRC0.unIRQS14.stcField.u1IRQS477)  /*@bf@*/
#define IRC0_IRQS14_IRQS478	(IRC0.unIRQS14.stcField.u1IRQS478)  /*@bf@*/
#define IRC0_IRQS14_IRQS479	(IRC0.unIRQS14.stcField.u1IRQS479)  /*@bf@*/

typedef struct stc_irc0_irqs14_field{
    uint_io32_t		u1IRQS448:1;
    uint_io32_t		u1IRQS449:1;
    uint_io32_t		u1IRQS450:1;
    uint_io32_t		u1IRQS451:1;
    uint_io32_t		u1IRQS452:1;
    uint_io32_t		u1IRQS453:1;
    uint_io32_t		u1IRQS454:1;
    uint_io32_t		u1IRQS455:1;
    uint_io32_t		u1IRQS456:1;
    uint_io32_t		u1IRQS457:1;
    uint_io32_t		u1IRQS458:1;
    uint_io32_t		u1IRQS459:1;
    uint_io32_t		u1IRQS460:1;
    uint_io32_t		u1IRQS461:1;
    uint_io32_t		u1IRQS462:1;
    uint_io32_t		u1IRQS463:1;
    uint_io32_t		u1IRQS464:1;
    uint_io32_t		u1IRQS465:1;
    uint_io32_t		u1IRQS466:1;
    uint_io32_t		u1IRQS467:1;
    uint_io32_t		u1IRQS468:1;
    uint_io32_t		u1IRQS469:1;
    uint_io32_t		u1IRQS470:1;
    uint_io32_t		u1IRQS471:1;
    uint_io32_t		u1IRQS472:1;
    uint_io32_t		u1IRQS473:1;
    uint_io32_t		u1IRQS474:1;
    uint_io32_t		u1IRQS475:1;
    uint_io32_t		u1IRQS476:1;
    uint_io32_t		u1IRQS477:1;
    uint_io32_t		u1IRQS478:1;
    uint_io32_t		u1IRQS479:1;
}stc_irc0_irqs14_field_t;

typedef union un_irc0_irqs14{
    uint_io32_t		u32Register;
    stc_irc0_irqs14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs14_t;

/* IRQS15 */
#define IRC0_IRQS15	(IRC0.unIRQS15.u32Register)  /*@rg@*/
#define IRC0_IRQS15_IRQS480	(IRC0.unIRQS15.stcField.u1IRQS480)  /*@bf@*/
#define IRC0_IRQS15_IRQS481	(IRC0.unIRQS15.stcField.u1IRQS481)  /*@bf@*/
#define IRC0_IRQS15_IRQS482	(IRC0.unIRQS15.stcField.u1IRQS482)  /*@bf@*/
#define IRC0_IRQS15_IRQS483	(IRC0.unIRQS15.stcField.u1IRQS483)  /*@bf@*/
#define IRC0_IRQS15_IRQS484	(IRC0.unIRQS15.stcField.u1IRQS484)  /*@bf@*/
#define IRC0_IRQS15_IRQS485	(IRC0.unIRQS15.stcField.u1IRQS485)  /*@bf@*/
#define IRC0_IRQS15_IRQS486	(IRC0.unIRQS15.stcField.u1IRQS486)  /*@bf@*/
#define IRC0_IRQS15_IRQS487	(IRC0.unIRQS15.stcField.u1IRQS487)  /*@bf@*/
#define IRC0_IRQS15_IRQS488	(IRC0.unIRQS15.stcField.u1IRQS488)  /*@bf@*/
#define IRC0_IRQS15_IRQS489	(IRC0.unIRQS15.stcField.u1IRQS489)  /*@bf@*/
#define IRC0_IRQS15_IRQS490	(IRC0.unIRQS15.stcField.u1IRQS490)  /*@bf@*/
#define IRC0_IRQS15_IRQS491	(IRC0.unIRQS15.stcField.u1IRQS491)  /*@bf@*/
#define IRC0_IRQS15_IRQS492	(IRC0.unIRQS15.stcField.u1IRQS492)  /*@bf@*/
#define IRC0_IRQS15_IRQS493	(IRC0.unIRQS15.stcField.u1IRQS493)  /*@bf@*/
#define IRC0_IRQS15_IRQS494	(IRC0.unIRQS15.stcField.u1IRQS494)  /*@bf@*/
#define IRC0_IRQS15_IRQS495	(IRC0.unIRQS15.stcField.u1IRQS495)  /*@bf@*/
#define IRC0_IRQS15_IRQS496	(IRC0.unIRQS15.stcField.u1IRQS496)  /*@bf@*/
#define IRC0_IRQS15_IRQS497	(IRC0.unIRQS15.stcField.u1IRQS497)  /*@bf@*/
#define IRC0_IRQS15_IRQS498	(IRC0.unIRQS15.stcField.u1IRQS498)  /*@bf@*/
#define IRC0_IRQS15_IRQS499	(IRC0.unIRQS15.stcField.u1IRQS499)  /*@bf@*/
#define IRC0_IRQS15_IRQS500	(IRC0.unIRQS15.stcField.u1IRQS500)  /*@bf@*/
#define IRC0_IRQS15_IRQS501	(IRC0.unIRQS15.stcField.u1IRQS501)  /*@bf@*/
#define IRC0_IRQS15_IRQS502	(IRC0.unIRQS15.stcField.u1IRQS502)  /*@bf@*/
#define IRC0_IRQS15_IRQS503	(IRC0.unIRQS15.stcField.u1IRQS503)  /*@bf@*/
#define IRC0_IRQS15_IRQS504	(IRC0.unIRQS15.stcField.u1IRQS504)  /*@bf@*/
#define IRC0_IRQS15_IRQS505	(IRC0.unIRQS15.stcField.u1IRQS505)  /*@bf@*/
#define IRC0_IRQS15_IRQS506	(IRC0.unIRQS15.stcField.u1IRQS506)  /*@bf@*/
#define IRC0_IRQS15_IRQS507	(IRC0.unIRQS15.stcField.u1IRQS507)  /*@bf@*/
#define IRC0_IRQS15_IRQS508	(IRC0.unIRQS15.stcField.u1IRQS508)  /*@bf@*/
#define IRC0_IRQS15_IRQS509	(IRC0.unIRQS15.stcField.u1IRQS509)  /*@bf@*/
#define IRC0_IRQS15_IRQS510	(IRC0.unIRQS15.stcField.u1IRQS510)  /*@bf@*/
#define IRC0_IRQS15_IRQS511	(IRC0.unIRQS15.stcField.u1IRQS511)  /*@bf@*/

typedef struct stc_irc0_irqs15_field{
    uint_io32_t		u1IRQS480:1;
    uint_io32_t		u1IRQS481:1;
    uint_io32_t		u1IRQS482:1;
    uint_io32_t		u1IRQS483:1;
    uint_io32_t		u1IRQS484:1;
    uint_io32_t		u1IRQS485:1;
    uint_io32_t		u1IRQS486:1;
    uint_io32_t		u1IRQS487:1;
    uint_io32_t		u1IRQS488:1;
    uint_io32_t		u1IRQS489:1;
    uint_io32_t		u1IRQS490:1;
    uint_io32_t		u1IRQS491:1;
    uint_io32_t		u1IRQS492:1;
    uint_io32_t		u1IRQS493:1;
    uint_io32_t		u1IRQS494:1;
    uint_io32_t		u1IRQS495:1;
    uint_io32_t		u1IRQS496:1;
    uint_io32_t		u1IRQS497:1;
    uint_io32_t		u1IRQS498:1;
    uint_io32_t		u1IRQS499:1;
    uint_io32_t		u1IRQS500:1;
    uint_io32_t		u1IRQS501:1;
    uint_io32_t		u1IRQS502:1;
    uint_io32_t		u1IRQS503:1;
    uint_io32_t		u1IRQS504:1;
    uint_io32_t		u1IRQS505:1;
    uint_io32_t		u1IRQS506:1;
    uint_io32_t		u1IRQS507:1;
    uint_io32_t		u1IRQS508:1;
    uint_io32_t		u1IRQS509:1;
    uint_io32_t		u1IRQS510:1;
    uint_io32_t		u1IRQS511:1;
}stc_irc0_irqs15_field_t;

typedef union un_irc0_irqs15{
    uint_io32_t		u32Register;
    stc_irc0_irqs15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqs15_t;

/* IRQR0 */
#define IRC0_IRQR0	(IRC0.unIRQR0.u32Register)  /*@rg@*/
#define IRC0_IRQR0_IRQR0	(IRC0.unIRQR0.stcField.u1IRQR0)  /*@bf@*/
#define IRC0_IRQR0_IRQR1	(IRC0.unIRQR0.stcField.u1IRQR1)  /*@bf@*/
#define IRC0_IRQR0_IRQR2	(IRC0.unIRQR0.stcField.u1IRQR2)  /*@bf@*/
#define IRC0_IRQR0_IRQR3	(IRC0.unIRQR0.stcField.u1IRQR3)  /*@bf@*/
#define IRC0_IRQR0_IRQR4	(IRC0.unIRQR0.stcField.u1IRQR4)  /*@bf@*/
#define IRC0_IRQR0_IRQR5	(IRC0.unIRQR0.stcField.u1IRQR5)  /*@bf@*/
#define IRC0_IRQR0_IRQR6	(IRC0.unIRQR0.stcField.u1IRQR6)  /*@bf@*/
#define IRC0_IRQR0_IRQR7	(IRC0.unIRQR0.stcField.u1IRQR7)  /*@bf@*/
#define IRC0_IRQR0_IRQR8	(IRC0.unIRQR0.stcField.u1IRQR8)  /*@bf@*/
#define IRC0_IRQR0_IRQR9	(IRC0.unIRQR0.stcField.u1IRQR9)  /*@bf@*/
#define IRC0_IRQR0_IRQR10	(IRC0.unIRQR0.stcField.u1IRQR10)  /*@bf@*/
#define IRC0_IRQR0_IRQR11	(IRC0.unIRQR0.stcField.u1IRQR11)  /*@bf@*/
#define IRC0_IRQR0_IRQR12	(IRC0.unIRQR0.stcField.u1IRQR12)  /*@bf@*/
#define IRC0_IRQR0_IRQR13	(IRC0.unIRQR0.stcField.u1IRQR13)  /*@bf@*/
#define IRC0_IRQR0_IRQR14	(IRC0.unIRQR0.stcField.u1IRQR14)  /*@bf@*/
#define IRC0_IRQR0_IRQR15	(IRC0.unIRQR0.stcField.u1IRQR15)  /*@bf@*/
#define IRC0_IRQR0_IRQR16	(IRC0.unIRQR0.stcField.u1IRQR16)  /*@bf@*/
#define IRC0_IRQR0_IRQR17	(IRC0.unIRQR0.stcField.u1IRQR17)  /*@bf@*/
#define IRC0_IRQR0_IRQR18	(IRC0.unIRQR0.stcField.u1IRQR18)  /*@bf@*/
#define IRC0_IRQR0_IRQR19	(IRC0.unIRQR0.stcField.u1IRQR19)  /*@bf@*/
#define IRC0_IRQR0_IRQR20	(IRC0.unIRQR0.stcField.u1IRQR20)  /*@bf@*/
#define IRC0_IRQR0_IRQR21	(IRC0.unIRQR0.stcField.u1IRQR21)  /*@bf@*/
#define IRC0_IRQR0_IRQR22	(IRC0.unIRQR0.stcField.u1IRQR22)  /*@bf@*/
#define IRC0_IRQR0_IRQR23	(IRC0.unIRQR0.stcField.u1IRQR23)  /*@bf@*/
#define IRC0_IRQR0_IRQR24	(IRC0.unIRQR0.stcField.u1IRQR24)  /*@bf@*/
#define IRC0_IRQR0_IRQR25	(IRC0.unIRQR0.stcField.u1IRQR25)  /*@bf@*/
#define IRC0_IRQR0_IRQR26	(IRC0.unIRQR0.stcField.u1IRQR26)  /*@bf@*/
#define IRC0_IRQR0_IRQR27	(IRC0.unIRQR0.stcField.u1IRQR27)  /*@bf@*/
#define IRC0_IRQR0_IRQR28	(IRC0.unIRQR0.stcField.u1IRQR28)  /*@bf@*/
#define IRC0_IRQR0_IRQR29	(IRC0.unIRQR0.stcField.u1IRQR29)  /*@bf@*/
#define IRC0_IRQR0_IRQR30	(IRC0.unIRQR0.stcField.u1IRQR30)  /*@bf@*/
#define IRC0_IRQR0_IRQR31	(IRC0.unIRQR0.stcField.u1IRQR31)  /*@bf@*/

typedef struct stc_irc0_irqr0_field{
    uint_io32_t		u1IRQR0:1;
    uint_io32_t		u1IRQR1:1;
    uint_io32_t		u1IRQR2:1;
    uint_io32_t		u1IRQR3:1;
    uint_io32_t		u1IRQR4:1;
    uint_io32_t		u1IRQR5:1;
    uint_io32_t		u1IRQR6:1;
    uint_io32_t		u1IRQR7:1;
    uint_io32_t		u1IRQR8:1;
    uint_io32_t		u1IRQR9:1;
    uint_io32_t		u1IRQR10:1;
    uint_io32_t		u1IRQR11:1;
    uint_io32_t		u1IRQR12:1;
    uint_io32_t		u1IRQR13:1;
    uint_io32_t		u1IRQR14:1;
    uint_io32_t		u1IRQR15:1;
    uint_io32_t		u1IRQR16:1;
    uint_io32_t		u1IRQR17:1;
    uint_io32_t		u1IRQR18:1;
    uint_io32_t		u1IRQR19:1;
    uint_io32_t		u1IRQR20:1;
    uint_io32_t		u1IRQR21:1;
    uint_io32_t		u1IRQR22:1;
    uint_io32_t		u1IRQR23:1;
    uint_io32_t		u1IRQR24:1;
    uint_io32_t		u1IRQR25:1;
    uint_io32_t		u1IRQR26:1;
    uint_io32_t		u1IRQR27:1;
    uint_io32_t		u1IRQR28:1;
    uint_io32_t		u1IRQR29:1;
    uint_io32_t		u1IRQR30:1;
    uint_io32_t		u1IRQR31:1;
}stc_irc0_irqr0_field_t;

typedef union un_irc0_irqr0{
    uint_io32_t		u32Register;
    stc_irc0_irqr0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr0_t;

/* IRQR1 */
#define IRC0_IRQR1	(IRC0.unIRQR1.u32Register)  /*@rg@*/
#define IRC0_IRQR1_IRQR32	(IRC0.unIRQR1.stcField.u1IRQR32)  /*@bf@*/
#define IRC0_IRQR1_IRQR33	(IRC0.unIRQR1.stcField.u1IRQR33)  /*@bf@*/
#define IRC0_IRQR1_IRQR34	(IRC0.unIRQR1.stcField.u1IRQR34)  /*@bf@*/
#define IRC0_IRQR1_IRQR35	(IRC0.unIRQR1.stcField.u1IRQR35)  /*@bf@*/
#define IRC0_IRQR1_IRQR36	(IRC0.unIRQR1.stcField.u1IRQR36)  /*@bf@*/
#define IRC0_IRQR1_IRQR37	(IRC0.unIRQR1.stcField.u1IRQR37)  /*@bf@*/
#define IRC0_IRQR1_IRQR38	(IRC0.unIRQR1.stcField.u1IRQR38)  /*@bf@*/
#define IRC0_IRQR1_IRQR39	(IRC0.unIRQR1.stcField.u1IRQR39)  /*@bf@*/
#define IRC0_IRQR1_IRQR40	(IRC0.unIRQR1.stcField.u1IRQR40)  /*@bf@*/
#define IRC0_IRQR1_IRQR41	(IRC0.unIRQR1.stcField.u1IRQR41)  /*@bf@*/
#define IRC0_IRQR1_IRQR42	(IRC0.unIRQR1.stcField.u1IRQR42)  /*@bf@*/
#define IRC0_IRQR1_IRQR43	(IRC0.unIRQR1.stcField.u1IRQR43)  /*@bf@*/
#define IRC0_IRQR1_IRQR44	(IRC0.unIRQR1.stcField.u1IRQR44)  /*@bf@*/
#define IRC0_IRQR1_IRQR45	(IRC0.unIRQR1.stcField.u1IRQR45)  /*@bf@*/
#define IRC0_IRQR1_IRQR46	(IRC0.unIRQR1.stcField.u1IRQR46)  /*@bf@*/
#define IRC0_IRQR1_IRQR47	(IRC0.unIRQR1.stcField.u1IRQR47)  /*@bf@*/
#define IRC0_IRQR1_IRQR48	(IRC0.unIRQR1.stcField.u1IRQR48)  /*@bf@*/
#define IRC0_IRQR1_IRQR49	(IRC0.unIRQR1.stcField.u1IRQR49)  /*@bf@*/
#define IRC0_IRQR1_IRQR50	(IRC0.unIRQR1.stcField.u1IRQR50)  /*@bf@*/
#define IRC0_IRQR1_IRQR51	(IRC0.unIRQR1.stcField.u1IRQR51)  /*@bf@*/
#define IRC0_IRQR1_IRQR52	(IRC0.unIRQR1.stcField.u1IRQR52)  /*@bf@*/
#define IRC0_IRQR1_IRQR53	(IRC0.unIRQR1.stcField.u1IRQR53)  /*@bf@*/
#define IRC0_IRQR1_IRQR54	(IRC0.unIRQR1.stcField.u1IRQR54)  /*@bf@*/
#define IRC0_IRQR1_IRQR55	(IRC0.unIRQR1.stcField.u1IRQR55)  /*@bf@*/
#define IRC0_IRQR1_IRQR56	(IRC0.unIRQR1.stcField.u1IRQR56)  /*@bf@*/
#define IRC0_IRQR1_IRQR57	(IRC0.unIRQR1.stcField.u1IRQR57)  /*@bf@*/
#define IRC0_IRQR1_IRQR58	(IRC0.unIRQR1.stcField.u1IRQR58)  /*@bf@*/
#define IRC0_IRQR1_IRQR59	(IRC0.unIRQR1.stcField.u1IRQR59)  /*@bf@*/
#define IRC0_IRQR1_IRQR60	(IRC0.unIRQR1.stcField.u1IRQR60)  /*@bf@*/
#define IRC0_IRQR1_IRQR61	(IRC0.unIRQR1.stcField.u1IRQR61)  /*@bf@*/
#define IRC0_IRQR1_IRQR62	(IRC0.unIRQR1.stcField.u1IRQR62)  /*@bf@*/
#define IRC0_IRQR1_IRQR63	(IRC0.unIRQR1.stcField.u1IRQR63)  /*@bf@*/

typedef struct stc_irc0_irqr1_field{
    uint_io32_t		u1IRQR32:1;
    uint_io32_t		u1IRQR33:1;
    uint_io32_t		u1IRQR34:1;
    uint_io32_t		u1IRQR35:1;
    uint_io32_t		u1IRQR36:1;
    uint_io32_t		u1IRQR37:1;
    uint_io32_t		u1IRQR38:1;
    uint_io32_t		u1IRQR39:1;
    uint_io32_t		u1IRQR40:1;
    uint_io32_t		u1IRQR41:1;
    uint_io32_t		u1IRQR42:1;
    uint_io32_t		u1IRQR43:1;
    uint_io32_t		u1IRQR44:1;
    uint_io32_t		u1IRQR45:1;
    uint_io32_t		u1IRQR46:1;
    uint_io32_t		u1IRQR47:1;
    uint_io32_t		u1IRQR48:1;
    uint_io32_t		u1IRQR49:1;
    uint_io32_t		u1IRQR50:1;
    uint_io32_t		u1IRQR51:1;
    uint_io32_t		u1IRQR52:1;
    uint_io32_t		u1IRQR53:1;
    uint_io32_t		u1IRQR54:1;
    uint_io32_t		u1IRQR55:1;
    uint_io32_t		u1IRQR56:1;
    uint_io32_t		u1IRQR57:1;
    uint_io32_t		u1IRQR58:1;
    uint_io32_t		u1IRQR59:1;
    uint_io32_t		u1IRQR60:1;
    uint_io32_t		u1IRQR61:1;
    uint_io32_t		u1IRQR62:1;
    uint_io32_t		u1IRQR63:1;
}stc_irc0_irqr1_field_t;

typedef union un_irc0_irqr1{
    uint_io32_t		u32Register;
    stc_irc0_irqr1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr1_t;

/* IRQR2 */
#define IRC0_IRQR2	(IRC0.unIRQR2.u32Register)  /*@rg@*/
#define IRC0_IRQR2_IRQR64	(IRC0.unIRQR2.stcField.u1IRQR64)  /*@bf@*/
#define IRC0_IRQR2_IRQR65	(IRC0.unIRQR2.stcField.u1IRQR65)  /*@bf@*/
#define IRC0_IRQR2_IRQR66	(IRC0.unIRQR2.stcField.u1IRQR66)  /*@bf@*/
#define IRC0_IRQR2_IRQR67	(IRC0.unIRQR2.stcField.u1IRQR67)  /*@bf@*/
#define IRC0_IRQR2_IRQR68	(IRC0.unIRQR2.stcField.u1IRQR68)  /*@bf@*/
#define IRC0_IRQR2_IRQR69	(IRC0.unIRQR2.stcField.u1IRQR69)  /*@bf@*/
#define IRC0_IRQR2_IRQR70	(IRC0.unIRQR2.stcField.u1IRQR70)  /*@bf@*/
#define IRC0_IRQR2_IRQR71	(IRC0.unIRQR2.stcField.u1IRQR71)  /*@bf@*/
#define IRC0_IRQR2_IRQR72	(IRC0.unIRQR2.stcField.u1IRQR72)  /*@bf@*/
#define IRC0_IRQR2_IRQR73	(IRC0.unIRQR2.stcField.u1IRQR73)  /*@bf@*/
#define IRC0_IRQR2_IRQR74	(IRC0.unIRQR2.stcField.u1IRQR74)  /*@bf@*/
#define IRC0_IRQR2_IRQR75	(IRC0.unIRQR2.stcField.u1IRQR75)  /*@bf@*/
#define IRC0_IRQR2_IRQR76	(IRC0.unIRQR2.stcField.u1IRQR76)  /*@bf@*/
#define IRC0_IRQR2_IRQR77	(IRC0.unIRQR2.stcField.u1IRQR77)  /*@bf@*/
#define IRC0_IRQR2_IRQR78	(IRC0.unIRQR2.stcField.u1IRQR78)  /*@bf@*/
#define IRC0_IRQR2_IRQR79	(IRC0.unIRQR2.stcField.u1IRQR79)  /*@bf@*/
#define IRC0_IRQR2_IRQR80	(IRC0.unIRQR2.stcField.u1IRQR80)  /*@bf@*/
#define IRC0_IRQR2_IRQR81	(IRC0.unIRQR2.stcField.u1IRQR81)  /*@bf@*/
#define IRC0_IRQR2_IRQR82	(IRC0.unIRQR2.stcField.u1IRQR82)  /*@bf@*/
#define IRC0_IRQR2_IRQR83	(IRC0.unIRQR2.stcField.u1IRQR83)  /*@bf@*/
#define IRC0_IRQR2_IRQR84	(IRC0.unIRQR2.stcField.u1IRQR84)  /*@bf@*/
#define IRC0_IRQR2_IRQR85	(IRC0.unIRQR2.stcField.u1IRQR85)  /*@bf@*/
#define IRC0_IRQR2_IRQR86	(IRC0.unIRQR2.stcField.u1IRQR86)  /*@bf@*/
#define IRC0_IRQR2_IRQR87	(IRC0.unIRQR2.stcField.u1IRQR87)  /*@bf@*/
#define IRC0_IRQR2_IRQR88	(IRC0.unIRQR2.stcField.u1IRQR88)  /*@bf@*/
#define IRC0_IRQR2_IRQR89	(IRC0.unIRQR2.stcField.u1IRQR89)  /*@bf@*/
#define IRC0_IRQR2_IRQR90	(IRC0.unIRQR2.stcField.u1IRQR90)  /*@bf@*/
#define IRC0_IRQR2_IRQR91	(IRC0.unIRQR2.stcField.u1IRQR91)  /*@bf@*/
#define IRC0_IRQR2_IRQR92	(IRC0.unIRQR2.stcField.u1IRQR92)  /*@bf@*/
#define IRC0_IRQR2_IRQR93	(IRC0.unIRQR2.stcField.u1IRQR93)  /*@bf@*/
#define IRC0_IRQR2_IRQR94	(IRC0.unIRQR2.stcField.u1IRQR94)  /*@bf@*/
#define IRC0_IRQR2_IRQR95	(IRC0.unIRQR2.stcField.u1IRQR95)  /*@bf@*/

typedef struct stc_irc0_irqr2_field{
    uint_io32_t		u1IRQR64:1;
    uint_io32_t		u1IRQR65:1;
    uint_io32_t		u1IRQR66:1;
    uint_io32_t		u1IRQR67:1;
    uint_io32_t		u1IRQR68:1;
    uint_io32_t		u1IRQR69:1;
    uint_io32_t		u1IRQR70:1;
    uint_io32_t		u1IRQR71:1;
    uint_io32_t		u1IRQR72:1;
    uint_io32_t		u1IRQR73:1;
    uint_io32_t		u1IRQR74:1;
    uint_io32_t		u1IRQR75:1;
    uint_io32_t		u1IRQR76:1;
    uint_io32_t		u1IRQR77:1;
    uint_io32_t		u1IRQR78:1;
    uint_io32_t		u1IRQR79:1;
    uint_io32_t		u1IRQR80:1;
    uint_io32_t		u1IRQR81:1;
    uint_io32_t		u1IRQR82:1;
    uint_io32_t		u1IRQR83:1;
    uint_io32_t		u1IRQR84:1;
    uint_io32_t		u1IRQR85:1;
    uint_io32_t		u1IRQR86:1;
    uint_io32_t		u1IRQR87:1;
    uint_io32_t		u1IRQR88:1;
    uint_io32_t		u1IRQR89:1;
    uint_io32_t		u1IRQR90:1;
    uint_io32_t		u1IRQR91:1;
    uint_io32_t		u1IRQR92:1;
    uint_io32_t		u1IRQR93:1;
    uint_io32_t		u1IRQR94:1;
    uint_io32_t		u1IRQR95:1;
}stc_irc0_irqr2_field_t;

typedef union un_irc0_irqr2{
    uint_io32_t		u32Register;
    stc_irc0_irqr2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr2_t;

/* IRQR3 */
#define IRC0_IRQR3	(IRC0.unIRQR3.u32Register)  /*@rg@*/
#define IRC0_IRQR3_IRQR96	(IRC0.unIRQR3.stcField.u1IRQR96)  /*@bf@*/
#define IRC0_IRQR3_IRQR97	(IRC0.unIRQR3.stcField.u1IRQR97)  /*@bf@*/
#define IRC0_IRQR3_IRQR98	(IRC0.unIRQR3.stcField.u1IRQR98)  /*@bf@*/
#define IRC0_IRQR3_IRQR99	(IRC0.unIRQR3.stcField.u1IRQR99)  /*@bf@*/
#define IRC0_IRQR3_IRQR100	(IRC0.unIRQR3.stcField.u1IRQR100)  /*@bf@*/
#define IRC0_IRQR3_IRQR101	(IRC0.unIRQR3.stcField.u1IRQR101)  /*@bf@*/
#define IRC0_IRQR3_IRQR102	(IRC0.unIRQR3.stcField.u1IRQR102)  /*@bf@*/
#define IRC0_IRQR3_IRQR103	(IRC0.unIRQR3.stcField.u1IRQR103)  /*@bf@*/
#define IRC0_IRQR3_IRQR104	(IRC0.unIRQR3.stcField.u1IRQR104)  /*@bf@*/
#define IRC0_IRQR3_IRQR105	(IRC0.unIRQR3.stcField.u1IRQR105)  /*@bf@*/
#define IRC0_IRQR3_IRQR106	(IRC0.unIRQR3.stcField.u1IRQR106)  /*@bf@*/
#define IRC0_IRQR3_IRQR107	(IRC0.unIRQR3.stcField.u1IRQR107)  /*@bf@*/
#define IRC0_IRQR3_IRQR108	(IRC0.unIRQR3.stcField.u1IRQR108)  /*@bf@*/
#define IRC0_IRQR3_IRQR109	(IRC0.unIRQR3.stcField.u1IRQR109)  /*@bf@*/
#define IRC0_IRQR3_IRQR110	(IRC0.unIRQR3.stcField.u1IRQR110)  /*@bf@*/
#define IRC0_IRQR3_IRQR111	(IRC0.unIRQR3.stcField.u1IRQR111)  /*@bf@*/
#define IRC0_IRQR3_IRQR112	(IRC0.unIRQR3.stcField.u1IRQR112)  /*@bf@*/
#define IRC0_IRQR3_IRQR113	(IRC0.unIRQR3.stcField.u1IRQR113)  /*@bf@*/
#define IRC0_IRQR3_IRQR114	(IRC0.unIRQR3.stcField.u1IRQR114)  /*@bf@*/
#define IRC0_IRQR3_IRQR115	(IRC0.unIRQR3.stcField.u1IRQR115)  /*@bf@*/
#define IRC0_IRQR3_IRQR116	(IRC0.unIRQR3.stcField.u1IRQR116)  /*@bf@*/
#define IRC0_IRQR3_IRQR117	(IRC0.unIRQR3.stcField.u1IRQR117)  /*@bf@*/
#define IRC0_IRQR3_IRQR118	(IRC0.unIRQR3.stcField.u1IRQR118)  /*@bf@*/
#define IRC0_IRQR3_IRQR119	(IRC0.unIRQR3.stcField.u1IRQR119)  /*@bf@*/
#define IRC0_IRQR3_IRQR120	(IRC0.unIRQR3.stcField.u1IRQR120)  /*@bf@*/
#define IRC0_IRQR3_IRQR121	(IRC0.unIRQR3.stcField.u1IRQR121)  /*@bf@*/
#define IRC0_IRQR3_IRQR122	(IRC0.unIRQR3.stcField.u1IRQR122)  /*@bf@*/
#define IRC0_IRQR3_IRQR123	(IRC0.unIRQR3.stcField.u1IRQR123)  /*@bf@*/
#define IRC0_IRQR3_IRQR124	(IRC0.unIRQR3.stcField.u1IRQR124)  /*@bf@*/
#define IRC0_IRQR3_IRQR125	(IRC0.unIRQR3.stcField.u1IRQR125)  /*@bf@*/
#define IRC0_IRQR3_IRQR126	(IRC0.unIRQR3.stcField.u1IRQR126)  /*@bf@*/
#define IRC0_IRQR3_IRQR127	(IRC0.unIRQR3.stcField.u1IRQR127)  /*@bf@*/

typedef struct stc_irc0_irqr3_field{
    uint_io32_t		u1IRQR96:1;
    uint_io32_t		u1IRQR97:1;
    uint_io32_t		u1IRQR98:1;
    uint_io32_t		u1IRQR99:1;
    uint_io32_t		u1IRQR100:1;
    uint_io32_t		u1IRQR101:1;
    uint_io32_t		u1IRQR102:1;
    uint_io32_t		u1IRQR103:1;
    uint_io32_t		u1IRQR104:1;
    uint_io32_t		u1IRQR105:1;
    uint_io32_t		u1IRQR106:1;
    uint_io32_t		u1IRQR107:1;
    uint_io32_t		u1IRQR108:1;
    uint_io32_t		u1IRQR109:1;
    uint_io32_t		u1IRQR110:1;
    uint_io32_t		u1IRQR111:1;
    uint_io32_t		u1IRQR112:1;
    uint_io32_t		u1IRQR113:1;
    uint_io32_t		u1IRQR114:1;
    uint_io32_t		u1IRQR115:1;
    uint_io32_t		u1IRQR116:1;
    uint_io32_t		u1IRQR117:1;
    uint_io32_t		u1IRQR118:1;
    uint_io32_t		u1IRQR119:1;
    uint_io32_t		u1IRQR120:1;
    uint_io32_t		u1IRQR121:1;
    uint_io32_t		u1IRQR122:1;
    uint_io32_t		u1IRQR123:1;
    uint_io32_t		u1IRQR124:1;
    uint_io32_t		u1IRQR125:1;
    uint_io32_t		u1IRQR126:1;
    uint_io32_t		u1IRQR127:1;
}stc_irc0_irqr3_field_t;

typedef union un_irc0_irqr3{
    uint_io32_t		u32Register;
    stc_irc0_irqr3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr3_t;

/* IRQR4 */
#define IRC0_IRQR4	(IRC0.unIRQR4.u32Register)  /*@rg@*/
#define IRC0_IRQR4_IRQR128	(IRC0.unIRQR4.stcField.u1IRQR128)  /*@bf@*/
#define IRC0_IRQR4_IRQR129	(IRC0.unIRQR4.stcField.u1IRQR129)  /*@bf@*/
#define IRC0_IRQR4_IRQR130	(IRC0.unIRQR4.stcField.u1IRQR130)  /*@bf@*/
#define IRC0_IRQR4_IRQR131	(IRC0.unIRQR4.stcField.u1IRQR131)  /*@bf@*/
#define IRC0_IRQR4_IRQR132	(IRC0.unIRQR4.stcField.u1IRQR132)  /*@bf@*/
#define IRC0_IRQR4_IRQR133	(IRC0.unIRQR4.stcField.u1IRQR133)  /*@bf@*/
#define IRC0_IRQR4_IRQR134	(IRC0.unIRQR4.stcField.u1IRQR134)  /*@bf@*/
#define IRC0_IRQR4_IRQR135	(IRC0.unIRQR4.stcField.u1IRQR135)  /*@bf@*/
#define IRC0_IRQR4_IRQR136	(IRC0.unIRQR4.stcField.u1IRQR136)  /*@bf@*/
#define IRC0_IRQR4_IRQR137	(IRC0.unIRQR4.stcField.u1IRQR137)  /*@bf@*/
#define IRC0_IRQR4_IRQR138	(IRC0.unIRQR4.stcField.u1IRQR138)  /*@bf@*/
#define IRC0_IRQR4_IRQR139	(IRC0.unIRQR4.stcField.u1IRQR139)  /*@bf@*/
#define IRC0_IRQR4_IRQR140	(IRC0.unIRQR4.stcField.u1IRQR140)  /*@bf@*/
#define IRC0_IRQR4_IRQR141	(IRC0.unIRQR4.stcField.u1IRQR141)  /*@bf@*/
#define IRC0_IRQR4_IRQR142	(IRC0.unIRQR4.stcField.u1IRQR142)  /*@bf@*/
#define IRC0_IRQR4_IRQR143	(IRC0.unIRQR4.stcField.u1IRQR143)  /*@bf@*/
#define IRC0_IRQR4_IRQR144	(IRC0.unIRQR4.stcField.u1IRQR144)  /*@bf@*/
#define IRC0_IRQR4_IRQR145	(IRC0.unIRQR4.stcField.u1IRQR145)  /*@bf@*/
#define IRC0_IRQR4_IRQR146	(IRC0.unIRQR4.stcField.u1IRQR146)  /*@bf@*/
#define IRC0_IRQR4_IRQR147	(IRC0.unIRQR4.stcField.u1IRQR147)  /*@bf@*/
#define IRC0_IRQR4_IRQR148	(IRC0.unIRQR4.stcField.u1IRQR148)  /*@bf@*/
#define IRC0_IRQR4_IRQR149	(IRC0.unIRQR4.stcField.u1IRQR149)  /*@bf@*/
#define IRC0_IRQR4_IRQR150	(IRC0.unIRQR4.stcField.u1IRQR150)  /*@bf@*/
#define IRC0_IRQR4_IRQR151	(IRC0.unIRQR4.stcField.u1IRQR151)  /*@bf@*/
#define IRC0_IRQR4_IRQR152	(IRC0.unIRQR4.stcField.u1IRQR152)  /*@bf@*/
#define IRC0_IRQR4_IRQR153	(IRC0.unIRQR4.stcField.u1IRQR153)  /*@bf@*/
#define IRC0_IRQR4_IRQR154	(IRC0.unIRQR4.stcField.u1IRQR154)  /*@bf@*/
#define IRC0_IRQR4_IRQR155	(IRC0.unIRQR4.stcField.u1IRQR155)  /*@bf@*/
#define IRC0_IRQR4_IRQR156	(IRC0.unIRQR4.stcField.u1IRQR156)  /*@bf@*/
#define IRC0_IRQR4_IRQR157	(IRC0.unIRQR4.stcField.u1IRQR157)  /*@bf@*/
#define IRC0_IRQR4_IRQR158	(IRC0.unIRQR4.stcField.u1IRQR158)  /*@bf@*/
#define IRC0_IRQR4_IRQR159	(IRC0.unIRQR4.stcField.u1IRQR159)  /*@bf@*/

typedef struct stc_irc0_irqr4_field{
    uint_io32_t		u1IRQR128:1;
    uint_io32_t		u1IRQR129:1;
    uint_io32_t		u1IRQR130:1;
    uint_io32_t		u1IRQR131:1;
    uint_io32_t		u1IRQR132:1;
    uint_io32_t		u1IRQR133:1;
    uint_io32_t		u1IRQR134:1;
    uint_io32_t		u1IRQR135:1;
    uint_io32_t		u1IRQR136:1;
    uint_io32_t		u1IRQR137:1;
    uint_io32_t		u1IRQR138:1;
    uint_io32_t		u1IRQR139:1;
    uint_io32_t		u1IRQR140:1;
    uint_io32_t		u1IRQR141:1;
    uint_io32_t		u1IRQR142:1;
    uint_io32_t		u1IRQR143:1;
    uint_io32_t		u1IRQR144:1;
    uint_io32_t		u1IRQR145:1;
    uint_io32_t		u1IRQR146:1;
    uint_io32_t		u1IRQR147:1;
    uint_io32_t		u1IRQR148:1;
    uint_io32_t		u1IRQR149:1;
    uint_io32_t		u1IRQR150:1;
    uint_io32_t		u1IRQR151:1;
    uint_io32_t		u1IRQR152:1;
    uint_io32_t		u1IRQR153:1;
    uint_io32_t		u1IRQR154:1;
    uint_io32_t		u1IRQR155:1;
    uint_io32_t		u1IRQR156:1;
    uint_io32_t		u1IRQR157:1;
    uint_io32_t		u1IRQR158:1;
    uint_io32_t		u1IRQR159:1;
}stc_irc0_irqr4_field_t;

typedef union un_irc0_irqr4{
    uint_io32_t		u32Register;
    stc_irc0_irqr4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr4_t;

/* IRQR5 */
#define IRC0_IRQR5	(IRC0.unIRQR5.u32Register)  /*@rg@*/
#define IRC0_IRQR5_IRQR160	(IRC0.unIRQR5.stcField.u1IRQR160)  /*@bf@*/
#define IRC0_IRQR5_IRQR161	(IRC0.unIRQR5.stcField.u1IRQR161)  /*@bf@*/
#define IRC0_IRQR5_IRQR162	(IRC0.unIRQR5.stcField.u1IRQR162)  /*@bf@*/
#define IRC0_IRQR5_IRQR163	(IRC0.unIRQR5.stcField.u1IRQR163)  /*@bf@*/
#define IRC0_IRQR5_IRQR164	(IRC0.unIRQR5.stcField.u1IRQR164)  /*@bf@*/
#define IRC0_IRQR5_IRQR165	(IRC0.unIRQR5.stcField.u1IRQR165)  /*@bf@*/
#define IRC0_IRQR5_IRQR166	(IRC0.unIRQR5.stcField.u1IRQR166)  /*@bf@*/
#define IRC0_IRQR5_IRQR167	(IRC0.unIRQR5.stcField.u1IRQR167)  /*@bf@*/
#define IRC0_IRQR5_IRQR168	(IRC0.unIRQR5.stcField.u1IRQR168)  /*@bf@*/
#define IRC0_IRQR5_IRQR169	(IRC0.unIRQR5.stcField.u1IRQR169)  /*@bf@*/
#define IRC0_IRQR5_IRQR170	(IRC0.unIRQR5.stcField.u1IRQR170)  /*@bf@*/
#define IRC0_IRQR5_IRQR171	(IRC0.unIRQR5.stcField.u1IRQR171)  /*@bf@*/
#define IRC0_IRQR5_IRQR172	(IRC0.unIRQR5.stcField.u1IRQR172)  /*@bf@*/
#define IRC0_IRQR5_IRQR173	(IRC0.unIRQR5.stcField.u1IRQR173)  /*@bf@*/
#define IRC0_IRQR5_IRQR174	(IRC0.unIRQR5.stcField.u1IRQR174)  /*@bf@*/
#define IRC0_IRQR5_IRQR175	(IRC0.unIRQR5.stcField.u1IRQR175)  /*@bf@*/
#define IRC0_IRQR5_IRQR176	(IRC0.unIRQR5.stcField.u1IRQR176)  /*@bf@*/
#define IRC0_IRQR5_IRQR177	(IRC0.unIRQR5.stcField.u1IRQR177)  /*@bf@*/
#define IRC0_IRQR5_IRQR178	(IRC0.unIRQR5.stcField.u1IRQR178)  /*@bf@*/
#define IRC0_IRQR5_IRQR179	(IRC0.unIRQR5.stcField.u1IRQR179)  /*@bf@*/
#define IRC0_IRQR5_IRQR180	(IRC0.unIRQR5.stcField.u1IRQR180)  /*@bf@*/
#define IRC0_IRQR5_IRQR181	(IRC0.unIRQR5.stcField.u1IRQR181)  /*@bf@*/
#define IRC0_IRQR5_IRQR182	(IRC0.unIRQR5.stcField.u1IRQR182)  /*@bf@*/
#define IRC0_IRQR5_IRQR183	(IRC0.unIRQR5.stcField.u1IRQR183)  /*@bf@*/
#define IRC0_IRQR5_IRQR184	(IRC0.unIRQR5.stcField.u1IRQR184)  /*@bf@*/
#define IRC0_IRQR5_IRQR185	(IRC0.unIRQR5.stcField.u1IRQR185)  /*@bf@*/
#define IRC0_IRQR5_IRQR186	(IRC0.unIRQR5.stcField.u1IRQR186)  /*@bf@*/
#define IRC0_IRQR5_IRQR187	(IRC0.unIRQR5.stcField.u1IRQR187)  /*@bf@*/
#define IRC0_IRQR5_IRQR188	(IRC0.unIRQR5.stcField.u1IRQR188)  /*@bf@*/
#define IRC0_IRQR5_IRQR189	(IRC0.unIRQR5.stcField.u1IRQR189)  /*@bf@*/
#define IRC0_IRQR5_IRQR190	(IRC0.unIRQR5.stcField.u1IRQR190)  /*@bf@*/
#define IRC0_IRQR5_IRQR191	(IRC0.unIRQR5.stcField.u1IRQR191)  /*@bf@*/

typedef struct stc_irc0_irqr5_field{
    uint_io32_t		u1IRQR160:1;
    uint_io32_t		u1IRQR161:1;
    uint_io32_t		u1IRQR162:1;
    uint_io32_t		u1IRQR163:1;
    uint_io32_t		u1IRQR164:1;
    uint_io32_t		u1IRQR165:1;
    uint_io32_t		u1IRQR166:1;
    uint_io32_t		u1IRQR167:1;
    uint_io32_t		u1IRQR168:1;
    uint_io32_t		u1IRQR169:1;
    uint_io32_t		u1IRQR170:1;
    uint_io32_t		u1IRQR171:1;
    uint_io32_t		u1IRQR172:1;
    uint_io32_t		u1IRQR173:1;
    uint_io32_t		u1IRQR174:1;
    uint_io32_t		u1IRQR175:1;
    uint_io32_t		u1IRQR176:1;
    uint_io32_t		u1IRQR177:1;
    uint_io32_t		u1IRQR178:1;
    uint_io32_t		u1IRQR179:1;
    uint_io32_t		u1IRQR180:1;
    uint_io32_t		u1IRQR181:1;
    uint_io32_t		u1IRQR182:1;
    uint_io32_t		u1IRQR183:1;
    uint_io32_t		u1IRQR184:1;
    uint_io32_t		u1IRQR185:1;
    uint_io32_t		u1IRQR186:1;
    uint_io32_t		u1IRQR187:1;
    uint_io32_t		u1IRQR188:1;
    uint_io32_t		u1IRQR189:1;
    uint_io32_t		u1IRQR190:1;
    uint_io32_t		u1IRQR191:1;
}stc_irc0_irqr5_field_t;

typedef union un_irc0_irqr5{
    uint_io32_t		u32Register;
    stc_irc0_irqr5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr5_t;

/* IRQR6 */
#define IRC0_IRQR6	(IRC0.unIRQR6.u32Register)  /*@rg@*/
#define IRC0_IRQR6_IRQR192	(IRC0.unIRQR6.stcField.u1IRQR192)  /*@bf@*/
#define IRC0_IRQR6_IRQR193	(IRC0.unIRQR6.stcField.u1IRQR193)  /*@bf@*/
#define IRC0_IRQR6_IRQR194	(IRC0.unIRQR6.stcField.u1IRQR194)  /*@bf@*/
#define IRC0_IRQR6_IRQR195	(IRC0.unIRQR6.stcField.u1IRQR195)  /*@bf@*/
#define IRC0_IRQR6_IRQR196	(IRC0.unIRQR6.stcField.u1IRQR196)  /*@bf@*/
#define IRC0_IRQR6_IRQR197	(IRC0.unIRQR6.stcField.u1IRQR197)  /*@bf@*/
#define IRC0_IRQR6_IRQR198	(IRC0.unIRQR6.stcField.u1IRQR198)  /*@bf@*/
#define IRC0_IRQR6_IRQR199	(IRC0.unIRQR6.stcField.u1IRQR199)  /*@bf@*/
#define IRC0_IRQR6_IRQR200	(IRC0.unIRQR6.stcField.u1IRQR200)  /*@bf@*/
#define IRC0_IRQR6_IRQR201	(IRC0.unIRQR6.stcField.u1IRQR201)  /*@bf@*/
#define IRC0_IRQR6_IRQR202	(IRC0.unIRQR6.stcField.u1IRQR202)  /*@bf@*/
#define IRC0_IRQR6_IRQR203	(IRC0.unIRQR6.stcField.u1IRQR203)  /*@bf@*/
#define IRC0_IRQR6_IRQR204	(IRC0.unIRQR6.stcField.u1IRQR204)  /*@bf@*/
#define IRC0_IRQR6_IRQR205	(IRC0.unIRQR6.stcField.u1IRQR205)  /*@bf@*/
#define IRC0_IRQR6_IRQR206	(IRC0.unIRQR6.stcField.u1IRQR206)  /*@bf@*/
#define IRC0_IRQR6_IRQR207	(IRC0.unIRQR6.stcField.u1IRQR207)  /*@bf@*/
#define IRC0_IRQR6_IRQR208	(IRC0.unIRQR6.stcField.u1IRQR208)  /*@bf@*/
#define IRC0_IRQR6_IRQR209	(IRC0.unIRQR6.stcField.u1IRQR209)  /*@bf@*/
#define IRC0_IRQR6_IRQR210	(IRC0.unIRQR6.stcField.u1IRQR210)  /*@bf@*/
#define IRC0_IRQR6_IRQR211	(IRC0.unIRQR6.stcField.u1IRQR211)  /*@bf@*/
#define IRC0_IRQR6_IRQR212	(IRC0.unIRQR6.stcField.u1IRQR212)  /*@bf@*/
#define IRC0_IRQR6_IRQR213	(IRC0.unIRQR6.stcField.u1IRQR213)  /*@bf@*/
#define IRC0_IRQR6_IRQR214	(IRC0.unIRQR6.stcField.u1IRQR214)  /*@bf@*/
#define IRC0_IRQR6_IRQR215	(IRC0.unIRQR6.stcField.u1IRQR215)  /*@bf@*/
#define IRC0_IRQR6_IRQR216	(IRC0.unIRQR6.stcField.u1IRQR216)  /*@bf@*/
#define IRC0_IRQR6_IRQR217	(IRC0.unIRQR6.stcField.u1IRQR217)  /*@bf@*/
#define IRC0_IRQR6_IRQR218	(IRC0.unIRQR6.stcField.u1IRQR218)  /*@bf@*/
#define IRC0_IRQR6_IRQR219	(IRC0.unIRQR6.stcField.u1IRQR219)  /*@bf@*/
#define IRC0_IRQR6_IRQR220	(IRC0.unIRQR6.stcField.u1IRQR220)  /*@bf@*/
#define IRC0_IRQR6_IRQR221	(IRC0.unIRQR6.stcField.u1IRQR221)  /*@bf@*/
#define IRC0_IRQR6_IRQR222	(IRC0.unIRQR6.stcField.u1IRQR222)  /*@bf@*/
#define IRC0_IRQR6_IRQR223	(IRC0.unIRQR6.stcField.u1IRQR223)  /*@bf@*/

typedef struct stc_irc0_irqr6_field{
    uint_io32_t		u1IRQR192:1;
    uint_io32_t		u1IRQR193:1;
    uint_io32_t		u1IRQR194:1;
    uint_io32_t		u1IRQR195:1;
    uint_io32_t		u1IRQR196:1;
    uint_io32_t		u1IRQR197:1;
    uint_io32_t		u1IRQR198:1;
    uint_io32_t		u1IRQR199:1;
    uint_io32_t		u1IRQR200:1;
    uint_io32_t		u1IRQR201:1;
    uint_io32_t		u1IRQR202:1;
    uint_io32_t		u1IRQR203:1;
    uint_io32_t		u1IRQR204:1;
    uint_io32_t		u1IRQR205:1;
    uint_io32_t		u1IRQR206:1;
    uint_io32_t		u1IRQR207:1;
    uint_io32_t		u1IRQR208:1;
    uint_io32_t		u1IRQR209:1;
    uint_io32_t		u1IRQR210:1;
    uint_io32_t		u1IRQR211:1;
    uint_io32_t		u1IRQR212:1;
    uint_io32_t		u1IRQR213:1;
    uint_io32_t		u1IRQR214:1;
    uint_io32_t		u1IRQR215:1;
    uint_io32_t		u1IRQR216:1;
    uint_io32_t		u1IRQR217:1;
    uint_io32_t		u1IRQR218:1;
    uint_io32_t		u1IRQR219:1;
    uint_io32_t		u1IRQR220:1;
    uint_io32_t		u1IRQR221:1;
    uint_io32_t		u1IRQR222:1;
    uint_io32_t		u1IRQR223:1;
}stc_irc0_irqr6_field_t;

typedef union un_irc0_irqr6{
    uint_io32_t		u32Register;
    stc_irc0_irqr6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr6_t;

/* IRQR7 */
#define IRC0_IRQR7	(IRC0.unIRQR7.u32Register)  /*@rg@*/
#define IRC0_IRQR7_IRQR224	(IRC0.unIRQR7.stcField.u1IRQR224)  /*@bf@*/
#define IRC0_IRQR7_IRQR225	(IRC0.unIRQR7.stcField.u1IRQR225)  /*@bf@*/
#define IRC0_IRQR7_IRQR226	(IRC0.unIRQR7.stcField.u1IRQR226)  /*@bf@*/
#define IRC0_IRQR7_IRQR227	(IRC0.unIRQR7.stcField.u1IRQR227)  /*@bf@*/
#define IRC0_IRQR7_IRQR228	(IRC0.unIRQR7.stcField.u1IRQR228)  /*@bf@*/
#define IRC0_IRQR7_IRQR229	(IRC0.unIRQR7.stcField.u1IRQR229)  /*@bf@*/
#define IRC0_IRQR7_IRQR230	(IRC0.unIRQR7.stcField.u1IRQR230)  /*@bf@*/
#define IRC0_IRQR7_IRQR231	(IRC0.unIRQR7.stcField.u1IRQR231)  /*@bf@*/
#define IRC0_IRQR7_IRQR232	(IRC0.unIRQR7.stcField.u1IRQR232)  /*@bf@*/
#define IRC0_IRQR7_IRQR233	(IRC0.unIRQR7.stcField.u1IRQR233)  /*@bf@*/
#define IRC0_IRQR7_IRQR234	(IRC0.unIRQR7.stcField.u1IRQR234)  /*@bf@*/
#define IRC0_IRQR7_IRQR235	(IRC0.unIRQR7.stcField.u1IRQR235)  /*@bf@*/
#define IRC0_IRQR7_IRQR236	(IRC0.unIRQR7.stcField.u1IRQR236)  /*@bf@*/
#define IRC0_IRQR7_IRQR237	(IRC0.unIRQR7.stcField.u1IRQR237)  /*@bf@*/
#define IRC0_IRQR7_IRQR238	(IRC0.unIRQR7.stcField.u1IRQR238)  /*@bf@*/
#define IRC0_IRQR7_IRQR239	(IRC0.unIRQR7.stcField.u1IRQR239)  /*@bf@*/
#define IRC0_IRQR7_IRQR240	(IRC0.unIRQR7.stcField.u1IRQR240)  /*@bf@*/
#define IRC0_IRQR7_IRQR241	(IRC0.unIRQR7.stcField.u1IRQR241)  /*@bf@*/
#define IRC0_IRQR7_IRQR242	(IRC0.unIRQR7.stcField.u1IRQR242)  /*@bf@*/
#define IRC0_IRQR7_IRQR243	(IRC0.unIRQR7.stcField.u1IRQR243)  /*@bf@*/
#define IRC0_IRQR7_IRQR244	(IRC0.unIRQR7.stcField.u1IRQR244)  /*@bf@*/
#define IRC0_IRQR7_IRQR245	(IRC0.unIRQR7.stcField.u1IRQR245)  /*@bf@*/
#define IRC0_IRQR7_IRQR246	(IRC0.unIRQR7.stcField.u1IRQR246)  /*@bf@*/
#define IRC0_IRQR7_IRQR247	(IRC0.unIRQR7.stcField.u1IRQR247)  /*@bf@*/
#define IRC0_IRQR7_IRQR248	(IRC0.unIRQR7.stcField.u1IRQR248)  /*@bf@*/
#define IRC0_IRQR7_IRQR249	(IRC0.unIRQR7.stcField.u1IRQR249)  /*@bf@*/
#define IRC0_IRQR7_IRQR250	(IRC0.unIRQR7.stcField.u1IRQR250)  /*@bf@*/
#define IRC0_IRQR7_IRQR251	(IRC0.unIRQR7.stcField.u1IRQR251)  /*@bf@*/
#define IRC0_IRQR7_IRQR252	(IRC0.unIRQR7.stcField.u1IRQR252)  /*@bf@*/
#define IRC0_IRQR7_IRQR253	(IRC0.unIRQR7.stcField.u1IRQR253)  /*@bf@*/
#define IRC0_IRQR7_IRQR254	(IRC0.unIRQR7.stcField.u1IRQR254)  /*@bf@*/
#define IRC0_IRQR7_IRQR255	(IRC0.unIRQR7.stcField.u1IRQR255)  /*@bf@*/

typedef struct stc_irc0_irqr7_field{
    uint_io32_t		u1IRQR224:1;
    uint_io32_t		u1IRQR225:1;
    uint_io32_t		u1IRQR226:1;
    uint_io32_t		u1IRQR227:1;
    uint_io32_t		u1IRQR228:1;
    uint_io32_t		u1IRQR229:1;
    uint_io32_t		u1IRQR230:1;
    uint_io32_t		u1IRQR231:1;
    uint_io32_t		u1IRQR232:1;
    uint_io32_t		u1IRQR233:1;
    uint_io32_t		u1IRQR234:1;
    uint_io32_t		u1IRQR235:1;
    uint_io32_t		u1IRQR236:1;
    uint_io32_t		u1IRQR237:1;
    uint_io32_t		u1IRQR238:1;
    uint_io32_t		u1IRQR239:1;
    uint_io32_t		u1IRQR240:1;
    uint_io32_t		u1IRQR241:1;
    uint_io32_t		u1IRQR242:1;
    uint_io32_t		u1IRQR243:1;
    uint_io32_t		u1IRQR244:1;
    uint_io32_t		u1IRQR245:1;
    uint_io32_t		u1IRQR246:1;
    uint_io32_t		u1IRQR247:1;
    uint_io32_t		u1IRQR248:1;
    uint_io32_t		u1IRQR249:1;
    uint_io32_t		u1IRQR250:1;
    uint_io32_t		u1IRQR251:1;
    uint_io32_t		u1IRQR252:1;
    uint_io32_t		u1IRQR253:1;
    uint_io32_t		u1IRQR254:1;
    uint_io32_t		u1IRQR255:1;
}stc_irc0_irqr7_field_t;

typedef union un_irc0_irqr7{
    uint_io32_t		u32Register;
    stc_irc0_irqr7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr7_t;

/* IRQR8 */
#define IRC0_IRQR8	(IRC0.unIRQR8.u32Register)  /*@rg@*/
#define IRC0_IRQR8_IRQR256	(IRC0.unIRQR8.stcField.u1IRQR256)  /*@bf@*/
#define IRC0_IRQR8_IRQR257	(IRC0.unIRQR8.stcField.u1IRQR257)  /*@bf@*/
#define IRC0_IRQR8_IRQR258	(IRC0.unIRQR8.stcField.u1IRQR258)  /*@bf@*/
#define IRC0_IRQR8_IRQR259	(IRC0.unIRQR8.stcField.u1IRQR259)  /*@bf@*/
#define IRC0_IRQR8_IRQR260	(IRC0.unIRQR8.stcField.u1IRQR260)  /*@bf@*/
#define IRC0_IRQR8_IRQR261	(IRC0.unIRQR8.stcField.u1IRQR261)  /*@bf@*/
#define IRC0_IRQR8_IRQR262	(IRC0.unIRQR8.stcField.u1IRQR262)  /*@bf@*/
#define IRC0_IRQR8_IRQR263	(IRC0.unIRQR8.stcField.u1IRQR263)  /*@bf@*/
#define IRC0_IRQR8_IRQR264	(IRC0.unIRQR8.stcField.u1IRQR264)  /*@bf@*/
#define IRC0_IRQR8_IRQR265	(IRC0.unIRQR8.stcField.u1IRQR265)  /*@bf@*/
#define IRC0_IRQR8_IRQR266	(IRC0.unIRQR8.stcField.u1IRQR266)  /*@bf@*/
#define IRC0_IRQR8_IRQR267	(IRC0.unIRQR8.stcField.u1IRQR267)  /*@bf@*/
#define IRC0_IRQR8_IRQR268	(IRC0.unIRQR8.stcField.u1IRQR268)  /*@bf@*/
#define IRC0_IRQR8_IRQR269	(IRC0.unIRQR8.stcField.u1IRQR269)  /*@bf@*/
#define IRC0_IRQR8_IRQR270	(IRC0.unIRQR8.stcField.u1IRQR270)  /*@bf@*/
#define IRC0_IRQR8_IRQR271	(IRC0.unIRQR8.stcField.u1IRQR271)  /*@bf@*/
#define IRC0_IRQR8_IRQR272	(IRC0.unIRQR8.stcField.u1IRQR272)  /*@bf@*/
#define IRC0_IRQR8_IRQR273	(IRC0.unIRQR8.stcField.u1IRQR273)  /*@bf@*/
#define IRC0_IRQR8_IRQR274	(IRC0.unIRQR8.stcField.u1IRQR274)  /*@bf@*/
#define IRC0_IRQR8_IRQR275	(IRC0.unIRQR8.stcField.u1IRQR275)  /*@bf@*/
#define IRC0_IRQR8_IRQR276	(IRC0.unIRQR8.stcField.u1IRQR276)  /*@bf@*/
#define IRC0_IRQR8_IRQR277	(IRC0.unIRQR8.stcField.u1IRQR277)  /*@bf@*/
#define IRC0_IRQR8_IRQR278	(IRC0.unIRQR8.stcField.u1IRQR278)  /*@bf@*/
#define IRC0_IRQR8_IRQR279	(IRC0.unIRQR8.stcField.u1IRQR279)  /*@bf@*/
#define IRC0_IRQR8_IRQR280	(IRC0.unIRQR8.stcField.u1IRQR280)  /*@bf@*/
#define IRC0_IRQR8_IRQR281	(IRC0.unIRQR8.stcField.u1IRQR281)  /*@bf@*/
#define IRC0_IRQR8_IRQR282	(IRC0.unIRQR8.stcField.u1IRQR282)  /*@bf@*/
#define IRC0_IRQR8_IRQR283	(IRC0.unIRQR8.stcField.u1IRQR283)  /*@bf@*/
#define IRC0_IRQR8_IRQR284	(IRC0.unIRQR8.stcField.u1IRQR284)  /*@bf@*/
#define IRC0_IRQR8_IRQR285	(IRC0.unIRQR8.stcField.u1IRQR285)  /*@bf@*/
#define IRC0_IRQR8_IRQR286	(IRC0.unIRQR8.stcField.u1IRQR286)  /*@bf@*/
#define IRC0_IRQR8_IRQR287	(IRC0.unIRQR8.stcField.u1IRQR287)  /*@bf@*/

typedef struct stc_irc0_irqr8_field{
    uint_io32_t		u1IRQR256:1;
    uint_io32_t		u1IRQR257:1;
    uint_io32_t		u1IRQR258:1;
    uint_io32_t		u1IRQR259:1;
    uint_io32_t		u1IRQR260:1;
    uint_io32_t		u1IRQR261:1;
    uint_io32_t		u1IRQR262:1;
    uint_io32_t		u1IRQR263:1;
    uint_io32_t		u1IRQR264:1;
    uint_io32_t		u1IRQR265:1;
    uint_io32_t		u1IRQR266:1;
    uint_io32_t		u1IRQR267:1;
    uint_io32_t		u1IRQR268:1;
    uint_io32_t		u1IRQR269:1;
    uint_io32_t		u1IRQR270:1;
    uint_io32_t		u1IRQR271:1;
    uint_io32_t		u1IRQR272:1;
    uint_io32_t		u1IRQR273:1;
    uint_io32_t		u1IRQR274:1;
    uint_io32_t		u1IRQR275:1;
    uint_io32_t		u1IRQR276:1;
    uint_io32_t		u1IRQR277:1;
    uint_io32_t		u1IRQR278:1;
    uint_io32_t		u1IRQR279:1;
    uint_io32_t		u1IRQR280:1;
    uint_io32_t		u1IRQR281:1;
    uint_io32_t		u1IRQR282:1;
    uint_io32_t		u1IRQR283:1;
    uint_io32_t		u1IRQR284:1;
    uint_io32_t		u1IRQR285:1;
    uint_io32_t		u1IRQR286:1;
    uint_io32_t		u1IRQR287:1;
}stc_irc0_irqr8_field_t;

typedef union un_irc0_irqr8{
    uint_io32_t		u32Register;
    stc_irc0_irqr8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr8_t;

/* IRQR9 */
#define IRC0_IRQR9	(IRC0.unIRQR9.u32Register)  /*@rg@*/
#define IRC0_IRQR9_IRQR288	(IRC0.unIRQR9.stcField.u1IRQR288)  /*@bf@*/
#define IRC0_IRQR9_IRQR289	(IRC0.unIRQR9.stcField.u1IRQR289)  /*@bf@*/
#define IRC0_IRQR9_IRQR290	(IRC0.unIRQR9.stcField.u1IRQR290)  /*@bf@*/
#define IRC0_IRQR9_IRQR291	(IRC0.unIRQR9.stcField.u1IRQR291)  /*@bf@*/
#define IRC0_IRQR9_IRQR292	(IRC0.unIRQR9.stcField.u1IRQR292)  /*@bf@*/
#define IRC0_IRQR9_IRQR293	(IRC0.unIRQR9.stcField.u1IRQR293)  /*@bf@*/
#define IRC0_IRQR9_IRQR294	(IRC0.unIRQR9.stcField.u1IRQR294)  /*@bf@*/
#define IRC0_IRQR9_IRQR295	(IRC0.unIRQR9.stcField.u1IRQR295)  /*@bf@*/
#define IRC0_IRQR9_IRQR296	(IRC0.unIRQR9.stcField.u1IRQR296)  /*@bf@*/
#define IRC0_IRQR9_IRQR297	(IRC0.unIRQR9.stcField.u1IRQR297)  /*@bf@*/
#define IRC0_IRQR9_IRQR298	(IRC0.unIRQR9.stcField.u1IRQR298)  /*@bf@*/
#define IRC0_IRQR9_IRQR299	(IRC0.unIRQR9.stcField.u1IRQR299)  /*@bf@*/
#define IRC0_IRQR9_IRQR300	(IRC0.unIRQR9.stcField.u1IRQR300)  /*@bf@*/
#define IRC0_IRQR9_IRQR301	(IRC0.unIRQR9.stcField.u1IRQR301)  /*@bf@*/
#define IRC0_IRQR9_IRQR302	(IRC0.unIRQR9.stcField.u1IRQR302)  /*@bf@*/
#define IRC0_IRQR9_IRQR303	(IRC0.unIRQR9.stcField.u1IRQR303)  /*@bf@*/
#define IRC0_IRQR9_IRQR304	(IRC0.unIRQR9.stcField.u1IRQR304)  /*@bf@*/
#define IRC0_IRQR9_IRQR305	(IRC0.unIRQR9.stcField.u1IRQR305)  /*@bf@*/
#define IRC0_IRQR9_IRQR306	(IRC0.unIRQR9.stcField.u1IRQR306)  /*@bf@*/
#define IRC0_IRQR9_IRQR307	(IRC0.unIRQR9.stcField.u1IRQR307)  /*@bf@*/
#define IRC0_IRQR9_IRQR308	(IRC0.unIRQR9.stcField.u1IRQR308)  /*@bf@*/
#define IRC0_IRQR9_IRQR309	(IRC0.unIRQR9.stcField.u1IRQR309)  /*@bf@*/
#define IRC0_IRQR9_IRQR310	(IRC0.unIRQR9.stcField.u1IRQR310)  /*@bf@*/
#define IRC0_IRQR9_IRQR311	(IRC0.unIRQR9.stcField.u1IRQR311)  /*@bf@*/
#define IRC0_IRQR9_IRQR312	(IRC0.unIRQR9.stcField.u1IRQR312)  /*@bf@*/
#define IRC0_IRQR9_IRQR313	(IRC0.unIRQR9.stcField.u1IRQR313)  /*@bf@*/
#define IRC0_IRQR9_IRQR314	(IRC0.unIRQR9.stcField.u1IRQR314)  /*@bf@*/
#define IRC0_IRQR9_IRQR315	(IRC0.unIRQR9.stcField.u1IRQR315)  /*@bf@*/
#define IRC0_IRQR9_IRQR316	(IRC0.unIRQR9.stcField.u1IRQR316)  /*@bf@*/
#define IRC0_IRQR9_IRQR317	(IRC0.unIRQR9.stcField.u1IRQR317)  /*@bf@*/
#define IRC0_IRQR9_IRQR318	(IRC0.unIRQR9.stcField.u1IRQR318)  /*@bf@*/
#define IRC0_IRQR9_IRQR319	(IRC0.unIRQR9.stcField.u1IRQR319)  /*@bf@*/

typedef struct stc_irc0_irqr9_field{
    uint_io32_t		u1IRQR288:1;
    uint_io32_t		u1IRQR289:1;
    uint_io32_t		u1IRQR290:1;
    uint_io32_t		u1IRQR291:1;
    uint_io32_t		u1IRQR292:1;
    uint_io32_t		u1IRQR293:1;
    uint_io32_t		u1IRQR294:1;
    uint_io32_t		u1IRQR295:1;
    uint_io32_t		u1IRQR296:1;
    uint_io32_t		u1IRQR297:1;
    uint_io32_t		u1IRQR298:1;
    uint_io32_t		u1IRQR299:1;
    uint_io32_t		u1IRQR300:1;
    uint_io32_t		u1IRQR301:1;
    uint_io32_t		u1IRQR302:1;
    uint_io32_t		u1IRQR303:1;
    uint_io32_t		u1IRQR304:1;
    uint_io32_t		u1IRQR305:1;
    uint_io32_t		u1IRQR306:1;
    uint_io32_t		u1IRQR307:1;
    uint_io32_t		u1IRQR308:1;
    uint_io32_t		u1IRQR309:1;
    uint_io32_t		u1IRQR310:1;
    uint_io32_t		u1IRQR311:1;
    uint_io32_t		u1IRQR312:1;
    uint_io32_t		u1IRQR313:1;
    uint_io32_t		u1IRQR314:1;
    uint_io32_t		u1IRQR315:1;
    uint_io32_t		u1IRQR316:1;
    uint_io32_t		u1IRQR317:1;
    uint_io32_t		u1IRQR318:1;
    uint_io32_t		u1IRQR319:1;
}stc_irc0_irqr9_field_t;

typedef union un_irc0_irqr9{
    uint_io32_t		u32Register;
    stc_irc0_irqr9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr9_t;

/* IRQR10 */
#define IRC0_IRQR10	(IRC0.unIRQR10.u32Register)  /*@rg@*/
#define IRC0_IRQR10_IRQR320	(IRC0.unIRQR10.stcField.u1IRQR320)  /*@bf@*/
#define IRC0_IRQR10_IRQR321	(IRC0.unIRQR10.stcField.u1IRQR321)  /*@bf@*/
#define IRC0_IRQR10_IRQR322	(IRC0.unIRQR10.stcField.u1IRQR322)  /*@bf@*/
#define IRC0_IRQR10_IRQR323	(IRC0.unIRQR10.stcField.u1IRQR323)  /*@bf@*/
#define IRC0_IRQR10_IRQR324	(IRC0.unIRQR10.stcField.u1IRQR324)  /*@bf@*/
#define IRC0_IRQR10_IRQR325	(IRC0.unIRQR10.stcField.u1IRQR325)  /*@bf@*/
#define IRC0_IRQR10_IRQR326	(IRC0.unIRQR10.stcField.u1IRQR326)  /*@bf@*/
#define IRC0_IRQR10_IRQR327	(IRC0.unIRQR10.stcField.u1IRQR327)  /*@bf@*/
#define IRC0_IRQR10_IRQR328	(IRC0.unIRQR10.stcField.u1IRQR328)  /*@bf@*/
#define IRC0_IRQR10_IRQR329	(IRC0.unIRQR10.stcField.u1IRQR329)  /*@bf@*/
#define IRC0_IRQR10_IRQR330	(IRC0.unIRQR10.stcField.u1IRQR330)  /*@bf@*/
#define IRC0_IRQR10_IRQR331	(IRC0.unIRQR10.stcField.u1IRQR331)  /*@bf@*/
#define IRC0_IRQR10_IRQR332	(IRC0.unIRQR10.stcField.u1IRQR332)  /*@bf@*/
#define IRC0_IRQR10_IRQR333	(IRC0.unIRQR10.stcField.u1IRQR333)  /*@bf@*/
#define IRC0_IRQR10_IRQR334	(IRC0.unIRQR10.stcField.u1IRQR334)  /*@bf@*/
#define IRC0_IRQR10_IRQR335	(IRC0.unIRQR10.stcField.u1IRQR335)  /*@bf@*/
#define IRC0_IRQR10_IRQR336	(IRC0.unIRQR10.stcField.u1IRQR336)  /*@bf@*/
#define IRC0_IRQR10_IRQR337	(IRC0.unIRQR10.stcField.u1IRQR337)  /*@bf@*/
#define IRC0_IRQR10_IRQR338	(IRC0.unIRQR10.stcField.u1IRQR338)  /*@bf@*/
#define IRC0_IRQR10_IRQR339	(IRC0.unIRQR10.stcField.u1IRQR339)  /*@bf@*/
#define IRC0_IRQR10_IRQR340	(IRC0.unIRQR10.stcField.u1IRQR340)  /*@bf@*/
#define IRC0_IRQR10_IRQR341	(IRC0.unIRQR10.stcField.u1IRQR341)  /*@bf@*/
#define IRC0_IRQR10_IRQR342	(IRC0.unIRQR10.stcField.u1IRQR342)  /*@bf@*/
#define IRC0_IRQR10_IRQR343	(IRC0.unIRQR10.stcField.u1IRQR343)  /*@bf@*/
#define IRC0_IRQR10_IRQR344	(IRC0.unIRQR10.stcField.u1IRQR344)  /*@bf@*/
#define IRC0_IRQR10_IRQR345	(IRC0.unIRQR10.stcField.u1IRQR345)  /*@bf@*/
#define IRC0_IRQR10_IRQR346	(IRC0.unIRQR10.stcField.u1IRQR346)  /*@bf@*/
#define IRC0_IRQR10_IRQR347	(IRC0.unIRQR10.stcField.u1IRQR347)  /*@bf@*/
#define IRC0_IRQR10_IRQR348	(IRC0.unIRQR10.stcField.u1IRQR348)  /*@bf@*/
#define IRC0_IRQR10_IRQR349	(IRC0.unIRQR10.stcField.u1IRQR349)  /*@bf@*/
#define IRC0_IRQR10_IRQR350	(IRC0.unIRQR10.stcField.u1IRQR350)  /*@bf@*/
#define IRC0_IRQR10_IRQR351	(IRC0.unIRQR10.stcField.u1IRQR351)  /*@bf@*/

typedef struct stc_irc0_irqr10_field{
    uint_io32_t		u1IRQR320:1;
    uint_io32_t		u1IRQR321:1;
    uint_io32_t		u1IRQR322:1;
    uint_io32_t		u1IRQR323:1;
    uint_io32_t		u1IRQR324:1;
    uint_io32_t		u1IRQR325:1;
    uint_io32_t		u1IRQR326:1;
    uint_io32_t		u1IRQR327:1;
    uint_io32_t		u1IRQR328:1;
    uint_io32_t		u1IRQR329:1;
    uint_io32_t		u1IRQR330:1;
    uint_io32_t		u1IRQR331:1;
    uint_io32_t		u1IRQR332:1;
    uint_io32_t		u1IRQR333:1;
    uint_io32_t		u1IRQR334:1;
    uint_io32_t		u1IRQR335:1;
    uint_io32_t		u1IRQR336:1;
    uint_io32_t		u1IRQR337:1;
    uint_io32_t		u1IRQR338:1;
    uint_io32_t		u1IRQR339:1;
    uint_io32_t		u1IRQR340:1;
    uint_io32_t		u1IRQR341:1;
    uint_io32_t		u1IRQR342:1;
    uint_io32_t		u1IRQR343:1;
    uint_io32_t		u1IRQR344:1;
    uint_io32_t		u1IRQR345:1;
    uint_io32_t		u1IRQR346:1;
    uint_io32_t		u1IRQR347:1;
    uint_io32_t		u1IRQR348:1;
    uint_io32_t		u1IRQR349:1;
    uint_io32_t		u1IRQR350:1;
    uint_io32_t		u1IRQR351:1;
}stc_irc0_irqr10_field_t;

typedef union un_irc0_irqr10{
    uint_io32_t		u32Register;
    stc_irc0_irqr10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr10_t;

/* IRQR11 */
#define IRC0_IRQR11	(IRC0.unIRQR11.u32Register)  /*@rg@*/
#define IRC0_IRQR11_IRQR352	(IRC0.unIRQR11.stcField.u1IRQR352)  /*@bf@*/
#define IRC0_IRQR11_IRQR353	(IRC0.unIRQR11.stcField.u1IRQR353)  /*@bf@*/
#define IRC0_IRQR11_IRQR354	(IRC0.unIRQR11.stcField.u1IRQR354)  /*@bf@*/
#define IRC0_IRQR11_IRQR355	(IRC0.unIRQR11.stcField.u1IRQR355)  /*@bf@*/
#define IRC0_IRQR11_IRQR356	(IRC0.unIRQR11.stcField.u1IRQR356)  /*@bf@*/
#define IRC0_IRQR11_IRQR357	(IRC0.unIRQR11.stcField.u1IRQR357)  /*@bf@*/
#define IRC0_IRQR11_IRQR358	(IRC0.unIRQR11.stcField.u1IRQR358)  /*@bf@*/
#define IRC0_IRQR11_IRQR359	(IRC0.unIRQR11.stcField.u1IRQR359)  /*@bf@*/
#define IRC0_IRQR11_IRQR360	(IRC0.unIRQR11.stcField.u1IRQR360)  /*@bf@*/
#define IRC0_IRQR11_IRQR361	(IRC0.unIRQR11.stcField.u1IRQR361)  /*@bf@*/
#define IRC0_IRQR11_IRQR362	(IRC0.unIRQR11.stcField.u1IRQR362)  /*@bf@*/
#define IRC0_IRQR11_IRQR363	(IRC0.unIRQR11.stcField.u1IRQR363)  /*@bf@*/
#define IRC0_IRQR11_IRQR364	(IRC0.unIRQR11.stcField.u1IRQR364)  /*@bf@*/
#define IRC0_IRQR11_IRQR365	(IRC0.unIRQR11.stcField.u1IRQR365)  /*@bf@*/
#define IRC0_IRQR11_IRQR366	(IRC0.unIRQR11.stcField.u1IRQR366)  /*@bf@*/
#define IRC0_IRQR11_IRQR367	(IRC0.unIRQR11.stcField.u1IRQR367)  /*@bf@*/
#define IRC0_IRQR11_IRQR368	(IRC0.unIRQR11.stcField.u1IRQR368)  /*@bf@*/
#define IRC0_IRQR11_IRQR369	(IRC0.unIRQR11.stcField.u1IRQR369)  /*@bf@*/
#define IRC0_IRQR11_IRQR370	(IRC0.unIRQR11.stcField.u1IRQR370)  /*@bf@*/
#define IRC0_IRQR11_IRQR371	(IRC0.unIRQR11.stcField.u1IRQR371)  /*@bf@*/
#define IRC0_IRQR11_IRQR372	(IRC0.unIRQR11.stcField.u1IRQR372)  /*@bf@*/
#define IRC0_IRQR11_IRQR373	(IRC0.unIRQR11.stcField.u1IRQR373)  /*@bf@*/
#define IRC0_IRQR11_IRQR374	(IRC0.unIRQR11.stcField.u1IRQR374)  /*@bf@*/
#define IRC0_IRQR11_IRQR375	(IRC0.unIRQR11.stcField.u1IRQR375)  /*@bf@*/
#define IRC0_IRQR11_IRQR376	(IRC0.unIRQR11.stcField.u1IRQR376)  /*@bf@*/
#define IRC0_IRQR11_IRQR377	(IRC0.unIRQR11.stcField.u1IRQR377)  /*@bf@*/
#define IRC0_IRQR11_IRQR378	(IRC0.unIRQR11.stcField.u1IRQR378)  /*@bf@*/
#define IRC0_IRQR11_IRQR379	(IRC0.unIRQR11.stcField.u1IRQR379)  /*@bf@*/
#define IRC0_IRQR11_IRQR380	(IRC0.unIRQR11.stcField.u1IRQR380)  /*@bf@*/
#define IRC0_IRQR11_IRQR381	(IRC0.unIRQR11.stcField.u1IRQR381)  /*@bf@*/
#define IRC0_IRQR11_IRQR382	(IRC0.unIRQR11.stcField.u1IRQR382)  /*@bf@*/
#define IRC0_IRQR11_IRQR383	(IRC0.unIRQR11.stcField.u1IRQR383)  /*@bf@*/

typedef struct stc_irc0_irqr11_field{
    uint_io32_t		u1IRQR352:1;
    uint_io32_t		u1IRQR353:1;
    uint_io32_t		u1IRQR354:1;
    uint_io32_t		u1IRQR355:1;
    uint_io32_t		u1IRQR356:1;
    uint_io32_t		u1IRQR357:1;
    uint_io32_t		u1IRQR358:1;
    uint_io32_t		u1IRQR359:1;
    uint_io32_t		u1IRQR360:1;
    uint_io32_t		u1IRQR361:1;
    uint_io32_t		u1IRQR362:1;
    uint_io32_t		u1IRQR363:1;
    uint_io32_t		u1IRQR364:1;
    uint_io32_t		u1IRQR365:1;
    uint_io32_t		u1IRQR366:1;
    uint_io32_t		u1IRQR367:1;
    uint_io32_t		u1IRQR368:1;
    uint_io32_t		u1IRQR369:1;
    uint_io32_t		u1IRQR370:1;
    uint_io32_t		u1IRQR371:1;
    uint_io32_t		u1IRQR372:1;
    uint_io32_t		u1IRQR373:1;
    uint_io32_t		u1IRQR374:1;
    uint_io32_t		u1IRQR375:1;
    uint_io32_t		u1IRQR376:1;
    uint_io32_t		u1IRQR377:1;
    uint_io32_t		u1IRQR378:1;
    uint_io32_t		u1IRQR379:1;
    uint_io32_t		u1IRQR380:1;
    uint_io32_t		u1IRQR381:1;
    uint_io32_t		u1IRQR382:1;
    uint_io32_t		u1IRQR383:1;
}stc_irc0_irqr11_field_t;

typedef union un_irc0_irqr11{
    uint_io32_t		u32Register;
    stc_irc0_irqr11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr11_t;

/* IRQR12 */
#define IRC0_IRQR12	(IRC0.unIRQR12.u32Register)  /*@rg@*/
#define IRC0_IRQR12_IRQR384	(IRC0.unIRQR12.stcField.u1IRQR384)  /*@bf@*/
#define IRC0_IRQR12_IRQR385	(IRC0.unIRQR12.stcField.u1IRQR385)  /*@bf@*/
#define IRC0_IRQR12_IRQR386	(IRC0.unIRQR12.stcField.u1IRQR386)  /*@bf@*/
#define IRC0_IRQR12_IRQR387	(IRC0.unIRQR12.stcField.u1IRQR387)  /*@bf@*/
#define IRC0_IRQR12_IRQR388	(IRC0.unIRQR12.stcField.u1IRQR388)  /*@bf@*/
#define IRC0_IRQR12_IRQR389	(IRC0.unIRQR12.stcField.u1IRQR389)  /*@bf@*/
#define IRC0_IRQR12_IRQR390	(IRC0.unIRQR12.stcField.u1IRQR390)  /*@bf@*/
#define IRC0_IRQR12_IRQR391	(IRC0.unIRQR12.stcField.u1IRQR391)  /*@bf@*/
#define IRC0_IRQR12_IRQR392	(IRC0.unIRQR12.stcField.u1IRQR392)  /*@bf@*/
#define IRC0_IRQR12_IRQR393	(IRC0.unIRQR12.stcField.u1IRQR393)  /*@bf@*/
#define IRC0_IRQR12_IRQR394	(IRC0.unIRQR12.stcField.u1IRQR394)  /*@bf@*/
#define IRC0_IRQR12_IRQR395	(IRC0.unIRQR12.stcField.u1IRQR395)  /*@bf@*/
#define IRC0_IRQR12_IRQR396	(IRC0.unIRQR12.stcField.u1IRQR396)  /*@bf@*/
#define IRC0_IRQR12_IRQR397	(IRC0.unIRQR12.stcField.u1IRQR397)  /*@bf@*/
#define IRC0_IRQR12_IRQR398	(IRC0.unIRQR12.stcField.u1IRQR398)  /*@bf@*/
#define IRC0_IRQR12_IRQR399	(IRC0.unIRQR12.stcField.u1IRQR399)  /*@bf@*/
#define IRC0_IRQR12_IRQR400	(IRC0.unIRQR12.stcField.u1IRQR400)  /*@bf@*/
#define IRC0_IRQR12_IRQR401	(IRC0.unIRQR12.stcField.u1IRQR401)  /*@bf@*/
#define IRC0_IRQR12_IRQR402	(IRC0.unIRQR12.stcField.u1IRQR402)  /*@bf@*/
#define IRC0_IRQR12_IRQR403	(IRC0.unIRQR12.stcField.u1IRQR403)  /*@bf@*/
#define IRC0_IRQR12_IRQR404	(IRC0.unIRQR12.stcField.u1IRQR404)  /*@bf@*/
#define IRC0_IRQR12_IRQR405	(IRC0.unIRQR12.stcField.u1IRQR405)  /*@bf@*/
#define IRC0_IRQR12_IRQR406	(IRC0.unIRQR12.stcField.u1IRQR406)  /*@bf@*/
#define IRC0_IRQR12_IRQR407	(IRC0.unIRQR12.stcField.u1IRQR407)  /*@bf@*/
#define IRC0_IRQR12_IRQR408	(IRC0.unIRQR12.stcField.u1IRQR408)  /*@bf@*/
#define IRC0_IRQR12_IRQR409	(IRC0.unIRQR12.stcField.u1IRQR409)  /*@bf@*/
#define IRC0_IRQR12_IRQR410	(IRC0.unIRQR12.stcField.u1IRQR410)  /*@bf@*/
#define IRC0_IRQR12_IRQR411	(IRC0.unIRQR12.stcField.u1IRQR411)  /*@bf@*/
#define IRC0_IRQR12_IRQR412	(IRC0.unIRQR12.stcField.u1IRQR412)  /*@bf@*/
#define IRC0_IRQR12_IRQR413	(IRC0.unIRQR12.stcField.u1IRQR413)  /*@bf@*/
#define IRC0_IRQR12_IRQR414	(IRC0.unIRQR12.stcField.u1IRQR414)  /*@bf@*/
#define IRC0_IRQR12_IRQR415	(IRC0.unIRQR12.stcField.u1IRQR415)  /*@bf@*/

typedef struct stc_irc0_irqr12_field{
    uint_io32_t		u1IRQR384:1;
    uint_io32_t		u1IRQR385:1;
    uint_io32_t		u1IRQR386:1;
    uint_io32_t		u1IRQR387:1;
    uint_io32_t		u1IRQR388:1;
    uint_io32_t		u1IRQR389:1;
    uint_io32_t		u1IRQR390:1;
    uint_io32_t		u1IRQR391:1;
    uint_io32_t		u1IRQR392:1;
    uint_io32_t		u1IRQR393:1;
    uint_io32_t		u1IRQR394:1;
    uint_io32_t		u1IRQR395:1;
    uint_io32_t		u1IRQR396:1;
    uint_io32_t		u1IRQR397:1;
    uint_io32_t		u1IRQR398:1;
    uint_io32_t		u1IRQR399:1;
    uint_io32_t		u1IRQR400:1;
    uint_io32_t		u1IRQR401:1;
    uint_io32_t		u1IRQR402:1;
    uint_io32_t		u1IRQR403:1;
    uint_io32_t		u1IRQR404:1;
    uint_io32_t		u1IRQR405:1;
    uint_io32_t		u1IRQR406:1;
    uint_io32_t		u1IRQR407:1;
    uint_io32_t		u1IRQR408:1;
    uint_io32_t		u1IRQR409:1;
    uint_io32_t		u1IRQR410:1;
    uint_io32_t		u1IRQR411:1;
    uint_io32_t		u1IRQR412:1;
    uint_io32_t		u1IRQR413:1;
    uint_io32_t		u1IRQR414:1;
    uint_io32_t		u1IRQR415:1;
}stc_irc0_irqr12_field_t;

typedef union un_irc0_irqr12{
    uint_io32_t		u32Register;
    stc_irc0_irqr12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr12_t;

/* IRQR13 */
#define IRC0_IRQR13	(IRC0.unIRQR13.u32Register)  /*@rg@*/
#define IRC0_IRQR13_IRQR416	(IRC0.unIRQR13.stcField.u1IRQR416)  /*@bf@*/
#define IRC0_IRQR13_IRQR417	(IRC0.unIRQR13.stcField.u1IRQR417)  /*@bf@*/
#define IRC0_IRQR13_IRQR418	(IRC0.unIRQR13.stcField.u1IRQR418)  /*@bf@*/
#define IRC0_IRQR13_IRQR419	(IRC0.unIRQR13.stcField.u1IRQR419)  /*@bf@*/
#define IRC0_IRQR13_IRQR420	(IRC0.unIRQR13.stcField.u1IRQR420)  /*@bf@*/
#define IRC0_IRQR13_IRQR421	(IRC0.unIRQR13.stcField.u1IRQR421)  /*@bf@*/
#define IRC0_IRQR13_IRQR422	(IRC0.unIRQR13.stcField.u1IRQR422)  /*@bf@*/
#define IRC0_IRQR13_IRQR423	(IRC0.unIRQR13.stcField.u1IRQR423)  /*@bf@*/
#define IRC0_IRQR13_IRQR424	(IRC0.unIRQR13.stcField.u1IRQR424)  /*@bf@*/
#define IRC0_IRQR13_IRQR425	(IRC0.unIRQR13.stcField.u1IRQR425)  /*@bf@*/
#define IRC0_IRQR13_IRQR426	(IRC0.unIRQR13.stcField.u1IRQR426)  /*@bf@*/
#define IRC0_IRQR13_IRQR427	(IRC0.unIRQR13.stcField.u1IRQR427)  /*@bf@*/
#define IRC0_IRQR13_IRQR428	(IRC0.unIRQR13.stcField.u1IRQR428)  /*@bf@*/
#define IRC0_IRQR13_IRQR429	(IRC0.unIRQR13.stcField.u1IRQR429)  /*@bf@*/
#define IRC0_IRQR13_IRQR430	(IRC0.unIRQR13.stcField.u1IRQR430)  /*@bf@*/
#define IRC0_IRQR13_IRQR431	(IRC0.unIRQR13.stcField.u1IRQR431)  /*@bf@*/
#define IRC0_IRQR13_IRQR432	(IRC0.unIRQR13.stcField.u1IRQR432)  /*@bf@*/
#define IRC0_IRQR13_IRQR433	(IRC0.unIRQR13.stcField.u1IRQR433)  /*@bf@*/
#define IRC0_IRQR13_IRQR434	(IRC0.unIRQR13.stcField.u1IRQR434)  /*@bf@*/
#define IRC0_IRQR13_IRQR435	(IRC0.unIRQR13.stcField.u1IRQR435)  /*@bf@*/
#define IRC0_IRQR13_IRQR436	(IRC0.unIRQR13.stcField.u1IRQR436)  /*@bf@*/
#define IRC0_IRQR13_IRQR437	(IRC0.unIRQR13.stcField.u1IRQR437)  /*@bf@*/
#define IRC0_IRQR13_IRQR438	(IRC0.unIRQR13.stcField.u1IRQR438)  /*@bf@*/
#define IRC0_IRQR13_IRQR439	(IRC0.unIRQR13.stcField.u1IRQR439)  /*@bf@*/
#define IRC0_IRQR13_IRQR440	(IRC0.unIRQR13.stcField.u1IRQR440)  /*@bf@*/
#define IRC0_IRQR13_IRQR441	(IRC0.unIRQR13.stcField.u1IRQR441)  /*@bf@*/
#define IRC0_IRQR13_IRQR442	(IRC0.unIRQR13.stcField.u1IRQR442)  /*@bf@*/
#define IRC0_IRQR13_IRQR443	(IRC0.unIRQR13.stcField.u1IRQR443)  /*@bf@*/
#define IRC0_IRQR13_IRQR444	(IRC0.unIRQR13.stcField.u1IRQR444)  /*@bf@*/
#define IRC0_IRQR13_IRQR445	(IRC0.unIRQR13.stcField.u1IRQR445)  /*@bf@*/
#define IRC0_IRQR13_IRQR446	(IRC0.unIRQR13.stcField.u1IRQR446)  /*@bf@*/
#define IRC0_IRQR13_IRQR447	(IRC0.unIRQR13.stcField.u1IRQR447)  /*@bf@*/

typedef struct stc_irc0_irqr13_field{
    uint_io32_t		u1IRQR416:1;
    uint_io32_t		u1IRQR417:1;
    uint_io32_t		u1IRQR418:1;
    uint_io32_t		u1IRQR419:1;
    uint_io32_t		u1IRQR420:1;
    uint_io32_t		u1IRQR421:1;
    uint_io32_t		u1IRQR422:1;
    uint_io32_t		u1IRQR423:1;
    uint_io32_t		u1IRQR424:1;
    uint_io32_t		u1IRQR425:1;
    uint_io32_t		u1IRQR426:1;
    uint_io32_t		u1IRQR427:1;
    uint_io32_t		u1IRQR428:1;
    uint_io32_t		u1IRQR429:1;
    uint_io32_t		u1IRQR430:1;
    uint_io32_t		u1IRQR431:1;
    uint_io32_t		u1IRQR432:1;
    uint_io32_t		u1IRQR433:1;
    uint_io32_t		u1IRQR434:1;
    uint_io32_t		u1IRQR435:1;
    uint_io32_t		u1IRQR436:1;
    uint_io32_t		u1IRQR437:1;
    uint_io32_t		u1IRQR438:1;
    uint_io32_t		u1IRQR439:1;
    uint_io32_t		u1IRQR440:1;
    uint_io32_t		u1IRQR441:1;
    uint_io32_t		u1IRQR442:1;
    uint_io32_t		u1IRQR443:1;
    uint_io32_t		u1IRQR444:1;
    uint_io32_t		u1IRQR445:1;
    uint_io32_t		u1IRQR446:1;
    uint_io32_t		u1IRQR447:1;
}stc_irc0_irqr13_field_t;

typedef union un_irc0_irqr13{
    uint_io32_t		u32Register;
    stc_irc0_irqr13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr13_t;

/* IRQR14 */
#define IRC0_IRQR14	(IRC0.unIRQR14.u32Register)  /*@rg@*/
#define IRC0_IRQR14_IRQR448	(IRC0.unIRQR14.stcField.u1IRQR448)  /*@bf@*/
#define IRC0_IRQR14_IRQR449	(IRC0.unIRQR14.stcField.u1IRQR449)  /*@bf@*/
#define IRC0_IRQR14_IRQR450	(IRC0.unIRQR14.stcField.u1IRQR450)  /*@bf@*/
#define IRC0_IRQR14_IRQR451	(IRC0.unIRQR14.stcField.u1IRQR451)  /*@bf@*/
#define IRC0_IRQR14_IRQR452	(IRC0.unIRQR14.stcField.u1IRQR452)  /*@bf@*/
#define IRC0_IRQR14_IRQR453	(IRC0.unIRQR14.stcField.u1IRQR453)  /*@bf@*/
#define IRC0_IRQR14_IRQR454	(IRC0.unIRQR14.stcField.u1IRQR454)  /*@bf@*/
#define IRC0_IRQR14_IRQR455	(IRC0.unIRQR14.stcField.u1IRQR455)  /*@bf@*/
#define IRC0_IRQR14_IRQR456	(IRC0.unIRQR14.stcField.u1IRQR456)  /*@bf@*/
#define IRC0_IRQR14_IRQR457	(IRC0.unIRQR14.stcField.u1IRQR457)  /*@bf@*/
#define IRC0_IRQR14_IRQR458	(IRC0.unIRQR14.stcField.u1IRQR458)  /*@bf@*/
#define IRC0_IRQR14_IRQR459	(IRC0.unIRQR14.stcField.u1IRQR459)  /*@bf@*/
#define IRC0_IRQR14_IRQR460	(IRC0.unIRQR14.stcField.u1IRQR460)  /*@bf@*/
#define IRC0_IRQR14_IRQR461	(IRC0.unIRQR14.stcField.u1IRQR461)  /*@bf@*/
#define IRC0_IRQR14_IRQR462	(IRC0.unIRQR14.stcField.u1IRQR462)  /*@bf@*/
#define IRC0_IRQR14_IRQR463	(IRC0.unIRQR14.stcField.u1IRQR463)  /*@bf@*/
#define IRC0_IRQR14_IRQR464	(IRC0.unIRQR14.stcField.u1IRQR464)  /*@bf@*/
#define IRC0_IRQR14_IRQR465	(IRC0.unIRQR14.stcField.u1IRQR465)  /*@bf@*/
#define IRC0_IRQR14_IRQR466	(IRC0.unIRQR14.stcField.u1IRQR466)  /*@bf@*/
#define IRC0_IRQR14_IRQR467	(IRC0.unIRQR14.stcField.u1IRQR467)  /*@bf@*/
#define IRC0_IRQR14_IRQR468	(IRC0.unIRQR14.stcField.u1IRQR468)  /*@bf@*/
#define IRC0_IRQR14_IRQR469	(IRC0.unIRQR14.stcField.u1IRQR469)  /*@bf@*/
#define IRC0_IRQR14_IRQR470	(IRC0.unIRQR14.stcField.u1IRQR470)  /*@bf@*/
#define IRC0_IRQR14_IRQR471	(IRC0.unIRQR14.stcField.u1IRQR471)  /*@bf@*/
#define IRC0_IRQR14_IRQR472	(IRC0.unIRQR14.stcField.u1IRQR472)  /*@bf@*/
#define IRC0_IRQR14_IRQR473	(IRC0.unIRQR14.stcField.u1IRQR473)  /*@bf@*/
#define IRC0_IRQR14_IRQR474	(IRC0.unIRQR14.stcField.u1IRQR474)  /*@bf@*/
#define IRC0_IRQR14_IRQR475	(IRC0.unIRQR14.stcField.u1IRQR475)  /*@bf@*/
#define IRC0_IRQR14_IRQR476	(IRC0.unIRQR14.stcField.u1IRQR476)  /*@bf@*/
#define IRC0_IRQR14_IRQR477	(IRC0.unIRQR14.stcField.u1IRQR477)  /*@bf@*/
#define IRC0_IRQR14_IRQR478	(IRC0.unIRQR14.stcField.u1IRQR478)  /*@bf@*/
#define IRC0_IRQR14_IRQR479	(IRC0.unIRQR14.stcField.u1IRQR479)  /*@bf@*/

typedef struct stc_irc0_irqr14_field{
    uint_io32_t		u1IRQR448:1;
    uint_io32_t		u1IRQR449:1;
    uint_io32_t		u1IRQR450:1;
    uint_io32_t		u1IRQR451:1;
    uint_io32_t		u1IRQR452:1;
    uint_io32_t		u1IRQR453:1;
    uint_io32_t		u1IRQR454:1;
    uint_io32_t		u1IRQR455:1;
    uint_io32_t		u1IRQR456:1;
    uint_io32_t		u1IRQR457:1;
    uint_io32_t		u1IRQR458:1;
    uint_io32_t		u1IRQR459:1;
    uint_io32_t		u1IRQR460:1;
    uint_io32_t		u1IRQR461:1;
    uint_io32_t		u1IRQR462:1;
    uint_io32_t		u1IRQR463:1;
    uint_io32_t		u1IRQR464:1;
    uint_io32_t		u1IRQR465:1;
    uint_io32_t		u1IRQR466:1;
    uint_io32_t		u1IRQR467:1;
    uint_io32_t		u1IRQR468:1;
    uint_io32_t		u1IRQR469:1;
    uint_io32_t		u1IRQR470:1;
    uint_io32_t		u1IRQR471:1;
    uint_io32_t		u1IRQR472:1;
    uint_io32_t		u1IRQR473:1;
    uint_io32_t		u1IRQR474:1;
    uint_io32_t		u1IRQR475:1;
    uint_io32_t		u1IRQR476:1;
    uint_io32_t		u1IRQR477:1;
    uint_io32_t		u1IRQR478:1;
    uint_io32_t		u1IRQR479:1;
}stc_irc0_irqr14_field_t;

typedef union un_irc0_irqr14{
    uint_io32_t		u32Register;
    stc_irc0_irqr14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr14_t;

/* IRQR15 */
#define IRC0_IRQR15	(IRC0.unIRQR15.u32Register)  /*@rg@*/
#define IRC0_IRQR15_IRQR480	(IRC0.unIRQR15.stcField.u1IRQR480)  /*@bf@*/
#define IRC0_IRQR15_IRQR481	(IRC0.unIRQR15.stcField.u1IRQR481)  /*@bf@*/
#define IRC0_IRQR15_IRQR482	(IRC0.unIRQR15.stcField.u1IRQR482)  /*@bf@*/
#define IRC0_IRQR15_IRQR483	(IRC0.unIRQR15.stcField.u1IRQR483)  /*@bf@*/
#define IRC0_IRQR15_IRQR484	(IRC0.unIRQR15.stcField.u1IRQR484)  /*@bf@*/
#define IRC0_IRQR15_IRQR485	(IRC0.unIRQR15.stcField.u1IRQR485)  /*@bf@*/
#define IRC0_IRQR15_IRQR486	(IRC0.unIRQR15.stcField.u1IRQR486)  /*@bf@*/
#define IRC0_IRQR15_IRQR487	(IRC0.unIRQR15.stcField.u1IRQR487)  /*@bf@*/
#define IRC0_IRQR15_IRQR488	(IRC0.unIRQR15.stcField.u1IRQR488)  /*@bf@*/
#define IRC0_IRQR15_IRQR489	(IRC0.unIRQR15.stcField.u1IRQR489)  /*@bf@*/
#define IRC0_IRQR15_IRQR490	(IRC0.unIRQR15.stcField.u1IRQR490)  /*@bf@*/
#define IRC0_IRQR15_IRQR491	(IRC0.unIRQR15.stcField.u1IRQR491)  /*@bf@*/
#define IRC0_IRQR15_IRQR492	(IRC0.unIRQR15.stcField.u1IRQR492)  /*@bf@*/
#define IRC0_IRQR15_IRQR493	(IRC0.unIRQR15.stcField.u1IRQR493)  /*@bf@*/
#define IRC0_IRQR15_IRQR494	(IRC0.unIRQR15.stcField.u1IRQR494)  /*@bf@*/
#define IRC0_IRQR15_IRQR495	(IRC0.unIRQR15.stcField.u1IRQR495)  /*@bf@*/
#define IRC0_IRQR15_IRQR496	(IRC0.unIRQR15.stcField.u1IRQR496)  /*@bf@*/
#define IRC0_IRQR15_IRQR497	(IRC0.unIRQR15.stcField.u1IRQR497)  /*@bf@*/
#define IRC0_IRQR15_IRQR498	(IRC0.unIRQR15.stcField.u1IRQR498)  /*@bf@*/
#define IRC0_IRQR15_IRQR499	(IRC0.unIRQR15.stcField.u1IRQR499)  /*@bf@*/
#define IRC0_IRQR15_IRQR500	(IRC0.unIRQR15.stcField.u1IRQR500)  /*@bf@*/
#define IRC0_IRQR15_IRQR501	(IRC0.unIRQR15.stcField.u1IRQR501)  /*@bf@*/
#define IRC0_IRQR15_IRQR502	(IRC0.unIRQR15.stcField.u1IRQR502)  /*@bf@*/
#define IRC0_IRQR15_IRQR503	(IRC0.unIRQR15.stcField.u1IRQR503)  /*@bf@*/
#define IRC0_IRQR15_IRQR504	(IRC0.unIRQR15.stcField.u1IRQR504)  /*@bf@*/
#define IRC0_IRQR15_IRQR505	(IRC0.unIRQR15.stcField.u1IRQR505)  /*@bf@*/
#define IRC0_IRQR15_IRQR506	(IRC0.unIRQR15.stcField.u1IRQR506)  /*@bf@*/
#define IRC0_IRQR15_IRQR507	(IRC0.unIRQR15.stcField.u1IRQR507)  /*@bf@*/
#define IRC0_IRQR15_IRQR508	(IRC0.unIRQR15.stcField.u1IRQR508)  /*@bf@*/
#define IRC0_IRQR15_IRQR509	(IRC0.unIRQR15.stcField.u1IRQR509)  /*@bf@*/
#define IRC0_IRQR15_IRQR510	(IRC0.unIRQR15.stcField.u1IRQR510)  /*@bf@*/
#define IRC0_IRQR15_IRQR511	(IRC0.unIRQR15.stcField.u1IRQR511)  /*@bf@*/

typedef struct stc_irc0_irqr15_field{
    uint_io32_t		u1IRQR480:1;
    uint_io32_t		u1IRQR481:1;
    uint_io32_t		u1IRQR482:1;
    uint_io32_t		u1IRQR483:1;
    uint_io32_t		u1IRQR484:1;
    uint_io32_t		u1IRQR485:1;
    uint_io32_t		u1IRQR486:1;
    uint_io32_t		u1IRQR487:1;
    uint_io32_t		u1IRQR488:1;
    uint_io32_t		u1IRQR489:1;
    uint_io32_t		u1IRQR490:1;
    uint_io32_t		u1IRQR491:1;
    uint_io32_t		u1IRQR492:1;
    uint_io32_t		u1IRQR493:1;
    uint_io32_t		u1IRQR494:1;
    uint_io32_t		u1IRQR495:1;
    uint_io32_t		u1IRQR496:1;
    uint_io32_t		u1IRQR497:1;
    uint_io32_t		u1IRQR498:1;
    uint_io32_t		u1IRQR499:1;
    uint_io32_t		u1IRQR500:1;
    uint_io32_t		u1IRQR501:1;
    uint_io32_t		u1IRQR502:1;
    uint_io32_t		u1IRQR503:1;
    uint_io32_t		u1IRQR504:1;
    uint_io32_t		u1IRQR505:1;
    uint_io32_t		u1IRQR506:1;
    uint_io32_t		u1IRQR507:1;
    uint_io32_t		u1IRQR508:1;
    uint_io32_t		u1IRQR509:1;
    uint_io32_t		u1IRQR510:1;
    uint_io32_t		u1IRQR511:1;
}stc_irc0_irqr15_field_t;

typedef union un_irc0_irqr15{
    uint_io32_t		u32Register;
    stc_irc0_irqr15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqr15_t;

/* IRQSIS0 */
#define IRC0_IRQSIS0	(IRC0.unIRQSIS0.u32Register)  /*@rg@*/
#define IRC0_IRQSIS0_IRQSIS0	(IRC0.unIRQSIS0.stcField.u1IRQSIS0)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS1	(IRC0.unIRQSIS0.stcField.u1IRQSIS1)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS2	(IRC0.unIRQSIS0.stcField.u1IRQSIS2)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS3	(IRC0.unIRQSIS0.stcField.u1IRQSIS3)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS4	(IRC0.unIRQSIS0.stcField.u1IRQSIS4)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS5	(IRC0.unIRQSIS0.stcField.u1IRQSIS5)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS6	(IRC0.unIRQSIS0.stcField.u1IRQSIS6)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS7	(IRC0.unIRQSIS0.stcField.u1IRQSIS7)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS8	(IRC0.unIRQSIS0.stcField.u1IRQSIS8)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS9	(IRC0.unIRQSIS0.stcField.u1IRQSIS9)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS10	(IRC0.unIRQSIS0.stcField.u1IRQSIS10)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS11	(IRC0.unIRQSIS0.stcField.u1IRQSIS11)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS12	(IRC0.unIRQSIS0.stcField.u1IRQSIS12)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS13	(IRC0.unIRQSIS0.stcField.u1IRQSIS13)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS14	(IRC0.unIRQSIS0.stcField.u1IRQSIS14)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS15	(IRC0.unIRQSIS0.stcField.u1IRQSIS15)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS16	(IRC0.unIRQSIS0.stcField.u1IRQSIS16)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS17	(IRC0.unIRQSIS0.stcField.u1IRQSIS17)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS18	(IRC0.unIRQSIS0.stcField.u1IRQSIS18)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS19	(IRC0.unIRQSIS0.stcField.u1IRQSIS19)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS20	(IRC0.unIRQSIS0.stcField.u1IRQSIS20)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS21	(IRC0.unIRQSIS0.stcField.u1IRQSIS21)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS22	(IRC0.unIRQSIS0.stcField.u1IRQSIS22)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS23	(IRC0.unIRQSIS0.stcField.u1IRQSIS23)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS24	(IRC0.unIRQSIS0.stcField.u1IRQSIS24)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS25	(IRC0.unIRQSIS0.stcField.u1IRQSIS25)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS26	(IRC0.unIRQSIS0.stcField.u1IRQSIS26)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS27	(IRC0.unIRQSIS0.stcField.u1IRQSIS27)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS28	(IRC0.unIRQSIS0.stcField.u1IRQSIS28)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS29	(IRC0.unIRQSIS0.stcField.u1IRQSIS29)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS30	(IRC0.unIRQSIS0.stcField.u1IRQSIS30)  /*@bf@*/
#define IRC0_IRQSIS0_IRQSIS31	(IRC0.unIRQSIS0.stcField.u1IRQSIS31)  /*@bf@*/

typedef struct stc_irc0_irqsis0_field{
    uint_io32_t		u1IRQSIS0:1;
    uint_io32_t		u1IRQSIS1:1;
    uint_io32_t		u1IRQSIS2:1;
    uint_io32_t		u1IRQSIS3:1;
    uint_io32_t		u1IRQSIS4:1;
    uint_io32_t		u1IRQSIS5:1;
    uint_io32_t		u1IRQSIS6:1;
    uint_io32_t		u1IRQSIS7:1;
    uint_io32_t		u1IRQSIS8:1;
    uint_io32_t		u1IRQSIS9:1;
    uint_io32_t		u1IRQSIS10:1;
    uint_io32_t		u1IRQSIS11:1;
    uint_io32_t		u1IRQSIS12:1;
    uint_io32_t		u1IRQSIS13:1;
    uint_io32_t		u1IRQSIS14:1;
    uint_io32_t		u1IRQSIS15:1;
    uint_io32_t		u1IRQSIS16:1;
    uint_io32_t		u1IRQSIS17:1;
    uint_io32_t		u1IRQSIS18:1;
    uint_io32_t		u1IRQSIS19:1;
    uint_io32_t		u1IRQSIS20:1;
    uint_io32_t		u1IRQSIS21:1;
    uint_io32_t		u1IRQSIS22:1;
    uint_io32_t		u1IRQSIS23:1;
    uint_io32_t		u1IRQSIS24:1;
    uint_io32_t		u1IRQSIS25:1;
    uint_io32_t		u1IRQSIS26:1;
    uint_io32_t		u1IRQSIS27:1;
    uint_io32_t		u1IRQSIS28:1;
    uint_io32_t		u1IRQSIS29:1;
    uint_io32_t		u1IRQSIS30:1;
    uint_io32_t		u1IRQSIS31:1;
}stc_irc0_irqsis0_field_t;

typedef union un_irc0_irqsis0{
    uint_io32_t		u32Register;
    stc_irc0_irqsis0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis0_t;

/* IRQSIS1 */
#define IRC0_IRQSIS1	(IRC0.unIRQSIS1.u32Register)  /*@rg@*/
#define IRC0_IRQSIS1_IRQSIS32	(IRC0.unIRQSIS1.stcField.u1IRQSIS32)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS33	(IRC0.unIRQSIS1.stcField.u1IRQSIS33)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS34	(IRC0.unIRQSIS1.stcField.u1IRQSIS34)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS35	(IRC0.unIRQSIS1.stcField.u1IRQSIS35)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS36	(IRC0.unIRQSIS1.stcField.u1IRQSIS36)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS37	(IRC0.unIRQSIS1.stcField.u1IRQSIS37)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS38	(IRC0.unIRQSIS1.stcField.u1IRQSIS38)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS39	(IRC0.unIRQSIS1.stcField.u1IRQSIS39)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS40	(IRC0.unIRQSIS1.stcField.u1IRQSIS40)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS41	(IRC0.unIRQSIS1.stcField.u1IRQSIS41)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS42	(IRC0.unIRQSIS1.stcField.u1IRQSIS42)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS43	(IRC0.unIRQSIS1.stcField.u1IRQSIS43)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS44	(IRC0.unIRQSIS1.stcField.u1IRQSIS44)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS45	(IRC0.unIRQSIS1.stcField.u1IRQSIS45)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS46	(IRC0.unIRQSIS1.stcField.u1IRQSIS46)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS47	(IRC0.unIRQSIS1.stcField.u1IRQSIS47)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS48	(IRC0.unIRQSIS1.stcField.u1IRQSIS48)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS49	(IRC0.unIRQSIS1.stcField.u1IRQSIS49)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS50	(IRC0.unIRQSIS1.stcField.u1IRQSIS50)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS51	(IRC0.unIRQSIS1.stcField.u1IRQSIS51)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS52	(IRC0.unIRQSIS1.stcField.u1IRQSIS52)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS53	(IRC0.unIRQSIS1.stcField.u1IRQSIS53)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS54	(IRC0.unIRQSIS1.stcField.u1IRQSIS54)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS55	(IRC0.unIRQSIS1.stcField.u1IRQSIS55)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS56	(IRC0.unIRQSIS1.stcField.u1IRQSIS56)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS57	(IRC0.unIRQSIS1.stcField.u1IRQSIS57)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS58	(IRC0.unIRQSIS1.stcField.u1IRQSIS58)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS59	(IRC0.unIRQSIS1.stcField.u1IRQSIS59)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS60	(IRC0.unIRQSIS1.stcField.u1IRQSIS60)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS61	(IRC0.unIRQSIS1.stcField.u1IRQSIS61)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS62	(IRC0.unIRQSIS1.stcField.u1IRQSIS62)  /*@bf@*/
#define IRC0_IRQSIS1_IRQSIS63	(IRC0.unIRQSIS1.stcField.u1IRQSIS63)  /*@bf@*/

typedef struct stc_irc0_irqsis1_field{
    uint_io32_t		u1IRQSIS32:1;
    uint_io32_t		u1IRQSIS33:1;
    uint_io32_t		u1IRQSIS34:1;
    uint_io32_t		u1IRQSIS35:1;
    uint_io32_t		u1IRQSIS36:1;
    uint_io32_t		u1IRQSIS37:1;
    uint_io32_t		u1IRQSIS38:1;
    uint_io32_t		u1IRQSIS39:1;
    uint_io32_t		u1IRQSIS40:1;
    uint_io32_t		u1IRQSIS41:1;
    uint_io32_t		u1IRQSIS42:1;
    uint_io32_t		u1IRQSIS43:1;
    uint_io32_t		u1IRQSIS44:1;
    uint_io32_t		u1IRQSIS45:1;
    uint_io32_t		u1IRQSIS46:1;
    uint_io32_t		u1IRQSIS47:1;
    uint_io32_t		u1IRQSIS48:1;
    uint_io32_t		u1IRQSIS49:1;
    uint_io32_t		u1IRQSIS50:1;
    uint_io32_t		u1IRQSIS51:1;
    uint_io32_t		u1IRQSIS52:1;
    uint_io32_t		u1IRQSIS53:1;
    uint_io32_t		u1IRQSIS54:1;
    uint_io32_t		u1IRQSIS55:1;
    uint_io32_t		u1IRQSIS56:1;
    uint_io32_t		u1IRQSIS57:1;
    uint_io32_t		u1IRQSIS58:1;
    uint_io32_t		u1IRQSIS59:1;
    uint_io32_t		u1IRQSIS60:1;
    uint_io32_t		u1IRQSIS61:1;
    uint_io32_t		u1IRQSIS62:1;
    uint_io32_t		u1IRQSIS63:1;
}stc_irc0_irqsis1_field_t;

typedef union un_irc0_irqsis1{
    uint_io32_t		u32Register;
    stc_irc0_irqsis1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis1_t;

/* IRQSIS2 */
#define IRC0_IRQSIS2	(IRC0.unIRQSIS2.u32Register)  /*@rg@*/
#define IRC0_IRQSIS2_IRQSIS64	(IRC0.unIRQSIS2.stcField.u1IRQSIS64)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS65	(IRC0.unIRQSIS2.stcField.u1IRQSIS65)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS66	(IRC0.unIRQSIS2.stcField.u1IRQSIS66)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS67	(IRC0.unIRQSIS2.stcField.u1IRQSIS67)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS68	(IRC0.unIRQSIS2.stcField.u1IRQSIS68)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS69	(IRC0.unIRQSIS2.stcField.u1IRQSIS69)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS70	(IRC0.unIRQSIS2.stcField.u1IRQSIS70)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS71	(IRC0.unIRQSIS2.stcField.u1IRQSIS71)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS72	(IRC0.unIRQSIS2.stcField.u1IRQSIS72)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS73	(IRC0.unIRQSIS2.stcField.u1IRQSIS73)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS74	(IRC0.unIRQSIS2.stcField.u1IRQSIS74)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS75	(IRC0.unIRQSIS2.stcField.u1IRQSIS75)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS76	(IRC0.unIRQSIS2.stcField.u1IRQSIS76)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS77	(IRC0.unIRQSIS2.stcField.u1IRQSIS77)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS78	(IRC0.unIRQSIS2.stcField.u1IRQSIS78)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS79	(IRC0.unIRQSIS2.stcField.u1IRQSIS79)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS80	(IRC0.unIRQSIS2.stcField.u1IRQSIS80)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS81	(IRC0.unIRQSIS2.stcField.u1IRQSIS81)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS82	(IRC0.unIRQSIS2.stcField.u1IRQSIS82)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS83	(IRC0.unIRQSIS2.stcField.u1IRQSIS83)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS84	(IRC0.unIRQSIS2.stcField.u1IRQSIS84)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS85	(IRC0.unIRQSIS2.stcField.u1IRQSIS85)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS86	(IRC0.unIRQSIS2.stcField.u1IRQSIS86)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS87	(IRC0.unIRQSIS2.stcField.u1IRQSIS87)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS88	(IRC0.unIRQSIS2.stcField.u1IRQSIS88)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS89	(IRC0.unIRQSIS2.stcField.u1IRQSIS89)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS90	(IRC0.unIRQSIS2.stcField.u1IRQSIS90)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS91	(IRC0.unIRQSIS2.stcField.u1IRQSIS91)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS92	(IRC0.unIRQSIS2.stcField.u1IRQSIS92)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS93	(IRC0.unIRQSIS2.stcField.u1IRQSIS93)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS94	(IRC0.unIRQSIS2.stcField.u1IRQSIS94)  /*@bf@*/
#define IRC0_IRQSIS2_IRQSIS95	(IRC0.unIRQSIS2.stcField.u1IRQSIS95)  /*@bf@*/

typedef struct stc_irc0_irqsis2_field{
    uint_io32_t		u1IRQSIS64:1;
    uint_io32_t		u1IRQSIS65:1;
    uint_io32_t		u1IRQSIS66:1;
    uint_io32_t		u1IRQSIS67:1;
    uint_io32_t		u1IRQSIS68:1;
    uint_io32_t		u1IRQSIS69:1;
    uint_io32_t		u1IRQSIS70:1;
    uint_io32_t		u1IRQSIS71:1;
    uint_io32_t		u1IRQSIS72:1;
    uint_io32_t		u1IRQSIS73:1;
    uint_io32_t		u1IRQSIS74:1;
    uint_io32_t		u1IRQSIS75:1;
    uint_io32_t		u1IRQSIS76:1;
    uint_io32_t		u1IRQSIS77:1;
    uint_io32_t		u1IRQSIS78:1;
    uint_io32_t		u1IRQSIS79:1;
    uint_io32_t		u1IRQSIS80:1;
    uint_io32_t		u1IRQSIS81:1;
    uint_io32_t		u1IRQSIS82:1;
    uint_io32_t		u1IRQSIS83:1;
    uint_io32_t		u1IRQSIS84:1;
    uint_io32_t		u1IRQSIS85:1;
    uint_io32_t		u1IRQSIS86:1;
    uint_io32_t		u1IRQSIS87:1;
    uint_io32_t		u1IRQSIS88:1;
    uint_io32_t		u1IRQSIS89:1;
    uint_io32_t		u1IRQSIS90:1;
    uint_io32_t		u1IRQSIS91:1;
    uint_io32_t		u1IRQSIS92:1;
    uint_io32_t		u1IRQSIS93:1;
    uint_io32_t		u1IRQSIS94:1;
    uint_io32_t		u1IRQSIS95:1;
}stc_irc0_irqsis2_field_t;

typedef union un_irc0_irqsis2{
    uint_io32_t		u32Register;
    stc_irc0_irqsis2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis2_t;

/* IRQSIS3 */
#define IRC0_IRQSIS3	(IRC0.unIRQSIS3.u32Register)  /*@rg@*/
#define IRC0_IRQSIS3_IRQSIS96	(IRC0.unIRQSIS3.stcField.u1IRQSIS96)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS97	(IRC0.unIRQSIS3.stcField.u1IRQSIS97)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS98	(IRC0.unIRQSIS3.stcField.u1IRQSIS98)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS99	(IRC0.unIRQSIS3.stcField.u1IRQSIS99)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS100	(IRC0.unIRQSIS3.stcField.u1IRQSIS100)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS101	(IRC0.unIRQSIS3.stcField.u1IRQSIS101)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS102	(IRC0.unIRQSIS3.stcField.u1IRQSIS102)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS103	(IRC0.unIRQSIS3.stcField.u1IRQSIS103)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS104	(IRC0.unIRQSIS3.stcField.u1IRQSIS104)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS105	(IRC0.unIRQSIS3.stcField.u1IRQSIS105)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS106	(IRC0.unIRQSIS3.stcField.u1IRQSIS106)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS107	(IRC0.unIRQSIS3.stcField.u1IRQSIS107)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS108	(IRC0.unIRQSIS3.stcField.u1IRQSIS108)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS109	(IRC0.unIRQSIS3.stcField.u1IRQSIS109)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS110	(IRC0.unIRQSIS3.stcField.u1IRQSIS110)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS111	(IRC0.unIRQSIS3.stcField.u1IRQSIS111)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS112	(IRC0.unIRQSIS3.stcField.u1IRQSIS112)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS113	(IRC0.unIRQSIS3.stcField.u1IRQSIS113)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS114	(IRC0.unIRQSIS3.stcField.u1IRQSIS114)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS115	(IRC0.unIRQSIS3.stcField.u1IRQSIS115)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS116	(IRC0.unIRQSIS3.stcField.u1IRQSIS116)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS117	(IRC0.unIRQSIS3.stcField.u1IRQSIS117)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS118	(IRC0.unIRQSIS3.stcField.u1IRQSIS118)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS119	(IRC0.unIRQSIS3.stcField.u1IRQSIS119)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS120	(IRC0.unIRQSIS3.stcField.u1IRQSIS120)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS121	(IRC0.unIRQSIS3.stcField.u1IRQSIS121)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS122	(IRC0.unIRQSIS3.stcField.u1IRQSIS122)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS123	(IRC0.unIRQSIS3.stcField.u1IRQSIS123)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS124	(IRC0.unIRQSIS3.stcField.u1IRQSIS124)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS125	(IRC0.unIRQSIS3.stcField.u1IRQSIS125)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS126	(IRC0.unIRQSIS3.stcField.u1IRQSIS126)  /*@bf@*/
#define IRC0_IRQSIS3_IRQSIS127	(IRC0.unIRQSIS3.stcField.u1IRQSIS127)  /*@bf@*/

typedef struct stc_irc0_irqsis3_field{
    uint_io32_t		u1IRQSIS96:1;
    uint_io32_t		u1IRQSIS97:1;
    uint_io32_t		u1IRQSIS98:1;
    uint_io32_t		u1IRQSIS99:1;
    uint_io32_t		u1IRQSIS100:1;
    uint_io32_t		u1IRQSIS101:1;
    uint_io32_t		u1IRQSIS102:1;
    uint_io32_t		u1IRQSIS103:1;
    uint_io32_t		u1IRQSIS104:1;
    uint_io32_t		u1IRQSIS105:1;
    uint_io32_t		u1IRQSIS106:1;
    uint_io32_t		u1IRQSIS107:1;
    uint_io32_t		u1IRQSIS108:1;
    uint_io32_t		u1IRQSIS109:1;
    uint_io32_t		u1IRQSIS110:1;
    uint_io32_t		u1IRQSIS111:1;
    uint_io32_t		u1IRQSIS112:1;
    uint_io32_t		u1IRQSIS113:1;
    uint_io32_t		u1IRQSIS114:1;
    uint_io32_t		u1IRQSIS115:1;
    uint_io32_t		u1IRQSIS116:1;
    uint_io32_t		u1IRQSIS117:1;
    uint_io32_t		u1IRQSIS118:1;
    uint_io32_t		u1IRQSIS119:1;
    uint_io32_t		u1IRQSIS120:1;
    uint_io32_t		u1IRQSIS121:1;
    uint_io32_t		u1IRQSIS122:1;
    uint_io32_t		u1IRQSIS123:1;
    uint_io32_t		u1IRQSIS124:1;
    uint_io32_t		u1IRQSIS125:1;
    uint_io32_t		u1IRQSIS126:1;
    uint_io32_t		u1IRQSIS127:1;
}stc_irc0_irqsis3_field_t;

typedef union un_irc0_irqsis3{
    uint_io32_t		u32Register;
    stc_irc0_irqsis3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis3_t;

/* IRQSIS4 */
#define IRC0_IRQSIS4	(IRC0.unIRQSIS4.u32Register)  /*@rg@*/
#define IRC0_IRQSIS4_IRQSIS128	(IRC0.unIRQSIS4.stcField.u1IRQSIS128)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS129	(IRC0.unIRQSIS4.stcField.u1IRQSIS129)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS130	(IRC0.unIRQSIS4.stcField.u1IRQSIS130)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS131	(IRC0.unIRQSIS4.stcField.u1IRQSIS131)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS132	(IRC0.unIRQSIS4.stcField.u1IRQSIS132)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS133	(IRC0.unIRQSIS4.stcField.u1IRQSIS133)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS134	(IRC0.unIRQSIS4.stcField.u1IRQSIS134)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS135	(IRC0.unIRQSIS4.stcField.u1IRQSIS135)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS136	(IRC0.unIRQSIS4.stcField.u1IRQSIS136)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS137	(IRC0.unIRQSIS4.stcField.u1IRQSIS137)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS138	(IRC0.unIRQSIS4.stcField.u1IRQSIS138)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS139	(IRC0.unIRQSIS4.stcField.u1IRQSIS139)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS140	(IRC0.unIRQSIS4.stcField.u1IRQSIS140)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS141	(IRC0.unIRQSIS4.stcField.u1IRQSIS141)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS142	(IRC0.unIRQSIS4.stcField.u1IRQSIS142)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS143	(IRC0.unIRQSIS4.stcField.u1IRQSIS143)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS144	(IRC0.unIRQSIS4.stcField.u1IRQSIS144)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS145	(IRC0.unIRQSIS4.stcField.u1IRQSIS145)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS146	(IRC0.unIRQSIS4.stcField.u1IRQSIS146)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS147	(IRC0.unIRQSIS4.stcField.u1IRQSIS147)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS148	(IRC0.unIRQSIS4.stcField.u1IRQSIS148)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS149	(IRC0.unIRQSIS4.stcField.u1IRQSIS149)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS150	(IRC0.unIRQSIS4.stcField.u1IRQSIS150)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS151	(IRC0.unIRQSIS4.stcField.u1IRQSIS151)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS152	(IRC0.unIRQSIS4.stcField.u1IRQSIS152)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS153	(IRC0.unIRQSIS4.stcField.u1IRQSIS153)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS154	(IRC0.unIRQSIS4.stcField.u1IRQSIS154)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS155	(IRC0.unIRQSIS4.stcField.u1IRQSIS155)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS156	(IRC0.unIRQSIS4.stcField.u1IRQSIS156)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS157	(IRC0.unIRQSIS4.stcField.u1IRQSIS157)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS158	(IRC0.unIRQSIS4.stcField.u1IRQSIS158)  /*@bf@*/
#define IRC0_IRQSIS4_IRQSIS159	(IRC0.unIRQSIS4.stcField.u1IRQSIS159)  /*@bf@*/

typedef struct stc_irc0_irqsis4_field{
    uint_io32_t		u1IRQSIS128:1;
    uint_io32_t		u1IRQSIS129:1;
    uint_io32_t		u1IRQSIS130:1;
    uint_io32_t		u1IRQSIS131:1;
    uint_io32_t		u1IRQSIS132:1;
    uint_io32_t		u1IRQSIS133:1;
    uint_io32_t		u1IRQSIS134:1;
    uint_io32_t		u1IRQSIS135:1;
    uint_io32_t		u1IRQSIS136:1;
    uint_io32_t		u1IRQSIS137:1;
    uint_io32_t		u1IRQSIS138:1;
    uint_io32_t		u1IRQSIS139:1;
    uint_io32_t		u1IRQSIS140:1;
    uint_io32_t		u1IRQSIS141:1;
    uint_io32_t		u1IRQSIS142:1;
    uint_io32_t		u1IRQSIS143:1;
    uint_io32_t		u1IRQSIS144:1;
    uint_io32_t		u1IRQSIS145:1;
    uint_io32_t		u1IRQSIS146:1;
    uint_io32_t		u1IRQSIS147:1;
    uint_io32_t		u1IRQSIS148:1;
    uint_io32_t		u1IRQSIS149:1;
    uint_io32_t		u1IRQSIS150:1;
    uint_io32_t		u1IRQSIS151:1;
    uint_io32_t		u1IRQSIS152:1;
    uint_io32_t		u1IRQSIS153:1;
    uint_io32_t		u1IRQSIS154:1;
    uint_io32_t		u1IRQSIS155:1;
    uint_io32_t		u1IRQSIS156:1;
    uint_io32_t		u1IRQSIS157:1;
    uint_io32_t		u1IRQSIS158:1;
    uint_io32_t		u1IRQSIS159:1;
}stc_irc0_irqsis4_field_t;

typedef union un_irc0_irqsis4{
    uint_io32_t		u32Register;
    stc_irc0_irqsis4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis4_t;

/* IRQSIS5 */
#define IRC0_IRQSIS5	(IRC0.unIRQSIS5.u32Register)  /*@rg@*/
#define IRC0_IRQSIS5_IRQSIS160	(IRC0.unIRQSIS5.stcField.u1IRQSIS160)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS161	(IRC0.unIRQSIS5.stcField.u1IRQSIS161)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS162	(IRC0.unIRQSIS5.stcField.u1IRQSIS162)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS163	(IRC0.unIRQSIS5.stcField.u1IRQSIS163)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS164	(IRC0.unIRQSIS5.stcField.u1IRQSIS164)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS165	(IRC0.unIRQSIS5.stcField.u1IRQSIS165)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS166	(IRC0.unIRQSIS5.stcField.u1IRQSIS166)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS167	(IRC0.unIRQSIS5.stcField.u1IRQSIS167)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS168	(IRC0.unIRQSIS5.stcField.u1IRQSIS168)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS169	(IRC0.unIRQSIS5.stcField.u1IRQSIS169)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS170	(IRC0.unIRQSIS5.stcField.u1IRQSIS170)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS171	(IRC0.unIRQSIS5.stcField.u1IRQSIS171)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS172	(IRC0.unIRQSIS5.stcField.u1IRQSIS172)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS173	(IRC0.unIRQSIS5.stcField.u1IRQSIS173)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS174	(IRC0.unIRQSIS5.stcField.u1IRQSIS174)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS175	(IRC0.unIRQSIS5.stcField.u1IRQSIS175)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS176	(IRC0.unIRQSIS5.stcField.u1IRQSIS176)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS177	(IRC0.unIRQSIS5.stcField.u1IRQSIS177)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS178	(IRC0.unIRQSIS5.stcField.u1IRQSIS178)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS179	(IRC0.unIRQSIS5.stcField.u1IRQSIS179)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS180	(IRC0.unIRQSIS5.stcField.u1IRQSIS180)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS181	(IRC0.unIRQSIS5.stcField.u1IRQSIS181)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS182	(IRC0.unIRQSIS5.stcField.u1IRQSIS182)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS183	(IRC0.unIRQSIS5.stcField.u1IRQSIS183)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS184	(IRC0.unIRQSIS5.stcField.u1IRQSIS184)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS185	(IRC0.unIRQSIS5.stcField.u1IRQSIS185)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS186	(IRC0.unIRQSIS5.stcField.u1IRQSIS186)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS187	(IRC0.unIRQSIS5.stcField.u1IRQSIS187)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS188	(IRC0.unIRQSIS5.stcField.u1IRQSIS188)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS189	(IRC0.unIRQSIS5.stcField.u1IRQSIS189)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS190	(IRC0.unIRQSIS5.stcField.u1IRQSIS190)  /*@bf@*/
#define IRC0_IRQSIS5_IRQSIS191	(IRC0.unIRQSIS5.stcField.u1IRQSIS191)  /*@bf@*/

typedef struct stc_irc0_irqsis5_field{
    uint_io32_t		u1IRQSIS160:1;
    uint_io32_t		u1IRQSIS161:1;
    uint_io32_t		u1IRQSIS162:1;
    uint_io32_t		u1IRQSIS163:1;
    uint_io32_t		u1IRQSIS164:1;
    uint_io32_t		u1IRQSIS165:1;
    uint_io32_t		u1IRQSIS166:1;
    uint_io32_t		u1IRQSIS167:1;
    uint_io32_t		u1IRQSIS168:1;
    uint_io32_t		u1IRQSIS169:1;
    uint_io32_t		u1IRQSIS170:1;
    uint_io32_t		u1IRQSIS171:1;
    uint_io32_t		u1IRQSIS172:1;
    uint_io32_t		u1IRQSIS173:1;
    uint_io32_t		u1IRQSIS174:1;
    uint_io32_t		u1IRQSIS175:1;
    uint_io32_t		u1IRQSIS176:1;
    uint_io32_t		u1IRQSIS177:1;
    uint_io32_t		u1IRQSIS178:1;
    uint_io32_t		u1IRQSIS179:1;
    uint_io32_t		u1IRQSIS180:1;
    uint_io32_t		u1IRQSIS181:1;
    uint_io32_t		u1IRQSIS182:1;
    uint_io32_t		u1IRQSIS183:1;
    uint_io32_t		u1IRQSIS184:1;
    uint_io32_t		u1IRQSIS185:1;
    uint_io32_t		u1IRQSIS186:1;
    uint_io32_t		u1IRQSIS187:1;
    uint_io32_t		u1IRQSIS188:1;
    uint_io32_t		u1IRQSIS189:1;
    uint_io32_t		u1IRQSIS190:1;
    uint_io32_t		u1IRQSIS191:1;
}stc_irc0_irqsis5_field_t;

typedef union un_irc0_irqsis5{
    uint_io32_t		u32Register;
    stc_irc0_irqsis5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis5_t;

/* IRQSIS6 */
#define IRC0_IRQSIS6	(IRC0.unIRQSIS6.u32Register)  /*@rg@*/
#define IRC0_IRQSIS6_IRQSIS192	(IRC0.unIRQSIS6.stcField.u1IRQSIS192)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS193	(IRC0.unIRQSIS6.stcField.u1IRQSIS193)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS194	(IRC0.unIRQSIS6.stcField.u1IRQSIS194)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS195	(IRC0.unIRQSIS6.stcField.u1IRQSIS195)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS196	(IRC0.unIRQSIS6.stcField.u1IRQSIS196)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS197	(IRC0.unIRQSIS6.stcField.u1IRQSIS197)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS198	(IRC0.unIRQSIS6.stcField.u1IRQSIS198)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS199	(IRC0.unIRQSIS6.stcField.u1IRQSIS199)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS200	(IRC0.unIRQSIS6.stcField.u1IRQSIS200)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS201	(IRC0.unIRQSIS6.stcField.u1IRQSIS201)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS202	(IRC0.unIRQSIS6.stcField.u1IRQSIS202)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS203	(IRC0.unIRQSIS6.stcField.u1IRQSIS203)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS204	(IRC0.unIRQSIS6.stcField.u1IRQSIS204)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS205	(IRC0.unIRQSIS6.stcField.u1IRQSIS205)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS206	(IRC0.unIRQSIS6.stcField.u1IRQSIS206)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS207	(IRC0.unIRQSIS6.stcField.u1IRQSIS207)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS208	(IRC0.unIRQSIS6.stcField.u1IRQSIS208)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS209	(IRC0.unIRQSIS6.stcField.u1IRQSIS209)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS210	(IRC0.unIRQSIS6.stcField.u1IRQSIS210)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS211	(IRC0.unIRQSIS6.stcField.u1IRQSIS211)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS212	(IRC0.unIRQSIS6.stcField.u1IRQSIS212)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS213	(IRC0.unIRQSIS6.stcField.u1IRQSIS213)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS214	(IRC0.unIRQSIS6.stcField.u1IRQSIS214)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS215	(IRC0.unIRQSIS6.stcField.u1IRQSIS215)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS216	(IRC0.unIRQSIS6.stcField.u1IRQSIS216)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS217	(IRC0.unIRQSIS6.stcField.u1IRQSIS217)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS218	(IRC0.unIRQSIS6.stcField.u1IRQSIS218)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS219	(IRC0.unIRQSIS6.stcField.u1IRQSIS219)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS220	(IRC0.unIRQSIS6.stcField.u1IRQSIS220)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS221	(IRC0.unIRQSIS6.stcField.u1IRQSIS221)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS222	(IRC0.unIRQSIS6.stcField.u1IRQSIS222)  /*@bf@*/
#define IRC0_IRQSIS6_IRQSIS223	(IRC0.unIRQSIS6.stcField.u1IRQSIS223)  /*@bf@*/

typedef struct stc_irc0_irqsis6_field{
    uint_io32_t		u1IRQSIS192:1;
    uint_io32_t		u1IRQSIS193:1;
    uint_io32_t		u1IRQSIS194:1;
    uint_io32_t		u1IRQSIS195:1;
    uint_io32_t		u1IRQSIS196:1;
    uint_io32_t		u1IRQSIS197:1;
    uint_io32_t		u1IRQSIS198:1;
    uint_io32_t		u1IRQSIS199:1;
    uint_io32_t		u1IRQSIS200:1;
    uint_io32_t		u1IRQSIS201:1;
    uint_io32_t		u1IRQSIS202:1;
    uint_io32_t		u1IRQSIS203:1;
    uint_io32_t		u1IRQSIS204:1;
    uint_io32_t		u1IRQSIS205:1;
    uint_io32_t		u1IRQSIS206:1;
    uint_io32_t		u1IRQSIS207:1;
    uint_io32_t		u1IRQSIS208:1;
    uint_io32_t		u1IRQSIS209:1;
    uint_io32_t		u1IRQSIS210:1;
    uint_io32_t		u1IRQSIS211:1;
    uint_io32_t		u1IRQSIS212:1;
    uint_io32_t		u1IRQSIS213:1;
    uint_io32_t		u1IRQSIS214:1;
    uint_io32_t		u1IRQSIS215:1;
    uint_io32_t		u1IRQSIS216:1;
    uint_io32_t		u1IRQSIS217:1;
    uint_io32_t		u1IRQSIS218:1;
    uint_io32_t		u1IRQSIS219:1;
    uint_io32_t		u1IRQSIS220:1;
    uint_io32_t		u1IRQSIS221:1;
    uint_io32_t		u1IRQSIS222:1;
    uint_io32_t		u1IRQSIS223:1;
}stc_irc0_irqsis6_field_t;

typedef union un_irc0_irqsis6{
    uint_io32_t		u32Register;
    stc_irc0_irqsis6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis6_t;

/* IRQSIS7 */
#define IRC0_IRQSIS7	(IRC0.unIRQSIS7.u32Register)  /*@rg@*/
#define IRC0_IRQSIS7_IRQSIS224	(IRC0.unIRQSIS7.stcField.u1IRQSIS224)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS225	(IRC0.unIRQSIS7.stcField.u1IRQSIS225)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS226	(IRC0.unIRQSIS7.stcField.u1IRQSIS226)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS227	(IRC0.unIRQSIS7.stcField.u1IRQSIS227)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS228	(IRC0.unIRQSIS7.stcField.u1IRQSIS228)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS229	(IRC0.unIRQSIS7.stcField.u1IRQSIS229)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS230	(IRC0.unIRQSIS7.stcField.u1IRQSIS230)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS231	(IRC0.unIRQSIS7.stcField.u1IRQSIS231)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS232	(IRC0.unIRQSIS7.stcField.u1IRQSIS232)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS233	(IRC0.unIRQSIS7.stcField.u1IRQSIS233)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS234	(IRC0.unIRQSIS7.stcField.u1IRQSIS234)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS235	(IRC0.unIRQSIS7.stcField.u1IRQSIS235)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS236	(IRC0.unIRQSIS7.stcField.u1IRQSIS236)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS237	(IRC0.unIRQSIS7.stcField.u1IRQSIS237)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS238	(IRC0.unIRQSIS7.stcField.u1IRQSIS238)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS239	(IRC0.unIRQSIS7.stcField.u1IRQSIS239)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS240	(IRC0.unIRQSIS7.stcField.u1IRQSIS240)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS241	(IRC0.unIRQSIS7.stcField.u1IRQSIS241)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS242	(IRC0.unIRQSIS7.stcField.u1IRQSIS242)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS243	(IRC0.unIRQSIS7.stcField.u1IRQSIS243)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS244	(IRC0.unIRQSIS7.stcField.u1IRQSIS244)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS245	(IRC0.unIRQSIS7.stcField.u1IRQSIS245)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS246	(IRC0.unIRQSIS7.stcField.u1IRQSIS246)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS247	(IRC0.unIRQSIS7.stcField.u1IRQSIS247)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS248	(IRC0.unIRQSIS7.stcField.u1IRQSIS248)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS249	(IRC0.unIRQSIS7.stcField.u1IRQSIS249)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS250	(IRC0.unIRQSIS7.stcField.u1IRQSIS250)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS251	(IRC0.unIRQSIS7.stcField.u1IRQSIS251)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS252	(IRC0.unIRQSIS7.stcField.u1IRQSIS252)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS253	(IRC0.unIRQSIS7.stcField.u1IRQSIS253)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS254	(IRC0.unIRQSIS7.stcField.u1IRQSIS254)  /*@bf@*/
#define IRC0_IRQSIS7_IRQSIS255	(IRC0.unIRQSIS7.stcField.u1IRQSIS255)  /*@bf@*/

typedef struct stc_irc0_irqsis7_field{
    uint_io32_t		u1IRQSIS224:1;
    uint_io32_t		u1IRQSIS225:1;
    uint_io32_t		u1IRQSIS226:1;
    uint_io32_t		u1IRQSIS227:1;
    uint_io32_t		u1IRQSIS228:1;
    uint_io32_t		u1IRQSIS229:1;
    uint_io32_t		u1IRQSIS230:1;
    uint_io32_t		u1IRQSIS231:1;
    uint_io32_t		u1IRQSIS232:1;
    uint_io32_t		u1IRQSIS233:1;
    uint_io32_t		u1IRQSIS234:1;
    uint_io32_t		u1IRQSIS235:1;
    uint_io32_t		u1IRQSIS236:1;
    uint_io32_t		u1IRQSIS237:1;
    uint_io32_t		u1IRQSIS238:1;
    uint_io32_t		u1IRQSIS239:1;
    uint_io32_t		u1IRQSIS240:1;
    uint_io32_t		u1IRQSIS241:1;
    uint_io32_t		u1IRQSIS242:1;
    uint_io32_t		u1IRQSIS243:1;
    uint_io32_t		u1IRQSIS244:1;
    uint_io32_t		u1IRQSIS245:1;
    uint_io32_t		u1IRQSIS246:1;
    uint_io32_t		u1IRQSIS247:1;
    uint_io32_t		u1IRQSIS248:1;
    uint_io32_t		u1IRQSIS249:1;
    uint_io32_t		u1IRQSIS250:1;
    uint_io32_t		u1IRQSIS251:1;
    uint_io32_t		u1IRQSIS252:1;
    uint_io32_t		u1IRQSIS253:1;
    uint_io32_t		u1IRQSIS254:1;
    uint_io32_t		u1IRQSIS255:1;
}stc_irc0_irqsis7_field_t;

typedef union un_irc0_irqsis7{
    uint_io32_t		u32Register;
    stc_irc0_irqsis7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis7_t;

/* IRQSIS8 */
#define IRC0_IRQSIS8	(IRC0.unIRQSIS8.u32Register)  /*@rg@*/
#define IRC0_IRQSIS8_IRQSIS256	(IRC0.unIRQSIS8.stcField.u1IRQSIS256)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS257	(IRC0.unIRQSIS8.stcField.u1IRQSIS257)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS258	(IRC0.unIRQSIS8.stcField.u1IRQSIS258)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS259	(IRC0.unIRQSIS8.stcField.u1IRQSIS259)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS260	(IRC0.unIRQSIS8.stcField.u1IRQSIS260)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS261	(IRC0.unIRQSIS8.stcField.u1IRQSIS261)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS262	(IRC0.unIRQSIS8.stcField.u1IRQSIS262)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS263	(IRC0.unIRQSIS8.stcField.u1IRQSIS263)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS264	(IRC0.unIRQSIS8.stcField.u1IRQSIS264)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS265	(IRC0.unIRQSIS8.stcField.u1IRQSIS265)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS266	(IRC0.unIRQSIS8.stcField.u1IRQSIS266)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS267	(IRC0.unIRQSIS8.stcField.u1IRQSIS267)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS268	(IRC0.unIRQSIS8.stcField.u1IRQSIS268)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS269	(IRC0.unIRQSIS8.stcField.u1IRQSIS269)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS270	(IRC0.unIRQSIS8.stcField.u1IRQSIS270)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS271	(IRC0.unIRQSIS8.stcField.u1IRQSIS271)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS272	(IRC0.unIRQSIS8.stcField.u1IRQSIS272)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS273	(IRC0.unIRQSIS8.stcField.u1IRQSIS273)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS274	(IRC0.unIRQSIS8.stcField.u1IRQSIS274)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS275	(IRC0.unIRQSIS8.stcField.u1IRQSIS275)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS276	(IRC0.unIRQSIS8.stcField.u1IRQSIS276)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS277	(IRC0.unIRQSIS8.stcField.u1IRQSIS277)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS278	(IRC0.unIRQSIS8.stcField.u1IRQSIS278)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS279	(IRC0.unIRQSIS8.stcField.u1IRQSIS279)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS280	(IRC0.unIRQSIS8.stcField.u1IRQSIS280)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS281	(IRC0.unIRQSIS8.stcField.u1IRQSIS281)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS282	(IRC0.unIRQSIS8.stcField.u1IRQSIS282)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS283	(IRC0.unIRQSIS8.stcField.u1IRQSIS283)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS284	(IRC0.unIRQSIS8.stcField.u1IRQSIS284)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS285	(IRC0.unIRQSIS8.stcField.u1IRQSIS285)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS286	(IRC0.unIRQSIS8.stcField.u1IRQSIS286)  /*@bf@*/
#define IRC0_IRQSIS8_IRQSIS287	(IRC0.unIRQSIS8.stcField.u1IRQSIS287)  /*@bf@*/

typedef struct stc_irc0_irqsis8_field{
    uint_io32_t		u1IRQSIS256:1;
    uint_io32_t		u1IRQSIS257:1;
    uint_io32_t		u1IRQSIS258:1;
    uint_io32_t		u1IRQSIS259:1;
    uint_io32_t		u1IRQSIS260:1;
    uint_io32_t		u1IRQSIS261:1;
    uint_io32_t		u1IRQSIS262:1;
    uint_io32_t		u1IRQSIS263:1;
    uint_io32_t		u1IRQSIS264:1;
    uint_io32_t		u1IRQSIS265:1;
    uint_io32_t		u1IRQSIS266:1;
    uint_io32_t		u1IRQSIS267:1;
    uint_io32_t		u1IRQSIS268:1;
    uint_io32_t		u1IRQSIS269:1;
    uint_io32_t		u1IRQSIS270:1;
    uint_io32_t		u1IRQSIS271:1;
    uint_io32_t		u1IRQSIS272:1;
    uint_io32_t		u1IRQSIS273:1;
    uint_io32_t		u1IRQSIS274:1;
    uint_io32_t		u1IRQSIS275:1;
    uint_io32_t		u1IRQSIS276:1;
    uint_io32_t		u1IRQSIS277:1;
    uint_io32_t		u1IRQSIS278:1;
    uint_io32_t		u1IRQSIS279:1;
    uint_io32_t		u1IRQSIS280:1;
    uint_io32_t		u1IRQSIS281:1;
    uint_io32_t		u1IRQSIS282:1;
    uint_io32_t		u1IRQSIS283:1;
    uint_io32_t		u1IRQSIS284:1;
    uint_io32_t		u1IRQSIS285:1;
    uint_io32_t		u1IRQSIS286:1;
    uint_io32_t		u1IRQSIS287:1;
}stc_irc0_irqsis8_field_t;

typedef union un_irc0_irqsis8{
    uint_io32_t		u32Register;
    stc_irc0_irqsis8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis8_t;

/* IRQSIS9 */
#define IRC0_IRQSIS9	(IRC0.unIRQSIS9.u32Register)  /*@rg@*/
#define IRC0_IRQSIS9_IRQSIS288	(IRC0.unIRQSIS9.stcField.u1IRQSIS288)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS289	(IRC0.unIRQSIS9.stcField.u1IRQSIS289)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS290	(IRC0.unIRQSIS9.stcField.u1IRQSIS290)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS291	(IRC0.unIRQSIS9.stcField.u1IRQSIS291)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS292	(IRC0.unIRQSIS9.stcField.u1IRQSIS292)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS293	(IRC0.unIRQSIS9.stcField.u1IRQSIS293)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS294	(IRC0.unIRQSIS9.stcField.u1IRQSIS294)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS295	(IRC0.unIRQSIS9.stcField.u1IRQSIS295)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS296	(IRC0.unIRQSIS9.stcField.u1IRQSIS296)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS297	(IRC0.unIRQSIS9.stcField.u1IRQSIS297)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS298	(IRC0.unIRQSIS9.stcField.u1IRQSIS298)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS299	(IRC0.unIRQSIS9.stcField.u1IRQSIS299)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS300	(IRC0.unIRQSIS9.stcField.u1IRQSIS300)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS301	(IRC0.unIRQSIS9.stcField.u1IRQSIS301)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS302	(IRC0.unIRQSIS9.stcField.u1IRQSIS302)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS303	(IRC0.unIRQSIS9.stcField.u1IRQSIS303)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS304	(IRC0.unIRQSIS9.stcField.u1IRQSIS304)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS305	(IRC0.unIRQSIS9.stcField.u1IRQSIS305)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS306	(IRC0.unIRQSIS9.stcField.u1IRQSIS306)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS307	(IRC0.unIRQSIS9.stcField.u1IRQSIS307)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS308	(IRC0.unIRQSIS9.stcField.u1IRQSIS308)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS309	(IRC0.unIRQSIS9.stcField.u1IRQSIS309)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS310	(IRC0.unIRQSIS9.stcField.u1IRQSIS310)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS311	(IRC0.unIRQSIS9.stcField.u1IRQSIS311)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS312	(IRC0.unIRQSIS9.stcField.u1IRQSIS312)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS313	(IRC0.unIRQSIS9.stcField.u1IRQSIS313)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS314	(IRC0.unIRQSIS9.stcField.u1IRQSIS314)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS315	(IRC0.unIRQSIS9.stcField.u1IRQSIS315)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS316	(IRC0.unIRQSIS9.stcField.u1IRQSIS316)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS317	(IRC0.unIRQSIS9.stcField.u1IRQSIS317)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS318	(IRC0.unIRQSIS9.stcField.u1IRQSIS318)  /*@bf@*/
#define IRC0_IRQSIS9_IRQSIS319	(IRC0.unIRQSIS9.stcField.u1IRQSIS319)  /*@bf@*/

typedef struct stc_irc0_irqsis9_field{
    uint_io32_t		u1IRQSIS288:1;
    uint_io32_t		u1IRQSIS289:1;
    uint_io32_t		u1IRQSIS290:1;
    uint_io32_t		u1IRQSIS291:1;
    uint_io32_t		u1IRQSIS292:1;
    uint_io32_t		u1IRQSIS293:1;
    uint_io32_t		u1IRQSIS294:1;
    uint_io32_t		u1IRQSIS295:1;
    uint_io32_t		u1IRQSIS296:1;
    uint_io32_t		u1IRQSIS297:1;
    uint_io32_t		u1IRQSIS298:1;
    uint_io32_t		u1IRQSIS299:1;
    uint_io32_t		u1IRQSIS300:1;
    uint_io32_t		u1IRQSIS301:1;
    uint_io32_t		u1IRQSIS302:1;
    uint_io32_t		u1IRQSIS303:1;
    uint_io32_t		u1IRQSIS304:1;
    uint_io32_t		u1IRQSIS305:1;
    uint_io32_t		u1IRQSIS306:1;
    uint_io32_t		u1IRQSIS307:1;
    uint_io32_t		u1IRQSIS308:1;
    uint_io32_t		u1IRQSIS309:1;
    uint_io32_t		u1IRQSIS310:1;
    uint_io32_t		u1IRQSIS311:1;
    uint_io32_t		u1IRQSIS312:1;
    uint_io32_t		u1IRQSIS313:1;
    uint_io32_t		u1IRQSIS314:1;
    uint_io32_t		u1IRQSIS315:1;
    uint_io32_t		u1IRQSIS316:1;
    uint_io32_t		u1IRQSIS317:1;
    uint_io32_t		u1IRQSIS318:1;
    uint_io32_t		u1IRQSIS319:1;
}stc_irc0_irqsis9_field_t;

typedef union un_irc0_irqsis9{
    uint_io32_t		u32Register;
    stc_irc0_irqsis9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis9_t;

/* IRQSIS10 */
#define IRC0_IRQSIS10	(IRC0.unIRQSIS10.u32Register)  /*@rg@*/
#define IRC0_IRQSIS10_IRQSIS320	(IRC0.unIRQSIS10.stcField.u1IRQSIS320)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS321	(IRC0.unIRQSIS10.stcField.u1IRQSIS321)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS322	(IRC0.unIRQSIS10.stcField.u1IRQSIS322)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS323	(IRC0.unIRQSIS10.stcField.u1IRQSIS323)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS324	(IRC0.unIRQSIS10.stcField.u1IRQSIS324)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS325	(IRC0.unIRQSIS10.stcField.u1IRQSIS325)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS326	(IRC0.unIRQSIS10.stcField.u1IRQSIS326)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS327	(IRC0.unIRQSIS10.stcField.u1IRQSIS327)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS328	(IRC0.unIRQSIS10.stcField.u1IRQSIS328)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS329	(IRC0.unIRQSIS10.stcField.u1IRQSIS329)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS330	(IRC0.unIRQSIS10.stcField.u1IRQSIS330)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS331	(IRC0.unIRQSIS10.stcField.u1IRQSIS331)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS332	(IRC0.unIRQSIS10.stcField.u1IRQSIS332)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS333	(IRC0.unIRQSIS10.stcField.u1IRQSIS333)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS334	(IRC0.unIRQSIS10.stcField.u1IRQSIS334)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS335	(IRC0.unIRQSIS10.stcField.u1IRQSIS335)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS336	(IRC0.unIRQSIS10.stcField.u1IRQSIS336)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS337	(IRC0.unIRQSIS10.stcField.u1IRQSIS337)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS338	(IRC0.unIRQSIS10.stcField.u1IRQSIS338)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS339	(IRC0.unIRQSIS10.stcField.u1IRQSIS339)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS340	(IRC0.unIRQSIS10.stcField.u1IRQSIS340)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS341	(IRC0.unIRQSIS10.stcField.u1IRQSIS341)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS342	(IRC0.unIRQSIS10.stcField.u1IRQSIS342)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS343	(IRC0.unIRQSIS10.stcField.u1IRQSIS343)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS344	(IRC0.unIRQSIS10.stcField.u1IRQSIS344)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS345	(IRC0.unIRQSIS10.stcField.u1IRQSIS345)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS346	(IRC0.unIRQSIS10.stcField.u1IRQSIS346)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS347	(IRC0.unIRQSIS10.stcField.u1IRQSIS347)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS348	(IRC0.unIRQSIS10.stcField.u1IRQSIS348)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS349	(IRC0.unIRQSIS10.stcField.u1IRQSIS349)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS350	(IRC0.unIRQSIS10.stcField.u1IRQSIS350)  /*@bf@*/
#define IRC0_IRQSIS10_IRQSIS351	(IRC0.unIRQSIS10.stcField.u1IRQSIS351)  /*@bf@*/

typedef struct stc_irc0_irqsis10_field{
    uint_io32_t		u1IRQSIS320:1;
    uint_io32_t		u1IRQSIS321:1;
    uint_io32_t		u1IRQSIS322:1;
    uint_io32_t		u1IRQSIS323:1;
    uint_io32_t		u1IRQSIS324:1;
    uint_io32_t		u1IRQSIS325:1;
    uint_io32_t		u1IRQSIS326:1;
    uint_io32_t		u1IRQSIS327:1;
    uint_io32_t		u1IRQSIS328:1;
    uint_io32_t		u1IRQSIS329:1;
    uint_io32_t		u1IRQSIS330:1;
    uint_io32_t		u1IRQSIS331:1;
    uint_io32_t		u1IRQSIS332:1;
    uint_io32_t		u1IRQSIS333:1;
    uint_io32_t		u1IRQSIS334:1;
    uint_io32_t		u1IRQSIS335:1;
    uint_io32_t		u1IRQSIS336:1;
    uint_io32_t		u1IRQSIS337:1;
    uint_io32_t		u1IRQSIS338:1;
    uint_io32_t		u1IRQSIS339:1;
    uint_io32_t		u1IRQSIS340:1;
    uint_io32_t		u1IRQSIS341:1;
    uint_io32_t		u1IRQSIS342:1;
    uint_io32_t		u1IRQSIS343:1;
    uint_io32_t		u1IRQSIS344:1;
    uint_io32_t		u1IRQSIS345:1;
    uint_io32_t		u1IRQSIS346:1;
    uint_io32_t		u1IRQSIS347:1;
    uint_io32_t		u1IRQSIS348:1;
    uint_io32_t		u1IRQSIS349:1;
    uint_io32_t		u1IRQSIS350:1;
    uint_io32_t		u1IRQSIS351:1;
}stc_irc0_irqsis10_field_t;

typedef union un_irc0_irqsis10{
    uint_io32_t		u32Register;
    stc_irc0_irqsis10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis10_t;

/* IRQSIS11 */
#define IRC0_IRQSIS11	(IRC0.unIRQSIS11.u32Register)  /*@rg@*/
#define IRC0_IRQSIS11_IRQSIS352	(IRC0.unIRQSIS11.stcField.u1IRQSIS352)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS353	(IRC0.unIRQSIS11.stcField.u1IRQSIS353)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS354	(IRC0.unIRQSIS11.stcField.u1IRQSIS354)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS355	(IRC0.unIRQSIS11.stcField.u1IRQSIS355)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS356	(IRC0.unIRQSIS11.stcField.u1IRQSIS356)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS357	(IRC0.unIRQSIS11.stcField.u1IRQSIS357)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS358	(IRC0.unIRQSIS11.stcField.u1IRQSIS358)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS359	(IRC0.unIRQSIS11.stcField.u1IRQSIS359)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS360	(IRC0.unIRQSIS11.stcField.u1IRQSIS360)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS361	(IRC0.unIRQSIS11.stcField.u1IRQSIS361)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS362	(IRC0.unIRQSIS11.stcField.u1IRQSIS362)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS363	(IRC0.unIRQSIS11.stcField.u1IRQSIS363)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS364	(IRC0.unIRQSIS11.stcField.u1IRQSIS364)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS365	(IRC0.unIRQSIS11.stcField.u1IRQSIS365)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS366	(IRC0.unIRQSIS11.stcField.u1IRQSIS366)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS367	(IRC0.unIRQSIS11.stcField.u1IRQSIS367)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS368	(IRC0.unIRQSIS11.stcField.u1IRQSIS368)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS369	(IRC0.unIRQSIS11.stcField.u1IRQSIS369)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS370	(IRC0.unIRQSIS11.stcField.u1IRQSIS370)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS371	(IRC0.unIRQSIS11.stcField.u1IRQSIS371)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS372	(IRC0.unIRQSIS11.stcField.u1IRQSIS372)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS373	(IRC0.unIRQSIS11.stcField.u1IRQSIS373)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS374	(IRC0.unIRQSIS11.stcField.u1IRQSIS374)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS375	(IRC0.unIRQSIS11.stcField.u1IRQSIS375)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS376	(IRC0.unIRQSIS11.stcField.u1IRQSIS376)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS377	(IRC0.unIRQSIS11.stcField.u1IRQSIS377)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS378	(IRC0.unIRQSIS11.stcField.u1IRQSIS378)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS379	(IRC0.unIRQSIS11.stcField.u1IRQSIS379)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS380	(IRC0.unIRQSIS11.stcField.u1IRQSIS380)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS381	(IRC0.unIRQSIS11.stcField.u1IRQSIS381)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS382	(IRC0.unIRQSIS11.stcField.u1IRQSIS382)  /*@bf@*/
#define IRC0_IRQSIS11_IRQSIS383	(IRC0.unIRQSIS11.stcField.u1IRQSIS383)  /*@bf@*/

typedef struct stc_irc0_irqsis11_field{
    uint_io32_t		u1IRQSIS352:1;
    uint_io32_t		u1IRQSIS353:1;
    uint_io32_t		u1IRQSIS354:1;
    uint_io32_t		u1IRQSIS355:1;
    uint_io32_t		u1IRQSIS356:1;
    uint_io32_t		u1IRQSIS357:1;
    uint_io32_t		u1IRQSIS358:1;
    uint_io32_t		u1IRQSIS359:1;
    uint_io32_t		u1IRQSIS360:1;
    uint_io32_t		u1IRQSIS361:1;
    uint_io32_t		u1IRQSIS362:1;
    uint_io32_t		u1IRQSIS363:1;
    uint_io32_t		u1IRQSIS364:1;
    uint_io32_t		u1IRQSIS365:1;
    uint_io32_t		u1IRQSIS366:1;
    uint_io32_t		u1IRQSIS367:1;
    uint_io32_t		u1IRQSIS368:1;
    uint_io32_t		u1IRQSIS369:1;
    uint_io32_t		u1IRQSIS370:1;
    uint_io32_t		u1IRQSIS371:1;
    uint_io32_t		u1IRQSIS372:1;
    uint_io32_t		u1IRQSIS373:1;
    uint_io32_t		u1IRQSIS374:1;
    uint_io32_t		u1IRQSIS375:1;
    uint_io32_t		u1IRQSIS376:1;
    uint_io32_t		u1IRQSIS377:1;
    uint_io32_t		u1IRQSIS378:1;
    uint_io32_t		u1IRQSIS379:1;
    uint_io32_t		u1IRQSIS380:1;
    uint_io32_t		u1IRQSIS381:1;
    uint_io32_t		u1IRQSIS382:1;
    uint_io32_t		u1IRQSIS383:1;
}stc_irc0_irqsis11_field_t;

typedef union un_irc0_irqsis11{
    uint_io32_t		u32Register;
    stc_irc0_irqsis11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis11_t;

/* IRQSIS12 */
#define IRC0_IRQSIS12	(IRC0.unIRQSIS12.u32Register)  /*@rg@*/
#define IRC0_IRQSIS12_IRQSIS384	(IRC0.unIRQSIS12.stcField.u1IRQSIS384)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS385	(IRC0.unIRQSIS12.stcField.u1IRQSIS385)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS386	(IRC0.unIRQSIS12.stcField.u1IRQSIS386)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS387	(IRC0.unIRQSIS12.stcField.u1IRQSIS387)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS388	(IRC0.unIRQSIS12.stcField.u1IRQSIS388)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS389	(IRC0.unIRQSIS12.stcField.u1IRQSIS389)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS390	(IRC0.unIRQSIS12.stcField.u1IRQSIS390)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS391	(IRC0.unIRQSIS12.stcField.u1IRQSIS391)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS392	(IRC0.unIRQSIS12.stcField.u1IRQSIS392)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS393	(IRC0.unIRQSIS12.stcField.u1IRQSIS393)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS394	(IRC0.unIRQSIS12.stcField.u1IRQSIS394)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS395	(IRC0.unIRQSIS12.stcField.u1IRQSIS395)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS396	(IRC0.unIRQSIS12.stcField.u1IRQSIS396)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS397	(IRC0.unIRQSIS12.stcField.u1IRQSIS397)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS398	(IRC0.unIRQSIS12.stcField.u1IRQSIS398)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS399	(IRC0.unIRQSIS12.stcField.u1IRQSIS399)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS400	(IRC0.unIRQSIS12.stcField.u1IRQSIS400)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS401	(IRC0.unIRQSIS12.stcField.u1IRQSIS401)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS402	(IRC0.unIRQSIS12.stcField.u1IRQSIS402)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS403	(IRC0.unIRQSIS12.stcField.u1IRQSIS403)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS404	(IRC0.unIRQSIS12.stcField.u1IRQSIS404)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS405	(IRC0.unIRQSIS12.stcField.u1IRQSIS405)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS406	(IRC0.unIRQSIS12.stcField.u1IRQSIS406)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS407	(IRC0.unIRQSIS12.stcField.u1IRQSIS407)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS408	(IRC0.unIRQSIS12.stcField.u1IRQSIS408)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS409	(IRC0.unIRQSIS12.stcField.u1IRQSIS409)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS410	(IRC0.unIRQSIS12.stcField.u1IRQSIS410)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS411	(IRC0.unIRQSIS12.stcField.u1IRQSIS411)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS412	(IRC0.unIRQSIS12.stcField.u1IRQSIS412)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS413	(IRC0.unIRQSIS12.stcField.u1IRQSIS413)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS414	(IRC0.unIRQSIS12.stcField.u1IRQSIS414)  /*@bf@*/
#define IRC0_IRQSIS12_IRQSIS415	(IRC0.unIRQSIS12.stcField.u1IRQSIS415)  /*@bf@*/

typedef struct stc_irc0_irqsis12_field{
    uint_io32_t		u1IRQSIS384:1;
    uint_io32_t		u1IRQSIS385:1;
    uint_io32_t		u1IRQSIS386:1;
    uint_io32_t		u1IRQSIS387:1;
    uint_io32_t		u1IRQSIS388:1;
    uint_io32_t		u1IRQSIS389:1;
    uint_io32_t		u1IRQSIS390:1;
    uint_io32_t		u1IRQSIS391:1;
    uint_io32_t		u1IRQSIS392:1;
    uint_io32_t		u1IRQSIS393:1;
    uint_io32_t		u1IRQSIS394:1;
    uint_io32_t		u1IRQSIS395:1;
    uint_io32_t		u1IRQSIS396:1;
    uint_io32_t		u1IRQSIS397:1;
    uint_io32_t		u1IRQSIS398:1;
    uint_io32_t		u1IRQSIS399:1;
    uint_io32_t		u1IRQSIS400:1;
    uint_io32_t		u1IRQSIS401:1;
    uint_io32_t		u1IRQSIS402:1;
    uint_io32_t		u1IRQSIS403:1;
    uint_io32_t		u1IRQSIS404:1;
    uint_io32_t		u1IRQSIS405:1;
    uint_io32_t		u1IRQSIS406:1;
    uint_io32_t		u1IRQSIS407:1;
    uint_io32_t		u1IRQSIS408:1;
    uint_io32_t		u1IRQSIS409:1;
    uint_io32_t		u1IRQSIS410:1;
    uint_io32_t		u1IRQSIS411:1;
    uint_io32_t		u1IRQSIS412:1;
    uint_io32_t		u1IRQSIS413:1;
    uint_io32_t		u1IRQSIS414:1;
    uint_io32_t		u1IRQSIS415:1;
}stc_irc0_irqsis12_field_t;

typedef union un_irc0_irqsis12{
    uint_io32_t		u32Register;
    stc_irc0_irqsis12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis12_t;

/* IRQSIS13 */
#define IRC0_IRQSIS13	(IRC0.unIRQSIS13.u32Register)  /*@rg@*/
#define IRC0_IRQSIS13_IRQSIS416	(IRC0.unIRQSIS13.stcField.u1IRQSIS416)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS417	(IRC0.unIRQSIS13.stcField.u1IRQSIS417)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS418	(IRC0.unIRQSIS13.stcField.u1IRQSIS418)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS419	(IRC0.unIRQSIS13.stcField.u1IRQSIS419)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS420	(IRC0.unIRQSIS13.stcField.u1IRQSIS420)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS421	(IRC0.unIRQSIS13.stcField.u1IRQSIS421)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS422	(IRC0.unIRQSIS13.stcField.u1IRQSIS422)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS423	(IRC0.unIRQSIS13.stcField.u1IRQSIS423)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS424	(IRC0.unIRQSIS13.stcField.u1IRQSIS424)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS425	(IRC0.unIRQSIS13.stcField.u1IRQSIS425)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS426	(IRC0.unIRQSIS13.stcField.u1IRQSIS426)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS427	(IRC0.unIRQSIS13.stcField.u1IRQSIS427)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS428	(IRC0.unIRQSIS13.stcField.u1IRQSIS428)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS429	(IRC0.unIRQSIS13.stcField.u1IRQSIS429)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS430	(IRC0.unIRQSIS13.stcField.u1IRQSIS430)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS431	(IRC0.unIRQSIS13.stcField.u1IRQSIS431)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS432	(IRC0.unIRQSIS13.stcField.u1IRQSIS432)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS433	(IRC0.unIRQSIS13.stcField.u1IRQSIS433)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS434	(IRC0.unIRQSIS13.stcField.u1IRQSIS434)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS435	(IRC0.unIRQSIS13.stcField.u1IRQSIS435)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS436	(IRC0.unIRQSIS13.stcField.u1IRQSIS436)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS437	(IRC0.unIRQSIS13.stcField.u1IRQSIS437)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS438	(IRC0.unIRQSIS13.stcField.u1IRQSIS438)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS439	(IRC0.unIRQSIS13.stcField.u1IRQSIS439)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS440	(IRC0.unIRQSIS13.stcField.u1IRQSIS440)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS441	(IRC0.unIRQSIS13.stcField.u1IRQSIS441)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS442	(IRC0.unIRQSIS13.stcField.u1IRQSIS442)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS443	(IRC0.unIRQSIS13.stcField.u1IRQSIS443)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS444	(IRC0.unIRQSIS13.stcField.u1IRQSIS444)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS445	(IRC0.unIRQSIS13.stcField.u1IRQSIS445)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS446	(IRC0.unIRQSIS13.stcField.u1IRQSIS446)  /*@bf@*/
#define IRC0_IRQSIS13_IRQSIS447	(IRC0.unIRQSIS13.stcField.u1IRQSIS447)  /*@bf@*/

typedef struct stc_irc0_irqsis13_field{
    uint_io32_t		u1IRQSIS416:1;
    uint_io32_t		u1IRQSIS417:1;
    uint_io32_t		u1IRQSIS418:1;
    uint_io32_t		u1IRQSIS419:1;
    uint_io32_t		u1IRQSIS420:1;
    uint_io32_t		u1IRQSIS421:1;
    uint_io32_t		u1IRQSIS422:1;
    uint_io32_t		u1IRQSIS423:1;
    uint_io32_t		u1IRQSIS424:1;
    uint_io32_t		u1IRQSIS425:1;
    uint_io32_t		u1IRQSIS426:1;
    uint_io32_t		u1IRQSIS427:1;
    uint_io32_t		u1IRQSIS428:1;
    uint_io32_t		u1IRQSIS429:1;
    uint_io32_t		u1IRQSIS430:1;
    uint_io32_t		u1IRQSIS431:1;
    uint_io32_t		u1IRQSIS432:1;
    uint_io32_t		u1IRQSIS433:1;
    uint_io32_t		u1IRQSIS434:1;
    uint_io32_t		u1IRQSIS435:1;
    uint_io32_t		u1IRQSIS436:1;
    uint_io32_t		u1IRQSIS437:1;
    uint_io32_t		u1IRQSIS438:1;
    uint_io32_t		u1IRQSIS439:1;
    uint_io32_t		u1IRQSIS440:1;
    uint_io32_t		u1IRQSIS441:1;
    uint_io32_t		u1IRQSIS442:1;
    uint_io32_t		u1IRQSIS443:1;
    uint_io32_t		u1IRQSIS444:1;
    uint_io32_t		u1IRQSIS445:1;
    uint_io32_t		u1IRQSIS446:1;
    uint_io32_t		u1IRQSIS447:1;
}stc_irc0_irqsis13_field_t;

typedef union un_irc0_irqsis13{
    uint_io32_t		u32Register;
    stc_irc0_irqsis13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis13_t;

/* IRQSIS14 */
#define IRC0_IRQSIS14	(IRC0.unIRQSIS14.u32Register)  /*@rg@*/
#define IRC0_IRQSIS14_IRQSIS448	(IRC0.unIRQSIS14.stcField.u1IRQSIS448)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS449	(IRC0.unIRQSIS14.stcField.u1IRQSIS449)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS450	(IRC0.unIRQSIS14.stcField.u1IRQSIS450)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS451	(IRC0.unIRQSIS14.stcField.u1IRQSIS451)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS452	(IRC0.unIRQSIS14.stcField.u1IRQSIS452)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS453	(IRC0.unIRQSIS14.stcField.u1IRQSIS453)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS454	(IRC0.unIRQSIS14.stcField.u1IRQSIS454)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS455	(IRC0.unIRQSIS14.stcField.u1IRQSIS455)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS456	(IRC0.unIRQSIS14.stcField.u1IRQSIS456)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS457	(IRC0.unIRQSIS14.stcField.u1IRQSIS457)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS458	(IRC0.unIRQSIS14.stcField.u1IRQSIS458)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS459	(IRC0.unIRQSIS14.stcField.u1IRQSIS459)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS460	(IRC0.unIRQSIS14.stcField.u1IRQSIS460)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS461	(IRC0.unIRQSIS14.stcField.u1IRQSIS461)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS462	(IRC0.unIRQSIS14.stcField.u1IRQSIS462)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS463	(IRC0.unIRQSIS14.stcField.u1IRQSIS463)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS464	(IRC0.unIRQSIS14.stcField.u1IRQSIS464)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS465	(IRC0.unIRQSIS14.stcField.u1IRQSIS465)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS466	(IRC0.unIRQSIS14.stcField.u1IRQSIS466)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS467	(IRC0.unIRQSIS14.stcField.u1IRQSIS467)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS468	(IRC0.unIRQSIS14.stcField.u1IRQSIS468)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS469	(IRC0.unIRQSIS14.stcField.u1IRQSIS469)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS470	(IRC0.unIRQSIS14.stcField.u1IRQSIS470)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS471	(IRC0.unIRQSIS14.stcField.u1IRQSIS471)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS472	(IRC0.unIRQSIS14.stcField.u1IRQSIS472)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS473	(IRC0.unIRQSIS14.stcField.u1IRQSIS473)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS474	(IRC0.unIRQSIS14.stcField.u1IRQSIS474)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS475	(IRC0.unIRQSIS14.stcField.u1IRQSIS475)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS476	(IRC0.unIRQSIS14.stcField.u1IRQSIS476)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS477	(IRC0.unIRQSIS14.stcField.u1IRQSIS477)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS478	(IRC0.unIRQSIS14.stcField.u1IRQSIS478)  /*@bf@*/
#define IRC0_IRQSIS14_IRQSIS479	(IRC0.unIRQSIS14.stcField.u1IRQSIS479)  /*@bf@*/

typedef struct stc_irc0_irqsis14_field{
    uint_io32_t		u1IRQSIS448:1;
    uint_io32_t		u1IRQSIS449:1;
    uint_io32_t		u1IRQSIS450:1;
    uint_io32_t		u1IRQSIS451:1;
    uint_io32_t		u1IRQSIS452:1;
    uint_io32_t		u1IRQSIS453:1;
    uint_io32_t		u1IRQSIS454:1;
    uint_io32_t		u1IRQSIS455:1;
    uint_io32_t		u1IRQSIS456:1;
    uint_io32_t		u1IRQSIS457:1;
    uint_io32_t		u1IRQSIS458:1;
    uint_io32_t		u1IRQSIS459:1;
    uint_io32_t		u1IRQSIS460:1;
    uint_io32_t		u1IRQSIS461:1;
    uint_io32_t		u1IRQSIS462:1;
    uint_io32_t		u1IRQSIS463:1;
    uint_io32_t		u1IRQSIS464:1;
    uint_io32_t		u1IRQSIS465:1;
    uint_io32_t		u1IRQSIS466:1;
    uint_io32_t		u1IRQSIS467:1;
    uint_io32_t		u1IRQSIS468:1;
    uint_io32_t		u1IRQSIS469:1;
    uint_io32_t		u1IRQSIS470:1;
    uint_io32_t		u1IRQSIS471:1;
    uint_io32_t		u1IRQSIS472:1;
    uint_io32_t		u1IRQSIS473:1;
    uint_io32_t		u1IRQSIS474:1;
    uint_io32_t		u1IRQSIS475:1;
    uint_io32_t		u1IRQSIS476:1;
    uint_io32_t		u1IRQSIS477:1;
    uint_io32_t		u1IRQSIS478:1;
    uint_io32_t		u1IRQSIS479:1;
}stc_irc0_irqsis14_field_t;

typedef union un_irc0_irqsis14{
    uint_io32_t		u32Register;
    stc_irc0_irqsis14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis14_t;

/* IRQSIS15 */
#define IRC0_IRQSIS15	(IRC0.unIRQSIS15.u32Register)  /*@rg@*/
#define IRC0_IRQSIS15_IRQSIS480	(IRC0.unIRQSIS15.stcField.u1IRQSIS480)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS481	(IRC0.unIRQSIS15.stcField.u1IRQSIS481)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS482	(IRC0.unIRQSIS15.stcField.u1IRQSIS482)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS483	(IRC0.unIRQSIS15.stcField.u1IRQSIS483)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS484	(IRC0.unIRQSIS15.stcField.u1IRQSIS484)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS485	(IRC0.unIRQSIS15.stcField.u1IRQSIS485)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS486	(IRC0.unIRQSIS15.stcField.u1IRQSIS486)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS487	(IRC0.unIRQSIS15.stcField.u1IRQSIS487)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS488	(IRC0.unIRQSIS15.stcField.u1IRQSIS488)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS489	(IRC0.unIRQSIS15.stcField.u1IRQSIS489)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS490	(IRC0.unIRQSIS15.stcField.u1IRQSIS490)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS491	(IRC0.unIRQSIS15.stcField.u1IRQSIS491)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS492	(IRC0.unIRQSIS15.stcField.u1IRQSIS492)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS493	(IRC0.unIRQSIS15.stcField.u1IRQSIS493)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS494	(IRC0.unIRQSIS15.stcField.u1IRQSIS494)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS495	(IRC0.unIRQSIS15.stcField.u1IRQSIS495)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS496	(IRC0.unIRQSIS15.stcField.u1IRQSIS496)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS497	(IRC0.unIRQSIS15.stcField.u1IRQSIS497)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS498	(IRC0.unIRQSIS15.stcField.u1IRQSIS498)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS499	(IRC0.unIRQSIS15.stcField.u1IRQSIS499)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS500	(IRC0.unIRQSIS15.stcField.u1IRQSIS500)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS501	(IRC0.unIRQSIS15.stcField.u1IRQSIS501)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS502	(IRC0.unIRQSIS15.stcField.u1IRQSIS502)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS503	(IRC0.unIRQSIS15.stcField.u1IRQSIS503)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS504	(IRC0.unIRQSIS15.stcField.u1IRQSIS504)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS505	(IRC0.unIRQSIS15.stcField.u1IRQSIS505)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS506	(IRC0.unIRQSIS15.stcField.u1IRQSIS506)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS507	(IRC0.unIRQSIS15.stcField.u1IRQSIS507)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS508	(IRC0.unIRQSIS15.stcField.u1IRQSIS508)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS509	(IRC0.unIRQSIS15.stcField.u1IRQSIS509)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS510	(IRC0.unIRQSIS15.stcField.u1IRQSIS510)  /*@bf@*/
#define IRC0_IRQSIS15_IRQSIS511	(IRC0.unIRQSIS15.stcField.u1IRQSIS511)  /*@bf@*/

typedef struct stc_irc0_irqsis15_field{
    uint_io32_t		u1IRQSIS480:1;
    uint_io32_t		u1IRQSIS481:1;
    uint_io32_t		u1IRQSIS482:1;
    uint_io32_t		u1IRQSIS483:1;
    uint_io32_t		u1IRQSIS484:1;
    uint_io32_t		u1IRQSIS485:1;
    uint_io32_t		u1IRQSIS486:1;
    uint_io32_t		u1IRQSIS487:1;
    uint_io32_t		u1IRQSIS488:1;
    uint_io32_t		u1IRQSIS489:1;
    uint_io32_t		u1IRQSIS490:1;
    uint_io32_t		u1IRQSIS491:1;
    uint_io32_t		u1IRQSIS492:1;
    uint_io32_t		u1IRQSIS493:1;
    uint_io32_t		u1IRQSIS494:1;
    uint_io32_t		u1IRQSIS495:1;
    uint_io32_t		u1IRQSIS496:1;
    uint_io32_t		u1IRQSIS497:1;
    uint_io32_t		u1IRQSIS498:1;
    uint_io32_t		u1IRQSIS499:1;
    uint_io32_t		u1IRQSIS500:1;
    uint_io32_t		u1IRQSIS501:1;
    uint_io32_t		u1IRQSIS502:1;
    uint_io32_t		u1IRQSIS503:1;
    uint_io32_t		u1IRQSIS504:1;
    uint_io32_t		u1IRQSIS505:1;
    uint_io32_t		u1IRQSIS506:1;
    uint_io32_t		u1IRQSIS507:1;
    uint_io32_t		u1IRQSIS508:1;
    uint_io32_t		u1IRQSIS509:1;
    uint_io32_t		u1IRQSIS510:1;
    uint_io32_t		u1IRQSIS511:1;
}stc_irc0_irqsis15_field_t;

typedef union un_irc0_irqsis15{
    uint_io32_t		u32Register;
    stc_irc0_irqsis15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqsis15_t;

/* IRQCES0 */
#define IRC0_IRQCES0	(IRC0.unIRQCES0.u32Register)  /*@rg@*/
#define IRC0_IRQCES0_IRQCES0	(IRC0.unIRQCES0.stcField.u1IRQCES0)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES1	(IRC0.unIRQCES0.stcField.u1IRQCES1)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES2	(IRC0.unIRQCES0.stcField.u1IRQCES2)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES3	(IRC0.unIRQCES0.stcField.u1IRQCES3)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES4	(IRC0.unIRQCES0.stcField.u1IRQCES4)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES5	(IRC0.unIRQCES0.stcField.u1IRQCES5)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES6	(IRC0.unIRQCES0.stcField.u1IRQCES6)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES7	(IRC0.unIRQCES0.stcField.u1IRQCES7)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES8	(IRC0.unIRQCES0.stcField.u1IRQCES8)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES9	(IRC0.unIRQCES0.stcField.u1IRQCES9)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES10	(IRC0.unIRQCES0.stcField.u1IRQCES10)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES11	(IRC0.unIRQCES0.stcField.u1IRQCES11)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES12	(IRC0.unIRQCES0.stcField.u1IRQCES12)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES13	(IRC0.unIRQCES0.stcField.u1IRQCES13)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES14	(IRC0.unIRQCES0.stcField.u1IRQCES14)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES15	(IRC0.unIRQCES0.stcField.u1IRQCES15)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES16	(IRC0.unIRQCES0.stcField.u1IRQCES16)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES17	(IRC0.unIRQCES0.stcField.u1IRQCES17)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES18	(IRC0.unIRQCES0.stcField.u1IRQCES18)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES19	(IRC0.unIRQCES0.stcField.u1IRQCES19)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES20	(IRC0.unIRQCES0.stcField.u1IRQCES20)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES21	(IRC0.unIRQCES0.stcField.u1IRQCES21)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES22	(IRC0.unIRQCES0.stcField.u1IRQCES22)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES23	(IRC0.unIRQCES0.stcField.u1IRQCES23)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES24	(IRC0.unIRQCES0.stcField.u1IRQCES24)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES25	(IRC0.unIRQCES0.stcField.u1IRQCES25)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES26	(IRC0.unIRQCES0.stcField.u1IRQCES26)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES27	(IRC0.unIRQCES0.stcField.u1IRQCES27)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES28	(IRC0.unIRQCES0.stcField.u1IRQCES28)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES29	(IRC0.unIRQCES0.stcField.u1IRQCES29)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES30	(IRC0.unIRQCES0.stcField.u1IRQCES30)  /*@bf@*/
#define IRC0_IRQCES0_IRQCES31	(IRC0.unIRQCES0.stcField.u1IRQCES31)  /*@bf@*/

typedef struct stc_irc0_irqces0_field{
    uint_io32_t		u1IRQCES0:1;
    uint_io32_t		u1IRQCES1:1;
    uint_io32_t		u1IRQCES2:1;
    uint_io32_t		u1IRQCES3:1;
    uint_io32_t		u1IRQCES4:1;
    uint_io32_t		u1IRQCES5:1;
    uint_io32_t		u1IRQCES6:1;
    uint_io32_t		u1IRQCES7:1;
    uint_io32_t		u1IRQCES8:1;
    uint_io32_t		u1IRQCES9:1;
    uint_io32_t		u1IRQCES10:1;
    uint_io32_t		u1IRQCES11:1;
    uint_io32_t		u1IRQCES12:1;
    uint_io32_t		u1IRQCES13:1;
    uint_io32_t		u1IRQCES14:1;
    uint_io32_t		u1IRQCES15:1;
    uint_io32_t		u1IRQCES16:1;
    uint_io32_t		u1IRQCES17:1;
    uint_io32_t		u1IRQCES18:1;
    uint_io32_t		u1IRQCES19:1;
    uint_io32_t		u1IRQCES20:1;
    uint_io32_t		u1IRQCES21:1;
    uint_io32_t		u1IRQCES22:1;
    uint_io32_t		u1IRQCES23:1;
    uint_io32_t		u1IRQCES24:1;
    uint_io32_t		u1IRQCES25:1;
    uint_io32_t		u1IRQCES26:1;
    uint_io32_t		u1IRQCES27:1;
    uint_io32_t		u1IRQCES28:1;
    uint_io32_t		u1IRQCES29:1;
    uint_io32_t		u1IRQCES30:1;
    uint_io32_t		u1IRQCES31:1;
}stc_irc0_irqces0_field_t;

typedef union un_irc0_irqces0{
    uint_io32_t		u32Register;
    stc_irc0_irqces0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces0_t;

/* IRQCES1 */
#define IRC0_IRQCES1	(IRC0.unIRQCES1.u32Register)  /*@rg@*/
#define IRC0_IRQCES1_IRQCES32	(IRC0.unIRQCES1.stcField.u1IRQCES32)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES33	(IRC0.unIRQCES1.stcField.u1IRQCES33)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES34	(IRC0.unIRQCES1.stcField.u1IRQCES34)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES35	(IRC0.unIRQCES1.stcField.u1IRQCES35)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES36	(IRC0.unIRQCES1.stcField.u1IRQCES36)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES37	(IRC0.unIRQCES1.stcField.u1IRQCES37)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES38	(IRC0.unIRQCES1.stcField.u1IRQCES38)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES39	(IRC0.unIRQCES1.stcField.u1IRQCES39)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES40	(IRC0.unIRQCES1.stcField.u1IRQCES40)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES41	(IRC0.unIRQCES1.stcField.u1IRQCES41)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES42	(IRC0.unIRQCES1.stcField.u1IRQCES42)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES43	(IRC0.unIRQCES1.stcField.u1IRQCES43)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES44	(IRC0.unIRQCES1.stcField.u1IRQCES44)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES45	(IRC0.unIRQCES1.stcField.u1IRQCES45)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES46	(IRC0.unIRQCES1.stcField.u1IRQCES46)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES47	(IRC0.unIRQCES1.stcField.u1IRQCES47)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES48	(IRC0.unIRQCES1.stcField.u1IRQCES48)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES49	(IRC0.unIRQCES1.stcField.u1IRQCES49)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES50	(IRC0.unIRQCES1.stcField.u1IRQCES50)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES51	(IRC0.unIRQCES1.stcField.u1IRQCES51)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES52	(IRC0.unIRQCES1.stcField.u1IRQCES52)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES53	(IRC0.unIRQCES1.stcField.u1IRQCES53)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES54	(IRC0.unIRQCES1.stcField.u1IRQCES54)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES55	(IRC0.unIRQCES1.stcField.u1IRQCES55)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES56	(IRC0.unIRQCES1.stcField.u1IRQCES56)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES57	(IRC0.unIRQCES1.stcField.u1IRQCES57)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES58	(IRC0.unIRQCES1.stcField.u1IRQCES58)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES59	(IRC0.unIRQCES1.stcField.u1IRQCES59)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES60	(IRC0.unIRQCES1.stcField.u1IRQCES60)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES61	(IRC0.unIRQCES1.stcField.u1IRQCES61)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES62	(IRC0.unIRQCES1.stcField.u1IRQCES62)  /*@bf@*/
#define IRC0_IRQCES1_IRQCES63	(IRC0.unIRQCES1.stcField.u1IRQCES63)  /*@bf@*/

typedef struct stc_irc0_irqces1_field{
    uint_io32_t		u1IRQCES32:1;
    uint_io32_t		u1IRQCES33:1;
    uint_io32_t		u1IRQCES34:1;
    uint_io32_t		u1IRQCES35:1;
    uint_io32_t		u1IRQCES36:1;
    uint_io32_t		u1IRQCES37:1;
    uint_io32_t		u1IRQCES38:1;
    uint_io32_t		u1IRQCES39:1;
    uint_io32_t		u1IRQCES40:1;
    uint_io32_t		u1IRQCES41:1;
    uint_io32_t		u1IRQCES42:1;
    uint_io32_t		u1IRQCES43:1;
    uint_io32_t		u1IRQCES44:1;
    uint_io32_t		u1IRQCES45:1;
    uint_io32_t		u1IRQCES46:1;
    uint_io32_t		u1IRQCES47:1;
    uint_io32_t		u1IRQCES48:1;
    uint_io32_t		u1IRQCES49:1;
    uint_io32_t		u1IRQCES50:1;
    uint_io32_t		u1IRQCES51:1;
    uint_io32_t		u1IRQCES52:1;
    uint_io32_t		u1IRQCES53:1;
    uint_io32_t		u1IRQCES54:1;
    uint_io32_t		u1IRQCES55:1;
    uint_io32_t		u1IRQCES56:1;
    uint_io32_t		u1IRQCES57:1;
    uint_io32_t		u1IRQCES58:1;
    uint_io32_t		u1IRQCES59:1;
    uint_io32_t		u1IRQCES60:1;
    uint_io32_t		u1IRQCES61:1;
    uint_io32_t		u1IRQCES62:1;
    uint_io32_t		u1IRQCES63:1;
}stc_irc0_irqces1_field_t;

typedef union un_irc0_irqces1{
    uint_io32_t		u32Register;
    stc_irc0_irqces1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces1_t;

/* IRQCES2 */
#define IRC0_IRQCES2	(IRC0.unIRQCES2.u32Register)  /*@rg@*/
#define IRC0_IRQCES2_IRQCES64	(IRC0.unIRQCES2.stcField.u1IRQCES64)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES65	(IRC0.unIRQCES2.stcField.u1IRQCES65)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES66	(IRC0.unIRQCES2.stcField.u1IRQCES66)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES67	(IRC0.unIRQCES2.stcField.u1IRQCES67)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES68	(IRC0.unIRQCES2.stcField.u1IRQCES68)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES69	(IRC0.unIRQCES2.stcField.u1IRQCES69)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES70	(IRC0.unIRQCES2.stcField.u1IRQCES70)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES71	(IRC0.unIRQCES2.stcField.u1IRQCES71)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES72	(IRC0.unIRQCES2.stcField.u1IRQCES72)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES73	(IRC0.unIRQCES2.stcField.u1IRQCES73)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES74	(IRC0.unIRQCES2.stcField.u1IRQCES74)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES75	(IRC0.unIRQCES2.stcField.u1IRQCES75)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES76	(IRC0.unIRQCES2.stcField.u1IRQCES76)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES77	(IRC0.unIRQCES2.stcField.u1IRQCES77)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES78	(IRC0.unIRQCES2.stcField.u1IRQCES78)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES79	(IRC0.unIRQCES2.stcField.u1IRQCES79)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES80	(IRC0.unIRQCES2.stcField.u1IRQCES80)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES81	(IRC0.unIRQCES2.stcField.u1IRQCES81)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES82	(IRC0.unIRQCES2.stcField.u1IRQCES82)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES83	(IRC0.unIRQCES2.stcField.u1IRQCES83)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES84	(IRC0.unIRQCES2.stcField.u1IRQCES84)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES85	(IRC0.unIRQCES2.stcField.u1IRQCES85)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES86	(IRC0.unIRQCES2.stcField.u1IRQCES86)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES87	(IRC0.unIRQCES2.stcField.u1IRQCES87)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES88	(IRC0.unIRQCES2.stcField.u1IRQCES88)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES89	(IRC0.unIRQCES2.stcField.u1IRQCES89)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES90	(IRC0.unIRQCES2.stcField.u1IRQCES90)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES91	(IRC0.unIRQCES2.stcField.u1IRQCES91)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES92	(IRC0.unIRQCES2.stcField.u1IRQCES92)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES93	(IRC0.unIRQCES2.stcField.u1IRQCES93)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES94	(IRC0.unIRQCES2.stcField.u1IRQCES94)  /*@bf@*/
#define IRC0_IRQCES2_IRQCES95	(IRC0.unIRQCES2.stcField.u1IRQCES95)  /*@bf@*/

typedef struct stc_irc0_irqces2_field{
    uint_io32_t		u1IRQCES64:1;
    uint_io32_t		u1IRQCES65:1;
    uint_io32_t		u1IRQCES66:1;
    uint_io32_t		u1IRQCES67:1;
    uint_io32_t		u1IRQCES68:1;
    uint_io32_t		u1IRQCES69:1;
    uint_io32_t		u1IRQCES70:1;
    uint_io32_t		u1IRQCES71:1;
    uint_io32_t		u1IRQCES72:1;
    uint_io32_t		u1IRQCES73:1;
    uint_io32_t		u1IRQCES74:1;
    uint_io32_t		u1IRQCES75:1;
    uint_io32_t		u1IRQCES76:1;
    uint_io32_t		u1IRQCES77:1;
    uint_io32_t		u1IRQCES78:1;
    uint_io32_t		u1IRQCES79:1;
    uint_io32_t		u1IRQCES80:1;
    uint_io32_t		u1IRQCES81:1;
    uint_io32_t		u1IRQCES82:1;
    uint_io32_t		u1IRQCES83:1;
    uint_io32_t		u1IRQCES84:1;
    uint_io32_t		u1IRQCES85:1;
    uint_io32_t		u1IRQCES86:1;
    uint_io32_t		u1IRQCES87:1;
    uint_io32_t		u1IRQCES88:1;
    uint_io32_t		u1IRQCES89:1;
    uint_io32_t		u1IRQCES90:1;
    uint_io32_t		u1IRQCES91:1;
    uint_io32_t		u1IRQCES92:1;
    uint_io32_t		u1IRQCES93:1;
    uint_io32_t		u1IRQCES94:1;
    uint_io32_t		u1IRQCES95:1;
}stc_irc0_irqces2_field_t;

typedef union un_irc0_irqces2{
    uint_io32_t		u32Register;
    stc_irc0_irqces2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces2_t;

/* IRQCES3 */
#define IRC0_IRQCES3	(IRC0.unIRQCES3.u32Register)  /*@rg@*/
#define IRC0_IRQCES3_IRQCES96	(IRC0.unIRQCES3.stcField.u1IRQCES96)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES97	(IRC0.unIRQCES3.stcField.u1IRQCES97)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES98	(IRC0.unIRQCES3.stcField.u1IRQCES98)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES99	(IRC0.unIRQCES3.stcField.u1IRQCES99)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES100	(IRC0.unIRQCES3.stcField.u1IRQCES100)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES101	(IRC0.unIRQCES3.stcField.u1IRQCES101)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES102	(IRC0.unIRQCES3.stcField.u1IRQCES102)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES103	(IRC0.unIRQCES3.stcField.u1IRQCES103)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES104	(IRC0.unIRQCES3.stcField.u1IRQCES104)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES105	(IRC0.unIRQCES3.stcField.u1IRQCES105)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES106	(IRC0.unIRQCES3.stcField.u1IRQCES106)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES107	(IRC0.unIRQCES3.stcField.u1IRQCES107)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES108	(IRC0.unIRQCES3.stcField.u1IRQCES108)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES109	(IRC0.unIRQCES3.stcField.u1IRQCES109)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES110	(IRC0.unIRQCES3.stcField.u1IRQCES110)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES111	(IRC0.unIRQCES3.stcField.u1IRQCES111)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES112	(IRC0.unIRQCES3.stcField.u1IRQCES112)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES113	(IRC0.unIRQCES3.stcField.u1IRQCES113)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES114	(IRC0.unIRQCES3.stcField.u1IRQCES114)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES115	(IRC0.unIRQCES3.stcField.u1IRQCES115)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES116	(IRC0.unIRQCES3.stcField.u1IRQCES116)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES117	(IRC0.unIRQCES3.stcField.u1IRQCES117)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES118	(IRC0.unIRQCES3.stcField.u1IRQCES118)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES119	(IRC0.unIRQCES3.stcField.u1IRQCES119)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES120	(IRC0.unIRQCES3.stcField.u1IRQCES120)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES121	(IRC0.unIRQCES3.stcField.u1IRQCES121)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES122	(IRC0.unIRQCES3.stcField.u1IRQCES122)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES123	(IRC0.unIRQCES3.stcField.u1IRQCES123)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES124	(IRC0.unIRQCES3.stcField.u1IRQCES124)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES125	(IRC0.unIRQCES3.stcField.u1IRQCES125)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES126	(IRC0.unIRQCES3.stcField.u1IRQCES126)  /*@bf@*/
#define IRC0_IRQCES3_IRQCES127	(IRC0.unIRQCES3.stcField.u1IRQCES127)  /*@bf@*/

typedef struct stc_irc0_irqces3_field{
    uint_io32_t		u1IRQCES96:1;
    uint_io32_t		u1IRQCES97:1;
    uint_io32_t		u1IRQCES98:1;
    uint_io32_t		u1IRQCES99:1;
    uint_io32_t		u1IRQCES100:1;
    uint_io32_t		u1IRQCES101:1;
    uint_io32_t		u1IRQCES102:1;
    uint_io32_t		u1IRQCES103:1;
    uint_io32_t		u1IRQCES104:1;
    uint_io32_t		u1IRQCES105:1;
    uint_io32_t		u1IRQCES106:1;
    uint_io32_t		u1IRQCES107:1;
    uint_io32_t		u1IRQCES108:1;
    uint_io32_t		u1IRQCES109:1;
    uint_io32_t		u1IRQCES110:1;
    uint_io32_t		u1IRQCES111:1;
    uint_io32_t		u1IRQCES112:1;
    uint_io32_t		u1IRQCES113:1;
    uint_io32_t		u1IRQCES114:1;
    uint_io32_t		u1IRQCES115:1;
    uint_io32_t		u1IRQCES116:1;
    uint_io32_t		u1IRQCES117:1;
    uint_io32_t		u1IRQCES118:1;
    uint_io32_t		u1IRQCES119:1;
    uint_io32_t		u1IRQCES120:1;
    uint_io32_t		u1IRQCES121:1;
    uint_io32_t		u1IRQCES122:1;
    uint_io32_t		u1IRQCES123:1;
    uint_io32_t		u1IRQCES124:1;
    uint_io32_t		u1IRQCES125:1;
    uint_io32_t		u1IRQCES126:1;
    uint_io32_t		u1IRQCES127:1;
}stc_irc0_irqces3_field_t;

typedef union un_irc0_irqces3{
    uint_io32_t		u32Register;
    stc_irc0_irqces3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces3_t;

/* IRQCES4 */
#define IRC0_IRQCES4	(IRC0.unIRQCES4.u32Register)  /*@rg@*/
#define IRC0_IRQCES4_IRQCES128	(IRC0.unIRQCES4.stcField.u1IRQCES128)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES129	(IRC0.unIRQCES4.stcField.u1IRQCES129)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES130	(IRC0.unIRQCES4.stcField.u1IRQCES130)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES131	(IRC0.unIRQCES4.stcField.u1IRQCES131)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES132	(IRC0.unIRQCES4.stcField.u1IRQCES132)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES133	(IRC0.unIRQCES4.stcField.u1IRQCES133)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES134	(IRC0.unIRQCES4.stcField.u1IRQCES134)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES135	(IRC0.unIRQCES4.stcField.u1IRQCES135)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES136	(IRC0.unIRQCES4.stcField.u1IRQCES136)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES137	(IRC0.unIRQCES4.stcField.u1IRQCES137)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES138	(IRC0.unIRQCES4.stcField.u1IRQCES138)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES139	(IRC0.unIRQCES4.stcField.u1IRQCES139)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES140	(IRC0.unIRQCES4.stcField.u1IRQCES140)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES141	(IRC0.unIRQCES4.stcField.u1IRQCES141)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES142	(IRC0.unIRQCES4.stcField.u1IRQCES142)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES143	(IRC0.unIRQCES4.stcField.u1IRQCES143)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES144	(IRC0.unIRQCES4.stcField.u1IRQCES144)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES145	(IRC0.unIRQCES4.stcField.u1IRQCES145)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES146	(IRC0.unIRQCES4.stcField.u1IRQCES146)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES147	(IRC0.unIRQCES4.stcField.u1IRQCES147)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES148	(IRC0.unIRQCES4.stcField.u1IRQCES148)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES149	(IRC0.unIRQCES4.stcField.u1IRQCES149)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES150	(IRC0.unIRQCES4.stcField.u1IRQCES150)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES151	(IRC0.unIRQCES4.stcField.u1IRQCES151)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES152	(IRC0.unIRQCES4.stcField.u1IRQCES152)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES153	(IRC0.unIRQCES4.stcField.u1IRQCES153)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES154	(IRC0.unIRQCES4.stcField.u1IRQCES154)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES155	(IRC0.unIRQCES4.stcField.u1IRQCES155)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES156	(IRC0.unIRQCES4.stcField.u1IRQCES156)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES157	(IRC0.unIRQCES4.stcField.u1IRQCES157)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES158	(IRC0.unIRQCES4.stcField.u1IRQCES158)  /*@bf@*/
#define IRC0_IRQCES4_IRQCES159	(IRC0.unIRQCES4.stcField.u1IRQCES159)  /*@bf@*/

typedef struct stc_irc0_irqces4_field{
    uint_io32_t		u1IRQCES128:1;
    uint_io32_t		u1IRQCES129:1;
    uint_io32_t		u1IRQCES130:1;
    uint_io32_t		u1IRQCES131:1;
    uint_io32_t		u1IRQCES132:1;
    uint_io32_t		u1IRQCES133:1;
    uint_io32_t		u1IRQCES134:1;
    uint_io32_t		u1IRQCES135:1;
    uint_io32_t		u1IRQCES136:1;
    uint_io32_t		u1IRQCES137:1;
    uint_io32_t		u1IRQCES138:1;
    uint_io32_t		u1IRQCES139:1;
    uint_io32_t		u1IRQCES140:1;
    uint_io32_t		u1IRQCES141:1;
    uint_io32_t		u1IRQCES142:1;
    uint_io32_t		u1IRQCES143:1;
    uint_io32_t		u1IRQCES144:1;
    uint_io32_t		u1IRQCES145:1;
    uint_io32_t		u1IRQCES146:1;
    uint_io32_t		u1IRQCES147:1;
    uint_io32_t		u1IRQCES148:1;
    uint_io32_t		u1IRQCES149:1;
    uint_io32_t		u1IRQCES150:1;
    uint_io32_t		u1IRQCES151:1;
    uint_io32_t		u1IRQCES152:1;
    uint_io32_t		u1IRQCES153:1;
    uint_io32_t		u1IRQCES154:1;
    uint_io32_t		u1IRQCES155:1;
    uint_io32_t		u1IRQCES156:1;
    uint_io32_t		u1IRQCES157:1;
    uint_io32_t		u1IRQCES158:1;
    uint_io32_t		u1IRQCES159:1;
}stc_irc0_irqces4_field_t;

typedef union un_irc0_irqces4{
    uint_io32_t		u32Register;
    stc_irc0_irqces4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces4_t;

/* IRQCES5 */
#define IRC0_IRQCES5	(IRC0.unIRQCES5.u32Register)  /*@rg@*/
#define IRC0_IRQCES5_IRQCES160	(IRC0.unIRQCES5.stcField.u1IRQCES160)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES161	(IRC0.unIRQCES5.stcField.u1IRQCES161)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES162	(IRC0.unIRQCES5.stcField.u1IRQCES162)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES163	(IRC0.unIRQCES5.stcField.u1IRQCES163)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES164	(IRC0.unIRQCES5.stcField.u1IRQCES164)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES165	(IRC0.unIRQCES5.stcField.u1IRQCES165)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES166	(IRC0.unIRQCES5.stcField.u1IRQCES166)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES167	(IRC0.unIRQCES5.stcField.u1IRQCES167)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES168	(IRC0.unIRQCES5.stcField.u1IRQCES168)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES169	(IRC0.unIRQCES5.stcField.u1IRQCES169)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES170	(IRC0.unIRQCES5.stcField.u1IRQCES170)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES171	(IRC0.unIRQCES5.stcField.u1IRQCES171)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES172	(IRC0.unIRQCES5.stcField.u1IRQCES172)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES173	(IRC0.unIRQCES5.stcField.u1IRQCES173)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES174	(IRC0.unIRQCES5.stcField.u1IRQCES174)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES175	(IRC0.unIRQCES5.stcField.u1IRQCES175)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES176	(IRC0.unIRQCES5.stcField.u1IRQCES176)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES177	(IRC0.unIRQCES5.stcField.u1IRQCES177)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES178	(IRC0.unIRQCES5.stcField.u1IRQCES178)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES179	(IRC0.unIRQCES5.stcField.u1IRQCES179)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES180	(IRC0.unIRQCES5.stcField.u1IRQCES180)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES181	(IRC0.unIRQCES5.stcField.u1IRQCES181)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES182	(IRC0.unIRQCES5.stcField.u1IRQCES182)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES183	(IRC0.unIRQCES5.stcField.u1IRQCES183)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES184	(IRC0.unIRQCES5.stcField.u1IRQCES184)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES185	(IRC0.unIRQCES5.stcField.u1IRQCES185)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES186	(IRC0.unIRQCES5.stcField.u1IRQCES186)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES187	(IRC0.unIRQCES5.stcField.u1IRQCES187)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES188	(IRC0.unIRQCES5.stcField.u1IRQCES188)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES189	(IRC0.unIRQCES5.stcField.u1IRQCES189)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES190	(IRC0.unIRQCES5.stcField.u1IRQCES190)  /*@bf@*/
#define IRC0_IRQCES5_IRQCES191	(IRC0.unIRQCES5.stcField.u1IRQCES191)  /*@bf@*/

typedef struct stc_irc0_irqces5_field{
    uint_io32_t		u1IRQCES160:1;
    uint_io32_t		u1IRQCES161:1;
    uint_io32_t		u1IRQCES162:1;
    uint_io32_t		u1IRQCES163:1;
    uint_io32_t		u1IRQCES164:1;
    uint_io32_t		u1IRQCES165:1;
    uint_io32_t		u1IRQCES166:1;
    uint_io32_t		u1IRQCES167:1;
    uint_io32_t		u1IRQCES168:1;
    uint_io32_t		u1IRQCES169:1;
    uint_io32_t		u1IRQCES170:1;
    uint_io32_t		u1IRQCES171:1;
    uint_io32_t		u1IRQCES172:1;
    uint_io32_t		u1IRQCES173:1;
    uint_io32_t		u1IRQCES174:1;
    uint_io32_t		u1IRQCES175:1;
    uint_io32_t		u1IRQCES176:1;
    uint_io32_t		u1IRQCES177:1;
    uint_io32_t		u1IRQCES178:1;
    uint_io32_t		u1IRQCES179:1;
    uint_io32_t		u1IRQCES180:1;
    uint_io32_t		u1IRQCES181:1;
    uint_io32_t		u1IRQCES182:1;
    uint_io32_t		u1IRQCES183:1;
    uint_io32_t		u1IRQCES184:1;
    uint_io32_t		u1IRQCES185:1;
    uint_io32_t		u1IRQCES186:1;
    uint_io32_t		u1IRQCES187:1;
    uint_io32_t		u1IRQCES188:1;
    uint_io32_t		u1IRQCES189:1;
    uint_io32_t		u1IRQCES190:1;
    uint_io32_t		u1IRQCES191:1;
}stc_irc0_irqces5_field_t;

typedef union un_irc0_irqces5{
    uint_io32_t		u32Register;
    stc_irc0_irqces5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces5_t;

/* IRQCES6 */
#define IRC0_IRQCES6	(IRC0.unIRQCES6.u32Register)  /*@rg@*/
#define IRC0_IRQCES6_IRQCES192	(IRC0.unIRQCES6.stcField.u1IRQCES192)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES193	(IRC0.unIRQCES6.stcField.u1IRQCES193)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES194	(IRC0.unIRQCES6.stcField.u1IRQCES194)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES195	(IRC0.unIRQCES6.stcField.u1IRQCES195)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES196	(IRC0.unIRQCES6.stcField.u1IRQCES196)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES197	(IRC0.unIRQCES6.stcField.u1IRQCES197)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES198	(IRC0.unIRQCES6.stcField.u1IRQCES198)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES199	(IRC0.unIRQCES6.stcField.u1IRQCES199)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES200	(IRC0.unIRQCES6.stcField.u1IRQCES200)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES201	(IRC0.unIRQCES6.stcField.u1IRQCES201)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES202	(IRC0.unIRQCES6.stcField.u1IRQCES202)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES203	(IRC0.unIRQCES6.stcField.u1IRQCES203)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES204	(IRC0.unIRQCES6.stcField.u1IRQCES204)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES205	(IRC0.unIRQCES6.stcField.u1IRQCES205)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES206	(IRC0.unIRQCES6.stcField.u1IRQCES206)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES207	(IRC0.unIRQCES6.stcField.u1IRQCES207)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES208	(IRC0.unIRQCES6.stcField.u1IRQCES208)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES209	(IRC0.unIRQCES6.stcField.u1IRQCES209)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES210	(IRC0.unIRQCES6.stcField.u1IRQCES210)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES211	(IRC0.unIRQCES6.stcField.u1IRQCES211)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES212	(IRC0.unIRQCES6.stcField.u1IRQCES212)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES213	(IRC0.unIRQCES6.stcField.u1IRQCES213)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES214	(IRC0.unIRQCES6.stcField.u1IRQCES214)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES215	(IRC0.unIRQCES6.stcField.u1IRQCES215)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES216	(IRC0.unIRQCES6.stcField.u1IRQCES216)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES217	(IRC0.unIRQCES6.stcField.u1IRQCES217)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES218	(IRC0.unIRQCES6.stcField.u1IRQCES218)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES219	(IRC0.unIRQCES6.stcField.u1IRQCES219)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES220	(IRC0.unIRQCES6.stcField.u1IRQCES220)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES221	(IRC0.unIRQCES6.stcField.u1IRQCES221)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES222	(IRC0.unIRQCES6.stcField.u1IRQCES222)  /*@bf@*/
#define IRC0_IRQCES6_IRQCES223	(IRC0.unIRQCES6.stcField.u1IRQCES223)  /*@bf@*/

typedef struct stc_irc0_irqces6_field{
    uint_io32_t		u1IRQCES192:1;
    uint_io32_t		u1IRQCES193:1;
    uint_io32_t		u1IRQCES194:1;
    uint_io32_t		u1IRQCES195:1;
    uint_io32_t		u1IRQCES196:1;
    uint_io32_t		u1IRQCES197:1;
    uint_io32_t		u1IRQCES198:1;
    uint_io32_t		u1IRQCES199:1;
    uint_io32_t		u1IRQCES200:1;
    uint_io32_t		u1IRQCES201:1;
    uint_io32_t		u1IRQCES202:1;
    uint_io32_t		u1IRQCES203:1;
    uint_io32_t		u1IRQCES204:1;
    uint_io32_t		u1IRQCES205:1;
    uint_io32_t		u1IRQCES206:1;
    uint_io32_t		u1IRQCES207:1;
    uint_io32_t		u1IRQCES208:1;
    uint_io32_t		u1IRQCES209:1;
    uint_io32_t		u1IRQCES210:1;
    uint_io32_t		u1IRQCES211:1;
    uint_io32_t		u1IRQCES212:1;
    uint_io32_t		u1IRQCES213:1;
    uint_io32_t		u1IRQCES214:1;
    uint_io32_t		u1IRQCES215:1;
    uint_io32_t		u1IRQCES216:1;
    uint_io32_t		u1IRQCES217:1;
    uint_io32_t		u1IRQCES218:1;
    uint_io32_t		u1IRQCES219:1;
    uint_io32_t		u1IRQCES220:1;
    uint_io32_t		u1IRQCES221:1;
    uint_io32_t		u1IRQCES222:1;
    uint_io32_t		u1IRQCES223:1;
}stc_irc0_irqces6_field_t;

typedef union un_irc0_irqces6{
    uint_io32_t		u32Register;
    stc_irc0_irqces6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces6_t;

/* IRQCES7 */
#define IRC0_IRQCES7	(IRC0.unIRQCES7.u32Register)  /*@rg@*/
#define IRC0_IRQCES7_IRQCES224	(IRC0.unIRQCES7.stcField.u1IRQCES224)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES225	(IRC0.unIRQCES7.stcField.u1IRQCES225)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES226	(IRC0.unIRQCES7.stcField.u1IRQCES226)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES227	(IRC0.unIRQCES7.stcField.u1IRQCES227)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES228	(IRC0.unIRQCES7.stcField.u1IRQCES228)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES229	(IRC0.unIRQCES7.stcField.u1IRQCES229)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES230	(IRC0.unIRQCES7.stcField.u1IRQCES230)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES231	(IRC0.unIRQCES7.stcField.u1IRQCES231)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES232	(IRC0.unIRQCES7.stcField.u1IRQCES232)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES233	(IRC0.unIRQCES7.stcField.u1IRQCES233)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES234	(IRC0.unIRQCES7.stcField.u1IRQCES234)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES235	(IRC0.unIRQCES7.stcField.u1IRQCES235)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES236	(IRC0.unIRQCES7.stcField.u1IRQCES236)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES237	(IRC0.unIRQCES7.stcField.u1IRQCES237)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES238	(IRC0.unIRQCES7.stcField.u1IRQCES238)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES239	(IRC0.unIRQCES7.stcField.u1IRQCES239)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES240	(IRC0.unIRQCES7.stcField.u1IRQCES240)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES241	(IRC0.unIRQCES7.stcField.u1IRQCES241)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES242	(IRC0.unIRQCES7.stcField.u1IRQCES242)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES243	(IRC0.unIRQCES7.stcField.u1IRQCES243)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES244	(IRC0.unIRQCES7.stcField.u1IRQCES244)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES245	(IRC0.unIRQCES7.stcField.u1IRQCES245)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES246	(IRC0.unIRQCES7.stcField.u1IRQCES246)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES247	(IRC0.unIRQCES7.stcField.u1IRQCES247)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES248	(IRC0.unIRQCES7.stcField.u1IRQCES248)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES249	(IRC0.unIRQCES7.stcField.u1IRQCES249)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES250	(IRC0.unIRQCES7.stcField.u1IRQCES250)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES251	(IRC0.unIRQCES7.stcField.u1IRQCES251)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES252	(IRC0.unIRQCES7.stcField.u1IRQCES252)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES253	(IRC0.unIRQCES7.stcField.u1IRQCES253)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES254	(IRC0.unIRQCES7.stcField.u1IRQCES254)  /*@bf@*/
#define IRC0_IRQCES7_IRQCES255	(IRC0.unIRQCES7.stcField.u1IRQCES255)  /*@bf@*/

typedef struct stc_irc0_irqces7_field{
    uint_io32_t		u1IRQCES224:1;
    uint_io32_t		u1IRQCES225:1;
    uint_io32_t		u1IRQCES226:1;
    uint_io32_t		u1IRQCES227:1;
    uint_io32_t		u1IRQCES228:1;
    uint_io32_t		u1IRQCES229:1;
    uint_io32_t		u1IRQCES230:1;
    uint_io32_t		u1IRQCES231:1;
    uint_io32_t		u1IRQCES232:1;
    uint_io32_t		u1IRQCES233:1;
    uint_io32_t		u1IRQCES234:1;
    uint_io32_t		u1IRQCES235:1;
    uint_io32_t		u1IRQCES236:1;
    uint_io32_t		u1IRQCES237:1;
    uint_io32_t		u1IRQCES238:1;
    uint_io32_t		u1IRQCES239:1;
    uint_io32_t		u1IRQCES240:1;
    uint_io32_t		u1IRQCES241:1;
    uint_io32_t		u1IRQCES242:1;
    uint_io32_t		u1IRQCES243:1;
    uint_io32_t		u1IRQCES244:1;
    uint_io32_t		u1IRQCES245:1;
    uint_io32_t		u1IRQCES246:1;
    uint_io32_t		u1IRQCES247:1;
    uint_io32_t		u1IRQCES248:1;
    uint_io32_t		u1IRQCES249:1;
    uint_io32_t		u1IRQCES250:1;
    uint_io32_t		u1IRQCES251:1;
    uint_io32_t		u1IRQCES252:1;
    uint_io32_t		u1IRQCES253:1;
    uint_io32_t		u1IRQCES254:1;
    uint_io32_t		u1IRQCES255:1;
}stc_irc0_irqces7_field_t;

typedef union un_irc0_irqces7{
    uint_io32_t		u32Register;
    stc_irc0_irqces7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces7_t;

/* IRQCES8 */
#define IRC0_IRQCES8	(IRC0.unIRQCES8.u32Register)  /*@rg@*/
#define IRC0_IRQCES8_IRQCES256	(IRC0.unIRQCES8.stcField.u1IRQCES256)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES257	(IRC0.unIRQCES8.stcField.u1IRQCES257)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES258	(IRC0.unIRQCES8.stcField.u1IRQCES258)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES259	(IRC0.unIRQCES8.stcField.u1IRQCES259)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES260	(IRC0.unIRQCES8.stcField.u1IRQCES260)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES261	(IRC0.unIRQCES8.stcField.u1IRQCES261)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES262	(IRC0.unIRQCES8.stcField.u1IRQCES262)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES263	(IRC0.unIRQCES8.stcField.u1IRQCES263)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES264	(IRC0.unIRQCES8.stcField.u1IRQCES264)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES265	(IRC0.unIRQCES8.stcField.u1IRQCES265)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES266	(IRC0.unIRQCES8.stcField.u1IRQCES266)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES267	(IRC0.unIRQCES8.stcField.u1IRQCES267)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES268	(IRC0.unIRQCES8.stcField.u1IRQCES268)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES269	(IRC0.unIRQCES8.stcField.u1IRQCES269)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES270	(IRC0.unIRQCES8.stcField.u1IRQCES270)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES271	(IRC0.unIRQCES8.stcField.u1IRQCES271)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES272	(IRC0.unIRQCES8.stcField.u1IRQCES272)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES273	(IRC0.unIRQCES8.stcField.u1IRQCES273)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES274	(IRC0.unIRQCES8.stcField.u1IRQCES274)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES275	(IRC0.unIRQCES8.stcField.u1IRQCES275)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES276	(IRC0.unIRQCES8.stcField.u1IRQCES276)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES277	(IRC0.unIRQCES8.stcField.u1IRQCES277)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES278	(IRC0.unIRQCES8.stcField.u1IRQCES278)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES279	(IRC0.unIRQCES8.stcField.u1IRQCES279)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES280	(IRC0.unIRQCES8.stcField.u1IRQCES280)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES281	(IRC0.unIRQCES8.stcField.u1IRQCES281)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES282	(IRC0.unIRQCES8.stcField.u1IRQCES282)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES283	(IRC0.unIRQCES8.stcField.u1IRQCES283)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES284	(IRC0.unIRQCES8.stcField.u1IRQCES284)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES285	(IRC0.unIRQCES8.stcField.u1IRQCES285)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES286	(IRC0.unIRQCES8.stcField.u1IRQCES286)  /*@bf@*/
#define IRC0_IRQCES8_IRQCES287	(IRC0.unIRQCES8.stcField.u1IRQCES287)  /*@bf@*/

typedef struct stc_irc0_irqces8_field{
    uint_io32_t		u1IRQCES256:1;
    uint_io32_t		u1IRQCES257:1;
    uint_io32_t		u1IRQCES258:1;
    uint_io32_t		u1IRQCES259:1;
    uint_io32_t		u1IRQCES260:1;
    uint_io32_t		u1IRQCES261:1;
    uint_io32_t		u1IRQCES262:1;
    uint_io32_t		u1IRQCES263:1;
    uint_io32_t		u1IRQCES264:1;
    uint_io32_t		u1IRQCES265:1;
    uint_io32_t		u1IRQCES266:1;
    uint_io32_t		u1IRQCES267:1;
    uint_io32_t		u1IRQCES268:1;
    uint_io32_t		u1IRQCES269:1;
    uint_io32_t		u1IRQCES270:1;
    uint_io32_t		u1IRQCES271:1;
    uint_io32_t		u1IRQCES272:1;
    uint_io32_t		u1IRQCES273:1;
    uint_io32_t		u1IRQCES274:1;
    uint_io32_t		u1IRQCES275:1;
    uint_io32_t		u1IRQCES276:1;
    uint_io32_t		u1IRQCES277:1;
    uint_io32_t		u1IRQCES278:1;
    uint_io32_t		u1IRQCES279:1;
    uint_io32_t		u1IRQCES280:1;
    uint_io32_t		u1IRQCES281:1;
    uint_io32_t		u1IRQCES282:1;
    uint_io32_t		u1IRQCES283:1;
    uint_io32_t		u1IRQCES284:1;
    uint_io32_t		u1IRQCES285:1;
    uint_io32_t		u1IRQCES286:1;
    uint_io32_t		u1IRQCES287:1;
}stc_irc0_irqces8_field_t;

typedef union un_irc0_irqces8{
    uint_io32_t		u32Register;
    stc_irc0_irqces8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces8_t;

/* IRQCES9 */
#define IRC0_IRQCES9	(IRC0.unIRQCES9.u32Register)  /*@rg@*/
#define IRC0_IRQCES9_IRQCES288	(IRC0.unIRQCES9.stcField.u1IRQCES288)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES289	(IRC0.unIRQCES9.stcField.u1IRQCES289)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES290	(IRC0.unIRQCES9.stcField.u1IRQCES290)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES291	(IRC0.unIRQCES9.stcField.u1IRQCES291)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES292	(IRC0.unIRQCES9.stcField.u1IRQCES292)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES293	(IRC0.unIRQCES9.stcField.u1IRQCES293)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES294	(IRC0.unIRQCES9.stcField.u1IRQCES294)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES295	(IRC0.unIRQCES9.stcField.u1IRQCES295)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES296	(IRC0.unIRQCES9.stcField.u1IRQCES296)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES297	(IRC0.unIRQCES9.stcField.u1IRQCES297)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES298	(IRC0.unIRQCES9.stcField.u1IRQCES298)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES299	(IRC0.unIRQCES9.stcField.u1IRQCES299)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES300	(IRC0.unIRQCES9.stcField.u1IRQCES300)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES301	(IRC0.unIRQCES9.stcField.u1IRQCES301)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES302	(IRC0.unIRQCES9.stcField.u1IRQCES302)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES303	(IRC0.unIRQCES9.stcField.u1IRQCES303)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES304	(IRC0.unIRQCES9.stcField.u1IRQCES304)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES305	(IRC0.unIRQCES9.stcField.u1IRQCES305)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES306	(IRC0.unIRQCES9.stcField.u1IRQCES306)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES307	(IRC0.unIRQCES9.stcField.u1IRQCES307)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES308	(IRC0.unIRQCES9.stcField.u1IRQCES308)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES309	(IRC0.unIRQCES9.stcField.u1IRQCES309)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES310	(IRC0.unIRQCES9.stcField.u1IRQCES310)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES311	(IRC0.unIRQCES9.stcField.u1IRQCES311)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES312	(IRC0.unIRQCES9.stcField.u1IRQCES312)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES313	(IRC0.unIRQCES9.stcField.u1IRQCES313)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES314	(IRC0.unIRQCES9.stcField.u1IRQCES314)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES315	(IRC0.unIRQCES9.stcField.u1IRQCES315)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES316	(IRC0.unIRQCES9.stcField.u1IRQCES316)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES317	(IRC0.unIRQCES9.stcField.u1IRQCES317)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES318	(IRC0.unIRQCES9.stcField.u1IRQCES318)  /*@bf@*/
#define IRC0_IRQCES9_IRQCES319	(IRC0.unIRQCES9.stcField.u1IRQCES319)  /*@bf@*/

typedef struct stc_irc0_irqces9_field{
    uint_io32_t		u1IRQCES288:1;
    uint_io32_t		u1IRQCES289:1;
    uint_io32_t		u1IRQCES290:1;
    uint_io32_t		u1IRQCES291:1;
    uint_io32_t		u1IRQCES292:1;
    uint_io32_t		u1IRQCES293:1;
    uint_io32_t		u1IRQCES294:1;
    uint_io32_t		u1IRQCES295:1;
    uint_io32_t		u1IRQCES296:1;
    uint_io32_t		u1IRQCES297:1;
    uint_io32_t		u1IRQCES298:1;
    uint_io32_t		u1IRQCES299:1;
    uint_io32_t		u1IRQCES300:1;
    uint_io32_t		u1IRQCES301:1;
    uint_io32_t		u1IRQCES302:1;
    uint_io32_t		u1IRQCES303:1;
    uint_io32_t		u1IRQCES304:1;
    uint_io32_t		u1IRQCES305:1;
    uint_io32_t		u1IRQCES306:1;
    uint_io32_t		u1IRQCES307:1;
    uint_io32_t		u1IRQCES308:1;
    uint_io32_t		u1IRQCES309:1;
    uint_io32_t		u1IRQCES310:1;
    uint_io32_t		u1IRQCES311:1;
    uint_io32_t		u1IRQCES312:1;
    uint_io32_t		u1IRQCES313:1;
    uint_io32_t		u1IRQCES314:1;
    uint_io32_t		u1IRQCES315:1;
    uint_io32_t		u1IRQCES316:1;
    uint_io32_t		u1IRQCES317:1;
    uint_io32_t		u1IRQCES318:1;
    uint_io32_t		u1IRQCES319:1;
}stc_irc0_irqces9_field_t;

typedef union un_irc0_irqces9{
    uint_io32_t		u32Register;
    stc_irc0_irqces9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces9_t;

/* IRQCES10 */
#define IRC0_IRQCES10	(IRC0.unIRQCES10.u32Register)  /*@rg@*/
#define IRC0_IRQCES10_IRQCES320	(IRC0.unIRQCES10.stcField.u1IRQCES320)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES321	(IRC0.unIRQCES10.stcField.u1IRQCES321)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES322	(IRC0.unIRQCES10.stcField.u1IRQCES322)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES323	(IRC0.unIRQCES10.stcField.u1IRQCES323)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES324	(IRC0.unIRQCES10.stcField.u1IRQCES324)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES325	(IRC0.unIRQCES10.stcField.u1IRQCES325)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES326	(IRC0.unIRQCES10.stcField.u1IRQCES326)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES327	(IRC0.unIRQCES10.stcField.u1IRQCES327)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES328	(IRC0.unIRQCES10.stcField.u1IRQCES328)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES329	(IRC0.unIRQCES10.stcField.u1IRQCES329)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES330	(IRC0.unIRQCES10.stcField.u1IRQCES330)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES331	(IRC0.unIRQCES10.stcField.u1IRQCES331)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES332	(IRC0.unIRQCES10.stcField.u1IRQCES332)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES333	(IRC0.unIRQCES10.stcField.u1IRQCES333)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES334	(IRC0.unIRQCES10.stcField.u1IRQCES334)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES335	(IRC0.unIRQCES10.stcField.u1IRQCES335)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES336	(IRC0.unIRQCES10.stcField.u1IRQCES336)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES337	(IRC0.unIRQCES10.stcField.u1IRQCES337)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES338	(IRC0.unIRQCES10.stcField.u1IRQCES338)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES339	(IRC0.unIRQCES10.stcField.u1IRQCES339)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES340	(IRC0.unIRQCES10.stcField.u1IRQCES340)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES341	(IRC0.unIRQCES10.stcField.u1IRQCES341)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES342	(IRC0.unIRQCES10.stcField.u1IRQCES342)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES343	(IRC0.unIRQCES10.stcField.u1IRQCES343)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES344	(IRC0.unIRQCES10.stcField.u1IRQCES344)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES345	(IRC0.unIRQCES10.stcField.u1IRQCES345)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES346	(IRC0.unIRQCES10.stcField.u1IRQCES346)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES347	(IRC0.unIRQCES10.stcField.u1IRQCES347)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES348	(IRC0.unIRQCES10.stcField.u1IRQCES348)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES349	(IRC0.unIRQCES10.stcField.u1IRQCES349)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES350	(IRC0.unIRQCES10.stcField.u1IRQCES350)  /*@bf@*/
#define IRC0_IRQCES10_IRQCES351	(IRC0.unIRQCES10.stcField.u1IRQCES351)  /*@bf@*/

typedef struct stc_irc0_irqces10_field{
    uint_io32_t		u1IRQCES320:1;
    uint_io32_t		u1IRQCES321:1;
    uint_io32_t		u1IRQCES322:1;
    uint_io32_t		u1IRQCES323:1;
    uint_io32_t		u1IRQCES324:1;
    uint_io32_t		u1IRQCES325:1;
    uint_io32_t		u1IRQCES326:1;
    uint_io32_t		u1IRQCES327:1;
    uint_io32_t		u1IRQCES328:1;
    uint_io32_t		u1IRQCES329:1;
    uint_io32_t		u1IRQCES330:1;
    uint_io32_t		u1IRQCES331:1;
    uint_io32_t		u1IRQCES332:1;
    uint_io32_t		u1IRQCES333:1;
    uint_io32_t		u1IRQCES334:1;
    uint_io32_t		u1IRQCES335:1;
    uint_io32_t		u1IRQCES336:1;
    uint_io32_t		u1IRQCES337:1;
    uint_io32_t		u1IRQCES338:1;
    uint_io32_t		u1IRQCES339:1;
    uint_io32_t		u1IRQCES340:1;
    uint_io32_t		u1IRQCES341:1;
    uint_io32_t		u1IRQCES342:1;
    uint_io32_t		u1IRQCES343:1;
    uint_io32_t		u1IRQCES344:1;
    uint_io32_t		u1IRQCES345:1;
    uint_io32_t		u1IRQCES346:1;
    uint_io32_t		u1IRQCES347:1;
    uint_io32_t		u1IRQCES348:1;
    uint_io32_t		u1IRQCES349:1;
    uint_io32_t		u1IRQCES350:1;
    uint_io32_t		u1IRQCES351:1;
}stc_irc0_irqces10_field_t;

typedef union un_irc0_irqces10{
    uint_io32_t		u32Register;
    stc_irc0_irqces10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces10_t;

/* IRQCES11 */
#define IRC0_IRQCES11	(IRC0.unIRQCES11.u32Register)  /*@rg@*/
#define IRC0_IRQCES11_IRQCES352	(IRC0.unIRQCES11.stcField.u1IRQCES352)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES353	(IRC0.unIRQCES11.stcField.u1IRQCES353)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES354	(IRC0.unIRQCES11.stcField.u1IRQCES354)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES355	(IRC0.unIRQCES11.stcField.u1IRQCES355)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES356	(IRC0.unIRQCES11.stcField.u1IRQCES356)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES357	(IRC0.unIRQCES11.stcField.u1IRQCES357)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES358	(IRC0.unIRQCES11.stcField.u1IRQCES358)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES359	(IRC0.unIRQCES11.stcField.u1IRQCES359)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES360	(IRC0.unIRQCES11.stcField.u1IRQCES360)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES361	(IRC0.unIRQCES11.stcField.u1IRQCES361)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES362	(IRC0.unIRQCES11.stcField.u1IRQCES362)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES363	(IRC0.unIRQCES11.stcField.u1IRQCES363)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES364	(IRC0.unIRQCES11.stcField.u1IRQCES364)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES365	(IRC0.unIRQCES11.stcField.u1IRQCES365)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES366	(IRC0.unIRQCES11.stcField.u1IRQCES366)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES367	(IRC0.unIRQCES11.stcField.u1IRQCES367)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES368	(IRC0.unIRQCES11.stcField.u1IRQCES368)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES369	(IRC0.unIRQCES11.stcField.u1IRQCES369)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES370	(IRC0.unIRQCES11.stcField.u1IRQCES370)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES371	(IRC0.unIRQCES11.stcField.u1IRQCES371)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES372	(IRC0.unIRQCES11.stcField.u1IRQCES372)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES373	(IRC0.unIRQCES11.stcField.u1IRQCES373)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES374	(IRC0.unIRQCES11.stcField.u1IRQCES374)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES375	(IRC0.unIRQCES11.stcField.u1IRQCES375)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES376	(IRC0.unIRQCES11.stcField.u1IRQCES376)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES377	(IRC0.unIRQCES11.stcField.u1IRQCES377)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES378	(IRC0.unIRQCES11.stcField.u1IRQCES378)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES379	(IRC0.unIRQCES11.stcField.u1IRQCES379)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES380	(IRC0.unIRQCES11.stcField.u1IRQCES380)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES381	(IRC0.unIRQCES11.stcField.u1IRQCES381)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES382	(IRC0.unIRQCES11.stcField.u1IRQCES382)  /*@bf@*/
#define IRC0_IRQCES11_IRQCES383	(IRC0.unIRQCES11.stcField.u1IRQCES383)  /*@bf@*/

typedef struct stc_irc0_irqces11_field{
    uint_io32_t		u1IRQCES352:1;
    uint_io32_t		u1IRQCES353:1;
    uint_io32_t		u1IRQCES354:1;
    uint_io32_t		u1IRQCES355:1;
    uint_io32_t		u1IRQCES356:1;
    uint_io32_t		u1IRQCES357:1;
    uint_io32_t		u1IRQCES358:1;
    uint_io32_t		u1IRQCES359:1;
    uint_io32_t		u1IRQCES360:1;
    uint_io32_t		u1IRQCES361:1;
    uint_io32_t		u1IRQCES362:1;
    uint_io32_t		u1IRQCES363:1;
    uint_io32_t		u1IRQCES364:1;
    uint_io32_t		u1IRQCES365:1;
    uint_io32_t		u1IRQCES366:1;
    uint_io32_t		u1IRQCES367:1;
    uint_io32_t		u1IRQCES368:1;
    uint_io32_t		u1IRQCES369:1;
    uint_io32_t		u1IRQCES370:1;
    uint_io32_t		u1IRQCES371:1;
    uint_io32_t		u1IRQCES372:1;
    uint_io32_t		u1IRQCES373:1;
    uint_io32_t		u1IRQCES374:1;
    uint_io32_t		u1IRQCES375:1;
    uint_io32_t		u1IRQCES376:1;
    uint_io32_t		u1IRQCES377:1;
    uint_io32_t		u1IRQCES378:1;
    uint_io32_t		u1IRQCES379:1;
    uint_io32_t		u1IRQCES380:1;
    uint_io32_t		u1IRQCES381:1;
    uint_io32_t		u1IRQCES382:1;
    uint_io32_t		u1IRQCES383:1;
}stc_irc0_irqces11_field_t;

typedef union un_irc0_irqces11{
    uint_io32_t		u32Register;
    stc_irc0_irqces11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces11_t;

/* IRQCES12 */
#define IRC0_IRQCES12	(IRC0.unIRQCES12.u32Register)  /*@rg@*/
#define IRC0_IRQCES12_IRQCES384	(IRC0.unIRQCES12.stcField.u1IRQCES384)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES385	(IRC0.unIRQCES12.stcField.u1IRQCES385)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES386	(IRC0.unIRQCES12.stcField.u1IRQCES386)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES387	(IRC0.unIRQCES12.stcField.u1IRQCES387)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES388	(IRC0.unIRQCES12.stcField.u1IRQCES388)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES389	(IRC0.unIRQCES12.stcField.u1IRQCES389)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES390	(IRC0.unIRQCES12.stcField.u1IRQCES390)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES391	(IRC0.unIRQCES12.stcField.u1IRQCES391)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES392	(IRC0.unIRQCES12.stcField.u1IRQCES392)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES393	(IRC0.unIRQCES12.stcField.u1IRQCES393)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES394	(IRC0.unIRQCES12.stcField.u1IRQCES394)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES395	(IRC0.unIRQCES12.stcField.u1IRQCES395)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES396	(IRC0.unIRQCES12.stcField.u1IRQCES396)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES397	(IRC0.unIRQCES12.stcField.u1IRQCES397)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES398	(IRC0.unIRQCES12.stcField.u1IRQCES398)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES399	(IRC0.unIRQCES12.stcField.u1IRQCES399)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES400	(IRC0.unIRQCES12.stcField.u1IRQCES400)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES401	(IRC0.unIRQCES12.stcField.u1IRQCES401)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES402	(IRC0.unIRQCES12.stcField.u1IRQCES402)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES403	(IRC0.unIRQCES12.stcField.u1IRQCES403)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES404	(IRC0.unIRQCES12.stcField.u1IRQCES404)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES405	(IRC0.unIRQCES12.stcField.u1IRQCES405)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES406	(IRC0.unIRQCES12.stcField.u1IRQCES406)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES407	(IRC0.unIRQCES12.stcField.u1IRQCES407)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES408	(IRC0.unIRQCES12.stcField.u1IRQCES408)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES409	(IRC0.unIRQCES12.stcField.u1IRQCES409)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES410	(IRC0.unIRQCES12.stcField.u1IRQCES410)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES411	(IRC0.unIRQCES12.stcField.u1IRQCES411)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES412	(IRC0.unIRQCES12.stcField.u1IRQCES412)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES413	(IRC0.unIRQCES12.stcField.u1IRQCES413)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES414	(IRC0.unIRQCES12.stcField.u1IRQCES414)  /*@bf@*/
#define IRC0_IRQCES12_IRQCES415	(IRC0.unIRQCES12.stcField.u1IRQCES415)  /*@bf@*/

typedef struct stc_irc0_irqces12_field{
    uint_io32_t		u1IRQCES384:1;
    uint_io32_t		u1IRQCES385:1;
    uint_io32_t		u1IRQCES386:1;
    uint_io32_t		u1IRQCES387:1;
    uint_io32_t		u1IRQCES388:1;
    uint_io32_t		u1IRQCES389:1;
    uint_io32_t		u1IRQCES390:1;
    uint_io32_t		u1IRQCES391:1;
    uint_io32_t		u1IRQCES392:1;
    uint_io32_t		u1IRQCES393:1;
    uint_io32_t		u1IRQCES394:1;
    uint_io32_t		u1IRQCES395:1;
    uint_io32_t		u1IRQCES396:1;
    uint_io32_t		u1IRQCES397:1;
    uint_io32_t		u1IRQCES398:1;
    uint_io32_t		u1IRQCES399:1;
    uint_io32_t		u1IRQCES400:1;
    uint_io32_t		u1IRQCES401:1;
    uint_io32_t		u1IRQCES402:1;
    uint_io32_t		u1IRQCES403:1;
    uint_io32_t		u1IRQCES404:1;
    uint_io32_t		u1IRQCES405:1;
    uint_io32_t		u1IRQCES406:1;
    uint_io32_t		u1IRQCES407:1;
    uint_io32_t		u1IRQCES408:1;
    uint_io32_t		u1IRQCES409:1;
    uint_io32_t		u1IRQCES410:1;
    uint_io32_t		u1IRQCES411:1;
    uint_io32_t		u1IRQCES412:1;
    uint_io32_t		u1IRQCES413:1;
    uint_io32_t		u1IRQCES414:1;
    uint_io32_t		u1IRQCES415:1;
}stc_irc0_irqces12_field_t;

typedef union un_irc0_irqces12{
    uint_io32_t		u32Register;
    stc_irc0_irqces12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces12_t;

/* IRQCES13 */
#define IRC0_IRQCES13	(IRC0.unIRQCES13.u32Register)  /*@rg@*/
#define IRC0_IRQCES13_IRQCES416	(IRC0.unIRQCES13.stcField.u1IRQCES416)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES417	(IRC0.unIRQCES13.stcField.u1IRQCES417)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES418	(IRC0.unIRQCES13.stcField.u1IRQCES418)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES419	(IRC0.unIRQCES13.stcField.u1IRQCES419)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES420	(IRC0.unIRQCES13.stcField.u1IRQCES420)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES421	(IRC0.unIRQCES13.stcField.u1IRQCES421)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES422	(IRC0.unIRQCES13.stcField.u1IRQCES422)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES423	(IRC0.unIRQCES13.stcField.u1IRQCES423)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES424	(IRC0.unIRQCES13.stcField.u1IRQCES424)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES425	(IRC0.unIRQCES13.stcField.u1IRQCES425)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES426	(IRC0.unIRQCES13.stcField.u1IRQCES426)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES427	(IRC0.unIRQCES13.stcField.u1IRQCES427)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES428	(IRC0.unIRQCES13.stcField.u1IRQCES428)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES429	(IRC0.unIRQCES13.stcField.u1IRQCES429)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES430	(IRC0.unIRQCES13.stcField.u1IRQCES430)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES431	(IRC0.unIRQCES13.stcField.u1IRQCES431)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES432	(IRC0.unIRQCES13.stcField.u1IRQCES432)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES433	(IRC0.unIRQCES13.stcField.u1IRQCES433)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES434	(IRC0.unIRQCES13.stcField.u1IRQCES434)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES435	(IRC0.unIRQCES13.stcField.u1IRQCES435)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES436	(IRC0.unIRQCES13.stcField.u1IRQCES436)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES437	(IRC0.unIRQCES13.stcField.u1IRQCES437)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES438	(IRC0.unIRQCES13.stcField.u1IRQCES438)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES439	(IRC0.unIRQCES13.stcField.u1IRQCES439)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES440	(IRC0.unIRQCES13.stcField.u1IRQCES440)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES441	(IRC0.unIRQCES13.stcField.u1IRQCES441)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES442	(IRC0.unIRQCES13.stcField.u1IRQCES442)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES443	(IRC0.unIRQCES13.stcField.u1IRQCES443)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES444	(IRC0.unIRQCES13.stcField.u1IRQCES444)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES445	(IRC0.unIRQCES13.stcField.u1IRQCES445)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES446	(IRC0.unIRQCES13.stcField.u1IRQCES446)  /*@bf@*/
#define IRC0_IRQCES13_IRQCES447	(IRC0.unIRQCES13.stcField.u1IRQCES447)  /*@bf@*/

typedef struct stc_irc0_irqces13_field{
    uint_io32_t		u1IRQCES416:1;
    uint_io32_t		u1IRQCES417:1;
    uint_io32_t		u1IRQCES418:1;
    uint_io32_t		u1IRQCES419:1;
    uint_io32_t		u1IRQCES420:1;
    uint_io32_t		u1IRQCES421:1;
    uint_io32_t		u1IRQCES422:1;
    uint_io32_t		u1IRQCES423:1;
    uint_io32_t		u1IRQCES424:1;
    uint_io32_t		u1IRQCES425:1;
    uint_io32_t		u1IRQCES426:1;
    uint_io32_t		u1IRQCES427:1;
    uint_io32_t		u1IRQCES428:1;
    uint_io32_t		u1IRQCES429:1;
    uint_io32_t		u1IRQCES430:1;
    uint_io32_t		u1IRQCES431:1;
    uint_io32_t		u1IRQCES432:1;
    uint_io32_t		u1IRQCES433:1;
    uint_io32_t		u1IRQCES434:1;
    uint_io32_t		u1IRQCES435:1;
    uint_io32_t		u1IRQCES436:1;
    uint_io32_t		u1IRQCES437:1;
    uint_io32_t		u1IRQCES438:1;
    uint_io32_t		u1IRQCES439:1;
    uint_io32_t		u1IRQCES440:1;
    uint_io32_t		u1IRQCES441:1;
    uint_io32_t		u1IRQCES442:1;
    uint_io32_t		u1IRQCES443:1;
    uint_io32_t		u1IRQCES444:1;
    uint_io32_t		u1IRQCES445:1;
    uint_io32_t		u1IRQCES446:1;
    uint_io32_t		u1IRQCES447:1;
}stc_irc0_irqces13_field_t;

typedef union un_irc0_irqces13{
    uint_io32_t		u32Register;
    stc_irc0_irqces13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces13_t;

/* IRQCES14 */
#define IRC0_IRQCES14	(IRC0.unIRQCES14.u32Register)  /*@rg@*/
#define IRC0_IRQCES14_IRQCES448	(IRC0.unIRQCES14.stcField.u1IRQCES448)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES449	(IRC0.unIRQCES14.stcField.u1IRQCES449)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES450	(IRC0.unIRQCES14.stcField.u1IRQCES450)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES451	(IRC0.unIRQCES14.stcField.u1IRQCES451)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES452	(IRC0.unIRQCES14.stcField.u1IRQCES452)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES453	(IRC0.unIRQCES14.stcField.u1IRQCES453)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES454	(IRC0.unIRQCES14.stcField.u1IRQCES454)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES455	(IRC0.unIRQCES14.stcField.u1IRQCES455)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES456	(IRC0.unIRQCES14.stcField.u1IRQCES456)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES457	(IRC0.unIRQCES14.stcField.u1IRQCES457)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES458	(IRC0.unIRQCES14.stcField.u1IRQCES458)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES459	(IRC0.unIRQCES14.stcField.u1IRQCES459)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES460	(IRC0.unIRQCES14.stcField.u1IRQCES460)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES461	(IRC0.unIRQCES14.stcField.u1IRQCES461)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES462	(IRC0.unIRQCES14.stcField.u1IRQCES462)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES463	(IRC0.unIRQCES14.stcField.u1IRQCES463)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES464	(IRC0.unIRQCES14.stcField.u1IRQCES464)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES465	(IRC0.unIRQCES14.stcField.u1IRQCES465)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES466	(IRC0.unIRQCES14.stcField.u1IRQCES466)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES467	(IRC0.unIRQCES14.stcField.u1IRQCES467)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES468	(IRC0.unIRQCES14.stcField.u1IRQCES468)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES469	(IRC0.unIRQCES14.stcField.u1IRQCES469)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES470	(IRC0.unIRQCES14.stcField.u1IRQCES470)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES471	(IRC0.unIRQCES14.stcField.u1IRQCES471)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES472	(IRC0.unIRQCES14.stcField.u1IRQCES472)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES473	(IRC0.unIRQCES14.stcField.u1IRQCES473)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES474	(IRC0.unIRQCES14.stcField.u1IRQCES474)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES475	(IRC0.unIRQCES14.stcField.u1IRQCES475)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES476	(IRC0.unIRQCES14.stcField.u1IRQCES476)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES477	(IRC0.unIRQCES14.stcField.u1IRQCES477)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES478	(IRC0.unIRQCES14.stcField.u1IRQCES478)  /*@bf@*/
#define IRC0_IRQCES14_IRQCES479	(IRC0.unIRQCES14.stcField.u1IRQCES479)  /*@bf@*/

typedef struct stc_irc0_irqces14_field{
    uint_io32_t		u1IRQCES448:1;
    uint_io32_t		u1IRQCES449:1;
    uint_io32_t		u1IRQCES450:1;
    uint_io32_t		u1IRQCES451:1;
    uint_io32_t		u1IRQCES452:1;
    uint_io32_t		u1IRQCES453:1;
    uint_io32_t		u1IRQCES454:1;
    uint_io32_t		u1IRQCES455:1;
    uint_io32_t		u1IRQCES456:1;
    uint_io32_t		u1IRQCES457:1;
    uint_io32_t		u1IRQCES458:1;
    uint_io32_t		u1IRQCES459:1;
    uint_io32_t		u1IRQCES460:1;
    uint_io32_t		u1IRQCES461:1;
    uint_io32_t		u1IRQCES462:1;
    uint_io32_t		u1IRQCES463:1;
    uint_io32_t		u1IRQCES464:1;
    uint_io32_t		u1IRQCES465:1;
    uint_io32_t		u1IRQCES466:1;
    uint_io32_t		u1IRQCES467:1;
    uint_io32_t		u1IRQCES468:1;
    uint_io32_t		u1IRQCES469:1;
    uint_io32_t		u1IRQCES470:1;
    uint_io32_t		u1IRQCES471:1;
    uint_io32_t		u1IRQCES472:1;
    uint_io32_t		u1IRQCES473:1;
    uint_io32_t		u1IRQCES474:1;
    uint_io32_t		u1IRQCES475:1;
    uint_io32_t		u1IRQCES476:1;
    uint_io32_t		u1IRQCES477:1;
    uint_io32_t		u1IRQCES478:1;
    uint_io32_t		u1IRQCES479:1;
}stc_irc0_irqces14_field_t;

typedef union un_irc0_irqces14{
    uint_io32_t		u32Register;
    stc_irc0_irqces14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces14_t;

/* IRQCES15 */
#define IRC0_IRQCES15	(IRC0.unIRQCES15.u32Register)  /*@rg@*/
#define IRC0_IRQCES15_IRQCES480	(IRC0.unIRQCES15.stcField.u1IRQCES480)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES481	(IRC0.unIRQCES15.stcField.u1IRQCES481)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES482	(IRC0.unIRQCES15.stcField.u1IRQCES482)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES483	(IRC0.unIRQCES15.stcField.u1IRQCES483)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES484	(IRC0.unIRQCES15.stcField.u1IRQCES484)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES485	(IRC0.unIRQCES15.stcField.u1IRQCES485)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES486	(IRC0.unIRQCES15.stcField.u1IRQCES486)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES487	(IRC0.unIRQCES15.stcField.u1IRQCES487)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES488	(IRC0.unIRQCES15.stcField.u1IRQCES488)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES489	(IRC0.unIRQCES15.stcField.u1IRQCES489)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES490	(IRC0.unIRQCES15.stcField.u1IRQCES490)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES491	(IRC0.unIRQCES15.stcField.u1IRQCES491)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES492	(IRC0.unIRQCES15.stcField.u1IRQCES492)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES493	(IRC0.unIRQCES15.stcField.u1IRQCES493)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES494	(IRC0.unIRQCES15.stcField.u1IRQCES494)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES495	(IRC0.unIRQCES15.stcField.u1IRQCES495)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES496	(IRC0.unIRQCES15.stcField.u1IRQCES496)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES497	(IRC0.unIRQCES15.stcField.u1IRQCES497)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES498	(IRC0.unIRQCES15.stcField.u1IRQCES498)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES499	(IRC0.unIRQCES15.stcField.u1IRQCES499)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES500	(IRC0.unIRQCES15.stcField.u1IRQCES500)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES501	(IRC0.unIRQCES15.stcField.u1IRQCES501)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES502	(IRC0.unIRQCES15.stcField.u1IRQCES502)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES503	(IRC0.unIRQCES15.stcField.u1IRQCES503)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES504	(IRC0.unIRQCES15.stcField.u1IRQCES504)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES505	(IRC0.unIRQCES15.stcField.u1IRQCES505)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES506	(IRC0.unIRQCES15.stcField.u1IRQCES506)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES507	(IRC0.unIRQCES15.stcField.u1IRQCES507)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES508	(IRC0.unIRQCES15.stcField.u1IRQCES508)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES509	(IRC0.unIRQCES15.stcField.u1IRQCES509)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES510	(IRC0.unIRQCES15.stcField.u1IRQCES510)  /*@bf@*/
#define IRC0_IRQCES15_IRQCES511	(IRC0.unIRQCES15.stcField.u1IRQCES511)  /*@bf@*/

typedef struct stc_irc0_irqces15_field{
    uint_io32_t		u1IRQCES480:1;
    uint_io32_t		u1IRQCES481:1;
    uint_io32_t		u1IRQCES482:1;
    uint_io32_t		u1IRQCES483:1;
    uint_io32_t		u1IRQCES484:1;
    uint_io32_t		u1IRQCES485:1;
    uint_io32_t		u1IRQCES486:1;
    uint_io32_t		u1IRQCES487:1;
    uint_io32_t		u1IRQCES488:1;
    uint_io32_t		u1IRQCES489:1;
    uint_io32_t		u1IRQCES490:1;
    uint_io32_t		u1IRQCES491:1;
    uint_io32_t		u1IRQCES492:1;
    uint_io32_t		u1IRQCES493:1;
    uint_io32_t		u1IRQCES494:1;
    uint_io32_t		u1IRQCES495:1;
    uint_io32_t		u1IRQCES496:1;
    uint_io32_t		u1IRQCES497:1;
    uint_io32_t		u1IRQCES498:1;
    uint_io32_t		u1IRQCES499:1;
    uint_io32_t		u1IRQCES500:1;
    uint_io32_t		u1IRQCES501:1;
    uint_io32_t		u1IRQCES502:1;
    uint_io32_t		u1IRQCES503:1;
    uint_io32_t		u1IRQCES504:1;
    uint_io32_t		u1IRQCES505:1;
    uint_io32_t		u1IRQCES506:1;
    uint_io32_t		u1IRQCES507:1;
    uint_io32_t		u1IRQCES508:1;
    uint_io32_t		u1IRQCES509:1;
    uint_io32_t		u1IRQCES510:1;
    uint_io32_t		u1IRQCES511:1;
}stc_irc0_irqces15_field_t;

typedef union un_irc0_irqces15{
    uint_io32_t		u32Register;
    stc_irc0_irqces15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqces15_t;

/* IRQCEC0 */
#define IRC0_IRQCEC0	(IRC0.unIRQCEC0.u32Register)  /*@rg@*/
#define IRC0_IRQCEC0_IRQCEC0	(IRC0.unIRQCEC0.stcField.u1IRQCEC0)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC1	(IRC0.unIRQCEC0.stcField.u1IRQCEC1)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC2	(IRC0.unIRQCEC0.stcField.u1IRQCEC2)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC3	(IRC0.unIRQCEC0.stcField.u1IRQCEC3)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC4	(IRC0.unIRQCEC0.stcField.u1IRQCEC4)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC5	(IRC0.unIRQCEC0.stcField.u1IRQCEC5)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC6	(IRC0.unIRQCEC0.stcField.u1IRQCEC6)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC7	(IRC0.unIRQCEC0.stcField.u1IRQCEC7)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC8	(IRC0.unIRQCEC0.stcField.u1IRQCEC8)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC9	(IRC0.unIRQCEC0.stcField.u1IRQCEC9)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC10	(IRC0.unIRQCEC0.stcField.u1IRQCEC10)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC11	(IRC0.unIRQCEC0.stcField.u1IRQCEC11)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC12	(IRC0.unIRQCEC0.stcField.u1IRQCEC12)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC13	(IRC0.unIRQCEC0.stcField.u1IRQCEC13)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC14	(IRC0.unIRQCEC0.stcField.u1IRQCEC14)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC15	(IRC0.unIRQCEC0.stcField.u1IRQCEC15)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC16	(IRC0.unIRQCEC0.stcField.u1IRQCEC16)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC17	(IRC0.unIRQCEC0.stcField.u1IRQCEC17)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC18	(IRC0.unIRQCEC0.stcField.u1IRQCEC18)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC19	(IRC0.unIRQCEC0.stcField.u1IRQCEC19)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC20	(IRC0.unIRQCEC0.stcField.u1IRQCEC20)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC21	(IRC0.unIRQCEC0.stcField.u1IRQCEC21)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC22	(IRC0.unIRQCEC0.stcField.u1IRQCEC22)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC23	(IRC0.unIRQCEC0.stcField.u1IRQCEC23)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC24	(IRC0.unIRQCEC0.stcField.u1IRQCEC24)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC25	(IRC0.unIRQCEC0.stcField.u1IRQCEC25)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC26	(IRC0.unIRQCEC0.stcField.u1IRQCEC26)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC27	(IRC0.unIRQCEC0.stcField.u1IRQCEC27)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC28	(IRC0.unIRQCEC0.stcField.u1IRQCEC28)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC29	(IRC0.unIRQCEC0.stcField.u1IRQCEC29)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC30	(IRC0.unIRQCEC0.stcField.u1IRQCEC30)  /*@bf@*/
#define IRC0_IRQCEC0_IRQCEC31	(IRC0.unIRQCEC0.stcField.u1IRQCEC31)  /*@bf@*/

typedef struct stc_irc0_irqcec0_field{
    uint_io32_t		u1IRQCEC0:1;
    uint_io32_t		u1IRQCEC1:1;
    uint_io32_t		u1IRQCEC2:1;
    uint_io32_t		u1IRQCEC3:1;
    uint_io32_t		u1IRQCEC4:1;
    uint_io32_t		u1IRQCEC5:1;
    uint_io32_t		u1IRQCEC6:1;
    uint_io32_t		u1IRQCEC7:1;
    uint_io32_t		u1IRQCEC8:1;
    uint_io32_t		u1IRQCEC9:1;
    uint_io32_t		u1IRQCEC10:1;
    uint_io32_t		u1IRQCEC11:1;
    uint_io32_t		u1IRQCEC12:1;
    uint_io32_t		u1IRQCEC13:1;
    uint_io32_t		u1IRQCEC14:1;
    uint_io32_t		u1IRQCEC15:1;
    uint_io32_t		u1IRQCEC16:1;
    uint_io32_t		u1IRQCEC17:1;
    uint_io32_t		u1IRQCEC18:1;
    uint_io32_t		u1IRQCEC19:1;
    uint_io32_t		u1IRQCEC20:1;
    uint_io32_t		u1IRQCEC21:1;
    uint_io32_t		u1IRQCEC22:1;
    uint_io32_t		u1IRQCEC23:1;
    uint_io32_t		u1IRQCEC24:1;
    uint_io32_t		u1IRQCEC25:1;
    uint_io32_t		u1IRQCEC26:1;
    uint_io32_t		u1IRQCEC27:1;
    uint_io32_t		u1IRQCEC28:1;
    uint_io32_t		u1IRQCEC29:1;
    uint_io32_t		u1IRQCEC30:1;
    uint_io32_t		u1IRQCEC31:1;
}stc_irc0_irqcec0_field_t;

typedef union un_irc0_irqcec0{
    uint_io32_t		u32Register;
    stc_irc0_irqcec0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec0_t;

/* IRQCEC1 */
#define IRC0_IRQCEC1	(IRC0.unIRQCEC1.u32Register)  /*@rg@*/
#define IRC0_IRQCEC1_IRQCEC32	(IRC0.unIRQCEC1.stcField.u1IRQCEC32)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC33	(IRC0.unIRQCEC1.stcField.u1IRQCEC33)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC34	(IRC0.unIRQCEC1.stcField.u1IRQCEC34)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC35	(IRC0.unIRQCEC1.stcField.u1IRQCEC35)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC36	(IRC0.unIRQCEC1.stcField.u1IRQCEC36)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC37	(IRC0.unIRQCEC1.stcField.u1IRQCEC37)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC38	(IRC0.unIRQCEC1.stcField.u1IRQCEC38)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC39	(IRC0.unIRQCEC1.stcField.u1IRQCEC39)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC40	(IRC0.unIRQCEC1.stcField.u1IRQCEC40)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC41	(IRC0.unIRQCEC1.stcField.u1IRQCEC41)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC42	(IRC0.unIRQCEC1.stcField.u1IRQCEC42)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC43	(IRC0.unIRQCEC1.stcField.u1IRQCEC43)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC44	(IRC0.unIRQCEC1.stcField.u1IRQCEC44)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC45	(IRC0.unIRQCEC1.stcField.u1IRQCEC45)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC46	(IRC0.unIRQCEC1.stcField.u1IRQCEC46)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC47	(IRC0.unIRQCEC1.stcField.u1IRQCEC47)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC48	(IRC0.unIRQCEC1.stcField.u1IRQCEC48)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC49	(IRC0.unIRQCEC1.stcField.u1IRQCEC49)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC50	(IRC0.unIRQCEC1.stcField.u1IRQCEC50)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC51	(IRC0.unIRQCEC1.stcField.u1IRQCEC51)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC52	(IRC0.unIRQCEC1.stcField.u1IRQCEC52)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC53	(IRC0.unIRQCEC1.stcField.u1IRQCEC53)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC54	(IRC0.unIRQCEC1.stcField.u1IRQCEC54)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC55	(IRC0.unIRQCEC1.stcField.u1IRQCEC55)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC56	(IRC0.unIRQCEC1.stcField.u1IRQCEC56)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC57	(IRC0.unIRQCEC1.stcField.u1IRQCEC57)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC58	(IRC0.unIRQCEC1.stcField.u1IRQCEC58)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC59	(IRC0.unIRQCEC1.stcField.u1IRQCEC59)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC60	(IRC0.unIRQCEC1.stcField.u1IRQCEC60)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC61	(IRC0.unIRQCEC1.stcField.u1IRQCEC61)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC62	(IRC0.unIRQCEC1.stcField.u1IRQCEC62)  /*@bf@*/
#define IRC0_IRQCEC1_IRQCEC63	(IRC0.unIRQCEC1.stcField.u1IRQCEC63)  /*@bf@*/

typedef struct stc_irc0_irqcec1_field{
    uint_io32_t		u1IRQCEC32:1;
    uint_io32_t		u1IRQCEC33:1;
    uint_io32_t		u1IRQCEC34:1;
    uint_io32_t		u1IRQCEC35:1;
    uint_io32_t		u1IRQCEC36:1;
    uint_io32_t		u1IRQCEC37:1;
    uint_io32_t		u1IRQCEC38:1;
    uint_io32_t		u1IRQCEC39:1;
    uint_io32_t		u1IRQCEC40:1;
    uint_io32_t		u1IRQCEC41:1;
    uint_io32_t		u1IRQCEC42:1;
    uint_io32_t		u1IRQCEC43:1;
    uint_io32_t		u1IRQCEC44:1;
    uint_io32_t		u1IRQCEC45:1;
    uint_io32_t		u1IRQCEC46:1;
    uint_io32_t		u1IRQCEC47:1;
    uint_io32_t		u1IRQCEC48:1;
    uint_io32_t		u1IRQCEC49:1;
    uint_io32_t		u1IRQCEC50:1;
    uint_io32_t		u1IRQCEC51:1;
    uint_io32_t		u1IRQCEC52:1;
    uint_io32_t		u1IRQCEC53:1;
    uint_io32_t		u1IRQCEC54:1;
    uint_io32_t		u1IRQCEC55:1;
    uint_io32_t		u1IRQCEC56:1;
    uint_io32_t		u1IRQCEC57:1;
    uint_io32_t		u1IRQCEC58:1;
    uint_io32_t		u1IRQCEC59:1;
    uint_io32_t		u1IRQCEC60:1;
    uint_io32_t		u1IRQCEC61:1;
    uint_io32_t		u1IRQCEC62:1;
    uint_io32_t		u1IRQCEC63:1;
}stc_irc0_irqcec1_field_t;

typedef union un_irc0_irqcec1{
    uint_io32_t		u32Register;
    stc_irc0_irqcec1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec1_t;

/* IRQCEC2 */
#define IRC0_IRQCEC2	(IRC0.unIRQCEC2.u32Register)  /*@rg@*/
#define IRC0_IRQCEC2_IRQCEC64	(IRC0.unIRQCEC2.stcField.u1IRQCEC64)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC65	(IRC0.unIRQCEC2.stcField.u1IRQCEC65)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC66	(IRC0.unIRQCEC2.stcField.u1IRQCEC66)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC67	(IRC0.unIRQCEC2.stcField.u1IRQCEC67)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC68	(IRC0.unIRQCEC2.stcField.u1IRQCEC68)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC69	(IRC0.unIRQCEC2.stcField.u1IRQCEC69)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC70	(IRC0.unIRQCEC2.stcField.u1IRQCEC70)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC71	(IRC0.unIRQCEC2.stcField.u1IRQCEC71)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC72	(IRC0.unIRQCEC2.stcField.u1IRQCEC72)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC73	(IRC0.unIRQCEC2.stcField.u1IRQCEC73)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC74	(IRC0.unIRQCEC2.stcField.u1IRQCEC74)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC75	(IRC0.unIRQCEC2.stcField.u1IRQCEC75)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC76	(IRC0.unIRQCEC2.stcField.u1IRQCEC76)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC77	(IRC0.unIRQCEC2.stcField.u1IRQCEC77)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC78	(IRC0.unIRQCEC2.stcField.u1IRQCEC78)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC79	(IRC0.unIRQCEC2.stcField.u1IRQCEC79)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC80	(IRC0.unIRQCEC2.stcField.u1IRQCEC80)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC81	(IRC0.unIRQCEC2.stcField.u1IRQCEC81)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC82	(IRC0.unIRQCEC2.stcField.u1IRQCEC82)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC83	(IRC0.unIRQCEC2.stcField.u1IRQCEC83)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC84	(IRC0.unIRQCEC2.stcField.u1IRQCEC84)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC85	(IRC0.unIRQCEC2.stcField.u1IRQCEC85)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC86	(IRC0.unIRQCEC2.stcField.u1IRQCEC86)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC87	(IRC0.unIRQCEC2.stcField.u1IRQCEC87)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC88	(IRC0.unIRQCEC2.stcField.u1IRQCEC88)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC89	(IRC0.unIRQCEC2.stcField.u1IRQCEC89)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC90	(IRC0.unIRQCEC2.stcField.u1IRQCEC90)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC91	(IRC0.unIRQCEC2.stcField.u1IRQCEC91)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC92	(IRC0.unIRQCEC2.stcField.u1IRQCEC92)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC93	(IRC0.unIRQCEC2.stcField.u1IRQCEC93)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC94	(IRC0.unIRQCEC2.stcField.u1IRQCEC94)  /*@bf@*/
#define IRC0_IRQCEC2_IRQCEC95	(IRC0.unIRQCEC2.stcField.u1IRQCEC95)  /*@bf@*/

typedef struct stc_irc0_irqcec2_field{
    uint_io32_t		u1IRQCEC64:1;
    uint_io32_t		u1IRQCEC65:1;
    uint_io32_t		u1IRQCEC66:1;
    uint_io32_t		u1IRQCEC67:1;
    uint_io32_t		u1IRQCEC68:1;
    uint_io32_t		u1IRQCEC69:1;
    uint_io32_t		u1IRQCEC70:1;
    uint_io32_t		u1IRQCEC71:1;
    uint_io32_t		u1IRQCEC72:1;
    uint_io32_t		u1IRQCEC73:1;
    uint_io32_t		u1IRQCEC74:1;
    uint_io32_t		u1IRQCEC75:1;
    uint_io32_t		u1IRQCEC76:1;
    uint_io32_t		u1IRQCEC77:1;
    uint_io32_t		u1IRQCEC78:1;
    uint_io32_t		u1IRQCEC79:1;
    uint_io32_t		u1IRQCEC80:1;
    uint_io32_t		u1IRQCEC81:1;
    uint_io32_t		u1IRQCEC82:1;
    uint_io32_t		u1IRQCEC83:1;
    uint_io32_t		u1IRQCEC84:1;
    uint_io32_t		u1IRQCEC85:1;
    uint_io32_t		u1IRQCEC86:1;
    uint_io32_t		u1IRQCEC87:1;
    uint_io32_t		u1IRQCEC88:1;
    uint_io32_t		u1IRQCEC89:1;
    uint_io32_t		u1IRQCEC90:1;
    uint_io32_t		u1IRQCEC91:1;
    uint_io32_t		u1IRQCEC92:1;
    uint_io32_t		u1IRQCEC93:1;
    uint_io32_t		u1IRQCEC94:1;
    uint_io32_t		u1IRQCEC95:1;
}stc_irc0_irqcec2_field_t;

typedef union un_irc0_irqcec2{
    uint_io32_t		u32Register;
    stc_irc0_irqcec2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec2_t;

/* IRQCEC3 */
#define IRC0_IRQCEC3	(IRC0.unIRQCEC3.u32Register)  /*@rg@*/
#define IRC0_IRQCEC3_IRQCEC96	(IRC0.unIRQCEC3.stcField.u1IRQCEC96)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC97	(IRC0.unIRQCEC3.stcField.u1IRQCEC97)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC98	(IRC0.unIRQCEC3.stcField.u1IRQCEC98)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC99	(IRC0.unIRQCEC3.stcField.u1IRQCEC99)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC100	(IRC0.unIRQCEC3.stcField.u1IRQCEC100)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC101	(IRC0.unIRQCEC3.stcField.u1IRQCEC101)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC102	(IRC0.unIRQCEC3.stcField.u1IRQCEC102)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC103	(IRC0.unIRQCEC3.stcField.u1IRQCEC103)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC104	(IRC0.unIRQCEC3.stcField.u1IRQCEC104)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC105	(IRC0.unIRQCEC3.stcField.u1IRQCEC105)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC106	(IRC0.unIRQCEC3.stcField.u1IRQCEC106)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC107	(IRC0.unIRQCEC3.stcField.u1IRQCEC107)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC108	(IRC0.unIRQCEC3.stcField.u1IRQCEC108)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC109	(IRC0.unIRQCEC3.stcField.u1IRQCEC109)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC110	(IRC0.unIRQCEC3.stcField.u1IRQCEC110)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC111	(IRC0.unIRQCEC3.stcField.u1IRQCEC111)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC112	(IRC0.unIRQCEC3.stcField.u1IRQCEC112)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC113	(IRC0.unIRQCEC3.stcField.u1IRQCEC113)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC114	(IRC0.unIRQCEC3.stcField.u1IRQCEC114)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC115	(IRC0.unIRQCEC3.stcField.u1IRQCEC115)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC116	(IRC0.unIRQCEC3.stcField.u1IRQCEC116)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC117	(IRC0.unIRQCEC3.stcField.u1IRQCEC117)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC118	(IRC0.unIRQCEC3.stcField.u1IRQCEC118)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC119	(IRC0.unIRQCEC3.stcField.u1IRQCEC119)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC120	(IRC0.unIRQCEC3.stcField.u1IRQCEC120)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC121	(IRC0.unIRQCEC3.stcField.u1IRQCEC121)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC122	(IRC0.unIRQCEC3.stcField.u1IRQCEC122)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC123	(IRC0.unIRQCEC3.stcField.u1IRQCEC123)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC124	(IRC0.unIRQCEC3.stcField.u1IRQCEC124)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC125	(IRC0.unIRQCEC3.stcField.u1IRQCEC125)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC126	(IRC0.unIRQCEC3.stcField.u1IRQCEC126)  /*@bf@*/
#define IRC0_IRQCEC3_IRQCEC127	(IRC0.unIRQCEC3.stcField.u1IRQCEC127)  /*@bf@*/

typedef struct stc_irc0_irqcec3_field{
    uint_io32_t		u1IRQCEC96:1;
    uint_io32_t		u1IRQCEC97:1;
    uint_io32_t		u1IRQCEC98:1;
    uint_io32_t		u1IRQCEC99:1;
    uint_io32_t		u1IRQCEC100:1;
    uint_io32_t		u1IRQCEC101:1;
    uint_io32_t		u1IRQCEC102:1;
    uint_io32_t		u1IRQCEC103:1;
    uint_io32_t		u1IRQCEC104:1;
    uint_io32_t		u1IRQCEC105:1;
    uint_io32_t		u1IRQCEC106:1;
    uint_io32_t		u1IRQCEC107:1;
    uint_io32_t		u1IRQCEC108:1;
    uint_io32_t		u1IRQCEC109:1;
    uint_io32_t		u1IRQCEC110:1;
    uint_io32_t		u1IRQCEC111:1;
    uint_io32_t		u1IRQCEC112:1;
    uint_io32_t		u1IRQCEC113:1;
    uint_io32_t		u1IRQCEC114:1;
    uint_io32_t		u1IRQCEC115:1;
    uint_io32_t		u1IRQCEC116:1;
    uint_io32_t		u1IRQCEC117:1;
    uint_io32_t		u1IRQCEC118:1;
    uint_io32_t		u1IRQCEC119:1;
    uint_io32_t		u1IRQCEC120:1;
    uint_io32_t		u1IRQCEC121:1;
    uint_io32_t		u1IRQCEC122:1;
    uint_io32_t		u1IRQCEC123:1;
    uint_io32_t		u1IRQCEC124:1;
    uint_io32_t		u1IRQCEC125:1;
    uint_io32_t		u1IRQCEC126:1;
    uint_io32_t		u1IRQCEC127:1;
}stc_irc0_irqcec3_field_t;

typedef union un_irc0_irqcec3{
    uint_io32_t		u32Register;
    stc_irc0_irqcec3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec3_t;

/* IRQCEC4 */
#define IRC0_IRQCEC4	(IRC0.unIRQCEC4.u32Register)  /*@rg@*/
#define IRC0_IRQCEC4_IRQCEC128	(IRC0.unIRQCEC4.stcField.u1IRQCEC128)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC129	(IRC0.unIRQCEC4.stcField.u1IRQCEC129)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC130	(IRC0.unIRQCEC4.stcField.u1IRQCEC130)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC131	(IRC0.unIRQCEC4.stcField.u1IRQCEC131)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC132	(IRC0.unIRQCEC4.stcField.u1IRQCEC132)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC133	(IRC0.unIRQCEC4.stcField.u1IRQCEC133)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC134	(IRC0.unIRQCEC4.stcField.u1IRQCEC134)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC135	(IRC0.unIRQCEC4.stcField.u1IRQCEC135)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC136	(IRC0.unIRQCEC4.stcField.u1IRQCEC136)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC137	(IRC0.unIRQCEC4.stcField.u1IRQCEC137)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC138	(IRC0.unIRQCEC4.stcField.u1IRQCEC138)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC139	(IRC0.unIRQCEC4.stcField.u1IRQCEC139)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC140	(IRC0.unIRQCEC4.stcField.u1IRQCEC140)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC141	(IRC0.unIRQCEC4.stcField.u1IRQCEC141)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC142	(IRC0.unIRQCEC4.stcField.u1IRQCEC142)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC143	(IRC0.unIRQCEC4.stcField.u1IRQCEC143)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC144	(IRC0.unIRQCEC4.stcField.u1IRQCEC144)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC145	(IRC0.unIRQCEC4.stcField.u1IRQCEC145)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC146	(IRC0.unIRQCEC4.stcField.u1IRQCEC146)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC147	(IRC0.unIRQCEC4.stcField.u1IRQCEC147)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC148	(IRC0.unIRQCEC4.stcField.u1IRQCEC148)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC149	(IRC0.unIRQCEC4.stcField.u1IRQCEC149)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC150	(IRC0.unIRQCEC4.stcField.u1IRQCEC150)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC151	(IRC0.unIRQCEC4.stcField.u1IRQCEC151)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC152	(IRC0.unIRQCEC4.stcField.u1IRQCEC152)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC153	(IRC0.unIRQCEC4.stcField.u1IRQCEC153)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC154	(IRC0.unIRQCEC4.stcField.u1IRQCEC154)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC155	(IRC0.unIRQCEC4.stcField.u1IRQCEC155)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC156	(IRC0.unIRQCEC4.stcField.u1IRQCEC156)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC157	(IRC0.unIRQCEC4.stcField.u1IRQCEC157)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC158	(IRC0.unIRQCEC4.stcField.u1IRQCEC158)  /*@bf@*/
#define IRC0_IRQCEC4_IRQCEC159	(IRC0.unIRQCEC4.stcField.u1IRQCEC159)  /*@bf@*/

typedef struct stc_irc0_irqcec4_field{
    uint_io32_t		u1IRQCEC128:1;
    uint_io32_t		u1IRQCEC129:1;
    uint_io32_t		u1IRQCEC130:1;
    uint_io32_t		u1IRQCEC131:1;
    uint_io32_t		u1IRQCEC132:1;
    uint_io32_t		u1IRQCEC133:1;
    uint_io32_t		u1IRQCEC134:1;
    uint_io32_t		u1IRQCEC135:1;
    uint_io32_t		u1IRQCEC136:1;
    uint_io32_t		u1IRQCEC137:1;
    uint_io32_t		u1IRQCEC138:1;
    uint_io32_t		u1IRQCEC139:1;
    uint_io32_t		u1IRQCEC140:1;
    uint_io32_t		u1IRQCEC141:1;
    uint_io32_t		u1IRQCEC142:1;
    uint_io32_t		u1IRQCEC143:1;
    uint_io32_t		u1IRQCEC144:1;
    uint_io32_t		u1IRQCEC145:1;
    uint_io32_t		u1IRQCEC146:1;
    uint_io32_t		u1IRQCEC147:1;
    uint_io32_t		u1IRQCEC148:1;
    uint_io32_t		u1IRQCEC149:1;
    uint_io32_t		u1IRQCEC150:1;
    uint_io32_t		u1IRQCEC151:1;
    uint_io32_t		u1IRQCEC152:1;
    uint_io32_t		u1IRQCEC153:1;
    uint_io32_t		u1IRQCEC154:1;
    uint_io32_t		u1IRQCEC155:1;
    uint_io32_t		u1IRQCEC156:1;
    uint_io32_t		u1IRQCEC157:1;
    uint_io32_t		u1IRQCEC158:1;
    uint_io32_t		u1IRQCEC159:1;
}stc_irc0_irqcec4_field_t;

typedef union un_irc0_irqcec4{
    uint_io32_t		u32Register;
    stc_irc0_irqcec4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec4_t;

/* IRQCEC5 */
#define IRC0_IRQCEC5	(IRC0.unIRQCEC5.u32Register)  /*@rg@*/
#define IRC0_IRQCEC5_IRQCEC160	(IRC0.unIRQCEC5.stcField.u1IRQCEC160)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC161	(IRC0.unIRQCEC5.stcField.u1IRQCEC161)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC162	(IRC0.unIRQCEC5.stcField.u1IRQCEC162)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC163	(IRC0.unIRQCEC5.stcField.u1IRQCEC163)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC164	(IRC0.unIRQCEC5.stcField.u1IRQCEC164)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC165	(IRC0.unIRQCEC5.stcField.u1IRQCEC165)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC166	(IRC0.unIRQCEC5.stcField.u1IRQCEC166)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC167	(IRC0.unIRQCEC5.stcField.u1IRQCEC167)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC168	(IRC0.unIRQCEC5.stcField.u1IRQCEC168)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC169	(IRC0.unIRQCEC5.stcField.u1IRQCEC169)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC170	(IRC0.unIRQCEC5.stcField.u1IRQCEC170)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC171	(IRC0.unIRQCEC5.stcField.u1IRQCEC171)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC172	(IRC0.unIRQCEC5.stcField.u1IRQCEC172)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC173	(IRC0.unIRQCEC5.stcField.u1IRQCEC173)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC174	(IRC0.unIRQCEC5.stcField.u1IRQCEC174)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC175	(IRC0.unIRQCEC5.stcField.u1IRQCEC175)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC176	(IRC0.unIRQCEC5.stcField.u1IRQCEC176)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC177	(IRC0.unIRQCEC5.stcField.u1IRQCEC177)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC178	(IRC0.unIRQCEC5.stcField.u1IRQCEC178)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC179	(IRC0.unIRQCEC5.stcField.u1IRQCEC179)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC180	(IRC0.unIRQCEC5.stcField.u1IRQCEC180)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC181	(IRC0.unIRQCEC5.stcField.u1IRQCEC181)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC182	(IRC0.unIRQCEC5.stcField.u1IRQCEC182)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC183	(IRC0.unIRQCEC5.stcField.u1IRQCEC183)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC184	(IRC0.unIRQCEC5.stcField.u1IRQCEC184)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC185	(IRC0.unIRQCEC5.stcField.u1IRQCEC185)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC186	(IRC0.unIRQCEC5.stcField.u1IRQCEC186)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC187	(IRC0.unIRQCEC5.stcField.u1IRQCEC187)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC188	(IRC0.unIRQCEC5.stcField.u1IRQCEC188)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC189	(IRC0.unIRQCEC5.stcField.u1IRQCEC189)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC190	(IRC0.unIRQCEC5.stcField.u1IRQCEC190)  /*@bf@*/
#define IRC0_IRQCEC5_IRQCEC191	(IRC0.unIRQCEC5.stcField.u1IRQCEC191)  /*@bf@*/

typedef struct stc_irc0_irqcec5_field{
    uint_io32_t		u1IRQCEC160:1;
    uint_io32_t		u1IRQCEC161:1;
    uint_io32_t		u1IRQCEC162:1;
    uint_io32_t		u1IRQCEC163:1;
    uint_io32_t		u1IRQCEC164:1;
    uint_io32_t		u1IRQCEC165:1;
    uint_io32_t		u1IRQCEC166:1;
    uint_io32_t		u1IRQCEC167:1;
    uint_io32_t		u1IRQCEC168:1;
    uint_io32_t		u1IRQCEC169:1;
    uint_io32_t		u1IRQCEC170:1;
    uint_io32_t		u1IRQCEC171:1;
    uint_io32_t		u1IRQCEC172:1;
    uint_io32_t		u1IRQCEC173:1;
    uint_io32_t		u1IRQCEC174:1;
    uint_io32_t		u1IRQCEC175:1;
    uint_io32_t		u1IRQCEC176:1;
    uint_io32_t		u1IRQCEC177:1;
    uint_io32_t		u1IRQCEC178:1;
    uint_io32_t		u1IRQCEC179:1;
    uint_io32_t		u1IRQCEC180:1;
    uint_io32_t		u1IRQCEC181:1;
    uint_io32_t		u1IRQCEC182:1;
    uint_io32_t		u1IRQCEC183:1;
    uint_io32_t		u1IRQCEC184:1;
    uint_io32_t		u1IRQCEC185:1;
    uint_io32_t		u1IRQCEC186:1;
    uint_io32_t		u1IRQCEC187:1;
    uint_io32_t		u1IRQCEC188:1;
    uint_io32_t		u1IRQCEC189:1;
    uint_io32_t		u1IRQCEC190:1;
    uint_io32_t		u1IRQCEC191:1;
}stc_irc0_irqcec5_field_t;

typedef union un_irc0_irqcec5{
    uint_io32_t		u32Register;
    stc_irc0_irqcec5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec5_t;

/* IRQCEC6 */
#define IRC0_IRQCEC6	(IRC0.unIRQCEC6.u32Register)  /*@rg@*/
#define IRC0_IRQCEC6_IRQCEC192	(IRC0.unIRQCEC6.stcField.u1IRQCEC192)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC193	(IRC0.unIRQCEC6.stcField.u1IRQCEC193)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC194	(IRC0.unIRQCEC6.stcField.u1IRQCEC194)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC195	(IRC0.unIRQCEC6.stcField.u1IRQCEC195)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC196	(IRC0.unIRQCEC6.stcField.u1IRQCEC196)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC197	(IRC0.unIRQCEC6.stcField.u1IRQCEC197)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC198	(IRC0.unIRQCEC6.stcField.u1IRQCEC198)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC199	(IRC0.unIRQCEC6.stcField.u1IRQCEC199)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC200	(IRC0.unIRQCEC6.stcField.u1IRQCEC200)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC201	(IRC0.unIRQCEC6.stcField.u1IRQCEC201)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC202	(IRC0.unIRQCEC6.stcField.u1IRQCEC202)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC203	(IRC0.unIRQCEC6.stcField.u1IRQCEC203)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC204	(IRC0.unIRQCEC6.stcField.u1IRQCEC204)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC205	(IRC0.unIRQCEC6.stcField.u1IRQCEC205)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC206	(IRC0.unIRQCEC6.stcField.u1IRQCEC206)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC207	(IRC0.unIRQCEC6.stcField.u1IRQCEC207)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC208	(IRC0.unIRQCEC6.stcField.u1IRQCEC208)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC209	(IRC0.unIRQCEC6.stcField.u1IRQCEC209)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC210	(IRC0.unIRQCEC6.stcField.u1IRQCEC210)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC211	(IRC0.unIRQCEC6.stcField.u1IRQCEC211)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC212	(IRC0.unIRQCEC6.stcField.u1IRQCEC212)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC213	(IRC0.unIRQCEC6.stcField.u1IRQCEC213)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC214	(IRC0.unIRQCEC6.stcField.u1IRQCEC214)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC215	(IRC0.unIRQCEC6.stcField.u1IRQCEC215)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC216	(IRC0.unIRQCEC6.stcField.u1IRQCEC216)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC217	(IRC0.unIRQCEC6.stcField.u1IRQCEC217)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC218	(IRC0.unIRQCEC6.stcField.u1IRQCEC218)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC219	(IRC0.unIRQCEC6.stcField.u1IRQCEC219)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC220	(IRC0.unIRQCEC6.stcField.u1IRQCEC220)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC221	(IRC0.unIRQCEC6.stcField.u1IRQCEC221)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC222	(IRC0.unIRQCEC6.stcField.u1IRQCEC222)  /*@bf@*/
#define IRC0_IRQCEC6_IRQCEC223	(IRC0.unIRQCEC6.stcField.u1IRQCEC223)  /*@bf@*/

typedef struct stc_irc0_irqcec6_field{
    uint_io32_t		u1IRQCEC192:1;
    uint_io32_t		u1IRQCEC193:1;
    uint_io32_t		u1IRQCEC194:1;
    uint_io32_t		u1IRQCEC195:1;
    uint_io32_t		u1IRQCEC196:1;
    uint_io32_t		u1IRQCEC197:1;
    uint_io32_t		u1IRQCEC198:1;
    uint_io32_t		u1IRQCEC199:1;
    uint_io32_t		u1IRQCEC200:1;
    uint_io32_t		u1IRQCEC201:1;
    uint_io32_t		u1IRQCEC202:1;
    uint_io32_t		u1IRQCEC203:1;
    uint_io32_t		u1IRQCEC204:1;
    uint_io32_t		u1IRQCEC205:1;
    uint_io32_t		u1IRQCEC206:1;
    uint_io32_t		u1IRQCEC207:1;
    uint_io32_t		u1IRQCEC208:1;
    uint_io32_t		u1IRQCEC209:1;
    uint_io32_t		u1IRQCEC210:1;
    uint_io32_t		u1IRQCEC211:1;
    uint_io32_t		u1IRQCEC212:1;
    uint_io32_t		u1IRQCEC213:1;
    uint_io32_t		u1IRQCEC214:1;
    uint_io32_t		u1IRQCEC215:1;
    uint_io32_t		u1IRQCEC216:1;
    uint_io32_t		u1IRQCEC217:1;
    uint_io32_t		u1IRQCEC218:1;
    uint_io32_t		u1IRQCEC219:1;
    uint_io32_t		u1IRQCEC220:1;
    uint_io32_t		u1IRQCEC221:1;
    uint_io32_t		u1IRQCEC222:1;
    uint_io32_t		u1IRQCEC223:1;
}stc_irc0_irqcec6_field_t;

typedef union un_irc0_irqcec6{
    uint_io32_t		u32Register;
    stc_irc0_irqcec6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec6_t;

/* IRQCEC7 */
#define IRC0_IRQCEC7	(IRC0.unIRQCEC7.u32Register)  /*@rg@*/
#define IRC0_IRQCEC7_IRQCEC224	(IRC0.unIRQCEC7.stcField.u1IRQCEC224)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC225	(IRC0.unIRQCEC7.stcField.u1IRQCEC225)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC226	(IRC0.unIRQCEC7.stcField.u1IRQCEC226)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC227	(IRC0.unIRQCEC7.stcField.u1IRQCEC227)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC228	(IRC0.unIRQCEC7.stcField.u1IRQCEC228)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC229	(IRC0.unIRQCEC7.stcField.u1IRQCEC229)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC230	(IRC0.unIRQCEC7.stcField.u1IRQCEC230)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC231	(IRC0.unIRQCEC7.stcField.u1IRQCEC231)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC232	(IRC0.unIRQCEC7.stcField.u1IRQCEC232)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC233	(IRC0.unIRQCEC7.stcField.u1IRQCEC233)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC234	(IRC0.unIRQCEC7.stcField.u1IRQCEC234)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC235	(IRC0.unIRQCEC7.stcField.u1IRQCEC235)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC236	(IRC0.unIRQCEC7.stcField.u1IRQCEC236)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC237	(IRC0.unIRQCEC7.stcField.u1IRQCEC237)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC238	(IRC0.unIRQCEC7.stcField.u1IRQCEC238)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC239	(IRC0.unIRQCEC7.stcField.u1IRQCEC239)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC240	(IRC0.unIRQCEC7.stcField.u1IRQCEC240)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC241	(IRC0.unIRQCEC7.stcField.u1IRQCEC241)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC242	(IRC0.unIRQCEC7.stcField.u1IRQCEC242)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC243	(IRC0.unIRQCEC7.stcField.u1IRQCEC243)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC244	(IRC0.unIRQCEC7.stcField.u1IRQCEC244)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC245	(IRC0.unIRQCEC7.stcField.u1IRQCEC245)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC246	(IRC0.unIRQCEC7.stcField.u1IRQCEC246)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC247	(IRC0.unIRQCEC7.stcField.u1IRQCEC247)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC248	(IRC0.unIRQCEC7.stcField.u1IRQCEC248)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC249	(IRC0.unIRQCEC7.stcField.u1IRQCEC249)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC250	(IRC0.unIRQCEC7.stcField.u1IRQCEC250)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC251	(IRC0.unIRQCEC7.stcField.u1IRQCEC251)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC252	(IRC0.unIRQCEC7.stcField.u1IRQCEC252)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC253	(IRC0.unIRQCEC7.stcField.u1IRQCEC253)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC254	(IRC0.unIRQCEC7.stcField.u1IRQCEC254)  /*@bf@*/
#define IRC0_IRQCEC7_IRQCEC255	(IRC0.unIRQCEC7.stcField.u1IRQCEC255)  /*@bf@*/

typedef struct stc_irc0_irqcec7_field{
    uint_io32_t		u1IRQCEC224:1;
    uint_io32_t		u1IRQCEC225:1;
    uint_io32_t		u1IRQCEC226:1;
    uint_io32_t		u1IRQCEC227:1;
    uint_io32_t		u1IRQCEC228:1;
    uint_io32_t		u1IRQCEC229:1;
    uint_io32_t		u1IRQCEC230:1;
    uint_io32_t		u1IRQCEC231:1;
    uint_io32_t		u1IRQCEC232:1;
    uint_io32_t		u1IRQCEC233:1;
    uint_io32_t		u1IRQCEC234:1;
    uint_io32_t		u1IRQCEC235:1;
    uint_io32_t		u1IRQCEC236:1;
    uint_io32_t		u1IRQCEC237:1;
    uint_io32_t		u1IRQCEC238:1;
    uint_io32_t		u1IRQCEC239:1;
    uint_io32_t		u1IRQCEC240:1;
    uint_io32_t		u1IRQCEC241:1;
    uint_io32_t		u1IRQCEC242:1;
    uint_io32_t		u1IRQCEC243:1;
    uint_io32_t		u1IRQCEC244:1;
    uint_io32_t		u1IRQCEC245:1;
    uint_io32_t		u1IRQCEC246:1;
    uint_io32_t		u1IRQCEC247:1;
    uint_io32_t		u1IRQCEC248:1;
    uint_io32_t		u1IRQCEC249:1;
    uint_io32_t		u1IRQCEC250:1;
    uint_io32_t		u1IRQCEC251:1;
    uint_io32_t		u1IRQCEC252:1;
    uint_io32_t		u1IRQCEC253:1;
    uint_io32_t		u1IRQCEC254:1;
    uint_io32_t		u1IRQCEC255:1;
}stc_irc0_irqcec7_field_t;

typedef union un_irc0_irqcec7{
    uint_io32_t		u32Register;
    stc_irc0_irqcec7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec7_t;

/* IRQCEC8 */
#define IRC0_IRQCEC8	(IRC0.unIRQCEC8.u32Register)  /*@rg@*/
#define IRC0_IRQCEC8_IRQCEC256	(IRC0.unIRQCEC8.stcField.u1IRQCEC256)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC257	(IRC0.unIRQCEC8.stcField.u1IRQCEC257)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC258	(IRC0.unIRQCEC8.stcField.u1IRQCEC258)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC259	(IRC0.unIRQCEC8.stcField.u1IRQCEC259)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC260	(IRC0.unIRQCEC8.stcField.u1IRQCEC260)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC261	(IRC0.unIRQCEC8.stcField.u1IRQCEC261)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC262	(IRC0.unIRQCEC8.stcField.u1IRQCEC262)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC263	(IRC0.unIRQCEC8.stcField.u1IRQCEC263)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC264	(IRC0.unIRQCEC8.stcField.u1IRQCEC264)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC265	(IRC0.unIRQCEC8.stcField.u1IRQCEC265)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC266	(IRC0.unIRQCEC8.stcField.u1IRQCEC266)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC267	(IRC0.unIRQCEC8.stcField.u1IRQCEC267)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC268	(IRC0.unIRQCEC8.stcField.u1IRQCEC268)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC269	(IRC0.unIRQCEC8.stcField.u1IRQCEC269)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC270	(IRC0.unIRQCEC8.stcField.u1IRQCEC270)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC271	(IRC0.unIRQCEC8.stcField.u1IRQCEC271)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC272	(IRC0.unIRQCEC8.stcField.u1IRQCEC272)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC273	(IRC0.unIRQCEC8.stcField.u1IRQCEC273)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC274	(IRC0.unIRQCEC8.stcField.u1IRQCEC274)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC275	(IRC0.unIRQCEC8.stcField.u1IRQCEC275)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC276	(IRC0.unIRQCEC8.stcField.u1IRQCEC276)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC277	(IRC0.unIRQCEC8.stcField.u1IRQCEC277)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC278	(IRC0.unIRQCEC8.stcField.u1IRQCEC278)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC279	(IRC0.unIRQCEC8.stcField.u1IRQCEC279)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC280	(IRC0.unIRQCEC8.stcField.u1IRQCEC280)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC281	(IRC0.unIRQCEC8.stcField.u1IRQCEC281)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC282	(IRC0.unIRQCEC8.stcField.u1IRQCEC282)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC283	(IRC0.unIRQCEC8.stcField.u1IRQCEC283)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC284	(IRC0.unIRQCEC8.stcField.u1IRQCEC284)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC285	(IRC0.unIRQCEC8.stcField.u1IRQCEC285)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC286	(IRC0.unIRQCEC8.stcField.u1IRQCEC286)  /*@bf@*/
#define IRC0_IRQCEC8_IRQCEC287	(IRC0.unIRQCEC8.stcField.u1IRQCEC287)  /*@bf@*/

typedef struct stc_irc0_irqcec8_field{
    uint_io32_t		u1IRQCEC256:1;
    uint_io32_t		u1IRQCEC257:1;
    uint_io32_t		u1IRQCEC258:1;
    uint_io32_t		u1IRQCEC259:1;
    uint_io32_t		u1IRQCEC260:1;
    uint_io32_t		u1IRQCEC261:1;
    uint_io32_t		u1IRQCEC262:1;
    uint_io32_t		u1IRQCEC263:1;
    uint_io32_t		u1IRQCEC264:1;
    uint_io32_t		u1IRQCEC265:1;
    uint_io32_t		u1IRQCEC266:1;
    uint_io32_t		u1IRQCEC267:1;
    uint_io32_t		u1IRQCEC268:1;
    uint_io32_t		u1IRQCEC269:1;
    uint_io32_t		u1IRQCEC270:1;
    uint_io32_t		u1IRQCEC271:1;
    uint_io32_t		u1IRQCEC272:1;
    uint_io32_t		u1IRQCEC273:1;
    uint_io32_t		u1IRQCEC274:1;
    uint_io32_t		u1IRQCEC275:1;
    uint_io32_t		u1IRQCEC276:1;
    uint_io32_t		u1IRQCEC277:1;
    uint_io32_t		u1IRQCEC278:1;
    uint_io32_t		u1IRQCEC279:1;
    uint_io32_t		u1IRQCEC280:1;
    uint_io32_t		u1IRQCEC281:1;
    uint_io32_t		u1IRQCEC282:1;
    uint_io32_t		u1IRQCEC283:1;
    uint_io32_t		u1IRQCEC284:1;
    uint_io32_t		u1IRQCEC285:1;
    uint_io32_t		u1IRQCEC286:1;
    uint_io32_t		u1IRQCEC287:1;
}stc_irc0_irqcec8_field_t;

typedef union un_irc0_irqcec8{
    uint_io32_t		u32Register;
    stc_irc0_irqcec8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec8_t;

/* IRQCEC9 */
#define IRC0_IRQCEC9	(IRC0.unIRQCEC9.u32Register)  /*@rg@*/
#define IRC0_IRQCEC9_IRQCEC288	(IRC0.unIRQCEC9.stcField.u1IRQCEC288)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC289	(IRC0.unIRQCEC9.stcField.u1IRQCEC289)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC290	(IRC0.unIRQCEC9.stcField.u1IRQCEC290)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC291	(IRC0.unIRQCEC9.stcField.u1IRQCEC291)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC292	(IRC0.unIRQCEC9.stcField.u1IRQCEC292)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC293	(IRC0.unIRQCEC9.stcField.u1IRQCEC293)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC294	(IRC0.unIRQCEC9.stcField.u1IRQCEC294)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC295	(IRC0.unIRQCEC9.stcField.u1IRQCEC295)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC296	(IRC0.unIRQCEC9.stcField.u1IRQCEC296)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC297	(IRC0.unIRQCEC9.stcField.u1IRQCEC297)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC298	(IRC0.unIRQCEC9.stcField.u1IRQCEC298)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC299	(IRC0.unIRQCEC9.stcField.u1IRQCEC299)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC300	(IRC0.unIRQCEC9.stcField.u1IRQCEC300)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC301	(IRC0.unIRQCEC9.stcField.u1IRQCEC301)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC302	(IRC0.unIRQCEC9.stcField.u1IRQCEC302)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC303	(IRC0.unIRQCEC9.stcField.u1IRQCEC303)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC304	(IRC0.unIRQCEC9.stcField.u1IRQCEC304)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC305	(IRC0.unIRQCEC9.stcField.u1IRQCEC305)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC306	(IRC0.unIRQCEC9.stcField.u1IRQCEC306)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC307	(IRC0.unIRQCEC9.stcField.u1IRQCEC307)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC308	(IRC0.unIRQCEC9.stcField.u1IRQCEC308)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC309	(IRC0.unIRQCEC9.stcField.u1IRQCEC309)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC310	(IRC0.unIRQCEC9.stcField.u1IRQCEC310)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC311	(IRC0.unIRQCEC9.stcField.u1IRQCEC311)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC312	(IRC0.unIRQCEC9.stcField.u1IRQCEC312)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC313	(IRC0.unIRQCEC9.stcField.u1IRQCEC313)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC314	(IRC0.unIRQCEC9.stcField.u1IRQCEC314)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC315	(IRC0.unIRQCEC9.stcField.u1IRQCEC315)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC316	(IRC0.unIRQCEC9.stcField.u1IRQCEC316)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC317	(IRC0.unIRQCEC9.stcField.u1IRQCEC317)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC318	(IRC0.unIRQCEC9.stcField.u1IRQCEC318)  /*@bf@*/
#define IRC0_IRQCEC9_IRQCEC319	(IRC0.unIRQCEC9.stcField.u1IRQCEC319)  /*@bf@*/

typedef struct stc_irc0_irqcec9_field{
    uint_io32_t		u1IRQCEC288:1;
    uint_io32_t		u1IRQCEC289:1;
    uint_io32_t		u1IRQCEC290:1;
    uint_io32_t		u1IRQCEC291:1;
    uint_io32_t		u1IRQCEC292:1;
    uint_io32_t		u1IRQCEC293:1;
    uint_io32_t		u1IRQCEC294:1;
    uint_io32_t		u1IRQCEC295:1;
    uint_io32_t		u1IRQCEC296:1;
    uint_io32_t		u1IRQCEC297:1;
    uint_io32_t		u1IRQCEC298:1;
    uint_io32_t		u1IRQCEC299:1;
    uint_io32_t		u1IRQCEC300:1;
    uint_io32_t		u1IRQCEC301:1;
    uint_io32_t		u1IRQCEC302:1;
    uint_io32_t		u1IRQCEC303:1;
    uint_io32_t		u1IRQCEC304:1;
    uint_io32_t		u1IRQCEC305:1;
    uint_io32_t		u1IRQCEC306:1;
    uint_io32_t		u1IRQCEC307:1;
    uint_io32_t		u1IRQCEC308:1;
    uint_io32_t		u1IRQCEC309:1;
    uint_io32_t		u1IRQCEC310:1;
    uint_io32_t		u1IRQCEC311:1;
    uint_io32_t		u1IRQCEC312:1;
    uint_io32_t		u1IRQCEC313:1;
    uint_io32_t		u1IRQCEC314:1;
    uint_io32_t		u1IRQCEC315:1;
    uint_io32_t		u1IRQCEC316:1;
    uint_io32_t		u1IRQCEC317:1;
    uint_io32_t		u1IRQCEC318:1;
    uint_io32_t		u1IRQCEC319:1;
}stc_irc0_irqcec9_field_t;

typedef union un_irc0_irqcec9{
    uint_io32_t		u32Register;
    stc_irc0_irqcec9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec9_t;

/* IRQCEC10 */
#define IRC0_IRQCEC10	(IRC0.unIRQCEC10.u32Register)  /*@rg@*/
#define IRC0_IRQCEC10_IRQCEC320	(IRC0.unIRQCEC10.stcField.u1IRQCEC320)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC321	(IRC0.unIRQCEC10.stcField.u1IRQCEC321)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC322	(IRC0.unIRQCEC10.stcField.u1IRQCEC322)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC323	(IRC0.unIRQCEC10.stcField.u1IRQCEC323)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC324	(IRC0.unIRQCEC10.stcField.u1IRQCEC324)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC325	(IRC0.unIRQCEC10.stcField.u1IRQCEC325)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC326	(IRC0.unIRQCEC10.stcField.u1IRQCEC326)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC327	(IRC0.unIRQCEC10.stcField.u1IRQCEC327)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC328	(IRC0.unIRQCEC10.stcField.u1IRQCEC328)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC329	(IRC0.unIRQCEC10.stcField.u1IRQCEC329)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC330	(IRC0.unIRQCEC10.stcField.u1IRQCEC330)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC331	(IRC0.unIRQCEC10.stcField.u1IRQCEC331)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC332	(IRC0.unIRQCEC10.stcField.u1IRQCEC332)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC333	(IRC0.unIRQCEC10.stcField.u1IRQCEC333)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC334	(IRC0.unIRQCEC10.stcField.u1IRQCEC334)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC335	(IRC0.unIRQCEC10.stcField.u1IRQCEC335)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC336	(IRC0.unIRQCEC10.stcField.u1IRQCEC336)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC337	(IRC0.unIRQCEC10.stcField.u1IRQCEC337)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC338	(IRC0.unIRQCEC10.stcField.u1IRQCEC338)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC339	(IRC0.unIRQCEC10.stcField.u1IRQCEC339)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC340	(IRC0.unIRQCEC10.stcField.u1IRQCEC340)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC341	(IRC0.unIRQCEC10.stcField.u1IRQCEC341)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC342	(IRC0.unIRQCEC10.stcField.u1IRQCEC342)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC343	(IRC0.unIRQCEC10.stcField.u1IRQCEC343)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC344	(IRC0.unIRQCEC10.stcField.u1IRQCEC344)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC345	(IRC0.unIRQCEC10.stcField.u1IRQCEC345)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC346	(IRC0.unIRQCEC10.stcField.u1IRQCEC346)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC347	(IRC0.unIRQCEC10.stcField.u1IRQCEC347)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC348	(IRC0.unIRQCEC10.stcField.u1IRQCEC348)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC349	(IRC0.unIRQCEC10.stcField.u1IRQCEC349)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC350	(IRC0.unIRQCEC10.stcField.u1IRQCEC350)  /*@bf@*/
#define IRC0_IRQCEC10_IRQCEC351	(IRC0.unIRQCEC10.stcField.u1IRQCEC351)  /*@bf@*/

typedef struct stc_irc0_irqcec10_field{
    uint_io32_t		u1IRQCEC320:1;
    uint_io32_t		u1IRQCEC321:1;
    uint_io32_t		u1IRQCEC322:1;
    uint_io32_t		u1IRQCEC323:1;
    uint_io32_t		u1IRQCEC324:1;
    uint_io32_t		u1IRQCEC325:1;
    uint_io32_t		u1IRQCEC326:1;
    uint_io32_t		u1IRQCEC327:1;
    uint_io32_t		u1IRQCEC328:1;
    uint_io32_t		u1IRQCEC329:1;
    uint_io32_t		u1IRQCEC330:1;
    uint_io32_t		u1IRQCEC331:1;
    uint_io32_t		u1IRQCEC332:1;
    uint_io32_t		u1IRQCEC333:1;
    uint_io32_t		u1IRQCEC334:1;
    uint_io32_t		u1IRQCEC335:1;
    uint_io32_t		u1IRQCEC336:1;
    uint_io32_t		u1IRQCEC337:1;
    uint_io32_t		u1IRQCEC338:1;
    uint_io32_t		u1IRQCEC339:1;
    uint_io32_t		u1IRQCEC340:1;
    uint_io32_t		u1IRQCEC341:1;
    uint_io32_t		u1IRQCEC342:1;
    uint_io32_t		u1IRQCEC343:1;
    uint_io32_t		u1IRQCEC344:1;
    uint_io32_t		u1IRQCEC345:1;
    uint_io32_t		u1IRQCEC346:1;
    uint_io32_t		u1IRQCEC347:1;
    uint_io32_t		u1IRQCEC348:1;
    uint_io32_t		u1IRQCEC349:1;
    uint_io32_t		u1IRQCEC350:1;
    uint_io32_t		u1IRQCEC351:1;
}stc_irc0_irqcec10_field_t;

typedef union un_irc0_irqcec10{
    uint_io32_t		u32Register;
    stc_irc0_irqcec10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec10_t;

/* IRQCEC11 */
#define IRC0_IRQCEC11	(IRC0.unIRQCEC11.u32Register)  /*@rg@*/
#define IRC0_IRQCEC11_IRQCEC352	(IRC0.unIRQCEC11.stcField.u1IRQCEC352)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC353	(IRC0.unIRQCEC11.stcField.u1IRQCEC353)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC354	(IRC0.unIRQCEC11.stcField.u1IRQCEC354)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC355	(IRC0.unIRQCEC11.stcField.u1IRQCEC355)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC356	(IRC0.unIRQCEC11.stcField.u1IRQCEC356)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC357	(IRC0.unIRQCEC11.stcField.u1IRQCEC357)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC358	(IRC0.unIRQCEC11.stcField.u1IRQCEC358)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC359	(IRC0.unIRQCEC11.stcField.u1IRQCEC359)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC360	(IRC0.unIRQCEC11.stcField.u1IRQCEC360)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC361	(IRC0.unIRQCEC11.stcField.u1IRQCEC361)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC362	(IRC0.unIRQCEC11.stcField.u1IRQCEC362)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC363	(IRC0.unIRQCEC11.stcField.u1IRQCEC363)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC364	(IRC0.unIRQCEC11.stcField.u1IRQCEC364)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC365	(IRC0.unIRQCEC11.stcField.u1IRQCEC365)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC366	(IRC0.unIRQCEC11.stcField.u1IRQCEC366)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC367	(IRC0.unIRQCEC11.stcField.u1IRQCEC367)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC368	(IRC0.unIRQCEC11.stcField.u1IRQCEC368)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC369	(IRC0.unIRQCEC11.stcField.u1IRQCEC369)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC370	(IRC0.unIRQCEC11.stcField.u1IRQCEC370)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC371	(IRC0.unIRQCEC11.stcField.u1IRQCEC371)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC372	(IRC0.unIRQCEC11.stcField.u1IRQCEC372)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC373	(IRC0.unIRQCEC11.stcField.u1IRQCEC373)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC374	(IRC0.unIRQCEC11.stcField.u1IRQCEC374)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC375	(IRC0.unIRQCEC11.stcField.u1IRQCEC375)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC376	(IRC0.unIRQCEC11.stcField.u1IRQCEC376)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC377	(IRC0.unIRQCEC11.stcField.u1IRQCEC377)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC378	(IRC0.unIRQCEC11.stcField.u1IRQCEC378)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC379	(IRC0.unIRQCEC11.stcField.u1IRQCEC379)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC380	(IRC0.unIRQCEC11.stcField.u1IRQCEC380)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC381	(IRC0.unIRQCEC11.stcField.u1IRQCEC381)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC382	(IRC0.unIRQCEC11.stcField.u1IRQCEC382)  /*@bf@*/
#define IRC0_IRQCEC11_IRQCEC383	(IRC0.unIRQCEC11.stcField.u1IRQCEC383)  /*@bf@*/

typedef struct stc_irc0_irqcec11_field{
    uint_io32_t		u1IRQCEC352:1;
    uint_io32_t		u1IRQCEC353:1;
    uint_io32_t		u1IRQCEC354:1;
    uint_io32_t		u1IRQCEC355:1;
    uint_io32_t		u1IRQCEC356:1;
    uint_io32_t		u1IRQCEC357:1;
    uint_io32_t		u1IRQCEC358:1;
    uint_io32_t		u1IRQCEC359:1;
    uint_io32_t		u1IRQCEC360:1;
    uint_io32_t		u1IRQCEC361:1;
    uint_io32_t		u1IRQCEC362:1;
    uint_io32_t		u1IRQCEC363:1;
    uint_io32_t		u1IRQCEC364:1;
    uint_io32_t		u1IRQCEC365:1;
    uint_io32_t		u1IRQCEC366:1;
    uint_io32_t		u1IRQCEC367:1;
    uint_io32_t		u1IRQCEC368:1;
    uint_io32_t		u1IRQCEC369:1;
    uint_io32_t		u1IRQCEC370:1;
    uint_io32_t		u1IRQCEC371:1;
    uint_io32_t		u1IRQCEC372:1;
    uint_io32_t		u1IRQCEC373:1;
    uint_io32_t		u1IRQCEC374:1;
    uint_io32_t		u1IRQCEC375:1;
    uint_io32_t		u1IRQCEC376:1;
    uint_io32_t		u1IRQCEC377:1;
    uint_io32_t		u1IRQCEC378:1;
    uint_io32_t		u1IRQCEC379:1;
    uint_io32_t		u1IRQCEC380:1;
    uint_io32_t		u1IRQCEC381:1;
    uint_io32_t		u1IRQCEC382:1;
    uint_io32_t		u1IRQCEC383:1;
}stc_irc0_irqcec11_field_t;

typedef union un_irc0_irqcec11{
    uint_io32_t		u32Register;
    stc_irc0_irqcec11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec11_t;

/* IRQCEC12 */
#define IRC0_IRQCEC12	(IRC0.unIRQCEC12.u32Register)  /*@rg@*/
#define IRC0_IRQCEC12_IRQCEC384	(IRC0.unIRQCEC12.stcField.u1IRQCEC384)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC385	(IRC0.unIRQCEC12.stcField.u1IRQCEC385)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC386	(IRC0.unIRQCEC12.stcField.u1IRQCEC386)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC387	(IRC0.unIRQCEC12.stcField.u1IRQCEC387)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC388	(IRC0.unIRQCEC12.stcField.u1IRQCEC388)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC389	(IRC0.unIRQCEC12.stcField.u1IRQCEC389)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC390	(IRC0.unIRQCEC12.stcField.u1IRQCEC390)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC391	(IRC0.unIRQCEC12.stcField.u1IRQCEC391)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC392	(IRC0.unIRQCEC12.stcField.u1IRQCEC392)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC393	(IRC0.unIRQCEC12.stcField.u1IRQCEC393)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC394	(IRC0.unIRQCEC12.stcField.u1IRQCEC394)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC395	(IRC0.unIRQCEC12.stcField.u1IRQCEC395)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC396	(IRC0.unIRQCEC12.stcField.u1IRQCEC396)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC397	(IRC0.unIRQCEC12.stcField.u1IRQCEC397)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC398	(IRC0.unIRQCEC12.stcField.u1IRQCEC398)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC399	(IRC0.unIRQCEC12.stcField.u1IRQCEC399)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC400	(IRC0.unIRQCEC12.stcField.u1IRQCEC400)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC401	(IRC0.unIRQCEC12.stcField.u1IRQCEC401)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC402	(IRC0.unIRQCEC12.stcField.u1IRQCEC402)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC403	(IRC0.unIRQCEC12.stcField.u1IRQCEC403)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC404	(IRC0.unIRQCEC12.stcField.u1IRQCEC404)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC405	(IRC0.unIRQCEC12.stcField.u1IRQCEC405)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC406	(IRC0.unIRQCEC12.stcField.u1IRQCEC406)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC407	(IRC0.unIRQCEC12.stcField.u1IRQCEC407)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC408	(IRC0.unIRQCEC12.stcField.u1IRQCEC408)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC409	(IRC0.unIRQCEC12.stcField.u1IRQCEC409)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC410	(IRC0.unIRQCEC12.stcField.u1IRQCEC410)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC411	(IRC0.unIRQCEC12.stcField.u1IRQCEC411)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC412	(IRC0.unIRQCEC12.stcField.u1IRQCEC412)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC413	(IRC0.unIRQCEC12.stcField.u1IRQCEC413)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC414	(IRC0.unIRQCEC12.stcField.u1IRQCEC414)  /*@bf@*/
#define IRC0_IRQCEC12_IRQCEC415	(IRC0.unIRQCEC12.stcField.u1IRQCEC415)  /*@bf@*/

typedef struct stc_irc0_irqcec12_field{
    uint_io32_t		u1IRQCEC384:1;
    uint_io32_t		u1IRQCEC385:1;
    uint_io32_t		u1IRQCEC386:1;
    uint_io32_t		u1IRQCEC387:1;
    uint_io32_t		u1IRQCEC388:1;
    uint_io32_t		u1IRQCEC389:1;
    uint_io32_t		u1IRQCEC390:1;
    uint_io32_t		u1IRQCEC391:1;
    uint_io32_t		u1IRQCEC392:1;
    uint_io32_t		u1IRQCEC393:1;
    uint_io32_t		u1IRQCEC394:1;
    uint_io32_t		u1IRQCEC395:1;
    uint_io32_t		u1IRQCEC396:1;
    uint_io32_t		u1IRQCEC397:1;
    uint_io32_t		u1IRQCEC398:1;
    uint_io32_t		u1IRQCEC399:1;
    uint_io32_t		u1IRQCEC400:1;
    uint_io32_t		u1IRQCEC401:1;
    uint_io32_t		u1IRQCEC402:1;
    uint_io32_t		u1IRQCEC403:1;
    uint_io32_t		u1IRQCEC404:1;
    uint_io32_t		u1IRQCEC405:1;
    uint_io32_t		u1IRQCEC406:1;
    uint_io32_t		u1IRQCEC407:1;
    uint_io32_t		u1IRQCEC408:1;
    uint_io32_t		u1IRQCEC409:1;
    uint_io32_t		u1IRQCEC410:1;
    uint_io32_t		u1IRQCEC411:1;
    uint_io32_t		u1IRQCEC412:1;
    uint_io32_t		u1IRQCEC413:1;
    uint_io32_t		u1IRQCEC414:1;
    uint_io32_t		u1IRQCEC415:1;
}stc_irc0_irqcec12_field_t;

typedef union un_irc0_irqcec12{
    uint_io32_t		u32Register;
    stc_irc0_irqcec12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec12_t;

/* IRQCEC13 */
#define IRC0_IRQCEC13	(IRC0.unIRQCEC13.u32Register)  /*@rg@*/
#define IRC0_IRQCEC13_IRQCEC416	(IRC0.unIRQCEC13.stcField.u1IRQCEC416)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC417	(IRC0.unIRQCEC13.stcField.u1IRQCEC417)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC418	(IRC0.unIRQCEC13.stcField.u1IRQCEC418)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC419	(IRC0.unIRQCEC13.stcField.u1IRQCEC419)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC420	(IRC0.unIRQCEC13.stcField.u1IRQCEC420)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC421	(IRC0.unIRQCEC13.stcField.u1IRQCEC421)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC422	(IRC0.unIRQCEC13.stcField.u1IRQCEC422)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC423	(IRC0.unIRQCEC13.stcField.u1IRQCEC423)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC424	(IRC0.unIRQCEC13.stcField.u1IRQCEC424)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC425	(IRC0.unIRQCEC13.stcField.u1IRQCEC425)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC426	(IRC0.unIRQCEC13.stcField.u1IRQCEC426)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC427	(IRC0.unIRQCEC13.stcField.u1IRQCEC427)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC428	(IRC0.unIRQCEC13.stcField.u1IRQCEC428)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC429	(IRC0.unIRQCEC13.stcField.u1IRQCEC429)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC430	(IRC0.unIRQCEC13.stcField.u1IRQCEC430)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC431	(IRC0.unIRQCEC13.stcField.u1IRQCEC431)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC432	(IRC0.unIRQCEC13.stcField.u1IRQCEC432)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC433	(IRC0.unIRQCEC13.stcField.u1IRQCEC433)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC434	(IRC0.unIRQCEC13.stcField.u1IRQCEC434)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC435	(IRC0.unIRQCEC13.stcField.u1IRQCEC435)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC436	(IRC0.unIRQCEC13.stcField.u1IRQCEC436)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC437	(IRC0.unIRQCEC13.stcField.u1IRQCEC437)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC438	(IRC0.unIRQCEC13.stcField.u1IRQCEC438)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC439	(IRC0.unIRQCEC13.stcField.u1IRQCEC439)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC440	(IRC0.unIRQCEC13.stcField.u1IRQCEC440)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC441	(IRC0.unIRQCEC13.stcField.u1IRQCEC441)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC442	(IRC0.unIRQCEC13.stcField.u1IRQCEC442)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC443	(IRC0.unIRQCEC13.stcField.u1IRQCEC443)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC444	(IRC0.unIRQCEC13.stcField.u1IRQCEC444)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC445	(IRC0.unIRQCEC13.stcField.u1IRQCEC445)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC446	(IRC0.unIRQCEC13.stcField.u1IRQCEC446)  /*@bf@*/
#define IRC0_IRQCEC13_IRQCEC447	(IRC0.unIRQCEC13.stcField.u1IRQCEC447)  /*@bf@*/

typedef struct stc_irc0_irqcec13_field{
    uint_io32_t		u1IRQCEC416:1;
    uint_io32_t		u1IRQCEC417:1;
    uint_io32_t		u1IRQCEC418:1;
    uint_io32_t		u1IRQCEC419:1;
    uint_io32_t		u1IRQCEC420:1;
    uint_io32_t		u1IRQCEC421:1;
    uint_io32_t		u1IRQCEC422:1;
    uint_io32_t		u1IRQCEC423:1;
    uint_io32_t		u1IRQCEC424:1;
    uint_io32_t		u1IRQCEC425:1;
    uint_io32_t		u1IRQCEC426:1;
    uint_io32_t		u1IRQCEC427:1;
    uint_io32_t		u1IRQCEC428:1;
    uint_io32_t		u1IRQCEC429:1;
    uint_io32_t		u1IRQCEC430:1;
    uint_io32_t		u1IRQCEC431:1;
    uint_io32_t		u1IRQCEC432:1;
    uint_io32_t		u1IRQCEC433:1;
    uint_io32_t		u1IRQCEC434:1;
    uint_io32_t		u1IRQCEC435:1;
    uint_io32_t		u1IRQCEC436:1;
    uint_io32_t		u1IRQCEC437:1;
    uint_io32_t		u1IRQCEC438:1;
    uint_io32_t		u1IRQCEC439:1;
    uint_io32_t		u1IRQCEC440:1;
    uint_io32_t		u1IRQCEC441:1;
    uint_io32_t		u1IRQCEC442:1;
    uint_io32_t		u1IRQCEC443:1;
    uint_io32_t		u1IRQCEC444:1;
    uint_io32_t		u1IRQCEC445:1;
    uint_io32_t		u1IRQCEC446:1;
    uint_io32_t		u1IRQCEC447:1;
}stc_irc0_irqcec13_field_t;

typedef union un_irc0_irqcec13{
    uint_io32_t		u32Register;
    stc_irc0_irqcec13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec13_t;

/* IRQCEC14 */
#define IRC0_IRQCEC14	(IRC0.unIRQCEC14.u32Register)  /*@rg@*/
#define IRC0_IRQCEC14_IRQCEC448	(IRC0.unIRQCEC14.stcField.u1IRQCEC448)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC449	(IRC0.unIRQCEC14.stcField.u1IRQCEC449)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC450	(IRC0.unIRQCEC14.stcField.u1IRQCEC450)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC451	(IRC0.unIRQCEC14.stcField.u1IRQCEC451)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC452	(IRC0.unIRQCEC14.stcField.u1IRQCEC452)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC453	(IRC0.unIRQCEC14.stcField.u1IRQCEC453)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC454	(IRC0.unIRQCEC14.stcField.u1IRQCEC454)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC455	(IRC0.unIRQCEC14.stcField.u1IRQCEC455)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC456	(IRC0.unIRQCEC14.stcField.u1IRQCEC456)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC457	(IRC0.unIRQCEC14.stcField.u1IRQCEC457)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC458	(IRC0.unIRQCEC14.stcField.u1IRQCEC458)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC459	(IRC0.unIRQCEC14.stcField.u1IRQCEC459)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC460	(IRC0.unIRQCEC14.stcField.u1IRQCEC460)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC461	(IRC0.unIRQCEC14.stcField.u1IRQCEC461)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC462	(IRC0.unIRQCEC14.stcField.u1IRQCEC462)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC463	(IRC0.unIRQCEC14.stcField.u1IRQCEC463)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC464	(IRC0.unIRQCEC14.stcField.u1IRQCEC464)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC465	(IRC0.unIRQCEC14.stcField.u1IRQCEC465)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC466	(IRC0.unIRQCEC14.stcField.u1IRQCEC466)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC467	(IRC0.unIRQCEC14.stcField.u1IRQCEC467)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC468	(IRC0.unIRQCEC14.stcField.u1IRQCEC468)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC469	(IRC0.unIRQCEC14.stcField.u1IRQCEC469)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC470	(IRC0.unIRQCEC14.stcField.u1IRQCEC470)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC471	(IRC0.unIRQCEC14.stcField.u1IRQCEC471)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC472	(IRC0.unIRQCEC14.stcField.u1IRQCEC472)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC473	(IRC0.unIRQCEC14.stcField.u1IRQCEC473)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC474	(IRC0.unIRQCEC14.stcField.u1IRQCEC474)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC475	(IRC0.unIRQCEC14.stcField.u1IRQCEC475)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC476	(IRC0.unIRQCEC14.stcField.u1IRQCEC476)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC477	(IRC0.unIRQCEC14.stcField.u1IRQCEC477)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC478	(IRC0.unIRQCEC14.stcField.u1IRQCEC478)  /*@bf@*/
#define IRC0_IRQCEC14_IRQCEC479	(IRC0.unIRQCEC14.stcField.u1IRQCEC479)  /*@bf@*/

typedef struct stc_irc0_irqcec14_field{
    uint_io32_t		u1IRQCEC448:1;
    uint_io32_t		u1IRQCEC449:1;
    uint_io32_t		u1IRQCEC450:1;
    uint_io32_t		u1IRQCEC451:1;
    uint_io32_t		u1IRQCEC452:1;
    uint_io32_t		u1IRQCEC453:1;
    uint_io32_t		u1IRQCEC454:1;
    uint_io32_t		u1IRQCEC455:1;
    uint_io32_t		u1IRQCEC456:1;
    uint_io32_t		u1IRQCEC457:1;
    uint_io32_t		u1IRQCEC458:1;
    uint_io32_t		u1IRQCEC459:1;
    uint_io32_t		u1IRQCEC460:1;
    uint_io32_t		u1IRQCEC461:1;
    uint_io32_t		u1IRQCEC462:1;
    uint_io32_t		u1IRQCEC463:1;
    uint_io32_t		u1IRQCEC464:1;
    uint_io32_t		u1IRQCEC465:1;
    uint_io32_t		u1IRQCEC466:1;
    uint_io32_t		u1IRQCEC467:1;
    uint_io32_t		u1IRQCEC468:1;
    uint_io32_t		u1IRQCEC469:1;
    uint_io32_t		u1IRQCEC470:1;
    uint_io32_t		u1IRQCEC471:1;
    uint_io32_t		u1IRQCEC472:1;
    uint_io32_t		u1IRQCEC473:1;
    uint_io32_t		u1IRQCEC474:1;
    uint_io32_t		u1IRQCEC475:1;
    uint_io32_t		u1IRQCEC476:1;
    uint_io32_t		u1IRQCEC477:1;
    uint_io32_t		u1IRQCEC478:1;
    uint_io32_t		u1IRQCEC479:1;
}stc_irc0_irqcec14_field_t;

typedef union un_irc0_irqcec14{
    uint_io32_t		u32Register;
    stc_irc0_irqcec14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec14_t;

/* IRQCEC15 */
#define IRC0_IRQCEC15	(IRC0.unIRQCEC15.u32Register)  /*@rg@*/
#define IRC0_IRQCEC15_IRQCEC480	(IRC0.unIRQCEC15.stcField.u1IRQCEC480)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC481	(IRC0.unIRQCEC15.stcField.u1IRQCEC481)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC482	(IRC0.unIRQCEC15.stcField.u1IRQCEC482)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC483	(IRC0.unIRQCEC15.stcField.u1IRQCEC483)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC484	(IRC0.unIRQCEC15.stcField.u1IRQCEC484)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC485	(IRC0.unIRQCEC15.stcField.u1IRQCEC485)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC486	(IRC0.unIRQCEC15.stcField.u1IRQCEC486)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC487	(IRC0.unIRQCEC15.stcField.u1IRQCEC487)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC488	(IRC0.unIRQCEC15.stcField.u1IRQCEC488)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC489	(IRC0.unIRQCEC15.stcField.u1IRQCEC489)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC490	(IRC0.unIRQCEC15.stcField.u1IRQCEC490)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC491	(IRC0.unIRQCEC15.stcField.u1IRQCEC491)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC492	(IRC0.unIRQCEC15.stcField.u1IRQCEC492)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC493	(IRC0.unIRQCEC15.stcField.u1IRQCEC493)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC494	(IRC0.unIRQCEC15.stcField.u1IRQCEC494)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC495	(IRC0.unIRQCEC15.stcField.u1IRQCEC495)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC496	(IRC0.unIRQCEC15.stcField.u1IRQCEC496)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC497	(IRC0.unIRQCEC15.stcField.u1IRQCEC497)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC498	(IRC0.unIRQCEC15.stcField.u1IRQCEC498)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC499	(IRC0.unIRQCEC15.stcField.u1IRQCEC499)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC500	(IRC0.unIRQCEC15.stcField.u1IRQCEC500)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC501	(IRC0.unIRQCEC15.stcField.u1IRQCEC501)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC502	(IRC0.unIRQCEC15.stcField.u1IRQCEC502)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC503	(IRC0.unIRQCEC15.stcField.u1IRQCEC503)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC504	(IRC0.unIRQCEC15.stcField.u1IRQCEC504)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC505	(IRC0.unIRQCEC15.stcField.u1IRQCEC505)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC506	(IRC0.unIRQCEC15.stcField.u1IRQCEC506)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC507	(IRC0.unIRQCEC15.stcField.u1IRQCEC507)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC508	(IRC0.unIRQCEC15.stcField.u1IRQCEC508)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC509	(IRC0.unIRQCEC15.stcField.u1IRQCEC509)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC510	(IRC0.unIRQCEC15.stcField.u1IRQCEC510)  /*@bf@*/
#define IRC0_IRQCEC15_IRQCEC511	(IRC0.unIRQCEC15.stcField.u1IRQCEC511)  /*@bf@*/

typedef struct stc_irc0_irqcec15_field{
    uint_io32_t		u1IRQCEC480:1;
    uint_io32_t		u1IRQCEC481:1;
    uint_io32_t		u1IRQCEC482:1;
    uint_io32_t		u1IRQCEC483:1;
    uint_io32_t		u1IRQCEC484:1;
    uint_io32_t		u1IRQCEC485:1;
    uint_io32_t		u1IRQCEC486:1;
    uint_io32_t		u1IRQCEC487:1;
    uint_io32_t		u1IRQCEC488:1;
    uint_io32_t		u1IRQCEC489:1;
    uint_io32_t		u1IRQCEC490:1;
    uint_io32_t		u1IRQCEC491:1;
    uint_io32_t		u1IRQCEC492:1;
    uint_io32_t		u1IRQCEC493:1;
    uint_io32_t		u1IRQCEC494:1;
    uint_io32_t		u1IRQCEC495:1;
    uint_io32_t		u1IRQCEC496:1;
    uint_io32_t		u1IRQCEC497:1;
    uint_io32_t		u1IRQCEC498:1;
    uint_io32_t		u1IRQCEC499:1;
    uint_io32_t		u1IRQCEC500:1;
    uint_io32_t		u1IRQCEC501:1;
    uint_io32_t		u1IRQCEC502:1;
    uint_io32_t		u1IRQCEC503:1;
    uint_io32_t		u1IRQCEC504:1;
    uint_io32_t		u1IRQCEC505:1;
    uint_io32_t		u1IRQCEC506:1;
    uint_io32_t		u1IRQCEC507:1;
    uint_io32_t		u1IRQCEC508:1;
    uint_io32_t		u1IRQCEC509:1;
    uint_io32_t		u1IRQCEC510:1;
    uint_io32_t		u1IRQCEC511:1;
}stc_irc0_irqcec15_field_t;

typedef union un_irc0_irqcec15{
    uint_io32_t		u32Register;
    stc_irc0_irqcec15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqcec15_t;

/* IRQCE0 */
#define IRC0_IRQCE0	(IRC0.unIRQCE0.u32Register)  /*@rg@*/
#define IRC0_IRQCE0_IRQCE0	(IRC0.unIRQCE0.stcField.u1IRQCE0)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE1	(IRC0.unIRQCE0.stcField.u1IRQCE1)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE2	(IRC0.unIRQCE0.stcField.u1IRQCE2)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE3	(IRC0.unIRQCE0.stcField.u1IRQCE3)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE4	(IRC0.unIRQCE0.stcField.u1IRQCE4)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE5	(IRC0.unIRQCE0.stcField.u1IRQCE5)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE6	(IRC0.unIRQCE0.stcField.u1IRQCE6)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE7	(IRC0.unIRQCE0.stcField.u1IRQCE7)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE8	(IRC0.unIRQCE0.stcField.u1IRQCE8)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE9	(IRC0.unIRQCE0.stcField.u1IRQCE9)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE10	(IRC0.unIRQCE0.stcField.u1IRQCE10)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE11	(IRC0.unIRQCE0.stcField.u1IRQCE11)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE12	(IRC0.unIRQCE0.stcField.u1IRQCE12)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE13	(IRC0.unIRQCE0.stcField.u1IRQCE13)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE14	(IRC0.unIRQCE0.stcField.u1IRQCE14)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE15	(IRC0.unIRQCE0.stcField.u1IRQCE15)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE16	(IRC0.unIRQCE0.stcField.u1IRQCE16)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE17	(IRC0.unIRQCE0.stcField.u1IRQCE17)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE18	(IRC0.unIRQCE0.stcField.u1IRQCE18)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE19	(IRC0.unIRQCE0.stcField.u1IRQCE19)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE20	(IRC0.unIRQCE0.stcField.u1IRQCE20)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE21	(IRC0.unIRQCE0.stcField.u1IRQCE21)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE22	(IRC0.unIRQCE0.stcField.u1IRQCE22)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE23	(IRC0.unIRQCE0.stcField.u1IRQCE23)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE24	(IRC0.unIRQCE0.stcField.u1IRQCE24)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE25	(IRC0.unIRQCE0.stcField.u1IRQCE25)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE26	(IRC0.unIRQCE0.stcField.u1IRQCE26)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE27	(IRC0.unIRQCE0.stcField.u1IRQCE27)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE28	(IRC0.unIRQCE0.stcField.u1IRQCE28)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE29	(IRC0.unIRQCE0.stcField.u1IRQCE29)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE30	(IRC0.unIRQCE0.stcField.u1IRQCE30)  /*@bf@*/
#define IRC0_IRQCE0_IRQCE31	(IRC0.unIRQCE0.stcField.u1IRQCE31)  /*@bf@*/

typedef struct stc_irc0_irqce0_field{
    uint_io32_t		u1IRQCE0:1;
    uint_io32_t		u1IRQCE1:1;
    uint_io32_t		u1IRQCE2:1;
    uint_io32_t		u1IRQCE3:1;
    uint_io32_t		u1IRQCE4:1;
    uint_io32_t		u1IRQCE5:1;
    uint_io32_t		u1IRQCE6:1;
    uint_io32_t		u1IRQCE7:1;
    uint_io32_t		u1IRQCE8:1;
    uint_io32_t		u1IRQCE9:1;
    uint_io32_t		u1IRQCE10:1;
    uint_io32_t		u1IRQCE11:1;
    uint_io32_t		u1IRQCE12:1;
    uint_io32_t		u1IRQCE13:1;
    uint_io32_t		u1IRQCE14:1;
    uint_io32_t		u1IRQCE15:1;
    uint_io32_t		u1IRQCE16:1;
    uint_io32_t		u1IRQCE17:1;
    uint_io32_t		u1IRQCE18:1;
    uint_io32_t		u1IRQCE19:1;
    uint_io32_t		u1IRQCE20:1;
    uint_io32_t		u1IRQCE21:1;
    uint_io32_t		u1IRQCE22:1;
    uint_io32_t		u1IRQCE23:1;
    uint_io32_t		u1IRQCE24:1;
    uint_io32_t		u1IRQCE25:1;
    uint_io32_t		u1IRQCE26:1;
    uint_io32_t		u1IRQCE27:1;
    uint_io32_t		u1IRQCE28:1;
    uint_io32_t		u1IRQCE29:1;
    uint_io32_t		u1IRQCE30:1;
    uint_io32_t		u1IRQCE31:1;
}stc_irc0_irqce0_field_t;

typedef union un_irc0_irqce0{
    uint_io32_t		u32Register;
    stc_irc0_irqce0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce0_t;

/* IRQCE1 */
#define IRC0_IRQCE1	(IRC0.unIRQCE1.u32Register)  /*@rg@*/
#define IRC0_IRQCE1_IRQCE32	(IRC0.unIRQCE1.stcField.u1IRQCE32)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE33	(IRC0.unIRQCE1.stcField.u1IRQCE33)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE34	(IRC0.unIRQCE1.stcField.u1IRQCE34)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE35	(IRC0.unIRQCE1.stcField.u1IRQCE35)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE36	(IRC0.unIRQCE1.stcField.u1IRQCE36)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE37	(IRC0.unIRQCE1.stcField.u1IRQCE37)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE38	(IRC0.unIRQCE1.stcField.u1IRQCE38)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE39	(IRC0.unIRQCE1.stcField.u1IRQCE39)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE40	(IRC0.unIRQCE1.stcField.u1IRQCE40)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE41	(IRC0.unIRQCE1.stcField.u1IRQCE41)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE42	(IRC0.unIRQCE1.stcField.u1IRQCE42)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE43	(IRC0.unIRQCE1.stcField.u1IRQCE43)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE44	(IRC0.unIRQCE1.stcField.u1IRQCE44)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE45	(IRC0.unIRQCE1.stcField.u1IRQCE45)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE46	(IRC0.unIRQCE1.stcField.u1IRQCE46)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE47	(IRC0.unIRQCE1.stcField.u1IRQCE47)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE48	(IRC0.unIRQCE1.stcField.u1IRQCE48)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE49	(IRC0.unIRQCE1.stcField.u1IRQCE49)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE50	(IRC0.unIRQCE1.stcField.u1IRQCE50)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE51	(IRC0.unIRQCE1.stcField.u1IRQCE51)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE52	(IRC0.unIRQCE1.stcField.u1IRQCE52)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE53	(IRC0.unIRQCE1.stcField.u1IRQCE53)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE54	(IRC0.unIRQCE1.stcField.u1IRQCE54)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE55	(IRC0.unIRQCE1.stcField.u1IRQCE55)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE56	(IRC0.unIRQCE1.stcField.u1IRQCE56)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE57	(IRC0.unIRQCE1.stcField.u1IRQCE57)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE58	(IRC0.unIRQCE1.stcField.u1IRQCE58)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE59	(IRC0.unIRQCE1.stcField.u1IRQCE59)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE60	(IRC0.unIRQCE1.stcField.u1IRQCE60)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE61	(IRC0.unIRQCE1.stcField.u1IRQCE61)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE62	(IRC0.unIRQCE1.stcField.u1IRQCE62)  /*@bf@*/
#define IRC0_IRQCE1_IRQCE63	(IRC0.unIRQCE1.stcField.u1IRQCE63)  /*@bf@*/

typedef struct stc_irc0_irqce1_field{
    uint_io32_t		u1IRQCE32:1;
    uint_io32_t		u1IRQCE33:1;
    uint_io32_t		u1IRQCE34:1;
    uint_io32_t		u1IRQCE35:1;
    uint_io32_t		u1IRQCE36:1;
    uint_io32_t		u1IRQCE37:1;
    uint_io32_t		u1IRQCE38:1;
    uint_io32_t		u1IRQCE39:1;
    uint_io32_t		u1IRQCE40:1;
    uint_io32_t		u1IRQCE41:1;
    uint_io32_t		u1IRQCE42:1;
    uint_io32_t		u1IRQCE43:1;
    uint_io32_t		u1IRQCE44:1;
    uint_io32_t		u1IRQCE45:1;
    uint_io32_t		u1IRQCE46:1;
    uint_io32_t		u1IRQCE47:1;
    uint_io32_t		u1IRQCE48:1;
    uint_io32_t		u1IRQCE49:1;
    uint_io32_t		u1IRQCE50:1;
    uint_io32_t		u1IRQCE51:1;
    uint_io32_t		u1IRQCE52:1;
    uint_io32_t		u1IRQCE53:1;
    uint_io32_t		u1IRQCE54:1;
    uint_io32_t		u1IRQCE55:1;
    uint_io32_t		u1IRQCE56:1;
    uint_io32_t		u1IRQCE57:1;
    uint_io32_t		u1IRQCE58:1;
    uint_io32_t		u1IRQCE59:1;
    uint_io32_t		u1IRQCE60:1;
    uint_io32_t		u1IRQCE61:1;
    uint_io32_t		u1IRQCE62:1;
    uint_io32_t		u1IRQCE63:1;
}stc_irc0_irqce1_field_t;

typedef union un_irc0_irqce1{
    uint_io32_t		u32Register;
    stc_irc0_irqce1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce1_t;

/* IRQCE2 */
#define IRC0_IRQCE2	(IRC0.unIRQCE2.u32Register)  /*@rg@*/
#define IRC0_IRQCE2_IRQCE64	(IRC0.unIRQCE2.stcField.u1IRQCE64)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE65	(IRC0.unIRQCE2.stcField.u1IRQCE65)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE66	(IRC0.unIRQCE2.stcField.u1IRQCE66)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE67	(IRC0.unIRQCE2.stcField.u1IRQCE67)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE68	(IRC0.unIRQCE2.stcField.u1IRQCE68)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE69	(IRC0.unIRQCE2.stcField.u1IRQCE69)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE70	(IRC0.unIRQCE2.stcField.u1IRQCE70)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE71	(IRC0.unIRQCE2.stcField.u1IRQCE71)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE72	(IRC0.unIRQCE2.stcField.u1IRQCE72)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE73	(IRC0.unIRQCE2.stcField.u1IRQCE73)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE74	(IRC0.unIRQCE2.stcField.u1IRQCE74)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE75	(IRC0.unIRQCE2.stcField.u1IRQCE75)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE76	(IRC0.unIRQCE2.stcField.u1IRQCE76)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE77	(IRC0.unIRQCE2.stcField.u1IRQCE77)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE78	(IRC0.unIRQCE2.stcField.u1IRQCE78)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE79	(IRC0.unIRQCE2.stcField.u1IRQCE79)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE80	(IRC0.unIRQCE2.stcField.u1IRQCE80)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE81	(IRC0.unIRQCE2.stcField.u1IRQCE81)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE82	(IRC0.unIRQCE2.stcField.u1IRQCE82)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE83	(IRC0.unIRQCE2.stcField.u1IRQCE83)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE84	(IRC0.unIRQCE2.stcField.u1IRQCE84)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE85	(IRC0.unIRQCE2.stcField.u1IRQCE85)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE86	(IRC0.unIRQCE2.stcField.u1IRQCE86)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE87	(IRC0.unIRQCE2.stcField.u1IRQCE87)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE88	(IRC0.unIRQCE2.stcField.u1IRQCE88)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE89	(IRC0.unIRQCE2.stcField.u1IRQCE89)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE90	(IRC0.unIRQCE2.stcField.u1IRQCE90)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE91	(IRC0.unIRQCE2.stcField.u1IRQCE91)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE92	(IRC0.unIRQCE2.stcField.u1IRQCE92)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE93	(IRC0.unIRQCE2.stcField.u1IRQCE93)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE94	(IRC0.unIRQCE2.stcField.u1IRQCE94)  /*@bf@*/
#define IRC0_IRQCE2_IRQCE95	(IRC0.unIRQCE2.stcField.u1IRQCE95)  /*@bf@*/

typedef struct stc_irc0_irqce2_field{
    uint_io32_t		u1IRQCE64:1;
    uint_io32_t		u1IRQCE65:1;
    uint_io32_t		u1IRQCE66:1;
    uint_io32_t		u1IRQCE67:1;
    uint_io32_t		u1IRQCE68:1;
    uint_io32_t		u1IRQCE69:1;
    uint_io32_t		u1IRQCE70:1;
    uint_io32_t		u1IRQCE71:1;
    uint_io32_t		u1IRQCE72:1;
    uint_io32_t		u1IRQCE73:1;
    uint_io32_t		u1IRQCE74:1;
    uint_io32_t		u1IRQCE75:1;
    uint_io32_t		u1IRQCE76:1;
    uint_io32_t		u1IRQCE77:1;
    uint_io32_t		u1IRQCE78:1;
    uint_io32_t		u1IRQCE79:1;
    uint_io32_t		u1IRQCE80:1;
    uint_io32_t		u1IRQCE81:1;
    uint_io32_t		u1IRQCE82:1;
    uint_io32_t		u1IRQCE83:1;
    uint_io32_t		u1IRQCE84:1;
    uint_io32_t		u1IRQCE85:1;
    uint_io32_t		u1IRQCE86:1;
    uint_io32_t		u1IRQCE87:1;
    uint_io32_t		u1IRQCE88:1;
    uint_io32_t		u1IRQCE89:1;
    uint_io32_t		u1IRQCE90:1;
    uint_io32_t		u1IRQCE91:1;
    uint_io32_t		u1IRQCE92:1;
    uint_io32_t		u1IRQCE93:1;
    uint_io32_t		u1IRQCE94:1;
    uint_io32_t		u1IRQCE95:1;
}stc_irc0_irqce2_field_t;

typedef union un_irc0_irqce2{
    uint_io32_t		u32Register;
    stc_irc0_irqce2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce2_t;

/* IRQCE3 */
#define IRC0_IRQCE3	(IRC0.unIRQCE3.u32Register)  /*@rg@*/
#define IRC0_IRQCE3_IRQCE96	(IRC0.unIRQCE3.stcField.u1IRQCE96)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE97	(IRC0.unIRQCE3.stcField.u1IRQCE97)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE98	(IRC0.unIRQCE3.stcField.u1IRQCE98)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE99	(IRC0.unIRQCE3.stcField.u1IRQCE99)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE100	(IRC0.unIRQCE3.stcField.u1IRQCE100)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE101	(IRC0.unIRQCE3.stcField.u1IRQCE101)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE102	(IRC0.unIRQCE3.stcField.u1IRQCE102)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE103	(IRC0.unIRQCE3.stcField.u1IRQCE103)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE104	(IRC0.unIRQCE3.stcField.u1IRQCE104)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE105	(IRC0.unIRQCE3.stcField.u1IRQCE105)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE106	(IRC0.unIRQCE3.stcField.u1IRQCE106)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE107	(IRC0.unIRQCE3.stcField.u1IRQCE107)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE108	(IRC0.unIRQCE3.stcField.u1IRQCE108)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE109	(IRC0.unIRQCE3.stcField.u1IRQCE109)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE110	(IRC0.unIRQCE3.stcField.u1IRQCE110)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE111	(IRC0.unIRQCE3.stcField.u1IRQCE111)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE112	(IRC0.unIRQCE3.stcField.u1IRQCE112)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE113	(IRC0.unIRQCE3.stcField.u1IRQCE113)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE114	(IRC0.unIRQCE3.stcField.u1IRQCE114)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE115	(IRC0.unIRQCE3.stcField.u1IRQCE115)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE116	(IRC0.unIRQCE3.stcField.u1IRQCE116)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE117	(IRC0.unIRQCE3.stcField.u1IRQCE117)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE118	(IRC0.unIRQCE3.stcField.u1IRQCE118)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE119	(IRC0.unIRQCE3.stcField.u1IRQCE119)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE120	(IRC0.unIRQCE3.stcField.u1IRQCE120)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE121	(IRC0.unIRQCE3.stcField.u1IRQCE121)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE122	(IRC0.unIRQCE3.stcField.u1IRQCE122)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE123	(IRC0.unIRQCE3.stcField.u1IRQCE123)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE124	(IRC0.unIRQCE3.stcField.u1IRQCE124)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE125	(IRC0.unIRQCE3.stcField.u1IRQCE125)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE126	(IRC0.unIRQCE3.stcField.u1IRQCE126)  /*@bf@*/
#define IRC0_IRQCE3_IRQCE127	(IRC0.unIRQCE3.stcField.u1IRQCE127)  /*@bf@*/

typedef struct stc_irc0_irqce3_field{
    uint_io32_t		u1IRQCE96:1;
    uint_io32_t		u1IRQCE97:1;
    uint_io32_t		u1IRQCE98:1;
    uint_io32_t		u1IRQCE99:1;
    uint_io32_t		u1IRQCE100:1;
    uint_io32_t		u1IRQCE101:1;
    uint_io32_t		u1IRQCE102:1;
    uint_io32_t		u1IRQCE103:1;
    uint_io32_t		u1IRQCE104:1;
    uint_io32_t		u1IRQCE105:1;
    uint_io32_t		u1IRQCE106:1;
    uint_io32_t		u1IRQCE107:1;
    uint_io32_t		u1IRQCE108:1;
    uint_io32_t		u1IRQCE109:1;
    uint_io32_t		u1IRQCE110:1;
    uint_io32_t		u1IRQCE111:1;
    uint_io32_t		u1IRQCE112:1;
    uint_io32_t		u1IRQCE113:1;
    uint_io32_t		u1IRQCE114:1;
    uint_io32_t		u1IRQCE115:1;
    uint_io32_t		u1IRQCE116:1;
    uint_io32_t		u1IRQCE117:1;
    uint_io32_t		u1IRQCE118:1;
    uint_io32_t		u1IRQCE119:1;
    uint_io32_t		u1IRQCE120:1;
    uint_io32_t		u1IRQCE121:1;
    uint_io32_t		u1IRQCE122:1;
    uint_io32_t		u1IRQCE123:1;
    uint_io32_t		u1IRQCE124:1;
    uint_io32_t		u1IRQCE125:1;
    uint_io32_t		u1IRQCE126:1;
    uint_io32_t		u1IRQCE127:1;
}stc_irc0_irqce3_field_t;

typedef union un_irc0_irqce3{
    uint_io32_t		u32Register;
    stc_irc0_irqce3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce3_t;

/* IRQCE4 */
#define IRC0_IRQCE4	(IRC0.unIRQCE4.u32Register)  /*@rg@*/
#define IRC0_IRQCE4_IRQCE128	(IRC0.unIRQCE4.stcField.u1IRQCE128)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE129	(IRC0.unIRQCE4.stcField.u1IRQCE129)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE130	(IRC0.unIRQCE4.stcField.u1IRQCE130)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE131	(IRC0.unIRQCE4.stcField.u1IRQCE131)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE132	(IRC0.unIRQCE4.stcField.u1IRQCE132)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE133	(IRC0.unIRQCE4.stcField.u1IRQCE133)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE134	(IRC0.unIRQCE4.stcField.u1IRQCE134)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE135	(IRC0.unIRQCE4.stcField.u1IRQCE135)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE136	(IRC0.unIRQCE4.stcField.u1IRQCE136)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE137	(IRC0.unIRQCE4.stcField.u1IRQCE137)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE138	(IRC0.unIRQCE4.stcField.u1IRQCE138)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE139	(IRC0.unIRQCE4.stcField.u1IRQCE139)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE140	(IRC0.unIRQCE4.stcField.u1IRQCE140)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE141	(IRC0.unIRQCE4.stcField.u1IRQCE141)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE142	(IRC0.unIRQCE4.stcField.u1IRQCE142)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE143	(IRC0.unIRQCE4.stcField.u1IRQCE143)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE144	(IRC0.unIRQCE4.stcField.u1IRQCE144)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE145	(IRC0.unIRQCE4.stcField.u1IRQCE145)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE146	(IRC0.unIRQCE4.stcField.u1IRQCE146)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE147	(IRC0.unIRQCE4.stcField.u1IRQCE147)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE148	(IRC0.unIRQCE4.stcField.u1IRQCE148)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE149	(IRC0.unIRQCE4.stcField.u1IRQCE149)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE150	(IRC0.unIRQCE4.stcField.u1IRQCE150)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE151	(IRC0.unIRQCE4.stcField.u1IRQCE151)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE152	(IRC0.unIRQCE4.stcField.u1IRQCE152)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE153	(IRC0.unIRQCE4.stcField.u1IRQCE153)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE154	(IRC0.unIRQCE4.stcField.u1IRQCE154)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE155	(IRC0.unIRQCE4.stcField.u1IRQCE155)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE156	(IRC0.unIRQCE4.stcField.u1IRQCE156)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE157	(IRC0.unIRQCE4.stcField.u1IRQCE157)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE158	(IRC0.unIRQCE4.stcField.u1IRQCE158)  /*@bf@*/
#define IRC0_IRQCE4_IRQCE159	(IRC0.unIRQCE4.stcField.u1IRQCE159)  /*@bf@*/

typedef struct stc_irc0_irqce4_field{
    uint_io32_t		u1IRQCE128:1;
    uint_io32_t		u1IRQCE129:1;
    uint_io32_t		u1IRQCE130:1;
    uint_io32_t		u1IRQCE131:1;
    uint_io32_t		u1IRQCE132:1;
    uint_io32_t		u1IRQCE133:1;
    uint_io32_t		u1IRQCE134:1;
    uint_io32_t		u1IRQCE135:1;
    uint_io32_t		u1IRQCE136:1;
    uint_io32_t		u1IRQCE137:1;
    uint_io32_t		u1IRQCE138:1;
    uint_io32_t		u1IRQCE139:1;
    uint_io32_t		u1IRQCE140:1;
    uint_io32_t		u1IRQCE141:1;
    uint_io32_t		u1IRQCE142:1;
    uint_io32_t		u1IRQCE143:1;
    uint_io32_t		u1IRQCE144:1;
    uint_io32_t		u1IRQCE145:1;
    uint_io32_t		u1IRQCE146:1;
    uint_io32_t		u1IRQCE147:1;
    uint_io32_t		u1IRQCE148:1;
    uint_io32_t		u1IRQCE149:1;
    uint_io32_t		u1IRQCE150:1;
    uint_io32_t		u1IRQCE151:1;
    uint_io32_t		u1IRQCE152:1;
    uint_io32_t		u1IRQCE153:1;
    uint_io32_t		u1IRQCE154:1;
    uint_io32_t		u1IRQCE155:1;
    uint_io32_t		u1IRQCE156:1;
    uint_io32_t		u1IRQCE157:1;
    uint_io32_t		u1IRQCE158:1;
    uint_io32_t		u1IRQCE159:1;
}stc_irc0_irqce4_field_t;

typedef union un_irc0_irqce4{
    uint_io32_t		u32Register;
    stc_irc0_irqce4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce4_t;

/* IRQCE5 */
#define IRC0_IRQCE5	(IRC0.unIRQCE5.u32Register)  /*@rg@*/
#define IRC0_IRQCE5_IRQCE160	(IRC0.unIRQCE5.stcField.u1IRQCE160)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE161	(IRC0.unIRQCE5.stcField.u1IRQCE161)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE162	(IRC0.unIRQCE5.stcField.u1IRQCE162)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE163	(IRC0.unIRQCE5.stcField.u1IRQCE163)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE164	(IRC0.unIRQCE5.stcField.u1IRQCE164)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE165	(IRC0.unIRQCE5.stcField.u1IRQCE165)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE166	(IRC0.unIRQCE5.stcField.u1IRQCE166)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE167	(IRC0.unIRQCE5.stcField.u1IRQCE167)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE168	(IRC0.unIRQCE5.stcField.u1IRQCE168)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE169	(IRC0.unIRQCE5.stcField.u1IRQCE169)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE170	(IRC0.unIRQCE5.stcField.u1IRQCE170)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE171	(IRC0.unIRQCE5.stcField.u1IRQCE171)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE172	(IRC0.unIRQCE5.stcField.u1IRQCE172)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE173	(IRC0.unIRQCE5.stcField.u1IRQCE173)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE174	(IRC0.unIRQCE5.stcField.u1IRQCE174)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE175	(IRC0.unIRQCE5.stcField.u1IRQCE175)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE176	(IRC0.unIRQCE5.stcField.u1IRQCE176)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE177	(IRC0.unIRQCE5.stcField.u1IRQCE177)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE178	(IRC0.unIRQCE5.stcField.u1IRQCE178)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE179	(IRC0.unIRQCE5.stcField.u1IRQCE179)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE180	(IRC0.unIRQCE5.stcField.u1IRQCE180)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE181	(IRC0.unIRQCE5.stcField.u1IRQCE181)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE182	(IRC0.unIRQCE5.stcField.u1IRQCE182)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE183	(IRC0.unIRQCE5.stcField.u1IRQCE183)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE184	(IRC0.unIRQCE5.stcField.u1IRQCE184)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE185	(IRC0.unIRQCE5.stcField.u1IRQCE185)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE186	(IRC0.unIRQCE5.stcField.u1IRQCE186)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE187	(IRC0.unIRQCE5.stcField.u1IRQCE187)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE188	(IRC0.unIRQCE5.stcField.u1IRQCE188)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE189	(IRC0.unIRQCE5.stcField.u1IRQCE189)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE190	(IRC0.unIRQCE5.stcField.u1IRQCE190)  /*@bf@*/
#define IRC0_IRQCE5_IRQCE191	(IRC0.unIRQCE5.stcField.u1IRQCE191)  /*@bf@*/

typedef struct stc_irc0_irqce5_field{
    uint_io32_t		u1IRQCE160:1;
    uint_io32_t		u1IRQCE161:1;
    uint_io32_t		u1IRQCE162:1;
    uint_io32_t		u1IRQCE163:1;
    uint_io32_t		u1IRQCE164:1;
    uint_io32_t		u1IRQCE165:1;
    uint_io32_t		u1IRQCE166:1;
    uint_io32_t		u1IRQCE167:1;
    uint_io32_t		u1IRQCE168:1;
    uint_io32_t		u1IRQCE169:1;
    uint_io32_t		u1IRQCE170:1;
    uint_io32_t		u1IRQCE171:1;
    uint_io32_t		u1IRQCE172:1;
    uint_io32_t		u1IRQCE173:1;
    uint_io32_t		u1IRQCE174:1;
    uint_io32_t		u1IRQCE175:1;
    uint_io32_t		u1IRQCE176:1;
    uint_io32_t		u1IRQCE177:1;
    uint_io32_t		u1IRQCE178:1;
    uint_io32_t		u1IRQCE179:1;
    uint_io32_t		u1IRQCE180:1;
    uint_io32_t		u1IRQCE181:1;
    uint_io32_t		u1IRQCE182:1;
    uint_io32_t		u1IRQCE183:1;
    uint_io32_t		u1IRQCE184:1;
    uint_io32_t		u1IRQCE185:1;
    uint_io32_t		u1IRQCE186:1;
    uint_io32_t		u1IRQCE187:1;
    uint_io32_t		u1IRQCE188:1;
    uint_io32_t		u1IRQCE189:1;
    uint_io32_t		u1IRQCE190:1;
    uint_io32_t		u1IRQCE191:1;
}stc_irc0_irqce5_field_t;

typedef union un_irc0_irqce5{
    uint_io32_t		u32Register;
    stc_irc0_irqce5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce5_t;

/* IRQCE6 */
#define IRC0_IRQCE6	(IRC0.unIRQCE6.u32Register)  /*@rg@*/
#define IRC0_IRQCE6_IRQCE192	(IRC0.unIRQCE6.stcField.u1IRQCE192)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE193	(IRC0.unIRQCE6.stcField.u1IRQCE193)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE194	(IRC0.unIRQCE6.stcField.u1IRQCE194)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE195	(IRC0.unIRQCE6.stcField.u1IRQCE195)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE196	(IRC0.unIRQCE6.stcField.u1IRQCE196)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE197	(IRC0.unIRQCE6.stcField.u1IRQCE197)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE198	(IRC0.unIRQCE6.stcField.u1IRQCE198)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE199	(IRC0.unIRQCE6.stcField.u1IRQCE199)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE200	(IRC0.unIRQCE6.stcField.u1IRQCE200)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE201	(IRC0.unIRQCE6.stcField.u1IRQCE201)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE202	(IRC0.unIRQCE6.stcField.u1IRQCE202)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE203	(IRC0.unIRQCE6.stcField.u1IRQCE203)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE204	(IRC0.unIRQCE6.stcField.u1IRQCE204)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE205	(IRC0.unIRQCE6.stcField.u1IRQCE205)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE206	(IRC0.unIRQCE6.stcField.u1IRQCE206)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE207	(IRC0.unIRQCE6.stcField.u1IRQCE207)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE208	(IRC0.unIRQCE6.stcField.u1IRQCE208)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE209	(IRC0.unIRQCE6.stcField.u1IRQCE209)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE210	(IRC0.unIRQCE6.stcField.u1IRQCE210)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE211	(IRC0.unIRQCE6.stcField.u1IRQCE211)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE212	(IRC0.unIRQCE6.stcField.u1IRQCE212)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE213	(IRC0.unIRQCE6.stcField.u1IRQCE213)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE214	(IRC0.unIRQCE6.stcField.u1IRQCE214)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE215	(IRC0.unIRQCE6.stcField.u1IRQCE215)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE216	(IRC0.unIRQCE6.stcField.u1IRQCE216)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE217	(IRC0.unIRQCE6.stcField.u1IRQCE217)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE218	(IRC0.unIRQCE6.stcField.u1IRQCE218)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE219	(IRC0.unIRQCE6.stcField.u1IRQCE219)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE220	(IRC0.unIRQCE6.stcField.u1IRQCE220)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE221	(IRC0.unIRQCE6.stcField.u1IRQCE221)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE222	(IRC0.unIRQCE6.stcField.u1IRQCE222)  /*@bf@*/
#define IRC0_IRQCE6_IRQCE223	(IRC0.unIRQCE6.stcField.u1IRQCE223)  /*@bf@*/

typedef struct stc_irc0_irqce6_field{
    uint_io32_t		u1IRQCE192:1;
    uint_io32_t		u1IRQCE193:1;
    uint_io32_t		u1IRQCE194:1;
    uint_io32_t		u1IRQCE195:1;
    uint_io32_t		u1IRQCE196:1;
    uint_io32_t		u1IRQCE197:1;
    uint_io32_t		u1IRQCE198:1;
    uint_io32_t		u1IRQCE199:1;
    uint_io32_t		u1IRQCE200:1;
    uint_io32_t		u1IRQCE201:1;
    uint_io32_t		u1IRQCE202:1;
    uint_io32_t		u1IRQCE203:1;
    uint_io32_t		u1IRQCE204:1;
    uint_io32_t		u1IRQCE205:1;
    uint_io32_t		u1IRQCE206:1;
    uint_io32_t		u1IRQCE207:1;
    uint_io32_t		u1IRQCE208:1;
    uint_io32_t		u1IRQCE209:1;
    uint_io32_t		u1IRQCE210:1;
    uint_io32_t		u1IRQCE211:1;
    uint_io32_t		u1IRQCE212:1;
    uint_io32_t		u1IRQCE213:1;
    uint_io32_t		u1IRQCE214:1;
    uint_io32_t		u1IRQCE215:1;
    uint_io32_t		u1IRQCE216:1;
    uint_io32_t		u1IRQCE217:1;
    uint_io32_t		u1IRQCE218:1;
    uint_io32_t		u1IRQCE219:1;
    uint_io32_t		u1IRQCE220:1;
    uint_io32_t		u1IRQCE221:1;
    uint_io32_t		u1IRQCE222:1;
    uint_io32_t		u1IRQCE223:1;
}stc_irc0_irqce6_field_t;

typedef union un_irc0_irqce6{
    uint_io32_t		u32Register;
    stc_irc0_irqce6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce6_t;

/* IRQCE7 */
#define IRC0_IRQCE7	(IRC0.unIRQCE7.u32Register)  /*@rg@*/
#define IRC0_IRQCE7_IRQCE224	(IRC0.unIRQCE7.stcField.u1IRQCE224)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE225	(IRC0.unIRQCE7.stcField.u1IRQCE225)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE226	(IRC0.unIRQCE7.stcField.u1IRQCE226)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE227	(IRC0.unIRQCE7.stcField.u1IRQCE227)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE228	(IRC0.unIRQCE7.stcField.u1IRQCE228)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE229	(IRC0.unIRQCE7.stcField.u1IRQCE229)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE230	(IRC0.unIRQCE7.stcField.u1IRQCE230)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE231	(IRC0.unIRQCE7.stcField.u1IRQCE231)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE232	(IRC0.unIRQCE7.stcField.u1IRQCE232)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE233	(IRC0.unIRQCE7.stcField.u1IRQCE233)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE234	(IRC0.unIRQCE7.stcField.u1IRQCE234)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE235	(IRC0.unIRQCE7.stcField.u1IRQCE235)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE236	(IRC0.unIRQCE7.stcField.u1IRQCE236)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE237	(IRC0.unIRQCE7.stcField.u1IRQCE237)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE238	(IRC0.unIRQCE7.stcField.u1IRQCE238)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE239	(IRC0.unIRQCE7.stcField.u1IRQCE239)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE240	(IRC0.unIRQCE7.stcField.u1IRQCE240)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE241	(IRC0.unIRQCE7.stcField.u1IRQCE241)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE242	(IRC0.unIRQCE7.stcField.u1IRQCE242)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE243	(IRC0.unIRQCE7.stcField.u1IRQCE243)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE244	(IRC0.unIRQCE7.stcField.u1IRQCE244)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE245	(IRC0.unIRQCE7.stcField.u1IRQCE245)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE246	(IRC0.unIRQCE7.stcField.u1IRQCE246)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE247	(IRC0.unIRQCE7.stcField.u1IRQCE247)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE248	(IRC0.unIRQCE7.stcField.u1IRQCE248)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE249	(IRC0.unIRQCE7.stcField.u1IRQCE249)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE250	(IRC0.unIRQCE7.stcField.u1IRQCE250)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE251	(IRC0.unIRQCE7.stcField.u1IRQCE251)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE252	(IRC0.unIRQCE7.stcField.u1IRQCE252)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE253	(IRC0.unIRQCE7.stcField.u1IRQCE253)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE254	(IRC0.unIRQCE7.stcField.u1IRQCE254)  /*@bf@*/
#define IRC0_IRQCE7_IRQCE255	(IRC0.unIRQCE7.stcField.u1IRQCE255)  /*@bf@*/

typedef struct stc_irc0_irqce7_field{
    uint_io32_t		u1IRQCE224:1;
    uint_io32_t		u1IRQCE225:1;
    uint_io32_t		u1IRQCE226:1;
    uint_io32_t		u1IRQCE227:1;
    uint_io32_t		u1IRQCE228:1;
    uint_io32_t		u1IRQCE229:1;
    uint_io32_t		u1IRQCE230:1;
    uint_io32_t		u1IRQCE231:1;
    uint_io32_t		u1IRQCE232:1;
    uint_io32_t		u1IRQCE233:1;
    uint_io32_t		u1IRQCE234:1;
    uint_io32_t		u1IRQCE235:1;
    uint_io32_t		u1IRQCE236:1;
    uint_io32_t		u1IRQCE237:1;
    uint_io32_t		u1IRQCE238:1;
    uint_io32_t		u1IRQCE239:1;
    uint_io32_t		u1IRQCE240:1;
    uint_io32_t		u1IRQCE241:1;
    uint_io32_t		u1IRQCE242:1;
    uint_io32_t		u1IRQCE243:1;
    uint_io32_t		u1IRQCE244:1;
    uint_io32_t		u1IRQCE245:1;
    uint_io32_t		u1IRQCE246:1;
    uint_io32_t		u1IRQCE247:1;
    uint_io32_t		u1IRQCE248:1;
    uint_io32_t		u1IRQCE249:1;
    uint_io32_t		u1IRQCE250:1;
    uint_io32_t		u1IRQCE251:1;
    uint_io32_t		u1IRQCE252:1;
    uint_io32_t		u1IRQCE253:1;
    uint_io32_t		u1IRQCE254:1;
    uint_io32_t		u1IRQCE255:1;
}stc_irc0_irqce7_field_t;

typedef union un_irc0_irqce7{
    uint_io32_t		u32Register;
    stc_irc0_irqce7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce7_t;

/* IRQCE8 */
#define IRC0_IRQCE8	(IRC0.unIRQCE8.u32Register)  /*@rg@*/
#define IRC0_IRQCE8_IRQCE256	(IRC0.unIRQCE8.stcField.u1IRQCE256)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE257	(IRC0.unIRQCE8.stcField.u1IRQCE257)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE258	(IRC0.unIRQCE8.stcField.u1IRQCE258)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE259	(IRC0.unIRQCE8.stcField.u1IRQCE259)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE260	(IRC0.unIRQCE8.stcField.u1IRQCE260)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE261	(IRC0.unIRQCE8.stcField.u1IRQCE261)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE262	(IRC0.unIRQCE8.stcField.u1IRQCE262)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE263	(IRC0.unIRQCE8.stcField.u1IRQCE263)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE264	(IRC0.unIRQCE8.stcField.u1IRQCE264)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE265	(IRC0.unIRQCE8.stcField.u1IRQCE265)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE266	(IRC0.unIRQCE8.stcField.u1IRQCE266)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE267	(IRC0.unIRQCE8.stcField.u1IRQCE267)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE268	(IRC0.unIRQCE8.stcField.u1IRQCE268)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE269	(IRC0.unIRQCE8.stcField.u1IRQCE269)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE270	(IRC0.unIRQCE8.stcField.u1IRQCE270)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE271	(IRC0.unIRQCE8.stcField.u1IRQCE271)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE272	(IRC0.unIRQCE8.stcField.u1IRQCE272)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE273	(IRC0.unIRQCE8.stcField.u1IRQCE273)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE274	(IRC0.unIRQCE8.stcField.u1IRQCE274)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE275	(IRC0.unIRQCE8.stcField.u1IRQCE275)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE276	(IRC0.unIRQCE8.stcField.u1IRQCE276)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE277	(IRC0.unIRQCE8.stcField.u1IRQCE277)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE278	(IRC0.unIRQCE8.stcField.u1IRQCE278)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE279	(IRC0.unIRQCE8.stcField.u1IRQCE279)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE280	(IRC0.unIRQCE8.stcField.u1IRQCE280)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE281	(IRC0.unIRQCE8.stcField.u1IRQCE281)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE282	(IRC0.unIRQCE8.stcField.u1IRQCE282)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE283	(IRC0.unIRQCE8.stcField.u1IRQCE283)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE284	(IRC0.unIRQCE8.stcField.u1IRQCE284)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE285	(IRC0.unIRQCE8.stcField.u1IRQCE285)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE286	(IRC0.unIRQCE8.stcField.u1IRQCE286)  /*@bf@*/
#define IRC0_IRQCE8_IRQCE287	(IRC0.unIRQCE8.stcField.u1IRQCE287)  /*@bf@*/

typedef struct stc_irc0_irqce8_field{
    uint_io32_t		u1IRQCE256:1;
    uint_io32_t		u1IRQCE257:1;
    uint_io32_t		u1IRQCE258:1;
    uint_io32_t		u1IRQCE259:1;
    uint_io32_t		u1IRQCE260:1;
    uint_io32_t		u1IRQCE261:1;
    uint_io32_t		u1IRQCE262:1;
    uint_io32_t		u1IRQCE263:1;
    uint_io32_t		u1IRQCE264:1;
    uint_io32_t		u1IRQCE265:1;
    uint_io32_t		u1IRQCE266:1;
    uint_io32_t		u1IRQCE267:1;
    uint_io32_t		u1IRQCE268:1;
    uint_io32_t		u1IRQCE269:1;
    uint_io32_t		u1IRQCE270:1;
    uint_io32_t		u1IRQCE271:1;
    uint_io32_t		u1IRQCE272:1;
    uint_io32_t		u1IRQCE273:1;
    uint_io32_t		u1IRQCE274:1;
    uint_io32_t		u1IRQCE275:1;
    uint_io32_t		u1IRQCE276:1;
    uint_io32_t		u1IRQCE277:1;
    uint_io32_t		u1IRQCE278:1;
    uint_io32_t		u1IRQCE279:1;
    uint_io32_t		u1IRQCE280:1;
    uint_io32_t		u1IRQCE281:1;
    uint_io32_t		u1IRQCE282:1;
    uint_io32_t		u1IRQCE283:1;
    uint_io32_t		u1IRQCE284:1;
    uint_io32_t		u1IRQCE285:1;
    uint_io32_t		u1IRQCE286:1;
    uint_io32_t		u1IRQCE287:1;
}stc_irc0_irqce8_field_t;

typedef union un_irc0_irqce8{
    uint_io32_t		u32Register;
    stc_irc0_irqce8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce8_t;

/* IRQCE9 */
#define IRC0_IRQCE9	(IRC0.unIRQCE9.u32Register)  /*@rg@*/
#define IRC0_IRQCE9_IRQCE288	(IRC0.unIRQCE9.stcField.u1IRQCE288)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE289	(IRC0.unIRQCE9.stcField.u1IRQCE289)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE290	(IRC0.unIRQCE9.stcField.u1IRQCE290)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE291	(IRC0.unIRQCE9.stcField.u1IRQCE291)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE292	(IRC0.unIRQCE9.stcField.u1IRQCE292)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE293	(IRC0.unIRQCE9.stcField.u1IRQCE293)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE294	(IRC0.unIRQCE9.stcField.u1IRQCE294)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE295	(IRC0.unIRQCE9.stcField.u1IRQCE295)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE296	(IRC0.unIRQCE9.stcField.u1IRQCE296)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE297	(IRC0.unIRQCE9.stcField.u1IRQCE297)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE298	(IRC0.unIRQCE9.stcField.u1IRQCE298)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE299	(IRC0.unIRQCE9.stcField.u1IRQCE299)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE300	(IRC0.unIRQCE9.stcField.u1IRQCE300)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE301	(IRC0.unIRQCE9.stcField.u1IRQCE301)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE302	(IRC0.unIRQCE9.stcField.u1IRQCE302)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE303	(IRC0.unIRQCE9.stcField.u1IRQCE303)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE304	(IRC0.unIRQCE9.stcField.u1IRQCE304)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE305	(IRC0.unIRQCE9.stcField.u1IRQCE305)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE306	(IRC0.unIRQCE9.stcField.u1IRQCE306)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE307	(IRC0.unIRQCE9.stcField.u1IRQCE307)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE308	(IRC0.unIRQCE9.stcField.u1IRQCE308)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE309	(IRC0.unIRQCE9.stcField.u1IRQCE309)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE310	(IRC0.unIRQCE9.stcField.u1IRQCE310)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE311	(IRC0.unIRQCE9.stcField.u1IRQCE311)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE312	(IRC0.unIRQCE9.stcField.u1IRQCE312)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE313	(IRC0.unIRQCE9.stcField.u1IRQCE313)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE314	(IRC0.unIRQCE9.stcField.u1IRQCE314)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE315	(IRC0.unIRQCE9.stcField.u1IRQCE315)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE316	(IRC0.unIRQCE9.stcField.u1IRQCE316)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE317	(IRC0.unIRQCE9.stcField.u1IRQCE317)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE318	(IRC0.unIRQCE9.stcField.u1IRQCE318)  /*@bf@*/
#define IRC0_IRQCE9_IRQCE319	(IRC0.unIRQCE9.stcField.u1IRQCE319)  /*@bf@*/

typedef struct stc_irc0_irqce9_field{
    uint_io32_t		u1IRQCE288:1;
    uint_io32_t		u1IRQCE289:1;
    uint_io32_t		u1IRQCE290:1;
    uint_io32_t		u1IRQCE291:1;
    uint_io32_t		u1IRQCE292:1;
    uint_io32_t		u1IRQCE293:1;
    uint_io32_t		u1IRQCE294:1;
    uint_io32_t		u1IRQCE295:1;
    uint_io32_t		u1IRQCE296:1;
    uint_io32_t		u1IRQCE297:1;
    uint_io32_t		u1IRQCE298:1;
    uint_io32_t		u1IRQCE299:1;
    uint_io32_t		u1IRQCE300:1;
    uint_io32_t		u1IRQCE301:1;
    uint_io32_t		u1IRQCE302:1;
    uint_io32_t		u1IRQCE303:1;
    uint_io32_t		u1IRQCE304:1;
    uint_io32_t		u1IRQCE305:1;
    uint_io32_t		u1IRQCE306:1;
    uint_io32_t		u1IRQCE307:1;
    uint_io32_t		u1IRQCE308:1;
    uint_io32_t		u1IRQCE309:1;
    uint_io32_t		u1IRQCE310:1;
    uint_io32_t		u1IRQCE311:1;
    uint_io32_t		u1IRQCE312:1;
    uint_io32_t		u1IRQCE313:1;
    uint_io32_t		u1IRQCE314:1;
    uint_io32_t		u1IRQCE315:1;
    uint_io32_t		u1IRQCE316:1;
    uint_io32_t		u1IRQCE317:1;
    uint_io32_t		u1IRQCE318:1;
    uint_io32_t		u1IRQCE319:1;
}stc_irc0_irqce9_field_t;

typedef union un_irc0_irqce9{
    uint_io32_t		u32Register;
    stc_irc0_irqce9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce9_t;

/* IRQCE10 */
#define IRC0_IRQCE10	(IRC0.unIRQCE10.u32Register)  /*@rg@*/
#define IRC0_IRQCE10_IRQCE320	(IRC0.unIRQCE10.stcField.u1IRQCE320)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE321	(IRC0.unIRQCE10.stcField.u1IRQCE321)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE322	(IRC0.unIRQCE10.stcField.u1IRQCE322)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE323	(IRC0.unIRQCE10.stcField.u1IRQCE323)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE324	(IRC0.unIRQCE10.stcField.u1IRQCE324)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE325	(IRC0.unIRQCE10.stcField.u1IRQCE325)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE326	(IRC0.unIRQCE10.stcField.u1IRQCE326)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE327	(IRC0.unIRQCE10.stcField.u1IRQCE327)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE328	(IRC0.unIRQCE10.stcField.u1IRQCE328)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE329	(IRC0.unIRQCE10.stcField.u1IRQCE329)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE330	(IRC0.unIRQCE10.stcField.u1IRQCE330)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE331	(IRC0.unIRQCE10.stcField.u1IRQCE331)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE332	(IRC0.unIRQCE10.stcField.u1IRQCE332)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE333	(IRC0.unIRQCE10.stcField.u1IRQCE333)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE334	(IRC0.unIRQCE10.stcField.u1IRQCE334)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE335	(IRC0.unIRQCE10.stcField.u1IRQCE335)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE336	(IRC0.unIRQCE10.stcField.u1IRQCE336)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE337	(IRC0.unIRQCE10.stcField.u1IRQCE337)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE338	(IRC0.unIRQCE10.stcField.u1IRQCE338)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE339	(IRC0.unIRQCE10.stcField.u1IRQCE339)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE340	(IRC0.unIRQCE10.stcField.u1IRQCE340)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE341	(IRC0.unIRQCE10.stcField.u1IRQCE341)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE342	(IRC0.unIRQCE10.stcField.u1IRQCE342)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE343	(IRC0.unIRQCE10.stcField.u1IRQCE343)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE344	(IRC0.unIRQCE10.stcField.u1IRQCE344)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE345	(IRC0.unIRQCE10.stcField.u1IRQCE345)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE346	(IRC0.unIRQCE10.stcField.u1IRQCE346)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE347	(IRC0.unIRQCE10.stcField.u1IRQCE347)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE348	(IRC0.unIRQCE10.stcField.u1IRQCE348)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE349	(IRC0.unIRQCE10.stcField.u1IRQCE349)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE350	(IRC0.unIRQCE10.stcField.u1IRQCE350)  /*@bf@*/
#define IRC0_IRQCE10_IRQCE351	(IRC0.unIRQCE10.stcField.u1IRQCE351)  /*@bf@*/

typedef struct stc_irc0_irqce10_field{
    uint_io32_t		u1IRQCE320:1;
    uint_io32_t		u1IRQCE321:1;
    uint_io32_t		u1IRQCE322:1;
    uint_io32_t		u1IRQCE323:1;
    uint_io32_t		u1IRQCE324:1;
    uint_io32_t		u1IRQCE325:1;
    uint_io32_t		u1IRQCE326:1;
    uint_io32_t		u1IRQCE327:1;
    uint_io32_t		u1IRQCE328:1;
    uint_io32_t		u1IRQCE329:1;
    uint_io32_t		u1IRQCE330:1;
    uint_io32_t		u1IRQCE331:1;
    uint_io32_t		u1IRQCE332:1;
    uint_io32_t		u1IRQCE333:1;
    uint_io32_t		u1IRQCE334:1;
    uint_io32_t		u1IRQCE335:1;
    uint_io32_t		u1IRQCE336:1;
    uint_io32_t		u1IRQCE337:1;
    uint_io32_t		u1IRQCE338:1;
    uint_io32_t		u1IRQCE339:1;
    uint_io32_t		u1IRQCE340:1;
    uint_io32_t		u1IRQCE341:1;
    uint_io32_t		u1IRQCE342:1;
    uint_io32_t		u1IRQCE343:1;
    uint_io32_t		u1IRQCE344:1;
    uint_io32_t		u1IRQCE345:1;
    uint_io32_t		u1IRQCE346:1;
    uint_io32_t		u1IRQCE347:1;
    uint_io32_t		u1IRQCE348:1;
    uint_io32_t		u1IRQCE349:1;
    uint_io32_t		u1IRQCE350:1;
    uint_io32_t		u1IRQCE351:1;
}stc_irc0_irqce10_field_t;

typedef union un_irc0_irqce10{
    uint_io32_t		u32Register;
    stc_irc0_irqce10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce10_t;

/* IRQCE11 */
#define IRC0_IRQCE11	(IRC0.unIRQCE11.u32Register)  /*@rg@*/
#define IRC0_IRQCE11_IRQCE352	(IRC0.unIRQCE11.stcField.u1IRQCE352)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE353	(IRC0.unIRQCE11.stcField.u1IRQCE353)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE354	(IRC0.unIRQCE11.stcField.u1IRQCE354)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE355	(IRC0.unIRQCE11.stcField.u1IRQCE355)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE356	(IRC0.unIRQCE11.stcField.u1IRQCE356)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE357	(IRC0.unIRQCE11.stcField.u1IRQCE357)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE358	(IRC0.unIRQCE11.stcField.u1IRQCE358)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE359	(IRC0.unIRQCE11.stcField.u1IRQCE359)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE360	(IRC0.unIRQCE11.stcField.u1IRQCE360)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE361	(IRC0.unIRQCE11.stcField.u1IRQCE361)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE362	(IRC0.unIRQCE11.stcField.u1IRQCE362)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE363	(IRC0.unIRQCE11.stcField.u1IRQCE363)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE364	(IRC0.unIRQCE11.stcField.u1IRQCE364)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE365	(IRC0.unIRQCE11.stcField.u1IRQCE365)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE366	(IRC0.unIRQCE11.stcField.u1IRQCE366)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE367	(IRC0.unIRQCE11.stcField.u1IRQCE367)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE368	(IRC0.unIRQCE11.stcField.u1IRQCE368)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE369	(IRC0.unIRQCE11.stcField.u1IRQCE369)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE370	(IRC0.unIRQCE11.stcField.u1IRQCE370)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE371	(IRC0.unIRQCE11.stcField.u1IRQCE371)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE372	(IRC0.unIRQCE11.stcField.u1IRQCE372)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE373	(IRC0.unIRQCE11.stcField.u1IRQCE373)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE374	(IRC0.unIRQCE11.stcField.u1IRQCE374)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE375	(IRC0.unIRQCE11.stcField.u1IRQCE375)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE376	(IRC0.unIRQCE11.stcField.u1IRQCE376)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE377	(IRC0.unIRQCE11.stcField.u1IRQCE377)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE378	(IRC0.unIRQCE11.stcField.u1IRQCE378)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE379	(IRC0.unIRQCE11.stcField.u1IRQCE379)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE380	(IRC0.unIRQCE11.stcField.u1IRQCE380)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE381	(IRC0.unIRQCE11.stcField.u1IRQCE381)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE382	(IRC0.unIRQCE11.stcField.u1IRQCE382)  /*@bf@*/
#define IRC0_IRQCE11_IRQCE383	(IRC0.unIRQCE11.stcField.u1IRQCE383)  /*@bf@*/

typedef struct stc_irc0_irqce11_field{
    uint_io32_t		u1IRQCE352:1;
    uint_io32_t		u1IRQCE353:1;
    uint_io32_t		u1IRQCE354:1;
    uint_io32_t		u1IRQCE355:1;
    uint_io32_t		u1IRQCE356:1;
    uint_io32_t		u1IRQCE357:1;
    uint_io32_t		u1IRQCE358:1;
    uint_io32_t		u1IRQCE359:1;
    uint_io32_t		u1IRQCE360:1;
    uint_io32_t		u1IRQCE361:1;
    uint_io32_t		u1IRQCE362:1;
    uint_io32_t		u1IRQCE363:1;
    uint_io32_t		u1IRQCE364:1;
    uint_io32_t		u1IRQCE365:1;
    uint_io32_t		u1IRQCE366:1;
    uint_io32_t		u1IRQCE367:1;
    uint_io32_t		u1IRQCE368:1;
    uint_io32_t		u1IRQCE369:1;
    uint_io32_t		u1IRQCE370:1;
    uint_io32_t		u1IRQCE371:1;
    uint_io32_t		u1IRQCE372:1;
    uint_io32_t		u1IRQCE373:1;
    uint_io32_t		u1IRQCE374:1;
    uint_io32_t		u1IRQCE375:1;
    uint_io32_t		u1IRQCE376:1;
    uint_io32_t		u1IRQCE377:1;
    uint_io32_t		u1IRQCE378:1;
    uint_io32_t		u1IRQCE379:1;
    uint_io32_t		u1IRQCE380:1;
    uint_io32_t		u1IRQCE381:1;
    uint_io32_t		u1IRQCE382:1;
    uint_io32_t		u1IRQCE383:1;
}stc_irc0_irqce11_field_t;

typedef union un_irc0_irqce11{
    uint_io32_t		u32Register;
    stc_irc0_irqce11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce11_t;

/* IRQCE12 */
#define IRC0_IRQCE12	(IRC0.unIRQCE12.u32Register)  /*@rg@*/
#define IRC0_IRQCE12_IRQCE384	(IRC0.unIRQCE12.stcField.u1IRQCE384)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE385	(IRC0.unIRQCE12.stcField.u1IRQCE385)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE386	(IRC0.unIRQCE12.stcField.u1IRQCE386)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE387	(IRC0.unIRQCE12.stcField.u1IRQCE387)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE388	(IRC0.unIRQCE12.stcField.u1IRQCE388)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE389	(IRC0.unIRQCE12.stcField.u1IRQCE389)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE390	(IRC0.unIRQCE12.stcField.u1IRQCE390)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE391	(IRC0.unIRQCE12.stcField.u1IRQCE391)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE392	(IRC0.unIRQCE12.stcField.u1IRQCE392)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE393	(IRC0.unIRQCE12.stcField.u1IRQCE393)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE394	(IRC0.unIRQCE12.stcField.u1IRQCE394)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE395	(IRC0.unIRQCE12.stcField.u1IRQCE395)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE396	(IRC0.unIRQCE12.stcField.u1IRQCE396)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE397	(IRC0.unIRQCE12.stcField.u1IRQCE397)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE398	(IRC0.unIRQCE12.stcField.u1IRQCE398)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE399	(IRC0.unIRQCE12.stcField.u1IRQCE399)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE400	(IRC0.unIRQCE12.stcField.u1IRQCE400)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE401	(IRC0.unIRQCE12.stcField.u1IRQCE401)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE402	(IRC0.unIRQCE12.stcField.u1IRQCE402)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE403	(IRC0.unIRQCE12.stcField.u1IRQCE403)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE404	(IRC0.unIRQCE12.stcField.u1IRQCE404)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE405	(IRC0.unIRQCE12.stcField.u1IRQCE405)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE406	(IRC0.unIRQCE12.stcField.u1IRQCE406)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE407	(IRC0.unIRQCE12.stcField.u1IRQCE407)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE408	(IRC0.unIRQCE12.stcField.u1IRQCE408)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE409	(IRC0.unIRQCE12.stcField.u1IRQCE409)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE410	(IRC0.unIRQCE12.stcField.u1IRQCE410)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE411	(IRC0.unIRQCE12.stcField.u1IRQCE411)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE412	(IRC0.unIRQCE12.stcField.u1IRQCE412)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE413	(IRC0.unIRQCE12.stcField.u1IRQCE413)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE414	(IRC0.unIRQCE12.stcField.u1IRQCE414)  /*@bf@*/
#define IRC0_IRQCE12_IRQCE415	(IRC0.unIRQCE12.stcField.u1IRQCE415)  /*@bf@*/

typedef struct stc_irc0_irqce12_field{
    uint_io32_t		u1IRQCE384:1;
    uint_io32_t		u1IRQCE385:1;
    uint_io32_t		u1IRQCE386:1;
    uint_io32_t		u1IRQCE387:1;
    uint_io32_t		u1IRQCE388:1;
    uint_io32_t		u1IRQCE389:1;
    uint_io32_t		u1IRQCE390:1;
    uint_io32_t		u1IRQCE391:1;
    uint_io32_t		u1IRQCE392:1;
    uint_io32_t		u1IRQCE393:1;
    uint_io32_t		u1IRQCE394:1;
    uint_io32_t		u1IRQCE395:1;
    uint_io32_t		u1IRQCE396:1;
    uint_io32_t		u1IRQCE397:1;
    uint_io32_t		u1IRQCE398:1;
    uint_io32_t		u1IRQCE399:1;
    uint_io32_t		u1IRQCE400:1;
    uint_io32_t		u1IRQCE401:1;
    uint_io32_t		u1IRQCE402:1;
    uint_io32_t		u1IRQCE403:1;
    uint_io32_t		u1IRQCE404:1;
    uint_io32_t		u1IRQCE405:1;
    uint_io32_t		u1IRQCE406:1;
    uint_io32_t		u1IRQCE407:1;
    uint_io32_t		u1IRQCE408:1;
    uint_io32_t		u1IRQCE409:1;
    uint_io32_t		u1IRQCE410:1;
    uint_io32_t		u1IRQCE411:1;
    uint_io32_t		u1IRQCE412:1;
    uint_io32_t		u1IRQCE413:1;
    uint_io32_t		u1IRQCE414:1;
    uint_io32_t		u1IRQCE415:1;
}stc_irc0_irqce12_field_t;

typedef union un_irc0_irqce12{
    uint_io32_t		u32Register;
    stc_irc0_irqce12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce12_t;

/* IRQCE13 */
#define IRC0_IRQCE13	(IRC0.unIRQCE13.u32Register)  /*@rg@*/
#define IRC0_IRQCE13_IRQCE416	(IRC0.unIRQCE13.stcField.u1IRQCE416)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE417	(IRC0.unIRQCE13.stcField.u1IRQCE417)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE418	(IRC0.unIRQCE13.stcField.u1IRQCE418)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE419	(IRC0.unIRQCE13.stcField.u1IRQCE419)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE420	(IRC0.unIRQCE13.stcField.u1IRQCE420)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE421	(IRC0.unIRQCE13.stcField.u1IRQCE421)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE422	(IRC0.unIRQCE13.stcField.u1IRQCE422)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE423	(IRC0.unIRQCE13.stcField.u1IRQCE423)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE424	(IRC0.unIRQCE13.stcField.u1IRQCE424)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE425	(IRC0.unIRQCE13.stcField.u1IRQCE425)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE426	(IRC0.unIRQCE13.stcField.u1IRQCE426)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE427	(IRC0.unIRQCE13.stcField.u1IRQCE427)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE428	(IRC0.unIRQCE13.stcField.u1IRQCE428)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE429	(IRC0.unIRQCE13.stcField.u1IRQCE429)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE430	(IRC0.unIRQCE13.stcField.u1IRQCE430)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE431	(IRC0.unIRQCE13.stcField.u1IRQCE431)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE432	(IRC0.unIRQCE13.stcField.u1IRQCE432)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE433	(IRC0.unIRQCE13.stcField.u1IRQCE433)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE434	(IRC0.unIRQCE13.stcField.u1IRQCE434)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE435	(IRC0.unIRQCE13.stcField.u1IRQCE435)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE436	(IRC0.unIRQCE13.stcField.u1IRQCE436)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE437	(IRC0.unIRQCE13.stcField.u1IRQCE437)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE438	(IRC0.unIRQCE13.stcField.u1IRQCE438)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE439	(IRC0.unIRQCE13.stcField.u1IRQCE439)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE440	(IRC0.unIRQCE13.stcField.u1IRQCE440)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE441	(IRC0.unIRQCE13.stcField.u1IRQCE441)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE442	(IRC0.unIRQCE13.stcField.u1IRQCE442)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE443	(IRC0.unIRQCE13.stcField.u1IRQCE443)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE444	(IRC0.unIRQCE13.stcField.u1IRQCE444)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE445	(IRC0.unIRQCE13.stcField.u1IRQCE445)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE446	(IRC0.unIRQCE13.stcField.u1IRQCE446)  /*@bf@*/
#define IRC0_IRQCE13_IRQCE447	(IRC0.unIRQCE13.stcField.u1IRQCE447)  /*@bf@*/

typedef struct stc_irc0_irqce13_field{
    uint_io32_t		u1IRQCE416:1;
    uint_io32_t		u1IRQCE417:1;
    uint_io32_t		u1IRQCE418:1;
    uint_io32_t		u1IRQCE419:1;
    uint_io32_t		u1IRQCE420:1;
    uint_io32_t		u1IRQCE421:1;
    uint_io32_t		u1IRQCE422:1;
    uint_io32_t		u1IRQCE423:1;
    uint_io32_t		u1IRQCE424:1;
    uint_io32_t		u1IRQCE425:1;
    uint_io32_t		u1IRQCE426:1;
    uint_io32_t		u1IRQCE427:1;
    uint_io32_t		u1IRQCE428:1;
    uint_io32_t		u1IRQCE429:1;
    uint_io32_t		u1IRQCE430:1;
    uint_io32_t		u1IRQCE431:1;
    uint_io32_t		u1IRQCE432:1;
    uint_io32_t		u1IRQCE433:1;
    uint_io32_t		u1IRQCE434:1;
    uint_io32_t		u1IRQCE435:1;
    uint_io32_t		u1IRQCE436:1;
    uint_io32_t		u1IRQCE437:1;
    uint_io32_t		u1IRQCE438:1;
    uint_io32_t		u1IRQCE439:1;
    uint_io32_t		u1IRQCE440:1;
    uint_io32_t		u1IRQCE441:1;
    uint_io32_t		u1IRQCE442:1;
    uint_io32_t		u1IRQCE443:1;
    uint_io32_t		u1IRQCE444:1;
    uint_io32_t		u1IRQCE445:1;
    uint_io32_t		u1IRQCE446:1;
    uint_io32_t		u1IRQCE447:1;
}stc_irc0_irqce13_field_t;

typedef union un_irc0_irqce13{
    uint_io32_t		u32Register;
    stc_irc0_irqce13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce13_t;

/* IRQCE14 */
#define IRC0_IRQCE14	(IRC0.unIRQCE14.u32Register)  /*@rg@*/
#define IRC0_IRQCE14_IRQCE448	(IRC0.unIRQCE14.stcField.u1IRQCE448)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE449	(IRC0.unIRQCE14.stcField.u1IRQCE449)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE450	(IRC0.unIRQCE14.stcField.u1IRQCE450)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE451	(IRC0.unIRQCE14.stcField.u1IRQCE451)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE452	(IRC0.unIRQCE14.stcField.u1IRQCE452)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE453	(IRC0.unIRQCE14.stcField.u1IRQCE453)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE454	(IRC0.unIRQCE14.stcField.u1IRQCE454)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE455	(IRC0.unIRQCE14.stcField.u1IRQCE455)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE456	(IRC0.unIRQCE14.stcField.u1IRQCE456)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE457	(IRC0.unIRQCE14.stcField.u1IRQCE457)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE458	(IRC0.unIRQCE14.stcField.u1IRQCE458)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE459	(IRC0.unIRQCE14.stcField.u1IRQCE459)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE460	(IRC0.unIRQCE14.stcField.u1IRQCE460)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE461	(IRC0.unIRQCE14.stcField.u1IRQCE461)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE462	(IRC0.unIRQCE14.stcField.u1IRQCE462)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE463	(IRC0.unIRQCE14.stcField.u1IRQCE463)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE464	(IRC0.unIRQCE14.stcField.u1IRQCE464)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE465	(IRC0.unIRQCE14.stcField.u1IRQCE465)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE466	(IRC0.unIRQCE14.stcField.u1IRQCE466)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE467	(IRC0.unIRQCE14.stcField.u1IRQCE467)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE468	(IRC0.unIRQCE14.stcField.u1IRQCE468)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE469	(IRC0.unIRQCE14.stcField.u1IRQCE469)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE470	(IRC0.unIRQCE14.stcField.u1IRQCE470)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE471	(IRC0.unIRQCE14.stcField.u1IRQCE471)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE472	(IRC0.unIRQCE14.stcField.u1IRQCE472)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE473	(IRC0.unIRQCE14.stcField.u1IRQCE473)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE474	(IRC0.unIRQCE14.stcField.u1IRQCE474)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE475	(IRC0.unIRQCE14.stcField.u1IRQCE475)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE476	(IRC0.unIRQCE14.stcField.u1IRQCE476)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE477	(IRC0.unIRQCE14.stcField.u1IRQCE477)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE478	(IRC0.unIRQCE14.stcField.u1IRQCE478)  /*@bf@*/
#define IRC0_IRQCE14_IRQCE479	(IRC0.unIRQCE14.stcField.u1IRQCE479)  /*@bf@*/

typedef struct stc_irc0_irqce14_field{
    uint_io32_t		u1IRQCE448:1;
    uint_io32_t		u1IRQCE449:1;
    uint_io32_t		u1IRQCE450:1;
    uint_io32_t		u1IRQCE451:1;
    uint_io32_t		u1IRQCE452:1;
    uint_io32_t		u1IRQCE453:1;
    uint_io32_t		u1IRQCE454:1;
    uint_io32_t		u1IRQCE455:1;
    uint_io32_t		u1IRQCE456:1;
    uint_io32_t		u1IRQCE457:1;
    uint_io32_t		u1IRQCE458:1;
    uint_io32_t		u1IRQCE459:1;
    uint_io32_t		u1IRQCE460:1;
    uint_io32_t		u1IRQCE461:1;
    uint_io32_t		u1IRQCE462:1;
    uint_io32_t		u1IRQCE463:1;
    uint_io32_t		u1IRQCE464:1;
    uint_io32_t		u1IRQCE465:1;
    uint_io32_t		u1IRQCE466:1;
    uint_io32_t		u1IRQCE467:1;
    uint_io32_t		u1IRQCE468:1;
    uint_io32_t		u1IRQCE469:1;
    uint_io32_t		u1IRQCE470:1;
    uint_io32_t		u1IRQCE471:1;
    uint_io32_t		u1IRQCE472:1;
    uint_io32_t		u1IRQCE473:1;
    uint_io32_t		u1IRQCE474:1;
    uint_io32_t		u1IRQCE475:1;
    uint_io32_t		u1IRQCE476:1;
    uint_io32_t		u1IRQCE477:1;
    uint_io32_t		u1IRQCE478:1;
    uint_io32_t		u1IRQCE479:1;
}stc_irc0_irqce14_field_t;

typedef union un_irc0_irqce14{
    uint_io32_t		u32Register;
    stc_irc0_irqce14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce14_t;

/* IRQCE15 */
#define IRC0_IRQCE15	(IRC0.unIRQCE15.u32Register)  /*@rg@*/
#define IRC0_IRQCE15_IRQCE480	(IRC0.unIRQCE15.stcField.u1IRQCE480)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE481	(IRC0.unIRQCE15.stcField.u1IRQCE481)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE482	(IRC0.unIRQCE15.stcField.u1IRQCE482)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE483	(IRC0.unIRQCE15.stcField.u1IRQCE483)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE484	(IRC0.unIRQCE15.stcField.u1IRQCE484)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE485	(IRC0.unIRQCE15.stcField.u1IRQCE485)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE486	(IRC0.unIRQCE15.stcField.u1IRQCE486)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE487	(IRC0.unIRQCE15.stcField.u1IRQCE487)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE488	(IRC0.unIRQCE15.stcField.u1IRQCE488)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE489	(IRC0.unIRQCE15.stcField.u1IRQCE489)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE490	(IRC0.unIRQCE15.stcField.u1IRQCE490)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE491	(IRC0.unIRQCE15.stcField.u1IRQCE491)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE492	(IRC0.unIRQCE15.stcField.u1IRQCE492)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE493	(IRC0.unIRQCE15.stcField.u1IRQCE493)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE494	(IRC0.unIRQCE15.stcField.u1IRQCE494)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE495	(IRC0.unIRQCE15.stcField.u1IRQCE495)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE496	(IRC0.unIRQCE15.stcField.u1IRQCE496)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE497	(IRC0.unIRQCE15.stcField.u1IRQCE497)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE498	(IRC0.unIRQCE15.stcField.u1IRQCE498)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE499	(IRC0.unIRQCE15.stcField.u1IRQCE499)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE500	(IRC0.unIRQCE15.stcField.u1IRQCE500)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE501	(IRC0.unIRQCE15.stcField.u1IRQCE501)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE502	(IRC0.unIRQCE15.stcField.u1IRQCE502)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE503	(IRC0.unIRQCE15.stcField.u1IRQCE503)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE504	(IRC0.unIRQCE15.stcField.u1IRQCE504)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE505	(IRC0.unIRQCE15.stcField.u1IRQCE505)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE506	(IRC0.unIRQCE15.stcField.u1IRQCE506)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE507	(IRC0.unIRQCE15.stcField.u1IRQCE507)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE508	(IRC0.unIRQCE15.stcField.u1IRQCE508)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE509	(IRC0.unIRQCE15.stcField.u1IRQCE509)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE510	(IRC0.unIRQCE15.stcField.u1IRQCE510)  /*@bf@*/
#define IRC0_IRQCE15_IRQCE511	(IRC0.unIRQCE15.stcField.u1IRQCE511)  /*@bf@*/

typedef struct stc_irc0_irqce15_field{
    uint_io32_t		u1IRQCE480:1;
    uint_io32_t		u1IRQCE481:1;
    uint_io32_t		u1IRQCE482:1;
    uint_io32_t		u1IRQCE483:1;
    uint_io32_t		u1IRQCE484:1;
    uint_io32_t		u1IRQCE485:1;
    uint_io32_t		u1IRQCE486:1;
    uint_io32_t		u1IRQCE487:1;
    uint_io32_t		u1IRQCE488:1;
    uint_io32_t		u1IRQCE489:1;
    uint_io32_t		u1IRQCE490:1;
    uint_io32_t		u1IRQCE491:1;
    uint_io32_t		u1IRQCE492:1;
    uint_io32_t		u1IRQCE493:1;
    uint_io32_t		u1IRQCE494:1;
    uint_io32_t		u1IRQCE495:1;
    uint_io32_t		u1IRQCE496:1;
    uint_io32_t		u1IRQCE497:1;
    uint_io32_t		u1IRQCE498:1;
    uint_io32_t		u1IRQCE499:1;
    uint_io32_t		u1IRQCE500:1;
    uint_io32_t		u1IRQCE501:1;
    uint_io32_t		u1IRQCE502:1;
    uint_io32_t		u1IRQCE503:1;
    uint_io32_t		u1IRQCE504:1;
    uint_io32_t		u1IRQCE505:1;
    uint_io32_t		u1IRQCE506:1;
    uint_io32_t		u1IRQCE507:1;
    uint_io32_t		u1IRQCE508:1;
    uint_io32_t		u1IRQCE509:1;
    uint_io32_t		u1IRQCE510:1;
    uint_io32_t		u1IRQCE511:1;
}stc_irc0_irqce15_field_t;

typedef union un_irc0_irqce15{
    uint_io32_t		u32Register;
    stc_irc0_irqce15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqce15_t;

/* NMIHC */
#define IRC0_NMIHC	(IRC0.unNMIHC.u32Register)  /*@rg@*/
#define IRC0_NMIHC_NMIHCN	(IRC0.unNMIHC.stcField.u5NMIHCN)  /*@bf@*/

typedef struct stc_irc0_nmihc_field{
    uint_io32_t		u5NMIHCN:5;
    uint_io32_t		:27;
}stc_irc0_nmihc_field_t;

typedef union un_irc0_nmihc{
    uint_io32_t		u32Register;
    stc_irc0_nmihc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmihc_t;

/* NMIHS */
#define IRC0_NMIHS	(IRC0.unNMIHS.u32Register)  /*@rg@*/
#define IRC0_NMIHS_NMIHS0	(IRC0.unNMIHS.stcField.u1NMIHS0)  /*@bf@*/
#define IRC0_NMIHS_NMIHS1	(IRC0.unNMIHS.stcField.u1NMIHS1)  /*@bf@*/
#define IRC0_NMIHS_NMIHS2	(IRC0.unNMIHS.stcField.u1NMIHS2)  /*@bf@*/
#define IRC0_NMIHS_NMIHS3	(IRC0.unNMIHS.stcField.u1NMIHS3)  /*@bf@*/
#define IRC0_NMIHS_NMIHS4	(IRC0.unNMIHS.stcField.u1NMIHS4)  /*@bf@*/
#define IRC0_NMIHS_NMIHS5	(IRC0.unNMIHS.stcField.u1NMIHS5)  /*@bf@*/
#define IRC0_NMIHS_NMIHS6	(IRC0.unNMIHS.stcField.u1NMIHS6)  /*@bf@*/
#define IRC0_NMIHS_NMIHS7	(IRC0.unNMIHS.stcField.u1NMIHS7)  /*@bf@*/
#define IRC0_NMIHS_NMIHS8	(IRC0.unNMIHS.stcField.u1NMIHS8)  /*@bf@*/
#define IRC0_NMIHS_NMIHS9	(IRC0.unNMIHS.stcField.u1NMIHS9)  /*@bf@*/
#define IRC0_NMIHS_NMIHS10	(IRC0.unNMIHS.stcField.u1NMIHS10)  /*@bf@*/
#define IRC0_NMIHS_NMIHS11	(IRC0.unNMIHS.stcField.u1NMIHS11)  /*@bf@*/
#define IRC0_NMIHS_NMIHS12	(IRC0.unNMIHS.stcField.u1NMIHS12)  /*@bf@*/
#define IRC0_NMIHS_NMIHS13	(IRC0.unNMIHS.stcField.u1NMIHS13)  /*@bf@*/
#define IRC0_NMIHS_NMIHS14	(IRC0.unNMIHS.stcField.u1NMIHS14)  /*@bf@*/
#define IRC0_NMIHS_NMIHS15	(IRC0.unNMIHS.stcField.u1NMIHS15)  /*@bf@*/
#define IRC0_NMIHS_NMIHS16	(IRC0.unNMIHS.stcField.u1NMIHS16)  /*@bf@*/
#define IRC0_NMIHS_NMIHS17	(IRC0.unNMIHS.stcField.u1NMIHS17)  /*@bf@*/
#define IRC0_NMIHS_NMIHS18	(IRC0.unNMIHS.stcField.u1NMIHS18)  /*@bf@*/
#define IRC0_NMIHS_NMIHS19	(IRC0.unNMIHS.stcField.u1NMIHS19)  /*@bf@*/
#define IRC0_NMIHS_NMIHS20	(IRC0.unNMIHS.stcField.u1NMIHS20)  /*@bf@*/
#define IRC0_NMIHS_NMIHS21	(IRC0.unNMIHS.stcField.u1NMIHS21)  /*@bf@*/
#define IRC0_NMIHS_NMIHS22	(IRC0.unNMIHS.stcField.u1NMIHS22)  /*@bf@*/
#define IRC0_NMIHS_NMIHS23	(IRC0.unNMIHS.stcField.u1NMIHS23)  /*@bf@*/
#define IRC0_NMIHS_NMIHS24	(IRC0.unNMIHS.stcField.u1NMIHS24)  /*@bf@*/
#define IRC0_NMIHS_NMIHS25	(IRC0.unNMIHS.stcField.u1NMIHS25)  /*@bf@*/
#define IRC0_NMIHS_NMIHS26	(IRC0.unNMIHS.stcField.u1NMIHS26)  /*@bf@*/
#define IRC0_NMIHS_NMIHS27	(IRC0.unNMIHS.stcField.u1NMIHS27)  /*@bf@*/
#define IRC0_NMIHS_NMIHS28	(IRC0.unNMIHS.stcField.u1NMIHS28)  /*@bf@*/
#define IRC0_NMIHS_NMIHS29	(IRC0.unNMIHS.stcField.u1NMIHS29)  /*@bf@*/
#define IRC0_NMIHS_NMIHS30	(IRC0.unNMIHS.stcField.u1NMIHS30)  /*@bf@*/
#define IRC0_NMIHS_NMIHS31	(IRC0.unNMIHS.stcField.u1NMIHS31)  /*@bf@*/

typedef struct stc_irc0_nmihs_field{
    uint_io32_t		u1NMIHS0:1;
    uint_io32_t		u1NMIHS1:1;
    uint_io32_t		u1NMIHS2:1;
    uint_io32_t		u1NMIHS3:1;
    uint_io32_t		u1NMIHS4:1;
    uint_io32_t		u1NMIHS5:1;
    uint_io32_t		u1NMIHS6:1;
    uint_io32_t		u1NMIHS7:1;
    uint_io32_t		u1NMIHS8:1;
    uint_io32_t		u1NMIHS9:1;
    uint_io32_t		u1NMIHS10:1;
    uint_io32_t		u1NMIHS11:1;
    uint_io32_t		u1NMIHS12:1;
    uint_io32_t		u1NMIHS13:1;
    uint_io32_t		u1NMIHS14:1;
    uint_io32_t		u1NMIHS15:1;
    uint_io32_t		u1NMIHS16:1;
    uint_io32_t		u1NMIHS17:1;
    uint_io32_t		u1NMIHS18:1;
    uint_io32_t		u1NMIHS19:1;
    uint_io32_t		u1NMIHS20:1;
    uint_io32_t		u1NMIHS21:1;
    uint_io32_t		u1NMIHS22:1;
    uint_io32_t		u1NMIHS23:1;
    uint_io32_t		u1NMIHS24:1;
    uint_io32_t		u1NMIHS25:1;
    uint_io32_t		u1NMIHS26:1;
    uint_io32_t		u1NMIHS27:1;
    uint_io32_t		u1NMIHS28:1;
    uint_io32_t		u1NMIHS29:1;
    uint_io32_t		u1NMIHS30:1;
    uint_io32_t		u1NMIHS31:1;
}stc_irc0_nmihs_field_t;

typedef union un_irc0_nmihs{
    uint_io32_t		u32Register;
    stc_irc0_nmihs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmihs_t;

/* IRQHC */
#define IRC0_IRQHC	(IRC0.unIRQHC.u32Register)  /*@rg@*/
#define IRC0_IRQHC_IRQHCN	(IRC0.unIRQHC.stcField.u9IRQHCN)  /*@bf@*/

typedef struct stc_irc0_irqhc_field{
    uint_io32_t		u9IRQHCN:9;
    uint_io32_t		:23;
}stc_irc0_irqhc_field_t;

typedef union un_irc0_irqhc{
    uint_io32_t		u32Register;
    stc_irc0_irqhc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhc_t;

/* IRQHS0 */
#define IRC0_IRQHS0	(IRC0.unIRQHS0.u32Register)  /*@rg@*/
#define IRC0_IRQHS0_IRQHS0	(IRC0.unIRQHS0.stcField.u1IRQHS0)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS1	(IRC0.unIRQHS0.stcField.u1IRQHS1)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS2	(IRC0.unIRQHS0.stcField.u1IRQHS2)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS3	(IRC0.unIRQHS0.stcField.u1IRQHS3)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS4	(IRC0.unIRQHS0.stcField.u1IRQHS4)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS5	(IRC0.unIRQHS0.stcField.u1IRQHS5)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS6	(IRC0.unIRQHS0.stcField.u1IRQHS6)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS7	(IRC0.unIRQHS0.stcField.u1IRQHS7)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS8	(IRC0.unIRQHS0.stcField.u1IRQHS8)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS9	(IRC0.unIRQHS0.stcField.u1IRQHS9)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS10	(IRC0.unIRQHS0.stcField.u1IRQHS10)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS11	(IRC0.unIRQHS0.stcField.u1IRQHS11)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS12	(IRC0.unIRQHS0.stcField.u1IRQHS12)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS13	(IRC0.unIRQHS0.stcField.u1IRQHS13)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS14	(IRC0.unIRQHS0.stcField.u1IRQHS14)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS15	(IRC0.unIRQHS0.stcField.u1IRQHS15)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS16	(IRC0.unIRQHS0.stcField.u1IRQHS16)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS17	(IRC0.unIRQHS0.stcField.u1IRQHS17)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS18	(IRC0.unIRQHS0.stcField.u1IRQHS18)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS19	(IRC0.unIRQHS0.stcField.u1IRQHS19)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS20	(IRC0.unIRQHS0.stcField.u1IRQHS20)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS21	(IRC0.unIRQHS0.stcField.u1IRQHS21)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS22	(IRC0.unIRQHS0.stcField.u1IRQHS22)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS23	(IRC0.unIRQHS0.stcField.u1IRQHS23)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS24	(IRC0.unIRQHS0.stcField.u1IRQHS24)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS25	(IRC0.unIRQHS0.stcField.u1IRQHS25)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS26	(IRC0.unIRQHS0.stcField.u1IRQHS26)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS27	(IRC0.unIRQHS0.stcField.u1IRQHS27)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS28	(IRC0.unIRQHS0.stcField.u1IRQHS28)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS29	(IRC0.unIRQHS0.stcField.u1IRQHS29)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS30	(IRC0.unIRQHS0.stcField.u1IRQHS30)  /*@bf@*/
#define IRC0_IRQHS0_IRQHS31	(IRC0.unIRQHS0.stcField.u1IRQHS31)  /*@bf@*/

typedef struct stc_irc0_irqhs0_field{
    uint_io32_t		u1IRQHS0:1;
    uint_io32_t		u1IRQHS1:1;
    uint_io32_t		u1IRQHS2:1;
    uint_io32_t		u1IRQHS3:1;
    uint_io32_t		u1IRQHS4:1;
    uint_io32_t		u1IRQHS5:1;
    uint_io32_t		u1IRQHS6:1;
    uint_io32_t		u1IRQHS7:1;
    uint_io32_t		u1IRQHS8:1;
    uint_io32_t		u1IRQHS9:1;
    uint_io32_t		u1IRQHS10:1;
    uint_io32_t		u1IRQHS11:1;
    uint_io32_t		u1IRQHS12:1;
    uint_io32_t		u1IRQHS13:1;
    uint_io32_t		u1IRQHS14:1;
    uint_io32_t		u1IRQHS15:1;
    uint_io32_t		u1IRQHS16:1;
    uint_io32_t		u1IRQHS17:1;
    uint_io32_t		u1IRQHS18:1;
    uint_io32_t		u1IRQHS19:1;
    uint_io32_t		u1IRQHS20:1;
    uint_io32_t		u1IRQHS21:1;
    uint_io32_t		u1IRQHS22:1;
    uint_io32_t		u1IRQHS23:1;
    uint_io32_t		u1IRQHS24:1;
    uint_io32_t		u1IRQHS25:1;
    uint_io32_t		u1IRQHS26:1;
    uint_io32_t		u1IRQHS27:1;
    uint_io32_t		u1IRQHS28:1;
    uint_io32_t		u1IRQHS29:1;
    uint_io32_t		u1IRQHS30:1;
    uint_io32_t		u1IRQHS31:1;
}stc_irc0_irqhs0_field_t;

typedef union un_irc0_irqhs0{
    uint_io32_t		u32Register;
    stc_irc0_irqhs0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs0_t;

/* IRQHS1 */
#define IRC0_IRQHS1	(IRC0.unIRQHS1.u32Register)  /*@rg@*/
#define IRC0_IRQHS1_IRQHS32	(IRC0.unIRQHS1.stcField.u1IRQHS32)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS33	(IRC0.unIRQHS1.stcField.u1IRQHS33)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS34	(IRC0.unIRQHS1.stcField.u1IRQHS34)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS35	(IRC0.unIRQHS1.stcField.u1IRQHS35)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS36	(IRC0.unIRQHS1.stcField.u1IRQHS36)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS37	(IRC0.unIRQHS1.stcField.u1IRQHS37)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS38	(IRC0.unIRQHS1.stcField.u1IRQHS38)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS39	(IRC0.unIRQHS1.stcField.u1IRQHS39)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS40	(IRC0.unIRQHS1.stcField.u1IRQHS40)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS41	(IRC0.unIRQHS1.stcField.u1IRQHS41)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS42	(IRC0.unIRQHS1.stcField.u1IRQHS42)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS43	(IRC0.unIRQHS1.stcField.u1IRQHS43)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS44	(IRC0.unIRQHS1.stcField.u1IRQHS44)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS45	(IRC0.unIRQHS1.stcField.u1IRQHS45)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS46	(IRC0.unIRQHS1.stcField.u1IRQHS46)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS47	(IRC0.unIRQHS1.stcField.u1IRQHS47)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS48	(IRC0.unIRQHS1.stcField.u1IRQHS48)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS49	(IRC0.unIRQHS1.stcField.u1IRQHS49)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS50	(IRC0.unIRQHS1.stcField.u1IRQHS50)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS51	(IRC0.unIRQHS1.stcField.u1IRQHS51)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS52	(IRC0.unIRQHS1.stcField.u1IRQHS52)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS53	(IRC0.unIRQHS1.stcField.u1IRQHS53)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS54	(IRC0.unIRQHS1.stcField.u1IRQHS54)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS55	(IRC0.unIRQHS1.stcField.u1IRQHS55)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS56	(IRC0.unIRQHS1.stcField.u1IRQHS56)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS57	(IRC0.unIRQHS1.stcField.u1IRQHS57)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS58	(IRC0.unIRQHS1.stcField.u1IRQHS58)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS59	(IRC0.unIRQHS1.stcField.u1IRQHS59)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS60	(IRC0.unIRQHS1.stcField.u1IRQHS60)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS61	(IRC0.unIRQHS1.stcField.u1IRQHS61)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS62	(IRC0.unIRQHS1.stcField.u1IRQHS62)  /*@bf@*/
#define IRC0_IRQHS1_IRQHS63	(IRC0.unIRQHS1.stcField.u1IRQHS63)  /*@bf@*/

typedef struct stc_irc0_irqhs1_field{
    uint_io32_t		u1IRQHS32:1;
    uint_io32_t		u1IRQHS33:1;
    uint_io32_t		u1IRQHS34:1;
    uint_io32_t		u1IRQHS35:1;
    uint_io32_t		u1IRQHS36:1;
    uint_io32_t		u1IRQHS37:1;
    uint_io32_t		u1IRQHS38:1;
    uint_io32_t		u1IRQHS39:1;
    uint_io32_t		u1IRQHS40:1;
    uint_io32_t		u1IRQHS41:1;
    uint_io32_t		u1IRQHS42:1;
    uint_io32_t		u1IRQHS43:1;
    uint_io32_t		u1IRQHS44:1;
    uint_io32_t		u1IRQHS45:1;
    uint_io32_t		u1IRQHS46:1;
    uint_io32_t		u1IRQHS47:1;
    uint_io32_t		u1IRQHS48:1;
    uint_io32_t		u1IRQHS49:1;
    uint_io32_t		u1IRQHS50:1;
    uint_io32_t		u1IRQHS51:1;
    uint_io32_t		u1IRQHS52:1;
    uint_io32_t		u1IRQHS53:1;
    uint_io32_t		u1IRQHS54:1;
    uint_io32_t		u1IRQHS55:1;
    uint_io32_t		u1IRQHS56:1;
    uint_io32_t		u1IRQHS57:1;
    uint_io32_t		u1IRQHS58:1;
    uint_io32_t		u1IRQHS59:1;
    uint_io32_t		u1IRQHS60:1;
    uint_io32_t		u1IRQHS61:1;
    uint_io32_t		u1IRQHS62:1;
    uint_io32_t		u1IRQHS63:1;
}stc_irc0_irqhs1_field_t;

typedef union un_irc0_irqhs1{
    uint_io32_t		u32Register;
    stc_irc0_irqhs1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs1_t;

/* IRQHS2 */
#define IRC0_IRQHS2	(IRC0.unIRQHS2.u32Register)  /*@rg@*/
#define IRC0_IRQHS2_IRQHS64	(IRC0.unIRQHS2.stcField.u1IRQHS64)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS65	(IRC0.unIRQHS2.stcField.u1IRQHS65)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS66	(IRC0.unIRQHS2.stcField.u1IRQHS66)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS67	(IRC0.unIRQHS2.stcField.u1IRQHS67)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS68	(IRC0.unIRQHS2.stcField.u1IRQHS68)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS69	(IRC0.unIRQHS2.stcField.u1IRQHS69)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS70	(IRC0.unIRQHS2.stcField.u1IRQHS70)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS71	(IRC0.unIRQHS2.stcField.u1IRQHS71)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS72	(IRC0.unIRQHS2.stcField.u1IRQHS72)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS73	(IRC0.unIRQHS2.stcField.u1IRQHS73)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS74	(IRC0.unIRQHS2.stcField.u1IRQHS74)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS75	(IRC0.unIRQHS2.stcField.u1IRQHS75)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS76	(IRC0.unIRQHS2.stcField.u1IRQHS76)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS77	(IRC0.unIRQHS2.stcField.u1IRQHS77)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS78	(IRC0.unIRQHS2.stcField.u1IRQHS78)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS79	(IRC0.unIRQHS2.stcField.u1IRQHS79)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS80	(IRC0.unIRQHS2.stcField.u1IRQHS80)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS81	(IRC0.unIRQHS2.stcField.u1IRQHS81)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS82	(IRC0.unIRQHS2.stcField.u1IRQHS82)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS83	(IRC0.unIRQHS2.stcField.u1IRQHS83)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS84	(IRC0.unIRQHS2.stcField.u1IRQHS84)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS85	(IRC0.unIRQHS2.stcField.u1IRQHS85)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS86	(IRC0.unIRQHS2.stcField.u1IRQHS86)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS87	(IRC0.unIRQHS2.stcField.u1IRQHS87)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS88	(IRC0.unIRQHS2.stcField.u1IRQHS88)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS89	(IRC0.unIRQHS2.stcField.u1IRQHS89)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS90	(IRC0.unIRQHS2.stcField.u1IRQHS90)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS91	(IRC0.unIRQHS2.stcField.u1IRQHS91)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS92	(IRC0.unIRQHS2.stcField.u1IRQHS92)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS93	(IRC0.unIRQHS2.stcField.u1IRQHS93)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS94	(IRC0.unIRQHS2.stcField.u1IRQHS94)  /*@bf@*/
#define IRC0_IRQHS2_IRQHS95	(IRC0.unIRQHS2.stcField.u1IRQHS95)  /*@bf@*/

typedef struct stc_irc0_irqhs2_field{
    uint_io32_t		u1IRQHS64:1;
    uint_io32_t		u1IRQHS65:1;
    uint_io32_t		u1IRQHS66:1;
    uint_io32_t		u1IRQHS67:1;
    uint_io32_t		u1IRQHS68:1;
    uint_io32_t		u1IRQHS69:1;
    uint_io32_t		u1IRQHS70:1;
    uint_io32_t		u1IRQHS71:1;
    uint_io32_t		u1IRQHS72:1;
    uint_io32_t		u1IRQHS73:1;
    uint_io32_t		u1IRQHS74:1;
    uint_io32_t		u1IRQHS75:1;
    uint_io32_t		u1IRQHS76:1;
    uint_io32_t		u1IRQHS77:1;
    uint_io32_t		u1IRQHS78:1;
    uint_io32_t		u1IRQHS79:1;
    uint_io32_t		u1IRQHS80:1;
    uint_io32_t		u1IRQHS81:1;
    uint_io32_t		u1IRQHS82:1;
    uint_io32_t		u1IRQHS83:1;
    uint_io32_t		u1IRQHS84:1;
    uint_io32_t		u1IRQHS85:1;
    uint_io32_t		u1IRQHS86:1;
    uint_io32_t		u1IRQHS87:1;
    uint_io32_t		u1IRQHS88:1;
    uint_io32_t		u1IRQHS89:1;
    uint_io32_t		u1IRQHS90:1;
    uint_io32_t		u1IRQHS91:1;
    uint_io32_t		u1IRQHS92:1;
    uint_io32_t		u1IRQHS93:1;
    uint_io32_t		u1IRQHS94:1;
    uint_io32_t		u1IRQHS95:1;
}stc_irc0_irqhs2_field_t;

typedef union un_irc0_irqhs2{
    uint_io32_t		u32Register;
    stc_irc0_irqhs2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs2_t;

/* IRQHS3 */
#define IRC0_IRQHS3	(IRC0.unIRQHS3.u32Register)  /*@rg@*/
#define IRC0_IRQHS3_IRQHS96	(IRC0.unIRQHS3.stcField.u1IRQHS96)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS97	(IRC0.unIRQHS3.stcField.u1IRQHS97)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS98	(IRC0.unIRQHS3.stcField.u1IRQHS98)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS99	(IRC0.unIRQHS3.stcField.u1IRQHS99)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS100	(IRC0.unIRQHS3.stcField.u1IRQHS100)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS101	(IRC0.unIRQHS3.stcField.u1IRQHS101)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS102	(IRC0.unIRQHS3.stcField.u1IRQHS102)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS103	(IRC0.unIRQHS3.stcField.u1IRQHS103)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS104	(IRC0.unIRQHS3.stcField.u1IRQHS104)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS105	(IRC0.unIRQHS3.stcField.u1IRQHS105)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS106	(IRC0.unIRQHS3.stcField.u1IRQHS106)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS107	(IRC0.unIRQHS3.stcField.u1IRQHS107)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS108	(IRC0.unIRQHS3.stcField.u1IRQHS108)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS109	(IRC0.unIRQHS3.stcField.u1IRQHS109)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS110	(IRC0.unIRQHS3.stcField.u1IRQHS110)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS111	(IRC0.unIRQHS3.stcField.u1IRQHS111)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS112	(IRC0.unIRQHS3.stcField.u1IRQHS112)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS113	(IRC0.unIRQHS3.stcField.u1IRQHS113)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS114	(IRC0.unIRQHS3.stcField.u1IRQHS114)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS115	(IRC0.unIRQHS3.stcField.u1IRQHS115)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS116	(IRC0.unIRQHS3.stcField.u1IRQHS116)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS117	(IRC0.unIRQHS3.stcField.u1IRQHS117)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS118	(IRC0.unIRQHS3.stcField.u1IRQHS118)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS119	(IRC0.unIRQHS3.stcField.u1IRQHS119)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS120	(IRC0.unIRQHS3.stcField.u1IRQHS120)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS121	(IRC0.unIRQHS3.stcField.u1IRQHS121)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS122	(IRC0.unIRQHS3.stcField.u1IRQHS122)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS123	(IRC0.unIRQHS3.stcField.u1IRQHS123)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS124	(IRC0.unIRQHS3.stcField.u1IRQHS124)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS125	(IRC0.unIRQHS3.stcField.u1IRQHS125)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS126	(IRC0.unIRQHS3.stcField.u1IRQHS126)  /*@bf@*/
#define IRC0_IRQHS3_IRQHS127	(IRC0.unIRQHS3.stcField.u1IRQHS127)  /*@bf@*/

typedef struct stc_irc0_irqhs3_field{
    uint_io32_t		u1IRQHS96:1;
    uint_io32_t		u1IRQHS97:1;
    uint_io32_t		u1IRQHS98:1;
    uint_io32_t		u1IRQHS99:1;
    uint_io32_t		u1IRQHS100:1;
    uint_io32_t		u1IRQHS101:1;
    uint_io32_t		u1IRQHS102:1;
    uint_io32_t		u1IRQHS103:1;
    uint_io32_t		u1IRQHS104:1;
    uint_io32_t		u1IRQHS105:1;
    uint_io32_t		u1IRQHS106:1;
    uint_io32_t		u1IRQHS107:1;
    uint_io32_t		u1IRQHS108:1;
    uint_io32_t		u1IRQHS109:1;
    uint_io32_t		u1IRQHS110:1;
    uint_io32_t		u1IRQHS111:1;
    uint_io32_t		u1IRQHS112:1;
    uint_io32_t		u1IRQHS113:1;
    uint_io32_t		u1IRQHS114:1;
    uint_io32_t		u1IRQHS115:1;
    uint_io32_t		u1IRQHS116:1;
    uint_io32_t		u1IRQHS117:1;
    uint_io32_t		u1IRQHS118:1;
    uint_io32_t		u1IRQHS119:1;
    uint_io32_t		u1IRQHS120:1;
    uint_io32_t		u1IRQHS121:1;
    uint_io32_t		u1IRQHS122:1;
    uint_io32_t		u1IRQHS123:1;
    uint_io32_t		u1IRQHS124:1;
    uint_io32_t		u1IRQHS125:1;
    uint_io32_t		u1IRQHS126:1;
    uint_io32_t		u1IRQHS127:1;
}stc_irc0_irqhs3_field_t;

typedef union un_irc0_irqhs3{
    uint_io32_t		u32Register;
    stc_irc0_irqhs3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs3_t;

/* IRQHS4 */
#define IRC0_IRQHS4	(IRC0.unIRQHS4.u32Register)  /*@rg@*/
#define IRC0_IRQHS4_IRQHS128	(IRC0.unIRQHS4.stcField.u1IRQHS128)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS129	(IRC0.unIRQHS4.stcField.u1IRQHS129)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS130	(IRC0.unIRQHS4.stcField.u1IRQHS130)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS131	(IRC0.unIRQHS4.stcField.u1IRQHS131)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS132	(IRC0.unIRQHS4.stcField.u1IRQHS132)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS133	(IRC0.unIRQHS4.stcField.u1IRQHS133)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS134	(IRC0.unIRQHS4.stcField.u1IRQHS134)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS135	(IRC0.unIRQHS4.stcField.u1IRQHS135)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS136	(IRC0.unIRQHS4.stcField.u1IRQHS136)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS137	(IRC0.unIRQHS4.stcField.u1IRQHS137)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS138	(IRC0.unIRQHS4.stcField.u1IRQHS138)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS139	(IRC0.unIRQHS4.stcField.u1IRQHS139)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS140	(IRC0.unIRQHS4.stcField.u1IRQHS140)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS141	(IRC0.unIRQHS4.stcField.u1IRQHS141)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS142	(IRC0.unIRQHS4.stcField.u1IRQHS142)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS143	(IRC0.unIRQHS4.stcField.u1IRQHS143)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS144	(IRC0.unIRQHS4.stcField.u1IRQHS144)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS145	(IRC0.unIRQHS4.stcField.u1IRQHS145)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS146	(IRC0.unIRQHS4.stcField.u1IRQHS146)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS147	(IRC0.unIRQHS4.stcField.u1IRQHS147)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS148	(IRC0.unIRQHS4.stcField.u1IRQHS148)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS149	(IRC0.unIRQHS4.stcField.u1IRQHS149)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS150	(IRC0.unIRQHS4.stcField.u1IRQHS150)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS151	(IRC0.unIRQHS4.stcField.u1IRQHS151)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS152	(IRC0.unIRQHS4.stcField.u1IRQHS152)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS153	(IRC0.unIRQHS4.stcField.u1IRQHS153)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS154	(IRC0.unIRQHS4.stcField.u1IRQHS154)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS155	(IRC0.unIRQHS4.stcField.u1IRQHS155)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS156	(IRC0.unIRQHS4.stcField.u1IRQHS156)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS157	(IRC0.unIRQHS4.stcField.u1IRQHS157)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS158	(IRC0.unIRQHS4.stcField.u1IRQHS158)  /*@bf@*/
#define IRC0_IRQHS4_IRQHS159	(IRC0.unIRQHS4.stcField.u1IRQHS159)  /*@bf@*/

typedef struct stc_irc0_irqhs4_field{
    uint_io32_t		u1IRQHS128:1;
    uint_io32_t		u1IRQHS129:1;
    uint_io32_t		u1IRQHS130:1;
    uint_io32_t		u1IRQHS131:1;
    uint_io32_t		u1IRQHS132:1;
    uint_io32_t		u1IRQHS133:1;
    uint_io32_t		u1IRQHS134:1;
    uint_io32_t		u1IRQHS135:1;
    uint_io32_t		u1IRQHS136:1;
    uint_io32_t		u1IRQHS137:1;
    uint_io32_t		u1IRQHS138:1;
    uint_io32_t		u1IRQHS139:1;
    uint_io32_t		u1IRQHS140:1;
    uint_io32_t		u1IRQHS141:1;
    uint_io32_t		u1IRQHS142:1;
    uint_io32_t		u1IRQHS143:1;
    uint_io32_t		u1IRQHS144:1;
    uint_io32_t		u1IRQHS145:1;
    uint_io32_t		u1IRQHS146:1;
    uint_io32_t		u1IRQHS147:1;
    uint_io32_t		u1IRQHS148:1;
    uint_io32_t		u1IRQHS149:1;
    uint_io32_t		u1IRQHS150:1;
    uint_io32_t		u1IRQHS151:1;
    uint_io32_t		u1IRQHS152:1;
    uint_io32_t		u1IRQHS153:1;
    uint_io32_t		u1IRQHS154:1;
    uint_io32_t		u1IRQHS155:1;
    uint_io32_t		u1IRQHS156:1;
    uint_io32_t		u1IRQHS157:1;
    uint_io32_t		u1IRQHS158:1;
    uint_io32_t		u1IRQHS159:1;
}stc_irc0_irqhs4_field_t;

typedef union un_irc0_irqhs4{
    uint_io32_t		u32Register;
    stc_irc0_irqhs4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs4_t;

/* IRQHS5 */
#define IRC0_IRQHS5	(IRC0.unIRQHS5.u32Register)  /*@rg@*/
#define IRC0_IRQHS5_IRQHS160	(IRC0.unIRQHS5.stcField.u1IRQHS160)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS161	(IRC0.unIRQHS5.stcField.u1IRQHS161)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS162	(IRC0.unIRQHS5.stcField.u1IRQHS162)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS163	(IRC0.unIRQHS5.stcField.u1IRQHS163)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS164	(IRC0.unIRQHS5.stcField.u1IRQHS164)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS165	(IRC0.unIRQHS5.stcField.u1IRQHS165)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS166	(IRC0.unIRQHS5.stcField.u1IRQHS166)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS167	(IRC0.unIRQHS5.stcField.u1IRQHS167)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS168	(IRC0.unIRQHS5.stcField.u1IRQHS168)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS169	(IRC0.unIRQHS5.stcField.u1IRQHS169)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS170	(IRC0.unIRQHS5.stcField.u1IRQHS170)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS171	(IRC0.unIRQHS5.stcField.u1IRQHS171)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS172	(IRC0.unIRQHS5.stcField.u1IRQHS172)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS173	(IRC0.unIRQHS5.stcField.u1IRQHS173)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS174	(IRC0.unIRQHS5.stcField.u1IRQHS174)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS175	(IRC0.unIRQHS5.stcField.u1IRQHS175)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS176	(IRC0.unIRQHS5.stcField.u1IRQHS176)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS177	(IRC0.unIRQHS5.stcField.u1IRQHS177)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS178	(IRC0.unIRQHS5.stcField.u1IRQHS178)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS179	(IRC0.unIRQHS5.stcField.u1IRQHS179)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS180	(IRC0.unIRQHS5.stcField.u1IRQHS180)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS181	(IRC0.unIRQHS5.stcField.u1IRQHS181)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS182	(IRC0.unIRQHS5.stcField.u1IRQHS182)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS183	(IRC0.unIRQHS5.stcField.u1IRQHS183)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS184	(IRC0.unIRQHS5.stcField.u1IRQHS184)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS185	(IRC0.unIRQHS5.stcField.u1IRQHS185)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS186	(IRC0.unIRQHS5.stcField.u1IRQHS186)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS187	(IRC0.unIRQHS5.stcField.u1IRQHS187)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS188	(IRC0.unIRQHS5.stcField.u1IRQHS188)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS189	(IRC0.unIRQHS5.stcField.u1IRQHS189)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS190	(IRC0.unIRQHS5.stcField.u1IRQHS190)  /*@bf@*/
#define IRC0_IRQHS5_IRQHS191	(IRC0.unIRQHS5.stcField.u1IRQHS191)  /*@bf@*/

typedef struct stc_irc0_irqhs5_field{
    uint_io32_t		u1IRQHS160:1;
    uint_io32_t		u1IRQHS161:1;
    uint_io32_t		u1IRQHS162:1;
    uint_io32_t		u1IRQHS163:1;
    uint_io32_t		u1IRQHS164:1;
    uint_io32_t		u1IRQHS165:1;
    uint_io32_t		u1IRQHS166:1;
    uint_io32_t		u1IRQHS167:1;
    uint_io32_t		u1IRQHS168:1;
    uint_io32_t		u1IRQHS169:1;
    uint_io32_t		u1IRQHS170:1;
    uint_io32_t		u1IRQHS171:1;
    uint_io32_t		u1IRQHS172:1;
    uint_io32_t		u1IRQHS173:1;
    uint_io32_t		u1IRQHS174:1;
    uint_io32_t		u1IRQHS175:1;
    uint_io32_t		u1IRQHS176:1;
    uint_io32_t		u1IRQHS177:1;
    uint_io32_t		u1IRQHS178:1;
    uint_io32_t		u1IRQHS179:1;
    uint_io32_t		u1IRQHS180:1;
    uint_io32_t		u1IRQHS181:1;
    uint_io32_t		u1IRQHS182:1;
    uint_io32_t		u1IRQHS183:1;
    uint_io32_t		u1IRQHS184:1;
    uint_io32_t		u1IRQHS185:1;
    uint_io32_t		u1IRQHS186:1;
    uint_io32_t		u1IRQHS187:1;
    uint_io32_t		u1IRQHS188:1;
    uint_io32_t		u1IRQHS189:1;
    uint_io32_t		u1IRQHS190:1;
    uint_io32_t		u1IRQHS191:1;
}stc_irc0_irqhs5_field_t;

typedef union un_irc0_irqhs5{
    uint_io32_t		u32Register;
    stc_irc0_irqhs5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs5_t;

/* IRQHS6 */
#define IRC0_IRQHS6	(IRC0.unIRQHS6.u32Register)  /*@rg@*/
#define IRC0_IRQHS6_IRQHS192	(IRC0.unIRQHS6.stcField.u1IRQHS192)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS193	(IRC0.unIRQHS6.stcField.u1IRQHS193)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS194	(IRC0.unIRQHS6.stcField.u1IRQHS194)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS195	(IRC0.unIRQHS6.stcField.u1IRQHS195)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS196	(IRC0.unIRQHS6.stcField.u1IRQHS196)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS197	(IRC0.unIRQHS6.stcField.u1IRQHS197)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS198	(IRC0.unIRQHS6.stcField.u1IRQHS198)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS199	(IRC0.unIRQHS6.stcField.u1IRQHS199)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS200	(IRC0.unIRQHS6.stcField.u1IRQHS200)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS201	(IRC0.unIRQHS6.stcField.u1IRQHS201)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS202	(IRC0.unIRQHS6.stcField.u1IRQHS202)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS203	(IRC0.unIRQHS6.stcField.u1IRQHS203)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS204	(IRC0.unIRQHS6.stcField.u1IRQHS204)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS205	(IRC0.unIRQHS6.stcField.u1IRQHS205)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS206	(IRC0.unIRQHS6.stcField.u1IRQHS206)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS207	(IRC0.unIRQHS6.stcField.u1IRQHS207)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS208	(IRC0.unIRQHS6.stcField.u1IRQHS208)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS209	(IRC0.unIRQHS6.stcField.u1IRQHS209)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS210	(IRC0.unIRQHS6.stcField.u1IRQHS210)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS211	(IRC0.unIRQHS6.stcField.u1IRQHS211)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS212	(IRC0.unIRQHS6.stcField.u1IRQHS212)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS213	(IRC0.unIRQHS6.stcField.u1IRQHS213)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS214	(IRC0.unIRQHS6.stcField.u1IRQHS214)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS215	(IRC0.unIRQHS6.stcField.u1IRQHS215)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS216	(IRC0.unIRQHS6.stcField.u1IRQHS216)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS217	(IRC0.unIRQHS6.stcField.u1IRQHS217)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS218	(IRC0.unIRQHS6.stcField.u1IRQHS218)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS219	(IRC0.unIRQHS6.stcField.u1IRQHS219)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS220	(IRC0.unIRQHS6.stcField.u1IRQHS220)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS221	(IRC0.unIRQHS6.stcField.u1IRQHS221)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS222	(IRC0.unIRQHS6.stcField.u1IRQHS222)  /*@bf@*/
#define IRC0_IRQHS6_IRQHS223	(IRC0.unIRQHS6.stcField.u1IRQHS223)  /*@bf@*/

typedef struct stc_irc0_irqhs6_field{
    uint_io32_t		u1IRQHS192:1;
    uint_io32_t		u1IRQHS193:1;
    uint_io32_t		u1IRQHS194:1;
    uint_io32_t		u1IRQHS195:1;
    uint_io32_t		u1IRQHS196:1;
    uint_io32_t		u1IRQHS197:1;
    uint_io32_t		u1IRQHS198:1;
    uint_io32_t		u1IRQHS199:1;
    uint_io32_t		u1IRQHS200:1;
    uint_io32_t		u1IRQHS201:1;
    uint_io32_t		u1IRQHS202:1;
    uint_io32_t		u1IRQHS203:1;
    uint_io32_t		u1IRQHS204:1;
    uint_io32_t		u1IRQHS205:1;
    uint_io32_t		u1IRQHS206:1;
    uint_io32_t		u1IRQHS207:1;
    uint_io32_t		u1IRQHS208:1;
    uint_io32_t		u1IRQHS209:1;
    uint_io32_t		u1IRQHS210:1;
    uint_io32_t		u1IRQHS211:1;
    uint_io32_t		u1IRQHS212:1;
    uint_io32_t		u1IRQHS213:1;
    uint_io32_t		u1IRQHS214:1;
    uint_io32_t		u1IRQHS215:1;
    uint_io32_t		u1IRQHS216:1;
    uint_io32_t		u1IRQHS217:1;
    uint_io32_t		u1IRQHS218:1;
    uint_io32_t		u1IRQHS219:1;
    uint_io32_t		u1IRQHS220:1;
    uint_io32_t		u1IRQHS221:1;
    uint_io32_t		u1IRQHS222:1;
    uint_io32_t		u1IRQHS223:1;
}stc_irc0_irqhs6_field_t;

typedef union un_irc0_irqhs6{
    uint_io32_t		u32Register;
    stc_irc0_irqhs6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs6_t;

/* IRQHS7 */
#define IRC0_IRQHS7	(IRC0.unIRQHS7.u32Register)  /*@rg@*/
#define IRC0_IRQHS7_IRQHS224	(IRC0.unIRQHS7.stcField.u1IRQHS224)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS225	(IRC0.unIRQHS7.stcField.u1IRQHS225)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS226	(IRC0.unIRQHS7.stcField.u1IRQHS226)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS227	(IRC0.unIRQHS7.stcField.u1IRQHS227)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS228	(IRC0.unIRQHS7.stcField.u1IRQHS228)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS229	(IRC0.unIRQHS7.stcField.u1IRQHS229)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS230	(IRC0.unIRQHS7.stcField.u1IRQHS230)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS231	(IRC0.unIRQHS7.stcField.u1IRQHS231)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS232	(IRC0.unIRQHS7.stcField.u1IRQHS232)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS233	(IRC0.unIRQHS7.stcField.u1IRQHS233)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS234	(IRC0.unIRQHS7.stcField.u1IRQHS234)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS235	(IRC0.unIRQHS7.stcField.u1IRQHS235)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS236	(IRC0.unIRQHS7.stcField.u1IRQHS236)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS237	(IRC0.unIRQHS7.stcField.u1IRQHS237)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS238	(IRC0.unIRQHS7.stcField.u1IRQHS238)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS239	(IRC0.unIRQHS7.stcField.u1IRQHS239)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS240	(IRC0.unIRQHS7.stcField.u1IRQHS240)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS241	(IRC0.unIRQHS7.stcField.u1IRQHS241)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS242	(IRC0.unIRQHS7.stcField.u1IRQHS242)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS243	(IRC0.unIRQHS7.stcField.u1IRQHS243)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS244	(IRC0.unIRQHS7.stcField.u1IRQHS244)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS245	(IRC0.unIRQHS7.stcField.u1IRQHS245)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS246	(IRC0.unIRQHS7.stcField.u1IRQHS246)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS247	(IRC0.unIRQHS7.stcField.u1IRQHS247)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS248	(IRC0.unIRQHS7.stcField.u1IRQHS248)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS249	(IRC0.unIRQHS7.stcField.u1IRQHS249)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS250	(IRC0.unIRQHS7.stcField.u1IRQHS250)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS251	(IRC0.unIRQHS7.stcField.u1IRQHS251)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS252	(IRC0.unIRQHS7.stcField.u1IRQHS252)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS253	(IRC0.unIRQHS7.stcField.u1IRQHS253)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS254	(IRC0.unIRQHS7.stcField.u1IRQHS254)  /*@bf@*/
#define IRC0_IRQHS7_IRQHS255	(IRC0.unIRQHS7.stcField.u1IRQHS255)  /*@bf@*/

typedef struct stc_irc0_irqhs7_field{
    uint_io32_t		u1IRQHS224:1;
    uint_io32_t		u1IRQHS225:1;
    uint_io32_t		u1IRQHS226:1;
    uint_io32_t		u1IRQHS227:1;
    uint_io32_t		u1IRQHS228:1;
    uint_io32_t		u1IRQHS229:1;
    uint_io32_t		u1IRQHS230:1;
    uint_io32_t		u1IRQHS231:1;
    uint_io32_t		u1IRQHS232:1;
    uint_io32_t		u1IRQHS233:1;
    uint_io32_t		u1IRQHS234:1;
    uint_io32_t		u1IRQHS235:1;
    uint_io32_t		u1IRQHS236:1;
    uint_io32_t		u1IRQHS237:1;
    uint_io32_t		u1IRQHS238:1;
    uint_io32_t		u1IRQHS239:1;
    uint_io32_t		u1IRQHS240:1;
    uint_io32_t		u1IRQHS241:1;
    uint_io32_t		u1IRQHS242:1;
    uint_io32_t		u1IRQHS243:1;
    uint_io32_t		u1IRQHS244:1;
    uint_io32_t		u1IRQHS245:1;
    uint_io32_t		u1IRQHS246:1;
    uint_io32_t		u1IRQHS247:1;
    uint_io32_t		u1IRQHS248:1;
    uint_io32_t		u1IRQHS249:1;
    uint_io32_t		u1IRQHS250:1;
    uint_io32_t		u1IRQHS251:1;
    uint_io32_t		u1IRQHS252:1;
    uint_io32_t		u1IRQHS253:1;
    uint_io32_t		u1IRQHS254:1;
    uint_io32_t		u1IRQHS255:1;
}stc_irc0_irqhs7_field_t;

typedef union un_irc0_irqhs7{
    uint_io32_t		u32Register;
    stc_irc0_irqhs7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs7_t;

/* IRQHS8 */
#define IRC0_IRQHS8	(IRC0.unIRQHS8.u32Register)  /*@rg@*/
#define IRC0_IRQHS8_IRQHS256	(IRC0.unIRQHS8.stcField.u1IRQHS256)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS257	(IRC0.unIRQHS8.stcField.u1IRQHS257)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS258	(IRC0.unIRQHS8.stcField.u1IRQHS258)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS259	(IRC0.unIRQHS8.stcField.u1IRQHS259)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS260	(IRC0.unIRQHS8.stcField.u1IRQHS260)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS261	(IRC0.unIRQHS8.stcField.u1IRQHS261)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS262	(IRC0.unIRQHS8.stcField.u1IRQHS262)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS263	(IRC0.unIRQHS8.stcField.u1IRQHS263)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS264	(IRC0.unIRQHS8.stcField.u1IRQHS264)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS265	(IRC0.unIRQHS8.stcField.u1IRQHS265)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS266	(IRC0.unIRQHS8.stcField.u1IRQHS266)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS267	(IRC0.unIRQHS8.stcField.u1IRQHS267)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS268	(IRC0.unIRQHS8.stcField.u1IRQHS268)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS269	(IRC0.unIRQHS8.stcField.u1IRQHS269)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS270	(IRC0.unIRQHS8.stcField.u1IRQHS270)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS271	(IRC0.unIRQHS8.stcField.u1IRQHS271)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS272	(IRC0.unIRQHS8.stcField.u1IRQHS272)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS273	(IRC0.unIRQHS8.stcField.u1IRQHS273)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS274	(IRC0.unIRQHS8.stcField.u1IRQHS274)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS275	(IRC0.unIRQHS8.stcField.u1IRQHS275)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS276	(IRC0.unIRQHS8.stcField.u1IRQHS276)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS277	(IRC0.unIRQHS8.stcField.u1IRQHS277)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS278	(IRC0.unIRQHS8.stcField.u1IRQHS278)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS279	(IRC0.unIRQHS8.stcField.u1IRQHS279)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS280	(IRC0.unIRQHS8.stcField.u1IRQHS280)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS281	(IRC0.unIRQHS8.stcField.u1IRQHS281)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS282	(IRC0.unIRQHS8.stcField.u1IRQHS282)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS283	(IRC0.unIRQHS8.stcField.u1IRQHS283)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS284	(IRC0.unIRQHS8.stcField.u1IRQHS284)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS285	(IRC0.unIRQHS8.stcField.u1IRQHS285)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS286	(IRC0.unIRQHS8.stcField.u1IRQHS286)  /*@bf@*/
#define IRC0_IRQHS8_IRQHS287	(IRC0.unIRQHS8.stcField.u1IRQHS287)  /*@bf@*/

typedef struct stc_irc0_irqhs8_field{
    uint_io32_t		u1IRQHS256:1;
    uint_io32_t		u1IRQHS257:1;
    uint_io32_t		u1IRQHS258:1;
    uint_io32_t		u1IRQHS259:1;
    uint_io32_t		u1IRQHS260:1;
    uint_io32_t		u1IRQHS261:1;
    uint_io32_t		u1IRQHS262:1;
    uint_io32_t		u1IRQHS263:1;
    uint_io32_t		u1IRQHS264:1;
    uint_io32_t		u1IRQHS265:1;
    uint_io32_t		u1IRQHS266:1;
    uint_io32_t		u1IRQHS267:1;
    uint_io32_t		u1IRQHS268:1;
    uint_io32_t		u1IRQHS269:1;
    uint_io32_t		u1IRQHS270:1;
    uint_io32_t		u1IRQHS271:1;
    uint_io32_t		u1IRQHS272:1;
    uint_io32_t		u1IRQHS273:1;
    uint_io32_t		u1IRQHS274:1;
    uint_io32_t		u1IRQHS275:1;
    uint_io32_t		u1IRQHS276:1;
    uint_io32_t		u1IRQHS277:1;
    uint_io32_t		u1IRQHS278:1;
    uint_io32_t		u1IRQHS279:1;
    uint_io32_t		u1IRQHS280:1;
    uint_io32_t		u1IRQHS281:1;
    uint_io32_t		u1IRQHS282:1;
    uint_io32_t		u1IRQHS283:1;
    uint_io32_t		u1IRQHS284:1;
    uint_io32_t		u1IRQHS285:1;
    uint_io32_t		u1IRQHS286:1;
    uint_io32_t		u1IRQHS287:1;
}stc_irc0_irqhs8_field_t;

typedef union un_irc0_irqhs8{
    uint_io32_t		u32Register;
    stc_irc0_irqhs8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs8_t;

/* IRQHS9 */
#define IRC0_IRQHS9	(IRC0.unIRQHS9.u32Register)  /*@rg@*/
#define IRC0_IRQHS9_IRQHS288	(IRC0.unIRQHS9.stcField.u1IRQHS288)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS289	(IRC0.unIRQHS9.stcField.u1IRQHS289)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS290	(IRC0.unIRQHS9.stcField.u1IRQHS290)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS291	(IRC0.unIRQHS9.stcField.u1IRQHS291)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS292	(IRC0.unIRQHS9.stcField.u1IRQHS292)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS293	(IRC0.unIRQHS9.stcField.u1IRQHS293)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS294	(IRC0.unIRQHS9.stcField.u1IRQHS294)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS295	(IRC0.unIRQHS9.stcField.u1IRQHS295)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS296	(IRC0.unIRQHS9.stcField.u1IRQHS296)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS297	(IRC0.unIRQHS9.stcField.u1IRQHS297)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS298	(IRC0.unIRQHS9.stcField.u1IRQHS298)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS299	(IRC0.unIRQHS9.stcField.u1IRQHS299)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS300	(IRC0.unIRQHS9.stcField.u1IRQHS300)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS301	(IRC0.unIRQHS9.stcField.u1IRQHS301)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS302	(IRC0.unIRQHS9.stcField.u1IRQHS302)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS303	(IRC0.unIRQHS9.stcField.u1IRQHS303)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS304	(IRC0.unIRQHS9.stcField.u1IRQHS304)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS305	(IRC0.unIRQHS9.stcField.u1IRQHS305)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS306	(IRC0.unIRQHS9.stcField.u1IRQHS306)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS307	(IRC0.unIRQHS9.stcField.u1IRQHS307)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS308	(IRC0.unIRQHS9.stcField.u1IRQHS308)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS309	(IRC0.unIRQHS9.stcField.u1IRQHS309)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS310	(IRC0.unIRQHS9.stcField.u1IRQHS310)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS311	(IRC0.unIRQHS9.stcField.u1IRQHS311)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS312	(IRC0.unIRQHS9.stcField.u1IRQHS312)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS313	(IRC0.unIRQHS9.stcField.u1IRQHS313)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS314	(IRC0.unIRQHS9.stcField.u1IRQHS314)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS315	(IRC0.unIRQHS9.stcField.u1IRQHS315)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS316	(IRC0.unIRQHS9.stcField.u1IRQHS316)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS317	(IRC0.unIRQHS9.stcField.u1IRQHS317)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS318	(IRC0.unIRQHS9.stcField.u1IRQHS318)  /*@bf@*/
#define IRC0_IRQHS9_IRQHS319	(IRC0.unIRQHS9.stcField.u1IRQHS319)  /*@bf@*/

typedef struct stc_irc0_irqhs9_field{
    uint_io32_t		u1IRQHS288:1;
    uint_io32_t		u1IRQHS289:1;
    uint_io32_t		u1IRQHS290:1;
    uint_io32_t		u1IRQHS291:1;
    uint_io32_t		u1IRQHS292:1;
    uint_io32_t		u1IRQHS293:1;
    uint_io32_t		u1IRQHS294:1;
    uint_io32_t		u1IRQHS295:1;
    uint_io32_t		u1IRQHS296:1;
    uint_io32_t		u1IRQHS297:1;
    uint_io32_t		u1IRQHS298:1;
    uint_io32_t		u1IRQHS299:1;
    uint_io32_t		u1IRQHS300:1;
    uint_io32_t		u1IRQHS301:1;
    uint_io32_t		u1IRQHS302:1;
    uint_io32_t		u1IRQHS303:1;
    uint_io32_t		u1IRQHS304:1;
    uint_io32_t		u1IRQHS305:1;
    uint_io32_t		u1IRQHS306:1;
    uint_io32_t		u1IRQHS307:1;
    uint_io32_t		u1IRQHS308:1;
    uint_io32_t		u1IRQHS309:1;
    uint_io32_t		u1IRQHS310:1;
    uint_io32_t		u1IRQHS311:1;
    uint_io32_t		u1IRQHS312:1;
    uint_io32_t		u1IRQHS313:1;
    uint_io32_t		u1IRQHS314:1;
    uint_io32_t		u1IRQHS315:1;
    uint_io32_t		u1IRQHS316:1;
    uint_io32_t		u1IRQHS317:1;
    uint_io32_t		u1IRQHS318:1;
    uint_io32_t		u1IRQHS319:1;
}stc_irc0_irqhs9_field_t;

typedef union un_irc0_irqhs9{
    uint_io32_t		u32Register;
    stc_irc0_irqhs9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs9_t;

/* IRQHS10 */
#define IRC0_IRQHS10	(IRC0.unIRQHS10.u32Register)  /*@rg@*/
#define IRC0_IRQHS10_IRQHS320	(IRC0.unIRQHS10.stcField.u1IRQHS320)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS321	(IRC0.unIRQHS10.stcField.u1IRQHS321)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS322	(IRC0.unIRQHS10.stcField.u1IRQHS322)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS323	(IRC0.unIRQHS10.stcField.u1IRQHS323)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS324	(IRC0.unIRQHS10.stcField.u1IRQHS324)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS325	(IRC0.unIRQHS10.stcField.u1IRQHS325)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS326	(IRC0.unIRQHS10.stcField.u1IRQHS326)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS327	(IRC0.unIRQHS10.stcField.u1IRQHS327)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS328	(IRC0.unIRQHS10.stcField.u1IRQHS328)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS329	(IRC0.unIRQHS10.stcField.u1IRQHS329)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS330	(IRC0.unIRQHS10.stcField.u1IRQHS330)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS331	(IRC0.unIRQHS10.stcField.u1IRQHS331)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS332	(IRC0.unIRQHS10.stcField.u1IRQHS332)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS333	(IRC0.unIRQHS10.stcField.u1IRQHS333)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS334	(IRC0.unIRQHS10.stcField.u1IRQHS334)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS335	(IRC0.unIRQHS10.stcField.u1IRQHS335)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS336	(IRC0.unIRQHS10.stcField.u1IRQHS336)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS337	(IRC0.unIRQHS10.stcField.u1IRQHS337)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS338	(IRC0.unIRQHS10.stcField.u1IRQHS338)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS339	(IRC0.unIRQHS10.stcField.u1IRQHS339)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS340	(IRC0.unIRQHS10.stcField.u1IRQHS340)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS341	(IRC0.unIRQHS10.stcField.u1IRQHS341)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS342	(IRC0.unIRQHS10.stcField.u1IRQHS342)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS343	(IRC0.unIRQHS10.stcField.u1IRQHS343)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS344	(IRC0.unIRQHS10.stcField.u1IRQHS344)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS345	(IRC0.unIRQHS10.stcField.u1IRQHS345)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS346	(IRC0.unIRQHS10.stcField.u1IRQHS346)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS347	(IRC0.unIRQHS10.stcField.u1IRQHS347)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS348	(IRC0.unIRQHS10.stcField.u1IRQHS348)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS349	(IRC0.unIRQHS10.stcField.u1IRQHS349)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS350	(IRC0.unIRQHS10.stcField.u1IRQHS350)  /*@bf@*/
#define IRC0_IRQHS10_IRQHS351	(IRC0.unIRQHS10.stcField.u1IRQHS351)  /*@bf@*/

typedef struct stc_irc0_irqhs10_field{
    uint_io32_t		u1IRQHS320:1;
    uint_io32_t		u1IRQHS321:1;
    uint_io32_t		u1IRQHS322:1;
    uint_io32_t		u1IRQHS323:1;
    uint_io32_t		u1IRQHS324:1;
    uint_io32_t		u1IRQHS325:1;
    uint_io32_t		u1IRQHS326:1;
    uint_io32_t		u1IRQHS327:1;
    uint_io32_t		u1IRQHS328:1;
    uint_io32_t		u1IRQHS329:1;
    uint_io32_t		u1IRQHS330:1;
    uint_io32_t		u1IRQHS331:1;
    uint_io32_t		u1IRQHS332:1;
    uint_io32_t		u1IRQHS333:1;
    uint_io32_t		u1IRQHS334:1;
    uint_io32_t		u1IRQHS335:1;
    uint_io32_t		u1IRQHS336:1;
    uint_io32_t		u1IRQHS337:1;
    uint_io32_t		u1IRQHS338:1;
    uint_io32_t		u1IRQHS339:1;
    uint_io32_t		u1IRQHS340:1;
    uint_io32_t		u1IRQHS341:1;
    uint_io32_t		u1IRQHS342:1;
    uint_io32_t		u1IRQHS343:1;
    uint_io32_t		u1IRQHS344:1;
    uint_io32_t		u1IRQHS345:1;
    uint_io32_t		u1IRQHS346:1;
    uint_io32_t		u1IRQHS347:1;
    uint_io32_t		u1IRQHS348:1;
    uint_io32_t		u1IRQHS349:1;
    uint_io32_t		u1IRQHS350:1;
    uint_io32_t		u1IRQHS351:1;
}stc_irc0_irqhs10_field_t;

typedef union un_irc0_irqhs10{
    uint_io32_t		u32Register;
    stc_irc0_irqhs10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs10_t;

/* IRQHS11 */
#define IRC0_IRQHS11	(IRC0.unIRQHS11.u32Register)  /*@rg@*/
#define IRC0_IRQHS11_IRQHS352	(IRC0.unIRQHS11.stcField.u1IRQHS352)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS353	(IRC0.unIRQHS11.stcField.u1IRQHS353)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS354	(IRC0.unIRQHS11.stcField.u1IRQHS354)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS355	(IRC0.unIRQHS11.stcField.u1IRQHS355)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS356	(IRC0.unIRQHS11.stcField.u1IRQHS356)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS357	(IRC0.unIRQHS11.stcField.u1IRQHS357)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS358	(IRC0.unIRQHS11.stcField.u1IRQHS358)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS359	(IRC0.unIRQHS11.stcField.u1IRQHS359)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS360	(IRC0.unIRQHS11.stcField.u1IRQHS360)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS361	(IRC0.unIRQHS11.stcField.u1IRQHS361)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS362	(IRC0.unIRQHS11.stcField.u1IRQHS362)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS363	(IRC0.unIRQHS11.stcField.u1IRQHS363)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS364	(IRC0.unIRQHS11.stcField.u1IRQHS364)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS365	(IRC0.unIRQHS11.stcField.u1IRQHS365)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS366	(IRC0.unIRQHS11.stcField.u1IRQHS366)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS367	(IRC0.unIRQHS11.stcField.u1IRQHS367)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS368	(IRC0.unIRQHS11.stcField.u1IRQHS368)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS369	(IRC0.unIRQHS11.stcField.u1IRQHS369)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS370	(IRC0.unIRQHS11.stcField.u1IRQHS370)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS371	(IRC0.unIRQHS11.stcField.u1IRQHS371)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS372	(IRC0.unIRQHS11.stcField.u1IRQHS372)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS373	(IRC0.unIRQHS11.stcField.u1IRQHS373)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS374	(IRC0.unIRQHS11.stcField.u1IRQHS374)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS375	(IRC0.unIRQHS11.stcField.u1IRQHS375)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS376	(IRC0.unIRQHS11.stcField.u1IRQHS376)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS377	(IRC0.unIRQHS11.stcField.u1IRQHS377)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS378	(IRC0.unIRQHS11.stcField.u1IRQHS378)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS379	(IRC0.unIRQHS11.stcField.u1IRQHS379)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS380	(IRC0.unIRQHS11.stcField.u1IRQHS380)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS381	(IRC0.unIRQHS11.stcField.u1IRQHS381)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS382	(IRC0.unIRQHS11.stcField.u1IRQHS382)  /*@bf@*/
#define IRC0_IRQHS11_IRQHS383	(IRC0.unIRQHS11.stcField.u1IRQHS383)  /*@bf@*/

typedef struct stc_irc0_irqhs11_field{
    uint_io32_t		u1IRQHS352:1;
    uint_io32_t		u1IRQHS353:1;
    uint_io32_t		u1IRQHS354:1;
    uint_io32_t		u1IRQHS355:1;
    uint_io32_t		u1IRQHS356:1;
    uint_io32_t		u1IRQHS357:1;
    uint_io32_t		u1IRQHS358:1;
    uint_io32_t		u1IRQHS359:1;
    uint_io32_t		u1IRQHS360:1;
    uint_io32_t		u1IRQHS361:1;
    uint_io32_t		u1IRQHS362:1;
    uint_io32_t		u1IRQHS363:1;
    uint_io32_t		u1IRQHS364:1;
    uint_io32_t		u1IRQHS365:1;
    uint_io32_t		u1IRQHS366:1;
    uint_io32_t		u1IRQHS367:1;
    uint_io32_t		u1IRQHS368:1;
    uint_io32_t		u1IRQHS369:1;
    uint_io32_t		u1IRQHS370:1;
    uint_io32_t		u1IRQHS371:1;
    uint_io32_t		u1IRQHS372:1;
    uint_io32_t		u1IRQHS373:1;
    uint_io32_t		u1IRQHS374:1;
    uint_io32_t		u1IRQHS375:1;
    uint_io32_t		u1IRQHS376:1;
    uint_io32_t		u1IRQHS377:1;
    uint_io32_t		u1IRQHS378:1;
    uint_io32_t		u1IRQHS379:1;
    uint_io32_t		u1IRQHS380:1;
    uint_io32_t		u1IRQHS381:1;
    uint_io32_t		u1IRQHS382:1;
    uint_io32_t		u1IRQHS383:1;
}stc_irc0_irqhs11_field_t;

typedef union un_irc0_irqhs11{
    uint_io32_t		u32Register;
    stc_irc0_irqhs11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs11_t;

/* IRQHS12 */
#define IRC0_IRQHS12	(IRC0.unIRQHS12.u32Register)  /*@rg@*/
#define IRC0_IRQHS12_IRQHS384	(IRC0.unIRQHS12.stcField.u1IRQHS384)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS385	(IRC0.unIRQHS12.stcField.u1IRQHS385)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS386	(IRC0.unIRQHS12.stcField.u1IRQHS386)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS387	(IRC0.unIRQHS12.stcField.u1IRQHS387)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS388	(IRC0.unIRQHS12.stcField.u1IRQHS388)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS389	(IRC0.unIRQHS12.stcField.u1IRQHS389)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS390	(IRC0.unIRQHS12.stcField.u1IRQHS390)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS391	(IRC0.unIRQHS12.stcField.u1IRQHS391)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS392	(IRC0.unIRQHS12.stcField.u1IRQHS392)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS393	(IRC0.unIRQHS12.stcField.u1IRQHS393)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS394	(IRC0.unIRQHS12.stcField.u1IRQHS394)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS395	(IRC0.unIRQHS12.stcField.u1IRQHS395)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS396	(IRC0.unIRQHS12.stcField.u1IRQHS396)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS397	(IRC0.unIRQHS12.stcField.u1IRQHS397)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS398	(IRC0.unIRQHS12.stcField.u1IRQHS398)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS399	(IRC0.unIRQHS12.stcField.u1IRQHS399)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS400	(IRC0.unIRQHS12.stcField.u1IRQHS400)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS401	(IRC0.unIRQHS12.stcField.u1IRQHS401)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS402	(IRC0.unIRQHS12.stcField.u1IRQHS402)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS403	(IRC0.unIRQHS12.stcField.u1IRQHS403)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS404	(IRC0.unIRQHS12.stcField.u1IRQHS404)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS405	(IRC0.unIRQHS12.stcField.u1IRQHS405)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS406	(IRC0.unIRQHS12.stcField.u1IRQHS406)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS407	(IRC0.unIRQHS12.stcField.u1IRQHS407)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS408	(IRC0.unIRQHS12.stcField.u1IRQHS408)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS409	(IRC0.unIRQHS12.stcField.u1IRQHS409)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS410	(IRC0.unIRQHS12.stcField.u1IRQHS410)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS411	(IRC0.unIRQHS12.stcField.u1IRQHS411)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS412	(IRC0.unIRQHS12.stcField.u1IRQHS412)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS413	(IRC0.unIRQHS12.stcField.u1IRQHS413)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS414	(IRC0.unIRQHS12.stcField.u1IRQHS414)  /*@bf@*/
#define IRC0_IRQHS12_IRQHS415	(IRC0.unIRQHS12.stcField.u1IRQHS415)  /*@bf@*/

typedef struct stc_irc0_irqhs12_field{
    uint_io32_t		u1IRQHS384:1;
    uint_io32_t		u1IRQHS385:1;
    uint_io32_t		u1IRQHS386:1;
    uint_io32_t		u1IRQHS387:1;
    uint_io32_t		u1IRQHS388:1;
    uint_io32_t		u1IRQHS389:1;
    uint_io32_t		u1IRQHS390:1;
    uint_io32_t		u1IRQHS391:1;
    uint_io32_t		u1IRQHS392:1;
    uint_io32_t		u1IRQHS393:1;
    uint_io32_t		u1IRQHS394:1;
    uint_io32_t		u1IRQHS395:1;
    uint_io32_t		u1IRQHS396:1;
    uint_io32_t		u1IRQHS397:1;
    uint_io32_t		u1IRQHS398:1;
    uint_io32_t		u1IRQHS399:1;
    uint_io32_t		u1IRQHS400:1;
    uint_io32_t		u1IRQHS401:1;
    uint_io32_t		u1IRQHS402:1;
    uint_io32_t		u1IRQHS403:1;
    uint_io32_t		u1IRQHS404:1;
    uint_io32_t		u1IRQHS405:1;
    uint_io32_t		u1IRQHS406:1;
    uint_io32_t		u1IRQHS407:1;
    uint_io32_t		u1IRQHS408:1;
    uint_io32_t		u1IRQHS409:1;
    uint_io32_t		u1IRQHS410:1;
    uint_io32_t		u1IRQHS411:1;
    uint_io32_t		u1IRQHS412:1;
    uint_io32_t		u1IRQHS413:1;
    uint_io32_t		u1IRQHS414:1;
    uint_io32_t		u1IRQHS415:1;
}stc_irc0_irqhs12_field_t;

typedef union un_irc0_irqhs12{
    uint_io32_t		u32Register;
    stc_irc0_irqhs12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs12_t;

/* IRQHS13 */
#define IRC0_IRQHS13	(IRC0.unIRQHS13.u32Register)  /*@rg@*/
#define IRC0_IRQHS13_IRQHS416	(IRC0.unIRQHS13.stcField.u1IRQHS416)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS417	(IRC0.unIRQHS13.stcField.u1IRQHS417)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS418	(IRC0.unIRQHS13.stcField.u1IRQHS418)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS419	(IRC0.unIRQHS13.stcField.u1IRQHS419)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS420	(IRC0.unIRQHS13.stcField.u1IRQHS420)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS421	(IRC0.unIRQHS13.stcField.u1IRQHS421)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS422	(IRC0.unIRQHS13.stcField.u1IRQHS422)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS423	(IRC0.unIRQHS13.stcField.u1IRQHS423)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS424	(IRC0.unIRQHS13.stcField.u1IRQHS424)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS425	(IRC0.unIRQHS13.stcField.u1IRQHS425)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS426	(IRC0.unIRQHS13.stcField.u1IRQHS426)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS427	(IRC0.unIRQHS13.stcField.u1IRQHS427)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS428	(IRC0.unIRQHS13.stcField.u1IRQHS428)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS429	(IRC0.unIRQHS13.stcField.u1IRQHS429)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS430	(IRC0.unIRQHS13.stcField.u1IRQHS430)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS431	(IRC0.unIRQHS13.stcField.u1IRQHS431)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS432	(IRC0.unIRQHS13.stcField.u1IRQHS432)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS433	(IRC0.unIRQHS13.stcField.u1IRQHS433)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS434	(IRC0.unIRQHS13.stcField.u1IRQHS434)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS435	(IRC0.unIRQHS13.stcField.u1IRQHS435)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS436	(IRC0.unIRQHS13.stcField.u1IRQHS436)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS437	(IRC0.unIRQHS13.stcField.u1IRQHS437)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS438	(IRC0.unIRQHS13.stcField.u1IRQHS438)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS439	(IRC0.unIRQHS13.stcField.u1IRQHS439)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS440	(IRC0.unIRQHS13.stcField.u1IRQHS440)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS441	(IRC0.unIRQHS13.stcField.u1IRQHS441)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS442	(IRC0.unIRQHS13.stcField.u1IRQHS442)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS443	(IRC0.unIRQHS13.stcField.u1IRQHS443)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS444	(IRC0.unIRQHS13.stcField.u1IRQHS444)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS445	(IRC0.unIRQHS13.stcField.u1IRQHS445)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS446	(IRC0.unIRQHS13.stcField.u1IRQHS446)  /*@bf@*/
#define IRC0_IRQHS13_IRQHS447	(IRC0.unIRQHS13.stcField.u1IRQHS447)  /*@bf@*/

typedef struct stc_irc0_irqhs13_field{
    uint_io32_t		u1IRQHS416:1;
    uint_io32_t		u1IRQHS417:1;
    uint_io32_t		u1IRQHS418:1;
    uint_io32_t		u1IRQHS419:1;
    uint_io32_t		u1IRQHS420:1;
    uint_io32_t		u1IRQHS421:1;
    uint_io32_t		u1IRQHS422:1;
    uint_io32_t		u1IRQHS423:1;
    uint_io32_t		u1IRQHS424:1;
    uint_io32_t		u1IRQHS425:1;
    uint_io32_t		u1IRQHS426:1;
    uint_io32_t		u1IRQHS427:1;
    uint_io32_t		u1IRQHS428:1;
    uint_io32_t		u1IRQHS429:1;
    uint_io32_t		u1IRQHS430:1;
    uint_io32_t		u1IRQHS431:1;
    uint_io32_t		u1IRQHS432:1;
    uint_io32_t		u1IRQHS433:1;
    uint_io32_t		u1IRQHS434:1;
    uint_io32_t		u1IRQHS435:1;
    uint_io32_t		u1IRQHS436:1;
    uint_io32_t		u1IRQHS437:1;
    uint_io32_t		u1IRQHS438:1;
    uint_io32_t		u1IRQHS439:1;
    uint_io32_t		u1IRQHS440:1;
    uint_io32_t		u1IRQHS441:1;
    uint_io32_t		u1IRQHS442:1;
    uint_io32_t		u1IRQHS443:1;
    uint_io32_t		u1IRQHS444:1;
    uint_io32_t		u1IRQHS445:1;
    uint_io32_t		u1IRQHS446:1;
    uint_io32_t		u1IRQHS447:1;
}stc_irc0_irqhs13_field_t;

typedef union un_irc0_irqhs13{
    uint_io32_t		u32Register;
    stc_irc0_irqhs13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs13_t;

/* IRQHS14 */
#define IRC0_IRQHS14	(IRC0.unIRQHS14.u32Register)  /*@rg@*/
#define IRC0_IRQHS14_IRQHS448	(IRC0.unIRQHS14.stcField.u1IRQHS448)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS449	(IRC0.unIRQHS14.stcField.u1IRQHS449)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS450	(IRC0.unIRQHS14.stcField.u1IRQHS450)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS451	(IRC0.unIRQHS14.stcField.u1IRQHS451)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS452	(IRC0.unIRQHS14.stcField.u1IRQHS452)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS453	(IRC0.unIRQHS14.stcField.u1IRQHS453)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS454	(IRC0.unIRQHS14.stcField.u1IRQHS454)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS455	(IRC0.unIRQHS14.stcField.u1IRQHS455)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS456	(IRC0.unIRQHS14.stcField.u1IRQHS456)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS457	(IRC0.unIRQHS14.stcField.u1IRQHS457)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS458	(IRC0.unIRQHS14.stcField.u1IRQHS458)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS459	(IRC0.unIRQHS14.stcField.u1IRQHS459)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS460	(IRC0.unIRQHS14.stcField.u1IRQHS460)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS461	(IRC0.unIRQHS14.stcField.u1IRQHS461)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS462	(IRC0.unIRQHS14.stcField.u1IRQHS462)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS463	(IRC0.unIRQHS14.stcField.u1IRQHS463)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS464	(IRC0.unIRQHS14.stcField.u1IRQHS464)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS465	(IRC0.unIRQHS14.stcField.u1IRQHS465)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS466	(IRC0.unIRQHS14.stcField.u1IRQHS466)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS467	(IRC0.unIRQHS14.stcField.u1IRQHS467)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS468	(IRC0.unIRQHS14.stcField.u1IRQHS468)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS469	(IRC0.unIRQHS14.stcField.u1IRQHS469)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS470	(IRC0.unIRQHS14.stcField.u1IRQHS470)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS471	(IRC0.unIRQHS14.stcField.u1IRQHS471)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS472	(IRC0.unIRQHS14.stcField.u1IRQHS472)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS473	(IRC0.unIRQHS14.stcField.u1IRQHS473)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS474	(IRC0.unIRQHS14.stcField.u1IRQHS474)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS475	(IRC0.unIRQHS14.stcField.u1IRQHS475)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS476	(IRC0.unIRQHS14.stcField.u1IRQHS476)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS477	(IRC0.unIRQHS14.stcField.u1IRQHS477)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS478	(IRC0.unIRQHS14.stcField.u1IRQHS478)  /*@bf@*/
#define IRC0_IRQHS14_IRQHS479	(IRC0.unIRQHS14.stcField.u1IRQHS479)  /*@bf@*/

typedef struct stc_irc0_irqhs14_field{
    uint_io32_t		u1IRQHS448:1;
    uint_io32_t		u1IRQHS449:1;
    uint_io32_t		u1IRQHS450:1;
    uint_io32_t		u1IRQHS451:1;
    uint_io32_t		u1IRQHS452:1;
    uint_io32_t		u1IRQHS453:1;
    uint_io32_t		u1IRQHS454:1;
    uint_io32_t		u1IRQHS455:1;
    uint_io32_t		u1IRQHS456:1;
    uint_io32_t		u1IRQHS457:1;
    uint_io32_t		u1IRQHS458:1;
    uint_io32_t		u1IRQHS459:1;
    uint_io32_t		u1IRQHS460:1;
    uint_io32_t		u1IRQHS461:1;
    uint_io32_t		u1IRQHS462:1;
    uint_io32_t		u1IRQHS463:1;
    uint_io32_t		u1IRQHS464:1;
    uint_io32_t		u1IRQHS465:1;
    uint_io32_t		u1IRQHS466:1;
    uint_io32_t		u1IRQHS467:1;
    uint_io32_t		u1IRQHS468:1;
    uint_io32_t		u1IRQHS469:1;
    uint_io32_t		u1IRQHS470:1;
    uint_io32_t		u1IRQHS471:1;
    uint_io32_t		u1IRQHS472:1;
    uint_io32_t		u1IRQHS473:1;
    uint_io32_t		u1IRQHS474:1;
    uint_io32_t		u1IRQHS475:1;
    uint_io32_t		u1IRQHS476:1;
    uint_io32_t		u1IRQHS477:1;
    uint_io32_t		u1IRQHS478:1;
    uint_io32_t		u1IRQHS479:1;
}stc_irc0_irqhs14_field_t;

typedef union un_irc0_irqhs14{
    uint_io32_t		u32Register;
    stc_irc0_irqhs14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs14_t;

/* IRQHS15 */
#define IRC0_IRQHS15	(IRC0.unIRQHS15.u32Register)  /*@rg@*/
#define IRC0_IRQHS15_IRQHS480	(IRC0.unIRQHS15.stcField.u1IRQHS480)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS481	(IRC0.unIRQHS15.stcField.u1IRQHS481)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS482	(IRC0.unIRQHS15.stcField.u1IRQHS482)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS483	(IRC0.unIRQHS15.stcField.u1IRQHS483)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS484	(IRC0.unIRQHS15.stcField.u1IRQHS484)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS485	(IRC0.unIRQHS15.stcField.u1IRQHS485)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS486	(IRC0.unIRQHS15.stcField.u1IRQHS486)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS487	(IRC0.unIRQHS15.stcField.u1IRQHS487)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS488	(IRC0.unIRQHS15.stcField.u1IRQHS488)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS489	(IRC0.unIRQHS15.stcField.u1IRQHS489)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS490	(IRC0.unIRQHS15.stcField.u1IRQHS490)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS491	(IRC0.unIRQHS15.stcField.u1IRQHS491)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS492	(IRC0.unIRQHS15.stcField.u1IRQHS492)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS493	(IRC0.unIRQHS15.stcField.u1IRQHS493)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS494	(IRC0.unIRQHS15.stcField.u1IRQHS494)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS495	(IRC0.unIRQHS15.stcField.u1IRQHS495)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS496	(IRC0.unIRQHS15.stcField.u1IRQHS496)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS497	(IRC0.unIRQHS15.stcField.u1IRQHS497)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS498	(IRC0.unIRQHS15.stcField.u1IRQHS498)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS499	(IRC0.unIRQHS15.stcField.u1IRQHS499)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS500	(IRC0.unIRQHS15.stcField.u1IRQHS500)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS501	(IRC0.unIRQHS15.stcField.u1IRQHS501)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS502	(IRC0.unIRQHS15.stcField.u1IRQHS502)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS503	(IRC0.unIRQHS15.stcField.u1IRQHS503)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS504	(IRC0.unIRQHS15.stcField.u1IRQHS504)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS505	(IRC0.unIRQHS15.stcField.u1IRQHS505)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS506	(IRC0.unIRQHS15.stcField.u1IRQHS506)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS507	(IRC0.unIRQHS15.stcField.u1IRQHS507)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS508	(IRC0.unIRQHS15.stcField.u1IRQHS508)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS509	(IRC0.unIRQHS15.stcField.u1IRQHS509)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS510	(IRC0.unIRQHS15.stcField.u1IRQHS510)  /*@bf@*/
#define IRC0_IRQHS15_IRQHS511	(IRC0.unIRQHS15.stcField.u1IRQHS511)  /*@bf@*/

typedef struct stc_irc0_irqhs15_field{
    uint_io32_t		u1IRQHS480:1;
    uint_io32_t		u1IRQHS481:1;
    uint_io32_t		u1IRQHS482:1;
    uint_io32_t		u1IRQHS483:1;
    uint_io32_t		u1IRQHS484:1;
    uint_io32_t		u1IRQHS485:1;
    uint_io32_t		u1IRQHS486:1;
    uint_io32_t		u1IRQHS487:1;
    uint_io32_t		u1IRQHS488:1;
    uint_io32_t		u1IRQHS489:1;
    uint_io32_t		u1IRQHS490:1;
    uint_io32_t		u1IRQHS491:1;
    uint_io32_t		u1IRQHS492:1;
    uint_io32_t		u1IRQHS493:1;
    uint_io32_t		u1IRQHS494:1;
    uint_io32_t		u1IRQHS495:1;
    uint_io32_t		u1IRQHS496:1;
    uint_io32_t		u1IRQHS497:1;
    uint_io32_t		u1IRQHS498:1;
    uint_io32_t		u1IRQHS499:1;
    uint_io32_t		u1IRQHS500:1;
    uint_io32_t		u1IRQHS501:1;
    uint_io32_t		u1IRQHS502:1;
    uint_io32_t		u1IRQHS503:1;
    uint_io32_t		u1IRQHS504:1;
    uint_io32_t		u1IRQHS505:1;
    uint_io32_t		u1IRQHS506:1;
    uint_io32_t		u1IRQHS507:1;
    uint_io32_t		u1IRQHS508:1;
    uint_io32_t		u1IRQHS509:1;
    uint_io32_t		u1IRQHS510:1;
    uint_io32_t		u1IRQHS511:1;
}stc_irc0_irqhs15_field_t;

typedef union un_irc0_irqhs15{
    uint_io32_t		u32Register;
    stc_irc0_irqhs15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqhs15_t;

/* IRQPLM */
#define IRC0_IRQPLM	(IRC0.unIRQPLM.u32Register)  /*@rg@*/
#define IRC0_IRQPLM_IRQPLM	(IRC0.unIRQPLM.stcField.u6IRQPLM)  /*@bf@*/

typedef struct stc_irc0_irqplm_field{
    uint_io32_t		u6IRQPLM:6;
    uint_io32_t		:26;
}stc_irc0_irqplm_field_t;

typedef union un_irc0_irqplm{
    uint_io32_t		u32Register;
    stc_irc0_irqplm_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqplm_t;

/* CSR */
#define IRC0_CSR	(IRC0.unCSR.u32Register)  /*@rg@*/
#define IRC0_CSR_IRQEN	(IRC0.unCSR.stcField.u1IRQEN)  /*@bf@*/
#define IRC0_CSR_LST	(IRC0.unCSR.stcField.u1LST)  /*@bf@*/

typedef struct stc_irc0_csr_field{
    uint_io32_t		u1IRQEN:1;
    uint_io32_t		:15;
    uint_io32_t		u1LST:1;
    uint_io32_t		:15;
}stc_irc0_csr_field_t;

typedef union un_irc0_csr{
    uint_io32_t		u32Register;
    stc_irc0_csr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_csr_t;

/* NMIRS */
#define IRC0_NMIRS	(IRC0.unNMIRS.u32Register)  /*@rg@*/
#define IRC0_NMIRS_NMIRS0	(IRC0.unNMIRS.stcField.u1NMIRS0)  /*@bf@*/
#define IRC0_NMIRS_NMIRS1	(IRC0.unNMIRS.stcField.u1NMIRS1)  /*@bf@*/
#define IRC0_NMIRS_NMIRS2	(IRC0.unNMIRS.stcField.u1NMIRS2)  /*@bf@*/
#define IRC0_NMIRS_NMIRS3	(IRC0.unNMIRS.stcField.u1NMIRS3)  /*@bf@*/
#define IRC0_NMIRS_NMIRS4	(IRC0.unNMIRS.stcField.u1NMIRS4)  /*@bf@*/
#define IRC0_NMIRS_NMIRS5	(IRC0.unNMIRS.stcField.u1NMIRS5)  /*@bf@*/
#define IRC0_NMIRS_NMIRS6	(IRC0.unNMIRS.stcField.u1NMIRS6)  /*@bf@*/
#define IRC0_NMIRS_NMIRS7	(IRC0.unNMIRS.stcField.u1NMIRS7)  /*@bf@*/
#define IRC0_NMIRS_NMIRS8	(IRC0.unNMIRS.stcField.u1NMIRS8)  /*@bf@*/
#define IRC0_NMIRS_NMIRS9	(IRC0.unNMIRS.stcField.u1NMIRS9)  /*@bf@*/
#define IRC0_NMIRS_NMIRS10	(IRC0.unNMIRS.stcField.u1NMIRS10)  /*@bf@*/
#define IRC0_NMIRS_NMIRS11	(IRC0.unNMIRS.stcField.u1NMIRS11)  /*@bf@*/
#define IRC0_NMIRS_NMIRS12	(IRC0.unNMIRS.stcField.u1NMIRS12)  /*@bf@*/
#define IRC0_NMIRS_NMIRS13	(IRC0.unNMIRS.stcField.u1NMIRS13)  /*@bf@*/
#define IRC0_NMIRS_NMIRS14	(IRC0.unNMIRS.stcField.u1NMIRS14)  /*@bf@*/
#define IRC0_NMIRS_NMIRS15	(IRC0.unNMIRS.stcField.u1NMIRS15)  /*@bf@*/
#define IRC0_NMIRS_NMIRS16	(IRC0.unNMIRS.stcField.u1NMIRS16)  /*@bf@*/
#define IRC0_NMIRS_NMIRS17	(IRC0.unNMIRS.stcField.u1NMIRS17)  /*@bf@*/
#define IRC0_NMIRS_NMIRS18	(IRC0.unNMIRS.stcField.u1NMIRS18)  /*@bf@*/
#define IRC0_NMIRS_NMIRS19	(IRC0.unNMIRS.stcField.u1NMIRS19)  /*@bf@*/
#define IRC0_NMIRS_NMIRS20	(IRC0.unNMIRS.stcField.u1NMIRS20)  /*@bf@*/
#define IRC0_NMIRS_NMIRS21	(IRC0.unNMIRS.stcField.u1NMIRS21)  /*@bf@*/
#define IRC0_NMIRS_NMIRS22	(IRC0.unNMIRS.stcField.u1NMIRS22)  /*@bf@*/
#define IRC0_NMIRS_NMIRS23	(IRC0.unNMIRS.stcField.u1NMIRS23)  /*@bf@*/
#define IRC0_NMIRS_NMIRS24	(IRC0.unNMIRS.stcField.u1NMIRS24)  /*@bf@*/
#define IRC0_NMIRS_NMIRS25	(IRC0.unNMIRS.stcField.u1NMIRS25)  /*@bf@*/
#define IRC0_NMIRS_NMIRS26	(IRC0.unNMIRS.stcField.u1NMIRS26)  /*@bf@*/
#define IRC0_NMIRS_NMIRS27	(IRC0.unNMIRS.stcField.u1NMIRS27)  /*@bf@*/
#define IRC0_NMIRS_NMIRS28	(IRC0.unNMIRS.stcField.u1NMIRS28)  /*@bf@*/
#define IRC0_NMIRS_NMIRS29	(IRC0.unNMIRS.stcField.u1NMIRS29)  /*@bf@*/
#define IRC0_NMIRS_NMIRS30	(IRC0.unNMIRS.stcField.u1NMIRS30)  /*@bf@*/
#define IRC0_NMIRS_NMIRS31	(IRC0.unNMIRS.stcField.u1NMIRS31)  /*@bf@*/

typedef struct stc_irc0_nmirs_field{
    uint_io32_t		u1NMIRS0:1;
    uint_io32_t		u1NMIRS1:1;
    uint_io32_t		u1NMIRS2:1;
    uint_io32_t		u1NMIRS3:1;
    uint_io32_t		u1NMIRS4:1;
    uint_io32_t		u1NMIRS5:1;
    uint_io32_t		u1NMIRS6:1;
    uint_io32_t		u1NMIRS7:1;
    uint_io32_t		u1NMIRS8:1;
    uint_io32_t		u1NMIRS9:1;
    uint_io32_t		u1NMIRS10:1;
    uint_io32_t		u1NMIRS11:1;
    uint_io32_t		u1NMIRS12:1;
    uint_io32_t		u1NMIRS13:1;
    uint_io32_t		u1NMIRS14:1;
    uint_io32_t		u1NMIRS15:1;
    uint_io32_t		u1NMIRS16:1;
    uint_io32_t		u1NMIRS17:1;
    uint_io32_t		u1NMIRS18:1;
    uint_io32_t		u1NMIRS19:1;
    uint_io32_t		u1NMIRS20:1;
    uint_io32_t		u1NMIRS21:1;
    uint_io32_t		u1NMIRS22:1;
    uint_io32_t		u1NMIRS23:1;
    uint_io32_t		u1NMIRS24:1;
    uint_io32_t		u1NMIRS25:1;
    uint_io32_t		u1NMIRS26:1;
    uint_io32_t		u1NMIRS27:1;
    uint_io32_t		u1NMIRS28:1;
    uint_io32_t		u1NMIRS29:1;
    uint_io32_t		u1NMIRS30:1;
    uint_io32_t		u1NMIRS31:1;
}stc_irc0_nmirs_field_t;

typedef union un_irc0_nmirs{
    uint_io32_t		u32Register;
    stc_irc0_nmirs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmirs_t;

/* NMIPS */
#define IRC0_NMIPS	(IRC0.unNMIPS.u32Register)  /*@rg@*/
#define IRC0_NMIPS_NMIPS0	(IRC0.unNMIPS.stcField.u1NMIPS0)  /*@bf@*/
#define IRC0_NMIPS_NMIPS1	(IRC0.unNMIPS.stcField.u1NMIPS1)  /*@bf@*/
#define IRC0_NMIPS_NMIPS2	(IRC0.unNMIPS.stcField.u1NMIPS2)  /*@bf@*/
#define IRC0_NMIPS_NMIPS3	(IRC0.unNMIPS.stcField.u1NMIPS3)  /*@bf@*/
#define IRC0_NMIPS_NMIPS4	(IRC0.unNMIPS.stcField.u1NMIPS4)  /*@bf@*/
#define IRC0_NMIPS_NMIPS5	(IRC0.unNMIPS.stcField.u1NMIPS5)  /*@bf@*/
#define IRC0_NMIPS_NMIPS6	(IRC0.unNMIPS.stcField.u1NMIPS6)  /*@bf@*/
#define IRC0_NMIPS_NMIPS7	(IRC0.unNMIPS.stcField.u1NMIPS7)  /*@bf@*/
#define IRC0_NMIPS_NMIPS8	(IRC0.unNMIPS.stcField.u1NMIPS8)  /*@bf@*/
#define IRC0_NMIPS_NMIPS9	(IRC0.unNMIPS.stcField.u1NMIPS9)  /*@bf@*/
#define IRC0_NMIPS_NMIPS10	(IRC0.unNMIPS.stcField.u1NMIPS10)  /*@bf@*/
#define IRC0_NMIPS_NMIPS11	(IRC0.unNMIPS.stcField.u1NMIPS11)  /*@bf@*/
#define IRC0_NMIPS_NMIPS12	(IRC0.unNMIPS.stcField.u1NMIPS12)  /*@bf@*/
#define IRC0_NMIPS_NMIPS13	(IRC0.unNMIPS.stcField.u1NMIPS13)  /*@bf@*/
#define IRC0_NMIPS_NMIPS14	(IRC0.unNMIPS.stcField.u1NMIPS14)  /*@bf@*/
#define IRC0_NMIPS_NMIPS15	(IRC0.unNMIPS.stcField.u1NMIPS15)  /*@bf@*/
#define IRC0_NMIPS_NMIPS16	(IRC0.unNMIPS.stcField.u1NMIPS16)  /*@bf@*/
#define IRC0_NMIPS_NMIPS17	(IRC0.unNMIPS.stcField.u1NMIPS17)  /*@bf@*/
#define IRC0_NMIPS_NMIPS18	(IRC0.unNMIPS.stcField.u1NMIPS18)  /*@bf@*/
#define IRC0_NMIPS_NMIPS19	(IRC0.unNMIPS.stcField.u1NMIPS19)  /*@bf@*/
#define IRC0_NMIPS_NMIPS20	(IRC0.unNMIPS.stcField.u1NMIPS20)  /*@bf@*/
#define IRC0_NMIPS_NMIPS21	(IRC0.unNMIPS.stcField.u1NMIPS21)  /*@bf@*/
#define IRC0_NMIPS_NMIPS22	(IRC0.unNMIPS.stcField.u1NMIPS22)  /*@bf@*/
#define IRC0_NMIPS_NMIPS23	(IRC0.unNMIPS.stcField.u1NMIPS23)  /*@bf@*/
#define IRC0_NMIPS_NMIPS24	(IRC0.unNMIPS.stcField.u1NMIPS24)  /*@bf@*/
#define IRC0_NMIPS_NMIPS25	(IRC0.unNMIPS.stcField.u1NMIPS25)  /*@bf@*/
#define IRC0_NMIPS_NMIPS26	(IRC0.unNMIPS.stcField.u1NMIPS26)  /*@bf@*/
#define IRC0_NMIPS_NMIPS27	(IRC0.unNMIPS.stcField.u1NMIPS27)  /*@bf@*/
#define IRC0_NMIPS_NMIPS28	(IRC0.unNMIPS.stcField.u1NMIPS28)  /*@bf@*/
#define IRC0_NMIPS_NMIPS29	(IRC0.unNMIPS.stcField.u1NMIPS29)  /*@bf@*/
#define IRC0_NMIPS_NMIPS30	(IRC0.unNMIPS.stcField.u1NMIPS30)  /*@bf@*/
#define IRC0_NMIPS_NMIPS31	(IRC0.unNMIPS.stcField.u1NMIPS31)  /*@bf@*/

typedef struct stc_irc0_nmips_field{
    uint_io32_t		u1NMIPS0:1;
    uint_io32_t		u1NMIPS1:1;
    uint_io32_t		u1NMIPS2:1;
    uint_io32_t		u1NMIPS3:1;
    uint_io32_t		u1NMIPS4:1;
    uint_io32_t		u1NMIPS5:1;
    uint_io32_t		u1NMIPS6:1;
    uint_io32_t		u1NMIPS7:1;
    uint_io32_t		u1NMIPS8:1;
    uint_io32_t		u1NMIPS9:1;
    uint_io32_t		u1NMIPS10:1;
    uint_io32_t		u1NMIPS11:1;
    uint_io32_t		u1NMIPS12:1;
    uint_io32_t		u1NMIPS13:1;
    uint_io32_t		u1NMIPS14:1;
    uint_io32_t		u1NMIPS15:1;
    uint_io32_t		u1NMIPS16:1;
    uint_io32_t		u1NMIPS17:1;
    uint_io32_t		u1NMIPS18:1;
    uint_io32_t		u1NMIPS19:1;
    uint_io32_t		u1NMIPS20:1;
    uint_io32_t		u1NMIPS21:1;
    uint_io32_t		u1NMIPS22:1;
    uint_io32_t		u1NMIPS23:1;
    uint_io32_t		u1NMIPS24:1;
    uint_io32_t		u1NMIPS25:1;
    uint_io32_t		u1NMIPS26:1;
    uint_io32_t		u1NMIPS27:1;
    uint_io32_t		u1NMIPS28:1;
    uint_io32_t		u1NMIPS29:1;
    uint_io32_t		u1NMIPS30:1;
    uint_io32_t		u1NMIPS31:1;
}stc_irc0_nmips_field_t;

typedef union un_irc0_nmips{
    uint_io32_t		u32Register;
    stc_irc0_nmips_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_nmips_t;

/* IRQRS0 */
#define IRC0_IRQRS0	(IRC0.unIRQRS0.u32Register)  /*@rg@*/
#define IRC0_IRQRS0_IRQRS0	(IRC0.unIRQRS0.stcField.u1IRQRS0)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS1	(IRC0.unIRQRS0.stcField.u1IRQRS1)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS2	(IRC0.unIRQRS0.stcField.u1IRQRS2)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS3	(IRC0.unIRQRS0.stcField.u1IRQRS3)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS4	(IRC0.unIRQRS0.stcField.u1IRQRS4)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS5	(IRC0.unIRQRS0.stcField.u1IRQRS5)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS6	(IRC0.unIRQRS0.stcField.u1IRQRS6)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS7	(IRC0.unIRQRS0.stcField.u1IRQRS7)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS8	(IRC0.unIRQRS0.stcField.u1IRQRS8)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS9	(IRC0.unIRQRS0.stcField.u1IRQRS9)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS10	(IRC0.unIRQRS0.stcField.u1IRQRS10)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS11	(IRC0.unIRQRS0.stcField.u1IRQRS11)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS12	(IRC0.unIRQRS0.stcField.u1IRQRS12)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS13	(IRC0.unIRQRS0.stcField.u1IRQRS13)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS14	(IRC0.unIRQRS0.stcField.u1IRQRS14)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS15	(IRC0.unIRQRS0.stcField.u1IRQRS15)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS16	(IRC0.unIRQRS0.stcField.u1IRQRS16)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS17	(IRC0.unIRQRS0.stcField.u1IRQRS17)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS18	(IRC0.unIRQRS0.stcField.u1IRQRS18)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS19	(IRC0.unIRQRS0.stcField.u1IRQRS19)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS20	(IRC0.unIRQRS0.stcField.u1IRQRS20)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS21	(IRC0.unIRQRS0.stcField.u1IRQRS21)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS22	(IRC0.unIRQRS0.stcField.u1IRQRS22)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS23	(IRC0.unIRQRS0.stcField.u1IRQRS23)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS24	(IRC0.unIRQRS0.stcField.u1IRQRS24)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS25	(IRC0.unIRQRS0.stcField.u1IRQRS25)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS26	(IRC0.unIRQRS0.stcField.u1IRQRS26)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS27	(IRC0.unIRQRS0.stcField.u1IRQRS27)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS28	(IRC0.unIRQRS0.stcField.u1IRQRS28)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS29	(IRC0.unIRQRS0.stcField.u1IRQRS29)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS30	(IRC0.unIRQRS0.stcField.u1IRQRS30)  /*@bf@*/
#define IRC0_IRQRS0_IRQRS31	(IRC0.unIRQRS0.stcField.u1IRQRS31)  /*@bf@*/

typedef struct stc_irc0_irqrs0_field{
    uint_io32_t		u1IRQRS0:1;
    uint_io32_t		u1IRQRS1:1;
    uint_io32_t		u1IRQRS2:1;
    uint_io32_t		u1IRQRS3:1;
    uint_io32_t		u1IRQRS4:1;
    uint_io32_t		u1IRQRS5:1;
    uint_io32_t		u1IRQRS6:1;
    uint_io32_t		u1IRQRS7:1;
    uint_io32_t		u1IRQRS8:1;
    uint_io32_t		u1IRQRS9:1;
    uint_io32_t		u1IRQRS10:1;
    uint_io32_t		u1IRQRS11:1;
    uint_io32_t		u1IRQRS12:1;
    uint_io32_t		u1IRQRS13:1;
    uint_io32_t		u1IRQRS14:1;
    uint_io32_t		u1IRQRS15:1;
    uint_io32_t		u1IRQRS16:1;
    uint_io32_t		u1IRQRS17:1;
    uint_io32_t		u1IRQRS18:1;
    uint_io32_t		u1IRQRS19:1;
    uint_io32_t		u1IRQRS20:1;
    uint_io32_t		u1IRQRS21:1;
    uint_io32_t		u1IRQRS22:1;
    uint_io32_t		u1IRQRS23:1;
    uint_io32_t		u1IRQRS24:1;
    uint_io32_t		u1IRQRS25:1;
    uint_io32_t		u1IRQRS26:1;
    uint_io32_t		u1IRQRS27:1;
    uint_io32_t		u1IRQRS28:1;
    uint_io32_t		u1IRQRS29:1;
    uint_io32_t		u1IRQRS30:1;
    uint_io32_t		u1IRQRS31:1;
}stc_irc0_irqrs0_field_t;

typedef union un_irc0_irqrs0{
    uint_io32_t		u32Register;
    stc_irc0_irqrs0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs0_t;

/* IRQRS1 */
#define IRC0_IRQRS1	(IRC0.unIRQRS1.u32Register)  /*@rg@*/
#define IRC0_IRQRS1_IRQRS32	(IRC0.unIRQRS1.stcField.u1IRQRS32)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS33	(IRC0.unIRQRS1.stcField.u1IRQRS33)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS34	(IRC0.unIRQRS1.stcField.u1IRQRS34)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS35	(IRC0.unIRQRS1.stcField.u1IRQRS35)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS36	(IRC0.unIRQRS1.stcField.u1IRQRS36)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS37	(IRC0.unIRQRS1.stcField.u1IRQRS37)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS38	(IRC0.unIRQRS1.stcField.u1IRQRS38)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS39	(IRC0.unIRQRS1.stcField.u1IRQRS39)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS40	(IRC0.unIRQRS1.stcField.u1IRQRS40)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS41	(IRC0.unIRQRS1.stcField.u1IRQRS41)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS42	(IRC0.unIRQRS1.stcField.u1IRQRS42)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS43	(IRC0.unIRQRS1.stcField.u1IRQRS43)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS44	(IRC0.unIRQRS1.stcField.u1IRQRS44)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS45	(IRC0.unIRQRS1.stcField.u1IRQRS45)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS46	(IRC0.unIRQRS1.stcField.u1IRQRS46)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS47	(IRC0.unIRQRS1.stcField.u1IRQRS47)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS48	(IRC0.unIRQRS1.stcField.u1IRQRS48)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS49	(IRC0.unIRQRS1.stcField.u1IRQRS49)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS50	(IRC0.unIRQRS1.stcField.u1IRQRS50)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS51	(IRC0.unIRQRS1.stcField.u1IRQRS51)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS52	(IRC0.unIRQRS1.stcField.u1IRQRS52)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS53	(IRC0.unIRQRS1.stcField.u1IRQRS53)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS54	(IRC0.unIRQRS1.stcField.u1IRQRS54)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS55	(IRC0.unIRQRS1.stcField.u1IRQRS55)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS56	(IRC0.unIRQRS1.stcField.u1IRQRS56)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS57	(IRC0.unIRQRS1.stcField.u1IRQRS57)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS58	(IRC0.unIRQRS1.stcField.u1IRQRS58)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS59	(IRC0.unIRQRS1.stcField.u1IRQRS59)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS60	(IRC0.unIRQRS1.stcField.u1IRQRS60)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS61	(IRC0.unIRQRS1.stcField.u1IRQRS61)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS62	(IRC0.unIRQRS1.stcField.u1IRQRS62)  /*@bf@*/
#define IRC0_IRQRS1_IRQRS63	(IRC0.unIRQRS1.stcField.u1IRQRS63)  /*@bf@*/

typedef struct stc_irc0_irqrs1_field{
    uint_io32_t		u1IRQRS32:1;
    uint_io32_t		u1IRQRS33:1;
    uint_io32_t		u1IRQRS34:1;
    uint_io32_t		u1IRQRS35:1;
    uint_io32_t		u1IRQRS36:1;
    uint_io32_t		u1IRQRS37:1;
    uint_io32_t		u1IRQRS38:1;
    uint_io32_t		u1IRQRS39:1;
    uint_io32_t		u1IRQRS40:1;
    uint_io32_t		u1IRQRS41:1;
    uint_io32_t		u1IRQRS42:1;
    uint_io32_t		u1IRQRS43:1;
    uint_io32_t		u1IRQRS44:1;
    uint_io32_t		u1IRQRS45:1;
    uint_io32_t		u1IRQRS46:1;
    uint_io32_t		u1IRQRS47:1;
    uint_io32_t		u1IRQRS48:1;
    uint_io32_t		u1IRQRS49:1;
    uint_io32_t		u1IRQRS50:1;
    uint_io32_t		u1IRQRS51:1;
    uint_io32_t		u1IRQRS52:1;
    uint_io32_t		u1IRQRS53:1;
    uint_io32_t		u1IRQRS54:1;
    uint_io32_t		u1IRQRS55:1;
    uint_io32_t		u1IRQRS56:1;
    uint_io32_t		u1IRQRS57:1;
    uint_io32_t		u1IRQRS58:1;
    uint_io32_t		u1IRQRS59:1;
    uint_io32_t		u1IRQRS60:1;
    uint_io32_t		u1IRQRS61:1;
    uint_io32_t		u1IRQRS62:1;
    uint_io32_t		u1IRQRS63:1;
}stc_irc0_irqrs1_field_t;

typedef union un_irc0_irqrs1{
    uint_io32_t		u32Register;
    stc_irc0_irqrs1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs1_t;

/* IRQRS2 */
#define IRC0_IRQRS2	(IRC0.unIRQRS2.u32Register)  /*@rg@*/
#define IRC0_IRQRS2_IRQRS64	(IRC0.unIRQRS2.stcField.u1IRQRS64)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS65	(IRC0.unIRQRS2.stcField.u1IRQRS65)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS66	(IRC0.unIRQRS2.stcField.u1IRQRS66)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS67	(IRC0.unIRQRS2.stcField.u1IRQRS67)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS68	(IRC0.unIRQRS2.stcField.u1IRQRS68)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS69	(IRC0.unIRQRS2.stcField.u1IRQRS69)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS70	(IRC0.unIRQRS2.stcField.u1IRQRS70)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS71	(IRC0.unIRQRS2.stcField.u1IRQRS71)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS72	(IRC0.unIRQRS2.stcField.u1IRQRS72)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS73	(IRC0.unIRQRS2.stcField.u1IRQRS73)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS74	(IRC0.unIRQRS2.stcField.u1IRQRS74)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS75	(IRC0.unIRQRS2.stcField.u1IRQRS75)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS76	(IRC0.unIRQRS2.stcField.u1IRQRS76)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS77	(IRC0.unIRQRS2.stcField.u1IRQRS77)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS78	(IRC0.unIRQRS2.stcField.u1IRQRS78)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS79	(IRC0.unIRQRS2.stcField.u1IRQRS79)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS80	(IRC0.unIRQRS2.stcField.u1IRQRS80)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS81	(IRC0.unIRQRS2.stcField.u1IRQRS81)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS82	(IRC0.unIRQRS2.stcField.u1IRQRS82)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS83	(IRC0.unIRQRS2.stcField.u1IRQRS83)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS84	(IRC0.unIRQRS2.stcField.u1IRQRS84)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS85	(IRC0.unIRQRS2.stcField.u1IRQRS85)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS86	(IRC0.unIRQRS2.stcField.u1IRQRS86)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS87	(IRC0.unIRQRS2.stcField.u1IRQRS87)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS88	(IRC0.unIRQRS2.stcField.u1IRQRS88)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS89	(IRC0.unIRQRS2.stcField.u1IRQRS89)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS90	(IRC0.unIRQRS2.stcField.u1IRQRS90)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS91	(IRC0.unIRQRS2.stcField.u1IRQRS91)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS92	(IRC0.unIRQRS2.stcField.u1IRQRS92)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS93	(IRC0.unIRQRS2.stcField.u1IRQRS93)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS94	(IRC0.unIRQRS2.stcField.u1IRQRS94)  /*@bf@*/
#define IRC0_IRQRS2_IRQRS95	(IRC0.unIRQRS2.stcField.u1IRQRS95)  /*@bf@*/

typedef struct stc_irc0_irqrs2_field{
    uint_io32_t		u1IRQRS64:1;
    uint_io32_t		u1IRQRS65:1;
    uint_io32_t		u1IRQRS66:1;
    uint_io32_t		u1IRQRS67:1;
    uint_io32_t		u1IRQRS68:1;
    uint_io32_t		u1IRQRS69:1;
    uint_io32_t		u1IRQRS70:1;
    uint_io32_t		u1IRQRS71:1;
    uint_io32_t		u1IRQRS72:1;
    uint_io32_t		u1IRQRS73:1;
    uint_io32_t		u1IRQRS74:1;
    uint_io32_t		u1IRQRS75:1;
    uint_io32_t		u1IRQRS76:1;
    uint_io32_t		u1IRQRS77:1;
    uint_io32_t		u1IRQRS78:1;
    uint_io32_t		u1IRQRS79:1;
    uint_io32_t		u1IRQRS80:1;
    uint_io32_t		u1IRQRS81:1;
    uint_io32_t		u1IRQRS82:1;
    uint_io32_t		u1IRQRS83:1;
    uint_io32_t		u1IRQRS84:1;
    uint_io32_t		u1IRQRS85:1;
    uint_io32_t		u1IRQRS86:1;
    uint_io32_t		u1IRQRS87:1;
    uint_io32_t		u1IRQRS88:1;
    uint_io32_t		u1IRQRS89:1;
    uint_io32_t		u1IRQRS90:1;
    uint_io32_t		u1IRQRS91:1;
    uint_io32_t		u1IRQRS92:1;
    uint_io32_t		u1IRQRS93:1;
    uint_io32_t		u1IRQRS94:1;
    uint_io32_t		u1IRQRS95:1;
}stc_irc0_irqrs2_field_t;

typedef union un_irc0_irqrs2{
    uint_io32_t		u32Register;
    stc_irc0_irqrs2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs2_t;

/* IRQRS3 */
#define IRC0_IRQRS3	(IRC0.unIRQRS3.u32Register)  /*@rg@*/
#define IRC0_IRQRS3_IRQRS96	(IRC0.unIRQRS3.stcField.u1IRQRS96)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS97	(IRC0.unIRQRS3.stcField.u1IRQRS97)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS98	(IRC0.unIRQRS3.stcField.u1IRQRS98)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS99	(IRC0.unIRQRS3.stcField.u1IRQRS99)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS100	(IRC0.unIRQRS3.stcField.u1IRQRS100)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS101	(IRC0.unIRQRS3.stcField.u1IRQRS101)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS102	(IRC0.unIRQRS3.stcField.u1IRQRS102)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS103	(IRC0.unIRQRS3.stcField.u1IRQRS103)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS104	(IRC0.unIRQRS3.stcField.u1IRQRS104)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS105	(IRC0.unIRQRS3.stcField.u1IRQRS105)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS106	(IRC0.unIRQRS3.stcField.u1IRQRS106)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS107	(IRC0.unIRQRS3.stcField.u1IRQRS107)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS108	(IRC0.unIRQRS3.stcField.u1IRQRS108)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS109	(IRC0.unIRQRS3.stcField.u1IRQRS109)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS110	(IRC0.unIRQRS3.stcField.u1IRQRS110)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS111	(IRC0.unIRQRS3.stcField.u1IRQRS111)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS112	(IRC0.unIRQRS3.stcField.u1IRQRS112)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS113	(IRC0.unIRQRS3.stcField.u1IRQRS113)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS114	(IRC0.unIRQRS3.stcField.u1IRQRS114)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS115	(IRC0.unIRQRS3.stcField.u1IRQRS115)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS116	(IRC0.unIRQRS3.stcField.u1IRQRS116)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS117	(IRC0.unIRQRS3.stcField.u1IRQRS117)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS118	(IRC0.unIRQRS3.stcField.u1IRQRS118)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS119	(IRC0.unIRQRS3.stcField.u1IRQRS119)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS120	(IRC0.unIRQRS3.stcField.u1IRQRS120)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS121	(IRC0.unIRQRS3.stcField.u1IRQRS121)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS122	(IRC0.unIRQRS3.stcField.u1IRQRS122)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS123	(IRC0.unIRQRS3.stcField.u1IRQRS123)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS124	(IRC0.unIRQRS3.stcField.u1IRQRS124)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS125	(IRC0.unIRQRS3.stcField.u1IRQRS125)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS126	(IRC0.unIRQRS3.stcField.u1IRQRS126)  /*@bf@*/
#define IRC0_IRQRS3_IRQRS127	(IRC0.unIRQRS3.stcField.u1IRQRS127)  /*@bf@*/

typedef struct stc_irc0_irqrs3_field{
    uint_io32_t		u1IRQRS96:1;
    uint_io32_t		u1IRQRS97:1;
    uint_io32_t		u1IRQRS98:1;
    uint_io32_t		u1IRQRS99:1;
    uint_io32_t		u1IRQRS100:1;
    uint_io32_t		u1IRQRS101:1;
    uint_io32_t		u1IRQRS102:1;
    uint_io32_t		u1IRQRS103:1;
    uint_io32_t		u1IRQRS104:1;
    uint_io32_t		u1IRQRS105:1;
    uint_io32_t		u1IRQRS106:1;
    uint_io32_t		u1IRQRS107:1;
    uint_io32_t		u1IRQRS108:1;
    uint_io32_t		u1IRQRS109:1;
    uint_io32_t		u1IRQRS110:1;
    uint_io32_t		u1IRQRS111:1;
    uint_io32_t		u1IRQRS112:1;
    uint_io32_t		u1IRQRS113:1;
    uint_io32_t		u1IRQRS114:1;
    uint_io32_t		u1IRQRS115:1;
    uint_io32_t		u1IRQRS116:1;
    uint_io32_t		u1IRQRS117:1;
    uint_io32_t		u1IRQRS118:1;
    uint_io32_t		u1IRQRS119:1;
    uint_io32_t		u1IRQRS120:1;
    uint_io32_t		u1IRQRS121:1;
    uint_io32_t		u1IRQRS122:1;
    uint_io32_t		u1IRQRS123:1;
    uint_io32_t		u1IRQRS124:1;
    uint_io32_t		u1IRQRS125:1;
    uint_io32_t		u1IRQRS126:1;
    uint_io32_t		u1IRQRS127:1;
}stc_irc0_irqrs3_field_t;

typedef union un_irc0_irqrs3{
    uint_io32_t		u32Register;
    stc_irc0_irqrs3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs3_t;

/* IRQRS4 */
#define IRC0_IRQRS4	(IRC0.unIRQRS4.u32Register)  /*@rg@*/
#define IRC0_IRQRS4_IRQRS128	(IRC0.unIRQRS4.stcField.u1IRQRS128)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS129	(IRC0.unIRQRS4.stcField.u1IRQRS129)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS130	(IRC0.unIRQRS4.stcField.u1IRQRS130)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS131	(IRC0.unIRQRS4.stcField.u1IRQRS131)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS132	(IRC0.unIRQRS4.stcField.u1IRQRS132)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS133	(IRC0.unIRQRS4.stcField.u1IRQRS133)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS134	(IRC0.unIRQRS4.stcField.u1IRQRS134)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS135	(IRC0.unIRQRS4.stcField.u1IRQRS135)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS136	(IRC0.unIRQRS4.stcField.u1IRQRS136)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS137	(IRC0.unIRQRS4.stcField.u1IRQRS137)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS138	(IRC0.unIRQRS4.stcField.u1IRQRS138)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS139	(IRC0.unIRQRS4.stcField.u1IRQRS139)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS140	(IRC0.unIRQRS4.stcField.u1IRQRS140)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS141	(IRC0.unIRQRS4.stcField.u1IRQRS141)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS142	(IRC0.unIRQRS4.stcField.u1IRQRS142)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS143	(IRC0.unIRQRS4.stcField.u1IRQRS143)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS144	(IRC0.unIRQRS4.stcField.u1IRQRS144)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS145	(IRC0.unIRQRS4.stcField.u1IRQRS145)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS146	(IRC0.unIRQRS4.stcField.u1IRQRS146)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS147	(IRC0.unIRQRS4.stcField.u1IRQRS147)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS148	(IRC0.unIRQRS4.stcField.u1IRQRS148)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS149	(IRC0.unIRQRS4.stcField.u1IRQRS149)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS150	(IRC0.unIRQRS4.stcField.u1IRQRS150)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS151	(IRC0.unIRQRS4.stcField.u1IRQRS151)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS152	(IRC0.unIRQRS4.stcField.u1IRQRS152)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS153	(IRC0.unIRQRS4.stcField.u1IRQRS153)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS154	(IRC0.unIRQRS4.stcField.u1IRQRS154)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS155	(IRC0.unIRQRS4.stcField.u1IRQRS155)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS156	(IRC0.unIRQRS4.stcField.u1IRQRS156)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS157	(IRC0.unIRQRS4.stcField.u1IRQRS157)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS158	(IRC0.unIRQRS4.stcField.u1IRQRS158)  /*@bf@*/
#define IRC0_IRQRS4_IRQRS159	(IRC0.unIRQRS4.stcField.u1IRQRS159)  /*@bf@*/

typedef struct stc_irc0_irqrs4_field{
    uint_io32_t		u1IRQRS128:1;
    uint_io32_t		u1IRQRS129:1;
    uint_io32_t		u1IRQRS130:1;
    uint_io32_t		u1IRQRS131:1;
    uint_io32_t		u1IRQRS132:1;
    uint_io32_t		u1IRQRS133:1;
    uint_io32_t		u1IRQRS134:1;
    uint_io32_t		u1IRQRS135:1;
    uint_io32_t		u1IRQRS136:1;
    uint_io32_t		u1IRQRS137:1;
    uint_io32_t		u1IRQRS138:1;
    uint_io32_t		u1IRQRS139:1;
    uint_io32_t		u1IRQRS140:1;
    uint_io32_t		u1IRQRS141:1;
    uint_io32_t		u1IRQRS142:1;
    uint_io32_t		u1IRQRS143:1;
    uint_io32_t		u1IRQRS144:1;
    uint_io32_t		u1IRQRS145:1;
    uint_io32_t		u1IRQRS146:1;
    uint_io32_t		u1IRQRS147:1;
    uint_io32_t		u1IRQRS148:1;
    uint_io32_t		u1IRQRS149:1;
    uint_io32_t		u1IRQRS150:1;
    uint_io32_t		u1IRQRS151:1;
    uint_io32_t		u1IRQRS152:1;
    uint_io32_t		u1IRQRS153:1;
    uint_io32_t		u1IRQRS154:1;
    uint_io32_t		u1IRQRS155:1;
    uint_io32_t		u1IRQRS156:1;
    uint_io32_t		u1IRQRS157:1;
    uint_io32_t		u1IRQRS158:1;
    uint_io32_t		u1IRQRS159:1;
}stc_irc0_irqrs4_field_t;

typedef union un_irc0_irqrs4{
    uint_io32_t		u32Register;
    stc_irc0_irqrs4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs4_t;

/* IRQRS5 */
#define IRC0_IRQRS5	(IRC0.unIRQRS5.u32Register)  /*@rg@*/
#define IRC0_IRQRS5_IRQRS160	(IRC0.unIRQRS5.stcField.u1IRQRS160)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS161	(IRC0.unIRQRS5.stcField.u1IRQRS161)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS162	(IRC0.unIRQRS5.stcField.u1IRQRS162)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS163	(IRC0.unIRQRS5.stcField.u1IRQRS163)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS164	(IRC0.unIRQRS5.stcField.u1IRQRS164)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS165	(IRC0.unIRQRS5.stcField.u1IRQRS165)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS166	(IRC0.unIRQRS5.stcField.u1IRQRS166)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS167	(IRC0.unIRQRS5.stcField.u1IRQRS167)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS168	(IRC0.unIRQRS5.stcField.u1IRQRS168)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS169	(IRC0.unIRQRS5.stcField.u1IRQRS169)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS170	(IRC0.unIRQRS5.stcField.u1IRQRS170)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS171	(IRC0.unIRQRS5.stcField.u1IRQRS171)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS172	(IRC0.unIRQRS5.stcField.u1IRQRS172)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS173	(IRC0.unIRQRS5.stcField.u1IRQRS173)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS174	(IRC0.unIRQRS5.stcField.u1IRQRS174)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS175	(IRC0.unIRQRS5.stcField.u1IRQRS175)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS176	(IRC0.unIRQRS5.stcField.u1IRQRS176)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS177	(IRC0.unIRQRS5.stcField.u1IRQRS177)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS178	(IRC0.unIRQRS5.stcField.u1IRQRS178)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS179	(IRC0.unIRQRS5.stcField.u1IRQRS179)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS180	(IRC0.unIRQRS5.stcField.u1IRQRS180)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS181	(IRC0.unIRQRS5.stcField.u1IRQRS181)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS182	(IRC0.unIRQRS5.stcField.u1IRQRS182)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS183	(IRC0.unIRQRS5.stcField.u1IRQRS183)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS184	(IRC0.unIRQRS5.stcField.u1IRQRS184)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS185	(IRC0.unIRQRS5.stcField.u1IRQRS185)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS186	(IRC0.unIRQRS5.stcField.u1IRQRS186)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS187	(IRC0.unIRQRS5.stcField.u1IRQRS187)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS188	(IRC0.unIRQRS5.stcField.u1IRQRS188)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS189	(IRC0.unIRQRS5.stcField.u1IRQRS189)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS190	(IRC0.unIRQRS5.stcField.u1IRQRS190)  /*@bf@*/
#define IRC0_IRQRS5_IRQRS191	(IRC0.unIRQRS5.stcField.u1IRQRS191)  /*@bf@*/

typedef struct stc_irc0_irqrs5_field{
    uint_io32_t		u1IRQRS160:1;
    uint_io32_t		u1IRQRS161:1;
    uint_io32_t		u1IRQRS162:1;
    uint_io32_t		u1IRQRS163:1;
    uint_io32_t		u1IRQRS164:1;
    uint_io32_t		u1IRQRS165:1;
    uint_io32_t		u1IRQRS166:1;
    uint_io32_t		u1IRQRS167:1;
    uint_io32_t		u1IRQRS168:1;
    uint_io32_t		u1IRQRS169:1;
    uint_io32_t		u1IRQRS170:1;
    uint_io32_t		u1IRQRS171:1;
    uint_io32_t		u1IRQRS172:1;
    uint_io32_t		u1IRQRS173:1;
    uint_io32_t		u1IRQRS174:1;
    uint_io32_t		u1IRQRS175:1;
    uint_io32_t		u1IRQRS176:1;
    uint_io32_t		u1IRQRS177:1;
    uint_io32_t		u1IRQRS178:1;
    uint_io32_t		u1IRQRS179:1;
    uint_io32_t		u1IRQRS180:1;
    uint_io32_t		u1IRQRS181:1;
    uint_io32_t		u1IRQRS182:1;
    uint_io32_t		u1IRQRS183:1;
    uint_io32_t		u1IRQRS184:1;
    uint_io32_t		u1IRQRS185:1;
    uint_io32_t		u1IRQRS186:1;
    uint_io32_t		u1IRQRS187:1;
    uint_io32_t		u1IRQRS188:1;
    uint_io32_t		u1IRQRS189:1;
    uint_io32_t		u1IRQRS190:1;
    uint_io32_t		u1IRQRS191:1;
}stc_irc0_irqrs5_field_t;

typedef union un_irc0_irqrs5{
    uint_io32_t		u32Register;
    stc_irc0_irqrs5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs5_t;

/* IRQRS6 */
#define IRC0_IRQRS6	(IRC0.unIRQRS6.u32Register)  /*@rg@*/
#define IRC0_IRQRS6_IRQRS192	(IRC0.unIRQRS6.stcField.u1IRQRS192)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS193	(IRC0.unIRQRS6.stcField.u1IRQRS193)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS194	(IRC0.unIRQRS6.stcField.u1IRQRS194)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS195	(IRC0.unIRQRS6.stcField.u1IRQRS195)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS196	(IRC0.unIRQRS6.stcField.u1IRQRS196)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS197	(IRC0.unIRQRS6.stcField.u1IRQRS197)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS198	(IRC0.unIRQRS6.stcField.u1IRQRS198)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS199	(IRC0.unIRQRS6.stcField.u1IRQRS199)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS200	(IRC0.unIRQRS6.stcField.u1IRQRS200)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS201	(IRC0.unIRQRS6.stcField.u1IRQRS201)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS202	(IRC0.unIRQRS6.stcField.u1IRQRS202)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS203	(IRC0.unIRQRS6.stcField.u1IRQRS203)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS204	(IRC0.unIRQRS6.stcField.u1IRQRS204)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS205	(IRC0.unIRQRS6.stcField.u1IRQRS205)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS206	(IRC0.unIRQRS6.stcField.u1IRQRS206)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS207	(IRC0.unIRQRS6.stcField.u1IRQRS207)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS208	(IRC0.unIRQRS6.stcField.u1IRQRS208)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS209	(IRC0.unIRQRS6.stcField.u1IRQRS209)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS210	(IRC0.unIRQRS6.stcField.u1IRQRS210)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS211	(IRC0.unIRQRS6.stcField.u1IRQRS211)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS212	(IRC0.unIRQRS6.stcField.u1IRQRS212)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS213	(IRC0.unIRQRS6.stcField.u1IRQRS213)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS214	(IRC0.unIRQRS6.stcField.u1IRQRS214)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS215	(IRC0.unIRQRS6.stcField.u1IRQRS215)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS216	(IRC0.unIRQRS6.stcField.u1IRQRS216)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS217	(IRC0.unIRQRS6.stcField.u1IRQRS217)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS218	(IRC0.unIRQRS6.stcField.u1IRQRS218)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS219	(IRC0.unIRQRS6.stcField.u1IRQRS219)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS220	(IRC0.unIRQRS6.stcField.u1IRQRS220)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS221	(IRC0.unIRQRS6.stcField.u1IRQRS221)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS222	(IRC0.unIRQRS6.stcField.u1IRQRS222)  /*@bf@*/
#define IRC0_IRQRS6_IRQRS223	(IRC0.unIRQRS6.stcField.u1IRQRS223)  /*@bf@*/

typedef struct stc_irc0_irqrs6_field{
    uint_io32_t		u1IRQRS192:1;
    uint_io32_t		u1IRQRS193:1;
    uint_io32_t		u1IRQRS194:1;
    uint_io32_t		u1IRQRS195:1;
    uint_io32_t		u1IRQRS196:1;
    uint_io32_t		u1IRQRS197:1;
    uint_io32_t		u1IRQRS198:1;
    uint_io32_t		u1IRQRS199:1;
    uint_io32_t		u1IRQRS200:1;
    uint_io32_t		u1IRQRS201:1;
    uint_io32_t		u1IRQRS202:1;
    uint_io32_t		u1IRQRS203:1;
    uint_io32_t		u1IRQRS204:1;
    uint_io32_t		u1IRQRS205:1;
    uint_io32_t		u1IRQRS206:1;
    uint_io32_t		u1IRQRS207:1;
    uint_io32_t		u1IRQRS208:1;
    uint_io32_t		u1IRQRS209:1;
    uint_io32_t		u1IRQRS210:1;
    uint_io32_t		u1IRQRS211:1;
    uint_io32_t		u1IRQRS212:1;
    uint_io32_t		u1IRQRS213:1;
    uint_io32_t		u1IRQRS214:1;
    uint_io32_t		u1IRQRS215:1;
    uint_io32_t		u1IRQRS216:1;
    uint_io32_t		u1IRQRS217:1;
    uint_io32_t		u1IRQRS218:1;
    uint_io32_t		u1IRQRS219:1;
    uint_io32_t		u1IRQRS220:1;
    uint_io32_t		u1IRQRS221:1;
    uint_io32_t		u1IRQRS222:1;
    uint_io32_t		u1IRQRS223:1;
}stc_irc0_irqrs6_field_t;

typedef union un_irc0_irqrs6{
    uint_io32_t		u32Register;
    stc_irc0_irqrs6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs6_t;

/* IRQRS7 */
#define IRC0_IRQRS7	(IRC0.unIRQRS7.u32Register)  /*@rg@*/
#define IRC0_IRQRS7_IRQRS224	(IRC0.unIRQRS7.stcField.u1IRQRS224)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS225	(IRC0.unIRQRS7.stcField.u1IRQRS225)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS226	(IRC0.unIRQRS7.stcField.u1IRQRS226)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS227	(IRC0.unIRQRS7.stcField.u1IRQRS227)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS228	(IRC0.unIRQRS7.stcField.u1IRQRS228)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS229	(IRC0.unIRQRS7.stcField.u1IRQRS229)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS230	(IRC0.unIRQRS7.stcField.u1IRQRS230)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS231	(IRC0.unIRQRS7.stcField.u1IRQRS231)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS232	(IRC0.unIRQRS7.stcField.u1IRQRS232)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS233	(IRC0.unIRQRS7.stcField.u1IRQRS233)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS234	(IRC0.unIRQRS7.stcField.u1IRQRS234)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS235	(IRC0.unIRQRS7.stcField.u1IRQRS235)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS236	(IRC0.unIRQRS7.stcField.u1IRQRS236)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS237	(IRC0.unIRQRS7.stcField.u1IRQRS237)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS238	(IRC0.unIRQRS7.stcField.u1IRQRS238)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS239	(IRC0.unIRQRS7.stcField.u1IRQRS239)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS240	(IRC0.unIRQRS7.stcField.u1IRQRS240)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS241	(IRC0.unIRQRS7.stcField.u1IRQRS241)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS242	(IRC0.unIRQRS7.stcField.u1IRQRS242)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS243	(IRC0.unIRQRS7.stcField.u1IRQRS243)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS244	(IRC0.unIRQRS7.stcField.u1IRQRS244)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS245	(IRC0.unIRQRS7.stcField.u1IRQRS245)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS246	(IRC0.unIRQRS7.stcField.u1IRQRS246)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS247	(IRC0.unIRQRS7.stcField.u1IRQRS247)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS248	(IRC0.unIRQRS7.stcField.u1IRQRS248)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS249	(IRC0.unIRQRS7.stcField.u1IRQRS249)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS250	(IRC0.unIRQRS7.stcField.u1IRQRS250)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS251	(IRC0.unIRQRS7.stcField.u1IRQRS251)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS252	(IRC0.unIRQRS7.stcField.u1IRQRS252)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS253	(IRC0.unIRQRS7.stcField.u1IRQRS253)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS254	(IRC0.unIRQRS7.stcField.u1IRQRS254)  /*@bf@*/
#define IRC0_IRQRS7_IRQRS255	(IRC0.unIRQRS7.stcField.u1IRQRS255)  /*@bf@*/

typedef struct stc_irc0_irqrs7_field{
    uint_io32_t		u1IRQRS224:1;
    uint_io32_t		u1IRQRS225:1;
    uint_io32_t		u1IRQRS226:1;
    uint_io32_t		u1IRQRS227:1;
    uint_io32_t		u1IRQRS228:1;
    uint_io32_t		u1IRQRS229:1;
    uint_io32_t		u1IRQRS230:1;
    uint_io32_t		u1IRQRS231:1;
    uint_io32_t		u1IRQRS232:1;
    uint_io32_t		u1IRQRS233:1;
    uint_io32_t		u1IRQRS234:1;
    uint_io32_t		u1IRQRS235:1;
    uint_io32_t		u1IRQRS236:1;
    uint_io32_t		u1IRQRS237:1;
    uint_io32_t		u1IRQRS238:1;
    uint_io32_t		u1IRQRS239:1;
    uint_io32_t		u1IRQRS240:1;
    uint_io32_t		u1IRQRS241:1;
    uint_io32_t		u1IRQRS242:1;
    uint_io32_t		u1IRQRS243:1;
    uint_io32_t		u1IRQRS244:1;
    uint_io32_t		u1IRQRS245:1;
    uint_io32_t		u1IRQRS246:1;
    uint_io32_t		u1IRQRS247:1;
    uint_io32_t		u1IRQRS248:1;
    uint_io32_t		u1IRQRS249:1;
    uint_io32_t		u1IRQRS250:1;
    uint_io32_t		u1IRQRS251:1;
    uint_io32_t		u1IRQRS252:1;
    uint_io32_t		u1IRQRS253:1;
    uint_io32_t		u1IRQRS254:1;
    uint_io32_t		u1IRQRS255:1;
}stc_irc0_irqrs7_field_t;

typedef union un_irc0_irqrs7{
    uint_io32_t		u32Register;
    stc_irc0_irqrs7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs7_t;

/* IRQRS8 */
#define IRC0_IRQRS8	(IRC0.unIRQRS8.u32Register)  /*@rg@*/
#define IRC0_IRQRS8_IRQRS256	(IRC0.unIRQRS8.stcField.u1IRQRS256)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS257	(IRC0.unIRQRS8.stcField.u1IRQRS257)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS258	(IRC0.unIRQRS8.stcField.u1IRQRS258)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS259	(IRC0.unIRQRS8.stcField.u1IRQRS259)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS260	(IRC0.unIRQRS8.stcField.u1IRQRS260)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS261	(IRC0.unIRQRS8.stcField.u1IRQRS261)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS262	(IRC0.unIRQRS8.stcField.u1IRQRS262)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS263	(IRC0.unIRQRS8.stcField.u1IRQRS263)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS264	(IRC0.unIRQRS8.stcField.u1IRQRS264)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS265	(IRC0.unIRQRS8.stcField.u1IRQRS265)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS266	(IRC0.unIRQRS8.stcField.u1IRQRS266)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS267	(IRC0.unIRQRS8.stcField.u1IRQRS267)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS268	(IRC0.unIRQRS8.stcField.u1IRQRS268)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS269	(IRC0.unIRQRS8.stcField.u1IRQRS269)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS270	(IRC0.unIRQRS8.stcField.u1IRQRS270)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS271	(IRC0.unIRQRS8.stcField.u1IRQRS271)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS272	(IRC0.unIRQRS8.stcField.u1IRQRS272)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS273	(IRC0.unIRQRS8.stcField.u1IRQRS273)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS274	(IRC0.unIRQRS8.stcField.u1IRQRS274)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS275	(IRC0.unIRQRS8.stcField.u1IRQRS275)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS276	(IRC0.unIRQRS8.stcField.u1IRQRS276)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS277	(IRC0.unIRQRS8.stcField.u1IRQRS277)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS278	(IRC0.unIRQRS8.stcField.u1IRQRS278)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS279	(IRC0.unIRQRS8.stcField.u1IRQRS279)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS280	(IRC0.unIRQRS8.stcField.u1IRQRS280)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS281	(IRC0.unIRQRS8.stcField.u1IRQRS281)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS282	(IRC0.unIRQRS8.stcField.u1IRQRS282)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS283	(IRC0.unIRQRS8.stcField.u1IRQRS283)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS284	(IRC0.unIRQRS8.stcField.u1IRQRS284)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS285	(IRC0.unIRQRS8.stcField.u1IRQRS285)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS286	(IRC0.unIRQRS8.stcField.u1IRQRS286)  /*@bf@*/
#define IRC0_IRQRS8_IRQRS287	(IRC0.unIRQRS8.stcField.u1IRQRS287)  /*@bf@*/

typedef struct stc_irc0_irqrs8_field{
    uint_io32_t		u1IRQRS256:1;
    uint_io32_t		u1IRQRS257:1;
    uint_io32_t		u1IRQRS258:1;
    uint_io32_t		u1IRQRS259:1;
    uint_io32_t		u1IRQRS260:1;
    uint_io32_t		u1IRQRS261:1;
    uint_io32_t		u1IRQRS262:1;
    uint_io32_t		u1IRQRS263:1;
    uint_io32_t		u1IRQRS264:1;
    uint_io32_t		u1IRQRS265:1;
    uint_io32_t		u1IRQRS266:1;
    uint_io32_t		u1IRQRS267:1;
    uint_io32_t		u1IRQRS268:1;
    uint_io32_t		u1IRQRS269:1;
    uint_io32_t		u1IRQRS270:1;
    uint_io32_t		u1IRQRS271:1;
    uint_io32_t		u1IRQRS272:1;
    uint_io32_t		u1IRQRS273:1;
    uint_io32_t		u1IRQRS274:1;
    uint_io32_t		u1IRQRS275:1;
    uint_io32_t		u1IRQRS276:1;
    uint_io32_t		u1IRQRS277:1;
    uint_io32_t		u1IRQRS278:1;
    uint_io32_t		u1IRQRS279:1;
    uint_io32_t		u1IRQRS280:1;
    uint_io32_t		u1IRQRS281:1;
    uint_io32_t		u1IRQRS282:1;
    uint_io32_t		u1IRQRS283:1;
    uint_io32_t		u1IRQRS284:1;
    uint_io32_t		u1IRQRS285:1;
    uint_io32_t		u1IRQRS286:1;
    uint_io32_t		u1IRQRS287:1;
}stc_irc0_irqrs8_field_t;

typedef union un_irc0_irqrs8{
    uint_io32_t		u32Register;
    stc_irc0_irqrs8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs8_t;

/* IRQRS9 */
#define IRC0_IRQRS9	(IRC0.unIRQRS9.u32Register)  /*@rg@*/
#define IRC0_IRQRS9_IRQRS288	(IRC0.unIRQRS9.stcField.u1IRQRS288)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS289	(IRC0.unIRQRS9.stcField.u1IRQRS289)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS290	(IRC0.unIRQRS9.stcField.u1IRQRS290)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS291	(IRC0.unIRQRS9.stcField.u1IRQRS291)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS292	(IRC0.unIRQRS9.stcField.u1IRQRS292)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS293	(IRC0.unIRQRS9.stcField.u1IRQRS293)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS294	(IRC0.unIRQRS9.stcField.u1IRQRS294)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS295	(IRC0.unIRQRS9.stcField.u1IRQRS295)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS296	(IRC0.unIRQRS9.stcField.u1IRQRS296)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS297	(IRC0.unIRQRS9.stcField.u1IRQRS297)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS298	(IRC0.unIRQRS9.stcField.u1IRQRS298)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS299	(IRC0.unIRQRS9.stcField.u1IRQRS299)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS300	(IRC0.unIRQRS9.stcField.u1IRQRS300)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS301	(IRC0.unIRQRS9.stcField.u1IRQRS301)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS302	(IRC0.unIRQRS9.stcField.u1IRQRS302)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS303	(IRC0.unIRQRS9.stcField.u1IRQRS303)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS304	(IRC0.unIRQRS9.stcField.u1IRQRS304)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS305	(IRC0.unIRQRS9.stcField.u1IRQRS305)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS306	(IRC0.unIRQRS9.stcField.u1IRQRS306)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS307	(IRC0.unIRQRS9.stcField.u1IRQRS307)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS308	(IRC0.unIRQRS9.stcField.u1IRQRS308)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS309	(IRC0.unIRQRS9.stcField.u1IRQRS309)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS310	(IRC0.unIRQRS9.stcField.u1IRQRS310)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS311	(IRC0.unIRQRS9.stcField.u1IRQRS311)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS312	(IRC0.unIRQRS9.stcField.u1IRQRS312)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS313	(IRC0.unIRQRS9.stcField.u1IRQRS313)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS314	(IRC0.unIRQRS9.stcField.u1IRQRS314)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS315	(IRC0.unIRQRS9.stcField.u1IRQRS315)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS316	(IRC0.unIRQRS9.stcField.u1IRQRS316)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS317	(IRC0.unIRQRS9.stcField.u1IRQRS317)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS318	(IRC0.unIRQRS9.stcField.u1IRQRS318)  /*@bf@*/
#define IRC0_IRQRS9_IRQRS319	(IRC0.unIRQRS9.stcField.u1IRQRS319)  /*@bf@*/

typedef struct stc_irc0_irqrs9_field{
    uint_io32_t		u1IRQRS288:1;
    uint_io32_t		u1IRQRS289:1;
    uint_io32_t		u1IRQRS290:1;
    uint_io32_t		u1IRQRS291:1;
    uint_io32_t		u1IRQRS292:1;
    uint_io32_t		u1IRQRS293:1;
    uint_io32_t		u1IRQRS294:1;
    uint_io32_t		u1IRQRS295:1;
    uint_io32_t		u1IRQRS296:1;
    uint_io32_t		u1IRQRS297:1;
    uint_io32_t		u1IRQRS298:1;
    uint_io32_t		u1IRQRS299:1;
    uint_io32_t		u1IRQRS300:1;
    uint_io32_t		u1IRQRS301:1;
    uint_io32_t		u1IRQRS302:1;
    uint_io32_t		u1IRQRS303:1;
    uint_io32_t		u1IRQRS304:1;
    uint_io32_t		u1IRQRS305:1;
    uint_io32_t		u1IRQRS306:1;
    uint_io32_t		u1IRQRS307:1;
    uint_io32_t		u1IRQRS308:1;
    uint_io32_t		u1IRQRS309:1;
    uint_io32_t		u1IRQRS310:1;
    uint_io32_t		u1IRQRS311:1;
    uint_io32_t		u1IRQRS312:1;
    uint_io32_t		u1IRQRS313:1;
    uint_io32_t		u1IRQRS314:1;
    uint_io32_t		u1IRQRS315:1;
    uint_io32_t		u1IRQRS316:1;
    uint_io32_t		u1IRQRS317:1;
    uint_io32_t		u1IRQRS318:1;
    uint_io32_t		u1IRQRS319:1;
}stc_irc0_irqrs9_field_t;

typedef union un_irc0_irqrs9{
    uint_io32_t		u32Register;
    stc_irc0_irqrs9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs9_t;

/* IRQRS10 */
#define IRC0_IRQRS10	(IRC0.unIRQRS10.u32Register)  /*@rg@*/
#define IRC0_IRQRS10_IRQRS320	(IRC0.unIRQRS10.stcField.u1IRQRS320)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS321	(IRC0.unIRQRS10.stcField.u1IRQRS321)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS322	(IRC0.unIRQRS10.stcField.u1IRQRS322)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS323	(IRC0.unIRQRS10.stcField.u1IRQRS323)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS324	(IRC0.unIRQRS10.stcField.u1IRQRS324)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS325	(IRC0.unIRQRS10.stcField.u1IRQRS325)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS326	(IRC0.unIRQRS10.stcField.u1IRQRS326)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS327	(IRC0.unIRQRS10.stcField.u1IRQRS327)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS328	(IRC0.unIRQRS10.stcField.u1IRQRS328)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS329	(IRC0.unIRQRS10.stcField.u1IRQRS329)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS330	(IRC0.unIRQRS10.stcField.u1IRQRS330)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS331	(IRC0.unIRQRS10.stcField.u1IRQRS331)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS332	(IRC0.unIRQRS10.stcField.u1IRQRS332)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS333	(IRC0.unIRQRS10.stcField.u1IRQRS333)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS334	(IRC0.unIRQRS10.stcField.u1IRQRS334)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS335	(IRC0.unIRQRS10.stcField.u1IRQRS335)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS336	(IRC0.unIRQRS10.stcField.u1IRQRS336)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS337	(IRC0.unIRQRS10.stcField.u1IRQRS337)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS338	(IRC0.unIRQRS10.stcField.u1IRQRS338)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS339	(IRC0.unIRQRS10.stcField.u1IRQRS339)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS340	(IRC0.unIRQRS10.stcField.u1IRQRS340)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS341	(IRC0.unIRQRS10.stcField.u1IRQRS341)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS342	(IRC0.unIRQRS10.stcField.u1IRQRS342)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS343	(IRC0.unIRQRS10.stcField.u1IRQRS343)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS344	(IRC0.unIRQRS10.stcField.u1IRQRS344)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS345	(IRC0.unIRQRS10.stcField.u1IRQRS345)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS346	(IRC0.unIRQRS10.stcField.u1IRQRS346)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS347	(IRC0.unIRQRS10.stcField.u1IRQRS347)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS348	(IRC0.unIRQRS10.stcField.u1IRQRS348)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS349	(IRC0.unIRQRS10.stcField.u1IRQRS349)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS350	(IRC0.unIRQRS10.stcField.u1IRQRS350)  /*@bf@*/
#define IRC0_IRQRS10_IRQRS351	(IRC0.unIRQRS10.stcField.u1IRQRS351)  /*@bf@*/

typedef struct stc_irc0_irqrs10_field{
    uint_io32_t		u1IRQRS320:1;
    uint_io32_t		u1IRQRS321:1;
    uint_io32_t		u1IRQRS322:1;
    uint_io32_t		u1IRQRS323:1;
    uint_io32_t		u1IRQRS324:1;
    uint_io32_t		u1IRQRS325:1;
    uint_io32_t		u1IRQRS326:1;
    uint_io32_t		u1IRQRS327:1;
    uint_io32_t		u1IRQRS328:1;
    uint_io32_t		u1IRQRS329:1;
    uint_io32_t		u1IRQRS330:1;
    uint_io32_t		u1IRQRS331:1;
    uint_io32_t		u1IRQRS332:1;
    uint_io32_t		u1IRQRS333:1;
    uint_io32_t		u1IRQRS334:1;
    uint_io32_t		u1IRQRS335:1;
    uint_io32_t		u1IRQRS336:1;
    uint_io32_t		u1IRQRS337:1;
    uint_io32_t		u1IRQRS338:1;
    uint_io32_t		u1IRQRS339:1;
    uint_io32_t		u1IRQRS340:1;
    uint_io32_t		u1IRQRS341:1;
    uint_io32_t		u1IRQRS342:1;
    uint_io32_t		u1IRQRS343:1;
    uint_io32_t		u1IRQRS344:1;
    uint_io32_t		u1IRQRS345:1;
    uint_io32_t		u1IRQRS346:1;
    uint_io32_t		u1IRQRS347:1;
    uint_io32_t		u1IRQRS348:1;
    uint_io32_t		u1IRQRS349:1;
    uint_io32_t		u1IRQRS350:1;
    uint_io32_t		u1IRQRS351:1;
}stc_irc0_irqrs10_field_t;

typedef union un_irc0_irqrs10{
    uint_io32_t		u32Register;
    stc_irc0_irqrs10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs10_t;

/* IRQRS11 */
#define IRC0_IRQRS11	(IRC0.unIRQRS11.u32Register)  /*@rg@*/
#define IRC0_IRQRS11_IRQRS352	(IRC0.unIRQRS11.stcField.u1IRQRS352)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS353	(IRC0.unIRQRS11.stcField.u1IRQRS353)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS354	(IRC0.unIRQRS11.stcField.u1IRQRS354)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS355	(IRC0.unIRQRS11.stcField.u1IRQRS355)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS356	(IRC0.unIRQRS11.stcField.u1IRQRS356)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS357	(IRC0.unIRQRS11.stcField.u1IRQRS357)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS358	(IRC0.unIRQRS11.stcField.u1IRQRS358)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS359	(IRC0.unIRQRS11.stcField.u1IRQRS359)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS360	(IRC0.unIRQRS11.stcField.u1IRQRS360)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS361	(IRC0.unIRQRS11.stcField.u1IRQRS361)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS362	(IRC0.unIRQRS11.stcField.u1IRQRS362)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS363	(IRC0.unIRQRS11.stcField.u1IRQRS363)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS364	(IRC0.unIRQRS11.stcField.u1IRQRS364)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS365	(IRC0.unIRQRS11.stcField.u1IRQRS365)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS366	(IRC0.unIRQRS11.stcField.u1IRQRS366)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS367	(IRC0.unIRQRS11.stcField.u1IRQRS367)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS368	(IRC0.unIRQRS11.stcField.u1IRQRS368)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS369	(IRC0.unIRQRS11.stcField.u1IRQRS369)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS370	(IRC0.unIRQRS11.stcField.u1IRQRS370)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS371	(IRC0.unIRQRS11.stcField.u1IRQRS371)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS372	(IRC0.unIRQRS11.stcField.u1IRQRS372)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS373	(IRC0.unIRQRS11.stcField.u1IRQRS373)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS374	(IRC0.unIRQRS11.stcField.u1IRQRS374)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS375	(IRC0.unIRQRS11.stcField.u1IRQRS375)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS376	(IRC0.unIRQRS11.stcField.u1IRQRS376)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS377	(IRC0.unIRQRS11.stcField.u1IRQRS377)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS378	(IRC0.unIRQRS11.stcField.u1IRQRS378)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS379	(IRC0.unIRQRS11.stcField.u1IRQRS379)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS380	(IRC0.unIRQRS11.stcField.u1IRQRS380)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS381	(IRC0.unIRQRS11.stcField.u1IRQRS381)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS382	(IRC0.unIRQRS11.stcField.u1IRQRS382)  /*@bf@*/
#define IRC0_IRQRS11_IRQRS383	(IRC0.unIRQRS11.stcField.u1IRQRS383)  /*@bf@*/

typedef struct stc_irc0_irqrs11_field{
    uint_io32_t		u1IRQRS352:1;
    uint_io32_t		u1IRQRS353:1;
    uint_io32_t		u1IRQRS354:1;
    uint_io32_t		u1IRQRS355:1;
    uint_io32_t		u1IRQRS356:1;
    uint_io32_t		u1IRQRS357:1;
    uint_io32_t		u1IRQRS358:1;
    uint_io32_t		u1IRQRS359:1;
    uint_io32_t		u1IRQRS360:1;
    uint_io32_t		u1IRQRS361:1;
    uint_io32_t		u1IRQRS362:1;
    uint_io32_t		u1IRQRS363:1;
    uint_io32_t		u1IRQRS364:1;
    uint_io32_t		u1IRQRS365:1;
    uint_io32_t		u1IRQRS366:1;
    uint_io32_t		u1IRQRS367:1;
    uint_io32_t		u1IRQRS368:1;
    uint_io32_t		u1IRQRS369:1;
    uint_io32_t		u1IRQRS370:1;
    uint_io32_t		u1IRQRS371:1;
    uint_io32_t		u1IRQRS372:1;
    uint_io32_t		u1IRQRS373:1;
    uint_io32_t		u1IRQRS374:1;
    uint_io32_t		u1IRQRS375:1;
    uint_io32_t		u1IRQRS376:1;
    uint_io32_t		u1IRQRS377:1;
    uint_io32_t		u1IRQRS378:1;
    uint_io32_t		u1IRQRS379:1;
    uint_io32_t		u1IRQRS380:1;
    uint_io32_t		u1IRQRS381:1;
    uint_io32_t		u1IRQRS382:1;
    uint_io32_t		u1IRQRS383:1;
}stc_irc0_irqrs11_field_t;

typedef union un_irc0_irqrs11{
    uint_io32_t		u32Register;
    stc_irc0_irqrs11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs11_t;

/* IRQRS12 */
#define IRC0_IRQRS12	(IRC0.unIRQRS12.u32Register)  /*@rg@*/
#define IRC0_IRQRS12_IRQRS384	(IRC0.unIRQRS12.stcField.u1IRQRS384)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS385	(IRC0.unIRQRS12.stcField.u1IRQRS385)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS386	(IRC0.unIRQRS12.stcField.u1IRQRS386)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS387	(IRC0.unIRQRS12.stcField.u1IRQRS387)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS388	(IRC0.unIRQRS12.stcField.u1IRQRS388)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS389	(IRC0.unIRQRS12.stcField.u1IRQRS389)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS390	(IRC0.unIRQRS12.stcField.u1IRQRS390)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS391	(IRC0.unIRQRS12.stcField.u1IRQRS391)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS392	(IRC0.unIRQRS12.stcField.u1IRQRS392)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS393	(IRC0.unIRQRS12.stcField.u1IRQRS393)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS394	(IRC0.unIRQRS12.stcField.u1IRQRS394)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS395	(IRC0.unIRQRS12.stcField.u1IRQRS395)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS396	(IRC0.unIRQRS12.stcField.u1IRQRS396)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS397	(IRC0.unIRQRS12.stcField.u1IRQRS397)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS398	(IRC0.unIRQRS12.stcField.u1IRQRS398)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS399	(IRC0.unIRQRS12.stcField.u1IRQRS399)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS400	(IRC0.unIRQRS12.stcField.u1IRQRS400)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS401	(IRC0.unIRQRS12.stcField.u1IRQRS401)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS402	(IRC0.unIRQRS12.stcField.u1IRQRS402)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS403	(IRC0.unIRQRS12.stcField.u1IRQRS403)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS404	(IRC0.unIRQRS12.stcField.u1IRQRS404)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS405	(IRC0.unIRQRS12.stcField.u1IRQRS405)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS406	(IRC0.unIRQRS12.stcField.u1IRQRS406)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS407	(IRC0.unIRQRS12.stcField.u1IRQRS407)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS408	(IRC0.unIRQRS12.stcField.u1IRQRS408)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS409	(IRC0.unIRQRS12.stcField.u1IRQRS409)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS410	(IRC0.unIRQRS12.stcField.u1IRQRS410)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS411	(IRC0.unIRQRS12.stcField.u1IRQRS411)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS412	(IRC0.unIRQRS12.stcField.u1IRQRS412)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS413	(IRC0.unIRQRS12.stcField.u1IRQRS413)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS414	(IRC0.unIRQRS12.stcField.u1IRQRS414)  /*@bf@*/
#define IRC0_IRQRS12_IRQRS415	(IRC0.unIRQRS12.stcField.u1IRQRS415)  /*@bf@*/

typedef struct stc_irc0_irqrs12_field{
    uint_io32_t		u1IRQRS384:1;
    uint_io32_t		u1IRQRS385:1;
    uint_io32_t		u1IRQRS386:1;
    uint_io32_t		u1IRQRS387:1;
    uint_io32_t		u1IRQRS388:1;
    uint_io32_t		u1IRQRS389:1;
    uint_io32_t		u1IRQRS390:1;
    uint_io32_t		u1IRQRS391:1;
    uint_io32_t		u1IRQRS392:1;
    uint_io32_t		u1IRQRS393:1;
    uint_io32_t		u1IRQRS394:1;
    uint_io32_t		u1IRQRS395:1;
    uint_io32_t		u1IRQRS396:1;
    uint_io32_t		u1IRQRS397:1;
    uint_io32_t		u1IRQRS398:1;
    uint_io32_t		u1IRQRS399:1;
    uint_io32_t		u1IRQRS400:1;
    uint_io32_t		u1IRQRS401:1;
    uint_io32_t		u1IRQRS402:1;
    uint_io32_t		u1IRQRS403:1;
    uint_io32_t		u1IRQRS404:1;
    uint_io32_t		u1IRQRS405:1;
    uint_io32_t		u1IRQRS406:1;
    uint_io32_t		u1IRQRS407:1;
    uint_io32_t		u1IRQRS408:1;
    uint_io32_t		u1IRQRS409:1;
    uint_io32_t		u1IRQRS410:1;
    uint_io32_t		u1IRQRS411:1;
    uint_io32_t		u1IRQRS412:1;
    uint_io32_t		u1IRQRS413:1;
    uint_io32_t		u1IRQRS414:1;
    uint_io32_t		u1IRQRS415:1;
}stc_irc0_irqrs12_field_t;

typedef union un_irc0_irqrs12{
    uint_io32_t		u32Register;
    stc_irc0_irqrs12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs12_t;

/* IRQRS13 */
#define IRC0_IRQRS13	(IRC0.unIRQRS13.u32Register)  /*@rg@*/
#define IRC0_IRQRS13_IRQRS416	(IRC0.unIRQRS13.stcField.u1IRQRS416)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS417	(IRC0.unIRQRS13.stcField.u1IRQRS417)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS418	(IRC0.unIRQRS13.stcField.u1IRQRS418)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS419	(IRC0.unIRQRS13.stcField.u1IRQRS419)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS420	(IRC0.unIRQRS13.stcField.u1IRQRS420)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS421	(IRC0.unIRQRS13.stcField.u1IRQRS421)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS422	(IRC0.unIRQRS13.stcField.u1IRQRS422)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS423	(IRC0.unIRQRS13.stcField.u1IRQRS423)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS424	(IRC0.unIRQRS13.stcField.u1IRQRS424)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS425	(IRC0.unIRQRS13.stcField.u1IRQRS425)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS426	(IRC0.unIRQRS13.stcField.u1IRQRS426)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS427	(IRC0.unIRQRS13.stcField.u1IRQRS427)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS428	(IRC0.unIRQRS13.stcField.u1IRQRS428)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS429	(IRC0.unIRQRS13.stcField.u1IRQRS429)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS430	(IRC0.unIRQRS13.stcField.u1IRQRS430)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS431	(IRC0.unIRQRS13.stcField.u1IRQRS431)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS432	(IRC0.unIRQRS13.stcField.u1IRQRS432)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS433	(IRC0.unIRQRS13.stcField.u1IRQRS433)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS434	(IRC0.unIRQRS13.stcField.u1IRQRS434)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS435	(IRC0.unIRQRS13.stcField.u1IRQRS435)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS436	(IRC0.unIRQRS13.stcField.u1IRQRS436)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS437	(IRC0.unIRQRS13.stcField.u1IRQRS437)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS438	(IRC0.unIRQRS13.stcField.u1IRQRS438)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS439	(IRC0.unIRQRS13.stcField.u1IRQRS439)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS440	(IRC0.unIRQRS13.stcField.u1IRQRS440)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS441	(IRC0.unIRQRS13.stcField.u1IRQRS441)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS442	(IRC0.unIRQRS13.stcField.u1IRQRS442)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS443	(IRC0.unIRQRS13.stcField.u1IRQRS443)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS444	(IRC0.unIRQRS13.stcField.u1IRQRS444)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS445	(IRC0.unIRQRS13.stcField.u1IRQRS445)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS446	(IRC0.unIRQRS13.stcField.u1IRQRS446)  /*@bf@*/
#define IRC0_IRQRS13_IRQRS447	(IRC0.unIRQRS13.stcField.u1IRQRS447)  /*@bf@*/

typedef struct stc_irc0_irqrs13_field{
    uint_io32_t		u1IRQRS416:1;
    uint_io32_t		u1IRQRS417:1;
    uint_io32_t		u1IRQRS418:1;
    uint_io32_t		u1IRQRS419:1;
    uint_io32_t		u1IRQRS420:1;
    uint_io32_t		u1IRQRS421:1;
    uint_io32_t		u1IRQRS422:1;
    uint_io32_t		u1IRQRS423:1;
    uint_io32_t		u1IRQRS424:1;
    uint_io32_t		u1IRQRS425:1;
    uint_io32_t		u1IRQRS426:1;
    uint_io32_t		u1IRQRS427:1;
    uint_io32_t		u1IRQRS428:1;
    uint_io32_t		u1IRQRS429:1;
    uint_io32_t		u1IRQRS430:1;
    uint_io32_t		u1IRQRS431:1;
    uint_io32_t		u1IRQRS432:1;
    uint_io32_t		u1IRQRS433:1;
    uint_io32_t		u1IRQRS434:1;
    uint_io32_t		u1IRQRS435:1;
    uint_io32_t		u1IRQRS436:1;
    uint_io32_t		u1IRQRS437:1;
    uint_io32_t		u1IRQRS438:1;
    uint_io32_t		u1IRQRS439:1;
    uint_io32_t		u1IRQRS440:1;
    uint_io32_t		u1IRQRS441:1;
    uint_io32_t		u1IRQRS442:1;
    uint_io32_t		u1IRQRS443:1;
    uint_io32_t		u1IRQRS444:1;
    uint_io32_t		u1IRQRS445:1;
    uint_io32_t		u1IRQRS446:1;
    uint_io32_t		u1IRQRS447:1;
}stc_irc0_irqrs13_field_t;

typedef union un_irc0_irqrs13{
    uint_io32_t		u32Register;
    stc_irc0_irqrs13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs13_t;

/* IRQRS14 */
#define IRC0_IRQRS14	(IRC0.unIRQRS14.u32Register)  /*@rg@*/
#define IRC0_IRQRS14_IRQRS448	(IRC0.unIRQRS14.stcField.u1IRQRS448)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS449	(IRC0.unIRQRS14.stcField.u1IRQRS449)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS450	(IRC0.unIRQRS14.stcField.u1IRQRS450)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS451	(IRC0.unIRQRS14.stcField.u1IRQRS451)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS452	(IRC0.unIRQRS14.stcField.u1IRQRS452)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS453	(IRC0.unIRQRS14.stcField.u1IRQRS453)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS454	(IRC0.unIRQRS14.stcField.u1IRQRS454)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS455	(IRC0.unIRQRS14.stcField.u1IRQRS455)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS456	(IRC0.unIRQRS14.stcField.u1IRQRS456)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS457	(IRC0.unIRQRS14.stcField.u1IRQRS457)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS458	(IRC0.unIRQRS14.stcField.u1IRQRS458)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS459	(IRC0.unIRQRS14.stcField.u1IRQRS459)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS460	(IRC0.unIRQRS14.stcField.u1IRQRS460)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS461	(IRC0.unIRQRS14.stcField.u1IRQRS461)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS462	(IRC0.unIRQRS14.stcField.u1IRQRS462)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS463	(IRC0.unIRQRS14.stcField.u1IRQRS463)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS464	(IRC0.unIRQRS14.stcField.u1IRQRS464)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS465	(IRC0.unIRQRS14.stcField.u1IRQRS465)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS466	(IRC0.unIRQRS14.stcField.u1IRQRS466)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS467	(IRC0.unIRQRS14.stcField.u1IRQRS467)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS468	(IRC0.unIRQRS14.stcField.u1IRQRS468)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS469	(IRC0.unIRQRS14.stcField.u1IRQRS469)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS470	(IRC0.unIRQRS14.stcField.u1IRQRS470)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS471	(IRC0.unIRQRS14.stcField.u1IRQRS471)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS472	(IRC0.unIRQRS14.stcField.u1IRQRS472)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS473	(IRC0.unIRQRS14.stcField.u1IRQRS473)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS474	(IRC0.unIRQRS14.stcField.u1IRQRS474)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS475	(IRC0.unIRQRS14.stcField.u1IRQRS475)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS476	(IRC0.unIRQRS14.stcField.u1IRQRS476)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS477	(IRC0.unIRQRS14.stcField.u1IRQRS477)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS478	(IRC0.unIRQRS14.stcField.u1IRQRS478)  /*@bf@*/
#define IRC0_IRQRS14_IRQRS479	(IRC0.unIRQRS14.stcField.u1IRQRS479)  /*@bf@*/

typedef struct stc_irc0_irqrs14_field{
    uint_io32_t		u1IRQRS448:1;
    uint_io32_t		u1IRQRS449:1;
    uint_io32_t		u1IRQRS450:1;
    uint_io32_t		u1IRQRS451:1;
    uint_io32_t		u1IRQRS452:1;
    uint_io32_t		u1IRQRS453:1;
    uint_io32_t		u1IRQRS454:1;
    uint_io32_t		u1IRQRS455:1;
    uint_io32_t		u1IRQRS456:1;
    uint_io32_t		u1IRQRS457:1;
    uint_io32_t		u1IRQRS458:1;
    uint_io32_t		u1IRQRS459:1;
    uint_io32_t		u1IRQRS460:1;
    uint_io32_t		u1IRQRS461:1;
    uint_io32_t		u1IRQRS462:1;
    uint_io32_t		u1IRQRS463:1;
    uint_io32_t		u1IRQRS464:1;
    uint_io32_t		u1IRQRS465:1;
    uint_io32_t		u1IRQRS466:1;
    uint_io32_t		u1IRQRS467:1;
    uint_io32_t		u1IRQRS468:1;
    uint_io32_t		u1IRQRS469:1;
    uint_io32_t		u1IRQRS470:1;
    uint_io32_t		u1IRQRS471:1;
    uint_io32_t		u1IRQRS472:1;
    uint_io32_t		u1IRQRS473:1;
    uint_io32_t		u1IRQRS474:1;
    uint_io32_t		u1IRQRS475:1;
    uint_io32_t		u1IRQRS476:1;
    uint_io32_t		u1IRQRS477:1;
    uint_io32_t		u1IRQRS478:1;
    uint_io32_t		u1IRQRS479:1;
}stc_irc0_irqrs14_field_t;

typedef union un_irc0_irqrs14{
    uint_io32_t		u32Register;
    stc_irc0_irqrs14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs14_t;

/* IRQRS15 */
#define IRC0_IRQRS15	(IRC0.unIRQRS15.u32Register)  /*@rg@*/
#define IRC0_IRQRS15_IRQRS480	(IRC0.unIRQRS15.stcField.u1IRQRS480)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS481	(IRC0.unIRQRS15.stcField.u1IRQRS481)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS482	(IRC0.unIRQRS15.stcField.u1IRQRS482)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS483	(IRC0.unIRQRS15.stcField.u1IRQRS483)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS484	(IRC0.unIRQRS15.stcField.u1IRQRS484)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS485	(IRC0.unIRQRS15.stcField.u1IRQRS485)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS486	(IRC0.unIRQRS15.stcField.u1IRQRS486)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS487	(IRC0.unIRQRS15.stcField.u1IRQRS487)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS488	(IRC0.unIRQRS15.stcField.u1IRQRS488)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS489	(IRC0.unIRQRS15.stcField.u1IRQRS489)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS490	(IRC0.unIRQRS15.stcField.u1IRQRS490)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS491	(IRC0.unIRQRS15.stcField.u1IRQRS491)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS492	(IRC0.unIRQRS15.stcField.u1IRQRS492)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS493	(IRC0.unIRQRS15.stcField.u1IRQRS493)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS494	(IRC0.unIRQRS15.stcField.u1IRQRS494)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS495	(IRC0.unIRQRS15.stcField.u1IRQRS495)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS496	(IRC0.unIRQRS15.stcField.u1IRQRS496)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS497	(IRC0.unIRQRS15.stcField.u1IRQRS497)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS498	(IRC0.unIRQRS15.stcField.u1IRQRS498)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS499	(IRC0.unIRQRS15.stcField.u1IRQRS499)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS500	(IRC0.unIRQRS15.stcField.u1IRQRS500)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS501	(IRC0.unIRQRS15.stcField.u1IRQRS501)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS502	(IRC0.unIRQRS15.stcField.u1IRQRS502)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS503	(IRC0.unIRQRS15.stcField.u1IRQRS503)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS504	(IRC0.unIRQRS15.stcField.u1IRQRS504)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS505	(IRC0.unIRQRS15.stcField.u1IRQRS505)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS506	(IRC0.unIRQRS15.stcField.u1IRQRS506)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS507	(IRC0.unIRQRS15.stcField.u1IRQRS507)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS508	(IRC0.unIRQRS15.stcField.u1IRQRS508)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS509	(IRC0.unIRQRS15.stcField.u1IRQRS509)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS510	(IRC0.unIRQRS15.stcField.u1IRQRS510)  /*@bf@*/
#define IRC0_IRQRS15_IRQRS511	(IRC0.unIRQRS15.stcField.u1IRQRS511)  /*@bf@*/

typedef struct stc_irc0_irqrs15_field{
    uint_io32_t		u1IRQRS480:1;
    uint_io32_t		u1IRQRS481:1;
    uint_io32_t		u1IRQRS482:1;
    uint_io32_t		u1IRQRS483:1;
    uint_io32_t		u1IRQRS484:1;
    uint_io32_t		u1IRQRS485:1;
    uint_io32_t		u1IRQRS486:1;
    uint_io32_t		u1IRQRS487:1;
    uint_io32_t		u1IRQRS488:1;
    uint_io32_t		u1IRQRS489:1;
    uint_io32_t		u1IRQRS490:1;
    uint_io32_t		u1IRQRS491:1;
    uint_io32_t		u1IRQRS492:1;
    uint_io32_t		u1IRQRS493:1;
    uint_io32_t		u1IRQRS494:1;
    uint_io32_t		u1IRQRS495:1;
    uint_io32_t		u1IRQRS496:1;
    uint_io32_t		u1IRQRS497:1;
    uint_io32_t		u1IRQRS498:1;
    uint_io32_t		u1IRQRS499:1;
    uint_io32_t		u1IRQRS500:1;
    uint_io32_t		u1IRQRS501:1;
    uint_io32_t		u1IRQRS502:1;
    uint_io32_t		u1IRQRS503:1;
    uint_io32_t		u1IRQRS504:1;
    uint_io32_t		u1IRQRS505:1;
    uint_io32_t		u1IRQRS506:1;
    uint_io32_t		u1IRQRS507:1;
    uint_io32_t		u1IRQRS508:1;
    uint_io32_t		u1IRQRS509:1;
    uint_io32_t		u1IRQRS510:1;
    uint_io32_t		u1IRQRS511:1;
}stc_irc0_irqrs15_field_t;

typedef union un_irc0_irqrs15{
    uint_io32_t		u32Register;
    stc_irc0_irqrs15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqrs15_t;

/* IRQPS0 */
#define IRC0_IRQPS0	(IRC0.unIRQPS0.u32Register)  /*@rg@*/
#define IRC0_IRQPS0_IRQPS0	(IRC0.unIRQPS0.stcField.u1IRQPS0)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS1	(IRC0.unIRQPS0.stcField.u1IRQPS1)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS2	(IRC0.unIRQPS0.stcField.u1IRQPS2)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS3	(IRC0.unIRQPS0.stcField.u1IRQPS3)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS4	(IRC0.unIRQPS0.stcField.u1IRQPS4)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS5	(IRC0.unIRQPS0.stcField.u1IRQPS5)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS6	(IRC0.unIRQPS0.stcField.u1IRQPS6)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS7	(IRC0.unIRQPS0.stcField.u1IRQPS7)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS8	(IRC0.unIRQPS0.stcField.u1IRQPS8)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS9	(IRC0.unIRQPS0.stcField.u1IRQPS9)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS10	(IRC0.unIRQPS0.stcField.u1IRQPS10)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS11	(IRC0.unIRQPS0.stcField.u1IRQPS11)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS12	(IRC0.unIRQPS0.stcField.u1IRQPS12)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS13	(IRC0.unIRQPS0.stcField.u1IRQPS13)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS14	(IRC0.unIRQPS0.stcField.u1IRQPS14)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS15	(IRC0.unIRQPS0.stcField.u1IRQPS15)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS16	(IRC0.unIRQPS0.stcField.u1IRQPS16)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS17	(IRC0.unIRQPS0.stcField.u1IRQPS17)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS18	(IRC0.unIRQPS0.stcField.u1IRQPS18)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS19	(IRC0.unIRQPS0.stcField.u1IRQPS19)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS20	(IRC0.unIRQPS0.stcField.u1IRQPS20)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS21	(IRC0.unIRQPS0.stcField.u1IRQPS21)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS22	(IRC0.unIRQPS0.stcField.u1IRQPS22)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS23	(IRC0.unIRQPS0.stcField.u1IRQPS23)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS24	(IRC0.unIRQPS0.stcField.u1IRQPS24)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS25	(IRC0.unIRQPS0.stcField.u1IRQPS25)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS26	(IRC0.unIRQPS0.stcField.u1IRQPS26)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS27	(IRC0.unIRQPS0.stcField.u1IRQPS27)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS28	(IRC0.unIRQPS0.stcField.u1IRQPS28)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS29	(IRC0.unIRQPS0.stcField.u1IRQPS29)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS30	(IRC0.unIRQPS0.stcField.u1IRQPS30)  /*@bf@*/
#define IRC0_IRQPS0_IRQPS31	(IRC0.unIRQPS0.stcField.u1IRQPS31)  /*@bf@*/

typedef struct stc_irc0_irqps0_field{
    uint_io32_t		u1IRQPS0:1;
    uint_io32_t		u1IRQPS1:1;
    uint_io32_t		u1IRQPS2:1;
    uint_io32_t		u1IRQPS3:1;
    uint_io32_t		u1IRQPS4:1;
    uint_io32_t		u1IRQPS5:1;
    uint_io32_t		u1IRQPS6:1;
    uint_io32_t		u1IRQPS7:1;
    uint_io32_t		u1IRQPS8:1;
    uint_io32_t		u1IRQPS9:1;
    uint_io32_t		u1IRQPS10:1;
    uint_io32_t		u1IRQPS11:1;
    uint_io32_t		u1IRQPS12:1;
    uint_io32_t		u1IRQPS13:1;
    uint_io32_t		u1IRQPS14:1;
    uint_io32_t		u1IRQPS15:1;
    uint_io32_t		u1IRQPS16:1;
    uint_io32_t		u1IRQPS17:1;
    uint_io32_t		u1IRQPS18:1;
    uint_io32_t		u1IRQPS19:1;
    uint_io32_t		u1IRQPS20:1;
    uint_io32_t		u1IRQPS21:1;
    uint_io32_t		u1IRQPS22:1;
    uint_io32_t		u1IRQPS23:1;
    uint_io32_t		u1IRQPS24:1;
    uint_io32_t		u1IRQPS25:1;
    uint_io32_t		u1IRQPS26:1;
    uint_io32_t		u1IRQPS27:1;
    uint_io32_t		u1IRQPS28:1;
    uint_io32_t		u1IRQPS29:1;
    uint_io32_t		u1IRQPS30:1;
    uint_io32_t		u1IRQPS31:1;
}stc_irc0_irqps0_field_t;

typedef union un_irc0_irqps0{
    uint_io32_t		u32Register;
    stc_irc0_irqps0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps0_t;

/* IRQPS1 */
#define IRC0_IRQPS1	(IRC0.unIRQPS1.u32Register)  /*@rg@*/
#define IRC0_IRQPS1_IRQPS32	(IRC0.unIRQPS1.stcField.u1IRQPS32)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS33	(IRC0.unIRQPS1.stcField.u1IRQPS33)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS34	(IRC0.unIRQPS1.stcField.u1IRQPS34)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS35	(IRC0.unIRQPS1.stcField.u1IRQPS35)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS36	(IRC0.unIRQPS1.stcField.u1IRQPS36)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS37	(IRC0.unIRQPS1.stcField.u1IRQPS37)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS38	(IRC0.unIRQPS1.stcField.u1IRQPS38)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS39	(IRC0.unIRQPS1.stcField.u1IRQPS39)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS40	(IRC0.unIRQPS1.stcField.u1IRQPS40)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS41	(IRC0.unIRQPS1.stcField.u1IRQPS41)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS42	(IRC0.unIRQPS1.stcField.u1IRQPS42)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS43	(IRC0.unIRQPS1.stcField.u1IRQPS43)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS44	(IRC0.unIRQPS1.stcField.u1IRQPS44)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS45	(IRC0.unIRQPS1.stcField.u1IRQPS45)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS46	(IRC0.unIRQPS1.stcField.u1IRQPS46)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS47	(IRC0.unIRQPS1.stcField.u1IRQPS47)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS48	(IRC0.unIRQPS1.stcField.u1IRQPS48)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS49	(IRC0.unIRQPS1.stcField.u1IRQPS49)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS50	(IRC0.unIRQPS1.stcField.u1IRQPS50)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS51	(IRC0.unIRQPS1.stcField.u1IRQPS51)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS52	(IRC0.unIRQPS1.stcField.u1IRQPS52)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS53	(IRC0.unIRQPS1.stcField.u1IRQPS53)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS54	(IRC0.unIRQPS1.stcField.u1IRQPS54)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS55	(IRC0.unIRQPS1.stcField.u1IRQPS55)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS56	(IRC0.unIRQPS1.stcField.u1IRQPS56)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS57	(IRC0.unIRQPS1.stcField.u1IRQPS57)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS58	(IRC0.unIRQPS1.stcField.u1IRQPS58)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS59	(IRC0.unIRQPS1.stcField.u1IRQPS59)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS60	(IRC0.unIRQPS1.stcField.u1IRQPS60)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS61	(IRC0.unIRQPS1.stcField.u1IRQPS61)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS62	(IRC0.unIRQPS1.stcField.u1IRQPS62)  /*@bf@*/
#define IRC0_IRQPS1_IRQPS63	(IRC0.unIRQPS1.stcField.u1IRQPS63)  /*@bf@*/

typedef struct stc_irc0_irqps1_field{
    uint_io32_t		u1IRQPS32:1;
    uint_io32_t		u1IRQPS33:1;
    uint_io32_t		u1IRQPS34:1;
    uint_io32_t		u1IRQPS35:1;
    uint_io32_t		u1IRQPS36:1;
    uint_io32_t		u1IRQPS37:1;
    uint_io32_t		u1IRQPS38:1;
    uint_io32_t		u1IRQPS39:1;
    uint_io32_t		u1IRQPS40:1;
    uint_io32_t		u1IRQPS41:1;
    uint_io32_t		u1IRQPS42:1;
    uint_io32_t		u1IRQPS43:1;
    uint_io32_t		u1IRQPS44:1;
    uint_io32_t		u1IRQPS45:1;
    uint_io32_t		u1IRQPS46:1;
    uint_io32_t		u1IRQPS47:1;
    uint_io32_t		u1IRQPS48:1;
    uint_io32_t		u1IRQPS49:1;
    uint_io32_t		u1IRQPS50:1;
    uint_io32_t		u1IRQPS51:1;
    uint_io32_t		u1IRQPS52:1;
    uint_io32_t		u1IRQPS53:1;
    uint_io32_t		u1IRQPS54:1;
    uint_io32_t		u1IRQPS55:1;
    uint_io32_t		u1IRQPS56:1;
    uint_io32_t		u1IRQPS57:1;
    uint_io32_t		u1IRQPS58:1;
    uint_io32_t		u1IRQPS59:1;
    uint_io32_t		u1IRQPS60:1;
    uint_io32_t		u1IRQPS61:1;
    uint_io32_t		u1IRQPS62:1;
    uint_io32_t		u1IRQPS63:1;
}stc_irc0_irqps1_field_t;

typedef union un_irc0_irqps1{
    uint_io32_t		u32Register;
    stc_irc0_irqps1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps1_t;

/* IRQPS2 */
#define IRC0_IRQPS2	(IRC0.unIRQPS2.u32Register)  /*@rg@*/
#define IRC0_IRQPS2_IRQPS64	(IRC0.unIRQPS2.stcField.u1IRQPS64)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS65	(IRC0.unIRQPS2.stcField.u1IRQPS65)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS66	(IRC0.unIRQPS2.stcField.u1IRQPS66)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS67	(IRC0.unIRQPS2.stcField.u1IRQPS67)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS68	(IRC0.unIRQPS2.stcField.u1IRQPS68)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS69	(IRC0.unIRQPS2.stcField.u1IRQPS69)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS70	(IRC0.unIRQPS2.stcField.u1IRQPS70)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS71	(IRC0.unIRQPS2.stcField.u1IRQPS71)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS72	(IRC0.unIRQPS2.stcField.u1IRQPS72)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS73	(IRC0.unIRQPS2.stcField.u1IRQPS73)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS74	(IRC0.unIRQPS2.stcField.u1IRQPS74)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS75	(IRC0.unIRQPS2.stcField.u1IRQPS75)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS76	(IRC0.unIRQPS2.stcField.u1IRQPS76)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS77	(IRC0.unIRQPS2.stcField.u1IRQPS77)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS78	(IRC0.unIRQPS2.stcField.u1IRQPS78)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS79	(IRC0.unIRQPS2.stcField.u1IRQPS79)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS80	(IRC0.unIRQPS2.stcField.u1IRQPS80)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS81	(IRC0.unIRQPS2.stcField.u1IRQPS81)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS82	(IRC0.unIRQPS2.stcField.u1IRQPS82)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS83	(IRC0.unIRQPS2.stcField.u1IRQPS83)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS84	(IRC0.unIRQPS2.stcField.u1IRQPS84)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS85	(IRC0.unIRQPS2.stcField.u1IRQPS85)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS86	(IRC0.unIRQPS2.stcField.u1IRQPS86)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS87	(IRC0.unIRQPS2.stcField.u1IRQPS87)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS88	(IRC0.unIRQPS2.stcField.u1IRQPS88)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS89	(IRC0.unIRQPS2.stcField.u1IRQPS89)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS90	(IRC0.unIRQPS2.stcField.u1IRQPS90)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS91	(IRC0.unIRQPS2.stcField.u1IRQPS91)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS92	(IRC0.unIRQPS2.stcField.u1IRQPS92)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS93	(IRC0.unIRQPS2.stcField.u1IRQPS93)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS94	(IRC0.unIRQPS2.stcField.u1IRQPS94)  /*@bf@*/
#define IRC0_IRQPS2_IRQPS95	(IRC0.unIRQPS2.stcField.u1IRQPS95)  /*@bf@*/

typedef struct stc_irc0_irqps2_field{
    uint_io32_t		u1IRQPS64:1;
    uint_io32_t		u1IRQPS65:1;
    uint_io32_t		u1IRQPS66:1;
    uint_io32_t		u1IRQPS67:1;
    uint_io32_t		u1IRQPS68:1;
    uint_io32_t		u1IRQPS69:1;
    uint_io32_t		u1IRQPS70:1;
    uint_io32_t		u1IRQPS71:1;
    uint_io32_t		u1IRQPS72:1;
    uint_io32_t		u1IRQPS73:1;
    uint_io32_t		u1IRQPS74:1;
    uint_io32_t		u1IRQPS75:1;
    uint_io32_t		u1IRQPS76:1;
    uint_io32_t		u1IRQPS77:1;
    uint_io32_t		u1IRQPS78:1;
    uint_io32_t		u1IRQPS79:1;
    uint_io32_t		u1IRQPS80:1;
    uint_io32_t		u1IRQPS81:1;
    uint_io32_t		u1IRQPS82:1;
    uint_io32_t		u1IRQPS83:1;
    uint_io32_t		u1IRQPS84:1;
    uint_io32_t		u1IRQPS85:1;
    uint_io32_t		u1IRQPS86:1;
    uint_io32_t		u1IRQPS87:1;
    uint_io32_t		u1IRQPS88:1;
    uint_io32_t		u1IRQPS89:1;
    uint_io32_t		u1IRQPS90:1;
    uint_io32_t		u1IRQPS91:1;
    uint_io32_t		u1IRQPS92:1;
    uint_io32_t		u1IRQPS93:1;
    uint_io32_t		u1IRQPS94:1;
    uint_io32_t		u1IRQPS95:1;
}stc_irc0_irqps2_field_t;

typedef union un_irc0_irqps2{
    uint_io32_t		u32Register;
    stc_irc0_irqps2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps2_t;

/* IRQPS3 */
#define IRC0_IRQPS3	(IRC0.unIRQPS3.u32Register)  /*@rg@*/
#define IRC0_IRQPS3_IRQPS96	(IRC0.unIRQPS3.stcField.u1IRQPS96)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS97	(IRC0.unIRQPS3.stcField.u1IRQPS97)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS98	(IRC0.unIRQPS3.stcField.u1IRQPS98)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS99	(IRC0.unIRQPS3.stcField.u1IRQPS99)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS100	(IRC0.unIRQPS3.stcField.u1IRQPS100)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS101	(IRC0.unIRQPS3.stcField.u1IRQPS101)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS102	(IRC0.unIRQPS3.stcField.u1IRQPS102)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS103	(IRC0.unIRQPS3.stcField.u1IRQPS103)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS104	(IRC0.unIRQPS3.stcField.u1IRQPS104)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS105	(IRC0.unIRQPS3.stcField.u1IRQPS105)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS106	(IRC0.unIRQPS3.stcField.u1IRQPS106)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS107	(IRC0.unIRQPS3.stcField.u1IRQPS107)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS108	(IRC0.unIRQPS3.stcField.u1IRQPS108)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS109	(IRC0.unIRQPS3.stcField.u1IRQPS109)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS110	(IRC0.unIRQPS3.stcField.u1IRQPS110)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS111	(IRC0.unIRQPS3.stcField.u1IRQPS111)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS112	(IRC0.unIRQPS3.stcField.u1IRQPS112)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS113	(IRC0.unIRQPS3.stcField.u1IRQPS113)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS114	(IRC0.unIRQPS3.stcField.u1IRQPS114)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS115	(IRC0.unIRQPS3.stcField.u1IRQPS115)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS116	(IRC0.unIRQPS3.stcField.u1IRQPS116)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS117	(IRC0.unIRQPS3.stcField.u1IRQPS117)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS118	(IRC0.unIRQPS3.stcField.u1IRQPS118)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS119	(IRC0.unIRQPS3.stcField.u1IRQPS119)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS120	(IRC0.unIRQPS3.stcField.u1IRQPS120)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS121	(IRC0.unIRQPS3.stcField.u1IRQPS121)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS122	(IRC0.unIRQPS3.stcField.u1IRQPS122)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS123	(IRC0.unIRQPS3.stcField.u1IRQPS123)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS124	(IRC0.unIRQPS3.stcField.u1IRQPS124)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS125	(IRC0.unIRQPS3.stcField.u1IRQPS125)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS126	(IRC0.unIRQPS3.stcField.u1IRQPS126)  /*@bf@*/
#define IRC0_IRQPS3_IRQPS127	(IRC0.unIRQPS3.stcField.u1IRQPS127)  /*@bf@*/

typedef struct stc_irc0_irqps3_field{
    uint_io32_t		u1IRQPS96:1;
    uint_io32_t		u1IRQPS97:1;
    uint_io32_t		u1IRQPS98:1;
    uint_io32_t		u1IRQPS99:1;
    uint_io32_t		u1IRQPS100:1;
    uint_io32_t		u1IRQPS101:1;
    uint_io32_t		u1IRQPS102:1;
    uint_io32_t		u1IRQPS103:1;
    uint_io32_t		u1IRQPS104:1;
    uint_io32_t		u1IRQPS105:1;
    uint_io32_t		u1IRQPS106:1;
    uint_io32_t		u1IRQPS107:1;
    uint_io32_t		u1IRQPS108:1;
    uint_io32_t		u1IRQPS109:1;
    uint_io32_t		u1IRQPS110:1;
    uint_io32_t		u1IRQPS111:1;
    uint_io32_t		u1IRQPS112:1;
    uint_io32_t		u1IRQPS113:1;
    uint_io32_t		u1IRQPS114:1;
    uint_io32_t		u1IRQPS115:1;
    uint_io32_t		u1IRQPS116:1;
    uint_io32_t		u1IRQPS117:1;
    uint_io32_t		u1IRQPS118:1;
    uint_io32_t		u1IRQPS119:1;
    uint_io32_t		u1IRQPS120:1;
    uint_io32_t		u1IRQPS121:1;
    uint_io32_t		u1IRQPS122:1;
    uint_io32_t		u1IRQPS123:1;
    uint_io32_t		u1IRQPS124:1;
    uint_io32_t		u1IRQPS125:1;
    uint_io32_t		u1IRQPS126:1;
    uint_io32_t		u1IRQPS127:1;
}stc_irc0_irqps3_field_t;

typedef union un_irc0_irqps3{
    uint_io32_t		u32Register;
    stc_irc0_irqps3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps3_t;

/* IRQPS4 */
#define IRC0_IRQPS4	(IRC0.unIRQPS4.u32Register)  /*@rg@*/
#define IRC0_IRQPS4_IRQPS128	(IRC0.unIRQPS4.stcField.u1IRQPS128)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS129	(IRC0.unIRQPS4.stcField.u1IRQPS129)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS130	(IRC0.unIRQPS4.stcField.u1IRQPS130)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS131	(IRC0.unIRQPS4.stcField.u1IRQPS131)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS132	(IRC0.unIRQPS4.stcField.u1IRQPS132)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS133	(IRC0.unIRQPS4.stcField.u1IRQPS133)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS134	(IRC0.unIRQPS4.stcField.u1IRQPS134)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS135	(IRC0.unIRQPS4.stcField.u1IRQPS135)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS136	(IRC0.unIRQPS4.stcField.u1IRQPS136)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS137	(IRC0.unIRQPS4.stcField.u1IRQPS137)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS138	(IRC0.unIRQPS4.stcField.u1IRQPS138)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS139	(IRC0.unIRQPS4.stcField.u1IRQPS139)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS140	(IRC0.unIRQPS4.stcField.u1IRQPS140)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS141	(IRC0.unIRQPS4.stcField.u1IRQPS141)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS142	(IRC0.unIRQPS4.stcField.u1IRQPS142)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS143	(IRC0.unIRQPS4.stcField.u1IRQPS143)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS144	(IRC0.unIRQPS4.stcField.u1IRQPS144)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS145	(IRC0.unIRQPS4.stcField.u1IRQPS145)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS146	(IRC0.unIRQPS4.stcField.u1IRQPS146)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS147	(IRC0.unIRQPS4.stcField.u1IRQPS147)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS148	(IRC0.unIRQPS4.stcField.u1IRQPS148)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS149	(IRC0.unIRQPS4.stcField.u1IRQPS149)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS150	(IRC0.unIRQPS4.stcField.u1IRQPS150)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS151	(IRC0.unIRQPS4.stcField.u1IRQPS151)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS152	(IRC0.unIRQPS4.stcField.u1IRQPS152)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS153	(IRC0.unIRQPS4.stcField.u1IRQPS153)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS154	(IRC0.unIRQPS4.stcField.u1IRQPS154)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS155	(IRC0.unIRQPS4.stcField.u1IRQPS155)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS156	(IRC0.unIRQPS4.stcField.u1IRQPS156)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS157	(IRC0.unIRQPS4.stcField.u1IRQPS157)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS158	(IRC0.unIRQPS4.stcField.u1IRQPS158)  /*@bf@*/
#define IRC0_IRQPS4_IRQPS159	(IRC0.unIRQPS4.stcField.u1IRQPS159)  /*@bf@*/

typedef struct stc_irc0_irqps4_field{
    uint_io32_t		u1IRQPS128:1;
    uint_io32_t		u1IRQPS129:1;
    uint_io32_t		u1IRQPS130:1;
    uint_io32_t		u1IRQPS131:1;
    uint_io32_t		u1IRQPS132:1;
    uint_io32_t		u1IRQPS133:1;
    uint_io32_t		u1IRQPS134:1;
    uint_io32_t		u1IRQPS135:1;
    uint_io32_t		u1IRQPS136:1;
    uint_io32_t		u1IRQPS137:1;
    uint_io32_t		u1IRQPS138:1;
    uint_io32_t		u1IRQPS139:1;
    uint_io32_t		u1IRQPS140:1;
    uint_io32_t		u1IRQPS141:1;
    uint_io32_t		u1IRQPS142:1;
    uint_io32_t		u1IRQPS143:1;
    uint_io32_t		u1IRQPS144:1;
    uint_io32_t		u1IRQPS145:1;
    uint_io32_t		u1IRQPS146:1;
    uint_io32_t		u1IRQPS147:1;
    uint_io32_t		u1IRQPS148:1;
    uint_io32_t		u1IRQPS149:1;
    uint_io32_t		u1IRQPS150:1;
    uint_io32_t		u1IRQPS151:1;
    uint_io32_t		u1IRQPS152:1;
    uint_io32_t		u1IRQPS153:1;
    uint_io32_t		u1IRQPS154:1;
    uint_io32_t		u1IRQPS155:1;
    uint_io32_t		u1IRQPS156:1;
    uint_io32_t		u1IRQPS157:1;
    uint_io32_t		u1IRQPS158:1;
    uint_io32_t		u1IRQPS159:1;
}stc_irc0_irqps4_field_t;

typedef union un_irc0_irqps4{
    uint_io32_t		u32Register;
    stc_irc0_irqps4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps4_t;

/* IRQPS5 */
#define IRC0_IRQPS5	(IRC0.unIRQPS5.u32Register)  /*@rg@*/
#define IRC0_IRQPS5_IRQPS160	(IRC0.unIRQPS5.stcField.u1IRQPS160)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS161	(IRC0.unIRQPS5.stcField.u1IRQPS161)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS162	(IRC0.unIRQPS5.stcField.u1IRQPS162)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS163	(IRC0.unIRQPS5.stcField.u1IRQPS163)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS164	(IRC0.unIRQPS5.stcField.u1IRQPS164)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS165	(IRC0.unIRQPS5.stcField.u1IRQPS165)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS166	(IRC0.unIRQPS5.stcField.u1IRQPS166)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS167	(IRC0.unIRQPS5.stcField.u1IRQPS167)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS168	(IRC0.unIRQPS5.stcField.u1IRQPS168)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS169	(IRC0.unIRQPS5.stcField.u1IRQPS169)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS170	(IRC0.unIRQPS5.stcField.u1IRQPS170)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS171	(IRC0.unIRQPS5.stcField.u1IRQPS171)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS172	(IRC0.unIRQPS5.stcField.u1IRQPS172)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS173	(IRC0.unIRQPS5.stcField.u1IRQPS173)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS174	(IRC0.unIRQPS5.stcField.u1IRQPS174)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS175	(IRC0.unIRQPS5.stcField.u1IRQPS175)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS176	(IRC0.unIRQPS5.stcField.u1IRQPS176)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS177	(IRC0.unIRQPS5.stcField.u1IRQPS177)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS178	(IRC0.unIRQPS5.stcField.u1IRQPS178)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS179	(IRC0.unIRQPS5.stcField.u1IRQPS179)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS180	(IRC0.unIRQPS5.stcField.u1IRQPS180)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS181	(IRC0.unIRQPS5.stcField.u1IRQPS181)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS182	(IRC0.unIRQPS5.stcField.u1IRQPS182)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS183	(IRC0.unIRQPS5.stcField.u1IRQPS183)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS184	(IRC0.unIRQPS5.stcField.u1IRQPS184)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS185	(IRC0.unIRQPS5.stcField.u1IRQPS185)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS186	(IRC0.unIRQPS5.stcField.u1IRQPS186)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS187	(IRC0.unIRQPS5.stcField.u1IRQPS187)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS188	(IRC0.unIRQPS5.stcField.u1IRQPS188)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS189	(IRC0.unIRQPS5.stcField.u1IRQPS189)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS190	(IRC0.unIRQPS5.stcField.u1IRQPS190)  /*@bf@*/
#define IRC0_IRQPS5_IRQPS191	(IRC0.unIRQPS5.stcField.u1IRQPS191)  /*@bf@*/

typedef struct stc_irc0_irqps5_field{
    uint_io32_t		u1IRQPS160:1;
    uint_io32_t		u1IRQPS161:1;
    uint_io32_t		u1IRQPS162:1;
    uint_io32_t		u1IRQPS163:1;
    uint_io32_t		u1IRQPS164:1;
    uint_io32_t		u1IRQPS165:1;
    uint_io32_t		u1IRQPS166:1;
    uint_io32_t		u1IRQPS167:1;
    uint_io32_t		u1IRQPS168:1;
    uint_io32_t		u1IRQPS169:1;
    uint_io32_t		u1IRQPS170:1;
    uint_io32_t		u1IRQPS171:1;
    uint_io32_t		u1IRQPS172:1;
    uint_io32_t		u1IRQPS173:1;
    uint_io32_t		u1IRQPS174:1;
    uint_io32_t		u1IRQPS175:1;
    uint_io32_t		u1IRQPS176:1;
    uint_io32_t		u1IRQPS177:1;
    uint_io32_t		u1IRQPS178:1;
    uint_io32_t		u1IRQPS179:1;
    uint_io32_t		u1IRQPS180:1;
    uint_io32_t		u1IRQPS181:1;
    uint_io32_t		u1IRQPS182:1;
    uint_io32_t		u1IRQPS183:1;
    uint_io32_t		u1IRQPS184:1;
    uint_io32_t		u1IRQPS185:1;
    uint_io32_t		u1IRQPS186:1;
    uint_io32_t		u1IRQPS187:1;
    uint_io32_t		u1IRQPS188:1;
    uint_io32_t		u1IRQPS189:1;
    uint_io32_t		u1IRQPS190:1;
    uint_io32_t		u1IRQPS191:1;
}stc_irc0_irqps5_field_t;

typedef union un_irc0_irqps5{
    uint_io32_t		u32Register;
    stc_irc0_irqps5_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps5_t;

/* IRQPS6 */
#define IRC0_IRQPS6	(IRC0.unIRQPS6.u32Register)  /*@rg@*/
#define IRC0_IRQPS6_IRQPS192	(IRC0.unIRQPS6.stcField.u1IRQPS192)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS193	(IRC0.unIRQPS6.stcField.u1IRQPS193)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS194	(IRC0.unIRQPS6.stcField.u1IRQPS194)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS195	(IRC0.unIRQPS6.stcField.u1IRQPS195)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS196	(IRC0.unIRQPS6.stcField.u1IRQPS196)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS197	(IRC0.unIRQPS6.stcField.u1IRQPS197)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS198	(IRC0.unIRQPS6.stcField.u1IRQPS198)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS199	(IRC0.unIRQPS6.stcField.u1IRQPS199)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS200	(IRC0.unIRQPS6.stcField.u1IRQPS200)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS201	(IRC0.unIRQPS6.stcField.u1IRQPS201)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS202	(IRC0.unIRQPS6.stcField.u1IRQPS202)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS203	(IRC0.unIRQPS6.stcField.u1IRQPS203)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS204	(IRC0.unIRQPS6.stcField.u1IRQPS204)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS205	(IRC0.unIRQPS6.stcField.u1IRQPS205)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS206	(IRC0.unIRQPS6.stcField.u1IRQPS206)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS207	(IRC0.unIRQPS6.stcField.u1IRQPS207)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS208	(IRC0.unIRQPS6.stcField.u1IRQPS208)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS209	(IRC0.unIRQPS6.stcField.u1IRQPS209)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS210	(IRC0.unIRQPS6.stcField.u1IRQPS210)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS211	(IRC0.unIRQPS6.stcField.u1IRQPS211)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS212	(IRC0.unIRQPS6.stcField.u1IRQPS212)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS213	(IRC0.unIRQPS6.stcField.u1IRQPS213)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS214	(IRC0.unIRQPS6.stcField.u1IRQPS214)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS215	(IRC0.unIRQPS6.stcField.u1IRQPS215)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS216	(IRC0.unIRQPS6.stcField.u1IRQPS216)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS217	(IRC0.unIRQPS6.stcField.u1IRQPS217)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS218	(IRC0.unIRQPS6.stcField.u1IRQPS218)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS219	(IRC0.unIRQPS6.stcField.u1IRQPS219)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS220	(IRC0.unIRQPS6.stcField.u1IRQPS220)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS221	(IRC0.unIRQPS6.stcField.u1IRQPS221)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS222	(IRC0.unIRQPS6.stcField.u1IRQPS222)  /*@bf@*/
#define IRC0_IRQPS6_IRQPS223	(IRC0.unIRQPS6.stcField.u1IRQPS223)  /*@bf@*/

typedef struct stc_irc0_irqps6_field{
    uint_io32_t		u1IRQPS192:1;
    uint_io32_t		u1IRQPS193:1;
    uint_io32_t		u1IRQPS194:1;
    uint_io32_t		u1IRQPS195:1;
    uint_io32_t		u1IRQPS196:1;
    uint_io32_t		u1IRQPS197:1;
    uint_io32_t		u1IRQPS198:1;
    uint_io32_t		u1IRQPS199:1;
    uint_io32_t		u1IRQPS200:1;
    uint_io32_t		u1IRQPS201:1;
    uint_io32_t		u1IRQPS202:1;
    uint_io32_t		u1IRQPS203:1;
    uint_io32_t		u1IRQPS204:1;
    uint_io32_t		u1IRQPS205:1;
    uint_io32_t		u1IRQPS206:1;
    uint_io32_t		u1IRQPS207:1;
    uint_io32_t		u1IRQPS208:1;
    uint_io32_t		u1IRQPS209:1;
    uint_io32_t		u1IRQPS210:1;
    uint_io32_t		u1IRQPS211:1;
    uint_io32_t		u1IRQPS212:1;
    uint_io32_t		u1IRQPS213:1;
    uint_io32_t		u1IRQPS214:1;
    uint_io32_t		u1IRQPS215:1;
    uint_io32_t		u1IRQPS216:1;
    uint_io32_t		u1IRQPS217:1;
    uint_io32_t		u1IRQPS218:1;
    uint_io32_t		u1IRQPS219:1;
    uint_io32_t		u1IRQPS220:1;
    uint_io32_t		u1IRQPS221:1;
    uint_io32_t		u1IRQPS222:1;
    uint_io32_t		u1IRQPS223:1;
}stc_irc0_irqps6_field_t;

typedef union un_irc0_irqps6{
    uint_io32_t		u32Register;
    stc_irc0_irqps6_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps6_t;

/* IRQPS7 */
#define IRC0_IRQPS7	(IRC0.unIRQPS7.u32Register)  /*@rg@*/
#define IRC0_IRQPS7_IRQPS224	(IRC0.unIRQPS7.stcField.u1IRQPS224)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS225	(IRC0.unIRQPS7.stcField.u1IRQPS225)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS226	(IRC0.unIRQPS7.stcField.u1IRQPS226)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS227	(IRC0.unIRQPS7.stcField.u1IRQPS227)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS228	(IRC0.unIRQPS7.stcField.u1IRQPS228)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS229	(IRC0.unIRQPS7.stcField.u1IRQPS229)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS230	(IRC0.unIRQPS7.stcField.u1IRQPS230)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS231	(IRC0.unIRQPS7.stcField.u1IRQPS231)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS232	(IRC0.unIRQPS7.stcField.u1IRQPS232)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS233	(IRC0.unIRQPS7.stcField.u1IRQPS233)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS234	(IRC0.unIRQPS7.stcField.u1IRQPS234)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS235	(IRC0.unIRQPS7.stcField.u1IRQPS235)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS236	(IRC0.unIRQPS7.stcField.u1IRQPS236)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS237	(IRC0.unIRQPS7.stcField.u1IRQPS237)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS238	(IRC0.unIRQPS7.stcField.u1IRQPS238)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS239	(IRC0.unIRQPS7.stcField.u1IRQPS239)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS240	(IRC0.unIRQPS7.stcField.u1IRQPS240)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS241	(IRC0.unIRQPS7.stcField.u1IRQPS241)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS242	(IRC0.unIRQPS7.stcField.u1IRQPS242)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS243	(IRC0.unIRQPS7.stcField.u1IRQPS243)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS244	(IRC0.unIRQPS7.stcField.u1IRQPS244)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS245	(IRC0.unIRQPS7.stcField.u1IRQPS245)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS246	(IRC0.unIRQPS7.stcField.u1IRQPS246)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS247	(IRC0.unIRQPS7.stcField.u1IRQPS247)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS248	(IRC0.unIRQPS7.stcField.u1IRQPS248)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS249	(IRC0.unIRQPS7.stcField.u1IRQPS249)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS250	(IRC0.unIRQPS7.stcField.u1IRQPS250)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS251	(IRC0.unIRQPS7.stcField.u1IRQPS251)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS252	(IRC0.unIRQPS7.stcField.u1IRQPS252)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS253	(IRC0.unIRQPS7.stcField.u1IRQPS253)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS254	(IRC0.unIRQPS7.stcField.u1IRQPS254)  /*@bf@*/
#define IRC0_IRQPS7_IRQPS255	(IRC0.unIRQPS7.stcField.u1IRQPS255)  /*@bf@*/

typedef struct stc_irc0_irqps7_field{
    uint_io32_t		u1IRQPS224:1;
    uint_io32_t		u1IRQPS225:1;
    uint_io32_t		u1IRQPS226:1;
    uint_io32_t		u1IRQPS227:1;
    uint_io32_t		u1IRQPS228:1;
    uint_io32_t		u1IRQPS229:1;
    uint_io32_t		u1IRQPS230:1;
    uint_io32_t		u1IRQPS231:1;
    uint_io32_t		u1IRQPS232:1;
    uint_io32_t		u1IRQPS233:1;
    uint_io32_t		u1IRQPS234:1;
    uint_io32_t		u1IRQPS235:1;
    uint_io32_t		u1IRQPS236:1;
    uint_io32_t		u1IRQPS237:1;
    uint_io32_t		u1IRQPS238:1;
    uint_io32_t		u1IRQPS239:1;
    uint_io32_t		u1IRQPS240:1;
    uint_io32_t		u1IRQPS241:1;
    uint_io32_t		u1IRQPS242:1;
    uint_io32_t		u1IRQPS243:1;
    uint_io32_t		u1IRQPS244:1;
    uint_io32_t		u1IRQPS245:1;
    uint_io32_t		u1IRQPS246:1;
    uint_io32_t		u1IRQPS247:1;
    uint_io32_t		u1IRQPS248:1;
    uint_io32_t		u1IRQPS249:1;
    uint_io32_t		u1IRQPS250:1;
    uint_io32_t		u1IRQPS251:1;
    uint_io32_t		u1IRQPS252:1;
    uint_io32_t		u1IRQPS253:1;
    uint_io32_t		u1IRQPS254:1;
    uint_io32_t		u1IRQPS255:1;
}stc_irc0_irqps7_field_t;

typedef union un_irc0_irqps7{
    uint_io32_t		u32Register;
    stc_irc0_irqps7_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps7_t;

/* IRQPS8 */
#define IRC0_IRQPS8	(IRC0.unIRQPS8.u32Register)  /*@rg@*/
#define IRC0_IRQPS8_IRQPS256	(IRC0.unIRQPS8.stcField.u1IRQPS256)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS257	(IRC0.unIRQPS8.stcField.u1IRQPS257)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS258	(IRC0.unIRQPS8.stcField.u1IRQPS258)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS259	(IRC0.unIRQPS8.stcField.u1IRQPS259)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS260	(IRC0.unIRQPS8.stcField.u1IRQPS260)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS261	(IRC0.unIRQPS8.stcField.u1IRQPS261)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS262	(IRC0.unIRQPS8.stcField.u1IRQPS262)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS263	(IRC0.unIRQPS8.stcField.u1IRQPS263)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS264	(IRC0.unIRQPS8.stcField.u1IRQPS264)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS265	(IRC0.unIRQPS8.stcField.u1IRQPS265)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS266	(IRC0.unIRQPS8.stcField.u1IRQPS266)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS267	(IRC0.unIRQPS8.stcField.u1IRQPS267)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS268	(IRC0.unIRQPS8.stcField.u1IRQPS268)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS269	(IRC0.unIRQPS8.stcField.u1IRQPS269)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS270	(IRC0.unIRQPS8.stcField.u1IRQPS270)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS271	(IRC0.unIRQPS8.stcField.u1IRQPS271)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS272	(IRC0.unIRQPS8.stcField.u1IRQPS272)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS273	(IRC0.unIRQPS8.stcField.u1IRQPS273)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS274	(IRC0.unIRQPS8.stcField.u1IRQPS274)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS275	(IRC0.unIRQPS8.stcField.u1IRQPS275)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS276	(IRC0.unIRQPS8.stcField.u1IRQPS276)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS277	(IRC0.unIRQPS8.stcField.u1IRQPS277)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS278	(IRC0.unIRQPS8.stcField.u1IRQPS278)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS279	(IRC0.unIRQPS8.stcField.u1IRQPS279)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS280	(IRC0.unIRQPS8.stcField.u1IRQPS280)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS281	(IRC0.unIRQPS8.stcField.u1IRQPS281)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS282	(IRC0.unIRQPS8.stcField.u1IRQPS282)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS283	(IRC0.unIRQPS8.stcField.u1IRQPS283)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS284	(IRC0.unIRQPS8.stcField.u1IRQPS284)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS285	(IRC0.unIRQPS8.stcField.u1IRQPS285)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS286	(IRC0.unIRQPS8.stcField.u1IRQPS286)  /*@bf@*/
#define IRC0_IRQPS8_IRQPS287	(IRC0.unIRQPS8.stcField.u1IRQPS287)  /*@bf@*/

typedef struct stc_irc0_irqps8_field{
    uint_io32_t		u1IRQPS256:1;
    uint_io32_t		u1IRQPS257:1;
    uint_io32_t		u1IRQPS258:1;
    uint_io32_t		u1IRQPS259:1;
    uint_io32_t		u1IRQPS260:1;
    uint_io32_t		u1IRQPS261:1;
    uint_io32_t		u1IRQPS262:1;
    uint_io32_t		u1IRQPS263:1;
    uint_io32_t		u1IRQPS264:1;
    uint_io32_t		u1IRQPS265:1;
    uint_io32_t		u1IRQPS266:1;
    uint_io32_t		u1IRQPS267:1;
    uint_io32_t		u1IRQPS268:1;
    uint_io32_t		u1IRQPS269:1;
    uint_io32_t		u1IRQPS270:1;
    uint_io32_t		u1IRQPS271:1;
    uint_io32_t		u1IRQPS272:1;
    uint_io32_t		u1IRQPS273:1;
    uint_io32_t		u1IRQPS274:1;
    uint_io32_t		u1IRQPS275:1;
    uint_io32_t		u1IRQPS276:1;
    uint_io32_t		u1IRQPS277:1;
    uint_io32_t		u1IRQPS278:1;
    uint_io32_t		u1IRQPS279:1;
    uint_io32_t		u1IRQPS280:1;
    uint_io32_t		u1IRQPS281:1;
    uint_io32_t		u1IRQPS282:1;
    uint_io32_t		u1IRQPS283:1;
    uint_io32_t		u1IRQPS284:1;
    uint_io32_t		u1IRQPS285:1;
    uint_io32_t		u1IRQPS286:1;
    uint_io32_t		u1IRQPS287:1;
}stc_irc0_irqps8_field_t;

typedef union un_irc0_irqps8{
    uint_io32_t		u32Register;
    stc_irc0_irqps8_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps8_t;

/* IRQPS9 */
#define IRC0_IRQPS9	(IRC0.unIRQPS9.u32Register)  /*@rg@*/
#define IRC0_IRQPS9_IRQPS288	(IRC0.unIRQPS9.stcField.u1IRQPS288)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS289	(IRC0.unIRQPS9.stcField.u1IRQPS289)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS290	(IRC0.unIRQPS9.stcField.u1IRQPS290)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS291	(IRC0.unIRQPS9.stcField.u1IRQPS291)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS292	(IRC0.unIRQPS9.stcField.u1IRQPS292)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS293	(IRC0.unIRQPS9.stcField.u1IRQPS293)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS294	(IRC0.unIRQPS9.stcField.u1IRQPS294)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS295	(IRC0.unIRQPS9.stcField.u1IRQPS295)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS296	(IRC0.unIRQPS9.stcField.u1IRQPS296)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS297	(IRC0.unIRQPS9.stcField.u1IRQPS297)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS298	(IRC0.unIRQPS9.stcField.u1IRQPS298)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS299	(IRC0.unIRQPS9.stcField.u1IRQPS299)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS300	(IRC0.unIRQPS9.stcField.u1IRQPS300)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS301	(IRC0.unIRQPS9.stcField.u1IRQPS301)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS302	(IRC0.unIRQPS9.stcField.u1IRQPS302)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS303	(IRC0.unIRQPS9.stcField.u1IRQPS303)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS304	(IRC0.unIRQPS9.stcField.u1IRQPS304)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS305	(IRC0.unIRQPS9.stcField.u1IRQPS305)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS306	(IRC0.unIRQPS9.stcField.u1IRQPS306)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS307	(IRC0.unIRQPS9.stcField.u1IRQPS307)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS308	(IRC0.unIRQPS9.stcField.u1IRQPS308)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS309	(IRC0.unIRQPS9.stcField.u1IRQPS309)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS310	(IRC0.unIRQPS9.stcField.u1IRQPS310)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS311	(IRC0.unIRQPS9.stcField.u1IRQPS311)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS312	(IRC0.unIRQPS9.stcField.u1IRQPS312)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS313	(IRC0.unIRQPS9.stcField.u1IRQPS313)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS314	(IRC0.unIRQPS9.stcField.u1IRQPS314)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS315	(IRC0.unIRQPS9.stcField.u1IRQPS315)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS316	(IRC0.unIRQPS9.stcField.u1IRQPS316)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS317	(IRC0.unIRQPS9.stcField.u1IRQPS317)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS318	(IRC0.unIRQPS9.stcField.u1IRQPS318)  /*@bf@*/
#define IRC0_IRQPS9_IRQPS319	(IRC0.unIRQPS9.stcField.u1IRQPS319)  /*@bf@*/

typedef struct stc_irc0_irqps9_field{
    uint_io32_t		u1IRQPS288:1;
    uint_io32_t		u1IRQPS289:1;
    uint_io32_t		u1IRQPS290:1;
    uint_io32_t		u1IRQPS291:1;
    uint_io32_t		u1IRQPS292:1;
    uint_io32_t		u1IRQPS293:1;
    uint_io32_t		u1IRQPS294:1;
    uint_io32_t		u1IRQPS295:1;
    uint_io32_t		u1IRQPS296:1;
    uint_io32_t		u1IRQPS297:1;
    uint_io32_t		u1IRQPS298:1;
    uint_io32_t		u1IRQPS299:1;
    uint_io32_t		u1IRQPS300:1;
    uint_io32_t		u1IRQPS301:1;
    uint_io32_t		u1IRQPS302:1;
    uint_io32_t		u1IRQPS303:1;
    uint_io32_t		u1IRQPS304:1;
    uint_io32_t		u1IRQPS305:1;
    uint_io32_t		u1IRQPS306:1;
    uint_io32_t		u1IRQPS307:1;
    uint_io32_t		u1IRQPS308:1;
    uint_io32_t		u1IRQPS309:1;
    uint_io32_t		u1IRQPS310:1;
    uint_io32_t		u1IRQPS311:1;
    uint_io32_t		u1IRQPS312:1;
    uint_io32_t		u1IRQPS313:1;
    uint_io32_t		u1IRQPS314:1;
    uint_io32_t		u1IRQPS315:1;
    uint_io32_t		u1IRQPS316:1;
    uint_io32_t		u1IRQPS317:1;
    uint_io32_t		u1IRQPS318:1;
    uint_io32_t		u1IRQPS319:1;
}stc_irc0_irqps9_field_t;

typedef union un_irc0_irqps9{
    uint_io32_t		u32Register;
    stc_irc0_irqps9_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps9_t;

/* IRQPS10 */
#define IRC0_IRQPS10	(IRC0.unIRQPS10.u32Register)  /*@rg@*/
#define IRC0_IRQPS10_IRQPS320	(IRC0.unIRQPS10.stcField.u1IRQPS320)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS321	(IRC0.unIRQPS10.stcField.u1IRQPS321)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS322	(IRC0.unIRQPS10.stcField.u1IRQPS322)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS323	(IRC0.unIRQPS10.stcField.u1IRQPS323)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS324	(IRC0.unIRQPS10.stcField.u1IRQPS324)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS325	(IRC0.unIRQPS10.stcField.u1IRQPS325)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS326	(IRC0.unIRQPS10.stcField.u1IRQPS326)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS327	(IRC0.unIRQPS10.stcField.u1IRQPS327)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS328	(IRC0.unIRQPS10.stcField.u1IRQPS328)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS329	(IRC0.unIRQPS10.stcField.u1IRQPS329)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS330	(IRC0.unIRQPS10.stcField.u1IRQPS330)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS331	(IRC0.unIRQPS10.stcField.u1IRQPS331)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS332	(IRC0.unIRQPS10.stcField.u1IRQPS332)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS333	(IRC0.unIRQPS10.stcField.u1IRQPS333)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS334	(IRC0.unIRQPS10.stcField.u1IRQPS334)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS335	(IRC0.unIRQPS10.stcField.u1IRQPS335)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS336	(IRC0.unIRQPS10.stcField.u1IRQPS336)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS337	(IRC0.unIRQPS10.stcField.u1IRQPS337)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS338	(IRC0.unIRQPS10.stcField.u1IRQPS338)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS339	(IRC0.unIRQPS10.stcField.u1IRQPS339)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS340	(IRC0.unIRQPS10.stcField.u1IRQPS340)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS341	(IRC0.unIRQPS10.stcField.u1IRQPS341)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS342	(IRC0.unIRQPS10.stcField.u1IRQPS342)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS343	(IRC0.unIRQPS10.stcField.u1IRQPS343)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS344	(IRC0.unIRQPS10.stcField.u1IRQPS344)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS345	(IRC0.unIRQPS10.stcField.u1IRQPS345)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS346	(IRC0.unIRQPS10.stcField.u1IRQPS346)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS347	(IRC0.unIRQPS10.stcField.u1IRQPS347)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS348	(IRC0.unIRQPS10.stcField.u1IRQPS348)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS349	(IRC0.unIRQPS10.stcField.u1IRQPS349)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS350	(IRC0.unIRQPS10.stcField.u1IRQPS350)  /*@bf@*/
#define IRC0_IRQPS10_IRQPS351	(IRC0.unIRQPS10.stcField.u1IRQPS351)  /*@bf@*/

typedef struct stc_irc0_irqps10_field{
    uint_io32_t		u1IRQPS320:1;
    uint_io32_t		u1IRQPS321:1;
    uint_io32_t		u1IRQPS322:1;
    uint_io32_t		u1IRQPS323:1;
    uint_io32_t		u1IRQPS324:1;
    uint_io32_t		u1IRQPS325:1;
    uint_io32_t		u1IRQPS326:1;
    uint_io32_t		u1IRQPS327:1;
    uint_io32_t		u1IRQPS328:1;
    uint_io32_t		u1IRQPS329:1;
    uint_io32_t		u1IRQPS330:1;
    uint_io32_t		u1IRQPS331:1;
    uint_io32_t		u1IRQPS332:1;
    uint_io32_t		u1IRQPS333:1;
    uint_io32_t		u1IRQPS334:1;
    uint_io32_t		u1IRQPS335:1;
    uint_io32_t		u1IRQPS336:1;
    uint_io32_t		u1IRQPS337:1;
    uint_io32_t		u1IRQPS338:1;
    uint_io32_t		u1IRQPS339:1;
    uint_io32_t		u1IRQPS340:1;
    uint_io32_t		u1IRQPS341:1;
    uint_io32_t		u1IRQPS342:1;
    uint_io32_t		u1IRQPS343:1;
    uint_io32_t		u1IRQPS344:1;
    uint_io32_t		u1IRQPS345:1;
    uint_io32_t		u1IRQPS346:1;
    uint_io32_t		u1IRQPS347:1;
    uint_io32_t		u1IRQPS348:1;
    uint_io32_t		u1IRQPS349:1;
    uint_io32_t		u1IRQPS350:1;
    uint_io32_t		u1IRQPS351:1;
}stc_irc0_irqps10_field_t;

typedef union un_irc0_irqps10{
    uint_io32_t		u32Register;
    stc_irc0_irqps10_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps10_t;

/* IRQPS11 */
#define IRC0_IRQPS11	(IRC0.unIRQPS11.u32Register)  /*@rg@*/
#define IRC0_IRQPS11_IRQPS352	(IRC0.unIRQPS11.stcField.u1IRQPS352)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS353	(IRC0.unIRQPS11.stcField.u1IRQPS353)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS354	(IRC0.unIRQPS11.stcField.u1IRQPS354)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS355	(IRC0.unIRQPS11.stcField.u1IRQPS355)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS356	(IRC0.unIRQPS11.stcField.u1IRQPS356)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS357	(IRC0.unIRQPS11.stcField.u1IRQPS357)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS358	(IRC0.unIRQPS11.stcField.u1IRQPS358)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS359	(IRC0.unIRQPS11.stcField.u1IRQPS359)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS360	(IRC0.unIRQPS11.stcField.u1IRQPS360)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS361	(IRC0.unIRQPS11.stcField.u1IRQPS361)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS362	(IRC0.unIRQPS11.stcField.u1IRQPS362)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS363	(IRC0.unIRQPS11.stcField.u1IRQPS363)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS364	(IRC0.unIRQPS11.stcField.u1IRQPS364)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS365	(IRC0.unIRQPS11.stcField.u1IRQPS365)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS366	(IRC0.unIRQPS11.stcField.u1IRQPS366)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS367	(IRC0.unIRQPS11.stcField.u1IRQPS367)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS368	(IRC0.unIRQPS11.stcField.u1IRQPS368)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS369	(IRC0.unIRQPS11.stcField.u1IRQPS369)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS370	(IRC0.unIRQPS11.stcField.u1IRQPS370)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS371	(IRC0.unIRQPS11.stcField.u1IRQPS371)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS372	(IRC0.unIRQPS11.stcField.u1IRQPS372)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS373	(IRC0.unIRQPS11.stcField.u1IRQPS373)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS374	(IRC0.unIRQPS11.stcField.u1IRQPS374)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS375	(IRC0.unIRQPS11.stcField.u1IRQPS375)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS376	(IRC0.unIRQPS11.stcField.u1IRQPS376)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS377	(IRC0.unIRQPS11.stcField.u1IRQPS377)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS378	(IRC0.unIRQPS11.stcField.u1IRQPS378)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS379	(IRC0.unIRQPS11.stcField.u1IRQPS379)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS380	(IRC0.unIRQPS11.stcField.u1IRQPS380)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS381	(IRC0.unIRQPS11.stcField.u1IRQPS381)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS382	(IRC0.unIRQPS11.stcField.u1IRQPS382)  /*@bf@*/
#define IRC0_IRQPS11_IRQPS383	(IRC0.unIRQPS11.stcField.u1IRQPS383)  /*@bf@*/

typedef struct stc_irc0_irqps11_field{
    uint_io32_t		u1IRQPS352:1;
    uint_io32_t		u1IRQPS353:1;
    uint_io32_t		u1IRQPS354:1;
    uint_io32_t		u1IRQPS355:1;
    uint_io32_t		u1IRQPS356:1;
    uint_io32_t		u1IRQPS357:1;
    uint_io32_t		u1IRQPS358:1;
    uint_io32_t		u1IRQPS359:1;
    uint_io32_t		u1IRQPS360:1;
    uint_io32_t		u1IRQPS361:1;
    uint_io32_t		u1IRQPS362:1;
    uint_io32_t		u1IRQPS363:1;
    uint_io32_t		u1IRQPS364:1;
    uint_io32_t		u1IRQPS365:1;
    uint_io32_t		u1IRQPS366:1;
    uint_io32_t		u1IRQPS367:1;
    uint_io32_t		u1IRQPS368:1;
    uint_io32_t		u1IRQPS369:1;
    uint_io32_t		u1IRQPS370:1;
    uint_io32_t		u1IRQPS371:1;
    uint_io32_t		u1IRQPS372:1;
    uint_io32_t		u1IRQPS373:1;
    uint_io32_t		u1IRQPS374:1;
    uint_io32_t		u1IRQPS375:1;
    uint_io32_t		u1IRQPS376:1;
    uint_io32_t		u1IRQPS377:1;
    uint_io32_t		u1IRQPS378:1;
    uint_io32_t		u1IRQPS379:1;
    uint_io32_t		u1IRQPS380:1;
    uint_io32_t		u1IRQPS381:1;
    uint_io32_t		u1IRQPS382:1;
    uint_io32_t		u1IRQPS383:1;
}stc_irc0_irqps11_field_t;

typedef union un_irc0_irqps11{
    uint_io32_t		u32Register;
    stc_irc0_irqps11_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps11_t;

/* IRQPS12 */
#define IRC0_IRQPS12	(IRC0.unIRQPS12.u32Register)  /*@rg@*/
#define IRC0_IRQPS12_IRQPS384	(IRC0.unIRQPS12.stcField.u1IRQPS384)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS385	(IRC0.unIRQPS12.stcField.u1IRQPS385)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS386	(IRC0.unIRQPS12.stcField.u1IRQPS386)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS387	(IRC0.unIRQPS12.stcField.u1IRQPS387)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS388	(IRC0.unIRQPS12.stcField.u1IRQPS388)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS389	(IRC0.unIRQPS12.stcField.u1IRQPS389)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS390	(IRC0.unIRQPS12.stcField.u1IRQPS390)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS391	(IRC0.unIRQPS12.stcField.u1IRQPS391)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS392	(IRC0.unIRQPS12.stcField.u1IRQPS392)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS393	(IRC0.unIRQPS12.stcField.u1IRQPS393)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS394	(IRC0.unIRQPS12.stcField.u1IRQPS394)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS395	(IRC0.unIRQPS12.stcField.u1IRQPS395)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS396	(IRC0.unIRQPS12.stcField.u1IRQPS396)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS397	(IRC0.unIRQPS12.stcField.u1IRQPS397)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS398	(IRC0.unIRQPS12.stcField.u1IRQPS398)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS399	(IRC0.unIRQPS12.stcField.u1IRQPS399)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS400	(IRC0.unIRQPS12.stcField.u1IRQPS400)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS401	(IRC0.unIRQPS12.stcField.u1IRQPS401)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS402	(IRC0.unIRQPS12.stcField.u1IRQPS402)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS403	(IRC0.unIRQPS12.stcField.u1IRQPS403)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS404	(IRC0.unIRQPS12.stcField.u1IRQPS404)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS405	(IRC0.unIRQPS12.stcField.u1IRQPS405)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS406	(IRC0.unIRQPS12.stcField.u1IRQPS406)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS407	(IRC0.unIRQPS12.stcField.u1IRQPS407)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS408	(IRC0.unIRQPS12.stcField.u1IRQPS408)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS409	(IRC0.unIRQPS12.stcField.u1IRQPS409)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS410	(IRC0.unIRQPS12.stcField.u1IRQPS410)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS411	(IRC0.unIRQPS12.stcField.u1IRQPS411)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS412	(IRC0.unIRQPS12.stcField.u1IRQPS412)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS413	(IRC0.unIRQPS12.stcField.u1IRQPS413)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS414	(IRC0.unIRQPS12.stcField.u1IRQPS414)  /*@bf@*/
#define IRC0_IRQPS12_IRQPS415	(IRC0.unIRQPS12.stcField.u1IRQPS415)  /*@bf@*/

typedef struct stc_irc0_irqps12_field{
    uint_io32_t		u1IRQPS384:1;
    uint_io32_t		u1IRQPS385:1;
    uint_io32_t		u1IRQPS386:1;
    uint_io32_t		u1IRQPS387:1;
    uint_io32_t		u1IRQPS388:1;
    uint_io32_t		u1IRQPS389:1;
    uint_io32_t		u1IRQPS390:1;
    uint_io32_t		u1IRQPS391:1;
    uint_io32_t		u1IRQPS392:1;
    uint_io32_t		u1IRQPS393:1;
    uint_io32_t		u1IRQPS394:1;
    uint_io32_t		u1IRQPS395:1;
    uint_io32_t		u1IRQPS396:1;
    uint_io32_t		u1IRQPS397:1;
    uint_io32_t		u1IRQPS398:1;
    uint_io32_t		u1IRQPS399:1;
    uint_io32_t		u1IRQPS400:1;
    uint_io32_t		u1IRQPS401:1;
    uint_io32_t		u1IRQPS402:1;
    uint_io32_t		u1IRQPS403:1;
    uint_io32_t		u1IRQPS404:1;
    uint_io32_t		u1IRQPS405:1;
    uint_io32_t		u1IRQPS406:1;
    uint_io32_t		u1IRQPS407:1;
    uint_io32_t		u1IRQPS408:1;
    uint_io32_t		u1IRQPS409:1;
    uint_io32_t		u1IRQPS410:1;
    uint_io32_t		u1IRQPS411:1;
    uint_io32_t		u1IRQPS412:1;
    uint_io32_t		u1IRQPS413:1;
    uint_io32_t		u1IRQPS414:1;
    uint_io32_t		u1IRQPS415:1;
}stc_irc0_irqps12_field_t;

typedef union un_irc0_irqps12{
    uint_io32_t		u32Register;
    stc_irc0_irqps12_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps12_t;

/* IRQPS13 */
#define IRC0_IRQPS13	(IRC0.unIRQPS13.u32Register)  /*@rg@*/
#define IRC0_IRQPS13_IRQPS416	(IRC0.unIRQPS13.stcField.u1IRQPS416)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS417	(IRC0.unIRQPS13.stcField.u1IRQPS417)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS418	(IRC0.unIRQPS13.stcField.u1IRQPS418)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS419	(IRC0.unIRQPS13.stcField.u1IRQPS419)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS420	(IRC0.unIRQPS13.stcField.u1IRQPS420)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS421	(IRC0.unIRQPS13.stcField.u1IRQPS421)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS422	(IRC0.unIRQPS13.stcField.u1IRQPS422)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS423	(IRC0.unIRQPS13.stcField.u1IRQPS423)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS424	(IRC0.unIRQPS13.stcField.u1IRQPS424)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS425	(IRC0.unIRQPS13.stcField.u1IRQPS425)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS426	(IRC0.unIRQPS13.stcField.u1IRQPS426)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS427	(IRC0.unIRQPS13.stcField.u1IRQPS427)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS428	(IRC0.unIRQPS13.stcField.u1IRQPS428)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS429	(IRC0.unIRQPS13.stcField.u1IRQPS429)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS430	(IRC0.unIRQPS13.stcField.u1IRQPS430)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS431	(IRC0.unIRQPS13.stcField.u1IRQPS431)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS432	(IRC0.unIRQPS13.stcField.u1IRQPS432)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS433	(IRC0.unIRQPS13.stcField.u1IRQPS433)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS434	(IRC0.unIRQPS13.stcField.u1IRQPS434)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS435	(IRC0.unIRQPS13.stcField.u1IRQPS435)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS436	(IRC0.unIRQPS13.stcField.u1IRQPS436)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS437	(IRC0.unIRQPS13.stcField.u1IRQPS437)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS438	(IRC0.unIRQPS13.stcField.u1IRQPS438)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS439	(IRC0.unIRQPS13.stcField.u1IRQPS439)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS440	(IRC0.unIRQPS13.stcField.u1IRQPS440)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS441	(IRC0.unIRQPS13.stcField.u1IRQPS441)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS442	(IRC0.unIRQPS13.stcField.u1IRQPS442)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS443	(IRC0.unIRQPS13.stcField.u1IRQPS443)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS444	(IRC0.unIRQPS13.stcField.u1IRQPS444)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS445	(IRC0.unIRQPS13.stcField.u1IRQPS445)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS446	(IRC0.unIRQPS13.stcField.u1IRQPS446)  /*@bf@*/
#define IRC0_IRQPS13_IRQPS447	(IRC0.unIRQPS13.stcField.u1IRQPS447)  /*@bf@*/

typedef struct stc_irc0_irqps13_field{
    uint_io32_t		u1IRQPS416:1;
    uint_io32_t		u1IRQPS417:1;
    uint_io32_t		u1IRQPS418:1;
    uint_io32_t		u1IRQPS419:1;
    uint_io32_t		u1IRQPS420:1;
    uint_io32_t		u1IRQPS421:1;
    uint_io32_t		u1IRQPS422:1;
    uint_io32_t		u1IRQPS423:1;
    uint_io32_t		u1IRQPS424:1;
    uint_io32_t		u1IRQPS425:1;
    uint_io32_t		u1IRQPS426:1;
    uint_io32_t		u1IRQPS427:1;
    uint_io32_t		u1IRQPS428:1;
    uint_io32_t		u1IRQPS429:1;
    uint_io32_t		u1IRQPS430:1;
    uint_io32_t		u1IRQPS431:1;
    uint_io32_t		u1IRQPS432:1;
    uint_io32_t		u1IRQPS433:1;
    uint_io32_t		u1IRQPS434:1;
    uint_io32_t		u1IRQPS435:1;
    uint_io32_t		u1IRQPS436:1;
    uint_io32_t		u1IRQPS437:1;
    uint_io32_t		u1IRQPS438:1;
    uint_io32_t		u1IRQPS439:1;
    uint_io32_t		u1IRQPS440:1;
    uint_io32_t		u1IRQPS441:1;
    uint_io32_t		u1IRQPS442:1;
    uint_io32_t		u1IRQPS443:1;
    uint_io32_t		u1IRQPS444:1;
    uint_io32_t		u1IRQPS445:1;
    uint_io32_t		u1IRQPS446:1;
    uint_io32_t		u1IRQPS447:1;
}stc_irc0_irqps13_field_t;

typedef union un_irc0_irqps13{
    uint_io32_t		u32Register;
    stc_irc0_irqps13_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps13_t;

/* IRQPS14 */
#define IRC0_IRQPS14	(IRC0.unIRQPS14.u32Register)  /*@rg@*/
#define IRC0_IRQPS14_IRQPS448	(IRC0.unIRQPS14.stcField.u1IRQPS448)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS449	(IRC0.unIRQPS14.stcField.u1IRQPS449)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS450	(IRC0.unIRQPS14.stcField.u1IRQPS450)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS451	(IRC0.unIRQPS14.stcField.u1IRQPS451)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS452	(IRC0.unIRQPS14.stcField.u1IRQPS452)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS453	(IRC0.unIRQPS14.stcField.u1IRQPS453)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS454	(IRC0.unIRQPS14.stcField.u1IRQPS454)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS455	(IRC0.unIRQPS14.stcField.u1IRQPS455)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS456	(IRC0.unIRQPS14.stcField.u1IRQPS456)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS457	(IRC0.unIRQPS14.stcField.u1IRQPS457)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS458	(IRC0.unIRQPS14.stcField.u1IRQPS458)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS459	(IRC0.unIRQPS14.stcField.u1IRQPS459)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS460	(IRC0.unIRQPS14.stcField.u1IRQPS460)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS461	(IRC0.unIRQPS14.stcField.u1IRQPS461)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS462	(IRC0.unIRQPS14.stcField.u1IRQPS462)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS463	(IRC0.unIRQPS14.stcField.u1IRQPS463)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS464	(IRC0.unIRQPS14.stcField.u1IRQPS464)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS465	(IRC0.unIRQPS14.stcField.u1IRQPS465)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS466	(IRC0.unIRQPS14.stcField.u1IRQPS466)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS467	(IRC0.unIRQPS14.stcField.u1IRQPS467)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS468	(IRC0.unIRQPS14.stcField.u1IRQPS468)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS469	(IRC0.unIRQPS14.stcField.u1IRQPS469)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS470	(IRC0.unIRQPS14.stcField.u1IRQPS470)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS471	(IRC0.unIRQPS14.stcField.u1IRQPS471)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS472	(IRC0.unIRQPS14.stcField.u1IRQPS472)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS473	(IRC0.unIRQPS14.stcField.u1IRQPS473)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS474	(IRC0.unIRQPS14.stcField.u1IRQPS474)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS475	(IRC0.unIRQPS14.stcField.u1IRQPS475)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS476	(IRC0.unIRQPS14.stcField.u1IRQPS476)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS477	(IRC0.unIRQPS14.stcField.u1IRQPS477)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS478	(IRC0.unIRQPS14.stcField.u1IRQPS478)  /*@bf@*/
#define IRC0_IRQPS14_IRQPS479	(IRC0.unIRQPS14.stcField.u1IRQPS479)  /*@bf@*/

typedef struct stc_irc0_irqps14_field{
    uint_io32_t		u1IRQPS448:1;
    uint_io32_t		u1IRQPS449:1;
    uint_io32_t		u1IRQPS450:1;
    uint_io32_t		u1IRQPS451:1;
    uint_io32_t		u1IRQPS452:1;
    uint_io32_t		u1IRQPS453:1;
    uint_io32_t		u1IRQPS454:1;
    uint_io32_t		u1IRQPS455:1;
    uint_io32_t		u1IRQPS456:1;
    uint_io32_t		u1IRQPS457:1;
    uint_io32_t		u1IRQPS458:1;
    uint_io32_t		u1IRQPS459:1;
    uint_io32_t		u1IRQPS460:1;
    uint_io32_t		u1IRQPS461:1;
    uint_io32_t		u1IRQPS462:1;
    uint_io32_t		u1IRQPS463:1;
    uint_io32_t		u1IRQPS464:1;
    uint_io32_t		u1IRQPS465:1;
    uint_io32_t		u1IRQPS466:1;
    uint_io32_t		u1IRQPS467:1;
    uint_io32_t		u1IRQPS468:1;
    uint_io32_t		u1IRQPS469:1;
    uint_io32_t		u1IRQPS470:1;
    uint_io32_t		u1IRQPS471:1;
    uint_io32_t		u1IRQPS472:1;
    uint_io32_t		u1IRQPS473:1;
    uint_io32_t		u1IRQPS474:1;
    uint_io32_t		u1IRQPS475:1;
    uint_io32_t		u1IRQPS476:1;
    uint_io32_t		u1IRQPS477:1;
    uint_io32_t		u1IRQPS478:1;
    uint_io32_t		u1IRQPS479:1;
}stc_irc0_irqps14_field_t;

typedef union un_irc0_irqps14{
    uint_io32_t		u32Register;
    stc_irc0_irqps14_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps14_t;

/* IRQPS15 */
#define IRC0_IRQPS15	(IRC0.unIRQPS15.u32Register)  /*@rg@*/
#define IRC0_IRQPS15_IRQPS480	(IRC0.unIRQPS15.stcField.u1IRQPS480)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS481	(IRC0.unIRQPS15.stcField.u1IRQPS481)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS482	(IRC0.unIRQPS15.stcField.u1IRQPS482)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS483	(IRC0.unIRQPS15.stcField.u1IRQPS483)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS484	(IRC0.unIRQPS15.stcField.u1IRQPS484)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS485	(IRC0.unIRQPS15.stcField.u1IRQPS485)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS486	(IRC0.unIRQPS15.stcField.u1IRQPS486)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS487	(IRC0.unIRQPS15.stcField.u1IRQPS487)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS488	(IRC0.unIRQPS15.stcField.u1IRQPS488)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS489	(IRC0.unIRQPS15.stcField.u1IRQPS489)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS490	(IRC0.unIRQPS15.stcField.u1IRQPS490)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS491	(IRC0.unIRQPS15.stcField.u1IRQPS491)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS492	(IRC0.unIRQPS15.stcField.u1IRQPS492)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS493	(IRC0.unIRQPS15.stcField.u1IRQPS493)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS494	(IRC0.unIRQPS15.stcField.u1IRQPS494)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS495	(IRC0.unIRQPS15.stcField.u1IRQPS495)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS496	(IRC0.unIRQPS15.stcField.u1IRQPS496)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS497	(IRC0.unIRQPS15.stcField.u1IRQPS497)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS498	(IRC0.unIRQPS15.stcField.u1IRQPS498)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS499	(IRC0.unIRQPS15.stcField.u1IRQPS499)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS500	(IRC0.unIRQPS15.stcField.u1IRQPS500)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS501	(IRC0.unIRQPS15.stcField.u1IRQPS501)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS502	(IRC0.unIRQPS15.stcField.u1IRQPS502)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS503	(IRC0.unIRQPS15.stcField.u1IRQPS503)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS504	(IRC0.unIRQPS15.stcField.u1IRQPS504)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS505	(IRC0.unIRQPS15.stcField.u1IRQPS505)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS506	(IRC0.unIRQPS15.stcField.u1IRQPS506)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS507	(IRC0.unIRQPS15.stcField.u1IRQPS507)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS508	(IRC0.unIRQPS15.stcField.u1IRQPS508)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS509	(IRC0.unIRQPS15.stcField.u1IRQPS509)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS510	(IRC0.unIRQPS15.stcField.u1IRQPS510)  /*@bf@*/
#define IRC0_IRQPS15_IRQPS511	(IRC0.unIRQPS15.stcField.u1IRQPS511)  /*@bf@*/

typedef struct stc_irc0_irqps15_field{
    uint_io32_t		u1IRQPS480:1;
    uint_io32_t		u1IRQPS481:1;
    uint_io32_t		u1IRQPS482:1;
    uint_io32_t		u1IRQPS483:1;
    uint_io32_t		u1IRQPS484:1;
    uint_io32_t		u1IRQPS485:1;
    uint_io32_t		u1IRQPS486:1;
    uint_io32_t		u1IRQPS487:1;
    uint_io32_t		u1IRQPS488:1;
    uint_io32_t		u1IRQPS489:1;
    uint_io32_t		u1IRQPS490:1;
    uint_io32_t		u1IRQPS491:1;
    uint_io32_t		u1IRQPS492:1;
    uint_io32_t		u1IRQPS493:1;
    uint_io32_t		u1IRQPS494:1;
    uint_io32_t		u1IRQPS495:1;
    uint_io32_t		u1IRQPS496:1;
    uint_io32_t		u1IRQPS497:1;
    uint_io32_t		u1IRQPS498:1;
    uint_io32_t		u1IRQPS499:1;
    uint_io32_t		u1IRQPS500:1;
    uint_io32_t		u1IRQPS501:1;
    uint_io32_t		u1IRQPS502:1;
    uint_io32_t		u1IRQPS503:1;
    uint_io32_t		u1IRQPS504:1;
    uint_io32_t		u1IRQPS505:1;
    uint_io32_t		u1IRQPS506:1;
    uint_io32_t		u1IRQPS507:1;
    uint_io32_t		u1IRQPS508:1;
    uint_io32_t		u1IRQPS509:1;
    uint_io32_t		u1IRQPS510:1;
    uint_io32_t		u1IRQPS511:1;
}stc_irc0_irqps15_field_t;

typedef union un_irc0_irqps15{
    uint_io32_t		u32Register;
    stc_irc0_irqps15_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqps15_t;

/* UNLOCK */
#define IRC0_UNLOCK	(IRC0.unUNLOCK.u32Register)  /*@rg@*/
#define IRC0_UNLOCK_UNLOCK	IRC0_UNLOCK  /*@bfrg@*/

typedef union un_irc0_unlock{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_unlock_t;

/* IRQEEVA */
#define IRC0_IRQEEVA	(IRC0.unIRQEEVA.u32Register)  /*@rg@*/
#define IRC0_IRQEEVA_IRQVA	IRC0_IRQEEVA  /*@bfrg@*/

typedef union un_irc0_irqeeva{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_irqeeva_t;

/* EEI */
#define IRC0_EEI	(IRC0.unEEI.u32Register)  /*@rg@*/
#define IRC0_EEI_EENC	(IRC0.unEEI.stcField.u1EENC)  /*@bf@*/
#define IRC0_EEI_EENS	(IRC0.unEEI.stcField.u1EENS)  /*@bf@*/
#define IRC0_EEI_EEIC	(IRC0.unEEI.stcField.u1EEIC)  /*@bf@*/
#define IRC0_EEI_EEIS	(IRC0.unEEI.stcField.u1EEIS)  /*@bf@*/

typedef struct stc_irc0_eei_field{
    uint_io32_t		u1EENC:1;
    uint_io32_t		:7;
    uint_io32_t		u1EENS:1;
    uint_io32_t		:7;
    uint_io32_t		u1EEIC:1;
    uint_io32_t		:7;
    uint_io32_t		u1EEIS:1;
    uint_io32_t		:7;
}stc_irc0_eei_field_t;

typedef union un_irc0_eei{
    uint_io32_t		u32Register;
    stc_irc0_eei_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_eei_t;

/* EAN */
#define IRC0_EAN	(IRC0.unEAN.u32Register)  /*@rg@*/
#define IRC0_EAN_EAN	(IRC0.unEAN.au8Byte[0])  /*@bfbyte@*/

typedef struct stc_irc0_ean_field{
    uint_io32_t		u8EAN:8;
    uint_io32_t		:24;
}stc_irc0_ean_field_t;

typedef union un_irc0_ean{
    uint_io32_t		u32Register;
    stc_irc0_ean_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_ean_t;

/* ET */
#define IRC0_ET	(IRC0.unET.u32Register)  /*@rg@*/
#define IRC0_ET_ET	(IRC0.unET.stcField.u1ET)  /*@bf@*/

typedef struct stc_irc0_et_field{
    uint_io32_t		u1ET:1;
    uint_io32_t		:31;
}stc_irc0_et_field_t;

typedef union un_irc0_et{
    uint_io32_t		u32Register;
    stc_irc0_et_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_et_t;

/* EEB[0/1] */
#define IRC0_EEB0	(IRC0.unEEB0.u32Register)  /*@rg@*/
#define IRC0_EEB0_EEB	(IRC0.unEEB0.stcField.u30EEB)  /*@bf@*/

#define IRC0_EEB1	(IRC0.unEEB1.u32Register)  /*@rg@*/
#define IRC0_EEB1_EEB	(IRC0.unEEB1.stcField.u30EEB)  /*@bf@*/

typedef struct stc_irc0_eebn_field{
    uint_io32_t		:2;
    uint_io32_t		u30EEB:30;
}stc_irc0_eebn_field_t;

typedef union un_irc0_eebn{
    uint_io32_t		u32Register;
    stc_irc0_eebn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_eebn_t;

/* EEB2 */
#define IRC0_EEB2	(IRC0.unEEB2.u32Register)  /*@rg@*/
#define IRC0_EEB2_EEBE	(IRC0.unEEB2.stcField.u7EEBE)  /*@bf@*/
#define IRC0_EEB2_EEBO	(IRC0.unEEB2.stcField.u7EEBO)  /*@bf@*/

typedef struct stc_irc0_eeb2_field{
    uint_io32_t		u7EEBE:7;
    uint_io32_t		:1;
    uint_io32_t		u7EEBO:7;
    uint_io32_t		:17;
}stc_irc0_eeb2_field_t;

typedef union un_irc0_eeb2{
    uint_io32_t		u32Register;
    stc_irc0_eeb2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_eeb2_t;


typedef struct stc_irc0{
    un_irc0_nmivas_t	unNMIVAS;	/* 0x00000000 */
    un_irc0_nmist_t	unNMIST;	/* 0x00000004 */
    un_irc0_irqvas_t	unIRQVAS;	/* 0x00000008 */
    un_irc0_irqst_t	unIRQST;	/* 0x0000000C */
    un_irc0_nmivan_t	unNMIVA0;	/* 0x00000010 */
    un_irc0_nmivan_t	unNMIVA1;	/* 0x00000014 */
    un_irc0_nmivan_t	unNMIVA2;	/* 0x00000018 */
    un_irc0_nmivan_t	unNMIVA3;	/* 0x0000001C */
    un_irc0_nmivan_t	unNMIVA4;	/* 0x00000020 */
    un_irc0_nmivan_t	unNMIVA5;	/* 0x00000024 */
    un_irc0_nmivan_t	unNMIVA6;	/* 0x00000028 */
    un_irc0_nmivan_t	unNMIVA7;	/* 0x0000002C */
    un_irc0_nmivan_t	unNMIVA8;	/* 0x00000030 */
    un_irc0_nmivan_t	unNMIVA9;	/* 0x00000034 */
    un_irc0_nmivan_t	unNMIVA10;	/* 0x00000038 */
    un_irc0_nmivan_t	unNMIVA11;	/* 0x0000003C */
    un_irc0_nmivan_t	unNMIVA12;	/* 0x00000040 */
    un_irc0_nmivan_t	unNMIVA13;	/* 0x00000044 */
    un_irc0_nmivan_t	unNMIVA14;	/* 0x00000048 */
    un_irc0_nmivan_t	unNMIVA15;	/* 0x0000004C */
    un_irc0_nmivan_t	unNMIVA16;	/* 0x00000050 */
    un_irc0_nmivan_t	unNMIVA17;	/* 0x00000054 */
    un_irc0_nmivan_t	unNMIVA18;	/* 0x00000058 */
    un_irc0_nmivan_t	unNMIVA19;	/* 0x0000005C */
    un_irc0_nmivan_t	unNMIVA20;	/* 0x00000060 */
    un_irc0_nmivan_t	unNMIVA21;	/* 0x00000064 */
    un_irc0_nmivan_t	unNMIVA22;	/* 0x00000068 */
    un_irc0_nmivan_t	unNMIVA23;	/* 0x0000006C */
    un_irc0_nmivan_t	unNMIVA24;	/* 0x00000070 */
    un_irc0_nmivan_t	unNMIVA25;	/* 0x00000074 */
    un_irc0_nmivan_t	unNMIVA26;	/* 0x00000078 */
    un_irc0_nmivan_t	unNMIVA27;	/* 0x0000007C */
    un_irc0_nmivan_t	unNMIVA28;	/* 0x00000080 */
    un_irc0_nmivan_t	unNMIVA29;	/* 0x00000084 */
    un_irc0_nmivan_t	unNMIVA30;	/* 0x00000088 */
    un_irc0_nmivan_t	unNMIVA31;	/* 0x0000008C */
    un_irc0_irqvan_t	unIRQVA0;	/* 0x00000090 */
    un_irc0_irqvan_t	unIRQVA1;	/* 0x00000094 */
    un_irc0_irqvan_t	unIRQVA2;	/* 0x00000098 */
    un_irc0_irqvan_t	unIRQVA3;	/* 0x0000009C */
    un_irc0_irqvan_t	unIRQVA4;	/* 0x000000A0 */
    un_irc0_irqvan_t	unIRQVA5;	/* 0x000000A4 */
    un_irc0_irqvan_t	unIRQVA6;	/* 0x000000A8 */
    un_irc0_irqvan_t	unIRQVA7;	/* 0x000000AC */
    un_irc0_irqvan_t	unIRQVA8;	/* 0x000000B0 */
    un_irc0_irqvan_t	unIRQVA9;	/* 0x000000B4 */
    un_irc0_irqvan_t	unIRQVA10;	/* 0x000000B8 */
    un_irc0_irqvan_t	unIRQVA11;	/* 0x000000BC */
    un_irc0_irqvan_t	unIRQVA12;	/* 0x000000C0 */
    un_irc0_irqvan_t	unIRQVA13;	/* 0x000000C4 */
    un_irc0_irqvan_t	unIRQVA14;	/* 0x000000C8 */
    un_irc0_irqvan_t	unIRQVA15;	/* 0x000000CC */
    un_irc0_irqvan_t	unIRQVA16;	/* 0x000000D0 */
    un_irc0_irqvan_t	unIRQVA17;	/* 0x000000D4 */
    un_irc0_irqvan_t	unIRQVA18;	/* 0x000000D8 */
    un_irc0_irqvan_t	unIRQVA19;	/* 0x000000DC */
    un_irc0_irqvan_t	unIRQVA20;	/* 0x000000E0 */
    un_irc0_irqvan_t	unIRQVA21;	/* 0x000000E4 */
    un_irc0_irqvan_t	unIRQVA22;	/* 0x000000E8 */
    un_irc0_irqvan_t	unIRQVA23;	/* 0x000000EC */
    un_irc0_irqvan_t	unIRQVA24;	/* 0x000000F0 */
    un_irc0_irqvan_t	unIRQVA25;	/* 0x000000F4 */
    un_irc0_irqvan_t	unIRQVA26;	/* 0x000000F8 */
    un_irc0_irqvan_t	unIRQVA27;	/* 0x000000FC */
    un_irc0_irqvan_t	unIRQVA28;	/* 0x00000100 */
    un_irc0_irqvan_t	unIRQVA29;	/* 0x00000104 */
    un_irc0_irqvan_t	unIRQVA30;	/* 0x00000108 */
    un_irc0_irqvan_t	unIRQVA31;	/* 0x0000010C */
    un_irc0_irqvan_t	unIRQVA32;	/* 0x00000110 */
    un_irc0_irqvan_t	unIRQVA33;	/* 0x00000114 */
    un_irc0_irqvan_t	unIRQVA34;	/* 0x00000118 */
    un_irc0_irqvan_t	unIRQVA35;	/* 0x0000011C */
    un_irc0_irqvan_t	unIRQVA36;	/* 0x00000120 */
    un_irc0_irqvan_t	unIRQVA37;	/* 0x00000124 */
    un_irc0_irqvan_t	unIRQVA38;	/* 0x00000128 */
    un_irc0_irqvan_t	unIRQVA39;	/* 0x0000012C */
    un_irc0_irqvan_t	unIRQVA40;	/* 0x00000130 */
    un_irc0_irqvan_t	unIRQVA41;	/* 0x00000134 */
    un_irc0_irqvan_t	unIRQVA42;	/* 0x00000138 */
    un_irc0_irqvan_t	unIRQVA43;	/* 0x0000013C */
    un_irc0_irqvan_t	unIRQVA44;	/* 0x00000140 */
    un_irc0_irqvan_t	unIRQVA45;	/* 0x00000144 */
    un_irc0_irqvan_t	unIRQVA46;	/* 0x00000148 */
    un_irc0_irqvan_t	unIRQVA47;	/* 0x0000014C */
    un_irc0_irqvan_t	unIRQVA48;	/* 0x00000150 */
    un_irc0_irqvan_t	unIRQVA49;	/* 0x00000154 */
    un_irc0_irqvan_t	unIRQVA50;	/* 0x00000158 */
    un_irc0_irqvan_t	unIRQVA51;	/* 0x0000015C */
    un_irc0_irqvan_t	unIRQVA52;	/* 0x00000160 */
    un_irc0_irqvan_t	unIRQVA53;	/* 0x00000164 */
    un_irc0_irqvan_t	unIRQVA54;	/* 0x00000168 */
    un_irc0_irqvan_t	unIRQVA55;	/* 0x0000016C */
    un_irc0_irqvan_t	unIRQVA56;	/* 0x00000170 */
    un_irc0_irqvan_t	unIRQVA57;	/* 0x00000174 */
    un_irc0_irqvan_t	unIRQVA58;	/* 0x00000178 */
    un_irc0_irqvan_t	unIRQVA59;	/* 0x0000017C */
    un_irc0_irqvan_t	unIRQVA60;	/* 0x00000180 */
    un_irc0_irqvan_t	unIRQVA61;	/* 0x00000184 */
    un_irc0_irqvan_t	unIRQVA62;	/* 0x00000188 */
    un_irc0_irqvan_t	unIRQVA63;	/* 0x0000018C */
    un_irc0_irqvan_t	unIRQVA64;	/* 0x00000190 */
    un_irc0_irqvan_t	unIRQVA65;	/* 0x00000194 */
    un_irc0_irqvan_t	unIRQVA66;	/* 0x00000198 */
    un_irc0_irqvan_t	unIRQVA67;	/* 0x0000019C */
    un_irc0_irqvan_t	unIRQVA68;	/* 0x000001A0 */
    un_irc0_irqvan_t	unIRQVA69;	/* 0x000001A4 */
    un_irc0_irqvan_t	unIRQVA70;	/* 0x000001A8 */
    un_irc0_irqvan_t	unIRQVA71;	/* 0x000001AC */
    un_irc0_irqvan_t	unIRQVA72;	/* 0x000001B0 */
    un_irc0_irqvan_t	unIRQVA73;	/* 0x000001B4 */
    un_irc0_irqvan_t	unIRQVA74;	/* 0x000001B8 */
    un_irc0_irqvan_t	unIRQVA75;	/* 0x000001BC */
    un_irc0_irqvan_t	unIRQVA76;	/* 0x000001C0 */
    un_irc0_irqvan_t	unIRQVA77;	/* 0x000001C4 */
    un_irc0_irqvan_t	unIRQVA78;	/* 0x000001C8 */
    un_irc0_irqvan_t	unIRQVA79;	/* 0x000001CC */
    un_irc0_irqvan_t	unIRQVA80;	/* 0x000001D0 */
    un_irc0_irqvan_t	unIRQVA81;	/* 0x000001D4 */
    un_irc0_irqvan_t	unIRQVA82;	/* 0x000001D8 */
    un_irc0_irqvan_t	unIRQVA83;	/* 0x000001DC */
    un_irc0_irqvan_t	unIRQVA84;	/* 0x000001E0 */
    un_irc0_irqvan_t	unIRQVA85;	/* 0x000001E4 */
    un_irc0_irqvan_t	unIRQVA86;	/* 0x000001E8 */
    un_irc0_irqvan_t	unIRQVA87;	/* 0x000001EC */
    un_irc0_irqvan_t	unIRQVA88;	/* 0x000001F0 */
    un_irc0_irqvan_t	unIRQVA89;	/* 0x000001F4 */
    un_irc0_irqvan_t	unIRQVA90;	/* 0x000001F8 */
    un_irc0_irqvan_t	unIRQVA91;	/* 0x000001FC */
    un_irc0_irqvan_t	unIRQVA92;	/* 0x00000200 */
    un_irc0_irqvan_t	unIRQVA93;	/* 0x00000204 */
    un_irc0_irqvan_t	unIRQVA94;	/* 0x00000208 */
    un_irc0_irqvan_t	unIRQVA95;	/* 0x0000020C */
    un_irc0_irqvan_t	unIRQVA96;	/* 0x00000210 */
    un_irc0_irqvan_t	unIRQVA97;	/* 0x00000214 */
    un_irc0_irqvan_t	unIRQVA98;	/* 0x00000218 */
    un_irc0_irqvan_t	unIRQVA99;	/* 0x0000021C */
    un_irc0_irqvan_t	unIRQVA100;	/* 0x00000220 */
    un_irc0_irqvan_t	unIRQVA101;	/* 0x00000224 */
    un_irc0_irqvan_t	unIRQVA102;	/* 0x00000228 */
    un_irc0_irqvan_t	unIRQVA103;	/* 0x0000022C */
    un_irc0_irqvan_t	unIRQVA104;	/* 0x00000230 */
    un_irc0_irqvan_t	unIRQVA105;	/* 0x00000234 */
    un_irc0_irqvan_t	unIRQVA106;	/* 0x00000238 */
    un_irc0_irqvan_t	unIRQVA107;	/* 0x0000023C */
    un_irc0_irqvan_t	unIRQVA108;	/* 0x00000240 */
    un_irc0_irqvan_t	unIRQVA109;	/* 0x00000244 */
    un_irc0_irqvan_t	unIRQVA110;	/* 0x00000248 */
    un_irc0_irqvan_t	unIRQVA111;	/* 0x0000024C */
    un_irc0_irqvan_t	unIRQVA112;	/* 0x00000250 */
    un_irc0_irqvan_t	unIRQVA113;	/* 0x00000254 */
    un_irc0_irqvan_t	unIRQVA114;	/* 0x00000258 */
    un_irc0_irqvan_t	unIRQVA115;	/* 0x0000025C */
    un_irc0_irqvan_t	unIRQVA116;	/* 0x00000260 */
    un_irc0_irqvan_t	unIRQVA117;	/* 0x00000264 */
    un_irc0_irqvan_t	unIRQVA118;	/* 0x00000268 */
    un_irc0_irqvan_t	unIRQVA119;	/* 0x0000026C */
    un_irc0_irqvan_t	unIRQVA120;	/* 0x00000270 */
    un_irc0_irqvan_t	unIRQVA121;	/* 0x00000274 */
    un_irc0_irqvan_t	unIRQVA122;	/* 0x00000278 */
    un_irc0_irqvan_t	unIRQVA123;	/* 0x0000027C */
    un_irc0_irqvan_t	unIRQVA124;	/* 0x00000280 */
    un_irc0_irqvan_t	unIRQVA125;	/* 0x00000284 */
    un_irc0_irqvan_t	unIRQVA126;	/* 0x00000288 */
    un_irc0_irqvan_t	unIRQVA127;	/* 0x0000028C */
    un_irc0_irqvan_t	unIRQVA128;	/* 0x00000290 */
    un_irc0_irqvan_t	unIRQVA129;	/* 0x00000294 */
    un_irc0_irqvan_t	unIRQVA130;	/* 0x00000298 */
    un_irc0_irqvan_t	unIRQVA131;	/* 0x0000029C */
    un_irc0_irqvan_t	unIRQVA132;	/* 0x000002A0 */
    un_irc0_irqvan_t	unIRQVA133;	/* 0x000002A4 */
    un_irc0_irqvan_t	unIRQVA134;	/* 0x000002A8 */
    un_irc0_irqvan_t	unIRQVA135;	/* 0x000002AC */
    un_irc0_irqvan_t	unIRQVA136;	/* 0x000002B0 */
    un_irc0_irqvan_t	unIRQVA137;	/* 0x000002B4 */
    un_irc0_irqvan_t	unIRQVA138;	/* 0x000002B8 */
    un_irc0_irqvan_t	unIRQVA139;	/* 0x000002BC */
    un_irc0_irqvan_t	unIRQVA140;	/* 0x000002C0 */
    un_irc0_irqvan_t	unIRQVA141;	/* 0x000002C4 */
    un_irc0_irqvan_t	unIRQVA142;	/* 0x000002C8 */
    un_irc0_irqvan_t	unIRQVA143;	/* 0x000002CC */
    un_irc0_irqvan_t	unIRQVA144;	/* 0x000002D0 */
    un_irc0_irqvan_t	unIRQVA145;	/* 0x000002D4 */
    un_irc0_irqvan_t	unIRQVA146;	/* 0x000002D8 */
    un_irc0_irqvan_t	unIRQVA147;	/* 0x000002DC */
    un_irc0_irqvan_t	unIRQVA148;	/* 0x000002E0 */
    un_irc0_irqvan_t	unIRQVA149;	/* 0x000002E4 */
    un_irc0_irqvan_t	unIRQVA150;	/* 0x000002E8 */
    un_irc0_irqvan_t	unIRQVA151;	/* 0x000002EC */
    un_irc0_irqvan_t	unIRQVA152;	/* 0x000002F0 */
    un_irc0_irqvan_t	unIRQVA153;	/* 0x000002F4 */
    un_irc0_irqvan_t	unIRQVA154;	/* 0x000002F8 */
    un_irc0_irqvan_t	unIRQVA155;	/* 0x000002FC */
    un_irc0_irqvan_t	unIRQVA156;	/* 0x00000300 */
    un_irc0_irqvan_t	unIRQVA157;	/* 0x00000304 */
    un_irc0_irqvan_t	unIRQVA158;	/* 0x00000308 */
    un_irc0_irqvan_t	unIRQVA159;	/* 0x0000030C */
    un_irc0_irqvan_t	unIRQVA160;	/* 0x00000310 */
    un_irc0_irqvan_t	unIRQVA161;	/* 0x00000314 */
    un_irc0_irqvan_t	unIRQVA162;	/* 0x00000318 */
    un_irc0_irqvan_t	unIRQVA163;	/* 0x0000031C */
    un_irc0_irqvan_t	unIRQVA164;	/* 0x00000320 */
    un_irc0_irqvan_t	unIRQVA165;	/* 0x00000324 */
    un_irc0_irqvan_t	unIRQVA166;	/* 0x00000328 */
    un_irc0_irqvan_t	unIRQVA167;	/* 0x0000032C */
    un_irc0_irqvan_t	unIRQVA168;	/* 0x00000330 */
    un_irc0_irqvan_t	unIRQVA169;	/* 0x00000334 */
    un_irc0_irqvan_t	unIRQVA170;	/* 0x00000338 */
    un_irc0_irqvan_t	unIRQVA171;	/* 0x0000033C */
    un_irc0_irqvan_t	unIRQVA172;	/* 0x00000340 */
    un_irc0_irqvan_t	unIRQVA173;	/* 0x00000344 */
    un_irc0_irqvan_t	unIRQVA174;	/* 0x00000348 */
    un_irc0_irqvan_t	unIRQVA175;	/* 0x0000034C */
    un_irc0_irqvan_t	unIRQVA176;	/* 0x00000350 */
    un_irc0_irqvan_t	unIRQVA177;	/* 0x00000354 */
    un_irc0_irqvan_t	unIRQVA178;	/* 0x00000358 */
    un_irc0_irqvan_t	unIRQVA179;	/* 0x0000035C */
    un_irc0_irqvan_t	unIRQVA180;	/* 0x00000360 */
    un_irc0_irqvan_t	unIRQVA181;	/* 0x00000364 */
    un_irc0_irqvan_t	unIRQVA182;	/* 0x00000368 */
    un_irc0_irqvan_t	unIRQVA183;	/* 0x0000036C */
    un_irc0_irqvan_t	unIRQVA184;	/* 0x00000370 */
    un_irc0_irqvan_t	unIRQVA185;	/* 0x00000374 */
    un_irc0_irqvan_t	unIRQVA186;	/* 0x00000378 */
    un_irc0_irqvan_t	unIRQVA187;	/* 0x0000037C */
    un_irc0_irqvan_t	unIRQVA188;	/* 0x00000380 */
    un_irc0_irqvan_t	unIRQVA189;	/* 0x00000384 */
    un_irc0_irqvan_t	unIRQVA190;	/* 0x00000388 */
    un_irc0_irqvan_t	unIRQVA191;	/* 0x0000038C */
    un_irc0_irqvan_t	unIRQVA192;	/* 0x00000390 */
    un_irc0_irqvan_t	unIRQVA193;	/* 0x00000394 */
    un_irc0_irqvan_t	unIRQVA194;	/* 0x00000398 */
    un_irc0_irqvan_t	unIRQVA195;	/* 0x0000039C */
    un_irc0_irqvan_t	unIRQVA196;	/* 0x000003A0 */
    un_irc0_irqvan_t	unIRQVA197;	/* 0x000003A4 */
    un_irc0_irqvan_t	unIRQVA198;	/* 0x000003A8 */
    un_irc0_irqvan_t	unIRQVA199;	/* 0x000003AC */
    un_irc0_irqvan_t	unIRQVA200;	/* 0x000003B0 */
    un_irc0_irqvan_t	unIRQVA201;	/* 0x000003B4 */
    un_irc0_irqvan_t	unIRQVA202;	/* 0x000003B8 */
    un_irc0_irqvan_t	unIRQVA203;	/* 0x000003BC */
    un_irc0_irqvan_t	unIRQVA204;	/* 0x000003C0 */
    un_irc0_irqvan_t	unIRQVA205;	/* 0x000003C4 */
    un_irc0_irqvan_t	unIRQVA206;	/* 0x000003C8 */
    un_irc0_irqvan_t	unIRQVA207;	/* 0x000003CC */
    un_irc0_irqvan_t	unIRQVA208;	/* 0x000003D0 */
    un_irc0_irqvan_t	unIRQVA209;	/* 0x000003D4 */
    un_irc0_irqvan_t	unIRQVA210;	/* 0x000003D8 */
    un_irc0_irqvan_t	unIRQVA211;	/* 0x000003DC */
    un_irc0_irqvan_t	unIRQVA212;	/* 0x000003E0 */
    un_irc0_irqvan_t	unIRQVA213;	/* 0x000003E4 */
    un_irc0_irqvan_t	unIRQVA214;	/* 0x000003E8 */
    un_irc0_irqvan_t	unIRQVA215;	/* 0x000003EC */
    un_irc0_irqvan_t	unIRQVA216;	/* 0x000003F0 */
    un_irc0_irqvan_t	unIRQVA217;	/* 0x000003F4 */
    un_irc0_irqvan_t	unIRQVA218;	/* 0x000003F8 */
    un_irc0_irqvan_t	unIRQVA219;	/* 0x000003FC */
    un_irc0_irqvan_t	unIRQVA220;	/* 0x00000400 */
    un_irc0_irqvan_t	unIRQVA221;	/* 0x00000404 */
    un_irc0_irqvan_t	unIRQVA222;	/* 0x00000408 */
    un_irc0_irqvan_t	unIRQVA223;	/* 0x0000040C */
    un_irc0_irqvan_t	unIRQVA224;	/* 0x00000410 */
    un_irc0_irqvan_t	unIRQVA225;	/* 0x00000414 */
    un_irc0_irqvan_t	unIRQVA226;	/* 0x00000418 */
    un_irc0_irqvan_t	unIRQVA227;	/* 0x0000041C */
    un_irc0_irqvan_t	unIRQVA228;	/* 0x00000420 */
    un_irc0_irqvan_t	unIRQVA229;	/* 0x00000424 */
    un_irc0_irqvan_t	unIRQVA230;	/* 0x00000428 */
    un_irc0_irqvan_t	unIRQVA231;	/* 0x0000042C */
    un_irc0_irqvan_t	unIRQVA232;	/* 0x00000430 */
    un_irc0_irqvan_t	unIRQVA233;	/* 0x00000434 */
    un_irc0_irqvan_t	unIRQVA234;	/* 0x00000438 */
    un_irc0_irqvan_t	unIRQVA235;	/* 0x0000043C */
    un_irc0_irqvan_t	unIRQVA236;	/* 0x00000440 */
    un_irc0_irqvan_t	unIRQVA237;	/* 0x00000444 */
    un_irc0_irqvan_t	unIRQVA238;	/* 0x00000448 */
    un_irc0_irqvan_t	unIRQVA239;	/* 0x0000044C */
    un_irc0_irqvan_t	unIRQVA240;	/* 0x00000450 */
    un_irc0_irqvan_t	unIRQVA241;	/* 0x00000454 */
    un_irc0_irqvan_t	unIRQVA242;	/* 0x00000458 */
    un_irc0_irqvan_t	unIRQVA243;	/* 0x0000045C */
    un_irc0_irqvan_t	unIRQVA244;	/* 0x00000460 */
    un_irc0_irqvan_t	unIRQVA245;	/* 0x00000464 */
    un_irc0_irqvan_t	unIRQVA246;	/* 0x00000468 */
    un_irc0_irqvan_t	unIRQVA247;	/* 0x0000046C */
    un_irc0_irqvan_t	unIRQVA248;	/* 0x00000470 */
    un_irc0_irqvan_t	unIRQVA249;	/* 0x00000474 */
    un_irc0_irqvan_t	unIRQVA250;	/* 0x00000478 */
    un_irc0_irqvan_t	unIRQVA251;	/* 0x0000047C */
    un_irc0_irqvan_t	unIRQVA252;	/* 0x00000480 */
    un_irc0_irqvan_t	unIRQVA253;	/* 0x00000484 */
    un_irc0_irqvan_t	unIRQVA254;	/* 0x00000488 */
    un_irc0_irqvan_t	unIRQVA255;	/* 0x0000048C */
    un_irc0_irqvan_t	unIRQVA256;	/* 0x00000490 */
    un_irc0_irqvan_t	unIRQVA257;	/* 0x00000494 */
    un_irc0_irqvan_t	unIRQVA258;	/* 0x00000498 */
    un_irc0_irqvan_t	unIRQVA259;	/* 0x0000049C */
    un_irc0_irqvan_t	unIRQVA260;	/* 0x000004A0 */
    un_irc0_irqvan_t	unIRQVA261;	/* 0x000004A4 */
    un_irc0_irqvan_t	unIRQVA262;	/* 0x000004A8 */
    un_irc0_irqvan_t	unIRQVA263;	/* 0x000004AC */
    un_irc0_irqvan_t	unIRQVA264;	/* 0x000004B0 */
    un_irc0_irqvan_t	unIRQVA265;	/* 0x000004B4 */
    un_irc0_irqvan_t	unIRQVA266;	/* 0x000004B8 */
    un_irc0_irqvan_t	unIRQVA267;	/* 0x000004BC */
    un_irc0_irqvan_t	unIRQVA268;	/* 0x000004C0 */
    un_irc0_irqvan_t	unIRQVA269;	/* 0x000004C4 */
    un_irc0_irqvan_t	unIRQVA270;	/* 0x000004C8 */
    un_irc0_irqvan_t	unIRQVA271;	/* 0x000004CC */
    un_irc0_irqvan_t	unIRQVA272;	/* 0x000004D0 */
    un_irc0_irqvan_t	unIRQVA273;	/* 0x000004D4 */
    un_irc0_irqvan_t	unIRQVA274;	/* 0x000004D8 */
    un_irc0_irqvan_t	unIRQVA275;	/* 0x000004DC */
    un_irc0_irqvan_t	unIRQVA276;	/* 0x000004E0 */
    un_irc0_irqvan_t	unIRQVA277;	/* 0x000004E4 */
    un_irc0_irqvan_t	unIRQVA278;	/* 0x000004E8 */
    un_irc0_irqvan_t	unIRQVA279;	/* 0x000004EC */
    un_irc0_irqvan_t	unIRQVA280;	/* 0x000004F0 */
    un_irc0_irqvan_t	unIRQVA281;	/* 0x000004F4 */
    un_irc0_irqvan_t	unIRQVA282;	/* 0x000004F8 */
    un_irc0_irqvan_t	unIRQVA283;	/* 0x000004FC */
    un_irc0_irqvan_t	unIRQVA284;	/* 0x00000500 */
    un_irc0_irqvan_t	unIRQVA285;	/* 0x00000504 */
    un_irc0_irqvan_t	unIRQVA286;	/* 0x00000508 */
    un_irc0_irqvan_t	unIRQVA287;	/* 0x0000050C */
    un_irc0_irqvan_t	unIRQVA288;	/* 0x00000510 */
    un_irc0_irqvan_t	unIRQVA289;	/* 0x00000514 */
    un_irc0_irqvan_t	unIRQVA290;	/* 0x00000518 */
    un_irc0_irqvan_t	unIRQVA291;	/* 0x0000051C */
    un_irc0_irqvan_t	unIRQVA292;	/* 0x00000520 */
    un_irc0_irqvan_t	unIRQVA293;	/* 0x00000524 */
    un_irc0_irqvan_t	unIRQVA294;	/* 0x00000528 */
    un_irc0_irqvan_t	unIRQVA295;	/* 0x0000052C */
    un_irc0_irqvan_t	unIRQVA296;	/* 0x00000530 */
    un_irc0_irqvan_t	unIRQVA297;	/* 0x00000534 */
    un_irc0_irqvan_t	unIRQVA298;	/* 0x00000538 */
    un_irc0_irqvan_t	unIRQVA299;	/* 0x0000053C */
    un_irc0_irqvan_t	unIRQVA300;	/* 0x00000540 */
    un_irc0_irqvan_t	unIRQVA301;	/* 0x00000544 */
    un_irc0_irqvan_t	unIRQVA302;	/* 0x00000548 */
    un_irc0_irqvan_t	unIRQVA303;	/* 0x0000054C */
    un_irc0_irqvan_t	unIRQVA304;	/* 0x00000550 */
    un_irc0_irqvan_t	unIRQVA305;	/* 0x00000554 */
    un_irc0_irqvan_t	unIRQVA306;	/* 0x00000558 */
    un_irc0_irqvan_t	unIRQVA307;	/* 0x0000055C */
    un_irc0_irqvan_t	unIRQVA308;	/* 0x00000560 */
    un_irc0_irqvan_t	unIRQVA309;	/* 0x00000564 */
    un_irc0_irqvan_t	unIRQVA310;	/* 0x00000568 */
    un_irc0_irqvan_t	unIRQVA311;	/* 0x0000056C */
    un_irc0_irqvan_t	unIRQVA312;	/* 0x00000570 */
    un_irc0_irqvan_t	unIRQVA313;	/* 0x00000574 */
    un_irc0_irqvan_t	unIRQVA314;	/* 0x00000578 */
    un_irc0_irqvan_t	unIRQVA315;	/* 0x0000057C */
    un_irc0_irqvan_t	unIRQVA316;	/* 0x00000580 */
    un_irc0_irqvan_t	unIRQVA317;	/* 0x00000584 */
    un_irc0_irqvan_t	unIRQVA318;	/* 0x00000588 */
    un_irc0_irqvan_t	unIRQVA319;	/* 0x0000058C */
    un_irc0_irqvan_t	unIRQVA320;	/* 0x00000590 */
    un_irc0_irqvan_t	unIRQVA321;	/* 0x00000594 */
    un_irc0_irqvan_t	unIRQVA322;	/* 0x00000598 */
    un_irc0_irqvan_t	unIRQVA323;	/* 0x0000059C */
    un_irc0_irqvan_t	unIRQVA324;	/* 0x000005A0 */
    un_irc0_irqvan_t	unIRQVA325;	/* 0x000005A4 */
    un_irc0_irqvan_t	unIRQVA326;	/* 0x000005A8 */
    un_irc0_irqvan_t	unIRQVA327;	/* 0x000005AC */
    un_irc0_irqvan_t	unIRQVA328;	/* 0x000005B0 */
    un_irc0_irqvan_t	unIRQVA329;	/* 0x000005B4 */
    un_irc0_irqvan_t	unIRQVA330;	/* 0x000005B8 */
    un_irc0_irqvan_t	unIRQVA331;	/* 0x000005BC */
    un_irc0_irqvan_t	unIRQVA332;	/* 0x000005C0 */
    un_irc0_irqvan_t	unIRQVA333;	/* 0x000005C4 */
    un_irc0_irqvan_t	unIRQVA334;	/* 0x000005C8 */
    un_irc0_irqvan_t	unIRQVA335;	/* 0x000005CC */
    un_irc0_irqvan_t	unIRQVA336;	/* 0x000005D0 */
    un_irc0_irqvan_t	unIRQVA337;	/* 0x000005D4 */
    un_irc0_irqvan_t	unIRQVA338;	/* 0x000005D8 */
    un_irc0_irqvan_t	unIRQVA339;	/* 0x000005DC */
    un_irc0_irqvan_t	unIRQVA340;	/* 0x000005E0 */
    un_irc0_irqvan_t	unIRQVA341;	/* 0x000005E4 */
    un_irc0_irqvan_t	unIRQVA342;	/* 0x000005E8 */
    un_irc0_irqvan_t	unIRQVA343;	/* 0x000005EC */
    un_irc0_irqvan_t	unIRQVA344;	/* 0x000005F0 */
    un_irc0_irqvan_t	unIRQVA345;	/* 0x000005F4 */
    un_irc0_irqvan_t	unIRQVA346;	/* 0x000005F8 */
    un_irc0_irqvan_t	unIRQVA347;	/* 0x000005FC */
    un_irc0_irqvan_t	unIRQVA348;	/* 0x00000600 */
    un_irc0_irqvan_t	unIRQVA349;	/* 0x00000604 */
    un_irc0_irqvan_t	unIRQVA350;	/* 0x00000608 */
    un_irc0_irqvan_t	unIRQVA351;	/* 0x0000060C */
    un_irc0_irqvan_t	unIRQVA352;	/* 0x00000610 */
    un_irc0_irqvan_t	unIRQVA353;	/* 0x00000614 */
    un_irc0_irqvan_t	unIRQVA354;	/* 0x00000618 */
    un_irc0_irqvan_t	unIRQVA355;	/* 0x0000061C */
    un_irc0_irqvan_t	unIRQVA356;	/* 0x00000620 */
    un_irc0_irqvan_t	unIRQVA357;	/* 0x00000624 */
    un_irc0_irqvan_t	unIRQVA358;	/* 0x00000628 */
    un_irc0_irqvan_t	unIRQVA359;	/* 0x0000062C */
    un_irc0_irqvan_t	unIRQVA360;	/* 0x00000630 */
    un_irc0_irqvan_t	unIRQVA361;	/* 0x00000634 */
    un_irc0_irqvan_t	unIRQVA362;	/* 0x00000638 */
    un_irc0_irqvan_t	unIRQVA363;	/* 0x0000063C */
    un_irc0_irqvan_t	unIRQVA364;	/* 0x00000640 */
    un_irc0_irqvan_t	unIRQVA365;	/* 0x00000644 */
    un_irc0_irqvan_t	unIRQVA366;	/* 0x00000648 */
    un_irc0_irqvan_t	unIRQVA367;	/* 0x0000064C */
    un_irc0_irqvan_t	unIRQVA368;	/* 0x00000650 */
    un_irc0_irqvan_t	unIRQVA369;	/* 0x00000654 */
    un_irc0_irqvan_t	unIRQVA370;	/* 0x00000658 */
    un_irc0_irqvan_t	unIRQVA371;	/* 0x0000065C */
    un_irc0_irqvan_t	unIRQVA372;	/* 0x00000660 */
    un_irc0_irqvan_t	unIRQVA373;	/* 0x00000664 */
    un_irc0_irqvan_t	unIRQVA374;	/* 0x00000668 */
    un_irc0_irqvan_t	unIRQVA375;	/* 0x0000066C */
    un_irc0_irqvan_t	unIRQVA376;	/* 0x00000670 */
    un_irc0_irqvan_t	unIRQVA377;	/* 0x00000674 */
    un_irc0_irqvan_t	unIRQVA378;	/* 0x00000678 */
    un_irc0_irqvan_t	unIRQVA379;	/* 0x0000067C */
    un_irc0_irqvan_t	unIRQVA380;	/* 0x00000680 */
    un_irc0_irqvan_t	unIRQVA381;	/* 0x00000684 */
    un_irc0_irqvan_t	unIRQVA382;	/* 0x00000688 */
    un_irc0_irqvan_t	unIRQVA383;	/* 0x0000068C */
    un_irc0_irqvan_t	unIRQVA384;	/* 0x00000690 */
    un_irc0_irqvan_t	unIRQVA385;	/* 0x00000694 */
    un_irc0_irqvan_t	unIRQVA386;	/* 0x00000698 */
    un_irc0_irqvan_t	unIRQVA387;	/* 0x0000069C */
    un_irc0_irqvan_t	unIRQVA388;	/* 0x000006A0 */
    un_irc0_irqvan_t	unIRQVA389;	/* 0x000006A4 */
    un_irc0_irqvan_t	unIRQVA390;	/* 0x000006A8 */
    un_irc0_irqvan_t	unIRQVA391;	/* 0x000006AC */
    un_irc0_irqvan_t	unIRQVA392;	/* 0x000006B0 */
    un_irc0_irqvan_t	unIRQVA393;	/* 0x000006B4 */
    un_irc0_irqvan_t	unIRQVA394;	/* 0x000006B8 */
    un_irc0_irqvan_t	unIRQVA395;	/* 0x000006BC */
    un_irc0_irqvan_t	unIRQVA396;	/* 0x000006C0 */
    un_irc0_irqvan_t	unIRQVA397;	/* 0x000006C4 */
    un_irc0_irqvan_t	unIRQVA398;	/* 0x000006C8 */
    un_irc0_irqvan_t	unIRQVA399;	/* 0x000006CC */
    un_irc0_irqvan_t	unIRQVA400;	/* 0x000006D0 */
    un_irc0_irqvan_t	unIRQVA401;	/* 0x000006D4 */
    un_irc0_irqvan_t	unIRQVA402;	/* 0x000006D8 */
    un_irc0_irqvan_t	unIRQVA403;	/* 0x000006DC */
    un_irc0_irqvan_t	unIRQVA404;	/* 0x000006E0 */
    un_irc0_irqvan_t	unIRQVA405;	/* 0x000006E4 */
    un_irc0_irqvan_t	unIRQVA406;	/* 0x000006E8 */
    un_irc0_irqvan_t	unIRQVA407;	/* 0x000006EC */
    un_irc0_irqvan_t	unIRQVA408;	/* 0x000006F0 */
    un_irc0_irqvan_t	unIRQVA409;	/* 0x000006F4 */
    un_irc0_irqvan_t	unIRQVA410;	/* 0x000006F8 */
    un_irc0_irqvan_t	unIRQVA411;	/* 0x000006FC */
    un_irc0_irqvan_t	unIRQVA412;	/* 0x00000700 */
    un_irc0_irqvan_t	unIRQVA413;	/* 0x00000704 */
    un_irc0_irqvan_t	unIRQVA414;	/* 0x00000708 */
    un_irc0_irqvan_t	unIRQVA415;	/* 0x0000070C */
    un_irc0_irqvan_t	unIRQVA416;	/* 0x00000710 */
    un_irc0_irqvan_t	unIRQVA417;	/* 0x00000714 */
    un_irc0_irqvan_t	unIRQVA418;	/* 0x00000718 */
    un_irc0_irqvan_t	unIRQVA419;	/* 0x0000071C */
    un_irc0_irqvan_t	unIRQVA420;	/* 0x00000720 */
    un_irc0_irqvan_t	unIRQVA421;	/* 0x00000724 */
    un_irc0_irqvan_t	unIRQVA422;	/* 0x00000728 */
    un_irc0_irqvan_t	unIRQVA423;	/* 0x0000072C */
    un_irc0_irqvan_t	unIRQVA424;	/* 0x00000730 */
    un_irc0_irqvan_t	unIRQVA425;	/* 0x00000734 */
    un_irc0_irqvan_t	unIRQVA426;	/* 0x00000738 */
    un_irc0_irqvan_t	unIRQVA427;	/* 0x0000073C */
    un_irc0_irqvan_t	unIRQVA428;	/* 0x00000740 */
    un_irc0_irqvan_t	unIRQVA429;	/* 0x00000744 */
    un_irc0_irqvan_t	unIRQVA430;	/* 0x00000748 */
    un_irc0_irqvan_t	unIRQVA431;	/* 0x0000074C */
    un_irc0_irqvan_t	unIRQVA432;	/* 0x00000750 */
    un_irc0_irqvan_t	unIRQVA433;	/* 0x00000754 */
    un_irc0_irqvan_t	unIRQVA434;	/* 0x00000758 */
    un_irc0_irqvan_t	unIRQVA435;	/* 0x0000075C */
    un_irc0_irqvan_t	unIRQVA436;	/* 0x00000760 */
    un_irc0_irqvan_t	unIRQVA437;	/* 0x00000764 */
    un_irc0_irqvan_t	unIRQVA438;	/* 0x00000768 */
    un_irc0_irqvan_t	unIRQVA439;	/* 0x0000076C */
    un_irc0_irqvan_t	unIRQVA440;	/* 0x00000770 */
    un_irc0_irqvan_t	unIRQVA441;	/* 0x00000774 */
    un_irc0_irqvan_t	unIRQVA442;	/* 0x00000778 */
    un_irc0_irqvan_t	unIRQVA443;	/* 0x0000077C */
    un_irc0_irqvan_t	unIRQVA444;	/* 0x00000780 */
    un_irc0_irqvan_t	unIRQVA445;	/* 0x00000784 */
    un_irc0_irqvan_t	unIRQVA446;	/* 0x00000788 */
    un_irc0_irqvan_t	unIRQVA447;	/* 0x0000078C */
    un_irc0_irqvan_t	unIRQVA448;	/* 0x00000790 */
    un_irc0_irqvan_t	unIRQVA449;	/* 0x00000794 */
    un_irc0_irqvan_t	unIRQVA450;	/* 0x00000798 */
    un_irc0_irqvan_t	unIRQVA451;	/* 0x0000079C */
    un_irc0_irqvan_t	unIRQVA452;	/* 0x000007A0 */
    un_irc0_irqvan_t	unIRQVA453;	/* 0x000007A4 */
    un_irc0_irqvan_t	unIRQVA454;	/* 0x000007A8 */
    un_irc0_irqvan_t	unIRQVA455;	/* 0x000007AC */
    un_irc0_irqvan_t	unIRQVA456;	/* 0x000007B0 */
    un_irc0_irqvan_t	unIRQVA457;	/* 0x000007B4 */
    un_irc0_irqvan_t	unIRQVA458;	/* 0x000007B8 */
    un_irc0_irqvan_t	unIRQVA459;	/* 0x000007BC */
    un_irc0_irqvan_t	unIRQVA460;	/* 0x000007C0 */
    un_irc0_irqvan_t	unIRQVA461;	/* 0x000007C4 */
    un_irc0_irqvan_t	unIRQVA462;	/* 0x000007C8 */
    un_irc0_irqvan_t	unIRQVA463;	/* 0x000007CC */
    un_irc0_irqvan_t	unIRQVA464;	/* 0x000007D0 */
    un_irc0_irqvan_t	unIRQVA465;	/* 0x000007D4 */
    un_irc0_irqvan_t	unIRQVA466;	/* 0x000007D8 */
    un_irc0_irqvan_t	unIRQVA467;	/* 0x000007DC */
    un_irc0_irqvan_t	unIRQVA468;	/* 0x000007E0 */
    un_irc0_irqvan_t	unIRQVA469;	/* 0x000007E4 */
    un_irc0_irqvan_t	unIRQVA470;	/* 0x000007E8 */
    un_irc0_irqvan_t	unIRQVA471;	/* 0x000007EC */
    un_irc0_irqvan_t	unIRQVA472;	/* 0x000007F0 */
    un_irc0_irqvan_t	unIRQVA473;	/* 0x000007F4 */
    un_irc0_irqvan_t	unIRQVA474;	/* 0x000007F8 */
    un_irc0_irqvan_t	unIRQVA475;	/* 0x000007FC */
    un_irc0_irqvan_t	unIRQVA476;	/* 0x00000800 */
    un_irc0_irqvan_t	unIRQVA477;	/* 0x00000804 */
    un_irc0_irqvan_t	unIRQVA478;	/* 0x00000808 */
    un_irc0_irqvan_t	unIRQVA479;	/* 0x0000080C */
    un_irc0_irqvan_t	unIRQVA480;	/* 0x00000810 */
    un_irc0_irqvan_t	unIRQVA481;	/* 0x00000814 */
    un_irc0_irqvan_t	unIRQVA482;	/* 0x00000818 */
    un_irc0_irqvan_t	unIRQVA483;	/* 0x0000081C */
    un_irc0_irqvan_t	unIRQVA484;	/* 0x00000820 */
    un_irc0_irqvan_t	unIRQVA485;	/* 0x00000824 */
    un_irc0_irqvan_t	unIRQVA486;	/* 0x00000828 */
    un_irc0_irqvan_t	unIRQVA487;	/* 0x0000082C */
    un_irc0_irqvan_t	unIRQVA488;	/* 0x00000830 */
    un_irc0_irqvan_t	unIRQVA489;	/* 0x00000834 */
    un_irc0_irqvan_t	unIRQVA490;	/* 0x00000838 */
    un_irc0_irqvan_t	unIRQVA491;	/* 0x0000083C */
    un_irc0_irqvan_t	unIRQVA492;	/* 0x00000840 */
    un_irc0_irqvan_t	unIRQVA493;	/* 0x00000844 */
    un_irc0_irqvan_t	unIRQVA494;	/* 0x00000848 */
    un_irc0_irqvan_t	unIRQVA495;	/* 0x0000084C */
    un_irc0_irqvan_t	unIRQVA496;	/* 0x00000850 */
    un_irc0_irqvan_t	unIRQVA497;	/* 0x00000854 */
    un_irc0_irqvan_t	unIRQVA498;	/* 0x00000858 */
    un_irc0_irqvan_t	unIRQVA499;	/* 0x0000085C */
    un_irc0_irqvan_t	unIRQVA500;	/* 0x00000860 */
    un_irc0_irqvan_t	unIRQVA501;	/* 0x00000864 */
    un_irc0_irqvan_t	unIRQVA502;	/* 0x00000868 */
    un_irc0_irqvan_t	unIRQVA503;	/* 0x0000086C */
    un_irc0_irqvan_t	unIRQVA504;	/* 0x00000870 */
    un_irc0_irqvan_t	unIRQVA505;	/* 0x00000874 */
    un_irc0_irqvan_t	unIRQVA506;	/* 0x00000878 */
    un_irc0_irqvan_t	unIRQVA507;	/* 0x0000087C */
    un_irc0_irqvan_t	unIRQVA508;	/* 0x00000880 */
    un_irc0_irqvan_t	unIRQVA509;	/* 0x00000884 */
    un_irc0_irqvan_t	unIRQVA510;	/* 0x00000888 */
    un_irc0_irqvan_t	unIRQVA511;	/* 0x0000088C */
    un_irc0_nmipl0_t	unNMIPL0;	/* 0x00000890 */
    un_irc0_nmipl1_t	unNMIPL1;	/* 0x00000894 */
    un_irc0_nmipl2_t	unNMIPL2;	/* 0x00000898 */
    un_irc0_nmipl3_t	unNMIPL3;	/* 0x0000089C */
    un_irc0_nmipl4_t	unNMIPL4;	/* 0x000008A0 */
    un_irc0_nmipl5_t	unNMIPL5;	/* 0x000008A4 */
    un_irc0_nmipl6_t	unNMIPL6;	/* 0x000008A8 */
    un_irc0_nmipl7_t	unNMIPL7;	/* 0x000008AC */
    un_irc0_irqpl0_t	unIRQPL0;	/* 0x000008B0 */
    un_irc0_irqpl1_t	unIRQPL1;	/* 0x000008B4 */
    un_irc0_irqpl2_t	unIRQPL2;	/* 0x000008B8 */
    un_irc0_irqpl3_t	unIRQPL3;	/* 0x000008BC */
    un_irc0_irqpl4_t	unIRQPL4;	/* 0x000008C0 */
    un_irc0_irqpl5_t	unIRQPL5;	/* 0x000008C4 */
    un_irc0_irqpl6_t	unIRQPL6;	/* 0x000008C8 */
    un_irc0_irqpl7_t	unIRQPL7;	/* 0x000008CC */
    un_irc0_irqpl8_t	unIRQPL8;	/* 0x000008D0 */
    un_irc0_irqpl9_t	unIRQPL9;	/* 0x000008D4 */
    un_irc0_irqpl10_t	unIRQPL10;	/* 0x000008D8 */
    un_irc0_irqpl11_t	unIRQPL11;	/* 0x000008DC */
    un_irc0_irqpl12_t	unIRQPL12;	/* 0x000008E0 */
    un_irc0_irqpl13_t	unIRQPL13;	/* 0x000008E4 */
    un_irc0_irqpl14_t	unIRQPL14;	/* 0x000008E8 */
    un_irc0_irqpl15_t	unIRQPL15;	/* 0x000008EC */
    un_irc0_irqpl16_t	unIRQPL16;	/* 0x000008F0 */
    un_irc0_irqpl17_t	unIRQPL17;	/* 0x000008F4 */
    un_irc0_irqpl18_t	unIRQPL18;	/* 0x000008F8 */
    un_irc0_irqpl19_t	unIRQPL19;	/* 0x000008FC */
    un_irc0_irqpl20_t	unIRQPL20;	/* 0x00000900 */
    un_irc0_irqpl21_t	unIRQPL21;	/* 0x00000904 */
    un_irc0_irqpl22_t	unIRQPL22;	/* 0x00000908 */
    un_irc0_irqpl23_t	unIRQPL23;	/* 0x0000090C */
    un_irc0_irqpl24_t	unIRQPL24;	/* 0x00000910 */
    un_irc0_irqpl25_t	unIRQPL25;	/* 0x00000914 */
    un_irc0_irqpl26_t	unIRQPL26;	/* 0x00000918 */
    un_irc0_irqpl27_t	unIRQPL27;	/* 0x0000091C */
    un_irc0_irqpl28_t	unIRQPL28;	/* 0x00000920 */
    un_irc0_irqpl29_t	unIRQPL29;	/* 0x00000924 */
    un_irc0_irqpl30_t	unIRQPL30;	/* 0x00000928 */
    un_irc0_irqpl31_t	unIRQPL31;	/* 0x0000092C */
    un_irc0_irqpl32_t	unIRQPL32;	/* 0x00000930 */
    un_irc0_irqpl33_t	unIRQPL33;	/* 0x00000934 */
    un_irc0_irqpl34_t	unIRQPL34;	/* 0x00000938 */
    un_irc0_irqpl35_t	unIRQPL35;	/* 0x0000093C */
    un_irc0_irqpl36_t	unIRQPL36;	/* 0x00000940 */
    un_irc0_irqpl37_t	unIRQPL37;	/* 0x00000944 */
    un_irc0_irqpl38_t	unIRQPL38;	/* 0x00000948 */
    un_irc0_irqpl39_t	unIRQPL39;	/* 0x0000094C */
    un_irc0_irqpl40_t	unIRQPL40;	/* 0x00000950 */
    un_irc0_irqpl41_t	unIRQPL41;	/* 0x00000954 */
    un_irc0_irqpl42_t	unIRQPL42;	/* 0x00000958 */
    un_irc0_irqpl43_t	unIRQPL43;	/* 0x0000095C */
    un_irc0_irqpl44_t	unIRQPL44;	/* 0x00000960 */
    un_irc0_irqpl45_t	unIRQPL45;	/* 0x00000964 */
    un_irc0_irqpl46_t	unIRQPL46;	/* 0x00000968 */
    un_irc0_irqpl47_t	unIRQPL47;	/* 0x0000096C */
    un_irc0_irqpl48_t	unIRQPL48;	/* 0x00000970 */
    un_irc0_irqpl49_t	unIRQPL49;	/* 0x00000974 */
    un_irc0_irqpl50_t	unIRQPL50;	/* 0x00000978 */
    un_irc0_irqpl51_t	unIRQPL51;	/* 0x0000097C */
    un_irc0_irqpl52_t	unIRQPL52;	/* 0x00000980 */
    un_irc0_irqpl53_t	unIRQPL53;	/* 0x00000984 */
    un_irc0_irqpl54_t	unIRQPL54;	/* 0x00000988 */
    un_irc0_irqpl55_t	unIRQPL55;	/* 0x0000098C */
    un_irc0_irqpl56_t	unIRQPL56;	/* 0x00000990 */
    un_irc0_irqpl57_t	unIRQPL57;	/* 0x00000994 */
    un_irc0_irqpl58_t	unIRQPL58;	/* 0x00000998 */
    un_irc0_irqpl59_t	unIRQPL59;	/* 0x0000099C */
    un_irc0_irqpl60_t	unIRQPL60;	/* 0x000009A0 */
    un_irc0_irqpl61_t	unIRQPL61;	/* 0x000009A4 */
    un_irc0_irqpl62_t	unIRQPL62;	/* 0x000009A8 */
    un_irc0_irqpl63_t	unIRQPL63;	/* 0x000009AC */
    un_irc0_irqpl64_t	unIRQPL64;	/* 0x000009B0 */
    un_irc0_irqpl65_t	unIRQPL65;	/* 0x000009B4 */
    un_irc0_irqpl66_t	unIRQPL66;	/* 0x000009B8 */
    un_irc0_irqpl67_t	unIRQPL67;	/* 0x000009BC */
    un_irc0_irqpl68_t	unIRQPL68;	/* 0x000009C0 */
    un_irc0_irqpl69_t	unIRQPL69;	/* 0x000009C4 */
    un_irc0_irqpl70_t	unIRQPL70;	/* 0x000009C8 */
    un_irc0_irqpl71_t	unIRQPL71;	/* 0x000009CC */
    un_irc0_irqpl72_t	unIRQPL72;	/* 0x000009D0 */
    un_irc0_irqpl73_t	unIRQPL73;	/* 0x000009D4 */
    un_irc0_irqpl74_t	unIRQPL74;	/* 0x000009D8 */
    un_irc0_irqpl75_t	unIRQPL75;	/* 0x000009DC */
    un_irc0_irqpl76_t	unIRQPL76;	/* 0x000009E0 */
    un_irc0_irqpl77_t	unIRQPL77;	/* 0x000009E4 */
    un_irc0_irqpl78_t	unIRQPL78;	/* 0x000009E8 */
    un_irc0_irqpl79_t	unIRQPL79;	/* 0x000009EC */
    un_irc0_irqpl80_t	unIRQPL80;	/* 0x000009F0 */
    un_irc0_irqpl81_t	unIRQPL81;	/* 0x000009F4 */
    un_irc0_irqpl82_t	unIRQPL82;	/* 0x000009F8 */
    un_irc0_irqpl83_t	unIRQPL83;	/* 0x000009FC */
    un_irc0_irqpl84_t	unIRQPL84;	/* 0x00000A00 */
    un_irc0_irqpl85_t	unIRQPL85;	/* 0x00000A04 */
    un_irc0_irqpl86_t	unIRQPL86;	/* 0x00000A08 */
    un_irc0_irqpl87_t	unIRQPL87;	/* 0x00000A0C */
    un_irc0_irqpl88_t	unIRQPL88;	/* 0x00000A10 */
    un_irc0_irqpl89_t	unIRQPL89;	/* 0x00000A14 */
    un_irc0_irqpl90_t	unIRQPL90;	/* 0x00000A18 */
    un_irc0_irqpl91_t	unIRQPL91;	/* 0x00000A1C */
    un_irc0_irqpl92_t	unIRQPL92;	/* 0x00000A20 */
    un_irc0_irqpl93_t	unIRQPL93;	/* 0x00000A24 */
    un_irc0_irqpl94_t	unIRQPL94;	/* 0x00000A28 */
    un_irc0_irqpl95_t	unIRQPL95;	/* 0x00000A2C */
    un_irc0_irqpl96_t	unIRQPL96;	/* 0x00000A30 */
    un_irc0_irqpl97_t	unIRQPL97;	/* 0x00000A34 */
    un_irc0_irqpl98_t	unIRQPL98;	/* 0x00000A38 */
    un_irc0_irqpl99_t	unIRQPL99;	/* 0x00000A3C */
    un_irc0_irqpl100_t	unIRQPL100;	/* 0x00000A40 */
    un_irc0_irqpl101_t	unIRQPL101;	/* 0x00000A44 */
    un_irc0_irqpl102_t	unIRQPL102;	/* 0x00000A48 */
    un_irc0_irqpl103_t	unIRQPL103;	/* 0x00000A4C */
    un_irc0_irqpl104_t	unIRQPL104;	/* 0x00000A50 */
    un_irc0_irqpl105_t	unIRQPL105;	/* 0x00000A54 */
    un_irc0_irqpl106_t	unIRQPL106;	/* 0x00000A58 */
    un_irc0_irqpl107_t	unIRQPL107;	/* 0x00000A5C */
    un_irc0_irqpl108_t	unIRQPL108;	/* 0x00000A60 */
    un_irc0_irqpl109_t	unIRQPL109;	/* 0x00000A64 */
    un_irc0_irqpl110_t	unIRQPL110;	/* 0x00000A68 */
    un_irc0_irqpl111_t	unIRQPL111;	/* 0x00000A6C */
    un_irc0_irqpl112_t	unIRQPL112;	/* 0x00000A70 */
    un_irc0_irqpl113_t	unIRQPL113;	/* 0x00000A74 */
    un_irc0_irqpl114_t	unIRQPL114;	/* 0x00000A78 */
    un_irc0_irqpl115_t	unIRQPL115;	/* 0x00000A7C */
    un_irc0_irqpl116_t	unIRQPL116;	/* 0x00000A80 */
    un_irc0_irqpl117_t	unIRQPL117;	/* 0x00000A84 */
    un_irc0_irqpl118_t	unIRQPL118;	/* 0x00000A88 */
    un_irc0_irqpl119_t	unIRQPL119;	/* 0x00000A8C */
    un_irc0_irqpl120_t	unIRQPL120;	/* 0x00000A90 */
    un_irc0_irqpl121_t	unIRQPL121;	/* 0x00000A94 */
    un_irc0_irqpl122_t	unIRQPL122;	/* 0x00000A98 */
    un_irc0_irqpl123_t	unIRQPL123;	/* 0x00000A9C */
    un_irc0_irqpl124_t	unIRQPL124;	/* 0x00000AA0 */
    un_irc0_irqpl125_t	unIRQPL125;	/* 0x00000AA4 */
    un_irc0_irqpl126_t	unIRQPL126;	/* 0x00000AA8 */
    un_irc0_irqpl127_t	unIRQPL127;	/* 0x00000AAC */
    un_irc0_nmis_t	unNMIS;	/* 0x00000AB0 */
    un_irc0_nmir_t	unNMIR;	/* 0x00000AB4 */
    un_irc0_nmisis_t	unNMISIS;	/* 0x00000AB8 */
    uint_io8_t	au8Reserved0[4];	/* 0x00000ABC */
    un_irc0_irqs0_t	unIRQS0;	/* 0x00000AC0 */
    un_irc0_irqs1_t	unIRQS1;	/* 0x00000AC4 */
    un_irc0_irqs2_t	unIRQS2;	/* 0x00000AC8 */
    un_irc0_irqs3_t	unIRQS3;	/* 0x00000ACC */
    un_irc0_irqs4_t	unIRQS4;	/* 0x00000AD0 */
    un_irc0_irqs5_t	unIRQS5;	/* 0x00000AD4 */
    un_irc0_irqs6_t	unIRQS6;	/* 0x00000AD8 */
    un_irc0_irqs7_t	unIRQS7;	/* 0x00000ADC */
    un_irc0_irqs8_t	unIRQS8;	/* 0x00000AE0 */
    un_irc0_irqs9_t	unIRQS9;	/* 0x00000AE4 */
    un_irc0_irqs10_t	unIRQS10;	/* 0x00000AE8 */
    un_irc0_irqs11_t	unIRQS11;	/* 0x00000AEC */
    un_irc0_irqs12_t	unIRQS12;	/* 0x00000AF0 */
    un_irc0_irqs13_t	unIRQS13;	/* 0x00000AF4 */
    un_irc0_irqs14_t	unIRQS14;	/* 0x00000AF8 */
    un_irc0_irqs15_t	unIRQS15;	/* 0x00000AFC */
    un_irc0_irqr0_t	unIRQR0;	/* 0x00000B00 */
    un_irc0_irqr1_t	unIRQR1;	/* 0x00000B04 */
    un_irc0_irqr2_t	unIRQR2;	/* 0x00000B08 */
    un_irc0_irqr3_t	unIRQR3;	/* 0x00000B0C */
    un_irc0_irqr4_t	unIRQR4;	/* 0x00000B10 */
    un_irc0_irqr5_t	unIRQR5;	/* 0x00000B14 */
    un_irc0_irqr6_t	unIRQR6;	/* 0x00000B18 */
    un_irc0_irqr7_t	unIRQR7;	/* 0x00000B1C */
    un_irc0_irqr8_t	unIRQR8;	/* 0x00000B20 */
    un_irc0_irqr9_t	unIRQR9;	/* 0x00000B24 */
    un_irc0_irqr10_t	unIRQR10;	/* 0x00000B28 */
    un_irc0_irqr11_t	unIRQR11;	/* 0x00000B2C */
    un_irc0_irqr12_t	unIRQR12;	/* 0x00000B30 */
    un_irc0_irqr13_t	unIRQR13;	/* 0x00000B34 */
    un_irc0_irqr14_t	unIRQR14;	/* 0x00000B38 */
    un_irc0_irqr15_t	unIRQR15;	/* 0x00000B3C */
    un_irc0_irqsis0_t	unIRQSIS0;	/* 0x00000B40 */
    un_irc0_irqsis1_t	unIRQSIS1;	/* 0x00000B44 */
    un_irc0_irqsis2_t	unIRQSIS2;	/* 0x00000B48 */
    un_irc0_irqsis3_t	unIRQSIS3;	/* 0x00000B4C */
    un_irc0_irqsis4_t	unIRQSIS4;	/* 0x00000B50 */
    un_irc0_irqsis5_t	unIRQSIS5;	/* 0x00000B54 */
    un_irc0_irqsis6_t	unIRQSIS6;	/* 0x00000B58 */
    un_irc0_irqsis7_t	unIRQSIS7;	/* 0x00000B5C */
    un_irc0_irqsis8_t	unIRQSIS8;	/* 0x00000B60 */
    un_irc0_irqsis9_t	unIRQSIS9;	/* 0x00000B64 */
    un_irc0_irqsis10_t	unIRQSIS10;	/* 0x00000B68 */
    un_irc0_irqsis11_t	unIRQSIS11;	/* 0x00000B6C */
    un_irc0_irqsis12_t	unIRQSIS12;	/* 0x00000B70 */
    un_irc0_irqsis13_t	unIRQSIS13;	/* 0x00000B74 */
    un_irc0_irqsis14_t	unIRQSIS14;	/* 0x00000B78 */
    un_irc0_irqsis15_t	unIRQSIS15;	/* 0x00000B7C */
    un_irc0_irqces0_t	unIRQCES0;	/* 0x00000B80 */
    un_irc0_irqces1_t	unIRQCES1;	/* 0x00000B84 */
    un_irc0_irqces2_t	unIRQCES2;	/* 0x00000B88 */
    un_irc0_irqces3_t	unIRQCES3;	/* 0x00000B8C */
    un_irc0_irqces4_t	unIRQCES4;	/* 0x00000B90 */
    un_irc0_irqces5_t	unIRQCES5;	/* 0x00000B94 */
    un_irc0_irqces6_t	unIRQCES6;	/* 0x00000B98 */
    un_irc0_irqces7_t	unIRQCES7;	/* 0x00000B9C */
    un_irc0_irqces8_t	unIRQCES8;	/* 0x00000BA0 */
    un_irc0_irqces9_t	unIRQCES9;	/* 0x00000BA4 */
    un_irc0_irqces10_t	unIRQCES10;	/* 0x00000BA8 */
    un_irc0_irqces11_t	unIRQCES11;	/* 0x00000BAC */
    un_irc0_irqces12_t	unIRQCES12;	/* 0x00000BB0 */
    un_irc0_irqces13_t	unIRQCES13;	/* 0x00000BB4 */
    un_irc0_irqces14_t	unIRQCES14;	/* 0x00000BB8 */
    un_irc0_irqces15_t	unIRQCES15;	/* 0x00000BBC */
    un_irc0_irqcec0_t	unIRQCEC0;	/* 0x00000BC0 */
    un_irc0_irqcec1_t	unIRQCEC1;	/* 0x00000BC4 */
    un_irc0_irqcec2_t	unIRQCEC2;	/* 0x00000BC8 */
    un_irc0_irqcec3_t	unIRQCEC3;	/* 0x00000BCC */
    un_irc0_irqcec4_t	unIRQCEC4;	/* 0x00000BD0 */
    un_irc0_irqcec5_t	unIRQCEC5;	/* 0x00000BD4 */
    un_irc0_irqcec6_t	unIRQCEC6;	/* 0x00000BD8 */
    un_irc0_irqcec7_t	unIRQCEC7;	/* 0x00000BDC */
    un_irc0_irqcec8_t	unIRQCEC8;	/* 0x00000BE0 */
    un_irc0_irqcec9_t	unIRQCEC9;	/* 0x00000BE4 */
    un_irc0_irqcec10_t	unIRQCEC10;	/* 0x00000BE8 */
    un_irc0_irqcec11_t	unIRQCEC11;	/* 0x00000BEC */
    un_irc0_irqcec12_t	unIRQCEC12;	/* 0x00000BF0 */
    un_irc0_irqcec13_t	unIRQCEC13;	/* 0x00000BF4 */
    un_irc0_irqcec14_t	unIRQCEC14;	/* 0x00000BF8 */
    un_irc0_irqcec15_t	unIRQCEC15;	/* 0x00000BFC */
    un_irc0_irqce0_t	unIRQCE0;	/* 0x00000C00 */
    un_irc0_irqce1_t	unIRQCE1;	/* 0x00000C04 */
    un_irc0_irqce2_t	unIRQCE2;	/* 0x00000C08 */
    un_irc0_irqce3_t	unIRQCE3;	/* 0x00000C0C */
    un_irc0_irqce4_t	unIRQCE4;	/* 0x00000C10 */
    un_irc0_irqce5_t	unIRQCE5;	/* 0x00000C14 */
    un_irc0_irqce6_t	unIRQCE6;	/* 0x00000C18 */
    un_irc0_irqce7_t	unIRQCE7;	/* 0x00000C1C */
    un_irc0_irqce8_t	unIRQCE8;	/* 0x00000C20 */
    un_irc0_irqce9_t	unIRQCE9;	/* 0x00000C24 */
    un_irc0_irqce10_t	unIRQCE10;	/* 0x00000C28 */
    un_irc0_irqce11_t	unIRQCE11;	/* 0x00000C2C */
    un_irc0_irqce12_t	unIRQCE12;	/* 0x00000C30 */
    un_irc0_irqce13_t	unIRQCE13;	/* 0x00000C34 */
    un_irc0_irqce14_t	unIRQCE14;	/* 0x00000C38 */
    un_irc0_irqce15_t	unIRQCE15;	/* 0x00000C3C */
    un_irc0_nmihc_t	unNMIHC;	/* 0x00000C40 */
    un_irc0_nmihs_t	unNMIHS;	/* 0x00000C44 */
    un_irc0_irqhc_t	unIRQHC;	/* 0x00000C48 */
    uint_io8_t	au8Reserved1[4];	/* 0x00000C4C */
    un_irc0_irqhs0_t	unIRQHS0;	/* 0x00000C50 */
    un_irc0_irqhs1_t	unIRQHS1;	/* 0x00000C54 */
    un_irc0_irqhs2_t	unIRQHS2;	/* 0x00000C58 */
    un_irc0_irqhs3_t	unIRQHS3;	/* 0x00000C5C */
    un_irc0_irqhs4_t	unIRQHS4;	/* 0x00000C60 */
    un_irc0_irqhs5_t	unIRQHS5;	/* 0x00000C64 */
    un_irc0_irqhs6_t	unIRQHS6;	/* 0x00000C68 */
    un_irc0_irqhs7_t	unIRQHS7;	/* 0x00000C6C */
    un_irc0_irqhs8_t	unIRQHS8;	/* 0x00000C70 */
    un_irc0_irqhs9_t	unIRQHS9;	/* 0x00000C74 */
    un_irc0_irqhs10_t	unIRQHS10;	/* 0x00000C78 */
    un_irc0_irqhs11_t	unIRQHS11;	/* 0x00000C7C */
    un_irc0_irqhs12_t	unIRQHS12;	/* 0x00000C80 */
    un_irc0_irqhs13_t	unIRQHS13;	/* 0x00000C84 */
    un_irc0_irqhs14_t	unIRQHS14;	/* 0x00000C88 */
    un_irc0_irqhs15_t	unIRQHS15;	/* 0x00000C8C */
    un_irc0_irqplm_t	unIRQPLM;	/* 0x00000C90 */
    uint_io8_t	au8Reserved2[4];	/* 0x00000C94 */
    un_irc0_csr_t	unCSR;	/* 0x00000C98 */
    uint_io8_t	au8Reserved3[12];	/* 0x00000C9C */
    un_irc0_nmirs_t	unNMIRS;	/* 0x00000CA8 */
    un_irc0_nmips_t	unNMIPS;	/* 0x00000CAC */
    un_irc0_irqrs0_t	unIRQRS0;	/* 0x00000CB0 */
    un_irc0_irqrs1_t	unIRQRS1;	/* 0x00000CB4 */
    un_irc0_irqrs2_t	unIRQRS2;	/* 0x00000CB8 */
    un_irc0_irqrs3_t	unIRQRS3;	/* 0x00000CBC */
    un_irc0_irqrs4_t	unIRQRS4;	/* 0x00000CC0 */
    un_irc0_irqrs5_t	unIRQRS5;	/* 0x00000CC4 */
    un_irc0_irqrs6_t	unIRQRS6;	/* 0x00000CC8 */
    un_irc0_irqrs7_t	unIRQRS7;	/* 0x00000CCC */
    un_irc0_irqrs8_t	unIRQRS8;	/* 0x00000CD0 */
    un_irc0_irqrs9_t	unIRQRS9;	/* 0x00000CD4 */
    un_irc0_irqrs10_t	unIRQRS10;	/* 0x00000CD8 */
    un_irc0_irqrs11_t	unIRQRS11;	/* 0x00000CDC */
    un_irc0_irqrs12_t	unIRQRS12;	/* 0x00000CE0 */
    un_irc0_irqrs13_t	unIRQRS13;	/* 0x00000CE4 */
    un_irc0_irqrs14_t	unIRQRS14;	/* 0x00000CE8 */
    un_irc0_irqrs15_t	unIRQRS15;	/* 0x00000CEC */
    un_irc0_irqps0_t	unIRQPS0;	/* 0x00000CF0 */
    un_irc0_irqps1_t	unIRQPS1;	/* 0x00000CF4 */
    un_irc0_irqps2_t	unIRQPS2;	/* 0x00000CF8 */
    un_irc0_irqps3_t	unIRQPS3;	/* 0x00000CFC */
    un_irc0_irqps4_t	unIRQPS4;	/* 0x00000D00 */
    un_irc0_irqps5_t	unIRQPS5;	/* 0x00000D04 */
    un_irc0_irqps6_t	unIRQPS6;	/* 0x00000D08 */
    un_irc0_irqps7_t	unIRQPS7;	/* 0x00000D0C */
    un_irc0_irqps8_t	unIRQPS8;	/* 0x00000D10 */
    un_irc0_irqps9_t	unIRQPS9;	/* 0x00000D14 */
    un_irc0_irqps10_t	unIRQPS10;	/* 0x00000D18 */
    un_irc0_irqps11_t	unIRQPS11;	/* 0x00000D1C */
    un_irc0_irqps12_t	unIRQPS12;	/* 0x00000D20 */
    un_irc0_irqps13_t	unIRQPS13;	/* 0x00000D24 */
    un_irc0_irqps14_t	unIRQPS14;	/* 0x00000D28 */
    un_irc0_irqps15_t	unIRQPS15;	/* 0x00000D2C */
    un_irc0_unlock_t	unUNLOCK;	/* 0x00000D30 */
    uint_io8_t	au8Reserved4[8];	/* 0x00000D34 */
    un_irc0_irqeeva_t	unIRQEEVA;	/* 0x00000D3C */
    un_irc0_eei_t	unEEI;	/* 0x00000D40 */
    un_irc0_ean_t	unEAN;	/* 0x00000D44 */
    un_irc0_et_t	unET;	/* 0x00000D48 */
    un_irc0_eebn_t	unEEB0;	/* 0x00000D4C */
    un_irc0_eebn_t	unEEB1;	/* 0x00000D50 */
    un_irc0_eeb2_t	unEEB2;	/* 0x00000D54 */
    uint_io8_t	au8Reserved5[29352];	/* 0x00000D58 */
}stc_irc0_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_irc0_t	stcIRC0;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 32768(0x8000) bytes */


/* IRC0 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define IRC0_1	stcIRC0_1
#else /* __IO_DEFINE */
#define IRC0_1	(*((volatile stc_irc0_1_t*)0xFFFEE000))
#endif /* __IO_DEFINE */

/* NMIVASBR */
#define IRC0_NMIVASBR	(IRC0_1.unNMIVASBR.u32Register)  /*@rg@*/
#define IRC0_NMIVASBR_NMIVAS	IRC0_NMIVASBR  /*@bfrg@*/

typedef union un_irc0_1_nmivasbr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc0_1_nmivasbr_t;


typedef struct stc_irc0_1{
    uint_io8_t	au8Reserved0[1020];	/* 0x00000000 */
    un_irc0_1_nmivasbr_t	unNMIVASBR;	/* 0x000003FC */
}stc_irc0_1_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_irc0_1_t	stcIRC0_1;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


/* IRC base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define IRC_2	stcIRC_2
#else /* __IO_DEFINE */
#define IRC_2	(*((volatile stc_irc_2_t*)0xFFFEF800))
#endif /* __IO_DEFINE */

/* NMIVASBR */
#define IRC_NMIVASBR	(IRC_2.unNMIVASBR.u32Register)  /*@rg@*/
#define IRC_NMIVASBR_NMIVAS	IRC_NMIVASBR  /*@bfrg@*/

typedef union un_irc_2_nmivasbr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_irc_2_nmivasbr_t;


typedef struct stc_irc_2{
    uint_io8_t	au8Reserved0[1020];	/* 0x00000000 */
    un_irc_2_nmivasbr_t	unNMIVASBR;	/* 0x000003FC */
}stc_irc_2_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_irc_2_t	stcIRC_2;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_IRC_H */
