/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_LCDB_H
#define __S6J3360_LCDB_H

#include "s6j3360io_basetypes.h"

/* LCDB base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define LCDB	stcLCDB
#else /* __IO_DEFINE */
#define LCDB	(*((volatile stc_lcdb_t*)0xB8040000))
#endif /* __IO_DEFINE */

/* LockUnlockLcd */
#define LCDB_LockUnlockLcd	(LCDB.unLockUnlockLcd.u32Register)  /*@rg@*/
#define LCDB_LOCKUNLOCKLCD	(LCDB_LockUnlockLcd)  /*@rg2@*/
#define LCDB_LockUnlockLcd_LockUnlockLcd	LCDB_LockUnlockLcd  /*@bfrg@*/
#define LCDB_LOCKUNLOCKLCD_LOCKUNLOCKLCD	LCDB_LockUnlockLcd_LockUnlockLcd  /*@bf2@*/

typedef union un_lcdb_lockunlocklcd{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockunlocklcd_t;

/* LockStatusLcd */
#define LCDB_LockStatusLcd	(LCDB.unLockStatusLcd.u32Register)  /*@rg@*/
#define LCDB_LOCKSTATUSLCD	(LCDB_LockStatusLcd)  /*@rg2@*/
#define LCDB_LockStatusLcd_LockStatusLcd	(LCDB.unLockStatusLcd.stcField.u1LockStatusLcd)  /*@bf@*/
#define LCDB_LockStatusLcd_PrivilegeStatusLcd	(LCDB.unLockStatusLcd.stcField.u1PrivilegeStatusLcd)  /*@bf@*/
#define LCDB_LockStatusLcd_FreezeStatusLcd	(LCDB.unLockStatusLcd.stcField.u1FreezeStatusLcd)  /*@bf@*/
#define LCDB_LOCKSTATUSLCD_LOCKSTATUSLCD	LCDB_LockStatusLcd_LockStatusLcd  /*@bf2@*/
#define LCDB_LOCKSTATUSLCD_PRIVILEGESTATUSLCD	LCDB_LockStatusLcd_PrivilegeStatusLcd  /*@bf2@*/
#define LCDB_LOCKSTATUSLCD_FREEZESTATUSLCD	LCDB_LockStatusLcd_FreezeStatusLcd  /*@bf2@*/

typedef struct stc_lcdb_lockstatuslcd_field{
    uint_io32_t		u1LockStatusLcd:1;
    uint_io32_t		:3;
    uint_io32_t		u1PrivilegeStatusLcd:1;
    uint_io32_t		:3;
    uint_io32_t		u1FreezeStatusLcd:1;
    uint_io32_t		:23;
}stc_lcdb_lockstatuslcd_field_t;

typedef union un_lcdb_lockstatuslcd{
    uint_io32_t		u32Register;
    stc_lcdb_lockstatuslcd_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockstatuslcd_t;

/* InterfaceConfig */
#define LCDB_InterfaceConfig	(LCDB.unInterfaceConfig.u32Register)  /*@rg@*/
#define LCDB_INTERFACECONFIG	(LCDB_InterfaceConfig)  /*@rg2@*/
#define LCDB_InterfaceConfig_InterfaceType	(LCDB.unInterfaceConfig.stcField.u2InterfaceType)  /*@bf@*/
#define LCDB_InterfaceConfig_InterfaceWidth	(LCDB.unInterfaceConfig.stcField.u2InterfaceWidth)  /*@bf@*/
#define LCDB_InterfaceConfig_CsPolarity	(LCDB.unInterfaceConfig.stcField.u1CsPolarity)  /*@bf@*/
#define LCDB_InterfaceConfig_WrPolarity	(LCDB.unInterfaceConfig.stcField.u1WrPolarity)  /*@bf@*/
#define LCDB_InterfaceConfig_RdPolarity	(LCDB.unInterfaceConfig.stcField.u1RdPolarity)  /*@bf@*/
#define LCDB_InterfaceConfig_RsPolarity	(LCDB.unInterfaceConfig.stcField.u1RsPolarity)  /*@bf@*/
#define LCDB_InterfaceConfig_DataPolarity	(LCDB.unInterfaceConfig.stcField.u1DataPolarity)  /*@bf@*/
#define LCDB_InterfaceConfig_TePolarity	(LCDB.unInterfaceConfig.stcField.u1TePolarity)  /*@bf@*/
#define LCDB_INTERFACECONFIG_INTERFACETYPE	LCDB_InterfaceConfig_InterfaceType  /*@bf2@*/
#define LCDB_INTERFACECONFIG_INTERFACEWIDTH	LCDB_InterfaceConfig_InterfaceWidth  /*@bf2@*/
#define LCDB_INTERFACECONFIG_CSPOLARITY	LCDB_InterfaceConfig_CsPolarity  /*@bf2@*/
#define LCDB_INTERFACECONFIG_WRPOLARITY	LCDB_InterfaceConfig_WrPolarity  /*@bf2@*/
#define LCDB_INTERFACECONFIG_RDPOLARITY	LCDB_InterfaceConfig_RdPolarity  /*@bf2@*/
#define LCDB_INTERFACECONFIG_RSPOLARITY	LCDB_InterfaceConfig_RsPolarity  /*@bf2@*/
#define LCDB_INTERFACECONFIG_DATAPOLARITY	LCDB_InterfaceConfig_DataPolarity  /*@bf2@*/
#define LCDB_INTERFACECONFIG_TEPOLARITY	LCDB_InterfaceConfig_TePolarity  /*@bf2@*/

typedef struct stc_lcdb_interfaceconfig_field{
    uint_io32_t		u2InterfaceType:2;
    uint_io32_t		:6;
    uint_io32_t		u2InterfaceWidth:2;
    uint_io32_t		:6;
    uint_io32_t		u1CsPolarity:1;
    uint_io32_t		u1WrPolarity:1;
    uint_io32_t		u1RdPolarity:1;
    uint_io32_t		u1RsPolarity:1;
    uint_io32_t		u1DataPolarity:1;
    uint_io32_t		u1TePolarity:1;
    uint_io32_t		:10;
}stc_lcdb_interfaceconfig_field_t;

typedef union un_lcdb_interfaceconfig{
    uint_io32_t		u32Register;
    stc_lcdb_interfaceconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_interfaceconfig_t;

/* WriteTimingConfig */
#define LCDB_WriteTimingConfig	(LCDB.unWriteTimingConfig.u32Register)  /*@rg@*/
#define LCDB_WRITETIMINGCONFIG	(LCDB_WriteTimingConfig)  /*@rg2@*/
#define LCDB_WriteTimingConfig_WriteSetupCycles	(LCDB.unWriteTimingConfig.au8Byte[0])  /*@bfbyte@*/
#define LCDB_WriteTimingConfig_WriteActiveCycles	(LCDB.unWriteTimingConfig.au8Byte[1])  /*@bfbyte@*/
#define LCDB_WriteTimingConfig_WriteHoldCycles	(LCDB.unWriteTimingConfig.au8Byte[2])  /*@bfbyte@*/
#define LCDB_WRITETIMINGCONFIG_WRITESETUPCYCLES	LCDB_WriteTimingConfig_WriteSetupCycles  /*@bf2@*/
#define LCDB_WRITETIMINGCONFIG_WRITEACTIVECYCLES	LCDB_WriteTimingConfig_WriteActiveCycles  /*@bf2@*/
#define LCDB_WRITETIMINGCONFIG_WRITEHOLDCYCLES	LCDB_WriteTimingConfig_WriteHoldCycles  /*@bf2@*/

typedef struct stc_lcdb_writetimingconfig_field{
    uint_io32_t		u8WriteSetupCycles:8;
    uint_io32_t		u8WriteActiveCycles:8;
    uint_io32_t		u8WriteHoldCycles:8;
    uint_io32_t		:8;
}stc_lcdb_writetimingconfig_field_t;

typedef union un_lcdb_writetimingconfig{
    uint_io32_t		u32Register;
    stc_lcdb_writetimingconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_writetimingconfig_t;

/* ReadTimingConfig */
#define LCDB_ReadTimingConfig	(LCDB.unReadTimingConfig.u32Register)  /*@rg@*/
#define LCDB_READTIMINGCONFIG	(LCDB_ReadTimingConfig)  /*@rg2@*/
#define LCDB_ReadTimingConfig_ReadSetupCycles	(LCDB.unReadTimingConfig.au8Byte[0])  /*@bfbyte@*/
#define LCDB_ReadTimingConfig_ReadActiveCycles	(LCDB.unReadTimingConfig.au8Byte[1])  /*@bfbyte@*/
#define LCDB_ReadTimingConfig_ReadHoldCycles	(LCDB.unReadTimingConfig.au8Byte[2])  /*@bfbyte@*/
#define LCDB_READTIMINGCONFIG_READSETUPCYCLES	LCDB_ReadTimingConfig_ReadSetupCycles  /*@bf2@*/
#define LCDB_READTIMINGCONFIG_READACTIVECYCLES	LCDB_ReadTimingConfig_ReadActiveCycles  /*@bf2@*/
#define LCDB_READTIMINGCONFIG_READHOLDCYCLES	LCDB_ReadTimingConfig_ReadHoldCycles  /*@bf2@*/

typedef struct stc_lcdb_readtimingconfig_field{
    uint_io32_t		u8ReadSetupCycles:8;
    uint_io32_t		u8ReadActiveCycles:8;
    uint_io32_t		u8ReadHoldCycles:8;
    uint_io32_t		:8;
}stc_lcdb_readtimingconfig_field_t;

typedef union un_lcdb_readtimingconfig{
    uint_io32_t		u32Register;
    stc_lcdb_readtimingconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_readtimingconfig_t;

/* CommandTransferMapping0 */
#define LCDB_CommandTransferMapping0	(LCDB.unCommandTransferMapping0.u32Register)  /*@rg@*/
#define LCDB_COMMANDTRANSFERMAPPING0	(LCDB_CommandTransferMapping0)  /*@rg2@*/
#define LCDB_CommandTransferMapping0_CommandTransfer0Bits	(LCDB.unCommandTransferMapping0.stcField.u5CommandTransfer0Bits)  /*@bf@*/
#define LCDB_CommandTransferMapping0_CommandTransfer0SrcLsb	(LCDB.unCommandTransferMapping0.stcField.u5CommandTransfer0SrcLsb)  /*@bf@*/
#define LCDB_CommandTransferMapping0_CommandTransfer0DstLsb	(LCDB.unCommandTransferMapping0.stcField.u5CommandTransfer0DstLsb)  /*@bf@*/
#define LCDB_CommandTransferMapping0_CommandTransfer0Next	(LCDB.unCommandTransferMapping0.stcField.u1CommandTransfer0Next)  /*@bf@*/
#define LCDB_COMMANDTRANSFERMAPPING0_COMMANDTRANSFER0BITS	LCDB_CommandTransferMapping0_CommandTransfer0Bits  /*@bf2@*/
#define LCDB_COMMANDTRANSFERMAPPING0_COMMANDTRANSFER0SRCLSB	LCDB_CommandTransferMapping0_CommandTransfer0SrcLsb  /*@bf2@*/
#define LCDB_COMMANDTRANSFERMAPPING0_COMMANDTRANSFER0DSTLSB	LCDB_CommandTransferMapping0_CommandTransfer0DstLsb  /*@bf2@*/
#define LCDB_COMMANDTRANSFERMAPPING0_COMMANDTRANSFER0NEXT	LCDB_CommandTransferMapping0_CommandTransfer0Next  /*@bf2@*/

typedef struct stc_lcdb_commandtransfermapping0_field{
    uint_io32_t		u5CommandTransfer0Bits:5;
    uint_io32_t		u5CommandTransfer0SrcLsb:5;
    uint_io32_t		u5CommandTransfer0DstLsb:5;
    uint_io32_t		u1CommandTransfer0Next:1;
    uint_io32_t		:16;
}stc_lcdb_commandtransfermapping0_field_t;

typedef union un_lcdb_commandtransfermapping0{
    uint_io32_t		u32Register;
    stc_lcdb_commandtransfermapping0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_commandtransfermapping0_t;

/* CommandTransferMapping1 */
#define LCDB_CommandTransferMapping1	(LCDB.unCommandTransferMapping1.u32Register)  /*@rg@*/
#define LCDB_COMMANDTRANSFERMAPPING1	(LCDB_CommandTransferMapping1)  /*@rg2@*/
#define LCDB_CommandTransferMapping1_CommandTransfer1Bits	(LCDB.unCommandTransferMapping1.stcField.u5CommandTransfer1Bits)  /*@bf@*/
#define LCDB_CommandTransferMapping1_CommandTransfer1SrcLsb	(LCDB.unCommandTransferMapping1.stcField.u5CommandTransfer1SrcLsb)  /*@bf@*/
#define LCDB_CommandTransferMapping1_CommandTransfer1DstLsb	(LCDB.unCommandTransferMapping1.stcField.u5CommandTransfer1DstLsb)  /*@bf@*/
#define LCDB_CommandTransferMapping1_CommandTransfer1Next	(LCDB.unCommandTransferMapping1.stcField.u1CommandTransfer1Next)  /*@bf@*/
#define LCDB_COMMANDTRANSFERMAPPING1_COMMANDTRANSFER1BITS	LCDB_CommandTransferMapping1_CommandTransfer1Bits  /*@bf2@*/
#define LCDB_COMMANDTRANSFERMAPPING1_COMMANDTRANSFER1SRCLSB	LCDB_CommandTransferMapping1_CommandTransfer1SrcLsb  /*@bf2@*/
#define LCDB_COMMANDTRANSFERMAPPING1_COMMANDTRANSFER1DSTLSB	LCDB_CommandTransferMapping1_CommandTransfer1DstLsb  /*@bf2@*/
#define LCDB_COMMANDTRANSFERMAPPING1_COMMANDTRANSFER1NEXT	LCDB_CommandTransferMapping1_CommandTransfer1Next  /*@bf2@*/

typedef struct stc_lcdb_commandtransfermapping1_field{
    uint_io32_t		u5CommandTransfer1Bits:5;
    uint_io32_t		u5CommandTransfer1SrcLsb:5;
    uint_io32_t		u5CommandTransfer1DstLsb:5;
    uint_io32_t		u1CommandTransfer1Next:1;
    uint_io32_t		:16;
}stc_lcdb_commandtransfermapping1_field_t;

typedef union un_lcdb_commandtransfermapping1{
    uint_io32_t		u32Register;
    stc_lcdb_commandtransfermapping1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_commandtransfermapping1_t;

/* CommandTransferMapping2 */
#define LCDB_CommandTransferMapping2	(LCDB.unCommandTransferMapping2.u32Register)  /*@rg@*/
#define LCDB_COMMANDTRANSFERMAPPING2	(LCDB_CommandTransferMapping2)  /*@rg2@*/
#define LCDB_CommandTransferMapping2_CommandTransfer2Bits	(LCDB.unCommandTransferMapping2.stcField.u5CommandTransfer2Bits)  /*@bf@*/
#define LCDB_CommandTransferMapping2_CommandTransfer2SrcLsb	(LCDB.unCommandTransferMapping2.stcField.u5CommandTransfer2SrcLsb)  /*@bf@*/
#define LCDB_CommandTransferMapping2_CommandTransfer2DstLsb	(LCDB.unCommandTransferMapping2.stcField.u5CommandTransfer2DstLsb)  /*@bf@*/
#define LCDB_COMMANDTRANSFERMAPPING2_COMMANDTRANSFER2BITS	LCDB_CommandTransferMapping2_CommandTransfer2Bits  /*@bf2@*/
#define LCDB_COMMANDTRANSFERMAPPING2_COMMANDTRANSFER2SRCLSB	LCDB_CommandTransferMapping2_CommandTransfer2SrcLsb  /*@bf2@*/
#define LCDB_COMMANDTRANSFERMAPPING2_COMMANDTRANSFER2DSTLSB	LCDB_CommandTransferMapping2_CommandTransfer2DstLsb  /*@bf2@*/

typedef struct stc_lcdb_commandtransfermapping2_field{
    uint_io32_t		u5CommandTransfer2Bits:5;
    uint_io32_t		u5CommandTransfer2SrcLsb:5;
    uint_io32_t		u5CommandTransfer2DstLsb:5;
    uint_io32_t		:17;
}stc_lcdb_commandtransfermapping2_field_t;

typedef union un_lcdb_commandtransfermapping2{
    uint_io32_t		u32Register;
    stc_lcdb_commandtransfermapping2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_commandtransfermapping2_t;

/* DataTransferMapping0 */
#define LCDB_DataTransferMapping0	(LCDB.unDataTransferMapping0.u32Register)  /*@rg@*/
#define LCDB_DATATRANSFERMAPPING0	(LCDB_DataTransferMapping0)  /*@rg2@*/
#define LCDB_DataTransferMapping0_DataTransfer0Bits	(LCDB.unDataTransferMapping0.stcField.u5DataTransfer0Bits)  /*@bf@*/
#define LCDB_DataTransferMapping0_DataTransfer0SrcLsb	(LCDB.unDataTransferMapping0.stcField.u5DataTransfer0SrcLsb)  /*@bf@*/
#define LCDB_DataTransferMapping0_DataTransfer0DstLsb	(LCDB.unDataTransferMapping0.stcField.u5DataTransfer0DstLsb)  /*@bf@*/
#define LCDB_DataTransferMapping0_DataTransfer0Next	(LCDB.unDataTransferMapping0.stcField.u1DataTransfer0Next)  /*@bf@*/
#define LCDB_DATATRANSFERMAPPING0_DATATRANSFER0BITS	LCDB_DataTransferMapping0_DataTransfer0Bits  /*@bf2@*/
#define LCDB_DATATRANSFERMAPPING0_DATATRANSFER0SRCLSB	LCDB_DataTransferMapping0_DataTransfer0SrcLsb  /*@bf2@*/
#define LCDB_DATATRANSFERMAPPING0_DATATRANSFER0DSTLSB	LCDB_DataTransferMapping0_DataTransfer0DstLsb  /*@bf2@*/
#define LCDB_DATATRANSFERMAPPING0_DATATRANSFER0NEXT	LCDB_DataTransferMapping0_DataTransfer0Next  /*@bf2@*/

typedef struct stc_lcdb_datatransfermapping0_field{
    uint_io32_t		u5DataTransfer0Bits:5;
    uint_io32_t		u5DataTransfer0SrcLsb:5;
    uint_io32_t		u5DataTransfer0DstLsb:5;
    uint_io32_t		u1DataTransfer0Next:1;
    uint_io32_t		:16;
}stc_lcdb_datatransfermapping0_field_t;

typedef union un_lcdb_datatransfermapping0{
    uint_io32_t		u32Register;
    stc_lcdb_datatransfermapping0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_datatransfermapping0_t;

/* DataTransferMapping1 */
#define LCDB_DataTransferMapping1	(LCDB.unDataTransferMapping1.u32Register)  /*@rg@*/
#define LCDB_DATATRANSFERMAPPING1	(LCDB_DataTransferMapping1)  /*@rg2@*/
#define LCDB_DataTransferMapping1_DataTransfer1Bits	(LCDB.unDataTransferMapping1.stcField.u5DataTransfer1Bits)  /*@bf@*/
#define LCDB_DataTransferMapping1_DataTransfer1SrcLsb	(LCDB.unDataTransferMapping1.stcField.u5DataTransfer1SrcLsb)  /*@bf@*/
#define LCDB_DataTransferMapping1_DataTransfer1DstLsb	(LCDB.unDataTransferMapping1.stcField.u5DataTransfer1DstLsb)  /*@bf@*/
#define LCDB_DataTransferMapping1_DataTransfer1Next	(LCDB.unDataTransferMapping1.stcField.u1DataTransfer1Next)  /*@bf@*/
#define LCDB_DATATRANSFERMAPPING1_DATATRANSFER1BITS	LCDB_DataTransferMapping1_DataTransfer1Bits  /*@bf2@*/
#define LCDB_DATATRANSFERMAPPING1_DATATRANSFER1SRCLSB	LCDB_DataTransferMapping1_DataTransfer1SrcLsb  /*@bf2@*/
#define LCDB_DATATRANSFERMAPPING1_DATATRANSFER1DSTLSB	LCDB_DataTransferMapping1_DataTransfer1DstLsb  /*@bf2@*/
#define LCDB_DATATRANSFERMAPPING1_DATATRANSFER1NEXT	LCDB_DataTransferMapping1_DataTransfer1Next  /*@bf2@*/

typedef struct stc_lcdb_datatransfermapping1_field{
    uint_io32_t		u5DataTransfer1Bits:5;
    uint_io32_t		u5DataTransfer1SrcLsb:5;
    uint_io32_t		u5DataTransfer1DstLsb:5;
    uint_io32_t		u1DataTransfer1Next:1;
    uint_io32_t		:16;
}stc_lcdb_datatransfermapping1_field_t;

typedef union un_lcdb_datatransfermapping1{
    uint_io32_t		u32Register;
    stc_lcdb_datatransfermapping1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_datatransfermapping1_t;

/* DataTransferMapping2 */
#define LCDB_DataTransferMapping2	(LCDB.unDataTransferMapping2.u32Register)  /*@rg@*/
#define LCDB_DATATRANSFERMAPPING2	(LCDB_DataTransferMapping2)  /*@rg2@*/
#define LCDB_DataTransferMapping2_DataTransfer2Bits	(LCDB.unDataTransferMapping2.stcField.u5DataTransfer2Bits)  /*@bf@*/
#define LCDB_DataTransferMapping2_DataTransfer2SrcLsb	(LCDB.unDataTransferMapping2.stcField.u5DataTransfer2SrcLsb)  /*@bf@*/
#define LCDB_DataTransferMapping2_DataTransfer2DstLsb	(LCDB.unDataTransferMapping2.stcField.u5DataTransfer2DstLsb)  /*@bf@*/
#define LCDB_DATATRANSFERMAPPING2_DATATRANSFER2BITS	LCDB_DataTransferMapping2_DataTransfer2Bits  /*@bf2@*/
#define LCDB_DATATRANSFERMAPPING2_DATATRANSFER2SRCLSB	LCDB_DataTransferMapping2_DataTransfer2SrcLsb  /*@bf2@*/
#define LCDB_DATATRANSFERMAPPING2_DATATRANSFER2DSTLSB	LCDB_DataTransferMapping2_DataTransfer2DstLsb  /*@bf2@*/

typedef struct stc_lcdb_datatransfermapping2_field{
    uint_io32_t		u5DataTransfer2Bits:5;
    uint_io32_t		u5DataTransfer2SrcLsb:5;
    uint_io32_t		u5DataTransfer2DstLsb:5;
    uint_io32_t		:17;
}stc_lcdb_datatransfermapping2_field_t;

typedef union un_lcdb_datatransfermapping2{
    uint_io32_t		u32Register;
    stc_lcdb_datatransfermapping2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_datatransfermapping2_t;

/* ColorComponentBits */
#define LCDB_ColorComponentBits	(LCDB.unColorComponentBits.u32Register)  /*@rg@*/
#define LCDB_COLORCOMPONENTBITS	(LCDB_ColorComponentBits)  /*@rg2@*/
#define LCDB_ColorComponentBits_ComponentBitsBlue	(LCDB.unColorComponentBits.stcField.u4ComponentBitsBlue)  /*@bf@*/
#define LCDB_ColorComponentBits_ComponentBitsGreen	(LCDB.unColorComponentBits.stcField.u4ComponentBitsGreen)  /*@bf@*/
#define LCDB_ColorComponentBits_ComponentBitsRed	(LCDB.unColorComponentBits.stcField.u4ComponentBitsRed)  /*@bf@*/
#define LCDB_COLORCOMPONENTBITS_COMPONENTBITSBLUE	LCDB_ColorComponentBits_ComponentBitsBlue  /*@bf2@*/
#define LCDB_COLORCOMPONENTBITS_COMPONENTBITSGREEN	LCDB_ColorComponentBits_ComponentBitsGreen  /*@bf2@*/
#define LCDB_COLORCOMPONENTBITS_COMPONENTBITSRED	LCDB_ColorComponentBits_ComponentBitsRed  /*@bf2@*/

typedef struct stc_lcdb_colorcomponentbits_field{
    uint_io32_t		:8;
    uint_io32_t		u4ComponentBitsBlue:4;
    uint_io32_t		:4;
    uint_io32_t		u4ComponentBitsGreen:4;
    uint_io32_t		:4;
    uint_io32_t		u4ComponentBitsRed:4;
    uint_io32_t		:4;
}stc_lcdb_colorcomponentbits_field_t;

typedef union un_lcdb_colorcomponentbits{
    uint_io32_t		u32Register;
    stc_lcdb_colorcomponentbits_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_colorcomponentbits_t;

/* ColorComponentShift */
#define LCDB_ColorComponentShift	(LCDB.unColorComponentShift.u32Register)  /*@rg@*/
#define LCDB_COLORCOMPONENTSHIFT	(LCDB_ColorComponentShift)  /*@rg2@*/
#define LCDB_ColorComponentShift_ComponentShiftBlue	(LCDB.unColorComponentShift.stcField.u5ComponentShiftBlue)  /*@bf@*/
#define LCDB_ColorComponentShift_ComponentShiftGreen	(LCDB.unColorComponentShift.stcField.u5ComponentShiftGreen)  /*@bf@*/
#define LCDB_ColorComponentShift_ComponentShiftRed	(LCDB.unColorComponentShift.stcField.u5ComponentShiftRed)  /*@bf@*/
#define LCDB_COLORCOMPONENTSHIFT_COMPONENTSHIFTBLUE	LCDB_ColorComponentShift_ComponentShiftBlue  /*@bf2@*/
#define LCDB_COLORCOMPONENTSHIFT_COMPONENTSHIFTGREEN	LCDB_ColorComponentShift_ComponentShiftGreen  /*@bf2@*/
#define LCDB_COLORCOMPONENTSHIFT_COMPONENTSHIFTRED	LCDB_ColorComponentShift_ComponentShiftRed  /*@bf2@*/

typedef struct stc_lcdb_colorcomponentshift_field{
    uint_io32_t		:8;
    uint_io32_t		u5ComponentShiftBlue:5;
    uint_io32_t		:3;
    uint_io32_t		u5ComponentShiftGreen:5;
    uint_io32_t		:3;
    uint_io32_t		u5ComponentShiftRed:5;
    uint_io32_t		:3;
}stc_lcdb_colorcomponentshift_field_t;

typedef union un_lcdb_colorcomponentshift{
    uint_io32_t		u32Register;
    stc_lcdb_colorcomponentshift_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_colorcomponentshift_t;

/* DestinationAttributes */
#define LCDB_DestinationAttributes	(LCDB.unDestinationAttributes.u32Register)  /*@rg@*/
#define LCDB_DESTINATIONATTRIBUTES	(LCDB_DestinationAttributes)  /*@rg2@*/
#define LCDB_DestinationAttributes_BitsPerTransfer	(LCDB.unDestinationAttributes.stcField.u5BitsPerTransfer)  /*@bf@*/
#define LCDB_DestinationAttributes_BitsPerPixel	(LCDB.unDestinationAttributes.stcField.u5BitsPerPixel)  /*@bf@*/
#define LCDB_DESTINATIONATTRIBUTES_BITSPERTRANSFER	LCDB_DestinationAttributes_BitsPerTransfer  /*@bf2@*/
#define LCDB_DESTINATIONATTRIBUTES_BITSPERPIXEL	LCDB_DestinationAttributes_BitsPerPixel  /*@bf2@*/

typedef struct stc_lcdb_destinationattributes_field{
    uint_io32_t		u5BitsPerTransfer:5;
    uint_io32_t		:3;
    uint_io32_t		u5BitsPerPixel:5;
    uint_io32_t		:19;
}stc_lcdb_destinationattributes_field_t;

typedef union un_lcdb_destinationattributes{
    uint_io32_t		u32Register;
    stc_lcdb_destinationattributes_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_destinationattributes_t;

/* LockUnlockControl */
#define LCDB_LockUnlockControl	(LCDB.unLockUnlockControl.u32Register)  /*@rg@*/
#define LCDB_LOCKUNLOCKCONTROL	(LCDB_LockUnlockControl)  /*@rg2@*/
#define LCDB_LockUnlockControl_LockUnlockControl	LCDB_LockUnlockControl  /*@bfrg@*/
#define LCDB_LOCKUNLOCKCONTROL_LOCKUNLOCKCONTROL	LCDB_LockUnlockControl_LockUnlockControl  /*@bf2@*/

typedef union un_lcdb_lockunlockcontrol{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockunlockcontrol_t;

/* LockStatusControl */
#define LCDB_LockStatusControl	(LCDB.unLockStatusControl.u32Register)  /*@rg@*/
#define LCDB_LOCKSTATUSCONTROL	(LCDB_LockStatusControl)  /*@rg2@*/
#define LCDB_LockStatusControl_LockStatusControl	(LCDB.unLockStatusControl.stcField.u1LockStatusControl)  /*@bf@*/
#define LCDB_LockStatusControl_PrivilegeStatusControl	(LCDB.unLockStatusControl.stcField.u1PrivilegeStatusControl)  /*@bf@*/
#define LCDB_LockStatusControl_FreezeStatusControl	(LCDB.unLockStatusControl.stcField.u1FreezeStatusControl)  /*@bf@*/
#define LCDB_LOCKSTATUSCONTROL_LOCKSTATUSCONTROL	LCDB_LockStatusControl_LockStatusControl  /*@bf2@*/
#define LCDB_LOCKSTATUSCONTROL_PRIVILEGESTATUSCONTROL	LCDB_LockStatusControl_PrivilegeStatusControl  /*@bf2@*/
#define LCDB_LOCKSTATUSCONTROL_FREEZESTATUSCONTROL	LCDB_LockStatusControl_FreezeStatusControl  /*@bf2@*/

typedef struct stc_lcdb_lockstatuscontrol_field{
    uint_io32_t		u1LockStatusControl:1;
    uint_io32_t		:3;
    uint_io32_t		u1PrivilegeStatusControl:1;
    uint_io32_t		:3;
    uint_io32_t		u1FreezeStatusControl:1;
    uint_io32_t		:23;
}stc_lcdb_lockstatuscontrol_field_t;

typedef union un_lcdb_lockstatuscontrol{
    uint_io32_t		u32Register;
    stc_lcdb_lockstatuscontrol_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockstatuscontrol_t;

/* SequencerConfig */
#define LCDB_SequencerConfig	(LCDB.unSequencerConfig.u32Register)  /*@rg@*/
#define LCDB_SEQUENCERCONFIG	(LCDB_SequencerConfig)  /*@rg2@*/
#define LCDB_SequencerConfig_InstructionTimeout	(LCDB.unSequencerConfig.stcField.u31InstructionTimeout)  /*@bf@*/
#define LCDB_SequencerConfig_InstructionTimeoutEnable	(LCDB.unSequencerConfig.stcField.u1InstructionTimeoutEnable)  /*@bf@*/
#define LCDB_SEQUENCERCONFIG_INSTRUCTIONTIMEOUT	LCDB_SequencerConfig_InstructionTimeout  /*@bf2@*/
#define LCDB_SEQUENCERCONFIG_INSTRUCTIONTIMEOUTENABLE	LCDB_SequencerConfig_InstructionTimeoutEnable  /*@bf2@*/

typedef struct stc_lcdb_sequencerconfig_field{
    uint_io32_t		u31InstructionTimeout:31;
    uint_io32_t		u1InstructionTimeoutEnable:1;
}stc_lcdb_sequencerconfig_field_t;

typedef union un_lcdb_sequencerconfig{
    uint_io32_t		u32Register;
    stc_lcdb_sequencerconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_sequencerconfig_t;

/* InstructionFifoConfig */
#define LCDB_InstructionFifoConfig	(LCDB.unInstructionFifoConfig.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFOCONFIG	(LCDB_InstructionFifoConfig)  /*@rg2@*/
#define LCDB_InstructionFifoConfig_InstrThresholdLow	(LCDB.unInstructionFifoConfig.stcField.u6InstrThresholdLow)  /*@bf@*/
#define LCDB_InstructionFifoConfig_InstrThresholdHigh	(LCDB.unInstructionFifoConfig.stcField.u6InstrThresholdHigh)  /*@bf@*/
#define LCDB_InstructionFifoConfig_InstrThresholdTrigger	(LCDB.unInstructionFifoConfig.stcField.u2InstrThresholdTrigger)  /*@bf@*/
#define LCDB_INSTRUCTIONFIFOCONFIG_INSTRTHRESHOLDLOW	LCDB_InstructionFifoConfig_InstrThresholdLow  /*@bf2@*/
#define LCDB_INSTRUCTIONFIFOCONFIG_INSTRTHRESHOLDHIGH	LCDB_InstructionFifoConfig_InstrThresholdHigh  /*@bf2@*/
#define LCDB_INSTRUCTIONFIFOCONFIG_INSTRTHRESHOLDTRIGGER	LCDB_InstructionFifoConfig_InstrThresholdTrigger  /*@bf2@*/

typedef struct stc_lcdb_instructionfifoconfig_field{
    uint_io32_t		u6InstrThresholdLow:6;
    uint_io32_t		:2;
    uint_io32_t		u6InstrThresholdHigh:6;
    uint_io32_t		:2;
    uint_io32_t		u2InstrThresholdTrigger:2;
    uint_io32_t		:14;
}stc_lcdb_instructionfifoconfig_field_t;

typedef union un_lcdb_instructionfifoconfig{
    uint_io32_t		u32Register;
    stc_lcdb_instructionfifoconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_instructionfifoconfig_t;

/* ReceptionFifoConfig */
#define LCDB_ReceptionFifoConfig	(LCDB.unReceptionFifoConfig.u32Register)  /*@rg@*/
#define LCDB_RECEPTIONFIFOCONFIG	(LCDB_ReceptionFifoConfig)  /*@rg2@*/
#define LCDB_ReceptionFifoConfig_RxThresholdLow	(LCDB.unReceptionFifoConfig.stcField.u5RxThresholdLow)  /*@bf@*/
#define LCDB_ReceptionFifoConfig_RxThresholdHigh	(LCDB.unReceptionFifoConfig.stcField.u5RxThresholdHigh)  /*@bf@*/
#define LCDB_ReceptionFifoConfig_RxThresholdTrigger	(LCDB.unReceptionFifoConfig.stcField.u2RxThresholdTrigger)  /*@bf@*/
#define LCDB_RECEPTIONFIFOCONFIG_RXTHRESHOLDLOW	LCDB_ReceptionFifoConfig_RxThresholdLow  /*@bf2@*/
#define LCDB_RECEPTIONFIFOCONFIG_RXTHRESHOLDHIGH	LCDB_ReceptionFifoConfig_RxThresholdHigh  /*@bf2@*/
#define LCDB_RECEPTIONFIFOCONFIG_RXTHRESHOLDTRIGGER	LCDB_ReceptionFifoConfig_RxThresholdTrigger  /*@bf2@*/

typedef struct stc_lcdb_receptionfifoconfig_field{
    uint_io32_t		u5RxThresholdLow:5;
    uint_io32_t		:3;
    uint_io32_t		u5RxThresholdHigh:5;
    uint_io32_t		:3;
    uint_io32_t		u2RxThresholdTrigger:2;
    uint_io32_t		:14;
}stc_lcdb_receptionfifoconfig_field_t;

typedef union un_lcdb_receptionfifoconfig{
    uint_io32_t		u32Register;
    stc_lcdb_receptionfifoconfig_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_receptionfifoconfig_t;

/* SoftwareReset */
#define LCDB_SoftwareReset	(LCDB.unSoftwareReset.u32Register)  /*@rg@*/
#define LCDB_SOFTWARERESET	(LCDB_SoftwareReset)  /*@rg2@*/
#define LCDB_SoftwareReset_SoftwareReset	(LCDB.unSoftwareReset.stcField.u1SoftwareReset)  /*@bf@*/
#define LCDB_SOFTWARERESET_SOFTWARERESET	LCDB_SoftwareReset_SoftwareReset  /*@bf2@*/

typedef struct stc_lcdb_softwarereset_field{
    uint_io32_t		u1SoftwareReset:1;
    uint_io32_t		:31;
}stc_lcdb_softwarereset_field_t;

typedef union un_lcdb_softwarereset{
    uint_io32_t		u32Register;
    stc_lcdb_softwarereset_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_softwarereset_t;

/* RxFifoControl */
#define LCDB_RxFifoControl	(LCDB.unRxFifoControl.u32Register)  /*@rg@*/
#define LCDB_RXFIFOCONTROL	(LCDB_RxFifoControl)  /*@rg2@*/
#define LCDB_RxFifoControl_RxClear	(LCDB.unRxFifoControl.stcField.u1RxClear)  /*@bf@*/
#define LCDB_RXFIFOCONTROL_RXCLEAR	LCDB_RxFifoControl_RxClear  /*@bf2@*/

typedef struct stc_lcdb_rxfifocontrol_field{
    uint_io32_t		u1RxClear:1;
    uint_io32_t		:31;
}stc_lcdb_rxfifocontrol_field_t;

typedef union un_lcdb_rxfifocontrol{
    uint_io32_t		u32Register;
    stc_lcdb_rxfifocontrol_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_rxfifocontrol_t;

/* SequencerSync */
#define LCDB_SequencerSync	(LCDB.unSequencerSync.u32Register)  /*@rg@*/
#define LCDB_SEQUENCERSYNC	(LCDB_SequencerSync)  /*@rg2@*/
#define LCDB_SequencerSync_SequencerAck	(LCDB.unSequencerSync.stcField.u1SequencerAck)  /*@bf@*/
#define LCDB_SEQUENCERSYNC_SEQUENCERACK	LCDB_SequencerSync_SequencerAck  /*@bf2@*/

typedef struct stc_lcdb_sequencersync_field{
    uint_io32_t		u1SequencerAck:1;
    uint_io32_t		:31;
}stc_lcdb_sequencersync_field_t;

typedef union un_lcdb_sequencersync{
    uint_io32_t		u32Register;
    stc_lcdb_sequencersync_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_sequencersync_t;

/* SequencerStatus */
#define LCDB_SequencerStatus	(LCDB.unSequencerStatus.u32Register)  /*@rg@*/
#define LCDB_SEQUENCERSTATUS	(LCDB_SequencerStatus)  /*@rg2@*/
#define LCDB_SequencerStatus_OperationState	(LCDB.unSequencerStatus.stcField.u2OperationState)  /*@bf@*/
#define LCDB_SequencerStatus_WaitAck	(LCDB.unSequencerStatus.stcField.u1WaitAck)  /*@bf@*/
#define LCDB_SequencerStatus_ErrorCode	(LCDB.unSequencerStatus.stcField.u4ErrorCode)  /*@bf@*/
#define LCDB_SequencerStatus_InstructionCounter	(LCDB.unSequencerStatus.stcField.u6InstructionCounter)  /*@bf@*/
#define LCDB_SequencerStatus_InstructionRegister	(LCDB.unSequencerStatus.au8Byte[2])  /*@bfbyte@*/
#define LCDB_SequencerStatus_IrisInterfaceStatus	(LCDB.unSequencerStatus.stcField.u2IrisInterfaceStatus)  /*@bf@*/
#define LCDB_SequencerStatus_LcdInterfaceState	(LCDB.unSequencerStatus.stcField.u1LcdInterfaceState)  /*@bf@*/
#define LCDB_SEQUENCERSTATUS_OPERATIONSTATE	LCDB_SequencerStatus_OperationState  /*@bf2@*/
#define LCDB_SEQUENCERSTATUS_WAITACK	LCDB_SequencerStatus_WaitAck  /*@bf2@*/
#define LCDB_SEQUENCERSTATUS_ERRORCODE	LCDB_SequencerStatus_ErrorCode  /*@bf2@*/
#define LCDB_SEQUENCERSTATUS_INSTRUCTIONCOUNTER	LCDB_SequencerStatus_InstructionCounter  /*@bf2@*/
#define LCDB_SEQUENCERSTATUS_INSTRUCTIONREGISTER	LCDB_SequencerStatus_InstructionRegister  /*@bf2@*/
#define LCDB_SEQUENCERSTATUS_IRISINTERFACESTATUS	LCDB_SequencerStatus_IrisInterfaceStatus  /*@bf2@*/
#define LCDB_SEQUENCERSTATUS_LCDINTERFACESTATE	LCDB_SequencerStatus_LcdInterfaceState  /*@bf2@*/

typedef struct stc_lcdb_sequencerstatus_field{
    uint_io32_t		u2OperationState:2;
    uint_io32_t		u1WaitAck:1;
    uint_io32_t		:1;
    uint_io32_t		u4ErrorCode:4;
    uint_io32_t		u6InstructionCounter:6;
    uint_io32_t		:2;
    uint_io32_t		u8InstructionRegister:8;
    uint_io32_t		u2IrisInterfaceStatus:2;
    uint_io32_t		:2;
    uint_io32_t		u1LcdInterfaceState:1;
    uint_io32_t		:3;
}stc_lcdb_sequencerstatus_field_t;

typedef union un_lcdb_sequencerstatus{
    uint_io32_t		u32Register;
    stc_lcdb_sequencerstatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_sequencerstatus_t;

/* FifoStatus */
#define LCDB_FifoStatus	(LCDB.unFifoStatus.u32Register)  /*@rg@*/
#define LCDB_FIFOSTATUS	(LCDB_FifoStatus)  /*@rg2@*/
#define LCDB_FifoStatus_InstrSpace	(LCDB.unFifoStatus.stcField.u6InstrSpace)  /*@bf@*/
#define LCDB_FifoStatus_InstrEmpty	(LCDB.unFifoStatus.stcField.u1InstrEmpty)  /*@bf@*/
#define LCDB_FifoStatus_InstrFull	(LCDB.unFifoStatus.stcField.u1InstrFull)  /*@bf@*/
#define LCDB_FifoStatus_RxLevel	(LCDB.unFifoStatus.stcField.u5RxLevel)  /*@bf@*/
#define LCDB_FifoStatus_RxEmpty	(LCDB.unFifoStatus.stcField.u1RxEmpty)  /*@bf@*/
#define LCDB_FifoStatus_RxFull	(LCDB.unFifoStatus.stcField.u1RxFull)  /*@bf@*/
#define LCDB_FIFOSTATUS_INSTRSPACE	LCDB_FifoStatus_InstrSpace  /*@bf2@*/
#define LCDB_FIFOSTATUS_INSTREMPTY	LCDB_FifoStatus_InstrEmpty  /*@bf2@*/
#define LCDB_FIFOSTATUS_INSTRFULL	LCDB_FifoStatus_InstrFull  /*@bf2@*/
#define LCDB_FIFOSTATUS_RXLEVEL	LCDB_FifoStatus_RxLevel  /*@bf2@*/
#define LCDB_FIFOSTATUS_RXEMPTY	LCDB_FifoStatus_RxEmpty  /*@bf2@*/
#define LCDB_FIFOSTATUS_RXFULL	LCDB_FifoStatus_RxFull  /*@bf2@*/

typedef struct stc_lcdb_fifostatus_field{
    uint_io32_t		u6InstrSpace:6;
    uint_io32_t		:2;
    uint_io32_t		u1InstrEmpty:1;
    uint_io32_t		:3;
    uint_io32_t		u1InstrFull:1;
    uint_io32_t		:3;
    uint_io32_t		u5RxLevel:5;
    uint_io32_t		:3;
    uint_io32_t		u1RxEmpty:1;
    uint_io32_t		:3;
    uint_io32_t		u1RxFull:1;
    uint_io32_t		:3;
}stc_lcdb_fifostatus_field_t;

typedef union un_lcdb_fifostatus{
    uint_io32_t		u32Register;
    stc_lcdb_fifostatus_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_fifostatus_t;

/* LockUnlockFifo */
#define LCDB_LockUnlockFifo	(LCDB.unLockUnlockFifo.u32Register)  /*@rg@*/
#define LCDB_LOCKUNLOCKFIFO	(LCDB_LockUnlockFifo)  /*@rg2@*/
#define LCDB_LockUnlockFifo_LockUnlockFifo	LCDB_LockUnlockFifo  /*@bfrg@*/
#define LCDB_LOCKUNLOCKFIFO_LOCKUNLOCKFIFO	LCDB_LockUnlockFifo_LockUnlockFifo  /*@bf2@*/

typedef union un_lcdb_lockunlockfifo{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockunlockfifo_t;

/* LockStatusFifo */
#define LCDB_LockStatusFifo	(LCDB.unLockStatusFifo.u32Register)  /*@rg@*/
#define LCDB_LOCKSTATUSFIFO	(LCDB_LockStatusFifo)  /*@rg2@*/
#define LCDB_LockStatusFifo_LockStatusFifo	(LCDB.unLockStatusFifo.stcField.u1LockStatusFifo)  /*@bf@*/
#define LCDB_LockStatusFifo_PrivilegeStatusFifo	(LCDB.unLockStatusFifo.stcField.u1PrivilegeStatusFifo)  /*@bf@*/
#define LCDB_LockStatusFifo_FreezeStatusFifo	(LCDB.unLockStatusFifo.stcField.u1FreezeStatusFifo)  /*@bf@*/
#define LCDB_LOCKSTATUSFIFO_LOCKSTATUSFIFO	LCDB_LockStatusFifo_LockStatusFifo  /*@bf2@*/
#define LCDB_LOCKSTATUSFIFO_PRIVILEGESTATUSFIFO	LCDB_LockStatusFifo_PrivilegeStatusFifo  /*@bf2@*/
#define LCDB_LOCKSTATUSFIFO_FREEZESTATUSFIFO	LCDB_LockStatusFifo_FreezeStatusFifo  /*@bf2@*/

typedef struct stc_lcdb_lockstatusfifo_field{
    uint_io32_t		u1LockStatusFifo:1;
    uint_io32_t		:3;
    uint_io32_t		u1PrivilegeStatusFifo:1;
    uint_io32_t		:3;
    uint_io32_t		u1FreezeStatusFifo:1;
    uint_io32_t		:23;
}stc_lcdb_lockstatusfifo_field_t;

typedef union un_lcdb_lockstatusfifo{
    uint_io32_t		u32Register;
    stc_lcdb_lockstatusfifo_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_lockstatusfifo_t;

/* InstructionFifo[0-31] */
#define LCDB_InstructionFifo0	(LCDB.unInstructionFifo0.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO0	(LCDB_InstructionFifo0)  /*@rg2@*/
#define LCDB_InstructionFifo0_Instruction	LCDB_InstructionFifo0  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO0_INSTRUCTION	LCDB_InstructionFifo0_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo1	(LCDB.unInstructionFifo1.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO1	(LCDB_InstructionFifo1)  /*@rg2@*/
#define LCDB_InstructionFifo1_Instruction	LCDB_InstructionFifo1  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO1_INSTRUCTION	LCDB_InstructionFifo1_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo2	(LCDB.unInstructionFifo2.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO2	(LCDB_InstructionFifo2)  /*@rg2@*/
#define LCDB_InstructionFifo2_Instruction	LCDB_InstructionFifo2  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO2_INSTRUCTION	LCDB_InstructionFifo2_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo3	(LCDB.unInstructionFifo3.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO3	(LCDB_InstructionFifo3)  /*@rg2@*/
#define LCDB_InstructionFifo3_Instruction	LCDB_InstructionFifo3  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO3_INSTRUCTION	LCDB_InstructionFifo3_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo4	(LCDB.unInstructionFifo4.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO4	(LCDB_InstructionFifo4)  /*@rg2@*/
#define LCDB_InstructionFifo4_Instruction	LCDB_InstructionFifo4  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO4_INSTRUCTION	LCDB_InstructionFifo4_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo5	(LCDB.unInstructionFifo5.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO5	(LCDB_InstructionFifo5)  /*@rg2@*/
#define LCDB_InstructionFifo5_Instruction	LCDB_InstructionFifo5  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO5_INSTRUCTION	LCDB_InstructionFifo5_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo6	(LCDB.unInstructionFifo6.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO6	(LCDB_InstructionFifo6)  /*@rg2@*/
#define LCDB_InstructionFifo6_Instruction	LCDB_InstructionFifo6  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO6_INSTRUCTION	LCDB_InstructionFifo6_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo7	(LCDB.unInstructionFifo7.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO7	(LCDB_InstructionFifo7)  /*@rg2@*/
#define LCDB_InstructionFifo7_Instruction	LCDB_InstructionFifo7  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO7_INSTRUCTION	LCDB_InstructionFifo7_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo8	(LCDB.unInstructionFifo8.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO8	(LCDB_InstructionFifo8)  /*@rg2@*/
#define LCDB_InstructionFifo8_Instruction	LCDB_InstructionFifo8  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO8_INSTRUCTION	LCDB_InstructionFifo8_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo9	(LCDB.unInstructionFifo9.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO9	(LCDB_InstructionFifo9)  /*@rg2@*/
#define LCDB_InstructionFifo9_Instruction	LCDB_InstructionFifo9  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO9_INSTRUCTION	LCDB_InstructionFifo9_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo10	(LCDB.unInstructionFifo10.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO10	(LCDB_InstructionFifo10)  /*@rg2@*/
#define LCDB_InstructionFifo10_Instruction	LCDB_InstructionFifo10  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO10_INSTRUCTION	LCDB_InstructionFifo10_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo11	(LCDB.unInstructionFifo11.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO11	(LCDB_InstructionFifo11)  /*@rg2@*/
#define LCDB_InstructionFifo11_Instruction	LCDB_InstructionFifo11  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO11_INSTRUCTION	LCDB_InstructionFifo11_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo12	(LCDB.unInstructionFifo12.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO12	(LCDB_InstructionFifo12)  /*@rg2@*/
#define LCDB_InstructionFifo12_Instruction	LCDB_InstructionFifo12  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO12_INSTRUCTION	LCDB_InstructionFifo12_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo13	(LCDB.unInstructionFifo13.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO13	(LCDB_InstructionFifo13)  /*@rg2@*/
#define LCDB_InstructionFifo13_Instruction	LCDB_InstructionFifo13  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO13_INSTRUCTION	LCDB_InstructionFifo13_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo14	(LCDB.unInstructionFifo14.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO14	(LCDB_InstructionFifo14)  /*@rg2@*/
#define LCDB_InstructionFifo14_Instruction	LCDB_InstructionFifo14  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO14_INSTRUCTION	LCDB_InstructionFifo14_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo15	(LCDB.unInstructionFifo15.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO15	(LCDB_InstructionFifo15)  /*@rg2@*/
#define LCDB_InstructionFifo15_Instruction	LCDB_InstructionFifo15  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO15_INSTRUCTION	LCDB_InstructionFifo15_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo16	(LCDB.unInstructionFifo16.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO16	(LCDB_InstructionFifo16)  /*@rg2@*/
#define LCDB_InstructionFifo16_Instruction	LCDB_InstructionFifo16  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO16_INSTRUCTION	LCDB_InstructionFifo16_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo17	(LCDB.unInstructionFifo17.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO17	(LCDB_InstructionFifo17)  /*@rg2@*/
#define LCDB_InstructionFifo17_Instruction	LCDB_InstructionFifo17  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO17_INSTRUCTION	LCDB_InstructionFifo17_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo18	(LCDB.unInstructionFifo18.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO18	(LCDB_InstructionFifo18)  /*@rg2@*/
#define LCDB_InstructionFifo18_Instruction	LCDB_InstructionFifo18  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO18_INSTRUCTION	LCDB_InstructionFifo18_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo19	(LCDB.unInstructionFifo19.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO19	(LCDB_InstructionFifo19)  /*@rg2@*/
#define LCDB_InstructionFifo19_Instruction	LCDB_InstructionFifo19  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO19_INSTRUCTION	LCDB_InstructionFifo19_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo20	(LCDB.unInstructionFifo20.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO20	(LCDB_InstructionFifo20)  /*@rg2@*/
#define LCDB_InstructionFifo20_Instruction	LCDB_InstructionFifo20  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO20_INSTRUCTION	LCDB_InstructionFifo20_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo21	(LCDB.unInstructionFifo21.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO21	(LCDB_InstructionFifo21)  /*@rg2@*/
#define LCDB_InstructionFifo21_Instruction	LCDB_InstructionFifo21  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO21_INSTRUCTION	LCDB_InstructionFifo21_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo22	(LCDB.unInstructionFifo22.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO22	(LCDB_InstructionFifo22)  /*@rg2@*/
#define LCDB_InstructionFifo22_Instruction	LCDB_InstructionFifo22  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO22_INSTRUCTION	LCDB_InstructionFifo22_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo23	(LCDB.unInstructionFifo23.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO23	(LCDB_InstructionFifo23)  /*@rg2@*/
#define LCDB_InstructionFifo23_Instruction	LCDB_InstructionFifo23  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO23_INSTRUCTION	LCDB_InstructionFifo23_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo24	(LCDB.unInstructionFifo24.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO24	(LCDB_InstructionFifo24)  /*@rg2@*/
#define LCDB_InstructionFifo24_Instruction	LCDB_InstructionFifo24  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO24_INSTRUCTION	LCDB_InstructionFifo24_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo25	(LCDB.unInstructionFifo25.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO25	(LCDB_InstructionFifo25)  /*@rg2@*/
#define LCDB_InstructionFifo25_Instruction	LCDB_InstructionFifo25  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO25_INSTRUCTION	LCDB_InstructionFifo25_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo26	(LCDB.unInstructionFifo26.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO26	(LCDB_InstructionFifo26)  /*@rg2@*/
#define LCDB_InstructionFifo26_Instruction	LCDB_InstructionFifo26  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO26_INSTRUCTION	LCDB_InstructionFifo26_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo27	(LCDB.unInstructionFifo27.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO27	(LCDB_InstructionFifo27)  /*@rg2@*/
#define LCDB_InstructionFifo27_Instruction	LCDB_InstructionFifo27  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO27_INSTRUCTION	LCDB_InstructionFifo27_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo28	(LCDB.unInstructionFifo28.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO28	(LCDB_InstructionFifo28)  /*@rg2@*/
#define LCDB_InstructionFifo28_Instruction	LCDB_InstructionFifo28  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO28_INSTRUCTION	LCDB_InstructionFifo28_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo29	(LCDB.unInstructionFifo29.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO29	(LCDB_InstructionFifo29)  /*@rg2@*/
#define LCDB_InstructionFifo29_Instruction	LCDB_InstructionFifo29  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO29_INSTRUCTION	LCDB_InstructionFifo29_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo30	(LCDB.unInstructionFifo30.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO30	(LCDB_InstructionFifo30)  /*@rg2@*/
#define LCDB_InstructionFifo30_Instruction	LCDB_InstructionFifo30  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO30_INSTRUCTION	LCDB_InstructionFifo30_Instruction  /*@bf2@*/

#define LCDB_InstructionFifo31	(LCDB.unInstructionFifo31.u32Register)  /*@rg@*/
#define LCDB_INSTRUCTIONFIFO31	(LCDB_InstructionFifo31)  /*@rg2@*/
#define LCDB_InstructionFifo31_Instruction	LCDB_InstructionFifo31  /*@bfrg@*/
#define LCDB_INSTRUCTIONFIFO31_INSTRUCTION	LCDB_InstructionFifo31_Instruction  /*@bf2@*/

typedef union un_lcdb_instructionfifon{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_instructionfifon_t;

/* RxFifo[0-15] */
#define LCDB_RxFifo0	(LCDB.unRxFifo0.u32Register)  /*@rg@*/
#define LCDB_RXFIFO0	(LCDB_RxFifo0)  /*@rg2@*/
#define LCDB_RxFifo0_RxEntry	(LCDB.unRxFifo0.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO0_RXENTRY	LCDB_RxFifo0_RxEntry  /*@bf2@*/

#define LCDB_RxFifo1	(LCDB.unRxFifo1.u32Register)  /*@rg@*/
#define LCDB_RXFIFO1	(LCDB_RxFifo1)  /*@rg2@*/
#define LCDB_RxFifo1_RxEntry	(LCDB.unRxFifo1.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO1_RXENTRY	LCDB_RxFifo1_RxEntry  /*@bf2@*/

#define LCDB_RxFifo2	(LCDB.unRxFifo2.u32Register)  /*@rg@*/
#define LCDB_RXFIFO2	(LCDB_RxFifo2)  /*@rg2@*/
#define LCDB_RxFifo2_RxEntry	(LCDB.unRxFifo2.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO2_RXENTRY	LCDB_RxFifo2_RxEntry  /*@bf2@*/

#define LCDB_RxFifo3	(LCDB.unRxFifo3.u32Register)  /*@rg@*/
#define LCDB_RXFIFO3	(LCDB_RxFifo3)  /*@rg2@*/
#define LCDB_RxFifo3_RxEntry	(LCDB.unRxFifo3.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO3_RXENTRY	LCDB_RxFifo3_RxEntry  /*@bf2@*/

#define LCDB_RxFifo4	(LCDB.unRxFifo4.u32Register)  /*@rg@*/
#define LCDB_RXFIFO4	(LCDB_RxFifo4)  /*@rg2@*/
#define LCDB_RxFifo4_RxEntry	(LCDB.unRxFifo4.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO4_RXENTRY	LCDB_RxFifo4_RxEntry  /*@bf2@*/

#define LCDB_RxFifo5	(LCDB.unRxFifo5.u32Register)  /*@rg@*/
#define LCDB_RXFIFO5	(LCDB_RxFifo5)  /*@rg2@*/
#define LCDB_RxFifo5_RxEntry	(LCDB.unRxFifo5.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO5_RXENTRY	LCDB_RxFifo5_RxEntry  /*@bf2@*/

#define LCDB_RxFifo6	(LCDB.unRxFifo6.u32Register)  /*@rg@*/
#define LCDB_RXFIFO6	(LCDB_RxFifo6)  /*@rg2@*/
#define LCDB_RxFifo6_RxEntry	(LCDB.unRxFifo6.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO6_RXENTRY	LCDB_RxFifo6_RxEntry  /*@bf2@*/

#define LCDB_RxFifo7	(LCDB.unRxFifo7.u32Register)  /*@rg@*/
#define LCDB_RXFIFO7	(LCDB_RxFifo7)  /*@rg2@*/
#define LCDB_RxFifo7_RxEntry	(LCDB.unRxFifo7.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO7_RXENTRY	LCDB_RxFifo7_RxEntry  /*@bf2@*/

#define LCDB_RxFifo8	(LCDB.unRxFifo8.u32Register)  /*@rg@*/
#define LCDB_RXFIFO8	(LCDB_RxFifo8)  /*@rg2@*/
#define LCDB_RxFifo8_RxEntry	(LCDB.unRxFifo8.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO8_RXENTRY	LCDB_RxFifo8_RxEntry  /*@bf2@*/

#define LCDB_RxFifo9	(LCDB.unRxFifo9.u32Register)  /*@rg@*/
#define LCDB_RXFIFO9	(LCDB_RxFifo9)  /*@rg2@*/
#define LCDB_RxFifo9_RxEntry	(LCDB.unRxFifo9.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO9_RXENTRY	LCDB_RxFifo9_RxEntry  /*@bf2@*/

#define LCDB_RxFifo10	(LCDB.unRxFifo10.u32Register)  /*@rg@*/
#define LCDB_RXFIFO10	(LCDB_RxFifo10)  /*@rg2@*/
#define LCDB_RxFifo10_RxEntry	(LCDB.unRxFifo10.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO10_RXENTRY	LCDB_RxFifo10_RxEntry  /*@bf2@*/

#define LCDB_RxFifo11	(LCDB.unRxFifo11.u32Register)  /*@rg@*/
#define LCDB_RXFIFO11	(LCDB_RxFifo11)  /*@rg2@*/
#define LCDB_RxFifo11_RxEntry	(LCDB.unRxFifo11.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO11_RXENTRY	LCDB_RxFifo11_RxEntry  /*@bf2@*/

#define LCDB_RxFifo12	(LCDB.unRxFifo12.u32Register)  /*@rg@*/
#define LCDB_RXFIFO12	(LCDB_RxFifo12)  /*@rg2@*/
#define LCDB_RxFifo12_RxEntry	(LCDB.unRxFifo12.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO12_RXENTRY	LCDB_RxFifo12_RxEntry  /*@bf2@*/

#define LCDB_RxFifo13	(LCDB.unRxFifo13.u32Register)  /*@rg@*/
#define LCDB_RXFIFO13	(LCDB_RxFifo13)  /*@rg2@*/
#define LCDB_RxFifo13_RxEntry	(LCDB.unRxFifo13.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO13_RXENTRY	LCDB_RxFifo13_RxEntry  /*@bf2@*/

#define LCDB_RxFifo14	(LCDB.unRxFifo14.u32Register)  /*@rg@*/
#define LCDB_RXFIFO14	(LCDB_RxFifo14)  /*@rg2@*/
#define LCDB_RxFifo14_RxEntry	(LCDB.unRxFifo14.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO14_RXENTRY	LCDB_RxFifo14_RxEntry  /*@bf2@*/

#define LCDB_RxFifo15	(LCDB.unRxFifo15.u32Register)  /*@rg@*/
#define LCDB_RXFIFO15	(LCDB_RxFifo15)  /*@rg2@*/
#define LCDB_RxFifo15_RxEntry	(LCDB.unRxFifo15.stcField.u18RxEntry)  /*@bf@*/
#define LCDB_RXFIFO15_RXENTRY	LCDB_RxFifo15_RxEntry  /*@bf2@*/

typedef struct stc_lcdb_rxfifon_field{
    uint_io32_t		u18RxEntry:18;
    uint_io32_t		:14;
}stc_lcdb_rxfifon_field_t;

typedef union un_lcdb_rxfifon{
    uint_io32_t		u32Register;
    stc_lcdb_rxfifon_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_lcdb_rxfifon_t;


typedef struct stc_lcdb{
    un_lcdb_lockunlocklcd_t	unLockUnlockLcd;	/* 0x00000000 */
    un_lcdb_lockstatuslcd_t	unLockStatusLcd;	/* 0x00000004 */
    un_lcdb_interfaceconfig_t	unInterfaceConfig;	/* 0x00000008 */
    un_lcdb_writetimingconfig_t	unWriteTimingConfig;	/* 0x0000000C */
    un_lcdb_readtimingconfig_t	unReadTimingConfig;	/* 0x00000010 */
    un_lcdb_commandtransfermapping0_t	unCommandTransferMapping0;	/* 0x00000014 */
    un_lcdb_commandtransfermapping1_t	unCommandTransferMapping1;	/* 0x00000018 */
    un_lcdb_commandtransfermapping2_t	unCommandTransferMapping2;	/* 0x0000001C */
    un_lcdb_datatransfermapping0_t	unDataTransferMapping0;	/* 0x00000020 */
    un_lcdb_datatransfermapping1_t	unDataTransferMapping1;	/* 0x00000024 */
    un_lcdb_datatransfermapping2_t	unDataTransferMapping2;	/* 0x00000028 */
    un_lcdb_colorcomponentbits_t	unColorComponentBits;	/* 0x0000002C */
    un_lcdb_colorcomponentshift_t	unColorComponentShift;	/* 0x00000030 */
    un_lcdb_destinationattributes_t	unDestinationAttributes;	/* 0x00000034 */
    uint_io8_t	au8Reserved0[8];	/* 0x00000038 */
    un_lcdb_lockunlockcontrol_t	unLockUnlockControl;	/* 0x00000040 */
    un_lcdb_lockstatuscontrol_t	unLockStatusControl;	/* 0x00000044 */
    un_lcdb_sequencerconfig_t	unSequencerConfig;	/* 0x00000048 */
    un_lcdb_instructionfifoconfig_t	unInstructionFifoConfig;	/* 0x0000004C */
    un_lcdb_receptionfifoconfig_t	unReceptionFifoConfig;	/* 0x00000050 */
    un_lcdb_softwarereset_t	unSoftwareReset;	/* 0x00000054 */
    un_lcdb_rxfifocontrol_t	unRxFifoControl;	/* 0x00000058 */
    un_lcdb_sequencersync_t	unSequencerSync;	/* 0x0000005C */
    un_lcdb_sequencerstatus_t	unSequencerStatus;	/* 0x00000060 */
    un_lcdb_fifostatus_t	unFifoStatus;	/* 0x00000064 */
    uint_io8_t	au8Reserved1[24];	/* 0x00000068 */
    un_lcdb_lockunlockfifo_t	unLockUnlockFifo;	/* 0x00000080 */
    un_lcdb_lockstatusfifo_t	unLockStatusFifo;	/* 0x00000084 */
    uint_io8_t	au8Reserved2[120];	/* 0x00000088 */
    un_lcdb_instructionfifon_t	unInstructionFifo0;	/* 0x00000100 */
    un_lcdb_instructionfifon_t	unInstructionFifo1;	/* 0x00000104 */
    un_lcdb_instructionfifon_t	unInstructionFifo2;	/* 0x00000108 */
    un_lcdb_instructionfifon_t	unInstructionFifo3;	/* 0x0000010C */
    un_lcdb_instructionfifon_t	unInstructionFifo4;	/* 0x00000110 */
    un_lcdb_instructionfifon_t	unInstructionFifo5;	/* 0x00000114 */
    un_lcdb_instructionfifon_t	unInstructionFifo6;	/* 0x00000118 */
    un_lcdb_instructionfifon_t	unInstructionFifo7;	/* 0x0000011C */
    un_lcdb_instructionfifon_t	unInstructionFifo8;	/* 0x00000120 */
    un_lcdb_instructionfifon_t	unInstructionFifo9;	/* 0x00000124 */
    un_lcdb_instructionfifon_t	unInstructionFifo10;	/* 0x00000128 */
    un_lcdb_instructionfifon_t	unInstructionFifo11;	/* 0x0000012C */
    un_lcdb_instructionfifon_t	unInstructionFifo12;	/* 0x00000130 */
    un_lcdb_instructionfifon_t	unInstructionFifo13;	/* 0x00000134 */
    un_lcdb_instructionfifon_t	unInstructionFifo14;	/* 0x00000138 */
    un_lcdb_instructionfifon_t	unInstructionFifo15;	/* 0x0000013C */
    un_lcdb_instructionfifon_t	unInstructionFifo16;	/* 0x00000140 */
    un_lcdb_instructionfifon_t	unInstructionFifo17;	/* 0x00000144 */
    un_lcdb_instructionfifon_t	unInstructionFifo18;	/* 0x00000148 */
    un_lcdb_instructionfifon_t	unInstructionFifo19;	/* 0x0000014C */
    un_lcdb_instructionfifon_t	unInstructionFifo20;	/* 0x00000150 */
    un_lcdb_instructionfifon_t	unInstructionFifo21;	/* 0x00000154 */
    un_lcdb_instructionfifon_t	unInstructionFifo22;	/* 0x00000158 */
    un_lcdb_instructionfifon_t	unInstructionFifo23;	/* 0x0000015C */
    un_lcdb_instructionfifon_t	unInstructionFifo24;	/* 0x00000160 */
    un_lcdb_instructionfifon_t	unInstructionFifo25;	/* 0x00000164 */
    un_lcdb_instructionfifon_t	unInstructionFifo26;	/* 0x00000168 */
    un_lcdb_instructionfifon_t	unInstructionFifo27;	/* 0x0000016C */
    un_lcdb_instructionfifon_t	unInstructionFifo28;	/* 0x00000170 */
    un_lcdb_instructionfifon_t	unInstructionFifo29;	/* 0x00000174 */
    un_lcdb_instructionfifon_t	unInstructionFifo30;	/* 0x00000178 */
    un_lcdb_instructionfifon_t	unInstructionFifo31;	/* 0x0000017C */
    uint_io8_t	au8Reserved3[128];	/* 0x00000180 */
    un_lcdb_rxfifon_t	unRxFifo0;	/* 0x00000200 */
    un_lcdb_rxfifon_t	unRxFifo1;	/* 0x00000204 */
    un_lcdb_rxfifon_t	unRxFifo2;	/* 0x00000208 */
    un_lcdb_rxfifon_t	unRxFifo3;	/* 0x0000020C */
    un_lcdb_rxfifon_t	unRxFifo4;	/* 0x00000210 */
    un_lcdb_rxfifon_t	unRxFifo5;	/* 0x00000214 */
    un_lcdb_rxfifon_t	unRxFifo6;	/* 0x00000218 */
    un_lcdb_rxfifon_t	unRxFifo7;	/* 0x0000021C */
    un_lcdb_rxfifon_t	unRxFifo8;	/* 0x00000220 */
    un_lcdb_rxfifon_t	unRxFifo9;	/* 0x00000224 */
    un_lcdb_rxfifon_t	unRxFifo10;	/* 0x00000228 */
    un_lcdb_rxfifon_t	unRxFifo11;	/* 0x0000022C */
    un_lcdb_rxfifon_t	unRxFifo12;	/* 0x00000230 */
    un_lcdb_rxfifon_t	unRxFifo13;	/* 0x00000234 */
    un_lcdb_rxfifon_t	unRxFifo14;	/* 0x00000238 */
    un_lcdb_rxfifon_t	unRxFifo15;	/* 0x0000023C */
    uint_io8_t	au8Reserved4[1472];	/* 0x00000240 */
}stc_lcdb_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_lcdb_t	stcLCDB;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 2048(0x800) bytes */


#endif /* __S6J3360_LCDB_H */
