/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_MFS_CSIO_H
#define __S6J3360_MFS_CSIO_H

#include "s6j3360io_basetypes.h"

/* CPG_MFS[00-11]_CSIO base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CPG_MFS00_CSIO	stcCPG_MFS_CSIO[0]
#define CPG_MFS01_CSIO	stcCPG_MFS_CSIO[1]
#define CPG_MFS02_CSIO	stcCPG_MFS_CSIO[2]
#define CPG_MFS03_CSIO	stcCPG_MFS_CSIO[3]
#define CPG_MFS04_CSIO	stcCPG_MFS_CSIO[4]
#define CPG_MFS05_CSIO	stcCPG_MFS_CSIO[5]
#define CPG_MFS06_CSIO	stcCPG_MFS_CSIO[6]
#define CPG_MFS07_CSIO	stcCPG_MFS_CSIO[7]
#define CPG_MFS08_CSIO	stcCPG_MFS_CSIO[8]
#define CPG_MFS09_CSIO	stcCPG_MFS_CSIO[9]
#define CPG_MFS10_CSIO	stcCPG_MFS_CSIO[10]
#define CPG_MFS11_CSIO	stcCPG_MFS_CSIO[11]
#else /* __IO_DEFINE */
#define CPG_MFS00_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4800000))
#define CPG_MFS01_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4800400))
#define CPG_MFS02_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4800800))
#define CPG_MFS03_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4800C00))
#define CPG_MFS04_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4801000))
#define CPG_MFS05_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4801400))
#define CPG_MFS06_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4801800))
#define CPG_MFS07_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4801C00))
#define CPG_MFS08_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4880000))
#define CPG_MFS09_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4880400))
#define CPG_MFS10_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4880800))
#define CPG_MFS11_CSIO	(*((volatile stc_cpg_mfsn_csio_t*)0xB4880C00))
#endif /* __IO_DEFINE */

/* SMR */
#define CPG_MFS00_CSIO_SMR	(CPG_MFS00_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SMR_SOE	(CPG_MFS00_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS00_CSIO_SMR_SCKE	(CPG_MFS00_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS00_CSIO_SMR_BDS	(CPG_MFS00_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS00_CSIO_SMR_SCINV	(CPG_MFS00_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS00_CSIO_SMR_WUCR	(CPG_MFS00_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS00_CSIO_SMR_MD	(CPG_MFS00_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS01_CSIO_SMR	(CPG_MFS01_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SMR_SOE	(CPG_MFS01_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS01_CSIO_SMR_SCKE	(CPG_MFS01_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS01_CSIO_SMR_BDS	(CPG_MFS01_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS01_CSIO_SMR_SCINV	(CPG_MFS01_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS01_CSIO_SMR_WUCR	(CPG_MFS01_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS01_CSIO_SMR_MD	(CPG_MFS01_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS02_CSIO_SMR	(CPG_MFS02_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SMR_SOE	(CPG_MFS02_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS02_CSIO_SMR_SCKE	(CPG_MFS02_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS02_CSIO_SMR_BDS	(CPG_MFS02_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS02_CSIO_SMR_SCINV	(CPG_MFS02_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS02_CSIO_SMR_WUCR	(CPG_MFS02_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS02_CSIO_SMR_MD	(CPG_MFS02_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS03_CSIO_SMR	(CPG_MFS03_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SMR_SOE	(CPG_MFS03_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS03_CSIO_SMR_SCKE	(CPG_MFS03_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS03_CSIO_SMR_BDS	(CPG_MFS03_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS03_CSIO_SMR_SCINV	(CPG_MFS03_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS03_CSIO_SMR_WUCR	(CPG_MFS03_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS03_CSIO_SMR_MD	(CPG_MFS03_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS04_CSIO_SMR	(CPG_MFS04_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SMR_SOE	(CPG_MFS04_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS04_CSIO_SMR_SCKE	(CPG_MFS04_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS04_CSIO_SMR_BDS	(CPG_MFS04_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS04_CSIO_SMR_SCINV	(CPG_MFS04_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS04_CSIO_SMR_WUCR	(CPG_MFS04_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS04_CSIO_SMR_MD	(CPG_MFS04_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS05_CSIO_SMR	(CPG_MFS05_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SMR_SOE	(CPG_MFS05_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS05_CSIO_SMR_SCKE	(CPG_MFS05_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS05_CSIO_SMR_BDS	(CPG_MFS05_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS05_CSIO_SMR_SCINV	(CPG_MFS05_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS05_CSIO_SMR_WUCR	(CPG_MFS05_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS05_CSIO_SMR_MD	(CPG_MFS05_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS06_CSIO_SMR	(CPG_MFS06_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SMR_SOE	(CPG_MFS06_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS06_CSIO_SMR_SCKE	(CPG_MFS06_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS06_CSIO_SMR_BDS	(CPG_MFS06_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS06_CSIO_SMR_SCINV	(CPG_MFS06_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS06_CSIO_SMR_WUCR	(CPG_MFS06_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS06_CSIO_SMR_MD	(CPG_MFS06_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS07_CSIO_SMR	(CPG_MFS07_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SMR_SOE	(CPG_MFS07_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS07_CSIO_SMR_SCKE	(CPG_MFS07_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS07_CSIO_SMR_BDS	(CPG_MFS07_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS07_CSIO_SMR_SCINV	(CPG_MFS07_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS07_CSIO_SMR_WUCR	(CPG_MFS07_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS07_CSIO_SMR_MD	(CPG_MFS07_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS08_CSIO_SMR	(CPG_MFS08_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SMR_SOE	(CPG_MFS08_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS08_CSIO_SMR_SCKE	(CPG_MFS08_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS08_CSIO_SMR_BDS	(CPG_MFS08_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS08_CSIO_SMR_SCINV	(CPG_MFS08_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS08_CSIO_SMR_WUCR	(CPG_MFS08_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS08_CSIO_SMR_MD	(CPG_MFS08_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS09_CSIO_SMR	(CPG_MFS09_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SMR_SOE	(CPG_MFS09_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS09_CSIO_SMR_SCKE	(CPG_MFS09_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS09_CSIO_SMR_BDS	(CPG_MFS09_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS09_CSIO_SMR_SCINV	(CPG_MFS09_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS09_CSIO_SMR_WUCR	(CPG_MFS09_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS09_CSIO_SMR_MD	(CPG_MFS09_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS10_CSIO_SMR	(CPG_MFS10_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SMR_SOE	(CPG_MFS10_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS10_CSIO_SMR_SCKE	(CPG_MFS10_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS10_CSIO_SMR_BDS	(CPG_MFS10_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS10_CSIO_SMR_SCINV	(CPG_MFS10_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS10_CSIO_SMR_WUCR	(CPG_MFS10_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS10_CSIO_SMR_MD	(CPG_MFS10_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

#define CPG_MFS11_CSIO_SMR	(CPG_MFS11_CSIO.unSMR.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SMR_SOE	(CPG_MFS11_CSIO.unSMR.stcField.u1SOE)  /*@bf@*/
#define CPG_MFS11_CSIO_SMR_SCKE	(CPG_MFS11_CSIO.unSMR.stcField.u1SCKE)  /*@bf@*/
#define CPG_MFS11_CSIO_SMR_BDS	(CPG_MFS11_CSIO.unSMR.stcField.u1BDS)  /*@bf@*/
#define CPG_MFS11_CSIO_SMR_SCINV	(CPG_MFS11_CSIO.unSMR.stcField.u1SCINV)  /*@bf@*/
#define CPG_MFS11_CSIO_SMR_WUCR	(CPG_MFS11_CSIO.unSMR.stcField.u1WUCR)  /*@bf@*/
#define CPG_MFS11_CSIO_SMR_MD	(CPG_MFS11_CSIO.unSMR.stcField.u3MD)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_smr_field{
    uint_io8_t		u1SOE:1;
    uint_io8_t		u1SCKE:1;
    uint_io8_t		u1BDS:1;
    uint_io8_t		u1SCINV:1;
    uint_io8_t		u1WUCR:1;
    uint_io8_t		u3MD:3;
}stc_cpg_mfsn_csio_smr_field_t;

typedef union un_cpg_mfsn_csio_smr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_smr_field_t		stcField;
}un_cpg_mfsn_csio_smr_t;

/* SCR */
#define CPG_MFS00_CSIO_SCR	(CPG_MFS00_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SCR_TXE	(CPG_MFS00_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS00_CSIO_SCR_RXE	(CPG_MFS00_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS00_CSIO_SCR_TBIE	(CPG_MFS00_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS00_CSIO_SCR_TIE	(CPG_MFS00_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS00_CSIO_SCR_RIE	(CPG_MFS00_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS00_CSIO_SCR_SPI	(CPG_MFS00_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS00_CSIO_SCR_MS	(CPG_MFS00_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS00_CSIO_SCR_UPCL	(CPG_MFS00_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS01_CSIO_SCR	(CPG_MFS01_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SCR_TXE	(CPG_MFS01_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS01_CSIO_SCR_RXE	(CPG_MFS01_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS01_CSIO_SCR_TBIE	(CPG_MFS01_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS01_CSIO_SCR_TIE	(CPG_MFS01_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS01_CSIO_SCR_RIE	(CPG_MFS01_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS01_CSIO_SCR_SPI	(CPG_MFS01_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS01_CSIO_SCR_MS	(CPG_MFS01_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS01_CSIO_SCR_UPCL	(CPG_MFS01_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS02_CSIO_SCR	(CPG_MFS02_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SCR_TXE	(CPG_MFS02_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS02_CSIO_SCR_RXE	(CPG_MFS02_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS02_CSIO_SCR_TBIE	(CPG_MFS02_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS02_CSIO_SCR_TIE	(CPG_MFS02_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS02_CSIO_SCR_RIE	(CPG_MFS02_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS02_CSIO_SCR_SPI	(CPG_MFS02_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS02_CSIO_SCR_MS	(CPG_MFS02_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS02_CSIO_SCR_UPCL	(CPG_MFS02_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS03_CSIO_SCR	(CPG_MFS03_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SCR_TXE	(CPG_MFS03_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS03_CSIO_SCR_RXE	(CPG_MFS03_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS03_CSIO_SCR_TBIE	(CPG_MFS03_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS03_CSIO_SCR_TIE	(CPG_MFS03_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS03_CSIO_SCR_RIE	(CPG_MFS03_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS03_CSIO_SCR_SPI	(CPG_MFS03_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS03_CSIO_SCR_MS	(CPG_MFS03_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS03_CSIO_SCR_UPCL	(CPG_MFS03_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS04_CSIO_SCR	(CPG_MFS04_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SCR_TXE	(CPG_MFS04_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS04_CSIO_SCR_RXE	(CPG_MFS04_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS04_CSIO_SCR_TBIE	(CPG_MFS04_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS04_CSIO_SCR_TIE	(CPG_MFS04_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS04_CSIO_SCR_RIE	(CPG_MFS04_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS04_CSIO_SCR_SPI	(CPG_MFS04_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS04_CSIO_SCR_MS	(CPG_MFS04_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS04_CSIO_SCR_UPCL	(CPG_MFS04_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS05_CSIO_SCR	(CPG_MFS05_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SCR_TXE	(CPG_MFS05_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS05_CSIO_SCR_RXE	(CPG_MFS05_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS05_CSIO_SCR_TBIE	(CPG_MFS05_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS05_CSIO_SCR_TIE	(CPG_MFS05_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS05_CSIO_SCR_RIE	(CPG_MFS05_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS05_CSIO_SCR_SPI	(CPG_MFS05_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS05_CSIO_SCR_MS	(CPG_MFS05_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS05_CSIO_SCR_UPCL	(CPG_MFS05_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS06_CSIO_SCR	(CPG_MFS06_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SCR_TXE	(CPG_MFS06_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS06_CSIO_SCR_RXE	(CPG_MFS06_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS06_CSIO_SCR_TBIE	(CPG_MFS06_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS06_CSIO_SCR_TIE	(CPG_MFS06_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS06_CSIO_SCR_RIE	(CPG_MFS06_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS06_CSIO_SCR_SPI	(CPG_MFS06_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS06_CSIO_SCR_MS	(CPG_MFS06_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS06_CSIO_SCR_UPCL	(CPG_MFS06_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS07_CSIO_SCR	(CPG_MFS07_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SCR_TXE	(CPG_MFS07_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS07_CSIO_SCR_RXE	(CPG_MFS07_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS07_CSIO_SCR_TBIE	(CPG_MFS07_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS07_CSIO_SCR_TIE	(CPG_MFS07_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS07_CSIO_SCR_RIE	(CPG_MFS07_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS07_CSIO_SCR_SPI	(CPG_MFS07_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS07_CSIO_SCR_MS	(CPG_MFS07_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS07_CSIO_SCR_UPCL	(CPG_MFS07_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS08_CSIO_SCR	(CPG_MFS08_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SCR_TXE	(CPG_MFS08_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS08_CSIO_SCR_RXE	(CPG_MFS08_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS08_CSIO_SCR_TBIE	(CPG_MFS08_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS08_CSIO_SCR_TIE	(CPG_MFS08_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS08_CSIO_SCR_RIE	(CPG_MFS08_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS08_CSIO_SCR_SPI	(CPG_MFS08_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS08_CSIO_SCR_MS	(CPG_MFS08_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS08_CSIO_SCR_UPCL	(CPG_MFS08_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS09_CSIO_SCR	(CPG_MFS09_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SCR_TXE	(CPG_MFS09_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS09_CSIO_SCR_RXE	(CPG_MFS09_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS09_CSIO_SCR_TBIE	(CPG_MFS09_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS09_CSIO_SCR_TIE	(CPG_MFS09_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS09_CSIO_SCR_RIE	(CPG_MFS09_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS09_CSIO_SCR_SPI	(CPG_MFS09_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS09_CSIO_SCR_MS	(CPG_MFS09_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS09_CSIO_SCR_UPCL	(CPG_MFS09_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS10_CSIO_SCR	(CPG_MFS10_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SCR_TXE	(CPG_MFS10_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS10_CSIO_SCR_RXE	(CPG_MFS10_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS10_CSIO_SCR_TBIE	(CPG_MFS10_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS10_CSIO_SCR_TIE	(CPG_MFS10_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS10_CSIO_SCR_RIE	(CPG_MFS10_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS10_CSIO_SCR_SPI	(CPG_MFS10_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS10_CSIO_SCR_MS	(CPG_MFS10_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS10_CSIO_SCR_UPCL	(CPG_MFS10_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

#define CPG_MFS11_CSIO_SCR	(CPG_MFS11_CSIO.unSCR.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SCR_TXE	(CPG_MFS11_CSIO.unSCR.stcField.u1TXE)  /*@bf@*/
#define CPG_MFS11_CSIO_SCR_RXE	(CPG_MFS11_CSIO.unSCR.stcField.u1RXE)  /*@bf@*/
#define CPG_MFS11_CSIO_SCR_TBIE	(CPG_MFS11_CSIO.unSCR.stcField.u1TBIE)  /*@bf@*/
#define CPG_MFS11_CSIO_SCR_TIE	(CPG_MFS11_CSIO.unSCR.stcField.u1TIE)  /*@bf@*/
#define CPG_MFS11_CSIO_SCR_RIE	(CPG_MFS11_CSIO.unSCR.stcField.u1RIE)  /*@bf@*/
#define CPG_MFS11_CSIO_SCR_SPI	(CPG_MFS11_CSIO.unSCR.stcField.u1SPI)  /*@bf@*/
#define CPG_MFS11_CSIO_SCR_MS	(CPG_MFS11_CSIO.unSCR.stcField.u1MS)  /*@bf@*/
#define CPG_MFS11_CSIO_SCR_UPCL	(CPG_MFS11_CSIO.unSCR.stcField.u1UPCL)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_scr_field{
    uint_io8_t		u1TXE:1;
    uint_io8_t		u1RXE:1;
    uint_io8_t		u1TBIE:1;
    uint_io8_t		u1TIE:1;
    uint_io8_t		u1RIE:1;
    uint_io8_t		u1SPI:1;
    uint_io8_t		u1MS:1;
    uint_io8_t		u1UPCL:1;
}stc_cpg_mfsn_csio_scr_field_t;

typedef union un_cpg_mfsn_csio_scr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_scr_field_t		stcField;
}un_cpg_mfsn_csio_scr_t;

/* ESCR */
#define CPG_MFS00_CSIO_ESCR	(CPG_MFS00_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_ESCR_L2_0	(CPG_MFS00_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS00_CSIO_ESCR_WT	(CPG_MFS00_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS00_CSIO_ESCR_CSFE	(CPG_MFS00_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS00_CSIO_ESCR_L3	(CPG_MFS00_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS00_CSIO_ESCR_SOP	(CPG_MFS00_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS01_CSIO_ESCR	(CPG_MFS01_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_ESCR_L2_0	(CPG_MFS01_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS01_CSIO_ESCR_WT	(CPG_MFS01_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS01_CSIO_ESCR_CSFE	(CPG_MFS01_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS01_CSIO_ESCR_L3	(CPG_MFS01_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS01_CSIO_ESCR_SOP	(CPG_MFS01_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS02_CSIO_ESCR	(CPG_MFS02_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_ESCR_L2_0	(CPG_MFS02_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS02_CSIO_ESCR_WT	(CPG_MFS02_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS02_CSIO_ESCR_CSFE	(CPG_MFS02_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS02_CSIO_ESCR_L3	(CPG_MFS02_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS02_CSIO_ESCR_SOP	(CPG_MFS02_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS03_CSIO_ESCR	(CPG_MFS03_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_ESCR_L2_0	(CPG_MFS03_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS03_CSIO_ESCR_WT	(CPG_MFS03_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS03_CSIO_ESCR_CSFE	(CPG_MFS03_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS03_CSIO_ESCR_L3	(CPG_MFS03_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS03_CSIO_ESCR_SOP	(CPG_MFS03_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS04_CSIO_ESCR	(CPG_MFS04_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_ESCR_L2_0	(CPG_MFS04_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS04_CSIO_ESCR_WT	(CPG_MFS04_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS04_CSIO_ESCR_CSFE	(CPG_MFS04_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS04_CSIO_ESCR_L3	(CPG_MFS04_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS04_CSIO_ESCR_SOP	(CPG_MFS04_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS05_CSIO_ESCR	(CPG_MFS05_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_ESCR_L2_0	(CPG_MFS05_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS05_CSIO_ESCR_WT	(CPG_MFS05_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS05_CSIO_ESCR_CSFE	(CPG_MFS05_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS05_CSIO_ESCR_L3	(CPG_MFS05_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS05_CSIO_ESCR_SOP	(CPG_MFS05_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS06_CSIO_ESCR	(CPG_MFS06_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_ESCR_L2_0	(CPG_MFS06_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS06_CSIO_ESCR_WT	(CPG_MFS06_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS06_CSIO_ESCR_CSFE	(CPG_MFS06_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS06_CSIO_ESCR_L3	(CPG_MFS06_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS06_CSIO_ESCR_SOP	(CPG_MFS06_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS07_CSIO_ESCR	(CPG_MFS07_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_ESCR_L2_0	(CPG_MFS07_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS07_CSIO_ESCR_WT	(CPG_MFS07_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS07_CSIO_ESCR_CSFE	(CPG_MFS07_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS07_CSIO_ESCR_L3	(CPG_MFS07_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS07_CSIO_ESCR_SOP	(CPG_MFS07_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS08_CSIO_ESCR	(CPG_MFS08_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_ESCR_L2_0	(CPG_MFS08_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS08_CSIO_ESCR_WT	(CPG_MFS08_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS08_CSIO_ESCR_CSFE	(CPG_MFS08_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS08_CSIO_ESCR_L3	(CPG_MFS08_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS08_CSIO_ESCR_SOP	(CPG_MFS08_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS09_CSIO_ESCR	(CPG_MFS09_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_ESCR_L2_0	(CPG_MFS09_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS09_CSIO_ESCR_WT	(CPG_MFS09_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS09_CSIO_ESCR_CSFE	(CPG_MFS09_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS09_CSIO_ESCR_L3	(CPG_MFS09_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS09_CSIO_ESCR_SOP	(CPG_MFS09_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS10_CSIO_ESCR	(CPG_MFS10_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_ESCR_L2_0	(CPG_MFS10_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS10_CSIO_ESCR_WT	(CPG_MFS10_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS10_CSIO_ESCR_CSFE	(CPG_MFS10_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS10_CSIO_ESCR_L3	(CPG_MFS10_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS10_CSIO_ESCR_SOP	(CPG_MFS10_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

#define CPG_MFS11_CSIO_ESCR	(CPG_MFS11_CSIO.unESCR.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_ESCR_L2_0	(CPG_MFS11_CSIO.unESCR.stcField.u3L2_0)  /*@bf@*/
#define CPG_MFS11_CSIO_ESCR_WT	(CPG_MFS11_CSIO.unESCR.stcField.u2WT)  /*@bf@*/
#define CPG_MFS11_CSIO_ESCR_CSFE	(CPG_MFS11_CSIO.unESCR.stcField.u1CSFE)  /*@bf@*/
#define CPG_MFS11_CSIO_ESCR_L3	(CPG_MFS11_CSIO.unESCR.stcField.u1L3)  /*@bf@*/
#define CPG_MFS11_CSIO_ESCR_SOP	(CPG_MFS11_CSIO.unESCR.stcField.u1SOP)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_escr_field{
    uint_io8_t		u3L2_0:3;
    uint_io8_t		u2WT:2;
    uint_io8_t		u1CSFE:1;
    uint_io8_t		u1L3:1;
    uint_io8_t		u1SOP:1;
}stc_cpg_mfsn_csio_escr_field_t;

typedef union un_cpg_mfsn_csio_escr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_escr_field_t		stcField;
}un_cpg_mfsn_csio_escr_t;

/* SSR */
#define CPG_MFS00_CSIO_SSR	(CPG_MFS00_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SSR_TBI	(CPG_MFS00_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS00_CSIO_SSR_TDRE	(CPG_MFS00_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS00_CSIO_SSR_RDRF	(CPG_MFS00_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS00_CSIO_SSR_ORE	(CPG_MFS00_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS00_CSIO_SSR_AWC	(CPG_MFS00_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS00_CSIO_SSR_REC	(CPG_MFS00_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS01_CSIO_SSR	(CPG_MFS01_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SSR_TBI	(CPG_MFS01_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS01_CSIO_SSR_TDRE	(CPG_MFS01_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS01_CSIO_SSR_RDRF	(CPG_MFS01_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS01_CSIO_SSR_ORE	(CPG_MFS01_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS01_CSIO_SSR_AWC	(CPG_MFS01_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS01_CSIO_SSR_REC	(CPG_MFS01_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS02_CSIO_SSR	(CPG_MFS02_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SSR_TBI	(CPG_MFS02_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS02_CSIO_SSR_TDRE	(CPG_MFS02_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS02_CSIO_SSR_RDRF	(CPG_MFS02_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS02_CSIO_SSR_ORE	(CPG_MFS02_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS02_CSIO_SSR_AWC	(CPG_MFS02_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS02_CSIO_SSR_REC	(CPG_MFS02_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS03_CSIO_SSR	(CPG_MFS03_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SSR_TBI	(CPG_MFS03_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS03_CSIO_SSR_TDRE	(CPG_MFS03_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS03_CSIO_SSR_RDRF	(CPG_MFS03_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS03_CSIO_SSR_ORE	(CPG_MFS03_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS03_CSIO_SSR_AWC	(CPG_MFS03_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS03_CSIO_SSR_REC	(CPG_MFS03_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS04_CSIO_SSR	(CPG_MFS04_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SSR_TBI	(CPG_MFS04_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS04_CSIO_SSR_TDRE	(CPG_MFS04_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS04_CSIO_SSR_RDRF	(CPG_MFS04_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS04_CSIO_SSR_ORE	(CPG_MFS04_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS04_CSIO_SSR_AWC	(CPG_MFS04_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS04_CSIO_SSR_REC	(CPG_MFS04_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS05_CSIO_SSR	(CPG_MFS05_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SSR_TBI	(CPG_MFS05_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS05_CSIO_SSR_TDRE	(CPG_MFS05_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS05_CSIO_SSR_RDRF	(CPG_MFS05_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS05_CSIO_SSR_ORE	(CPG_MFS05_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS05_CSIO_SSR_AWC	(CPG_MFS05_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS05_CSIO_SSR_REC	(CPG_MFS05_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS06_CSIO_SSR	(CPG_MFS06_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SSR_TBI	(CPG_MFS06_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS06_CSIO_SSR_TDRE	(CPG_MFS06_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS06_CSIO_SSR_RDRF	(CPG_MFS06_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS06_CSIO_SSR_ORE	(CPG_MFS06_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS06_CSIO_SSR_AWC	(CPG_MFS06_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS06_CSIO_SSR_REC	(CPG_MFS06_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS07_CSIO_SSR	(CPG_MFS07_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SSR_TBI	(CPG_MFS07_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS07_CSIO_SSR_TDRE	(CPG_MFS07_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS07_CSIO_SSR_RDRF	(CPG_MFS07_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS07_CSIO_SSR_ORE	(CPG_MFS07_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS07_CSIO_SSR_AWC	(CPG_MFS07_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS07_CSIO_SSR_REC	(CPG_MFS07_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS08_CSIO_SSR	(CPG_MFS08_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SSR_TBI	(CPG_MFS08_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS08_CSIO_SSR_TDRE	(CPG_MFS08_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS08_CSIO_SSR_RDRF	(CPG_MFS08_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS08_CSIO_SSR_ORE	(CPG_MFS08_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS08_CSIO_SSR_AWC	(CPG_MFS08_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS08_CSIO_SSR_REC	(CPG_MFS08_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS09_CSIO_SSR	(CPG_MFS09_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SSR_TBI	(CPG_MFS09_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS09_CSIO_SSR_TDRE	(CPG_MFS09_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS09_CSIO_SSR_RDRF	(CPG_MFS09_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS09_CSIO_SSR_ORE	(CPG_MFS09_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS09_CSIO_SSR_AWC	(CPG_MFS09_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS09_CSIO_SSR_REC	(CPG_MFS09_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS10_CSIO_SSR	(CPG_MFS10_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SSR_TBI	(CPG_MFS10_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS10_CSIO_SSR_TDRE	(CPG_MFS10_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS10_CSIO_SSR_RDRF	(CPG_MFS10_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS10_CSIO_SSR_ORE	(CPG_MFS10_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS10_CSIO_SSR_AWC	(CPG_MFS10_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS10_CSIO_SSR_REC	(CPG_MFS10_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

#define CPG_MFS11_CSIO_SSR	(CPG_MFS11_CSIO.unSSR.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SSR_TBI	(CPG_MFS11_CSIO.unSSR.stcField.u1TBI)  /*@bf@*/
#define CPG_MFS11_CSIO_SSR_TDRE	(CPG_MFS11_CSIO.unSSR.stcField.u1TDRE)  /*@bf@*/
#define CPG_MFS11_CSIO_SSR_RDRF	(CPG_MFS11_CSIO.unSSR.stcField.u1RDRF)  /*@bf@*/
#define CPG_MFS11_CSIO_SSR_ORE	(CPG_MFS11_CSIO.unSSR.stcField.u1ORE)  /*@bf@*/
#define CPG_MFS11_CSIO_SSR_AWC	(CPG_MFS11_CSIO.unSSR.stcField.u1AWC)  /*@bf@*/
#define CPG_MFS11_CSIO_SSR_REC	(CPG_MFS11_CSIO.unSSR.stcField.u1REC)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_ssr_field{
    uint_io8_t		u1TBI:1;
    uint_io8_t		u1TDRE:1;
    uint_io8_t		u1RDRF:1;
    uint_io8_t		u1ORE:1;
    uint_io8_t		u1AWC:1;
    uint_io8_t		:2;
    uint_io8_t		u1REC:1;
}stc_cpg_mfsn_csio_ssr_field_t;

typedef union un_cpg_mfsn_csio_ssr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_ssr_field_t		stcField;
}un_cpg_mfsn_csio_ssr_t;

/* RDR */
#define CPG_MFS00_CSIO_RDR	(CPG_MFS00_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS00_CSIO_TDR	(CPG_MFS00_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS00_CSIO_RDR_L	(CPG_MFS00_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS00_CSIO_TDR_L	(CPG_MFS00_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS00_CSIO_RDR_D	CPG_MFS00_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS00_CSIO_TDR_D	CPG_MFS00_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS01_CSIO_RDR	(CPG_MFS01_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS01_CSIO_TDR	(CPG_MFS01_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS01_CSIO_RDR_L	(CPG_MFS01_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS01_CSIO_TDR_L	(CPG_MFS01_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS01_CSIO_RDR_D	CPG_MFS01_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS01_CSIO_TDR_D	CPG_MFS01_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS02_CSIO_RDR	(CPG_MFS02_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS02_CSIO_TDR	(CPG_MFS02_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS02_CSIO_RDR_L	(CPG_MFS02_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS02_CSIO_TDR_L	(CPG_MFS02_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS02_CSIO_RDR_D	CPG_MFS02_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS02_CSIO_TDR_D	CPG_MFS02_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS03_CSIO_RDR	(CPG_MFS03_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS03_CSIO_TDR	(CPG_MFS03_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS03_CSIO_RDR_L	(CPG_MFS03_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS03_CSIO_TDR_L	(CPG_MFS03_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS03_CSIO_RDR_D	CPG_MFS03_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS03_CSIO_TDR_D	CPG_MFS03_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS04_CSIO_RDR	(CPG_MFS04_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS04_CSIO_TDR	(CPG_MFS04_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS04_CSIO_RDR_L	(CPG_MFS04_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS04_CSIO_TDR_L	(CPG_MFS04_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS04_CSIO_RDR_D	CPG_MFS04_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS04_CSIO_TDR_D	CPG_MFS04_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS05_CSIO_RDR	(CPG_MFS05_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS05_CSIO_TDR	(CPG_MFS05_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS05_CSIO_RDR_L	(CPG_MFS05_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS05_CSIO_TDR_L	(CPG_MFS05_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS05_CSIO_RDR_D	CPG_MFS05_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS05_CSIO_TDR_D	CPG_MFS05_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS06_CSIO_RDR	(CPG_MFS06_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS06_CSIO_TDR	(CPG_MFS06_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS06_CSIO_RDR_L	(CPG_MFS06_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS06_CSIO_TDR_L	(CPG_MFS06_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS06_CSIO_RDR_D	CPG_MFS06_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS06_CSIO_TDR_D	CPG_MFS06_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS07_CSIO_RDR	(CPG_MFS07_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS07_CSIO_TDR	(CPG_MFS07_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS07_CSIO_RDR_L	(CPG_MFS07_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS07_CSIO_TDR_L	(CPG_MFS07_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS07_CSIO_RDR_D	CPG_MFS07_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS07_CSIO_TDR_D	CPG_MFS07_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS08_CSIO_RDR	(CPG_MFS08_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS08_CSIO_TDR	(CPG_MFS08_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS08_CSIO_RDR_L	(CPG_MFS08_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS08_CSIO_TDR_L	(CPG_MFS08_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS08_CSIO_RDR_D	CPG_MFS08_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS08_CSIO_TDR_D	CPG_MFS08_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS09_CSIO_RDR	(CPG_MFS09_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS09_CSIO_TDR	(CPG_MFS09_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS09_CSIO_RDR_L	(CPG_MFS09_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS09_CSIO_TDR_L	(CPG_MFS09_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS09_CSIO_RDR_D	CPG_MFS09_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS09_CSIO_TDR_D	CPG_MFS09_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS10_CSIO_RDR	(CPG_MFS10_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS10_CSIO_TDR	(CPG_MFS10_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS10_CSIO_RDR_L	(CPG_MFS10_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS10_CSIO_TDR_L	(CPG_MFS10_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS10_CSIO_RDR_D	CPG_MFS10_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS10_CSIO_TDR_D	CPG_MFS10_CSIO_RDR_D  /*@bf2@*/

#define CPG_MFS11_CSIO_RDR	(CPG_MFS11_CSIO.unRDR.u32Register)  /*@rg@*/
#define CPG_MFS11_CSIO_TDR	(CPG_MFS11_CSIO_RDR)  /*@rg2@*/
#define CPG_MFS11_CSIO_RDR_L	(CPG_MFS11_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS11_CSIO_TDR_L	(CPG_MFS11_CSIO.unRDR.au16Halfword[0])  /*@arhword@*/
#define CPG_MFS11_CSIO_RDR_D	CPG_MFS11_CSIO_RDR  /*@bfrg@*/
#define CPG_MFS11_CSIO_TDR_D	CPG_MFS11_CSIO_RDR_D  /*@bf2@*/

typedef union un_cpg_mfsn_csio_rdr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_mfsn_csio_rdr_t;

/* SACSR */
#define CPG_MFS00_CSIO_SACSR	(CPG_MFS00_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SACSR_TMRE	(CPG_MFS00_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_TDIV	(CPG_MFS00_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_TRGE	(CPG_MFS00_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_TSYNE	(CPG_MFS00_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_TINTE	(CPG_MFS00_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_TINT	(CPG_MFS00_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_TRG	(CPG_MFS00_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_CSE	(CPG_MFS00_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_CSEIE	(CPG_MFS00_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_TBEEN	(CPG_MFS00_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSR_STST	(CPG_MFS00_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS01_CSIO_SACSR	(CPG_MFS01_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SACSR_TMRE	(CPG_MFS01_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_TDIV	(CPG_MFS01_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_TRGE	(CPG_MFS01_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_TSYNE	(CPG_MFS01_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_TINTE	(CPG_MFS01_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_TINT	(CPG_MFS01_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_TRG	(CPG_MFS01_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_CSE	(CPG_MFS01_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_CSEIE	(CPG_MFS01_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_TBEEN	(CPG_MFS01_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSR_STST	(CPG_MFS01_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS02_CSIO_SACSR	(CPG_MFS02_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SACSR_TMRE	(CPG_MFS02_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_TDIV	(CPG_MFS02_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_TRGE	(CPG_MFS02_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_TSYNE	(CPG_MFS02_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_TINTE	(CPG_MFS02_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_TINT	(CPG_MFS02_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_TRG	(CPG_MFS02_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_CSE	(CPG_MFS02_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_CSEIE	(CPG_MFS02_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_TBEEN	(CPG_MFS02_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSR_STST	(CPG_MFS02_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS03_CSIO_SACSR	(CPG_MFS03_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SACSR_TMRE	(CPG_MFS03_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_TDIV	(CPG_MFS03_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_TRGE	(CPG_MFS03_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_TSYNE	(CPG_MFS03_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_TINTE	(CPG_MFS03_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_TINT	(CPG_MFS03_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_TRG	(CPG_MFS03_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_CSE	(CPG_MFS03_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_CSEIE	(CPG_MFS03_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_TBEEN	(CPG_MFS03_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSR_STST	(CPG_MFS03_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS04_CSIO_SACSR	(CPG_MFS04_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SACSR_TMRE	(CPG_MFS04_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_TDIV	(CPG_MFS04_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_TRGE	(CPG_MFS04_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_TSYNE	(CPG_MFS04_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_TINTE	(CPG_MFS04_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_TINT	(CPG_MFS04_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_TRG	(CPG_MFS04_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_CSE	(CPG_MFS04_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_CSEIE	(CPG_MFS04_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_TBEEN	(CPG_MFS04_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSR_STST	(CPG_MFS04_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS05_CSIO_SACSR	(CPG_MFS05_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SACSR_TMRE	(CPG_MFS05_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_TDIV	(CPG_MFS05_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_TRGE	(CPG_MFS05_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_TSYNE	(CPG_MFS05_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_TINTE	(CPG_MFS05_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_TINT	(CPG_MFS05_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_TRG	(CPG_MFS05_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_CSE	(CPG_MFS05_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_CSEIE	(CPG_MFS05_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_TBEEN	(CPG_MFS05_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSR_STST	(CPG_MFS05_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS06_CSIO_SACSR	(CPG_MFS06_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SACSR_TMRE	(CPG_MFS06_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_TDIV	(CPG_MFS06_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_TRGE	(CPG_MFS06_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_TSYNE	(CPG_MFS06_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_TINTE	(CPG_MFS06_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_TINT	(CPG_MFS06_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_TRG	(CPG_MFS06_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_CSE	(CPG_MFS06_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_CSEIE	(CPG_MFS06_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_TBEEN	(CPG_MFS06_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSR_STST	(CPG_MFS06_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS07_CSIO_SACSR	(CPG_MFS07_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SACSR_TMRE	(CPG_MFS07_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_TDIV	(CPG_MFS07_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_TRGE	(CPG_MFS07_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_TSYNE	(CPG_MFS07_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_TINTE	(CPG_MFS07_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_TINT	(CPG_MFS07_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_TRG	(CPG_MFS07_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_CSE	(CPG_MFS07_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_CSEIE	(CPG_MFS07_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_TBEEN	(CPG_MFS07_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSR_STST	(CPG_MFS07_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS08_CSIO_SACSR	(CPG_MFS08_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SACSR_TMRE	(CPG_MFS08_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_TDIV	(CPG_MFS08_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_TRGE	(CPG_MFS08_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_TSYNE	(CPG_MFS08_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_TINTE	(CPG_MFS08_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_TINT	(CPG_MFS08_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_TRG	(CPG_MFS08_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_CSE	(CPG_MFS08_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_CSEIE	(CPG_MFS08_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_TBEEN	(CPG_MFS08_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSR_STST	(CPG_MFS08_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS09_CSIO_SACSR	(CPG_MFS09_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SACSR_TMRE	(CPG_MFS09_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_TDIV	(CPG_MFS09_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_TRGE	(CPG_MFS09_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_TSYNE	(CPG_MFS09_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_TINTE	(CPG_MFS09_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_TINT	(CPG_MFS09_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_TRG	(CPG_MFS09_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_CSE	(CPG_MFS09_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_CSEIE	(CPG_MFS09_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_TBEEN	(CPG_MFS09_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSR_STST	(CPG_MFS09_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS10_CSIO_SACSR	(CPG_MFS10_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SACSR_TMRE	(CPG_MFS10_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_TDIV	(CPG_MFS10_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_TRGE	(CPG_MFS10_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_TSYNE	(CPG_MFS10_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_TINTE	(CPG_MFS10_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_TINT	(CPG_MFS10_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_TRG	(CPG_MFS10_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_CSE	(CPG_MFS10_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_CSEIE	(CPG_MFS10_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_TBEEN	(CPG_MFS10_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSR_STST	(CPG_MFS10_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

#define CPG_MFS11_CSIO_SACSR	(CPG_MFS11_CSIO.unSACSR.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SACSR_TMRE	(CPG_MFS11_CSIO.unSACSR.stcField.u1TMRE)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_TDIV	(CPG_MFS11_CSIO.unSACSR.stcField.u4TDIV)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_TRGE	(CPG_MFS11_CSIO.unSACSR.stcField.u1TRGE)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_TSYNE	(CPG_MFS11_CSIO.unSACSR.stcField.u1TSYNE)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_TINTE	(CPG_MFS11_CSIO.unSACSR.stcField.u1TINTE)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_TINT	(CPG_MFS11_CSIO.unSACSR.stcField.u1TINT)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_TRG	(CPG_MFS11_CSIO.unSACSR.stcField.u2TRG)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_CSE	(CPG_MFS11_CSIO.unSACSR.stcField.u1CSE)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_CSEIE	(CPG_MFS11_CSIO.unSACSR.stcField.u1CSEIE)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_TBEEN	(CPG_MFS11_CSIO.unSACSR.stcField.u1TBEEN)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSR_STST	(CPG_MFS11_CSIO.unSACSR.stcField.u1STST)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_sacsr_field{
    uint_io16_t		u1TMRE:1;
    uint_io16_t		u4TDIV:4;
    uint_io16_t		u1TRGE:1;
    uint_io16_t		u1TSYNE:1;
    uint_io16_t		u1TINTE:1;
    uint_io16_t		u1TINT:1;
    uint_io16_t		u2TRG:2;
    uint_io16_t		u1CSE:1;
    uint_io16_t		u1CSEIE:1;
    uint_io16_t		u1TBEEN:1;
    uint_io16_t		:1;
    uint_io16_t		u1STST:1;
}stc_cpg_mfsn_csio_sacsr_field_t;

typedef union un_cpg_mfsn_csio_sacsr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_csio_sacsr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_sacsr_t;

/* STMR */
#define CPG_MFS00_CSIO_STMR	(CPG_MFS00_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_STMR_TM	CPG_MFS00_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS01_CSIO_STMR	(CPG_MFS01_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_STMR_TM	CPG_MFS01_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS02_CSIO_STMR	(CPG_MFS02_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_STMR_TM	CPG_MFS02_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS03_CSIO_STMR	(CPG_MFS03_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_STMR_TM	CPG_MFS03_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS04_CSIO_STMR	(CPG_MFS04_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_STMR_TM	CPG_MFS04_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS05_CSIO_STMR	(CPG_MFS05_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_STMR_TM	CPG_MFS05_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS06_CSIO_STMR	(CPG_MFS06_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_STMR_TM	CPG_MFS06_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS07_CSIO_STMR	(CPG_MFS07_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_STMR_TM	CPG_MFS07_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS08_CSIO_STMR	(CPG_MFS08_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_STMR_TM	CPG_MFS08_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS09_CSIO_STMR	(CPG_MFS09_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_STMR_TM	CPG_MFS09_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS10_CSIO_STMR	(CPG_MFS10_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_STMR_TM	CPG_MFS10_CSIO_STMR  /*@bfrg@*/

#define CPG_MFS11_CSIO_STMR	(CPG_MFS11_CSIO.unSTMR.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_STMR_TM	CPG_MFS11_CSIO_STMR  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_stmr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_stmr_t;

/* STMCR */
#define CPG_MFS00_CSIO_STMCR	(CPG_MFS00_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_STMCR_TC	CPG_MFS00_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS01_CSIO_STMCR	(CPG_MFS01_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_STMCR_TC	CPG_MFS01_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS02_CSIO_STMCR	(CPG_MFS02_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_STMCR_TC	CPG_MFS02_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS03_CSIO_STMCR	(CPG_MFS03_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_STMCR_TC	CPG_MFS03_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS04_CSIO_STMCR	(CPG_MFS04_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_STMCR_TC	CPG_MFS04_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS05_CSIO_STMCR	(CPG_MFS05_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_STMCR_TC	CPG_MFS05_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS06_CSIO_STMCR	(CPG_MFS06_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_STMCR_TC	CPG_MFS06_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS07_CSIO_STMCR	(CPG_MFS07_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_STMCR_TC	CPG_MFS07_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS08_CSIO_STMCR	(CPG_MFS08_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_STMCR_TC	CPG_MFS08_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS09_CSIO_STMCR	(CPG_MFS09_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_STMCR_TC	CPG_MFS09_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS10_CSIO_STMCR	(CPG_MFS10_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_STMCR_TC	CPG_MFS10_CSIO_STMCR  /*@bfrg@*/

#define CPG_MFS11_CSIO_STMCR	(CPG_MFS11_CSIO.unSTMCR.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_STMCR_TC	CPG_MFS11_CSIO_STMCR  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_stmcr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_stmcr_t;

/* SCSCR */
#define CPG_MFS00_CSIO_SCSCR	(CPG_MFS00_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SCSCR_CSOE	(CPG_MFS00_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_CSEN0	(CPG_MFS00_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_CSEN1	(CPG_MFS00_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_CSEN2	(CPG_MFS00_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_CSEN3	(CPG_MFS00_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_CSLVL	(CPG_MFS00_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_CDIV	(CPG_MFS00_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_SCAM	(CPG_MFS00_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_SCD	(CPG_MFS00_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_SED	(CPG_MFS00_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSCR_SST	(CPG_MFS00_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS01_CSIO_SCSCR	(CPG_MFS01_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SCSCR_CSOE	(CPG_MFS01_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_CSEN0	(CPG_MFS01_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_CSEN1	(CPG_MFS01_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_CSEN2	(CPG_MFS01_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_CSEN3	(CPG_MFS01_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_CSLVL	(CPG_MFS01_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_CDIV	(CPG_MFS01_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_SCAM	(CPG_MFS01_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_SCD	(CPG_MFS01_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_SED	(CPG_MFS01_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSCR_SST	(CPG_MFS01_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS02_CSIO_SCSCR	(CPG_MFS02_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SCSCR_CSOE	(CPG_MFS02_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_CSEN0	(CPG_MFS02_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_CSEN1	(CPG_MFS02_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_CSEN2	(CPG_MFS02_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_CSEN3	(CPG_MFS02_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_CSLVL	(CPG_MFS02_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_CDIV	(CPG_MFS02_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_SCAM	(CPG_MFS02_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_SCD	(CPG_MFS02_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_SED	(CPG_MFS02_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSCR_SST	(CPG_MFS02_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS03_CSIO_SCSCR	(CPG_MFS03_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SCSCR_CSOE	(CPG_MFS03_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_CSEN0	(CPG_MFS03_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_CSEN1	(CPG_MFS03_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_CSEN2	(CPG_MFS03_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_CSEN3	(CPG_MFS03_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_CSLVL	(CPG_MFS03_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_CDIV	(CPG_MFS03_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_SCAM	(CPG_MFS03_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_SCD	(CPG_MFS03_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_SED	(CPG_MFS03_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSCR_SST	(CPG_MFS03_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS04_CSIO_SCSCR	(CPG_MFS04_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SCSCR_CSOE	(CPG_MFS04_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_CSEN0	(CPG_MFS04_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_CSEN1	(CPG_MFS04_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_CSEN2	(CPG_MFS04_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_CSEN3	(CPG_MFS04_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_CSLVL	(CPG_MFS04_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_CDIV	(CPG_MFS04_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_SCAM	(CPG_MFS04_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_SCD	(CPG_MFS04_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_SED	(CPG_MFS04_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSCR_SST	(CPG_MFS04_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS05_CSIO_SCSCR	(CPG_MFS05_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SCSCR_CSOE	(CPG_MFS05_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_CSEN0	(CPG_MFS05_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_CSEN1	(CPG_MFS05_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_CSEN2	(CPG_MFS05_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_CSEN3	(CPG_MFS05_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_CSLVL	(CPG_MFS05_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_CDIV	(CPG_MFS05_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_SCAM	(CPG_MFS05_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_SCD	(CPG_MFS05_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_SED	(CPG_MFS05_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSCR_SST	(CPG_MFS05_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS06_CSIO_SCSCR	(CPG_MFS06_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SCSCR_CSOE	(CPG_MFS06_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_CSEN0	(CPG_MFS06_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_CSEN1	(CPG_MFS06_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_CSEN2	(CPG_MFS06_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_CSEN3	(CPG_MFS06_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_CSLVL	(CPG_MFS06_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_CDIV	(CPG_MFS06_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_SCAM	(CPG_MFS06_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_SCD	(CPG_MFS06_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_SED	(CPG_MFS06_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSCR_SST	(CPG_MFS06_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS07_CSIO_SCSCR	(CPG_MFS07_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SCSCR_CSOE	(CPG_MFS07_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_CSEN0	(CPG_MFS07_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_CSEN1	(CPG_MFS07_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_CSEN2	(CPG_MFS07_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_CSEN3	(CPG_MFS07_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_CSLVL	(CPG_MFS07_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_CDIV	(CPG_MFS07_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_SCAM	(CPG_MFS07_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_SCD	(CPG_MFS07_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_SED	(CPG_MFS07_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSCR_SST	(CPG_MFS07_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS08_CSIO_SCSCR	(CPG_MFS08_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SCSCR_CSOE	(CPG_MFS08_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_CSEN0	(CPG_MFS08_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_CSEN1	(CPG_MFS08_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_CSEN2	(CPG_MFS08_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_CSEN3	(CPG_MFS08_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_CSLVL	(CPG_MFS08_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_CDIV	(CPG_MFS08_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_SCAM	(CPG_MFS08_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_SCD	(CPG_MFS08_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_SED	(CPG_MFS08_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSCR_SST	(CPG_MFS08_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS09_CSIO_SCSCR	(CPG_MFS09_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SCSCR_CSOE	(CPG_MFS09_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_CSEN0	(CPG_MFS09_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_CSEN1	(CPG_MFS09_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_CSEN2	(CPG_MFS09_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_CSEN3	(CPG_MFS09_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_CSLVL	(CPG_MFS09_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_CDIV	(CPG_MFS09_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_SCAM	(CPG_MFS09_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_SCD	(CPG_MFS09_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_SED	(CPG_MFS09_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSCR_SST	(CPG_MFS09_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS10_CSIO_SCSCR	(CPG_MFS10_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SCSCR_CSOE	(CPG_MFS10_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_CSEN0	(CPG_MFS10_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_CSEN1	(CPG_MFS10_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_CSEN2	(CPG_MFS10_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_CSEN3	(CPG_MFS10_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_CSLVL	(CPG_MFS10_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_CDIV	(CPG_MFS10_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_SCAM	(CPG_MFS10_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_SCD	(CPG_MFS10_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_SED	(CPG_MFS10_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSCR_SST	(CPG_MFS10_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

#define CPG_MFS11_CSIO_SCSCR	(CPG_MFS11_CSIO.unSCSCR.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SCSCR_CSOE	(CPG_MFS11_CSIO.unSCSCR.stcField.u1CSOE)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_CSEN0	(CPG_MFS11_CSIO.unSCSCR.stcField.u1CSEN0)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_CSEN1	(CPG_MFS11_CSIO.unSCSCR.stcField.u1CSEN1)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_CSEN2	(CPG_MFS11_CSIO.unSCSCR.stcField.u1CSEN2)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_CSEN3	(CPG_MFS11_CSIO.unSCSCR.stcField.u1CSEN3)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_CSLVL	(CPG_MFS11_CSIO.unSCSCR.stcField.u1CSLVL)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_CDIV	(CPG_MFS11_CSIO.unSCSCR.stcField.u3CDIV)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_SCAM	(CPG_MFS11_CSIO.unSCSCR.stcField.u1SCAM)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_SCD	(CPG_MFS11_CSIO.unSCSCR.stcField.u2SCD)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_SED	(CPG_MFS11_CSIO.unSCSCR.stcField.u2SED)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSCR_SST	(CPG_MFS11_CSIO.unSCSCR.stcField.u2SST)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_scscr_field{
    uint_io16_t		u1CSOE:1;
    uint_io16_t		u1CSEN0:1;
    uint_io16_t		u1CSEN1:1;
    uint_io16_t		u1CSEN2:1;
    uint_io16_t		u1CSEN3:1;
    uint_io16_t		u1CSLVL:1;
    uint_io16_t		u3CDIV:3;
    uint_io16_t		u1SCAM:1;
    uint_io16_t		u2SCD:2;
    uint_io16_t		u2SED:2;
    uint_io16_t		u2SST:2;
}stc_cpg_mfsn_csio_scscr_field_t;

typedef union un_cpg_mfsn_csio_scscr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_csio_scscr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_scscr_t;

/* SCSTR0 */
#define CPG_MFS00_CSIO_SCSTR0	(CPG_MFS00_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SCSTR0_CSHD	CPG_MFS00_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS01_CSIO_SCSTR0	(CPG_MFS01_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SCSTR0_CSHD	CPG_MFS01_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS02_CSIO_SCSTR0	(CPG_MFS02_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SCSTR0_CSHD	CPG_MFS02_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS03_CSIO_SCSTR0	(CPG_MFS03_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SCSTR0_CSHD	CPG_MFS03_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS04_CSIO_SCSTR0	(CPG_MFS04_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SCSTR0_CSHD	CPG_MFS04_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS05_CSIO_SCSTR0	(CPG_MFS05_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SCSTR0_CSHD	CPG_MFS05_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS06_CSIO_SCSTR0	(CPG_MFS06_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SCSTR0_CSHD	CPG_MFS06_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS07_CSIO_SCSTR0	(CPG_MFS07_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SCSTR0_CSHD	CPG_MFS07_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS08_CSIO_SCSTR0	(CPG_MFS08_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SCSTR0_CSHD	CPG_MFS08_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS09_CSIO_SCSTR0	(CPG_MFS09_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SCSTR0_CSHD	CPG_MFS09_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS10_CSIO_SCSTR0	(CPG_MFS10_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SCSTR0_CSHD	CPG_MFS10_CSIO_SCSTR0  /*@bfrg@*/

#define CPG_MFS11_CSIO_SCSTR0	(CPG_MFS11_CSIO.unSCSTR0.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SCSTR0_CSHD	CPG_MFS11_CSIO_SCSTR0  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_scstr0{
    uint_io8_t		u8Register;
}un_cpg_mfsn_csio_scstr0_t;

/* SCSTR1 */
#define CPG_MFS00_CSIO_SCSTR1	(CPG_MFS00_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SCSTR1_CSSU	CPG_MFS00_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS01_CSIO_SCSTR1	(CPG_MFS01_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SCSTR1_CSSU	CPG_MFS01_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS02_CSIO_SCSTR1	(CPG_MFS02_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SCSTR1_CSSU	CPG_MFS02_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS03_CSIO_SCSTR1	(CPG_MFS03_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SCSTR1_CSSU	CPG_MFS03_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS04_CSIO_SCSTR1	(CPG_MFS04_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SCSTR1_CSSU	CPG_MFS04_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS05_CSIO_SCSTR1	(CPG_MFS05_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SCSTR1_CSSU	CPG_MFS05_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS06_CSIO_SCSTR1	(CPG_MFS06_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SCSTR1_CSSU	CPG_MFS06_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS07_CSIO_SCSTR1	(CPG_MFS07_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SCSTR1_CSSU	CPG_MFS07_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS08_CSIO_SCSTR1	(CPG_MFS08_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SCSTR1_CSSU	CPG_MFS08_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS09_CSIO_SCSTR1	(CPG_MFS09_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SCSTR1_CSSU	CPG_MFS09_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS10_CSIO_SCSTR1	(CPG_MFS10_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SCSTR1_CSSU	CPG_MFS10_CSIO_SCSTR1  /*@bfrg@*/

#define CPG_MFS11_CSIO_SCSTR1	(CPG_MFS11_CSIO.unSCSTR1.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SCSTR1_CSSU	CPG_MFS11_CSIO_SCSTR1  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_scstr1{
    uint_io8_t		u8Register;
}un_cpg_mfsn_csio_scstr1_t;

/* SCSTR23 */
#define CPG_MFS00_CSIO_SCSTR23	(CPG_MFS00_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SCSTR2	(CPG_MFS00_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS00_CSIO_SCSTR3	(CPG_MFS00_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS00_CSIO_SCSTR23_CSDS	CPG_MFS00_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS01_CSIO_SCSTR23	(CPG_MFS01_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SCSTR2	(CPG_MFS01_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS01_CSIO_SCSTR3	(CPG_MFS01_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS01_CSIO_SCSTR23_CSDS	CPG_MFS01_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS02_CSIO_SCSTR23	(CPG_MFS02_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SCSTR2	(CPG_MFS02_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS02_CSIO_SCSTR3	(CPG_MFS02_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS02_CSIO_SCSTR23_CSDS	CPG_MFS02_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS03_CSIO_SCSTR23	(CPG_MFS03_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SCSTR2	(CPG_MFS03_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS03_CSIO_SCSTR3	(CPG_MFS03_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS03_CSIO_SCSTR23_CSDS	CPG_MFS03_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS04_CSIO_SCSTR23	(CPG_MFS04_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SCSTR2	(CPG_MFS04_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS04_CSIO_SCSTR3	(CPG_MFS04_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS04_CSIO_SCSTR23_CSDS	CPG_MFS04_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS05_CSIO_SCSTR23	(CPG_MFS05_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SCSTR2	(CPG_MFS05_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS05_CSIO_SCSTR3	(CPG_MFS05_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS05_CSIO_SCSTR23_CSDS	CPG_MFS05_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS06_CSIO_SCSTR23	(CPG_MFS06_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SCSTR2	(CPG_MFS06_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS06_CSIO_SCSTR3	(CPG_MFS06_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS06_CSIO_SCSTR23_CSDS	CPG_MFS06_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS07_CSIO_SCSTR23	(CPG_MFS07_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SCSTR2	(CPG_MFS07_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS07_CSIO_SCSTR3	(CPG_MFS07_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS07_CSIO_SCSTR23_CSDS	CPG_MFS07_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS08_CSIO_SCSTR23	(CPG_MFS08_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SCSTR2	(CPG_MFS08_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS08_CSIO_SCSTR3	(CPG_MFS08_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS08_CSIO_SCSTR23_CSDS	CPG_MFS08_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS09_CSIO_SCSTR23	(CPG_MFS09_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SCSTR2	(CPG_MFS09_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS09_CSIO_SCSTR3	(CPG_MFS09_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS09_CSIO_SCSTR23_CSDS	CPG_MFS09_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS10_CSIO_SCSTR23	(CPG_MFS10_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SCSTR2	(CPG_MFS10_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS10_CSIO_SCSTR3	(CPG_MFS10_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS10_CSIO_SCSTR23_CSDS	CPG_MFS10_CSIO_SCSTR23  /*@bfrg@*/

#define CPG_MFS11_CSIO_SCSTR23	(CPG_MFS11_CSIO.unSCSTR23.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SCSTR2	(CPG_MFS11_CSIO.unSCSTR23.au8Byte[0])  /*@arbyte@*/
#define CPG_MFS11_CSIO_SCSTR3	(CPG_MFS11_CSIO.unSCSTR23.au8Byte[1])  /*@arbyte@*/
#define CPG_MFS11_CSIO_SCSTR23_CSDS	CPG_MFS11_CSIO_SCSTR23  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_scstr23{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_scstr23_t;

/* SCSFR0 */
#define CPG_MFS00_CSIO_SCSFR0	(CPG_MFS00_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SCSFR0_CS1L	(CPG_MFS00_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR0_CS1BDS	(CPG_MFS00_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR0_CS1SPI	(CPG_MFS00_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR0_CS1SCINV	(CPG_MFS00_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS00_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS01_CSIO_SCSFR0	(CPG_MFS01_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SCSFR0_CS1L	(CPG_MFS01_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR0_CS1BDS	(CPG_MFS01_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR0_CS1SPI	(CPG_MFS01_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR0_CS1SCINV	(CPG_MFS01_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS01_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS02_CSIO_SCSFR0	(CPG_MFS02_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SCSFR0_CS1L	(CPG_MFS02_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR0_CS1BDS	(CPG_MFS02_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR0_CS1SPI	(CPG_MFS02_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR0_CS1SCINV	(CPG_MFS02_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS02_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS03_CSIO_SCSFR0	(CPG_MFS03_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SCSFR0_CS1L	(CPG_MFS03_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR0_CS1BDS	(CPG_MFS03_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR0_CS1SPI	(CPG_MFS03_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR0_CS1SCINV	(CPG_MFS03_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS03_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS04_CSIO_SCSFR0	(CPG_MFS04_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SCSFR0_CS1L	(CPG_MFS04_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR0_CS1BDS	(CPG_MFS04_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR0_CS1SPI	(CPG_MFS04_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR0_CS1SCINV	(CPG_MFS04_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS04_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS05_CSIO_SCSFR0	(CPG_MFS05_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SCSFR0_CS1L	(CPG_MFS05_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR0_CS1BDS	(CPG_MFS05_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR0_CS1SPI	(CPG_MFS05_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR0_CS1SCINV	(CPG_MFS05_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS05_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS06_CSIO_SCSFR0	(CPG_MFS06_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SCSFR0_CS1L	(CPG_MFS06_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR0_CS1BDS	(CPG_MFS06_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR0_CS1SPI	(CPG_MFS06_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR0_CS1SCINV	(CPG_MFS06_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS06_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS07_CSIO_SCSFR0	(CPG_MFS07_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SCSFR0_CS1L	(CPG_MFS07_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR0_CS1BDS	(CPG_MFS07_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR0_CS1SPI	(CPG_MFS07_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR0_CS1SCINV	(CPG_MFS07_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS07_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS08_CSIO_SCSFR0	(CPG_MFS08_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SCSFR0_CS1L	(CPG_MFS08_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR0_CS1BDS	(CPG_MFS08_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR0_CS1SPI	(CPG_MFS08_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR0_CS1SCINV	(CPG_MFS08_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS08_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS09_CSIO_SCSFR0	(CPG_MFS09_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SCSFR0_CS1L	(CPG_MFS09_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR0_CS1BDS	(CPG_MFS09_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR0_CS1SPI	(CPG_MFS09_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR0_CS1SCINV	(CPG_MFS09_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS09_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS10_CSIO_SCSFR0	(CPG_MFS10_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SCSFR0_CS1L	(CPG_MFS10_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR0_CS1BDS	(CPG_MFS10_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR0_CS1SPI	(CPG_MFS10_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR0_CS1SCINV	(CPG_MFS10_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS10_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

#define CPG_MFS11_CSIO_SCSFR0	(CPG_MFS11_CSIO.unSCSFR0.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SCSFR0_CS1L	(CPG_MFS11_CSIO.unSCSFR0.stcField.u4CS1L)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR0_CS1BDS	(CPG_MFS11_CSIO.unSCSFR0.stcField.u1CS1BDS)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR0_CS1SPI	(CPG_MFS11_CSIO.unSCSFR0.stcField.u1CS1SPI)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR0_CS1SCINV	(CPG_MFS11_CSIO.unSCSFR0.stcField.u1CS1SCINV)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR0_CS1CSLVL	(CPG_MFS11_CSIO.unSCSFR0.stcField.u1CS1CSLVL)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_scsfr0_field{
    uint_io8_t		u4CS1L:4;
    uint_io8_t		u1CS1BDS:1;
    uint_io8_t		u1CS1SPI:1;
    uint_io8_t		u1CS1SCINV:1;
    uint_io8_t		u1CS1CSLVL:1;
}stc_cpg_mfsn_csio_scsfr0_field_t;

typedef union un_cpg_mfsn_csio_scsfr0{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_scsfr0_field_t		stcField;
}un_cpg_mfsn_csio_scsfr0_t;

/* SCSFR1 */
#define CPG_MFS00_CSIO_SCSFR1	(CPG_MFS00_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SCSFR1_CS2L	(CPG_MFS00_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR1_CS2BDS	(CPG_MFS00_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR1_CS2SPI	(CPG_MFS00_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR1_CS2SCINV	(CPG_MFS00_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS00_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS01_CSIO_SCSFR1	(CPG_MFS01_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SCSFR1_CS2L	(CPG_MFS01_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR1_CS2BDS	(CPG_MFS01_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR1_CS2SPI	(CPG_MFS01_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR1_CS2SCINV	(CPG_MFS01_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS01_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS02_CSIO_SCSFR1	(CPG_MFS02_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SCSFR1_CS2L	(CPG_MFS02_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR1_CS2BDS	(CPG_MFS02_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR1_CS2SPI	(CPG_MFS02_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR1_CS2SCINV	(CPG_MFS02_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS02_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS03_CSIO_SCSFR1	(CPG_MFS03_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SCSFR1_CS2L	(CPG_MFS03_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR1_CS2BDS	(CPG_MFS03_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR1_CS2SPI	(CPG_MFS03_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR1_CS2SCINV	(CPG_MFS03_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS03_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS04_CSIO_SCSFR1	(CPG_MFS04_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SCSFR1_CS2L	(CPG_MFS04_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR1_CS2BDS	(CPG_MFS04_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR1_CS2SPI	(CPG_MFS04_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR1_CS2SCINV	(CPG_MFS04_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS04_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS05_CSIO_SCSFR1	(CPG_MFS05_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SCSFR1_CS2L	(CPG_MFS05_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR1_CS2BDS	(CPG_MFS05_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR1_CS2SPI	(CPG_MFS05_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR1_CS2SCINV	(CPG_MFS05_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS05_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS06_CSIO_SCSFR1	(CPG_MFS06_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SCSFR1_CS2L	(CPG_MFS06_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR1_CS2BDS	(CPG_MFS06_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR1_CS2SPI	(CPG_MFS06_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR1_CS2SCINV	(CPG_MFS06_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS06_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS07_CSIO_SCSFR1	(CPG_MFS07_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SCSFR1_CS2L	(CPG_MFS07_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR1_CS2BDS	(CPG_MFS07_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR1_CS2SPI	(CPG_MFS07_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR1_CS2SCINV	(CPG_MFS07_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS07_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS08_CSIO_SCSFR1	(CPG_MFS08_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SCSFR1_CS2L	(CPG_MFS08_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR1_CS2BDS	(CPG_MFS08_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR1_CS2SPI	(CPG_MFS08_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR1_CS2SCINV	(CPG_MFS08_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS08_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS09_CSIO_SCSFR1	(CPG_MFS09_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SCSFR1_CS2L	(CPG_MFS09_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR1_CS2BDS	(CPG_MFS09_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR1_CS2SPI	(CPG_MFS09_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR1_CS2SCINV	(CPG_MFS09_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS09_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS10_CSIO_SCSFR1	(CPG_MFS10_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SCSFR1_CS2L	(CPG_MFS10_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR1_CS2BDS	(CPG_MFS10_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR1_CS2SPI	(CPG_MFS10_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR1_CS2SCINV	(CPG_MFS10_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS10_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

#define CPG_MFS11_CSIO_SCSFR1	(CPG_MFS11_CSIO.unSCSFR1.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SCSFR1_CS2L	(CPG_MFS11_CSIO.unSCSFR1.stcField.u4CS2L)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR1_CS2BDS	(CPG_MFS11_CSIO.unSCSFR1.stcField.u1CS2BDS)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR1_CS2SPI	(CPG_MFS11_CSIO.unSCSFR1.stcField.u1CS2SPI)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR1_CS2SCINV	(CPG_MFS11_CSIO.unSCSFR1.stcField.u1CS2SCINV)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR1_CS2CSLVL	(CPG_MFS11_CSIO.unSCSFR1.stcField.u1CS2CSLVL)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_scsfr1_field{
    uint_io8_t		u4CS2L:4;
    uint_io8_t		u1CS2BDS:1;
    uint_io8_t		u1CS2SPI:1;
    uint_io8_t		u1CS2SCINV:1;
    uint_io8_t		u1CS2CSLVL:1;
}stc_cpg_mfsn_csio_scsfr1_field_t;

typedef union un_cpg_mfsn_csio_scsfr1{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_scsfr1_field_t		stcField;
}un_cpg_mfsn_csio_scsfr1_t;

/* SCSFR2 */
#define CPG_MFS00_CSIO_SCSFR2	(CPG_MFS00_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SCSFR2_CS3L	(CPG_MFS00_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR2_CS3BDS	(CPG_MFS00_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR2_CS3SPI	(CPG_MFS00_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR2_CS3SCINV	(CPG_MFS00_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS00_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS00_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS01_CSIO_SCSFR2	(CPG_MFS01_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SCSFR2_CS3L	(CPG_MFS01_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR2_CS3BDS	(CPG_MFS01_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR2_CS3SPI	(CPG_MFS01_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR2_CS3SCINV	(CPG_MFS01_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS01_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS01_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS02_CSIO_SCSFR2	(CPG_MFS02_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SCSFR2_CS3L	(CPG_MFS02_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR2_CS3BDS	(CPG_MFS02_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR2_CS3SPI	(CPG_MFS02_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR2_CS3SCINV	(CPG_MFS02_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS02_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS02_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS03_CSIO_SCSFR2	(CPG_MFS03_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SCSFR2_CS3L	(CPG_MFS03_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR2_CS3BDS	(CPG_MFS03_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR2_CS3SPI	(CPG_MFS03_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR2_CS3SCINV	(CPG_MFS03_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS03_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS03_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS04_CSIO_SCSFR2	(CPG_MFS04_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SCSFR2_CS3L	(CPG_MFS04_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR2_CS3BDS	(CPG_MFS04_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR2_CS3SPI	(CPG_MFS04_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR2_CS3SCINV	(CPG_MFS04_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS04_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS04_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS05_CSIO_SCSFR2	(CPG_MFS05_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SCSFR2_CS3L	(CPG_MFS05_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR2_CS3BDS	(CPG_MFS05_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR2_CS3SPI	(CPG_MFS05_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR2_CS3SCINV	(CPG_MFS05_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS05_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS05_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS06_CSIO_SCSFR2	(CPG_MFS06_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SCSFR2_CS3L	(CPG_MFS06_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR2_CS3BDS	(CPG_MFS06_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR2_CS3SPI	(CPG_MFS06_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR2_CS3SCINV	(CPG_MFS06_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS06_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS06_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS07_CSIO_SCSFR2	(CPG_MFS07_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SCSFR2_CS3L	(CPG_MFS07_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR2_CS3BDS	(CPG_MFS07_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR2_CS3SPI	(CPG_MFS07_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR2_CS3SCINV	(CPG_MFS07_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS07_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS07_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS08_CSIO_SCSFR2	(CPG_MFS08_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SCSFR2_CS3L	(CPG_MFS08_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR2_CS3BDS	(CPG_MFS08_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR2_CS3SPI	(CPG_MFS08_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR2_CS3SCINV	(CPG_MFS08_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS08_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS08_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS09_CSIO_SCSFR2	(CPG_MFS09_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SCSFR2_CS3L	(CPG_MFS09_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR2_CS3BDS	(CPG_MFS09_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR2_CS3SPI	(CPG_MFS09_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR2_CS3SCINV	(CPG_MFS09_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS09_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS09_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS10_CSIO_SCSFR2	(CPG_MFS10_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SCSFR2_CS3L	(CPG_MFS10_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR2_CS3BDS	(CPG_MFS10_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR2_CS3SPI	(CPG_MFS10_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR2_CS3SCINV	(CPG_MFS10_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS10_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS10_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

#define CPG_MFS11_CSIO_SCSFR2	(CPG_MFS11_CSIO.unSCSFR2.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SCSFR2_CS3L	(CPG_MFS11_CSIO.unSCSFR2.stcField.u4CS3L)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR2_CS3BDS	(CPG_MFS11_CSIO.unSCSFR2.stcField.u1CS3BDS)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR2_CS3SPI	(CPG_MFS11_CSIO.unSCSFR2.stcField.u1CS3SPI)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR2_CS3SCINV	(CPG_MFS11_CSIO.unSCSFR2.stcField.u1CS3SCINV)  /*@bf@*/
#define CPG_MFS11_CSIO_SCSFR2_CS3CSLVL	(CPG_MFS11_CSIO.unSCSFR2.stcField.u1CS3CSLVL)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_scsfr2_field{
    uint_io8_t		u4CS3L:4;
    uint_io8_t		u1CS3BDS:1;
    uint_io8_t		u1CS3SPI:1;
    uint_io8_t		u1CS3SCINV:1;
    uint_io8_t		u1CS3CSLVL:1;
}stc_cpg_mfsn_csio_scsfr2_field_t;

typedef union un_cpg_mfsn_csio_scsfr2{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_scsfr2_field_t		stcField;
}un_cpg_mfsn_csio_scsfr2_t;

/* TBYTE0 */
#define CPG_MFS00_CSIO_TBYTE0	(CPG_MFS00_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_TBYTE0_TBYTE0	CPG_MFS00_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS01_CSIO_TBYTE0	(CPG_MFS01_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_TBYTE0_TBYTE0	CPG_MFS01_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS02_CSIO_TBYTE0	(CPG_MFS02_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_TBYTE0_TBYTE0	CPG_MFS02_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS03_CSIO_TBYTE0	(CPG_MFS03_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_TBYTE0_TBYTE0	CPG_MFS03_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS04_CSIO_TBYTE0	(CPG_MFS04_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_TBYTE0_TBYTE0	CPG_MFS04_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS05_CSIO_TBYTE0	(CPG_MFS05_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_TBYTE0_TBYTE0	CPG_MFS05_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS06_CSIO_TBYTE0	(CPG_MFS06_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_TBYTE0_TBYTE0	CPG_MFS06_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS07_CSIO_TBYTE0	(CPG_MFS07_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_TBYTE0_TBYTE0	CPG_MFS07_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS08_CSIO_TBYTE0	(CPG_MFS08_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_TBYTE0_TBYTE0	CPG_MFS08_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS09_CSIO_TBYTE0	(CPG_MFS09_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_TBYTE0_TBYTE0	CPG_MFS09_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS10_CSIO_TBYTE0	(CPG_MFS10_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_TBYTE0_TBYTE0	CPG_MFS10_CSIO_TBYTE0  /*@bfrg@*/

#define CPG_MFS11_CSIO_TBYTE0	(CPG_MFS11_CSIO.unTBYTE0.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_TBYTE0_TBYTE0	CPG_MFS11_CSIO_TBYTE0  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_tbyte0{
    uint_io8_t		u8Register;
}un_cpg_mfsn_csio_tbyte0_t;

/* TBYTE1 */
#define CPG_MFS00_CSIO_TBYTE1	(CPG_MFS00_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_TBYTE1_TBYTE1	CPG_MFS00_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS01_CSIO_TBYTE1	(CPG_MFS01_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_TBYTE1_TBYTE1	CPG_MFS01_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS02_CSIO_TBYTE1	(CPG_MFS02_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_TBYTE1_TBYTE1	CPG_MFS02_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS03_CSIO_TBYTE1	(CPG_MFS03_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_TBYTE1_TBYTE1	CPG_MFS03_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS04_CSIO_TBYTE1	(CPG_MFS04_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_TBYTE1_TBYTE1	CPG_MFS04_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS05_CSIO_TBYTE1	(CPG_MFS05_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_TBYTE1_TBYTE1	CPG_MFS05_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS06_CSIO_TBYTE1	(CPG_MFS06_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_TBYTE1_TBYTE1	CPG_MFS06_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS07_CSIO_TBYTE1	(CPG_MFS07_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_TBYTE1_TBYTE1	CPG_MFS07_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS08_CSIO_TBYTE1	(CPG_MFS08_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_TBYTE1_TBYTE1	CPG_MFS08_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS09_CSIO_TBYTE1	(CPG_MFS09_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_TBYTE1_TBYTE1	CPG_MFS09_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS10_CSIO_TBYTE1	(CPG_MFS10_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_TBYTE1_TBYTE1	CPG_MFS10_CSIO_TBYTE1  /*@bfrg@*/

#define CPG_MFS11_CSIO_TBYTE1	(CPG_MFS11_CSIO.unTBYTE1.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_TBYTE1_TBYTE1	CPG_MFS11_CSIO_TBYTE1  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_tbyte1{
    uint_io8_t		u8Register;
}un_cpg_mfsn_csio_tbyte1_t;

/* TBYTE2 */
#define CPG_MFS00_CSIO_TBYTE2	(CPG_MFS00_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_TBYTE2_TBYTE2	CPG_MFS00_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS01_CSIO_TBYTE2	(CPG_MFS01_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_TBYTE2_TBYTE2	CPG_MFS01_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS02_CSIO_TBYTE2	(CPG_MFS02_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_TBYTE2_TBYTE2	CPG_MFS02_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS03_CSIO_TBYTE2	(CPG_MFS03_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_TBYTE2_TBYTE2	CPG_MFS03_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS04_CSIO_TBYTE2	(CPG_MFS04_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_TBYTE2_TBYTE2	CPG_MFS04_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS05_CSIO_TBYTE2	(CPG_MFS05_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_TBYTE2_TBYTE2	CPG_MFS05_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS06_CSIO_TBYTE2	(CPG_MFS06_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_TBYTE2_TBYTE2	CPG_MFS06_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS07_CSIO_TBYTE2	(CPG_MFS07_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_TBYTE2_TBYTE2	CPG_MFS07_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS08_CSIO_TBYTE2	(CPG_MFS08_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_TBYTE2_TBYTE2	CPG_MFS08_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS09_CSIO_TBYTE2	(CPG_MFS09_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_TBYTE2_TBYTE2	CPG_MFS09_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS10_CSIO_TBYTE2	(CPG_MFS10_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_TBYTE2_TBYTE2	CPG_MFS10_CSIO_TBYTE2  /*@bfrg@*/

#define CPG_MFS11_CSIO_TBYTE2	(CPG_MFS11_CSIO.unTBYTE2.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_TBYTE2_TBYTE2	CPG_MFS11_CSIO_TBYTE2  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_tbyte2{
    uint_io8_t		u8Register;
}un_cpg_mfsn_csio_tbyte2_t;

/* TBYTE3 */
#define CPG_MFS00_CSIO_TBYTE3	(CPG_MFS00_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_TBYTE3_TBYTE3	CPG_MFS00_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS01_CSIO_TBYTE3	(CPG_MFS01_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_TBYTE3_TBYTE3	CPG_MFS01_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS02_CSIO_TBYTE3	(CPG_MFS02_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_TBYTE3_TBYTE3	CPG_MFS02_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS03_CSIO_TBYTE3	(CPG_MFS03_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_TBYTE3_TBYTE3	CPG_MFS03_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS04_CSIO_TBYTE3	(CPG_MFS04_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_TBYTE3_TBYTE3	CPG_MFS04_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS05_CSIO_TBYTE3	(CPG_MFS05_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_TBYTE3_TBYTE3	CPG_MFS05_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS06_CSIO_TBYTE3	(CPG_MFS06_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_TBYTE3_TBYTE3	CPG_MFS06_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS07_CSIO_TBYTE3	(CPG_MFS07_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_TBYTE3_TBYTE3	CPG_MFS07_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS08_CSIO_TBYTE3	(CPG_MFS08_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_TBYTE3_TBYTE3	CPG_MFS08_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS09_CSIO_TBYTE3	(CPG_MFS09_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_TBYTE3_TBYTE3	CPG_MFS09_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS10_CSIO_TBYTE3	(CPG_MFS10_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_TBYTE3_TBYTE3	CPG_MFS10_CSIO_TBYTE3  /*@bfrg@*/

#define CPG_MFS11_CSIO_TBYTE3	(CPG_MFS11_CSIO.unTBYTE3.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_TBYTE3_TBYTE3	CPG_MFS11_CSIO_TBYTE3  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_tbyte3{
    uint_io8_t		u8Register;
}un_cpg_mfsn_csio_tbyte3_t;

/* BGR */
#define CPG_MFS00_CSIO_BGR	(CPG_MFS00_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_BGR_BGR	(CPG_MFS00_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS01_CSIO_BGR	(CPG_MFS01_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_BGR_BGR	(CPG_MFS01_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS02_CSIO_BGR	(CPG_MFS02_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_BGR_BGR	(CPG_MFS02_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS03_CSIO_BGR	(CPG_MFS03_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_BGR_BGR	(CPG_MFS03_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS04_CSIO_BGR	(CPG_MFS04_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_BGR_BGR	(CPG_MFS04_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS05_CSIO_BGR	(CPG_MFS05_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_BGR_BGR	(CPG_MFS05_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS06_CSIO_BGR	(CPG_MFS06_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_BGR_BGR	(CPG_MFS06_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS07_CSIO_BGR	(CPG_MFS07_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_BGR_BGR	(CPG_MFS07_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS08_CSIO_BGR	(CPG_MFS08_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_BGR_BGR	(CPG_MFS08_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS09_CSIO_BGR	(CPG_MFS09_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_BGR_BGR	(CPG_MFS09_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS10_CSIO_BGR	(CPG_MFS10_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_BGR_BGR	(CPG_MFS10_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

#define CPG_MFS11_CSIO_BGR	(CPG_MFS11_CSIO.unBGR.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_BGR_BGR	(CPG_MFS11_CSIO.unBGR.stcField.u15BGR)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_bgr_field{
    uint_io16_t		u15BGR:15;
    uint_io16_t		:1;
}stc_cpg_mfsn_csio_bgr_field_t;

typedef union un_cpg_mfsn_csio_bgr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_csio_bgr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_bgr_t;

/* FCR0 */
#define CPG_MFS00_CSIO_FCR0	(CPG_MFS00_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_FCR0_FE1	(CPG_MFS00_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0_FE2	(CPG_MFS00_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0_FCL1	(CPG_MFS00_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0_FCL2	(CPG_MFS00_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0_FSET	(CPG_MFS00_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0_FLD	(CPG_MFS00_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0_FLST	(CPG_MFS00_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS01_CSIO_FCR0	(CPG_MFS01_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_FCR0_FE1	(CPG_MFS01_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0_FE2	(CPG_MFS01_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0_FCL1	(CPG_MFS01_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0_FCL2	(CPG_MFS01_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0_FSET	(CPG_MFS01_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0_FLD	(CPG_MFS01_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0_FLST	(CPG_MFS01_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS02_CSIO_FCR0	(CPG_MFS02_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_FCR0_FE1	(CPG_MFS02_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0_FE2	(CPG_MFS02_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0_FCL1	(CPG_MFS02_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0_FCL2	(CPG_MFS02_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0_FSET	(CPG_MFS02_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0_FLD	(CPG_MFS02_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0_FLST	(CPG_MFS02_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS03_CSIO_FCR0	(CPG_MFS03_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_FCR0_FE1	(CPG_MFS03_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0_FE2	(CPG_MFS03_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0_FCL1	(CPG_MFS03_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0_FCL2	(CPG_MFS03_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0_FSET	(CPG_MFS03_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0_FLD	(CPG_MFS03_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0_FLST	(CPG_MFS03_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS04_CSIO_FCR0	(CPG_MFS04_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_FCR0_FE1	(CPG_MFS04_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0_FE2	(CPG_MFS04_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0_FCL1	(CPG_MFS04_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0_FCL2	(CPG_MFS04_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0_FSET	(CPG_MFS04_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0_FLD	(CPG_MFS04_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0_FLST	(CPG_MFS04_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS05_CSIO_FCR0	(CPG_MFS05_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_FCR0_FE1	(CPG_MFS05_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0_FE2	(CPG_MFS05_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0_FCL1	(CPG_MFS05_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0_FCL2	(CPG_MFS05_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0_FSET	(CPG_MFS05_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0_FLD	(CPG_MFS05_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0_FLST	(CPG_MFS05_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS06_CSIO_FCR0	(CPG_MFS06_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_FCR0_FE1	(CPG_MFS06_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0_FE2	(CPG_MFS06_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0_FCL1	(CPG_MFS06_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0_FCL2	(CPG_MFS06_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0_FSET	(CPG_MFS06_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0_FLD	(CPG_MFS06_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0_FLST	(CPG_MFS06_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS07_CSIO_FCR0	(CPG_MFS07_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_FCR0_FE1	(CPG_MFS07_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0_FE2	(CPG_MFS07_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0_FCL1	(CPG_MFS07_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0_FCL2	(CPG_MFS07_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0_FSET	(CPG_MFS07_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0_FLD	(CPG_MFS07_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0_FLST	(CPG_MFS07_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS08_CSIO_FCR0	(CPG_MFS08_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_FCR0_FE1	(CPG_MFS08_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0_FE2	(CPG_MFS08_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0_FCL1	(CPG_MFS08_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0_FCL2	(CPG_MFS08_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0_FSET	(CPG_MFS08_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0_FLD	(CPG_MFS08_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0_FLST	(CPG_MFS08_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS09_CSIO_FCR0	(CPG_MFS09_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_FCR0_FE1	(CPG_MFS09_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0_FE2	(CPG_MFS09_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0_FCL1	(CPG_MFS09_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0_FCL2	(CPG_MFS09_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0_FSET	(CPG_MFS09_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0_FLD	(CPG_MFS09_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0_FLST	(CPG_MFS09_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS10_CSIO_FCR0	(CPG_MFS10_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_FCR0_FE1	(CPG_MFS10_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0_FE2	(CPG_MFS10_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0_FCL1	(CPG_MFS10_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0_FCL2	(CPG_MFS10_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0_FSET	(CPG_MFS10_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0_FLD	(CPG_MFS10_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0_FLST	(CPG_MFS10_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

#define CPG_MFS11_CSIO_FCR0	(CPG_MFS11_CSIO.unFCR0.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_FCR0_FE1	(CPG_MFS11_CSIO.unFCR0.stcField.u1FE1)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0_FE2	(CPG_MFS11_CSIO.unFCR0.stcField.u1FE2)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0_FCL1	(CPG_MFS11_CSIO.unFCR0.stcField.u1FCL1)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0_FCL2	(CPG_MFS11_CSIO.unFCR0.stcField.u1FCL2)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0_FSET	(CPG_MFS11_CSIO.unFCR0.stcField.u1FSET)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0_FLD	(CPG_MFS11_CSIO.unFCR0.stcField.u1FLD)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0_FLST	(CPG_MFS11_CSIO.unFCR0.stcField.u1FLST)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_fcr0_field{
    uint_io8_t		u1FE1:1;
    uint_io8_t		u1FE2:1;
    uint_io8_t		u1FCL1:1;
    uint_io8_t		u1FCL2:1;
    uint_io8_t		u1FSET:1;
    uint_io8_t		u1FLD:1;
    uint_io8_t		u1FLST:1;
    uint_io8_t		:1;
}stc_cpg_mfsn_csio_fcr0_field_t;

typedef union un_cpg_mfsn_csio_fcr0{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_fcr0_field_t		stcField;
}un_cpg_mfsn_csio_fcr0_t;

/* FCR1 */
#define CPG_MFS00_CSIO_FCR1	(CPG_MFS00_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_FCR1_FSEL	(CPG_MFS00_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1_FTIE	(CPG_MFS00_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1_FDRQ	(CPG_MFS00_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1_FRIIE	(CPG_MFS00_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1_FLSTE	(CPG_MFS00_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS01_CSIO_FCR1	(CPG_MFS01_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_FCR1_FSEL	(CPG_MFS01_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1_FTIE	(CPG_MFS01_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1_FDRQ	(CPG_MFS01_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1_FRIIE	(CPG_MFS01_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1_FLSTE	(CPG_MFS01_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS02_CSIO_FCR1	(CPG_MFS02_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_FCR1_FSEL	(CPG_MFS02_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1_FTIE	(CPG_MFS02_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1_FDRQ	(CPG_MFS02_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1_FRIIE	(CPG_MFS02_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1_FLSTE	(CPG_MFS02_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS03_CSIO_FCR1	(CPG_MFS03_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_FCR1_FSEL	(CPG_MFS03_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1_FTIE	(CPG_MFS03_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1_FDRQ	(CPG_MFS03_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1_FRIIE	(CPG_MFS03_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1_FLSTE	(CPG_MFS03_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS04_CSIO_FCR1	(CPG_MFS04_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_FCR1_FSEL	(CPG_MFS04_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1_FTIE	(CPG_MFS04_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1_FDRQ	(CPG_MFS04_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1_FRIIE	(CPG_MFS04_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1_FLSTE	(CPG_MFS04_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS05_CSIO_FCR1	(CPG_MFS05_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_FCR1_FSEL	(CPG_MFS05_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1_FTIE	(CPG_MFS05_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1_FDRQ	(CPG_MFS05_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1_FRIIE	(CPG_MFS05_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1_FLSTE	(CPG_MFS05_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS06_CSIO_FCR1	(CPG_MFS06_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_FCR1_FSEL	(CPG_MFS06_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1_FTIE	(CPG_MFS06_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1_FDRQ	(CPG_MFS06_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1_FRIIE	(CPG_MFS06_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1_FLSTE	(CPG_MFS06_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS07_CSIO_FCR1	(CPG_MFS07_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_FCR1_FSEL	(CPG_MFS07_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1_FTIE	(CPG_MFS07_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1_FDRQ	(CPG_MFS07_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1_FRIIE	(CPG_MFS07_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1_FLSTE	(CPG_MFS07_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS08_CSIO_FCR1	(CPG_MFS08_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_FCR1_FSEL	(CPG_MFS08_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1_FTIE	(CPG_MFS08_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1_FDRQ	(CPG_MFS08_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1_FRIIE	(CPG_MFS08_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1_FLSTE	(CPG_MFS08_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS09_CSIO_FCR1	(CPG_MFS09_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_FCR1_FSEL	(CPG_MFS09_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1_FTIE	(CPG_MFS09_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1_FDRQ	(CPG_MFS09_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1_FRIIE	(CPG_MFS09_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1_FLSTE	(CPG_MFS09_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS10_CSIO_FCR1	(CPG_MFS10_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_FCR1_FSEL	(CPG_MFS10_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1_FTIE	(CPG_MFS10_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1_FDRQ	(CPG_MFS10_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1_FRIIE	(CPG_MFS10_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1_FLSTE	(CPG_MFS10_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

#define CPG_MFS11_CSIO_FCR1	(CPG_MFS11_CSIO.unFCR1.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_FCR1_FSEL	(CPG_MFS11_CSIO.unFCR1.stcField.u1FSEL)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1_FTIE	(CPG_MFS11_CSIO.unFCR1.stcField.u1FTIE)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1_FDRQ	(CPG_MFS11_CSIO.unFCR1.stcField.u1FDRQ)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1_FRIIE	(CPG_MFS11_CSIO.unFCR1.stcField.u1FRIIE)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1_FLSTE	(CPG_MFS11_CSIO.unFCR1.stcField.u1FLSTE)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_fcr1_field{
    uint_io8_t		u1FSEL:1;
    uint_io8_t		u1FTIE:1;
    uint_io8_t		u1FDRQ:1;
    uint_io8_t		u1FRIIE:1;
    uint_io8_t		u1FLSTE:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_csio_fcr1_field_t;

typedef union un_cpg_mfsn_csio_fcr1{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_fcr1_field_t		stcField;
}un_cpg_mfsn_csio_fcr1_t;

/* FBYTE */
#define CPG_MFS00_CSIO_FBYTE	(CPG_MFS00_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_FBYTE_FBYTE1	(CPG_MFS00_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS00_CSIO_FBYTE_FBYTE2	(CPG_MFS00_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS01_CSIO_FBYTE	(CPG_MFS01_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_FBYTE_FBYTE1	(CPG_MFS01_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS01_CSIO_FBYTE_FBYTE2	(CPG_MFS01_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS02_CSIO_FBYTE	(CPG_MFS02_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_FBYTE_FBYTE1	(CPG_MFS02_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS02_CSIO_FBYTE_FBYTE2	(CPG_MFS02_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS03_CSIO_FBYTE	(CPG_MFS03_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_FBYTE_FBYTE1	(CPG_MFS03_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS03_CSIO_FBYTE_FBYTE2	(CPG_MFS03_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS04_CSIO_FBYTE	(CPG_MFS04_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_FBYTE_FBYTE1	(CPG_MFS04_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS04_CSIO_FBYTE_FBYTE2	(CPG_MFS04_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS05_CSIO_FBYTE	(CPG_MFS05_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_FBYTE_FBYTE1	(CPG_MFS05_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS05_CSIO_FBYTE_FBYTE2	(CPG_MFS05_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS06_CSIO_FBYTE	(CPG_MFS06_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_FBYTE_FBYTE1	(CPG_MFS06_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS06_CSIO_FBYTE_FBYTE2	(CPG_MFS06_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS07_CSIO_FBYTE	(CPG_MFS07_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_FBYTE_FBYTE1	(CPG_MFS07_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS07_CSIO_FBYTE_FBYTE2	(CPG_MFS07_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS08_CSIO_FBYTE	(CPG_MFS08_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_FBYTE_FBYTE1	(CPG_MFS08_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS08_CSIO_FBYTE_FBYTE2	(CPG_MFS08_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS09_CSIO_FBYTE	(CPG_MFS09_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_FBYTE_FBYTE1	(CPG_MFS09_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS09_CSIO_FBYTE_FBYTE2	(CPG_MFS09_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS10_CSIO_FBYTE	(CPG_MFS10_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_FBYTE_FBYTE1	(CPG_MFS10_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS10_CSIO_FBYTE_FBYTE2	(CPG_MFS10_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS11_CSIO_FBYTE	(CPG_MFS11_CSIO.unFBYTE.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_FBYTE_FBYTE1	(CPG_MFS11_CSIO.unFBYTE.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS11_CSIO_FBYTE_FBYTE2	(CPG_MFS11_CSIO.unFBYTE.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_mfsn_csio_fbyte_field{
    uint_io16_t		u8FBYTE1:8;
    uint_io16_t		u8FBYTE2:8;
}stc_cpg_mfsn_csio_fbyte_field_t;

typedef union un_cpg_mfsn_csio_fbyte{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_csio_fbyte_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_fbyte_t;

/* FTICR */
#define CPG_MFS00_CSIO_FTICR	(CPG_MFS00_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_FTICR_FTICR1	(CPG_MFS00_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS00_CSIO_FTICR_FTICR2	(CPG_MFS00_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS01_CSIO_FTICR	(CPG_MFS01_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_FTICR_FTICR1	(CPG_MFS01_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS01_CSIO_FTICR_FTICR2	(CPG_MFS01_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS02_CSIO_FTICR	(CPG_MFS02_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_FTICR_FTICR1	(CPG_MFS02_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS02_CSIO_FTICR_FTICR2	(CPG_MFS02_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS03_CSIO_FTICR	(CPG_MFS03_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_FTICR_FTICR1	(CPG_MFS03_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS03_CSIO_FTICR_FTICR2	(CPG_MFS03_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS04_CSIO_FTICR	(CPG_MFS04_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_FTICR_FTICR1	(CPG_MFS04_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS04_CSIO_FTICR_FTICR2	(CPG_MFS04_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS05_CSIO_FTICR	(CPG_MFS05_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_FTICR_FTICR1	(CPG_MFS05_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS05_CSIO_FTICR_FTICR2	(CPG_MFS05_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS06_CSIO_FTICR	(CPG_MFS06_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_FTICR_FTICR1	(CPG_MFS06_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS06_CSIO_FTICR_FTICR2	(CPG_MFS06_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS07_CSIO_FTICR	(CPG_MFS07_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_FTICR_FTICR1	(CPG_MFS07_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS07_CSIO_FTICR_FTICR2	(CPG_MFS07_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS08_CSIO_FTICR	(CPG_MFS08_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_FTICR_FTICR1	(CPG_MFS08_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS08_CSIO_FTICR_FTICR2	(CPG_MFS08_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS09_CSIO_FTICR	(CPG_MFS09_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_FTICR_FTICR1	(CPG_MFS09_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS09_CSIO_FTICR_FTICR2	(CPG_MFS09_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS10_CSIO_FTICR	(CPG_MFS10_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_FTICR_FTICR1	(CPG_MFS10_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS10_CSIO_FTICR_FTICR2	(CPG_MFS10_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

#define CPG_MFS11_CSIO_FTICR	(CPG_MFS11_CSIO.unFTICR.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_FTICR_FTICR1	(CPG_MFS11_CSIO.unFTICR.au8Byte[0])  /*@bfbyte@*/
#define CPG_MFS11_CSIO_FTICR_FTICR2	(CPG_MFS11_CSIO.unFTICR.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_mfsn_csio_fticr_field{
    uint_io16_t		u8FTICR1:8;
    uint_io16_t		u8FTICR2:8;
}stc_cpg_mfsn_csio_fticr_field_t;

typedef union un_cpg_mfsn_csio_fticr{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_csio_fticr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_fticr_t;

/* ECR */
#define CPG_MFS00_CSIO_ECR	(CPG_MFS00_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_ECR_TXBLKEN	(CPG_MFS00_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS00_CSIO_ECR_RXBLKEN	(CPG_MFS00_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS00_CSIO_ECR_TEIE	(CPG_MFS00_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS00_CSIO_ECR_REIE	(CPG_MFS00_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS00_CSIO_ECR_EISEL	(CPG_MFS00_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS01_CSIO_ECR	(CPG_MFS01_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_ECR_TXBLKEN	(CPG_MFS01_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS01_CSIO_ECR_RXBLKEN	(CPG_MFS01_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS01_CSIO_ECR_TEIE	(CPG_MFS01_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS01_CSIO_ECR_REIE	(CPG_MFS01_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS01_CSIO_ECR_EISEL	(CPG_MFS01_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS02_CSIO_ECR	(CPG_MFS02_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_ECR_TXBLKEN	(CPG_MFS02_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS02_CSIO_ECR_RXBLKEN	(CPG_MFS02_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS02_CSIO_ECR_TEIE	(CPG_MFS02_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS02_CSIO_ECR_REIE	(CPG_MFS02_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS02_CSIO_ECR_EISEL	(CPG_MFS02_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS03_CSIO_ECR	(CPG_MFS03_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_ECR_TXBLKEN	(CPG_MFS03_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS03_CSIO_ECR_RXBLKEN	(CPG_MFS03_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS03_CSIO_ECR_TEIE	(CPG_MFS03_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS03_CSIO_ECR_REIE	(CPG_MFS03_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS03_CSIO_ECR_EISEL	(CPG_MFS03_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS04_CSIO_ECR	(CPG_MFS04_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_ECR_TXBLKEN	(CPG_MFS04_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS04_CSIO_ECR_RXBLKEN	(CPG_MFS04_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS04_CSIO_ECR_TEIE	(CPG_MFS04_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS04_CSIO_ECR_REIE	(CPG_MFS04_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS04_CSIO_ECR_EISEL	(CPG_MFS04_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS05_CSIO_ECR	(CPG_MFS05_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_ECR_TXBLKEN	(CPG_MFS05_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS05_CSIO_ECR_RXBLKEN	(CPG_MFS05_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS05_CSIO_ECR_TEIE	(CPG_MFS05_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS05_CSIO_ECR_REIE	(CPG_MFS05_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS05_CSIO_ECR_EISEL	(CPG_MFS05_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS06_CSIO_ECR	(CPG_MFS06_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_ECR_TXBLKEN	(CPG_MFS06_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS06_CSIO_ECR_RXBLKEN	(CPG_MFS06_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS06_CSIO_ECR_TEIE	(CPG_MFS06_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS06_CSIO_ECR_REIE	(CPG_MFS06_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS06_CSIO_ECR_EISEL	(CPG_MFS06_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS07_CSIO_ECR	(CPG_MFS07_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_ECR_TXBLKEN	(CPG_MFS07_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS07_CSIO_ECR_RXBLKEN	(CPG_MFS07_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS07_CSIO_ECR_TEIE	(CPG_MFS07_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS07_CSIO_ECR_REIE	(CPG_MFS07_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS07_CSIO_ECR_EISEL	(CPG_MFS07_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS08_CSIO_ECR	(CPG_MFS08_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_ECR_TXBLKEN	(CPG_MFS08_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS08_CSIO_ECR_RXBLKEN	(CPG_MFS08_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS08_CSIO_ECR_TEIE	(CPG_MFS08_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS08_CSIO_ECR_REIE	(CPG_MFS08_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS08_CSIO_ECR_EISEL	(CPG_MFS08_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS09_CSIO_ECR	(CPG_MFS09_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_ECR_TXBLKEN	(CPG_MFS09_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS09_CSIO_ECR_RXBLKEN	(CPG_MFS09_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS09_CSIO_ECR_TEIE	(CPG_MFS09_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS09_CSIO_ECR_REIE	(CPG_MFS09_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS09_CSIO_ECR_EISEL	(CPG_MFS09_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS10_CSIO_ECR	(CPG_MFS10_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_ECR_TXBLKEN	(CPG_MFS10_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS10_CSIO_ECR_RXBLKEN	(CPG_MFS10_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS10_CSIO_ECR_TEIE	(CPG_MFS10_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS10_CSIO_ECR_REIE	(CPG_MFS10_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS10_CSIO_ECR_EISEL	(CPG_MFS10_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

#define CPG_MFS11_CSIO_ECR	(CPG_MFS11_CSIO.unECR.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_ECR_TXBLKEN	(CPG_MFS11_CSIO.unECR.stcField.u1TXBLKEN)  /*@bf@*/
#define CPG_MFS11_CSIO_ECR_RXBLKEN	(CPG_MFS11_CSIO.unECR.stcField.u1RXBLKEN)  /*@bf@*/
#define CPG_MFS11_CSIO_ECR_TEIE	(CPG_MFS11_CSIO.unECR.stcField.u1TEIE)  /*@bf@*/
#define CPG_MFS11_CSIO_ECR_REIE	(CPG_MFS11_CSIO.unECR.stcField.u1REIE)  /*@bf@*/
#define CPG_MFS11_CSIO_ECR_EISEL	(CPG_MFS11_CSIO.unECR.stcField.u1EISEL)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_ecr_field{
    uint_io8_t		u1TXBLKEN:1;
    uint_io8_t		u1RXBLKEN:1;
    uint_io8_t		u1TEIE:1;
    uint_io8_t		u1REIE:1;
    uint_io8_t		u1EISEL:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_csio_ecr_field_t;

typedef union un_cpg_mfsn_csio_ecr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_ecr_field_t		stcField;
}un_cpg_mfsn_csio_ecr_t;

/* ESR */
#define CPG_MFS00_CSIO_ESR	(CPG_MFS00_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_ESR_TBERR	(CPG_MFS00_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS00_CSIO_ESR_RBERR	(CPG_MFS00_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS00_CSIO_ESR_TXOVR	(CPG_MFS00_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS00_CSIO_ESR_RXUDR	(CPG_MFS00_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS01_CSIO_ESR	(CPG_MFS01_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_ESR_TBERR	(CPG_MFS01_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS01_CSIO_ESR_RBERR	(CPG_MFS01_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS01_CSIO_ESR_TXOVR	(CPG_MFS01_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS01_CSIO_ESR_RXUDR	(CPG_MFS01_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS02_CSIO_ESR	(CPG_MFS02_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_ESR_TBERR	(CPG_MFS02_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS02_CSIO_ESR_RBERR	(CPG_MFS02_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS02_CSIO_ESR_TXOVR	(CPG_MFS02_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS02_CSIO_ESR_RXUDR	(CPG_MFS02_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS03_CSIO_ESR	(CPG_MFS03_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_ESR_TBERR	(CPG_MFS03_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS03_CSIO_ESR_RBERR	(CPG_MFS03_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS03_CSIO_ESR_TXOVR	(CPG_MFS03_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS03_CSIO_ESR_RXUDR	(CPG_MFS03_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS04_CSIO_ESR	(CPG_MFS04_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_ESR_TBERR	(CPG_MFS04_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS04_CSIO_ESR_RBERR	(CPG_MFS04_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS04_CSIO_ESR_TXOVR	(CPG_MFS04_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS04_CSIO_ESR_RXUDR	(CPG_MFS04_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS05_CSIO_ESR	(CPG_MFS05_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_ESR_TBERR	(CPG_MFS05_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS05_CSIO_ESR_RBERR	(CPG_MFS05_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS05_CSIO_ESR_TXOVR	(CPG_MFS05_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS05_CSIO_ESR_RXUDR	(CPG_MFS05_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS06_CSIO_ESR	(CPG_MFS06_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_ESR_TBERR	(CPG_MFS06_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS06_CSIO_ESR_RBERR	(CPG_MFS06_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS06_CSIO_ESR_TXOVR	(CPG_MFS06_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS06_CSIO_ESR_RXUDR	(CPG_MFS06_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS07_CSIO_ESR	(CPG_MFS07_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_ESR_TBERR	(CPG_MFS07_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS07_CSIO_ESR_RBERR	(CPG_MFS07_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS07_CSIO_ESR_TXOVR	(CPG_MFS07_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS07_CSIO_ESR_RXUDR	(CPG_MFS07_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS08_CSIO_ESR	(CPG_MFS08_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_ESR_TBERR	(CPG_MFS08_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS08_CSIO_ESR_RBERR	(CPG_MFS08_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS08_CSIO_ESR_TXOVR	(CPG_MFS08_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS08_CSIO_ESR_RXUDR	(CPG_MFS08_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS09_CSIO_ESR	(CPG_MFS09_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_ESR_TBERR	(CPG_MFS09_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS09_CSIO_ESR_RBERR	(CPG_MFS09_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS09_CSIO_ESR_TXOVR	(CPG_MFS09_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS09_CSIO_ESR_RXUDR	(CPG_MFS09_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS10_CSIO_ESR	(CPG_MFS10_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_ESR_TBERR	(CPG_MFS10_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS10_CSIO_ESR_RBERR	(CPG_MFS10_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS10_CSIO_ESR_TXOVR	(CPG_MFS10_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS10_CSIO_ESR_RXUDR	(CPG_MFS10_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

#define CPG_MFS11_CSIO_ESR	(CPG_MFS11_CSIO.unESR.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_ESR_TBERR	(CPG_MFS11_CSIO.unESR.stcField.u1TBERR)  /*@bf@*/
#define CPG_MFS11_CSIO_ESR_RBERR	(CPG_MFS11_CSIO.unESR.stcField.u1RBERR)  /*@bf@*/
#define CPG_MFS11_CSIO_ESR_TXOVR	(CPG_MFS11_CSIO.unESR.stcField.u1TXOVR)  /*@bf@*/
#define CPG_MFS11_CSIO_ESR_RXUDR	(CPG_MFS11_CSIO.unESR.stcField.u1RXUDR)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_esr_field{
    uint_io8_t		u1TBERR:1;
    uint_io8_t		u1RBERR:1;
    uint_io8_t		u1TXOVR:1;
    uint_io8_t		u1RXUDR:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_csio_esr_field_t;

typedef union un_cpg_mfsn_csio_esr{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_esr_field_t		stcField;
}un_cpg_mfsn_csio_esr_t;

/* TBSIZE */
#define CPG_MFS00_CSIO_TBSIZE	(CPG_MFS00_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_TBSIZE_TBSIZE	CPG_MFS00_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS01_CSIO_TBSIZE	(CPG_MFS01_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_TBSIZE_TBSIZE	CPG_MFS01_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS02_CSIO_TBSIZE	(CPG_MFS02_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_TBSIZE_TBSIZE	CPG_MFS02_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS03_CSIO_TBSIZE	(CPG_MFS03_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_TBSIZE_TBSIZE	CPG_MFS03_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS04_CSIO_TBSIZE	(CPG_MFS04_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_TBSIZE_TBSIZE	CPG_MFS04_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS05_CSIO_TBSIZE	(CPG_MFS05_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_TBSIZE_TBSIZE	CPG_MFS05_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS06_CSIO_TBSIZE	(CPG_MFS06_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_TBSIZE_TBSIZE	CPG_MFS06_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS07_CSIO_TBSIZE	(CPG_MFS07_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_TBSIZE_TBSIZE	CPG_MFS07_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS08_CSIO_TBSIZE	(CPG_MFS08_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_TBSIZE_TBSIZE	CPG_MFS08_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS09_CSIO_TBSIZE	(CPG_MFS09_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_TBSIZE_TBSIZE	CPG_MFS09_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS10_CSIO_TBSIZE	(CPG_MFS10_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_TBSIZE_TBSIZE	CPG_MFS10_CSIO_TBSIZE  /*@bfrg@*/

#define CPG_MFS11_CSIO_TBSIZE	(CPG_MFS11_CSIO.unTBSIZE.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_TBSIZE_TBSIZE	CPG_MFS11_CSIO_TBSIZE  /*@bfrg@*/

typedef union un_cpg_mfsn_csio_tbsize{
    uint_io8_t		u8Register;
}un_cpg_mfsn_csio_tbsize_t;

/* SACSRC */
#define CPG_MFS00_CSIO_SACSRC	(CPG_MFS00_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SACSRC_TMREC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRC_TRGEC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRC_TSYNEC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRC_TINTEC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRC_TINTC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRC_CSEC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRC_CSEIEC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRC_TBEENC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRC_STSTC	(CPG_MFS00_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS01_CSIO_SACSRC	(CPG_MFS01_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SACSRC_TMREC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRC_TRGEC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRC_TSYNEC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRC_TINTEC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRC_TINTC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRC_CSEC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRC_CSEIEC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRC_TBEENC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRC_STSTC	(CPG_MFS01_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS02_CSIO_SACSRC	(CPG_MFS02_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SACSRC_TMREC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRC_TRGEC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRC_TSYNEC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRC_TINTEC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRC_TINTC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRC_CSEC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRC_CSEIEC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRC_TBEENC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRC_STSTC	(CPG_MFS02_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS03_CSIO_SACSRC	(CPG_MFS03_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SACSRC_TMREC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRC_TRGEC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRC_TSYNEC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRC_TINTEC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRC_TINTC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRC_CSEC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRC_CSEIEC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRC_TBEENC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRC_STSTC	(CPG_MFS03_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS04_CSIO_SACSRC	(CPG_MFS04_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SACSRC_TMREC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRC_TRGEC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRC_TSYNEC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRC_TINTEC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRC_TINTC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRC_CSEC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRC_CSEIEC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRC_TBEENC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRC_STSTC	(CPG_MFS04_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS05_CSIO_SACSRC	(CPG_MFS05_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SACSRC_TMREC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRC_TRGEC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRC_TSYNEC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRC_TINTEC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRC_TINTC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRC_CSEC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRC_CSEIEC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRC_TBEENC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRC_STSTC	(CPG_MFS05_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS06_CSIO_SACSRC	(CPG_MFS06_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SACSRC_TMREC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRC_TRGEC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRC_TSYNEC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRC_TINTEC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRC_TINTC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRC_CSEC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRC_CSEIEC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRC_TBEENC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRC_STSTC	(CPG_MFS06_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS07_CSIO_SACSRC	(CPG_MFS07_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SACSRC_TMREC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRC_TRGEC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRC_TSYNEC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRC_TINTEC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRC_TINTC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRC_CSEC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRC_CSEIEC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRC_TBEENC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRC_STSTC	(CPG_MFS07_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS08_CSIO_SACSRC	(CPG_MFS08_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SACSRC_TMREC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRC_TRGEC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRC_TSYNEC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRC_TINTEC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRC_TINTC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRC_CSEC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRC_CSEIEC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRC_TBEENC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRC_STSTC	(CPG_MFS08_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS09_CSIO_SACSRC	(CPG_MFS09_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SACSRC_TMREC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRC_TRGEC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRC_TSYNEC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRC_TINTEC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRC_TINTC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRC_CSEC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRC_CSEIEC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRC_TBEENC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRC_STSTC	(CPG_MFS09_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS10_CSIO_SACSRC	(CPG_MFS10_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SACSRC_TMREC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRC_TRGEC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRC_TSYNEC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRC_TINTEC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRC_TINTC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRC_CSEC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRC_CSEIEC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRC_TBEENC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRC_STSTC	(CPG_MFS10_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

#define CPG_MFS11_CSIO_SACSRC	(CPG_MFS11_CSIO.unSACSRC.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SACSRC_TMREC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1TMREC)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRC_TRGEC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1TRGEC)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRC_TSYNEC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1TSYNEC)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRC_TINTEC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1TINTEC)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRC_TINTC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1TINTC)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRC_CSEC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1CSEC)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRC_CSEIEC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1CSEIEC)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRC_TBEENC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1TBEENC)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRC_STSTC	(CPG_MFS11_CSIO.unSACSRC.stcField.u1STSTC)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_sacsrc_field{
    uint_io16_t		u1TMREC:1;
    uint_io16_t		:4;
    uint_io16_t		u1TRGEC:1;
    uint_io16_t		u1TSYNEC:1;
    uint_io16_t		u1TINTEC:1;
    uint_io16_t		u1TINTC:1;
    uint_io16_t		:2;
    uint_io16_t		u1CSEC:1;
    uint_io16_t		u1CSEIEC:1;
    uint_io16_t		u1TBEENC:1;
    uint_io16_t		:1;
    uint_io16_t		u1STSTC:1;
}stc_cpg_mfsn_csio_sacsrc_field_t;

typedef union un_cpg_mfsn_csio_sacsrc{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_csio_sacsrc_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_sacsrc_t;

/* FCR0C */
#define CPG_MFS00_CSIO_FCR0C	(CPG_MFS00_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_FCR0C_FE1C	(CPG_MFS00_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0C_FE2C	(CPG_MFS00_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS01_CSIO_FCR0C	(CPG_MFS01_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_FCR0C_FE1C	(CPG_MFS01_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0C_FE2C	(CPG_MFS01_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS02_CSIO_FCR0C	(CPG_MFS02_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_FCR0C_FE1C	(CPG_MFS02_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0C_FE2C	(CPG_MFS02_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS03_CSIO_FCR0C	(CPG_MFS03_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_FCR0C_FE1C	(CPG_MFS03_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0C_FE2C	(CPG_MFS03_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS04_CSIO_FCR0C	(CPG_MFS04_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_FCR0C_FE1C	(CPG_MFS04_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0C_FE2C	(CPG_MFS04_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS05_CSIO_FCR0C	(CPG_MFS05_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_FCR0C_FE1C	(CPG_MFS05_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0C_FE2C	(CPG_MFS05_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS06_CSIO_FCR0C	(CPG_MFS06_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_FCR0C_FE1C	(CPG_MFS06_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0C_FE2C	(CPG_MFS06_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS07_CSIO_FCR0C	(CPG_MFS07_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_FCR0C_FE1C	(CPG_MFS07_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0C_FE2C	(CPG_MFS07_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS08_CSIO_FCR0C	(CPG_MFS08_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_FCR0C_FE1C	(CPG_MFS08_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0C_FE2C	(CPG_MFS08_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS09_CSIO_FCR0C	(CPG_MFS09_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_FCR0C_FE1C	(CPG_MFS09_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0C_FE2C	(CPG_MFS09_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS10_CSIO_FCR0C	(CPG_MFS10_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_FCR0C_FE1C	(CPG_MFS10_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0C_FE2C	(CPG_MFS10_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

#define CPG_MFS11_CSIO_FCR0C	(CPG_MFS11_CSIO.unFCR0C.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_FCR0C_FE1C	(CPG_MFS11_CSIO.unFCR0C.stcField.u1FE1C)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0C_FE2C	(CPG_MFS11_CSIO.unFCR0C.stcField.u1FE2C)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_fcr0c_field{
    uint_io8_t		u1FE1C:1;
    uint_io8_t		u1FE2C:1;
    uint_io8_t		:6;
}stc_cpg_mfsn_csio_fcr0c_field_t;

typedef union un_cpg_mfsn_csio_fcr0c{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_fcr0c_field_t		stcField;
}un_cpg_mfsn_csio_fcr0c_t;

/* FCR1C */
#define CPG_MFS00_CSIO_FCR1C	(CPG_MFS00_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_FCR1C_FSELC	(CPG_MFS00_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1C_FTIEC	(CPG_MFS00_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1C_FDRQC	(CPG_MFS00_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1C_FRIIEC	(CPG_MFS00_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1C_FLSTEC	(CPG_MFS00_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS01_CSIO_FCR1C	(CPG_MFS01_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_FCR1C_FSELC	(CPG_MFS01_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1C_FTIEC	(CPG_MFS01_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1C_FDRQC	(CPG_MFS01_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1C_FRIIEC	(CPG_MFS01_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1C_FLSTEC	(CPG_MFS01_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS02_CSIO_FCR1C	(CPG_MFS02_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_FCR1C_FSELC	(CPG_MFS02_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1C_FTIEC	(CPG_MFS02_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1C_FDRQC	(CPG_MFS02_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1C_FRIIEC	(CPG_MFS02_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1C_FLSTEC	(CPG_MFS02_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS03_CSIO_FCR1C	(CPG_MFS03_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_FCR1C_FSELC	(CPG_MFS03_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1C_FTIEC	(CPG_MFS03_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1C_FDRQC	(CPG_MFS03_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1C_FRIIEC	(CPG_MFS03_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1C_FLSTEC	(CPG_MFS03_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS04_CSIO_FCR1C	(CPG_MFS04_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_FCR1C_FSELC	(CPG_MFS04_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1C_FTIEC	(CPG_MFS04_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1C_FDRQC	(CPG_MFS04_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1C_FRIIEC	(CPG_MFS04_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1C_FLSTEC	(CPG_MFS04_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS05_CSIO_FCR1C	(CPG_MFS05_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_FCR1C_FSELC	(CPG_MFS05_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1C_FTIEC	(CPG_MFS05_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1C_FDRQC	(CPG_MFS05_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1C_FRIIEC	(CPG_MFS05_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1C_FLSTEC	(CPG_MFS05_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS06_CSIO_FCR1C	(CPG_MFS06_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_FCR1C_FSELC	(CPG_MFS06_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1C_FTIEC	(CPG_MFS06_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1C_FDRQC	(CPG_MFS06_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1C_FRIIEC	(CPG_MFS06_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1C_FLSTEC	(CPG_MFS06_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS07_CSIO_FCR1C	(CPG_MFS07_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_FCR1C_FSELC	(CPG_MFS07_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1C_FTIEC	(CPG_MFS07_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1C_FDRQC	(CPG_MFS07_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1C_FRIIEC	(CPG_MFS07_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1C_FLSTEC	(CPG_MFS07_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS08_CSIO_FCR1C	(CPG_MFS08_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_FCR1C_FSELC	(CPG_MFS08_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1C_FTIEC	(CPG_MFS08_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1C_FDRQC	(CPG_MFS08_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1C_FRIIEC	(CPG_MFS08_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1C_FLSTEC	(CPG_MFS08_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS09_CSIO_FCR1C	(CPG_MFS09_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_FCR1C_FSELC	(CPG_MFS09_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1C_FTIEC	(CPG_MFS09_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1C_FDRQC	(CPG_MFS09_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1C_FRIIEC	(CPG_MFS09_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1C_FLSTEC	(CPG_MFS09_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS10_CSIO_FCR1C	(CPG_MFS10_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_FCR1C_FSELC	(CPG_MFS10_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1C_FTIEC	(CPG_MFS10_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1C_FDRQC	(CPG_MFS10_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1C_FRIIEC	(CPG_MFS10_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1C_FLSTEC	(CPG_MFS10_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

#define CPG_MFS11_CSIO_FCR1C	(CPG_MFS11_CSIO.unFCR1C.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_FCR1C_FSELC	(CPG_MFS11_CSIO.unFCR1C.stcField.u1FSELC)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1C_FTIEC	(CPG_MFS11_CSIO.unFCR1C.stcField.u1FTIEC)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1C_FDRQC	(CPG_MFS11_CSIO.unFCR1C.stcField.u1FDRQC)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1C_FRIIEC	(CPG_MFS11_CSIO.unFCR1C.stcField.u1FRIIEC)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1C_FLSTEC	(CPG_MFS11_CSIO.unFCR1C.stcField.u1FLSTEC)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_fcr1c_field{
    uint_io8_t		u1FSELC:1;
    uint_io8_t		u1FTIEC:1;
    uint_io8_t		u1FDRQC:1;
    uint_io8_t		u1FRIIEC:1;
    uint_io8_t		u1FLSTEC:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_csio_fcr1c_field_t;

typedef union un_cpg_mfsn_csio_fcr1c{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_fcr1c_field_t		stcField;
}un_cpg_mfsn_csio_fcr1c_t;

/* ESRC */
#define CPG_MFS00_CSIO_ESRC	(CPG_MFS00_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_ESRC_TBERRC	(CPG_MFS00_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS00_CSIO_ESRC_RBERRC	(CPG_MFS00_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS00_CSIO_ESRC_TXOVRC	(CPG_MFS00_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS00_CSIO_ESRC_RXUDRC	(CPG_MFS00_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS01_CSIO_ESRC	(CPG_MFS01_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_ESRC_TBERRC	(CPG_MFS01_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS01_CSIO_ESRC_RBERRC	(CPG_MFS01_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS01_CSIO_ESRC_TXOVRC	(CPG_MFS01_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS01_CSIO_ESRC_RXUDRC	(CPG_MFS01_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS02_CSIO_ESRC	(CPG_MFS02_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_ESRC_TBERRC	(CPG_MFS02_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS02_CSIO_ESRC_RBERRC	(CPG_MFS02_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS02_CSIO_ESRC_TXOVRC	(CPG_MFS02_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS02_CSIO_ESRC_RXUDRC	(CPG_MFS02_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS03_CSIO_ESRC	(CPG_MFS03_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_ESRC_TBERRC	(CPG_MFS03_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS03_CSIO_ESRC_RBERRC	(CPG_MFS03_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS03_CSIO_ESRC_TXOVRC	(CPG_MFS03_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS03_CSIO_ESRC_RXUDRC	(CPG_MFS03_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS04_CSIO_ESRC	(CPG_MFS04_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_ESRC_TBERRC	(CPG_MFS04_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS04_CSIO_ESRC_RBERRC	(CPG_MFS04_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS04_CSIO_ESRC_TXOVRC	(CPG_MFS04_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS04_CSIO_ESRC_RXUDRC	(CPG_MFS04_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS05_CSIO_ESRC	(CPG_MFS05_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_ESRC_TBERRC	(CPG_MFS05_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS05_CSIO_ESRC_RBERRC	(CPG_MFS05_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS05_CSIO_ESRC_TXOVRC	(CPG_MFS05_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS05_CSIO_ESRC_RXUDRC	(CPG_MFS05_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS06_CSIO_ESRC	(CPG_MFS06_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_ESRC_TBERRC	(CPG_MFS06_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS06_CSIO_ESRC_RBERRC	(CPG_MFS06_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS06_CSIO_ESRC_TXOVRC	(CPG_MFS06_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS06_CSIO_ESRC_RXUDRC	(CPG_MFS06_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS07_CSIO_ESRC	(CPG_MFS07_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_ESRC_TBERRC	(CPG_MFS07_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS07_CSIO_ESRC_RBERRC	(CPG_MFS07_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS07_CSIO_ESRC_TXOVRC	(CPG_MFS07_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS07_CSIO_ESRC_RXUDRC	(CPG_MFS07_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS08_CSIO_ESRC	(CPG_MFS08_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_ESRC_TBERRC	(CPG_MFS08_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS08_CSIO_ESRC_RBERRC	(CPG_MFS08_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS08_CSIO_ESRC_TXOVRC	(CPG_MFS08_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS08_CSIO_ESRC_RXUDRC	(CPG_MFS08_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS09_CSIO_ESRC	(CPG_MFS09_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_ESRC_TBERRC	(CPG_MFS09_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS09_CSIO_ESRC_RBERRC	(CPG_MFS09_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS09_CSIO_ESRC_TXOVRC	(CPG_MFS09_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS09_CSIO_ESRC_RXUDRC	(CPG_MFS09_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS10_CSIO_ESRC	(CPG_MFS10_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_ESRC_TBERRC	(CPG_MFS10_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS10_CSIO_ESRC_RBERRC	(CPG_MFS10_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS10_CSIO_ESRC_TXOVRC	(CPG_MFS10_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS10_CSIO_ESRC_RXUDRC	(CPG_MFS10_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

#define CPG_MFS11_CSIO_ESRC	(CPG_MFS11_CSIO.unESRC.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_ESRC_TBERRC	(CPG_MFS11_CSIO.unESRC.stcField.u1TBERRC)  /*@bf@*/
#define CPG_MFS11_CSIO_ESRC_RBERRC	(CPG_MFS11_CSIO.unESRC.stcField.u1RBERRC)  /*@bf@*/
#define CPG_MFS11_CSIO_ESRC_TXOVRC	(CPG_MFS11_CSIO.unESRC.stcField.u1TXOVRC)  /*@bf@*/
#define CPG_MFS11_CSIO_ESRC_RXUDRC	(CPG_MFS11_CSIO.unESRC.stcField.u1RXUDRC)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_esrc_field{
    uint_io8_t		u1TBERRC:1;
    uint_io8_t		u1RBERRC:1;
    uint_io8_t		u1TXOVRC:1;
    uint_io8_t		u1RXUDRC:1;
    uint_io8_t		:4;
}stc_cpg_mfsn_csio_esrc_field_t;

typedef union un_cpg_mfsn_csio_esrc{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_esrc_field_t		stcField;
}un_cpg_mfsn_csio_esrc_t;

/* SACSRS */
#define CPG_MFS00_CSIO_SACSRS	(CPG_MFS00_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS00_CSIO_SACSRS_TMRES	(CPG_MFS00_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRS_TRGES	(CPG_MFS00_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRS_TSYNES	(CPG_MFS00_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRS_TINTES	(CPG_MFS00_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRS_CSEIES	(CPG_MFS00_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRS_TBEENS	(CPG_MFS00_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS00_CSIO_SACSRS_STSTS	(CPG_MFS00_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS01_CSIO_SACSRS	(CPG_MFS01_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS01_CSIO_SACSRS_TMRES	(CPG_MFS01_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRS_TRGES	(CPG_MFS01_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRS_TSYNES	(CPG_MFS01_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRS_TINTES	(CPG_MFS01_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRS_CSEIES	(CPG_MFS01_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRS_TBEENS	(CPG_MFS01_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS01_CSIO_SACSRS_STSTS	(CPG_MFS01_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS02_CSIO_SACSRS	(CPG_MFS02_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS02_CSIO_SACSRS_TMRES	(CPG_MFS02_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRS_TRGES	(CPG_MFS02_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRS_TSYNES	(CPG_MFS02_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRS_TINTES	(CPG_MFS02_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRS_CSEIES	(CPG_MFS02_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRS_TBEENS	(CPG_MFS02_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS02_CSIO_SACSRS_STSTS	(CPG_MFS02_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS03_CSIO_SACSRS	(CPG_MFS03_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS03_CSIO_SACSRS_TMRES	(CPG_MFS03_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRS_TRGES	(CPG_MFS03_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRS_TSYNES	(CPG_MFS03_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRS_TINTES	(CPG_MFS03_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRS_CSEIES	(CPG_MFS03_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRS_TBEENS	(CPG_MFS03_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS03_CSIO_SACSRS_STSTS	(CPG_MFS03_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS04_CSIO_SACSRS	(CPG_MFS04_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS04_CSIO_SACSRS_TMRES	(CPG_MFS04_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRS_TRGES	(CPG_MFS04_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRS_TSYNES	(CPG_MFS04_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRS_TINTES	(CPG_MFS04_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRS_CSEIES	(CPG_MFS04_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRS_TBEENS	(CPG_MFS04_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS04_CSIO_SACSRS_STSTS	(CPG_MFS04_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS05_CSIO_SACSRS	(CPG_MFS05_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS05_CSIO_SACSRS_TMRES	(CPG_MFS05_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRS_TRGES	(CPG_MFS05_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRS_TSYNES	(CPG_MFS05_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRS_TINTES	(CPG_MFS05_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRS_CSEIES	(CPG_MFS05_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRS_TBEENS	(CPG_MFS05_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS05_CSIO_SACSRS_STSTS	(CPG_MFS05_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS06_CSIO_SACSRS	(CPG_MFS06_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS06_CSIO_SACSRS_TMRES	(CPG_MFS06_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRS_TRGES	(CPG_MFS06_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRS_TSYNES	(CPG_MFS06_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRS_TINTES	(CPG_MFS06_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRS_CSEIES	(CPG_MFS06_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRS_TBEENS	(CPG_MFS06_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS06_CSIO_SACSRS_STSTS	(CPG_MFS06_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS07_CSIO_SACSRS	(CPG_MFS07_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS07_CSIO_SACSRS_TMRES	(CPG_MFS07_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRS_TRGES	(CPG_MFS07_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRS_TSYNES	(CPG_MFS07_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRS_TINTES	(CPG_MFS07_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRS_CSEIES	(CPG_MFS07_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRS_TBEENS	(CPG_MFS07_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS07_CSIO_SACSRS_STSTS	(CPG_MFS07_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS08_CSIO_SACSRS	(CPG_MFS08_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS08_CSIO_SACSRS_TMRES	(CPG_MFS08_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRS_TRGES	(CPG_MFS08_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRS_TSYNES	(CPG_MFS08_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRS_TINTES	(CPG_MFS08_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRS_CSEIES	(CPG_MFS08_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRS_TBEENS	(CPG_MFS08_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS08_CSIO_SACSRS_STSTS	(CPG_MFS08_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS09_CSIO_SACSRS	(CPG_MFS09_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS09_CSIO_SACSRS_TMRES	(CPG_MFS09_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRS_TRGES	(CPG_MFS09_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRS_TSYNES	(CPG_MFS09_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRS_TINTES	(CPG_MFS09_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRS_CSEIES	(CPG_MFS09_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRS_TBEENS	(CPG_MFS09_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS09_CSIO_SACSRS_STSTS	(CPG_MFS09_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS10_CSIO_SACSRS	(CPG_MFS10_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS10_CSIO_SACSRS_TMRES	(CPG_MFS10_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRS_TRGES	(CPG_MFS10_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRS_TSYNES	(CPG_MFS10_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRS_TINTES	(CPG_MFS10_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRS_CSEIES	(CPG_MFS10_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRS_TBEENS	(CPG_MFS10_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS10_CSIO_SACSRS_STSTS	(CPG_MFS10_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

#define CPG_MFS11_CSIO_SACSRS	(CPG_MFS11_CSIO.unSACSRS.u16Register)  /*@rg@*/
#define CPG_MFS11_CSIO_SACSRS_TMRES	(CPG_MFS11_CSIO.unSACSRS.stcField.u1TMRES)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRS_TRGES	(CPG_MFS11_CSIO.unSACSRS.stcField.u1TRGES)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRS_TSYNES	(CPG_MFS11_CSIO.unSACSRS.stcField.u1TSYNES)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRS_TINTES	(CPG_MFS11_CSIO.unSACSRS.stcField.u1TINTES)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRS_CSEIES	(CPG_MFS11_CSIO.unSACSRS.stcField.u1CSEIES)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRS_TBEENS	(CPG_MFS11_CSIO.unSACSRS.stcField.u1TBEENS)  /*@bf@*/
#define CPG_MFS11_CSIO_SACSRS_STSTS	(CPG_MFS11_CSIO.unSACSRS.stcField.u1STSTS)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_sacsrs_field{
    uint_io16_t		u1TMRES:1;
    uint_io16_t		:4;
    uint_io16_t		u1TRGES:1;
    uint_io16_t		u1TSYNES:1;
    uint_io16_t		u1TINTES:1;
    uint_io16_t		:4;
    uint_io16_t		u1CSEIES:1;
    uint_io16_t		u1TBEENS:1;
    uint_io16_t		:1;
    uint_io16_t		u1STSTS:1;
}stc_cpg_mfsn_csio_sacsrs_field_t;

typedef union un_cpg_mfsn_csio_sacsrs{
    uint_io16_t		u16Register;
    stc_cpg_mfsn_csio_sacsrs_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_mfsn_csio_sacsrs_t;

/* FCR0S */
#define CPG_MFS00_CSIO_FCR0S	(CPG_MFS00_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_FCR0S_FE1S	(CPG_MFS00_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0S_FE2S	(CPG_MFS00_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0S_FCL1S	(CPG_MFS00_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0S_FCL2S	(CPG_MFS00_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0S_FSETS	(CPG_MFS00_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR0S_FLDS	(CPG_MFS00_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS01_CSIO_FCR0S	(CPG_MFS01_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_FCR0S_FE1S	(CPG_MFS01_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0S_FE2S	(CPG_MFS01_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0S_FCL1S	(CPG_MFS01_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0S_FCL2S	(CPG_MFS01_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0S_FSETS	(CPG_MFS01_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR0S_FLDS	(CPG_MFS01_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS02_CSIO_FCR0S	(CPG_MFS02_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_FCR0S_FE1S	(CPG_MFS02_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0S_FE2S	(CPG_MFS02_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0S_FCL1S	(CPG_MFS02_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0S_FCL2S	(CPG_MFS02_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0S_FSETS	(CPG_MFS02_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR0S_FLDS	(CPG_MFS02_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS03_CSIO_FCR0S	(CPG_MFS03_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_FCR0S_FE1S	(CPG_MFS03_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0S_FE2S	(CPG_MFS03_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0S_FCL1S	(CPG_MFS03_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0S_FCL2S	(CPG_MFS03_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0S_FSETS	(CPG_MFS03_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR0S_FLDS	(CPG_MFS03_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS04_CSIO_FCR0S	(CPG_MFS04_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_FCR0S_FE1S	(CPG_MFS04_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0S_FE2S	(CPG_MFS04_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0S_FCL1S	(CPG_MFS04_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0S_FCL2S	(CPG_MFS04_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0S_FSETS	(CPG_MFS04_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR0S_FLDS	(CPG_MFS04_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS05_CSIO_FCR0S	(CPG_MFS05_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_FCR0S_FE1S	(CPG_MFS05_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0S_FE2S	(CPG_MFS05_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0S_FCL1S	(CPG_MFS05_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0S_FCL2S	(CPG_MFS05_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0S_FSETS	(CPG_MFS05_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR0S_FLDS	(CPG_MFS05_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS06_CSIO_FCR0S	(CPG_MFS06_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_FCR0S_FE1S	(CPG_MFS06_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0S_FE2S	(CPG_MFS06_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0S_FCL1S	(CPG_MFS06_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0S_FCL2S	(CPG_MFS06_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0S_FSETS	(CPG_MFS06_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR0S_FLDS	(CPG_MFS06_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS07_CSIO_FCR0S	(CPG_MFS07_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_FCR0S_FE1S	(CPG_MFS07_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0S_FE2S	(CPG_MFS07_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0S_FCL1S	(CPG_MFS07_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0S_FCL2S	(CPG_MFS07_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0S_FSETS	(CPG_MFS07_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR0S_FLDS	(CPG_MFS07_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS08_CSIO_FCR0S	(CPG_MFS08_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_FCR0S_FE1S	(CPG_MFS08_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0S_FE2S	(CPG_MFS08_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0S_FCL1S	(CPG_MFS08_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0S_FCL2S	(CPG_MFS08_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0S_FSETS	(CPG_MFS08_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR0S_FLDS	(CPG_MFS08_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS09_CSIO_FCR0S	(CPG_MFS09_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_FCR0S_FE1S	(CPG_MFS09_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0S_FE2S	(CPG_MFS09_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0S_FCL1S	(CPG_MFS09_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0S_FCL2S	(CPG_MFS09_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0S_FSETS	(CPG_MFS09_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR0S_FLDS	(CPG_MFS09_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS10_CSIO_FCR0S	(CPG_MFS10_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_FCR0S_FE1S	(CPG_MFS10_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0S_FE2S	(CPG_MFS10_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0S_FCL1S	(CPG_MFS10_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0S_FCL2S	(CPG_MFS10_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0S_FSETS	(CPG_MFS10_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR0S_FLDS	(CPG_MFS10_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

#define CPG_MFS11_CSIO_FCR0S	(CPG_MFS11_CSIO.unFCR0S.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_FCR0S_FE1S	(CPG_MFS11_CSIO.unFCR0S.stcField.u1FE1S)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0S_FE2S	(CPG_MFS11_CSIO.unFCR0S.stcField.u1FE2S)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0S_FCL1S	(CPG_MFS11_CSIO.unFCR0S.stcField.u1FCL1S)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0S_FCL2S	(CPG_MFS11_CSIO.unFCR0S.stcField.u1FCL2S)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0S_FSETS	(CPG_MFS11_CSIO.unFCR0S.stcField.u1FSETS)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR0S_FLDS	(CPG_MFS11_CSIO.unFCR0S.stcField.u1FLDS)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_fcr0s_field{
    uint_io8_t		u1FE1S:1;
    uint_io8_t		u1FE2S:1;
    uint_io8_t		u1FCL1S:1;
    uint_io8_t		u1FCL2S:1;
    uint_io8_t		u1FSETS:1;
    uint_io8_t		u1FLDS:1;
    uint_io8_t		:2;
}stc_cpg_mfsn_csio_fcr0s_field_t;

typedef union un_cpg_mfsn_csio_fcr0s{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_fcr0s_field_t		stcField;
}un_cpg_mfsn_csio_fcr0s_t;

/* FCR1S */
#define CPG_MFS00_CSIO_FCR1S	(CPG_MFS00_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS00_CSIO_FCR1S_FSELS	(CPG_MFS00_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1S_FTIES	(CPG_MFS00_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1S_FRIIES	(CPG_MFS00_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS00_CSIO_FCR1S_FLSTES	(CPG_MFS00_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS01_CSIO_FCR1S	(CPG_MFS01_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS01_CSIO_FCR1S_FSELS	(CPG_MFS01_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1S_FTIES	(CPG_MFS01_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1S_FRIIES	(CPG_MFS01_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS01_CSIO_FCR1S_FLSTES	(CPG_MFS01_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS02_CSIO_FCR1S	(CPG_MFS02_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS02_CSIO_FCR1S_FSELS	(CPG_MFS02_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1S_FTIES	(CPG_MFS02_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1S_FRIIES	(CPG_MFS02_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS02_CSIO_FCR1S_FLSTES	(CPG_MFS02_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS03_CSIO_FCR1S	(CPG_MFS03_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS03_CSIO_FCR1S_FSELS	(CPG_MFS03_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1S_FTIES	(CPG_MFS03_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1S_FRIIES	(CPG_MFS03_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS03_CSIO_FCR1S_FLSTES	(CPG_MFS03_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS04_CSIO_FCR1S	(CPG_MFS04_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS04_CSIO_FCR1S_FSELS	(CPG_MFS04_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1S_FTIES	(CPG_MFS04_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1S_FRIIES	(CPG_MFS04_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS04_CSIO_FCR1S_FLSTES	(CPG_MFS04_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS05_CSIO_FCR1S	(CPG_MFS05_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS05_CSIO_FCR1S_FSELS	(CPG_MFS05_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1S_FTIES	(CPG_MFS05_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1S_FRIIES	(CPG_MFS05_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS05_CSIO_FCR1S_FLSTES	(CPG_MFS05_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS06_CSIO_FCR1S	(CPG_MFS06_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS06_CSIO_FCR1S_FSELS	(CPG_MFS06_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1S_FTIES	(CPG_MFS06_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1S_FRIIES	(CPG_MFS06_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS06_CSIO_FCR1S_FLSTES	(CPG_MFS06_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS07_CSIO_FCR1S	(CPG_MFS07_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS07_CSIO_FCR1S_FSELS	(CPG_MFS07_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1S_FTIES	(CPG_MFS07_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1S_FRIIES	(CPG_MFS07_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS07_CSIO_FCR1S_FLSTES	(CPG_MFS07_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS08_CSIO_FCR1S	(CPG_MFS08_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS08_CSIO_FCR1S_FSELS	(CPG_MFS08_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1S_FTIES	(CPG_MFS08_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1S_FRIIES	(CPG_MFS08_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS08_CSIO_FCR1S_FLSTES	(CPG_MFS08_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS09_CSIO_FCR1S	(CPG_MFS09_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS09_CSIO_FCR1S_FSELS	(CPG_MFS09_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1S_FTIES	(CPG_MFS09_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1S_FRIIES	(CPG_MFS09_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS09_CSIO_FCR1S_FLSTES	(CPG_MFS09_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS10_CSIO_FCR1S	(CPG_MFS10_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS10_CSIO_FCR1S_FSELS	(CPG_MFS10_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1S_FTIES	(CPG_MFS10_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1S_FRIIES	(CPG_MFS10_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS10_CSIO_FCR1S_FLSTES	(CPG_MFS10_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

#define CPG_MFS11_CSIO_FCR1S	(CPG_MFS11_CSIO.unFCR1S.u8Register)  /*@rg@*/
#define CPG_MFS11_CSIO_FCR1S_FSELS	(CPG_MFS11_CSIO.unFCR1S.stcField.u1FSELS)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1S_FTIES	(CPG_MFS11_CSIO.unFCR1S.stcField.u1FTIES)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1S_FRIIES	(CPG_MFS11_CSIO.unFCR1S.stcField.u1FRIIES)  /*@bf@*/
#define CPG_MFS11_CSIO_FCR1S_FLSTES	(CPG_MFS11_CSIO.unFCR1S.stcField.u1FLSTES)  /*@bf@*/

typedef struct stc_cpg_mfsn_csio_fcr1s_field{
    uint_io8_t		u1FSELS:1;
    uint_io8_t		u1FTIES:1;
    uint_io8_t		:1;
    uint_io8_t		u1FRIIES:1;
    uint_io8_t		u1FLSTES:1;
    uint_io8_t		:3;
}stc_cpg_mfsn_csio_fcr1s_field_t;

typedef union un_cpg_mfsn_csio_fcr1s{
    uint_io8_t		u8Register;
    stc_cpg_mfsn_csio_fcr1s_field_t		stcField;
}un_cpg_mfsn_csio_fcr1s_t;


typedef struct stc_cpg_mfsn_csio{
    un_cpg_mfsn_csio_smr_t	unSMR;	/* 0x00000000 */
    un_cpg_mfsn_csio_scr_t	unSCR;	/* 0x00000001 */
    un_cpg_mfsn_csio_escr_t	unESCR;	/* 0x00000002 */
    un_cpg_mfsn_csio_ssr_t	unSSR;	/* 0x00000003 */
    un_cpg_mfsn_csio_rdr_t	unRDR;	/* 0x00000004 */
    un_cpg_mfsn_csio_sacsr_t	unSACSR;	/* 0x00000008 */
    un_cpg_mfsn_csio_stmr_t	unSTMR;	/* 0x0000000A */
    un_cpg_mfsn_csio_stmcr_t	unSTMCR;	/* 0x0000000C */
    un_cpg_mfsn_csio_scscr_t	unSCSCR;	/* 0x0000000E */
    un_cpg_mfsn_csio_scstr0_t	unSCSTR0;	/* 0x00000010 */
    un_cpg_mfsn_csio_scstr1_t	unSCSTR1;	/* 0x00000011 */
    un_cpg_mfsn_csio_scstr23_t	unSCSTR23;	/* 0x00000012 */
    un_cpg_mfsn_csio_scsfr0_t	unSCSFR0;	/* 0x00000014 */
    un_cpg_mfsn_csio_scsfr1_t	unSCSFR1;	/* 0x00000015 */
    un_cpg_mfsn_csio_scsfr2_t	unSCSFR2;	/* 0x00000016 */
    uint_io8_t	au8Reserved0[1];	/* 0x00000017 */
    un_cpg_mfsn_csio_tbyte0_t	unTBYTE0;	/* 0x00000018 */
    un_cpg_mfsn_csio_tbyte1_t	unTBYTE1;	/* 0x00000019 */
    un_cpg_mfsn_csio_tbyte2_t	unTBYTE2;	/* 0x0000001A */
    un_cpg_mfsn_csio_tbyte3_t	unTBYTE3;	/* 0x0000001B */
    un_cpg_mfsn_csio_bgr_t	unBGR;	/* 0x0000001C */
    uint_io8_t	au8Reserved1[2];	/* 0x0000001E */
    un_cpg_mfsn_csio_fcr0_t	unFCR0;	/* 0x00000020 */
    un_cpg_mfsn_csio_fcr1_t	unFCR1;	/* 0x00000021 */
    un_cpg_mfsn_csio_fbyte_t	unFBYTE;	/* 0x00000022 */
    un_cpg_mfsn_csio_fticr_t	unFTICR;	/* 0x00000024 */
    un_cpg_mfsn_csio_ecr_t	unECR;	/* 0x00000026 */
    un_cpg_mfsn_csio_esr_t	unESR;	/* 0x00000027 */
    un_cpg_mfsn_csio_tbsize_t	unTBSIZE;	/* 0x00000028 */
    uint_io8_t	au8Reserved2[7];	/* 0x00000029 */
    un_cpg_mfsn_csio_sacsrc_t	unSACSRC;	/* 0x00000030 */
    uint_io8_t	au8Reserved3[10];	/* 0x00000032 */
    un_cpg_mfsn_csio_fcr0c_t	unFCR0C;	/* 0x0000003C */
    un_cpg_mfsn_csio_fcr1c_t	unFCR1C;	/* 0x0000003D */
    uint_io8_t	au8Reserved4[5];	/* 0x0000003E */
    un_cpg_mfsn_csio_esrc_t	unESRC;	/* 0x00000043 */
    uint_io8_t	au8Reserved5[4];	/* 0x00000044 */
    un_cpg_mfsn_csio_sacsrs_t	unSACSRS;	/* 0x00000048 */
    uint_io8_t	au8Reserved6[10];	/* 0x0000004A */
    un_cpg_mfsn_csio_fcr0s_t	unFCR0S;	/* 0x00000054 */
    un_cpg_mfsn_csio_fcr1s_t	unFCR1S;	/* 0x00000055 */
    uint_io8_t	au8Reserved7[938];	/* 0x00000056 */
}stc_cpg_mfsn_csio_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_cpg_mfsn_csio_t	stcCPG_MFS_CSIO[12];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_MFS_CSIO_H */
