/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_MCG_H
#define __S6J3360_MCG_H

#include "s6j3360io_basetypes.h"

/* MCG base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define MCG	stcMCG
#else /* __IO_DEFINE */
#define MCG	(*((volatile stc_mcg_t*)0xB0688800))
#endif /* __IO_DEFINE */

/* IRSR0 */
#define MCG_IRSR0	(MCG.unIRSR0.u32Register)  /*@rg@*/
#define MCG_IRSR0_NMI_LVD	(MCG.unIRSR0.stcField.u1NMI_LVD)  /*@bf@*/
#define MCG_IRSR0_NMI_SCU	(MCG.unIRSR0.stcField.u1NMI_SCU)  /*@bf@*/
#define MCG_IRSR0_NMI_HWDG	(MCG.unIRSR0.stcField.u1NMI_HWDG)  /*@bf@*/
#define MCG_IRSR0_NMI_EXTINT	(MCG.unIRSR0.stcField.u1NMI_EXTINT)  /*@bf@*/
#define MCG_IRSR0_IRQ_HWDG	(MCG.unIRSR0.stcField.u1IRQ_HWDG)  /*@bf@*/
#define MCG_IRSR0_IRQ_SCU	(MCG.unIRSR0.stcField.u1IRQ_SCU)  /*@bf@*/
#define MCG_IRSR0_IRQ_RTC	(MCG.unIRSR0.stcField.u1IRQ_RTC)  /*@bf@*/
#define MCG_IRSR0_IRQ_SCT_CR	(MCG.unIRSR0.stcField.u1IRQ_SCT_CR)  /*@bf@*/
#define MCG_IRSR0_IRQ_SCT_SCR	(MCG.unIRSR0.stcField.u1IRQ_SCT_SCR)  /*@bf@*/
#define MCG_IRSR0_IRQ_SCT_MAIN	(MCG.unIRSR0.stcField.u1IRQ_SCT_MAIN)  /*@bf@*/
#define MCG_IRSR0_IRQ_SCT_SUB	(MCG.unIRSR0.stcField.u1IRQ_SCT_SUB)  /*@bf@*/
#define MCG_IRSR0_IRQ_PW	(MCG.unIRSR0.stcField.u1IRQ_PW)  /*@bf@*/

typedef struct stc_mcg_irsr0_field{
    uint_io32_t		u1NMI_LVD:1;
    uint_io32_t		u1NMI_SCU:1;
    uint_io32_t		u1NMI_HWDG:1;
    uint_io32_t		u1NMI_EXTINT:1;
    uint_io32_t		:4;
    uint_io32_t		u1IRQ_HWDG:1;
    uint_io32_t		u1IRQ_SCU:1;
    uint_io32_t		u1IRQ_RTC:1;
    uint_io32_t		:5;
    uint_io32_t		u1IRQ_SCT_CR:1;
    uint_io32_t		u1IRQ_SCT_SCR:1;
    uint_io32_t		u1IRQ_SCT_MAIN:1;
    uint_io32_t		u1IRQ_SCT_SUB:1;
    uint_io32_t		:4;
    uint_io32_t		u1IRQ_PW:1;
    uint_io32_t		:7;
}stc_mcg_irsr0_field_t;

typedef union un_mcg_irsr0{
    uint_io32_t		u32Register;
    stc_mcg_irsr0_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_mcg_irsr0_t;

/* IRSR1 */
#define MCG_IRSR1	(MCG.unIRSR1.u32Register)  /*@rg@*/
#define MCG_IRSR1_IRQ_EXTINT	MCG_IRSR1  /*@bfrg@*/

typedef union un_mcg_irsr1{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_mcg_irsr1_t;

/* IRSR2 */
#define MCG_IRSR2	(MCG.unIRSR2.u32Register)  /*@rg@*/
#define MCG_IRSR2_NMI_RAMDE	(MCG.unIRSR2.stcField.u1NMI_RAMDE)  /*@bf@*/
#define MCG_IRSR2_IRQ_RAMSE	(MCG.unIRSR2.stcField.u1IRQ_RAMSE)  /*@bf@*/
#define MCG_IRSR2_IRQ_RAMTC	(MCG.unIRSR2.stcField.u1IRQ_RAMTC)  /*@bf@*/
#define MCG_IRSR2_IRQ_RAMTE	(MCG.unIRSR2.stcField.u1IRQ_RAMTE)  /*@bf@*/
#define MCG_IRSR2_IRQ_RAMIC	(MCG.unIRSR2.stcField.u1IRQ_RAMIC)  /*@bf@*/
#define MCG_IRSR2_IRQ_EICU	(MCG.unIRSR2.stcField.u1IRQ_EICU)  /*@bf@*/
#define MCG_IRSR2_IRQ_CRCAL	(MCG.unIRSR2.stcField.u1IRQ_CRCAL)  /*@bf@*/
#define MCG_IRSR2_IRQ_RLT0	(MCG.unIRSR2.stcField.u1IRQ_RLT0)  /*@bf@*/
#define MCG_IRSR2_IRQ_RLT1	(MCG.unIRSR2.stcField.u1IRQ_RLT1)  /*@bf@*/
#define MCG_IRSR2_IRQ_RLT2	(MCG.unIRSR2.stcField.u1IRQ_RLT2)  /*@bf@*/

typedef struct stc_mcg_irsr2_field{
    uint_io32_t		u1NMI_RAMDE:1;
    uint_io32_t		u1IRQ_RAMSE:1;
    uint_io32_t		u1IRQ_RAMTC:1;
    uint_io32_t		u1IRQ_RAMTE:1;
    uint_io32_t		u1IRQ_RAMIC:1;
    uint_io32_t		:3;
    uint_io32_t		u1IRQ_EICU:1;
    uint_io32_t		u1IRQ_CRCAL:1;
    uint_io32_t		:6;
    uint_io32_t		u1IRQ_RLT0:1;
    uint_io32_t		u1IRQ_RLT1:1;
    uint_io32_t		u1IRQ_RLT2:1;
    uint_io32_t		:13;
}stc_mcg_irsr2_field_t;

typedef union un_mcg_irsr2{
    uint_io32_t		u32Register;
    stc_mcg_irsr2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_mcg_irsr2_t;

/* IRSR3 */
#define MCG_IRSR3	(MCG.unIRSR3.u32Register)  /*@rg@*/
#define MCG_IRSR3_IRQ_MFS0_TIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS0_TIRQ)  /*@bf@*/
#define MCG_IRSR3_IRQ_MFS1_TIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS1_TIRQ)  /*@bf@*/
#define MCG_IRSR3_IRQ_MFS2_TIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS2_TIRQ)  /*@bf@*/
#define MCG_IRSR3_IRQ_MFS0_RIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS0_RIRQ)  /*@bf@*/
#define MCG_IRSR3_IRQ_MFS1_RIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS1_RIRQ)  /*@bf@*/
#define MCG_IRSR3_IRQ_MFS2_RIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS2_RIRQ)  /*@bf@*/
#define MCG_IRSR3_IRQ_MFS0_SIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS0_SIRQ)  /*@bf@*/
#define MCG_IRSR3_IRQ_MFS1_SIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS1_SIRQ)  /*@bf@*/
#define MCG_IRSR3_IRQ_MFS2_SIRQ	(MCG.unIRSR3.stcField.u1IRQ_MFS2_SIRQ)  /*@bf@*/
#define MCG_IRSR3_NMI_MCAN0_DE	(MCG.unIRSR3.stcField.u1NMI_MCAN0_DE)  /*@bf@*/
#define MCG_IRSR3_NMI_MCAN1_DE	(MCG.unIRSR3.stcField.u1NMI_MCAN1_DE)  /*@bf@*/
#define MCG_IRSR3_NMI_MCAN2_DE	(MCG.unIRSR3.stcField.u1NMI_MCAN2_DE)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN0_SE	(MCG.unIRSR3.stcField.u1IRQ_MCAN0_SE)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN1_SE	(MCG.unIRSR3.stcField.u1IRQ_MCAN1_SE)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN2_SE	(MCG.unIRSR3.stcField.u1IRQ_MCAN2_SE)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN0_INT0	(MCG.unIRSR3.stcField.u1IRQ_MCAN0_INT0)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN1_INT0	(MCG.unIRSR3.stcField.u1IRQ_MCAN1_INT0)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN2_INT0	(MCG.unIRSR3.stcField.u1IRQ_MCAN2_INT0)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN0_INT1	(MCG.unIRSR3.stcField.u1IRQ_MCAN0_INT1)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN1_INT1	(MCG.unIRSR3.stcField.u1IRQ_MCAN1_INT1)  /*@bf@*/
#define MCG_IRSR3_IRQ_MCAN2_INT1	(MCG.unIRSR3.stcField.u1IRQ_MCAN2_INT1)  /*@bf@*/

typedef struct stc_mcg_irsr3_field{
    uint_io32_t		u1IRQ_MFS0_TIRQ:1;
    uint_io32_t		u1IRQ_MFS1_TIRQ:1;
    uint_io32_t		u1IRQ_MFS2_TIRQ:1;
    uint_io32_t		:1;
    uint_io32_t		u1IRQ_MFS0_RIRQ:1;
    uint_io32_t		u1IRQ_MFS1_RIRQ:1;
    uint_io32_t		u1IRQ_MFS2_RIRQ:1;
    uint_io32_t		:1;
    uint_io32_t		u1IRQ_MFS0_SIRQ:1;
    uint_io32_t		u1IRQ_MFS1_SIRQ:1;
    uint_io32_t		u1IRQ_MFS2_SIRQ:1;
    uint_io32_t		:5;
    uint_io32_t		u1NMI_MCAN0_DE:1;
    uint_io32_t		u1NMI_MCAN1_DE:1;
    uint_io32_t		u1NMI_MCAN2_DE:1;
    uint_io32_t		:1;
    uint_io32_t		u1IRQ_MCAN0_SE:1;
    uint_io32_t		u1IRQ_MCAN1_SE:1;
    uint_io32_t		u1IRQ_MCAN2_SE:1;
    uint_io32_t		:1;
    uint_io32_t		u1IRQ_MCAN0_INT0:1;
    uint_io32_t		u1IRQ_MCAN1_INT0:1;
    uint_io32_t		u1IRQ_MCAN2_INT0:1;
    uint_io32_t		:1;
    uint_io32_t		u1IRQ_MCAN0_INT1:1;
    uint_io32_t		u1IRQ_MCAN1_INT1:1;
    uint_io32_t		u1IRQ_MCAN2_INT1:1;
    uint_io32_t		:1;
}stc_mcg_irsr3_field_t;

typedef union un_mcg_irsr3{
    uint_io32_t		u32Register;
    stc_mcg_irsr3_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_mcg_irsr3_t;

/* IRSR4 */
#define MCG_IRSR4	(MCG.unIRSR4.u32Register)  /*@rg@*/
#define MCG_IRSR4_IRQ_MFS0_TEIRQ	(MCG.unIRSR4.stcField.u1IRQ_MFS0_TEIRQ)  /*@bf@*/
#define MCG_IRSR4_IRQ_MFS1_TEIRQ	(MCG.unIRSR4.stcField.u1IRQ_MFS1_TEIRQ)  /*@bf@*/
#define MCG_IRSR4_IRQ_MFS2_TEIRQ	(MCG.unIRSR4.stcField.u1IRQ_MFS2_TEIRQ)  /*@bf@*/
#define MCG_IRSR4_IRQ_MFS0_REIRQ	(MCG.unIRSR4.stcField.u1IRQ_MFS0_REIRQ)  /*@bf@*/
#define MCG_IRSR4_IRQ_MFS1_REIRQ	(MCG.unIRSR4.stcField.u1IRQ_MFS1_REIRQ)  /*@bf@*/
#define MCG_IRSR4_IRQ_MFS2_REIRQ	(MCG.unIRSR4.stcField.u1IRQ_MFS2_REIRQ)  /*@bf@*/

typedef struct stc_mcg_irsr4_field{
    uint_io32_t		u1IRQ_MFS0_TEIRQ:1;
    uint_io32_t		u1IRQ_MFS1_TEIRQ:1;
    uint_io32_t		u1IRQ_MFS2_TEIRQ:1;
    uint_io32_t		:1;
    uint_io32_t		u1IRQ_MFS0_REIRQ:1;
    uint_io32_t		u1IRQ_MFS1_REIRQ:1;
    uint_io32_t		u1IRQ_MFS2_REIRQ:1;
    uint_io32_t		:25;
}stc_mcg_irsr4_field_t;

typedef union un_mcg_irsr4{
    uint_io32_t		u32Register;
    stc_mcg_irsr4_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_mcg_irsr4_t;


typedef struct stc_mcg{
    un_mcg_irsr0_t	unIRSR0;	/* 0x00000000 */
    un_mcg_irsr1_t	unIRSR1;	/* 0x00000004 */
    un_mcg_irsr2_t	unIRSR2;	/* 0x00000008 */
    un_mcg_irsr3_t	unIRSR3;	/* 0x0000000C */
    un_mcg_irsr4_t	unIRSR4;	/* 0x00000010 */
    uint_io8_t	au8Reserved0[1004];	/* 0x00000014 */
}stc_mcg_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_mcg_t	stcMCG;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_MCG_H */
